/*
 * Decompiled with CFR 0.152.
 */
package edu.washington.cs.knowitall.regex;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import edu.washington.cs.knowitall.regex.Expression;
import edu.washington.cs.knowitall.regex.Match;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class FiniteAutomaton {

    public static class Epsilon<E>
    extends AbstractEdge<E> {
        public Epsilon(State<E> dest) {
            super(dest);
        }

        public String toString() {
            return "(epsilon) -> " + this.dest.toString();
        }

        public boolean apply(E entity) {
            return true;
        }
    }

    public static class Edge<E>
    extends AbstractEdge<E> {
        public final Expression<E> expression;

        public Edge(State<E> dest, Expression<E> base) {
            super(dest);
            this.expression = base;
        }

        public String toString() {
            return "(" + this.expression.toString() + ") -> " + this.dest.toString();
        }

        public boolean apply(E entity) {
            if (this.expression == null) {
                return true;
            }
            return this.expression.apply(entity);
        }
    }

    public static abstract class AbstractEdge<E>
    implements Predicate<E> {
        public final State<E> dest;

        public AbstractEdge(State<E> dest) {
            this.dest = dest;
        }
    }

    public static class EndState<E>
    extends TerminusState<E> {
        public EndState(Expression<E> expression) {
            super(expression);
        }
    }

    public static class StartState<E>
    extends TerminusState<E> {
        public StartState(Expression<E> expression) {
            super(expression);
        }

        public int minMatchingLength() {
            return this.expression.minMatchingLength();
        }
    }

    public static class TerminusState<E>
    extends State<E> {
        public final Expression<E> expression;

        public TerminusState(Expression<E> expression) {
            this.expression = expression;
        }

        @Override
        public String toString() {
            return this.getClass().getSimpleName() + "(" + this.expression.toString() + "):" + this.edges.size();
        }
    }

    public static class State<E> {
        public final List<Edge<E>> edges = new ArrayList<Edge<E>>();
        public final List<Epsilon<E>> epsilons = new ArrayList<Epsilon<E>>();

        public void connect(State<E> dest) {
            this.epsilons.add(new Epsilon<E>(dest));
        }

        public void connect(State<E> dest, Expression<E> cost) {
            this.edges.add(new Edge<E>(dest, cost));
        }

        public String toString() {
            return this.getClass().getSimpleName() + ":" + this.edges.size();
        }
    }

    public static class Automaton<E> {
        public final StartState<E> start;
        public final EndState<E> end;

        public Automaton(StartState<E> start, EndState<E> end) {
            this.start = start;
            this.end = end;
        }

        public Automaton(Expression<E> expr) {
            this.start = new StartState<E>(expr);
            this.end = new EndState<E>(expr);
        }

        public boolean apply(List<E> tokens) {
            return this.evaluate(tokens, true) != null;
        }

        public int minMatchingLength() {
            return this.start.minMatchingLength();
        }

        public Match.FinalMatch<E> lookingAt(List<E> tokens) {
            return this.lookingAt(tokens, 0);
        }

        public Match.FinalMatch<E> lookingAt(List<E> tokens, int startIndex) {
            if (tokens.size() - startIndex - this.minMatchingLength() < 0) {
                return null;
            }
            List<E> sublist = tokens.subList(startIndex, tokens.size());
            Step<E> path = this.evaluate(sublist, startIndex == 0);
            if (path == null) {
                return null;
            }
            ArrayList edges = new ArrayList();
            while (path.state != this.start) {
                edges.add(path.path);
                path = path.prev;
            }
            Match.IntermediateMatch match = new Match.IntermediateMatch();
            this.buildMatch(sublist.iterator(), null, new AtomicInteger(startIndex), this.start, Lists.reverse(edges).iterator(), match);
            return new Match.FinalMatch(match);
        }

        private State<E> buildMatch(Iterator<E> tokenIterator, Expression<E> expression, AtomicInteger index, State<E> state, Iterator<AbstractEdge<E>> edgeIterator, Match.IntermediateMatch<E> match) {
            Match.IntermediateMatch newMatch = new Match.IntermediateMatch();
            while (edgeIterator.hasNext() && (!(state instanceof EndState) || ((EndState)state).expression != expression)) {
                AbstractEdge<E> edge = edgeIterator.next();
                if (edge instanceof Edge && !(((Edge)edge).expression instanceof Expression.AssertionExpression)) {
                    E token = tokenIterator.next();
                    newMatch.add(((Edge)edge).expression, token, index.getAndIncrement());
                    state = edge.dest;
                    continue;
                }
                if (state instanceof StartState) {
                    Expression expr = ((StartState)state).expression;
                    state = this.buildMatch(tokenIterator, expr, index, edge.dest, edgeIterator, newMatch);
                    assert (state instanceof EndState && ((EndState)state).expression == expr);
                    continue;
                }
                assert (edge instanceof Epsilon);
                state = edge.dest;
            }
            if (expression != null && (!newMatch.isEmpty() || expression instanceof Expression.MatchingGroup)) {
                Match.Group pair = new Match.Group(expression);
                for (Match.Group p : newMatch.pairs()) {
                    if (!(p.expr instanceof Expression.BaseExpression)) continue;
                    pair.addTokens(p);
                }
                match.add(pair);
            }
            match.addAll(newMatch.pairs());
            return state;
        }

        private void expandEpsilons(List<Step<E>> steps) {
            int size = steps.size();
            for (int i = 0; i < size; ++i) {
                Step<E> step = steps.get(i);
                this.expandEpsilon(step, steps);
            }
        }

        private void expandEpsilon(Step<E> step, List<Step<E>> steps) {
            for (final Epsilon edge : step.state.epsilons) {
                if (Iterables.any(steps, (Predicate)new Predicate<Step<E>>(){

                    public boolean apply(Step<E> step) {
                        return step.state == edge.dest;
                    }
                })) continue;
                Step<E> newstep = new Step<E>(edge.dest, step, edge);
                steps.add(newstep);
                this.expandEpsilon(newstep, steps);
            }
        }

        private void expandAssertions(List<Step<E>> steps, List<Step<E>> newsteps, boolean hasStart, List<E> tokens, int totalTokens) {
            for (Step<E> step : steps) {
                for (Edge edge : step.state.edges) {
                    Expression.AssertionExpression assertion;
                    if (!(edge.expression instanceof Expression.AssertionExpression) || !(assertion = (Expression.AssertionExpression)edge.expression).apply(hasStart, tokens, totalTokens)) continue;
                    newsteps.add(new Step<E>(edge.dest, step, edge));
                }
            }
        }

        private Step<E> evaluate(List<E> tokens, boolean hasStart) {
            ArrayList<Step<Step<E>>> steps = new ArrayList<Step<Step<E>>>();
            steps.add(new Step<E>(this.start));
            return this.evaluate(tokens, steps, hasStart);
        }

        private Step<E> evaluate(List<E> tokens, List<Step<E>> steps, boolean hasStart) {
            int totalTokens;
            int solutionTokensLeft = totalTokens = tokens.size();
            Step solution = null;
            while (!steps.isEmpty()) {
                this.expandEpsilons(steps);
                ArrayList<Step<Step<Step<E>>>> intermediate = new ArrayList<Step<Step<Step<E>>>>(steps);
                ArrayList newsteps = new ArrayList(steps.size() * 2);
                do {
                    for (Step step : intermediate) {
                        if (step.state != this.end || tokens.size() == totalTokens || tokens.size() >= solutionTokensLeft) continue;
                        solution = step;
                        solutionTokensLeft = tokens.size();
                    }
                    newsteps.clear();
                    this.expandAssertions(intermediate, newsteps, hasStart, tokens, totalTokens);
                    this.expandEpsilons(newsteps);
                    intermediate.clear();
                    intermediate.addAll(newsteps);
                    steps.addAll(newsteps);
                } while (newsteps.size() > 0);
                newsteps.clear();
                if (!tokens.isEmpty()) {
                    for (Step step : steps) {
                        for (Edge<E> edge : step.state.edges) {
                            if (!edge.apply(tokens.get(0))) continue;
                            newsteps.add(new Step(edge.dest, step, edge));
                        }
                    }
                    tokens = tokens.subList(1, tokens.size());
                }
                steps = newsteps;
            }
            return solution;
        }

        private static class Step<E> {
            public final State<E> state;
            public final Step<E> prev;
            public final AbstractEdge<E> path;

            public Step(State<E> state) {
                this(state, null, null);
            }

            public Step(State<E> state, Step<E> prev, AbstractEdge<E> path) {
                this.state = state;
                this.prev = prev;
                this.path = path;
            }

            public String toString() {
                return this.state.toString();
            }
        }
    }
}

