/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.codeInsight.intentions.shared;

import com.intellij.application.options.CodeStyle;
import com.intellij.modcommand.ActionContext;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.Presentation;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.idea.base.resources.KotlinBundle;
import org.jetbrains.kotlin.idea.codeinsight.api.applicable.intentions.KotlinApplicableModCommandAction;
import org.jetbrains.kotlin.idea.codeinsight.utils.KotlinPsiUtilsKt;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtContainerNode;
import org.jetbrains.kotlin.psi.KtDoWhileExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtLoopExpression;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtStatementExpression;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001aB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\r\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u0002H\u0014J-\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014H\u0016\u00a2\u0006\u0002\u0010\u0015J\u0018\u0010\u0016\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u000eH\u0014J\u000e\u0010\u0018\u001a\u0004\u0018\u00010\u0019*\u00020\u0002H\u0002\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/intentions/shared/RemoveBracesIntention;", "Lorg/jetbrains/kotlin/idea/codeinsight/api/applicable/intentions/KotlinApplicableModCommandAction$Simple;", "Lorg/jetbrains/kotlin/psi/KtElement;", "<init>", "()V", "getFamilyName", "", "Lcom/intellij/codeInspection/util/IntentionFamilyName;", "isApplicableByPsi", "", "element", "getPresentation", "Lcom/intellij/modcommand/Presentation;", "context", "Lcom/intellij/modcommand/ActionContext;", "invoke", "", "actionContext", "elementContext", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "(Lcom/intellij/modcommand/ActionContext;Lorg/jetbrains/kotlin/psi/KtElement;Lkotlin/Unit;Lcom/intellij/modcommand/ModPsiUpdater;)V", "stopSearchAt", "Lcom/intellij/psi/PsiElement;", "findChildBlock", "Lorg/jetbrains/kotlin/psi/KtBlockExpression;", "Holder", "kotlin.code-insight.intentions.shared"})
public final class RemoveBracesIntention
extends KotlinApplicableModCommandAction.Simple<KtElement> {
    public RemoveBracesIntention() {
        super(Reflection.getOrCreateKotlinClass(KtElement.class));
    }

    @NotNull
    public String getFamilyName() {
        return KotlinBundle.message((String)"remove.braces", (Object[])new Object[0]);
    }

    @Override
    public boolean isApplicableByPsi(@NotNull KtElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        KtBlockExpression ktBlockExpression = this.findChildBlock(element);
        if (ktBlockExpression == null) {
            return false;
        }
        KtBlockExpression block = ktBlockExpression;
        if (!Holder.INSTANCE.isApplicableTo(block)) {
            return false;
        }
        PsiElement psiElement = block.getParent();
        return psiElement instanceof KtContainerNode || psiElement instanceof KtWhenEntry;
    }

    @Nullable
    protected Presentation getPresentation(@NotNull ActionContext context2, @NotNull KtElement element) {
        Presentation presentation;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        KtBlockExpression ktBlockExpression = this.findChildBlock(element);
        if (ktBlockExpression == null) {
            return null;
        }
        KtBlockExpression block = ktBlockExpression;
        if (!Holder.INSTANCE.isApplicableTo(block)) {
            return null;
        }
        PsiElement container = block.getParent();
        if (container instanceof KtContainerNode) {
            String string = KotlinPsiUtilsKt.getControlFlowElementDescription((KtContainerNode)container);
            if (string == null) {
                return null;
            }
            String description = string;
            Object[] objectArray = new Object[]{description};
            presentation = Presentation.of((String)KotlinBundle.message((String)"remove.braces.from.0.statement", (Object[])objectArray));
        } else {
            presentation = container instanceof KtWhenEntry ? Presentation.of((String)KotlinBundle.message((String)"remove.braces.from.when.entry", (Object[])new Object[0])) : null;
        }
        return presentation;
    }

    @Override
    public void invoke(@NotNull ActionContext actionContext, @NotNull KtElement element, @NotNull Unit elementContext, @NotNull ModPsiUpdater updater2) {
        Intrinsics.checkNotNullParameter((Object)actionContext, (String)"actionContext");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)elementContext, (String)"elementContext");
        Intrinsics.checkNotNullParameter((Object)updater2, (String)"updater");
        KtBlockExpression ktBlockExpression = this.findChildBlock(element);
        if (ktBlockExpression == null) {
            return;
        }
        KtBlockExpression block = ktBlockExpression;
        Holder.INSTANCE.removeBraces(actionContext, element, block, updater2);
    }

    @Override
    protected boolean stopSearchAt(@NotNull PsiElement element, @NotNull ActionContext context2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        return element instanceof KtBlockExpression && !(((KtBlockExpression)element).getParent() instanceof KtWhenEntry);
    }

    private final KtBlockExpression findChildBlock(KtElement $this$findChildBlock) {
        KtExpression ktExpression;
        KtExpression ktExpression2;
        KtElement ktElement = $this$findChildBlock;
        Object object = ktElement instanceof KtBlockExpression ? (KtBlockExpression)$this$findChildBlock : (ktElement instanceof KtLoopExpression ? ((ktExpression2 = ((KtLoopExpression)$this$findChildBlock).getBody()) instanceof KtBlockExpression ? (KtBlockExpression)ktExpression2 : null) : (ktElement instanceof KtWhenEntry ? ((ktExpression = ((KtWhenEntry)$this$findChildBlock).getExpression()) instanceof KtBlockExpression ? (KtBlockExpression)ktExpression : null) : null));
        return object;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J&\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fJ\u0014\u0010\u0010\u001a\u00020\t*\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013*\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0005H\u0002\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/codeInsight/intentions/shared/RemoveBracesIntention$Holder;", "", "<init>", "()V", "isApplicableTo", "", "block", "Lorg/jetbrains/kotlin/psi/KtBlockExpression;", "removeBraces", "", "actionContext", "Lcom/intellij/modcommand/ActionContext;", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "handleComments", "Lorg/jetbrains/kotlin/psi/KtExpression;", "comments", "", "Lcom/intellij/psi/PsiElement;", "forward", "kotlin.code-insight.intentions.shared"})
    @SourceDebugExtension(value={"SMAP\nRemoveBracesIntention.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoveBracesIntention.kt\norg/jetbrains/kotlin/idea/codeInsight/intentions/shared/RemoveBracesIntention$Holder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,147:1\n1761#2,3:148\n*S KotlinDebug\n*F\n+ 1 RemoveBracesIntention.kt\norg/jetbrains/kotlin/idea/codeInsight/intentions/shared/RemoveBracesIntention$Holder\n*L\n142#1:148,3\n*E\n"})
    public static final class Holder {
        @NotNull
        public static final Holder INSTANCE = new Holder();

        private Holder() {
        }

        public final boolean isApplicableTo(@NotNull KtBlockExpression block) {
            Intrinsics.checkNotNullParameter((Object)block, (String)"block");
            List list2 = block.getStatements();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getStatements(...)");
            KtExpression ktExpression = (KtExpression)CollectionsKt.singleOrNull((List)list2);
            if (ktExpression == null) {
                return false;
            }
            KtExpression singleStatement = ktExpression;
            if (singleStatement instanceof KtLambdaExpression && ((KtLambdaExpression)singleStatement).getFunctionLiteral().getArrow() == null) {
                return false;
            }
            PsiElement container = block.getParent();
            if (container instanceof KtContainerNode) {
                if (singleStatement instanceof KtProperty || singleStatement instanceof KtClass) {
                    return false;
                }
                if (singleStatement instanceof KtIfExpression) {
                    KtExpression elseExpression;
                    PsiElement psiElement = ((KtContainerNode)container).getParent();
                    KtIfExpression ktIfExpression = psiElement instanceof KtIfExpression ? (KtIfExpression)psiElement : null;
                    Object object = elseExpression = ktIfExpression != null ? ktIfExpression.getElse() : null;
                    if (elseExpression != null && !Intrinsics.areEqual((Object)elseExpression, (Object)block)) {
                        return false;
                    }
                }
                return true;
            }
            if (container instanceof KtWhenEntry) {
                return !(singleStatement instanceof KtNamedDeclaration);
            }
            return false;
        }

        public final void removeBraces(@NotNull ActionContext actionContext, @NotNull KtElement element, @NotNull KtBlockExpression block, @NotNull ModPsiUpdater updater2) {
            block6: {
                int n;
                Intrinsics.checkNotNullParameter((Object)actionContext, (String)"actionContext");
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                Intrinsics.checkNotNullParameter((Object)block, (String)"block");
                Intrinsics.checkNotNullParameter((Object)updater2, (String)"updater");
                Project project = element.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                Project project2 = project;
                KtPsiFactory factory2 = new KtPsiFactory(project2, false, 2, null);
                List list2 = block.getStatements();
                Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getStatements(...)");
                KtExpression statement = (KtExpression)CollectionsKt.single((List)list2);
                int n2 = updater2.getCaretOffset();
                Intrinsics.checkNotNull((Object)statement);
                boolean caretOnAfterStatement = n2 >= PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)statement));
                PsiElement container = block.getParent();
                PsiElement psiElement = container.getParent();
                Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
                KtExpression construct = (KtExpression)psiElement;
                this.handleComments(statement, block);
                PsiElement newElement2 = block.replace(statement.copy());
                if (caretOnAfterStatement) {
                    Intrinsics.checkNotNull((Object)newElement2);
                    n = PsiUtilsKt.getEndOffset((PsiElement)newElement2);
                } else {
                    Intrinsics.checkNotNull((Object)newElement2);
                    n = PsiUtilsKt.getStartOffset((PsiElement)newElement2);
                }
                updater2.moveCaretTo(n);
                if (construct instanceof KtDoWhileExpression) {
                    PsiElement psiElement2 = newElement2.getParent();
                    Intrinsics.checkNotNull((Object)psiElement2);
                    psiElement2.addAfter(factory2.createNewLine(), newElement2);
                } else {
                    Document document = actionContext.file().getFileDocument();
                    Intrinsics.checkNotNullExpressionValue((Object)document, (String)"getFileDocument(...)");
                    Document document2 = document;
                    int rightMargin = CodeStyle.getSettings((Project)project2).getRightMargin(element.getLanguage());
                    int line = document2.getLineNumber(PsiUtilsKt.getStartOffset((PsiElement)newElement2));
                    int lineStartOffset = document2.getLineStartOffset(line);
                    int lineEndOffset = document2.getLineEndOffset(line) + newElement2.getTextLength();
                    if (lineEndOffset - lineStartOffset >= rightMargin) {
                        newElement2.getParent().addBefore(factory2.createNewLine(), newElement2);
                    }
                }
                if (!(construct instanceof KtIfExpression) || !Intrinsics.areEqual((Object)container.getNode().getElementType(), (Object)KtNodeTypes.ELSE) || !(((KtIfExpression)construct).getParent() instanceof KtExpression) || ((KtIfExpression)construct).getParent() instanceof KtStatementExpression) break block6;
                Object[] objectArray = new Object[]{construct};
                PsiElement replaced = ((KtIfExpression)construct).replace((PsiElement)CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)factory2, (String)"($0)", (Object[])objectArray, (boolean)false, (int)4, null));
                PsiElement psiElement3 = replaced.getChildren()[0];
                KtIfExpression ktIfExpression = psiElement3 instanceof KtIfExpression ? (KtIfExpression)psiElement3 : null;
                if (ktIfExpression != null && (ktIfExpression = ktIfExpression.getElse()) != null) {
                    KtIfExpression it = ktIfExpression;
                    boolean bl = false;
                    updater2.moveCaretTo(caretOnAfterStatement ? PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)it)) : PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)it)));
                }
            }
        }

        private final void handleComments(KtExpression $this$handleComments, KtBlockExpression block) {
            List<PsiElement> nextComments2 = this.comments($this$handleComments, true);
            List prevComments2 = CollectionsKt.reversed((Iterable)this.comments($this$handleComments, false));
            PsiElement blockParent = block.getParent();
            if (!((Collection)prevComments2).isEmpty()) {
                blockParent.addRangeBefore((PsiElement)CollectionsKt.first((List)prevComments2), (PsiElement)CollectionsKt.last((List)prevComments2), (PsiElement)block);
            }
            if (!((Collection)nextComments2).isEmpty()) {
                blockParent.addRangeAfter((PsiElement)CollectionsKt.first(nextComments2), (PsiElement)CollectionsKt.last(nextComments2), (PsiElement)block);
            }
        }

        private final List<PsiElement> comments(KtExpression $this$comments, boolean forward) {
            boolean bl;
            List elements;
            block3: {
                elements = SequencesKt.toList((Sequence)SequencesKt.takeWhile((Sequence)PsiUtilsKt.siblings((PsiElement)((PsiElement)$this$comments), (boolean)forward, (boolean)false), Holder::comments$lambda$0));
                Iterable $this$any$iv = elements;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        PsiElement it = (PsiElement)element$iv;
                        boolean bl2 = false;
                        if (!(it instanceof PsiComment)) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl ? elements : CollectionsKt.emptyList();
        }

        private static final boolean comments$lambda$0(PsiElement it) {
            Intrinsics.checkNotNullParameter((Object)it, (String)"it");
            return it instanceof PsiComment || it instanceof PsiWhiteSpace;
        }
    }
}

