/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.core;

import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.engine.JavaStackFrame;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.debugger.ui.AlternativeSourceNotificationPanel;
import com.intellij.debugger.ui.AlternativeSourceNotificationProvider;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.ui.EditorNotificationProvider;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XStackFrame;
import com.sun.jdi.Location;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.core.KotlinAlternativeSourceNotificationProviderKt;
import org.jetbrains.kotlin.idea.debugger.core.KotlinDebuggerCoreBundle;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0004\u001a\u0016\u0012\u0006\b\u0000\u0012\u00020\u0006\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u0007\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/core/KotlinAlternativeSourceNotificationProvider;", "Lcom/intellij/ui/EditorNotificationProvider;", "<init>", "()V", "collectNotificationData", "Ljava/util/function/Function;", "Lcom/intellij/openapi/fileEditor/FileEditor;", "Ljavax/swing/JComponent;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.kotlin.jvm.debugger.core"})
@SourceDebugExtension(value={"SMAP\nKotlinAlternativeSourceNotificationProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KotlinAlternativeSourceNotificationProvider.kt\norg/jetbrains/kotlin/idea/debugger/core/KotlinAlternativeSourceNotificationProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,105:1\n774#2:106\n865#2,2:107\n1563#2:109\n1634#2,3:110\n37#3,2:113\n*S KotlinDebug\n*F\n+ 1 KotlinAlternativeSourceNotificationProvider.kt\norg/jetbrains/kotlin/idea/debugger/core/KotlinAlternativeSourceNotificationProvider\n*L\n61#1:106\n61#1:107,2\n62#1:109\n62#1:110,3\n75#1:113,2\n*E\n"})
public final class KotlinAlternativeSourceNotificationProvider
implements EditorNotificationProvider {
    /*
     * WARNING - void declaration
     */
    @Nullable
    public Function<? super FileEditor, ? extends JComponent> collectNotificationData(@NotNull Project project, @NotNull VirtualFile file) {
        Location location;
        Comparable<Location> comparable;
        void $this$mapTo$iv$iv;
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        XSourcePosition position;
        XDebugSession session2;
        DebuggerSession javaSession;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!DebuggerSettings.getInstance().SHOW_ALTERNATIVE_SOURCE) {
            return null;
        }
        DebuggerSession debuggerSession = javaSession = DebuggerManagerEx.getInstanceEx((Project)project).getContext().getDebuggerSession();
        Object object = session2 = debuggerSession != null ? debuggerSession.getXDebugSession() : null;
        if (session2 == null) {
            AlternativeSourceNotificationProvider.setFileProcessed((VirtualFile)file, (boolean)false);
            return null;
        }
        XSourcePosition xSourcePosition = position = session2.getCurrentPosition();
        if (!Intrinsics.areEqual((Object)file, (Object)(xSourcePosition != null ? xSourcePosition.getFile() : null))) {
            AlternativeSourceNotificationProvider.setFileProcessed((VirtualFile)file, (boolean)false);
            return null;
        }
        if (DumbService.Companion.getInstance(project).isDumb()) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        KtFile ktFile2 = psiFile instanceof KtFile ? (KtFile)psiFile : null;
        if (ktFile2 == null) {
            return null;
        }
        KtFile ktFile3 = ktFile2;
        Set alternativeKtFiles = KotlinAlternativeSourceNotificationProviderKt.access$findAlternativeKtFiles(ktFile3, project, javaSession);
        AlternativeSourceNotificationProvider.setFileProcessed((VirtualFile)file, (boolean)true);
        if (alternativeKtFiles.size() <= 1) {
            return null;
        }
        Iterable iterable = alternativeKtFiles;
        Collection collection = CollectionsKt.listOf((Object)ktFile3);
        boolean $i$f$filter = false;
        void var11_13 = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            KtFile it = (KtFile)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual((Object)it, (Object)ktFile3))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List alternatives = CollectionsKt.plus((Collection)collection, (Iterable)((List)destination$iv$iv));
        Iterable $this$map$iv = alternatives;
        boolean $i$f$map = false;
        destination$iv$iv = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KtFile bl = (KtFile)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl2 = false;
            collection.add(new AlternativeSourceNotificationPanel.AlternativeSourceElement((PsiElement)it));
        }
        List items = (List)destination$iv$iv2;
        XStackFrame frame = session2.getCurrentStackFrame();
        String locationDeclName = frame instanceof JavaStackFrame ? ((comparable = (location = ((JavaStackFrame)frame).getDescriptor().getLocation())) != null && (comparable = comparable.declaringType()) != null ? comparable.name() : null) : null;
        return arg_0 -> KotlinAlternativeSourceNotificationProvider.collectNotificationData$lambda$2(project, file, items, locationDeclName, arg_0);
    }

    private static final AlternativeSourceNotificationPanel collectNotificationData$lambda$2(Project $project, VirtualFile $file, List $items, String $locationDeclName, FileEditor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Object[] objectArray = new Object[1];
        Intrinsics.checkNotNullExpressionValue((Object)$file.getName(), (String)"getName(...)");
        Collection $this$toTypedArray$iv = $items;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return new AlternativeSourceNotificationPanel(it, $project, KotlinDebuggerCoreBundle.message("alternative.sources.notification.title", objectArray), $file, thisCollection$iv.toArray(new AlternativeSourceNotificationPanel.AlternativeSourceElement[0]), $locationDeclName);
    }
}

