/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.tracing;

import io.opentelemetry.api.OpenTelemetry;
import jakarta.enterprise.inject.spi.CDI;
import java.lang.annotation.Annotation;
import org.keycloak.Config;
import org.keycloak.common.Profile;
import org.keycloak.config.Option;
import org.keycloak.config.TracingOptions;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.quarkus.runtime.configuration.Configuration;
import org.keycloak.quarkus.runtime.tracing.OTelTracingProvider;
import org.keycloak.tracing.TracingProvider;
import org.keycloak.tracing.TracingProviderFactory;

public class OTelTracingProviderFactory
implements TracingProviderFactory {
    public static final String PROVIDER_ID = "opentelemetry";
    private static OpenTelemetry OTEL_SINGLETON;

    public TracingProvider create(KeycloakSession session) {
        if (OTEL_SINGLETON == null) {
            OTEL_SINGLETON = (OpenTelemetry)CDI.current().select(OpenTelemetry.class, new Annotation[0]).get();
        }
        return new OTelTracingProvider(OTEL_SINGLETON);
    }

    public void init(Config.Scope config) {
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
        if (OTEL_SINGLETON != null) {
            CDI.current().select(OpenTelemetry.class, new Annotation[0]).destroy((Object)OTEL_SINGLETON);
            OTEL_SINGLETON = null;
        }
    }

    public int order() {
        return 10;
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public boolean isSupported(Config.Scope config) {
        return Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.OPENTELEMETRY) && Configuration.isTrue((Option<Boolean>)TracingOptions.TRACING_ENABLED);
    }
}

