/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.spi;

import java.util.Collection;
import java.util.Map;
import org.hibernate.CustomEntityDirtinessStrategy;
import org.hibernate.Incubating;
import org.hibernate.Internal;
import org.hibernate.SessionFactory;
import org.hibernate.SessionFactoryObserver;
import org.hibernate.boot.model.relational.SqlStringGenerationContext;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.spi.SessionFactoryOptions;
import org.hibernate.cache.spi.CacheImplementor;
import org.hibernate.context.spi.CurrentTenantIdentifierResolver;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.profile.FetchProfile;
import org.hibernate.engine.spi.FilterDefinition;
import org.hibernate.engine.spi.SessionBuilderImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.event.service.spi.EventListenerGroups;
import org.hibernate.event.service.spi.EventListenerRegistry;
import org.hibernate.event.spi.EntityCopyObserverFactory;
import org.hibernate.event.spi.EventEngine;
import org.hibernate.generator.Generator;
import org.hibernate.graph.RootGraph;
import org.hibernate.graph.spi.RootGraphImplementor;
import org.hibernate.metamodel.model.domain.JpaMetamodel;
import org.hibernate.metamodel.spi.MappingMetamodelImplementor;
import org.hibernate.metamodel.spi.RuntimeMetamodelsImplementor;
import org.hibernate.proxy.EntityNotFoundDelegate;
import org.hibernate.query.spi.QueryEngine;
import org.hibernate.query.sql.spi.SqlTranslationEngine;
import org.hibernate.resource.beans.spi.ManagedBeanRegistry;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.sql.ast.spi.ParameterMarkerStrategy;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesMappingProducerProvider;
import org.hibernate.stat.spi.StatisticsImplementor;
import org.hibernate.type.descriptor.WrapperOptions;
import org.hibernate.type.descriptor.java.JavaType;
import org.hibernate.type.spi.TypeConfiguration;

public interface SessionFactoryImplementor
extends SessionFactory {
    public String getUuid();

    @Override
    public SessionImplementor openSession();

    @Override
    public SessionBuilderImplementor withOptions();

    public SessionImplementor openTemporarySession();

    @Override
    public CacheImplementor getCache();

    @Override
    public StatisticsImplementor getStatistics();

    public TypeConfiguration getTypeConfiguration();

    public RuntimeMetamodelsImplementor getRuntimeMetamodels();

    default public MappingMetamodelImplementor getMappingMetamodel() {
        return this.getRuntimeMetamodels().getMappingMetamodel();
    }

    default public JpaMetamodel getJpaMetamodel() {
        return this.getRuntimeMetamodels().getJpaMetamodel();
    }

    public QueryEngine getQueryEngine();

    public SqlTranslationEngine getSqlTranslationEngine();

    public ServiceRegistryImplementor getServiceRegistry();

    public EventEngine getEventEngine();

    @Deprecated(since="7.0", forRemoval=true)
    public FetchProfile getFetchProfile(String var1);

    @Deprecated(since="7", forRemoval=true)
    public Generator getGenerator(String var1);

    public EntityNotFoundDelegate getEntityNotFoundDelegate();

    public void addObserver(SessionFactoryObserver var1);

    public CustomEntityDirtinessStrategy getCustomEntityDirtinessStrategy();

    public CurrentTenantIdentifierResolver<Object> getCurrentTenantIdentifierResolver();

    public JavaType<Object> getTenantIdentifierJavaType();

    @Internal
    @Incubating
    public EventListenerGroups getEventListenerGroups();

    @Incubating
    public ParameterMarkerStrategy getParameterMarkerStrategy();

    @Incubating
    public JdbcValuesMappingProducerProvider getJdbcValuesMappingProducerProvider();

    @Incubating
    public EntityCopyObserverFactory getEntityCopyObserver();

    @Incubating
    public ClassLoaderService getClassLoaderService();

    @Incubating
    public ManagedBeanRegistry getManagedBeanRegistry();

    @Incubating
    public EventListenerRegistry getEventListenerRegistry();

    public WrapperOptions getWrapperOptions();

    @Override
    public SessionFactoryOptions getSessionFactoryOptions();

    @Override
    public FilterDefinition getFilterDefinition(String var1);

    public Collection<FilterDefinition> getAutoEnabledFilters();

    public JdbcServices getJdbcServices();

    public SqlStringGenerationContext getSqlStringGenerationContext();

    public RootGraphImplementor<?> findEntityGraphByName(String var1);

    default public <T> RootGraphImplementor<T> createEntityGraph(Class<T> entityType) {
        return (RootGraphImplementor)SessionFactory.super.createEntityGraph(entityType);
    }

    @Override
    public RootGraph<Map<String, ?>> createGraphForDynamicEntity(String var1);

    public String bestGuessEntityName(Object var1);
}

