/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.micrometer.v1_5;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.config.NamingConvention;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.micrometer.v1_5.DistributionStatisticConfigModifier;
import io.opentelemetry.instrumentation.micrometer.v1_5.OpenTelemetryMeterRegistry;
import io.opentelemetry.instrumentation.micrometer.v1_5.PrometheusModeNamingConvention;
import java.util.concurrent.TimeUnit;

public final class OpenTelemetryMeterRegistryBuilder {
    private static final String INSTRUMENTATION_NAME = "io.opentelemetry.micrometer-1.5";
    private final OpenTelemetry openTelemetry;
    private Clock clock = Clock.SYSTEM;
    private TimeUnit baseTimeUnit = TimeUnit.SECONDS;
    private boolean prometheusMode = false;
    private boolean histogramGaugesEnabled = false;

    OpenTelemetryMeterRegistryBuilder(OpenTelemetry openTelemetry) {
        this.openTelemetry = openTelemetry;
    }

    @CanIgnoreReturnValue
    public OpenTelemetryMeterRegistryBuilder setClock(Clock clock) {
        this.clock = clock;
        return this;
    }

    @CanIgnoreReturnValue
    public OpenTelemetryMeterRegistryBuilder setBaseTimeUnit(TimeUnit baseTimeUnit) {
        this.baseTimeUnit = baseTimeUnit;
        return this;
    }

    @CanIgnoreReturnValue
    public OpenTelemetryMeterRegistryBuilder setPrometheusMode(boolean prometheusMode) {
        this.prometheusMode = prometheusMode;
        return this;
    }

    @CanIgnoreReturnValue
    public OpenTelemetryMeterRegistryBuilder setMicrometerHistogramGaugesEnabled(boolean histogramGaugesEnabled) {
        this.histogramGaugesEnabled = histogramGaugesEnabled;
        return this;
    }

    public MeterRegistry build() {
        TimeUnit baseTimeUnit = this.prometheusMode ? TimeUnit.SECONDS : this.baseTimeUnit;
        PrometheusModeNamingConvention namingConvention = this.prometheusMode ? PrometheusModeNamingConvention.INSTANCE : NamingConvention.identity;
        DistributionStatisticConfigModifier modifier = this.histogramGaugesEnabled ? DistributionStatisticConfigModifier.IDENTITY : DistributionStatisticConfigModifier.DISABLE_HISTOGRAM_GAUGES;
        return new OpenTelemetryMeterRegistry(this.clock, baseTimeUnit, namingConvention, modifier, this.openTelemetry.getMeterProvider().get(INSTRUMENTATION_NAME));
    }
}

