/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2.impl;

import io.github.dmlloyd.classfile.Annotation;
import io.github.dmlloyd.classfile.AnnotationElement;
import io.github.dmlloyd.classfile.AnnotationValue;
import io.github.dmlloyd.classfile.Signature;
import io.github.dmlloyd.classfile.TypeAnnotation;
import io.quarkus.gizmo2.GenericType;
import io.quarkus.gizmo2.TypeArgument;
import io.quarkus.gizmo2.TypeKind;
import io.quarkus.gizmo2.TypeParameter;
import io.quarkus.gizmo2.desc.MethodDesc;
import io.smallrye.common.constraint.Assert;
import java.io.Serializable;
import java.lang.annotation.RetentionPolicy;
import java.lang.constant.ClassDesc;
import java.lang.constant.ConstantDescs;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import sun.reflect.ReflectionFactory;

public final class Util {
    public static final ClassDesc[] NO_DESCS = new ClassDesc[0];
    public static final boolean debug = !"false".equals(System.getProperty("gizmo.debug", "false"));
    public static final String trackingMessage = "\nTo track callers and get an improved exception message, add the system property `gizmo.debug`";
    private static final ClassValue<ClassDesc> constantCache = new ClassValue<ClassDesc>(){

        @Override
        protected ClassDesc computeValue(Class<?> type) {
            return type.describeConstable().orElseThrow(IllegalArgumentException::new);
        }
    };
    private static final MethodHandle actualKind;
    private static final MethodHandle GenericType_computeAnnotations;
    private static final MethodHandle TypeParameter_computeAnnotations;
    private static final ClassValue<MethodHandle> writeReplaces;
    private static final StackWalker SW;
    private static final Map<ClassDesc, Signature.BaseTypeSig> baseTypeSigs;

    private Util() {
    }

    public static StringBuilder descName(StringBuilder b, ClassDesc desc) {
        if (desc.packageName().isEmpty()) {
            return b.append(desc.displayName());
        }
        return b.append(desc.packageName()).append('.').append(desc.displayName());
    }

    public static ClassDesc classDesc(Class<?> clazz) {
        return constantCache.get(clazz);
    }

    public static io.github.dmlloyd.classfile.TypeKind actualKindOf(TypeKind kind) {
        try {
            return actualKind.invokeExact(kind);
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new UndeclaredThrowableException(t);
        }
    }

    public static SerializedLambda serializedLambda(Serializable lambda) {
        MethodHandle handle = writeReplaces.get(lambda.getClass());
        if (handle == null) {
            throw new IllegalArgumentException("Cannot interpret method handle");
        }
        try {
            return handle.invokeExact(lambda);
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    public static String detailedStackTrace() {
        StringBuilder b = new StringBuilder(1000);
        SW.walk(stream -> {
            stream.forEachOrdered(fr -> b.append("at ").append(fr.toStackTraceElement()).append(" bci=").append(fr.getByteCodeIndex()).append('\n'));
            return null;
        });
        return b.toString();
    }

    public static String trackCaller() {
        return debug ? Util.callerOutsideGizmo() : null;
    }

    private static String callerOutsideGizmo() {
        return SW.walk(stream -> stream.filter(it -> !it.getClassName().startsWith("io.quarkus.gizmo2") || it.getClassName().endsWith("Test")).findFirst().map(it -> it.getClassName() + "." + it.getMethodName() + "(" + it.getFileName() + ":" + it.getLineNumber() + ")").orElseThrow(IllegalStateException::new));
    }

    public static <T> List<T> listWith(List<T> original, T addend) {
        assert (!(original instanceof ArrayList));
        original = List.copyOf(original);
        return switch (original.size()) {
            case 0 -> List.of(addend);
            case 1 -> List.of(original.get(0), addend);
            case 2 -> List.of(original.get(0), original.get(1), addend);
            default -> {
                ArrayList<T> a = new ArrayList<T>();
                a.addAll(original);
                a.add(addend);
                yield a;
            }
        };
    }

    public static <T, R> List<R> reinterpretCast(List<T> list) {
        return list;
    }

    public static <K, V> Map<V, K> reverseMap(Map<K, V> original) {
        return original.entrySet().stream().collect(Collectors.toUnmodifiableMap(Map.Entry::getValue, Map.Entry::getKey));
    }

    public static ClassDesc erased(Signature sig) {
        if (sig instanceof Signature.ClassTypeSig) {
            Signature.ClassTypeSig cts = (Signature.ClassTypeSig)sig;
            return cts.classDesc();
        }
        if (sig instanceof Signature.ArrayTypeSig) {
            Signature.ArrayTypeSig ats = (Signature.ArrayTypeSig)sig;
            return Util.erased(ats.componentSignature()).arrayType();
        }
        if (sig instanceof Signature.BaseTypeSig) {
            Signature.BaseTypeSig bts = (Signature.BaseTypeSig)sig;
            return switch (bts.baseType()) {
                case 'B' -> ConstantDescs.CD_byte;
                case 'C' -> ConstantDescs.CD_char;
                case 'D' -> ConstantDescs.CD_double;
                case 'F' -> ConstantDescs.CD_float;
                case 'I' -> ConstantDescs.CD_int;
                case 'J' -> ConstantDescs.CD_long;
                case 'S' -> ConstantDescs.CD_short;
                case 'V' -> ConstantDescs.CD_void;
                case 'Z' -> ConstantDescs.CD_boolean;
                default -> throw new IllegalArgumentException(bts.toString());
            };
        }
        if (sig instanceof Signature.TypeVarSig) {
            return ConstantDescs.CD_Object;
        }
        throw new IllegalArgumentException(sig.toString());
    }

    public static MethodDesc findSam(Class<?> type) {
        Method sam = null;
        for (Method method : type.getMethods()) {
            int mods = method.getModifiers();
            if (!Modifier.isAbstract(mods) || !Modifier.isPublic(mods) || Modifier.isStatic(mods)) continue;
            if (sam == null) {
                sam = method;
                continue;
            }
            throw new IllegalArgumentException("Found two abstract methods on " + String.valueOf(type) + ": " + sam.getName() + " and " + method.getName());
        }
        if (sam == null) {
            throw new IllegalArgumentException("No abstract method found on " + String.valueOf(type));
        }
        return MethodDesc.of(sam.getDeclaringClass(), sam.getName(), sam.getReturnType(), sam.getParameterTypes());
    }

    public static String internalName(ClassDesc desc) {
        if (desc.isClassOrInterface()) {
            String ds = desc.descriptorString();
            return ds.substring(1, ds.length() - 1);
        }
        return desc.descriptorString();
    }

    public static String binaryName(ClassDesc desc) {
        return Util.internalName(desc).replace('/', '.');
    }

    public static StringBuilder appendAnnotation(StringBuilder b, Annotation annotation) {
        b.append('@');
        b.append(Util.binaryName(annotation.classSymbol()));
        List elements = annotation.elements();
        if (!elements.isEmpty()) {
            b.append('(');
            if (elements.size() == 1 && ((AnnotationElement)elements.get(0)).name().equalsString("value")) {
                Util.appendAnnotationValue(b, ((AnnotationElement)elements.get(0)).value());
            } else {
                Iterator iter = elements.iterator();
                assert (iter.hasNext());
                AnnotationElement entry = (AnnotationElement)iter.next();
                Util.appendAnnotationValue(b.append(entry.name().stringValue()).append('='), entry.value());
                while (iter.hasNext()) {
                    entry = (AnnotationElement)iter.next();
                    Util.appendAnnotationValue(b.append(',').append(entry.name().stringValue()).append('='), entry.value());
                }
            }
            b.append(')');
        }
        return b;
    }

    public static void appendAnnotationValue(StringBuilder b, AnnotationValue value) {
        switch (value.tag()) {
            case 66: {
                b.append(((AnnotationValue.OfByte)value).byteValue());
                break;
            }
            case 67: {
                b.append('\'').append(((AnnotationValue.OfChar)value).charValue()).append('\'');
                break;
            }
            case 83: {
                b.append(((AnnotationValue.OfShort)value).shortValue());
                break;
            }
            case 73: {
                b.append(((AnnotationValue.OfInt)value).intValue());
                break;
            }
            case 74: {
                b.append(((AnnotationValue.OfLong)value).longValue()).append('L');
                break;
            }
            case 70: {
                b.append(((AnnotationValue.OfFloat)value).floatValue()).append('F');
                break;
            }
            case 68: {
                b.append(((AnnotationValue.OfDouble)value).doubleValue());
                break;
            }
            case 90: {
                b.append(((AnnotationValue.OfBoolean)value).booleanValue());
                break;
            }
            case 115: {
                b.append('\"').append(((AnnotationValue.OfString)value).stringValue()).append('\"');
                break;
            }
            case 101: {
                AnnotationValue.OfEnum ofEnum = (AnnotationValue.OfEnum)value;
                b.append(Util.binaryName(ofEnum.classSymbol())).append('.').append(ofEnum.constantName().stringValue());
                break;
            }
            case 91: {
                b.append('{');
                Iterator iterator = ((AnnotationValue.OfArray)value).values().iterator();
                if (iterator.hasNext()) {
                    AnnotationValue nested = (AnnotationValue)iterator.next();
                    Util.appendAnnotationValue(b, nested);
                    while (iterator.hasNext()) {
                        b.append(',');
                        nested = (AnnotationValue)iterator.next();
                        Util.appendAnnotationValue(b, nested);
                    }
                }
                b.append('}');
                break;
            }
            case 99: {
                b.append(Util.binaryName(((AnnotationValue.OfClass)value).classSymbol()));
                break;
            }
            case 64: {
                Util.appendAnnotation(b, ((AnnotationValue.OfAnnotation)value).annotation());
                break;
            }
            default: {
                throw Assert.impossibleSwitchCase((int)value.tag());
            }
        }
    }

    public static Signature signatureOf(GenericType type) {
        if (type instanceof GenericType.OfPrimitive) {
            GenericType.OfPrimitive prim = (GenericType.OfPrimitive)type;
            return Util.signatureOf(prim);
        }
        if (type instanceof GenericType.OfReference) {
            GenericType.OfReference ref = (GenericType.OfReference)type;
            return Util.signatureOf(ref);
        }
        throw Util.invalidType(type);
    }

    public static Signature.BaseTypeSig signatureOf(GenericType.OfPrimitive type) {
        return baseTypeSigs.get(type.desc());
    }

    public static Signature.RefTypeSig signatureOf(GenericType.OfReference type) {
        if (type instanceof GenericType.OfArray) {
            GenericType.OfArray array = (GenericType.OfArray)type;
            return Util.signatureOf(array);
        }
        if (type instanceof GenericType.OfThrows) {
            GenericType.OfThrows ot = (GenericType.OfThrows)type;
            return Util.signatureOf(ot);
        }
        throw Util.invalidType(type);
    }

    public static Signature.ArrayTypeSig signatureOf(GenericType.OfArray type) {
        return Signature.ArrayTypeSig.of((int)1, (Signature)Util.signatureOf(type.componentType()));
    }

    public static Signature.RefTypeSig signatureOf(GenericType.OfThrows type) {
        if (type instanceof GenericType.OfClass) {
            GenericType.OfClass oc = (GenericType.OfClass)type;
            return Util.signatureOf(oc);
        }
        if (type instanceof GenericType.OfTypeVariable) {
            GenericType.OfTypeVariable tv = (GenericType.OfTypeVariable)type;
            return Util.signatureOf(tv);
        }
        throw Util.invalidType(type);
    }

    public static Signature.ClassTypeSig signatureOf(GenericType.OfClass type) {
        if (type instanceof GenericType.OfRootClass) {
            GenericType.OfRootClass oc = (GenericType.OfRootClass)type;
            return Util.signatureOf(oc);
        }
        if (type instanceof GenericType.OfInnerClass) {
            GenericType.OfInnerClass ic = (GenericType.OfInnerClass)type;
            return Util.signatureOf(ic);
        }
        throw Util.invalidType(type);
    }

    public static Signature.ClassTypeSig signatureOf(GenericType.OfRootClass type) {
        return Signature.ClassTypeSig.of((ClassDesc)type.desc(), (Signature.TypeArg[])Util.typeArgsOf(type.typeArguments()));
    }

    public static Signature.ClassTypeSig signatureOf(GenericType.OfInnerClass type) {
        return Signature.ClassTypeSig.of((Signature.ClassTypeSig)Util.signatureOf(type.outerType()), (String)type.name(), (Signature.TypeArg[])Util.typeArgsOf(type.typeArguments()));
    }

    public static Signature.TypeVarSig signatureOf(GenericType.OfTypeVariable type) {
        return Signature.TypeVarSig.of((String)type.name());
    }

    public static Signature.TypeArg[] typeArgsOf(List<TypeArgument> typeArguments) {
        return (Signature.TypeArg[])typeArguments.stream().map(Util::typeArgOf).toArray(Signature.TypeArg[]::new);
    }

    public static Signature.TypeArg typeArgOf(TypeArgument arg) {
        if (arg instanceof TypeArgument.OfExact) {
            TypeArgument.OfExact ex = (TypeArgument.OfExact)arg;
            return Util.typeArgOf(ex);
        }
        if (arg instanceof TypeArgument.OfWildcard) {
            TypeArgument.OfWildcard wld = (TypeArgument.OfWildcard)arg;
            return Util.typeArgOf(wld);
        }
        throw Util.invalidType(arg);
    }

    public static Signature.TypeArg.Bounded typeArgOf(TypeArgument.OfExact arg) {
        return Signature.TypeArg.of((Signature.RefTypeSig)Util.signatureOf(arg.type()));
    }

    public static Signature.TypeArg typeArgOf(TypeArgument.OfWildcard arg) {
        if (arg instanceof TypeArgument.OfExtends) {
            TypeArgument.OfExtends oe = (TypeArgument.OfExtends)arg;
            return Util.typeArgOf(oe);
        }
        if (arg instanceof TypeArgument.OfSuper) {
            TypeArgument.OfSuper os = (TypeArgument.OfSuper)arg;
            return Util.typeArgOf(os);
        }
        if (arg instanceof TypeArgument.OfUnbounded) {
            TypeArgument.OfUnbounded wc = (TypeArgument.OfUnbounded)arg;
            return Util.typeArgOf(wc);
        }
        throw Util.invalidType(arg);
    }

    public static Signature.TypeArg.Bounded typeArgOf(TypeArgument.OfExtends arg) {
        return Signature.TypeArg.extendsOf((Signature.RefTypeSig)Util.signatureOf(arg.bound()));
    }

    public static Signature.TypeArg.Bounded typeArgOf(TypeArgument.OfSuper arg) {
        return Signature.TypeArg.superOf((Signature.RefTypeSig)Util.signatureOf(arg.bound()));
    }

    public static Signature.TypeArg.Unbounded typeArgOf(TypeArgument.OfUnbounded arg) {
        return Signature.TypeArg.unbounded();
    }

    public static Signature.TypeParam typeParamOf(TypeParameter tp) {
        return Signature.TypeParam.of((String)tp.name(), tp.firstBound().map(Util::signatureOf), (Signature.RefTypeSig[])((Signature.RefTypeSig[])tp.otherBounds().stream().map(Util::signatureOf).toArray(Signature.RefTypeSig[]::new)));
    }

    public static List<TypeAnnotation> computeAnnotations(GenericType type, RetentionPolicy retention, TypeAnnotation.TargetInfo targetInfo, ArrayList<TypeAnnotation> list, ArrayDeque<TypeAnnotation.TypePathComponent> path) {
        try {
            List ignored = GenericType_computeAnnotations.invokeExact(type, retention, targetInfo, list, path);
            return list;
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    public static List<TypeAnnotation> computeAnnotations(TypeParameter tp, RetentionPolicy retention, TypeAnnotation.TargetInfo targetInfo, ArrayList<TypeAnnotation> list, ArrayDeque<TypeAnnotation.TypePathComponent> path) {
        try {
            List ignored = TypeParameter_computeAnnotations.invokeExact(tp, retention, targetInfo, list, path);
            return list;
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    private static IllegalArgumentException invalidType(Object type) {
        return new IllegalArgumentException(type.getClass().toString());
    }

    static {
        try {
            actualKind = MethodHandles.privateLookupIn(TypeKind.class, MethodHandles.lookup()).findGetter(TypeKind.class, "actualKind", io.github.dmlloyd.classfile.TypeKind.class);
            MethodHandles.Lookup genericTypeLookup = MethodHandles.privateLookupIn(GenericType.class, MethodHandles.lookup());
            GenericType_computeAnnotations = genericTypeLookup.findVirtual(GenericType.class, "computeAnnotations", MethodType.methodType(List.class, RetentionPolicy.class, TypeAnnotation.TargetInfo.class, ArrayList.class, ArrayDeque.class));
            TypeParameter_computeAnnotations = genericTypeLookup.findVirtual(TypeParameter.class, "computeAnnotations", MethodType.methodType(List.class, RetentionPolicy.class, TypeAnnotation.TargetInfo.class, ArrayList.class, ArrayDeque.class));
        }
        catch (NoSuchFieldException e) {
            throw new NoSuchFieldError(e.getMessage());
        }
        catch (NoSuchMethodException e) {
            throw new NoSuchMethodError(e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new IllegalAccessError(e.getMessage());
        }
        writeReplaces = new ClassValue<MethodHandle>(){
            private static final ReflectionFactory rf = ReflectionFactory.getReflectionFactory();

            @Override
            protected MethodHandle computeValue(Class<?> type) {
                MethodHandle base = rf.writeReplaceForSerialization(type);
                return base == null ? null : base.asType(MethodType.methodType(SerializedLambda.class, Serializable.class));
            }
        };
        SW = StackWalker.getInstance(Set.of(StackWalker.Option.RETAIN_CLASS_REFERENCE, StackWalker.Option.SHOW_HIDDEN_FRAMES, StackWalker.Option.SHOW_REFLECT_FRAMES));
        baseTypeSigs = Stream.of(ConstantDescs.CD_boolean, ConstantDescs.CD_byte, ConstantDescs.CD_short, ConstantDescs.CD_char, ConstantDescs.CD_int, ConstantDescs.CD_long, ConstantDescs.CD_float, ConstantDescs.CD_double, ConstantDescs.CD_void).collect(Collectors.toUnmodifiableMap(Function.identity(), Signature.BaseTypeSig::of));
    }
}

