/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool.notification;

import es.blackleg.jlibnotify.JLibnotify;
import es.blackleg.jlibnotify.JLibnotifyNotification;
import es.blackleg.jlibnotify.ServerInfo;
import es.blackleg.jlibnotify.core.DefaultJLibnotifyLoader;
import es.blackleg.jlibnotify.exception.JLibnotifyInitException;
import es.blackleg.jlibnotify.exception.JLibnotifyLoadException;
import java.io.Closeable;
import java.util.Collection;
import mediathek.config.Config;
import mediathek.tool.notification.INotificationCenter;
import mediathek.tool.notification.NotificationMessage;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LinuxNotificationCenter
implements INotificationCenter,
Closeable {
    private static final Logger logger = LogManager.getLogger();
    private JLibnotify libNotify;
    private boolean nativeSupport;

    public LinuxNotificationCenter() {
        try {
            DefaultJLibnotifyLoader loader = new DefaultJLibnotifyLoader();
            this.libNotify = loader.load();
            this.libNotify.init("MediathekView");
            this.nativeSupport = true;
            ServerInfo serverInfo = this.libNotify.getServerInfo();
            logger.info((Object)serverInfo);
            if (Config.isDebugModeEnabled()) {
                logger.debug("Server capabilities:");
                Collection caps = this.libNotify.getServerCapabilities();
                for (String s : caps) {
                    logger.debug("\t {}", (Object)s);
                }
            }
        }
        catch (JLibnotifyInitException | JLibnotifyLoadException | RuntimeException | UnsatisfiedLinkError e) {
            this.nativeSupport = false;
            logger.error("Failed to initialize libNotify", e);
        }
    }

    @Override
    public void displayNotification(NotificationMessage msg) {
        JLibnotifyNotification notification = this.libNotify.createNotification(msg.getTitle(), msg.message, "dialog-information");
        notification.show();
    }

    public boolean hasNativeSupport() {
        return this.nativeSupport;
    }

    @Override
    public void close() {
        this.libNotify.unInit();
    }
}

