/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.DescribeVerifiedAccessGroupsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVerifiedAccessGroupsResponse;
import software.amazon.awssdk.services.ec2.model.VerifiedAccessGroup;

public class DescribeVerifiedAccessGroupsIterable
implements SdkIterable<DescribeVerifiedAccessGroupsResponse> {
    private final Ec2Client client;
    private final DescribeVerifiedAccessGroupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeVerifiedAccessGroupsIterable(Ec2Client client, DescribeVerifiedAccessGroupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeVerifiedAccessGroupsResponseFetcher();
    }

    public Iterator<DescribeVerifiedAccessGroupsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<VerifiedAccessGroup> verifiedAccessGroups() {
        Function<DescribeVerifiedAccessGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.verifiedAccessGroups() != null) {
                return response.verifiedAccessGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeVerifiedAccessGroupsResponseFetcher
    implements SyncPageFetcher<DescribeVerifiedAccessGroupsResponse> {
        private DescribeVerifiedAccessGroupsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeVerifiedAccessGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeVerifiedAccessGroupsResponse nextPage(DescribeVerifiedAccessGroupsResponse previousPage) {
            if (previousPage == null) {
                return DescribeVerifiedAccessGroupsIterable.this.client.describeVerifiedAccessGroups(DescribeVerifiedAccessGroupsIterable.this.firstRequest);
            }
            return DescribeVerifiedAccessGroupsIterable.this.client.describeVerifiedAccessGroups((DescribeVerifiedAccessGroupsRequest)((Object)DescribeVerifiedAccessGroupsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

