/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.action.IndexInsight;

import java.util.Optional;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.DocWriteResponse;
import org.opensearch.action.index.IndexResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.action.support.clustermanager.AcknowledgedResponse;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.xcontent.ToXContentObject;
import org.opensearch.ml.common.MLIndex;
import org.opensearch.ml.common.indexInsight.IndexInsightConfig;
import org.opensearch.ml.common.settings.MLCommonsSettings;
import org.opensearch.ml.common.settings.MLFeatureEnabledSetting;
import org.opensearch.ml.common.transport.indexInsight.MLIndexInsightConfigPutRequest;
import org.opensearch.ml.engine.indices.MLIndicesHandler;
import org.opensearch.ml.helper.ConnectorAccessControlHelper;
import org.opensearch.ml.utils.RestActionUtils;
import org.opensearch.ml.utils.TenantAwareHelper;
import org.opensearch.remote.metadata.client.PutDataObjectRequest;
import org.opensearch.remote.metadata.client.SdkClient;
import org.opensearch.remote.metadata.common.SdkClientUtils;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;

public class PutIndexInsightConfigTransportAction
extends HandledTransportAction<ActionRequest, AcknowledgedResponse> {
    @Generated
    private static final Logger log = LogManager.getLogger(PutIndexInsightConfigTransportAction.class);
    private final Client client;
    private final SdkClient sdkClient;
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;
    private final MLIndicesHandler mlIndicesHandler;

    @Inject
    public PutIndexInsightConfigTransportAction(TransportService transportService, ActionFilters actionFilters, MLFeatureEnabledSetting mlFeatureEnabledSetting, Client client, SdkClient sdkClient, MLIndicesHandler mlIndicesHandler) {
        super("cluster:admin/opensearch/ml/index_insight_container/create", transportService, actionFilters, MLIndexInsightConfigPutRequest::new);
        this.client = client;
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
        this.sdkClient = sdkClient;
        this.mlIndicesHandler = mlIndicesHandler;
    }

    protected void doExecute(Task task, ActionRequest request, ActionListener<AcknowledgedResponse> listener) {
        MLIndexInsightConfigPutRequest mlIndexInsightConfigPutRequest = MLIndexInsightConfigPutRequest.fromActionRequest((ActionRequest)request);
        if (!TenantAwareHelper.validateTenantId(this.mlFeatureEnabledSetting, mlIndexInsightConfigPutRequest.getTenantId(), listener)) {
            return;
        }
        if (!this.mlFeatureEnabledSetting.isIndexInsightEnabled()) {
            listener.onFailure((Exception)new RuntimeException("Index insight feature is not enabled yet. To enable, please update the setting " + MLCommonsSettings.ML_COMMONS_INDEX_INSIGHT_FEATURE_ENABLED.getKey()));
            return;
        }
        User user = RestActionUtils.getUserContext(this.client);
        if (user != null && !ConnectorAccessControlHelper.isAdmin(user)) {
            listener.onFailure((Exception)new RuntimeException("You don't have permission to put index insight config. Please contact admin user."));
            return;
        }
        String tenantId = mlIndexInsightConfigPutRequest.getTenantId();
        IndexInsightConfig indexInsightConfig = IndexInsightConfig.builder().isEnable(mlIndexInsightConfigPutRequest.getIsEnable()).tenantId(tenantId).build();
        this.mlIndicesHandler.initMLIndexIfAbsent(MLIndex.INDEX_INSIGHT_CONFIG, ActionListener.wrap(r -> this.indexIndexInsightConfig(indexInsightConfig, (ActionListener<Boolean>)ActionListener.wrap(r1 -> {
            if (indexInsightConfig.getIsEnable().booleanValue()) {
                this.mlIndicesHandler.initMLIndexIfAbsent(MLIndex.INDEX_INSIGHT_STORAGE, ActionListener.wrap(r2 -> {
                    log.info("Successfully created index insight data index");
                    listener.onResponse((Object)new AcknowledgedResponse(true));
                }, e -> {
                    log.error("Failed to create index insight config", (Throwable)e);
                    listener.onFailure(e);
                }));
            } else {
                listener.onResponse((Object)new AcknowledgedResponse(true));
            }
        }, arg_0 -> ((ActionListener)listener).onFailure(arg_0))), arg_0 -> listener.onFailure(arg_0)));
    }

    private void indexIndexInsightConfig(IndexInsightConfig indexInsightConfig, ActionListener<Boolean> listener) {
        try (ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();){
            String docId = Optional.ofNullable(indexInsightConfig.getTenantId()).orElse("03000200-0400-0500-0006-000700080009");
            this.sdkClient.putDataObjectAsync(((PutDataObjectRequest.Builder)((PutDataObjectRequest.Builder)((PutDataObjectRequest.Builder)PutDataObjectRequest.builder().tenantId(indexInsightConfig.getTenantId())).index(".plugins-ml-index-insight-config")).dataObject((ToXContentObject)indexInsightConfig).id(docId)).build()).whenComplete((r, throwable) -> {
                context.restore();
                if (throwable != null) {
                    Exception cause = SdkClientUtils.unwrapAndConvertToException((Throwable)throwable, (Class[])new Class[0]);
                    log.error("Failed to index index insight config", (Throwable)cause);
                    listener.onFailure(cause);
                } else {
                    try {
                        IndexResponse indexResponse = r.indexResponse();
                        assert (indexResponse != null);
                        if (indexResponse.getResult() == DocWriteResponse.Result.CREATED || indexResponse.getResult() == DocWriteResponse.Result.UPDATED) {
                            String generatedId = indexResponse.getId();
                            log.info("Successfully created index insight with ID: {}", (Object)generatedId);
                            listener.onResponse((Object)true);
                        } else {
                            listener.onFailure((Exception)new RuntimeException("Failed to create index insight config"));
                        }
                    }
                    catch (Exception e) {
                        listener.onFailure(e);
                    }
                }
            });
        }
        catch (Exception e) {
            log.error("Failed to create index insight config", (Throwable)e);
            listener.onFailure(e);
        }
    }
}

