/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.soap.messaging;

import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.collection.LazyList;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.soap.messaging.context.InboundSOAPContext;
import org.opensaml.soap.messaging.context.SOAP11Context;
import org.opensaml.soap.soap11.Envelope;
import org.opensaml.soap.soap11.Fault;
import org.opensaml.soap.soap11.Header;
import org.opensaml.soap.util.SOAPSupport;
import org.opensaml.soap.util.SOAPVersion;

public final class SOAPMessagingSupport {
    private SOAPMessagingSupport() {
    }

    @Nonnull
    public static InboundSOAPContext getInboundSOAPContext(@Nonnull MessageContext messageContext) {
        Constraint.isNotNull(messageContext, "Message context cannot be null");
        return messageContext.ensureSubcontext(InboundSOAPContext.class);
    }

    @Deprecated(since="5.0.0", forRemoval=true)
    @Nullable
    public static SOAP11Context getSOAP11Context(@Nonnull MessageContext messageContext, boolean autoCreate) {
        Constraint.isNotNull(messageContext, "Message context cannot be null");
        return messageContext.getSubcontext(SOAP11Context.class, autoCreate);
    }

    @Nullable
    public static SOAP11Context getSOAP11Context(@Nonnull MessageContext messageContext) {
        Constraint.isNotNull(messageContext, "Message context cannot be null");
        return messageContext.getSubcontext(SOAP11Context.class);
    }

    @Nonnull
    public static SOAP11Context ensureSOAP11Context(@Nonnull MessageContext messageContext) {
        Constraint.isNotNull(messageContext, "Message context cannot be null");
        return messageContext.ensureSubcontext(SOAP11Context.class);
    }

    public static void registerUnderstoodHeader(@Nonnull MessageContext msgContext, @Nonnull XMLObject header) {
        InboundSOAPContext inboundContext = SOAPMessagingSupport.getInboundSOAPContext(msgContext);
        inboundContext.getUnderstoodHeaders().add(header);
    }

    public static boolean checkUnderstoodHeader(@Nonnull MessageContext msgContext, @Nonnull XMLObject header) {
        InboundSOAPContext inboundContext = SOAPMessagingSupport.getInboundSOAPContext(msgContext);
        return inboundContext.getUnderstoodHeaders().contains(header);
    }

    public static boolean isSOAPMessage(@Nonnull MessageContext messageContext) {
        Constraint.isNotNull(messageContext, "Message context cannot be null");
        SOAPVersion version = SOAPMessagingSupport.getSOAPVersion(messageContext);
        return version != null;
    }

    public static boolean isSOAP11Message(@Nonnull MessageContext messageContext) {
        Constraint.isNotNull(messageContext, "Message context cannot be null");
        SOAPVersion version = SOAPMessagingSupport.getSOAPVersion(messageContext);
        return version != null && SOAPVersion.SOAP_1_1.equals((Object)version);
    }

    @Nullable
    public static SOAPVersion getSOAPVersion(@Nonnull MessageContext messageContext) {
        Constraint.isNotNull(messageContext, "Message context cannot be null");
        SOAP11Context soap11 = SOAPMessagingSupport.getSOAP11Context(messageContext, false);
        if (soap11 != null && soap11.getEnvelope() != null) {
            return SOAPVersion.SOAP_1_1;
        }
        return null;
    }

    public static boolean isMustUnderstand(@Nonnull MessageContext messageContext, @Nonnull XMLObject headerBlock) {
        Constraint.isNotNull(messageContext, "Message context cannot be null");
        Constraint.isNotNull(headerBlock, "Header block context cannot be null");
        SOAPVersion soapVersion = SOAPMessagingSupport.getSOAPVersion(messageContext);
        if (soapVersion == null) {
            throw new IllegalArgumentException("Could not determine SOAP version for message context");
        }
        switch (soapVersion) {
            case SOAP_1_1: {
                return SOAPSupport.getSOAP11MustUnderstandAttribute(headerBlock);
            }
            case SOAP_1_2: {
                return SOAPSupport.getSOAP12MustUnderstandAttribute(headerBlock);
            }
        }
        throw new IllegalArgumentException("Saw unsupported SOAP version: " + String.valueOf((Object)soapVersion));
    }

    public static void addMustUnderstand(@Nonnull MessageContext messageContext, @Nonnull XMLObject headerBlock, boolean mustUnderstand) {
        Constraint.isNotNull(messageContext, "Message context cannot be null");
        Constraint.isNotNull(headerBlock, "Header block context cannot be null");
        SOAPVersion soapVersion = SOAPMessagingSupport.getSOAPVersion(messageContext);
        if (soapVersion == null) {
            throw new IllegalArgumentException("Could not determine SOAP version for message context");
        }
        switch (soapVersion) {
            case SOAP_1_1: {
                SOAPSupport.addSOAP11MustUnderstandAttribute(headerBlock, mustUnderstand);
                break;
            }
            case SOAP_1_2: {
                SOAPSupport.addSOAP12MustUnderstandAttribute(headerBlock, mustUnderstand);
                break;
            }
            default: {
                throw new IllegalArgumentException("Saw unsupported SOAP version: " + String.valueOf((Object)soapVersion));
            }
        }
    }

    public static void addTargetNode(@Nonnull MessageContext messageContext, @Nonnull XMLObject headerBlock, @Nullable String targetNode) {
        if (targetNode == null) {
            return;
        }
        Constraint.isNotNull(messageContext, "Message context cannot be null");
        Constraint.isNotNull(headerBlock, "Header block context cannot be null");
        SOAPVersion soapVersion = SOAPMessagingSupport.getSOAPVersion(messageContext);
        if (soapVersion == null) {
            throw new IllegalArgumentException("Could not determine SOAP version for message context");
        }
        switch (soapVersion) {
            case SOAP_1_1: {
                SOAPSupport.addSOAP11ActorAttribute(headerBlock, targetNode);
                break;
            }
            case SOAP_1_2: {
                SOAPSupport.addSOAP12RoleAttribute(headerBlock, targetNode);
                break;
            }
            default: {
                throw new IllegalArgumentException("Saw unsupported SOAP version: " + String.valueOf((Object)soapVersion));
            }
        }
    }

    @Nonnull
    public static List<XMLObject> getInboundHeaderBlock(@Nonnull MessageContext messageContext, @Nonnull QName headerName) {
        InboundSOAPContext inboundContext = SOAPMessagingSupport.getInboundSOAPContext(messageContext);
        return SOAPMessagingSupport.getHeaderBlock(messageContext, headerName, inboundContext.getNodeActors(), inboundContext.isFinalDestination());
    }

    @Nonnull
    public static List<XMLObject> getOutboundHeaderBlock(@Nonnull MessageContext messageContext, @Nonnull QName headerName) {
        return SOAPMessagingSupport.getHeaderBlock(messageContext, headerName, null, true);
    }

    @Nonnull
    public static List<XMLObject> getHeaderBlock(@Nonnull MessageContext messageContext, @Nonnull QName headerName, @Nullable Set<String> targetNodes, boolean isFinalDestination) {
        Envelope env;
        Constraint.isNotNull(messageContext, "Message context cannot be null");
        SOAP11Context soap11 = SOAPMessagingSupport.getSOAP11Context(messageContext);
        if (soap11 != null && (env = soap11.getEnvelope()) != null) {
            return SOAPMessagingSupport.getSOAP11HeaderBlock(env, headerName, targetNodes, isFinalDestination);
        }
        return CollectionSupport.emptyList();
    }

    @Nonnull
    public static List<XMLObject> getSOAP11HeaderBlock(@Nonnull Envelope envelope, @Nonnull QName headerName, @Nullable Set<String> targetNodes, boolean isFinalDestination) {
        Constraint.isNotNull(envelope, "Envelope cannot be null");
        Constraint.isNotNull(headerName, "Header name cannot be null");
        Header envelopeHeader = envelope.getHeader();
        if (envelopeHeader == null) {
            return CollectionSupport.emptyList();
        }
        LazyList<XMLObject> headers = new LazyList<XMLObject>();
        for (XMLObject header : envelopeHeader.getUnknownXMLObjects(headerName)) {
            assert (header != null);
            if (!SOAPMessagingSupport.isSOAP11HeaderTargetedToNode(header, targetNodes, isFinalDestination)) continue;
            headers.add(header);
        }
        return headers;
    }

    public static boolean isSOAP11HeaderTargetedToNode(@Nonnull XMLObject header, @Nullable Set<String> nodeActors, boolean isFinalDestination) {
        String headerActor = SOAPSupport.getSOAP11ActorAttribute(header);
        if (headerActor == null) {
            if (isFinalDestination) {
                return true;
            }
        } else {
            if ("http://schemas.xmlsoap.org/soap/actor/next".equals(headerActor)) {
                return true;
            }
            if (nodeActors != null && nodeActors.contains(headerActor)) {
                return true;
            }
        }
        return false;
    }

    public static void addHeaderBlock(@Nonnull MessageContext messageContext, @Nonnull XMLObject headerBlock) {
        Constraint.isNotNull(messageContext, "Message context cannot be null");
        SOAP11Context soap11 = SOAPMessagingSupport.getSOAP11Context(messageContext);
        if (soap11 != null) {
            Envelope env = soap11.getEnvelope();
            if (env != null) {
                SOAPMessagingSupport.addSOAP11HeaderBlock(env, headerBlock);
            }
        } else {
            throw new IllegalArgumentException("Message context did not contain a SOAP Envelope");
        }
    }

    public static void addSOAP11HeaderBlock(@Nonnull Envelope envelope, @Nonnull XMLObject headerBlock) {
        Constraint.isNotNull(envelope, "Envelope cannot be null");
        Constraint.isNotNull(headerBlock, "Header block cannot be null");
        Header envelopeHeader = envelope.getHeader();
        if (envelopeHeader == null) {
            envelopeHeader = (Header)XMLObjectProviderRegistrySupport.getBuilderFactory().ensureBuilder(Header.DEFAULT_ELEMENT_NAME).buildObject(Header.DEFAULT_ELEMENT_NAME);
            envelope.setHeader(envelopeHeader);
        }
        envelopeHeader.getUnknownXMLObjects().add(headerBlock);
    }

    public static void registerSOAP11Fault(@Nonnull MessageContext messageContext, @Nonnull QName faultCode, @Nonnull String faultString, @Nullable String faultActor, @Nullable List<XMLObject> detailChildren, @Nullable Map<QName, String> detailAttributes) {
        SOAPMessagingSupport.registerSOAP11Fault(messageContext, SOAPSupport.buildSOAP11Fault(faultCode, faultString, faultActor, detailChildren, detailAttributes));
    }

    public static void registerSOAP11Fault(@Nonnull MessageContext messageContext, @Nullable Fault fault) {
        SOAP11Context soap11Context = SOAPMessagingSupport.ensureSOAP11Context(messageContext);
        soap11Context.setFault(fault);
    }

    public static Fault getSOAP11Fault(@Nonnull MessageContext messageContext) {
        SOAP11Context soap11Context = SOAPMessagingSupport.getSOAP11Context(messageContext);
        if (soap11Context != null) {
            return soap11Context.getFault();
        }
        return null;
    }

    public static void clearFault(@Nonnull MessageContext messageContext) {
        SOAP11Context soap11Context = SOAPMessagingSupport.getSOAP11Context(messageContext);
        if (soap11Context != null) {
            soap11Context.setFault(null);
        }
    }
}

