/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.jniutils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.graalvm.jniutils.JNI;
import org.graalvm.jniutils.JNICalls;
import org.graalvm.jniutils.JNIUtil;
import org.graalvm.nativeimage.StackValue;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.word.WordFactory;

public final class JNIExceptionWrapper
extends RuntimeException {
    private static final String HS_ENTRYPOINTS_CLASS = "org.graalvm.jniutils.JNIExceptionWrapperEntryPoints";
    private static final long serialVersionUID = 1L;
    private static final JNIMethodResolver CreateException = JNIMethodResolver.create("createException", Throwable.class, String.class, Throwable.class);
    private static final JNIMethodResolver GetClassName = JNIMethodResolver.create("getClassName", String.class, Class.class);
    private static final JNIMethodResolver GetStackTrace = JNIMethodResolver.create("getStackTrace", byte[].class, Throwable.class);
    private static final JNIMethodResolver GetThrowableMessage = JNIMethodResolver.create("getThrowableMessage", String.class, Throwable.class);
    private static final JNIMethodResolver UpdateStackTrace = JNIMethodResolver.create("updateStackTrace", Throwable.class, Throwable.class, byte[].class);
    private static volatile JNI.JClass entryPointsClass;
    private final JNI.JThrowable throwableHandle;
    private final boolean throwableRequiresStackTraceUpdate;
    private static final Set<String> JNI_TRANSITION_METHODS;
    private static final String JNI_TRANSITION_CLASS;
    private static final String JNI_FUNCTION_POINTER_CLASS_PREFIX;

    private JNIExceptionWrapper(JNI.JNIEnv env, JNI.JThrowable throwableHandle) {
        super(JNIExceptionWrapper.formatExceptionMessage(JNIExceptionWrapper.getClassName(env, throwableHandle), JNIExceptionWrapper.getMessage(env, throwableHandle)));
        this.throwableHandle = throwableHandle;
        this.throwableRequiresStackTraceUpdate = this.createMergedStackTrace(env);
    }

    private boolean createMergedStackTrace(JNI.JNIEnv env) {
        boolean res;
        StackTraceElement[] mergedStack;
        StackTraceElement[] hsStack = JNIExceptionWrapper.getJNIExceptionStackTrace(env, this.throwableHandle);
        if (hsStack.length == 0 || JNIExceptionWrapper.containsJNIHostCall(hsStack)) {
            mergedStack = hsStack;
            res = false;
        } else {
            StackTraceElement[] nativeStack = this.getStackTrace();
            boolean originatedInHotSpot = !hsStack[0].isNativeMethod();
            mergedStack = JNIExceptionWrapper.mergeStackTraces(hsStack, nativeStack, 0, JNIExceptionWrapper.getIndexOfPropagateJNIExceptionFrame(nativeStack), originatedInHotSpot);
            res = true;
        }
        this.setStackTrace(mergedStack);
        return res;
    }

    public static void wrapAndThrowPendingJNIException(JNI.JNIEnv env) {
        JNIExceptionWrapper.wrapAndThrowPendingJNIException(env, ExceptionHandler.DEFAULT);
    }

    public static void wrapAndThrowPendingJNIException(JNI.JNIEnv env, ExceptionHandler exceptionHandler) {
        Objects.requireNonNull(exceptionHandler, "ExceptionHandler must be non null.");
        if (JNIUtil.ExceptionCheck(env)) {
            JNI.JThrowable exception = JNIUtil.ExceptionOccurred(env);
            if (JNIUtil.tracingAt(2) && exception.isNonNull()) {
                JNIUtil.ExceptionDescribe(env);
            }
            JNIUtil.ExceptionClear(env);
            exceptionHandler.handleException(new ExceptionHandlerContext(env, exception));
        }
    }

    public static void throwInHotSpot(JNI.JNIEnv env, Throwable original) {
        try {
            JNIUtil.trace(2, original);
            JNI.JThrowable toThrow = JNIExceptionWrapper.createHSException(env, original);
            JNIUtil.Throw(env, toThrow);
        }
        catch (Throwable t) {
            if (t instanceof ThreadDeath) {
                throw t;
            }
            original.addSuppressed(t);
            original.printStackTrace();
        }
    }

    public static JNI.JThrowable createHSException(JNI.JNIEnv env, Throwable original) {
        JNI.JThrowable hsThrowable;
        if (original instanceof JNIExceptionWrapper) {
            JNIExceptionWrapper jniExceptionWrapper = (JNIExceptionWrapper)original;
            hsThrowable = jniExceptionWrapper.throwableHandle;
            if (jniExceptionWrapper.throwableRequiresStackTraceUpdate) {
                hsThrowable = JNIExceptionWrapper.updateStackTrace(env, hsThrowable, jniExceptionWrapper.getStackTrace());
            }
        } else {
            String message = JNIExceptionWrapper.formatExceptionMessage(original.getClass().getName(), original.getMessage());
            JNI.JString hsMessage = JNIUtil.createHSString(env, message);
            Throwable cause = original.getCause();
            JNI.JThrowable hsCause = cause != null ? JNIExceptionWrapper.createHSException(env, cause) : (JNI.JThrowable)WordFactory.nullPointer();
            hsThrowable = JNIExceptionWrapper.callCreateException(env, hsMessage, hsCause);
            StackTraceElement[] nativeStack = original.getStackTrace();
            if (nativeStack.length != 0) {
                StackTraceElement[] hsStack = JNIExceptionWrapper.getJNIExceptionStackTrace(env, hsThrowable);
                StackTraceElement[] mergedStack = JNIExceptionWrapper.mergeStackTraces(hsStack, nativeStack, 1, JNIExceptionWrapper.getIndexOfPropagateJNIExceptionFrame(nativeStack), false);
                hsThrowable = JNIExceptionWrapper.updateStackTrace(env, hsThrowable, mergedStack);
            }
        }
        return hsThrowable;
    }

    public static StackTraceElement[] mergeStackTraces(StackTraceElement[] hotSpotStackTrace, StackTraceElement[] nativeStackTrace, boolean originatedInHotSpot) {
        if (originatedInHotSpot) {
            if (JNIExceptionWrapper.containsJNIHostCall(hotSpotStackTrace)) {
                return hotSpotStackTrace;
            }
        } else if (JNIExceptionWrapper.containsHostToIsolateTransition(nativeStackTrace, hotSpotStackTrace)) {
            return nativeStackTrace;
        }
        return JNIExceptionWrapper.mergeStackTraces(hotSpotStackTrace, nativeStackTrace, originatedInHotSpot ? 0 : JNIExceptionWrapper.getIndexOfTransitionToNativeFrame(hotSpotStackTrace), JNIExceptionWrapper.getIndexOfPropagateJNIExceptionFrame(nativeStackTrace), originatedInHotSpot);
    }

    private static StackTraceElement[] mergeStackTraces(StackTraceElement[] hotSpotStackTrace, StackTraceElement[] nativeStackTrace, int hotSpotStackStartIndex, int nativeStackStartIndex, boolean originatedInHotSpot) {
        int targetIndex = 0;
        StackTraceElement[] merged = new StackTraceElement[hotSpotStackTrace.length - hotSpotStackStartIndex + nativeStackTrace.length - nativeStackStartIndex];
        boolean startingHotSpotFrame = true;
        boolean startingnativeFrame = true;
        boolean useHotSpotStack = originatedInHotSpot;
        int hotSpotStackIndex = hotSpotStackStartIndex;
        int nativeStackIndex = nativeStackStartIndex;
        while (hotSpotStackIndex < hotSpotStackTrace.length || nativeStackIndex < nativeStackTrace.length) {
            if (useHotSpotStack) {
                while (hotSpotStackIndex < hotSpotStackTrace.length && (startingHotSpotFrame || !hotSpotStackTrace[hotSpotStackIndex].isNativeMethod())) {
                    startingHotSpotFrame = false;
                    merged[targetIndex++] = hotSpotStackTrace[hotSpotStackIndex++];
                }
                startingHotSpotFrame = true;
            } else {
                useHotSpotStack = true;
            }
            while (!(nativeStackIndex >= nativeStackTrace.length || !startingnativeFrame && JNIExceptionWrapper.isJNIAPICall(nativeStackTrace[nativeStackIndex]) && JNIExceptionWrapper.isJNIHostCall(nativeStackTrace[nativeStackIndex + 1]))) {
                startingnativeFrame = false;
                merged[targetIndex++] = nativeStackTrace[nativeStackIndex++];
            }
            startingnativeFrame = true;
        }
        return merged;
    }

    private static StackTraceElement[] getJNIExceptionStackTrace(JNI.JNIEnv env, JNI.JObject throwableHandle) {
        StackTraceElement[] stackTraceElementArray;
        byte[] serializedStackTrace = JNIUtil.createArray(env, (JNI.JByteArray)JNIExceptionWrapper.callGetStackTrace(env, throwableHandle));
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(serializedStackTrace));
        try {
            int len = in.readInt();
            StackTraceElement[] res = new StackTraceElement[len];
            for (int i = 0; i < len; ++i) {
                String className = in.readUTF();
                String methodName = in.readUTF();
                String fileName = in.readUTF();
                fileName = fileName.isEmpty() ? null : fileName;
                int lineNumber = in.readInt();
                res[i] = new StackTraceElement(className, methodName, fileName, lineNumber);
            }
            stackTraceElementArray = res;
        }
        catch (Throwable throwable) {
            try {
                try {
                    in.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
        in.close();
        return stackTraceElementArray;
    }

    private static boolean containsJNIHostCall(StackTraceElement[] stackTrace) {
        for (StackTraceElement e : stackTrace) {
            if (!JNIExceptionWrapper.isJNIHostCall(e)) continue;
            return true;
        }
        return false;
    }

    private static boolean containsHostToIsolateTransition(StackTraceElement[] nativeStackTrace, StackTraceElement[] hotSpotStackTrace) {
        StackTraceElement transition = null;
        for (StackTraceElement element : hotSpotStackTrace) {
            if (!element.isNativeMethod()) continue;
            transition = element;
            break;
        }
        if (transition != null) {
            for (StackTraceElement element : nativeStackTrace) {
                if (!transition.getClassName().equals(element.getClassName()) || !transition.getMethodName().equals(element.getMethodName())) continue;
                return true;
            }
        }
        return false;
    }

    private static JNI.JThrowable updateStackTrace(JNI.JNIEnv env, JNI.JThrowable throwableHandle, StackTraceElement[] mergedStackTrace) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try (DataOutputStream out = new DataOutputStream(bout);){
            out.writeInt(mergedStackTrace.length);
            for (int i = 0; i < mergedStackTrace.length; ++i) {
                StackTraceElement stackTraceElement = mergedStackTrace[i];
                out.writeUTF(stackTraceElement.getClassName());
                out.writeUTF(stackTraceElement.getMethodName());
                String fileName = stackTraceElement.getFileName();
                out.writeUTF(fileName == null ? "" : fileName);
                out.writeInt(stackTraceElement.getLineNumber());
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        return (JNI.JThrowable)JNIExceptionWrapper.callUpdateStackTrace(env, throwableHandle, JNIUtil.createHSArray(env, bout.toByteArray()));
    }

    private static String getMessage(JNI.JNIEnv env, JNI.JThrowable throwableHandle) {
        JNI.JString message = (JNI.JString)JNIExceptionWrapper.callGetThrowableMessage(env, throwableHandle);
        return JNIUtil.createString(env, message);
    }

    private static String getClassName(JNI.JNIEnv env, JNI.JThrowable throwableHandle) {
        JNI.JClass classHandle = JNIUtil.GetObjectClass(env, throwableHandle);
        JNI.JString className = (JNI.JString)JNIExceptionWrapper.callGetClassName(env, classHandle);
        return JNIUtil.createString(env, className);
    }

    private static String formatExceptionMessage(String className, String message) {
        StringBuilder builder = new StringBuilder(className);
        if (message != null) {
            builder.append(": ").append(message);
        }
        return builder.toString();
    }

    private static int getIndexOfPropagateJNIExceptionFrame(StackTraceElement[] stackTrace) {
        boolean state = false;
        for (int i = 0; i < stackTrace.length; ++i) {
            if (JNIExceptionWrapper.isStackFrame(stackTrace[i], JNIExceptionWrapper.class, "wrapAndThrowPendingJNIException")) {
                state = true;
                continue;
            }
            if (!state) continue;
            return i;
        }
        return 0;
    }

    private static int getIndexOfTransitionToNativeFrame(StackTraceElement[] stackTrace) {
        for (int i = 0; i < stackTrace.length; ++i) {
            if (!stackTrace[i].isNativeMethod()) continue;
            return i;
        }
        return 0;
    }

    private static boolean isStackFrame(StackTraceElement stackTraceElement, Class<?> clazz, String methodName) {
        return clazz.getName().equals(stackTraceElement.getClassName()) && methodName.equals(stackTraceElement.getMethodName());
    }

    private static JNI.JThrowable callCreateException(JNI.JNIEnv env, JNI.JObject p0, JNI.JThrowable p1) {
        JNI.JValue args = (JNI.JValue)StackValue.get((int)2, JNI.JValue.class);
        args.addressOf(0).setJObject(p0);
        args.addressOf(1).setJObject(p1);
        return (JNI.JThrowable)JNICalls.getDefault().callStaticJObject(env, JNIExceptionWrapper.getEntryPoints(env), CreateException.resolve(env), args);
    }

    private static <T extends JNI.JObject> T callUpdateStackTrace(JNI.JNIEnv env, JNI.JObject p0, JNI.JByteArray p1) {
        JNI.JValue args = (JNI.JValue)StackValue.get((int)2, JNI.JValue.class);
        args.addressOf(0).setJObject(p0);
        args.addressOf(1).setJObject(p1);
        return (T)JNICalls.getDefault().callStaticJObject(env, JNIExceptionWrapper.getEntryPoints(env), UpdateStackTrace.resolve(env), args);
    }

    private static <T extends JNI.JObject> T callGetThrowableMessage(JNI.JNIEnv env, JNI.JObject p0) {
        JNI.JValue args = (JNI.JValue)StackValue.get((int)1, JNI.JValue.class);
        args.addressOf(0).setJObject(p0);
        return (T)JNICalls.getDefault().callStaticJObject(env, JNIExceptionWrapper.getEntryPoints(env), GetThrowableMessage.resolve(env), args);
    }

    static <T extends JNI.JObject> T callGetClassName(JNI.JNIEnv env, JNI.JObject p0) {
        JNI.JValue args = (JNI.JValue)StackValue.get((int)1, JNI.JValue.class);
        args.addressOf(0).setJObject(p0);
        return (T)JNICalls.getDefault().callStaticJObject(env, JNIExceptionWrapper.getEntryPoints(env), GetClassName.resolve(env), args);
    }

    private static <T extends JNI.JObject> T callGetStackTrace(JNI.JNIEnv env, JNI.JObject p0) {
        JNI.JValue args = (JNI.JValue)StackValue.get((int)1, JNI.JValue.class);
        args.addressOf(0).setJObject(p0);
        return (T)JNICalls.getDefault().callStaticJObject(env, JNIExceptionWrapper.getEntryPoints(env), GetStackTrace.resolve(env), args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static JNI.JClass getEntryPoints(JNI.JNIEnv env) {
        JNI.JClass res = entryPointsClass;
        if (!res.isNull()) return res;
        String binaryName = JNIUtil.getBinaryName(HS_ENTRYPOINTS_CLASS);
        JNI.JClass entryPoints = JNIUtil.findClass(env, binaryName);
        if (entryPoints.isNull()) {
            JNIUtil.ExceptionClear(env);
            JNI.JObject classLoader = JNIUtil.getJVMCIClassLoader(env);
            if (classLoader.isNonNull()) {
                entryPoints = JNIUtil.findClass(env, classLoader, binaryName);
            }
        }
        if (entryPoints.isNull()) {
            JNIUtil.ExceptionClear(env);
            throw new InternalError("Failed to load org.graalvm.jniutils.JNIExceptionWrapperEntryPoints");
        }
        Class<JNIExceptionWrapper> clazz = JNIExceptionWrapper.class;
        synchronized (JNIExceptionWrapper.class) {
            res = entryPointsClass;
            if (!res.isNull()) return res;
            entryPointsClass = res = JNIUtil.NewGlobalRef(env, entryPoints, "Class<org.graalvm.jniutils.JNIExceptionWrapperEntryPoints>");
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return res;
        }
    }

    private static boolean isJNIAPICall(StackTraceElement frame) {
        return frame.getClassName().startsWith(JNI_FUNCTION_POINTER_CLASS_PREFIX);
    }

    private static boolean isJNIHostCall(StackTraceElement frame) {
        return JNI_TRANSITION_CLASS.equals(frame.getClassName()) && JNI_TRANSITION_METHODS.contains(frame.getMethodName());
    }

    static {
        HashMap<String, Method> entryPoints = new HashMap<String, Method>();
        HashMap<String, Method> others = new HashMap<String, Method>();
        for (Method m : JNICalls.class.getDeclaredMethods()) {
            if (m.getAnnotation(JNICalls.JNICall.class) != null) {
                Method existing = entryPoints.put(m.getName(), m);
                if (existing == null) continue;
                throw new InternalError("Method annotated by " + JNICalls.JNICall.class.getSimpleName() + " must have unique name: " + String.valueOf(m) + " and " + String.valueOf(existing));
            }
            others.put(m.getName(), m);
        }
        for (Map.Entry entry : entryPoints.entrySet()) {
            Method existing = (Method)others.get(entry.getKey());
            if (existing == null) continue;
            throw new InternalError("Method annotated by " + JNICalls.JNICall.class.getSimpleName() + " must have unique name: " + String.valueOf(entry.getValue()) + " and " + String.valueOf(existing));
        }
        JNI_TRANSITION_CLASS = JNICalls.class.getName();
        JNI_TRANSITION_METHODS = Set.copyOf(entryPoints.keySet());
        JNI_FUNCTION_POINTER_CLASS_PREFIX = JNI.class.getName() + "$";
    }

    public static interface ExceptionHandler {
        public static final ExceptionHandler DEFAULT = new ExceptionHandler(){

            @Override
            public void handleException(ExceptionHandlerContext context) {
                context.throwJNIExceptionWrapper();
            }
        };

        @SafeVarargs
        public static ExceptionHandler allowExceptions(final Class<? extends Throwable> ... allowedExceptions) {
            return new ExceptionHandler(){

                @Override
                public void handleException(ExceptionHandlerContext context) {
                    JNI.JThrowable throwable = context.getThrowable();
                    JNI.JNIEnv env = context.getEnv();
                    JNI.JClass throwableClass = JNIUtil.GetObjectClass(env, throwable);
                    boolean allowed = false;
                    for (Class allowedException : allowedExceptions) {
                        JNI.JClass allowedExceptionClass = JNIUtil.findClass(env, JNIUtil.getBinaryName(allowedException.getName()));
                        if (!allowedExceptionClass.isNonNull() || !JNIUtil.IsSameObject(env, throwableClass, allowedExceptionClass)) continue;
                        allowed = true;
                        break;
                    }
                    if (!allowed) {
                        context.throwJNIExceptionWrapper();
                    }
                }
            };
        }

        public void handleException(ExceptionHandlerContext var1);
    }

    public static final class ExceptionHandlerContext {
        private final JNI.JNIEnv env;
        private final JNI.JThrowable throwable;

        ExceptionHandlerContext(JNI.JNIEnv env, JNI.JThrowable throwable) {
            this.env = env;
            this.throwable = throwable;
        }

        public JNI.JNIEnv getEnv() {
            return this.env;
        }

        public JNI.JThrowable getThrowable() {
            return this.throwable;
        }

        public String getThrowableClassName() {
            return JNIExceptionWrapper.getClassName(this.env, this.throwable);
        }

        public void throwJNIExceptionWrapper() {
            throw new JNIExceptionWrapper(this.env, this.throwable);
        }
    }

    private static final class JNIMethodResolver
    implements JNICalls.JNIMethod {
        private final String methodName;
        private final String methodSignature;
        private volatile JNI.JMethodID methodId;

        private JNIMethodResolver(String methodName, String methodSignature) {
            this.methodName = methodName;
            this.methodSignature = methodSignature;
        }

        JNIMethodResolver resolve(JNI.JNIEnv jniEnv) {
            JNI.JMethodID res = this.methodId;
            if (res.isNull()) {
                JNI.JClass entryPointClass = JNIExceptionWrapper.getEntryPoints(jniEnv);
                try (CTypeConversion.CCharPointerHolder name = CTypeConversion.toCString((CharSequence)this.methodName);
                     CTypeConversion.CCharPointerHolder sig = CTypeConversion.toCString((CharSequence)this.methodSignature);){
                    res = JNIUtil.GetStaticMethodID(jniEnv, entryPointClass, name.get(), sig.get());
                    if (res.isNull()) {
                        throw new InternalError("No such method: " + this.methodName);
                    }
                    this.methodId = res;
                }
            }
            return this;
        }

        @Override
        public JNI.JMethodID getJMethodID() {
            return this.methodId;
        }

        @Override
        public String getDisplayName() {
            return this.methodName;
        }

        static JNIMethodResolver create(String methodName, Class<?> returnType, Class<?> ... parameterTypes) {
            return new JNIMethodResolver(methodName, JNIUtil.encodeMethodSignature(returnType, parameterTypes));
        }
    }
}

