/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.SQLException;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.jdbc.FBDriverNotCapableException;
import org.firebirdsql.jdbc.FirebirdBlob;

public final class FBCachedBlob
implements FirebirdBlob {
    private static final byte[] FREED_MARKER = new byte[0];
    static final String BLOB_READ_ONLY = "Cached blob is read-only";
    private volatile byte[] blobData;

    public FBCachedBlob(byte[] data) {
        this.blobData = data;
    }

    @Override
    public FirebirdBlob detach() throws SQLException {
        this.checkClosed();
        return new FBCachedBlob(this.blobData);
    }

    @Override
    public boolean isSegmented() throws SQLException {
        this.checkClosed();
        return false;
    }

    @Override
    public long length() throws SQLException {
        this.checkClosed();
        return this.blobData != null ? (long)this.blobData.length : -1L;
    }

    @Override
    public byte[] getBytes(long pos, int length) throws SQLException {
        if (pos < 1L) {
            throw new SQLException("Expected value of pos > 0, got " + pos, "HY090");
        }
        if (length < 0) {
            throw new SQLException("Expected value of length >= 0, got " + length, "HY090");
        }
        this.checkClosed();
        if (this.blobData == null) {
            return null;
        }
        byte[] result = new byte[length];
        System.arraycopy(this.blobData, (int)pos - 1, result, 0, length);
        return result;
    }

    @Override
    public byte[] getBytes() throws SQLException {
        this.checkClosed();
        return this.blobData != null ? (byte[])this.blobData.clone() : null;
    }

    @Override
    public long position(byte[] pattern, long start) throws SQLException {
        throw new FBDriverNotCapableException("Method Method position(byte[], long) is not supported");
    }

    @Override
    public long position(Blob pattern, long start) throws SQLException {
        throw new FBDriverNotCapableException("Method position(Blob, long) is not supported");
    }

    @Override
    public InputStream getBinaryStream() throws SQLException {
        this.checkClosed();
        if (this.blobData == null) {
            return null;
        }
        return new ByteArrayInputStream(this.blobData);
    }

    @Override
    public InputStream getBinaryStream(long pos, long length) throws SQLException {
        throw new FBDriverNotCapableException("Method getBinaryStream(long, long) is not supported");
    }

    @Override
    public int setBytes(long pos, byte[] bytes) throws SQLException {
        throw new SQLException(BLOB_READ_ONLY, "HY000");
    }

    @Override
    public int setBytes(long pos, byte[] bytes, int offset, int len) throws SQLException {
        throw new SQLException(BLOB_READ_ONLY, "HY000");
    }

    @Override
    public OutputStream setBinaryStream(long pos) throws SQLException {
        throw new SQLException(BLOB_READ_ONLY, "HY000");
    }

    @Override
    public void truncate(long length) throws SQLException {
        throw new FBDriverNotCapableException("Method truncate(long) is not supported");
    }

    @Override
    public void free() throws SQLException {
        this.blobData = FREED_MARKER;
    }

    private void checkClosed() throws SQLException {
        if (this.blobData == FREED_MARKER) {
            throw FbExceptionBuilder.toException(337248295);
        }
    }
}

