/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.jdbc.escape;

import java.sql.SQLException;
import org.firebirdsql.jdbc.FBProcedureCall;
import org.firebirdsql.jdbc.FBProcedureParam;
import org.firebirdsql.jdbc.escape.FBEscapedParser;
import org.firebirdsql.jdbc.escape.FBSQLParseException;

public final class FBEscapedCallParser {
    private static final int INITIAL_CAPACITY = 32;
    private ParserState state = ParserState.NORMAL_STATE;
    private boolean isNameProcessed;
    private boolean isExecuteWordProcessed;
    private boolean isProcedureWordProcessed;
    private boolean isCallWordProcessed;
    private int openBraceCount;
    private FBProcedureCall procedureCall = new FBProcedureCall();

    void switchState(char testChar) {
        if (Character.isWhitespace(testChar) && this.state != ParserState.LITERAL_STATE) {
            this.state = ParserState.SPACE_STATE;
            return;
        }
        switch (testChar) {
            case '\'': {
                if (this.state == ParserState.NORMAL_STATE) {
                    this.state = ParserState.LITERAL_STATE;
                    break;
                }
                if (this.state != ParserState.LITERAL_STATE) break;
                this.state = ParserState.NORMAL_STATE;
                break;
            }
            case ',': {
                if (this.state == ParserState.LITERAL_STATE || this.state == ParserState.PARENS_STATE) break;
                this.state = ParserState.COMMA_STATE;
                break;
            }
            case '(': 
            case ')': {
                if (this.state == ParserState.LITERAL_STATE) break;
                this.state = ParserState.PARENS_STATE;
                break;
            }
            case '{': 
            case '}': {
                if (this.state == ParserState.LITERAL_STATE) break;
                this.state = ParserState.CURLY_BRACE_STATE;
                break;
            }
            default: {
                if (this.state == ParserState.LITERAL_STATE || this.state == ParserState.PARENS_STATE) break;
                this.state = ParserState.NORMAL_STATE;
            }
        }
    }

    private String cleanUpCall(String sql) throws FBSQLParseException {
        int startIndex;
        int endIndex = sql.length();
        for (startIndex = 0; startIndex < endIndex && Character.isWhitespace(sql.charAt(startIndex)); ++startIndex) {
        }
        while (endIndex > startIndex && Character.isWhitespace(sql.charAt(endIndex - 1))) {
            --endIndex;
        }
        if (startIndex < endIndex && sql.charAt(startIndex) == '{' && sql.charAt(endIndex - 1) == '}') {
            ++startIndex;
            --endIndex;
        }
        if (startIndex >= endIndex) {
            throw new FBSQLParseException("Escaped call statement was empty.");
        }
        return sql.substring(startIndex, endIndex);
    }

    private boolean isCallKeywordProcessed() {
        return this.isCallWordProcessed || this.isExecuteWordProcessed && this.isProcedureWordProcessed;
    }

    private void reset() {
        this.procedureCall = new FBProcedureCall();
        this.isExecuteWordProcessed = false;
        this.isProcedureWordProcessed = false;
        this.isCallWordProcessed = false;
        this.isNameProcessed = false;
        this.state = ParserState.NORMAL_STATE;
    }

    public FBProcedureCall parseCall(String sql) throws SQLException {
        String value;
        int startIndex;
        sql = this.cleanUpCall(sql);
        this.reset();
        boolean isFirstOutParam = false;
        int paramCount = 0;
        int paramPosition = 0;
        StringBuilder buffer = new StringBuilder(32);
        int length = sql.length();
        block8: for (int i = 0; i < length; ++i) {
            char currentChar = sql.charAt(i);
            this.switchState(currentChar);
            switch (this.state) {
                case NORMAL_STATE: {
                    Object param;
                    if (!(currentChar != '=' || this.openBraceCount > 0 || buffer.isEmpty() || buffer.charAt(0) != '?' || isFirstOutParam || this.isNameProcessed)) {
                        param = this.procedureCall.addParam(paramPosition, "?");
                        ((FBProcedureParam)param).setIndex(++paramCount);
                        isFirstOutParam = true;
                        ++paramPosition;
                        buffer.setLength(0);
                        continue block8;
                    }
                    buffer.append(currentChar);
                    continue block8;
                }
                case SPACE_STATE: {
                    int j;
                    if (buffer.isEmpty()) {
                        this.state = ParserState.NORMAL_STATE;
                        continue block8;
                    }
                    if (this.openBraceCount > 0 || this.isNameProcessed) {
                        buffer.append(currentChar);
                        this.state = ParserState.NORMAL_STATE;
                        continue block8;
                    }
                    boolean tokenProcessed = this.processToken(buffer.toString().trim());
                    if (!tokenProcessed) continue block8;
                    buffer.setLength(0);
                    this.state = ParserState.NORMAL_STATE;
                    if (!this.isNameProcessed) continue block8;
                    for (j = i; j < length - 1 && Character.isWhitespace(sql.charAt(j)); ++j) {
                    }
                    if (sql.charAt(j) != '(') continue block8;
                    i = j;
                    continue block8;
                }
                case PARENS_STATE: {
                    boolean isProcedureName;
                    boolean bl = isProcedureName = currentChar == '(' && this.isCallKeywordProcessed() && !this.isNameProcessed;
                    if (isProcedureName) {
                        if (buffer.isEmpty()) {
                            throw new FBSQLParseException("Procedure name is empty.");
                        }
                        this.procedureCall.setName(buffer.toString().trim());
                        this.isNameProcessed = true;
                        buffer.setLength(0);
                    } else {
                        buffer.append(currentChar);
                        this.openBraceCount = currentChar == '(' ? ++this.openBraceCount : --this.openBraceCount;
                    }
                    this.state = ParserState.NORMAL_STATE;
                    continue block8;
                }
                case CURLY_BRACE_STATE: {
                    buffer.append(currentChar);
                    this.state = ParserState.NORMAL_STATE;
                    continue block8;
                }
                case COMMA_STATE: {
                    if (this.openBraceCount > 0) {
                        buffer.append(currentChar);
                        continue block8;
                    }
                    Object param = this.processParam(buffer.toString());
                    buffer.setLength(0);
                    FBProcedureParam callParam = this.procedureCall.addParam(paramPosition, (String)param);
                    if (callParam.isParam()) {
                        callParam.setIndex(++paramCount);
                    }
                    ++paramPosition;
                    this.state = ParserState.NORMAL_STATE;
                    continue block8;
                }
                case LITERAL_STATE: {
                    buffer.append(currentChar);
                }
            }
        }
        if (buffer.isEmpty()) {
            return this.procedureCall;
        }
        int endIndex = buffer.length();
        for (startIndex = 0; startIndex < endIndex && Character.isSpaceChar(buffer.charAt(startIndex)); ++startIndex) {
        }
        while (endIndex > startIndex && Character.isSpaceChar(buffer.charAt(endIndex - 1))) {
            --endIndex;
        }
        if (startIndex < endIndex && buffer.charAt(startIndex) == '(') {
            ++startIndex;
        }
        if (startIndex < endIndex && buffer.charAt(endIndex - 1) == ')') {
            --endIndex;
        }
        String string = value = startIndex < endIndex ? buffer.substring(startIndex, endIndex).trim() : "";
        if (value.isEmpty()) {
            return this.procedureCall;
        }
        if (null == this.procedureCall.getName() && !this.isNameProcessed) {
            this.procedureCall.setName(value);
        } else {
            FBProcedureParam callParam = this.procedureCall.addParam(paramPosition, value);
            if (callParam.isParam()) {
                callParam.setIndex(++paramCount);
            }
        }
        return this.procedureCall;
    }

    boolean processToken(String token) {
        if ("EXECUTE".equalsIgnoreCase(token) && !this.isExecuteWordProcessed && !this.isProcedureWordProcessed && !this.isNameProcessed) {
            this.isExecuteWordProcessed = true;
            return true;
        }
        if ("PROCEDURE".equalsIgnoreCase(token) && this.isExecuteWordProcessed && !this.isProcedureWordProcessed && !this.isNameProcessed) {
            this.isProcedureWordProcessed = true;
            return true;
        }
        if ("call".equalsIgnoreCase(token) && !this.isCallWordProcessed && !this.isNameProcessed) {
            this.isCallWordProcessed = true;
            return true;
        }
        if ((this.isCallWordProcessed || this.isExecuteWordProcessed && this.isProcedureWordProcessed) && !this.isNameProcessed) {
            this.procedureCall.setName(token);
            this.isNameProcessed = true;
            return true;
        }
        return false;
    }

    String processParam(String param) throws SQLException {
        return FBEscapedParser.toNativeSql(param);
    }

    static enum ParserState {
        NORMAL_STATE,
        LITERAL_STATE,
        PARENS_STATE,
        CURLY_BRACE_STATE,
        SPACE_STATE,
        COMMA_STATE;

    }
}

