/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.AtexitModuleBuiltinsFactory;
import com.oracle.graal.python.builtins.modules.io.IONodes;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.frame.PFrame;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.lib.PyObjectCallMethodObjArgs;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonVarargsBuiltinNode;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.PythonContextFactory;
import com.oracle.graal.python.runtime.exception.ExceptionUtils;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import java.util.List;

@CoreFunctions(defineModule="atexit")
public final class AtexitModuleBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return AtexitModuleBuiltinsFactory.getFactories();
    }

    @Builtin(name="_run_exitfuncs")
    @GenerateNodeFactory
    static abstract class RunExitfuncsNode
    extends PythonBuiltinNode {
        RunExitfuncsNode() {
        }

        @Specialization
        Object run() {
            this.getContext().runAtexitHooks();
            return PNone.NONE;
        }
    }

    @Builtin(name="_ncallbacks")
    @GenerateNodeFactory
    static abstract class NCallbacksNode
    extends PythonBuiltinNode {
        NCallbacksNode() {
        }

        @Specialization
        int get() {
            return this.getContext().getAtexitHookCount();
        }
    }

    @Builtin(name="_clear")
    @GenerateNodeFactory
    static abstract class ClearNode
    extends PythonBuiltinNode {
        ClearNode() {
        }

        @Specialization
        Object clear() {
            this.getContext().clearAtexitHooks();
            return PNone.NONE;
        }
    }

    @Builtin(name="unregister", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class UnregisterNode
    extends PythonUnaryBuiltinNode {
        UnregisterNode() {
        }

        @Specialization
        Object register(Object callable) {
            this.getContext().unregisterAtexitHook(callable);
            return PNone.NONE;
        }
    }

    @Builtin(name="register", minNumOfPositionalArgs=1, takesVarArgs=true, takesVarKeywordArgs=true)
    @GenerateNodeFactory
    static abstract class RegisterNode
    extends PythonVarargsBuiltinNode {
        RegisterNode() {
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        static Object register(Object callable, Object[] arguments, PKeyword[] keywords) {
            PythonContext context = PythonContext.get(null);
            RootCallTarget callTarget = context.getLanguage().createCachedCallTarget(AtExitRootNode::new, AtExitRootNode.class);
            context.registerAtexitHook(callable, arguments, keywords, (CallTarget)callTarget);
            return callable;
        }

        private static class AtExitRootNode
        extends RootNode {
            @Node.Child
            private CallNode callNode = CallNode.create();
            @Node.Child
            private PythonContext.GetThreadStateNode getThreadStateNode = PythonContextFactory.GetThreadStateNodeGen.create();

            protected AtExitRootNode(TruffleLanguage<?> language) {
                super(language);
            }

            public Object execute(VirtualFrame frame) {
                PythonContext context = PythonContext.get((Node)this);
                this.getThreadStateNode.setTopFrameInfoCached(context, PFrame.Reference.EMPTY);
                this.getThreadStateNode.executeCached(context).setCaughtException(PException.NO_EXCEPTION);
                Object callable = frame.getArguments()[0];
                Object[] arguments = (Object[])frame.getArguments()[1];
                PKeyword[] keywords = (PKeyword[])frame.getArguments()[2];
                try {
                    Object object = this.callNode.execute((Frame)null, callable, arguments, keywords);
                    return object;
                }
                catch (PException e) {
                    AtExitRootNode.handleException(context, e);
                    throw e;
                }
                finally {
                    this.getThreadStateNode.clearTopFrameInfoCached(context);
                    this.getThreadStateNode.executeCached(context).setCaughtException(null);
                }
            }

            @CompilerDirectives.TruffleBoundary
            private static void handleException(PythonContext context, PException e) {
                Object pythonException = e.getEscapedException();
                if (!BuiltinClassProfiles.IsBuiltinClassProfile.profileClassSlowPath(GetClassNode.executeUncached(pythonException), PythonBuiltinClassType.SystemExit)) {
                    PyObjectCallMethodObjArgs callWrite = PyObjectCallMethodObjArgs.getUncached();
                    callWrite.execute(null, null, context.getStderr(), IONodes.T_WRITE, PythonUtils.toTruffleStringUncached("Error in atexit._run_exitfuncs:\n"));
                    try {
                        ExceptionUtils.printExceptionTraceback(context, pythonException);
                    }
                    catch (PException pe) {
                        callWrite.execute(null, null, context.getStderr(), IONodes.T_WRITE, PythonUtils.toTruffleStringUncached("Failed to print traceback\n"));
                    }
                }
            }
        }
    }
}

