/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins.temporal;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.temporal.JSTemporalBuiltinOperation;
import com.oracle.truffle.js.builtins.temporal.TemporalPlainDateTimeFunctionBuiltinsFactory;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.temporal.ToTemporalDateTimeNode;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateTime;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateTimeObject;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.TemporalUtil;

public class TemporalPlainDateTimeFunctionBuiltins
extends JSBuiltinsContainer.SwitchEnum<TemporalPlainDateTimeFunction> {
    public static final JSBuiltinsContainer BUILTINS = new TemporalPlainDateTimeFunctionBuiltins();

    protected TemporalPlainDateTimeFunctionBuiltins() {
        super(JSTemporalPlainDateTime.CLASS_NAME, TemporalPlainDateTimeFunction.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, TemporalPlainDateTimeFunction builtinEnum) {
        switch (builtinEnum.ordinal()) {
            case 0: {
                return TemporalPlainDateTimeFunctionBuiltinsFactory.JSTemporalPlainDateTimeFromNodeGen.create(context, builtin, TemporalPlainDateTimeFunctionBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
            case 1: {
                return TemporalPlainDateTimeFunctionBuiltinsFactory.JSTemporalPlainDateTimeCompareNodeGen.create(context, builtin, TemporalPlainDateTimeFunctionBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
        }
        return null;
    }

    public static enum TemporalPlainDateTimeFunction implements BuiltinEnum<TemporalPlainDateTimeFunction>
    {
        from(1),
        compare(2);

        private final int length;

        private TemporalPlainDateTimeFunction(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }
    }

    public static abstract class JSTemporalPlainDateTimeFromNode
    extends JSTemporalBuiltinOperation {
        public JSTemporalPlainDateTimeFromNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected JSTemporalPlainDateTimeObject from(Object item, Object options, @Cached ToTemporalDateTimeNode toTemporalDateTime) {
            return toTemporalDateTime.execute(item, options);
        }
    }

    public static abstract class JSTemporalPlainDateTimeCompareNode
    extends JSTemporalBuiltinOperation {
        public JSTemporalPlainDateTimeCompareNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected int compare(Object obj1, Object obj2, @Cached ToTemporalDateTimeNode toTemporalDateTime) {
            JSTemporalPlainDateTimeObject one = toTemporalDateTime.execute(obj1, (Object)Undefined.instance);
            JSTemporalPlainDateTimeObject two = toTemporalDateTime.execute(obj2, (Object)Undefined.instance);
            return TemporalUtil.compareISODateTime(one.getYear(), one.getMonth(), one.getDay(), one.getHour(), one.getMinute(), one.getSecond(), one.getMillisecond(), one.getMicrosecond(), one.getNanosecond(), two.getYear(), two.getMonth(), two.getDay(), two.getHour(), two.getMinute(), two.getSecond(), two.getMillisecond(), two.getMicrosecond(), two.getNanosecond());
        }
    }
}

