/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.wasm;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.runtime.BigInt;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSConfig;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.builtins.wasm.JSWebAssemblyInstance;
import com.oracle.truffle.js.runtime.objects.Null;

@ImportStatic(value={JSConfig.class})
@GenerateUncached
public abstract class ToJSValueNode
extends JavaScriptBaseNode {
    protected ToJSValueNode() {
    }

    public abstract Object execute(Object var1);

    @Specialization
    static int i32(int value) {
        return value;
    }

    @Specialization
    static BigInt i64(long value) {
        return BigInt.valueOf(value);
    }

    @Specialization
    static double f32(float value) {
        return value;
    }

    @Specialization
    static double f64(double value) {
        return value;
    }

    @Fallback
    final Object convert(Object value, @CachedLibrary(limit="InteropLibraryLimit") InteropLibrary isFuncLib, @CachedLibrary(limit="InteropLibraryLimit") InteropLibrary funcTypeLib, @CachedLibrary(limit="InteropLibraryLimit") InteropLibrary asTStringLib, @Cached TruffleString.SwitchEncodingNode switchEncoding) {
        JSRealm realm = this.getRealm();
        Object refNull = realm.getWasmRefNull();
        if (value == refNull) {
            return Null.instance;
        }
        Object isFuncFn = realm.getWASMIsFunc();
        try {
            Object isFunc = isFuncLib.execute(isFuncFn, new Object[]{value});
            if (isFunc instanceof Boolean && ((Boolean)isFunc).booleanValue()) {
                Object funcTypeFn = realm.getWASMFuncType();
                TruffleString funcType = Strings.interopAsTruffleString(funcTypeLib.execute(funcTypeFn, new Object[]{value}), asTStringLib, switchEncoding);
                return JSWebAssemblyInstance.exportFunction(realm.getContext(), realm, value, funcType);
            }
            return value;
        }
        catch (InteropException ex) {
            throw Errors.shouldNotReachHere(ex);
        }
    }
}

