/*=========================================================================
*
*  Copyright NumFOCUS
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkFastMarchingBaseImageFilter_h
#define sitkFastMarchingBaseImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk::simple {

    /**\class FastMarchingBaseImageFilter
\brief Apply the Fast Marching method to solve an Eikonal equation on an image.

The speed function can be specified as a speed image or a speed constant. The speed image is set using the method SetInput(). If the speed image is nullptr, a constant speed function is used and is specified using method the SetSpeedConstant() .

If the speed function is constant and of value one, fast marching results is an approximate distance function from the initial alive points.

There are two ways to specify the output image information (LargestPossibleRegion, Spacing, Origin): 

\li it is copied directly from the input speed image 


\li it is specified by the user. Default values are used if the user does not specify all the information.



The output information is computed as follows.

If the speed image is nullptr or if the OverrideOutputInformation is set to true, the output information is set from user specified parameters. These parameters can be specified using methods 

\li FastMarchingImageFilterBase::SetOutputRegion() , 


\li FastMarchingImageFilterBase::SetOutputSpacing() , 


\li FastMarchingImageFilterBase::SetOutputDirection() , 


\li FastMarchingImageFilterBase::SetOutputOrigin() .



Else the output information is copied from the input speed image.

Implementation of this class is based on Chapter 8 of "Level Set Methods and Fast Marching Methods", J.A. Sethian, Cambridge Press, Second edition, 1999.

For an alternative implementation, see itk::FastMarchingImageFilter .



TTraits

traits



\see FastMarchingImageFilter 


\see ImageFastMarchingTraits 


\see ImageFastMarchingTraits2
\sa itk::simple::FastMarchingBase for the procedural interface
\sa itk::FastMarchingImageFilterBase for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT FastMarchingBaseImageFilter : public ImageFilter {
    public:
      using Self = FastMarchingBaseImageFilter;

      /** Destructor */
      virtual ~FastMarchingBaseImageFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      FastMarchingBaseImageFilter();

      /** Define the pixels types supported by this filter */
      using PixelIDTypeList = BasicPixelIDTypeList;
\

      /**
       * Set the container of Trial Points representing the initial front. Trial points are represented as a VectorContainer of LevelSetNodes.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetTrialPoints ( std::vector< std::vector<unsigned int> > TrialPoints ) { this->m_TrialPoints = std::move(TrialPoints); return *this; }

      /**
       * Get the container of Trial Points representing the initial front.
       */
      std::vector< std::vector< unsigned int > > GetTrialPoints() const { return this->m_TrialPoints; }
      /** \brief Add TrialPoints point */
      SITK_RETURN_SELF_TYPE_HEADER AddTrialPoint( std::vector< unsigned int > point ) { this->m_TrialPoints.push_back(std::move(point)); return *this;}
      /** \brief Remove all TrialPoints points */
      SITK_RETURN_SELF_TYPE_HEADER ClearTrialPoints( ) { this->m_TrialPoints.clear(); return *this;}
\

      /**
       * Set/Get the Normalization Factor for the Speed Image . The values in the Speed Image is divided by this factor. This allows the use of images with integer pixel types to represent the speed.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetNormalizationFactor ( double NormalizationFactor ) { this->m_NormalizationFactor = NormalizationFactor; return *this; }

      /**
       * Set/Get the Normalization Factor for the Speed Image . The values in the Speed Image is divided by this factor. This allows the use of images with integer pixel types to represent the speed.
       */
      double GetNormalizationFactor() const { return this->m_NormalizationFactor; }\

      /**
       * Set the Fast Marching algorithm Stopping Value. The Fast Marching algorithm is terminated when the value of the smallest trial point is greater than the stopping value.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetStoppingValue ( double StoppingValue ) { this->m_StoppingValue = StoppingValue; return *this; }

      /**
       * Get the Fast Marching algorithm Stopping Value.
       */
      double GetStoppingValue() const { return this->m_StoppingValue; }

      typedef enum {Nothing,NoHandles,Strict} TopologyCheckType;\

      /**
       */
      SITK_RETURN_SELF_TYPE_HEADER SetTopologyCheck ( TopologyCheckType TopologyCheck ) { this->m_TopologyCheck = TopologyCheck; return *this; }

      /**
       */
      TopologyCheckType GetTopologyCheck() const { return this->m_TopologyCheck; }\

      /**
       * \brief Set the initial seed values for corresponding trial point.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetInitialTrialValues ( std::vector<double> InitialTrialValues ) { this->m_InitialTrialValues = InitialTrialValues; return *this; }

      /**
       */
      std::vector<double> GetInitialTrialValues() const { return this->m_InitialTrialValues; }

      /** Name of this class */
      std::string GetName() const { return std::string ("FastMarchingBaseImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input image */

      Image Execute ( const Image& image1 );

    private:

      /** Setup for member function dispatching */

      using MemberFunctionType = Image (Self::*)( const Image& image1 );
      template <class TImageType> Image ExecuteInternal ( const Image& image1 );


      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;

      std::unique_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;


      std::vector< std::vector<unsigned int> >  m_TrialPoints{std::vector< std::vector<unsigned int > >()};

      double  m_NormalizationFactor{1.0};

      double  m_StoppingValue{std::numeric_limits<float>::max()/2.0};

      /*  */
      TopologyCheckType  m_TopologyCheck{itk::simple::FastMarchingBaseImageFilter::Nothing};

      std::vector<double>  m_InitialTrialValues{std::vector<double>()};


    };

    /**\
     * \brief Apply the Fast Marching method to solve an Eikonal equation on an image.
     *
     * This function directly calls the execute method of FastMarchingBaseImageFilter
     * in order to support a procedural API
     *
     * \sa itk::simple::FastMarchingBaseImageFilter for the object oriented interface
     * @{
     */

     SITKBasicFilters_EXPORT Image FastMarchingBase ( const Image& image1, std::vector< std::vector<unsigned int> > trialPoints = std::vector< std::vector<unsigned int > >(), double normalizationFactor = 1.0, double stoppingValue = std::numeric_limits<float>::max()/2.0, FastMarchingBaseImageFilter::TopologyCheckType topologyCheck = itk::simple::FastMarchingBaseImageFilter::Nothing, std::vector<double> initialTrialValues = std::vector<double>() );

     /** @} */
}
#endif
