// Automatically generated file. DO NOT EDIT.
// Generated by gen-device-svd.go from ATSAML22G18A.svd, see https://github.com/posborne/cmsis-svd/tree/master/data/Atmel

//go:build sam && atsaml22g18a

/*
// Microchip ATSAML22G18A device: Cortex-M0+ Microcontroller with 256KB Flash, 32KB SRAM, 49-pin package
*/
//     Copyright (c) 2018 Microchip Technology Inc.
//
//     SPDX-License-Identifier: Apache-2.0
//
//     Licensed under the Apache License, Version 2.0 (the "License");
//     you may not use this file except in compliance with the License.
//     You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
//     Unless required by applicable law or agreed to in writing, software
//     distributed under the License is distributed on an "AS IS" BASIS,
//     WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//     See the License for the specific language governing permissions and
//     limitations under the License.
package sam

import (
	"runtime/volatile"
	"unsafe"
)

// Some information about this device.
const (
	Device       = "ATSAML22G18A"
	CPU          = "CM0+"
	FPUPresent   = false
	NVICPrioBits = 2
)

// Interrupt numbers.
const (
	// Main Clock // Oscillators Control // 32k Oscillators Control // Peripheral Access Controller // Power Manager // Supply Controller
	IRQ_SYSTEM = 0

	// Watchdog Timer
	IRQ_WDT = 1

	// Real-Time Counter
	IRQ_RTC = 2

	// External Interrupt Controller
	IRQ_EIC = 3

	// Frequency Meter
	IRQ_FREQM = 4

	// Universal Serial Bus
	IRQ_USB = 5

	// Non-Volatile Memory Controller
	IRQ_NVMCTRL = 6

	// Direct Memory Access Controller
	IRQ_DMAC = 7

	// Event System Interface
	IRQ_EVSYS = 8

	// Serial Communication Interface 0
	IRQ_SERCOM0 = 9

	// Serial Communication Interface 1
	IRQ_SERCOM1 = 10

	// Serial Communication Interface 2
	IRQ_SERCOM2 = 11

	// Serial Communication Interface 3
	IRQ_SERCOM3 = 12

	// Timer Counter Control
	IRQ_TCC0 = 15

	// Basic Timer Counter 0
	IRQ_TC0 = 16

	// Basic Timer Counter 1
	IRQ_TC1 = 17

	// Basic Timer Counter 2
	IRQ_TC2 = 18

	// Basic Timer Counter 3
	IRQ_TC3 = 19

	// Analog Digital Converter
	IRQ_ADC = 20

	// Analog Comparators
	IRQ_AC = 21

	// Segment Liquid Crystal Display Controller
	IRQ_SLCD = 23

	// Advanced Encryption Standard
	IRQ_AES = 24

	// True Random Generator
	IRQ_TRNG = 25

	// Highest interrupt number on this device.
	IRQ_max = 25
)

// Pseudo function call that is replaced by the compiler with the actual
// functions registered through interrupt.New.
//
//go:linkname callHandlers runtime/interrupt.callHandlers
func callHandlers(num int)

//export SYSTEM_IRQHandler
func interruptSYSTEM() {
	callHandlers(IRQ_SYSTEM)
}

//export WDT_IRQHandler
func interruptWDT() {
	callHandlers(IRQ_WDT)
}

//export RTC_IRQHandler
func interruptRTC() {
	callHandlers(IRQ_RTC)
}

//export EIC_IRQHandler
func interruptEIC() {
	callHandlers(IRQ_EIC)
}

//export FREQM_IRQHandler
func interruptFREQM() {
	callHandlers(IRQ_FREQM)
}

//export USB_IRQHandler
func interruptUSB() {
	callHandlers(IRQ_USB)
}

//export NVMCTRL_IRQHandler
func interruptNVMCTRL() {
	callHandlers(IRQ_NVMCTRL)
}

//export DMAC_IRQHandler
func interruptDMAC() {
	callHandlers(IRQ_DMAC)
}

//export EVSYS_IRQHandler
func interruptEVSYS() {
	callHandlers(IRQ_EVSYS)
}

//export SERCOM0_IRQHandler
func interruptSERCOM0() {
	callHandlers(IRQ_SERCOM0)
}

//export SERCOM1_IRQHandler
func interruptSERCOM1() {
	callHandlers(IRQ_SERCOM1)
}

//export SERCOM2_IRQHandler
func interruptSERCOM2() {
	callHandlers(IRQ_SERCOM2)
}

//export SERCOM3_IRQHandler
func interruptSERCOM3() {
	callHandlers(IRQ_SERCOM3)
}

//export TCC0_IRQHandler
func interruptTCC0() {
	callHandlers(IRQ_TCC0)
}

//export TC0_IRQHandler
func interruptTC0() {
	callHandlers(IRQ_TC0)
}

//export TC1_IRQHandler
func interruptTC1() {
	callHandlers(IRQ_TC1)
}

//export TC2_IRQHandler
func interruptTC2() {
	callHandlers(IRQ_TC2)
}

//export TC3_IRQHandler
func interruptTC3() {
	callHandlers(IRQ_TC3)
}

//export ADC_IRQHandler
func interruptADC() {
	callHandlers(IRQ_ADC)
}

//export AC_IRQHandler
func interruptAC() {
	callHandlers(IRQ_AC)
}

//export SLCD_IRQHandler
func interruptSLCD() {
	callHandlers(IRQ_SLCD)
}

//export AES_IRQHandler
func interruptAES() {
	callHandlers(IRQ_AES)
}

//export TRNG_IRQHandler
func interruptTRNG() {
	callHandlers(IRQ_TRNG)
}

// Peripherals.
var (
	// Analog Comparators
	AC = (*AC_Type)(unsafe.Pointer(uintptr(0x42003400)))

	// Analog Digital Converter
	ADC = (*ADC_Type)(unsafe.Pointer(uintptr(0x42003000)))

	// Advanced Encryption Standard
	AES = (*AES_Type)(unsafe.Pointer(uintptr(0x42004000)))

	// Configurable Custom Logic
	CCL = (*CCL_Type)(unsafe.Pointer(uintptr(0x42004800)))

	// Direct Memory Access Controller
	DMAC = (*DMAC_Type)(unsafe.Pointer(uintptr(0x41008000)))

	// Device Service Unit
	DSU = (*DSU_Type)(unsafe.Pointer(uintptr(0x41002000)))

	// External Interrupt Controller
	EIC = (*EIC_Type)(unsafe.Pointer(uintptr(0x40002800)))

	// Event System Interface
	EVSYS = (*EVSYS_Type)(unsafe.Pointer(uintptr(0x42000000)))

	// Frequency Meter
	FREQM = (*FREQM_Type)(unsafe.Pointer(uintptr(0x40002c00)))

	// Generic Clock Generator
	GCLK = (*GCLK_Type)(unsafe.Pointer(uintptr(0x40001c00)))

	// Main Clock
	MCLK = (*MCLK_Type)(unsafe.Pointer(uintptr(0x40000800)))

	// Cortex-M0+ Micro-Trace Buffer
	MTB = (*MTB_Type)(unsafe.Pointer(uintptr(0x4100a000)))

	// Non-Volatile Memory Controller
	NVMCTRL = (*NVMCTRL_Type)(unsafe.Pointer(uintptr(0x41004000)))

	// Oscillators Control
	OSCCTRL = (*OSCCTRL_Type)(unsafe.Pointer(uintptr(0x40001000)))

	// 32k Oscillators Control
	OSC32KCTRL = (*OSC32KCTRL_Type)(unsafe.Pointer(uintptr(0x40001400)))

	// Peripheral Access Controller
	PAC = (*PAC_Type)(unsafe.Pointer(uintptr(0x40000000)))

	// Power Manager
	PM = (*PM_Type)(unsafe.Pointer(uintptr(0x40000400)))

	// Port Module
	PORT = (*PORT_Type)(unsafe.Pointer(uintptr(0x41006000)))

	// Port Module (IOBUS)
	PORT_IOBUS = (*PORT_Type)(unsafe.Pointer(uintptr(0x60000000)))

	// Reset Controller
	RSTC = (*RSTC_Type)(unsafe.Pointer(uintptr(0x40000c00)))

	// Real-Time Counter
	RTC = (*RTC_Type)(unsafe.Pointer(uintptr(0x40002400)))

	// Real-Time Counter - MODE0
	RTC_MODE0 = (*RTC_MODE0_Type)(unsafe.Pointer(uintptr(0x40002400)))

	// Real-Time Counter - MODE1
	RTC_MODE1 = (*RTC_MODE1_Type)(unsafe.Pointer(uintptr(0x40002400)))

	// Real-Time Counter - MODE2
	RTC_MODE2 = (*RTC_MODE2_Type)(unsafe.Pointer(uintptr(0x40002400)))

	// Serial Communication Interface 0
	SERCOM0 = (*SERCOM_Type)(unsafe.Pointer(uintptr(0x42000400)))

	// Serial Communication Interface 0 - I2CM
	SERCOM0_I2CM = (*SERCOM_I2CM_Type)(unsafe.Pointer(uintptr(0x42000400)))

	// Serial Communication Interface 0 - I2CS
	SERCOM0_I2CS = (*SERCOM_I2CS_Type)(unsafe.Pointer(uintptr(0x42000400)))

	// Serial Communication Interface 0 - SPI
	SERCOM0_SPI = (*SERCOM_SPI_Type)(unsafe.Pointer(uintptr(0x42000400)))

	// Serial Communication Interface 0 - USART
	SERCOM0_USART = (*SERCOM_USART_Type)(unsafe.Pointer(uintptr(0x42000400)))

	// Segment Liquid Crystal Display Controller
	SLCD = (*SLCD_Type)(unsafe.Pointer(uintptr(0x42003c00)))

	// Supply Controller
	SUPC = (*SUPC_Type)(unsafe.Pointer(uintptr(0x40001800)))

	// Basic Timer Counter 0
	TC0 = (*TC_Type)(unsafe.Pointer(uintptr(0x42002000)))

	// Basic Timer Counter 0 - COUNT8
	TC0_COUNT8 = (*TC_COUNT8_Type)(unsafe.Pointer(uintptr(0x42002000)))

	// Basic Timer Counter 0 - COUNT16
	TC0_COUNT16 = (*TC_COUNT16_Type)(unsafe.Pointer(uintptr(0x42002000)))

	// Basic Timer Counter 0 - COUNT32
	TC0_COUNT32 = (*TC_COUNT32_Type)(unsafe.Pointer(uintptr(0x42002000)))

	// Timer Counter Control
	TCC0 = (*TCC_Type)(unsafe.Pointer(uintptr(0x42001c00)))

	// True Random Generator
	TRNG = (*TRNG_Type)(unsafe.Pointer(uintptr(0x42004400)))

	// Universal Serial Bus
	USB = (*USB_Type)(unsafe.Pointer(uintptr(0x41000000)))

	// Universal Serial Bus - DEVICE
	USB_DEVICE = (*USB_DEVICE_Type)(unsafe.Pointer(uintptr(0x41000000)))

	// Watchdog Timer
	WDT = (*WDT_Type)(unsafe.Pointer(uintptr(0x40002000)))

	// Serial Communication Interface 1
	SERCOM1 = (*SERCOM_Type)(unsafe.Pointer(uintptr(0x42000800)))

	// Serial Communication Interface 0 - I2CM
	SERCOM1_I2CM = (*SERCOM_I2CM_Type)(unsafe.Pointer(uintptr(0x42000800)))

	// Serial Communication Interface 0 - I2CS
	SERCOM1_I2CS = (*SERCOM_I2CS_Type)(unsafe.Pointer(uintptr(0x42000800)))

	// Serial Communication Interface 0 - SPI
	SERCOM1_SPI = (*SERCOM_SPI_Type)(unsafe.Pointer(uintptr(0x42000800)))

	// Serial Communication Interface 0 - USART
	SERCOM1_USART = (*SERCOM_USART_Type)(unsafe.Pointer(uintptr(0x42000800)))

	// Serial Communication Interface 2
	SERCOM2 = (*SERCOM_Type)(unsafe.Pointer(uintptr(0x42000c00)))

	// Serial Communication Interface 0 - I2CM
	SERCOM2_I2CM = (*SERCOM_I2CM_Type)(unsafe.Pointer(uintptr(0x42000c00)))

	// Serial Communication Interface 0 - I2CS
	SERCOM2_I2CS = (*SERCOM_I2CS_Type)(unsafe.Pointer(uintptr(0x42000c00)))

	// Serial Communication Interface 0 - SPI
	SERCOM2_SPI = (*SERCOM_SPI_Type)(unsafe.Pointer(uintptr(0x42000c00)))

	// Serial Communication Interface 0 - USART
	SERCOM2_USART = (*SERCOM_USART_Type)(unsafe.Pointer(uintptr(0x42000c00)))

	// Serial Communication Interface 3
	SERCOM3 = (*SERCOM_Type)(unsafe.Pointer(uintptr(0x42001000)))

	// Serial Communication Interface 0 - I2CM
	SERCOM3_I2CM = (*SERCOM_I2CM_Type)(unsafe.Pointer(uintptr(0x42001000)))

	// Serial Communication Interface 0 - I2CS
	SERCOM3_I2CS = (*SERCOM_I2CS_Type)(unsafe.Pointer(uintptr(0x42001000)))

	// Serial Communication Interface 0 - SPI
	SERCOM3_SPI = (*SERCOM_SPI_Type)(unsafe.Pointer(uintptr(0x42001000)))

	// Serial Communication Interface 0 - USART
	SERCOM3_USART = (*SERCOM_USART_Type)(unsafe.Pointer(uintptr(0x42001000)))

	// Basic Timer Counter 1
	TC1 = (*TC_Type)(unsafe.Pointer(uintptr(0x42002400)))

	// Basic Timer Counter 0 - COUNT8
	TC1_COUNT8 = (*TC_COUNT8_Type)(unsafe.Pointer(uintptr(0x42002400)))

	// Basic Timer Counter 0 - COUNT16
	TC1_COUNT16 = (*TC_COUNT16_Type)(unsafe.Pointer(uintptr(0x42002400)))

	// Basic Timer Counter 0 - COUNT32
	TC1_COUNT32 = (*TC_COUNT32_Type)(unsafe.Pointer(uintptr(0x42002400)))

	// Basic Timer Counter 2
	TC2 = (*TC_Type)(unsafe.Pointer(uintptr(0x42002800)))

	// Basic Timer Counter 0 - COUNT8
	TC2_COUNT8 = (*TC_COUNT8_Type)(unsafe.Pointer(uintptr(0x42002800)))

	// Basic Timer Counter 0 - COUNT16
	TC2_COUNT16 = (*TC_COUNT16_Type)(unsafe.Pointer(uintptr(0x42002800)))

	// Basic Timer Counter 0 - COUNT32
	TC2_COUNT32 = (*TC_COUNT32_Type)(unsafe.Pointer(uintptr(0x42002800)))

	// Basic Timer Counter 3
	TC3 = (*TC_Type)(unsafe.Pointer(uintptr(0x42002c00)))

	// Basic Timer Counter 0 - COUNT8
	TC3_COUNT8 = (*TC_COUNT8_Type)(unsafe.Pointer(uintptr(0x42002c00)))

	// Basic Timer Counter 0 - COUNT16
	TC3_COUNT16 = (*TC_COUNT16_Type)(unsafe.Pointer(uintptr(0x42002c00)))

	// Basic Timer Counter 0 - COUNT32
	TC3_COUNT32 = (*TC_COUNT32_Type)(unsafe.Pointer(uintptr(0x42002c00)))
)

// Analog Comparators
type AC_Type struct {
	CTRLA     volatile.Register8  // 0x0
	CTRLB     volatile.Register8  // 0x1
	EVCTRL    volatile.Register16 // 0x2
	INTENCLR  volatile.Register8  // 0x4
	INTENSET  volatile.Register8  // 0x5
	INTFLAG   volatile.Register8  // 0x6
	STATUSA   volatile.Register8  // 0x7
	STATUSB   volatile.Register8  // 0x8
	DBGCTRL   volatile.Register8  // 0x9
	WINCTRL   volatile.Register8  // 0xA
	_         byte
	SCALER0   volatile.Register8 // 0xC
	SCALER1   volatile.Register8 // 0xD
	_         [2]byte
	COMPCTRL0 volatile.Register32 // 0x10
	COMPCTRL1 volatile.Register32 // 0x14
	_         [8]byte
	SYNCBUSY  volatile.Register32 // 0x20
}

// AC.CTRLA: Control A
func (o *AC_Type) SetCTRLA_SWRST(value uint8) {
	volatile.StoreUint8(&o.CTRLA.Reg, volatile.LoadUint8(&o.CTRLA.Reg)&^(0x1)|value)
}
func (o *AC_Type) GetCTRLA_SWRST() uint8 {
	return volatile.LoadUint8(&o.CTRLA.Reg) & 0x1
}
func (o *AC_Type) SetCTRLA_ENABLE(value uint8) {
	volatile.StoreUint8(&o.CTRLA.Reg, volatile.LoadUint8(&o.CTRLA.Reg)&^(0x2)|value<<1)
}
func (o *AC_Type) GetCTRLA_ENABLE() uint8 {
	return (volatile.LoadUint8(&o.CTRLA.Reg) & 0x2) >> 1
}

// AC.CTRLB: Control B
func (o *AC_Type) SetCTRLB_START0(value uint8) {
	volatile.StoreUint8(&o.CTRLB.Reg, volatile.LoadUint8(&o.CTRLB.Reg)&^(0x1)|value)
}
func (o *AC_Type) GetCTRLB_START0() uint8 {
	return volatile.LoadUint8(&o.CTRLB.Reg) & 0x1
}
func (o *AC_Type) SetCTRLB_START1(value uint8) {
	volatile.StoreUint8(&o.CTRLB.Reg, volatile.LoadUint8(&o.CTRLB.Reg)&^(0x2)|value<<1)
}
func (o *AC_Type) GetCTRLB_START1() uint8 {
	return (volatile.LoadUint8(&o.CTRLB.Reg) & 0x2) >> 1
}

// AC.EVCTRL: Event Control
func (o *AC_Type) SetEVCTRL_COMPEO0(value uint16) {
	volatile.StoreUint16(&o.EVCTRL.Reg, volatile.LoadUint16(&o.EVCTRL.Reg)&^(0x1)|value)
}
func (o *AC_Type) GetEVCTRL_COMPEO0() uint16 {
	return volatile.LoadUint16(&o.EVCTRL.Reg) & 0x1
}
func (o *AC_Type) SetEVCTRL_COMPEO1(value uint16) {
	volatile.StoreUint16(&o.EVCTRL.Reg, volatile.LoadUint16(&o.EVCTRL.Reg)&^(0x2)|value<<1)
}
func (o *AC_Type) GetEVCTRL_COMPEO1() uint16 {
	return (volatile.LoadUint16(&o.EVCTRL.Reg) & 0x2) >> 1
}
func (o *AC_Type) SetEVCTRL_WINEO0(value uint16) {
	volatile.StoreUint16(&o.EVCTRL.Reg, volatile.LoadUint16(&o.EVCTRL.Reg)&^(0x10)|value<<4)
}
func (o *AC_Type) GetEVCTRL_WINEO0() uint16 {
	return (volatile.LoadUint16(&o.EVCTRL.Reg) & 0x10) >> 4
}
func (o *AC_Type) SetEVCTRL_COMPEI0(value uint16) {
	volatile.StoreUint16(&o.EVCTRL.Reg, volatile.LoadUint16(&o.EVCTRL.Reg)&^(0x100)|value<<8)
}
func (o *AC_Type) GetEVCTRL_COMPEI0() uint16 {
	return (volatile.LoadUint16(&o.EVCTRL.Reg) & 0x100) >> 8
}
func (o *AC_Type) SetEVCTRL_COMPEI1(value uint16) {
	volatile.StoreUint16(&o.EVCTRL.Reg, volatile.LoadUint16(&o.EVCTRL.Reg)&^(0x200)|value<<9)
}
func (o *AC_Type) GetEVCTRL_COMPEI1() uint16 {
	return (volatile.LoadUint16(&o.EVCTRL.Reg) & 0x200) >> 9
}
func (o *AC_Type) SetEVCTRL_INVEI0(value uint16) {
	volatile.StoreUint16(&o.EVCTRL.Reg, volatile.LoadUint16(&o.EVCTRL.Reg)&^(0x1000)|value<<12)
}
func (o *AC_Type) GetEVCTRL_INVEI0() uint16 {
	return (volatile.LoadUint16(&o.EVCTRL.Reg) & 0x1000) >> 12
}
func (o *AC_Type) SetEVCTRL_INVEI1(value uint16) {
	volatile.StoreUint16(&o.EVCTRL.Reg, volatile.LoadUint16(&o.EVCTRL.Reg)&^(0x2000)|value<<13)
}
func (o *AC_Type) GetEVCTRL_INVEI1() uint16 {
	return (volatile.LoadUint16(&o.EVCTRL.Reg) & 0x2000) >> 13
}

// AC.INTENCLR: Interrupt Enable Clear
func (o *AC_Type) SetINTENCLR_COMP0(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *AC_Type) GetINTENCLR_COMP0() uint8 {
	return volatile.LoadUint8(&o.INTENCLR.Reg) & 0x1
}
func (o *AC_Type) SetINTENCLR_COMP1(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *AC_Type) GetINTENCLR_COMP1() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *AC_Type) SetINTENCLR_WIN0(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x10)|value<<4)
}
func (o *AC_Type) GetINTENCLR_WIN0() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x10) >> 4
}

// AC.INTENSET: Interrupt Enable Set
func (o *AC_Type) SetINTENSET_COMP0(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *AC_Type) GetINTENSET_COMP0() uint8 {
	return volatile.LoadUint8(&o.INTENSET.Reg) & 0x1
}
func (o *AC_Type) SetINTENSET_COMP1(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *AC_Type) GetINTENSET_COMP1() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *AC_Type) SetINTENSET_WIN0(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x10)|value<<4)
}
func (o *AC_Type) GetINTENSET_WIN0() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x10) >> 4
}

// AC.INTFLAG: Interrupt Flag Status and Clear
func (o *AC_Type) SetINTFLAG_COMP0(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x1)|value)
}
func (o *AC_Type) GetINTFLAG_COMP0() uint8 {
	return volatile.LoadUint8(&o.INTFLAG.Reg) & 0x1
}
func (o *AC_Type) SetINTFLAG_COMP1(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x2)|value<<1)
}
func (o *AC_Type) GetINTFLAG_COMP1() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x2) >> 1
}
func (o *AC_Type) SetINTFLAG_WIN0(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x10)|value<<4)
}
func (o *AC_Type) GetINTFLAG_WIN0() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x10) >> 4
}

// AC.STATUSA: Status A
func (o *AC_Type) SetSTATUSA_STATE0(value uint8) {
	volatile.StoreUint8(&o.STATUSA.Reg, volatile.LoadUint8(&o.STATUSA.Reg)&^(0x1)|value)
}
func (o *AC_Type) GetSTATUSA_STATE0() uint8 {
	return volatile.LoadUint8(&o.STATUSA.Reg) & 0x1
}
func (o *AC_Type) SetSTATUSA_STATE1(value uint8) {
	volatile.StoreUint8(&o.STATUSA.Reg, volatile.LoadUint8(&o.STATUSA.Reg)&^(0x2)|value<<1)
}
func (o *AC_Type) GetSTATUSA_STATE1() uint8 {
	return (volatile.LoadUint8(&o.STATUSA.Reg) & 0x2) >> 1
}
func (o *AC_Type) SetSTATUSA_WSTATE0(value uint8) {
	volatile.StoreUint8(&o.STATUSA.Reg, volatile.LoadUint8(&o.STATUSA.Reg)&^(0x30)|value<<4)
}
func (o *AC_Type) GetSTATUSA_WSTATE0() uint8 {
	return (volatile.LoadUint8(&o.STATUSA.Reg) & 0x30) >> 4
}

// AC.STATUSB: Status B
func (o *AC_Type) SetSTATUSB_READY0(value uint8) {
	volatile.StoreUint8(&o.STATUSB.Reg, volatile.LoadUint8(&o.STATUSB.Reg)&^(0x1)|value)
}
func (o *AC_Type) GetSTATUSB_READY0() uint8 {
	return volatile.LoadUint8(&o.STATUSB.Reg) & 0x1
}
func (o *AC_Type) SetSTATUSB_READY1(value uint8) {
	volatile.StoreUint8(&o.STATUSB.Reg, volatile.LoadUint8(&o.STATUSB.Reg)&^(0x2)|value<<1)
}
func (o *AC_Type) GetSTATUSB_READY1() uint8 {
	return (volatile.LoadUint8(&o.STATUSB.Reg) & 0x2) >> 1
}

// AC.DBGCTRL: Debug Control
func (o *AC_Type) SetDBGCTRL_DBGRUN(value uint8) {
	volatile.StoreUint8(&o.DBGCTRL.Reg, volatile.LoadUint8(&o.DBGCTRL.Reg)&^(0x1)|value)
}
func (o *AC_Type) GetDBGCTRL_DBGRUN() uint8 {
	return volatile.LoadUint8(&o.DBGCTRL.Reg) & 0x1
}

// AC.WINCTRL: Window Control
func (o *AC_Type) SetWINCTRL_WEN0(value uint8) {
	volatile.StoreUint8(&o.WINCTRL.Reg, volatile.LoadUint8(&o.WINCTRL.Reg)&^(0x1)|value)
}
func (o *AC_Type) GetWINCTRL_WEN0() uint8 {
	return volatile.LoadUint8(&o.WINCTRL.Reg) & 0x1
}
func (o *AC_Type) SetWINCTRL_WINTSEL0(value uint8) {
	volatile.StoreUint8(&o.WINCTRL.Reg, volatile.LoadUint8(&o.WINCTRL.Reg)&^(0x6)|value<<1)
}
func (o *AC_Type) GetWINCTRL_WINTSEL0() uint8 {
	return (volatile.LoadUint8(&o.WINCTRL.Reg) & 0x6) >> 1
}

// AC.SCALER0: Scaler n
func (o *AC_Type) SetSCALER0_VALUE(value uint8) {
	volatile.StoreUint8(&o.SCALER0.Reg, volatile.LoadUint8(&o.SCALER0.Reg)&^(0x3f)|value)
}
func (o *AC_Type) GetSCALER0_VALUE() uint8 {
	return volatile.LoadUint8(&o.SCALER0.Reg) & 0x3f
}

// AC.SCALER1: Scaler n
func (o *AC_Type) SetSCALER1_VALUE(value uint8) {
	volatile.StoreUint8(&o.SCALER1.Reg, volatile.LoadUint8(&o.SCALER1.Reg)&^(0x3f)|value)
}
func (o *AC_Type) GetSCALER1_VALUE() uint8 {
	return volatile.LoadUint8(&o.SCALER1.Reg) & 0x3f
}

// AC.COMPCTRL0: Comparator Control n
func (o *AC_Type) SetCOMPCTRL0_ENABLE(value uint32) {
	volatile.StoreUint32(&o.COMPCTRL0.Reg, volatile.LoadUint32(&o.COMPCTRL0.Reg)&^(0x2)|value<<1)
}
func (o *AC_Type) GetCOMPCTRL0_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.COMPCTRL0.Reg) & 0x2) >> 1
}
func (o *AC_Type) SetCOMPCTRL0_SINGLE(value uint32) {
	volatile.StoreUint32(&o.COMPCTRL0.Reg, volatile.LoadUint32(&o.COMPCTRL0.Reg)&^(0x4)|value<<2)
}
func (o *AC_Type) GetCOMPCTRL0_SINGLE() uint32 {
	return (volatile.LoadUint32(&o.COMPCTRL0.Reg) & 0x4) >> 2
}
func (o *AC_Type) SetCOMPCTRL0_INTSEL(value uint32) {
	volatile.StoreUint32(&o.COMPCTRL0.Reg, volatile.LoadUint32(&o.COMPCTRL0.Reg)&^(0x18)|value<<3)
}
func (o *AC_Type) GetCOMPCTRL0_INTSEL() uint32 {
	return (volatile.LoadUint32(&o.COMPCTRL0.Reg) & 0x18) >> 3
}
func (o *AC_Type) SetCOMPCTRL0_RUNSTDBY(value uint32) {
	volatile.StoreUint32(&o.COMPCTRL0.Reg, volatile.LoadUint32(&o.COMPCTRL0.Reg)&^(0x40)|value<<6)
}
func (o *AC_Type) GetCOMPCTRL0_RUNSTDBY() uint32 {
	return (volatile.LoadUint32(&o.COMPCTRL0.Reg) & 0x40) >> 6
}
func (o *AC_Type) SetCOMPCTRL0_MUXNEG(value uint32) {
	volatile.StoreUint32(&o.COMPCTRL0.Reg, volatile.LoadUint32(&o.COMPCTRL0.Reg)&^(0x700)|value<<8)
}
func (o *AC_Type) GetCOMPCTRL0_MUXNEG() uint32 {
	return (volatile.LoadUint32(&o.COMPCTRL0.Reg) & 0x700) >> 8
}
func (o *AC_Type) SetCOMPCTRL0_MUXPOS(value uint32) {
	volatile.StoreUint32(&o.COMPCTRL0.Reg, volatile.LoadUint32(&o.COMPCTRL0.Reg)&^(0x7000)|value<<12)
}
func (o *AC_Type) GetCOMPCTRL0_MUXPOS() uint32 {
	return (volatile.LoadUint32(&o.COMPCTRL0.Reg) & 0x7000) >> 12
}
func (o *AC_Type) SetCOMPCTRL0_SWAP(value uint32) {
	volatile.StoreUint32(&o.COMPCTRL0.Reg, volatile.LoadUint32(&o.COMPCTRL0.Reg)&^(0x8000)|value<<15)
}
func (o *AC_Type) GetCOMPCTRL0_SWAP() uint32 {
	return (volatile.LoadUint32(&o.COMPCTRL0.Reg) & 0x8000) >> 15
}
func (o *AC_Type) SetCOMPCTRL0_SPEED(value uint32) {
	volatile.StoreUint32(&o.COMPCTRL0.Reg, volatile.LoadUint32(&o.COMPCTRL0.Reg)&^(0x30000)|value<<16)
}
func (o *AC_Type) GetCOMPCTRL0_SPEED() uint32 {
	return (volatile.LoadUint32(&o.COMPCTRL0.Reg) & 0x30000) >> 16
}
func (o *AC_Type) SetCOMPCTRL0_HYSTEN(value uint32) {
	volatile.StoreUint32(&o.COMPCTRL0.Reg, volatile.LoadUint32(&o.COMPCTRL0.Reg)&^(0x80000)|value<<19)
}
func (o *AC_Type) GetCOMPCTRL0_HYSTEN() uint32 {
	return (volatile.LoadUint32(&o.COMPCTRL0.Reg) & 0x80000) >> 19
}
func (o *AC_Type) SetCOMPCTRL0_HYST(value uint32) {
	volatile.StoreUint32(&o.COMPCTRL0.Reg, volatile.LoadUint32(&o.COMPCTRL0.Reg)&^(0x300000)|value<<20)
}
func (o *AC_Type) GetCOMPCTRL0_HYST() uint32 {
	return (volatile.LoadUint32(&o.COMPCTRL0.Reg) & 0x300000) >> 20
}
func (o *AC_Type) SetCOMPCTRL0_FLEN(value uint32) {
	volatile.StoreUint32(&o.COMPCTRL0.Reg, volatile.LoadUint32(&o.COMPCTRL0.Reg)&^(0x7000000)|value<<24)
}
func (o *AC_Type) GetCOMPCTRL0_FLEN() uint32 {
	return (volatile.LoadUint32(&o.COMPCTRL0.Reg) & 0x7000000) >> 24
}
func (o *AC_Type) SetCOMPCTRL0_OUT(value uint32) {
	volatile.StoreUint32(&o.COMPCTRL0.Reg, volatile.LoadUint32(&o.COMPCTRL0.Reg)&^(0x30000000)|value<<28)
}
func (o *AC_Type) GetCOMPCTRL0_OUT() uint32 {
	return (volatile.LoadUint32(&o.COMPCTRL0.Reg) & 0x30000000) >> 28
}

// AC.COMPCTRL1: Comparator Control n
func (o *AC_Type) SetCOMPCTRL1_ENABLE(value uint32) {
	volatile.StoreUint32(&o.COMPCTRL1.Reg, volatile.LoadUint32(&o.COMPCTRL1.Reg)&^(0x2)|value<<1)
}
func (o *AC_Type) GetCOMPCTRL1_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.COMPCTRL1.Reg) & 0x2) >> 1
}
func (o *AC_Type) SetCOMPCTRL1_SINGLE(value uint32) {
	volatile.StoreUint32(&o.COMPCTRL1.Reg, volatile.LoadUint32(&o.COMPCTRL1.Reg)&^(0x4)|value<<2)
}
func (o *AC_Type) GetCOMPCTRL1_SINGLE() uint32 {
	return (volatile.LoadUint32(&o.COMPCTRL1.Reg) & 0x4) >> 2
}
func (o *AC_Type) SetCOMPCTRL1_INTSEL(value uint32) {
	volatile.StoreUint32(&o.COMPCTRL1.Reg, volatile.LoadUint32(&o.COMPCTRL1.Reg)&^(0x18)|value<<3)
}
func (o *AC_Type) GetCOMPCTRL1_INTSEL() uint32 {
	return (volatile.LoadUint32(&o.COMPCTRL1.Reg) & 0x18) >> 3
}
func (o *AC_Type) SetCOMPCTRL1_RUNSTDBY(value uint32) {
	volatile.StoreUint32(&o.COMPCTRL1.Reg, volatile.LoadUint32(&o.COMPCTRL1.Reg)&^(0x40)|value<<6)
}
func (o *AC_Type) GetCOMPCTRL1_RUNSTDBY() uint32 {
	return (volatile.LoadUint32(&o.COMPCTRL1.Reg) & 0x40) >> 6
}
func (o *AC_Type) SetCOMPCTRL1_MUXNEG(value uint32) {
	volatile.StoreUint32(&o.COMPCTRL1.Reg, volatile.LoadUint32(&o.COMPCTRL1.Reg)&^(0x700)|value<<8)
}
func (o *AC_Type) GetCOMPCTRL1_MUXNEG() uint32 {
	return (volatile.LoadUint32(&o.COMPCTRL1.Reg) & 0x700) >> 8
}
func (o *AC_Type) SetCOMPCTRL1_MUXPOS(value uint32) {
	volatile.StoreUint32(&o.COMPCTRL1.Reg, volatile.LoadUint32(&o.COMPCTRL1.Reg)&^(0x7000)|value<<12)
}
func (o *AC_Type) GetCOMPCTRL1_MUXPOS() uint32 {
	return (volatile.LoadUint32(&o.COMPCTRL1.Reg) & 0x7000) >> 12
}
func (o *AC_Type) SetCOMPCTRL1_SWAP(value uint32) {
	volatile.StoreUint32(&o.COMPCTRL1.Reg, volatile.LoadUint32(&o.COMPCTRL1.Reg)&^(0x8000)|value<<15)
}
func (o *AC_Type) GetCOMPCTRL1_SWAP() uint32 {
	return (volatile.LoadUint32(&o.COMPCTRL1.Reg) & 0x8000) >> 15
}
func (o *AC_Type) SetCOMPCTRL1_SPEED(value uint32) {
	volatile.StoreUint32(&o.COMPCTRL1.Reg, volatile.LoadUint32(&o.COMPCTRL1.Reg)&^(0x30000)|value<<16)
}
func (o *AC_Type) GetCOMPCTRL1_SPEED() uint32 {
	return (volatile.LoadUint32(&o.COMPCTRL1.Reg) & 0x30000) >> 16
}
func (o *AC_Type) SetCOMPCTRL1_HYSTEN(value uint32) {
	volatile.StoreUint32(&o.COMPCTRL1.Reg, volatile.LoadUint32(&o.COMPCTRL1.Reg)&^(0x80000)|value<<19)
}
func (o *AC_Type) GetCOMPCTRL1_HYSTEN() uint32 {
	return (volatile.LoadUint32(&o.COMPCTRL1.Reg) & 0x80000) >> 19
}
func (o *AC_Type) SetCOMPCTRL1_HYST(value uint32) {
	volatile.StoreUint32(&o.COMPCTRL1.Reg, volatile.LoadUint32(&o.COMPCTRL1.Reg)&^(0x300000)|value<<20)
}
func (o *AC_Type) GetCOMPCTRL1_HYST() uint32 {
	return (volatile.LoadUint32(&o.COMPCTRL1.Reg) & 0x300000) >> 20
}
func (o *AC_Type) SetCOMPCTRL1_FLEN(value uint32) {
	volatile.StoreUint32(&o.COMPCTRL1.Reg, volatile.LoadUint32(&o.COMPCTRL1.Reg)&^(0x7000000)|value<<24)
}
func (o *AC_Type) GetCOMPCTRL1_FLEN() uint32 {
	return (volatile.LoadUint32(&o.COMPCTRL1.Reg) & 0x7000000) >> 24
}
func (o *AC_Type) SetCOMPCTRL1_OUT(value uint32) {
	volatile.StoreUint32(&o.COMPCTRL1.Reg, volatile.LoadUint32(&o.COMPCTRL1.Reg)&^(0x30000000)|value<<28)
}
func (o *AC_Type) GetCOMPCTRL1_OUT() uint32 {
	return (volatile.LoadUint32(&o.COMPCTRL1.Reg) & 0x30000000) >> 28
}

// AC.SYNCBUSY: Synchronization Busy
func (o *AC_Type) SetSYNCBUSY_SWRST(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x1)|value)
}
func (o *AC_Type) GetSYNCBUSY_SWRST() uint32 {
	return volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x1
}
func (o *AC_Type) SetSYNCBUSY_ENABLE(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x2)|value<<1)
}
func (o *AC_Type) GetSYNCBUSY_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x2) >> 1
}
func (o *AC_Type) SetSYNCBUSY_WINCTRL(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x4)|value<<2)
}
func (o *AC_Type) GetSYNCBUSY_WINCTRL() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x4) >> 2
}
func (o *AC_Type) SetSYNCBUSY_COMPCTRL0(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x8)|value<<3)
}
func (o *AC_Type) GetSYNCBUSY_COMPCTRL0() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x8) >> 3
}
func (o *AC_Type) SetSYNCBUSY_COMPCTRL1(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x10)|value<<4)
}
func (o *AC_Type) GetSYNCBUSY_COMPCTRL1() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x10) >> 4
}

// Analog Digital Converter
type ADC_Type struct {
	CTRLA      volatile.Register8  // 0x0
	CTRLB      volatile.Register8  // 0x1
	REFCTRL    volatile.Register8  // 0x2
	EVCTRL     volatile.Register8  // 0x3
	INTENCLR   volatile.Register8  // 0x4
	INTENSET   volatile.Register8  // 0x5
	INTFLAG    volatile.Register8  // 0x6
	SEQSTATUS  volatile.Register8  // 0x7
	INPUTCTRL  volatile.Register16 // 0x8
	CTRLC      volatile.Register16 // 0xA
	AVGCTRL    volatile.Register8  // 0xC
	SAMPCTRL   volatile.Register8  // 0xD
	WINLT      volatile.Register16 // 0xE
	WINUT      volatile.Register16 // 0x10
	GAINCORR   volatile.Register16 // 0x12
	OFFSETCORR volatile.Register16 // 0x14
	_          [2]byte
	SWTRIG     volatile.Register8 // 0x18
	_          [3]byte
	DBGCTRL    volatile.Register8 // 0x1C
	_          [3]byte
	SYNCBUSY   volatile.Register16 // 0x20
	_          [2]byte
	RESULT     volatile.Register16 // 0x24
	_          [2]byte
	SEQCTRL    volatile.Register32 // 0x28
	CALIB      volatile.Register16 // 0x2C
}

// ADC.CTRLA: Control A
func (o *ADC_Type) SetCTRLA_SWRST(value uint8) {
	volatile.StoreUint8(&o.CTRLA.Reg, volatile.LoadUint8(&o.CTRLA.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetCTRLA_SWRST() uint8 {
	return volatile.LoadUint8(&o.CTRLA.Reg) & 0x1
}
func (o *ADC_Type) SetCTRLA_ENABLE(value uint8) {
	volatile.StoreUint8(&o.CTRLA.Reg, volatile.LoadUint8(&o.CTRLA.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetCTRLA_ENABLE() uint8 {
	return (volatile.LoadUint8(&o.CTRLA.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetCTRLA_RUNSTDBY(value uint8) {
	volatile.StoreUint8(&o.CTRLA.Reg, volatile.LoadUint8(&o.CTRLA.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetCTRLA_RUNSTDBY() uint8 {
	return (volatile.LoadUint8(&o.CTRLA.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetCTRLA_ONDEMAND(value uint8) {
	volatile.StoreUint8(&o.CTRLA.Reg, volatile.LoadUint8(&o.CTRLA.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetCTRLA_ONDEMAND() uint8 {
	return (volatile.LoadUint8(&o.CTRLA.Reg) & 0x80) >> 7
}

// ADC.CTRLB: Control B
func (o *ADC_Type) SetCTRLB_PRESCALER(value uint8) {
	volatile.StoreUint8(&o.CTRLB.Reg, volatile.LoadUint8(&o.CTRLB.Reg)&^(0x7)|value)
}
func (o *ADC_Type) GetCTRLB_PRESCALER() uint8 {
	return volatile.LoadUint8(&o.CTRLB.Reg) & 0x7
}

// ADC.REFCTRL: Reference Control
func (o *ADC_Type) SetREFCTRL_REFSEL(value uint8) {
	volatile.StoreUint8(&o.REFCTRL.Reg, volatile.LoadUint8(&o.REFCTRL.Reg)&^(0xf)|value)
}
func (o *ADC_Type) GetREFCTRL_REFSEL() uint8 {
	return volatile.LoadUint8(&o.REFCTRL.Reg) & 0xf
}
func (o *ADC_Type) SetREFCTRL_REFCOMP(value uint8) {
	volatile.StoreUint8(&o.REFCTRL.Reg, volatile.LoadUint8(&o.REFCTRL.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetREFCTRL_REFCOMP() uint8 {
	return (volatile.LoadUint8(&o.REFCTRL.Reg) & 0x80) >> 7
}

// ADC.EVCTRL: Event Control
func (o *ADC_Type) SetEVCTRL_FLUSHEI(value uint8) {
	volatile.StoreUint8(&o.EVCTRL.Reg, volatile.LoadUint8(&o.EVCTRL.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetEVCTRL_FLUSHEI() uint8 {
	return volatile.LoadUint8(&o.EVCTRL.Reg) & 0x1
}
func (o *ADC_Type) SetEVCTRL_STARTEI(value uint8) {
	volatile.StoreUint8(&o.EVCTRL.Reg, volatile.LoadUint8(&o.EVCTRL.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetEVCTRL_STARTEI() uint8 {
	return (volatile.LoadUint8(&o.EVCTRL.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetEVCTRL_FLUSHINV(value uint8) {
	volatile.StoreUint8(&o.EVCTRL.Reg, volatile.LoadUint8(&o.EVCTRL.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetEVCTRL_FLUSHINV() uint8 {
	return (volatile.LoadUint8(&o.EVCTRL.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetEVCTRL_STARTINV(value uint8) {
	volatile.StoreUint8(&o.EVCTRL.Reg, volatile.LoadUint8(&o.EVCTRL.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetEVCTRL_STARTINV() uint8 {
	return (volatile.LoadUint8(&o.EVCTRL.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetEVCTRL_RESRDYEO(value uint8) {
	volatile.StoreUint8(&o.EVCTRL.Reg, volatile.LoadUint8(&o.EVCTRL.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetEVCTRL_RESRDYEO() uint8 {
	return (volatile.LoadUint8(&o.EVCTRL.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetEVCTRL_WINMONEO(value uint8) {
	volatile.StoreUint8(&o.EVCTRL.Reg, volatile.LoadUint8(&o.EVCTRL.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetEVCTRL_WINMONEO() uint8 {
	return (volatile.LoadUint8(&o.EVCTRL.Reg) & 0x20) >> 5
}

// ADC.INTENCLR: Interrupt Enable Clear
func (o *ADC_Type) SetINTENCLR_RESRDY(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetINTENCLR_RESRDY() uint8 {
	return volatile.LoadUint8(&o.INTENCLR.Reg) & 0x1
}
func (o *ADC_Type) SetINTENCLR_OVERRUN(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetINTENCLR_OVERRUN() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetINTENCLR_WINMON(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetINTENCLR_WINMON() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x4) >> 2
}

// ADC.INTENSET: Interrupt Enable Set
func (o *ADC_Type) SetINTENSET_RESRDY(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetINTENSET_RESRDY() uint8 {
	return volatile.LoadUint8(&o.INTENSET.Reg) & 0x1
}
func (o *ADC_Type) SetINTENSET_OVERRUN(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetINTENSET_OVERRUN() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetINTENSET_WINMON(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetINTENSET_WINMON() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x4) >> 2
}

// ADC.INTFLAG: Interrupt Flag Status and Clear
func (o *ADC_Type) SetINTFLAG_RESRDY(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetINTFLAG_RESRDY() uint8 {
	return volatile.LoadUint8(&o.INTFLAG.Reg) & 0x1
}
func (o *ADC_Type) SetINTFLAG_OVERRUN(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetINTFLAG_OVERRUN() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetINTFLAG_WINMON(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetINTFLAG_WINMON() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x4) >> 2
}

// ADC.SEQSTATUS: Sequence Status
func (o *ADC_Type) SetSEQSTATUS_SEQSTATE(value uint8) {
	volatile.StoreUint8(&o.SEQSTATUS.Reg, volatile.LoadUint8(&o.SEQSTATUS.Reg)&^(0x1f)|value)
}
func (o *ADC_Type) GetSEQSTATUS_SEQSTATE() uint8 {
	return volatile.LoadUint8(&o.SEQSTATUS.Reg) & 0x1f
}
func (o *ADC_Type) SetSEQSTATUS_SEQBUSY(value uint8) {
	volatile.StoreUint8(&o.SEQSTATUS.Reg, volatile.LoadUint8(&o.SEQSTATUS.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetSEQSTATUS_SEQBUSY() uint8 {
	return (volatile.LoadUint8(&o.SEQSTATUS.Reg) & 0x80) >> 7
}

// ADC.INPUTCTRL: Input Control
func (o *ADC_Type) SetINPUTCTRL_MUXPOS(value uint16) {
	volatile.StoreUint16(&o.INPUTCTRL.Reg, volatile.LoadUint16(&o.INPUTCTRL.Reg)&^(0x1f)|value)
}
func (o *ADC_Type) GetINPUTCTRL_MUXPOS() uint16 {
	return volatile.LoadUint16(&o.INPUTCTRL.Reg) & 0x1f
}
func (o *ADC_Type) SetINPUTCTRL_MUXNEG(value uint16) {
	volatile.StoreUint16(&o.INPUTCTRL.Reg, volatile.LoadUint16(&o.INPUTCTRL.Reg)&^(0x1f00)|value<<8)
}
func (o *ADC_Type) GetINPUTCTRL_MUXNEG() uint16 {
	return (volatile.LoadUint16(&o.INPUTCTRL.Reg) & 0x1f00) >> 8
}

// ADC.CTRLC: Control C
func (o *ADC_Type) SetCTRLC_DIFFMODE(value uint16) {
	volatile.StoreUint16(&o.CTRLC.Reg, volatile.LoadUint16(&o.CTRLC.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetCTRLC_DIFFMODE() uint16 {
	return volatile.LoadUint16(&o.CTRLC.Reg) & 0x1
}
func (o *ADC_Type) SetCTRLC_LEFTADJ(value uint16) {
	volatile.StoreUint16(&o.CTRLC.Reg, volatile.LoadUint16(&o.CTRLC.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetCTRLC_LEFTADJ() uint16 {
	return (volatile.LoadUint16(&o.CTRLC.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetCTRLC_FREERUN(value uint16) {
	volatile.StoreUint16(&o.CTRLC.Reg, volatile.LoadUint16(&o.CTRLC.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetCTRLC_FREERUN() uint16 {
	return (volatile.LoadUint16(&o.CTRLC.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetCTRLC_CORREN(value uint16) {
	volatile.StoreUint16(&o.CTRLC.Reg, volatile.LoadUint16(&o.CTRLC.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetCTRLC_CORREN() uint16 {
	return (volatile.LoadUint16(&o.CTRLC.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetCTRLC_RESSEL(value uint16) {
	volatile.StoreUint16(&o.CTRLC.Reg, volatile.LoadUint16(&o.CTRLC.Reg)&^(0x30)|value<<4)
}
func (o *ADC_Type) GetCTRLC_RESSEL() uint16 {
	return (volatile.LoadUint16(&o.CTRLC.Reg) & 0x30) >> 4
}
func (o *ADC_Type) SetCTRLC_R2R(value uint16) {
	volatile.StoreUint16(&o.CTRLC.Reg, volatile.LoadUint16(&o.CTRLC.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetCTRLC_R2R() uint16 {
	return (volatile.LoadUint16(&o.CTRLC.Reg) & 0x80) >> 7
}
func (o *ADC_Type) SetCTRLC_WINMODE(value uint16) {
	volatile.StoreUint16(&o.CTRLC.Reg, volatile.LoadUint16(&o.CTRLC.Reg)&^(0x700)|value<<8)
}
func (o *ADC_Type) GetCTRLC_WINMODE() uint16 {
	return (volatile.LoadUint16(&o.CTRLC.Reg) & 0x700) >> 8
}
func (o *ADC_Type) SetCTRLC_DUALSEL(value uint16) {
	volatile.StoreUint16(&o.CTRLC.Reg, volatile.LoadUint16(&o.CTRLC.Reg)&^(0x3000)|value<<12)
}
func (o *ADC_Type) GetCTRLC_DUALSEL() uint16 {
	return (volatile.LoadUint16(&o.CTRLC.Reg) & 0x3000) >> 12
}

// ADC.AVGCTRL: Average Control
func (o *ADC_Type) SetAVGCTRL_SAMPLENUM(value uint8) {
	volatile.StoreUint8(&o.AVGCTRL.Reg, volatile.LoadUint8(&o.AVGCTRL.Reg)&^(0xf)|value)
}
func (o *ADC_Type) GetAVGCTRL_SAMPLENUM() uint8 {
	return volatile.LoadUint8(&o.AVGCTRL.Reg) & 0xf
}
func (o *ADC_Type) SetAVGCTRL_ADJRES(value uint8) {
	volatile.StoreUint8(&o.AVGCTRL.Reg, volatile.LoadUint8(&o.AVGCTRL.Reg)&^(0x70)|value<<4)
}
func (o *ADC_Type) GetAVGCTRL_ADJRES() uint8 {
	return (volatile.LoadUint8(&o.AVGCTRL.Reg) & 0x70) >> 4
}

// ADC.SAMPCTRL: Sample Time Control
func (o *ADC_Type) SetSAMPCTRL_SAMPLEN(value uint8) {
	volatile.StoreUint8(&o.SAMPCTRL.Reg, volatile.LoadUint8(&o.SAMPCTRL.Reg)&^(0x3f)|value)
}
func (o *ADC_Type) GetSAMPCTRL_SAMPLEN() uint8 {
	return volatile.LoadUint8(&o.SAMPCTRL.Reg) & 0x3f
}
func (o *ADC_Type) SetSAMPCTRL_OFFCOMP(value uint8) {
	volatile.StoreUint8(&o.SAMPCTRL.Reg, volatile.LoadUint8(&o.SAMPCTRL.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetSAMPCTRL_OFFCOMP() uint8 {
	return (volatile.LoadUint8(&o.SAMPCTRL.Reg) & 0x80) >> 7
}

// ADC.WINLT: Window Monitor Lower Threshold
func (o *ADC_Type) SetWINLT(value uint16) {
	volatile.StoreUint16(&o.WINLT.Reg, value)
}
func (o *ADC_Type) GetWINLT() uint16 {
	return volatile.LoadUint16(&o.WINLT.Reg)
}

// ADC.WINUT: Window Monitor Upper Threshold
func (o *ADC_Type) SetWINUT(value uint16) {
	volatile.StoreUint16(&o.WINUT.Reg, value)
}
func (o *ADC_Type) GetWINUT() uint16 {
	return volatile.LoadUint16(&o.WINUT.Reg)
}

// ADC.GAINCORR: Gain Correction
func (o *ADC_Type) SetGAINCORR(value uint16) {
	volatile.StoreUint16(&o.GAINCORR.Reg, volatile.LoadUint16(&o.GAINCORR.Reg)&^(0xfff)|value)
}
func (o *ADC_Type) GetGAINCORR() uint16 {
	return volatile.LoadUint16(&o.GAINCORR.Reg) & 0xfff
}

// ADC.OFFSETCORR: Offset Correction
func (o *ADC_Type) SetOFFSETCORR(value uint16) {
	volatile.StoreUint16(&o.OFFSETCORR.Reg, volatile.LoadUint16(&o.OFFSETCORR.Reg)&^(0xfff)|value)
}
func (o *ADC_Type) GetOFFSETCORR() uint16 {
	return volatile.LoadUint16(&o.OFFSETCORR.Reg) & 0xfff
}

// ADC.SWTRIG: Software Trigger
func (o *ADC_Type) SetSWTRIG_FLUSH(value uint8) {
	volatile.StoreUint8(&o.SWTRIG.Reg, volatile.LoadUint8(&o.SWTRIG.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetSWTRIG_FLUSH() uint8 {
	return volatile.LoadUint8(&o.SWTRIG.Reg) & 0x1
}
func (o *ADC_Type) SetSWTRIG_START(value uint8) {
	volatile.StoreUint8(&o.SWTRIG.Reg, volatile.LoadUint8(&o.SWTRIG.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetSWTRIG_START() uint8 {
	return (volatile.LoadUint8(&o.SWTRIG.Reg) & 0x2) >> 1
}

// ADC.DBGCTRL: Debug Control
func (o *ADC_Type) SetDBGCTRL_DBGRUN(value uint8) {
	volatile.StoreUint8(&o.DBGCTRL.Reg, volatile.LoadUint8(&o.DBGCTRL.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetDBGCTRL_DBGRUN() uint8 {
	return volatile.LoadUint8(&o.DBGCTRL.Reg) & 0x1
}

// ADC.SYNCBUSY: Synchronization Busy
func (o *ADC_Type) SetSYNCBUSY_SWRST(value uint16) {
	volatile.StoreUint16(&o.SYNCBUSY.Reg, volatile.LoadUint16(&o.SYNCBUSY.Reg)&^(0x1)|value)
}
func (o *ADC_Type) GetSYNCBUSY_SWRST() uint16 {
	return volatile.LoadUint16(&o.SYNCBUSY.Reg) & 0x1
}
func (o *ADC_Type) SetSYNCBUSY_ENABLE(value uint16) {
	volatile.StoreUint16(&o.SYNCBUSY.Reg, volatile.LoadUint16(&o.SYNCBUSY.Reg)&^(0x2)|value<<1)
}
func (o *ADC_Type) GetSYNCBUSY_ENABLE() uint16 {
	return (volatile.LoadUint16(&o.SYNCBUSY.Reg) & 0x2) >> 1
}
func (o *ADC_Type) SetSYNCBUSY_INPUTCTRL(value uint16) {
	volatile.StoreUint16(&o.SYNCBUSY.Reg, volatile.LoadUint16(&o.SYNCBUSY.Reg)&^(0x4)|value<<2)
}
func (o *ADC_Type) GetSYNCBUSY_INPUTCTRL() uint16 {
	return (volatile.LoadUint16(&o.SYNCBUSY.Reg) & 0x4) >> 2
}
func (o *ADC_Type) SetSYNCBUSY_CTRLC(value uint16) {
	volatile.StoreUint16(&o.SYNCBUSY.Reg, volatile.LoadUint16(&o.SYNCBUSY.Reg)&^(0x8)|value<<3)
}
func (o *ADC_Type) GetSYNCBUSY_CTRLC() uint16 {
	return (volatile.LoadUint16(&o.SYNCBUSY.Reg) & 0x8) >> 3
}
func (o *ADC_Type) SetSYNCBUSY_AVGCTRL(value uint16) {
	volatile.StoreUint16(&o.SYNCBUSY.Reg, volatile.LoadUint16(&o.SYNCBUSY.Reg)&^(0x10)|value<<4)
}
func (o *ADC_Type) GetSYNCBUSY_AVGCTRL() uint16 {
	return (volatile.LoadUint16(&o.SYNCBUSY.Reg) & 0x10) >> 4
}
func (o *ADC_Type) SetSYNCBUSY_SAMPCTRL(value uint16) {
	volatile.StoreUint16(&o.SYNCBUSY.Reg, volatile.LoadUint16(&o.SYNCBUSY.Reg)&^(0x20)|value<<5)
}
func (o *ADC_Type) GetSYNCBUSY_SAMPCTRL() uint16 {
	return (volatile.LoadUint16(&o.SYNCBUSY.Reg) & 0x20) >> 5
}
func (o *ADC_Type) SetSYNCBUSY_WINLT(value uint16) {
	volatile.StoreUint16(&o.SYNCBUSY.Reg, volatile.LoadUint16(&o.SYNCBUSY.Reg)&^(0x40)|value<<6)
}
func (o *ADC_Type) GetSYNCBUSY_WINLT() uint16 {
	return (volatile.LoadUint16(&o.SYNCBUSY.Reg) & 0x40) >> 6
}
func (o *ADC_Type) SetSYNCBUSY_WINUT(value uint16) {
	volatile.StoreUint16(&o.SYNCBUSY.Reg, volatile.LoadUint16(&o.SYNCBUSY.Reg)&^(0x80)|value<<7)
}
func (o *ADC_Type) GetSYNCBUSY_WINUT() uint16 {
	return (volatile.LoadUint16(&o.SYNCBUSY.Reg) & 0x80) >> 7
}
func (o *ADC_Type) SetSYNCBUSY_GAINCORR(value uint16) {
	volatile.StoreUint16(&o.SYNCBUSY.Reg, volatile.LoadUint16(&o.SYNCBUSY.Reg)&^(0x100)|value<<8)
}
func (o *ADC_Type) GetSYNCBUSY_GAINCORR() uint16 {
	return (volatile.LoadUint16(&o.SYNCBUSY.Reg) & 0x100) >> 8
}
func (o *ADC_Type) SetSYNCBUSY_OFFSETCORR(value uint16) {
	volatile.StoreUint16(&o.SYNCBUSY.Reg, volatile.LoadUint16(&o.SYNCBUSY.Reg)&^(0x200)|value<<9)
}
func (o *ADC_Type) GetSYNCBUSY_OFFSETCORR() uint16 {
	return (volatile.LoadUint16(&o.SYNCBUSY.Reg) & 0x200) >> 9
}
func (o *ADC_Type) SetSYNCBUSY_SWTRIG(value uint16) {
	volatile.StoreUint16(&o.SYNCBUSY.Reg, volatile.LoadUint16(&o.SYNCBUSY.Reg)&^(0x400)|value<<10)
}
func (o *ADC_Type) GetSYNCBUSY_SWTRIG() uint16 {
	return (volatile.LoadUint16(&o.SYNCBUSY.Reg) & 0x400) >> 10
}

// ADC.RESULT: Result
func (o *ADC_Type) SetRESULT(value uint16) {
	volatile.StoreUint16(&o.RESULT.Reg, value)
}
func (o *ADC_Type) GetRESULT() uint16 {
	return volatile.LoadUint16(&o.RESULT.Reg)
}

// ADC.SEQCTRL: Sequence Control
func (o *ADC_Type) SetSEQCTRL(value uint32) {
	volatile.StoreUint32(&o.SEQCTRL.Reg, value)
}
func (o *ADC_Type) GetSEQCTRL() uint32 {
	return volatile.LoadUint32(&o.SEQCTRL.Reg)
}

// ADC.CALIB: Calibration
func (o *ADC_Type) SetCALIB_BIASCOMP(value uint16) {
	volatile.StoreUint16(&o.CALIB.Reg, volatile.LoadUint16(&o.CALIB.Reg)&^(0x7)|value)
}
func (o *ADC_Type) GetCALIB_BIASCOMP() uint16 {
	return volatile.LoadUint16(&o.CALIB.Reg) & 0x7
}
func (o *ADC_Type) SetCALIB_BIASREFBUF(value uint16) {
	volatile.StoreUint16(&o.CALIB.Reg, volatile.LoadUint16(&o.CALIB.Reg)&^(0x700)|value<<8)
}
func (o *ADC_Type) GetCALIB_BIASREFBUF() uint16 {
	return (volatile.LoadUint16(&o.CALIB.Reg) & 0x700) >> 8
}

// Advanced Encryption Standard
type AES_Type struct {
	CTRLA      volatile.Register32 // 0x0
	CTRLB      volatile.Register8  // 0x4
	INTENCLR   volatile.Register8  // 0x5
	INTENSET   volatile.Register8  // 0x6
	INTFLAG    volatile.Register8  // 0x7
	DATABUFPTR volatile.Register8  // 0x8
	DBGCTRL    volatile.Register8  // 0x9
	_          [2]byte
	KEYWORD0   volatile.Register32 // 0xC
	KEYWORD1   volatile.Register32 // 0x10
	KEYWORD2   volatile.Register32 // 0x14
	KEYWORD3   volatile.Register32 // 0x18
	KEYWORD4   volatile.Register32 // 0x1C
	KEYWORD5   volatile.Register32 // 0x20
	KEYWORD6   volatile.Register32 // 0x24
	KEYWORD7   volatile.Register32 // 0x28
	_          [12]byte
	INDATA     volatile.Register32 // 0x38
	INTVECTV0  volatile.Register32 // 0x3C
	INTVECTV1  volatile.Register32 // 0x40
	INTVECTV2  volatile.Register32 // 0x44
	INTVECTV3  volatile.Register32 // 0x48
	_          [16]byte
	HASHKEY0   volatile.Register32 // 0x5C
	HASHKEY1   volatile.Register32 // 0x60
	HASHKEY2   volatile.Register32 // 0x64
	HASHKEY3   volatile.Register32 // 0x68
	GHASH0     volatile.Register32 // 0x6C
	GHASH1     volatile.Register32 // 0x70
	GHASH2     volatile.Register32 // 0x74
	GHASH3     volatile.Register32 // 0x78
	_          [4]byte
	CIPLEN     volatile.Register32 // 0x80
	RANDSEED   volatile.Register32 // 0x84
}

// AES.CTRLA: Control A
func (o *AES_Type) SetCTRLA_SWRST(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x1)|value)
}
func (o *AES_Type) GetCTRLA_SWRST() uint32 {
	return volatile.LoadUint32(&o.CTRLA.Reg) & 0x1
}
func (o *AES_Type) SetCTRLA_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x2)|value<<1)
}
func (o *AES_Type) GetCTRLA_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x2) >> 1
}
func (o *AES_Type) SetCTRLA_AESMODE(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x1c)|value<<2)
}
func (o *AES_Type) GetCTRLA_AESMODE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x1c) >> 2
}
func (o *AES_Type) SetCTRLA_CFBS(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0xe0)|value<<5)
}
func (o *AES_Type) GetCTRLA_CFBS() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0xe0) >> 5
}
func (o *AES_Type) SetCTRLA_KEYSIZE(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x300)|value<<8)
}
func (o *AES_Type) GetCTRLA_KEYSIZE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x300) >> 8
}
func (o *AES_Type) SetCTRLA_CIPHER(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x400)|value<<10)
}
func (o *AES_Type) GetCTRLA_CIPHER() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x400) >> 10
}
func (o *AES_Type) SetCTRLA_STARTMODE(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x800)|value<<11)
}
func (o *AES_Type) GetCTRLA_STARTMODE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x800) >> 11
}
func (o *AES_Type) SetCTRLA_LOD(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x1000)|value<<12)
}
func (o *AES_Type) GetCTRLA_LOD() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x1000) >> 12
}
func (o *AES_Type) SetCTRLA_KEYGEN(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x2000)|value<<13)
}
func (o *AES_Type) GetCTRLA_KEYGEN() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x2000) >> 13
}
func (o *AES_Type) SetCTRLA_XORKEY(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x4000)|value<<14)
}
func (o *AES_Type) GetCTRLA_XORKEY() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x4000) >> 14
}
func (o *AES_Type) SetCTRLA_CTYPE(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0xf0000)|value<<16)
}
func (o *AES_Type) GetCTRLA_CTYPE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0xf0000) >> 16
}

// AES.CTRLB: Control B
func (o *AES_Type) SetCTRLB_START(value uint8) {
	volatile.StoreUint8(&o.CTRLB.Reg, volatile.LoadUint8(&o.CTRLB.Reg)&^(0x1)|value)
}
func (o *AES_Type) GetCTRLB_START() uint8 {
	return volatile.LoadUint8(&o.CTRLB.Reg) & 0x1
}
func (o *AES_Type) SetCTRLB_NEWMSG(value uint8) {
	volatile.StoreUint8(&o.CTRLB.Reg, volatile.LoadUint8(&o.CTRLB.Reg)&^(0x2)|value<<1)
}
func (o *AES_Type) GetCTRLB_NEWMSG() uint8 {
	return (volatile.LoadUint8(&o.CTRLB.Reg) & 0x2) >> 1
}
func (o *AES_Type) SetCTRLB_EOM(value uint8) {
	volatile.StoreUint8(&o.CTRLB.Reg, volatile.LoadUint8(&o.CTRLB.Reg)&^(0x4)|value<<2)
}
func (o *AES_Type) GetCTRLB_EOM() uint8 {
	return (volatile.LoadUint8(&o.CTRLB.Reg) & 0x4) >> 2
}
func (o *AES_Type) SetCTRLB_GFMUL(value uint8) {
	volatile.StoreUint8(&o.CTRLB.Reg, volatile.LoadUint8(&o.CTRLB.Reg)&^(0x8)|value<<3)
}
func (o *AES_Type) GetCTRLB_GFMUL() uint8 {
	return (volatile.LoadUint8(&o.CTRLB.Reg) & 0x8) >> 3
}

// AES.INTENCLR: Interrupt Enable Clear
func (o *AES_Type) SetINTENCLR_ENCCMP(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *AES_Type) GetINTENCLR_ENCCMP() uint8 {
	return volatile.LoadUint8(&o.INTENCLR.Reg) & 0x1
}
func (o *AES_Type) SetINTENCLR_GFMCMP(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *AES_Type) GetINTENCLR_GFMCMP() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x2) >> 1
}

// AES.INTENSET: Interrupt Enable Set
func (o *AES_Type) SetINTENSET_ENCCMP(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *AES_Type) GetINTENSET_ENCCMP() uint8 {
	return volatile.LoadUint8(&o.INTENSET.Reg) & 0x1
}
func (o *AES_Type) SetINTENSET_GFMCMP(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *AES_Type) GetINTENSET_GFMCMP() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x2) >> 1
}

// AES.INTFLAG: Interrupt Flag Status
func (o *AES_Type) SetINTFLAG_ENCCMP(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x1)|value)
}
func (o *AES_Type) GetINTFLAG_ENCCMP() uint8 {
	return volatile.LoadUint8(&o.INTFLAG.Reg) & 0x1
}
func (o *AES_Type) SetINTFLAG_GFMCMP(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x2)|value<<1)
}
func (o *AES_Type) GetINTFLAG_GFMCMP() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x2) >> 1
}

// AES.DATABUFPTR: Data buffer pointer
func (o *AES_Type) SetDATABUFPTR_INDATAPTR(value uint8) {
	volatile.StoreUint8(&o.DATABUFPTR.Reg, volatile.LoadUint8(&o.DATABUFPTR.Reg)&^(0x3)|value)
}
func (o *AES_Type) GetDATABUFPTR_INDATAPTR() uint8 {
	return volatile.LoadUint8(&o.DATABUFPTR.Reg) & 0x3
}

// AES.DBGCTRL: Debug control
func (o *AES_Type) SetDBGCTRL_DBGRUN(value uint8) {
	volatile.StoreUint8(&o.DBGCTRL.Reg, volatile.LoadUint8(&o.DBGCTRL.Reg)&^(0x1)|value)
}
func (o *AES_Type) GetDBGCTRL_DBGRUN() uint8 {
	return volatile.LoadUint8(&o.DBGCTRL.Reg) & 0x1
}

// Configurable Custom Logic
type CCL_Type struct {
	CTRL     volatile.Register8 // 0x0
	_        [3]byte
	SEQCTRL0 volatile.Register8 // 0x4
	SEQCTRL1 volatile.Register8 // 0x5
	_        [2]byte
	LUTCTRL0 volatile.Register32 // 0x8
	LUTCTRL1 volatile.Register32 // 0xC
	LUTCTRL2 volatile.Register32 // 0x10
	LUTCTRL3 volatile.Register32 // 0x14
}

// CCL.CTRL: Control
func (o *CCL_Type) SetCTRL_SWRST(value uint8) {
	volatile.StoreUint8(&o.CTRL.Reg, volatile.LoadUint8(&o.CTRL.Reg)&^(0x1)|value)
}
func (o *CCL_Type) GetCTRL_SWRST() uint8 {
	return volatile.LoadUint8(&o.CTRL.Reg) & 0x1
}
func (o *CCL_Type) SetCTRL_ENABLE(value uint8) {
	volatile.StoreUint8(&o.CTRL.Reg, volatile.LoadUint8(&o.CTRL.Reg)&^(0x2)|value<<1)
}
func (o *CCL_Type) GetCTRL_ENABLE() uint8 {
	return (volatile.LoadUint8(&o.CTRL.Reg) & 0x2) >> 1
}
func (o *CCL_Type) SetCTRL_RUNSTDBY(value uint8) {
	volatile.StoreUint8(&o.CTRL.Reg, volatile.LoadUint8(&o.CTRL.Reg)&^(0x40)|value<<6)
}
func (o *CCL_Type) GetCTRL_RUNSTDBY() uint8 {
	return (volatile.LoadUint8(&o.CTRL.Reg) & 0x40) >> 6
}

// CCL.SEQCTRL0: SEQ Control x
func (o *CCL_Type) SetSEQCTRL0_SEQSEL(value uint8) {
	volatile.StoreUint8(&o.SEQCTRL0.Reg, volatile.LoadUint8(&o.SEQCTRL0.Reg)&^(0xf)|value)
}
func (o *CCL_Type) GetSEQCTRL0_SEQSEL() uint8 {
	return volatile.LoadUint8(&o.SEQCTRL0.Reg) & 0xf
}

// CCL.SEQCTRL1: SEQ Control x
func (o *CCL_Type) SetSEQCTRL1_SEQSEL(value uint8) {
	volatile.StoreUint8(&o.SEQCTRL1.Reg, volatile.LoadUint8(&o.SEQCTRL1.Reg)&^(0xf)|value)
}
func (o *CCL_Type) GetSEQCTRL1_SEQSEL() uint8 {
	return volatile.LoadUint8(&o.SEQCTRL1.Reg) & 0xf
}

// CCL.LUTCTRL0: LUT Control x
func (o *CCL_Type) SetLUTCTRL0_ENABLE(value uint32) {
	volatile.StoreUint32(&o.LUTCTRL0.Reg, volatile.LoadUint32(&o.LUTCTRL0.Reg)&^(0x2)|value<<1)
}
func (o *CCL_Type) GetLUTCTRL0_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.LUTCTRL0.Reg) & 0x2) >> 1
}
func (o *CCL_Type) SetLUTCTRL0_FILTSEL(value uint32) {
	volatile.StoreUint32(&o.LUTCTRL0.Reg, volatile.LoadUint32(&o.LUTCTRL0.Reg)&^(0x30)|value<<4)
}
func (o *CCL_Type) GetLUTCTRL0_FILTSEL() uint32 {
	return (volatile.LoadUint32(&o.LUTCTRL0.Reg) & 0x30) >> 4
}
func (o *CCL_Type) SetLUTCTRL0_EDGESEL(value uint32) {
	volatile.StoreUint32(&o.LUTCTRL0.Reg, volatile.LoadUint32(&o.LUTCTRL0.Reg)&^(0x80)|value<<7)
}
func (o *CCL_Type) GetLUTCTRL0_EDGESEL() uint32 {
	return (volatile.LoadUint32(&o.LUTCTRL0.Reg) & 0x80) >> 7
}
func (o *CCL_Type) SetLUTCTRL0_INSEL0(value uint32) {
	volatile.StoreUint32(&o.LUTCTRL0.Reg, volatile.LoadUint32(&o.LUTCTRL0.Reg)&^(0xf00)|value<<8)
}
func (o *CCL_Type) GetLUTCTRL0_INSEL0() uint32 {
	return (volatile.LoadUint32(&o.LUTCTRL0.Reg) & 0xf00) >> 8
}
func (o *CCL_Type) SetLUTCTRL0_INSEL1(value uint32) {
	volatile.StoreUint32(&o.LUTCTRL0.Reg, volatile.LoadUint32(&o.LUTCTRL0.Reg)&^(0xf000)|value<<12)
}
func (o *CCL_Type) GetLUTCTRL0_INSEL1() uint32 {
	return (volatile.LoadUint32(&o.LUTCTRL0.Reg) & 0xf000) >> 12
}
func (o *CCL_Type) SetLUTCTRL0_INSEL2(value uint32) {
	volatile.StoreUint32(&o.LUTCTRL0.Reg, volatile.LoadUint32(&o.LUTCTRL0.Reg)&^(0xf0000)|value<<16)
}
func (o *CCL_Type) GetLUTCTRL0_INSEL2() uint32 {
	return (volatile.LoadUint32(&o.LUTCTRL0.Reg) & 0xf0000) >> 16
}
func (o *CCL_Type) SetLUTCTRL0_INVEI(value uint32) {
	volatile.StoreUint32(&o.LUTCTRL0.Reg, volatile.LoadUint32(&o.LUTCTRL0.Reg)&^(0x100000)|value<<20)
}
func (o *CCL_Type) GetLUTCTRL0_INVEI() uint32 {
	return (volatile.LoadUint32(&o.LUTCTRL0.Reg) & 0x100000) >> 20
}
func (o *CCL_Type) SetLUTCTRL0_LUTEI(value uint32) {
	volatile.StoreUint32(&o.LUTCTRL0.Reg, volatile.LoadUint32(&o.LUTCTRL0.Reg)&^(0x200000)|value<<21)
}
func (o *CCL_Type) GetLUTCTRL0_LUTEI() uint32 {
	return (volatile.LoadUint32(&o.LUTCTRL0.Reg) & 0x200000) >> 21
}
func (o *CCL_Type) SetLUTCTRL0_LUTEO(value uint32) {
	volatile.StoreUint32(&o.LUTCTRL0.Reg, volatile.LoadUint32(&o.LUTCTRL0.Reg)&^(0x400000)|value<<22)
}
func (o *CCL_Type) GetLUTCTRL0_LUTEO() uint32 {
	return (volatile.LoadUint32(&o.LUTCTRL0.Reg) & 0x400000) >> 22
}
func (o *CCL_Type) SetLUTCTRL0_TRUTH(value uint32) {
	volatile.StoreUint32(&o.LUTCTRL0.Reg, volatile.LoadUint32(&o.LUTCTRL0.Reg)&^(0xff000000)|value<<24)
}
func (o *CCL_Type) GetLUTCTRL0_TRUTH() uint32 {
	return (volatile.LoadUint32(&o.LUTCTRL0.Reg) & 0xff000000) >> 24
}

// CCL.LUTCTRL1: LUT Control x
func (o *CCL_Type) SetLUTCTRL1_ENABLE(value uint32) {
	volatile.StoreUint32(&o.LUTCTRL1.Reg, volatile.LoadUint32(&o.LUTCTRL1.Reg)&^(0x2)|value<<1)
}
func (o *CCL_Type) GetLUTCTRL1_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.LUTCTRL1.Reg) & 0x2) >> 1
}
func (o *CCL_Type) SetLUTCTRL1_FILTSEL(value uint32) {
	volatile.StoreUint32(&o.LUTCTRL1.Reg, volatile.LoadUint32(&o.LUTCTRL1.Reg)&^(0x30)|value<<4)
}
func (o *CCL_Type) GetLUTCTRL1_FILTSEL() uint32 {
	return (volatile.LoadUint32(&o.LUTCTRL1.Reg) & 0x30) >> 4
}
func (o *CCL_Type) SetLUTCTRL1_EDGESEL(value uint32) {
	volatile.StoreUint32(&o.LUTCTRL1.Reg, volatile.LoadUint32(&o.LUTCTRL1.Reg)&^(0x80)|value<<7)
}
func (o *CCL_Type) GetLUTCTRL1_EDGESEL() uint32 {
	return (volatile.LoadUint32(&o.LUTCTRL1.Reg) & 0x80) >> 7
}
func (o *CCL_Type) SetLUTCTRL1_INSEL0(value uint32) {
	volatile.StoreUint32(&o.LUTCTRL1.Reg, volatile.LoadUint32(&o.LUTCTRL1.Reg)&^(0xf00)|value<<8)
}
func (o *CCL_Type) GetLUTCTRL1_INSEL0() uint32 {
	return (volatile.LoadUint32(&o.LUTCTRL1.Reg) & 0xf00) >> 8
}
func (o *CCL_Type) SetLUTCTRL1_INSEL1(value uint32) {
	volatile.StoreUint32(&o.LUTCTRL1.Reg, volatile.LoadUint32(&o.LUTCTRL1.Reg)&^(0xf000)|value<<12)
}
func (o *CCL_Type) GetLUTCTRL1_INSEL1() uint32 {
	return (volatile.LoadUint32(&o.LUTCTRL1.Reg) & 0xf000) >> 12
}
func (o *CCL_Type) SetLUTCTRL1_INSEL2(value uint32) {
	volatile.StoreUint32(&o.LUTCTRL1.Reg, volatile.LoadUint32(&o.LUTCTRL1.Reg)&^(0xf0000)|value<<16)
}
func (o *CCL_Type) GetLUTCTRL1_INSEL2() uint32 {
	return (volatile.LoadUint32(&o.LUTCTRL1.Reg) & 0xf0000) >> 16
}
func (o *CCL_Type) SetLUTCTRL1_INVEI(value uint32) {
	volatile.StoreUint32(&o.LUTCTRL1.Reg, volatile.LoadUint32(&o.LUTCTRL1.Reg)&^(0x100000)|value<<20)
}
func (o *CCL_Type) GetLUTCTRL1_INVEI() uint32 {
	return (volatile.LoadUint32(&o.LUTCTRL1.Reg) & 0x100000) >> 20
}
func (o *CCL_Type) SetLUTCTRL1_LUTEI(value uint32) {
	volatile.StoreUint32(&o.LUTCTRL1.Reg, volatile.LoadUint32(&o.LUTCTRL1.Reg)&^(0x200000)|value<<21)
}
func (o *CCL_Type) GetLUTCTRL1_LUTEI() uint32 {
	return (volatile.LoadUint32(&o.LUTCTRL1.Reg) & 0x200000) >> 21
}
func (o *CCL_Type) SetLUTCTRL1_LUTEO(value uint32) {
	volatile.StoreUint32(&o.LUTCTRL1.Reg, volatile.LoadUint32(&o.LUTCTRL1.Reg)&^(0x400000)|value<<22)
}
func (o *CCL_Type) GetLUTCTRL1_LUTEO() uint32 {
	return (volatile.LoadUint32(&o.LUTCTRL1.Reg) & 0x400000) >> 22
}
func (o *CCL_Type) SetLUTCTRL1_TRUTH(value uint32) {
	volatile.StoreUint32(&o.LUTCTRL1.Reg, volatile.LoadUint32(&o.LUTCTRL1.Reg)&^(0xff000000)|value<<24)
}
func (o *CCL_Type) GetLUTCTRL1_TRUTH() uint32 {
	return (volatile.LoadUint32(&o.LUTCTRL1.Reg) & 0xff000000) >> 24
}

// CCL.LUTCTRL2: LUT Control x
func (o *CCL_Type) SetLUTCTRL2_ENABLE(value uint32) {
	volatile.StoreUint32(&o.LUTCTRL2.Reg, volatile.LoadUint32(&o.LUTCTRL2.Reg)&^(0x2)|value<<1)
}
func (o *CCL_Type) GetLUTCTRL2_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.LUTCTRL2.Reg) & 0x2) >> 1
}
func (o *CCL_Type) SetLUTCTRL2_FILTSEL(value uint32) {
	volatile.StoreUint32(&o.LUTCTRL2.Reg, volatile.LoadUint32(&o.LUTCTRL2.Reg)&^(0x30)|value<<4)
}
func (o *CCL_Type) GetLUTCTRL2_FILTSEL() uint32 {
	return (volatile.LoadUint32(&o.LUTCTRL2.Reg) & 0x30) >> 4
}
func (o *CCL_Type) SetLUTCTRL2_EDGESEL(value uint32) {
	volatile.StoreUint32(&o.LUTCTRL2.Reg, volatile.LoadUint32(&o.LUTCTRL2.Reg)&^(0x80)|value<<7)
}
func (o *CCL_Type) GetLUTCTRL2_EDGESEL() uint32 {
	return (volatile.LoadUint32(&o.LUTCTRL2.Reg) & 0x80) >> 7
}
func (o *CCL_Type) SetLUTCTRL2_INSEL0(value uint32) {
	volatile.StoreUint32(&o.LUTCTRL2.Reg, volatile.LoadUint32(&o.LUTCTRL2.Reg)&^(0xf00)|value<<8)
}
func (o *CCL_Type) GetLUTCTRL2_INSEL0() uint32 {
	return (volatile.LoadUint32(&o.LUTCTRL2.Reg) & 0xf00) >> 8
}
func (o *CCL_Type) SetLUTCTRL2_INSEL1(value uint32) {
	volatile.StoreUint32(&o.LUTCTRL2.Reg, volatile.LoadUint32(&o.LUTCTRL2.Reg)&^(0xf000)|value<<12)
}
func (o *CCL_Type) GetLUTCTRL2_INSEL1() uint32 {
	return (volatile.LoadUint32(&o.LUTCTRL2.Reg) & 0xf000) >> 12
}
func (o *CCL_Type) SetLUTCTRL2_INSEL2(value uint32) {
	volatile.StoreUint32(&o.LUTCTRL2.Reg, volatile.LoadUint32(&o.LUTCTRL2.Reg)&^(0xf0000)|value<<16)
}
func (o *CCL_Type) GetLUTCTRL2_INSEL2() uint32 {
	return (volatile.LoadUint32(&o.LUTCTRL2.Reg) & 0xf0000) >> 16
}
func (o *CCL_Type) SetLUTCTRL2_INVEI(value uint32) {
	volatile.StoreUint32(&o.LUTCTRL2.Reg, volatile.LoadUint32(&o.LUTCTRL2.Reg)&^(0x100000)|value<<20)
}
func (o *CCL_Type) GetLUTCTRL2_INVEI() uint32 {
	return (volatile.LoadUint32(&o.LUTCTRL2.Reg) & 0x100000) >> 20
}
func (o *CCL_Type) SetLUTCTRL2_LUTEI(value uint32) {
	volatile.StoreUint32(&o.LUTCTRL2.Reg, volatile.LoadUint32(&o.LUTCTRL2.Reg)&^(0x200000)|value<<21)
}
func (o *CCL_Type) GetLUTCTRL2_LUTEI() uint32 {
	return (volatile.LoadUint32(&o.LUTCTRL2.Reg) & 0x200000) >> 21
}
func (o *CCL_Type) SetLUTCTRL2_LUTEO(value uint32) {
	volatile.StoreUint32(&o.LUTCTRL2.Reg, volatile.LoadUint32(&o.LUTCTRL2.Reg)&^(0x400000)|value<<22)
}
func (o *CCL_Type) GetLUTCTRL2_LUTEO() uint32 {
	return (volatile.LoadUint32(&o.LUTCTRL2.Reg) & 0x400000) >> 22
}
func (o *CCL_Type) SetLUTCTRL2_TRUTH(value uint32) {
	volatile.StoreUint32(&o.LUTCTRL2.Reg, volatile.LoadUint32(&o.LUTCTRL2.Reg)&^(0xff000000)|value<<24)
}
func (o *CCL_Type) GetLUTCTRL2_TRUTH() uint32 {
	return (volatile.LoadUint32(&o.LUTCTRL2.Reg) & 0xff000000) >> 24
}

// CCL.LUTCTRL3: LUT Control x
func (o *CCL_Type) SetLUTCTRL3_ENABLE(value uint32) {
	volatile.StoreUint32(&o.LUTCTRL3.Reg, volatile.LoadUint32(&o.LUTCTRL3.Reg)&^(0x2)|value<<1)
}
func (o *CCL_Type) GetLUTCTRL3_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.LUTCTRL3.Reg) & 0x2) >> 1
}
func (o *CCL_Type) SetLUTCTRL3_FILTSEL(value uint32) {
	volatile.StoreUint32(&o.LUTCTRL3.Reg, volatile.LoadUint32(&o.LUTCTRL3.Reg)&^(0x30)|value<<4)
}
func (o *CCL_Type) GetLUTCTRL3_FILTSEL() uint32 {
	return (volatile.LoadUint32(&o.LUTCTRL3.Reg) & 0x30) >> 4
}
func (o *CCL_Type) SetLUTCTRL3_EDGESEL(value uint32) {
	volatile.StoreUint32(&o.LUTCTRL3.Reg, volatile.LoadUint32(&o.LUTCTRL3.Reg)&^(0x80)|value<<7)
}
func (o *CCL_Type) GetLUTCTRL3_EDGESEL() uint32 {
	return (volatile.LoadUint32(&o.LUTCTRL3.Reg) & 0x80) >> 7
}
func (o *CCL_Type) SetLUTCTRL3_INSEL0(value uint32) {
	volatile.StoreUint32(&o.LUTCTRL3.Reg, volatile.LoadUint32(&o.LUTCTRL3.Reg)&^(0xf00)|value<<8)
}
func (o *CCL_Type) GetLUTCTRL3_INSEL0() uint32 {
	return (volatile.LoadUint32(&o.LUTCTRL3.Reg) & 0xf00) >> 8
}
func (o *CCL_Type) SetLUTCTRL3_INSEL1(value uint32) {
	volatile.StoreUint32(&o.LUTCTRL3.Reg, volatile.LoadUint32(&o.LUTCTRL3.Reg)&^(0xf000)|value<<12)
}
func (o *CCL_Type) GetLUTCTRL3_INSEL1() uint32 {
	return (volatile.LoadUint32(&o.LUTCTRL3.Reg) & 0xf000) >> 12
}
func (o *CCL_Type) SetLUTCTRL3_INSEL2(value uint32) {
	volatile.StoreUint32(&o.LUTCTRL3.Reg, volatile.LoadUint32(&o.LUTCTRL3.Reg)&^(0xf0000)|value<<16)
}
func (o *CCL_Type) GetLUTCTRL3_INSEL2() uint32 {
	return (volatile.LoadUint32(&o.LUTCTRL3.Reg) & 0xf0000) >> 16
}
func (o *CCL_Type) SetLUTCTRL3_INVEI(value uint32) {
	volatile.StoreUint32(&o.LUTCTRL3.Reg, volatile.LoadUint32(&o.LUTCTRL3.Reg)&^(0x100000)|value<<20)
}
func (o *CCL_Type) GetLUTCTRL3_INVEI() uint32 {
	return (volatile.LoadUint32(&o.LUTCTRL3.Reg) & 0x100000) >> 20
}
func (o *CCL_Type) SetLUTCTRL3_LUTEI(value uint32) {
	volatile.StoreUint32(&o.LUTCTRL3.Reg, volatile.LoadUint32(&o.LUTCTRL3.Reg)&^(0x200000)|value<<21)
}
func (o *CCL_Type) GetLUTCTRL3_LUTEI() uint32 {
	return (volatile.LoadUint32(&o.LUTCTRL3.Reg) & 0x200000) >> 21
}
func (o *CCL_Type) SetLUTCTRL3_LUTEO(value uint32) {
	volatile.StoreUint32(&o.LUTCTRL3.Reg, volatile.LoadUint32(&o.LUTCTRL3.Reg)&^(0x400000)|value<<22)
}
func (o *CCL_Type) GetLUTCTRL3_LUTEO() uint32 {
	return (volatile.LoadUint32(&o.LUTCTRL3.Reg) & 0x400000) >> 22
}
func (o *CCL_Type) SetLUTCTRL3_TRUTH(value uint32) {
	volatile.StoreUint32(&o.LUTCTRL3.Reg, volatile.LoadUint32(&o.LUTCTRL3.Reg)&^(0xff000000)|value<<24)
}
func (o *CCL_Type) GetLUTCTRL3_TRUTH() uint32 {
	return (volatile.LoadUint32(&o.LUTCTRL3.Reg) & 0xff000000) >> 24
}

// Direct Memory Access Controller
type DMAC_Type struct {
	CTRL       volatile.Register16 // 0x0
	CRCCTRL    volatile.Register16 // 0x2
	CRCDATAIN  volatile.Register32 // 0x4
	CRCCHKSUM  volatile.Register32 // 0x8
	CRCSTATUS  volatile.Register8  // 0xC
	DBGCTRL    volatile.Register8  // 0xD
	QOSCTRL    volatile.Register8  // 0xE
	_          byte
	SWTRIGCTRL volatile.Register32 // 0x10
	PRICTRL0   volatile.Register32 // 0x14
	_          [8]byte
	INTPEND    volatile.Register16 // 0x20
	_          [2]byte
	INTSTATUS  volatile.Register32 // 0x24
	BUSYCH     volatile.Register32 // 0x28
	PENDCH     volatile.Register32 // 0x2C
	ACTIVE     volatile.Register32 // 0x30
	BASEADDR   volatile.Register32 // 0x34
	WRBADDR    volatile.Register32 // 0x38
	_          [3]byte
	CHID       volatile.Register8 // 0x3F
	CHCTRLA    volatile.Register8 // 0x40
	_          [3]byte
	CHCTRLB    volatile.Register32 // 0x44
	_          [4]byte
	CHINTENCLR volatile.Register8 // 0x4C
	CHINTENSET volatile.Register8 // 0x4D
	CHINTFLAG  volatile.Register8 // 0x4E
	CHSTATUS   volatile.Register8 // 0x4F
}

// DMAC.CTRL: Control
func (o *DMAC_Type) SetCTRL_SWRST(value uint16) {
	volatile.StoreUint16(&o.CTRL.Reg, volatile.LoadUint16(&o.CTRL.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetCTRL_SWRST() uint16 {
	return volatile.LoadUint16(&o.CTRL.Reg) & 0x1
}
func (o *DMAC_Type) SetCTRL_DMAENABLE(value uint16) {
	volatile.StoreUint16(&o.CTRL.Reg, volatile.LoadUint16(&o.CTRL.Reg)&^(0x2)|value<<1)
}
func (o *DMAC_Type) GetCTRL_DMAENABLE() uint16 {
	return (volatile.LoadUint16(&o.CTRL.Reg) & 0x2) >> 1
}
func (o *DMAC_Type) SetCTRL_CRCENABLE(value uint16) {
	volatile.StoreUint16(&o.CTRL.Reg, volatile.LoadUint16(&o.CTRL.Reg)&^(0x4)|value<<2)
}
func (o *DMAC_Type) GetCTRL_CRCENABLE() uint16 {
	return (volatile.LoadUint16(&o.CTRL.Reg) & 0x4) >> 2
}
func (o *DMAC_Type) SetCTRL_LVLEN0(value uint16) {
	volatile.StoreUint16(&o.CTRL.Reg, volatile.LoadUint16(&o.CTRL.Reg)&^(0x100)|value<<8)
}
func (o *DMAC_Type) GetCTRL_LVLEN0() uint16 {
	return (volatile.LoadUint16(&o.CTRL.Reg) & 0x100) >> 8
}
func (o *DMAC_Type) SetCTRL_LVLEN1(value uint16) {
	volatile.StoreUint16(&o.CTRL.Reg, volatile.LoadUint16(&o.CTRL.Reg)&^(0x200)|value<<9)
}
func (o *DMAC_Type) GetCTRL_LVLEN1() uint16 {
	return (volatile.LoadUint16(&o.CTRL.Reg) & 0x200) >> 9
}
func (o *DMAC_Type) SetCTRL_LVLEN2(value uint16) {
	volatile.StoreUint16(&o.CTRL.Reg, volatile.LoadUint16(&o.CTRL.Reg)&^(0x400)|value<<10)
}
func (o *DMAC_Type) GetCTRL_LVLEN2() uint16 {
	return (volatile.LoadUint16(&o.CTRL.Reg) & 0x400) >> 10
}
func (o *DMAC_Type) SetCTRL_LVLEN3(value uint16) {
	volatile.StoreUint16(&o.CTRL.Reg, volatile.LoadUint16(&o.CTRL.Reg)&^(0x800)|value<<11)
}
func (o *DMAC_Type) GetCTRL_LVLEN3() uint16 {
	return (volatile.LoadUint16(&o.CTRL.Reg) & 0x800) >> 11
}

// DMAC.CRCCTRL: CRC Control
func (o *DMAC_Type) SetCRCCTRL_CRCBEATSIZE(value uint16) {
	volatile.StoreUint16(&o.CRCCTRL.Reg, volatile.LoadUint16(&o.CRCCTRL.Reg)&^(0x3)|value)
}
func (o *DMAC_Type) GetCRCCTRL_CRCBEATSIZE() uint16 {
	return volatile.LoadUint16(&o.CRCCTRL.Reg) & 0x3
}
func (o *DMAC_Type) SetCRCCTRL_CRCPOLY(value uint16) {
	volatile.StoreUint16(&o.CRCCTRL.Reg, volatile.LoadUint16(&o.CRCCTRL.Reg)&^(0xc)|value<<2)
}
func (o *DMAC_Type) GetCRCCTRL_CRCPOLY() uint16 {
	return (volatile.LoadUint16(&o.CRCCTRL.Reg) & 0xc) >> 2
}
func (o *DMAC_Type) SetCRCCTRL_CRCSRC(value uint16) {
	volatile.StoreUint16(&o.CRCCTRL.Reg, volatile.LoadUint16(&o.CRCCTRL.Reg)&^(0x3f00)|value<<8)
}
func (o *DMAC_Type) GetCRCCTRL_CRCSRC() uint16 {
	return (volatile.LoadUint16(&o.CRCCTRL.Reg) & 0x3f00) >> 8
}

// DMAC.CRCDATAIN: CRC Data Input
func (o *DMAC_Type) SetCRCDATAIN(value uint32) {
	volatile.StoreUint32(&o.CRCDATAIN.Reg, value)
}
func (o *DMAC_Type) GetCRCDATAIN() uint32 {
	return volatile.LoadUint32(&o.CRCDATAIN.Reg)
}

// DMAC.CRCCHKSUM: CRC Checksum
func (o *DMAC_Type) SetCRCCHKSUM(value uint32) {
	volatile.StoreUint32(&o.CRCCHKSUM.Reg, value)
}
func (o *DMAC_Type) GetCRCCHKSUM() uint32 {
	return volatile.LoadUint32(&o.CRCCHKSUM.Reg)
}

// DMAC.CRCSTATUS: CRC Status
func (o *DMAC_Type) SetCRCSTATUS_CRCBUSY(value uint8) {
	volatile.StoreUint8(&o.CRCSTATUS.Reg, volatile.LoadUint8(&o.CRCSTATUS.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetCRCSTATUS_CRCBUSY() uint8 {
	return volatile.LoadUint8(&o.CRCSTATUS.Reg) & 0x1
}
func (o *DMAC_Type) SetCRCSTATUS_CRCZERO(value uint8) {
	volatile.StoreUint8(&o.CRCSTATUS.Reg, volatile.LoadUint8(&o.CRCSTATUS.Reg)&^(0x2)|value<<1)
}
func (o *DMAC_Type) GetCRCSTATUS_CRCZERO() uint8 {
	return (volatile.LoadUint8(&o.CRCSTATUS.Reg) & 0x2) >> 1
}

// DMAC.DBGCTRL: Debug Control
func (o *DMAC_Type) SetDBGCTRL_DBGRUN(value uint8) {
	volatile.StoreUint8(&o.DBGCTRL.Reg, volatile.LoadUint8(&o.DBGCTRL.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetDBGCTRL_DBGRUN() uint8 {
	return volatile.LoadUint8(&o.DBGCTRL.Reg) & 0x1
}

// DMAC.QOSCTRL: QOS Control
func (o *DMAC_Type) SetQOSCTRL_WRBQOS(value uint8) {
	volatile.StoreUint8(&o.QOSCTRL.Reg, volatile.LoadUint8(&o.QOSCTRL.Reg)&^(0x3)|value)
}
func (o *DMAC_Type) GetQOSCTRL_WRBQOS() uint8 {
	return volatile.LoadUint8(&o.QOSCTRL.Reg) & 0x3
}
func (o *DMAC_Type) SetQOSCTRL_FQOS(value uint8) {
	volatile.StoreUint8(&o.QOSCTRL.Reg, volatile.LoadUint8(&o.QOSCTRL.Reg)&^(0xc)|value<<2)
}
func (o *DMAC_Type) GetQOSCTRL_FQOS() uint8 {
	return (volatile.LoadUint8(&o.QOSCTRL.Reg) & 0xc) >> 2
}
func (o *DMAC_Type) SetQOSCTRL_DQOS(value uint8) {
	volatile.StoreUint8(&o.QOSCTRL.Reg, volatile.LoadUint8(&o.QOSCTRL.Reg)&^(0x30)|value<<4)
}
func (o *DMAC_Type) GetQOSCTRL_DQOS() uint8 {
	return (volatile.LoadUint8(&o.QOSCTRL.Reg) & 0x30) >> 4
}

// DMAC.SWTRIGCTRL: Software Trigger Control
func (o *DMAC_Type) SetSWTRIGCTRL_SWTRIG0(value uint32) {
	volatile.StoreUint32(&o.SWTRIGCTRL.Reg, volatile.LoadUint32(&o.SWTRIGCTRL.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetSWTRIGCTRL_SWTRIG0() uint32 {
	return volatile.LoadUint32(&o.SWTRIGCTRL.Reg) & 0x1
}
func (o *DMAC_Type) SetSWTRIGCTRL_SWTRIG1(value uint32) {
	volatile.StoreUint32(&o.SWTRIGCTRL.Reg, volatile.LoadUint32(&o.SWTRIGCTRL.Reg)&^(0x2)|value<<1)
}
func (o *DMAC_Type) GetSWTRIGCTRL_SWTRIG1() uint32 {
	return (volatile.LoadUint32(&o.SWTRIGCTRL.Reg) & 0x2) >> 1
}
func (o *DMAC_Type) SetSWTRIGCTRL_SWTRIG2(value uint32) {
	volatile.StoreUint32(&o.SWTRIGCTRL.Reg, volatile.LoadUint32(&o.SWTRIGCTRL.Reg)&^(0x4)|value<<2)
}
func (o *DMAC_Type) GetSWTRIGCTRL_SWTRIG2() uint32 {
	return (volatile.LoadUint32(&o.SWTRIGCTRL.Reg) & 0x4) >> 2
}
func (o *DMAC_Type) SetSWTRIGCTRL_SWTRIG3(value uint32) {
	volatile.StoreUint32(&o.SWTRIGCTRL.Reg, volatile.LoadUint32(&o.SWTRIGCTRL.Reg)&^(0x8)|value<<3)
}
func (o *DMAC_Type) GetSWTRIGCTRL_SWTRIG3() uint32 {
	return (volatile.LoadUint32(&o.SWTRIGCTRL.Reg) & 0x8) >> 3
}
func (o *DMAC_Type) SetSWTRIGCTRL_SWTRIG4(value uint32) {
	volatile.StoreUint32(&o.SWTRIGCTRL.Reg, volatile.LoadUint32(&o.SWTRIGCTRL.Reg)&^(0x10)|value<<4)
}
func (o *DMAC_Type) GetSWTRIGCTRL_SWTRIG4() uint32 {
	return (volatile.LoadUint32(&o.SWTRIGCTRL.Reg) & 0x10) >> 4
}
func (o *DMAC_Type) SetSWTRIGCTRL_SWTRIG5(value uint32) {
	volatile.StoreUint32(&o.SWTRIGCTRL.Reg, volatile.LoadUint32(&o.SWTRIGCTRL.Reg)&^(0x20)|value<<5)
}
func (o *DMAC_Type) GetSWTRIGCTRL_SWTRIG5() uint32 {
	return (volatile.LoadUint32(&o.SWTRIGCTRL.Reg) & 0x20) >> 5
}
func (o *DMAC_Type) SetSWTRIGCTRL_SWTRIG6(value uint32) {
	volatile.StoreUint32(&o.SWTRIGCTRL.Reg, volatile.LoadUint32(&o.SWTRIGCTRL.Reg)&^(0x40)|value<<6)
}
func (o *DMAC_Type) GetSWTRIGCTRL_SWTRIG6() uint32 {
	return (volatile.LoadUint32(&o.SWTRIGCTRL.Reg) & 0x40) >> 6
}
func (o *DMAC_Type) SetSWTRIGCTRL_SWTRIG7(value uint32) {
	volatile.StoreUint32(&o.SWTRIGCTRL.Reg, volatile.LoadUint32(&o.SWTRIGCTRL.Reg)&^(0x80)|value<<7)
}
func (o *DMAC_Type) GetSWTRIGCTRL_SWTRIG7() uint32 {
	return (volatile.LoadUint32(&o.SWTRIGCTRL.Reg) & 0x80) >> 7
}
func (o *DMAC_Type) SetSWTRIGCTRL_SWTRIG8(value uint32) {
	volatile.StoreUint32(&o.SWTRIGCTRL.Reg, volatile.LoadUint32(&o.SWTRIGCTRL.Reg)&^(0x100)|value<<8)
}
func (o *DMAC_Type) GetSWTRIGCTRL_SWTRIG8() uint32 {
	return (volatile.LoadUint32(&o.SWTRIGCTRL.Reg) & 0x100) >> 8
}
func (o *DMAC_Type) SetSWTRIGCTRL_SWTRIG9(value uint32) {
	volatile.StoreUint32(&o.SWTRIGCTRL.Reg, volatile.LoadUint32(&o.SWTRIGCTRL.Reg)&^(0x200)|value<<9)
}
func (o *DMAC_Type) GetSWTRIGCTRL_SWTRIG9() uint32 {
	return (volatile.LoadUint32(&o.SWTRIGCTRL.Reg) & 0x200) >> 9
}
func (o *DMAC_Type) SetSWTRIGCTRL_SWTRIG10(value uint32) {
	volatile.StoreUint32(&o.SWTRIGCTRL.Reg, volatile.LoadUint32(&o.SWTRIGCTRL.Reg)&^(0x400)|value<<10)
}
func (o *DMAC_Type) GetSWTRIGCTRL_SWTRIG10() uint32 {
	return (volatile.LoadUint32(&o.SWTRIGCTRL.Reg) & 0x400) >> 10
}
func (o *DMAC_Type) SetSWTRIGCTRL_SWTRIG11(value uint32) {
	volatile.StoreUint32(&o.SWTRIGCTRL.Reg, volatile.LoadUint32(&o.SWTRIGCTRL.Reg)&^(0x800)|value<<11)
}
func (o *DMAC_Type) GetSWTRIGCTRL_SWTRIG11() uint32 {
	return (volatile.LoadUint32(&o.SWTRIGCTRL.Reg) & 0x800) >> 11
}
func (o *DMAC_Type) SetSWTRIGCTRL_SWTRIG12(value uint32) {
	volatile.StoreUint32(&o.SWTRIGCTRL.Reg, volatile.LoadUint32(&o.SWTRIGCTRL.Reg)&^(0x1000)|value<<12)
}
func (o *DMAC_Type) GetSWTRIGCTRL_SWTRIG12() uint32 {
	return (volatile.LoadUint32(&o.SWTRIGCTRL.Reg) & 0x1000) >> 12
}
func (o *DMAC_Type) SetSWTRIGCTRL_SWTRIG13(value uint32) {
	volatile.StoreUint32(&o.SWTRIGCTRL.Reg, volatile.LoadUint32(&o.SWTRIGCTRL.Reg)&^(0x2000)|value<<13)
}
func (o *DMAC_Type) GetSWTRIGCTRL_SWTRIG13() uint32 {
	return (volatile.LoadUint32(&o.SWTRIGCTRL.Reg) & 0x2000) >> 13
}
func (o *DMAC_Type) SetSWTRIGCTRL_SWTRIG14(value uint32) {
	volatile.StoreUint32(&o.SWTRIGCTRL.Reg, volatile.LoadUint32(&o.SWTRIGCTRL.Reg)&^(0x4000)|value<<14)
}
func (o *DMAC_Type) GetSWTRIGCTRL_SWTRIG14() uint32 {
	return (volatile.LoadUint32(&o.SWTRIGCTRL.Reg) & 0x4000) >> 14
}
func (o *DMAC_Type) SetSWTRIGCTRL_SWTRIG15(value uint32) {
	volatile.StoreUint32(&o.SWTRIGCTRL.Reg, volatile.LoadUint32(&o.SWTRIGCTRL.Reg)&^(0x8000)|value<<15)
}
func (o *DMAC_Type) GetSWTRIGCTRL_SWTRIG15() uint32 {
	return (volatile.LoadUint32(&o.SWTRIGCTRL.Reg) & 0x8000) >> 15
}

// DMAC.PRICTRL0: Priority Control 0
func (o *DMAC_Type) SetPRICTRL0_LVLPRI0(value uint32) {
	volatile.StoreUint32(&o.PRICTRL0.Reg, volatile.LoadUint32(&o.PRICTRL0.Reg)&^(0xf)|value)
}
func (o *DMAC_Type) GetPRICTRL0_LVLPRI0() uint32 {
	return volatile.LoadUint32(&o.PRICTRL0.Reg) & 0xf
}
func (o *DMAC_Type) SetPRICTRL0_RRLVLEN0(value uint32) {
	volatile.StoreUint32(&o.PRICTRL0.Reg, volatile.LoadUint32(&o.PRICTRL0.Reg)&^(0x80)|value<<7)
}
func (o *DMAC_Type) GetPRICTRL0_RRLVLEN0() uint32 {
	return (volatile.LoadUint32(&o.PRICTRL0.Reg) & 0x80) >> 7
}
func (o *DMAC_Type) SetPRICTRL0_LVLPRI1(value uint32) {
	volatile.StoreUint32(&o.PRICTRL0.Reg, volatile.LoadUint32(&o.PRICTRL0.Reg)&^(0xf00)|value<<8)
}
func (o *DMAC_Type) GetPRICTRL0_LVLPRI1() uint32 {
	return (volatile.LoadUint32(&o.PRICTRL0.Reg) & 0xf00) >> 8
}
func (o *DMAC_Type) SetPRICTRL0_RRLVLEN1(value uint32) {
	volatile.StoreUint32(&o.PRICTRL0.Reg, volatile.LoadUint32(&o.PRICTRL0.Reg)&^(0x8000)|value<<15)
}
func (o *DMAC_Type) GetPRICTRL0_RRLVLEN1() uint32 {
	return (volatile.LoadUint32(&o.PRICTRL0.Reg) & 0x8000) >> 15
}
func (o *DMAC_Type) SetPRICTRL0_LVLPRI2(value uint32) {
	volatile.StoreUint32(&o.PRICTRL0.Reg, volatile.LoadUint32(&o.PRICTRL0.Reg)&^(0xf0000)|value<<16)
}
func (o *DMAC_Type) GetPRICTRL0_LVLPRI2() uint32 {
	return (volatile.LoadUint32(&o.PRICTRL0.Reg) & 0xf0000) >> 16
}
func (o *DMAC_Type) SetPRICTRL0_RRLVLEN2(value uint32) {
	volatile.StoreUint32(&o.PRICTRL0.Reg, volatile.LoadUint32(&o.PRICTRL0.Reg)&^(0x800000)|value<<23)
}
func (o *DMAC_Type) GetPRICTRL0_RRLVLEN2() uint32 {
	return (volatile.LoadUint32(&o.PRICTRL0.Reg) & 0x800000) >> 23
}
func (o *DMAC_Type) SetPRICTRL0_LVLPRI3(value uint32) {
	volatile.StoreUint32(&o.PRICTRL0.Reg, volatile.LoadUint32(&o.PRICTRL0.Reg)&^(0xf000000)|value<<24)
}
func (o *DMAC_Type) GetPRICTRL0_LVLPRI3() uint32 {
	return (volatile.LoadUint32(&o.PRICTRL0.Reg) & 0xf000000) >> 24
}
func (o *DMAC_Type) SetPRICTRL0_RRLVLEN3(value uint32) {
	volatile.StoreUint32(&o.PRICTRL0.Reg, volatile.LoadUint32(&o.PRICTRL0.Reg)&^(0x80000000)|value<<31)
}
func (o *DMAC_Type) GetPRICTRL0_RRLVLEN3() uint32 {
	return (volatile.LoadUint32(&o.PRICTRL0.Reg) & 0x80000000) >> 31
}

// DMAC.INTPEND: Interrupt Pending
func (o *DMAC_Type) SetINTPEND_ID(value uint16) {
	volatile.StoreUint16(&o.INTPEND.Reg, volatile.LoadUint16(&o.INTPEND.Reg)&^(0xf)|value)
}
func (o *DMAC_Type) GetINTPEND_ID() uint16 {
	return volatile.LoadUint16(&o.INTPEND.Reg) & 0xf
}
func (o *DMAC_Type) SetINTPEND_TERR(value uint16) {
	volatile.StoreUint16(&o.INTPEND.Reg, volatile.LoadUint16(&o.INTPEND.Reg)&^(0x100)|value<<8)
}
func (o *DMAC_Type) GetINTPEND_TERR() uint16 {
	return (volatile.LoadUint16(&o.INTPEND.Reg) & 0x100) >> 8
}
func (o *DMAC_Type) SetINTPEND_TCMPL(value uint16) {
	volatile.StoreUint16(&o.INTPEND.Reg, volatile.LoadUint16(&o.INTPEND.Reg)&^(0x200)|value<<9)
}
func (o *DMAC_Type) GetINTPEND_TCMPL() uint16 {
	return (volatile.LoadUint16(&o.INTPEND.Reg) & 0x200) >> 9
}
func (o *DMAC_Type) SetINTPEND_SUSP(value uint16) {
	volatile.StoreUint16(&o.INTPEND.Reg, volatile.LoadUint16(&o.INTPEND.Reg)&^(0x400)|value<<10)
}
func (o *DMAC_Type) GetINTPEND_SUSP() uint16 {
	return (volatile.LoadUint16(&o.INTPEND.Reg) & 0x400) >> 10
}
func (o *DMAC_Type) SetINTPEND_FERR(value uint16) {
	volatile.StoreUint16(&o.INTPEND.Reg, volatile.LoadUint16(&o.INTPEND.Reg)&^(0x2000)|value<<13)
}
func (o *DMAC_Type) GetINTPEND_FERR() uint16 {
	return (volatile.LoadUint16(&o.INTPEND.Reg) & 0x2000) >> 13
}
func (o *DMAC_Type) SetINTPEND_BUSY(value uint16) {
	volatile.StoreUint16(&o.INTPEND.Reg, volatile.LoadUint16(&o.INTPEND.Reg)&^(0x4000)|value<<14)
}
func (o *DMAC_Type) GetINTPEND_BUSY() uint16 {
	return (volatile.LoadUint16(&o.INTPEND.Reg) & 0x4000) >> 14
}
func (o *DMAC_Type) SetINTPEND_PEND(value uint16) {
	volatile.StoreUint16(&o.INTPEND.Reg, volatile.LoadUint16(&o.INTPEND.Reg)&^(0x8000)|value<<15)
}
func (o *DMAC_Type) GetINTPEND_PEND() uint16 {
	return (volatile.LoadUint16(&o.INTPEND.Reg) & 0x8000) >> 15
}

// DMAC.INTSTATUS: Interrupt Status
func (o *DMAC_Type) SetINTSTATUS_CHINT0(value uint32) {
	volatile.StoreUint32(&o.INTSTATUS.Reg, volatile.LoadUint32(&o.INTSTATUS.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetINTSTATUS_CHINT0() uint32 {
	return volatile.LoadUint32(&o.INTSTATUS.Reg) & 0x1
}
func (o *DMAC_Type) SetINTSTATUS_CHINT1(value uint32) {
	volatile.StoreUint32(&o.INTSTATUS.Reg, volatile.LoadUint32(&o.INTSTATUS.Reg)&^(0x2)|value<<1)
}
func (o *DMAC_Type) GetINTSTATUS_CHINT1() uint32 {
	return (volatile.LoadUint32(&o.INTSTATUS.Reg) & 0x2) >> 1
}
func (o *DMAC_Type) SetINTSTATUS_CHINT2(value uint32) {
	volatile.StoreUint32(&o.INTSTATUS.Reg, volatile.LoadUint32(&o.INTSTATUS.Reg)&^(0x4)|value<<2)
}
func (o *DMAC_Type) GetINTSTATUS_CHINT2() uint32 {
	return (volatile.LoadUint32(&o.INTSTATUS.Reg) & 0x4) >> 2
}
func (o *DMAC_Type) SetINTSTATUS_CHINT3(value uint32) {
	volatile.StoreUint32(&o.INTSTATUS.Reg, volatile.LoadUint32(&o.INTSTATUS.Reg)&^(0x8)|value<<3)
}
func (o *DMAC_Type) GetINTSTATUS_CHINT3() uint32 {
	return (volatile.LoadUint32(&o.INTSTATUS.Reg) & 0x8) >> 3
}
func (o *DMAC_Type) SetINTSTATUS_CHINT4(value uint32) {
	volatile.StoreUint32(&o.INTSTATUS.Reg, volatile.LoadUint32(&o.INTSTATUS.Reg)&^(0x10)|value<<4)
}
func (o *DMAC_Type) GetINTSTATUS_CHINT4() uint32 {
	return (volatile.LoadUint32(&o.INTSTATUS.Reg) & 0x10) >> 4
}
func (o *DMAC_Type) SetINTSTATUS_CHINT5(value uint32) {
	volatile.StoreUint32(&o.INTSTATUS.Reg, volatile.LoadUint32(&o.INTSTATUS.Reg)&^(0x20)|value<<5)
}
func (o *DMAC_Type) GetINTSTATUS_CHINT5() uint32 {
	return (volatile.LoadUint32(&o.INTSTATUS.Reg) & 0x20) >> 5
}
func (o *DMAC_Type) SetINTSTATUS_CHINT6(value uint32) {
	volatile.StoreUint32(&o.INTSTATUS.Reg, volatile.LoadUint32(&o.INTSTATUS.Reg)&^(0x40)|value<<6)
}
func (o *DMAC_Type) GetINTSTATUS_CHINT6() uint32 {
	return (volatile.LoadUint32(&o.INTSTATUS.Reg) & 0x40) >> 6
}
func (o *DMAC_Type) SetINTSTATUS_CHINT7(value uint32) {
	volatile.StoreUint32(&o.INTSTATUS.Reg, volatile.LoadUint32(&o.INTSTATUS.Reg)&^(0x80)|value<<7)
}
func (o *DMAC_Type) GetINTSTATUS_CHINT7() uint32 {
	return (volatile.LoadUint32(&o.INTSTATUS.Reg) & 0x80) >> 7
}
func (o *DMAC_Type) SetINTSTATUS_CHINT8(value uint32) {
	volatile.StoreUint32(&o.INTSTATUS.Reg, volatile.LoadUint32(&o.INTSTATUS.Reg)&^(0x100)|value<<8)
}
func (o *DMAC_Type) GetINTSTATUS_CHINT8() uint32 {
	return (volatile.LoadUint32(&o.INTSTATUS.Reg) & 0x100) >> 8
}
func (o *DMAC_Type) SetINTSTATUS_CHINT9(value uint32) {
	volatile.StoreUint32(&o.INTSTATUS.Reg, volatile.LoadUint32(&o.INTSTATUS.Reg)&^(0x200)|value<<9)
}
func (o *DMAC_Type) GetINTSTATUS_CHINT9() uint32 {
	return (volatile.LoadUint32(&o.INTSTATUS.Reg) & 0x200) >> 9
}
func (o *DMAC_Type) SetINTSTATUS_CHINT10(value uint32) {
	volatile.StoreUint32(&o.INTSTATUS.Reg, volatile.LoadUint32(&o.INTSTATUS.Reg)&^(0x400)|value<<10)
}
func (o *DMAC_Type) GetINTSTATUS_CHINT10() uint32 {
	return (volatile.LoadUint32(&o.INTSTATUS.Reg) & 0x400) >> 10
}
func (o *DMAC_Type) SetINTSTATUS_CHINT11(value uint32) {
	volatile.StoreUint32(&o.INTSTATUS.Reg, volatile.LoadUint32(&o.INTSTATUS.Reg)&^(0x800)|value<<11)
}
func (o *DMAC_Type) GetINTSTATUS_CHINT11() uint32 {
	return (volatile.LoadUint32(&o.INTSTATUS.Reg) & 0x800) >> 11
}
func (o *DMAC_Type) SetINTSTATUS_CHINT12(value uint32) {
	volatile.StoreUint32(&o.INTSTATUS.Reg, volatile.LoadUint32(&o.INTSTATUS.Reg)&^(0x1000)|value<<12)
}
func (o *DMAC_Type) GetINTSTATUS_CHINT12() uint32 {
	return (volatile.LoadUint32(&o.INTSTATUS.Reg) & 0x1000) >> 12
}
func (o *DMAC_Type) SetINTSTATUS_CHINT13(value uint32) {
	volatile.StoreUint32(&o.INTSTATUS.Reg, volatile.LoadUint32(&o.INTSTATUS.Reg)&^(0x2000)|value<<13)
}
func (o *DMAC_Type) GetINTSTATUS_CHINT13() uint32 {
	return (volatile.LoadUint32(&o.INTSTATUS.Reg) & 0x2000) >> 13
}
func (o *DMAC_Type) SetINTSTATUS_CHINT14(value uint32) {
	volatile.StoreUint32(&o.INTSTATUS.Reg, volatile.LoadUint32(&o.INTSTATUS.Reg)&^(0x4000)|value<<14)
}
func (o *DMAC_Type) GetINTSTATUS_CHINT14() uint32 {
	return (volatile.LoadUint32(&o.INTSTATUS.Reg) & 0x4000) >> 14
}
func (o *DMAC_Type) SetINTSTATUS_CHINT15(value uint32) {
	volatile.StoreUint32(&o.INTSTATUS.Reg, volatile.LoadUint32(&o.INTSTATUS.Reg)&^(0x8000)|value<<15)
}
func (o *DMAC_Type) GetINTSTATUS_CHINT15() uint32 {
	return (volatile.LoadUint32(&o.INTSTATUS.Reg) & 0x8000) >> 15
}

// DMAC.BUSYCH: Busy Channels
func (o *DMAC_Type) SetBUSYCH_BUSYCH0(value uint32) {
	volatile.StoreUint32(&o.BUSYCH.Reg, volatile.LoadUint32(&o.BUSYCH.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetBUSYCH_BUSYCH0() uint32 {
	return volatile.LoadUint32(&o.BUSYCH.Reg) & 0x1
}
func (o *DMAC_Type) SetBUSYCH_BUSYCH1(value uint32) {
	volatile.StoreUint32(&o.BUSYCH.Reg, volatile.LoadUint32(&o.BUSYCH.Reg)&^(0x2)|value<<1)
}
func (o *DMAC_Type) GetBUSYCH_BUSYCH1() uint32 {
	return (volatile.LoadUint32(&o.BUSYCH.Reg) & 0x2) >> 1
}
func (o *DMAC_Type) SetBUSYCH_BUSYCH2(value uint32) {
	volatile.StoreUint32(&o.BUSYCH.Reg, volatile.LoadUint32(&o.BUSYCH.Reg)&^(0x4)|value<<2)
}
func (o *DMAC_Type) GetBUSYCH_BUSYCH2() uint32 {
	return (volatile.LoadUint32(&o.BUSYCH.Reg) & 0x4) >> 2
}
func (o *DMAC_Type) SetBUSYCH_BUSYCH3(value uint32) {
	volatile.StoreUint32(&o.BUSYCH.Reg, volatile.LoadUint32(&o.BUSYCH.Reg)&^(0x8)|value<<3)
}
func (o *DMAC_Type) GetBUSYCH_BUSYCH3() uint32 {
	return (volatile.LoadUint32(&o.BUSYCH.Reg) & 0x8) >> 3
}
func (o *DMAC_Type) SetBUSYCH_BUSYCH4(value uint32) {
	volatile.StoreUint32(&o.BUSYCH.Reg, volatile.LoadUint32(&o.BUSYCH.Reg)&^(0x10)|value<<4)
}
func (o *DMAC_Type) GetBUSYCH_BUSYCH4() uint32 {
	return (volatile.LoadUint32(&o.BUSYCH.Reg) & 0x10) >> 4
}
func (o *DMAC_Type) SetBUSYCH_BUSYCH5(value uint32) {
	volatile.StoreUint32(&o.BUSYCH.Reg, volatile.LoadUint32(&o.BUSYCH.Reg)&^(0x20)|value<<5)
}
func (o *DMAC_Type) GetBUSYCH_BUSYCH5() uint32 {
	return (volatile.LoadUint32(&o.BUSYCH.Reg) & 0x20) >> 5
}
func (o *DMAC_Type) SetBUSYCH_BUSYCH6(value uint32) {
	volatile.StoreUint32(&o.BUSYCH.Reg, volatile.LoadUint32(&o.BUSYCH.Reg)&^(0x40)|value<<6)
}
func (o *DMAC_Type) GetBUSYCH_BUSYCH6() uint32 {
	return (volatile.LoadUint32(&o.BUSYCH.Reg) & 0x40) >> 6
}
func (o *DMAC_Type) SetBUSYCH_BUSYCH7(value uint32) {
	volatile.StoreUint32(&o.BUSYCH.Reg, volatile.LoadUint32(&o.BUSYCH.Reg)&^(0x80)|value<<7)
}
func (o *DMAC_Type) GetBUSYCH_BUSYCH7() uint32 {
	return (volatile.LoadUint32(&o.BUSYCH.Reg) & 0x80) >> 7
}
func (o *DMAC_Type) SetBUSYCH_BUSYCH8(value uint32) {
	volatile.StoreUint32(&o.BUSYCH.Reg, volatile.LoadUint32(&o.BUSYCH.Reg)&^(0x100)|value<<8)
}
func (o *DMAC_Type) GetBUSYCH_BUSYCH8() uint32 {
	return (volatile.LoadUint32(&o.BUSYCH.Reg) & 0x100) >> 8
}
func (o *DMAC_Type) SetBUSYCH_BUSYCH9(value uint32) {
	volatile.StoreUint32(&o.BUSYCH.Reg, volatile.LoadUint32(&o.BUSYCH.Reg)&^(0x200)|value<<9)
}
func (o *DMAC_Type) GetBUSYCH_BUSYCH9() uint32 {
	return (volatile.LoadUint32(&o.BUSYCH.Reg) & 0x200) >> 9
}
func (o *DMAC_Type) SetBUSYCH_BUSYCH10(value uint32) {
	volatile.StoreUint32(&o.BUSYCH.Reg, volatile.LoadUint32(&o.BUSYCH.Reg)&^(0x400)|value<<10)
}
func (o *DMAC_Type) GetBUSYCH_BUSYCH10() uint32 {
	return (volatile.LoadUint32(&o.BUSYCH.Reg) & 0x400) >> 10
}
func (o *DMAC_Type) SetBUSYCH_BUSYCH11(value uint32) {
	volatile.StoreUint32(&o.BUSYCH.Reg, volatile.LoadUint32(&o.BUSYCH.Reg)&^(0x800)|value<<11)
}
func (o *DMAC_Type) GetBUSYCH_BUSYCH11() uint32 {
	return (volatile.LoadUint32(&o.BUSYCH.Reg) & 0x800) >> 11
}
func (o *DMAC_Type) SetBUSYCH_BUSYCH12(value uint32) {
	volatile.StoreUint32(&o.BUSYCH.Reg, volatile.LoadUint32(&o.BUSYCH.Reg)&^(0x1000)|value<<12)
}
func (o *DMAC_Type) GetBUSYCH_BUSYCH12() uint32 {
	return (volatile.LoadUint32(&o.BUSYCH.Reg) & 0x1000) >> 12
}
func (o *DMAC_Type) SetBUSYCH_BUSYCH13(value uint32) {
	volatile.StoreUint32(&o.BUSYCH.Reg, volatile.LoadUint32(&o.BUSYCH.Reg)&^(0x2000)|value<<13)
}
func (o *DMAC_Type) GetBUSYCH_BUSYCH13() uint32 {
	return (volatile.LoadUint32(&o.BUSYCH.Reg) & 0x2000) >> 13
}
func (o *DMAC_Type) SetBUSYCH_BUSYCH14(value uint32) {
	volatile.StoreUint32(&o.BUSYCH.Reg, volatile.LoadUint32(&o.BUSYCH.Reg)&^(0x4000)|value<<14)
}
func (o *DMAC_Type) GetBUSYCH_BUSYCH14() uint32 {
	return (volatile.LoadUint32(&o.BUSYCH.Reg) & 0x4000) >> 14
}
func (o *DMAC_Type) SetBUSYCH_BUSYCH15(value uint32) {
	volatile.StoreUint32(&o.BUSYCH.Reg, volatile.LoadUint32(&o.BUSYCH.Reg)&^(0x8000)|value<<15)
}
func (o *DMAC_Type) GetBUSYCH_BUSYCH15() uint32 {
	return (volatile.LoadUint32(&o.BUSYCH.Reg) & 0x8000) >> 15
}

// DMAC.PENDCH: Pending Channels
func (o *DMAC_Type) SetPENDCH_PENDCH0(value uint32) {
	volatile.StoreUint32(&o.PENDCH.Reg, volatile.LoadUint32(&o.PENDCH.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetPENDCH_PENDCH0() uint32 {
	return volatile.LoadUint32(&o.PENDCH.Reg) & 0x1
}
func (o *DMAC_Type) SetPENDCH_PENDCH1(value uint32) {
	volatile.StoreUint32(&o.PENDCH.Reg, volatile.LoadUint32(&o.PENDCH.Reg)&^(0x2)|value<<1)
}
func (o *DMAC_Type) GetPENDCH_PENDCH1() uint32 {
	return (volatile.LoadUint32(&o.PENDCH.Reg) & 0x2) >> 1
}
func (o *DMAC_Type) SetPENDCH_PENDCH2(value uint32) {
	volatile.StoreUint32(&o.PENDCH.Reg, volatile.LoadUint32(&o.PENDCH.Reg)&^(0x4)|value<<2)
}
func (o *DMAC_Type) GetPENDCH_PENDCH2() uint32 {
	return (volatile.LoadUint32(&o.PENDCH.Reg) & 0x4) >> 2
}
func (o *DMAC_Type) SetPENDCH_PENDCH3(value uint32) {
	volatile.StoreUint32(&o.PENDCH.Reg, volatile.LoadUint32(&o.PENDCH.Reg)&^(0x8)|value<<3)
}
func (o *DMAC_Type) GetPENDCH_PENDCH3() uint32 {
	return (volatile.LoadUint32(&o.PENDCH.Reg) & 0x8) >> 3
}
func (o *DMAC_Type) SetPENDCH_PENDCH4(value uint32) {
	volatile.StoreUint32(&o.PENDCH.Reg, volatile.LoadUint32(&o.PENDCH.Reg)&^(0x10)|value<<4)
}
func (o *DMAC_Type) GetPENDCH_PENDCH4() uint32 {
	return (volatile.LoadUint32(&o.PENDCH.Reg) & 0x10) >> 4
}
func (o *DMAC_Type) SetPENDCH_PENDCH5(value uint32) {
	volatile.StoreUint32(&o.PENDCH.Reg, volatile.LoadUint32(&o.PENDCH.Reg)&^(0x20)|value<<5)
}
func (o *DMAC_Type) GetPENDCH_PENDCH5() uint32 {
	return (volatile.LoadUint32(&o.PENDCH.Reg) & 0x20) >> 5
}
func (o *DMAC_Type) SetPENDCH_PENDCH6(value uint32) {
	volatile.StoreUint32(&o.PENDCH.Reg, volatile.LoadUint32(&o.PENDCH.Reg)&^(0x40)|value<<6)
}
func (o *DMAC_Type) GetPENDCH_PENDCH6() uint32 {
	return (volatile.LoadUint32(&o.PENDCH.Reg) & 0x40) >> 6
}
func (o *DMAC_Type) SetPENDCH_PENDCH7(value uint32) {
	volatile.StoreUint32(&o.PENDCH.Reg, volatile.LoadUint32(&o.PENDCH.Reg)&^(0x80)|value<<7)
}
func (o *DMAC_Type) GetPENDCH_PENDCH7() uint32 {
	return (volatile.LoadUint32(&o.PENDCH.Reg) & 0x80) >> 7
}
func (o *DMAC_Type) SetPENDCH_PENDCH8(value uint32) {
	volatile.StoreUint32(&o.PENDCH.Reg, volatile.LoadUint32(&o.PENDCH.Reg)&^(0x100)|value<<8)
}
func (o *DMAC_Type) GetPENDCH_PENDCH8() uint32 {
	return (volatile.LoadUint32(&o.PENDCH.Reg) & 0x100) >> 8
}
func (o *DMAC_Type) SetPENDCH_PENDCH9(value uint32) {
	volatile.StoreUint32(&o.PENDCH.Reg, volatile.LoadUint32(&o.PENDCH.Reg)&^(0x200)|value<<9)
}
func (o *DMAC_Type) GetPENDCH_PENDCH9() uint32 {
	return (volatile.LoadUint32(&o.PENDCH.Reg) & 0x200) >> 9
}
func (o *DMAC_Type) SetPENDCH_PENDCH10(value uint32) {
	volatile.StoreUint32(&o.PENDCH.Reg, volatile.LoadUint32(&o.PENDCH.Reg)&^(0x400)|value<<10)
}
func (o *DMAC_Type) GetPENDCH_PENDCH10() uint32 {
	return (volatile.LoadUint32(&o.PENDCH.Reg) & 0x400) >> 10
}
func (o *DMAC_Type) SetPENDCH_PENDCH11(value uint32) {
	volatile.StoreUint32(&o.PENDCH.Reg, volatile.LoadUint32(&o.PENDCH.Reg)&^(0x800)|value<<11)
}
func (o *DMAC_Type) GetPENDCH_PENDCH11() uint32 {
	return (volatile.LoadUint32(&o.PENDCH.Reg) & 0x800) >> 11
}
func (o *DMAC_Type) SetPENDCH_PENDCH12(value uint32) {
	volatile.StoreUint32(&o.PENDCH.Reg, volatile.LoadUint32(&o.PENDCH.Reg)&^(0x1000)|value<<12)
}
func (o *DMAC_Type) GetPENDCH_PENDCH12() uint32 {
	return (volatile.LoadUint32(&o.PENDCH.Reg) & 0x1000) >> 12
}
func (o *DMAC_Type) SetPENDCH_PENDCH13(value uint32) {
	volatile.StoreUint32(&o.PENDCH.Reg, volatile.LoadUint32(&o.PENDCH.Reg)&^(0x2000)|value<<13)
}
func (o *DMAC_Type) GetPENDCH_PENDCH13() uint32 {
	return (volatile.LoadUint32(&o.PENDCH.Reg) & 0x2000) >> 13
}
func (o *DMAC_Type) SetPENDCH_PENDCH14(value uint32) {
	volatile.StoreUint32(&o.PENDCH.Reg, volatile.LoadUint32(&o.PENDCH.Reg)&^(0x4000)|value<<14)
}
func (o *DMAC_Type) GetPENDCH_PENDCH14() uint32 {
	return (volatile.LoadUint32(&o.PENDCH.Reg) & 0x4000) >> 14
}
func (o *DMAC_Type) SetPENDCH_PENDCH15(value uint32) {
	volatile.StoreUint32(&o.PENDCH.Reg, volatile.LoadUint32(&o.PENDCH.Reg)&^(0x8000)|value<<15)
}
func (o *DMAC_Type) GetPENDCH_PENDCH15() uint32 {
	return (volatile.LoadUint32(&o.PENDCH.Reg) & 0x8000) >> 15
}

// DMAC.ACTIVE: Active Channel and Levels
func (o *DMAC_Type) SetACTIVE_LVLEX0(value uint32) {
	volatile.StoreUint32(&o.ACTIVE.Reg, volatile.LoadUint32(&o.ACTIVE.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetACTIVE_LVLEX0() uint32 {
	return volatile.LoadUint32(&o.ACTIVE.Reg) & 0x1
}
func (o *DMAC_Type) SetACTIVE_LVLEX1(value uint32) {
	volatile.StoreUint32(&o.ACTIVE.Reg, volatile.LoadUint32(&o.ACTIVE.Reg)&^(0x2)|value<<1)
}
func (o *DMAC_Type) GetACTIVE_LVLEX1() uint32 {
	return (volatile.LoadUint32(&o.ACTIVE.Reg) & 0x2) >> 1
}
func (o *DMAC_Type) SetACTIVE_LVLEX2(value uint32) {
	volatile.StoreUint32(&o.ACTIVE.Reg, volatile.LoadUint32(&o.ACTIVE.Reg)&^(0x4)|value<<2)
}
func (o *DMAC_Type) GetACTIVE_LVLEX2() uint32 {
	return (volatile.LoadUint32(&o.ACTIVE.Reg) & 0x4) >> 2
}
func (o *DMAC_Type) SetACTIVE_LVLEX3(value uint32) {
	volatile.StoreUint32(&o.ACTIVE.Reg, volatile.LoadUint32(&o.ACTIVE.Reg)&^(0x8)|value<<3)
}
func (o *DMAC_Type) GetACTIVE_LVLEX3() uint32 {
	return (volatile.LoadUint32(&o.ACTIVE.Reg) & 0x8) >> 3
}
func (o *DMAC_Type) SetACTIVE_ID(value uint32) {
	volatile.StoreUint32(&o.ACTIVE.Reg, volatile.LoadUint32(&o.ACTIVE.Reg)&^(0x1f00)|value<<8)
}
func (o *DMAC_Type) GetACTIVE_ID() uint32 {
	return (volatile.LoadUint32(&o.ACTIVE.Reg) & 0x1f00) >> 8
}
func (o *DMAC_Type) SetACTIVE_ABUSY(value uint32) {
	volatile.StoreUint32(&o.ACTIVE.Reg, volatile.LoadUint32(&o.ACTIVE.Reg)&^(0x8000)|value<<15)
}
func (o *DMAC_Type) GetACTIVE_ABUSY() uint32 {
	return (volatile.LoadUint32(&o.ACTIVE.Reg) & 0x8000) >> 15
}
func (o *DMAC_Type) SetACTIVE_BTCNT(value uint32) {
	volatile.StoreUint32(&o.ACTIVE.Reg, volatile.LoadUint32(&o.ACTIVE.Reg)&^(0xffff0000)|value<<16)
}
func (o *DMAC_Type) GetACTIVE_BTCNT() uint32 {
	return (volatile.LoadUint32(&o.ACTIVE.Reg) & 0xffff0000) >> 16
}

// DMAC.BASEADDR: Descriptor Memory Section Base Address
func (o *DMAC_Type) SetBASEADDR(value uint32) {
	volatile.StoreUint32(&o.BASEADDR.Reg, value)
}
func (o *DMAC_Type) GetBASEADDR() uint32 {
	return volatile.LoadUint32(&o.BASEADDR.Reg)
}

// DMAC.WRBADDR: Write-Back Memory Section Base Address
func (o *DMAC_Type) SetWRBADDR(value uint32) {
	volatile.StoreUint32(&o.WRBADDR.Reg, value)
}
func (o *DMAC_Type) GetWRBADDR() uint32 {
	return volatile.LoadUint32(&o.WRBADDR.Reg)
}

// DMAC.CHID: Channel ID
func (o *DMAC_Type) SetCHID_ID(value uint8) {
	volatile.StoreUint8(&o.CHID.Reg, volatile.LoadUint8(&o.CHID.Reg)&^(0xf)|value)
}
func (o *DMAC_Type) GetCHID_ID() uint8 {
	return volatile.LoadUint8(&o.CHID.Reg) & 0xf
}

// DMAC.CHCTRLA: Channel Control A
func (o *DMAC_Type) SetCHCTRLA_SWRST(value uint8) {
	volatile.StoreUint8(&o.CHCTRLA.Reg, volatile.LoadUint8(&o.CHCTRLA.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetCHCTRLA_SWRST() uint8 {
	return volatile.LoadUint8(&o.CHCTRLA.Reg) & 0x1
}
func (o *DMAC_Type) SetCHCTRLA_ENABLE(value uint8) {
	volatile.StoreUint8(&o.CHCTRLA.Reg, volatile.LoadUint8(&o.CHCTRLA.Reg)&^(0x2)|value<<1)
}
func (o *DMAC_Type) GetCHCTRLA_ENABLE() uint8 {
	return (volatile.LoadUint8(&o.CHCTRLA.Reg) & 0x2) >> 1
}
func (o *DMAC_Type) SetCHCTRLA_RUNSTDBY(value uint8) {
	volatile.StoreUint8(&o.CHCTRLA.Reg, volatile.LoadUint8(&o.CHCTRLA.Reg)&^(0x40)|value<<6)
}
func (o *DMAC_Type) GetCHCTRLA_RUNSTDBY() uint8 {
	return (volatile.LoadUint8(&o.CHCTRLA.Reg) & 0x40) >> 6
}

// DMAC.CHCTRLB: Channel Control B
func (o *DMAC_Type) SetCHCTRLB_EVACT(value uint32) {
	volatile.StoreUint32(&o.CHCTRLB.Reg, volatile.LoadUint32(&o.CHCTRLB.Reg)&^(0x7)|value)
}
func (o *DMAC_Type) GetCHCTRLB_EVACT() uint32 {
	return volatile.LoadUint32(&o.CHCTRLB.Reg) & 0x7
}
func (o *DMAC_Type) SetCHCTRLB_EVIE(value uint32) {
	volatile.StoreUint32(&o.CHCTRLB.Reg, volatile.LoadUint32(&o.CHCTRLB.Reg)&^(0x8)|value<<3)
}
func (o *DMAC_Type) GetCHCTRLB_EVIE() uint32 {
	return (volatile.LoadUint32(&o.CHCTRLB.Reg) & 0x8) >> 3
}
func (o *DMAC_Type) SetCHCTRLB_EVOE(value uint32) {
	volatile.StoreUint32(&o.CHCTRLB.Reg, volatile.LoadUint32(&o.CHCTRLB.Reg)&^(0x10)|value<<4)
}
func (o *DMAC_Type) GetCHCTRLB_EVOE() uint32 {
	return (volatile.LoadUint32(&o.CHCTRLB.Reg) & 0x10) >> 4
}
func (o *DMAC_Type) SetCHCTRLB_LVL(value uint32) {
	volatile.StoreUint32(&o.CHCTRLB.Reg, volatile.LoadUint32(&o.CHCTRLB.Reg)&^(0x60)|value<<5)
}
func (o *DMAC_Type) GetCHCTRLB_LVL() uint32 {
	return (volatile.LoadUint32(&o.CHCTRLB.Reg) & 0x60) >> 5
}
func (o *DMAC_Type) SetCHCTRLB_TRIGSRC(value uint32) {
	volatile.StoreUint32(&o.CHCTRLB.Reg, volatile.LoadUint32(&o.CHCTRLB.Reg)&^(0x3f00)|value<<8)
}
func (o *DMAC_Type) GetCHCTRLB_TRIGSRC() uint32 {
	return (volatile.LoadUint32(&o.CHCTRLB.Reg) & 0x3f00) >> 8
}
func (o *DMAC_Type) SetCHCTRLB_TRIGACT(value uint32) {
	volatile.StoreUint32(&o.CHCTRLB.Reg, volatile.LoadUint32(&o.CHCTRLB.Reg)&^(0xc00000)|value<<22)
}
func (o *DMAC_Type) GetCHCTRLB_TRIGACT() uint32 {
	return (volatile.LoadUint32(&o.CHCTRLB.Reg) & 0xc00000) >> 22
}
func (o *DMAC_Type) SetCHCTRLB_CMD(value uint32) {
	volatile.StoreUint32(&o.CHCTRLB.Reg, volatile.LoadUint32(&o.CHCTRLB.Reg)&^(0x3000000)|value<<24)
}
func (o *DMAC_Type) GetCHCTRLB_CMD() uint32 {
	return (volatile.LoadUint32(&o.CHCTRLB.Reg) & 0x3000000) >> 24
}

// DMAC.CHINTENCLR: Channel Interrupt Enable Clear
func (o *DMAC_Type) SetCHINTENCLR_TERR(value uint8) {
	volatile.StoreUint8(&o.CHINTENCLR.Reg, volatile.LoadUint8(&o.CHINTENCLR.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetCHINTENCLR_TERR() uint8 {
	return volatile.LoadUint8(&o.CHINTENCLR.Reg) & 0x1
}
func (o *DMAC_Type) SetCHINTENCLR_TCMPL(value uint8) {
	volatile.StoreUint8(&o.CHINTENCLR.Reg, volatile.LoadUint8(&o.CHINTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *DMAC_Type) GetCHINTENCLR_TCMPL() uint8 {
	return (volatile.LoadUint8(&o.CHINTENCLR.Reg) & 0x2) >> 1
}
func (o *DMAC_Type) SetCHINTENCLR_SUSP(value uint8) {
	volatile.StoreUint8(&o.CHINTENCLR.Reg, volatile.LoadUint8(&o.CHINTENCLR.Reg)&^(0x4)|value<<2)
}
func (o *DMAC_Type) GetCHINTENCLR_SUSP() uint8 {
	return (volatile.LoadUint8(&o.CHINTENCLR.Reg) & 0x4) >> 2
}

// DMAC.CHINTENSET: Channel Interrupt Enable Set
func (o *DMAC_Type) SetCHINTENSET_TERR(value uint8) {
	volatile.StoreUint8(&o.CHINTENSET.Reg, volatile.LoadUint8(&o.CHINTENSET.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetCHINTENSET_TERR() uint8 {
	return volatile.LoadUint8(&o.CHINTENSET.Reg) & 0x1
}
func (o *DMAC_Type) SetCHINTENSET_TCMPL(value uint8) {
	volatile.StoreUint8(&o.CHINTENSET.Reg, volatile.LoadUint8(&o.CHINTENSET.Reg)&^(0x2)|value<<1)
}
func (o *DMAC_Type) GetCHINTENSET_TCMPL() uint8 {
	return (volatile.LoadUint8(&o.CHINTENSET.Reg) & 0x2) >> 1
}
func (o *DMAC_Type) SetCHINTENSET_SUSP(value uint8) {
	volatile.StoreUint8(&o.CHINTENSET.Reg, volatile.LoadUint8(&o.CHINTENSET.Reg)&^(0x4)|value<<2)
}
func (o *DMAC_Type) GetCHINTENSET_SUSP() uint8 {
	return (volatile.LoadUint8(&o.CHINTENSET.Reg) & 0x4) >> 2
}

// DMAC.CHINTFLAG: Channel Interrupt Flag Status and Clear
func (o *DMAC_Type) SetCHINTFLAG_TERR(value uint8) {
	volatile.StoreUint8(&o.CHINTFLAG.Reg, volatile.LoadUint8(&o.CHINTFLAG.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetCHINTFLAG_TERR() uint8 {
	return volatile.LoadUint8(&o.CHINTFLAG.Reg) & 0x1
}
func (o *DMAC_Type) SetCHINTFLAG_TCMPL(value uint8) {
	volatile.StoreUint8(&o.CHINTFLAG.Reg, volatile.LoadUint8(&o.CHINTFLAG.Reg)&^(0x2)|value<<1)
}
func (o *DMAC_Type) GetCHINTFLAG_TCMPL() uint8 {
	return (volatile.LoadUint8(&o.CHINTFLAG.Reg) & 0x2) >> 1
}
func (o *DMAC_Type) SetCHINTFLAG_SUSP(value uint8) {
	volatile.StoreUint8(&o.CHINTFLAG.Reg, volatile.LoadUint8(&o.CHINTFLAG.Reg)&^(0x4)|value<<2)
}
func (o *DMAC_Type) GetCHINTFLAG_SUSP() uint8 {
	return (volatile.LoadUint8(&o.CHINTFLAG.Reg) & 0x4) >> 2
}

// DMAC.CHSTATUS: Channel Status
func (o *DMAC_Type) SetCHSTATUS_PEND(value uint8) {
	volatile.StoreUint8(&o.CHSTATUS.Reg, volatile.LoadUint8(&o.CHSTATUS.Reg)&^(0x1)|value)
}
func (o *DMAC_Type) GetCHSTATUS_PEND() uint8 {
	return volatile.LoadUint8(&o.CHSTATUS.Reg) & 0x1
}
func (o *DMAC_Type) SetCHSTATUS_BUSY(value uint8) {
	volatile.StoreUint8(&o.CHSTATUS.Reg, volatile.LoadUint8(&o.CHSTATUS.Reg)&^(0x2)|value<<1)
}
func (o *DMAC_Type) GetCHSTATUS_BUSY() uint8 {
	return (volatile.LoadUint8(&o.CHSTATUS.Reg) & 0x2) >> 1
}
func (o *DMAC_Type) SetCHSTATUS_FERR(value uint8) {
	volatile.StoreUint8(&o.CHSTATUS.Reg, volatile.LoadUint8(&o.CHSTATUS.Reg)&^(0x4)|value<<2)
}
func (o *DMAC_Type) GetCHSTATUS_FERR() uint8 {
	return (volatile.LoadUint8(&o.CHSTATUS.Reg) & 0x4) >> 2
}

// Device Service Unit
type DSU_Type struct {
	CTRL    volatile.Register8 // 0x0
	STATUSA volatile.Register8 // 0x1
	STATUSB volatile.Register8 // 0x2
	_       byte
	ADDR    volatile.Register32 // 0x4
	LENGTH  volatile.Register32 // 0x8
	DATA    volatile.Register32 // 0xC
	DCC0    volatile.Register32 // 0x10
	DCC1    volatile.Register32 // 0x14
	DID     volatile.Register32 // 0x18
	_       [212]byte
	DCFG0   volatile.Register32 // 0xF0
	DCFG1   volatile.Register32 // 0xF4
	_       [3848]byte
	ENTRY0  volatile.Register32 // 0x1000
	ENTRY1  volatile.Register32 // 0x1004
	END     volatile.Register32 // 0x1008
	_       [4032]byte
	MEMTYPE volatile.Register32 // 0x1FCC
	PID4    volatile.Register32 // 0x1FD0
	PID5    volatile.Register32 // 0x1FD4
	PID6    volatile.Register32 // 0x1FD8
	PID7    volatile.Register32 // 0x1FDC
	PID0    volatile.Register32 // 0x1FE0
	PID1    volatile.Register32 // 0x1FE4
	PID2    volatile.Register32 // 0x1FE8
	PID3    volatile.Register32 // 0x1FEC
	CID0    volatile.Register32 // 0x1FF0
	CID1    volatile.Register32 // 0x1FF4
	CID2    volatile.Register32 // 0x1FF8
	CID3    volatile.Register32 // 0x1FFC
}

// DSU.CTRL: Control
func (o *DSU_Type) SetCTRL_SWRST(value uint8) {
	volatile.StoreUint8(&o.CTRL.Reg, volatile.LoadUint8(&o.CTRL.Reg)&^(0x1)|value)
}
func (o *DSU_Type) GetCTRL_SWRST() uint8 {
	return volatile.LoadUint8(&o.CTRL.Reg) & 0x1
}
func (o *DSU_Type) SetCTRL_CRC(value uint8) {
	volatile.StoreUint8(&o.CTRL.Reg, volatile.LoadUint8(&o.CTRL.Reg)&^(0x4)|value<<2)
}
func (o *DSU_Type) GetCTRL_CRC() uint8 {
	return (volatile.LoadUint8(&o.CTRL.Reg) & 0x4) >> 2
}
func (o *DSU_Type) SetCTRL_MBIST(value uint8) {
	volatile.StoreUint8(&o.CTRL.Reg, volatile.LoadUint8(&o.CTRL.Reg)&^(0x8)|value<<3)
}
func (o *DSU_Type) GetCTRL_MBIST() uint8 {
	return (volatile.LoadUint8(&o.CTRL.Reg) & 0x8) >> 3
}
func (o *DSU_Type) SetCTRL_CE(value uint8) {
	volatile.StoreUint8(&o.CTRL.Reg, volatile.LoadUint8(&o.CTRL.Reg)&^(0x10)|value<<4)
}
func (o *DSU_Type) GetCTRL_CE() uint8 {
	return (volatile.LoadUint8(&o.CTRL.Reg) & 0x10) >> 4
}
func (o *DSU_Type) SetCTRL_ARR(value uint8) {
	volatile.StoreUint8(&o.CTRL.Reg, volatile.LoadUint8(&o.CTRL.Reg)&^(0x40)|value<<6)
}
func (o *DSU_Type) GetCTRL_ARR() uint8 {
	return (volatile.LoadUint8(&o.CTRL.Reg) & 0x40) >> 6
}
func (o *DSU_Type) SetCTRL_SMSA(value uint8) {
	volatile.StoreUint8(&o.CTRL.Reg, volatile.LoadUint8(&o.CTRL.Reg)&^(0x80)|value<<7)
}
func (o *DSU_Type) GetCTRL_SMSA() uint8 {
	return (volatile.LoadUint8(&o.CTRL.Reg) & 0x80) >> 7
}

// DSU.STATUSA: Status A
func (o *DSU_Type) SetSTATUSA_DONE(value uint8) {
	volatile.StoreUint8(&o.STATUSA.Reg, volatile.LoadUint8(&o.STATUSA.Reg)&^(0x1)|value)
}
func (o *DSU_Type) GetSTATUSA_DONE() uint8 {
	return volatile.LoadUint8(&o.STATUSA.Reg) & 0x1
}
func (o *DSU_Type) SetSTATUSA_CRSTEXT(value uint8) {
	volatile.StoreUint8(&o.STATUSA.Reg, volatile.LoadUint8(&o.STATUSA.Reg)&^(0x2)|value<<1)
}
func (o *DSU_Type) GetSTATUSA_CRSTEXT() uint8 {
	return (volatile.LoadUint8(&o.STATUSA.Reg) & 0x2) >> 1
}
func (o *DSU_Type) SetSTATUSA_BERR(value uint8) {
	volatile.StoreUint8(&o.STATUSA.Reg, volatile.LoadUint8(&o.STATUSA.Reg)&^(0x4)|value<<2)
}
func (o *DSU_Type) GetSTATUSA_BERR() uint8 {
	return (volatile.LoadUint8(&o.STATUSA.Reg) & 0x4) >> 2
}
func (o *DSU_Type) SetSTATUSA_FAIL(value uint8) {
	volatile.StoreUint8(&o.STATUSA.Reg, volatile.LoadUint8(&o.STATUSA.Reg)&^(0x8)|value<<3)
}
func (o *DSU_Type) GetSTATUSA_FAIL() uint8 {
	return (volatile.LoadUint8(&o.STATUSA.Reg) & 0x8) >> 3
}
func (o *DSU_Type) SetSTATUSA_PERR(value uint8) {
	volatile.StoreUint8(&o.STATUSA.Reg, volatile.LoadUint8(&o.STATUSA.Reg)&^(0x10)|value<<4)
}
func (o *DSU_Type) GetSTATUSA_PERR() uint8 {
	return (volatile.LoadUint8(&o.STATUSA.Reg) & 0x10) >> 4
}

// DSU.STATUSB: Status B
func (o *DSU_Type) SetSTATUSB_PROT(value uint8) {
	volatile.StoreUint8(&o.STATUSB.Reg, volatile.LoadUint8(&o.STATUSB.Reg)&^(0x1)|value)
}
func (o *DSU_Type) GetSTATUSB_PROT() uint8 {
	return volatile.LoadUint8(&o.STATUSB.Reg) & 0x1
}
func (o *DSU_Type) SetSTATUSB_DBGPRES(value uint8) {
	volatile.StoreUint8(&o.STATUSB.Reg, volatile.LoadUint8(&o.STATUSB.Reg)&^(0x2)|value<<1)
}
func (o *DSU_Type) GetSTATUSB_DBGPRES() uint8 {
	return (volatile.LoadUint8(&o.STATUSB.Reg) & 0x2) >> 1
}
func (o *DSU_Type) SetSTATUSB_DCCD0(value uint8) {
	volatile.StoreUint8(&o.STATUSB.Reg, volatile.LoadUint8(&o.STATUSB.Reg)&^(0x4)|value<<2)
}
func (o *DSU_Type) GetSTATUSB_DCCD0() uint8 {
	return (volatile.LoadUint8(&o.STATUSB.Reg) & 0x4) >> 2
}
func (o *DSU_Type) SetSTATUSB_DCCD1(value uint8) {
	volatile.StoreUint8(&o.STATUSB.Reg, volatile.LoadUint8(&o.STATUSB.Reg)&^(0x8)|value<<3)
}
func (o *DSU_Type) GetSTATUSB_DCCD1() uint8 {
	return (volatile.LoadUint8(&o.STATUSB.Reg) & 0x8) >> 3
}
func (o *DSU_Type) SetSTATUSB_HPE(value uint8) {
	volatile.StoreUint8(&o.STATUSB.Reg, volatile.LoadUint8(&o.STATUSB.Reg)&^(0x10)|value<<4)
}
func (o *DSU_Type) GetSTATUSB_HPE() uint8 {
	return (volatile.LoadUint8(&o.STATUSB.Reg) & 0x10) >> 4
}

// DSU.ADDR: Address
func (o *DSU_Type) SetADDR_AMOD(value uint32) {
	volatile.StoreUint32(&o.ADDR.Reg, volatile.LoadUint32(&o.ADDR.Reg)&^(0x3)|value)
}
func (o *DSU_Type) GetADDR_AMOD() uint32 {
	return volatile.LoadUint32(&o.ADDR.Reg) & 0x3
}
func (o *DSU_Type) SetADDR(value uint32) {
	volatile.StoreUint32(&o.ADDR.Reg, volatile.LoadUint32(&o.ADDR.Reg)&^(0xfffffffc)|value<<2)
}
func (o *DSU_Type) GetADDR() uint32 {
	return (volatile.LoadUint32(&o.ADDR.Reg) & 0xfffffffc) >> 2
}

// DSU.LENGTH: Length
func (o *DSU_Type) SetLENGTH(value uint32) {
	volatile.StoreUint32(&o.LENGTH.Reg, volatile.LoadUint32(&o.LENGTH.Reg)&^(0xfffffffc)|value<<2)
}
func (o *DSU_Type) GetLENGTH() uint32 {
	return (volatile.LoadUint32(&o.LENGTH.Reg) & 0xfffffffc) >> 2
}

// DSU.DATA: Data
func (o *DSU_Type) SetDATA(value uint32) {
	volatile.StoreUint32(&o.DATA.Reg, value)
}
func (o *DSU_Type) GetDATA() uint32 {
	return volatile.LoadUint32(&o.DATA.Reg)
}

// DSU.DCC0: Debug Communication Channel n
func (o *DSU_Type) SetDCC0(value uint32) {
	volatile.StoreUint32(&o.DCC0.Reg, value)
}
func (o *DSU_Type) GetDCC0() uint32 {
	return volatile.LoadUint32(&o.DCC0.Reg)
}

// DSU.DCC1: Debug Communication Channel n
func (o *DSU_Type) SetDCC1(value uint32) {
	volatile.StoreUint32(&o.DCC1.Reg, value)
}
func (o *DSU_Type) GetDCC1() uint32 {
	return volatile.LoadUint32(&o.DCC1.Reg)
}

// DSU.DID: Device Identification
func (o *DSU_Type) SetDID_DEVSEL(value uint32) {
	volatile.StoreUint32(&o.DID.Reg, volatile.LoadUint32(&o.DID.Reg)&^(0xff)|value)
}
func (o *DSU_Type) GetDID_DEVSEL() uint32 {
	return volatile.LoadUint32(&o.DID.Reg) & 0xff
}
func (o *DSU_Type) SetDID_REVISION(value uint32) {
	volatile.StoreUint32(&o.DID.Reg, volatile.LoadUint32(&o.DID.Reg)&^(0xf00)|value<<8)
}
func (o *DSU_Type) GetDID_REVISION() uint32 {
	return (volatile.LoadUint32(&o.DID.Reg) & 0xf00) >> 8
}
func (o *DSU_Type) SetDID_DIE(value uint32) {
	volatile.StoreUint32(&o.DID.Reg, volatile.LoadUint32(&o.DID.Reg)&^(0xf000)|value<<12)
}
func (o *DSU_Type) GetDID_DIE() uint32 {
	return (volatile.LoadUint32(&o.DID.Reg) & 0xf000) >> 12
}
func (o *DSU_Type) SetDID_SERIES(value uint32) {
	volatile.StoreUint32(&o.DID.Reg, volatile.LoadUint32(&o.DID.Reg)&^(0x3f0000)|value<<16)
}
func (o *DSU_Type) GetDID_SERIES() uint32 {
	return (volatile.LoadUint32(&o.DID.Reg) & 0x3f0000) >> 16
}
func (o *DSU_Type) SetDID_FAMILY(value uint32) {
	volatile.StoreUint32(&o.DID.Reg, volatile.LoadUint32(&o.DID.Reg)&^(0xf800000)|value<<23)
}
func (o *DSU_Type) GetDID_FAMILY() uint32 {
	return (volatile.LoadUint32(&o.DID.Reg) & 0xf800000) >> 23
}
func (o *DSU_Type) SetDID_PROCESSOR(value uint32) {
	volatile.StoreUint32(&o.DID.Reg, volatile.LoadUint32(&o.DID.Reg)&^(0xf0000000)|value<<28)
}
func (o *DSU_Type) GetDID_PROCESSOR() uint32 {
	return (volatile.LoadUint32(&o.DID.Reg) & 0xf0000000) >> 28
}

// DSU.DCFG0: Device Configuration
func (o *DSU_Type) SetDCFG0(value uint32) {
	volatile.StoreUint32(&o.DCFG0.Reg, value)
}
func (o *DSU_Type) GetDCFG0() uint32 {
	return volatile.LoadUint32(&o.DCFG0.Reg)
}

// DSU.DCFG1: Device Configuration
func (o *DSU_Type) SetDCFG1(value uint32) {
	volatile.StoreUint32(&o.DCFG1.Reg, value)
}
func (o *DSU_Type) GetDCFG1() uint32 {
	return volatile.LoadUint32(&o.DCFG1.Reg)
}

// DSU.ENTRY0: CoreSight ROM Table Entry 0
func (o *DSU_Type) SetENTRY0_EPRES(value uint32) {
	volatile.StoreUint32(&o.ENTRY0.Reg, volatile.LoadUint32(&o.ENTRY0.Reg)&^(0x1)|value)
}
func (o *DSU_Type) GetENTRY0_EPRES() uint32 {
	return volatile.LoadUint32(&o.ENTRY0.Reg) & 0x1
}
func (o *DSU_Type) SetENTRY0_FMT(value uint32) {
	volatile.StoreUint32(&o.ENTRY0.Reg, volatile.LoadUint32(&o.ENTRY0.Reg)&^(0x2)|value<<1)
}
func (o *DSU_Type) GetENTRY0_FMT() uint32 {
	return (volatile.LoadUint32(&o.ENTRY0.Reg) & 0x2) >> 1
}
func (o *DSU_Type) SetENTRY0_ADDOFF(value uint32) {
	volatile.StoreUint32(&o.ENTRY0.Reg, volatile.LoadUint32(&o.ENTRY0.Reg)&^(0xfffff000)|value<<12)
}
func (o *DSU_Type) GetENTRY0_ADDOFF() uint32 {
	return (volatile.LoadUint32(&o.ENTRY0.Reg) & 0xfffff000) >> 12
}

// DSU.END: CoreSight ROM Table End
func (o *DSU_Type) SetEND(value uint32) {
	volatile.StoreUint32(&o.END.Reg, value)
}
func (o *DSU_Type) GetEND() uint32 {
	return volatile.LoadUint32(&o.END.Reg)
}

// DSU.MEMTYPE: CoreSight ROM Table Memory Type
func (o *DSU_Type) SetMEMTYPE_SMEMP(value uint32) {
	volatile.StoreUint32(&o.MEMTYPE.Reg, volatile.LoadUint32(&o.MEMTYPE.Reg)&^(0x1)|value)
}
func (o *DSU_Type) GetMEMTYPE_SMEMP() uint32 {
	return volatile.LoadUint32(&o.MEMTYPE.Reg) & 0x1
}

// DSU.PID4: Peripheral Identification 4
func (o *DSU_Type) SetPID4_JEPCC(value uint32) {
	volatile.StoreUint32(&o.PID4.Reg, volatile.LoadUint32(&o.PID4.Reg)&^(0xf)|value)
}
func (o *DSU_Type) GetPID4_JEPCC() uint32 {
	return volatile.LoadUint32(&o.PID4.Reg) & 0xf
}
func (o *DSU_Type) SetPID4_FKBC(value uint32) {
	volatile.StoreUint32(&o.PID4.Reg, volatile.LoadUint32(&o.PID4.Reg)&^(0xf0)|value<<4)
}
func (o *DSU_Type) GetPID4_FKBC() uint32 {
	return (volatile.LoadUint32(&o.PID4.Reg) & 0xf0) >> 4
}

// DSU.PID0: Peripheral Identification 0
func (o *DSU_Type) SetPID0_PARTNBL(value uint32) {
	volatile.StoreUint32(&o.PID0.Reg, volatile.LoadUint32(&o.PID0.Reg)&^(0xff)|value)
}
func (o *DSU_Type) GetPID0_PARTNBL() uint32 {
	return volatile.LoadUint32(&o.PID0.Reg) & 0xff
}

// DSU.PID1: Peripheral Identification 1
func (o *DSU_Type) SetPID1_PARTNBH(value uint32) {
	volatile.StoreUint32(&o.PID1.Reg, volatile.LoadUint32(&o.PID1.Reg)&^(0xf)|value)
}
func (o *DSU_Type) GetPID1_PARTNBH() uint32 {
	return volatile.LoadUint32(&o.PID1.Reg) & 0xf
}
func (o *DSU_Type) SetPID1_JEPIDCL(value uint32) {
	volatile.StoreUint32(&o.PID1.Reg, volatile.LoadUint32(&o.PID1.Reg)&^(0xf0)|value<<4)
}
func (o *DSU_Type) GetPID1_JEPIDCL() uint32 {
	return (volatile.LoadUint32(&o.PID1.Reg) & 0xf0) >> 4
}

// DSU.PID2: Peripheral Identification 2
func (o *DSU_Type) SetPID2_JEPIDCH(value uint32) {
	volatile.StoreUint32(&o.PID2.Reg, volatile.LoadUint32(&o.PID2.Reg)&^(0x7)|value)
}
func (o *DSU_Type) GetPID2_JEPIDCH() uint32 {
	return volatile.LoadUint32(&o.PID2.Reg) & 0x7
}
func (o *DSU_Type) SetPID2_JEPU(value uint32) {
	volatile.StoreUint32(&o.PID2.Reg, volatile.LoadUint32(&o.PID2.Reg)&^(0x8)|value<<3)
}
func (o *DSU_Type) GetPID2_JEPU() uint32 {
	return (volatile.LoadUint32(&o.PID2.Reg) & 0x8) >> 3
}
func (o *DSU_Type) SetPID2_REVISION(value uint32) {
	volatile.StoreUint32(&o.PID2.Reg, volatile.LoadUint32(&o.PID2.Reg)&^(0xf0)|value<<4)
}
func (o *DSU_Type) GetPID2_REVISION() uint32 {
	return (volatile.LoadUint32(&o.PID2.Reg) & 0xf0) >> 4
}

// DSU.PID3: Peripheral Identification 3
func (o *DSU_Type) SetPID3_CUSMOD(value uint32) {
	volatile.StoreUint32(&o.PID3.Reg, volatile.LoadUint32(&o.PID3.Reg)&^(0xf)|value)
}
func (o *DSU_Type) GetPID3_CUSMOD() uint32 {
	return volatile.LoadUint32(&o.PID3.Reg) & 0xf
}
func (o *DSU_Type) SetPID3_REVAND(value uint32) {
	volatile.StoreUint32(&o.PID3.Reg, volatile.LoadUint32(&o.PID3.Reg)&^(0xf0)|value<<4)
}
func (o *DSU_Type) GetPID3_REVAND() uint32 {
	return (volatile.LoadUint32(&o.PID3.Reg) & 0xf0) >> 4
}

// DSU.CID0: Component Identification 0
func (o *DSU_Type) SetCID0_PREAMBLEB0(value uint32) {
	volatile.StoreUint32(&o.CID0.Reg, volatile.LoadUint32(&o.CID0.Reg)&^(0xff)|value)
}
func (o *DSU_Type) GetCID0_PREAMBLEB0() uint32 {
	return volatile.LoadUint32(&o.CID0.Reg) & 0xff
}

// DSU.CID1: Component Identification 1
func (o *DSU_Type) SetCID1_PREAMBLE(value uint32) {
	volatile.StoreUint32(&o.CID1.Reg, volatile.LoadUint32(&o.CID1.Reg)&^(0xf)|value)
}
func (o *DSU_Type) GetCID1_PREAMBLE() uint32 {
	return volatile.LoadUint32(&o.CID1.Reg) & 0xf
}
func (o *DSU_Type) SetCID1_CCLASS(value uint32) {
	volatile.StoreUint32(&o.CID1.Reg, volatile.LoadUint32(&o.CID1.Reg)&^(0xf0)|value<<4)
}
func (o *DSU_Type) GetCID1_CCLASS() uint32 {
	return (volatile.LoadUint32(&o.CID1.Reg) & 0xf0) >> 4
}

// DSU.CID2: Component Identification 2
func (o *DSU_Type) SetCID2_PREAMBLEB2(value uint32) {
	volatile.StoreUint32(&o.CID2.Reg, volatile.LoadUint32(&o.CID2.Reg)&^(0xff)|value)
}
func (o *DSU_Type) GetCID2_PREAMBLEB2() uint32 {
	return volatile.LoadUint32(&o.CID2.Reg) & 0xff
}

// DSU.CID3: Component Identification 3
func (o *DSU_Type) SetCID3_PREAMBLEB3(value uint32) {
	volatile.StoreUint32(&o.CID3.Reg, volatile.LoadUint32(&o.CID3.Reg)&^(0xff)|value)
}
func (o *DSU_Type) GetCID3_PREAMBLEB3() uint32 {
	return volatile.LoadUint32(&o.CID3.Reg) & 0xff
}

// External Interrupt Controller
type EIC_Type struct {
	CTRLA    volatile.Register8  // 0x0
	NMICTRL  volatile.Register8  // 0x1
	NMIFLAG  volatile.Register16 // 0x2
	SYNCBUSY volatile.Register32 // 0x4
	EVCTRL   volatile.Register32 // 0x8
	INTENCLR volatile.Register32 // 0xC
	INTENSET volatile.Register32 // 0x10
	INTFLAG  volatile.Register32 // 0x14
	ASYNCH   volatile.Register32 // 0x18
	CONFIG0  volatile.Register32 // 0x1C
	CONFIG1  volatile.Register32 // 0x20
}

// EIC.CTRLA: Control
func (o *EIC_Type) SetCTRLA_SWRST(value uint8) {
	volatile.StoreUint8(&o.CTRLA.Reg, volatile.LoadUint8(&o.CTRLA.Reg)&^(0x1)|value)
}
func (o *EIC_Type) GetCTRLA_SWRST() uint8 {
	return volatile.LoadUint8(&o.CTRLA.Reg) & 0x1
}
func (o *EIC_Type) SetCTRLA_ENABLE(value uint8) {
	volatile.StoreUint8(&o.CTRLA.Reg, volatile.LoadUint8(&o.CTRLA.Reg)&^(0x2)|value<<1)
}
func (o *EIC_Type) GetCTRLA_ENABLE() uint8 {
	return (volatile.LoadUint8(&o.CTRLA.Reg) & 0x2) >> 1
}
func (o *EIC_Type) SetCTRLA_CKSEL(value uint8) {
	volatile.StoreUint8(&o.CTRLA.Reg, volatile.LoadUint8(&o.CTRLA.Reg)&^(0x10)|value<<4)
}
func (o *EIC_Type) GetCTRLA_CKSEL() uint8 {
	return (volatile.LoadUint8(&o.CTRLA.Reg) & 0x10) >> 4
}

// EIC.NMICTRL: NMI Control
func (o *EIC_Type) SetNMICTRL_NMISENSE(value uint8) {
	volatile.StoreUint8(&o.NMICTRL.Reg, volatile.LoadUint8(&o.NMICTRL.Reg)&^(0x7)|value)
}
func (o *EIC_Type) GetNMICTRL_NMISENSE() uint8 {
	return volatile.LoadUint8(&o.NMICTRL.Reg) & 0x7
}
func (o *EIC_Type) SetNMICTRL_NMIFILTEN(value uint8) {
	volatile.StoreUint8(&o.NMICTRL.Reg, volatile.LoadUint8(&o.NMICTRL.Reg)&^(0x8)|value<<3)
}
func (o *EIC_Type) GetNMICTRL_NMIFILTEN() uint8 {
	return (volatile.LoadUint8(&o.NMICTRL.Reg) & 0x8) >> 3
}
func (o *EIC_Type) SetNMICTRL_NMIASYNCH(value uint8) {
	volatile.StoreUint8(&o.NMICTRL.Reg, volatile.LoadUint8(&o.NMICTRL.Reg)&^(0x10)|value<<4)
}
func (o *EIC_Type) GetNMICTRL_NMIASYNCH() uint8 {
	return (volatile.LoadUint8(&o.NMICTRL.Reg) & 0x10) >> 4
}

// EIC.NMIFLAG: NMI Interrupt Flag
func (o *EIC_Type) SetNMIFLAG_NMI(value uint16) {
	volatile.StoreUint16(&o.NMIFLAG.Reg, volatile.LoadUint16(&o.NMIFLAG.Reg)&^(0x1)|value)
}
func (o *EIC_Type) GetNMIFLAG_NMI() uint16 {
	return volatile.LoadUint16(&o.NMIFLAG.Reg) & 0x1
}

// EIC.SYNCBUSY: Syncbusy register
func (o *EIC_Type) SetSYNCBUSY_SWRST(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x1)|value)
}
func (o *EIC_Type) GetSYNCBUSY_SWRST() uint32 {
	return volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x1
}
func (o *EIC_Type) SetSYNCBUSY_ENABLE(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x2)|value<<1)
}
func (o *EIC_Type) GetSYNCBUSY_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x2) >> 1
}

// EIC.EVCTRL: Event Control
func (o *EIC_Type) SetEVCTRL_EXTINTEO(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0xffff)|value)
}
func (o *EIC_Type) GetEVCTRL_EXTINTEO() uint32 {
	return volatile.LoadUint32(&o.EVCTRL.Reg) & 0xffff
}

// EIC.INTENCLR: Interrupt Enable Clear
func (o *EIC_Type) SetINTENCLR_EXTINT(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0xffff)|value)
}
func (o *EIC_Type) GetINTENCLR_EXTINT() uint32 {
	return volatile.LoadUint32(&o.INTENCLR.Reg) & 0xffff
}

// EIC.INTENSET: Interrupt Enable Set
func (o *EIC_Type) SetINTENSET_EXTINT(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0xffff)|value)
}
func (o *EIC_Type) GetINTENSET_EXTINT() uint32 {
	return volatile.LoadUint32(&o.INTENSET.Reg) & 0xffff
}

// EIC.INTFLAG: Interrupt Flag Status and Clear
func (o *EIC_Type) SetINTFLAG_EXTINT(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0xffff)|value)
}
func (o *EIC_Type) GetINTFLAG_EXTINT() uint32 {
	return volatile.LoadUint32(&o.INTFLAG.Reg) & 0xffff
}

// EIC.ASYNCH: EIC Asynchronous edge Detection Enable
func (o *EIC_Type) SetASYNCH(value uint32) {
	volatile.StoreUint32(&o.ASYNCH.Reg, volatile.LoadUint32(&o.ASYNCH.Reg)&^(0xffff)|value)
}
func (o *EIC_Type) GetASYNCH() uint32 {
	return volatile.LoadUint32(&o.ASYNCH.Reg) & 0xffff
}

// EIC.CONFIG0: Configuration n
func (o *EIC_Type) SetCONFIG0_SENSE0(value uint32) {
	volatile.StoreUint32(&o.CONFIG0.Reg, volatile.LoadUint32(&o.CONFIG0.Reg)&^(0x7)|value)
}
func (o *EIC_Type) GetCONFIG0_SENSE0() uint32 {
	return volatile.LoadUint32(&o.CONFIG0.Reg) & 0x7
}
func (o *EIC_Type) SetCONFIG0_FILTEN0(value uint32) {
	volatile.StoreUint32(&o.CONFIG0.Reg, volatile.LoadUint32(&o.CONFIG0.Reg)&^(0x8)|value<<3)
}
func (o *EIC_Type) GetCONFIG0_FILTEN0() uint32 {
	return (volatile.LoadUint32(&o.CONFIG0.Reg) & 0x8) >> 3
}
func (o *EIC_Type) SetCONFIG0_SENSE1(value uint32) {
	volatile.StoreUint32(&o.CONFIG0.Reg, volatile.LoadUint32(&o.CONFIG0.Reg)&^(0x70)|value<<4)
}
func (o *EIC_Type) GetCONFIG0_SENSE1() uint32 {
	return (volatile.LoadUint32(&o.CONFIG0.Reg) & 0x70) >> 4
}
func (o *EIC_Type) SetCONFIG0_FILTEN1(value uint32) {
	volatile.StoreUint32(&o.CONFIG0.Reg, volatile.LoadUint32(&o.CONFIG0.Reg)&^(0x80)|value<<7)
}
func (o *EIC_Type) GetCONFIG0_FILTEN1() uint32 {
	return (volatile.LoadUint32(&o.CONFIG0.Reg) & 0x80) >> 7
}
func (o *EIC_Type) SetCONFIG0_SENSE2(value uint32) {
	volatile.StoreUint32(&o.CONFIG0.Reg, volatile.LoadUint32(&o.CONFIG0.Reg)&^(0x700)|value<<8)
}
func (o *EIC_Type) GetCONFIG0_SENSE2() uint32 {
	return (volatile.LoadUint32(&o.CONFIG0.Reg) & 0x700) >> 8
}
func (o *EIC_Type) SetCONFIG0_FILTEN2(value uint32) {
	volatile.StoreUint32(&o.CONFIG0.Reg, volatile.LoadUint32(&o.CONFIG0.Reg)&^(0x800)|value<<11)
}
func (o *EIC_Type) GetCONFIG0_FILTEN2() uint32 {
	return (volatile.LoadUint32(&o.CONFIG0.Reg) & 0x800) >> 11
}
func (o *EIC_Type) SetCONFIG0_SENSE3(value uint32) {
	volatile.StoreUint32(&o.CONFIG0.Reg, volatile.LoadUint32(&o.CONFIG0.Reg)&^(0x7000)|value<<12)
}
func (o *EIC_Type) GetCONFIG0_SENSE3() uint32 {
	return (volatile.LoadUint32(&o.CONFIG0.Reg) & 0x7000) >> 12
}
func (o *EIC_Type) SetCONFIG0_FILTEN3(value uint32) {
	volatile.StoreUint32(&o.CONFIG0.Reg, volatile.LoadUint32(&o.CONFIG0.Reg)&^(0x8000)|value<<15)
}
func (o *EIC_Type) GetCONFIG0_FILTEN3() uint32 {
	return (volatile.LoadUint32(&o.CONFIG0.Reg) & 0x8000) >> 15
}
func (o *EIC_Type) SetCONFIG0_SENSE4(value uint32) {
	volatile.StoreUint32(&o.CONFIG0.Reg, volatile.LoadUint32(&o.CONFIG0.Reg)&^(0x70000)|value<<16)
}
func (o *EIC_Type) GetCONFIG0_SENSE4() uint32 {
	return (volatile.LoadUint32(&o.CONFIG0.Reg) & 0x70000) >> 16
}
func (o *EIC_Type) SetCONFIG0_FILTEN4(value uint32) {
	volatile.StoreUint32(&o.CONFIG0.Reg, volatile.LoadUint32(&o.CONFIG0.Reg)&^(0x80000)|value<<19)
}
func (o *EIC_Type) GetCONFIG0_FILTEN4() uint32 {
	return (volatile.LoadUint32(&o.CONFIG0.Reg) & 0x80000) >> 19
}
func (o *EIC_Type) SetCONFIG0_SENSE5(value uint32) {
	volatile.StoreUint32(&o.CONFIG0.Reg, volatile.LoadUint32(&o.CONFIG0.Reg)&^(0x700000)|value<<20)
}
func (o *EIC_Type) GetCONFIG0_SENSE5() uint32 {
	return (volatile.LoadUint32(&o.CONFIG0.Reg) & 0x700000) >> 20
}
func (o *EIC_Type) SetCONFIG0_FILTEN5(value uint32) {
	volatile.StoreUint32(&o.CONFIG0.Reg, volatile.LoadUint32(&o.CONFIG0.Reg)&^(0x800000)|value<<23)
}
func (o *EIC_Type) GetCONFIG0_FILTEN5() uint32 {
	return (volatile.LoadUint32(&o.CONFIG0.Reg) & 0x800000) >> 23
}
func (o *EIC_Type) SetCONFIG0_SENSE6(value uint32) {
	volatile.StoreUint32(&o.CONFIG0.Reg, volatile.LoadUint32(&o.CONFIG0.Reg)&^(0x7000000)|value<<24)
}
func (o *EIC_Type) GetCONFIG0_SENSE6() uint32 {
	return (volatile.LoadUint32(&o.CONFIG0.Reg) & 0x7000000) >> 24
}
func (o *EIC_Type) SetCONFIG0_FILTEN6(value uint32) {
	volatile.StoreUint32(&o.CONFIG0.Reg, volatile.LoadUint32(&o.CONFIG0.Reg)&^(0x8000000)|value<<27)
}
func (o *EIC_Type) GetCONFIG0_FILTEN6() uint32 {
	return (volatile.LoadUint32(&o.CONFIG0.Reg) & 0x8000000) >> 27
}
func (o *EIC_Type) SetCONFIG0_SENSE7(value uint32) {
	volatile.StoreUint32(&o.CONFIG0.Reg, volatile.LoadUint32(&o.CONFIG0.Reg)&^(0x70000000)|value<<28)
}
func (o *EIC_Type) GetCONFIG0_SENSE7() uint32 {
	return (volatile.LoadUint32(&o.CONFIG0.Reg) & 0x70000000) >> 28
}
func (o *EIC_Type) SetCONFIG0_FILTEN7(value uint32) {
	volatile.StoreUint32(&o.CONFIG0.Reg, volatile.LoadUint32(&o.CONFIG0.Reg)&^(0x80000000)|value<<31)
}
func (o *EIC_Type) GetCONFIG0_FILTEN7() uint32 {
	return (volatile.LoadUint32(&o.CONFIG0.Reg) & 0x80000000) >> 31
}

// EIC.CONFIG1: Configuration n
func (o *EIC_Type) SetCONFIG1_SENSE0(value uint32) {
	volatile.StoreUint32(&o.CONFIG1.Reg, volatile.LoadUint32(&o.CONFIG1.Reg)&^(0x7)|value)
}
func (o *EIC_Type) GetCONFIG1_SENSE0() uint32 {
	return volatile.LoadUint32(&o.CONFIG1.Reg) & 0x7
}
func (o *EIC_Type) SetCONFIG1_FILTEN0(value uint32) {
	volatile.StoreUint32(&o.CONFIG1.Reg, volatile.LoadUint32(&o.CONFIG1.Reg)&^(0x8)|value<<3)
}
func (o *EIC_Type) GetCONFIG1_FILTEN0() uint32 {
	return (volatile.LoadUint32(&o.CONFIG1.Reg) & 0x8) >> 3
}
func (o *EIC_Type) SetCONFIG1_SENSE1(value uint32) {
	volatile.StoreUint32(&o.CONFIG1.Reg, volatile.LoadUint32(&o.CONFIG1.Reg)&^(0x70)|value<<4)
}
func (o *EIC_Type) GetCONFIG1_SENSE1() uint32 {
	return (volatile.LoadUint32(&o.CONFIG1.Reg) & 0x70) >> 4
}
func (o *EIC_Type) SetCONFIG1_FILTEN1(value uint32) {
	volatile.StoreUint32(&o.CONFIG1.Reg, volatile.LoadUint32(&o.CONFIG1.Reg)&^(0x80)|value<<7)
}
func (o *EIC_Type) GetCONFIG1_FILTEN1() uint32 {
	return (volatile.LoadUint32(&o.CONFIG1.Reg) & 0x80) >> 7
}
func (o *EIC_Type) SetCONFIG1_SENSE2(value uint32) {
	volatile.StoreUint32(&o.CONFIG1.Reg, volatile.LoadUint32(&o.CONFIG1.Reg)&^(0x700)|value<<8)
}
func (o *EIC_Type) GetCONFIG1_SENSE2() uint32 {
	return (volatile.LoadUint32(&o.CONFIG1.Reg) & 0x700) >> 8
}
func (o *EIC_Type) SetCONFIG1_FILTEN2(value uint32) {
	volatile.StoreUint32(&o.CONFIG1.Reg, volatile.LoadUint32(&o.CONFIG1.Reg)&^(0x800)|value<<11)
}
func (o *EIC_Type) GetCONFIG1_FILTEN2() uint32 {
	return (volatile.LoadUint32(&o.CONFIG1.Reg) & 0x800) >> 11
}
func (o *EIC_Type) SetCONFIG1_SENSE3(value uint32) {
	volatile.StoreUint32(&o.CONFIG1.Reg, volatile.LoadUint32(&o.CONFIG1.Reg)&^(0x7000)|value<<12)
}
func (o *EIC_Type) GetCONFIG1_SENSE3() uint32 {
	return (volatile.LoadUint32(&o.CONFIG1.Reg) & 0x7000) >> 12
}
func (o *EIC_Type) SetCONFIG1_FILTEN3(value uint32) {
	volatile.StoreUint32(&o.CONFIG1.Reg, volatile.LoadUint32(&o.CONFIG1.Reg)&^(0x8000)|value<<15)
}
func (o *EIC_Type) GetCONFIG1_FILTEN3() uint32 {
	return (volatile.LoadUint32(&o.CONFIG1.Reg) & 0x8000) >> 15
}
func (o *EIC_Type) SetCONFIG1_SENSE4(value uint32) {
	volatile.StoreUint32(&o.CONFIG1.Reg, volatile.LoadUint32(&o.CONFIG1.Reg)&^(0x70000)|value<<16)
}
func (o *EIC_Type) GetCONFIG1_SENSE4() uint32 {
	return (volatile.LoadUint32(&o.CONFIG1.Reg) & 0x70000) >> 16
}
func (o *EIC_Type) SetCONFIG1_FILTEN4(value uint32) {
	volatile.StoreUint32(&o.CONFIG1.Reg, volatile.LoadUint32(&o.CONFIG1.Reg)&^(0x80000)|value<<19)
}
func (o *EIC_Type) GetCONFIG1_FILTEN4() uint32 {
	return (volatile.LoadUint32(&o.CONFIG1.Reg) & 0x80000) >> 19
}
func (o *EIC_Type) SetCONFIG1_SENSE5(value uint32) {
	volatile.StoreUint32(&o.CONFIG1.Reg, volatile.LoadUint32(&o.CONFIG1.Reg)&^(0x700000)|value<<20)
}
func (o *EIC_Type) GetCONFIG1_SENSE5() uint32 {
	return (volatile.LoadUint32(&o.CONFIG1.Reg) & 0x700000) >> 20
}
func (o *EIC_Type) SetCONFIG1_FILTEN5(value uint32) {
	volatile.StoreUint32(&o.CONFIG1.Reg, volatile.LoadUint32(&o.CONFIG1.Reg)&^(0x800000)|value<<23)
}
func (o *EIC_Type) GetCONFIG1_FILTEN5() uint32 {
	return (volatile.LoadUint32(&o.CONFIG1.Reg) & 0x800000) >> 23
}
func (o *EIC_Type) SetCONFIG1_SENSE6(value uint32) {
	volatile.StoreUint32(&o.CONFIG1.Reg, volatile.LoadUint32(&o.CONFIG1.Reg)&^(0x7000000)|value<<24)
}
func (o *EIC_Type) GetCONFIG1_SENSE6() uint32 {
	return (volatile.LoadUint32(&o.CONFIG1.Reg) & 0x7000000) >> 24
}
func (o *EIC_Type) SetCONFIG1_FILTEN6(value uint32) {
	volatile.StoreUint32(&o.CONFIG1.Reg, volatile.LoadUint32(&o.CONFIG1.Reg)&^(0x8000000)|value<<27)
}
func (o *EIC_Type) GetCONFIG1_FILTEN6() uint32 {
	return (volatile.LoadUint32(&o.CONFIG1.Reg) & 0x8000000) >> 27
}
func (o *EIC_Type) SetCONFIG1_SENSE7(value uint32) {
	volatile.StoreUint32(&o.CONFIG1.Reg, volatile.LoadUint32(&o.CONFIG1.Reg)&^(0x70000000)|value<<28)
}
func (o *EIC_Type) GetCONFIG1_SENSE7() uint32 {
	return (volatile.LoadUint32(&o.CONFIG1.Reg) & 0x70000000) >> 28
}
func (o *EIC_Type) SetCONFIG1_FILTEN7(value uint32) {
	volatile.StoreUint32(&o.CONFIG1.Reg, volatile.LoadUint32(&o.CONFIG1.Reg)&^(0x80000000)|value<<31)
}
func (o *EIC_Type) GetCONFIG1_FILTEN7() uint32 {
	return (volatile.LoadUint32(&o.CONFIG1.Reg) & 0x80000000) >> 31
}

// Event System Interface
type EVSYS_Type struct {
	CTRLA    volatile.Register8 // 0x0
	_        [11]byte
	CHSTATUS volatile.Register32 // 0xC
	INTENCLR volatile.Register32 // 0x10
	INTENSET volatile.Register32 // 0x14
	INTFLAG  volatile.Register32 // 0x18
	SWEVT    volatile.Register32 // 0x1C
	CHANNEL0 volatile.Register32 // 0x20
	CHANNEL1 volatile.Register32 // 0x24
	CHANNEL2 volatile.Register32 // 0x28
	CHANNEL3 volatile.Register32 // 0x2C
	CHANNEL4 volatile.Register32 // 0x30
	CHANNEL5 volatile.Register32 // 0x34
	CHANNEL6 volatile.Register32 // 0x38
	CHANNEL7 volatile.Register32 // 0x3C
	_        [64]byte
	USER0    volatile.Register32 // 0x80
	USER1    volatile.Register32 // 0x84
	USER2    volatile.Register32 // 0x88
	USER3    volatile.Register32 // 0x8C
	USER4    volatile.Register32 // 0x90
	USER5    volatile.Register32 // 0x94
	USER6    volatile.Register32 // 0x98
	USER7    volatile.Register32 // 0x9C
	USER8    volatile.Register32 // 0xA0
	USER9    volatile.Register32 // 0xA4
	USER10   volatile.Register32 // 0xA8
	USER11   volatile.Register32 // 0xAC
	USER12   volatile.Register32 // 0xB0
	USER13   volatile.Register32 // 0xB4
	USER14   volatile.Register32 // 0xB8
	USER15   volatile.Register32 // 0xBC
	USER16   volatile.Register32 // 0xC0
	USER17   volatile.Register32 // 0xC4
	USER18   volatile.Register32 // 0xC8
	USER19   volatile.Register32 // 0xCC
	USER20   volatile.Register32 // 0xD0
	USER21   volatile.Register32 // 0xD4
	USER22   volatile.Register32 // 0xD8
	USER23   volatile.Register32 // 0xDC
	USER24   volatile.Register32 // 0xE0
	USER25   volatile.Register32 // 0xE4
	USER26   volatile.Register32 // 0xE8
	USER27   volatile.Register32 // 0xEC
	USER28   volatile.Register32 // 0xF0
	USER29   volatile.Register32 // 0xF4
	USER30   volatile.Register32 // 0xF8
}

// EVSYS.CTRLA: Control
func (o *EVSYS_Type) SetCTRLA_SWRST(value uint8) {
	volatile.StoreUint8(&o.CTRLA.Reg, volatile.LoadUint8(&o.CTRLA.Reg)&^(0x1)|value)
}
func (o *EVSYS_Type) GetCTRLA_SWRST() uint8 {
	return volatile.LoadUint8(&o.CTRLA.Reg) & 0x1
}

// EVSYS.CHSTATUS: Channel Status
func (o *EVSYS_Type) SetCHSTATUS_USRRDY0(value uint32) {
	volatile.StoreUint32(&o.CHSTATUS.Reg, volatile.LoadUint32(&o.CHSTATUS.Reg)&^(0x1)|value)
}
func (o *EVSYS_Type) GetCHSTATUS_USRRDY0() uint32 {
	return volatile.LoadUint32(&o.CHSTATUS.Reg) & 0x1
}
func (o *EVSYS_Type) SetCHSTATUS_USRRDY1(value uint32) {
	volatile.StoreUint32(&o.CHSTATUS.Reg, volatile.LoadUint32(&o.CHSTATUS.Reg)&^(0x2)|value<<1)
}
func (o *EVSYS_Type) GetCHSTATUS_USRRDY1() uint32 {
	return (volatile.LoadUint32(&o.CHSTATUS.Reg) & 0x2) >> 1
}
func (o *EVSYS_Type) SetCHSTATUS_USRRDY2(value uint32) {
	volatile.StoreUint32(&o.CHSTATUS.Reg, volatile.LoadUint32(&o.CHSTATUS.Reg)&^(0x4)|value<<2)
}
func (o *EVSYS_Type) GetCHSTATUS_USRRDY2() uint32 {
	return (volatile.LoadUint32(&o.CHSTATUS.Reg) & 0x4) >> 2
}
func (o *EVSYS_Type) SetCHSTATUS_USRRDY3(value uint32) {
	volatile.StoreUint32(&o.CHSTATUS.Reg, volatile.LoadUint32(&o.CHSTATUS.Reg)&^(0x8)|value<<3)
}
func (o *EVSYS_Type) GetCHSTATUS_USRRDY3() uint32 {
	return (volatile.LoadUint32(&o.CHSTATUS.Reg) & 0x8) >> 3
}
func (o *EVSYS_Type) SetCHSTATUS_USRRDY4(value uint32) {
	volatile.StoreUint32(&o.CHSTATUS.Reg, volatile.LoadUint32(&o.CHSTATUS.Reg)&^(0x10)|value<<4)
}
func (o *EVSYS_Type) GetCHSTATUS_USRRDY4() uint32 {
	return (volatile.LoadUint32(&o.CHSTATUS.Reg) & 0x10) >> 4
}
func (o *EVSYS_Type) SetCHSTATUS_USRRDY5(value uint32) {
	volatile.StoreUint32(&o.CHSTATUS.Reg, volatile.LoadUint32(&o.CHSTATUS.Reg)&^(0x20)|value<<5)
}
func (o *EVSYS_Type) GetCHSTATUS_USRRDY5() uint32 {
	return (volatile.LoadUint32(&o.CHSTATUS.Reg) & 0x20) >> 5
}
func (o *EVSYS_Type) SetCHSTATUS_USRRDY6(value uint32) {
	volatile.StoreUint32(&o.CHSTATUS.Reg, volatile.LoadUint32(&o.CHSTATUS.Reg)&^(0x40)|value<<6)
}
func (o *EVSYS_Type) GetCHSTATUS_USRRDY6() uint32 {
	return (volatile.LoadUint32(&o.CHSTATUS.Reg) & 0x40) >> 6
}
func (o *EVSYS_Type) SetCHSTATUS_USRRDY7(value uint32) {
	volatile.StoreUint32(&o.CHSTATUS.Reg, volatile.LoadUint32(&o.CHSTATUS.Reg)&^(0x80)|value<<7)
}
func (o *EVSYS_Type) GetCHSTATUS_USRRDY7() uint32 {
	return (volatile.LoadUint32(&o.CHSTATUS.Reg) & 0x80) >> 7
}
func (o *EVSYS_Type) SetCHSTATUS_CHBUSY0(value uint32) {
	volatile.StoreUint32(&o.CHSTATUS.Reg, volatile.LoadUint32(&o.CHSTATUS.Reg)&^(0x10000)|value<<16)
}
func (o *EVSYS_Type) GetCHSTATUS_CHBUSY0() uint32 {
	return (volatile.LoadUint32(&o.CHSTATUS.Reg) & 0x10000) >> 16
}
func (o *EVSYS_Type) SetCHSTATUS_CHBUSY1(value uint32) {
	volatile.StoreUint32(&o.CHSTATUS.Reg, volatile.LoadUint32(&o.CHSTATUS.Reg)&^(0x20000)|value<<17)
}
func (o *EVSYS_Type) GetCHSTATUS_CHBUSY1() uint32 {
	return (volatile.LoadUint32(&o.CHSTATUS.Reg) & 0x20000) >> 17
}
func (o *EVSYS_Type) SetCHSTATUS_CHBUSY2(value uint32) {
	volatile.StoreUint32(&o.CHSTATUS.Reg, volatile.LoadUint32(&o.CHSTATUS.Reg)&^(0x40000)|value<<18)
}
func (o *EVSYS_Type) GetCHSTATUS_CHBUSY2() uint32 {
	return (volatile.LoadUint32(&o.CHSTATUS.Reg) & 0x40000) >> 18
}
func (o *EVSYS_Type) SetCHSTATUS_CHBUSY3(value uint32) {
	volatile.StoreUint32(&o.CHSTATUS.Reg, volatile.LoadUint32(&o.CHSTATUS.Reg)&^(0x80000)|value<<19)
}
func (o *EVSYS_Type) GetCHSTATUS_CHBUSY3() uint32 {
	return (volatile.LoadUint32(&o.CHSTATUS.Reg) & 0x80000) >> 19
}
func (o *EVSYS_Type) SetCHSTATUS_CHBUSY4(value uint32) {
	volatile.StoreUint32(&o.CHSTATUS.Reg, volatile.LoadUint32(&o.CHSTATUS.Reg)&^(0x100000)|value<<20)
}
func (o *EVSYS_Type) GetCHSTATUS_CHBUSY4() uint32 {
	return (volatile.LoadUint32(&o.CHSTATUS.Reg) & 0x100000) >> 20
}
func (o *EVSYS_Type) SetCHSTATUS_CHBUSY5(value uint32) {
	volatile.StoreUint32(&o.CHSTATUS.Reg, volatile.LoadUint32(&o.CHSTATUS.Reg)&^(0x200000)|value<<21)
}
func (o *EVSYS_Type) GetCHSTATUS_CHBUSY5() uint32 {
	return (volatile.LoadUint32(&o.CHSTATUS.Reg) & 0x200000) >> 21
}
func (o *EVSYS_Type) SetCHSTATUS_CHBUSY6(value uint32) {
	volatile.StoreUint32(&o.CHSTATUS.Reg, volatile.LoadUint32(&o.CHSTATUS.Reg)&^(0x400000)|value<<22)
}
func (o *EVSYS_Type) GetCHSTATUS_CHBUSY6() uint32 {
	return (volatile.LoadUint32(&o.CHSTATUS.Reg) & 0x400000) >> 22
}
func (o *EVSYS_Type) SetCHSTATUS_CHBUSY7(value uint32) {
	volatile.StoreUint32(&o.CHSTATUS.Reg, volatile.LoadUint32(&o.CHSTATUS.Reg)&^(0x800000)|value<<23)
}
func (o *EVSYS_Type) GetCHSTATUS_CHBUSY7() uint32 {
	return (volatile.LoadUint32(&o.CHSTATUS.Reg) & 0x800000) >> 23
}

// EVSYS.INTENCLR: Interrupt Enable Clear
func (o *EVSYS_Type) SetINTENCLR_OVR0(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *EVSYS_Type) GetINTENCLR_OVR0() uint32 {
	return volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1
}
func (o *EVSYS_Type) SetINTENCLR_OVR1(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *EVSYS_Type) GetINTENCLR_OVR1() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *EVSYS_Type) SetINTENCLR_OVR2(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x4)|value<<2)
}
func (o *EVSYS_Type) GetINTENCLR_OVR2() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x4) >> 2
}
func (o *EVSYS_Type) SetINTENCLR_OVR3(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x8)|value<<3)
}
func (o *EVSYS_Type) GetINTENCLR_OVR3() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x8) >> 3
}
func (o *EVSYS_Type) SetINTENCLR_OVR4(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x10)|value<<4)
}
func (o *EVSYS_Type) GetINTENCLR_OVR4() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x10) >> 4
}
func (o *EVSYS_Type) SetINTENCLR_OVR5(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x20)|value<<5)
}
func (o *EVSYS_Type) GetINTENCLR_OVR5() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x20) >> 5
}
func (o *EVSYS_Type) SetINTENCLR_OVR6(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x40)|value<<6)
}
func (o *EVSYS_Type) GetINTENCLR_OVR6() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x40) >> 6
}
func (o *EVSYS_Type) SetINTENCLR_OVR7(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x80)|value<<7)
}
func (o *EVSYS_Type) GetINTENCLR_OVR7() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x80) >> 7
}
func (o *EVSYS_Type) SetINTENCLR_EVD0(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x10000)|value<<16)
}
func (o *EVSYS_Type) GetINTENCLR_EVD0() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x10000) >> 16
}
func (o *EVSYS_Type) SetINTENCLR_EVD1(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x20000)|value<<17)
}
func (o *EVSYS_Type) GetINTENCLR_EVD1() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x20000) >> 17
}
func (o *EVSYS_Type) SetINTENCLR_EVD2(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x40000)|value<<18)
}
func (o *EVSYS_Type) GetINTENCLR_EVD2() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x40000) >> 18
}
func (o *EVSYS_Type) SetINTENCLR_EVD3(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x80000)|value<<19)
}
func (o *EVSYS_Type) GetINTENCLR_EVD3() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x80000) >> 19
}
func (o *EVSYS_Type) SetINTENCLR_EVD4(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x100000)|value<<20)
}
func (o *EVSYS_Type) GetINTENCLR_EVD4() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x100000) >> 20
}
func (o *EVSYS_Type) SetINTENCLR_EVD5(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x200000)|value<<21)
}
func (o *EVSYS_Type) GetINTENCLR_EVD5() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x200000) >> 21
}
func (o *EVSYS_Type) SetINTENCLR_EVD6(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x400000)|value<<22)
}
func (o *EVSYS_Type) GetINTENCLR_EVD6() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x400000) >> 22
}
func (o *EVSYS_Type) SetINTENCLR_EVD7(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x800000)|value<<23)
}
func (o *EVSYS_Type) GetINTENCLR_EVD7() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x800000) >> 23
}

// EVSYS.INTENSET: Interrupt Enable Set
func (o *EVSYS_Type) SetINTENSET_OVR0(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *EVSYS_Type) GetINTENSET_OVR0() uint32 {
	return volatile.LoadUint32(&o.INTENSET.Reg) & 0x1
}
func (o *EVSYS_Type) SetINTENSET_OVR1(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *EVSYS_Type) GetINTENSET_OVR1() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *EVSYS_Type) SetINTENSET_OVR2(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x4)|value<<2)
}
func (o *EVSYS_Type) GetINTENSET_OVR2() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x4) >> 2
}
func (o *EVSYS_Type) SetINTENSET_OVR3(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x8)|value<<3)
}
func (o *EVSYS_Type) GetINTENSET_OVR3() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x8) >> 3
}
func (o *EVSYS_Type) SetINTENSET_OVR4(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x10)|value<<4)
}
func (o *EVSYS_Type) GetINTENSET_OVR4() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x10) >> 4
}
func (o *EVSYS_Type) SetINTENSET_OVR5(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x20)|value<<5)
}
func (o *EVSYS_Type) GetINTENSET_OVR5() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x20) >> 5
}
func (o *EVSYS_Type) SetINTENSET_OVR6(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x40)|value<<6)
}
func (o *EVSYS_Type) GetINTENSET_OVR6() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x40) >> 6
}
func (o *EVSYS_Type) SetINTENSET_OVR7(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x80)|value<<7)
}
func (o *EVSYS_Type) GetINTENSET_OVR7() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x80) >> 7
}
func (o *EVSYS_Type) SetINTENSET_EVD0(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x10000)|value<<16)
}
func (o *EVSYS_Type) GetINTENSET_EVD0() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x10000) >> 16
}
func (o *EVSYS_Type) SetINTENSET_EVD1(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x20000)|value<<17)
}
func (o *EVSYS_Type) GetINTENSET_EVD1() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x20000) >> 17
}
func (o *EVSYS_Type) SetINTENSET_EVD2(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x40000)|value<<18)
}
func (o *EVSYS_Type) GetINTENSET_EVD2() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x40000) >> 18
}
func (o *EVSYS_Type) SetINTENSET_EVD3(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x80000)|value<<19)
}
func (o *EVSYS_Type) GetINTENSET_EVD3() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x80000) >> 19
}
func (o *EVSYS_Type) SetINTENSET_EVD4(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x100000)|value<<20)
}
func (o *EVSYS_Type) GetINTENSET_EVD4() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x100000) >> 20
}
func (o *EVSYS_Type) SetINTENSET_EVD5(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x200000)|value<<21)
}
func (o *EVSYS_Type) GetINTENSET_EVD5() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x200000) >> 21
}
func (o *EVSYS_Type) SetINTENSET_EVD6(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x400000)|value<<22)
}
func (o *EVSYS_Type) GetINTENSET_EVD6() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x400000) >> 22
}
func (o *EVSYS_Type) SetINTENSET_EVD7(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x800000)|value<<23)
}
func (o *EVSYS_Type) GetINTENSET_EVD7() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x800000) >> 23
}

// EVSYS.INTFLAG: Interrupt Flag Status and Clear
func (o *EVSYS_Type) SetINTFLAG_OVR0(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x1)|value)
}
func (o *EVSYS_Type) GetINTFLAG_OVR0() uint32 {
	return volatile.LoadUint32(&o.INTFLAG.Reg) & 0x1
}
func (o *EVSYS_Type) SetINTFLAG_OVR1(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x2)|value<<1)
}
func (o *EVSYS_Type) GetINTFLAG_OVR1() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x2) >> 1
}
func (o *EVSYS_Type) SetINTFLAG_OVR2(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x4)|value<<2)
}
func (o *EVSYS_Type) GetINTFLAG_OVR2() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x4) >> 2
}
func (o *EVSYS_Type) SetINTFLAG_OVR3(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x8)|value<<3)
}
func (o *EVSYS_Type) GetINTFLAG_OVR3() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x8) >> 3
}
func (o *EVSYS_Type) SetINTFLAG_OVR4(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x10)|value<<4)
}
func (o *EVSYS_Type) GetINTFLAG_OVR4() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x10) >> 4
}
func (o *EVSYS_Type) SetINTFLAG_OVR5(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x20)|value<<5)
}
func (o *EVSYS_Type) GetINTFLAG_OVR5() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x20) >> 5
}
func (o *EVSYS_Type) SetINTFLAG_OVR6(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x40)|value<<6)
}
func (o *EVSYS_Type) GetINTFLAG_OVR6() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x40) >> 6
}
func (o *EVSYS_Type) SetINTFLAG_OVR7(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x80)|value<<7)
}
func (o *EVSYS_Type) GetINTFLAG_OVR7() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x80) >> 7
}
func (o *EVSYS_Type) SetINTFLAG_EVD0(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x10000)|value<<16)
}
func (o *EVSYS_Type) GetINTFLAG_EVD0() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x10000) >> 16
}
func (o *EVSYS_Type) SetINTFLAG_EVD1(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x20000)|value<<17)
}
func (o *EVSYS_Type) GetINTFLAG_EVD1() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x20000) >> 17
}
func (o *EVSYS_Type) SetINTFLAG_EVD2(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x40000)|value<<18)
}
func (o *EVSYS_Type) GetINTFLAG_EVD2() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x40000) >> 18
}
func (o *EVSYS_Type) SetINTFLAG_EVD3(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x80000)|value<<19)
}
func (o *EVSYS_Type) GetINTFLAG_EVD3() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x80000) >> 19
}
func (o *EVSYS_Type) SetINTFLAG_EVD4(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x100000)|value<<20)
}
func (o *EVSYS_Type) GetINTFLAG_EVD4() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x100000) >> 20
}
func (o *EVSYS_Type) SetINTFLAG_EVD5(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x200000)|value<<21)
}
func (o *EVSYS_Type) GetINTFLAG_EVD5() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x200000) >> 21
}
func (o *EVSYS_Type) SetINTFLAG_EVD6(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x400000)|value<<22)
}
func (o *EVSYS_Type) GetINTFLAG_EVD6() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x400000) >> 22
}
func (o *EVSYS_Type) SetINTFLAG_EVD7(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x800000)|value<<23)
}
func (o *EVSYS_Type) GetINTFLAG_EVD7() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x800000) >> 23
}

// EVSYS.SWEVT: Software Event
func (o *EVSYS_Type) SetSWEVT_CHANNEL0(value uint32) {
	volatile.StoreUint32(&o.SWEVT.Reg, volatile.LoadUint32(&o.SWEVT.Reg)&^(0x1)|value)
}
func (o *EVSYS_Type) GetSWEVT_CHANNEL0() uint32 {
	return volatile.LoadUint32(&o.SWEVT.Reg) & 0x1
}
func (o *EVSYS_Type) SetSWEVT_CHANNEL1(value uint32) {
	volatile.StoreUint32(&o.SWEVT.Reg, volatile.LoadUint32(&o.SWEVT.Reg)&^(0x2)|value<<1)
}
func (o *EVSYS_Type) GetSWEVT_CHANNEL1() uint32 {
	return (volatile.LoadUint32(&o.SWEVT.Reg) & 0x2) >> 1
}
func (o *EVSYS_Type) SetSWEVT_CHANNEL2(value uint32) {
	volatile.StoreUint32(&o.SWEVT.Reg, volatile.LoadUint32(&o.SWEVT.Reg)&^(0x4)|value<<2)
}
func (o *EVSYS_Type) GetSWEVT_CHANNEL2() uint32 {
	return (volatile.LoadUint32(&o.SWEVT.Reg) & 0x4) >> 2
}
func (o *EVSYS_Type) SetSWEVT_CHANNEL3(value uint32) {
	volatile.StoreUint32(&o.SWEVT.Reg, volatile.LoadUint32(&o.SWEVT.Reg)&^(0x8)|value<<3)
}
func (o *EVSYS_Type) GetSWEVT_CHANNEL3() uint32 {
	return (volatile.LoadUint32(&o.SWEVT.Reg) & 0x8) >> 3
}
func (o *EVSYS_Type) SetSWEVT_CHANNEL4(value uint32) {
	volatile.StoreUint32(&o.SWEVT.Reg, volatile.LoadUint32(&o.SWEVT.Reg)&^(0x10)|value<<4)
}
func (o *EVSYS_Type) GetSWEVT_CHANNEL4() uint32 {
	return (volatile.LoadUint32(&o.SWEVT.Reg) & 0x10) >> 4
}
func (o *EVSYS_Type) SetSWEVT_CHANNEL5(value uint32) {
	volatile.StoreUint32(&o.SWEVT.Reg, volatile.LoadUint32(&o.SWEVT.Reg)&^(0x20)|value<<5)
}
func (o *EVSYS_Type) GetSWEVT_CHANNEL5() uint32 {
	return (volatile.LoadUint32(&o.SWEVT.Reg) & 0x20) >> 5
}
func (o *EVSYS_Type) SetSWEVT_CHANNEL6(value uint32) {
	volatile.StoreUint32(&o.SWEVT.Reg, volatile.LoadUint32(&o.SWEVT.Reg)&^(0x40)|value<<6)
}
func (o *EVSYS_Type) GetSWEVT_CHANNEL6() uint32 {
	return (volatile.LoadUint32(&o.SWEVT.Reg) & 0x40) >> 6
}
func (o *EVSYS_Type) SetSWEVT_CHANNEL7(value uint32) {
	volatile.StoreUint32(&o.SWEVT.Reg, volatile.LoadUint32(&o.SWEVT.Reg)&^(0x80)|value<<7)
}
func (o *EVSYS_Type) GetSWEVT_CHANNEL7() uint32 {
	return (volatile.LoadUint32(&o.SWEVT.Reg) & 0x80) >> 7
}

// EVSYS.CHANNEL0: Channel n
func (o *EVSYS_Type) SetCHANNEL0_EVGEN(value uint32) {
	volatile.StoreUint32(&o.CHANNEL0.Reg, volatile.LoadUint32(&o.CHANNEL0.Reg)&^(0x7f)|value)
}
func (o *EVSYS_Type) GetCHANNEL0_EVGEN() uint32 {
	return volatile.LoadUint32(&o.CHANNEL0.Reg) & 0x7f
}
func (o *EVSYS_Type) SetCHANNEL0_PATH(value uint32) {
	volatile.StoreUint32(&o.CHANNEL0.Reg, volatile.LoadUint32(&o.CHANNEL0.Reg)&^(0x300)|value<<8)
}
func (o *EVSYS_Type) GetCHANNEL0_PATH() uint32 {
	return (volatile.LoadUint32(&o.CHANNEL0.Reg) & 0x300) >> 8
}
func (o *EVSYS_Type) SetCHANNEL0_EDGSEL(value uint32) {
	volatile.StoreUint32(&o.CHANNEL0.Reg, volatile.LoadUint32(&o.CHANNEL0.Reg)&^(0xc00)|value<<10)
}
func (o *EVSYS_Type) GetCHANNEL0_EDGSEL() uint32 {
	return (volatile.LoadUint32(&o.CHANNEL0.Reg) & 0xc00) >> 10
}
func (o *EVSYS_Type) SetCHANNEL0_RUNSTDBY(value uint32) {
	volatile.StoreUint32(&o.CHANNEL0.Reg, volatile.LoadUint32(&o.CHANNEL0.Reg)&^(0x4000)|value<<14)
}
func (o *EVSYS_Type) GetCHANNEL0_RUNSTDBY() uint32 {
	return (volatile.LoadUint32(&o.CHANNEL0.Reg) & 0x4000) >> 14
}
func (o *EVSYS_Type) SetCHANNEL0_ONDEMAND(value uint32) {
	volatile.StoreUint32(&o.CHANNEL0.Reg, volatile.LoadUint32(&o.CHANNEL0.Reg)&^(0x8000)|value<<15)
}
func (o *EVSYS_Type) GetCHANNEL0_ONDEMAND() uint32 {
	return (volatile.LoadUint32(&o.CHANNEL0.Reg) & 0x8000) >> 15
}

// EVSYS.CHANNEL1: Channel n
func (o *EVSYS_Type) SetCHANNEL1_EVGEN(value uint32) {
	volatile.StoreUint32(&o.CHANNEL1.Reg, volatile.LoadUint32(&o.CHANNEL1.Reg)&^(0x7f)|value)
}
func (o *EVSYS_Type) GetCHANNEL1_EVGEN() uint32 {
	return volatile.LoadUint32(&o.CHANNEL1.Reg) & 0x7f
}
func (o *EVSYS_Type) SetCHANNEL1_PATH(value uint32) {
	volatile.StoreUint32(&o.CHANNEL1.Reg, volatile.LoadUint32(&o.CHANNEL1.Reg)&^(0x300)|value<<8)
}
func (o *EVSYS_Type) GetCHANNEL1_PATH() uint32 {
	return (volatile.LoadUint32(&o.CHANNEL1.Reg) & 0x300) >> 8
}
func (o *EVSYS_Type) SetCHANNEL1_EDGSEL(value uint32) {
	volatile.StoreUint32(&o.CHANNEL1.Reg, volatile.LoadUint32(&o.CHANNEL1.Reg)&^(0xc00)|value<<10)
}
func (o *EVSYS_Type) GetCHANNEL1_EDGSEL() uint32 {
	return (volatile.LoadUint32(&o.CHANNEL1.Reg) & 0xc00) >> 10
}
func (o *EVSYS_Type) SetCHANNEL1_RUNSTDBY(value uint32) {
	volatile.StoreUint32(&o.CHANNEL1.Reg, volatile.LoadUint32(&o.CHANNEL1.Reg)&^(0x4000)|value<<14)
}
func (o *EVSYS_Type) GetCHANNEL1_RUNSTDBY() uint32 {
	return (volatile.LoadUint32(&o.CHANNEL1.Reg) & 0x4000) >> 14
}
func (o *EVSYS_Type) SetCHANNEL1_ONDEMAND(value uint32) {
	volatile.StoreUint32(&o.CHANNEL1.Reg, volatile.LoadUint32(&o.CHANNEL1.Reg)&^(0x8000)|value<<15)
}
func (o *EVSYS_Type) GetCHANNEL1_ONDEMAND() uint32 {
	return (volatile.LoadUint32(&o.CHANNEL1.Reg) & 0x8000) >> 15
}

// EVSYS.CHANNEL2: Channel n
func (o *EVSYS_Type) SetCHANNEL2_EVGEN(value uint32) {
	volatile.StoreUint32(&o.CHANNEL2.Reg, volatile.LoadUint32(&o.CHANNEL2.Reg)&^(0x7f)|value)
}
func (o *EVSYS_Type) GetCHANNEL2_EVGEN() uint32 {
	return volatile.LoadUint32(&o.CHANNEL2.Reg) & 0x7f
}
func (o *EVSYS_Type) SetCHANNEL2_PATH(value uint32) {
	volatile.StoreUint32(&o.CHANNEL2.Reg, volatile.LoadUint32(&o.CHANNEL2.Reg)&^(0x300)|value<<8)
}
func (o *EVSYS_Type) GetCHANNEL2_PATH() uint32 {
	return (volatile.LoadUint32(&o.CHANNEL2.Reg) & 0x300) >> 8
}
func (o *EVSYS_Type) SetCHANNEL2_EDGSEL(value uint32) {
	volatile.StoreUint32(&o.CHANNEL2.Reg, volatile.LoadUint32(&o.CHANNEL2.Reg)&^(0xc00)|value<<10)
}
func (o *EVSYS_Type) GetCHANNEL2_EDGSEL() uint32 {
	return (volatile.LoadUint32(&o.CHANNEL2.Reg) & 0xc00) >> 10
}
func (o *EVSYS_Type) SetCHANNEL2_RUNSTDBY(value uint32) {
	volatile.StoreUint32(&o.CHANNEL2.Reg, volatile.LoadUint32(&o.CHANNEL2.Reg)&^(0x4000)|value<<14)
}
func (o *EVSYS_Type) GetCHANNEL2_RUNSTDBY() uint32 {
	return (volatile.LoadUint32(&o.CHANNEL2.Reg) & 0x4000) >> 14
}
func (o *EVSYS_Type) SetCHANNEL2_ONDEMAND(value uint32) {
	volatile.StoreUint32(&o.CHANNEL2.Reg, volatile.LoadUint32(&o.CHANNEL2.Reg)&^(0x8000)|value<<15)
}
func (o *EVSYS_Type) GetCHANNEL2_ONDEMAND() uint32 {
	return (volatile.LoadUint32(&o.CHANNEL2.Reg) & 0x8000) >> 15
}

// EVSYS.CHANNEL3: Channel n
func (o *EVSYS_Type) SetCHANNEL3_EVGEN(value uint32) {
	volatile.StoreUint32(&o.CHANNEL3.Reg, volatile.LoadUint32(&o.CHANNEL3.Reg)&^(0x7f)|value)
}
func (o *EVSYS_Type) GetCHANNEL3_EVGEN() uint32 {
	return volatile.LoadUint32(&o.CHANNEL3.Reg) & 0x7f
}
func (o *EVSYS_Type) SetCHANNEL3_PATH(value uint32) {
	volatile.StoreUint32(&o.CHANNEL3.Reg, volatile.LoadUint32(&o.CHANNEL3.Reg)&^(0x300)|value<<8)
}
func (o *EVSYS_Type) GetCHANNEL3_PATH() uint32 {
	return (volatile.LoadUint32(&o.CHANNEL3.Reg) & 0x300) >> 8
}
func (o *EVSYS_Type) SetCHANNEL3_EDGSEL(value uint32) {
	volatile.StoreUint32(&o.CHANNEL3.Reg, volatile.LoadUint32(&o.CHANNEL3.Reg)&^(0xc00)|value<<10)
}
func (o *EVSYS_Type) GetCHANNEL3_EDGSEL() uint32 {
	return (volatile.LoadUint32(&o.CHANNEL3.Reg) & 0xc00) >> 10
}
func (o *EVSYS_Type) SetCHANNEL3_RUNSTDBY(value uint32) {
	volatile.StoreUint32(&o.CHANNEL3.Reg, volatile.LoadUint32(&o.CHANNEL3.Reg)&^(0x4000)|value<<14)
}
func (o *EVSYS_Type) GetCHANNEL3_RUNSTDBY() uint32 {
	return (volatile.LoadUint32(&o.CHANNEL3.Reg) & 0x4000) >> 14
}
func (o *EVSYS_Type) SetCHANNEL3_ONDEMAND(value uint32) {
	volatile.StoreUint32(&o.CHANNEL3.Reg, volatile.LoadUint32(&o.CHANNEL3.Reg)&^(0x8000)|value<<15)
}
func (o *EVSYS_Type) GetCHANNEL3_ONDEMAND() uint32 {
	return (volatile.LoadUint32(&o.CHANNEL3.Reg) & 0x8000) >> 15
}

// EVSYS.CHANNEL4: Channel n
func (o *EVSYS_Type) SetCHANNEL4_EVGEN(value uint32) {
	volatile.StoreUint32(&o.CHANNEL4.Reg, volatile.LoadUint32(&o.CHANNEL4.Reg)&^(0x7f)|value)
}
func (o *EVSYS_Type) GetCHANNEL4_EVGEN() uint32 {
	return volatile.LoadUint32(&o.CHANNEL4.Reg) & 0x7f
}
func (o *EVSYS_Type) SetCHANNEL4_PATH(value uint32) {
	volatile.StoreUint32(&o.CHANNEL4.Reg, volatile.LoadUint32(&o.CHANNEL4.Reg)&^(0x300)|value<<8)
}
func (o *EVSYS_Type) GetCHANNEL4_PATH() uint32 {
	return (volatile.LoadUint32(&o.CHANNEL4.Reg) & 0x300) >> 8
}
func (o *EVSYS_Type) SetCHANNEL4_EDGSEL(value uint32) {
	volatile.StoreUint32(&o.CHANNEL4.Reg, volatile.LoadUint32(&o.CHANNEL4.Reg)&^(0xc00)|value<<10)
}
func (o *EVSYS_Type) GetCHANNEL4_EDGSEL() uint32 {
	return (volatile.LoadUint32(&o.CHANNEL4.Reg) & 0xc00) >> 10
}
func (o *EVSYS_Type) SetCHANNEL4_RUNSTDBY(value uint32) {
	volatile.StoreUint32(&o.CHANNEL4.Reg, volatile.LoadUint32(&o.CHANNEL4.Reg)&^(0x4000)|value<<14)
}
func (o *EVSYS_Type) GetCHANNEL4_RUNSTDBY() uint32 {
	return (volatile.LoadUint32(&o.CHANNEL4.Reg) & 0x4000) >> 14
}
func (o *EVSYS_Type) SetCHANNEL4_ONDEMAND(value uint32) {
	volatile.StoreUint32(&o.CHANNEL4.Reg, volatile.LoadUint32(&o.CHANNEL4.Reg)&^(0x8000)|value<<15)
}
func (o *EVSYS_Type) GetCHANNEL4_ONDEMAND() uint32 {
	return (volatile.LoadUint32(&o.CHANNEL4.Reg) & 0x8000) >> 15
}

// EVSYS.CHANNEL5: Channel n
func (o *EVSYS_Type) SetCHANNEL5_EVGEN(value uint32) {
	volatile.StoreUint32(&o.CHANNEL5.Reg, volatile.LoadUint32(&o.CHANNEL5.Reg)&^(0x7f)|value)
}
func (o *EVSYS_Type) GetCHANNEL5_EVGEN() uint32 {
	return volatile.LoadUint32(&o.CHANNEL5.Reg) & 0x7f
}
func (o *EVSYS_Type) SetCHANNEL5_PATH(value uint32) {
	volatile.StoreUint32(&o.CHANNEL5.Reg, volatile.LoadUint32(&o.CHANNEL5.Reg)&^(0x300)|value<<8)
}
func (o *EVSYS_Type) GetCHANNEL5_PATH() uint32 {
	return (volatile.LoadUint32(&o.CHANNEL5.Reg) & 0x300) >> 8
}
func (o *EVSYS_Type) SetCHANNEL5_EDGSEL(value uint32) {
	volatile.StoreUint32(&o.CHANNEL5.Reg, volatile.LoadUint32(&o.CHANNEL5.Reg)&^(0xc00)|value<<10)
}
func (o *EVSYS_Type) GetCHANNEL5_EDGSEL() uint32 {
	return (volatile.LoadUint32(&o.CHANNEL5.Reg) & 0xc00) >> 10
}
func (o *EVSYS_Type) SetCHANNEL5_RUNSTDBY(value uint32) {
	volatile.StoreUint32(&o.CHANNEL5.Reg, volatile.LoadUint32(&o.CHANNEL5.Reg)&^(0x4000)|value<<14)
}
func (o *EVSYS_Type) GetCHANNEL5_RUNSTDBY() uint32 {
	return (volatile.LoadUint32(&o.CHANNEL5.Reg) & 0x4000) >> 14
}
func (o *EVSYS_Type) SetCHANNEL5_ONDEMAND(value uint32) {
	volatile.StoreUint32(&o.CHANNEL5.Reg, volatile.LoadUint32(&o.CHANNEL5.Reg)&^(0x8000)|value<<15)
}
func (o *EVSYS_Type) GetCHANNEL5_ONDEMAND() uint32 {
	return (volatile.LoadUint32(&o.CHANNEL5.Reg) & 0x8000) >> 15
}

// EVSYS.CHANNEL6: Channel n
func (o *EVSYS_Type) SetCHANNEL6_EVGEN(value uint32) {
	volatile.StoreUint32(&o.CHANNEL6.Reg, volatile.LoadUint32(&o.CHANNEL6.Reg)&^(0x7f)|value)
}
func (o *EVSYS_Type) GetCHANNEL6_EVGEN() uint32 {
	return volatile.LoadUint32(&o.CHANNEL6.Reg) & 0x7f
}
func (o *EVSYS_Type) SetCHANNEL6_PATH(value uint32) {
	volatile.StoreUint32(&o.CHANNEL6.Reg, volatile.LoadUint32(&o.CHANNEL6.Reg)&^(0x300)|value<<8)
}
func (o *EVSYS_Type) GetCHANNEL6_PATH() uint32 {
	return (volatile.LoadUint32(&o.CHANNEL6.Reg) & 0x300) >> 8
}
func (o *EVSYS_Type) SetCHANNEL6_EDGSEL(value uint32) {
	volatile.StoreUint32(&o.CHANNEL6.Reg, volatile.LoadUint32(&o.CHANNEL6.Reg)&^(0xc00)|value<<10)
}
func (o *EVSYS_Type) GetCHANNEL6_EDGSEL() uint32 {
	return (volatile.LoadUint32(&o.CHANNEL6.Reg) & 0xc00) >> 10
}
func (o *EVSYS_Type) SetCHANNEL6_RUNSTDBY(value uint32) {
	volatile.StoreUint32(&o.CHANNEL6.Reg, volatile.LoadUint32(&o.CHANNEL6.Reg)&^(0x4000)|value<<14)
}
func (o *EVSYS_Type) GetCHANNEL6_RUNSTDBY() uint32 {
	return (volatile.LoadUint32(&o.CHANNEL6.Reg) & 0x4000) >> 14
}
func (o *EVSYS_Type) SetCHANNEL6_ONDEMAND(value uint32) {
	volatile.StoreUint32(&o.CHANNEL6.Reg, volatile.LoadUint32(&o.CHANNEL6.Reg)&^(0x8000)|value<<15)
}
func (o *EVSYS_Type) GetCHANNEL6_ONDEMAND() uint32 {
	return (volatile.LoadUint32(&o.CHANNEL6.Reg) & 0x8000) >> 15
}

// EVSYS.CHANNEL7: Channel n
func (o *EVSYS_Type) SetCHANNEL7_EVGEN(value uint32) {
	volatile.StoreUint32(&o.CHANNEL7.Reg, volatile.LoadUint32(&o.CHANNEL7.Reg)&^(0x7f)|value)
}
func (o *EVSYS_Type) GetCHANNEL7_EVGEN() uint32 {
	return volatile.LoadUint32(&o.CHANNEL7.Reg) & 0x7f
}
func (o *EVSYS_Type) SetCHANNEL7_PATH(value uint32) {
	volatile.StoreUint32(&o.CHANNEL7.Reg, volatile.LoadUint32(&o.CHANNEL7.Reg)&^(0x300)|value<<8)
}
func (o *EVSYS_Type) GetCHANNEL7_PATH() uint32 {
	return (volatile.LoadUint32(&o.CHANNEL7.Reg) & 0x300) >> 8
}
func (o *EVSYS_Type) SetCHANNEL7_EDGSEL(value uint32) {
	volatile.StoreUint32(&o.CHANNEL7.Reg, volatile.LoadUint32(&o.CHANNEL7.Reg)&^(0xc00)|value<<10)
}
func (o *EVSYS_Type) GetCHANNEL7_EDGSEL() uint32 {
	return (volatile.LoadUint32(&o.CHANNEL7.Reg) & 0xc00) >> 10
}
func (o *EVSYS_Type) SetCHANNEL7_RUNSTDBY(value uint32) {
	volatile.StoreUint32(&o.CHANNEL7.Reg, volatile.LoadUint32(&o.CHANNEL7.Reg)&^(0x4000)|value<<14)
}
func (o *EVSYS_Type) GetCHANNEL7_RUNSTDBY() uint32 {
	return (volatile.LoadUint32(&o.CHANNEL7.Reg) & 0x4000) >> 14
}
func (o *EVSYS_Type) SetCHANNEL7_ONDEMAND(value uint32) {
	volatile.StoreUint32(&o.CHANNEL7.Reg, volatile.LoadUint32(&o.CHANNEL7.Reg)&^(0x8000)|value<<15)
}
func (o *EVSYS_Type) GetCHANNEL7_ONDEMAND() uint32 {
	return (volatile.LoadUint32(&o.CHANNEL7.Reg) & 0x8000) >> 15
}

// EVSYS.USER0: User Multiplexer n
func (o *EVSYS_Type) SetUSER0_CHANNEL(value uint32) {
	volatile.StoreUint32(&o.USER0.Reg, volatile.LoadUint32(&o.USER0.Reg)&^(0xf)|value)
}
func (o *EVSYS_Type) GetUSER0_CHANNEL() uint32 {
	return volatile.LoadUint32(&o.USER0.Reg) & 0xf
}

// EVSYS.USER1: User Multiplexer n
func (o *EVSYS_Type) SetUSER1_CHANNEL(value uint32) {
	volatile.StoreUint32(&o.USER1.Reg, volatile.LoadUint32(&o.USER1.Reg)&^(0xf)|value)
}
func (o *EVSYS_Type) GetUSER1_CHANNEL() uint32 {
	return volatile.LoadUint32(&o.USER1.Reg) & 0xf
}

// EVSYS.USER2: User Multiplexer n
func (o *EVSYS_Type) SetUSER2_CHANNEL(value uint32) {
	volatile.StoreUint32(&o.USER2.Reg, volatile.LoadUint32(&o.USER2.Reg)&^(0xf)|value)
}
func (o *EVSYS_Type) GetUSER2_CHANNEL() uint32 {
	return volatile.LoadUint32(&o.USER2.Reg) & 0xf
}

// EVSYS.USER3: User Multiplexer n
func (o *EVSYS_Type) SetUSER3_CHANNEL(value uint32) {
	volatile.StoreUint32(&o.USER3.Reg, volatile.LoadUint32(&o.USER3.Reg)&^(0xf)|value)
}
func (o *EVSYS_Type) GetUSER3_CHANNEL() uint32 {
	return volatile.LoadUint32(&o.USER3.Reg) & 0xf
}

// EVSYS.USER4: User Multiplexer n
func (o *EVSYS_Type) SetUSER4_CHANNEL(value uint32) {
	volatile.StoreUint32(&o.USER4.Reg, volatile.LoadUint32(&o.USER4.Reg)&^(0xf)|value)
}
func (o *EVSYS_Type) GetUSER4_CHANNEL() uint32 {
	return volatile.LoadUint32(&o.USER4.Reg) & 0xf
}

// EVSYS.USER5: User Multiplexer n
func (o *EVSYS_Type) SetUSER5_CHANNEL(value uint32) {
	volatile.StoreUint32(&o.USER5.Reg, volatile.LoadUint32(&o.USER5.Reg)&^(0xf)|value)
}
func (o *EVSYS_Type) GetUSER5_CHANNEL() uint32 {
	return volatile.LoadUint32(&o.USER5.Reg) & 0xf
}

// EVSYS.USER6: User Multiplexer n
func (o *EVSYS_Type) SetUSER6_CHANNEL(value uint32) {
	volatile.StoreUint32(&o.USER6.Reg, volatile.LoadUint32(&o.USER6.Reg)&^(0xf)|value)
}
func (o *EVSYS_Type) GetUSER6_CHANNEL() uint32 {
	return volatile.LoadUint32(&o.USER6.Reg) & 0xf
}

// EVSYS.USER7: User Multiplexer n
func (o *EVSYS_Type) SetUSER7_CHANNEL(value uint32) {
	volatile.StoreUint32(&o.USER7.Reg, volatile.LoadUint32(&o.USER7.Reg)&^(0xf)|value)
}
func (o *EVSYS_Type) GetUSER7_CHANNEL() uint32 {
	return volatile.LoadUint32(&o.USER7.Reg) & 0xf
}

// EVSYS.USER8: User Multiplexer n
func (o *EVSYS_Type) SetUSER8_CHANNEL(value uint32) {
	volatile.StoreUint32(&o.USER8.Reg, volatile.LoadUint32(&o.USER8.Reg)&^(0xf)|value)
}
func (o *EVSYS_Type) GetUSER8_CHANNEL() uint32 {
	return volatile.LoadUint32(&o.USER8.Reg) & 0xf
}

// EVSYS.USER9: User Multiplexer n
func (o *EVSYS_Type) SetUSER9_CHANNEL(value uint32) {
	volatile.StoreUint32(&o.USER9.Reg, volatile.LoadUint32(&o.USER9.Reg)&^(0xf)|value)
}
func (o *EVSYS_Type) GetUSER9_CHANNEL() uint32 {
	return volatile.LoadUint32(&o.USER9.Reg) & 0xf
}

// EVSYS.USER10: User Multiplexer n
func (o *EVSYS_Type) SetUSER10_CHANNEL(value uint32) {
	volatile.StoreUint32(&o.USER10.Reg, volatile.LoadUint32(&o.USER10.Reg)&^(0xf)|value)
}
func (o *EVSYS_Type) GetUSER10_CHANNEL() uint32 {
	return volatile.LoadUint32(&o.USER10.Reg) & 0xf
}

// EVSYS.USER11: User Multiplexer n
func (o *EVSYS_Type) SetUSER11_CHANNEL(value uint32) {
	volatile.StoreUint32(&o.USER11.Reg, volatile.LoadUint32(&o.USER11.Reg)&^(0xf)|value)
}
func (o *EVSYS_Type) GetUSER11_CHANNEL() uint32 {
	return volatile.LoadUint32(&o.USER11.Reg) & 0xf
}

// EVSYS.USER12: User Multiplexer n
func (o *EVSYS_Type) SetUSER12_CHANNEL(value uint32) {
	volatile.StoreUint32(&o.USER12.Reg, volatile.LoadUint32(&o.USER12.Reg)&^(0xf)|value)
}
func (o *EVSYS_Type) GetUSER12_CHANNEL() uint32 {
	return volatile.LoadUint32(&o.USER12.Reg) & 0xf
}

// EVSYS.USER13: User Multiplexer n
func (o *EVSYS_Type) SetUSER13_CHANNEL(value uint32) {
	volatile.StoreUint32(&o.USER13.Reg, volatile.LoadUint32(&o.USER13.Reg)&^(0xf)|value)
}
func (o *EVSYS_Type) GetUSER13_CHANNEL() uint32 {
	return volatile.LoadUint32(&o.USER13.Reg) & 0xf
}

// EVSYS.USER14: User Multiplexer n
func (o *EVSYS_Type) SetUSER14_CHANNEL(value uint32) {
	volatile.StoreUint32(&o.USER14.Reg, volatile.LoadUint32(&o.USER14.Reg)&^(0xf)|value)
}
func (o *EVSYS_Type) GetUSER14_CHANNEL() uint32 {
	return volatile.LoadUint32(&o.USER14.Reg) & 0xf
}

// EVSYS.USER15: User Multiplexer n
func (o *EVSYS_Type) SetUSER15_CHANNEL(value uint32) {
	volatile.StoreUint32(&o.USER15.Reg, volatile.LoadUint32(&o.USER15.Reg)&^(0xf)|value)
}
func (o *EVSYS_Type) GetUSER15_CHANNEL() uint32 {
	return volatile.LoadUint32(&o.USER15.Reg) & 0xf
}

// EVSYS.USER16: User Multiplexer n
func (o *EVSYS_Type) SetUSER16_CHANNEL(value uint32) {
	volatile.StoreUint32(&o.USER16.Reg, volatile.LoadUint32(&o.USER16.Reg)&^(0xf)|value)
}
func (o *EVSYS_Type) GetUSER16_CHANNEL() uint32 {
	return volatile.LoadUint32(&o.USER16.Reg) & 0xf
}

// EVSYS.USER17: User Multiplexer n
func (o *EVSYS_Type) SetUSER17_CHANNEL(value uint32) {
	volatile.StoreUint32(&o.USER17.Reg, volatile.LoadUint32(&o.USER17.Reg)&^(0xf)|value)
}
func (o *EVSYS_Type) GetUSER17_CHANNEL() uint32 {
	return volatile.LoadUint32(&o.USER17.Reg) & 0xf
}

// EVSYS.USER18: User Multiplexer n
func (o *EVSYS_Type) SetUSER18_CHANNEL(value uint32) {
	volatile.StoreUint32(&o.USER18.Reg, volatile.LoadUint32(&o.USER18.Reg)&^(0xf)|value)
}
func (o *EVSYS_Type) GetUSER18_CHANNEL() uint32 {
	return volatile.LoadUint32(&o.USER18.Reg) & 0xf
}

// EVSYS.USER19: User Multiplexer n
func (o *EVSYS_Type) SetUSER19_CHANNEL(value uint32) {
	volatile.StoreUint32(&o.USER19.Reg, volatile.LoadUint32(&o.USER19.Reg)&^(0xf)|value)
}
func (o *EVSYS_Type) GetUSER19_CHANNEL() uint32 {
	return volatile.LoadUint32(&o.USER19.Reg) & 0xf
}

// EVSYS.USER20: User Multiplexer n
func (o *EVSYS_Type) SetUSER20_CHANNEL(value uint32) {
	volatile.StoreUint32(&o.USER20.Reg, volatile.LoadUint32(&o.USER20.Reg)&^(0xf)|value)
}
func (o *EVSYS_Type) GetUSER20_CHANNEL() uint32 {
	return volatile.LoadUint32(&o.USER20.Reg) & 0xf
}

// EVSYS.USER21: User Multiplexer n
func (o *EVSYS_Type) SetUSER21_CHANNEL(value uint32) {
	volatile.StoreUint32(&o.USER21.Reg, volatile.LoadUint32(&o.USER21.Reg)&^(0xf)|value)
}
func (o *EVSYS_Type) GetUSER21_CHANNEL() uint32 {
	return volatile.LoadUint32(&o.USER21.Reg) & 0xf
}

// EVSYS.USER22: User Multiplexer n
func (o *EVSYS_Type) SetUSER22_CHANNEL(value uint32) {
	volatile.StoreUint32(&o.USER22.Reg, volatile.LoadUint32(&o.USER22.Reg)&^(0xf)|value)
}
func (o *EVSYS_Type) GetUSER22_CHANNEL() uint32 {
	return volatile.LoadUint32(&o.USER22.Reg) & 0xf
}

// EVSYS.USER23: User Multiplexer n
func (o *EVSYS_Type) SetUSER23_CHANNEL(value uint32) {
	volatile.StoreUint32(&o.USER23.Reg, volatile.LoadUint32(&o.USER23.Reg)&^(0xf)|value)
}
func (o *EVSYS_Type) GetUSER23_CHANNEL() uint32 {
	return volatile.LoadUint32(&o.USER23.Reg) & 0xf
}

// EVSYS.USER24: User Multiplexer n
func (o *EVSYS_Type) SetUSER24_CHANNEL(value uint32) {
	volatile.StoreUint32(&o.USER24.Reg, volatile.LoadUint32(&o.USER24.Reg)&^(0xf)|value)
}
func (o *EVSYS_Type) GetUSER24_CHANNEL() uint32 {
	return volatile.LoadUint32(&o.USER24.Reg) & 0xf
}

// EVSYS.USER25: User Multiplexer n
func (o *EVSYS_Type) SetUSER25_CHANNEL(value uint32) {
	volatile.StoreUint32(&o.USER25.Reg, volatile.LoadUint32(&o.USER25.Reg)&^(0xf)|value)
}
func (o *EVSYS_Type) GetUSER25_CHANNEL() uint32 {
	return volatile.LoadUint32(&o.USER25.Reg) & 0xf
}

// EVSYS.USER26: User Multiplexer n
func (o *EVSYS_Type) SetUSER26_CHANNEL(value uint32) {
	volatile.StoreUint32(&o.USER26.Reg, volatile.LoadUint32(&o.USER26.Reg)&^(0xf)|value)
}
func (o *EVSYS_Type) GetUSER26_CHANNEL() uint32 {
	return volatile.LoadUint32(&o.USER26.Reg) & 0xf
}

// EVSYS.USER27: User Multiplexer n
func (o *EVSYS_Type) SetUSER27_CHANNEL(value uint32) {
	volatile.StoreUint32(&o.USER27.Reg, volatile.LoadUint32(&o.USER27.Reg)&^(0xf)|value)
}
func (o *EVSYS_Type) GetUSER27_CHANNEL() uint32 {
	return volatile.LoadUint32(&o.USER27.Reg) & 0xf
}

// EVSYS.USER28: User Multiplexer n
func (o *EVSYS_Type) SetUSER28_CHANNEL(value uint32) {
	volatile.StoreUint32(&o.USER28.Reg, volatile.LoadUint32(&o.USER28.Reg)&^(0xf)|value)
}
func (o *EVSYS_Type) GetUSER28_CHANNEL() uint32 {
	return volatile.LoadUint32(&o.USER28.Reg) & 0xf
}

// EVSYS.USER29: User Multiplexer n
func (o *EVSYS_Type) SetUSER29_CHANNEL(value uint32) {
	volatile.StoreUint32(&o.USER29.Reg, volatile.LoadUint32(&o.USER29.Reg)&^(0xf)|value)
}
func (o *EVSYS_Type) GetUSER29_CHANNEL() uint32 {
	return volatile.LoadUint32(&o.USER29.Reg) & 0xf
}

// EVSYS.USER30: User Multiplexer n
func (o *EVSYS_Type) SetUSER30_CHANNEL(value uint32) {
	volatile.StoreUint32(&o.USER30.Reg, volatile.LoadUint32(&o.USER30.Reg)&^(0xf)|value)
}
func (o *EVSYS_Type) GetUSER30_CHANNEL() uint32 {
	return volatile.LoadUint32(&o.USER30.Reg) & 0xf
}

// Frequency Meter
type FREQM_Type struct {
	CTRLA    volatile.Register8  // 0x0
	CTRLB    volatile.Register8  // 0x1
	CFGA     volatile.Register16 // 0x2
	_        [4]byte
	INTENCLR volatile.Register8  // 0x8
	INTENSET volatile.Register8  // 0x9
	INTFLAG  volatile.Register8  // 0xA
	STATUS   volatile.Register8  // 0xB
	SYNCBUSY volatile.Register32 // 0xC
	VALUE    volatile.Register32 // 0x10
}

// FREQM.CTRLA: Control A Register
func (o *FREQM_Type) SetCTRLA_SWRST(value uint8) {
	volatile.StoreUint8(&o.CTRLA.Reg, volatile.LoadUint8(&o.CTRLA.Reg)&^(0x1)|value)
}
func (o *FREQM_Type) GetCTRLA_SWRST() uint8 {
	return volatile.LoadUint8(&o.CTRLA.Reg) & 0x1
}
func (o *FREQM_Type) SetCTRLA_ENABLE(value uint8) {
	volatile.StoreUint8(&o.CTRLA.Reg, volatile.LoadUint8(&o.CTRLA.Reg)&^(0x2)|value<<1)
}
func (o *FREQM_Type) GetCTRLA_ENABLE() uint8 {
	return (volatile.LoadUint8(&o.CTRLA.Reg) & 0x2) >> 1
}

// FREQM.CTRLB: Control B Register
func (o *FREQM_Type) SetCTRLB_START(value uint8) {
	volatile.StoreUint8(&o.CTRLB.Reg, volatile.LoadUint8(&o.CTRLB.Reg)&^(0x1)|value)
}
func (o *FREQM_Type) GetCTRLB_START() uint8 {
	return volatile.LoadUint8(&o.CTRLB.Reg) & 0x1
}

// FREQM.CFGA: Config A register
func (o *FREQM_Type) SetCFGA_REFNUM(value uint16) {
	volatile.StoreUint16(&o.CFGA.Reg, volatile.LoadUint16(&o.CFGA.Reg)&^(0xff)|value)
}
func (o *FREQM_Type) GetCFGA_REFNUM() uint16 {
	return volatile.LoadUint16(&o.CFGA.Reg) & 0xff
}

// FREQM.INTENCLR: Interrupt Enable Clear Register
func (o *FREQM_Type) SetINTENCLR_DONE(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *FREQM_Type) GetINTENCLR_DONE() uint8 {
	return volatile.LoadUint8(&o.INTENCLR.Reg) & 0x1
}

// FREQM.INTENSET: Interrupt Enable Set Register
func (o *FREQM_Type) SetINTENSET_DONE(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *FREQM_Type) GetINTENSET_DONE() uint8 {
	return volatile.LoadUint8(&o.INTENSET.Reg) & 0x1
}

// FREQM.INTFLAG: Interrupt Flag Register
func (o *FREQM_Type) SetINTFLAG_DONE(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x1)|value)
}
func (o *FREQM_Type) GetINTFLAG_DONE() uint8 {
	return volatile.LoadUint8(&o.INTFLAG.Reg) & 0x1
}

// FREQM.STATUS: Status Register
func (o *FREQM_Type) SetSTATUS_BUSY(value uint8) {
	volatile.StoreUint8(&o.STATUS.Reg, volatile.LoadUint8(&o.STATUS.Reg)&^(0x1)|value)
}
func (o *FREQM_Type) GetSTATUS_BUSY() uint8 {
	return volatile.LoadUint8(&o.STATUS.Reg) & 0x1
}
func (o *FREQM_Type) SetSTATUS_OVF(value uint8) {
	volatile.StoreUint8(&o.STATUS.Reg, volatile.LoadUint8(&o.STATUS.Reg)&^(0x2)|value<<1)
}
func (o *FREQM_Type) GetSTATUS_OVF() uint8 {
	return (volatile.LoadUint8(&o.STATUS.Reg) & 0x2) >> 1
}

// FREQM.SYNCBUSY: Synchronization Busy Register
func (o *FREQM_Type) SetSYNCBUSY_SWRST(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x1)|value)
}
func (o *FREQM_Type) GetSYNCBUSY_SWRST() uint32 {
	return volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x1
}
func (o *FREQM_Type) SetSYNCBUSY_ENABLE(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x2)|value<<1)
}
func (o *FREQM_Type) GetSYNCBUSY_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x2) >> 1
}

// FREQM.VALUE: Count Value Register
func (o *FREQM_Type) SetVALUE(value uint32) {
	volatile.StoreUint32(&o.VALUE.Reg, volatile.LoadUint32(&o.VALUE.Reg)&^(0xffffff)|value)
}
func (o *FREQM_Type) GetVALUE() uint32 {
	return volatile.LoadUint32(&o.VALUE.Reg) & 0xffffff
}

// Generic Clock Generator
type GCLK_Type struct {
	CTRLA     volatile.Register8 // 0x0
	_         [3]byte
	SYNCBUSY  volatile.Register32 // 0x4
	_         [24]byte
	GENCTRL0  volatile.Register32 // 0x20
	GENCTRL1  volatile.Register32 // 0x24
	GENCTRL2  volatile.Register32 // 0x28
	GENCTRL3  volatile.Register32 // 0x2C
	GENCTRL4  volatile.Register32 // 0x30
	_         [76]byte
	PCHCTRL0  volatile.Register32 // 0x80
	PCHCTRL1  volatile.Register32 // 0x84
	PCHCTRL2  volatile.Register32 // 0x88
	PCHCTRL3  volatile.Register32 // 0x8C
	PCHCTRL4  volatile.Register32 // 0x90
	PCHCTRL5  volatile.Register32 // 0x94
	PCHCTRL6  volatile.Register32 // 0x98
	PCHCTRL7  volatile.Register32 // 0x9C
	PCHCTRL8  volatile.Register32 // 0xA0
	PCHCTRL9  volatile.Register32 // 0xA4
	PCHCTRL10 volatile.Register32 // 0xA8
	PCHCTRL11 volatile.Register32 // 0xAC
	PCHCTRL12 volatile.Register32 // 0xB0
	PCHCTRL13 volatile.Register32 // 0xB4
	PCHCTRL14 volatile.Register32 // 0xB8
	PCHCTRL15 volatile.Register32 // 0xBC
	PCHCTRL16 volatile.Register32 // 0xC0
	PCHCTRL17 volatile.Register32 // 0xC4
	PCHCTRL18 volatile.Register32 // 0xC8
	PCHCTRL19 volatile.Register32 // 0xCC
	PCHCTRL20 volatile.Register32 // 0xD0
	PCHCTRL21 volatile.Register32 // 0xD4
	PCHCTRL22 volatile.Register32 // 0xD8
	PCHCTRL23 volatile.Register32 // 0xDC
	PCHCTRL24 volatile.Register32 // 0xE0
	PCHCTRL25 volatile.Register32 // 0xE4
	PCHCTRL26 volatile.Register32 // 0xE8
	PCHCTRL27 volatile.Register32 // 0xEC
	PCHCTRL28 volatile.Register32 // 0xF0
	PCHCTRL29 volatile.Register32 // 0xF4
}

// GCLK.CTRLA: Control
func (o *GCLK_Type) SetCTRLA_SWRST(value uint8) {
	volatile.StoreUint8(&o.CTRLA.Reg, volatile.LoadUint8(&o.CTRLA.Reg)&^(0x1)|value)
}
func (o *GCLK_Type) GetCTRLA_SWRST() uint8 {
	return volatile.LoadUint8(&o.CTRLA.Reg) & 0x1
}

// GCLK.SYNCBUSY: Synchronization Busy
func (o *GCLK_Type) SetSYNCBUSY_SWRST(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x1)|value)
}
func (o *GCLK_Type) GetSYNCBUSY_SWRST() uint32 {
	return volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x1
}
func (o *GCLK_Type) SetSYNCBUSY_GENCTRL0(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x4)|value<<2)
}
func (o *GCLK_Type) GetSYNCBUSY_GENCTRL0() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x4) >> 2
}
func (o *GCLK_Type) SetSYNCBUSY_GENCTRL1(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x8)|value<<3)
}
func (o *GCLK_Type) GetSYNCBUSY_GENCTRL1() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x8) >> 3
}
func (o *GCLK_Type) SetSYNCBUSY_GENCTRL2(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x10)|value<<4)
}
func (o *GCLK_Type) GetSYNCBUSY_GENCTRL2() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x10) >> 4
}
func (o *GCLK_Type) SetSYNCBUSY_GENCTRL3(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x20)|value<<5)
}
func (o *GCLK_Type) GetSYNCBUSY_GENCTRL3() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x20) >> 5
}
func (o *GCLK_Type) SetSYNCBUSY_GENCTRL4(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x40)|value<<6)
}
func (o *GCLK_Type) GetSYNCBUSY_GENCTRL4() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x40) >> 6
}

// GCLK.GENCTRL0: Generic Clock Generator Control
func (o *GCLK_Type) SetGENCTRL0_SRC(value uint32) {
	volatile.StoreUint32(&o.GENCTRL0.Reg, volatile.LoadUint32(&o.GENCTRL0.Reg)&^(0x7)|value)
}
func (o *GCLK_Type) GetGENCTRL0_SRC() uint32 {
	return volatile.LoadUint32(&o.GENCTRL0.Reg) & 0x7
}
func (o *GCLK_Type) SetGENCTRL0_GENEN(value uint32) {
	volatile.StoreUint32(&o.GENCTRL0.Reg, volatile.LoadUint32(&o.GENCTRL0.Reg)&^(0x100)|value<<8)
}
func (o *GCLK_Type) GetGENCTRL0_GENEN() uint32 {
	return (volatile.LoadUint32(&o.GENCTRL0.Reg) & 0x100) >> 8
}
func (o *GCLK_Type) SetGENCTRL0_IDC(value uint32) {
	volatile.StoreUint32(&o.GENCTRL0.Reg, volatile.LoadUint32(&o.GENCTRL0.Reg)&^(0x200)|value<<9)
}
func (o *GCLK_Type) GetGENCTRL0_IDC() uint32 {
	return (volatile.LoadUint32(&o.GENCTRL0.Reg) & 0x200) >> 9
}
func (o *GCLK_Type) SetGENCTRL0_OOV(value uint32) {
	volatile.StoreUint32(&o.GENCTRL0.Reg, volatile.LoadUint32(&o.GENCTRL0.Reg)&^(0x400)|value<<10)
}
func (o *GCLK_Type) GetGENCTRL0_OOV() uint32 {
	return (volatile.LoadUint32(&o.GENCTRL0.Reg) & 0x400) >> 10
}
func (o *GCLK_Type) SetGENCTRL0_OE(value uint32) {
	volatile.StoreUint32(&o.GENCTRL0.Reg, volatile.LoadUint32(&o.GENCTRL0.Reg)&^(0x800)|value<<11)
}
func (o *GCLK_Type) GetGENCTRL0_OE() uint32 {
	return (volatile.LoadUint32(&o.GENCTRL0.Reg) & 0x800) >> 11
}
func (o *GCLK_Type) SetGENCTRL0_DIVSEL(value uint32) {
	volatile.StoreUint32(&o.GENCTRL0.Reg, volatile.LoadUint32(&o.GENCTRL0.Reg)&^(0x1000)|value<<12)
}
func (o *GCLK_Type) GetGENCTRL0_DIVSEL() uint32 {
	return (volatile.LoadUint32(&o.GENCTRL0.Reg) & 0x1000) >> 12
}
func (o *GCLK_Type) SetGENCTRL0_RUNSTDBY(value uint32) {
	volatile.StoreUint32(&o.GENCTRL0.Reg, volatile.LoadUint32(&o.GENCTRL0.Reg)&^(0x2000)|value<<13)
}
func (o *GCLK_Type) GetGENCTRL0_RUNSTDBY() uint32 {
	return (volatile.LoadUint32(&o.GENCTRL0.Reg) & 0x2000) >> 13
}
func (o *GCLK_Type) SetGENCTRL0_DIV(value uint32) {
	volatile.StoreUint32(&o.GENCTRL0.Reg, volatile.LoadUint32(&o.GENCTRL0.Reg)&^(0xffff0000)|value<<16)
}
func (o *GCLK_Type) GetGENCTRL0_DIV() uint32 {
	return (volatile.LoadUint32(&o.GENCTRL0.Reg) & 0xffff0000) >> 16
}

// GCLK.GENCTRL1: Generic Clock Generator Control
func (o *GCLK_Type) SetGENCTRL1_SRC(value uint32) {
	volatile.StoreUint32(&o.GENCTRL1.Reg, volatile.LoadUint32(&o.GENCTRL1.Reg)&^(0x7)|value)
}
func (o *GCLK_Type) GetGENCTRL1_SRC() uint32 {
	return volatile.LoadUint32(&o.GENCTRL1.Reg) & 0x7
}
func (o *GCLK_Type) SetGENCTRL1_GENEN(value uint32) {
	volatile.StoreUint32(&o.GENCTRL1.Reg, volatile.LoadUint32(&o.GENCTRL1.Reg)&^(0x100)|value<<8)
}
func (o *GCLK_Type) GetGENCTRL1_GENEN() uint32 {
	return (volatile.LoadUint32(&o.GENCTRL1.Reg) & 0x100) >> 8
}
func (o *GCLK_Type) SetGENCTRL1_IDC(value uint32) {
	volatile.StoreUint32(&o.GENCTRL1.Reg, volatile.LoadUint32(&o.GENCTRL1.Reg)&^(0x200)|value<<9)
}
func (o *GCLK_Type) GetGENCTRL1_IDC() uint32 {
	return (volatile.LoadUint32(&o.GENCTRL1.Reg) & 0x200) >> 9
}
func (o *GCLK_Type) SetGENCTRL1_OOV(value uint32) {
	volatile.StoreUint32(&o.GENCTRL1.Reg, volatile.LoadUint32(&o.GENCTRL1.Reg)&^(0x400)|value<<10)
}
func (o *GCLK_Type) GetGENCTRL1_OOV() uint32 {
	return (volatile.LoadUint32(&o.GENCTRL1.Reg) & 0x400) >> 10
}
func (o *GCLK_Type) SetGENCTRL1_OE(value uint32) {
	volatile.StoreUint32(&o.GENCTRL1.Reg, volatile.LoadUint32(&o.GENCTRL1.Reg)&^(0x800)|value<<11)
}
func (o *GCLK_Type) GetGENCTRL1_OE() uint32 {
	return (volatile.LoadUint32(&o.GENCTRL1.Reg) & 0x800) >> 11
}
func (o *GCLK_Type) SetGENCTRL1_DIVSEL(value uint32) {
	volatile.StoreUint32(&o.GENCTRL1.Reg, volatile.LoadUint32(&o.GENCTRL1.Reg)&^(0x1000)|value<<12)
}
func (o *GCLK_Type) GetGENCTRL1_DIVSEL() uint32 {
	return (volatile.LoadUint32(&o.GENCTRL1.Reg) & 0x1000) >> 12
}
func (o *GCLK_Type) SetGENCTRL1_RUNSTDBY(value uint32) {
	volatile.StoreUint32(&o.GENCTRL1.Reg, volatile.LoadUint32(&o.GENCTRL1.Reg)&^(0x2000)|value<<13)
}
func (o *GCLK_Type) GetGENCTRL1_RUNSTDBY() uint32 {
	return (volatile.LoadUint32(&o.GENCTRL1.Reg) & 0x2000) >> 13
}
func (o *GCLK_Type) SetGENCTRL1_DIV(value uint32) {
	volatile.StoreUint32(&o.GENCTRL1.Reg, volatile.LoadUint32(&o.GENCTRL1.Reg)&^(0xffff0000)|value<<16)
}
func (o *GCLK_Type) GetGENCTRL1_DIV() uint32 {
	return (volatile.LoadUint32(&o.GENCTRL1.Reg) & 0xffff0000) >> 16
}

// GCLK.GENCTRL2: Generic Clock Generator Control
func (o *GCLK_Type) SetGENCTRL2_SRC(value uint32) {
	volatile.StoreUint32(&o.GENCTRL2.Reg, volatile.LoadUint32(&o.GENCTRL2.Reg)&^(0x7)|value)
}
func (o *GCLK_Type) GetGENCTRL2_SRC() uint32 {
	return volatile.LoadUint32(&o.GENCTRL2.Reg) & 0x7
}
func (o *GCLK_Type) SetGENCTRL2_GENEN(value uint32) {
	volatile.StoreUint32(&o.GENCTRL2.Reg, volatile.LoadUint32(&o.GENCTRL2.Reg)&^(0x100)|value<<8)
}
func (o *GCLK_Type) GetGENCTRL2_GENEN() uint32 {
	return (volatile.LoadUint32(&o.GENCTRL2.Reg) & 0x100) >> 8
}
func (o *GCLK_Type) SetGENCTRL2_IDC(value uint32) {
	volatile.StoreUint32(&o.GENCTRL2.Reg, volatile.LoadUint32(&o.GENCTRL2.Reg)&^(0x200)|value<<9)
}
func (o *GCLK_Type) GetGENCTRL2_IDC() uint32 {
	return (volatile.LoadUint32(&o.GENCTRL2.Reg) & 0x200) >> 9
}
func (o *GCLK_Type) SetGENCTRL2_OOV(value uint32) {
	volatile.StoreUint32(&o.GENCTRL2.Reg, volatile.LoadUint32(&o.GENCTRL2.Reg)&^(0x400)|value<<10)
}
func (o *GCLK_Type) GetGENCTRL2_OOV() uint32 {
	return (volatile.LoadUint32(&o.GENCTRL2.Reg) & 0x400) >> 10
}
func (o *GCLK_Type) SetGENCTRL2_OE(value uint32) {
	volatile.StoreUint32(&o.GENCTRL2.Reg, volatile.LoadUint32(&o.GENCTRL2.Reg)&^(0x800)|value<<11)
}
func (o *GCLK_Type) GetGENCTRL2_OE() uint32 {
	return (volatile.LoadUint32(&o.GENCTRL2.Reg) & 0x800) >> 11
}
func (o *GCLK_Type) SetGENCTRL2_DIVSEL(value uint32) {
	volatile.StoreUint32(&o.GENCTRL2.Reg, volatile.LoadUint32(&o.GENCTRL2.Reg)&^(0x1000)|value<<12)
}
func (o *GCLK_Type) GetGENCTRL2_DIVSEL() uint32 {
	return (volatile.LoadUint32(&o.GENCTRL2.Reg) & 0x1000) >> 12
}
func (o *GCLK_Type) SetGENCTRL2_RUNSTDBY(value uint32) {
	volatile.StoreUint32(&o.GENCTRL2.Reg, volatile.LoadUint32(&o.GENCTRL2.Reg)&^(0x2000)|value<<13)
}
func (o *GCLK_Type) GetGENCTRL2_RUNSTDBY() uint32 {
	return (volatile.LoadUint32(&o.GENCTRL2.Reg) & 0x2000) >> 13
}
func (o *GCLK_Type) SetGENCTRL2_DIV(value uint32) {
	volatile.StoreUint32(&o.GENCTRL2.Reg, volatile.LoadUint32(&o.GENCTRL2.Reg)&^(0xffff0000)|value<<16)
}
func (o *GCLK_Type) GetGENCTRL2_DIV() uint32 {
	return (volatile.LoadUint32(&o.GENCTRL2.Reg) & 0xffff0000) >> 16
}

// GCLK.GENCTRL3: Generic Clock Generator Control
func (o *GCLK_Type) SetGENCTRL3_SRC(value uint32) {
	volatile.StoreUint32(&o.GENCTRL3.Reg, volatile.LoadUint32(&o.GENCTRL3.Reg)&^(0x7)|value)
}
func (o *GCLK_Type) GetGENCTRL3_SRC() uint32 {
	return volatile.LoadUint32(&o.GENCTRL3.Reg) & 0x7
}
func (o *GCLK_Type) SetGENCTRL3_GENEN(value uint32) {
	volatile.StoreUint32(&o.GENCTRL3.Reg, volatile.LoadUint32(&o.GENCTRL3.Reg)&^(0x100)|value<<8)
}
func (o *GCLK_Type) GetGENCTRL3_GENEN() uint32 {
	return (volatile.LoadUint32(&o.GENCTRL3.Reg) & 0x100) >> 8
}
func (o *GCLK_Type) SetGENCTRL3_IDC(value uint32) {
	volatile.StoreUint32(&o.GENCTRL3.Reg, volatile.LoadUint32(&o.GENCTRL3.Reg)&^(0x200)|value<<9)
}
func (o *GCLK_Type) GetGENCTRL3_IDC() uint32 {
	return (volatile.LoadUint32(&o.GENCTRL3.Reg) & 0x200) >> 9
}
func (o *GCLK_Type) SetGENCTRL3_OOV(value uint32) {
	volatile.StoreUint32(&o.GENCTRL3.Reg, volatile.LoadUint32(&o.GENCTRL3.Reg)&^(0x400)|value<<10)
}
func (o *GCLK_Type) GetGENCTRL3_OOV() uint32 {
	return (volatile.LoadUint32(&o.GENCTRL3.Reg) & 0x400) >> 10
}
func (o *GCLK_Type) SetGENCTRL3_OE(value uint32) {
	volatile.StoreUint32(&o.GENCTRL3.Reg, volatile.LoadUint32(&o.GENCTRL3.Reg)&^(0x800)|value<<11)
}
func (o *GCLK_Type) GetGENCTRL3_OE() uint32 {
	return (volatile.LoadUint32(&o.GENCTRL3.Reg) & 0x800) >> 11
}
func (o *GCLK_Type) SetGENCTRL3_DIVSEL(value uint32) {
	volatile.StoreUint32(&o.GENCTRL3.Reg, volatile.LoadUint32(&o.GENCTRL3.Reg)&^(0x1000)|value<<12)
}
func (o *GCLK_Type) GetGENCTRL3_DIVSEL() uint32 {
	return (volatile.LoadUint32(&o.GENCTRL3.Reg) & 0x1000) >> 12
}
func (o *GCLK_Type) SetGENCTRL3_RUNSTDBY(value uint32) {
	volatile.StoreUint32(&o.GENCTRL3.Reg, volatile.LoadUint32(&o.GENCTRL3.Reg)&^(0x2000)|value<<13)
}
func (o *GCLK_Type) GetGENCTRL3_RUNSTDBY() uint32 {
	return (volatile.LoadUint32(&o.GENCTRL3.Reg) & 0x2000) >> 13
}
func (o *GCLK_Type) SetGENCTRL3_DIV(value uint32) {
	volatile.StoreUint32(&o.GENCTRL3.Reg, volatile.LoadUint32(&o.GENCTRL3.Reg)&^(0xffff0000)|value<<16)
}
func (o *GCLK_Type) GetGENCTRL3_DIV() uint32 {
	return (volatile.LoadUint32(&o.GENCTRL3.Reg) & 0xffff0000) >> 16
}

// GCLK.GENCTRL4: Generic Clock Generator Control
func (o *GCLK_Type) SetGENCTRL4_SRC(value uint32) {
	volatile.StoreUint32(&o.GENCTRL4.Reg, volatile.LoadUint32(&o.GENCTRL4.Reg)&^(0x7)|value)
}
func (o *GCLK_Type) GetGENCTRL4_SRC() uint32 {
	return volatile.LoadUint32(&o.GENCTRL4.Reg) & 0x7
}
func (o *GCLK_Type) SetGENCTRL4_GENEN(value uint32) {
	volatile.StoreUint32(&o.GENCTRL4.Reg, volatile.LoadUint32(&o.GENCTRL4.Reg)&^(0x100)|value<<8)
}
func (o *GCLK_Type) GetGENCTRL4_GENEN() uint32 {
	return (volatile.LoadUint32(&o.GENCTRL4.Reg) & 0x100) >> 8
}
func (o *GCLK_Type) SetGENCTRL4_IDC(value uint32) {
	volatile.StoreUint32(&o.GENCTRL4.Reg, volatile.LoadUint32(&o.GENCTRL4.Reg)&^(0x200)|value<<9)
}
func (o *GCLK_Type) GetGENCTRL4_IDC() uint32 {
	return (volatile.LoadUint32(&o.GENCTRL4.Reg) & 0x200) >> 9
}
func (o *GCLK_Type) SetGENCTRL4_OOV(value uint32) {
	volatile.StoreUint32(&o.GENCTRL4.Reg, volatile.LoadUint32(&o.GENCTRL4.Reg)&^(0x400)|value<<10)
}
func (o *GCLK_Type) GetGENCTRL4_OOV() uint32 {
	return (volatile.LoadUint32(&o.GENCTRL4.Reg) & 0x400) >> 10
}
func (o *GCLK_Type) SetGENCTRL4_OE(value uint32) {
	volatile.StoreUint32(&o.GENCTRL4.Reg, volatile.LoadUint32(&o.GENCTRL4.Reg)&^(0x800)|value<<11)
}
func (o *GCLK_Type) GetGENCTRL4_OE() uint32 {
	return (volatile.LoadUint32(&o.GENCTRL4.Reg) & 0x800) >> 11
}
func (o *GCLK_Type) SetGENCTRL4_DIVSEL(value uint32) {
	volatile.StoreUint32(&o.GENCTRL4.Reg, volatile.LoadUint32(&o.GENCTRL4.Reg)&^(0x1000)|value<<12)
}
func (o *GCLK_Type) GetGENCTRL4_DIVSEL() uint32 {
	return (volatile.LoadUint32(&o.GENCTRL4.Reg) & 0x1000) >> 12
}
func (o *GCLK_Type) SetGENCTRL4_RUNSTDBY(value uint32) {
	volatile.StoreUint32(&o.GENCTRL4.Reg, volatile.LoadUint32(&o.GENCTRL4.Reg)&^(0x2000)|value<<13)
}
func (o *GCLK_Type) GetGENCTRL4_RUNSTDBY() uint32 {
	return (volatile.LoadUint32(&o.GENCTRL4.Reg) & 0x2000) >> 13
}
func (o *GCLK_Type) SetGENCTRL4_DIV(value uint32) {
	volatile.StoreUint32(&o.GENCTRL4.Reg, volatile.LoadUint32(&o.GENCTRL4.Reg)&^(0xffff0000)|value<<16)
}
func (o *GCLK_Type) GetGENCTRL4_DIV() uint32 {
	return (volatile.LoadUint32(&o.GENCTRL4.Reg) & 0xffff0000) >> 16
}

// GCLK.PCHCTRL0: Peripheral Clock Control
func (o *GCLK_Type) SetPCHCTRL0_GEN(value uint32) {
	volatile.StoreUint32(&o.PCHCTRL0.Reg, volatile.LoadUint32(&o.PCHCTRL0.Reg)&^(0x7)|value)
}
func (o *GCLK_Type) GetPCHCTRL0_GEN() uint32 {
	return volatile.LoadUint32(&o.PCHCTRL0.Reg) & 0x7
}
func (o *GCLK_Type) SetPCHCTRL0_CHEN(value uint32) {
	volatile.StoreUint32(&o.PCHCTRL0.Reg, volatile.LoadUint32(&o.PCHCTRL0.Reg)&^(0x40)|value<<6)
}
func (o *GCLK_Type) GetPCHCTRL0_CHEN() uint32 {
	return (volatile.LoadUint32(&o.PCHCTRL0.Reg) & 0x40) >> 6
}
func (o *GCLK_Type) SetPCHCTRL0_WRTLOCK(value uint32) {
	volatile.StoreUint32(&o.PCHCTRL0.Reg, volatile.LoadUint32(&o.PCHCTRL0.Reg)&^(0x80)|value<<7)
}
func (o *GCLK_Type) GetPCHCTRL0_WRTLOCK() uint32 {
	return (volatile.LoadUint32(&o.PCHCTRL0.Reg) & 0x80) >> 7
}

// GCLK.PCHCTRL1: Peripheral Clock Control
func (o *GCLK_Type) SetPCHCTRL1_GEN(value uint32) {
	volatile.StoreUint32(&o.PCHCTRL1.Reg, volatile.LoadUint32(&o.PCHCTRL1.Reg)&^(0x7)|value)
}
func (o *GCLK_Type) GetPCHCTRL1_GEN() uint32 {
	return volatile.LoadUint32(&o.PCHCTRL1.Reg) & 0x7
}
func (o *GCLK_Type) SetPCHCTRL1_CHEN(value uint32) {
	volatile.StoreUint32(&o.PCHCTRL1.Reg, volatile.LoadUint32(&o.PCHCTRL1.Reg)&^(0x40)|value<<6)
}
func (o *GCLK_Type) GetPCHCTRL1_CHEN() uint32 {
	return (volatile.LoadUint32(&o.PCHCTRL1.Reg) & 0x40) >> 6
}
func (o *GCLK_Type) SetPCHCTRL1_WRTLOCK(value uint32) {
	volatile.StoreUint32(&o.PCHCTRL1.Reg, volatile.LoadUint32(&o.PCHCTRL1.Reg)&^(0x80)|value<<7)
}
func (o *GCLK_Type) GetPCHCTRL1_WRTLOCK() uint32 {
	return (volatile.LoadUint32(&o.PCHCTRL1.Reg) & 0x80) >> 7
}

// GCLK.PCHCTRL2: Peripheral Clock Control
func (o *GCLK_Type) SetPCHCTRL2_GEN(value uint32) {
	volatile.StoreUint32(&o.PCHCTRL2.Reg, volatile.LoadUint32(&o.PCHCTRL2.Reg)&^(0x7)|value)
}
func (o *GCLK_Type) GetPCHCTRL2_GEN() uint32 {
	return volatile.LoadUint32(&o.PCHCTRL2.Reg) & 0x7
}
func (o *GCLK_Type) SetPCHCTRL2_CHEN(value uint32) {
	volatile.StoreUint32(&o.PCHCTRL2.Reg, volatile.LoadUint32(&o.PCHCTRL2.Reg)&^(0x40)|value<<6)
}
func (o *GCLK_Type) GetPCHCTRL2_CHEN() uint32 {
	return (volatile.LoadUint32(&o.PCHCTRL2.Reg) & 0x40) >> 6
}
func (o *GCLK_Type) SetPCHCTRL2_WRTLOCK(value uint32) {
	volatile.StoreUint32(&o.PCHCTRL2.Reg, volatile.LoadUint32(&o.PCHCTRL2.Reg)&^(0x80)|value<<7)
}
func (o *GCLK_Type) GetPCHCTRL2_WRTLOCK() uint32 {
	return (volatile.LoadUint32(&o.PCHCTRL2.Reg) & 0x80) >> 7
}

// GCLK.PCHCTRL3: Peripheral Clock Control
func (o *GCLK_Type) SetPCHCTRL3_GEN(value uint32) {
	volatile.StoreUint32(&o.PCHCTRL3.Reg, volatile.LoadUint32(&o.PCHCTRL3.Reg)&^(0x7)|value)
}
func (o *GCLK_Type) GetPCHCTRL3_GEN() uint32 {
	return volatile.LoadUint32(&o.PCHCTRL3.Reg) & 0x7
}
func (o *GCLK_Type) SetPCHCTRL3_CHEN(value uint32) {
	volatile.StoreUint32(&o.PCHCTRL3.Reg, volatile.LoadUint32(&o.PCHCTRL3.Reg)&^(0x40)|value<<6)
}
func (o *GCLK_Type) GetPCHCTRL3_CHEN() uint32 {
	return (volatile.LoadUint32(&o.PCHCTRL3.Reg) & 0x40) >> 6
}
func (o *GCLK_Type) SetPCHCTRL3_WRTLOCK(value uint32) {
	volatile.StoreUint32(&o.PCHCTRL3.Reg, volatile.LoadUint32(&o.PCHCTRL3.Reg)&^(0x80)|value<<7)
}
func (o *GCLK_Type) GetPCHCTRL3_WRTLOCK() uint32 {
	return (volatile.LoadUint32(&o.PCHCTRL3.Reg) & 0x80) >> 7
}

// GCLK.PCHCTRL4: Peripheral Clock Control
func (o *GCLK_Type) SetPCHCTRL4_GEN(value uint32) {
	volatile.StoreUint32(&o.PCHCTRL4.Reg, volatile.LoadUint32(&o.PCHCTRL4.Reg)&^(0x7)|value)
}
func (o *GCLK_Type) GetPCHCTRL4_GEN() uint32 {
	return volatile.LoadUint32(&o.PCHCTRL4.Reg) & 0x7
}
func (o *GCLK_Type) SetPCHCTRL4_CHEN(value uint32) {
	volatile.StoreUint32(&o.PCHCTRL4.Reg, volatile.LoadUint32(&o.PCHCTRL4.Reg)&^(0x40)|value<<6)
}
func (o *GCLK_Type) GetPCHCTRL4_CHEN() uint32 {
	return (volatile.LoadUint32(&o.PCHCTRL4.Reg) & 0x40) >> 6
}
func (o *GCLK_Type) SetPCHCTRL4_WRTLOCK(value uint32) {
	volatile.StoreUint32(&o.PCHCTRL4.Reg, volatile.LoadUint32(&o.PCHCTRL4.Reg)&^(0x80)|value<<7)
}
func (o *GCLK_Type) GetPCHCTRL4_WRTLOCK() uint32 {
	return (volatile.LoadUint32(&o.PCHCTRL4.Reg) & 0x80) >> 7
}

// GCLK.PCHCTRL5: Peripheral Clock Control
func (o *GCLK_Type) SetPCHCTRL5_GEN(value uint32) {
	volatile.StoreUint32(&o.PCHCTRL5.Reg, volatile.LoadUint32(&o.PCHCTRL5.Reg)&^(0x7)|value)
}
func (o *GCLK_Type) GetPCHCTRL5_GEN() uint32 {
	return volatile.LoadUint32(&o.PCHCTRL5.Reg) & 0x7
}
func (o *GCLK_Type) SetPCHCTRL5_CHEN(value uint32) {
	volatile.StoreUint32(&o.PCHCTRL5.Reg, volatile.LoadUint32(&o.PCHCTRL5.Reg)&^(0x40)|value<<6)
}
func (o *GCLK_Type) GetPCHCTRL5_CHEN() uint32 {
	return (volatile.LoadUint32(&o.PCHCTRL5.Reg) & 0x40) >> 6
}
func (o *GCLK_Type) SetPCHCTRL5_WRTLOCK(value uint32) {
	volatile.StoreUint32(&o.PCHCTRL5.Reg, volatile.LoadUint32(&o.PCHCTRL5.Reg)&^(0x80)|value<<7)
}
func (o *GCLK_Type) GetPCHCTRL5_WRTLOCK() uint32 {
	return (volatile.LoadUint32(&o.PCHCTRL5.Reg) & 0x80) >> 7
}

// GCLK.PCHCTRL6: Peripheral Clock Control
func (o *GCLK_Type) SetPCHCTRL6_GEN(value uint32) {
	volatile.StoreUint32(&o.PCHCTRL6.Reg, volatile.LoadUint32(&o.PCHCTRL6.Reg)&^(0x7)|value)
}
func (o *GCLK_Type) GetPCHCTRL6_GEN() uint32 {
	return volatile.LoadUint32(&o.PCHCTRL6.Reg) & 0x7
}
func (o *GCLK_Type) SetPCHCTRL6_CHEN(value uint32) {
	volatile.StoreUint32(&o.PCHCTRL6.Reg, volatile.LoadUint32(&o.PCHCTRL6.Reg)&^(0x40)|value<<6)
}
func (o *GCLK_Type) GetPCHCTRL6_CHEN() uint32 {
	return (volatile.LoadUint32(&o.PCHCTRL6.Reg) & 0x40) >> 6
}
func (o *GCLK_Type) SetPCHCTRL6_WRTLOCK(value uint32) {
	volatile.StoreUint32(&o.PCHCTRL6.Reg, volatile.LoadUint32(&o.PCHCTRL6.Reg)&^(0x80)|value<<7)
}
func (o *GCLK_Type) GetPCHCTRL6_WRTLOCK() uint32 {
	return (volatile.LoadUint32(&o.PCHCTRL6.Reg) & 0x80) >> 7
}

// GCLK.PCHCTRL7: Peripheral Clock Control
func (o *GCLK_Type) SetPCHCTRL7_GEN(value uint32) {
	volatile.StoreUint32(&o.PCHCTRL7.Reg, volatile.LoadUint32(&o.PCHCTRL7.Reg)&^(0x7)|value)
}
func (o *GCLK_Type) GetPCHCTRL7_GEN() uint32 {
	return volatile.LoadUint32(&o.PCHCTRL7.Reg) & 0x7
}
func (o *GCLK_Type) SetPCHCTRL7_CHEN(value uint32) {
	volatile.StoreUint32(&o.PCHCTRL7.Reg, volatile.LoadUint32(&o.PCHCTRL7.Reg)&^(0x40)|value<<6)
}
func (o *GCLK_Type) GetPCHCTRL7_CHEN() uint32 {
	return (volatile.LoadUint32(&o.PCHCTRL7.Reg) & 0x40) >> 6
}
func (o *GCLK_Type) SetPCHCTRL7_WRTLOCK(value uint32) {
	volatile.StoreUint32(&o.PCHCTRL7.Reg, volatile.LoadUint32(&o.PCHCTRL7.Reg)&^(0x80)|value<<7)
}
func (o *GCLK_Type) GetPCHCTRL7_WRTLOCK() uint32 {
	return (volatile.LoadUint32(&o.PCHCTRL7.Reg) & 0x80) >> 7
}

// GCLK.PCHCTRL8: Peripheral Clock Control
func (o *GCLK_Type) SetPCHCTRL8_GEN(value uint32) {
	volatile.StoreUint32(&o.PCHCTRL8.Reg, volatile.LoadUint32(&o.PCHCTRL8.Reg)&^(0x7)|value)
}
func (o *GCLK_Type) GetPCHCTRL8_GEN() uint32 {
	return volatile.LoadUint32(&o.PCHCTRL8.Reg) & 0x7
}
func (o *GCLK_Type) SetPCHCTRL8_CHEN(value uint32) {
	volatile.StoreUint32(&o.PCHCTRL8.Reg, volatile.LoadUint32(&o.PCHCTRL8.Reg)&^(0x40)|value<<6)
}
func (o *GCLK_Type) GetPCHCTRL8_CHEN() uint32 {
	return (volatile.LoadUint32(&o.PCHCTRL8.Reg) & 0x40) >> 6
}
func (o *GCLK_Type) SetPCHCTRL8_WRTLOCK(value uint32) {
	volatile.StoreUint32(&o.PCHCTRL8.Reg, volatile.LoadUint32(&o.PCHCTRL8.Reg)&^(0x80)|value<<7)
}
func (o *GCLK_Type) GetPCHCTRL8_WRTLOCK() uint32 {
	return (volatile.LoadUint32(&o.PCHCTRL8.Reg) & 0x80) >> 7
}

// GCLK.PCHCTRL9: Peripheral Clock Control
func (o *GCLK_Type) SetPCHCTRL9_GEN(value uint32) {
	volatile.StoreUint32(&o.PCHCTRL9.Reg, volatile.LoadUint32(&o.PCHCTRL9.Reg)&^(0x7)|value)
}
func (o *GCLK_Type) GetPCHCTRL9_GEN() uint32 {
	return volatile.LoadUint32(&o.PCHCTRL9.Reg) & 0x7
}
func (o *GCLK_Type) SetPCHCTRL9_CHEN(value uint32) {
	volatile.StoreUint32(&o.PCHCTRL9.Reg, volatile.LoadUint32(&o.PCHCTRL9.Reg)&^(0x40)|value<<6)
}
func (o *GCLK_Type) GetPCHCTRL9_CHEN() uint32 {
	return (volatile.LoadUint32(&o.PCHCTRL9.Reg) & 0x40) >> 6
}
func (o *GCLK_Type) SetPCHCTRL9_WRTLOCK(value uint32) {
	volatile.StoreUint32(&o.PCHCTRL9.Reg, volatile.LoadUint32(&o.PCHCTRL9.Reg)&^(0x80)|value<<7)
}
func (o *GCLK_Type) GetPCHCTRL9_WRTLOCK() uint32 {
	return (volatile.LoadUint32(&o.PCHCTRL9.Reg) & 0x80) >> 7
}

// GCLK.PCHCTRL10: Peripheral Clock Control
func (o *GCLK_Type) SetPCHCTRL10_GEN(value uint32) {
	volatile.StoreUint32(&o.PCHCTRL10.Reg, volatile.LoadUint32(&o.PCHCTRL10.Reg)&^(0x7)|value)
}
func (o *GCLK_Type) GetPCHCTRL10_GEN() uint32 {
	return volatile.LoadUint32(&o.PCHCTRL10.Reg) & 0x7
}
func (o *GCLK_Type) SetPCHCTRL10_CHEN(value uint32) {
	volatile.StoreUint32(&o.PCHCTRL10.Reg, volatile.LoadUint32(&o.PCHCTRL10.Reg)&^(0x40)|value<<6)
}
func (o *GCLK_Type) GetPCHCTRL10_CHEN() uint32 {
	return (volatile.LoadUint32(&o.PCHCTRL10.Reg) & 0x40) >> 6
}
func (o *GCLK_Type) SetPCHCTRL10_WRTLOCK(value uint32) {
	volatile.StoreUint32(&o.PCHCTRL10.Reg, volatile.LoadUint32(&o.PCHCTRL10.Reg)&^(0x80)|value<<7)
}
func (o *GCLK_Type) GetPCHCTRL10_WRTLOCK() uint32 {
	return (volatile.LoadUint32(&o.PCHCTRL10.Reg) & 0x80) >> 7
}

// GCLK.PCHCTRL11: Peripheral Clock Control
func (o *GCLK_Type) SetPCHCTRL11_GEN(value uint32) {
	volatile.StoreUint32(&o.PCHCTRL11.Reg, volatile.LoadUint32(&o.PCHCTRL11.Reg)&^(0x7)|value)
}
func (o *GCLK_Type) GetPCHCTRL11_GEN() uint32 {
	return volatile.LoadUint32(&o.PCHCTRL11.Reg) & 0x7
}
func (o *GCLK_Type) SetPCHCTRL11_CHEN(value uint32) {
	volatile.StoreUint32(&o.PCHCTRL11.Reg, volatile.LoadUint32(&o.PCHCTRL11.Reg)&^(0x40)|value<<6)
}
func (o *GCLK_Type) GetPCHCTRL11_CHEN() uint32 {
	return (volatile.LoadUint32(&o.PCHCTRL11.Reg) & 0x40) >> 6
}
func (o *GCLK_Type) SetPCHCTRL11_WRTLOCK(value uint32) {
	volatile.StoreUint32(&o.PCHCTRL11.Reg, volatile.LoadUint32(&o.PCHCTRL11.Reg)&^(0x80)|value<<7)
}
func (o *GCLK_Type) GetPCHCTRL11_WRTLOCK() uint32 {
	return (volatile.LoadUint32(&o.PCHCTRL11.Reg) & 0x80) >> 7
}

// GCLK.PCHCTRL12: Peripheral Clock Control
func (o *GCLK_Type) SetPCHCTRL12_GEN(value uint32) {
	volatile.StoreUint32(&o.PCHCTRL12.Reg, volatile.LoadUint32(&o.PCHCTRL12.Reg)&^(0x7)|value)
}
func (o *GCLK_Type) GetPCHCTRL12_GEN() uint32 {
	return volatile.LoadUint32(&o.PCHCTRL12.Reg) & 0x7
}
func (o *GCLK_Type) SetPCHCTRL12_CHEN(value uint32) {
	volatile.StoreUint32(&o.PCHCTRL12.Reg, volatile.LoadUint32(&o.PCHCTRL12.Reg)&^(0x40)|value<<6)
}
func (o *GCLK_Type) GetPCHCTRL12_CHEN() uint32 {
	return (volatile.LoadUint32(&o.PCHCTRL12.Reg) & 0x40) >> 6
}
func (o *GCLK_Type) SetPCHCTRL12_WRTLOCK(value uint32) {
	volatile.StoreUint32(&o.PCHCTRL12.Reg, volatile.LoadUint32(&o.PCHCTRL12.Reg)&^(0x80)|value<<7)
}
func (o *GCLK_Type) GetPCHCTRL12_WRTLOCK() uint32 {
	return (volatile.LoadUint32(&o.PCHCTRL12.Reg) & 0x80) >> 7
}

// GCLK.PCHCTRL13: Peripheral Clock Control
func (o *GCLK_Type) SetPCHCTRL13_GEN(value uint32) {
	volatile.StoreUint32(&o.PCHCTRL13.Reg, volatile.LoadUint32(&o.PCHCTRL13.Reg)&^(0x7)|value)
}
func (o *GCLK_Type) GetPCHCTRL13_GEN() uint32 {
	return volatile.LoadUint32(&o.PCHCTRL13.Reg) & 0x7
}
func (o *GCLK_Type) SetPCHCTRL13_CHEN(value uint32) {
	volatile.StoreUint32(&o.PCHCTRL13.Reg, volatile.LoadUint32(&o.PCHCTRL13.Reg)&^(0x40)|value<<6)
}
func (o *GCLK_Type) GetPCHCTRL13_CHEN() uint32 {
	return (volatile.LoadUint32(&o.PCHCTRL13.Reg) & 0x40) >> 6
}
func (o *GCLK_Type) SetPCHCTRL13_WRTLOCK(value uint32) {
	volatile.StoreUint32(&o.PCHCTRL13.Reg, volatile.LoadUint32(&o.PCHCTRL13.Reg)&^(0x80)|value<<7)
}
func (o *GCLK_Type) GetPCHCTRL13_WRTLOCK() uint32 {
	return (volatile.LoadUint32(&o.PCHCTRL13.Reg) & 0x80) >> 7
}

// GCLK.PCHCTRL14: Peripheral Clock Control
func (o *GCLK_Type) SetPCHCTRL14_GEN(value uint32) {
	volatile.StoreUint32(&o.PCHCTRL14.Reg, volatile.LoadUint32(&o.PCHCTRL14.Reg)&^(0x7)|value)
}
func (o *GCLK_Type) GetPCHCTRL14_GEN() uint32 {
	return volatile.LoadUint32(&o.PCHCTRL14.Reg) & 0x7
}
func (o *GCLK_Type) SetPCHCTRL14_CHEN(value uint32) {
	volatile.StoreUint32(&o.PCHCTRL14.Reg, volatile.LoadUint32(&o.PCHCTRL14.Reg)&^(0x40)|value<<6)
}
func (o *GCLK_Type) GetPCHCTRL14_CHEN() uint32 {
	return (volatile.LoadUint32(&o.PCHCTRL14.Reg) & 0x40) >> 6
}
func (o *GCLK_Type) SetPCHCTRL14_WRTLOCK(value uint32) {
	volatile.StoreUint32(&o.PCHCTRL14.Reg, volatile.LoadUint32(&o.PCHCTRL14.Reg)&^(0x80)|value<<7)
}
func (o *GCLK_Type) GetPCHCTRL14_WRTLOCK() uint32 {
	return (volatile.LoadUint32(&o.PCHCTRL14.Reg) & 0x80) >> 7
}

// GCLK.PCHCTRL15: Peripheral Clock Control
func (o *GCLK_Type) SetPCHCTRL15_GEN(value uint32) {
	volatile.StoreUint32(&o.PCHCTRL15.Reg, volatile.LoadUint32(&o.PCHCTRL15.Reg)&^(0x7)|value)
}
func (o *GCLK_Type) GetPCHCTRL15_GEN() uint32 {
	return volatile.LoadUint32(&o.PCHCTRL15.Reg) & 0x7
}
func (o *GCLK_Type) SetPCHCTRL15_CHEN(value uint32) {
	volatile.StoreUint32(&o.PCHCTRL15.Reg, volatile.LoadUint32(&o.PCHCTRL15.Reg)&^(0x40)|value<<6)
}
func (o *GCLK_Type) GetPCHCTRL15_CHEN() uint32 {
	return (volatile.LoadUint32(&o.PCHCTRL15.Reg) & 0x40) >> 6
}
func (o *GCLK_Type) SetPCHCTRL15_WRTLOCK(value uint32) {
	volatile.StoreUint32(&o.PCHCTRL15.Reg, volatile.LoadUint32(&o.PCHCTRL15.Reg)&^(0x80)|value<<7)
}
func (o *GCLK_Type) GetPCHCTRL15_WRTLOCK() uint32 {
	return (volatile.LoadUint32(&o.PCHCTRL15.Reg) & 0x80) >> 7
}

// GCLK.PCHCTRL16: Peripheral Clock Control
func (o *GCLK_Type) SetPCHCTRL16_GEN(value uint32) {
	volatile.StoreUint32(&o.PCHCTRL16.Reg, volatile.LoadUint32(&o.PCHCTRL16.Reg)&^(0x7)|value)
}
func (o *GCLK_Type) GetPCHCTRL16_GEN() uint32 {
	return volatile.LoadUint32(&o.PCHCTRL16.Reg) & 0x7
}
func (o *GCLK_Type) SetPCHCTRL16_CHEN(value uint32) {
	volatile.StoreUint32(&o.PCHCTRL16.Reg, volatile.LoadUint32(&o.PCHCTRL16.Reg)&^(0x40)|value<<6)
}
func (o *GCLK_Type) GetPCHCTRL16_CHEN() uint32 {
	return (volatile.LoadUint32(&o.PCHCTRL16.Reg) & 0x40) >> 6
}
func (o *GCLK_Type) SetPCHCTRL16_WRTLOCK(value uint32) {
	volatile.StoreUint32(&o.PCHCTRL16.Reg, volatile.LoadUint32(&o.PCHCTRL16.Reg)&^(0x80)|value<<7)
}
func (o *GCLK_Type) GetPCHCTRL16_WRTLOCK() uint32 {
	return (volatile.LoadUint32(&o.PCHCTRL16.Reg) & 0x80) >> 7
}

// GCLK.PCHCTRL17: Peripheral Clock Control
func (o *GCLK_Type) SetPCHCTRL17_GEN(value uint32) {
	volatile.StoreUint32(&o.PCHCTRL17.Reg, volatile.LoadUint32(&o.PCHCTRL17.Reg)&^(0x7)|value)
}
func (o *GCLK_Type) GetPCHCTRL17_GEN() uint32 {
	return volatile.LoadUint32(&o.PCHCTRL17.Reg) & 0x7
}
func (o *GCLK_Type) SetPCHCTRL17_CHEN(value uint32) {
	volatile.StoreUint32(&o.PCHCTRL17.Reg, volatile.LoadUint32(&o.PCHCTRL17.Reg)&^(0x40)|value<<6)
}
func (o *GCLK_Type) GetPCHCTRL17_CHEN() uint32 {
	return (volatile.LoadUint32(&o.PCHCTRL17.Reg) & 0x40) >> 6
}
func (o *GCLK_Type) SetPCHCTRL17_WRTLOCK(value uint32) {
	volatile.StoreUint32(&o.PCHCTRL17.Reg, volatile.LoadUint32(&o.PCHCTRL17.Reg)&^(0x80)|value<<7)
}
func (o *GCLK_Type) GetPCHCTRL17_WRTLOCK() uint32 {
	return (volatile.LoadUint32(&o.PCHCTRL17.Reg) & 0x80) >> 7
}

// GCLK.PCHCTRL18: Peripheral Clock Control
func (o *GCLK_Type) SetPCHCTRL18_GEN(value uint32) {
	volatile.StoreUint32(&o.PCHCTRL18.Reg, volatile.LoadUint32(&o.PCHCTRL18.Reg)&^(0x7)|value)
}
func (o *GCLK_Type) GetPCHCTRL18_GEN() uint32 {
	return volatile.LoadUint32(&o.PCHCTRL18.Reg) & 0x7
}
func (o *GCLK_Type) SetPCHCTRL18_CHEN(value uint32) {
	volatile.StoreUint32(&o.PCHCTRL18.Reg, volatile.LoadUint32(&o.PCHCTRL18.Reg)&^(0x40)|value<<6)
}
func (o *GCLK_Type) GetPCHCTRL18_CHEN() uint32 {
	return (volatile.LoadUint32(&o.PCHCTRL18.Reg) & 0x40) >> 6
}
func (o *GCLK_Type) SetPCHCTRL18_WRTLOCK(value uint32) {
	volatile.StoreUint32(&o.PCHCTRL18.Reg, volatile.LoadUint32(&o.PCHCTRL18.Reg)&^(0x80)|value<<7)
}
func (o *GCLK_Type) GetPCHCTRL18_WRTLOCK() uint32 {
	return (volatile.LoadUint32(&o.PCHCTRL18.Reg) & 0x80) >> 7
}

// GCLK.PCHCTRL19: Peripheral Clock Control
func (o *GCLK_Type) SetPCHCTRL19_GEN(value uint32) {
	volatile.StoreUint32(&o.PCHCTRL19.Reg, volatile.LoadUint32(&o.PCHCTRL19.Reg)&^(0x7)|value)
}
func (o *GCLK_Type) GetPCHCTRL19_GEN() uint32 {
	return volatile.LoadUint32(&o.PCHCTRL19.Reg) & 0x7
}
func (o *GCLK_Type) SetPCHCTRL19_CHEN(value uint32) {
	volatile.StoreUint32(&o.PCHCTRL19.Reg, volatile.LoadUint32(&o.PCHCTRL19.Reg)&^(0x40)|value<<6)
}
func (o *GCLK_Type) GetPCHCTRL19_CHEN() uint32 {
	return (volatile.LoadUint32(&o.PCHCTRL19.Reg) & 0x40) >> 6
}
func (o *GCLK_Type) SetPCHCTRL19_WRTLOCK(value uint32) {
	volatile.StoreUint32(&o.PCHCTRL19.Reg, volatile.LoadUint32(&o.PCHCTRL19.Reg)&^(0x80)|value<<7)
}
func (o *GCLK_Type) GetPCHCTRL19_WRTLOCK() uint32 {
	return (volatile.LoadUint32(&o.PCHCTRL19.Reg) & 0x80) >> 7
}

// GCLK.PCHCTRL20: Peripheral Clock Control
func (o *GCLK_Type) SetPCHCTRL20_GEN(value uint32) {
	volatile.StoreUint32(&o.PCHCTRL20.Reg, volatile.LoadUint32(&o.PCHCTRL20.Reg)&^(0x7)|value)
}
func (o *GCLK_Type) GetPCHCTRL20_GEN() uint32 {
	return volatile.LoadUint32(&o.PCHCTRL20.Reg) & 0x7
}
func (o *GCLK_Type) SetPCHCTRL20_CHEN(value uint32) {
	volatile.StoreUint32(&o.PCHCTRL20.Reg, volatile.LoadUint32(&o.PCHCTRL20.Reg)&^(0x40)|value<<6)
}
func (o *GCLK_Type) GetPCHCTRL20_CHEN() uint32 {
	return (volatile.LoadUint32(&o.PCHCTRL20.Reg) & 0x40) >> 6
}
func (o *GCLK_Type) SetPCHCTRL20_WRTLOCK(value uint32) {
	volatile.StoreUint32(&o.PCHCTRL20.Reg, volatile.LoadUint32(&o.PCHCTRL20.Reg)&^(0x80)|value<<7)
}
func (o *GCLK_Type) GetPCHCTRL20_WRTLOCK() uint32 {
	return (volatile.LoadUint32(&o.PCHCTRL20.Reg) & 0x80) >> 7
}

// GCLK.PCHCTRL21: Peripheral Clock Control
func (o *GCLK_Type) SetPCHCTRL21_GEN(value uint32) {
	volatile.StoreUint32(&o.PCHCTRL21.Reg, volatile.LoadUint32(&o.PCHCTRL21.Reg)&^(0x7)|value)
}
func (o *GCLK_Type) GetPCHCTRL21_GEN() uint32 {
	return volatile.LoadUint32(&o.PCHCTRL21.Reg) & 0x7
}
func (o *GCLK_Type) SetPCHCTRL21_CHEN(value uint32) {
	volatile.StoreUint32(&o.PCHCTRL21.Reg, volatile.LoadUint32(&o.PCHCTRL21.Reg)&^(0x40)|value<<6)
}
func (o *GCLK_Type) GetPCHCTRL21_CHEN() uint32 {
	return (volatile.LoadUint32(&o.PCHCTRL21.Reg) & 0x40) >> 6
}
func (o *GCLK_Type) SetPCHCTRL21_WRTLOCK(value uint32) {
	volatile.StoreUint32(&o.PCHCTRL21.Reg, volatile.LoadUint32(&o.PCHCTRL21.Reg)&^(0x80)|value<<7)
}
func (o *GCLK_Type) GetPCHCTRL21_WRTLOCK() uint32 {
	return (volatile.LoadUint32(&o.PCHCTRL21.Reg) & 0x80) >> 7
}

// GCLK.PCHCTRL22: Peripheral Clock Control
func (o *GCLK_Type) SetPCHCTRL22_GEN(value uint32) {
	volatile.StoreUint32(&o.PCHCTRL22.Reg, volatile.LoadUint32(&o.PCHCTRL22.Reg)&^(0x7)|value)
}
func (o *GCLK_Type) GetPCHCTRL22_GEN() uint32 {
	return volatile.LoadUint32(&o.PCHCTRL22.Reg) & 0x7
}
func (o *GCLK_Type) SetPCHCTRL22_CHEN(value uint32) {
	volatile.StoreUint32(&o.PCHCTRL22.Reg, volatile.LoadUint32(&o.PCHCTRL22.Reg)&^(0x40)|value<<6)
}
func (o *GCLK_Type) GetPCHCTRL22_CHEN() uint32 {
	return (volatile.LoadUint32(&o.PCHCTRL22.Reg) & 0x40) >> 6
}
func (o *GCLK_Type) SetPCHCTRL22_WRTLOCK(value uint32) {
	volatile.StoreUint32(&o.PCHCTRL22.Reg, volatile.LoadUint32(&o.PCHCTRL22.Reg)&^(0x80)|value<<7)
}
func (o *GCLK_Type) GetPCHCTRL22_WRTLOCK() uint32 {
	return (volatile.LoadUint32(&o.PCHCTRL22.Reg) & 0x80) >> 7
}

// GCLK.PCHCTRL23: Peripheral Clock Control
func (o *GCLK_Type) SetPCHCTRL23_GEN(value uint32) {
	volatile.StoreUint32(&o.PCHCTRL23.Reg, volatile.LoadUint32(&o.PCHCTRL23.Reg)&^(0x7)|value)
}
func (o *GCLK_Type) GetPCHCTRL23_GEN() uint32 {
	return volatile.LoadUint32(&o.PCHCTRL23.Reg) & 0x7
}
func (o *GCLK_Type) SetPCHCTRL23_CHEN(value uint32) {
	volatile.StoreUint32(&o.PCHCTRL23.Reg, volatile.LoadUint32(&o.PCHCTRL23.Reg)&^(0x40)|value<<6)
}
func (o *GCLK_Type) GetPCHCTRL23_CHEN() uint32 {
	return (volatile.LoadUint32(&o.PCHCTRL23.Reg) & 0x40) >> 6
}
func (o *GCLK_Type) SetPCHCTRL23_WRTLOCK(value uint32) {
	volatile.StoreUint32(&o.PCHCTRL23.Reg, volatile.LoadUint32(&o.PCHCTRL23.Reg)&^(0x80)|value<<7)
}
func (o *GCLK_Type) GetPCHCTRL23_WRTLOCK() uint32 {
	return (volatile.LoadUint32(&o.PCHCTRL23.Reg) & 0x80) >> 7
}

// GCLK.PCHCTRL24: Peripheral Clock Control
func (o *GCLK_Type) SetPCHCTRL24_GEN(value uint32) {
	volatile.StoreUint32(&o.PCHCTRL24.Reg, volatile.LoadUint32(&o.PCHCTRL24.Reg)&^(0x7)|value)
}
func (o *GCLK_Type) GetPCHCTRL24_GEN() uint32 {
	return volatile.LoadUint32(&o.PCHCTRL24.Reg) & 0x7
}
func (o *GCLK_Type) SetPCHCTRL24_CHEN(value uint32) {
	volatile.StoreUint32(&o.PCHCTRL24.Reg, volatile.LoadUint32(&o.PCHCTRL24.Reg)&^(0x40)|value<<6)
}
func (o *GCLK_Type) GetPCHCTRL24_CHEN() uint32 {
	return (volatile.LoadUint32(&o.PCHCTRL24.Reg) & 0x40) >> 6
}
func (o *GCLK_Type) SetPCHCTRL24_WRTLOCK(value uint32) {
	volatile.StoreUint32(&o.PCHCTRL24.Reg, volatile.LoadUint32(&o.PCHCTRL24.Reg)&^(0x80)|value<<7)
}
func (o *GCLK_Type) GetPCHCTRL24_WRTLOCK() uint32 {
	return (volatile.LoadUint32(&o.PCHCTRL24.Reg) & 0x80) >> 7
}

// GCLK.PCHCTRL25: Peripheral Clock Control
func (o *GCLK_Type) SetPCHCTRL25_GEN(value uint32) {
	volatile.StoreUint32(&o.PCHCTRL25.Reg, volatile.LoadUint32(&o.PCHCTRL25.Reg)&^(0x7)|value)
}
func (o *GCLK_Type) GetPCHCTRL25_GEN() uint32 {
	return volatile.LoadUint32(&o.PCHCTRL25.Reg) & 0x7
}
func (o *GCLK_Type) SetPCHCTRL25_CHEN(value uint32) {
	volatile.StoreUint32(&o.PCHCTRL25.Reg, volatile.LoadUint32(&o.PCHCTRL25.Reg)&^(0x40)|value<<6)
}
func (o *GCLK_Type) GetPCHCTRL25_CHEN() uint32 {
	return (volatile.LoadUint32(&o.PCHCTRL25.Reg) & 0x40) >> 6
}
func (o *GCLK_Type) SetPCHCTRL25_WRTLOCK(value uint32) {
	volatile.StoreUint32(&o.PCHCTRL25.Reg, volatile.LoadUint32(&o.PCHCTRL25.Reg)&^(0x80)|value<<7)
}
func (o *GCLK_Type) GetPCHCTRL25_WRTLOCK() uint32 {
	return (volatile.LoadUint32(&o.PCHCTRL25.Reg) & 0x80) >> 7
}

// GCLK.PCHCTRL26: Peripheral Clock Control
func (o *GCLK_Type) SetPCHCTRL26_GEN(value uint32) {
	volatile.StoreUint32(&o.PCHCTRL26.Reg, volatile.LoadUint32(&o.PCHCTRL26.Reg)&^(0x7)|value)
}
func (o *GCLK_Type) GetPCHCTRL26_GEN() uint32 {
	return volatile.LoadUint32(&o.PCHCTRL26.Reg) & 0x7
}
func (o *GCLK_Type) SetPCHCTRL26_CHEN(value uint32) {
	volatile.StoreUint32(&o.PCHCTRL26.Reg, volatile.LoadUint32(&o.PCHCTRL26.Reg)&^(0x40)|value<<6)
}
func (o *GCLK_Type) GetPCHCTRL26_CHEN() uint32 {
	return (volatile.LoadUint32(&o.PCHCTRL26.Reg) & 0x40) >> 6
}
func (o *GCLK_Type) SetPCHCTRL26_WRTLOCK(value uint32) {
	volatile.StoreUint32(&o.PCHCTRL26.Reg, volatile.LoadUint32(&o.PCHCTRL26.Reg)&^(0x80)|value<<7)
}
func (o *GCLK_Type) GetPCHCTRL26_WRTLOCK() uint32 {
	return (volatile.LoadUint32(&o.PCHCTRL26.Reg) & 0x80) >> 7
}

// GCLK.PCHCTRL27: Peripheral Clock Control
func (o *GCLK_Type) SetPCHCTRL27_GEN(value uint32) {
	volatile.StoreUint32(&o.PCHCTRL27.Reg, volatile.LoadUint32(&o.PCHCTRL27.Reg)&^(0x7)|value)
}
func (o *GCLK_Type) GetPCHCTRL27_GEN() uint32 {
	return volatile.LoadUint32(&o.PCHCTRL27.Reg) & 0x7
}
func (o *GCLK_Type) SetPCHCTRL27_CHEN(value uint32) {
	volatile.StoreUint32(&o.PCHCTRL27.Reg, volatile.LoadUint32(&o.PCHCTRL27.Reg)&^(0x40)|value<<6)
}
func (o *GCLK_Type) GetPCHCTRL27_CHEN() uint32 {
	return (volatile.LoadUint32(&o.PCHCTRL27.Reg) & 0x40) >> 6
}
func (o *GCLK_Type) SetPCHCTRL27_WRTLOCK(value uint32) {
	volatile.StoreUint32(&o.PCHCTRL27.Reg, volatile.LoadUint32(&o.PCHCTRL27.Reg)&^(0x80)|value<<7)
}
func (o *GCLK_Type) GetPCHCTRL27_WRTLOCK() uint32 {
	return (volatile.LoadUint32(&o.PCHCTRL27.Reg) & 0x80) >> 7
}

// GCLK.PCHCTRL28: Peripheral Clock Control
func (o *GCLK_Type) SetPCHCTRL28_GEN(value uint32) {
	volatile.StoreUint32(&o.PCHCTRL28.Reg, volatile.LoadUint32(&o.PCHCTRL28.Reg)&^(0x7)|value)
}
func (o *GCLK_Type) GetPCHCTRL28_GEN() uint32 {
	return volatile.LoadUint32(&o.PCHCTRL28.Reg) & 0x7
}
func (o *GCLK_Type) SetPCHCTRL28_CHEN(value uint32) {
	volatile.StoreUint32(&o.PCHCTRL28.Reg, volatile.LoadUint32(&o.PCHCTRL28.Reg)&^(0x40)|value<<6)
}
func (o *GCLK_Type) GetPCHCTRL28_CHEN() uint32 {
	return (volatile.LoadUint32(&o.PCHCTRL28.Reg) & 0x40) >> 6
}
func (o *GCLK_Type) SetPCHCTRL28_WRTLOCK(value uint32) {
	volatile.StoreUint32(&o.PCHCTRL28.Reg, volatile.LoadUint32(&o.PCHCTRL28.Reg)&^(0x80)|value<<7)
}
func (o *GCLK_Type) GetPCHCTRL28_WRTLOCK() uint32 {
	return (volatile.LoadUint32(&o.PCHCTRL28.Reg) & 0x80) >> 7
}

// GCLK.PCHCTRL29: Peripheral Clock Control
func (o *GCLK_Type) SetPCHCTRL29_GEN(value uint32) {
	volatile.StoreUint32(&o.PCHCTRL29.Reg, volatile.LoadUint32(&o.PCHCTRL29.Reg)&^(0x7)|value)
}
func (o *GCLK_Type) GetPCHCTRL29_GEN() uint32 {
	return volatile.LoadUint32(&o.PCHCTRL29.Reg) & 0x7
}
func (o *GCLK_Type) SetPCHCTRL29_CHEN(value uint32) {
	volatile.StoreUint32(&o.PCHCTRL29.Reg, volatile.LoadUint32(&o.PCHCTRL29.Reg)&^(0x40)|value<<6)
}
func (o *GCLK_Type) GetPCHCTRL29_CHEN() uint32 {
	return (volatile.LoadUint32(&o.PCHCTRL29.Reg) & 0x40) >> 6
}
func (o *GCLK_Type) SetPCHCTRL29_WRTLOCK(value uint32) {
	volatile.StoreUint32(&o.PCHCTRL29.Reg, volatile.LoadUint32(&o.PCHCTRL29.Reg)&^(0x80)|value<<7)
}
func (o *GCLK_Type) GetPCHCTRL29_WRTLOCK() uint32 {
	return (volatile.LoadUint32(&o.PCHCTRL29.Reg) & 0x80) >> 7
}

// Main Clock
type MCLK_Type struct {
	_        byte
	INTENCLR volatile.Register8 // 0x1
	INTENSET volatile.Register8 // 0x2
	INTFLAG  volatile.Register8 // 0x3
	CPUDIV   volatile.Register8 // 0x4
	_        byte
	BUPDIV   volatile.Register8 // 0x6
	_        [9]byte
	AHBMASK  volatile.Register32 // 0x10
	APBAMASK volatile.Register32 // 0x14
	APBBMASK volatile.Register32 // 0x18
	APBCMASK volatile.Register32 // 0x1C
}

// MCLK.INTENCLR: Interrupt Enable Clear
func (o *MCLK_Type) SetINTENCLR_CKRDY(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *MCLK_Type) GetINTENCLR_CKRDY() uint8 {
	return volatile.LoadUint8(&o.INTENCLR.Reg) & 0x1
}

// MCLK.INTENSET: Interrupt Enable Set
func (o *MCLK_Type) SetINTENSET_CKRDY(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *MCLK_Type) GetINTENSET_CKRDY() uint8 {
	return volatile.LoadUint8(&o.INTENSET.Reg) & 0x1
}

// MCLK.INTFLAG: Interrupt Flag Status and Clear
func (o *MCLK_Type) SetINTFLAG_CKRDY(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x1)|value)
}
func (o *MCLK_Type) GetINTFLAG_CKRDY() uint8 {
	return volatile.LoadUint8(&o.INTFLAG.Reg) & 0x1
}

// MCLK.CPUDIV: CPU Clock Division
func (o *MCLK_Type) SetCPUDIV(value uint8) {
	volatile.StoreUint8(&o.CPUDIV.Reg, value)
}
func (o *MCLK_Type) GetCPUDIV() uint8 {
	return volatile.LoadUint8(&o.CPUDIV.Reg)
}

// MCLK.BUPDIV: Backup Clock Division
func (o *MCLK_Type) SetBUPDIV(value uint8) {
	volatile.StoreUint8(&o.BUPDIV.Reg, value)
}
func (o *MCLK_Type) GetBUPDIV() uint8 {
	return volatile.LoadUint8(&o.BUPDIV.Reg)
}

// MCLK.AHBMASK: AHB Mask
func (o *MCLK_Type) SetAHBMASK_HPB0_(value uint32) {
	volatile.StoreUint32(&o.AHBMASK.Reg, volatile.LoadUint32(&o.AHBMASK.Reg)&^(0x1)|value)
}
func (o *MCLK_Type) GetAHBMASK_HPB0_() uint32 {
	return volatile.LoadUint32(&o.AHBMASK.Reg) & 0x1
}
func (o *MCLK_Type) SetAHBMASK_HPB1_(value uint32) {
	volatile.StoreUint32(&o.AHBMASK.Reg, volatile.LoadUint32(&o.AHBMASK.Reg)&^(0x2)|value<<1)
}
func (o *MCLK_Type) GetAHBMASK_HPB1_() uint32 {
	return (volatile.LoadUint32(&o.AHBMASK.Reg) & 0x2) >> 1
}
func (o *MCLK_Type) SetAHBMASK_HPB2_(value uint32) {
	volatile.StoreUint32(&o.AHBMASK.Reg, volatile.LoadUint32(&o.AHBMASK.Reg)&^(0x4)|value<<2)
}
func (o *MCLK_Type) GetAHBMASK_HPB2_() uint32 {
	return (volatile.LoadUint32(&o.AHBMASK.Reg) & 0x4) >> 2
}
func (o *MCLK_Type) SetAHBMASK_DMAC_(value uint32) {
	volatile.StoreUint32(&o.AHBMASK.Reg, volatile.LoadUint32(&o.AHBMASK.Reg)&^(0x8)|value<<3)
}
func (o *MCLK_Type) GetAHBMASK_DMAC_() uint32 {
	return (volatile.LoadUint32(&o.AHBMASK.Reg) & 0x8) >> 3
}
func (o *MCLK_Type) SetAHBMASK_USB_(value uint32) {
	volatile.StoreUint32(&o.AHBMASK.Reg, volatile.LoadUint32(&o.AHBMASK.Reg)&^(0x10)|value<<4)
}
func (o *MCLK_Type) GetAHBMASK_USB_() uint32 {
	return (volatile.LoadUint32(&o.AHBMASK.Reg) & 0x10) >> 4
}
func (o *MCLK_Type) SetAHBMASK_DSU_(value uint32) {
	volatile.StoreUint32(&o.AHBMASK.Reg, volatile.LoadUint32(&o.AHBMASK.Reg)&^(0x20)|value<<5)
}
func (o *MCLK_Type) GetAHBMASK_DSU_() uint32 {
	return (volatile.LoadUint32(&o.AHBMASK.Reg) & 0x20) >> 5
}
func (o *MCLK_Type) SetAHBMASK_PAC_(value uint32) {
	volatile.StoreUint32(&o.AHBMASK.Reg, volatile.LoadUint32(&o.AHBMASK.Reg)&^(0x80)|value<<7)
}
func (o *MCLK_Type) GetAHBMASK_PAC_() uint32 {
	return (volatile.LoadUint32(&o.AHBMASK.Reg) & 0x80) >> 7
}
func (o *MCLK_Type) SetAHBMASK_NVMCTRL_(value uint32) {
	volatile.StoreUint32(&o.AHBMASK.Reg, volatile.LoadUint32(&o.AHBMASK.Reg)&^(0x100)|value<<8)
}
func (o *MCLK_Type) GetAHBMASK_NVMCTRL_() uint32 {
	return (volatile.LoadUint32(&o.AHBMASK.Reg) & 0x100) >> 8
}
func (o *MCLK_Type) SetAHBMASK_HSRAM_(value uint32) {
	volatile.StoreUint32(&o.AHBMASK.Reg, volatile.LoadUint32(&o.AHBMASK.Reg)&^(0x200)|value<<9)
}
func (o *MCLK_Type) GetAHBMASK_HSRAM_() uint32 {
	return (volatile.LoadUint32(&o.AHBMASK.Reg) & 0x200) >> 9
}
func (o *MCLK_Type) SetAHBMASK_NVMCTRL_PICACHU_(value uint32) {
	volatile.StoreUint32(&o.AHBMASK.Reg, volatile.LoadUint32(&o.AHBMASK.Reg)&^(0x400)|value<<10)
}
func (o *MCLK_Type) GetAHBMASK_NVMCTRL_PICACHU_() uint32 {
	return (volatile.LoadUint32(&o.AHBMASK.Reg) & 0x400) >> 10
}

// MCLK.APBAMASK: APBA Mask
func (o *MCLK_Type) SetAPBAMASK_PAC_(value uint32) {
	volatile.StoreUint32(&o.APBAMASK.Reg, volatile.LoadUint32(&o.APBAMASK.Reg)&^(0x1)|value)
}
func (o *MCLK_Type) GetAPBAMASK_PAC_() uint32 {
	return volatile.LoadUint32(&o.APBAMASK.Reg) & 0x1
}
func (o *MCLK_Type) SetAPBAMASK_PM_(value uint32) {
	volatile.StoreUint32(&o.APBAMASK.Reg, volatile.LoadUint32(&o.APBAMASK.Reg)&^(0x2)|value<<1)
}
func (o *MCLK_Type) GetAPBAMASK_PM_() uint32 {
	return (volatile.LoadUint32(&o.APBAMASK.Reg) & 0x2) >> 1
}
func (o *MCLK_Type) SetAPBAMASK_MCLK_(value uint32) {
	volatile.StoreUint32(&o.APBAMASK.Reg, volatile.LoadUint32(&o.APBAMASK.Reg)&^(0x4)|value<<2)
}
func (o *MCLK_Type) GetAPBAMASK_MCLK_() uint32 {
	return (volatile.LoadUint32(&o.APBAMASK.Reg) & 0x4) >> 2
}
func (o *MCLK_Type) SetAPBAMASK_RSTC_(value uint32) {
	volatile.StoreUint32(&o.APBAMASK.Reg, volatile.LoadUint32(&o.APBAMASK.Reg)&^(0x8)|value<<3)
}
func (o *MCLK_Type) GetAPBAMASK_RSTC_() uint32 {
	return (volatile.LoadUint32(&o.APBAMASK.Reg) & 0x8) >> 3
}
func (o *MCLK_Type) SetAPBAMASK_OSCCTRL_(value uint32) {
	volatile.StoreUint32(&o.APBAMASK.Reg, volatile.LoadUint32(&o.APBAMASK.Reg)&^(0x10)|value<<4)
}
func (o *MCLK_Type) GetAPBAMASK_OSCCTRL_() uint32 {
	return (volatile.LoadUint32(&o.APBAMASK.Reg) & 0x10) >> 4
}
func (o *MCLK_Type) SetAPBAMASK_OSC32KCTRL_(value uint32) {
	volatile.StoreUint32(&o.APBAMASK.Reg, volatile.LoadUint32(&o.APBAMASK.Reg)&^(0x20)|value<<5)
}
func (o *MCLK_Type) GetAPBAMASK_OSC32KCTRL_() uint32 {
	return (volatile.LoadUint32(&o.APBAMASK.Reg) & 0x20) >> 5
}
func (o *MCLK_Type) SetAPBAMASK_SUPC_(value uint32) {
	volatile.StoreUint32(&o.APBAMASK.Reg, volatile.LoadUint32(&o.APBAMASK.Reg)&^(0x40)|value<<6)
}
func (o *MCLK_Type) GetAPBAMASK_SUPC_() uint32 {
	return (volatile.LoadUint32(&o.APBAMASK.Reg) & 0x40) >> 6
}
func (o *MCLK_Type) SetAPBAMASK_GCLK_(value uint32) {
	volatile.StoreUint32(&o.APBAMASK.Reg, volatile.LoadUint32(&o.APBAMASK.Reg)&^(0x80)|value<<7)
}
func (o *MCLK_Type) GetAPBAMASK_GCLK_() uint32 {
	return (volatile.LoadUint32(&o.APBAMASK.Reg) & 0x80) >> 7
}
func (o *MCLK_Type) SetAPBAMASK_WDT_(value uint32) {
	volatile.StoreUint32(&o.APBAMASK.Reg, volatile.LoadUint32(&o.APBAMASK.Reg)&^(0x100)|value<<8)
}
func (o *MCLK_Type) GetAPBAMASK_WDT_() uint32 {
	return (volatile.LoadUint32(&o.APBAMASK.Reg) & 0x100) >> 8
}
func (o *MCLK_Type) SetAPBAMASK_RTC_(value uint32) {
	volatile.StoreUint32(&o.APBAMASK.Reg, volatile.LoadUint32(&o.APBAMASK.Reg)&^(0x200)|value<<9)
}
func (o *MCLK_Type) GetAPBAMASK_RTC_() uint32 {
	return (volatile.LoadUint32(&o.APBAMASK.Reg) & 0x200) >> 9
}
func (o *MCLK_Type) SetAPBAMASK_EIC_(value uint32) {
	volatile.StoreUint32(&o.APBAMASK.Reg, volatile.LoadUint32(&o.APBAMASK.Reg)&^(0x400)|value<<10)
}
func (o *MCLK_Type) GetAPBAMASK_EIC_() uint32 {
	return (volatile.LoadUint32(&o.APBAMASK.Reg) & 0x400) >> 10
}
func (o *MCLK_Type) SetAPBAMASK_FREQM_(value uint32) {
	volatile.StoreUint32(&o.APBAMASK.Reg, volatile.LoadUint32(&o.APBAMASK.Reg)&^(0x800)|value<<11)
}
func (o *MCLK_Type) GetAPBAMASK_FREQM_() uint32 {
	return (volatile.LoadUint32(&o.APBAMASK.Reg) & 0x800) >> 11
}

// MCLK.APBBMASK: APBB Mask
func (o *MCLK_Type) SetAPBBMASK_USB_(value uint32) {
	volatile.StoreUint32(&o.APBBMASK.Reg, volatile.LoadUint32(&o.APBBMASK.Reg)&^(0x1)|value)
}
func (o *MCLK_Type) GetAPBBMASK_USB_() uint32 {
	return volatile.LoadUint32(&o.APBBMASK.Reg) & 0x1
}
func (o *MCLK_Type) SetAPBBMASK_DSU_(value uint32) {
	volatile.StoreUint32(&o.APBBMASK.Reg, volatile.LoadUint32(&o.APBBMASK.Reg)&^(0x2)|value<<1)
}
func (o *MCLK_Type) GetAPBBMASK_DSU_() uint32 {
	return (volatile.LoadUint32(&o.APBBMASK.Reg) & 0x2) >> 1
}
func (o *MCLK_Type) SetAPBBMASK_NVMCTRL_(value uint32) {
	volatile.StoreUint32(&o.APBBMASK.Reg, volatile.LoadUint32(&o.APBBMASK.Reg)&^(0x4)|value<<2)
}
func (o *MCLK_Type) GetAPBBMASK_NVMCTRL_() uint32 {
	return (volatile.LoadUint32(&o.APBBMASK.Reg) & 0x4) >> 2
}
func (o *MCLK_Type) SetAPBBMASK_PORT_(value uint32) {
	volatile.StoreUint32(&o.APBBMASK.Reg, volatile.LoadUint32(&o.APBBMASK.Reg)&^(0x8)|value<<3)
}
func (o *MCLK_Type) GetAPBBMASK_PORT_() uint32 {
	return (volatile.LoadUint32(&o.APBBMASK.Reg) & 0x8) >> 3
}

// MCLK.APBCMASK: APBC Mask
func (o *MCLK_Type) SetAPBCMASK_EVSYS_(value uint32) {
	volatile.StoreUint32(&o.APBCMASK.Reg, volatile.LoadUint32(&o.APBCMASK.Reg)&^(0x1)|value)
}
func (o *MCLK_Type) GetAPBCMASK_EVSYS_() uint32 {
	return volatile.LoadUint32(&o.APBCMASK.Reg) & 0x1
}
func (o *MCLK_Type) SetAPBCMASK_SERCOM0_(value uint32) {
	volatile.StoreUint32(&o.APBCMASK.Reg, volatile.LoadUint32(&o.APBCMASK.Reg)&^(0x2)|value<<1)
}
func (o *MCLK_Type) GetAPBCMASK_SERCOM0_() uint32 {
	return (volatile.LoadUint32(&o.APBCMASK.Reg) & 0x2) >> 1
}
func (o *MCLK_Type) SetAPBCMASK_SERCOM1_(value uint32) {
	volatile.StoreUint32(&o.APBCMASK.Reg, volatile.LoadUint32(&o.APBCMASK.Reg)&^(0x4)|value<<2)
}
func (o *MCLK_Type) GetAPBCMASK_SERCOM1_() uint32 {
	return (volatile.LoadUint32(&o.APBCMASK.Reg) & 0x4) >> 2
}
func (o *MCLK_Type) SetAPBCMASK_SERCOM2_(value uint32) {
	volatile.StoreUint32(&o.APBCMASK.Reg, volatile.LoadUint32(&o.APBCMASK.Reg)&^(0x8)|value<<3)
}
func (o *MCLK_Type) GetAPBCMASK_SERCOM2_() uint32 {
	return (volatile.LoadUint32(&o.APBCMASK.Reg) & 0x8) >> 3
}
func (o *MCLK_Type) SetAPBCMASK_SERCOM3_(value uint32) {
	volatile.StoreUint32(&o.APBCMASK.Reg, volatile.LoadUint32(&o.APBCMASK.Reg)&^(0x10)|value<<4)
}
func (o *MCLK_Type) GetAPBCMASK_SERCOM3_() uint32 {
	return (volatile.LoadUint32(&o.APBCMASK.Reg) & 0x10) >> 4
}
func (o *MCLK_Type) SetAPBCMASK_TCC0_(value uint32) {
	volatile.StoreUint32(&o.APBCMASK.Reg, volatile.LoadUint32(&o.APBCMASK.Reg)&^(0x80)|value<<7)
}
func (o *MCLK_Type) GetAPBCMASK_TCC0_() uint32 {
	return (volatile.LoadUint32(&o.APBCMASK.Reg) & 0x80) >> 7
}
func (o *MCLK_Type) SetAPBCMASK_TC0_(value uint32) {
	volatile.StoreUint32(&o.APBCMASK.Reg, volatile.LoadUint32(&o.APBCMASK.Reg)&^(0x100)|value<<8)
}
func (o *MCLK_Type) GetAPBCMASK_TC0_() uint32 {
	return (volatile.LoadUint32(&o.APBCMASK.Reg) & 0x100) >> 8
}
func (o *MCLK_Type) SetAPBCMASK_TC1_(value uint32) {
	volatile.StoreUint32(&o.APBCMASK.Reg, volatile.LoadUint32(&o.APBCMASK.Reg)&^(0x200)|value<<9)
}
func (o *MCLK_Type) GetAPBCMASK_TC1_() uint32 {
	return (volatile.LoadUint32(&o.APBCMASK.Reg) & 0x200) >> 9
}
func (o *MCLK_Type) SetAPBCMASK_TC2_(value uint32) {
	volatile.StoreUint32(&o.APBCMASK.Reg, volatile.LoadUint32(&o.APBCMASK.Reg)&^(0x400)|value<<10)
}
func (o *MCLK_Type) GetAPBCMASK_TC2_() uint32 {
	return (volatile.LoadUint32(&o.APBCMASK.Reg) & 0x400) >> 10
}
func (o *MCLK_Type) SetAPBCMASK_TC3_(value uint32) {
	volatile.StoreUint32(&o.APBCMASK.Reg, volatile.LoadUint32(&o.APBCMASK.Reg)&^(0x800)|value<<11)
}
func (o *MCLK_Type) GetAPBCMASK_TC3_() uint32 {
	return (volatile.LoadUint32(&o.APBCMASK.Reg) & 0x800) >> 11
}
func (o *MCLK_Type) SetAPBCMASK_ADC_(value uint32) {
	volatile.StoreUint32(&o.APBCMASK.Reg, volatile.LoadUint32(&o.APBCMASK.Reg)&^(0x1000)|value<<12)
}
func (o *MCLK_Type) GetAPBCMASK_ADC_() uint32 {
	return (volatile.LoadUint32(&o.APBCMASK.Reg) & 0x1000) >> 12
}
func (o *MCLK_Type) SetAPBCMASK_AC_(value uint32) {
	volatile.StoreUint32(&o.APBCMASK.Reg, volatile.LoadUint32(&o.APBCMASK.Reg)&^(0x2000)|value<<13)
}
func (o *MCLK_Type) GetAPBCMASK_AC_() uint32 {
	return (volatile.LoadUint32(&o.APBCMASK.Reg) & 0x2000) >> 13
}
func (o *MCLK_Type) SetAPBCMASK_PTC_(value uint32) {
	volatile.StoreUint32(&o.APBCMASK.Reg, volatile.LoadUint32(&o.APBCMASK.Reg)&^(0x4000)|value<<14)
}
func (o *MCLK_Type) GetAPBCMASK_PTC_() uint32 {
	return (volatile.LoadUint32(&o.APBCMASK.Reg) & 0x4000) >> 14
}
func (o *MCLK_Type) SetAPBCMASK_SLCD_(value uint32) {
	volatile.StoreUint32(&o.APBCMASK.Reg, volatile.LoadUint32(&o.APBCMASK.Reg)&^(0x8000)|value<<15)
}
func (o *MCLK_Type) GetAPBCMASK_SLCD_() uint32 {
	return (volatile.LoadUint32(&o.APBCMASK.Reg) & 0x8000) >> 15
}
func (o *MCLK_Type) SetAPBCMASK_AES_(value uint32) {
	volatile.StoreUint32(&o.APBCMASK.Reg, volatile.LoadUint32(&o.APBCMASK.Reg)&^(0x10000)|value<<16)
}
func (o *MCLK_Type) GetAPBCMASK_AES_() uint32 {
	return (volatile.LoadUint32(&o.APBCMASK.Reg) & 0x10000) >> 16
}
func (o *MCLK_Type) SetAPBCMASK_TRNG_(value uint32) {
	volatile.StoreUint32(&o.APBCMASK.Reg, volatile.LoadUint32(&o.APBCMASK.Reg)&^(0x20000)|value<<17)
}
func (o *MCLK_Type) GetAPBCMASK_TRNG_() uint32 {
	return (volatile.LoadUint32(&o.APBCMASK.Reg) & 0x20000) >> 17
}
func (o *MCLK_Type) SetAPBCMASK_CCL_(value uint32) {
	volatile.StoreUint32(&o.APBCMASK.Reg, volatile.LoadUint32(&o.APBCMASK.Reg)&^(0x40000)|value<<18)
}
func (o *MCLK_Type) GetAPBCMASK_CCL_() uint32 {
	return (volatile.LoadUint32(&o.APBCMASK.Reg) & 0x40000) >> 18
}

// Cortex-M0+ Micro-Trace Buffer
type MTB_Type struct {
	POSITION   volatile.Register32 // 0x0
	MASTER     volatile.Register32 // 0x4
	FLOW       volatile.Register32 // 0x8
	BASE       volatile.Register32 // 0xC
	_          [3824]byte
	ITCTRL     volatile.Register32 // 0xF00
	_          [156]byte
	CLAIMSET   volatile.Register32 // 0xFA0
	CLAIMCLR   volatile.Register32 // 0xFA4
	_          [8]byte
	LOCKACCESS volatile.Register32 // 0xFB0
	LOCKSTATUS volatile.Register32 // 0xFB4
	AUTHSTATUS volatile.Register32 // 0xFB8
	DEVARCH    volatile.Register32 // 0xFBC
	_          [8]byte
	DEVID      volatile.Register32 // 0xFC8
	DEVTYPE    volatile.Register32 // 0xFCC
	PID4       volatile.Register32 // 0xFD0
	PID5       volatile.Register32 // 0xFD4
	PID6       volatile.Register32 // 0xFD8
	PID7       volatile.Register32 // 0xFDC
	PID0       volatile.Register32 // 0xFE0
	PID1       volatile.Register32 // 0xFE4
	PID2       volatile.Register32 // 0xFE8
	PID3       volatile.Register32 // 0xFEC
	CID0       volatile.Register32 // 0xFF0
	CID1       volatile.Register32 // 0xFF4
	CID2       volatile.Register32 // 0xFF8
	CID3       volatile.Register32 // 0xFFC
}

// MTB.POSITION: MTB Position
func (o *MTB_Type) SetPOSITION_WRAP(value uint32) {
	volatile.StoreUint32(&o.POSITION.Reg, volatile.LoadUint32(&o.POSITION.Reg)&^(0x4)|value<<2)
}
func (o *MTB_Type) GetPOSITION_WRAP() uint32 {
	return (volatile.LoadUint32(&o.POSITION.Reg) & 0x4) >> 2
}
func (o *MTB_Type) SetPOSITION_POINTER(value uint32) {
	volatile.StoreUint32(&o.POSITION.Reg, volatile.LoadUint32(&o.POSITION.Reg)&^(0xfffffff8)|value<<3)
}
func (o *MTB_Type) GetPOSITION_POINTER() uint32 {
	return (volatile.LoadUint32(&o.POSITION.Reg) & 0xfffffff8) >> 3
}

// MTB.MASTER: MTB Master
func (o *MTB_Type) SetMASTER_MASK(value uint32) {
	volatile.StoreUint32(&o.MASTER.Reg, volatile.LoadUint32(&o.MASTER.Reg)&^(0x1f)|value)
}
func (o *MTB_Type) GetMASTER_MASK() uint32 {
	return volatile.LoadUint32(&o.MASTER.Reg) & 0x1f
}
func (o *MTB_Type) SetMASTER_TSTARTEN(value uint32) {
	volatile.StoreUint32(&o.MASTER.Reg, volatile.LoadUint32(&o.MASTER.Reg)&^(0x20)|value<<5)
}
func (o *MTB_Type) GetMASTER_TSTARTEN() uint32 {
	return (volatile.LoadUint32(&o.MASTER.Reg) & 0x20) >> 5
}
func (o *MTB_Type) SetMASTER_TSTOPEN(value uint32) {
	volatile.StoreUint32(&o.MASTER.Reg, volatile.LoadUint32(&o.MASTER.Reg)&^(0x40)|value<<6)
}
func (o *MTB_Type) GetMASTER_TSTOPEN() uint32 {
	return (volatile.LoadUint32(&o.MASTER.Reg) & 0x40) >> 6
}
func (o *MTB_Type) SetMASTER_SFRWPRIV(value uint32) {
	volatile.StoreUint32(&o.MASTER.Reg, volatile.LoadUint32(&o.MASTER.Reg)&^(0x80)|value<<7)
}
func (o *MTB_Type) GetMASTER_SFRWPRIV() uint32 {
	return (volatile.LoadUint32(&o.MASTER.Reg) & 0x80) >> 7
}
func (o *MTB_Type) SetMASTER_RAMPRIV(value uint32) {
	volatile.StoreUint32(&o.MASTER.Reg, volatile.LoadUint32(&o.MASTER.Reg)&^(0x100)|value<<8)
}
func (o *MTB_Type) GetMASTER_RAMPRIV() uint32 {
	return (volatile.LoadUint32(&o.MASTER.Reg) & 0x100) >> 8
}
func (o *MTB_Type) SetMASTER_HALTREQ(value uint32) {
	volatile.StoreUint32(&o.MASTER.Reg, volatile.LoadUint32(&o.MASTER.Reg)&^(0x200)|value<<9)
}
func (o *MTB_Type) GetMASTER_HALTREQ() uint32 {
	return (volatile.LoadUint32(&o.MASTER.Reg) & 0x200) >> 9
}
func (o *MTB_Type) SetMASTER_EN(value uint32) {
	volatile.StoreUint32(&o.MASTER.Reg, volatile.LoadUint32(&o.MASTER.Reg)&^(0x80000000)|value<<31)
}
func (o *MTB_Type) GetMASTER_EN() uint32 {
	return (volatile.LoadUint32(&o.MASTER.Reg) & 0x80000000) >> 31
}

// MTB.FLOW: MTB Flow
func (o *MTB_Type) SetFLOW_AUTOSTOP(value uint32) {
	volatile.StoreUint32(&o.FLOW.Reg, volatile.LoadUint32(&o.FLOW.Reg)&^(0x1)|value)
}
func (o *MTB_Type) GetFLOW_AUTOSTOP() uint32 {
	return volatile.LoadUint32(&o.FLOW.Reg) & 0x1
}
func (o *MTB_Type) SetFLOW_AUTOHALT(value uint32) {
	volatile.StoreUint32(&o.FLOW.Reg, volatile.LoadUint32(&o.FLOW.Reg)&^(0x2)|value<<1)
}
func (o *MTB_Type) GetFLOW_AUTOHALT() uint32 {
	return (volatile.LoadUint32(&o.FLOW.Reg) & 0x2) >> 1
}
func (o *MTB_Type) SetFLOW_WATERMARK(value uint32) {
	volatile.StoreUint32(&o.FLOW.Reg, volatile.LoadUint32(&o.FLOW.Reg)&^(0xfffffff8)|value<<3)
}
func (o *MTB_Type) GetFLOW_WATERMARK() uint32 {
	return (volatile.LoadUint32(&o.FLOW.Reg) & 0xfffffff8) >> 3
}

// Non-Volatile Memory Controller
type NVMCTRL_Type struct {
	CTRLA    volatile.Register16 // 0x0
	_        [2]byte
	CTRLB    volatile.Register32 // 0x4
	PARAM    volatile.Register32 // 0x8
	INTENCLR volatile.Register8  // 0xC
	_        [3]byte
	INTENSET volatile.Register8 // 0x10
	_        [3]byte
	INTFLAG  volatile.Register8 // 0x14
	_        [3]byte
	STATUS   volatile.Register16 // 0x18
	_        [2]byte
	ADDR     volatile.Register32 // 0x1C
	LOCK     volatile.Register16 // 0x20
}

// NVMCTRL.CTRLA: Control A
func (o *NVMCTRL_Type) SetCTRLA_CMD(value uint16) {
	volatile.StoreUint16(&o.CTRLA.Reg, volatile.LoadUint16(&o.CTRLA.Reg)&^(0x7f)|value)
}
func (o *NVMCTRL_Type) GetCTRLA_CMD() uint16 {
	return volatile.LoadUint16(&o.CTRLA.Reg) & 0x7f
}
func (o *NVMCTRL_Type) SetCTRLA_CMDEX(value uint16) {
	volatile.StoreUint16(&o.CTRLA.Reg, volatile.LoadUint16(&o.CTRLA.Reg)&^(0xff00)|value<<8)
}
func (o *NVMCTRL_Type) GetCTRLA_CMDEX() uint16 {
	return (volatile.LoadUint16(&o.CTRLA.Reg) & 0xff00) >> 8
}

// NVMCTRL.CTRLB: Control B
func (o *NVMCTRL_Type) SetCTRLB_RWS(value uint32) {
	volatile.StoreUint32(&o.CTRLB.Reg, volatile.LoadUint32(&o.CTRLB.Reg)&^(0x1e)|value<<1)
}
func (o *NVMCTRL_Type) GetCTRLB_RWS() uint32 {
	return (volatile.LoadUint32(&o.CTRLB.Reg) & 0x1e) >> 1
}
func (o *NVMCTRL_Type) SetCTRLB_MANW(value uint32) {
	volatile.StoreUint32(&o.CTRLB.Reg, volatile.LoadUint32(&o.CTRLB.Reg)&^(0x80)|value<<7)
}
func (o *NVMCTRL_Type) GetCTRLB_MANW() uint32 {
	return (volatile.LoadUint32(&o.CTRLB.Reg) & 0x80) >> 7
}
func (o *NVMCTRL_Type) SetCTRLB_SLEEPPRM(value uint32) {
	volatile.StoreUint32(&o.CTRLB.Reg, volatile.LoadUint32(&o.CTRLB.Reg)&^(0x300)|value<<8)
}
func (o *NVMCTRL_Type) GetCTRLB_SLEEPPRM() uint32 {
	return (volatile.LoadUint32(&o.CTRLB.Reg) & 0x300) >> 8
}
func (o *NVMCTRL_Type) SetCTRLB_FWUP(value uint32) {
	volatile.StoreUint32(&o.CTRLB.Reg, volatile.LoadUint32(&o.CTRLB.Reg)&^(0x800)|value<<11)
}
func (o *NVMCTRL_Type) GetCTRLB_FWUP() uint32 {
	return (volatile.LoadUint32(&o.CTRLB.Reg) & 0x800) >> 11
}
func (o *NVMCTRL_Type) SetCTRLB_READMODE(value uint32) {
	volatile.StoreUint32(&o.CTRLB.Reg, volatile.LoadUint32(&o.CTRLB.Reg)&^(0x30000)|value<<16)
}
func (o *NVMCTRL_Type) GetCTRLB_READMODE() uint32 {
	return (volatile.LoadUint32(&o.CTRLB.Reg) & 0x30000) >> 16
}
func (o *NVMCTRL_Type) SetCTRLB_CACHEDIS(value uint32) {
	volatile.StoreUint32(&o.CTRLB.Reg, volatile.LoadUint32(&o.CTRLB.Reg)&^(0x40000)|value<<18)
}
func (o *NVMCTRL_Type) GetCTRLB_CACHEDIS() uint32 {
	return (volatile.LoadUint32(&o.CTRLB.Reg) & 0x40000) >> 18
}

// NVMCTRL.PARAM: NVM Parameter
func (o *NVMCTRL_Type) SetPARAM_NVMP(value uint32) {
	volatile.StoreUint32(&o.PARAM.Reg, volatile.LoadUint32(&o.PARAM.Reg)&^(0xffff)|value)
}
func (o *NVMCTRL_Type) GetPARAM_NVMP() uint32 {
	return volatile.LoadUint32(&o.PARAM.Reg) & 0xffff
}
func (o *NVMCTRL_Type) SetPARAM_PSZ(value uint32) {
	volatile.StoreUint32(&o.PARAM.Reg, volatile.LoadUint32(&o.PARAM.Reg)&^(0x70000)|value<<16)
}
func (o *NVMCTRL_Type) GetPARAM_PSZ() uint32 {
	return (volatile.LoadUint32(&o.PARAM.Reg) & 0x70000) >> 16
}
func (o *NVMCTRL_Type) SetPARAM_RWWEEP(value uint32) {
	volatile.StoreUint32(&o.PARAM.Reg, volatile.LoadUint32(&o.PARAM.Reg)&^(0xfff00000)|value<<20)
}
func (o *NVMCTRL_Type) GetPARAM_RWWEEP() uint32 {
	return (volatile.LoadUint32(&o.PARAM.Reg) & 0xfff00000) >> 20
}

// NVMCTRL.INTENCLR: Interrupt Enable Clear
func (o *NVMCTRL_Type) SetINTENCLR_READY(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *NVMCTRL_Type) GetINTENCLR_READY() uint8 {
	return volatile.LoadUint8(&o.INTENCLR.Reg) & 0x1
}
func (o *NVMCTRL_Type) SetINTENCLR_ERROR(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *NVMCTRL_Type) GetINTENCLR_ERROR() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x2) >> 1
}

// NVMCTRL.INTENSET: Interrupt Enable Set
func (o *NVMCTRL_Type) SetINTENSET_READY(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *NVMCTRL_Type) GetINTENSET_READY() uint8 {
	return volatile.LoadUint8(&o.INTENSET.Reg) & 0x1
}
func (o *NVMCTRL_Type) SetINTENSET_ERROR(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *NVMCTRL_Type) GetINTENSET_ERROR() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x2) >> 1
}

// NVMCTRL.INTFLAG: Interrupt Flag Status and Clear
func (o *NVMCTRL_Type) SetINTFLAG_READY(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x1)|value)
}
func (o *NVMCTRL_Type) GetINTFLAG_READY() uint8 {
	return volatile.LoadUint8(&o.INTFLAG.Reg) & 0x1
}
func (o *NVMCTRL_Type) SetINTFLAG_ERROR(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x2)|value<<1)
}
func (o *NVMCTRL_Type) GetINTFLAG_ERROR() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x2) >> 1
}

// NVMCTRL.STATUS: Status
func (o *NVMCTRL_Type) SetSTATUS_PRM(value uint16) {
	volatile.StoreUint16(&o.STATUS.Reg, volatile.LoadUint16(&o.STATUS.Reg)&^(0x1)|value)
}
func (o *NVMCTRL_Type) GetSTATUS_PRM() uint16 {
	return volatile.LoadUint16(&o.STATUS.Reg) & 0x1
}
func (o *NVMCTRL_Type) SetSTATUS_LOAD(value uint16) {
	volatile.StoreUint16(&o.STATUS.Reg, volatile.LoadUint16(&o.STATUS.Reg)&^(0x2)|value<<1)
}
func (o *NVMCTRL_Type) GetSTATUS_LOAD() uint16 {
	return (volatile.LoadUint16(&o.STATUS.Reg) & 0x2) >> 1
}
func (o *NVMCTRL_Type) SetSTATUS_PROGE(value uint16) {
	volatile.StoreUint16(&o.STATUS.Reg, volatile.LoadUint16(&o.STATUS.Reg)&^(0x4)|value<<2)
}
func (o *NVMCTRL_Type) GetSTATUS_PROGE() uint16 {
	return (volatile.LoadUint16(&o.STATUS.Reg) & 0x4) >> 2
}
func (o *NVMCTRL_Type) SetSTATUS_LOCKE(value uint16) {
	volatile.StoreUint16(&o.STATUS.Reg, volatile.LoadUint16(&o.STATUS.Reg)&^(0x8)|value<<3)
}
func (o *NVMCTRL_Type) GetSTATUS_LOCKE() uint16 {
	return (volatile.LoadUint16(&o.STATUS.Reg) & 0x8) >> 3
}
func (o *NVMCTRL_Type) SetSTATUS_NVME(value uint16) {
	volatile.StoreUint16(&o.STATUS.Reg, volatile.LoadUint16(&o.STATUS.Reg)&^(0x10)|value<<4)
}
func (o *NVMCTRL_Type) GetSTATUS_NVME() uint16 {
	return (volatile.LoadUint16(&o.STATUS.Reg) & 0x10) >> 4
}
func (o *NVMCTRL_Type) SetSTATUS_SB(value uint16) {
	volatile.StoreUint16(&o.STATUS.Reg, volatile.LoadUint16(&o.STATUS.Reg)&^(0x100)|value<<8)
}
func (o *NVMCTRL_Type) GetSTATUS_SB() uint16 {
	return (volatile.LoadUint16(&o.STATUS.Reg) & 0x100) >> 8
}

// NVMCTRL.ADDR: Address
func (o *NVMCTRL_Type) SetADDR(value uint32) {
	volatile.StoreUint32(&o.ADDR.Reg, volatile.LoadUint32(&o.ADDR.Reg)&^(0x3fffff)|value)
}
func (o *NVMCTRL_Type) GetADDR() uint32 {
	return volatile.LoadUint32(&o.ADDR.Reg) & 0x3fffff
}

// NVMCTRL.LOCK: Lock Section
func (o *NVMCTRL_Type) SetLOCK(value uint16) {
	volatile.StoreUint16(&o.LOCK.Reg, value)
}
func (o *NVMCTRL_Type) GetLOCK() uint16 {
	return volatile.LoadUint16(&o.LOCK.Reg)
}

// Oscillators Control
type OSCCTRL_Type struct {
	INTENCLR     volatile.Register32 // 0x0
	INTENSET     volatile.Register32 // 0x4
	INTFLAG      volatile.Register32 // 0x8
	STATUS       volatile.Register32 // 0xC
	XOSCCTRL     volatile.Register16 // 0x10
	CFDPRESC     volatile.Register8  // 0x12
	EVCTRL       volatile.Register8  // 0x13
	OSC16MCTRL   volatile.Register8  // 0x14
	_            [3]byte
	DFLLCTRL     volatile.Register16 // 0x18
	_            [2]byte
	DFLLVAL      volatile.Register32 // 0x1C
	DFLLMUL      volatile.Register32 // 0x20
	DFLLSYNC     volatile.Register8  // 0x24
	_            [3]byte
	DPLLCTRLA    volatile.Register8 // 0x28
	_            [3]byte
	DPLLRATIO    volatile.Register32 // 0x2C
	DPLLCTRLB    volatile.Register32 // 0x30
	DPLLPRESC    volatile.Register8  // 0x34
	_            [3]byte
	DPLLSYNCBUSY volatile.Register8 // 0x38
	_            [3]byte
	DPLLSTATUS   volatile.Register8 // 0x3C
}

// OSCCTRL.INTENCLR: Interrupt Enable Clear
func (o *OSCCTRL_Type) SetINTENCLR_XOSCRDY(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *OSCCTRL_Type) GetINTENCLR_XOSCRDY() uint32 {
	return volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1
}
func (o *OSCCTRL_Type) SetINTENCLR_XOSCFAIL(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *OSCCTRL_Type) GetINTENCLR_XOSCFAIL() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *OSCCTRL_Type) SetINTENCLR_OSC16MRDY(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x10)|value<<4)
}
func (o *OSCCTRL_Type) GetINTENCLR_OSC16MRDY() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x10) >> 4
}
func (o *OSCCTRL_Type) SetINTENCLR_DFLLRDY(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x100)|value<<8)
}
func (o *OSCCTRL_Type) GetINTENCLR_DFLLRDY() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x100) >> 8
}
func (o *OSCCTRL_Type) SetINTENCLR_DFLLOOB(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x200)|value<<9)
}
func (o *OSCCTRL_Type) GetINTENCLR_DFLLOOB() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x200) >> 9
}
func (o *OSCCTRL_Type) SetINTENCLR_DFLLLCKF(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x400)|value<<10)
}
func (o *OSCCTRL_Type) GetINTENCLR_DFLLLCKF() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x400) >> 10
}
func (o *OSCCTRL_Type) SetINTENCLR_DFLLLCKC(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x800)|value<<11)
}
func (o *OSCCTRL_Type) GetINTENCLR_DFLLLCKC() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x800) >> 11
}
func (o *OSCCTRL_Type) SetINTENCLR_DFLLRCS(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1000)|value<<12)
}
func (o *OSCCTRL_Type) GetINTENCLR_DFLLRCS() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1000) >> 12
}
func (o *OSCCTRL_Type) SetINTENCLR_DPLLLCKR(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x10000)|value<<16)
}
func (o *OSCCTRL_Type) GetINTENCLR_DPLLLCKR() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x10000) >> 16
}
func (o *OSCCTRL_Type) SetINTENCLR_DPLLLCKF(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x20000)|value<<17)
}
func (o *OSCCTRL_Type) GetINTENCLR_DPLLLCKF() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x20000) >> 17
}
func (o *OSCCTRL_Type) SetINTENCLR_DPLLLTO(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x40000)|value<<18)
}
func (o *OSCCTRL_Type) GetINTENCLR_DPLLLTO() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x40000) >> 18
}
func (o *OSCCTRL_Type) SetINTENCLR_DPLLLDRTO(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x80000)|value<<19)
}
func (o *OSCCTRL_Type) GetINTENCLR_DPLLLDRTO() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x80000) >> 19
}

// OSCCTRL.INTENSET: Interrupt Enable Set
func (o *OSCCTRL_Type) SetINTENSET_XOSCRDY(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *OSCCTRL_Type) GetINTENSET_XOSCRDY() uint32 {
	return volatile.LoadUint32(&o.INTENSET.Reg) & 0x1
}
func (o *OSCCTRL_Type) SetINTENSET_XOSCFAIL(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *OSCCTRL_Type) GetINTENSET_XOSCFAIL() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *OSCCTRL_Type) SetINTENSET_OSC16MRDY(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x10)|value<<4)
}
func (o *OSCCTRL_Type) GetINTENSET_OSC16MRDY() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x10) >> 4
}
func (o *OSCCTRL_Type) SetINTENSET_DFLLRDY(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x100)|value<<8)
}
func (o *OSCCTRL_Type) GetINTENSET_DFLLRDY() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x100) >> 8
}
func (o *OSCCTRL_Type) SetINTENSET_DFLLOOB(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x200)|value<<9)
}
func (o *OSCCTRL_Type) GetINTENSET_DFLLOOB() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x200) >> 9
}
func (o *OSCCTRL_Type) SetINTENSET_DFLLLCKF(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x400)|value<<10)
}
func (o *OSCCTRL_Type) GetINTENSET_DFLLLCKF() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x400) >> 10
}
func (o *OSCCTRL_Type) SetINTENSET_DFLLLCKC(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x800)|value<<11)
}
func (o *OSCCTRL_Type) GetINTENSET_DFLLLCKC() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x800) >> 11
}
func (o *OSCCTRL_Type) SetINTENSET_DFLLRCS(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1000)|value<<12)
}
func (o *OSCCTRL_Type) GetINTENSET_DFLLRCS() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x1000) >> 12
}
func (o *OSCCTRL_Type) SetINTENSET_DPLLLCKR(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x10000)|value<<16)
}
func (o *OSCCTRL_Type) GetINTENSET_DPLLLCKR() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x10000) >> 16
}
func (o *OSCCTRL_Type) SetINTENSET_DPLLLCKF(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x20000)|value<<17)
}
func (o *OSCCTRL_Type) GetINTENSET_DPLLLCKF() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x20000) >> 17
}
func (o *OSCCTRL_Type) SetINTENSET_DPLLLTO(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x40000)|value<<18)
}
func (o *OSCCTRL_Type) GetINTENSET_DPLLLTO() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x40000) >> 18
}
func (o *OSCCTRL_Type) SetINTENSET_DPLLLDRTO(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x80000)|value<<19)
}
func (o *OSCCTRL_Type) GetINTENSET_DPLLLDRTO() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x80000) >> 19
}

// OSCCTRL.INTFLAG: Interrupt Flag Status and Clear
func (o *OSCCTRL_Type) SetINTFLAG_XOSCRDY(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x1)|value)
}
func (o *OSCCTRL_Type) GetINTFLAG_XOSCRDY() uint32 {
	return volatile.LoadUint32(&o.INTFLAG.Reg) & 0x1
}
func (o *OSCCTRL_Type) SetINTFLAG_XOSCFAIL(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x2)|value<<1)
}
func (o *OSCCTRL_Type) GetINTFLAG_XOSCFAIL() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x2) >> 1
}
func (o *OSCCTRL_Type) SetINTFLAG_OSC16MRDY(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x10)|value<<4)
}
func (o *OSCCTRL_Type) GetINTFLAG_OSC16MRDY() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x10) >> 4
}
func (o *OSCCTRL_Type) SetINTFLAG_DFLLRDY(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x100)|value<<8)
}
func (o *OSCCTRL_Type) GetINTFLAG_DFLLRDY() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x100) >> 8
}
func (o *OSCCTRL_Type) SetINTFLAG_DFLLOOB(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x200)|value<<9)
}
func (o *OSCCTRL_Type) GetINTFLAG_DFLLOOB() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x200) >> 9
}
func (o *OSCCTRL_Type) SetINTFLAG_DFLLLCKF(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x400)|value<<10)
}
func (o *OSCCTRL_Type) GetINTFLAG_DFLLLCKF() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x400) >> 10
}
func (o *OSCCTRL_Type) SetINTFLAG_DFLLLCKC(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x800)|value<<11)
}
func (o *OSCCTRL_Type) GetINTFLAG_DFLLLCKC() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x800) >> 11
}
func (o *OSCCTRL_Type) SetINTFLAG_DFLLRCS(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x1000)|value<<12)
}
func (o *OSCCTRL_Type) GetINTFLAG_DFLLRCS() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x1000) >> 12
}
func (o *OSCCTRL_Type) SetINTFLAG_DPLLLCKR(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x10000)|value<<16)
}
func (o *OSCCTRL_Type) GetINTFLAG_DPLLLCKR() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x10000) >> 16
}
func (o *OSCCTRL_Type) SetINTFLAG_DPLLLCKF(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x20000)|value<<17)
}
func (o *OSCCTRL_Type) GetINTFLAG_DPLLLCKF() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x20000) >> 17
}
func (o *OSCCTRL_Type) SetINTFLAG_DPLLLTO(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x40000)|value<<18)
}
func (o *OSCCTRL_Type) GetINTFLAG_DPLLLTO() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x40000) >> 18
}
func (o *OSCCTRL_Type) SetINTFLAG_DPLLLDRTO(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x80000)|value<<19)
}
func (o *OSCCTRL_Type) GetINTFLAG_DPLLLDRTO() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x80000) >> 19
}

// OSCCTRL.STATUS: Power and Clocks Status
func (o *OSCCTRL_Type) SetSTATUS_XOSCRDY(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x1)|value)
}
func (o *OSCCTRL_Type) GetSTATUS_XOSCRDY() uint32 {
	return volatile.LoadUint32(&o.STATUS.Reg) & 0x1
}
func (o *OSCCTRL_Type) SetSTATUS_XOSCFAIL(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x2)|value<<1)
}
func (o *OSCCTRL_Type) GetSTATUS_XOSCFAIL() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x2) >> 1
}
func (o *OSCCTRL_Type) SetSTATUS_XOSCCKSW(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x4)|value<<2)
}
func (o *OSCCTRL_Type) GetSTATUS_XOSCCKSW() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x4) >> 2
}
func (o *OSCCTRL_Type) SetSTATUS_OSC16MRDY(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x10)|value<<4)
}
func (o *OSCCTRL_Type) GetSTATUS_OSC16MRDY() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x10) >> 4
}
func (o *OSCCTRL_Type) SetSTATUS_DFLLRDY(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x100)|value<<8)
}
func (o *OSCCTRL_Type) GetSTATUS_DFLLRDY() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x100) >> 8
}
func (o *OSCCTRL_Type) SetSTATUS_DFLLOOB(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x200)|value<<9)
}
func (o *OSCCTRL_Type) GetSTATUS_DFLLOOB() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x200) >> 9
}
func (o *OSCCTRL_Type) SetSTATUS_DFLLLCKF(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x400)|value<<10)
}
func (o *OSCCTRL_Type) GetSTATUS_DFLLLCKF() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x400) >> 10
}
func (o *OSCCTRL_Type) SetSTATUS_DFLLLCKC(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x800)|value<<11)
}
func (o *OSCCTRL_Type) GetSTATUS_DFLLLCKC() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x800) >> 11
}
func (o *OSCCTRL_Type) SetSTATUS_DFLLRCS(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x1000)|value<<12)
}
func (o *OSCCTRL_Type) GetSTATUS_DFLLRCS() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x1000) >> 12
}
func (o *OSCCTRL_Type) SetSTATUS_DPLLLCKR(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x10000)|value<<16)
}
func (o *OSCCTRL_Type) GetSTATUS_DPLLLCKR() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x10000) >> 16
}
func (o *OSCCTRL_Type) SetSTATUS_DPLLLCKF(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x20000)|value<<17)
}
func (o *OSCCTRL_Type) GetSTATUS_DPLLLCKF() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x20000) >> 17
}
func (o *OSCCTRL_Type) SetSTATUS_DPLLTO(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x40000)|value<<18)
}
func (o *OSCCTRL_Type) GetSTATUS_DPLLTO() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x40000) >> 18
}
func (o *OSCCTRL_Type) SetSTATUS_DPLLLDRTO(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x80000)|value<<19)
}
func (o *OSCCTRL_Type) GetSTATUS_DPLLLDRTO() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x80000) >> 19
}

// OSCCTRL.XOSCCTRL: External Multipurpose Crystal Oscillator (XOSC) Control
func (o *OSCCTRL_Type) SetXOSCCTRL_ENABLE(value uint16) {
	volatile.StoreUint16(&o.XOSCCTRL.Reg, volatile.LoadUint16(&o.XOSCCTRL.Reg)&^(0x2)|value<<1)
}
func (o *OSCCTRL_Type) GetXOSCCTRL_ENABLE() uint16 {
	return (volatile.LoadUint16(&o.XOSCCTRL.Reg) & 0x2) >> 1
}
func (o *OSCCTRL_Type) SetXOSCCTRL_XTALEN(value uint16) {
	volatile.StoreUint16(&o.XOSCCTRL.Reg, volatile.LoadUint16(&o.XOSCCTRL.Reg)&^(0x4)|value<<2)
}
func (o *OSCCTRL_Type) GetXOSCCTRL_XTALEN() uint16 {
	return (volatile.LoadUint16(&o.XOSCCTRL.Reg) & 0x4) >> 2
}
func (o *OSCCTRL_Type) SetXOSCCTRL_CFDEN(value uint16) {
	volatile.StoreUint16(&o.XOSCCTRL.Reg, volatile.LoadUint16(&o.XOSCCTRL.Reg)&^(0x8)|value<<3)
}
func (o *OSCCTRL_Type) GetXOSCCTRL_CFDEN() uint16 {
	return (volatile.LoadUint16(&o.XOSCCTRL.Reg) & 0x8) >> 3
}
func (o *OSCCTRL_Type) SetXOSCCTRL_SWBEN(value uint16) {
	volatile.StoreUint16(&o.XOSCCTRL.Reg, volatile.LoadUint16(&o.XOSCCTRL.Reg)&^(0x10)|value<<4)
}
func (o *OSCCTRL_Type) GetXOSCCTRL_SWBEN() uint16 {
	return (volatile.LoadUint16(&o.XOSCCTRL.Reg) & 0x10) >> 4
}
func (o *OSCCTRL_Type) SetXOSCCTRL_RUNSTDBY(value uint16) {
	volatile.StoreUint16(&o.XOSCCTRL.Reg, volatile.LoadUint16(&o.XOSCCTRL.Reg)&^(0x40)|value<<6)
}
func (o *OSCCTRL_Type) GetXOSCCTRL_RUNSTDBY() uint16 {
	return (volatile.LoadUint16(&o.XOSCCTRL.Reg) & 0x40) >> 6
}
func (o *OSCCTRL_Type) SetXOSCCTRL_ONDEMAND(value uint16) {
	volatile.StoreUint16(&o.XOSCCTRL.Reg, volatile.LoadUint16(&o.XOSCCTRL.Reg)&^(0x80)|value<<7)
}
func (o *OSCCTRL_Type) GetXOSCCTRL_ONDEMAND() uint16 {
	return (volatile.LoadUint16(&o.XOSCCTRL.Reg) & 0x80) >> 7
}
func (o *OSCCTRL_Type) SetXOSCCTRL_GAIN(value uint16) {
	volatile.StoreUint16(&o.XOSCCTRL.Reg, volatile.LoadUint16(&o.XOSCCTRL.Reg)&^(0x700)|value<<8)
}
func (o *OSCCTRL_Type) GetXOSCCTRL_GAIN() uint16 {
	return (volatile.LoadUint16(&o.XOSCCTRL.Reg) & 0x700) >> 8
}
func (o *OSCCTRL_Type) SetXOSCCTRL_AMPGC(value uint16) {
	volatile.StoreUint16(&o.XOSCCTRL.Reg, volatile.LoadUint16(&o.XOSCCTRL.Reg)&^(0x800)|value<<11)
}
func (o *OSCCTRL_Type) GetXOSCCTRL_AMPGC() uint16 {
	return (volatile.LoadUint16(&o.XOSCCTRL.Reg) & 0x800) >> 11
}
func (o *OSCCTRL_Type) SetXOSCCTRL_STARTUP(value uint16) {
	volatile.StoreUint16(&o.XOSCCTRL.Reg, volatile.LoadUint16(&o.XOSCCTRL.Reg)&^(0xf000)|value<<12)
}
func (o *OSCCTRL_Type) GetXOSCCTRL_STARTUP() uint16 {
	return (volatile.LoadUint16(&o.XOSCCTRL.Reg) & 0xf000) >> 12
}

// OSCCTRL.CFDPRESC: Cloc Failure Detector Prescaler
func (o *OSCCTRL_Type) SetCFDPRESC(value uint8) {
	volatile.StoreUint8(&o.CFDPRESC.Reg, volatile.LoadUint8(&o.CFDPRESC.Reg)&^(0x7)|value)
}
func (o *OSCCTRL_Type) GetCFDPRESC() uint8 {
	return volatile.LoadUint8(&o.CFDPRESC.Reg) & 0x7
}

// OSCCTRL.EVCTRL: Event Control
func (o *OSCCTRL_Type) SetEVCTRL_CFDEO(value uint8) {
	volatile.StoreUint8(&o.EVCTRL.Reg, volatile.LoadUint8(&o.EVCTRL.Reg)&^(0x1)|value)
}
func (o *OSCCTRL_Type) GetEVCTRL_CFDEO() uint8 {
	return volatile.LoadUint8(&o.EVCTRL.Reg) & 0x1
}

// OSCCTRL.OSC16MCTRL: 16MHz Internal Oscillator (OSC16M) Control
func (o *OSCCTRL_Type) SetOSC16MCTRL_ENABLE(value uint8) {
	volatile.StoreUint8(&o.OSC16MCTRL.Reg, volatile.LoadUint8(&o.OSC16MCTRL.Reg)&^(0x2)|value<<1)
}
func (o *OSCCTRL_Type) GetOSC16MCTRL_ENABLE() uint8 {
	return (volatile.LoadUint8(&o.OSC16MCTRL.Reg) & 0x2) >> 1
}
func (o *OSCCTRL_Type) SetOSC16MCTRL_FSEL(value uint8) {
	volatile.StoreUint8(&o.OSC16MCTRL.Reg, volatile.LoadUint8(&o.OSC16MCTRL.Reg)&^(0xc)|value<<2)
}
func (o *OSCCTRL_Type) GetOSC16MCTRL_FSEL() uint8 {
	return (volatile.LoadUint8(&o.OSC16MCTRL.Reg) & 0xc) >> 2
}
func (o *OSCCTRL_Type) SetOSC16MCTRL_RUNSTDBY(value uint8) {
	volatile.StoreUint8(&o.OSC16MCTRL.Reg, volatile.LoadUint8(&o.OSC16MCTRL.Reg)&^(0x40)|value<<6)
}
func (o *OSCCTRL_Type) GetOSC16MCTRL_RUNSTDBY() uint8 {
	return (volatile.LoadUint8(&o.OSC16MCTRL.Reg) & 0x40) >> 6
}
func (o *OSCCTRL_Type) SetOSC16MCTRL_ONDEMAND(value uint8) {
	volatile.StoreUint8(&o.OSC16MCTRL.Reg, volatile.LoadUint8(&o.OSC16MCTRL.Reg)&^(0x80)|value<<7)
}
func (o *OSCCTRL_Type) GetOSC16MCTRL_ONDEMAND() uint8 {
	return (volatile.LoadUint8(&o.OSC16MCTRL.Reg) & 0x80) >> 7
}

// OSCCTRL.DFLLCTRL: DFLL48M Control
func (o *OSCCTRL_Type) SetDFLLCTRL_ENABLE(value uint16) {
	volatile.StoreUint16(&o.DFLLCTRL.Reg, volatile.LoadUint16(&o.DFLLCTRL.Reg)&^(0x2)|value<<1)
}
func (o *OSCCTRL_Type) GetDFLLCTRL_ENABLE() uint16 {
	return (volatile.LoadUint16(&o.DFLLCTRL.Reg) & 0x2) >> 1
}
func (o *OSCCTRL_Type) SetDFLLCTRL_MODE(value uint16) {
	volatile.StoreUint16(&o.DFLLCTRL.Reg, volatile.LoadUint16(&o.DFLLCTRL.Reg)&^(0x4)|value<<2)
}
func (o *OSCCTRL_Type) GetDFLLCTRL_MODE() uint16 {
	return (volatile.LoadUint16(&o.DFLLCTRL.Reg) & 0x4) >> 2
}
func (o *OSCCTRL_Type) SetDFLLCTRL_STABLE(value uint16) {
	volatile.StoreUint16(&o.DFLLCTRL.Reg, volatile.LoadUint16(&o.DFLLCTRL.Reg)&^(0x8)|value<<3)
}
func (o *OSCCTRL_Type) GetDFLLCTRL_STABLE() uint16 {
	return (volatile.LoadUint16(&o.DFLLCTRL.Reg) & 0x8) >> 3
}
func (o *OSCCTRL_Type) SetDFLLCTRL_LLAW(value uint16) {
	volatile.StoreUint16(&o.DFLLCTRL.Reg, volatile.LoadUint16(&o.DFLLCTRL.Reg)&^(0x10)|value<<4)
}
func (o *OSCCTRL_Type) GetDFLLCTRL_LLAW() uint16 {
	return (volatile.LoadUint16(&o.DFLLCTRL.Reg) & 0x10) >> 4
}
func (o *OSCCTRL_Type) SetDFLLCTRL_USBCRM(value uint16) {
	volatile.StoreUint16(&o.DFLLCTRL.Reg, volatile.LoadUint16(&o.DFLLCTRL.Reg)&^(0x20)|value<<5)
}
func (o *OSCCTRL_Type) GetDFLLCTRL_USBCRM() uint16 {
	return (volatile.LoadUint16(&o.DFLLCTRL.Reg) & 0x20) >> 5
}
func (o *OSCCTRL_Type) SetDFLLCTRL_RUNSTDBY(value uint16) {
	volatile.StoreUint16(&o.DFLLCTRL.Reg, volatile.LoadUint16(&o.DFLLCTRL.Reg)&^(0x40)|value<<6)
}
func (o *OSCCTRL_Type) GetDFLLCTRL_RUNSTDBY() uint16 {
	return (volatile.LoadUint16(&o.DFLLCTRL.Reg) & 0x40) >> 6
}
func (o *OSCCTRL_Type) SetDFLLCTRL_ONDEMAND(value uint16) {
	volatile.StoreUint16(&o.DFLLCTRL.Reg, volatile.LoadUint16(&o.DFLLCTRL.Reg)&^(0x80)|value<<7)
}
func (o *OSCCTRL_Type) GetDFLLCTRL_ONDEMAND() uint16 {
	return (volatile.LoadUint16(&o.DFLLCTRL.Reg) & 0x80) >> 7
}
func (o *OSCCTRL_Type) SetDFLLCTRL_CCDIS(value uint16) {
	volatile.StoreUint16(&o.DFLLCTRL.Reg, volatile.LoadUint16(&o.DFLLCTRL.Reg)&^(0x100)|value<<8)
}
func (o *OSCCTRL_Type) GetDFLLCTRL_CCDIS() uint16 {
	return (volatile.LoadUint16(&o.DFLLCTRL.Reg) & 0x100) >> 8
}
func (o *OSCCTRL_Type) SetDFLLCTRL_QLDIS(value uint16) {
	volatile.StoreUint16(&o.DFLLCTRL.Reg, volatile.LoadUint16(&o.DFLLCTRL.Reg)&^(0x200)|value<<9)
}
func (o *OSCCTRL_Type) GetDFLLCTRL_QLDIS() uint16 {
	return (volatile.LoadUint16(&o.DFLLCTRL.Reg) & 0x200) >> 9
}
func (o *OSCCTRL_Type) SetDFLLCTRL_BPLCKC(value uint16) {
	volatile.StoreUint16(&o.DFLLCTRL.Reg, volatile.LoadUint16(&o.DFLLCTRL.Reg)&^(0x400)|value<<10)
}
func (o *OSCCTRL_Type) GetDFLLCTRL_BPLCKC() uint16 {
	return (volatile.LoadUint16(&o.DFLLCTRL.Reg) & 0x400) >> 10
}
func (o *OSCCTRL_Type) SetDFLLCTRL_WAITLOCK(value uint16) {
	volatile.StoreUint16(&o.DFLLCTRL.Reg, volatile.LoadUint16(&o.DFLLCTRL.Reg)&^(0x800)|value<<11)
}
func (o *OSCCTRL_Type) GetDFLLCTRL_WAITLOCK() uint16 {
	return (volatile.LoadUint16(&o.DFLLCTRL.Reg) & 0x800) >> 11
}

// OSCCTRL.DFLLVAL: DFLL48M Value
func (o *OSCCTRL_Type) SetDFLLVAL_FINE(value uint32) {
	volatile.StoreUint32(&o.DFLLVAL.Reg, volatile.LoadUint32(&o.DFLLVAL.Reg)&^(0x3ff)|value)
}
func (o *OSCCTRL_Type) GetDFLLVAL_FINE() uint32 {
	return volatile.LoadUint32(&o.DFLLVAL.Reg) & 0x3ff
}
func (o *OSCCTRL_Type) SetDFLLVAL_COARSE(value uint32) {
	volatile.StoreUint32(&o.DFLLVAL.Reg, volatile.LoadUint32(&o.DFLLVAL.Reg)&^(0xfc00)|value<<10)
}
func (o *OSCCTRL_Type) GetDFLLVAL_COARSE() uint32 {
	return (volatile.LoadUint32(&o.DFLLVAL.Reg) & 0xfc00) >> 10
}
func (o *OSCCTRL_Type) SetDFLLVAL_DIFF(value uint32) {
	volatile.StoreUint32(&o.DFLLVAL.Reg, volatile.LoadUint32(&o.DFLLVAL.Reg)&^(0xffff0000)|value<<16)
}
func (o *OSCCTRL_Type) GetDFLLVAL_DIFF() uint32 {
	return (volatile.LoadUint32(&o.DFLLVAL.Reg) & 0xffff0000) >> 16
}

// OSCCTRL.DFLLMUL: DFLL48M Multiplier
func (o *OSCCTRL_Type) SetDFLLMUL_MUL(value uint32) {
	volatile.StoreUint32(&o.DFLLMUL.Reg, volatile.LoadUint32(&o.DFLLMUL.Reg)&^(0xffff)|value)
}
func (o *OSCCTRL_Type) GetDFLLMUL_MUL() uint32 {
	return volatile.LoadUint32(&o.DFLLMUL.Reg) & 0xffff
}
func (o *OSCCTRL_Type) SetDFLLMUL_FSTEP(value uint32) {
	volatile.StoreUint32(&o.DFLLMUL.Reg, volatile.LoadUint32(&o.DFLLMUL.Reg)&^(0x3ff0000)|value<<16)
}
func (o *OSCCTRL_Type) GetDFLLMUL_FSTEP() uint32 {
	return (volatile.LoadUint32(&o.DFLLMUL.Reg) & 0x3ff0000) >> 16
}
func (o *OSCCTRL_Type) SetDFLLMUL_CSTEP(value uint32) {
	volatile.StoreUint32(&o.DFLLMUL.Reg, volatile.LoadUint32(&o.DFLLMUL.Reg)&^(0xfc000000)|value<<26)
}
func (o *OSCCTRL_Type) GetDFLLMUL_CSTEP() uint32 {
	return (volatile.LoadUint32(&o.DFLLMUL.Reg) & 0xfc000000) >> 26
}

// OSCCTRL.DFLLSYNC: DFLL48M Synchronization
func (o *OSCCTRL_Type) SetDFLLSYNC_READREQ(value uint8) {
	volatile.StoreUint8(&o.DFLLSYNC.Reg, volatile.LoadUint8(&o.DFLLSYNC.Reg)&^(0x80)|value<<7)
}
func (o *OSCCTRL_Type) GetDFLLSYNC_READREQ() uint8 {
	return (volatile.LoadUint8(&o.DFLLSYNC.Reg) & 0x80) >> 7
}

// OSCCTRL.DPLLCTRLA: DPLL Control
func (o *OSCCTRL_Type) SetDPLLCTRLA_ENABLE(value uint8) {
	volatile.StoreUint8(&o.DPLLCTRLA.Reg, volatile.LoadUint8(&o.DPLLCTRLA.Reg)&^(0x2)|value<<1)
}
func (o *OSCCTRL_Type) GetDPLLCTRLA_ENABLE() uint8 {
	return (volatile.LoadUint8(&o.DPLLCTRLA.Reg) & 0x2) >> 1
}
func (o *OSCCTRL_Type) SetDPLLCTRLA_RUNSTDBY(value uint8) {
	volatile.StoreUint8(&o.DPLLCTRLA.Reg, volatile.LoadUint8(&o.DPLLCTRLA.Reg)&^(0x40)|value<<6)
}
func (o *OSCCTRL_Type) GetDPLLCTRLA_RUNSTDBY() uint8 {
	return (volatile.LoadUint8(&o.DPLLCTRLA.Reg) & 0x40) >> 6
}
func (o *OSCCTRL_Type) SetDPLLCTRLA_ONDEMAND(value uint8) {
	volatile.StoreUint8(&o.DPLLCTRLA.Reg, volatile.LoadUint8(&o.DPLLCTRLA.Reg)&^(0x80)|value<<7)
}
func (o *OSCCTRL_Type) GetDPLLCTRLA_ONDEMAND() uint8 {
	return (volatile.LoadUint8(&o.DPLLCTRLA.Reg) & 0x80) >> 7
}

// OSCCTRL.DPLLRATIO: DPLL Ratio Control
func (o *OSCCTRL_Type) SetDPLLRATIO_LDR(value uint32) {
	volatile.StoreUint32(&o.DPLLRATIO.Reg, volatile.LoadUint32(&o.DPLLRATIO.Reg)&^(0xfff)|value)
}
func (o *OSCCTRL_Type) GetDPLLRATIO_LDR() uint32 {
	return volatile.LoadUint32(&o.DPLLRATIO.Reg) & 0xfff
}
func (o *OSCCTRL_Type) SetDPLLRATIO_LDRFRAC(value uint32) {
	volatile.StoreUint32(&o.DPLLRATIO.Reg, volatile.LoadUint32(&o.DPLLRATIO.Reg)&^(0xf0000)|value<<16)
}
func (o *OSCCTRL_Type) GetDPLLRATIO_LDRFRAC() uint32 {
	return (volatile.LoadUint32(&o.DPLLRATIO.Reg) & 0xf0000) >> 16
}

// OSCCTRL.DPLLCTRLB: Digital Core Configuration
func (o *OSCCTRL_Type) SetDPLLCTRLB_FILTER(value uint32) {
	volatile.StoreUint32(&o.DPLLCTRLB.Reg, volatile.LoadUint32(&o.DPLLCTRLB.Reg)&^(0x3)|value)
}
func (o *OSCCTRL_Type) GetDPLLCTRLB_FILTER() uint32 {
	return volatile.LoadUint32(&o.DPLLCTRLB.Reg) & 0x3
}
func (o *OSCCTRL_Type) SetDPLLCTRLB_LPEN(value uint32) {
	volatile.StoreUint32(&o.DPLLCTRLB.Reg, volatile.LoadUint32(&o.DPLLCTRLB.Reg)&^(0x4)|value<<2)
}
func (o *OSCCTRL_Type) GetDPLLCTRLB_LPEN() uint32 {
	return (volatile.LoadUint32(&o.DPLLCTRLB.Reg) & 0x4) >> 2
}
func (o *OSCCTRL_Type) SetDPLLCTRLB_WUF(value uint32) {
	volatile.StoreUint32(&o.DPLLCTRLB.Reg, volatile.LoadUint32(&o.DPLLCTRLB.Reg)&^(0x8)|value<<3)
}
func (o *OSCCTRL_Type) GetDPLLCTRLB_WUF() uint32 {
	return (volatile.LoadUint32(&o.DPLLCTRLB.Reg) & 0x8) >> 3
}
func (o *OSCCTRL_Type) SetDPLLCTRLB_REFCLK(value uint32) {
	volatile.StoreUint32(&o.DPLLCTRLB.Reg, volatile.LoadUint32(&o.DPLLCTRLB.Reg)&^(0x30)|value<<4)
}
func (o *OSCCTRL_Type) GetDPLLCTRLB_REFCLK() uint32 {
	return (volatile.LoadUint32(&o.DPLLCTRLB.Reg) & 0x30) >> 4
}
func (o *OSCCTRL_Type) SetDPLLCTRLB_LTIME(value uint32) {
	volatile.StoreUint32(&o.DPLLCTRLB.Reg, volatile.LoadUint32(&o.DPLLCTRLB.Reg)&^(0x700)|value<<8)
}
func (o *OSCCTRL_Type) GetDPLLCTRLB_LTIME() uint32 {
	return (volatile.LoadUint32(&o.DPLLCTRLB.Reg) & 0x700) >> 8
}
func (o *OSCCTRL_Type) SetDPLLCTRLB_LBYPASS(value uint32) {
	volatile.StoreUint32(&o.DPLLCTRLB.Reg, volatile.LoadUint32(&o.DPLLCTRLB.Reg)&^(0x1000)|value<<12)
}
func (o *OSCCTRL_Type) GetDPLLCTRLB_LBYPASS() uint32 {
	return (volatile.LoadUint32(&o.DPLLCTRLB.Reg) & 0x1000) >> 12
}
func (o *OSCCTRL_Type) SetDPLLCTRLB_DIV(value uint32) {
	volatile.StoreUint32(&o.DPLLCTRLB.Reg, volatile.LoadUint32(&o.DPLLCTRLB.Reg)&^(0x7ff0000)|value<<16)
}
func (o *OSCCTRL_Type) GetDPLLCTRLB_DIV() uint32 {
	return (volatile.LoadUint32(&o.DPLLCTRLB.Reg) & 0x7ff0000) >> 16
}

// OSCCTRL.DPLLPRESC: DPLL Prescaler
func (o *OSCCTRL_Type) SetDPLLPRESC_PRESC(value uint8) {
	volatile.StoreUint8(&o.DPLLPRESC.Reg, volatile.LoadUint8(&o.DPLLPRESC.Reg)&^(0x3)|value)
}
func (o *OSCCTRL_Type) GetDPLLPRESC_PRESC() uint8 {
	return volatile.LoadUint8(&o.DPLLPRESC.Reg) & 0x3
}

// OSCCTRL.DPLLSYNCBUSY: DPLL Synchronization Busy
func (o *OSCCTRL_Type) SetDPLLSYNCBUSY_ENABLE(value uint8) {
	volatile.StoreUint8(&o.DPLLSYNCBUSY.Reg, volatile.LoadUint8(&o.DPLLSYNCBUSY.Reg)&^(0x2)|value<<1)
}
func (o *OSCCTRL_Type) GetDPLLSYNCBUSY_ENABLE() uint8 {
	return (volatile.LoadUint8(&o.DPLLSYNCBUSY.Reg) & 0x2) >> 1
}
func (o *OSCCTRL_Type) SetDPLLSYNCBUSY_DPLLRATIO(value uint8) {
	volatile.StoreUint8(&o.DPLLSYNCBUSY.Reg, volatile.LoadUint8(&o.DPLLSYNCBUSY.Reg)&^(0x4)|value<<2)
}
func (o *OSCCTRL_Type) GetDPLLSYNCBUSY_DPLLRATIO() uint8 {
	return (volatile.LoadUint8(&o.DPLLSYNCBUSY.Reg) & 0x4) >> 2
}
func (o *OSCCTRL_Type) SetDPLLSYNCBUSY_DPLLPRESC(value uint8) {
	volatile.StoreUint8(&o.DPLLSYNCBUSY.Reg, volatile.LoadUint8(&o.DPLLSYNCBUSY.Reg)&^(0x8)|value<<3)
}
func (o *OSCCTRL_Type) GetDPLLSYNCBUSY_DPLLPRESC() uint8 {
	return (volatile.LoadUint8(&o.DPLLSYNCBUSY.Reg) & 0x8) >> 3
}

// OSCCTRL.DPLLSTATUS: DPLL Status
func (o *OSCCTRL_Type) SetDPLLSTATUS_LOCK(value uint8) {
	volatile.StoreUint8(&o.DPLLSTATUS.Reg, volatile.LoadUint8(&o.DPLLSTATUS.Reg)&^(0x1)|value)
}
func (o *OSCCTRL_Type) GetDPLLSTATUS_LOCK() uint8 {
	return volatile.LoadUint8(&o.DPLLSTATUS.Reg) & 0x1
}
func (o *OSCCTRL_Type) SetDPLLSTATUS_CLKRDY(value uint8) {
	volatile.StoreUint8(&o.DPLLSTATUS.Reg, volatile.LoadUint8(&o.DPLLSTATUS.Reg)&^(0x2)|value<<1)
}
func (o *OSCCTRL_Type) GetDPLLSTATUS_CLKRDY() uint8 {
	return (volatile.LoadUint8(&o.DPLLSTATUS.Reg) & 0x2) >> 1
}

// 32k Oscillators Control
type OSC32KCTRL_Type struct {
	INTENCLR  volatile.Register32 // 0x0
	INTENSET  volatile.Register32 // 0x4
	INTFLAG   volatile.Register32 // 0x8
	STATUS    volatile.Register32 // 0xC
	RTCCTRL   volatile.Register8  // 0x10
	SLCDCTRL  volatile.Register8  // 0x11
	_         [2]byte
	XOSC32K   volatile.Register16 // 0x14
	CFDCTRL   volatile.Register8  // 0x16
	EVCTRL    volatile.Register8  // 0x17
	_         [4]byte
	OSCULP32K volatile.Register32 // 0x1C
}

// OSC32KCTRL.INTENCLR: Interrupt Enable Clear
func (o *OSC32KCTRL_Type) SetINTENCLR_XOSC32KRDY(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *OSC32KCTRL_Type) GetINTENCLR_XOSC32KRDY() uint32 {
	return volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1
}
func (o *OSC32KCTRL_Type) SetINTENCLR_CLKFAIL(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x4)|value<<2)
}
func (o *OSC32KCTRL_Type) GetINTENCLR_CLKFAIL() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x4) >> 2
}

// OSC32KCTRL.INTENSET: Interrupt Enable Set
func (o *OSC32KCTRL_Type) SetINTENSET_XOSC32KRDY(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *OSC32KCTRL_Type) GetINTENSET_XOSC32KRDY() uint32 {
	return volatile.LoadUint32(&o.INTENSET.Reg) & 0x1
}
func (o *OSC32KCTRL_Type) SetINTENSET_CLKFAIL(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x4)|value<<2)
}
func (o *OSC32KCTRL_Type) GetINTENSET_CLKFAIL() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x4) >> 2
}

// OSC32KCTRL.INTFLAG: Interrupt Flag Status and Clear
func (o *OSC32KCTRL_Type) SetINTFLAG_XOSC32KRDY(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x1)|value)
}
func (o *OSC32KCTRL_Type) GetINTFLAG_XOSC32KRDY() uint32 {
	return volatile.LoadUint32(&o.INTFLAG.Reg) & 0x1
}
func (o *OSC32KCTRL_Type) SetINTFLAG_CLKFAIL(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x4)|value<<2)
}
func (o *OSC32KCTRL_Type) GetINTFLAG_CLKFAIL() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x4) >> 2
}

// OSC32KCTRL.STATUS: Power and Clocks Status
func (o *OSC32KCTRL_Type) SetSTATUS_XOSC32KRDY(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x1)|value)
}
func (o *OSC32KCTRL_Type) GetSTATUS_XOSC32KRDY() uint32 {
	return volatile.LoadUint32(&o.STATUS.Reg) & 0x1
}
func (o *OSC32KCTRL_Type) SetSTATUS_CLKFAIL(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x4)|value<<2)
}
func (o *OSC32KCTRL_Type) GetSTATUS_CLKFAIL() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x4) >> 2
}
func (o *OSC32KCTRL_Type) SetSTATUS_CLKSW(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x8)|value<<3)
}
func (o *OSC32KCTRL_Type) GetSTATUS_CLKSW() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x8) >> 3
}

// OSC32KCTRL.RTCCTRL: RTC Clock Selection
func (o *OSC32KCTRL_Type) SetRTCCTRL_RTCSEL(value uint8) {
	volatile.StoreUint8(&o.RTCCTRL.Reg, volatile.LoadUint8(&o.RTCCTRL.Reg)&^(0x7)|value)
}
func (o *OSC32KCTRL_Type) GetRTCCTRL_RTCSEL() uint8 {
	return volatile.LoadUint8(&o.RTCCTRL.Reg) & 0x7
}

// OSC32KCTRL.SLCDCTRL: SLCD Clock Selection
func (o *OSC32KCTRL_Type) SetSLCDCTRL_SLCDSEL(value uint8) {
	volatile.StoreUint8(&o.SLCDCTRL.Reg, volatile.LoadUint8(&o.SLCDCTRL.Reg)&^(0x1)|value)
}
func (o *OSC32KCTRL_Type) GetSLCDCTRL_SLCDSEL() uint8 {
	return volatile.LoadUint8(&o.SLCDCTRL.Reg) & 0x1
}

// OSC32KCTRL.XOSC32K: 32kHz External Crystal Oscillator (XOSC32K) Control
func (o *OSC32KCTRL_Type) SetXOSC32K_ENABLE(value uint16) {
	volatile.StoreUint16(&o.XOSC32K.Reg, volatile.LoadUint16(&o.XOSC32K.Reg)&^(0x2)|value<<1)
}
func (o *OSC32KCTRL_Type) GetXOSC32K_ENABLE() uint16 {
	return (volatile.LoadUint16(&o.XOSC32K.Reg) & 0x2) >> 1
}
func (o *OSC32KCTRL_Type) SetXOSC32K_XTALEN(value uint16) {
	volatile.StoreUint16(&o.XOSC32K.Reg, volatile.LoadUint16(&o.XOSC32K.Reg)&^(0x4)|value<<2)
}
func (o *OSC32KCTRL_Type) GetXOSC32K_XTALEN() uint16 {
	return (volatile.LoadUint16(&o.XOSC32K.Reg) & 0x4) >> 2
}
func (o *OSC32KCTRL_Type) SetXOSC32K_EN32K(value uint16) {
	volatile.StoreUint16(&o.XOSC32K.Reg, volatile.LoadUint16(&o.XOSC32K.Reg)&^(0x8)|value<<3)
}
func (o *OSC32KCTRL_Type) GetXOSC32K_EN32K() uint16 {
	return (volatile.LoadUint16(&o.XOSC32K.Reg) & 0x8) >> 3
}
func (o *OSC32KCTRL_Type) SetXOSC32K_EN1K(value uint16) {
	volatile.StoreUint16(&o.XOSC32K.Reg, volatile.LoadUint16(&o.XOSC32K.Reg)&^(0x10)|value<<4)
}
func (o *OSC32KCTRL_Type) GetXOSC32K_EN1K() uint16 {
	return (volatile.LoadUint16(&o.XOSC32K.Reg) & 0x10) >> 4
}
func (o *OSC32KCTRL_Type) SetXOSC32K_RUNSTDBY(value uint16) {
	volatile.StoreUint16(&o.XOSC32K.Reg, volatile.LoadUint16(&o.XOSC32K.Reg)&^(0x40)|value<<6)
}
func (o *OSC32KCTRL_Type) GetXOSC32K_RUNSTDBY() uint16 {
	return (volatile.LoadUint16(&o.XOSC32K.Reg) & 0x40) >> 6
}
func (o *OSC32KCTRL_Type) SetXOSC32K_ONDEMAND(value uint16) {
	volatile.StoreUint16(&o.XOSC32K.Reg, volatile.LoadUint16(&o.XOSC32K.Reg)&^(0x80)|value<<7)
}
func (o *OSC32KCTRL_Type) GetXOSC32K_ONDEMAND() uint16 {
	return (volatile.LoadUint16(&o.XOSC32K.Reg) & 0x80) >> 7
}
func (o *OSC32KCTRL_Type) SetXOSC32K_STARTUP(value uint16) {
	volatile.StoreUint16(&o.XOSC32K.Reg, volatile.LoadUint16(&o.XOSC32K.Reg)&^(0x700)|value<<8)
}
func (o *OSC32KCTRL_Type) GetXOSC32K_STARTUP() uint16 {
	return (volatile.LoadUint16(&o.XOSC32K.Reg) & 0x700) >> 8
}
func (o *OSC32KCTRL_Type) SetXOSC32K_WRTLOCK(value uint16) {
	volatile.StoreUint16(&o.XOSC32K.Reg, volatile.LoadUint16(&o.XOSC32K.Reg)&^(0x1000)|value<<12)
}
func (o *OSC32KCTRL_Type) GetXOSC32K_WRTLOCK() uint16 {
	return (volatile.LoadUint16(&o.XOSC32K.Reg) & 0x1000) >> 12
}

// OSC32KCTRL.CFDCTRL: Clock Failure Detector Control
func (o *OSC32KCTRL_Type) SetCFDCTRL_CFDEN(value uint8) {
	volatile.StoreUint8(&o.CFDCTRL.Reg, volatile.LoadUint8(&o.CFDCTRL.Reg)&^(0x1)|value)
}
func (o *OSC32KCTRL_Type) GetCFDCTRL_CFDEN() uint8 {
	return volatile.LoadUint8(&o.CFDCTRL.Reg) & 0x1
}
func (o *OSC32KCTRL_Type) SetCFDCTRL_SWBACK(value uint8) {
	volatile.StoreUint8(&o.CFDCTRL.Reg, volatile.LoadUint8(&o.CFDCTRL.Reg)&^(0x2)|value<<1)
}
func (o *OSC32KCTRL_Type) GetCFDCTRL_SWBACK() uint8 {
	return (volatile.LoadUint8(&o.CFDCTRL.Reg) & 0x2) >> 1
}
func (o *OSC32KCTRL_Type) SetCFDCTRL_CFDPRESC(value uint8) {
	volatile.StoreUint8(&o.CFDCTRL.Reg, volatile.LoadUint8(&o.CFDCTRL.Reg)&^(0x4)|value<<2)
}
func (o *OSC32KCTRL_Type) GetCFDCTRL_CFDPRESC() uint8 {
	return (volatile.LoadUint8(&o.CFDCTRL.Reg) & 0x4) >> 2
}

// OSC32KCTRL.EVCTRL: Event Control
func (o *OSC32KCTRL_Type) SetEVCTRL_CFDEO(value uint8) {
	volatile.StoreUint8(&o.EVCTRL.Reg, volatile.LoadUint8(&o.EVCTRL.Reg)&^(0x1)|value)
}
func (o *OSC32KCTRL_Type) GetEVCTRL_CFDEO() uint8 {
	return volatile.LoadUint8(&o.EVCTRL.Reg) & 0x1
}

// OSC32KCTRL.OSCULP32K: 32kHz Ultra Low Power Internal Oscillator (OSCULP32K) Control
func (o *OSC32KCTRL_Type) SetOSCULP32K_EN32K(value uint32) {
	volatile.StoreUint32(&o.OSCULP32K.Reg, volatile.LoadUint32(&o.OSCULP32K.Reg)&^(0x2)|value<<1)
}
func (o *OSC32KCTRL_Type) GetOSCULP32K_EN32K() uint32 {
	return (volatile.LoadUint32(&o.OSCULP32K.Reg) & 0x2) >> 1
}
func (o *OSC32KCTRL_Type) SetOSCULP32K_EN1K(value uint32) {
	volatile.StoreUint32(&o.OSCULP32K.Reg, volatile.LoadUint32(&o.OSCULP32K.Reg)&^(0x4)|value<<2)
}
func (o *OSC32KCTRL_Type) GetOSCULP32K_EN1K() uint32 {
	return (volatile.LoadUint32(&o.OSCULP32K.Reg) & 0x4) >> 2
}
func (o *OSC32KCTRL_Type) SetOSCULP32K_CALIB(value uint32) {
	volatile.StoreUint32(&o.OSCULP32K.Reg, volatile.LoadUint32(&o.OSCULP32K.Reg)&^(0x1f00)|value<<8)
}
func (o *OSC32KCTRL_Type) GetOSCULP32K_CALIB() uint32 {
	return (volatile.LoadUint32(&o.OSCULP32K.Reg) & 0x1f00) >> 8
}
func (o *OSC32KCTRL_Type) SetOSCULP32K_WRTLOCK(value uint32) {
	volatile.StoreUint32(&o.OSCULP32K.Reg, volatile.LoadUint32(&o.OSCULP32K.Reg)&^(0x8000)|value<<15)
}
func (o *OSC32KCTRL_Type) GetOSCULP32K_WRTLOCK() uint32 {
	return (volatile.LoadUint32(&o.OSCULP32K.Reg) & 0x8000) >> 15
}

// Peripheral Access Controller
type PAC_Type struct {
	WRCTRL     volatile.Register32 // 0x0
	EVCTRL     volatile.Register8  // 0x4
	_          [3]byte
	INTENCLR   volatile.Register8 // 0x8
	INTENSET   volatile.Register8 // 0x9
	_          [6]byte
	INTFLAGAHB volatile.Register32 // 0x10
	INTFLAGA   volatile.Register32 // 0x14
	INTFLAGB   volatile.Register32 // 0x18
	INTFLAGC   volatile.Register32 // 0x1C
	_          [20]byte
	STATUSA    volatile.Register32 // 0x34
	STATUSB    volatile.Register32 // 0x38
	STATUSC    volatile.Register32 // 0x3C
}

// PAC.WRCTRL: Write control
func (o *PAC_Type) SetWRCTRL_PERID(value uint32) {
	volatile.StoreUint32(&o.WRCTRL.Reg, volatile.LoadUint32(&o.WRCTRL.Reg)&^(0xffff)|value)
}
func (o *PAC_Type) GetWRCTRL_PERID() uint32 {
	return volatile.LoadUint32(&o.WRCTRL.Reg) & 0xffff
}
func (o *PAC_Type) SetWRCTRL_KEY(value uint32) {
	volatile.StoreUint32(&o.WRCTRL.Reg, volatile.LoadUint32(&o.WRCTRL.Reg)&^(0xff0000)|value<<16)
}
func (o *PAC_Type) GetWRCTRL_KEY() uint32 {
	return (volatile.LoadUint32(&o.WRCTRL.Reg) & 0xff0000) >> 16
}

// PAC.EVCTRL: Event control
func (o *PAC_Type) SetEVCTRL_ERREO(value uint8) {
	volatile.StoreUint8(&o.EVCTRL.Reg, volatile.LoadUint8(&o.EVCTRL.Reg)&^(0x1)|value)
}
func (o *PAC_Type) GetEVCTRL_ERREO() uint8 {
	return volatile.LoadUint8(&o.EVCTRL.Reg) & 0x1
}

// PAC.INTENCLR: Interrupt enable clear
func (o *PAC_Type) SetINTENCLR_ERR(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *PAC_Type) GetINTENCLR_ERR() uint8 {
	return volatile.LoadUint8(&o.INTENCLR.Reg) & 0x1
}

// PAC.INTENSET: Interrupt enable set
func (o *PAC_Type) SetINTENSET_ERR(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *PAC_Type) GetINTENSET_ERR() uint8 {
	return volatile.LoadUint8(&o.INTENSET.Reg) & 0x1
}

// PAC.INTFLAGAHB: Bridge interrupt flag status
func (o *PAC_Type) SetINTFLAGAHB_FLASH_(value uint32) {
	volatile.StoreUint32(&o.INTFLAGAHB.Reg, volatile.LoadUint32(&o.INTFLAGAHB.Reg)&^(0x1)|value)
}
func (o *PAC_Type) GetINTFLAGAHB_FLASH_() uint32 {
	return volatile.LoadUint32(&o.INTFLAGAHB.Reg) & 0x1
}
func (o *PAC_Type) SetINTFLAGAHB_HSRAMCM0P_(value uint32) {
	volatile.StoreUint32(&o.INTFLAGAHB.Reg, volatile.LoadUint32(&o.INTFLAGAHB.Reg)&^(0x2)|value<<1)
}
func (o *PAC_Type) GetINTFLAGAHB_HSRAMCM0P_() uint32 {
	return (volatile.LoadUint32(&o.INTFLAGAHB.Reg) & 0x2) >> 1
}
func (o *PAC_Type) SetINTFLAGAHB_HSRAMDSU_(value uint32) {
	volatile.StoreUint32(&o.INTFLAGAHB.Reg, volatile.LoadUint32(&o.INTFLAGAHB.Reg)&^(0x4)|value<<2)
}
func (o *PAC_Type) GetINTFLAGAHB_HSRAMDSU_() uint32 {
	return (volatile.LoadUint32(&o.INTFLAGAHB.Reg) & 0x4) >> 2
}
func (o *PAC_Type) SetINTFLAGAHB_HPB1_(value uint32) {
	volatile.StoreUint32(&o.INTFLAGAHB.Reg, volatile.LoadUint32(&o.INTFLAGAHB.Reg)&^(0x8)|value<<3)
}
func (o *PAC_Type) GetINTFLAGAHB_HPB1_() uint32 {
	return (volatile.LoadUint32(&o.INTFLAGAHB.Reg) & 0x8) >> 3
}
func (o *PAC_Type) SetINTFLAGAHB_HPB0_(value uint32) {
	volatile.StoreUint32(&o.INTFLAGAHB.Reg, volatile.LoadUint32(&o.INTFLAGAHB.Reg)&^(0x10)|value<<4)
}
func (o *PAC_Type) GetINTFLAGAHB_HPB0_() uint32 {
	return (volatile.LoadUint32(&o.INTFLAGAHB.Reg) & 0x10) >> 4
}
func (o *PAC_Type) SetINTFLAGAHB_HPB2_(value uint32) {
	volatile.StoreUint32(&o.INTFLAGAHB.Reg, volatile.LoadUint32(&o.INTFLAGAHB.Reg)&^(0x20)|value<<5)
}
func (o *PAC_Type) GetINTFLAGAHB_HPB2_() uint32 {
	return (volatile.LoadUint32(&o.INTFLAGAHB.Reg) & 0x20) >> 5
}
func (o *PAC_Type) SetINTFLAGAHB_HSRAMDMAC_(value uint32) {
	volatile.StoreUint32(&o.INTFLAGAHB.Reg, volatile.LoadUint32(&o.INTFLAGAHB.Reg)&^(0x40)|value<<6)
}
func (o *PAC_Type) GetINTFLAGAHB_HSRAMDMAC_() uint32 {
	return (volatile.LoadUint32(&o.INTFLAGAHB.Reg) & 0x40) >> 6
}

// PAC.INTFLAGA: Peripheral interrupt flag status - Bridge A
func (o *PAC_Type) SetINTFLAGA_PAC_(value uint32) {
	volatile.StoreUint32(&o.INTFLAGA.Reg, volatile.LoadUint32(&o.INTFLAGA.Reg)&^(0x1)|value)
}
func (o *PAC_Type) GetINTFLAGA_PAC_() uint32 {
	return volatile.LoadUint32(&o.INTFLAGA.Reg) & 0x1
}
func (o *PAC_Type) SetINTFLAGA_PM_(value uint32) {
	volatile.StoreUint32(&o.INTFLAGA.Reg, volatile.LoadUint32(&o.INTFLAGA.Reg)&^(0x2)|value<<1)
}
func (o *PAC_Type) GetINTFLAGA_PM_() uint32 {
	return (volatile.LoadUint32(&o.INTFLAGA.Reg) & 0x2) >> 1
}
func (o *PAC_Type) SetINTFLAGA_MCLK_(value uint32) {
	volatile.StoreUint32(&o.INTFLAGA.Reg, volatile.LoadUint32(&o.INTFLAGA.Reg)&^(0x4)|value<<2)
}
func (o *PAC_Type) GetINTFLAGA_MCLK_() uint32 {
	return (volatile.LoadUint32(&o.INTFLAGA.Reg) & 0x4) >> 2
}
func (o *PAC_Type) SetINTFLAGA_RSTC_(value uint32) {
	volatile.StoreUint32(&o.INTFLAGA.Reg, volatile.LoadUint32(&o.INTFLAGA.Reg)&^(0x8)|value<<3)
}
func (o *PAC_Type) GetINTFLAGA_RSTC_() uint32 {
	return (volatile.LoadUint32(&o.INTFLAGA.Reg) & 0x8) >> 3
}
func (o *PAC_Type) SetINTFLAGA_OSCCTRL_(value uint32) {
	volatile.StoreUint32(&o.INTFLAGA.Reg, volatile.LoadUint32(&o.INTFLAGA.Reg)&^(0x10)|value<<4)
}
func (o *PAC_Type) GetINTFLAGA_OSCCTRL_() uint32 {
	return (volatile.LoadUint32(&o.INTFLAGA.Reg) & 0x10) >> 4
}
func (o *PAC_Type) SetINTFLAGA_OSC32KCTRL_(value uint32) {
	volatile.StoreUint32(&o.INTFLAGA.Reg, volatile.LoadUint32(&o.INTFLAGA.Reg)&^(0x20)|value<<5)
}
func (o *PAC_Type) GetINTFLAGA_OSC32KCTRL_() uint32 {
	return (volatile.LoadUint32(&o.INTFLAGA.Reg) & 0x20) >> 5
}
func (o *PAC_Type) SetINTFLAGA_SUPC_(value uint32) {
	volatile.StoreUint32(&o.INTFLAGA.Reg, volatile.LoadUint32(&o.INTFLAGA.Reg)&^(0x40)|value<<6)
}
func (o *PAC_Type) GetINTFLAGA_SUPC_() uint32 {
	return (volatile.LoadUint32(&o.INTFLAGA.Reg) & 0x40) >> 6
}
func (o *PAC_Type) SetINTFLAGA_GCLK_(value uint32) {
	volatile.StoreUint32(&o.INTFLAGA.Reg, volatile.LoadUint32(&o.INTFLAGA.Reg)&^(0x80)|value<<7)
}
func (o *PAC_Type) GetINTFLAGA_GCLK_() uint32 {
	return (volatile.LoadUint32(&o.INTFLAGA.Reg) & 0x80) >> 7
}
func (o *PAC_Type) SetINTFLAGA_WDT_(value uint32) {
	volatile.StoreUint32(&o.INTFLAGA.Reg, volatile.LoadUint32(&o.INTFLAGA.Reg)&^(0x100)|value<<8)
}
func (o *PAC_Type) GetINTFLAGA_WDT_() uint32 {
	return (volatile.LoadUint32(&o.INTFLAGA.Reg) & 0x100) >> 8
}
func (o *PAC_Type) SetINTFLAGA_RTC_(value uint32) {
	volatile.StoreUint32(&o.INTFLAGA.Reg, volatile.LoadUint32(&o.INTFLAGA.Reg)&^(0x200)|value<<9)
}
func (o *PAC_Type) GetINTFLAGA_RTC_() uint32 {
	return (volatile.LoadUint32(&o.INTFLAGA.Reg) & 0x200) >> 9
}
func (o *PAC_Type) SetINTFLAGA_EIC_(value uint32) {
	volatile.StoreUint32(&o.INTFLAGA.Reg, volatile.LoadUint32(&o.INTFLAGA.Reg)&^(0x400)|value<<10)
}
func (o *PAC_Type) GetINTFLAGA_EIC_() uint32 {
	return (volatile.LoadUint32(&o.INTFLAGA.Reg) & 0x400) >> 10
}
func (o *PAC_Type) SetINTFLAGA_FREQM_(value uint32) {
	volatile.StoreUint32(&o.INTFLAGA.Reg, volatile.LoadUint32(&o.INTFLAGA.Reg)&^(0x800)|value<<11)
}
func (o *PAC_Type) GetINTFLAGA_FREQM_() uint32 {
	return (volatile.LoadUint32(&o.INTFLAGA.Reg) & 0x800) >> 11
}

// PAC.INTFLAGB: Peripheral interrupt flag status - Bridge B
func (o *PAC_Type) SetINTFLAGB_USB_(value uint32) {
	volatile.StoreUint32(&o.INTFLAGB.Reg, volatile.LoadUint32(&o.INTFLAGB.Reg)&^(0x1)|value)
}
func (o *PAC_Type) GetINTFLAGB_USB_() uint32 {
	return volatile.LoadUint32(&o.INTFLAGB.Reg) & 0x1
}
func (o *PAC_Type) SetINTFLAGB_DSU_(value uint32) {
	volatile.StoreUint32(&o.INTFLAGB.Reg, volatile.LoadUint32(&o.INTFLAGB.Reg)&^(0x2)|value<<1)
}
func (o *PAC_Type) GetINTFLAGB_DSU_() uint32 {
	return (volatile.LoadUint32(&o.INTFLAGB.Reg) & 0x2) >> 1
}
func (o *PAC_Type) SetINTFLAGB_NVMCTRL_(value uint32) {
	volatile.StoreUint32(&o.INTFLAGB.Reg, volatile.LoadUint32(&o.INTFLAGB.Reg)&^(0x4)|value<<2)
}
func (o *PAC_Type) GetINTFLAGB_NVMCTRL_() uint32 {
	return (volatile.LoadUint32(&o.INTFLAGB.Reg) & 0x4) >> 2
}
func (o *PAC_Type) SetINTFLAGB_PORT_(value uint32) {
	volatile.StoreUint32(&o.INTFLAGB.Reg, volatile.LoadUint32(&o.INTFLAGB.Reg)&^(0x8)|value<<3)
}
func (o *PAC_Type) GetINTFLAGB_PORT_() uint32 {
	return (volatile.LoadUint32(&o.INTFLAGB.Reg) & 0x8) >> 3
}
func (o *PAC_Type) SetINTFLAGB_DMAC_(value uint32) {
	volatile.StoreUint32(&o.INTFLAGB.Reg, volatile.LoadUint32(&o.INTFLAGB.Reg)&^(0x10)|value<<4)
}
func (o *PAC_Type) GetINTFLAGB_DMAC_() uint32 {
	return (volatile.LoadUint32(&o.INTFLAGB.Reg) & 0x10) >> 4
}
func (o *PAC_Type) SetINTFLAGB_MTB_(value uint32) {
	volatile.StoreUint32(&o.INTFLAGB.Reg, volatile.LoadUint32(&o.INTFLAGB.Reg)&^(0x20)|value<<5)
}
func (o *PAC_Type) GetINTFLAGB_MTB_() uint32 {
	return (volatile.LoadUint32(&o.INTFLAGB.Reg) & 0x20) >> 5
}

// PAC.INTFLAGC: Peripheral interrupt flag status - Bridge C
func (o *PAC_Type) SetINTFLAGC_EVSYS_(value uint32) {
	volatile.StoreUint32(&o.INTFLAGC.Reg, volatile.LoadUint32(&o.INTFLAGC.Reg)&^(0x1)|value)
}
func (o *PAC_Type) GetINTFLAGC_EVSYS_() uint32 {
	return volatile.LoadUint32(&o.INTFLAGC.Reg) & 0x1
}
func (o *PAC_Type) SetINTFLAGC_SERCOM0_(value uint32) {
	volatile.StoreUint32(&o.INTFLAGC.Reg, volatile.LoadUint32(&o.INTFLAGC.Reg)&^(0x2)|value<<1)
}
func (o *PAC_Type) GetINTFLAGC_SERCOM0_() uint32 {
	return (volatile.LoadUint32(&o.INTFLAGC.Reg) & 0x2) >> 1
}
func (o *PAC_Type) SetINTFLAGC_SERCOM1_(value uint32) {
	volatile.StoreUint32(&o.INTFLAGC.Reg, volatile.LoadUint32(&o.INTFLAGC.Reg)&^(0x4)|value<<2)
}
func (o *PAC_Type) GetINTFLAGC_SERCOM1_() uint32 {
	return (volatile.LoadUint32(&o.INTFLAGC.Reg) & 0x4) >> 2
}
func (o *PAC_Type) SetINTFLAGC_SERCOM2_(value uint32) {
	volatile.StoreUint32(&o.INTFLAGC.Reg, volatile.LoadUint32(&o.INTFLAGC.Reg)&^(0x8)|value<<3)
}
func (o *PAC_Type) GetINTFLAGC_SERCOM2_() uint32 {
	return (volatile.LoadUint32(&o.INTFLAGC.Reg) & 0x8) >> 3
}
func (o *PAC_Type) SetINTFLAGC_SERCOM3_(value uint32) {
	volatile.StoreUint32(&o.INTFLAGC.Reg, volatile.LoadUint32(&o.INTFLAGC.Reg)&^(0x10)|value<<4)
}
func (o *PAC_Type) GetINTFLAGC_SERCOM3_() uint32 {
	return (volatile.LoadUint32(&o.INTFLAGC.Reg) & 0x10) >> 4
}
func (o *PAC_Type) SetINTFLAGC_TCC0_(value uint32) {
	volatile.StoreUint32(&o.INTFLAGC.Reg, volatile.LoadUint32(&o.INTFLAGC.Reg)&^(0x80)|value<<7)
}
func (o *PAC_Type) GetINTFLAGC_TCC0_() uint32 {
	return (volatile.LoadUint32(&o.INTFLAGC.Reg) & 0x80) >> 7
}
func (o *PAC_Type) SetINTFLAGC_TC0_(value uint32) {
	volatile.StoreUint32(&o.INTFLAGC.Reg, volatile.LoadUint32(&o.INTFLAGC.Reg)&^(0x100)|value<<8)
}
func (o *PAC_Type) GetINTFLAGC_TC0_() uint32 {
	return (volatile.LoadUint32(&o.INTFLAGC.Reg) & 0x100) >> 8
}
func (o *PAC_Type) SetINTFLAGC_TC1_(value uint32) {
	volatile.StoreUint32(&o.INTFLAGC.Reg, volatile.LoadUint32(&o.INTFLAGC.Reg)&^(0x200)|value<<9)
}
func (o *PAC_Type) GetINTFLAGC_TC1_() uint32 {
	return (volatile.LoadUint32(&o.INTFLAGC.Reg) & 0x200) >> 9
}
func (o *PAC_Type) SetINTFLAGC_TC2_(value uint32) {
	volatile.StoreUint32(&o.INTFLAGC.Reg, volatile.LoadUint32(&o.INTFLAGC.Reg)&^(0x400)|value<<10)
}
func (o *PAC_Type) GetINTFLAGC_TC2_() uint32 {
	return (volatile.LoadUint32(&o.INTFLAGC.Reg) & 0x400) >> 10
}
func (o *PAC_Type) SetINTFLAGC_TC3_(value uint32) {
	volatile.StoreUint32(&o.INTFLAGC.Reg, volatile.LoadUint32(&o.INTFLAGC.Reg)&^(0x800)|value<<11)
}
func (o *PAC_Type) GetINTFLAGC_TC3_() uint32 {
	return (volatile.LoadUint32(&o.INTFLAGC.Reg) & 0x800) >> 11
}
func (o *PAC_Type) SetINTFLAGC_ADC_(value uint32) {
	volatile.StoreUint32(&o.INTFLAGC.Reg, volatile.LoadUint32(&o.INTFLAGC.Reg)&^(0x1000)|value<<12)
}
func (o *PAC_Type) GetINTFLAGC_ADC_() uint32 {
	return (volatile.LoadUint32(&o.INTFLAGC.Reg) & 0x1000) >> 12
}
func (o *PAC_Type) SetINTFLAGC_AC_(value uint32) {
	volatile.StoreUint32(&o.INTFLAGC.Reg, volatile.LoadUint32(&o.INTFLAGC.Reg)&^(0x2000)|value<<13)
}
func (o *PAC_Type) GetINTFLAGC_AC_() uint32 {
	return (volatile.LoadUint32(&o.INTFLAGC.Reg) & 0x2000) >> 13
}
func (o *PAC_Type) SetINTFLAGC_PTC_(value uint32) {
	volatile.StoreUint32(&o.INTFLAGC.Reg, volatile.LoadUint32(&o.INTFLAGC.Reg)&^(0x4000)|value<<14)
}
func (o *PAC_Type) GetINTFLAGC_PTC_() uint32 {
	return (volatile.LoadUint32(&o.INTFLAGC.Reg) & 0x4000) >> 14
}
func (o *PAC_Type) SetINTFLAGC_SLCD_(value uint32) {
	volatile.StoreUint32(&o.INTFLAGC.Reg, volatile.LoadUint32(&o.INTFLAGC.Reg)&^(0x8000)|value<<15)
}
func (o *PAC_Type) GetINTFLAGC_SLCD_() uint32 {
	return (volatile.LoadUint32(&o.INTFLAGC.Reg) & 0x8000) >> 15
}
func (o *PAC_Type) SetINTFLAGC_AES_(value uint32) {
	volatile.StoreUint32(&o.INTFLAGC.Reg, volatile.LoadUint32(&o.INTFLAGC.Reg)&^(0x10000)|value<<16)
}
func (o *PAC_Type) GetINTFLAGC_AES_() uint32 {
	return (volatile.LoadUint32(&o.INTFLAGC.Reg) & 0x10000) >> 16
}
func (o *PAC_Type) SetINTFLAGC_TRNG_(value uint32) {
	volatile.StoreUint32(&o.INTFLAGC.Reg, volatile.LoadUint32(&o.INTFLAGC.Reg)&^(0x20000)|value<<17)
}
func (o *PAC_Type) GetINTFLAGC_TRNG_() uint32 {
	return (volatile.LoadUint32(&o.INTFLAGC.Reg) & 0x20000) >> 17
}
func (o *PAC_Type) SetINTFLAGC_CCL_(value uint32) {
	volatile.StoreUint32(&o.INTFLAGC.Reg, volatile.LoadUint32(&o.INTFLAGC.Reg)&^(0x40000)|value<<18)
}
func (o *PAC_Type) GetINTFLAGC_CCL_() uint32 {
	return (volatile.LoadUint32(&o.INTFLAGC.Reg) & 0x40000) >> 18
}

// PAC.STATUSA: Peripheral write protection status - Bridge A
func (o *PAC_Type) SetSTATUSA_PAC_(value uint32) {
	volatile.StoreUint32(&o.STATUSA.Reg, volatile.LoadUint32(&o.STATUSA.Reg)&^(0x1)|value)
}
func (o *PAC_Type) GetSTATUSA_PAC_() uint32 {
	return volatile.LoadUint32(&o.STATUSA.Reg) & 0x1
}
func (o *PAC_Type) SetSTATUSA_PM_(value uint32) {
	volatile.StoreUint32(&o.STATUSA.Reg, volatile.LoadUint32(&o.STATUSA.Reg)&^(0x2)|value<<1)
}
func (o *PAC_Type) GetSTATUSA_PM_() uint32 {
	return (volatile.LoadUint32(&o.STATUSA.Reg) & 0x2) >> 1
}
func (o *PAC_Type) SetSTATUSA_MCLK_(value uint32) {
	volatile.StoreUint32(&o.STATUSA.Reg, volatile.LoadUint32(&o.STATUSA.Reg)&^(0x4)|value<<2)
}
func (o *PAC_Type) GetSTATUSA_MCLK_() uint32 {
	return (volatile.LoadUint32(&o.STATUSA.Reg) & 0x4) >> 2
}
func (o *PAC_Type) SetSTATUSA_RSTC_(value uint32) {
	volatile.StoreUint32(&o.STATUSA.Reg, volatile.LoadUint32(&o.STATUSA.Reg)&^(0x8)|value<<3)
}
func (o *PAC_Type) GetSTATUSA_RSTC_() uint32 {
	return (volatile.LoadUint32(&o.STATUSA.Reg) & 0x8) >> 3
}
func (o *PAC_Type) SetSTATUSA_OSCCTRL_(value uint32) {
	volatile.StoreUint32(&o.STATUSA.Reg, volatile.LoadUint32(&o.STATUSA.Reg)&^(0x10)|value<<4)
}
func (o *PAC_Type) GetSTATUSA_OSCCTRL_() uint32 {
	return (volatile.LoadUint32(&o.STATUSA.Reg) & 0x10) >> 4
}
func (o *PAC_Type) SetSTATUSA_OSC32KCTRL_(value uint32) {
	volatile.StoreUint32(&o.STATUSA.Reg, volatile.LoadUint32(&o.STATUSA.Reg)&^(0x20)|value<<5)
}
func (o *PAC_Type) GetSTATUSA_OSC32KCTRL_() uint32 {
	return (volatile.LoadUint32(&o.STATUSA.Reg) & 0x20) >> 5
}
func (o *PAC_Type) SetSTATUSA_SUPC_(value uint32) {
	volatile.StoreUint32(&o.STATUSA.Reg, volatile.LoadUint32(&o.STATUSA.Reg)&^(0x40)|value<<6)
}
func (o *PAC_Type) GetSTATUSA_SUPC_() uint32 {
	return (volatile.LoadUint32(&o.STATUSA.Reg) & 0x40) >> 6
}
func (o *PAC_Type) SetSTATUSA_GCLK_(value uint32) {
	volatile.StoreUint32(&o.STATUSA.Reg, volatile.LoadUint32(&o.STATUSA.Reg)&^(0x80)|value<<7)
}
func (o *PAC_Type) GetSTATUSA_GCLK_() uint32 {
	return (volatile.LoadUint32(&o.STATUSA.Reg) & 0x80) >> 7
}
func (o *PAC_Type) SetSTATUSA_WDT_(value uint32) {
	volatile.StoreUint32(&o.STATUSA.Reg, volatile.LoadUint32(&o.STATUSA.Reg)&^(0x100)|value<<8)
}
func (o *PAC_Type) GetSTATUSA_WDT_() uint32 {
	return (volatile.LoadUint32(&o.STATUSA.Reg) & 0x100) >> 8
}
func (o *PAC_Type) SetSTATUSA_RTC_(value uint32) {
	volatile.StoreUint32(&o.STATUSA.Reg, volatile.LoadUint32(&o.STATUSA.Reg)&^(0x200)|value<<9)
}
func (o *PAC_Type) GetSTATUSA_RTC_() uint32 {
	return (volatile.LoadUint32(&o.STATUSA.Reg) & 0x200) >> 9
}
func (o *PAC_Type) SetSTATUSA_EIC_(value uint32) {
	volatile.StoreUint32(&o.STATUSA.Reg, volatile.LoadUint32(&o.STATUSA.Reg)&^(0x400)|value<<10)
}
func (o *PAC_Type) GetSTATUSA_EIC_() uint32 {
	return (volatile.LoadUint32(&o.STATUSA.Reg) & 0x400) >> 10
}
func (o *PAC_Type) SetSTATUSA_FREQM_(value uint32) {
	volatile.StoreUint32(&o.STATUSA.Reg, volatile.LoadUint32(&o.STATUSA.Reg)&^(0x800)|value<<11)
}
func (o *PAC_Type) GetSTATUSA_FREQM_() uint32 {
	return (volatile.LoadUint32(&o.STATUSA.Reg) & 0x800) >> 11
}

// PAC.STATUSB: Peripheral write protection status - Bridge B
func (o *PAC_Type) SetSTATUSB_USB_(value uint32) {
	volatile.StoreUint32(&o.STATUSB.Reg, volatile.LoadUint32(&o.STATUSB.Reg)&^(0x1)|value)
}
func (o *PAC_Type) GetSTATUSB_USB_() uint32 {
	return volatile.LoadUint32(&o.STATUSB.Reg) & 0x1
}
func (o *PAC_Type) SetSTATUSB_DSU_(value uint32) {
	volatile.StoreUint32(&o.STATUSB.Reg, volatile.LoadUint32(&o.STATUSB.Reg)&^(0x2)|value<<1)
}
func (o *PAC_Type) GetSTATUSB_DSU_() uint32 {
	return (volatile.LoadUint32(&o.STATUSB.Reg) & 0x2) >> 1
}
func (o *PAC_Type) SetSTATUSB_NVMCTRL_(value uint32) {
	volatile.StoreUint32(&o.STATUSB.Reg, volatile.LoadUint32(&o.STATUSB.Reg)&^(0x4)|value<<2)
}
func (o *PAC_Type) GetSTATUSB_NVMCTRL_() uint32 {
	return (volatile.LoadUint32(&o.STATUSB.Reg) & 0x4) >> 2
}
func (o *PAC_Type) SetSTATUSB_PORT_(value uint32) {
	volatile.StoreUint32(&o.STATUSB.Reg, volatile.LoadUint32(&o.STATUSB.Reg)&^(0x8)|value<<3)
}
func (o *PAC_Type) GetSTATUSB_PORT_() uint32 {
	return (volatile.LoadUint32(&o.STATUSB.Reg) & 0x8) >> 3
}
func (o *PAC_Type) SetSTATUSB_DMAC_(value uint32) {
	volatile.StoreUint32(&o.STATUSB.Reg, volatile.LoadUint32(&o.STATUSB.Reg)&^(0x10)|value<<4)
}
func (o *PAC_Type) GetSTATUSB_DMAC_() uint32 {
	return (volatile.LoadUint32(&o.STATUSB.Reg) & 0x10) >> 4
}
func (o *PAC_Type) SetSTATUSB_MTB_(value uint32) {
	volatile.StoreUint32(&o.STATUSB.Reg, volatile.LoadUint32(&o.STATUSB.Reg)&^(0x20)|value<<5)
}
func (o *PAC_Type) GetSTATUSB_MTB_() uint32 {
	return (volatile.LoadUint32(&o.STATUSB.Reg) & 0x20) >> 5
}

// PAC.STATUSC: Peripheral write protection status - Bridge C
func (o *PAC_Type) SetSTATUSC_EVSYS_(value uint32) {
	volatile.StoreUint32(&o.STATUSC.Reg, volatile.LoadUint32(&o.STATUSC.Reg)&^(0x1)|value)
}
func (o *PAC_Type) GetSTATUSC_EVSYS_() uint32 {
	return volatile.LoadUint32(&o.STATUSC.Reg) & 0x1
}
func (o *PAC_Type) SetSTATUSC_SERCOM0_(value uint32) {
	volatile.StoreUint32(&o.STATUSC.Reg, volatile.LoadUint32(&o.STATUSC.Reg)&^(0x2)|value<<1)
}
func (o *PAC_Type) GetSTATUSC_SERCOM0_() uint32 {
	return (volatile.LoadUint32(&o.STATUSC.Reg) & 0x2) >> 1
}
func (o *PAC_Type) SetSTATUSC_SERCOM1_(value uint32) {
	volatile.StoreUint32(&o.STATUSC.Reg, volatile.LoadUint32(&o.STATUSC.Reg)&^(0x4)|value<<2)
}
func (o *PAC_Type) GetSTATUSC_SERCOM1_() uint32 {
	return (volatile.LoadUint32(&o.STATUSC.Reg) & 0x4) >> 2
}
func (o *PAC_Type) SetSTATUSC_SERCOM2_(value uint32) {
	volatile.StoreUint32(&o.STATUSC.Reg, volatile.LoadUint32(&o.STATUSC.Reg)&^(0x8)|value<<3)
}
func (o *PAC_Type) GetSTATUSC_SERCOM2_() uint32 {
	return (volatile.LoadUint32(&o.STATUSC.Reg) & 0x8) >> 3
}
func (o *PAC_Type) SetSTATUSC_SERCOM3_(value uint32) {
	volatile.StoreUint32(&o.STATUSC.Reg, volatile.LoadUint32(&o.STATUSC.Reg)&^(0x10)|value<<4)
}
func (o *PAC_Type) GetSTATUSC_SERCOM3_() uint32 {
	return (volatile.LoadUint32(&o.STATUSC.Reg) & 0x10) >> 4
}
func (o *PAC_Type) SetSTATUSC_TCC0_(value uint32) {
	volatile.StoreUint32(&o.STATUSC.Reg, volatile.LoadUint32(&o.STATUSC.Reg)&^(0x80)|value<<7)
}
func (o *PAC_Type) GetSTATUSC_TCC0_() uint32 {
	return (volatile.LoadUint32(&o.STATUSC.Reg) & 0x80) >> 7
}
func (o *PAC_Type) SetSTATUSC_TC0_(value uint32) {
	volatile.StoreUint32(&o.STATUSC.Reg, volatile.LoadUint32(&o.STATUSC.Reg)&^(0x100)|value<<8)
}
func (o *PAC_Type) GetSTATUSC_TC0_() uint32 {
	return (volatile.LoadUint32(&o.STATUSC.Reg) & 0x100) >> 8
}
func (o *PAC_Type) SetSTATUSC_TC1_(value uint32) {
	volatile.StoreUint32(&o.STATUSC.Reg, volatile.LoadUint32(&o.STATUSC.Reg)&^(0x200)|value<<9)
}
func (o *PAC_Type) GetSTATUSC_TC1_() uint32 {
	return (volatile.LoadUint32(&o.STATUSC.Reg) & 0x200) >> 9
}
func (o *PAC_Type) SetSTATUSC_TC2_(value uint32) {
	volatile.StoreUint32(&o.STATUSC.Reg, volatile.LoadUint32(&o.STATUSC.Reg)&^(0x400)|value<<10)
}
func (o *PAC_Type) GetSTATUSC_TC2_() uint32 {
	return (volatile.LoadUint32(&o.STATUSC.Reg) & 0x400) >> 10
}
func (o *PAC_Type) SetSTATUSC_TC3_(value uint32) {
	volatile.StoreUint32(&o.STATUSC.Reg, volatile.LoadUint32(&o.STATUSC.Reg)&^(0x800)|value<<11)
}
func (o *PAC_Type) GetSTATUSC_TC3_() uint32 {
	return (volatile.LoadUint32(&o.STATUSC.Reg) & 0x800) >> 11
}
func (o *PAC_Type) SetSTATUSC_ADC_(value uint32) {
	volatile.StoreUint32(&o.STATUSC.Reg, volatile.LoadUint32(&o.STATUSC.Reg)&^(0x1000)|value<<12)
}
func (o *PAC_Type) GetSTATUSC_ADC_() uint32 {
	return (volatile.LoadUint32(&o.STATUSC.Reg) & 0x1000) >> 12
}
func (o *PAC_Type) SetSTATUSC_AC_(value uint32) {
	volatile.StoreUint32(&o.STATUSC.Reg, volatile.LoadUint32(&o.STATUSC.Reg)&^(0x2000)|value<<13)
}
func (o *PAC_Type) GetSTATUSC_AC_() uint32 {
	return (volatile.LoadUint32(&o.STATUSC.Reg) & 0x2000) >> 13
}
func (o *PAC_Type) SetSTATUSC_PTC_(value uint32) {
	volatile.StoreUint32(&o.STATUSC.Reg, volatile.LoadUint32(&o.STATUSC.Reg)&^(0x4000)|value<<14)
}
func (o *PAC_Type) GetSTATUSC_PTC_() uint32 {
	return (volatile.LoadUint32(&o.STATUSC.Reg) & 0x4000) >> 14
}
func (o *PAC_Type) SetSTATUSC_SLCD_(value uint32) {
	volatile.StoreUint32(&o.STATUSC.Reg, volatile.LoadUint32(&o.STATUSC.Reg)&^(0x8000)|value<<15)
}
func (o *PAC_Type) GetSTATUSC_SLCD_() uint32 {
	return (volatile.LoadUint32(&o.STATUSC.Reg) & 0x8000) >> 15
}
func (o *PAC_Type) SetSTATUSC_AES_(value uint32) {
	volatile.StoreUint32(&o.STATUSC.Reg, volatile.LoadUint32(&o.STATUSC.Reg)&^(0x10000)|value<<16)
}
func (o *PAC_Type) GetSTATUSC_AES_() uint32 {
	return (volatile.LoadUint32(&o.STATUSC.Reg) & 0x10000) >> 16
}
func (o *PAC_Type) SetSTATUSC_TRNG_(value uint32) {
	volatile.StoreUint32(&o.STATUSC.Reg, volatile.LoadUint32(&o.STATUSC.Reg)&^(0x20000)|value<<17)
}
func (o *PAC_Type) GetSTATUSC_TRNG_() uint32 {
	return (volatile.LoadUint32(&o.STATUSC.Reg) & 0x20000) >> 17
}
func (o *PAC_Type) SetSTATUSC_CCL_(value uint32) {
	volatile.StoreUint32(&o.STATUSC.Reg, volatile.LoadUint32(&o.STATUSC.Reg)&^(0x40000)|value<<18)
}
func (o *PAC_Type) GetSTATUSC_CCL_() uint32 {
	return (volatile.LoadUint32(&o.STATUSC.Reg) & 0x40000) >> 18
}

// Power Manager
type PM_Type struct {
	CTRLA    volatile.Register8 // 0x0
	SLEEPCFG volatile.Register8 // 0x1
	PLCFG    volatile.Register8 // 0x2
	_        byte
	INTENCLR volatile.Register8 // 0x4
	INTENSET volatile.Register8 // 0x5
	INTFLAG  volatile.Register8 // 0x6
	_        byte
	STDBYCFG volatile.Register16 // 0x8
}

// PM.CTRLA: Control A
func (o *PM_Type) SetCTRLA_IORET(value uint8) {
	volatile.StoreUint8(&o.CTRLA.Reg, volatile.LoadUint8(&o.CTRLA.Reg)&^(0x4)|value<<2)
}
func (o *PM_Type) GetCTRLA_IORET() uint8 {
	return (volatile.LoadUint8(&o.CTRLA.Reg) & 0x4) >> 2
}

// PM.SLEEPCFG: Sleep Configuration
func (o *PM_Type) SetSLEEPCFG_SLEEPMODE(value uint8) {
	volatile.StoreUint8(&o.SLEEPCFG.Reg, volatile.LoadUint8(&o.SLEEPCFG.Reg)&^(0x7)|value)
}
func (o *PM_Type) GetSLEEPCFG_SLEEPMODE() uint8 {
	return volatile.LoadUint8(&o.SLEEPCFG.Reg) & 0x7
}

// PM.PLCFG: Performance Level Configuration
func (o *PM_Type) SetPLCFG_PLSEL(value uint8) {
	volatile.StoreUint8(&o.PLCFG.Reg, volatile.LoadUint8(&o.PLCFG.Reg)&^(0x3)|value)
}
func (o *PM_Type) GetPLCFG_PLSEL() uint8 {
	return volatile.LoadUint8(&o.PLCFG.Reg) & 0x3
}
func (o *PM_Type) SetPLCFG_PLDIS(value uint8) {
	volatile.StoreUint8(&o.PLCFG.Reg, volatile.LoadUint8(&o.PLCFG.Reg)&^(0x80)|value<<7)
}
func (o *PM_Type) GetPLCFG_PLDIS() uint8 {
	return (volatile.LoadUint8(&o.PLCFG.Reg) & 0x80) >> 7
}

// PM.INTENCLR: Interrupt Enable Clear
func (o *PM_Type) SetINTENCLR_PLRDY(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *PM_Type) GetINTENCLR_PLRDY() uint8 {
	return volatile.LoadUint8(&o.INTENCLR.Reg) & 0x1
}

// PM.INTENSET: Interrupt Enable Set
func (o *PM_Type) SetINTENSET_PLRDY(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *PM_Type) GetINTENSET_PLRDY() uint8 {
	return volatile.LoadUint8(&o.INTENSET.Reg) & 0x1
}

// PM.INTFLAG: Interrupt Flag Status and Clear
func (o *PM_Type) SetINTFLAG_PLRDY(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x1)|value)
}
func (o *PM_Type) GetINTFLAG_PLRDY() uint8 {
	return volatile.LoadUint8(&o.INTFLAG.Reg) & 0x1
}

// PM.STDBYCFG: Standby Configuration
func (o *PM_Type) SetSTDBYCFG_VREGSMOD(value uint16) {
	volatile.StoreUint16(&o.STDBYCFG.Reg, volatile.LoadUint16(&o.STDBYCFG.Reg)&^(0xc0)|value<<6)
}
func (o *PM_Type) GetSTDBYCFG_VREGSMOD() uint16 {
	return (volatile.LoadUint16(&o.STDBYCFG.Reg) & 0xc0) >> 6
}
func (o *PM_Type) SetSTDBYCFG_BBIASHS(value uint16) {
	volatile.StoreUint16(&o.STDBYCFG.Reg, volatile.LoadUint16(&o.STDBYCFG.Reg)&^(0xc00)|value<<10)
}
func (o *PM_Type) GetSTDBYCFG_BBIASHS() uint16 {
	return (volatile.LoadUint16(&o.STDBYCFG.Reg) & 0xc00) >> 10
}

// Port Module
type PORT_Type struct {
	DIR0       volatile.Register32 // 0x0
	DIRCLR0    volatile.Register32 // 0x4
	DIRSET0    volatile.Register32 // 0x8
	DIRTGL0    volatile.Register32 // 0xC
	OUT0       volatile.Register32 // 0x10
	OUTCLR0    volatile.Register32 // 0x14
	OUTSET0    volatile.Register32 // 0x18
	OUTTGL0    volatile.Register32 // 0x1C
	IN0        volatile.Register32 // 0x20
	CTRL0      volatile.Register32 // 0x24
	WRCONFIG0  volatile.Register32 // 0x28
	EVCTRL0    volatile.Register32 // 0x2C
	PMUX0_0    volatile.Register8  // 0x30
	PMUX0_1    volatile.Register8  // 0x31
	PMUX0_2    volatile.Register8  // 0x32
	PMUX0_3    volatile.Register8  // 0x33
	PMUX0_4    volatile.Register8  // 0x34
	PMUX0_5    volatile.Register8  // 0x35
	PMUX0_6    volatile.Register8  // 0x36
	PMUX0_7    volatile.Register8  // 0x37
	PMUX0_8    volatile.Register8  // 0x38
	PMUX0_9    volatile.Register8  // 0x39
	PMUX0_10   volatile.Register8  // 0x3A
	PMUX0_11   volatile.Register8  // 0x3B
	PMUX0_12   volatile.Register8  // 0x3C
	PMUX0_13   volatile.Register8  // 0x3D
	PMUX0_14   volatile.Register8  // 0x3E
	PMUX0_15   volatile.Register8  // 0x3F
	PINCFG0_0  volatile.Register8  // 0x40
	PINCFG0_1  volatile.Register8  // 0x41
	PINCFG0_2  volatile.Register8  // 0x42
	PINCFG0_3  volatile.Register8  // 0x43
	PINCFG0_4  volatile.Register8  // 0x44
	PINCFG0_5  volatile.Register8  // 0x45
	PINCFG0_6  volatile.Register8  // 0x46
	PINCFG0_7  volatile.Register8  // 0x47
	PINCFG0_8  volatile.Register8  // 0x48
	PINCFG0_9  volatile.Register8  // 0x49
	PINCFG0_10 volatile.Register8  // 0x4A
	PINCFG0_11 volatile.Register8  // 0x4B
	PINCFG0_12 volatile.Register8  // 0x4C
	PINCFG0_13 volatile.Register8  // 0x4D
	PINCFG0_14 volatile.Register8  // 0x4E
	PINCFG0_15 volatile.Register8  // 0x4F
	PINCFG0_16 volatile.Register8  // 0x50
	PINCFG0_17 volatile.Register8  // 0x51
	PINCFG0_18 volatile.Register8  // 0x52
	PINCFG0_19 volatile.Register8  // 0x53
	PINCFG0_20 volatile.Register8  // 0x54
	PINCFG0_21 volatile.Register8  // 0x55
	PINCFG0_22 volatile.Register8  // 0x56
	PINCFG0_23 volatile.Register8  // 0x57
	PINCFG0_24 volatile.Register8  // 0x58
	PINCFG0_25 volatile.Register8  // 0x59
	PINCFG0_26 volatile.Register8  // 0x5A
	PINCFG0_27 volatile.Register8  // 0x5B
	PINCFG0_28 volatile.Register8  // 0x5C
	PINCFG0_29 volatile.Register8  // 0x5D
	PINCFG0_30 volatile.Register8  // 0x5E
	PINCFG0_31 volatile.Register8  // 0x5F
	_          [32]byte
	DIR1       volatile.Register32 // 0x80
	DIRCLR1    volatile.Register32 // 0x84
	DIRSET1    volatile.Register32 // 0x88
	DIRTGL1    volatile.Register32 // 0x8C
	OUT1       volatile.Register32 // 0x90
	OUTCLR1    volatile.Register32 // 0x94
	OUTSET1    volatile.Register32 // 0x98
	OUTTGL1    volatile.Register32 // 0x9C
	IN1        volatile.Register32 // 0xA0
	CTRL1      volatile.Register32 // 0xA4
	WRCONFIG1  volatile.Register32 // 0xA8
	EVCTRL1    volatile.Register32 // 0xAC
	PMUX1_0    volatile.Register32 // 0xB0
	PMUX1_4    volatile.Register32 // 0xB4
	PMUX1_8    volatile.Register32 // 0xB8
	PMUX1_12   volatile.Register32 // 0xBC
	PINCFG1_0  volatile.Register32 // 0xC0
	PINCFG1_4  volatile.Register32 // 0xC4
	PINCFG1_8  volatile.Register32 // 0xC8
	PINCFG1_12 volatile.Register32 // 0xCC
	PINCFG1_16 volatile.Register32 // 0xD0
	PINCFG1_20 volatile.Register32 // 0xD4
	PINCFG1_24 volatile.Register32 // 0xD8
	PINCFG1_28 volatile.Register32 // 0xDC
}

// PORT.CTRL0: Control
func (o *PORT_Type) SetCTRL0(value uint32) {
	volatile.StoreUint32(&o.CTRL0.Reg, value)
}
func (o *PORT_Type) GetCTRL0() uint32 {
	return volatile.LoadUint32(&o.CTRL0.Reg)
}

// PORT.WRCONFIG0: Write Configuration
func (o *PORT_Type) SetWRCONFIG0_PINMASK(value uint32) {
	volatile.StoreUint32(&o.WRCONFIG0.Reg, volatile.LoadUint32(&o.WRCONFIG0.Reg)&^(0xffff)|value)
}
func (o *PORT_Type) GetWRCONFIG0_PINMASK() uint32 {
	return volatile.LoadUint32(&o.WRCONFIG0.Reg) & 0xffff
}
func (o *PORT_Type) SetWRCONFIG0_PMUXEN(value uint32) {
	volatile.StoreUint32(&o.WRCONFIG0.Reg, volatile.LoadUint32(&o.WRCONFIG0.Reg)&^(0x10000)|value<<16)
}
func (o *PORT_Type) GetWRCONFIG0_PMUXEN() uint32 {
	return (volatile.LoadUint32(&o.WRCONFIG0.Reg) & 0x10000) >> 16
}
func (o *PORT_Type) SetWRCONFIG0_INEN(value uint32) {
	volatile.StoreUint32(&o.WRCONFIG0.Reg, volatile.LoadUint32(&o.WRCONFIG0.Reg)&^(0x20000)|value<<17)
}
func (o *PORT_Type) GetWRCONFIG0_INEN() uint32 {
	return (volatile.LoadUint32(&o.WRCONFIG0.Reg) & 0x20000) >> 17
}
func (o *PORT_Type) SetWRCONFIG0_PULLEN(value uint32) {
	volatile.StoreUint32(&o.WRCONFIG0.Reg, volatile.LoadUint32(&o.WRCONFIG0.Reg)&^(0x40000)|value<<18)
}
func (o *PORT_Type) GetWRCONFIG0_PULLEN() uint32 {
	return (volatile.LoadUint32(&o.WRCONFIG0.Reg) & 0x40000) >> 18
}
func (o *PORT_Type) SetWRCONFIG0_DRVSTR(value uint32) {
	volatile.StoreUint32(&o.WRCONFIG0.Reg, volatile.LoadUint32(&o.WRCONFIG0.Reg)&^(0x400000)|value<<22)
}
func (o *PORT_Type) GetWRCONFIG0_DRVSTR() uint32 {
	return (volatile.LoadUint32(&o.WRCONFIG0.Reg) & 0x400000) >> 22
}
func (o *PORT_Type) SetWRCONFIG0_PMUX(value uint32) {
	volatile.StoreUint32(&o.WRCONFIG0.Reg, volatile.LoadUint32(&o.WRCONFIG0.Reg)&^(0xf000000)|value<<24)
}
func (o *PORT_Type) GetWRCONFIG0_PMUX() uint32 {
	return (volatile.LoadUint32(&o.WRCONFIG0.Reg) & 0xf000000) >> 24
}
func (o *PORT_Type) SetWRCONFIG0_WRPMUX(value uint32) {
	volatile.StoreUint32(&o.WRCONFIG0.Reg, volatile.LoadUint32(&o.WRCONFIG0.Reg)&^(0x10000000)|value<<28)
}
func (o *PORT_Type) GetWRCONFIG0_WRPMUX() uint32 {
	return (volatile.LoadUint32(&o.WRCONFIG0.Reg) & 0x10000000) >> 28
}
func (o *PORT_Type) SetWRCONFIG0_WRPINCFG(value uint32) {
	volatile.StoreUint32(&o.WRCONFIG0.Reg, volatile.LoadUint32(&o.WRCONFIG0.Reg)&^(0x40000000)|value<<30)
}
func (o *PORT_Type) GetWRCONFIG0_WRPINCFG() uint32 {
	return (volatile.LoadUint32(&o.WRCONFIG0.Reg) & 0x40000000) >> 30
}
func (o *PORT_Type) SetWRCONFIG0_HWSEL(value uint32) {
	volatile.StoreUint32(&o.WRCONFIG0.Reg, volatile.LoadUint32(&o.WRCONFIG0.Reg)&^(0x80000000)|value<<31)
}
func (o *PORT_Type) GetWRCONFIG0_HWSEL() uint32 {
	return (volatile.LoadUint32(&o.WRCONFIG0.Reg) & 0x80000000) >> 31
}

// PORT.EVCTRL0: Event Input Control
func (o *PORT_Type) SetEVCTRL0_PID0(value uint32) {
	volatile.StoreUint32(&o.EVCTRL0.Reg, volatile.LoadUint32(&o.EVCTRL0.Reg)&^(0x1f)|value)
}
func (o *PORT_Type) GetEVCTRL0_PID0() uint32 {
	return volatile.LoadUint32(&o.EVCTRL0.Reg) & 0x1f
}
func (o *PORT_Type) SetEVCTRL0_EVACT0(value uint32) {
	volatile.StoreUint32(&o.EVCTRL0.Reg, volatile.LoadUint32(&o.EVCTRL0.Reg)&^(0x60)|value<<5)
}
func (o *PORT_Type) GetEVCTRL0_EVACT0() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL0.Reg) & 0x60) >> 5
}
func (o *PORT_Type) SetEVCTRL0_PORTEI0(value uint32) {
	volatile.StoreUint32(&o.EVCTRL0.Reg, volatile.LoadUint32(&o.EVCTRL0.Reg)&^(0x80)|value<<7)
}
func (o *PORT_Type) GetEVCTRL0_PORTEI0() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL0.Reg) & 0x80) >> 7
}
func (o *PORT_Type) SetEVCTRL0_PID1(value uint32) {
	volatile.StoreUint32(&o.EVCTRL0.Reg, volatile.LoadUint32(&o.EVCTRL0.Reg)&^(0x1f00)|value<<8)
}
func (o *PORT_Type) GetEVCTRL0_PID1() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL0.Reg) & 0x1f00) >> 8
}
func (o *PORT_Type) SetEVCTRL0_EVACT1(value uint32) {
	volatile.StoreUint32(&o.EVCTRL0.Reg, volatile.LoadUint32(&o.EVCTRL0.Reg)&^(0x6000)|value<<13)
}
func (o *PORT_Type) GetEVCTRL0_EVACT1() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL0.Reg) & 0x6000) >> 13
}
func (o *PORT_Type) SetEVCTRL0_PORTEI1(value uint32) {
	volatile.StoreUint32(&o.EVCTRL0.Reg, volatile.LoadUint32(&o.EVCTRL0.Reg)&^(0x8000)|value<<15)
}
func (o *PORT_Type) GetEVCTRL0_PORTEI1() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL0.Reg) & 0x8000) >> 15
}
func (o *PORT_Type) SetEVCTRL0_PID2(value uint32) {
	volatile.StoreUint32(&o.EVCTRL0.Reg, volatile.LoadUint32(&o.EVCTRL0.Reg)&^(0x1f0000)|value<<16)
}
func (o *PORT_Type) GetEVCTRL0_PID2() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL0.Reg) & 0x1f0000) >> 16
}
func (o *PORT_Type) SetEVCTRL0_EVACT2(value uint32) {
	volatile.StoreUint32(&o.EVCTRL0.Reg, volatile.LoadUint32(&o.EVCTRL0.Reg)&^(0x600000)|value<<21)
}
func (o *PORT_Type) GetEVCTRL0_EVACT2() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL0.Reg) & 0x600000) >> 21
}
func (o *PORT_Type) SetEVCTRL0_PORTEI2(value uint32) {
	volatile.StoreUint32(&o.EVCTRL0.Reg, volatile.LoadUint32(&o.EVCTRL0.Reg)&^(0x800000)|value<<23)
}
func (o *PORT_Type) GetEVCTRL0_PORTEI2() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL0.Reg) & 0x800000) >> 23
}
func (o *PORT_Type) SetEVCTRL0_PID3(value uint32) {
	volatile.StoreUint32(&o.EVCTRL0.Reg, volatile.LoadUint32(&o.EVCTRL0.Reg)&^(0x1f000000)|value<<24)
}
func (o *PORT_Type) GetEVCTRL0_PID3() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL0.Reg) & 0x1f000000) >> 24
}
func (o *PORT_Type) SetEVCTRL0_EVACT3(value uint32) {
	volatile.StoreUint32(&o.EVCTRL0.Reg, volatile.LoadUint32(&o.EVCTRL0.Reg)&^(0x60000000)|value<<29)
}
func (o *PORT_Type) GetEVCTRL0_EVACT3() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL0.Reg) & 0x60000000) >> 29
}
func (o *PORT_Type) SetEVCTRL0_PORTEI3(value uint32) {
	volatile.StoreUint32(&o.EVCTRL0.Reg, volatile.LoadUint32(&o.EVCTRL0.Reg)&^(0x80000000)|value<<31)
}
func (o *PORT_Type) GetEVCTRL0_PORTEI3() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL0.Reg) & 0x80000000) >> 31
}

// PORT.PMUX0_0: Peripheral Multiplexing n - Group 0
func (o *PORT_Type) SetPMUX0_0_PMUXE(value uint8) {
	volatile.StoreUint8(&o.PMUX0_0.Reg, volatile.LoadUint8(&o.PMUX0_0.Reg)&^(0xf)|value)
}
func (o *PORT_Type) GetPMUX0_0_PMUXE() uint8 {
	return volatile.LoadUint8(&o.PMUX0_0.Reg) & 0xf
}
func (o *PORT_Type) SetPMUX0_0_PMUXO(value uint8) {
	volatile.StoreUint8(&o.PMUX0_0.Reg, volatile.LoadUint8(&o.PMUX0_0.Reg)&^(0xf0)|value<<4)
}
func (o *PORT_Type) GetPMUX0_0_PMUXO() uint8 {
	return (volatile.LoadUint8(&o.PMUX0_0.Reg) & 0xf0) >> 4
}

// PORT.PMUX0_1: Peripheral Multiplexing n - Group 0
func (o *PORT_Type) SetPMUX0_1_PMUXE(value uint8) {
	volatile.StoreUint8(&o.PMUX0_1.Reg, volatile.LoadUint8(&o.PMUX0_1.Reg)&^(0xf)|value)
}
func (o *PORT_Type) GetPMUX0_1_PMUXE() uint8 {
	return volatile.LoadUint8(&o.PMUX0_1.Reg) & 0xf
}
func (o *PORT_Type) SetPMUX0_1_PMUXO(value uint8) {
	volatile.StoreUint8(&o.PMUX0_1.Reg, volatile.LoadUint8(&o.PMUX0_1.Reg)&^(0xf0)|value<<4)
}
func (o *PORT_Type) GetPMUX0_1_PMUXO() uint8 {
	return (volatile.LoadUint8(&o.PMUX0_1.Reg) & 0xf0) >> 4
}

// PORT.PMUX0_2: Peripheral Multiplexing n - Group 0
func (o *PORT_Type) SetPMUX0_2_PMUXE(value uint8) {
	volatile.StoreUint8(&o.PMUX0_2.Reg, volatile.LoadUint8(&o.PMUX0_2.Reg)&^(0xf)|value)
}
func (o *PORT_Type) GetPMUX0_2_PMUXE() uint8 {
	return volatile.LoadUint8(&o.PMUX0_2.Reg) & 0xf
}
func (o *PORT_Type) SetPMUX0_2_PMUXO(value uint8) {
	volatile.StoreUint8(&o.PMUX0_2.Reg, volatile.LoadUint8(&o.PMUX0_2.Reg)&^(0xf0)|value<<4)
}
func (o *PORT_Type) GetPMUX0_2_PMUXO() uint8 {
	return (volatile.LoadUint8(&o.PMUX0_2.Reg) & 0xf0) >> 4
}

// PORT.PMUX0_3: Peripheral Multiplexing n - Group 0
func (o *PORT_Type) SetPMUX0_3_PMUXE(value uint8) {
	volatile.StoreUint8(&o.PMUX0_3.Reg, volatile.LoadUint8(&o.PMUX0_3.Reg)&^(0xf)|value)
}
func (o *PORT_Type) GetPMUX0_3_PMUXE() uint8 {
	return volatile.LoadUint8(&o.PMUX0_3.Reg) & 0xf
}
func (o *PORT_Type) SetPMUX0_3_PMUXO(value uint8) {
	volatile.StoreUint8(&o.PMUX0_3.Reg, volatile.LoadUint8(&o.PMUX0_3.Reg)&^(0xf0)|value<<4)
}
func (o *PORT_Type) GetPMUX0_3_PMUXO() uint8 {
	return (volatile.LoadUint8(&o.PMUX0_3.Reg) & 0xf0) >> 4
}

// PORT.PMUX0_4: Peripheral Multiplexing n - Group 0
func (o *PORT_Type) SetPMUX0_4_PMUXE(value uint8) {
	volatile.StoreUint8(&o.PMUX0_4.Reg, volatile.LoadUint8(&o.PMUX0_4.Reg)&^(0xf)|value)
}
func (o *PORT_Type) GetPMUX0_4_PMUXE() uint8 {
	return volatile.LoadUint8(&o.PMUX0_4.Reg) & 0xf
}
func (o *PORT_Type) SetPMUX0_4_PMUXO(value uint8) {
	volatile.StoreUint8(&o.PMUX0_4.Reg, volatile.LoadUint8(&o.PMUX0_4.Reg)&^(0xf0)|value<<4)
}
func (o *PORT_Type) GetPMUX0_4_PMUXO() uint8 {
	return (volatile.LoadUint8(&o.PMUX0_4.Reg) & 0xf0) >> 4
}

// PORT.PMUX0_5: Peripheral Multiplexing n - Group 0
func (o *PORT_Type) SetPMUX0_5_PMUXE(value uint8) {
	volatile.StoreUint8(&o.PMUX0_5.Reg, volatile.LoadUint8(&o.PMUX0_5.Reg)&^(0xf)|value)
}
func (o *PORT_Type) GetPMUX0_5_PMUXE() uint8 {
	return volatile.LoadUint8(&o.PMUX0_5.Reg) & 0xf
}
func (o *PORT_Type) SetPMUX0_5_PMUXO(value uint8) {
	volatile.StoreUint8(&o.PMUX0_5.Reg, volatile.LoadUint8(&o.PMUX0_5.Reg)&^(0xf0)|value<<4)
}
func (o *PORT_Type) GetPMUX0_5_PMUXO() uint8 {
	return (volatile.LoadUint8(&o.PMUX0_5.Reg) & 0xf0) >> 4
}

// PORT.PMUX0_6: Peripheral Multiplexing n - Group 0
func (o *PORT_Type) SetPMUX0_6_PMUXE(value uint8) {
	volatile.StoreUint8(&o.PMUX0_6.Reg, volatile.LoadUint8(&o.PMUX0_6.Reg)&^(0xf)|value)
}
func (o *PORT_Type) GetPMUX0_6_PMUXE() uint8 {
	return volatile.LoadUint8(&o.PMUX0_6.Reg) & 0xf
}
func (o *PORT_Type) SetPMUX0_6_PMUXO(value uint8) {
	volatile.StoreUint8(&o.PMUX0_6.Reg, volatile.LoadUint8(&o.PMUX0_6.Reg)&^(0xf0)|value<<4)
}
func (o *PORT_Type) GetPMUX0_6_PMUXO() uint8 {
	return (volatile.LoadUint8(&o.PMUX0_6.Reg) & 0xf0) >> 4
}

// PORT.PMUX0_7: Peripheral Multiplexing n - Group 0
func (o *PORT_Type) SetPMUX0_7_PMUXE(value uint8) {
	volatile.StoreUint8(&o.PMUX0_7.Reg, volatile.LoadUint8(&o.PMUX0_7.Reg)&^(0xf)|value)
}
func (o *PORT_Type) GetPMUX0_7_PMUXE() uint8 {
	return volatile.LoadUint8(&o.PMUX0_7.Reg) & 0xf
}
func (o *PORT_Type) SetPMUX0_7_PMUXO(value uint8) {
	volatile.StoreUint8(&o.PMUX0_7.Reg, volatile.LoadUint8(&o.PMUX0_7.Reg)&^(0xf0)|value<<4)
}
func (o *PORT_Type) GetPMUX0_7_PMUXO() uint8 {
	return (volatile.LoadUint8(&o.PMUX0_7.Reg) & 0xf0) >> 4
}

// PORT.PMUX0_8: Peripheral Multiplexing n - Group 0
func (o *PORT_Type) SetPMUX0_8_PMUXE(value uint8) {
	volatile.StoreUint8(&o.PMUX0_8.Reg, volatile.LoadUint8(&o.PMUX0_8.Reg)&^(0xf)|value)
}
func (o *PORT_Type) GetPMUX0_8_PMUXE() uint8 {
	return volatile.LoadUint8(&o.PMUX0_8.Reg) & 0xf
}
func (o *PORT_Type) SetPMUX0_8_PMUXO(value uint8) {
	volatile.StoreUint8(&o.PMUX0_8.Reg, volatile.LoadUint8(&o.PMUX0_8.Reg)&^(0xf0)|value<<4)
}
func (o *PORT_Type) GetPMUX0_8_PMUXO() uint8 {
	return (volatile.LoadUint8(&o.PMUX0_8.Reg) & 0xf0) >> 4
}

// PORT.PMUX0_9: Peripheral Multiplexing n - Group 0
func (o *PORT_Type) SetPMUX0_9_PMUXE(value uint8) {
	volatile.StoreUint8(&o.PMUX0_9.Reg, volatile.LoadUint8(&o.PMUX0_9.Reg)&^(0xf)|value)
}
func (o *PORT_Type) GetPMUX0_9_PMUXE() uint8 {
	return volatile.LoadUint8(&o.PMUX0_9.Reg) & 0xf
}
func (o *PORT_Type) SetPMUX0_9_PMUXO(value uint8) {
	volatile.StoreUint8(&o.PMUX0_9.Reg, volatile.LoadUint8(&o.PMUX0_9.Reg)&^(0xf0)|value<<4)
}
func (o *PORT_Type) GetPMUX0_9_PMUXO() uint8 {
	return (volatile.LoadUint8(&o.PMUX0_9.Reg) & 0xf0) >> 4
}

// PORT.PMUX0_10: Peripheral Multiplexing n - Group 0
func (o *PORT_Type) SetPMUX0_10_PMUXE(value uint8) {
	volatile.StoreUint8(&o.PMUX0_10.Reg, volatile.LoadUint8(&o.PMUX0_10.Reg)&^(0xf)|value)
}
func (o *PORT_Type) GetPMUX0_10_PMUXE() uint8 {
	return volatile.LoadUint8(&o.PMUX0_10.Reg) & 0xf
}
func (o *PORT_Type) SetPMUX0_10_PMUXO(value uint8) {
	volatile.StoreUint8(&o.PMUX0_10.Reg, volatile.LoadUint8(&o.PMUX0_10.Reg)&^(0xf0)|value<<4)
}
func (o *PORT_Type) GetPMUX0_10_PMUXO() uint8 {
	return (volatile.LoadUint8(&o.PMUX0_10.Reg) & 0xf0) >> 4
}

// PORT.PMUX0_11: Peripheral Multiplexing n - Group 0
func (o *PORT_Type) SetPMUX0_11_PMUXE(value uint8) {
	volatile.StoreUint8(&o.PMUX0_11.Reg, volatile.LoadUint8(&o.PMUX0_11.Reg)&^(0xf)|value)
}
func (o *PORT_Type) GetPMUX0_11_PMUXE() uint8 {
	return volatile.LoadUint8(&o.PMUX0_11.Reg) & 0xf
}
func (o *PORT_Type) SetPMUX0_11_PMUXO(value uint8) {
	volatile.StoreUint8(&o.PMUX0_11.Reg, volatile.LoadUint8(&o.PMUX0_11.Reg)&^(0xf0)|value<<4)
}
func (o *PORT_Type) GetPMUX0_11_PMUXO() uint8 {
	return (volatile.LoadUint8(&o.PMUX0_11.Reg) & 0xf0) >> 4
}

// PORT.PMUX0_12: Peripheral Multiplexing n - Group 0
func (o *PORT_Type) SetPMUX0_12_PMUXE(value uint8) {
	volatile.StoreUint8(&o.PMUX0_12.Reg, volatile.LoadUint8(&o.PMUX0_12.Reg)&^(0xf)|value)
}
func (o *PORT_Type) GetPMUX0_12_PMUXE() uint8 {
	return volatile.LoadUint8(&o.PMUX0_12.Reg) & 0xf
}
func (o *PORT_Type) SetPMUX0_12_PMUXO(value uint8) {
	volatile.StoreUint8(&o.PMUX0_12.Reg, volatile.LoadUint8(&o.PMUX0_12.Reg)&^(0xf0)|value<<4)
}
func (o *PORT_Type) GetPMUX0_12_PMUXO() uint8 {
	return (volatile.LoadUint8(&o.PMUX0_12.Reg) & 0xf0) >> 4
}

// PORT.PMUX0_13: Peripheral Multiplexing n - Group 0
func (o *PORT_Type) SetPMUX0_13_PMUXE(value uint8) {
	volatile.StoreUint8(&o.PMUX0_13.Reg, volatile.LoadUint8(&o.PMUX0_13.Reg)&^(0xf)|value)
}
func (o *PORT_Type) GetPMUX0_13_PMUXE() uint8 {
	return volatile.LoadUint8(&o.PMUX0_13.Reg) & 0xf
}
func (o *PORT_Type) SetPMUX0_13_PMUXO(value uint8) {
	volatile.StoreUint8(&o.PMUX0_13.Reg, volatile.LoadUint8(&o.PMUX0_13.Reg)&^(0xf0)|value<<4)
}
func (o *PORT_Type) GetPMUX0_13_PMUXO() uint8 {
	return (volatile.LoadUint8(&o.PMUX0_13.Reg) & 0xf0) >> 4
}

// PORT.PMUX0_14: Peripheral Multiplexing n - Group 0
func (o *PORT_Type) SetPMUX0_14_PMUXE(value uint8) {
	volatile.StoreUint8(&o.PMUX0_14.Reg, volatile.LoadUint8(&o.PMUX0_14.Reg)&^(0xf)|value)
}
func (o *PORT_Type) GetPMUX0_14_PMUXE() uint8 {
	return volatile.LoadUint8(&o.PMUX0_14.Reg) & 0xf
}
func (o *PORT_Type) SetPMUX0_14_PMUXO(value uint8) {
	volatile.StoreUint8(&o.PMUX0_14.Reg, volatile.LoadUint8(&o.PMUX0_14.Reg)&^(0xf0)|value<<4)
}
func (o *PORT_Type) GetPMUX0_14_PMUXO() uint8 {
	return (volatile.LoadUint8(&o.PMUX0_14.Reg) & 0xf0) >> 4
}

// PORT.PMUX0_15: Peripheral Multiplexing n - Group 0
func (o *PORT_Type) SetPMUX0_15_PMUXE(value uint8) {
	volatile.StoreUint8(&o.PMUX0_15.Reg, volatile.LoadUint8(&o.PMUX0_15.Reg)&^(0xf)|value)
}
func (o *PORT_Type) GetPMUX0_15_PMUXE() uint8 {
	return volatile.LoadUint8(&o.PMUX0_15.Reg) & 0xf
}
func (o *PORT_Type) SetPMUX0_15_PMUXO(value uint8) {
	volatile.StoreUint8(&o.PMUX0_15.Reg, volatile.LoadUint8(&o.PMUX0_15.Reg)&^(0xf0)|value<<4)
}
func (o *PORT_Type) GetPMUX0_15_PMUXO() uint8 {
	return (volatile.LoadUint8(&o.PMUX0_15.Reg) & 0xf0) >> 4
}

// PORT.PINCFG0_0: Pin Configuration n - Group 0
func (o *PORT_Type) SetPINCFG0_0_PMUXEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_0.Reg, volatile.LoadUint8(&o.PINCFG0_0.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPINCFG0_0_PMUXEN() uint8 {
	return volatile.LoadUint8(&o.PINCFG0_0.Reg) & 0x1
}
func (o *PORT_Type) SetPINCFG0_0_INEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_0.Reg, volatile.LoadUint8(&o.PINCFG0_0.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPINCFG0_0_INEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_0.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPINCFG0_0_PULLEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_0.Reg, volatile.LoadUint8(&o.PINCFG0_0.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPINCFG0_0_PULLEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_0.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPINCFG0_0_DRVSTR(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_0.Reg, volatile.LoadUint8(&o.PINCFG0_0.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPINCFG0_0_DRVSTR() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_0.Reg) & 0x40) >> 6
}

// PORT.PINCFG0_1: Pin Configuration n - Group 0
func (o *PORT_Type) SetPINCFG0_1_PMUXEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_1.Reg, volatile.LoadUint8(&o.PINCFG0_1.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPINCFG0_1_PMUXEN() uint8 {
	return volatile.LoadUint8(&o.PINCFG0_1.Reg) & 0x1
}
func (o *PORT_Type) SetPINCFG0_1_INEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_1.Reg, volatile.LoadUint8(&o.PINCFG0_1.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPINCFG0_1_INEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_1.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPINCFG0_1_PULLEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_1.Reg, volatile.LoadUint8(&o.PINCFG0_1.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPINCFG0_1_PULLEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_1.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPINCFG0_1_DRVSTR(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_1.Reg, volatile.LoadUint8(&o.PINCFG0_1.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPINCFG0_1_DRVSTR() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_1.Reg) & 0x40) >> 6
}

// PORT.PINCFG0_2: Pin Configuration n - Group 0
func (o *PORT_Type) SetPINCFG0_2_PMUXEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_2.Reg, volatile.LoadUint8(&o.PINCFG0_2.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPINCFG0_2_PMUXEN() uint8 {
	return volatile.LoadUint8(&o.PINCFG0_2.Reg) & 0x1
}
func (o *PORT_Type) SetPINCFG0_2_INEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_2.Reg, volatile.LoadUint8(&o.PINCFG0_2.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPINCFG0_2_INEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_2.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPINCFG0_2_PULLEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_2.Reg, volatile.LoadUint8(&o.PINCFG0_2.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPINCFG0_2_PULLEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_2.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPINCFG0_2_DRVSTR(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_2.Reg, volatile.LoadUint8(&o.PINCFG0_2.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPINCFG0_2_DRVSTR() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_2.Reg) & 0x40) >> 6
}

// PORT.PINCFG0_3: Pin Configuration n - Group 0
func (o *PORT_Type) SetPINCFG0_3_PMUXEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_3.Reg, volatile.LoadUint8(&o.PINCFG0_3.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPINCFG0_3_PMUXEN() uint8 {
	return volatile.LoadUint8(&o.PINCFG0_3.Reg) & 0x1
}
func (o *PORT_Type) SetPINCFG0_3_INEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_3.Reg, volatile.LoadUint8(&o.PINCFG0_3.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPINCFG0_3_INEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_3.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPINCFG0_3_PULLEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_3.Reg, volatile.LoadUint8(&o.PINCFG0_3.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPINCFG0_3_PULLEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_3.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPINCFG0_3_DRVSTR(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_3.Reg, volatile.LoadUint8(&o.PINCFG0_3.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPINCFG0_3_DRVSTR() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_3.Reg) & 0x40) >> 6
}

// PORT.PINCFG0_4: Pin Configuration n - Group 0
func (o *PORT_Type) SetPINCFG0_4_PMUXEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_4.Reg, volatile.LoadUint8(&o.PINCFG0_4.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPINCFG0_4_PMUXEN() uint8 {
	return volatile.LoadUint8(&o.PINCFG0_4.Reg) & 0x1
}
func (o *PORT_Type) SetPINCFG0_4_INEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_4.Reg, volatile.LoadUint8(&o.PINCFG0_4.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPINCFG0_4_INEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_4.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPINCFG0_4_PULLEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_4.Reg, volatile.LoadUint8(&o.PINCFG0_4.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPINCFG0_4_PULLEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_4.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPINCFG0_4_DRVSTR(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_4.Reg, volatile.LoadUint8(&o.PINCFG0_4.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPINCFG0_4_DRVSTR() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_4.Reg) & 0x40) >> 6
}

// PORT.PINCFG0_5: Pin Configuration n - Group 0
func (o *PORT_Type) SetPINCFG0_5_PMUXEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_5.Reg, volatile.LoadUint8(&o.PINCFG0_5.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPINCFG0_5_PMUXEN() uint8 {
	return volatile.LoadUint8(&o.PINCFG0_5.Reg) & 0x1
}
func (o *PORT_Type) SetPINCFG0_5_INEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_5.Reg, volatile.LoadUint8(&o.PINCFG0_5.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPINCFG0_5_INEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_5.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPINCFG0_5_PULLEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_5.Reg, volatile.LoadUint8(&o.PINCFG0_5.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPINCFG0_5_PULLEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_5.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPINCFG0_5_DRVSTR(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_5.Reg, volatile.LoadUint8(&o.PINCFG0_5.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPINCFG0_5_DRVSTR() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_5.Reg) & 0x40) >> 6
}

// PORT.PINCFG0_6: Pin Configuration n - Group 0
func (o *PORT_Type) SetPINCFG0_6_PMUXEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_6.Reg, volatile.LoadUint8(&o.PINCFG0_6.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPINCFG0_6_PMUXEN() uint8 {
	return volatile.LoadUint8(&o.PINCFG0_6.Reg) & 0x1
}
func (o *PORT_Type) SetPINCFG0_6_INEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_6.Reg, volatile.LoadUint8(&o.PINCFG0_6.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPINCFG0_6_INEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_6.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPINCFG0_6_PULLEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_6.Reg, volatile.LoadUint8(&o.PINCFG0_6.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPINCFG0_6_PULLEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_6.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPINCFG0_6_DRVSTR(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_6.Reg, volatile.LoadUint8(&o.PINCFG0_6.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPINCFG0_6_DRVSTR() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_6.Reg) & 0x40) >> 6
}

// PORT.PINCFG0_7: Pin Configuration n - Group 0
func (o *PORT_Type) SetPINCFG0_7_PMUXEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_7.Reg, volatile.LoadUint8(&o.PINCFG0_7.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPINCFG0_7_PMUXEN() uint8 {
	return volatile.LoadUint8(&o.PINCFG0_7.Reg) & 0x1
}
func (o *PORT_Type) SetPINCFG0_7_INEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_7.Reg, volatile.LoadUint8(&o.PINCFG0_7.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPINCFG0_7_INEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_7.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPINCFG0_7_PULLEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_7.Reg, volatile.LoadUint8(&o.PINCFG0_7.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPINCFG0_7_PULLEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_7.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPINCFG0_7_DRVSTR(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_7.Reg, volatile.LoadUint8(&o.PINCFG0_7.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPINCFG0_7_DRVSTR() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_7.Reg) & 0x40) >> 6
}

// PORT.PINCFG0_8: Pin Configuration n - Group 0
func (o *PORT_Type) SetPINCFG0_8_PMUXEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_8.Reg, volatile.LoadUint8(&o.PINCFG0_8.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPINCFG0_8_PMUXEN() uint8 {
	return volatile.LoadUint8(&o.PINCFG0_8.Reg) & 0x1
}
func (o *PORT_Type) SetPINCFG0_8_INEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_8.Reg, volatile.LoadUint8(&o.PINCFG0_8.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPINCFG0_8_INEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_8.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPINCFG0_8_PULLEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_8.Reg, volatile.LoadUint8(&o.PINCFG0_8.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPINCFG0_8_PULLEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_8.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPINCFG0_8_DRVSTR(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_8.Reg, volatile.LoadUint8(&o.PINCFG0_8.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPINCFG0_8_DRVSTR() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_8.Reg) & 0x40) >> 6
}

// PORT.PINCFG0_9: Pin Configuration n - Group 0
func (o *PORT_Type) SetPINCFG0_9_PMUXEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_9.Reg, volatile.LoadUint8(&o.PINCFG0_9.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPINCFG0_9_PMUXEN() uint8 {
	return volatile.LoadUint8(&o.PINCFG0_9.Reg) & 0x1
}
func (o *PORT_Type) SetPINCFG0_9_INEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_9.Reg, volatile.LoadUint8(&o.PINCFG0_9.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPINCFG0_9_INEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_9.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPINCFG0_9_PULLEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_9.Reg, volatile.LoadUint8(&o.PINCFG0_9.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPINCFG0_9_PULLEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_9.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPINCFG0_9_DRVSTR(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_9.Reg, volatile.LoadUint8(&o.PINCFG0_9.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPINCFG0_9_DRVSTR() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_9.Reg) & 0x40) >> 6
}

// PORT.PINCFG0_10: Pin Configuration n - Group 0
func (o *PORT_Type) SetPINCFG0_10_PMUXEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_10.Reg, volatile.LoadUint8(&o.PINCFG0_10.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPINCFG0_10_PMUXEN() uint8 {
	return volatile.LoadUint8(&o.PINCFG0_10.Reg) & 0x1
}
func (o *PORT_Type) SetPINCFG0_10_INEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_10.Reg, volatile.LoadUint8(&o.PINCFG0_10.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPINCFG0_10_INEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_10.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPINCFG0_10_PULLEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_10.Reg, volatile.LoadUint8(&o.PINCFG0_10.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPINCFG0_10_PULLEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_10.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPINCFG0_10_DRVSTR(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_10.Reg, volatile.LoadUint8(&o.PINCFG0_10.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPINCFG0_10_DRVSTR() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_10.Reg) & 0x40) >> 6
}

// PORT.PINCFG0_11: Pin Configuration n - Group 0
func (o *PORT_Type) SetPINCFG0_11_PMUXEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_11.Reg, volatile.LoadUint8(&o.PINCFG0_11.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPINCFG0_11_PMUXEN() uint8 {
	return volatile.LoadUint8(&o.PINCFG0_11.Reg) & 0x1
}
func (o *PORT_Type) SetPINCFG0_11_INEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_11.Reg, volatile.LoadUint8(&o.PINCFG0_11.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPINCFG0_11_INEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_11.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPINCFG0_11_PULLEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_11.Reg, volatile.LoadUint8(&o.PINCFG0_11.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPINCFG0_11_PULLEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_11.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPINCFG0_11_DRVSTR(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_11.Reg, volatile.LoadUint8(&o.PINCFG0_11.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPINCFG0_11_DRVSTR() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_11.Reg) & 0x40) >> 6
}

// PORT.PINCFG0_12: Pin Configuration n - Group 0
func (o *PORT_Type) SetPINCFG0_12_PMUXEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_12.Reg, volatile.LoadUint8(&o.PINCFG0_12.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPINCFG0_12_PMUXEN() uint8 {
	return volatile.LoadUint8(&o.PINCFG0_12.Reg) & 0x1
}
func (o *PORT_Type) SetPINCFG0_12_INEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_12.Reg, volatile.LoadUint8(&o.PINCFG0_12.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPINCFG0_12_INEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_12.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPINCFG0_12_PULLEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_12.Reg, volatile.LoadUint8(&o.PINCFG0_12.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPINCFG0_12_PULLEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_12.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPINCFG0_12_DRVSTR(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_12.Reg, volatile.LoadUint8(&o.PINCFG0_12.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPINCFG0_12_DRVSTR() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_12.Reg) & 0x40) >> 6
}

// PORT.PINCFG0_13: Pin Configuration n - Group 0
func (o *PORT_Type) SetPINCFG0_13_PMUXEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_13.Reg, volatile.LoadUint8(&o.PINCFG0_13.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPINCFG0_13_PMUXEN() uint8 {
	return volatile.LoadUint8(&o.PINCFG0_13.Reg) & 0x1
}
func (o *PORT_Type) SetPINCFG0_13_INEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_13.Reg, volatile.LoadUint8(&o.PINCFG0_13.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPINCFG0_13_INEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_13.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPINCFG0_13_PULLEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_13.Reg, volatile.LoadUint8(&o.PINCFG0_13.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPINCFG0_13_PULLEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_13.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPINCFG0_13_DRVSTR(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_13.Reg, volatile.LoadUint8(&o.PINCFG0_13.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPINCFG0_13_DRVSTR() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_13.Reg) & 0x40) >> 6
}

// PORT.PINCFG0_14: Pin Configuration n - Group 0
func (o *PORT_Type) SetPINCFG0_14_PMUXEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_14.Reg, volatile.LoadUint8(&o.PINCFG0_14.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPINCFG0_14_PMUXEN() uint8 {
	return volatile.LoadUint8(&o.PINCFG0_14.Reg) & 0x1
}
func (o *PORT_Type) SetPINCFG0_14_INEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_14.Reg, volatile.LoadUint8(&o.PINCFG0_14.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPINCFG0_14_INEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_14.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPINCFG0_14_PULLEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_14.Reg, volatile.LoadUint8(&o.PINCFG0_14.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPINCFG0_14_PULLEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_14.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPINCFG0_14_DRVSTR(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_14.Reg, volatile.LoadUint8(&o.PINCFG0_14.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPINCFG0_14_DRVSTR() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_14.Reg) & 0x40) >> 6
}

// PORT.PINCFG0_15: Pin Configuration n - Group 0
func (o *PORT_Type) SetPINCFG0_15_PMUXEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_15.Reg, volatile.LoadUint8(&o.PINCFG0_15.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPINCFG0_15_PMUXEN() uint8 {
	return volatile.LoadUint8(&o.PINCFG0_15.Reg) & 0x1
}
func (o *PORT_Type) SetPINCFG0_15_INEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_15.Reg, volatile.LoadUint8(&o.PINCFG0_15.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPINCFG0_15_INEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_15.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPINCFG0_15_PULLEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_15.Reg, volatile.LoadUint8(&o.PINCFG0_15.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPINCFG0_15_PULLEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_15.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPINCFG0_15_DRVSTR(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_15.Reg, volatile.LoadUint8(&o.PINCFG0_15.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPINCFG0_15_DRVSTR() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_15.Reg) & 0x40) >> 6
}

// PORT.PINCFG0_16: Pin Configuration n - Group 0
func (o *PORT_Type) SetPINCFG0_16_PMUXEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_16.Reg, volatile.LoadUint8(&o.PINCFG0_16.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPINCFG0_16_PMUXEN() uint8 {
	return volatile.LoadUint8(&o.PINCFG0_16.Reg) & 0x1
}
func (o *PORT_Type) SetPINCFG0_16_INEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_16.Reg, volatile.LoadUint8(&o.PINCFG0_16.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPINCFG0_16_INEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_16.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPINCFG0_16_PULLEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_16.Reg, volatile.LoadUint8(&o.PINCFG0_16.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPINCFG0_16_PULLEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_16.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPINCFG0_16_DRVSTR(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_16.Reg, volatile.LoadUint8(&o.PINCFG0_16.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPINCFG0_16_DRVSTR() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_16.Reg) & 0x40) >> 6
}

// PORT.PINCFG0_17: Pin Configuration n - Group 0
func (o *PORT_Type) SetPINCFG0_17_PMUXEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_17.Reg, volatile.LoadUint8(&o.PINCFG0_17.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPINCFG0_17_PMUXEN() uint8 {
	return volatile.LoadUint8(&o.PINCFG0_17.Reg) & 0x1
}
func (o *PORT_Type) SetPINCFG0_17_INEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_17.Reg, volatile.LoadUint8(&o.PINCFG0_17.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPINCFG0_17_INEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_17.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPINCFG0_17_PULLEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_17.Reg, volatile.LoadUint8(&o.PINCFG0_17.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPINCFG0_17_PULLEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_17.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPINCFG0_17_DRVSTR(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_17.Reg, volatile.LoadUint8(&o.PINCFG0_17.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPINCFG0_17_DRVSTR() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_17.Reg) & 0x40) >> 6
}

// PORT.PINCFG0_18: Pin Configuration n - Group 0
func (o *PORT_Type) SetPINCFG0_18_PMUXEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_18.Reg, volatile.LoadUint8(&o.PINCFG0_18.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPINCFG0_18_PMUXEN() uint8 {
	return volatile.LoadUint8(&o.PINCFG0_18.Reg) & 0x1
}
func (o *PORT_Type) SetPINCFG0_18_INEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_18.Reg, volatile.LoadUint8(&o.PINCFG0_18.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPINCFG0_18_INEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_18.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPINCFG0_18_PULLEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_18.Reg, volatile.LoadUint8(&o.PINCFG0_18.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPINCFG0_18_PULLEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_18.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPINCFG0_18_DRVSTR(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_18.Reg, volatile.LoadUint8(&o.PINCFG0_18.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPINCFG0_18_DRVSTR() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_18.Reg) & 0x40) >> 6
}

// PORT.PINCFG0_19: Pin Configuration n - Group 0
func (o *PORT_Type) SetPINCFG0_19_PMUXEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_19.Reg, volatile.LoadUint8(&o.PINCFG0_19.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPINCFG0_19_PMUXEN() uint8 {
	return volatile.LoadUint8(&o.PINCFG0_19.Reg) & 0x1
}
func (o *PORT_Type) SetPINCFG0_19_INEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_19.Reg, volatile.LoadUint8(&o.PINCFG0_19.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPINCFG0_19_INEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_19.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPINCFG0_19_PULLEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_19.Reg, volatile.LoadUint8(&o.PINCFG0_19.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPINCFG0_19_PULLEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_19.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPINCFG0_19_DRVSTR(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_19.Reg, volatile.LoadUint8(&o.PINCFG0_19.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPINCFG0_19_DRVSTR() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_19.Reg) & 0x40) >> 6
}

// PORT.PINCFG0_20: Pin Configuration n - Group 0
func (o *PORT_Type) SetPINCFG0_20_PMUXEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_20.Reg, volatile.LoadUint8(&o.PINCFG0_20.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPINCFG0_20_PMUXEN() uint8 {
	return volatile.LoadUint8(&o.PINCFG0_20.Reg) & 0x1
}
func (o *PORT_Type) SetPINCFG0_20_INEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_20.Reg, volatile.LoadUint8(&o.PINCFG0_20.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPINCFG0_20_INEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_20.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPINCFG0_20_PULLEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_20.Reg, volatile.LoadUint8(&o.PINCFG0_20.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPINCFG0_20_PULLEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_20.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPINCFG0_20_DRVSTR(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_20.Reg, volatile.LoadUint8(&o.PINCFG0_20.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPINCFG0_20_DRVSTR() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_20.Reg) & 0x40) >> 6
}

// PORT.PINCFG0_21: Pin Configuration n - Group 0
func (o *PORT_Type) SetPINCFG0_21_PMUXEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_21.Reg, volatile.LoadUint8(&o.PINCFG0_21.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPINCFG0_21_PMUXEN() uint8 {
	return volatile.LoadUint8(&o.PINCFG0_21.Reg) & 0x1
}
func (o *PORT_Type) SetPINCFG0_21_INEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_21.Reg, volatile.LoadUint8(&o.PINCFG0_21.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPINCFG0_21_INEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_21.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPINCFG0_21_PULLEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_21.Reg, volatile.LoadUint8(&o.PINCFG0_21.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPINCFG0_21_PULLEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_21.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPINCFG0_21_DRVSTR(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_21.Reg, volatile.LoadUint8(&o.PINCFG0_21.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPINCFG0_21_DRVSTR() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_21.Reg) & 0x40) >> 6
}

// PORT.PINCFG0_22: Pin Configuration n - Group 0
func (o *PORT_Type) SetPINCFG0_22_PMUXEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_22.Reg, volatile.LoadUint8(&o.PINCFG0_22.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPINCFG0_22_PMUXEN() uint8 {
	return volatile.LoadUint8(&o.PINCFG0_22.Reg) & 0x1
}
func (o *PORT_Type) SetPINCFG0_22_INEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_22.Reg, volatile.LoadUint8(&o.PINCFG0_22.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPINCFG0_22_INEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_22.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPINCFG0_22_PULLEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_22.Reg, volatile.LoadUint8(&o.PINCFG0_22.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPINCFG0_22_PULLEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_22.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPINCFG0_22_DRVSTR(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_22.Reg, volatile.LoadUint8(&o.PINCFG0_22.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPINCFG0_22_DRVSTR() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_22.Reg) & 0x40) >> 6
}

// PORT.PINCFG0_23: Pin Configuration n - Group 0
func (o *PORT_Type) SetPINCFG0_23_PMUXEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_23.Reg, volatile.LoadUint8(&o.PINCFG0_23.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPINCFG0_23_PMUXEN() uint8 {
	return volatile.LoadUint8(&o.PINCFG0_23.Reg) & 0x1
}
func (o *PORT_Type) SetPINCFG0_23_INEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_23.Reg, volatile.LoadUint8(&o.PINCFG0_23.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPINCFG0_23_INEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_23.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPINCFG0_23_PULLEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_23.Reg, volatile.LoadUint8(&o.PINCFG0_23.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPINCFG0_23_PULLEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_23.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPINCFG0_23_DRVSTR(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_23.Reg, volatile.LoadUint8(&o.PINCFG0_23.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPINCFG0_23_DRVSTR() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_23.Reg) & 0x40) >> 6
}

// PORT.PINCFG0_24: Pin Configuration n - Group 0
func (o *PORT_Type) SetPINCFG0_24_PMUXEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_24.Reg, volatile.LoadUint8(&o.PINCFG0_24.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPINCFG0_24_PMUXEN() uint8 {
	return volatile.LoadUint8(&o.PINCFG0_24.Reg) & 0x1
}
func (o *PORT_Type) SetPINCFG0_24_INEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_24.Reg, volatile.LoadUint8(&o.PINCFG0_24.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPINCFG0_24_INEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_24.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPINCFG0_24_PULLEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_24.Reg, volatile.LoadUint8(&o.PINCFG0_24.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPINCFG0_24_PULLEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_24.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPINCFG0_24_DRVSTR(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_24.Reg, volatile.LoadUint8(&o.PINCFG0_24.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPINCFG0_24_DRVSTR() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_24.Reg) & 0x40) >> 6
}

// PORT.PINCFG0_25: Pin Configuration n - Group 0
func (o *PORT_Type) SetPINCFG0_25_PMUXEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_25.Reg, volatile.LoadUint8(&o.PINCFG0_25.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPINCFG0_25_PMUXEN() uint8 {
	return volatile.LoadUint8(&o.PINCFG0_25.Reg) & 0x1
}
func (o *PORT_Type) SetPINCFG0_25_INEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_25.Reg, volatile.LoadUint8(&o.PINCFG0_25.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPINCFG0_25_INEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_25.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPINCFG0_25_PULLEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_25.Reg, volatile.LoadUint8(&o.PINCFG0_25.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPINCFG0_25_PULLEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_25.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPINCFG0_25_DRVSTR(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_25.Reg, volatile.LoadUint8(&o.PINCFG0_25.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPINCFG0_25_DRVSTR() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_25.Reg) & 0x40) >> 6
}

// PORT.PINCFG0_26: Pin Configuration n - Group 0
func (o *PORT_Type) SetPINCFG0_26_PMUXEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_26.Reg, volatile.LoadUint8(&o.PINCFG0_26.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPINCFG0_26_PMUXEN() uint8 {
	return volatile.LoadUint8(&o.PINCFG0_26.Reg) & 0x1
}
func (o *PORT_Type) SetPINCFG0_26_INEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_26.Reg, volatile.LoadUint8(&o.PINCFG0_26.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPINCFG0_26_INEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_26.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPINCFG0_26_PULLEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_26.Reg, volatile.LoadUint8(&o.PINCFG0_26.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPINCFG0_26_PULLEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_26.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPINCFG0_26_DRVSTR(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_26.Reg, volatile.LoadUint8(&o.PINCFG0_26.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPINCFG0_26_DRVSTR() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_26.Reg) & 0x40) >> 6
}

// PORT.PINCFG0_27: Pin Configuration n - Group 0
func (o *PORT_Type) SetPINCFG0_27_PMUXEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_27.Reg, volatile.LoadUint8(&o.PINCFG0_27.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPINCFG0_27_PMUXEN() uint8 {
	return volatile.LoadUint8(&o.PINCFG0_27.Reg) & 0x1
}
func (o *PORT_Type) SetPINCFG0_27_INEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_27.Reg, volatile.LoadUint8(&o.PINCFG0_27.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPINCFG0_27_INEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_27.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPINCFG0_27_PULLEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_27.Reg, volatile.LoadUint8(&o.PINCFG0_27.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPINCFG0_27_PULLEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_27.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPINCFG0_27_DRVSTR(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_27.Reg, volatile.LoadUint8(&o.PINCFG0_27.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPINCFG0_27_DRVSTR() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_27.Reg) & 0x40) >> 6
}

// PORT.PINCFG0_28: Pin Configuration n - Group 0
func (o *PORT_Type) SetPINCFG0_28_PMUXEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_28.Reg, volatile.LoadUint8(&o.PINCFG0_28.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPINCFG0_28_PMUXEN() uint8 {
	return volatile.LoadUint8(&o.PINCFG0_28.Reg) & 0x1
}
func (o *PORT_Type) SetPINCFG0_28_INEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_28.Reg, volatile.LoadUint8(&o.PINCFG0_28.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPINCFG0_28_INEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_28.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPINCFG0_28_PULLEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_28.Reg, volatile.LoadUint8(&o.PINCFG0_28.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPINCFG0_28_PULLEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_28.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPINCFG0_28_DRVSTR(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_28.Reg, volatile.LoadUint8(&o.PINCFG0_28.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPINCFG0_28_DRVSTR() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_28.Reg) & 0x40) >> 6
}

// PORT.PINCFG0_29: Pin Configuration n - Group 0
func (o *PORT_Type) SetPINCFG0_29_PMUXEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_29.Reg, volatile.LoadUint8(&o.PINCFG0_29.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPINCFG0_29_PMUXEN() uint8 {
	return volatile.LoadUint8(&o.PINCFG0_29.Reg) & 0x1
}
func (o *PORT_Type) SetPINCFG0_29_INEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_29.Reg, volatile.LoadUint8(&o.PINCFG0_29.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPINCFG0_29_INEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_29.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPINCFG0_29_PULLEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_29.Reg, volatile.LoadUint8(&o.PINCFG0_29.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPINCFG0_29_PULLEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_29.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPINCFG0_29_DRVSTR(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_29.Reg, volatile.LoadUint8(&o.PINCFG0_29.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPINCFG0_29_DRVSTR() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_29.Reg) & 0x40) >> 6
}

// PORT.PINCFG0_30: Pin Configuration n - Group 0
func (o *PORT_Type) SetPINCFG0_30_PMUXEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_30.Reg, volatile.LoadUint8(&o.PINCFG0_30.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPINCFG0_30_PMUXEN() uint8 {
	return volatile.LoadUint8(&o.PINCFG0_30.Reg) & 0x1
}
func (o *PORT_Type) SetPINCFG0_30_INEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_30.Reg, volatile.LoadUint8(&o.PINCFG0_30.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPINCFG0_30_INEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_30.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPINCFG0_30_PULLEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_30.Reg, volatile.LoadUint8(&o.PINCFG0_30.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPINCFG0_30_PULLEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_30.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPINCFG0_30_DRVSTR(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_30.Reg, volatile.LoadUint8(&o.PINCFG0_30.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPINCFG0_30_DRVSTR() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_30.Reg) & 0x40) >> 6
}

// PORT.PINCFG0_31: Pin Configuration n - Group 0
func (o *PORT_Type) SetPINCFG0_31_PMUXEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_31.Reg, volatile.LoadUint8(&o.PINCFG0_31.Reg)&^(0x1)|value)
}
func (o *PORT_Type) GetPINCFG0_31_PMUXEN() uint8 {
	return volatile.LoadUint8(&o.PINCFG0_31.Reg) & 0x1
}
func (o *PORT_Type) SetPINCFG0_31_INEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_31.Reg, volatile.LoadUint8(&o.PINCFG0_31.Reg)&^(0x2)|value<<1)
}
func (o *PORT_Type) GetPINCFG0_31_INEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_31.Reg) & 0x2) >> 1
}
func (o *PORT_Type) SetPINCFG0_31_PULLEN(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_31.Reg, volatile.LoadUint8(&o.PINCFG0_31.Reg)&^(0x4)|value<<2)
}
func (o *PORT_Type) GetPINCFG0_31_PULLEN() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_31.Reg) & 0x4) >> 2
}
func (o *PORT_Type) SetPINCFG0_31_DRVSTR(value uint8) {
	volatile.StoreUint8(&o.PINCFG0_31.Reg, volatile.LoadUint8(&o.PINCFG0_31.Reg)&^(0x40)|value<<6)
}
func (o *PORT_Type) GetPINCFG0_31_DRVSTR() uint8 {
	return (volatile.LoadUint8(&o.PINCFG0_31.Reg) & 0x40) >> 6
}

// PORT.CTRL1: Control
func (o *PORT_Type) SetCTRL1(value uint32) {
	volatile.StoreUint32(&o.CTRL1.Reg, value)
}
func (o *PORT_Type) GetCTRL1() uint32 {
	return volatile.LoadUint32(&o.CTRL1.Reg)
}

// PORT.WRCONFIG1: Write Configuration
func (o *PORT_Type) SetWRCONFIG1_PINMASK(value uint32) {
	volatile.StoreUint32(&o.WRCONFIG1.Reg, volatile.LoadUint32(&o.WRCONFIG1.Reg)&^(0xffff)|value)
}
func (o *PORT_Type) GetWRCONFIG1_PINMASK() uint32 {
	return volatile.LoadUint32(&o.WRCONFIG1.Reg) & 0xffff
}
func (o *PORT_Type) SetWRCONFIG1_PMUXEN(value uint32) {
	volatile.StoreUint32(&o.WRCONFIG1.Reg, volatile.LoadUint32(&o.WRCONFIG1.Reg)&^(0x10000)|value<<16)
}
func (o *PORT_Type) GetWRCONFIG1_PMUXEN() uint32 {
	return (volatile.LoadUint32(&o.WRCONFIG1.Reg) & 0x10000) >> 16
}
func (o *PORT_Type) SetWRCONFIG1_INEN(value uint32) {
	volatile.StoreUint32(&o.WRCONFIG1.Reg, volatile.LoadUint32(&o.WRCONFIG1.Reg)&^(0x20000)|value<<17)
}
func (o *PORT_Type) GetWRCONFIG1_INEN() uint32 {
	return (volatile.LoadUint32(&o.WRCONFIG1.Reg) & 0x20000) >> 17
}
func (o *PORT_Type) SetWRCONFIG1_PULLEN(value uint32) {
	volatile.StoreUint32(&o.WRCONFIG1.Reg, volatile.LoadUint32(&o.WRCONFIG1.Reg)&^(0x40000)|value<<18)
}
func (o *PORT_Type) GetWRCONFIG1_PULLEN() uint32 {
	return (volatile.LoadUint32(&o.WRCONFIG1.Reg) & 0x40000) >> 18
}
func (o *PORT_Type) SetWRCONFIG1_DRVSTR(value uint32) {
	volatile.StoreUint32(&o.WRCONFIG1.Reg, volatile.LoadUint32(&o.WRCONFIG1.Reg)&^(0x400000)|value<<22)
}
func (o *PORT_Type) GetWRCONFIG1_DRVSTR() uint32 {
	return (volatile.LoadUint32(&o.WRCONFIG1.Reg) & 0x400000) >> 22
}
func (o *PORT_Type) SetWRCONFIG1_PMUX(value uint32) {
	volatile.StoreUint32(&o.WRCONFIG1.Reg, volatile.LoadUint32(&o.WRCONFIG1.Reg)&^(0xf000000)|value<<24)
}
func (o *PORT_Type) GetWRCONFIG1_PMUX() uint32 {
	return (volatile.LoadUint32(&o.WRCONFIG1.Reg) & 0xf000000) >> 24
}
func (o *PORT_Type) SetWRCONFIG1_WRPMUX(value uint32) {
	volatile.StoreUint32(&o.WRCONFIG1.Reg, volatile.LoadUint32(&o.WRCONFIG1.Reg)&^(0x10000000)|value<<28)
}
func (o *PORT_Type) GetWRCONFIG1_WRPMUX() uint32 {
	return (volatile.LoadUint32(&o.WRCONFIG1.Reg) & 0x10000000) >> 28
}
func (o *PORT_Type) SetWRCONFIG1_WRPINCFG(value uint32) {
	volatile.StoreUint32(&o.WRCONFIG1.Reg, volatile.LoadUint32(&o.WRCONFIG1.Reg)&^(0x40000000)|value<<30)
}
func (o *PORT_Type) GetWRCONFIG1_WRPINCFG() uint32 {
	return (volatile.LoadUint32(&o.WRCONFIG1.Reg) & 0x40000000) >> 30
}
func (o *PORT_Type) SetWRCONFIG1_HWSEL(value uint32) {
	volatile.StoreUint32(&o.WRCONFIG1.Reg, volatile.LoadUint32(&o.WRCONFIG1.Reg)&^(0x80000000)|value<<31)
}
func (o *PORT_Type) GetWRCONFIG1_HWSEL() uint32 {
	return (volatile.LoadUint32(&o.WRCONFIG1.Reg) & 0x80000000) >> 31
}

// PORT.EVCTRL1: Event Input Control
func (o *PORT_Type) SetEVCTRL1_PID0(value uint32) {
	volatile.StoreUint32(&o.EVCTRL1.Reg, volatile.LoadUint32(&o.EVCTRL1.Reg)&^(0x1f)|value)
}
func (o *PORT_Type) GetEVCTRL1_PID0() uint32 {
	return volatile.LoadUint32(&o.EVCTRL1.Reg) & 0x1f
}
func (o *PORT_Type) SetEVCTRL1_EVACT0(value uint32) {
	volatile.StoreUint32(&o.EVCTRL1.Reg, volatile.LoadUint32(&o.EVCTRL1.Reg)&^(0x60)|value<<5)
}
func (o *PORT_Type) GetEVCTRL1_EVACT0() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL1.Reg) & 0x60) >> 5
}
func (o *PORT_Type) SetEVCTRL1_PORTEI0(value uint32) {
	volatile.StoreUint32(&o.EVCTRL1.Reg, volatile.LoadUint32(&o.EVCTRL1.Reg)&^(0x80)|value<<7)
}
func (o *PORT_Type) GetEVCTRL1_PORTEI0() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL1.Reg) & 0x80) >> 7
}
func (o *PORT_Type) SetEVCTRL1_PID1(value uint32) {
	volatile.StoreUint32(&o.EVCTRL1.Reg, volatile.LoadUint32(&o.EVCTRL1.Reg)&^(0x1f00)|value<<8)
}
func (o *PORT_Type) GetEVCTRL1_PID1() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL1.Reg) & 0x1f00) >> 8
}
func (o *PORT_Type) SetEVCTRL1_EVACT1(value uint32) {
	volatile.StoreUint32(&o.EVCTRL1.Reg, volatile.LoadUint32(&o.EVCTRL1.Reg)&^(0x6000)|value<<13)
}
func (o *PORT_Type) GetEVCTRL1_EVACT1() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL1.Reg) & 0x6000) >> 13
}
func (o *PORT_Type) SetEVCTRL1_PORTEI1(value uint32) {
	volatile.StoreUint32(&o.EVCTRL1.Reg, volatile.LoadUint32(&o.EVCTRL1.Reg)&^(0x8000)|value<<15)
}
func (o *PORT_Type) GetEVCTRL1_PORTEI1() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL1.Reg) & 0x8000) >> 15
}
func (o *PORT_Type) SetEVCTRL1_PID2(value uint32) {
	volatile.StoreUint32(&o.EVCTRL1.Reg, volatile.LoadUint32(&o.EVCTRL1.Reg)&^(0x1f0000)|value<<16)
}
func (o *PORT_Type) GetEVCTRL1_PID2() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL1.Reg) & 0x1f0000) >> 16
}
func (o *PORT_Type) SetEVCTRL1_EVACT2(value uint32) {
	volatile.StoreUint32(&o.EVCTRL1.Reg, volatile.LoadUint32(&o.EVCTRL1.Reg)&^(0x600000)|value<<21)
}
func (o *PORT_Type) GetEVCTRL1_EVACT2() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL1.Reg) & 0x600000) >> 21
}
func (o *PORT_Type) SetEVCTRL1_PORTEI2(value uint32) {
	volatile.StoreUint32(&o.EVCTRL1.Reg, volatile.LoadUint32(&o.EVCTRL1.Reg)&^(0x800000)|value<<23)
}
func (o *PORT_Type) GetEVCTRL1_PORTEI2() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL1.Reg) & 0x800000) >> 23
}
func (o *PORT_Type) SetEVCTRL1_PID3(value uint32) {
	volatile.StoreUint32(&o.EVCTRL1.Reg, volatile.LoadUint32(&o.EVCTRL1.Reg)&^(0x1f000000)|value<<24)
}
func (o *PORT_Type) GetEVCTRL1_PID3() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL1.Reg) & 0x1f000000) >> 24
}
func (o *PORT_Type) SetEVCTRL1_EVACT3(value uint32) {
	volatile.StoreUint32(&o.EVCTRL1.Reg, volatile.LoadUint32(&o.EVCTRL1.Reg)&^(0x60000000)|value<<29)
}
func (o *PORT_Type) GetEVCTRL1_EVACT3() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL1.Reg) & 0x60000000) >> 29
}
func (o *PORT_Type) SetEVCTRL1_PORTEI3(value uint32) {
	volatile.StoreUint32(&o.EVCTRL1.Reg, volatile.LoadUint32(&o.EVCTRL1.Reg)&^(0x80000000)|value<<31)
}
func (o *PORT_Type) GetEVCTRL1_PORTEI3() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL1.Reg) & 0x80000000) >> 31
}

// Reset Controller
type RSTC_Type struct {
	RCAUSE   volatile.Register8 // 0x0
	_        byte
	BKUPEXIT volatile.Register8 // 0x2
}

// RSTC.RCAUSE: Reset Cause
func (o *RSTC_Type) SetRCAUSE_POR(value uint8) {
	volatile.StoreUint8(&o.RCAUSE.Reg, volatile.LoadUint8(&o.RCAUSE.Reg)&^(0x1)|value)
}
func (o *RSTC_Type) GetRCAUSE_POR() uint8 {
	return volatile.LoadUint8(&o.RCAUSE.Reg) & 0x1
}
func (o *RSTC_Type) SetRCAUSE_BODCORE(value uint8) {
	volatile.StoreUint8(&o.RCAUSE.Reg, volatile.LoadUint8(&o.RCAUSE.Reg)&^(0x2)|value<<1)
}
func (o *RSTC_Type) GetRCAUSE_BODCORE() uint8 {
	return (volatile.LoadUint8(&o.RCAUSE.Reg) & 0x2) >> 1
}
func (o *RSTC_Type) SetRCAUSE_BODVDD(value uint8) {
	volatile.StoreUint8(&o.RCAUSE.Reg, volatile.LoadUint8(&o.RCAUSE.Reg)&^(0x4)|value<<2)
}
func (o *RSTC_Type) GetRCAUSE_BODVDD() uint8 {
	return (volatile.LoadUint8(&o.RCAUSE.Reg) & 0x4) >> 2
}
func (o *RSTC_Type) SetRCAUSE_EXT(value uint8) {
	volatile.StoreUint8(&o.RCAUSE.Reg, volatile.LoadUint8(&o.RCAUSE.Reg)&^(0x10)|value<<4)
}
func (o *RSTC_Type) GetRCAUSE_EXT() uint8 {
	return (volatile.LoadUint8(&o.RCAUSE.Reg) & 0x10) >> 4
}
func (o *RSTC_Type) SetRCAUSE_WDT(value uint8) {
	volatile.StoreUint8(&o.RCAUSE.Reg, volatile.LoadUint8(&o.RCAUSE.Reg)&^(0x20)|value<<5)
}
func (o *RSTC_Type) GetRCAUSE_WDT() uint8 {
	return (volatile.LoadUint8(&o.RCAUSE.Reg) & 0x20) >> 5
}
func (o *RSTC_Type) SetRCAUSE_SYST(value uint8) {
	volatile.StoreUint8(&o.RCAUSE.Reg, volatile.LoadUint8(&o.RCAUSE.Reg)&^(0x40)|value<<6)
}
func (o *RSTC_Type) GetRCAUSE_SYST() uint8 {
	return (volatile.LoadUint8(&o.RCAUSE.Reg) & 0x40) >> 6
}
func (o *RSTC_Type) SetRCAUSE_BACKUP(value uint8) {
	volatile.StoreUint8(&o.RCAUSE.Reg, volatile.LoadUint8(&o.RCAUSE.Reg)&^(0x80)|value<<7)
}
func (o *RSTC_Type) GetRCAUSE_BACKUP() uint8 {
	return (volatile.LoadUint8(&o.RCAUSE.Reg) & 0x80) >> 7
}

// RSTC.BKUPEXIT: Backup Exit Source
func (o *RSTC_Type) SetBKUPEXIT_RTC(value uint8) {
	volatile.StoreUint8(&o.BKUPEXIT.Reg, volatile.LoadUint8(&o.BKUPEXIT.Reg)&^(0x2)|value<<1)
}
func (o *RSTC_Type) GetBKUPEXIT_RTC() uint8 {
	return (volatile.LoadUint8(&o.BKUPEXIT.Reg) & 0x2) >> 1
}
func (o *RSTC_Type) SetBKUPEXIT_BBPS(value uint8) {
	volatile.StoreUint8(&o.BKUPEXIT.Reg, volatile.LoadUint8(&o.BKUPEXIT.Reg)&^(0x4)|value<<2)
}
func (o *RSTC_Type) GetBKUPEXIT_BBPS() uint8 {
	return (volatile.LoadUint8(&o.BKUPEXIT.Reg) & 0x4) >> 2
}

// Real-Time Counter
type RTC_Type struct {
}

// Real-Time Counter - MODE0
type RTC_MODE0_Type struct {
	CTRLA     volatile.Register16 // 0x0
	CTRLB     volatile.Register16 // 0x2
	EVCTRL    volatile.Register32 // 0x4
	INTENCLR  volatile.Register16 // 0x8
	INTENSET  volatile.Register16 // 0xA
	INTFLAG   volatile.Register16 // 0xC
	DBGCTRL   volatile.Register8  // 0xE
	_         byte
	SYNCBUSY  volatile.Register32 // 0x10
	FREQCORR  volatile.Register8  // 0x14
	_         [3]byte
	COUNT     volatile.Register32 // 0x18
	_         [4]byte
	COMP0     volatile.Register32 // 0x20
	_         [28]byte
	GP0       volatile.Register32 // 0x40
	GP1       volatile.Register32 // 0x44
	_         [24]byte
	TAMPCTRL  volatile.Register32 // 0x60
	TIMESTAMP volatile.Register32 // 0x64
	TAMPID    volatile.Register32 // 0x68
	_         [20]byte
	BKUP0     volatile.Register32 // 0x80
	BKUP1     volatile.Register32 // 0x84
	BKUP2     volatile.Register32 // 0x88
	BKUP3     volatile.Register32 // 0x8C
	BKUP4     volatile.Register32 // 0x90
	BKUP5     volatile.Register32 // 0x94
	BKUP6     volatile.Register32 // 0x98
	BKUP7     volatile.Register32 // 0x9C
}

// RTC_MODE0.CTRLA: MODE0 Control A
func (o *RTC_MODE0_Type) SetCTRLA_SWRST(value uint16) {
	volatile.StoreUint16(&o.CTRLA.Reg, volatile.LoadUint16(&o.CTRLA.Reg)&^(0x1)|value)
}
func (o *RTC_MODE0_Type) GetCTRLA_SWRST() uint16 {
	return volatile.LoadUint16(&o.CTRLA.Reg) & 0x1
}
func (o *RTC_MODE0_Type) SetCTRLA_ENABLE(value uint16) {
	volatile.StoreUint16(&o.CTRLA.Reg, volatile.LoadUint16(&o.CTRLA.Reg)&^(0x2)|value<<1)
}
func (o *RTC_MODE0_Type) GetCTRLA_ENABLE() uint16 {
	return (volatile.LoadUint16(&o.CTRLA.Reg) & 0x2) >> 1
}
func (o *RTC_MODE0_Type) SetCTRLA_MODE(value uint16) {
	volatile.StoreUint16(&o.CTRLA.Reg, volatile.LoadUint16(&o.CTRLA.Reg)&^(0xc)|value<<2)
}
func (o *RTC_MODE0_Type) GetCTRLA_MODE() uint16 {
	return (volatile.LoadUint16(&o.CTRLA.Reg) & 0xc) >> 2
}
func (o *RTC_MODE0_Type) SetCTRLA_MATCHCLR(value uint16) {
	volatile.StoreUint16(&o.CTRLA.Reg, volatile.LoadUint16(&o.CTRLA.Reg)&^(0x80)|value<<7)
}
func (o *RTC_MODE0_Type) GetCTRLA_MATCHCLR() uint16 {
	return (volatile.LoadUint16(&o.CTRLA.Reg) & 0x80) >> 7
}
func (o *RTC_MODE0_Type) SetCTRLA_PRESCALER(value uint16) {
	volatile.StoreUint16(&o.CTRLA.Reg, volatile.LoadUint16(&o.CTRLA.Reg)&^(0xf00)|value<<8)
}
func (o *RTC_MODE0_Type) GetCTRLA_PRESCALER() uint16 {
	return (volatile.LoadUint16(&o.CTRLA.Reg) & 0xf00) >> 8
}
func (o *RTC_MODE0_Type) SetCTRLA_BKTRST(value uint16) {
	volatile.StoreUint16(&o.CTRLA.Reg, volatile.LoadUint16(&o.CTRLA.Reg)&^(0x2000)|value<<13)
}
func (o *RTC_MODE0_Type) GetCTRLA_BKTRST() uint16 {
	return (volatile.LoadUint16(&o.CTRLA.Reg) & 0x2000) >> 13
}
func (o *RTC_MODE0_Type) SetCTRLA_GPTRST(value uint16) {
	volatile.StoreUint16(&o.CTRLA.Reg, volatile.LoadUint16(&o.CTRLA.Reg)&^(0x4000)|value<<14)
}
func (o *RTC_MODE0_Type) GetCTRLA_GPTRST() uint16 {
	return (volatile.LoadUint16(&o.CTRLA.Reg) & 0x4000) >> 14
}
func (o *RTC_MODE0_Type) SetCTRLA_COUNTSYNC(value uint16) {
	volatile.StoreUint16(&o.CTRLA.Reg, volatile.LoadUint16(&o.CTRLA.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_MODE0_Type) GetCTRLA_COUNTSYNC() uint16 {
	return (volatile.LoadUint16(&o.CTRLA.Reg) & 0x8000) >> 15
}

// RTC_MODE0.CTRLB: MODE0 Control B
func (o *RTC_MODE0_Type) SetCTRLB_GP0EN(value uint16) {
	volatile.StoreUint16(&o.CTRLB.Reg, volatile.LoadUint16(&o.CTRLB.Reg)&^(0x1)|value)
}
func (o *RTC_MODE0_Type) GetCTRLB_GP0EN() uint16 {
	return volatile.LoadUint16(&o.CTRLB.Reg) & 0x1
}
func (o *RTC_MODE0_Type) SetCTRLB_DEBMAJ(value uint16) {
	volatile.StoreUint16(&o.CTRLB.Reg, volatile.LoadUint16(&o.CTRLB.Reg)&^(0x10)|value<<4)
}
func (o *RTC_MODE0_Type) GetCTRLB_DEBMAJ() uint16 {
	return (volatile.LoadUint16(&o.CTRLB.Reg) & 0x10) >> 4
}
func (o *RTC_MODE0_Type) SetCTRLB_DEBASYNC(value uint16) {
	volatile.StoreUint16(&o.CTRLB.Reg, volatile.LoadUint16(&o.CTRLB.Reg)&^(0x20)|value<<5)
}
func (o *RTC_MODE0_Type) GetCTRLB_DEBASYNC() uint16 {
	return (volatile.LoadUint16(&o.CTRLB.Reg) & 0x20) >> 5
}
func (o *RTC_MODE0_Type) SetCTRLB_RTCOUT(value uint16) {
	volatile.StoreUint16(&o.CTRLB.Reg, volatile.LoadUint16(&o.CTRLB.Reg)&^(0x40)|value<<6)
}
func (o *RTC_MODE0_Type) GetCTRLB_RTCOUT() uint16 {
	return (volatile.LoadUint16(&o.CTRLB.Reg) & 0x40) >> 6
}
func (o *RTC_MODE0_Type) SetCTRLB_DMAEN(value uint16) {
	volatile.StoreUint16(&o.CTRLB.Reg, volatile.LoadUint16(&o.CTRLB.Reg)&^(0x80)|value<<7)
}
func (o *RTC_MODE0_Type) GetCTRLB_DMAEN() uint16 {
	return (volatile.LoadUint16(&o.CTRLB.Reg) & 0x80) >> 7
}
func (o *RTC_MODE0_Type) SetCTRLB_DEBF(value uint16) {
	volatile.StoreUint16(&o.CTRLB.Reg, volatile.LoadUint16(&o.CTRLB.Reg)&^(0x700)|value<<8)
}
func (o *RTC_MODE0_Type) GetCTRLB_DEBF() uint16 {
	return (volatile.LoadUint16(&o.CTRLB.Reg) & 0x700) >> 8
}
func (o *RTC_MODE0_Type) SetCTRLB_ACTF(value uint16) {
	volatile.StoreUint16(&o.CTRLB.Reg, volatile.LoadUint16(&o.CTRLB.Reg)&^(0x7000)|value<<12)
}
func (o *RTC_MODE0_Type) GetCTRLB_ACTF() uint16 {
	return (volatile.LoadUint16(&o.CTRLB.Reg) & 0x7000) >> 12
}

// RTC_MODE0.EVCTRL: MODE0 Event Control
func (o *RTC_MODE0_Type) SetEVCTRL_PEREO0(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x1)|value)
}
func (o *RTC_MODE0_Type) GetEVCTRL_PEREO0() uint32 {
	return volatile.LoadUint32(&o.EVCTRL.Reg) & 0x1
}
func (o *RTC_MODE0_Type) SetEVCTRL_PEREO1(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x2)|value<<1)
}
func (o *RTC_MODE0_Type) GetEVCTRL_PEREO1() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x2) >> 1
}
func (o *RTC_MODE0_Type) SetEVCTRL_PEREO2(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x4)|value<<2)
}
func (o *RTC_MODE0_Type) GetEVCTRL_PEREO2() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x4) >> 2
}
func (o *RTC_MODE0_Type) SetEVCTRL_PEREO3(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x8)|value<<3)
}
func (o *RTC_MODE0_Type) GetEVCTRL_PEREO3() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x8) >> 3
}
func (o *RTC_MODE0_Type) SetEVCTRL_PEREO4(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x10)|value<<4)
}
func (o *RTC_MODE0_Type) GetEVCTRL_PEREO4() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x10) >> 4
}
func (o *RTC_MODE0_Type) SetEVCTRL_PEREO5(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x20)|value<<5)
}
func (o *RTC_MODE0_Type) GetEVCTRL_PEREO5() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x20) >> 5
}
func (o *RTC_MODE0_Type) SetEVCTRL_PEREO6(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x40)|value<<6)
}
func (o *RTC_MODE0_Type) GetEVCTRL_PEREO6() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x40) >> 6
}
func (o *RTC_MODE0_Type) SetEVCTRL_PEREO7(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x80)|value<<7)
}
func (o *RTC_MODE0_Type) GetEVCTRL_PEREO7() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x80) >> 7
}
func (o *RTC_MODE0_Type) SetEVCTRL_CMPEO0(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x100)|value<<8)
}
func (o *RTC_MODE0_Type) GetEVCTRL_CMPEO0() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x100) >> 8
}
func (o *RTC_MODE0_Type) SetEVCTRL_TAMPEREO(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x4000)|value<<14)
}
func (o *RTC_MODE0_Type) GetEVCTRL_TAMPEREO() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x4000) >> 14
}
func (o *RTC_MODE0_Type) SetEVCTRL_OVFEO(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_MODE0_Type) GetEVCTRL_OVFEO() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x8000) >> 15
}
func (o *RTC_MODE0_Type) SetEVCTRL_TAMPEVEI(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x10000)|value<<16)
}
func (o *RTC_MODE0_Type) GetEVCTRL_TAMPEVEI() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x10000) >> 16
}

// RTC_MODE0.INTENCLR: MODE0 Interrupt Enable Clear
func (o *RTC_MODE0_Type) SetINTENCLR_PER0(value uint16) {
	volatile.StoreUint16(&o.INTENCLR.Reg, volatile.LoadUint16(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *RTC_MODE0_Type) GetINTENCLR_PER0() uint16 {
	return volatile.LoadUint16(&o.INTENCLR.Reg) & 0x1
}
func (o *RTC_MODE0_Type) SetINTENCLR_PER1(value uint16) {
	volatile.StoreUint16(&o.INTENCLR.Reg, volatile.LoadUint16(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *RTC_MODE0_Type) GetINTENCLR_PER1() uint16 {
	return (volatile.LoadUint16(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *RTC_MODE0_Type) SetINTENCLR_PER2(value uint16) {
	volatile.StoreUint16(&o.INTENCLR.Reg, volatile.LoadUint16(&o.INTENCLR.Reg)&^(0x4)|value<<2)
}
func (o *RTC_MODE0_Type) GetINTENCLR_PER2() uint16 {
	return (volatile.LoadUint16(&o.INTENCLR.Reg) & 0x4) >> 2
}
func (o *RTC_MODE0_Type) SetINTENCLR_PER3(value uint16) {
	volatile.StoreUint16(&o.INTENCLR.Reg, volatile.LoadUint16(&o.INTENCLR.Reg)&^(0x8)|value<<3)
}
func (o *RTC_MODE0_Type) GetINTENCLR_PER3() uint16 {
	return (volatile.LoadUint16(&o.INTENCLR.Reg) & 0x8) >> 3
}
func (o *RTC_MODE0_Type) SetINTENCLR_PER4(value uint16) {
	volatile.StoreUint16(&o.INTENCLR.Reg, volatile.LoadUint16(&o.INTENCLR.Reg)&^(0x10)|value<<4)
}
func (o *RTC_MODE0_Type) GetINTENCLR_PER4() uint16 {
	return (volatile.LoadUint16(&o.INTENCLR.Reg) & 0x10) >> 4
}
func (o *RTC_MODE0_Type) SetINTENCLR_PER5(value uint16) {
	volatile.StoreUint16(&o.INTENCLR.Reg, volatile.LoadUint16(&o.INTENCLR.Reg)&^(0x20)|value<<5)
}
func (o *RTC_MODE0_Type) GetINTENCLR_PER5() uint16 {
	return (volatile.LoadUint16(&o.INTENCLR.Reg) & 0x20) >> 5
}
func (o *RTC_MODE0_Type) SetINTENCLR_PER6(value uint16) {
	volatile.StoreUint16(&o.INTENCLR.Reg, volatile.LoadUint16(&o.INTENCLR.Reg)&^(0x40)|value<<6)
}
func (o *RTC_MODE0_Type) GetINTENCLR_PER6() uint16 {
	return (volatile.LoadUint16(&o.INTENCLR.Reg) & 0x40) >> 6
}
func (o *RTC_MODE0_Type) SetINTENCLR_PER7(value uint16) {
	volatile.StoreUint16(&o.INTENCLR.Reg, volatile.LoadUint16(&o.INTENCLR.Reg)&^(0x80)|value<<7)
}
func (o *RTC_MODE0_Type) GetINTENCLR_PER7() uint16 {
	return (volatile.LoadUint16(&o.INTENCLR.Reg) & 0x80) >> 7
}
func (o *RTC_MODE0_Type) SetINTENCLR_CMP0(value uint16) {
	volatile.StoreUint16(&o.INTENCLR.Reg, volatile.LoadUint16(&o.INTENCLR.Reg)&^(0x100)|value<<8)
}
func (o *RTC_MODE0_Type) GetINTENCLR_CMP0() uint16 {
	return (volatile.LoadUint16(&o.INTENCLR.Reg) & 0x100) >> 8
}
func (o *RTC_MODE0_Type) SetINTENCLR_TAMPER(value uint16) {
	volatile.StoreUint16(&o.INTENCLR.Reg, volatile.LoadUint16(&o.INTENCLR.Reg)&^(0x4000)|value<<14)
}
func (o *RTC_MODE0_Type) GetINTENCLR_TAMPER() uint16 {
	return (volatile.LoadUint16(&o.INTENCLR.Reg) & 0x4000) >> 14
}
func (o *RTC_MODE0_Type) SetINTENCLR_OVF(value uint16) {
	volatile.StoreUint16(&o.INTENCLR.Reg, volatile.LoadUint16(&o.INTENCLR.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_MODE0_Type) GetINTENCLR_OVF() uint16 {
	return (volatile.LoadUint16(&o.INTENCLR.Reg) & 0x8000) >> 15
}

// RTC_MODE0.INTENSET: MODE0 Interrupt Enable Set
func (o *RTC_MODE0_Type) SetINTENSET_PER0(value uint16) {
	volatile.StoreUint16(&o.INTENSET.Reg, volatile.LoadUint16(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *RTC_MODE0_Type) GetINTENSET_PER0() uint16 {
	return volatile.LoadUint16(&o.INTENSET.Reg) & 0x1
}
func (o *RTC_MODE0_Type) SetINTENSET_PER1(value uint16) {
	volatile.StoreUint16(&o.INTENSET.Reg, volatile.LoadUint16(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *RTC_MODE0_Type) GetINTENSET_PER1() uint16 {
	return (volatile.LoadUint16(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *RTC_MODE0_Type) SetINTENSET_PER2(value uint16) {
	volatile.StoreUint16(&o.INTENSET.Reg, volatile.LoadUint16(&o.INTENSET.Reg)&^(0x4)|value<<2)
}
func (o *RTC_MODE0_Type) GetINTENSET_PER2() uint16 {
	return (volatile.LoadUint16(&o.INTENSET.Reg) & 0x4) >> 2
}
func (o *RTC_MODE0_Type) SetINTENSET_PER3(value uint16) {
	volatile.StoreUint16(&o.INTENSET.Reg, volatile.LoadUint16(&o.INTENSET.Reg)&^(0x8)|value<<3)
}
func (o *RTC_MODE0_Type) GetINTENSET_PER3() uint16 {
	return (volatile.LoadUint16(&o.INTENSET.Reg) & 0x8) >> 3
}
func (o *RTC_MODE0_Type) SetINTENSET_PER4(value uint16) {
	volatile.StoreUint16(&o.INTENSET.Reg, volatile.LoadUint16(&o.INTENSET.Reg)&^(0x10)|value<<4)
}
func (o *RTC_MODE0_Type) GetINTENSET_PER4() uint16 {
	return (volatile.LoadUint16(&o.INTENSET.Reg) & 0x10) >> 4
}
func (o *RTC_MODE0_Type) SetINTENSET_PER5(value uint16) {
	volatile.StoreUint16(&o.INTENSET.Reg, volatile.LoadUint16(&o.INTENSET.Reg)&^(0x20)|value<<5)
}
func (o *RTC_MODE0_Type) GetINTENSET_PER5() uint16 {
	return (volatile.LoadUint16(&o.INTENSET.Reg) & 0x20) >> 5
}
func (o *RTC_MODE0_Type) SetINTENSET_PER6(value uint16) {
	volatile.StoreUint16(&o.INTENSET.Reg, volatile.LoadUint16(&o.INTENSET.Reg)&^(0x40)|value<<6)
}
func (o *RTC_MODE0_Type) GetINTENSET_PER6() uint16 {
	return (volatile.LoadUint16(&o.INTENSET.Reg) & 0x40) >> 6
}
func (o *RTC_MODE0_Type) SetINTENSET_PER7(value uint16) {
	volatile.StoreUint16(&o.INTENSET.Reg, volatile.LoadUint16(&o.INTENSET.Reg)&^(0x80)|value<<7)
}
func (o *RTC_MODE0_Type) GetINTENSET_PER7() uint16 {
	return (volatile.LoadUint16(&o.INTENSET.Reg) & 0x80) >> 7
}
func (o *RTC_MODE0_Type) SetINTENSET_CMP0(value uint16) {
	volatile.StoreUint16(&o.INTENSET.Reg, volatile.LoadUint16(&o.INTENSET.Reg)&^(0x100)|value<<8)
}
func (o *RTC_MODE0_Type) GetINTENSET_CMP0() uint16 {
	return (volatile.LoadUint16(&o.INTENSET.Reg) & 0x100) >> 8
}
func (o *RTC_MODE0_Type) SetINTENSET_TAMPER(value uint16) {
	volatile.StoreUint16(&o.INTENSET.Reg, volatile.LoadUint16(&o.INTENSET.Reg)&^(0x4000)|value<<14)
}
func (o *RTC_MODE0_Type) GetINTENSET_TAMPER() uint16 {
	return (volatile.LoadUint16(&o.INTENSET.Reg) & 0x4000) >> 14
}
func (o *RTC_MODE0_Type) SetINTENSET_OVF(value uint16) {
	volatile.StoreUint16(&o.INTENSET.Reg, volatile.LoadUint16(&o.INTENSET.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_MODE0_Type) GetINTENSET_OVF() uint16 {
	return (volatile.LoadUint16(&o.INTENSET.Reg) & 0x8000) >> 15
}

// RTC_MODE0.INTFLAG: MODE0 Interrupt Flag Status and Clear
func (o *RTC_MODE0_Type) SetINTFLAG_PER0(value uint16) {
	volatile.StoreUint16(&o.INTFLAG.Reg, volatile.LoadUint16(&o.INTFLAG.Reg)&^(0x1)|value)
}
func (o *RTC_MODE0_Type) GetINTFLAG_PER0() uint16 {
	return volatile.LoadUint16(&o.INTFLAG.Reg) & 0x1
}
func (o *RTC_MODE0_Type) SetINTFLAG_PER1(value uint16) {
	volatile.StoreUint16(&o.INTFLAG.Reg, volatile.LoadUint16(&o.INTFLAG.Reg)&^(0x2)|value<<1)
}
func (o *RTC_MODE0_Type) GetINTFLAG_PER1() uint16 {
	return (volatile.LoadUint16(&o.INTFLAG.Reg) & 0x2) >> 1
}
func (o *RTC_MODE0_Type) SetINTFLAG_PER2(value uint16) {
	volatile.StoreUint16(&o.INTFLAG.Reg, volatile.LoadUint16(&o.INTFLAG.Reg)&^(0x4)|value<<2)
}
func (o *RTC_MODE0_Type) GetINTFLAG_PER2() uint16 {
	return (volatile.LoadUint16(&o.INTFLAG.Reg) & 0x4) >> 2
}
func (o *RTC_MODE0_Type) SetINTFLAG_PER3(value uint16) {
	volatile.StoreUint16(&o.INTFLAG.Reg, volatile.LoadUint16(&o.INTFLAG.Reg)&^(0x8)|value<<3)
}
func (o *RTC_MODE0_Type) GetINTFLAG_PER3() uint16 {
	return (volatile.LoadUint16(&o.INTFLAG.Reg) & 0x8) >> 3
}
func (o *RTC_MODE0_Type) SetINTFLAG_PER4(value uint16) {
	volatile.StoreUint16(&o.INTFLAG.Reg, volatile.LoadUint16(&o.INTFLAG.Reg)&^(0x10)|value<<4)
}
func (o *RTC_MODE0_Type) GetINTFLAG_PER4() uint16 {
	return (volatile.LoadUint16(&o.INTFLAG.Reg) & 0x10) >> 4
}
func (o *RTC_MODE0_Type) SetINTFLAG_PER5(value uint16) {
	volatile.StoreUint16(&o.INTFLAG.Reg, volatile.LoadUint16(&o.INTFLAG.Reg)&^(0x20)|value<<5)
}
func (o *RTC_MODE0_Type) GetINTFLAG_PER5() uint16 {
	return (volatile.LoadUint16(&o.INTFLAG.Reg) & 0x20) >> 5
}
func (o *RTC_MODE0_Type) SetINTFLAG_PER6(value uint16) {
	volatile.StoreUint16(&o.INTFLAG.Reg, volatile.LoadUint16(&o.INTFLAG.Reg)&^(0x40)|value<<6)
}
func (o *RTC_MODE0_Type) GetINTFLAG_PER6() uint16 {
	return (volatile.LoadUint16(&o.INTFLAG.Reg) & 0x40) >> 6
}
func (o *RTC_MODE0_Type) SetINTFLAG_PER7(value uint16) {
	volatile.StoreUint16(&o.INTFLAG.Reg, volatile.LoadUint16(&o.INTFLAG.Reg)&^(0x80)|value<<7)
}
func (o *RTC_MODE0_Type) GetINTFLAG_PER7() uint16 {
	return (volatile.LoadUint16(&o.INTFLAG.Reg) & 0x80) >> 7
}
func (o *RTC_MODE0_Type) SetINTFLAG_CMP0(value uint16) {
	volatile.StoreUint16(&o.INTFLAG.Reg, volatile.LoadUint16(&o.INTFLAG.Reg)&^(0x100)|value<<8)
}
func (o *RTC_MODE0_Type) GetINTFLAG_CMP0() uint16 {
	return (volatile.LoadUint16(&o.INTFLAG.Reg) & 0x100) >> 8
}
func (o *RTC_MODE0_Type) SetINTFLAG_TAMPER(value uint16) {
	volatile.StoreUint16(&o.INTFLAG.Reg, volatile.LoadUint16(&o.INTFLAG.Reg)&^(0x4000)|value<<14)
}
func (o *RTC_MODE0_Type) GetINTFLAG_TAMPER() uint16 {
	return (volatile.LoadUint16(&o.INTFLAG.Reg) & 0x4000) >> 14
}
func (o *RTC_MODE0_Type) SetINTFLAG_OVF(value uint16) {
	volatile.StoreUint16(&o.INTFLAG.Reg, volatile.LoadUint16(&o.INTFLAG.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_MODE0_Type) GetINTFLAG_OVF() uint16 {
	return (volatile.LoadUint16(&o.INTFLAG.Reg) & 0x8000) >> 15
}

// RTC_MODE0.DBGCTRL: Debug Control
func (o *RTC_MODE0_Type) SetDBGCTRL_DBGRUN(value uint8) {
	volatile.StoreUint8(&o.DBGCTRL.Reg, volatile.LoadUint8(&o.DBGCTRL.Reg)&^(0x1)|value)
}
func (o *RTC_MODE0_Type) GetDBGCTRL_DBGRUN() uint8 {
	return volatile.LoadUint8(&o.DBGCTRL.Reg) & 0x1
}

// RTC_MODE0.SYNCBUSY: MODE0 Synchronization Busy Status
func (o *RTC_MODE0_Type) SetSYNCBUSY_SWRST(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x1)|value)
}
func (o *RTC_MODE0_Type) GetSYNCBUSY_SWRST() uint32 {
	return volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x1
}
func (o *RTC_MODE0_Type) SetSYNCBUSY_ENABLE(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x2)|value<<1)
}
func (o *RTC_MODE0_Type) GetSYNCBUSY_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x2) >> 1
}
func (o *RTC_MODE0_Type) SetSYNCBUSY_FREQCORR(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x4)|value<<2)
}
func (o *RTC_MODE0_Type) GetSYNCBUSY_FREQCORR() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x4) >> 2
}
func (o *RTC_MODE0_Type) SetSYNCBUSY_COUNT(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x8)|value<<3)
}
func (o *RTC_MODE0_Type) GetSYNCBUSY_COUNT() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x8) >> 3
}
func (o *RTC_MODE0_Type) SetSYNCBUSY_COMP0(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x20)|value<<5)
}
func (o *RTC_MODE0_Type) GetSYNCBUSY_COMP0() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x20) >> 5
}
func (o *RTC_MODE0_Type) SetSYNCBUSY_COUNTSYNC(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_MODE0_Type) GetSYNCBUSY_COUNTSYNC() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x8000) >> 15
}
func (o *RTC_MODE0_Type) SetSYNCBUSY_GP0(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x10000)|value<<16)
}
func (o *RTC_MODE0_Type) GetSYNCBUSY_GP0() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x10000) >> 16
}
func (o *RTC_MODE0_Type) SetSYNCBUSY_GP1(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x20000)|value<<17)
}
func (o *RTC_MODE0_Type) GetSYNCBUSY_GP1() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x20000) >> 17
}

// RTC_MODE0.FREQCORR: Frequency Correction
func (o *RTC_MODE0_Type) SetFREQCORR_VALUE(value uint8) {
	volatile.StoreUint8(&o.FREQCORR.Reg, volatile.LoadUint8(&o.FREQCORR.Reg)&^(0x7f)|value)
}
func (o *RTC_MODE0_Type) GetFREQCORR_VALUE() uint8 {
	return volatile.LoadUint8(&o.FREQCORR.Reg) & 0x7f
}
func (o *RTC_MODE0_Type) SetFREQCORR_SIGN(value uint8) {
	volatile.StoreUint8(&o.FREQCORR.Reg, volatile.LoadUint8(&o.FREQCORR.Reg)&^(0x80)|value<<7)
}
func (o *RTC_MODE0_Type) GetFREQCORR_SIGN() uint8 {
	return (volatile.LoadUint8(&o.FREQCORR.Reg) & 0x80) >> 7
}

// RTC_MODE0.COUNT: MODE0 Counter Value
func (o *RTC_MODE0_Type) SetCOUNT(value uint32) {
	volatile.StoreUint32(&o.COUNT.Reg, value)
}
func (o *RTC_MODE0_Type) GetCOUNT() uint32 {
	return volatile.LoadUint32(&o.COUNT.Reg)
}

// RTC_MODE0.COMP0: MODE0 Compare n Value
func (o *RTC_MODE0_Type) SetCOMP0(value uint32) {
	volatile.StoreUint32(&o.COMP0.Reg, value)
}
func (o *RTC_MODE0_Type) GetCOMP0() uint32 {
	return volatile.LoadUint32(&o.COMP0.Reg)
}

// RTC_MODE0.GP0: General Purpose
func (o *RTC_MODE0_Type) SetGP0(value uint32) {
	volatile.StoreUint32(&o.GP0.Reg, value)
}
func (o *RTC_MODE0_Type) GetGP0() uint32 {
	return volatile.LoadUint32(&o.GP0.Reg)
}

// RTC_MODE0.GP1: General Purpose
func (o *RTC_MODE0_Type) SetGP1(value uint32) {
	volatile.StoreUint32(&o.GP1.Reg, value)
}
func (o *RTC_MODE0_Type) GetGP1() uint32 {
	return volatile.LoadUint32(&o.GP1.Reg)
}

// RTC_MODE0.TAMPCTRL: Tamper Control
func (o *RTC_MODE0_Type) SetTAMPCTRL_IN0ACT(value uint32) {
	volatile.StoreUint32(&o.TAMPCTRL.Reg, volatile.LoadUint32(&o.TAMPCTRL.Reg)&^(0x3)|value)
}
func (o *RTC_MODE0_Type) GetTAMPCTRL_IN0ACT() uint32 {
	return volatile.LoadUint32(&o.TAMPCTRL.Reg) & 0x3
}
func (o *RTC_MODE0_Type) SetTAMPCTRL_IN1ACT(value uint32) {
	volatile.StoreUint32(&o.TAMPCTRL.Reg, volatile.LoadUint32(&o.TAMPCTRL.Reg)&^(0xc)|value<<2)
}
func (o *RTC_MODE0_Type) GetTAMPCTRL_IN1ACT() uint32 {
	return (volatile.LoadUint32(&o.TAMPCTRL.Reg) & 0xc) >> 2
}
func (o *RTC_MODE0_Type) SetTAMPCTRL_IN2ACT(value uint32) {
	volatile.StoreUint32(&o.TAMPCTRL.Reg, volatile.LoadUint32(&o.TAMPCTRL.Reg)&^(0x30)|value<<4)
}
func (o *RTC_MODE0_Type) GetTAMPCTRL_IN2ACT() uint32 {
	return (volatile.LoadUint32(&o.TAMPCTRL.Reg) & 0x30) >> 4
}
func (o *RTC_MODE0_Type) SetTAMPCTRL_IN3ACT(value uint32) {
	volatile.StoreUint32(&o.TAMPCTRL.Reg, volatile.LoadUint32(&o.TAMPCTRL.Reg)&^(0xc0)|value<<6)
}
func (o *RTC_MODE0_Type) GetTAMPCTRL_IN3ACT() uint32 {
	return (volatile.LoadUint32(&o.TAMPCTRL.Reg) & 0xc0) >> 6
}
func (o *RTC_MODE0_Type) SetTAMPCTRL_IN4ACT(value uint32) {
	volatile.StoreUint32(&o.TAMPCTRL.Reg, volatile.LoadUint32(&o.TAMPCTRL.Reg)&^(0x300)|value<<8)
}
func (o *RTC_MODE0_Type) GetTAMPCTRL_IN4ACT() uint32 {
	return (volatile.LoadUint32(&o.TAMPCTRL.Reg) & 0x300) >> 8
}
func (o *RTC_MODE0_Type) SetTAMPCTRL_TAMLVL0(value uint32) {
	volatile.StoreUint32(&o.TAMPCTRL.Reg, volatile.LoadUint32(&o.TAMPCTRL.Reg)&^(0x10000)|value<<16)
}
func (o *RTC_MODE0_Type) GetTAMPCTRL_TAMLVL0() uint32 {
	return (volatile.LoadUint32(&o.TAMPCTRL.Reg) & 0x10000) >> 16
}
func (o *RTC_MODE0_Type) SetTAMPCTRL_TAMLVL1(value uint32) {
	volatile.StoreUint32(&o.TAMPCTRL.Reg, volatile.LoadUint32(&o.TAMPCTRL.Reg)&^(0x20000)|value<<17)
}
func (o *RTC_MODE0_Type) GetTAMPCTRL_TAMLVL1() uint32 {
	return (volatile.LoadUint32(&o.TAMPCTRL.Reg) & 0x20000) >> 17
}
func (o *RTC_MODE0_Type) SetTAMPCTRL_TAMLVL2(value uint32) {
	volatile.StoreUint32(&o.TAMPCTRL.Reg, volatile.LoadUint32(&o.TAMPCTRL.Reg)&^(0x40000)|value<<18)
}
func (o *RTC_MODE0_Type) GetTAMPCTRL_TAMLVL2() uint32 {
	return (volatile.LoadUint32(&o.TAMPCTRL.Reg) & 0x40000) >> 18
}
func (o *RTC_MODE0_Type) SetTAMPCTRL_TAMLVL3(value uint32) {
	volatile.StoreUint32(&o.TAMPCTRL.Reg, volatile.LoadUint32(&o.TAMPCTRL.Reg)&^(0x80000)|value<<19)
}
func (o *RTC_MODE0_Type) GetTAMPCTRL_TAMLVL3() uint32 {
	return (volatile.LoadUint32(&o.TAMPCTRL.Reg) & 0x80000) >> 19
}
func (o *RTC_MODE0_Type) SetTAMPCTRL_TAMLVL4(value uint32) {
	volatile.StoreUint32(&o.TAMPCTRL.Reg, volatile.LoadUint32(&o.TAMPCTRL.Reg)&^(0x100000)|value<<20)
}
func (o *RTC_MODE0_Type) GetTAMPCTRL_TAMLVL4() uint32 {
	return (volatile.LoadUint32(&o.TAMPCTRL.Reg) & 0x100000) >> 20
}
func (o *RTC_MODE0_Type) SetTAMPCTRL_DEBNC0(value uint32) {
	volatile.StoreUint32(&o.TAMPCTRL.Reg, volatile.LoadUint32(&o.TAMPCTRL.Reg)&^(0x1000000)|value<<24)
}
func (o *RTC_MODE0_Type) GetTAMPCTRL_DEBNC0() uint32 {
	return (volatile.LoadUint32(&o.TAMPCTRL.Reg) & 0x1000000) >> 24
}
func (o *RTC_MODE0_Type) SetTAMPCTRL_DEBNC1(value uint32) {
	volatile.StoreUint32(&o.TAMPCTRL.Reg, volatile.LoadUint32(&o.TAMPCTRL.Reg)&^(0x2000000)|value<<25)
}
func (o *RTC_MODE0_Type) GetTAMPCTRL_DEBNC1() uint32 {
	return (volatile.LoadUint32(&o.TAMPCTRL.Reg) & 0x2000000) >> 25
}
func (o *RTC_MODE0_Type) SetTAMPCTRL_DEBNC2(value uint32) {
	volatile.StoreUint32(&o.TAMPCTRL.Reg, volatile.LoadUint32(&o.TAMPCTRL.Reg)&^(0x4000000)|value<<26)
}
func (o *RTC_MODE0_Type) GetTAMPCTRL_DEBNC2() uint32 {
	return (volatile.LoadUint32(&o.TAMPCTRL.Reg) & 0x4000000) >> 26
}
func (o *RTC_MODE0_Type) SetTAMPCTRL_DEBNC3(value uint32) {
	volatile.StoreUint32(&o.TAMPCTRL.Reg, volatile.LoadUint32(&o.TAMPCTRL.Reg)&^(0x8000000)|value<<27)
}
func (o *RTC_MODE0_Type) GetTAMPCTRL_DEBNC3() uint32 {
	return (volatile.LoadUint32(&o.TAMPCTRL.Reg) & 0x8000000) >> 27
}
func (o *RTC_MODE0_Type) SetTAMPCTRL_DEBNC4(value uint32) {
	volatile.StoreUint32(&o.TAMPCTRL.Reg, volatile.LoadUint32(&o.TAMPCTRL.Reg)&^(0x10000000)|value<<28)
}
func (o *RTC_MODE0_Type) GetTAMPCTRL_DEBNC4() uint32 {
	return (volatile.LoadUint32(&o.TAMPCTRL.Reg) & 0x10000000) >> 28
}

// RTC_MODE0.TIMESTAMP: MODE0 Timestamp
func (o *RTC_MODE0_Type) SetTIMESTAMP(value uint32) {
	volatile.StoreUint32(&o.TIMESTAMP.Reg, value)
}
func (o *RTC_MODE0_Type) GetTIMESTAMP() uint32 {
	return volatile.LoadUint32(&o.TIMESTAMP.Reg)
}

// RTC_MODE0.TAMPID: Tamper ID
func (o *RTC_MODE0_Type) SetTAMPID_TAMPID0(value uint32) {
	volatile.StoreUint32(&o.TAMPID.Reg, volatile.LoadUint32(&o.TAMPID.Reg)&^(0x1)|value)
}
func (o *RTC_MODE0_Type) GetTAMPID_TAMPID0() uint32 {
	return volatile.LoadUint32(&o.TAMPID.Reg) & 0x1
}
func (o *RTC_MODE0_Type) SetTAMPID_TAMPID1(value uint32) {
	volatile.StoreUint32(&o.TAMPID.Reg, volatile.LoadUint32(&o.TAMPID.Reg)&^(0x2)|value<<1)
}
func (o *RTC_MODE0_Type) GetTAMPID_TAMPID1() uint32 {
	return (volatile.LoadUint32(&o.TAMPID.Reg) & 0x2) >> 1
}
func (o *RTC_MODE0_Type) SetTAMPID_TAMPID2(value uint32) {
	volatile.StoreUint32(&o.TAMPID.Reg, volatile.LoadUint32(&o.TAMPID.Reg)&^(0x4)|value<<2)
}
func (o *RTC_MODE0_Type) GetTAMPID_TAMPID2() uint32 {
	return (volatile.LoadUint32(&o.TAMPID.Reg) & 0x4) >> 2
}
func (o *RTC_MODE0_Type) SetTAMPID_TAMPID3(value uint32) {
	volatile.StoreUint32(&o.TAMPID.Reg, volatile.LoadUint32(&o.TAMPID.Reg)&^(0x8)|value<<3)
}
func (o *RTC_MODE0_Type) GetTAMPID_TAMPID3() uint32 {
	return (volatile.LoadUint32(&o.TAMPID.Reg) & 0x8) >> 3
}
func (o *RTC_MODE0_Type) SetTAMPID_TAMPID4(value uint32) {
	volatile.StoreUint32(&o.TAMPID.Reg, volatile.LoadUint32(&o.TAMPID.Reg)&^(0x10)|value<<4)
}
func (o *RTC_MODE0_Type) GetTAMPID_TAMPID4() uint32 {
	return (volatile.LoadUint32(&o.TAMPID.Reg) & 0x10) >> 4
}
func (o *RTC_MODE0_Type) SetTAMPID_TAMPEVT(value uint32) {
	volatile.StoreUint32(&o.TAMPID.Reg, volatile.LoadUint32(&o.TAMPID.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_MODE0_Type) GetTAMPID_TAMPEVT() uint32 {
	return (volatile.LoadUint32(&o.TAMPID.Reg) & 0x80000000) >> 31
}

// RTC_MODE0.BKUP0: Backup
func (o *RTC_MODE0_Type) SetBKUP0(value uint32) {
	volatile.StoreUint32(&o.BKUP0.Reg, value)
}
func (o *RTC_MODE0_Type) GetBKUP0() uint32 {
	return volatile.LoadUint32(&o.BKUP0.Reg)
}

// RTC_MODE0.BKUP1: Backup
func (o *RTC_MODE0_Type) SetBKUP1(value uint32) {
	volatile.StoreUint32(&o.BKUP1.Reg, value)
}
func (o *RTC_MODE0_Type) GetBKUP1() uint32 {
	return volatile.LoadUint32(&o.BKUP1.Reg)
}

// RTC_MODE0.BKUP2: Backup
func (o *RTC_MODE0_Type) SetBKUP2(value uint32) {
	volatile.StoreUint32(&o.BKUP2.Reg, value)
}
func (o *RTC_MODE0_Type) GetBKUP2() uint32 {
	return volatile.LoadUint32(&o.BKUP2.Reg)
}

// RTC_MODE0.BKUP3: Backup
func (o *RTC_MODE0_Type) SetBKUP3(value uint32) {
	volatile.StoreUint32(&o.BKUP3.Reg, value)
}
func (o *RTC_MODE0_Type) GetBKUP3() uint32 {
	return volatile.LoadUint32(&o.BKUP3.Reg)
}

// RTC_MODE0.BKUP4: Backup
func (o *RTC_MODE0_Type) SetBKUP4(value uint32) {
	volatile.StoreUint32(&o.BKUP4.Reg, value)
}
func (o *RTC_MODE0_Type) GetBKUP4() uint32 {
	return volatile.LoadUint32(&o.BKUP4.Reg)
}

// RTC_MODE0.BKUP5: Backup
func (o *RTC_MODE0_Type) SetBKUP5(value uint32) {
	volatile.StoreUint32(&o.BKUP5.Reg, value)
}
func (o *RTC_MODE0_Type) GetBKUP5() uint32 {
	return volatile.LoadUint32(&o.BKUP5.Reg)
}

// RTC_MODE0.BKUP6: Backup
func (o *RTC_MODE0_Type) SetBKUP6(value uint32) {
	volatile.StoreUint32(&o.BKUP6.Reg, value)
}
func (o *RTC_MODE0_Type) GetBKUP6() uint32 {
	return volatile.LoadUint32(&o.BKUP6.Reg)
}

// RTC_MODE0.BKUP7: Backup
func (o *RTC_MODE0_Type) SetBKUP7(value uint32) {
	volatile.StoreUint32(&o.BKUP7.Reg, value)
}
func (o *RTC_MODE0_Type) GetBKUP7() uint32 {
	return volatile.LoadUint32(&o.BKUP7.Reg)
}

// Real-Time Counter - MODE1
type RTC_MODE1_Type struct {
	CTRLA     volatile.Register16 // 0x0
	CTRLB     volatile.Register16 // 0x2
	EVCTRL    volatile.Register32 // 0x4
	INTENCLR  volatile.Register16 // 0x8
	INTENSET  volatile.Register16 // 0xA
	INTFLAG   volatile.Register16 // 0xC
	DBGCTRL   volatile.Register8  // 0xE
	_         byte
	SYNCBUSY  volatile.Register32 // 0x10
	FREQCORR  volatile.Register8  // 0x14
	_         [3]byte
	COUNT     volatile.Register16 // 0x18
	_         [2]byte
	PER       volatile.Register16 // 0x1C
	_         [2]byte
	COMP0     volatile.Register16 // 0x20
	COMP1     volatile.Register16 // 0x22
	_         [28]byte
	GP0       volatile.Register32 // 0x40
	GP1       volatile.Register32 // 0x44
	_         [24]byte
	TAMPCTRL  volatile.Register32 // 0x60
	TIMESTAMP volatile.Register32 // 0x64
	TAMPID    volatile.Register32 // 0x68
	_         [20]byte
	BKUP0     volatile.Register32 // 0x80
	BKUP1     volatile.Register32 // 0x84
	BKUP2     volatile.Register32 // 0x88
	BKUP3     volatile.Register32 // 0x8C
	BKUP4     volatile.Register32 // 0x90
	BKUP5     volatile.Register32 // 0x94
	BKUP6     volatile.Register32 // 0x98
	BKUP7     volatile.Register32 // 0x9C
}

// RTC_MODE1.CTRLA: MODE1 Control A
func (o *RTC_MODE1_Type) SetCTRLA_SWRST(value uint16) {
	volatile.StoreUint16(&o.CTRLA.Reg, volatile.LoadUint16(&o.CTRLA.Reg)&^(0x1)|value)
}
func (o *RTC_MODE1_Type) GetCTRLA_SWRST() uint16 {
	return volatile.LoadUint16(&o.CTRLA.Reg) & 0x1
}
func (o *RTC_MODE1_Type) SetCTRLA_ENABLE(value uint16) {
	volatile.StoreUint16(&o.CTRLA.Reg, volatile.LoadUint16(&o.CTRLA.Reg)&^(0x2)|value<<1)
}
func (o *RTC_MODE1_Type) GetCTRLA_ENABLE() uint16 {
	return (volatile.LoadUint16(&o.CTRLA.Reg) & 0x2) >> 1
}
func (o *RTC_MODE1_Type) SetCTRLA_MODE(value uint16) {
	volatile.StoreUint16(&o.CTRLA.Reg, volatile.LoadUint16(&o.CTRLA.Reg)&^(0xc)|value<<2)
}
func (o *RTC_MODE1_Type) GetCTRLA_MODE() uint16 {
	return (volatile.LoadUint16(&o.CTRLA.Reg) & 0xc) >> 2
}
func (o *RTC_MODE1_Type) SetCTRLA_PRESCALER(value uint16) {
	volatile.StoreUint16(&o.CTRLA.Reg, volatile.LoadUint16(&o.CTRLA.Reg)&^(0xf00)|value<<8)
}
func (o *RTC_MODE1_Type) GetCTRLA_PRESCALER() uint16 {
	return (volatile.LoadUint16(&o.CTRLA.Reg) & 0xf00) >> 8
}
func (o *RTC_MODE1_Type) SetCTRLA_BKTRST(value uint16) {
	volatile.StoreUint16(&o.CTRLA.Reg, volatile.LoadUint16(&o.CTRLA.Reg)&^(0x2000)|value<<13)
}
func (o *RTC_MODE1_Type) GetCTRLA_BKTRST() uint16 {
	return (volatile.LoadUint16(&o.CTRLA.Reg) & 0x2000) >> 13
}
func (o *RTC_MODE1_Type) SetCTRLA_GPTRST(value uint16) {
	volatile.StoreUint16(&o.CTRLA.Reg, volatile.LoadUint16(&o.CTRLA.Reg)&^(0x4000)|value<<14)
}
func (o *RTC_MODE1_Type) GetCTRLA_GPTRST() uint16 {
	return (volatile.LoadUint16(&o.CTRLA.Reg) & 0x4000) >> 14
}
func (o *RTC_MODE1_Type) SetCTRLA_COUNTSYNC(value uint16) {
	volatile.StoreUint16(&o.CTRLA.Reg, volatile.LoadUint16(&o.CTRLA.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_MODE1_Type) GetCTRLA_COUNTSYNC() uint16 {
	return (volatile.LoadUint16(&o.CTRLA.Reg) & 0x8000) >> 15
}

// RTC_MODE1.CTRLB: MODE1 Control B
func (o *RTC_MODE1_Type) SetCTRLB_GP0EN(value uint16) {
	volatile.StoreUint16(&o.CTRLB.Reg, volatile.LoadUint16(&o.CTRLB.Reg)&^(0x1)|value)
}
func (o *RTC_MODE1_Type) GetCTRLB_GP0EN() uint16 {
	return volatile.LoadUint16(&o.CTRLB.Reg) & 0x1
}
func (o *RTC_MODE1_Type) SetCTRLB_DEBMAJ(value uint16) {
	volatile.StoreUint16(&o.CTRLB.Reg, volatile.LoadUint16(&o.CTRLB.Reg)&^(0x10)|value<<4)
}
func (o *RTC_MODE1_Type) GetCTRLB_DEBMAJ() uint16 {
	return (volatile.LoadUint16(&o.CTRLB.Reg) & 0x10) >> 4
}
func (o *RTC_MODE1_Type) SetCTRLB_DEBASYNC(value uint16) {
	volatile.StoreUint16(&o.CTRLB.Reg, volatile.LoadUint16(&o.CTRLB.Reg)&^(0x20)|value<<5)
}
func (o *RTC_MODE1_Type) GetCTRLB_DEBASYNC() uint16 {
	return (volatile.LoadUint16(&o.CTRLB.Reg) & 0x20) >> 5
}
func (o *RTC_MODE1_Type) SetCTRLB_RTCOUT(value uint16) {
	volatile.StoreUint16(&o.CTRLB.Reg, volatile.LoadUint16(&o.CTRLB.Reg)&^(0x40)|value<<6)
}
func (o *RTC_MODE1_Type) GetCTRLB_RTCOUT() uint16 {
	return (volatile.LoadUint16(&o.CTRLB.Reg) & 0x40) >> 6
}
func (o *RTC_MODE1_Type) SetCTRLB_DMAEN(value uint16) {
	volatile.StoreUint16(&o.CTRLB.Reg, volatile.LoadUint16(&o.CTRLB.Reg)&^(0x80)|value<<7)
}
func (o *RTC_MODE1_Type) GetCTRLB_DMAEN() uint16 {
	return (volatile.LoadUint16(&o.CTRLB.Reg) & 0x80) >> 7
}
func (o *RTC_MODE1_Type) SetCTRLB_DEBF(value uint16) {
	volatile.StoreUint16(&o.CTRLB.Reg, volatile.LoadUint16(&o.CTRLB.Reg)&^(0x700)|value<<8)
}
func (o *RTC_MODE1_Type) GetCTRLB_DEBF() uint16 {
	return (volatile.LoadUint16(&o.CTRLB.Reg) & 0x700) >> 8
}
func (o *RTC_MODE1_Type) SetCTRLB_ACTF(value uint16) {
	volatile.StoreUint16(&o.CTRLB.Reg, volatile.LoadUint16(&o.CTRLB.Reg)&^(0x7000)|value<<12)
}
func (o *RTC_MODE1_Type) GetCTRLB_ACTF() uint16 {
	return (volatile.LoadUint16(&o.CTRLB.Reg) & 0x7000) >> 12
}

// RTC_MODE1.EVCTRL: MODE1 Event Control
func (o *RTC_MODE1_Type) SetEVCTRL_PEREO0(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x1)|value)
}
func (o *RTC_MODE1_Type) GetEVCTRL_PEREO0() uint32 {
	return volatile.LoadUint32(&o.EVCTRL.Reg) & 0x1
}
func (o *RTC_MODE1_Type) SetEVCTRL_PEREO1(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x2)|value<<1)
}
func (o *RTC_MODE1_Type) GetEVCTRL_PEREO1() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x2) >> 1
}
func (o *RTC_MODE1_Type) SetEVCTRL_PEREO2(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x4)|value<<2)
}
func (o *RTC_MODE1_Type) GetEVCTRL_PEREO2() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x4) >> 2
}
func (o *RTC_MODE1_Type) SetEVCTRL_PEREO3(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x8)|value<<3)
}
func (o *RTC_MODE1_Type) GetEVCTRL_PEREO3() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x8) >> 3
}
func (o *RTC_MODE1_Type) SetEVCTRL_PEREO4(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x10)|value<<4)
}
func (o *RTC_MODE1_Type) GetEVCTRL_PEREO4() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x10) >> 4
}
func (o *RTC_MODE1_Type) SetEVCTRL_PEREO5(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x20)|value<<5)
}
func (o *RTC_MODE1_Type) GetEVCTRL_PEREO5() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x20) >> 5
}
func (o *RTC_MODE1_Type) SetEVCTRL_PEREO6(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x40)|value<<6)
}
func (o *RTC_MODE1_Type) GetEVCTRL_PEREO6() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x40) >> 6
}
func (o *RTC_MODE1_Type) SetEVCTRL_PEREO7(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x80)|value<<7)
}
func (o *RTC_MODE1_Type) GetEVCTRL_PEREO7() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x80) >> 7
}
func (o *RTC_MODE1_Type) SetEVCTRL_CMPEO0(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x100)|value<<8)
}
func (o *RTC_MODE1_Type) GetEVCTRL_CMPEO0() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x100) >> 8
}
func (o *RTC_MODE1_Type) SetEVCTRL_CMPEO1(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x200)|value<<9)
}
func (o *RTC_MODE1_Type) GetEVCTRL_CMPEO1() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x200) >> 9
}
func (o *RTC_MODE1_Type) SetEVCTRL_TAMPEREO(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x4000)|value<<14)
}
func (o *RTC_MODE1_Type) GetEVCTRL_TAMPEREO() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x4000) >> 14
}
func (o *RTC_MODE1_Type) SetEVCTRL_OVFEO(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_MODE1_Type) GetEVCTRL_OVFEO() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x8000) >> 15
}
func (o *RTC_MODE1_Type) SetEVCTRL_TAMPEVEI(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x10000)|value<<16)
}
func (o *RTC_MODE1_Type) GetEVCTRL_TAMPEVEI() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x10000) >> 16
}

// RTC_MODE1.INTENCLR: MODE1 Interrupt Enable Clear
func (o *RTC_MODE1_Type) SetINTENCLR_PER0(value uint16) {
	volatile.StoreUint16(&o.INTENCLR.Reg, volatile.LoadUint16(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *RTC_MODE1_Type) GetINTENCLR_PER0() uint16 {
	return volatile.LoadUint16(&o.INTENCLR.Reg) & 0x1
}
func (o *RTC_MODE1_Type) SetINTENCLR_PER1(value uint16) {
	volatile.StoreUint16(&o.INTENCLR.Reg, volatile.LoadUint16(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *RTC_MODE1_Type) GetINTENCLR_PER1() uint16 {
	return (volatile.LoadUint16(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *RTC_MODE1_Type) SetINTENCLR_PER2(value uint16) {
	volatile.StoreUint16(&o.INTENCLR.Reg, volatile.LoadUint16(&o.INTENCLR.Reg)&^(0x4)|value<<2)
}
func (o *RTC_MODE1_Type) GetINTENCLR_PER2() uint16 {
	return (volatile.LoadUint16(&o.INTENCLR.Reg) & 0x4) >> 2
}
func (o *RTC_MODE1_Type) SetINTENCLR_PER3(value uint16) {
	volatile.StoreUint16(&o.INTENCLR.Reg, volatile.LoadUint16(&o.INTENCLR.Reg)&^(0x8)|value<<3)
}
func (o *RTC_MODE1_Type) GetINTENCLR_PER3() uint16 {
	return (volatile.LoadUint16(&o.INTENCLR.Reg) & 0x8) >> 3
}
func (o *RTC_MODE1_Type) SetINTENCLR_PER4(value uint16) {
	volatile.StoreUint16(&o.INTENCLR.Reg, volatile.LoadUint16(&o.INTENCLR.Reg)&^(0x10)|value<<4)
}
func (o *RTC_MODE1_Type) GetINTENCLR_PER4() uint16 {
	return (volatile.LoadUint16(&o.INTENCLR.Reg) & 0x10) >> 4
}
func (o *RTC_MODE1_Type) SetINTENCLR_PER5(value uint16) {
	volatile.StoreUint16(&o.INTENCLR.Reg, volatile.LoadUint16(&o.INTENCLR.Reg)&^(0x20)|value<<5)
}
func (o *RTC_MODE1_Type) GetINTENCLR_PER5() uint16 {
	return (volatile.LoadUint16(&o.INTENCLR.Reg) & 0x20) >> 5
}
func (o *RTC_MODE1_Type) SetINTENCLR_PER6(value uint16) {
	volatile.StoreUint16(&o.INTENCLR.Reg, volatile.LoadUint16(&o.INTENCLR.Reg)&^(0x40)|value<<6)
}
func (o *RTC_MODE1_Type) GetINTENCLR_PER6() uint16 {
	return (volatile.LoadUint16(&o.INTENCLR.Reg) & 0x40) >> 6
}
func (o *RTC_MODE1_Type) SetINTENCLR_PER7(value uint16) {
	volatile.StoreUint16(&o.INTENCLR.Reg, volatile.LoadUint16(&o.INTENCLR.Reg)&^(0x80)|value<<7)
}
func (o *RTC_MODE1_Type) GetINTENCLR_PER7() uint16 {
	return (volatile.LoadUint16(&o.INTENCLR.Reg) & 0x80) >> 7
}
func (o *RTC_MODE1_Type) SetINTENCLR_CMP0(value uint16) {
	volatile.StoreUint16(&o.INTENCLR.Reg, volatile.LoadUint16(&o.INTENCLR.Reg)&^(0x100)|value<<8)
}
func (o *RTC_MODE1_Type) GetINTENCLR_CMP0() uint16 {
	return (volatile.LoadUint16(&o.INTENCLR.Reg) & 0x100) >> 8
}
func (o *RTC_MODE1_Type) SetINTENCLR_CMP1(value uint16) {
	volatile.StoreUint16(&o.INTENCLR.Reg, volatile.LoadUint16(&o.INTENCLR.Reg)&^(0x200)|value<<9)
}
func (o *RTC_MODE1_Type) GetINTENCLR_CMP1() uint16 {
	return (volatile.LoadUint16(&o.INTENCLR.Reg) & 0x200) >> 9
}
func (o *RTC_MODE1_Type) SetINTENCLR_TAMPER(value uint16) {
	volatile.StoreUint16(&o.INTENCLR.Reg, volatile.LoadUint16(&o.INTENCLR.Reg)&^(0x4000)|value<<14)
}
func (o *RTC_MODE1_Type) GetINTENCLR_TAMPER() uint16 {
	return (volatile.LoadUint16(&o.INTENCLR.Reg) & 0x4000) >> 14
}
func (o *RTC_MODE1_Type) SetINTENCLR_OVF(value uint16) {
	volatile.StoreUint16(&o.INTENCLR.Reg, volatile.LoadUint16(&o.INTENCLR.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_MODE1_Type) GetINTENCLR_OVF() uint16 {
	return (volatile.LoadUint16(&o.INTENCLR.Reg) & 0x8000) >> 15
}

// RTC_MODE1.INTENSET: MODE1 Interrupt Enable Set
func (o *RTC_MODE1_Type) SetINTENSET_PER0(value uint16) {
	volatile.StoreUint16(&o.INTENSET.Reg, volatile.LoadUint16(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *RTC_MODE1_Type) GetINTENSET_PER0() uint16 {
	return volatile.LoadUint16(&o.INTENSET.Reg) & 0x1
}
func (o *RTC_MODE1_Type) SetINTENSET_PER1(value uint16) {
	volatile.StoreUint16(&o.INTENSET.Reg, volatile.LoadUint16(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *RTC_MODE1_Type) GetINTENSET_PER1() uint16 {
	return (volatile.LoadUint16(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *RTC_MODE1_Type) SetINTENSET_PER2(value uint16) {
	volatile.StoreUint16(&o.INTENSET.Reg, volatile.LoadUint16(&o.INTENSET.Reg)&^(0x4)|value<<2)
}
func (o *RTC_MODE1_Type) GetINTENSET_PER2() uint16 {
	return (volatile.LoadUint16(&o.INTENSET.Reg) & 0x4) >> 2
}
func (o *RTC_MODE1_Type) SetINTENSET_PER3(value uint16) {
	volatile.StoreUint16(&o.INTENSET.Reg, volatile.LoadUint16(&o.INTENSET.Reg)&^(0x8)|value<<3)
}
func (o *RTC_MODE1_Type) GetINTENSET_PER3() uint16 {
	return (volatile.LoadUint16(&o.INTENSET.Reg) & 0x8) >> 3
}
func (o *RTC_MODE1_Type) SetINTENSET_PER4(value uint16) {
	volatile.StoreUint16(&o.INTENSET.Reg, volatile.LoadUint16(&o.INTENSET.Reg)&^(0x10)|value<<4)
}
func (o *RTC_MODE1_Type) GetINTENSET_PER4() uint16 {
	return (volatile.LoadUint16(&o.INTENSET.Reg) & 0x10) >> 4
}
func (o *RTC_MODE1_Type) SetINTENSET_PER5(value uint16) {
	volatile.StoreUint16(&o.INTENSET.Reg, volatile.LoadUint16(&o.INTENSET.Reg)&^(0x20)|value<<5)
}
func (o *RTC_MODE1_Type) GetINTENSET_PER5() uint16 {
	return (volatile.LoadUint16(&o.INTENSET.Reg) & 0x20) >> 5
}
func (o *RTC_MODE1_Type) SetINTENSET_PER6(value uint16) {
	volatile.StoreUint16(&o.INTENSET.Reg, volatile.LoadUint16(&o.INTENSET.Reg)&^(0x40)|value<<6)
}
func (o *RTC_MODE1_Type) GetINTENSET_PER6() uint16 {
	return (volatile.LoadUint16(&o.INTENSET.Reg) & 0x40) >> 6
}
func (o *RTC_MODE1_Type) SetINTENSET_PER7(value uint16) {
	volatile.StoreUint16(&o.INTENSET.Reg, volatile.LoadUint16(&o.INTENSET.Reg)&^(0x80)|value<<7)
}
func (o *RTC_MODE1_Type) GetINTENSET_PER7() uint16 {
	return (volatile.LoadUint16(&o.INTENSET.Reg) & 0x80) >> 7
}
func (o *RTC_MODE1_Type) SetINTENSET_CMP0(value uint16) {
	volatile.StoreUint16(&o.INTENSET.Reg, volatile.LoadUint16(&o.INTENSET.Reg)&^(0x100)|value<<8)
}
func (o *RTC_MODE1_Type) GetINTENSET_CMP0() uint16 {
	return (volatile.LoadUint16(&o.INTENSET.Reg) & 0x100) >> 8
}
func (o *RTC_MODE1_Type) SetINTENSET_CMP1(value uint16) {
	volatile.StoreUint16(&o.INTENSET.Reg, volatile.LoadUint16(&o.INTENSET.Reg)&^(0x200)|value<<9)
}
func (o *RTC_MODE1_Type) GetINTENSET_CMP1() uint16 {
	return (volatile.LoadUint16(&o.INTENSET.Reg) & 0x200) >> 9
}
func (o *RTC_MODE1_Type) SetINTENSET_TAMPER(value uint16) {
	volatile.StoreUint16(&o.INTENSET.Reg, volatile.LoadUint16(&o.INTENSET.Reg)&^(0x4000)|value<<14)
}
func (o *RTC_MODE1_Type) GetINTENSET_TAMPER() uint16 {
	return (volatile.LoadUint16(&o.INTENSET.Reg) & 0x4000) >> 14
}
func (o *RTC_MODE1_Type) SetINTENSET_OVF(value uint16) {
	volatile.StoreUint16(&o.INTENSET.Reg, volatile.LoadUint16(&o.INTENSET.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_MODE1_Type) GetINTENSET_OVF() uint16 {
	return (volatile.LoadUint16(&o.INTENSET.Reg) & 0x8000) >> 15
}

// RTC_MODE1.INTFLAG: MODE1 Interrupt Flag Status and Clear
func (o *RTC_MODE1_Type) SetINTFLAG_PER0(value uint16) {
	volatile.StoreUint16(&o.INTFLAG.Reg, volatile.LoadUint16(&o.INTFLAG.Reg)&^(0x1)|value)
}
func (o *RTC_MODE1_Type) GetINTFLAG_PER0() uint16 {
	return volatile.LoadUint16(&o.INTFLAG.Reg) & 0x1
}
func (o *RTC_MODE1_Type) SetINTFLAG_PER1(value uint16) {
	volatile.StoreUint16(&o.INTFLAG.Reg, volatile.LoadUint16(&o.INTFLAG.Reg)&^(0x2)|value<<1)
}
func (o *RTC_MODE1_Type) GetINTFLAG_PER1() uint16 {
	return (volatile.LoadUint16(&o.INTFLAG.Reg) & 0x2) >> 1
}
func (o *RTC_MODE1_Type) SetINTFLAG_PER2(value uint16) {
	volatile.StoreUint16(&o.INTFLAG.Reg, volatile.LoadUint16(&o.INTFLAG.Reg)&^(0x4)|value<<2)
}
func (o *RTC_MODE1_Type) GetINTFLAG_PER2() uint16 {
	return (volatile.LoadUint16(&o.INTFLAG.Reg) & 0x4) >> 2
}
func (o *RTC_MODE1_Type) SetINTFLAG_PER3(value uint16) {
	volatile.StoreUint16(&o.INTFLAG.Reg, volatile.LoadUint16(&o.INTFLAG.Reg)&^(0x8)|value<<3)
}
func (o *RTC_MODE1_Type) GetINTFLAG_PER3() uint16 {
	return (volatile.LoadUint16(&o.INTFLAG.Reg) & 0x8) >> 3
}
func (o *RTC_MODE1_Type) SetINTFLAG_PER4(value uint16) {
	volatile.StoreUint16(&o.INTFLAG.Reg, volatile.LoadUint16(&o.INTFLAG.Reg)&^(0x10)|value<<4)
}
func (o *RTC_MODE1_Type) GetINTFLAG_PER4() uint16 {
	return (volatile.LoadUint16(&o.INTFLAG.Reg) & 0x10) >> 4
}
func (o *RTC_MODE1_Type) SetINTFLAG_PER5(value uint16) {
	volatile.StoreUint16(&o.INTFLAG.Reg, volatile.LoadUint16(&o.INTFLAG.Reg)&^(0x20)|value<<5)
}
func (o *RTC_MODE1_Type) GetINTFLAG_PER5() uint16 {
	return (volatile.LoadUint16(&o.INTFLAG.Reg) & 0x20) >> 5
}
func (o *RTC_MODE1_Type) SetINTFLAG_PER6(value uint16) {
	volatile.StoreUint16(&o.INTFLAG.Reg, volatile.LoadUint16(&o.INTFLAG.Reg)&^(0x40)|value<<6)
}
func (o *RTC_MODE1_Type) GetINTFLAG_PER6() uint16 {
	return (volatile.LoadUint16(&o.INTFLAG.Reg) & 0x40) >> 6
}
func (o *RTC_MODE1_Type) SetINTFLAG_PER7(value uint16) {
	volatile.StoreUint16(&o.INTFLAG.Reg, volatile.LoadUint16(&o.INTFLAG.Reg)&^(0x80)|value<<7)
}
func (o *RTC_MODE1_Type) GetINTFLAG_PER7() uint16 {
	return (volatile.LoadUint16(&o.INTFLAG.Reg) & 0x80) >> 7
}
func (o *RTC_MODE1_Type) SetINTFLAG_CMP0(value uint16) {
	volatile.StoreUint16(&o.INTFLAG.Reg, volatile.LoadUint16(&o.INTFLAG.Reg)&^(0x100)|value<<8)
}
func (o *RTC_MODE1_Type) GetINTFLAG_CMP0() uint16 {
	return (volatile.LoadUint16(&o.INTFLAG.Reg) & 0x100) >> 8
}
func (o *RTC_MODE1_Type) SetINTFLAG_CMP1(value uint16) {
	volatile.StoreUint16(&o.INTFLAG.Reg, volatile.LoadUint16(&o.INTFLAG.Reg)&^(0x200)|value<<9)
}
func (o *RTC_MODE1_Type) GetINTFLAG_CMP1() uint16 {
	return (volatile.LoadUint16(&o.INTFLAG.Reg) & 0x200) >> 9
}
func (o *RTC_MODE1_Type) SetINTFLAG_TAMPER(value uint16) {
	volatile.StoreUint16(&o.INTFLAG.Reg, volatile.LoadUint16(&o.INTFLAG.Reg)&^(0x4000)|value<<14)
}
func (o *RTC_MODE1_Type) GetINTFLAG_TAMPER() uint16 {
	return (volatile.LoadUint16(&o.INTFLAG.Reg) & 0x4000) >> 14
}
func (o *RTC_MODE1_Type) SetINTFLAG_OVF(value uint16) {
	volatile.StoreUint16(&o.INTFLAG.Reg, volatile.LoadUint16(&o.INTFLAG.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_MODE1_Type) GetINTFLAG_OVF() uint16 {
	return (volatile.LoadUint16(&o.INTFLAG.Reg) & 0x8000) >> 15
}

// RTC_MODE1.DBGCTRL: Debug Control
func (o *RTC_MODE1_Type) SetDBGCTRL_DBGRUN(value uint8) {
	volatile.StoreUint8(&o.DBGCTRL.Reg, volatile.LoadUint8(&o.DBGCTRL.Reg)&^(0x1)|value)
}
func (o *RTC_MODE1_Type) GetDBGCTRL_DBGRUN() uint8 {
	return volatile.LoadUint8(&o.DBGCTRL.Reg) & 0x1
}

// RTC_MODE1.SYNCBUSY: MODE1 Synchronization Busy Status
func (o *RTC_MODE1_Type) SetSYNCBUSY_SWRST(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x1)|value)
}
func (o *RTC_MODE1_Type) GetSYNCBUSY_SWRST() uint32 {
	return volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x1
}
func (o *RTC_MODE1_Type) SetSYNCBUSY_ENABLE(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x2)|value<<1)
}
func (o *RTC_MODE1_Type) GetSYNCBUSY_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x2) >> 1
}
func (o *RTC_MODE1_Type) SetSYNCBUSY_FREQCORR(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x4)|value<<2)
}
func (o *RTC_MODE1_Type) GetSYNCBUSY_FREQCORR() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x4) >> 2
}
func (o *RTC_MODE1_Type) SetSYNCBUSY_COUNT(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x8)|value<<3)
}
func (o *RTC_MODE1_Type) GetSYNCBUSY_COUNT() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x8) >> 3
}
func (o *RTC_MODE1_Type) SetSYNCBUSY_PER(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x10)|value<<4)
}
func (o *RTC_MODE1_Type) GetSYNCBUSY_PER() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x10) >> 4
}
func (o *RTC_MODE1_Type) SetSYNCBUSY_COMP0(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x20)|value<<5)
}
func (o *RTC_MODE1_Type) GetSYNCBUSY_COMP0() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x20) >> 5
}
func (o *RTC_MODE1_Type) SetSYNCBUSY_COMP1(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x40)|value<<6)
}
func (o *RTC_MODE1_Type) GetSYNCBUSY_COMP1() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x40) >> 6
}
func (o *RTC_MODE1_Type) SetSYNCBUSY_COUNTSYNC(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_MODE1_Type) GetSYNCBUSY_COUNTSYNC() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x8000) >> 15
}
func (o *RTC_MODE1_Type) SetSYNCBUSY_GP0(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x10000)|value<<16)
}
func (o *RTC_MODE1_Type) GetSYNCBUSY_GP0() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x10000) >> 16
}
func (o *RTC_MODE1_Type) SetSYNCBUSY_GP1(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x20000)|value<<17)
}
func (o *RTC_MODE1_Type) GetSYNCBUSY_GP1() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x20000) >> 17
}

// RTC_MODE1.FREQCORR: Frequency Correction
func (o *RTC_MODE1_Type) SetFREQCORR_VALUE(value uint8) {
	volatile.StoreUint8(&o.FREQCORR.Reg, volatile.LoadUint8(&o.FREQCORR.Reg)&^(0x7f)|value)
}
func (o *RTC_MODE1_Type) GetFREQCORR_VALUE() uint8 {
	return volatile.LoadUint8(&o.FREQCORR.Reg) & 0x7f
}
func (o *RTC_MODE1_Type) SetFREQCORR_SIGN(value uint8) {
	volatile.StoreUint8(&o.FREQCORR.Reg, volatile.LoadUint8(&o.FREQCORR.Reg)&^(0x80)|value<<7)
}
func (o *RTC_MODE1_Type) GetFREQCORR_SIGN() uint8 {
	return (volatile.LoadUint8(&o.FREQCORR.Reg) & 0x80) >> 7
}

// RTC_MODE1.COUNT: MODE1 Counter Value
func (o *RTC_MODE1_Type) SetCOUNT(value uint16) {
	volatile.StoreUint16(&o.COUNT.Reg, value)
}
func (o *RTC_MODE1_Type) GetCOUNT() uint16 {
	return volatile.LoadUint16(&o.COUNT.Reg)
}

// RTC_MODE1.PER: MODE1 Counter Period
func (o *RTC_MODE1_Type) SetPER(value uint16) {
	volatile.StoreUint16(&o.PER.Reg, value)
}
func (o *RTC_MODE1_Type) GetPER() uint16 {
	return volatile.LoadUint16(&o.PER.Reg)
}

// RTC_MODE1.COMP0: MODE1 Compare n Value
func (o *RTC_MODE1_Type) SetCOMP0(value uint16) {
	volatile.StoreUint16(&o.COMP0.Reg, value)
}
func (o *RTC_MODE1_Type) GetCOMP0() uint16 {
	return volatile.LoadUint16(&o.COMP0.Reg)
}

// RTC_MODE1.COMP1: MODE1 Compare n Value
func (o *RTC_MODE1_Type) SetCOMP1(value uint16) {
	volatile.StoreUint16(&o.COMP1.Reg, value)
}
func (o *RTC_MODE1_Type) GetCOMP1() uint16 {
	return volatile.LoadUint16(&o.COMP1.Reg)
}

// RTC_MODE1.GP0: General Purpose
func (o *RTC_MODE1_Type) SetGP0(value uint32) {
	volatile.StoreUint32(&o.GP0.Reg, value)
}
func (o *RTC_MODE1_Type) GetGP0() uint32 {
	return volatile.LoadUint32(&o.GP0.Reg)
}

// RTC_MODE1.GP1: General Purpose
func (o *RTC_MODE1_Type) SetGP1(value uint32) {
	volatile.StoreUint32(&o.GP1.Reg, value)
}
func (o *RTC_MODE1_Type) GetGP1() uint32 {
	return volatile.LoadUint32(&o.GP1.Reg)
}

// RTC_MODE1.TAMPCTRL: Tamper Control
func (o *RTC_MODE1_Type) SetTAMPCTRL_IN0ACT(value uint32) {
	volatile.StoreUint32(&o.TAMPCTRL.Reg, volatile.LoadUint32(&o.TAMPCTRL.Reg)&^(0x3)|value)
}
func (o *RTC_MODE1_Type) GetTAMPCTRL_IN0ACT() uint32 {
	return volatile.LoadUint32(&o.TAMPCTRL.Reg) & 0x3
}
func (o *RTC_MODE1_Type) SetTAMPCTRL_IN1ACT(value uint32) {
	volatile.StoreUint32(&o.TAMPCTRL.Reg, volatile.LoadUint32(&o.TAMPCTRL.Reg)&^(0xc)|value<<2)
}
func (o *RTC_MODE1_Type) GetTAMPCTRL_IN1ACT() uint32 {
	return (volatile.LoadUint32(&o.TAMPCTRL.Reg) & 0xc) >> 2
}
func (o *RTC_MODE1_Type) SetTAMPCTRL_IN2ACT(value uint32) {
	volatile.StoreUint32(&o.TAMPCTRL.Reg, volatile.LoadUint32(&o.TAMPCTRL.Reg)&^(0x30)|value<<4)
}
func (o *RTC_MODE1_Type) GetTAMPCTRL_IN2ACT() uint32 {
	return (volatile.LoadUint32(&o.TAMPCTRL.Reg) & 0x30) >> 4
}
func (o *RTC_MODE1_Type) SetTAMPCTRL_IN3ACT(value uint32) {
	volatile.StoreUint32(&o.TAMPCTRL.Reg, volatile.LoadUint32(&o.TAMPCTRL.Reg)&^(0xc0)|value<<6)
}
func (o *RTC_MODE1_Type) GetTAMPCTRL_IN3ACT() uint32 {
	return (volatile.LoadUint32(&o.TAMPCTRL.Reg) & 0xc0) >> 6
}
func (o *RTC_MODE1_Type) SetTAMPCTRL_IN4ACT(value uint32) {
	volatile.StoreUint32(&o.TAMPCTRL.Reg, volatile.LoadUint32(&o.TAMPCTRL.Reg)&^(0x300)|value<<8)
}
func (o *RTC_MODE1_Type) GetTAMPCTRL_IN4ACT() uint32 {
	return (volatile.LoadUint32(&o.TAMPCTRL.Reg) & 0x300) >> 8
}
func (o *RTC_MODE1_Type) SetTAMPCTRL_TAMLVL0(value uint32) {
	volatile.StoreUint32(&o.TAMPCTRL.Reg, volatile.LoadUint32(&o.TAMPCTRL.Reg)&^(0x10000)|value<<16)
}
func (o *RTC_MODE1_Type) GetTAMPCTRL_TAMLVL0() uint32 {
	return (volatile.LoadUint32(&o.TAMPCTRL.Reg) & 0x10000) >> 16
}
func (o *RTC_MODE1_Type) SetTAMPCTRL_TAMLVL1(value uint32) {
	volatile.StoreUint32(&o.TAMPCTRL.Reg, volatile.LoadUint32(&o.TAMPCTRL.Reg)&^(0x20000)|value<<17)
}
func (o *RTC_MODE1_Type) GetTAMPCTRL_TAMLVL1() uint32 {
	return (volatile.LoadUint32(&o.TAMPCTRL.Reg) & 0x20000) >> 17
}
func (o *RTC_MODE1_Type) SetTAMPCTRL_TAMLVL2(value uint32) {
	volatile.StoreUint32(&o.TAMPCTRL.Reg, volatile.LoadUint32(&o.TAMPCTRL.Reg)&^(0x40000)|value<<18)
}
func (o *RTC_MODE1_Type) GetTAMPCTRL_TAMLVL2() uint32 {
	return (volatile.LoadUint32(&o.TAMPCTRL.Reg) & 0x40000) >> 18
}
func (o *RTC_MODE1_Type) SetTAMPCTRL_TAMLVL3(value uint32) {
	volatile.StoreUint32(&o.TAMPCTRL.Reg, volatile.LoadUint32(&o.TAMPCTRL.Reg)&^(0x80000)|value<<19)
}
func (o *RTC_MODE1_Type) GetTAMPCTRL_TAMLVL3() uint32 {
	return (volatile.LoadUint32(&o.TAMPCTRL.Reg) & 0x80000) >> 19
}
func (o *RTC_MODE1_Type) SetTAMPCTRL_TAMLVL4(value uint32) {
	volatile.StoreUint32(&o.TAMPCTRL.Reg, volatile.LoadUint32(&o.TAMPCTRL.Reg)&^(0x100000)|value<<20)
}
func (o *RTC_MODE1_Type) GetTAMPCTRL_TAMLVL4() uint32 {
	return (volatile.LoadUint32(&o.TAMPCTRL.Reg) & 0x100000) >> 20
}
func (o *RTC_MODE1_Type) SetTAMPCTRL_DEBNC0(value uint32) {
	volatile.StoreUint32(&o.TAMPCTRL.Reg, volatile.LoadUint32(&o.TAMPCTRL.Reg)&^(0x1000000)|value<<24)
}
func (o *RTC_MODE1_Type) GetTAMPCTRL_DEBNC0() uint32 {
	return (volatile.LoadUint32(&o.TAMPCTRL.Reg) & 0x1000000) >> 24
}
func (o *RTC_MODE1_Type) SetTAMPCTRL_DEBNC1(value uint32) {
	volatile.StoreUint32(&o.TAMPCTRL.Reg, volatile.LoadUint32(&o.TAMPCTRL.Reg)&^(0x2000000)|value<<25)
}
func (o *RTC_MODE1_Type) GetTAMPCTRL_DEBNC1() uint32 {
	return (volatile.LoadUint32(&o.TAMPCTRL.Reg) & 0x2000000) >> 25
}
func (o *RTC_MODE1_Type) SetTAMPCTRL_DEBNC2(value uint32) {
	volatile.StoreUint32(&o.TAMPCTRL.Reg, volatile.LoadUint32(&o.TAMPCTRL.Reg)&^(0x4000000)|value<<26)
}
func (o *RTC_MODE1_Type) GetTAMPCTRL_DEBNC2() uint32 {
	return (volatile.LoadUint32(&o.TAMPCTRL.Reg) & 0x4000000) >> 26
}
func (o *RTC_MODE1_Type) SetTAMPCTRL_DEBNC3(value uint32) {
	volatile.StoreUint32(&o.TAMPCTRL.Reg, volatile.LoadUint32(&o.TAMPCTRL.Reg)&^(0x8000000)|value<<27)
}
func (o *RTC_MODE1_Type) GetTAMPCTRL_DEBNC3() uint32 {
	return (volatile.LoadUint32(&o.TAMPCTRL.Reg) & 0x8000000) >> 27
}
func (o *RTC_MODE1_Type) SetTAMPCTRL_DEBNC4(value uint32) {
	volatile.StoreUint32(&o.TAMPCTRL.Reg, volatile.LoadUint32(&o.TAMPCTRL.Reg)&^(0x10000000)|value<<28)
}
func (o *RTC_MODE1_Type) GetTAMPCTRL_DEBNC4() uint32 {
	return (volatile.LoadUint32(&o.TAMPCTRL.Reg) & 0x10000000) >> 28
}

// RTC_MODE1.TIMESTAMP: MODE1 Timestamp
func (o *RTC_MODE1_Type) SetTIMESTAMP_COUNT(value uint32) {
	volatile.StoreUint32(&o.TIMESTAMP.Reg, volatile.LoadUint32(&o.TIMESTAMP.Reg)&^(0xffff)|value)
}
func (o *RTC_MODE1_Type) GetTIMESTAMP_COUNT() uint32 {
	return volatile.LoadUint32(&o.TIMESTAMP.Reg) & 0xffff
}

// RTC_MODE1.TAMPID: Tamper ID
func (o *RTC_MODE1_Type) SetTAMPID_TAMPID0(value uint32) {
	volatile.StoreUint32(&o.TAMPID.Reg, volatile.LoadUint32(&o.TAMPID.Reg)&^(0x1)|value)
}
func (o *RTC_MODE1_Type) GetTAMPID_TAMPID0() uint32 {
	return volatile.LoadUint32(&o.TAMPID.Reg) & 0x1
}
func (o *RTC_MODE1_Type) SetTAMPID_TAMPID1(value uint32) {
	volatile.StoreUint32(&o.TAMPID.Reg, volatile.LoadUint32(&o.TAMPID.Reg)&^(0x2)|value<<1)
}
func (o *RTC_MODE1_Type) GetTAMPID_TAMPID1() uint32 {
	return (volatile.LoadUint32(&o.TAMPID.Reg) & 0x2) >> 1
}
func (o *RTC_MODE1_Type) SetTAMPID_TAMPID2(value uint32) {
	volatile.StoreUint32(&o.TAMPID.Reg, volatile.LoadUint32(&o.TAMPID.Reg)&^(0x4)|value<<2)
}
func (o *RTC_MODE1_Type) GetTAMPID_TAMPID2() uint32 {
	return (volatile.LoadUint32(&o.TAMPID.Reg) & 0x4) >> 2
}
func (o *RTC_MODE1_Type) SetTAMPID_TAMPID3(value uint32) {
	volatile.StoreUint32(&o.TAMPID.Reg, volatile.LoadUint32(&o.TAMPID.Reg)&^(0x8)|value<<3)
}
func (o *RTC_MODE1_Type) GetTAMPID_TAMPID3() uint32 {
	return (volatile.LoadUint32(&o.TAMPID.Reg) & 0x8) >> 3
}
func (o *RTC_MODE1_Type) SetTAMPID_TAMPID4(value uint32) {
	volatile.StoreUint32(&o.TAMPID.Reg, volatile.LoadUint32(&o.TAMPID.Reg)&^(0x10)|value<<4)
}
func (o *RTC_MODE1_Type) GetTAMPID_TAMPID4() uint32 {
	return (volatile.LoadUint32(&o.TAMPID.Reg) & 0x10) >> 4
}
func (o *RTC_MODE1_Type) SetTAMPID_TAMPEVT(value uint32) {
	volatile.StoreUint32(&o.TAMPID.Reg, volatile.LoadUint32(&o.TAMPID.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_MODE1_Type) GetTAMPID_TAMPEVT() uint32 {
	return (volatile.LoadUint32(&o.TAMPID.Reg) & 0x80000000) >> 31
}

// RTC_MODE1.BKUP0: Backup
func (o *RTC_MODE1_Type) SetBKUP0(value uint32) {
	volatile.StoreUint32(&o.BKUP0.Reg, value)
}
func (o *RTC_MODE1_Type) GetBKUP0() uint32 {
	return volatile.LoadUint32(&o.BKUP0.Reg)
}

// RTC_MODE1.BKUP1: Backup
func (o *RTC_MODE1_Type) SetBKUP1(value uint32) {
	volatile.StoreUint32(&o.BKUP1.Reg, value)
}
func (o *RTC_MODE1_Type) GetBKUP1() uint32 {
	return volatile.LoadUint32(&o.BKUP1.Reg)
}

// RTC_MODE1.BKUP2: Backup
func (o *RTC_MODE1_Type) SetBKUP2(value uint32) {
	volatile.StoreUint32(&o.BKUP2.Reg, value)
}
func (o *RTC_MODE1_Type) GetBKUP2() uint32 {
	return volatile.LoadUint32(&o.BKUP2.Reg)
}

// RTC_MODE1.BKUP3: Backup
func (o *RTC_MODE1_Type) SetBKUP3(value uint32) {
	volatile.StoreUint32(&o.BKUP3.Reg, value)
}
func (o *RTC_MODE1_Type) GetBKUP3() uint32 {
	return volatile.LoadUint32(&o.BKUP3.Reg)
}

// RTC_MODE1.BKUP4: Backup
func (o *RTC_MODE1_Type) SetBKUP4(value uint32) {
	volatile.StoreUint32(&o.BKUP4.Reg, value)
}
func (o *RTC_MODE1_Type) GetBKUP4() uint32 {
	return volatile.LoadUint32(&o.BKUP4.Reg)
}

// RTC_MODE1.BKUP5: Backup
func (o *RTC_MODE1_Type) SetBKUP5(value uint32) {
	volatile.StoreUint32(&o.BKUP5.Reg, value)
}
func (o *RTC_MODE1_Type) GetBKUP5() uint32 {
	return volatile.LoadUint32(&o.BKUP5.Reg)
}

// RTC_MODE1.BKUP6: Backup
func (o *RTC_MODE1_Type) SetBKUP6(value uint32) {
	volatile.StoreUint32(&o.BKUP6.Reg, value)
}
func (o *RTC_MODE1_Type) GetBKUP6() uint32 {
	return volatile.LoadUint32(&o.BKUP6.Reg)
}

// RTC_MODE1.BKUP7: Backup
func (o *RTC_MODE1_Type) SetBKUP7(value uint32) {
	volatile.StoreUint32(&o.BKUP7.Reg, value)
}
func (o *RTC_MODE1_Type) GetBKUP7() uint32 {
	return volatile.LoadUint32(&o.BKUP7.Reg)
}

// Real-Time Counter - MODE2
type RTC_MODE2_Type struct {
	CTRLA     volatile.Register16 // 0x0
	CTRLB     volatile.Register16 // 0x2
	EVCTRL    volatile.Register32 // 0x4
	INTENCLR  volatile.Register16 // 0x8
	INTENSET  volatile.Register16 // 0xA
	INTFLAG   volatile.Register16 // 0xC
	DBGCTRL   volatile.Register8  // 0xE
	_         byte
	SYNCBUSY  volatile.Register32 // 0x10
	FREQCORR  volatile.Register8  // 0x14
	_         [3]byte
	CLOCK     volatile.Register32 // 0x18
	_         [4]byte
	ALARM0    volatile.Register32 // 0x20
	MASK0     volatile.Register8  // 0x24
	_         [27]byte
	GP0       volatile.Register32 // 0x40
	GP1       volatile.Register32 // 0x44
	_         [24]byte
	TAMPCTRL  volatile.Register32 // 0x60
	TIMESTAMP volatile.Register32 // 0x64
	TAMPID    volatile.Register32 // 0x68
	_         [20]byte
	BKUP0     volatile.Register32 // 0x80
	BKUP1     volatile.Register32 // 0x84
	BKUP2     volatile.Register32 // 0x88
	BKUP3     volatile.Register32 // 0x8C
	BKUP4     volatile.Register32 // 0x90
	BKUP5     volatile.Register32 // 0x94
	BKUP6     volatile.Register32 // 0x98
	BKUP7     volatile.Register32 // 0x9C
}

// RTC_MODE2.CTRLA: MODE2 Control A
func (o *RTC_MODE2_Type) SetCTRLA_SWRST(value uint16) {
	volatile.StoreUint16(&o.CTRLA.Reg, volatile.LoadUint16(&o.CTRLA.Reg)&^(0x1)|value)
}
func (o *RTC_MODE2_Type) GetCTRLA_SWRST() uint16 {
	return volatile.LoadUint16(&o.CTRLA.Reg) & 0x1
}
func (o *RTC_MODE2_Type) SetCTRLA_ENABLE(value uint16) {
	volatile.StoreUint16(&o.CTRLA.Reg, volatile.LoadUint16(&o.CTRLA.Reg)&^(0x2)|value<<1)
}
func (o *RTC_MODE2_Type) GetCTRLA_ENABLE() uint16 {
	return (volatile.LoadUint16(&o.CTRLA.Reg) & 0x2) >> 1
}
func (o *RTC_MODE2_Type) SetCTRLA_MODE(value uint16) {
	volatile.StoreUint16(&o.CTRLA.Reg, volatile.LoadUint16(&o.CTRLA.Reg)&^(0xc)|value<<2)
}
func (o *RTC_MODE2_Type) GetCTRLA_MODE() uint16 {
	return (volatile.LoadUint16(&o.CTRLA.Reg) & 0xc) >> 2
}
func (o *RTC_MODE2_Type) SetCTRLA_CLKREP(value uint16) {
	volatile.StoreUint16(&o.CTRLA.Reg, volatile.LoadUint16(&o.CTRLA.Reg)&^(0x40)|value<<6)
}
func (o *RTC_MODE2_Type) GetCTRLA_CLKREP() uint16 {
	return (volatile.LoadUint16(&o.CTRLA.Reg) & 0x40) >> 6
}
func (o *RTC_MODE2_Type) SetCTRLA_MATCHCLR(value uint16) {
	volatile.StoreUint16(&o.CTRLA.Reg, volatile.LoadUint16(&o.CTRLA.Reg)&^(0x80)|value<<7)
}
func (o *RTC_MODE2_Type) GetCTRLA_MATCHCLR() uint16 {
	return (volatile.LoadUint16(&o.CTRLA.Reg) & 0x80) >> 7
}
func (o *RTC_MODE2_Type) SetCTRLA_PRESCALER(value uint16) {
	volatile.StoreUint16(&o.CTRLA.Reg, volatile.LoadUint16(&o.CTRLA.Reg)&^(0xf00)|value<<8)
}
func (o *RTC_MODE2_Type) GetCTRLA_PRESCALER() uint16 {
	return (volatile.LoadUint16(&o.CTRLA.Reg) & 0xf00) >> 8
}
func (o *RTC_MODE2_Type) SetCTRLA_BKTRST(value uint16) {
	volatile.StoreUint16(&o.CTRLA.Reg, volatile.LoadUint16(&o.CTRLA.Reg)&^(0x2000)|value<<13)
}
func (o *RTC_MODE2_Type) GetCTRLA_BKTRST() uint16 {
	return (volatile.LoadUint16(&o.CTRLA.Reg) & 0x2000) >> 13
}
func (o *RTC_MODE2_Type) SetCTRLA_GPTRST(value uint16) {
	volatile.StoreUint16(&o.CTRLA.Reg, volatile.LoadUint16(&o.CTRLA.Reg)&^(0x4000)|value<<14)
}
func (o *RTC_MODE2_Type) GetCTRLA_GPTRST() uint16 {
	return (volatile.LoadUint16(&o.CTRLA.Reg) & 0x4000) >> 14
}
func (o *RTC_MODE2_Type) SetCTRLA_CLOCKSYNC(value uint16) {
	volatile.StoreUint16(&o.CTRLA.Reg, volatile.LoadUint16(&o.CTRLA.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_MODE2_Type) GetCTRLA_CLOCKSYNC() uint16 {
	return (volatile.LoadUint16(&o.CTRLA.Reg) & 0x8000) >> 15
}

// RTC_MODE2.CTRLB: MODE2 Control B
func (o *RTC_MODE2_Type) SetCTRLB_GP0EN(value uint16) {
	volatile.StoreUint16(&o.CTRLB.Reg, volatile.LoadUint16(&o.CTRLB.Reg)&^(0x1)|value)
}
func (o *RTC_MODE2_Type) GetCTRLB_GP0EN() uint16 {
	return volatile.LoadUint16(&o.CTRLB.Reg) & 0x1
}
func (o *RTC_MODE2_Type) SetCTRLB_DEBMAJ(value uint16) {
	volatile.StoreUint16(&o.CTRLB.Reg, volatile.LoadUint16(&o.CTRLB.Reg)&^(0x10)|value<<4)
}
func (o *RTC_MODE2_Type) GetCTRLB_DEBMAJ() uint16 {
	return (volatile.LoadUint16(&o.CTRLB.Reg) & 0x10) >> 4
}
func (o *RTC_MODE2_Type) SetCTRLB_DEBASYNC(value uint16) {
	volatile.StoreUint16(&o.CTRLB.Reg, volatile.LoadUint16(&o.CTRLB.Reg)&^(0x20)|value<<5)
}
func (o *RTC_MODE2_Type) GetCTRLB_DEBASYNC() uint16 {
	return (volatile.LoadUint16(&o.CTRLB.Reg) & 0x20) >> 5
}
func (o *RTC_MODE2_Type) SetCTRLB_RTCOUT(value uint16) {
	volatile.StoreUint16(&o.CTRLB.Reg, volatile.LoadUint16(&o.CTRLB.Reg)&^(0x40)|value<<6)
}
func (o *RTC_MODE2_Type) GetCTRLB_RTCOUT() uint16 {
	return (volatile.LoadUint16(&o.CTRLB.Reg) & 0x40) >> 6
}
func (o *RTC_MODE2_Type) SetCTRLB_DMAEN(value uint16) {
	volatile.StoreUint16(&o.CTRLB.Reg, volatile.LoadUint16(&o.CTRLB.Reg)&^(0x80)|value<<7)
}
func (o *RTC_MODE2_Type) GetCTRLB_DMAEN() uint16 {
	return (volatile.LoadUint16(&o.CTRLB.Reg) & 0x80) >> 7
}
func (o *RTC_MODE2_Type) SetCTRLB_DEBF(value uint16) {
	volatile.StoreUint16(&o.CTRLB.Reg, volatile.LoadUint16(&o.CTRLB.Reg)&^(0x700)|value<<8)
}
func (o *RTC_MODE2_Type) GetCTRLB_DEBF() uint16 {
	return (volatile.LoadUint16(&o.CTRLB.Reg) & 0x700) >> 8
}
func (o *RTC_MODE2_Type) SetCTRLB_ACTF(value uint16) {
	volatile.StoreUint16(&o.CTRLB.Reg, volatile.LoadUint16(&o.CTRLB.Reg)&^(0x7000)|value<<12)
}
func (o *RTC_MODE2_Type) GetCTRLB_ACTF() uint16 {
	return (volatile.LoadUint16(&o.CTRLB.Reg) & 0x7000) >> 12
}

// RTC_MODE2.EVCTRL: MODE2 Event Control
func (o *RTC_MODE2_Type) SetEVCTRL_PEREO0(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x1)|value)
}
func (o *RTC_MODE2_Type) GetEVCTRL_PEREO0() uint32 {
	return volatile.LoadUint32(&o.EVCTRL.Reg) & 0x1
}
func (o *RTC_MODE2_Type) SetEVCTRL_PEREO1(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x2)|value<<1)
}
func (o *RTC_MODE2_Type) GetEVCTRL_PEREO1() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x2) >> 1
}
func (o *RTC_MODE2_Type) SetEVCTRL_PEREO2(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x4)|value<<2)
}
func (o *RTC_MODE2_Type) GetEVCTRL_PEREO2() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x4) >> 2
}
func (o *RTC_MODE2_Type) SetEVCTRL_PEREO3(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x8)|value<<3)
}
func (o *RTC_MODE2_Type) GetEVCTRL_PEREO3() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x8) >> 3
}
func (o *RTC_MODE2_Type) SetEVCTRL_PEREO4(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x10)|value<<4)
}
func (o *RTC_MODE2_Type) GetEVCTRL_PEREO4() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x10) >> 4
}
func (o *RTC_MODE2_Type) SetEVCTRL_PEREO5(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x20)|value<<5)
}
func (o *RTC_MODE2_Type) GetEVCTRL_PEREO5() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x20) >> 5
}
func (o *RTC_MODE2_Type) SetEVCTRL_PEREO6(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x40)|value<<6)
}
func (o *RTC_MODE2_Type) GetEVCTRL_PEREO6() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x40) >> 6
}
func (o *RTC_MODE2_Type) SetEVCTRL_PEREO7(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x80)|value<<7)
}
func (o *RTC_MODE2_Type) GetEVCTRL_PEREO7() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x80) >> 7
}
func (o *RTC_MODE2_Type) SetEVCTRL_ALARMEO0(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x100)|value<<8)
}
func (o *RTC_MODE2_Type) GetEVCTRL_ALARMEO0() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x100) >> 8
}
func (o *RTC_MODE2_Type) SetEVCTRL_TAMPEREO(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x4000)|value<<14)
}
func (o *RTC_MODE2_Type) GetEVCTRL_TAMPEREO() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x4000) >> 14
}
func (o *RTC_MODE2_Type) SetEVCTRL_OVFEO(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_MODE2_Type) GetEVCTRL_OVFEO() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x8000) >> 15
}
func (o *RTC_MODE2_Type) SetEVCTRL_TAMPEVEI(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x10000)|value<<16)
}
func (o *RTC_MODE2_Type) GetEVCTRL_TAMPEVEI() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x10000) >> 16
}

// RTC_MODE2.INTENCLR: MODE2 Interrupt Enable Clear
func (o *RTC_MODE2_Type) SetINTENCLR_PER0(value uint16) {
	volatile.StoreUint16(&o.INTENCLR.Reg, volatile.LoadUint16(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *RTC_MODE2_Type) GetINTENCLR_PER0() uint16 {
	return volatile.LoadUint16(&o.INTENCLR.Reg) & 0x1
}
func (o *RTC_MODE2_Type) SetINTENCLR_PER1(value uint16) {
	volatile.StoreUint16(&o.INTENCLR.Reg, volatile.LoadUint16(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *RTC_MODE2_Type) GetINTENCLR_PER1() uint16 {
	return (volatile.LoadUint16(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *RTC_MODE2_Type) SetINTENCLR_PER2(value uint16) {
	volatile.StoreUint16(&o.INTENCLR.Reg, volatile.LoadUint16(&o.INTENCLR.Reg)&^(0x4)|value<<2)
}
func (o *RTC_MODE2_Type) GetINTENCLR_PER2() uint16 {
	return (volatile.LoadUint16(&o.INTENCLR.Reg) & 0x4) >> 2
}
func (o *RTC_MODE2_Type) SetINTENCLR_PER3(value uint16) {
	volatile.StoreUint16(&o.INTENCLR.Reg, volatile.LoadUint16(&o.INTENCLR.Reg)&^(0x8)|value<<3)
}
func (o *RTC_MODE2_Type) GetINTENCLR_PER3() uint16 {
	return (volatile.LoadUint16(&o.INTENCLR.Reg) & 0x8) >> 3
}
func (o *RTC_MODE2_Type) SetINTENCLR_PER4(value uint16) {
	volatile.StoreUint16(&o.INTENCLR.Reg, volatile.LoadUint16(&o.INTENCLR.Reg)&^(0x10)|value<<4)
}
func (o *RTC_MODE2_Type) GetINTENCLR_PER4() uint16 {
	return (volatile.LoadUint16(&o.INTENCLR.Reg) & 0x10) >> 4
}
func (o *RTC_MODE2_Type) SetINTENCLR_PER5(value uint16) {
	volatile.StoreUint16(&o.INTENCLR.Reg, volatile.LoadUint16(&o.INTENCLR.Reg)&^(0x20)|value<<5)
}
func (o *RTC_MODE2_Type) GetINTENCLR_PER5() uint16 {
	return (volatile.LoadUint16(&o.INTENCLR.Reg) & 0x20) >> 5
}
func (o *RTC_MODE2_Type) SetINTENCLR_PER6(value uint16) {
	volatile.StoreUint16(&o.INTENCLR.Reg, volatile.LoadUint16(&o.INTENCLR.Reg)&^(0x40)|value<<6)
}
func (o *RTC_MODE2_Type) GetINTENCLR_PER6() uint16 {
	return (volatile.LoadUint16(&o.INTENCLR.Reg) & 0x40) >> 6
}
func (o *RTC_MODE2_Type) SetINTENCLR_PER7(value uint16) {
	volatile.StoreUint16(&o.INTENCLR.Reg, volatile.LoadUint16(&o.INTENCLR.Reg)&^(0x80)|value<<7)
}
func (o *RTC_MODE2_Type) GetINTENCLR_PER7() uint16 {
	return (volatile.LoadUint16(&o.INTENCLR.Reg) & 0x80) >> 7
}
func (o *RTC_MODE2_Type) SetINTENCLR_ALARM0(value uint16) {
	volatile.StoreUint16(&o.INTENCLR.Reg, volatile.LoadUint16(&o.INTENCLR.Reg)&^(0x100)|value<<8)
}
func (o *RTC_MODE2_Type) GetINTENCLR_ALARM0() uint16 {
	return (volatile.LoadUint16(&o.INTENCLR.Reg) & 0x100) >> 8
}
func (o *RTC_MODE2_Type) SetINTENCLR_TAMPER(value uint16) {
	volatile.StoreUint16(&o.INTENCLR.Reg, volatile.LoadUint16(&o.INTENCLR.Reg)&^(0x4000)|value<<14)
}
func (o *RTC_MODE2_Type) GetINTENCLR_TAMPER() uint16 {
	return (volatile.LoadUint16(&o.INTENCLR.Reg) & 0x4000) >> 14
}
func (o *RTC_MODE2_Type) SetINTENCLR_OVF(value uint16) {
	volatile.StoreUint16(&o.INTENCLR.Reg, volatile.LoadUint16(&o.INTENCLR.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_MODE2_Type) GetINTENCLR_OVF() uint16 {
	return (volatile.LoadUint16(&o.INTENCLR.Reg) & 0x8000) >> 15
}

// RTC_MODE2.INTENSET: MODE2 Interrupt Enable Set
func (o *RTC_MODE2_Type) SetINTENSET_PER0(value uint16) {
	volatile.StoreUint16(&o.INTENSET.Reg, volatile.LoadUint16(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *RTC_MODE2_Type) GetINTENSET_PER0() uint16 {
	return volatile.LoadUint16(&o.INTENSET.Reg) & 0x1
}
func (o *RTC_MODE2_Type) SetINTENSET_PER1(value uint16) {
	volatile.StoreUint16(&o.INTENSET.Reg, volatile.LoadUint16(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *RTC_MODE2_Type) GetINTENSET_PER1() uint16 {
	return (volatile.LoadUint16(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *RTC_MODE2_Type) SetINTENSET_PER2(value uint16) {
	volatile.StoreUint16(&o.INTENSET.Reg, volatile.LoadUint16(&o.INTENSET.Reg)&^(0x4)|value<<2)
}
func (o *RTC_MODE2_Type) GetINTENSET_PER2() uint16 {
	return (volatile.LoadUint16(&o.INTENSET.Reg) & 0x4) >> 2
}
func (o *RTC_MODE2_Type) SetINTENSET_PER3(value uint16) {
	volatile.StoreUint16(&o.INTENSET.Reg, volatile.LoadUint16(&o.INTENSET.Reg)&^(0x8)|value<<3)
}
func (o *RTC_MODE2_Type) GetINTENSET_PER3() uint16 {
	return (volatile.LoadUint16(&o.INTENSET.Reg) & 0x8) >> 3
}
func (o *RTC_MODE2_Type) SetINTENSET_PER4(value uint16) {
	volatile.StoreUint16(&o.INTENSET.Reg, volatile.LoadUint16(&o.INTENSET.Reg)&^(0x10)|value<<4)
}
func (o *RTC_MODE2_Type) GetINTENSET_PER4() uint16 {
	return (volatile.LoadUint16(&o.INTENSET.Reg) & 0x10) >> 4
}
func (o *RTC_MODE2_Type) SetINTENSET_PER5(value uint16) {
	volatile.StoreUint16(&o.INTENSET.Reg, volatile.LoadUint16(&o.INTENSET.Reg)&^(0x20)|value<<5)
}
func (o *RTC_MODE2_Type) GetINTENSET_PER5() uint16 {
	return (volatile.LoadUint16(&o.INTENSET.Reg) & 0x20) >> 5
}
func (o *RTC_MODE2_Type) SetINTENSET_PER6(value uint16) {
	volatile.StoreUint16(&o.INTENSET.Reg, volatile.LoadUint16(&o.INTENSET.Reg)&^(0x40)|value<<6)
}
func (o *RTC_MODE2_Type) GetINTENSET_PER6() uint16 {
	return (volatile.LoadUint16(&o.INTENSET.Reg) & 0x40) >> 6
}
func (o *RTC_MODE2_Type) SetINTENSET_PER7(value uint16) {
	volatile.StoreUint16(&o.INTENSET.Reg, volatile.LoadUint16(&o.INTENSET.Reg)&^(0x80)|value<<7)
}
func (o *RTC_MODE2_Type) GetINTENSET_PER7() uint16 {
	return (volatile.LoadUint16(&o.INTENSET.Reg) & 0x80) >> 7
}
func (o *RTC_MODE2_Type) SetINTENSET_ALARM0(value uint16) {
	volatile.StoreUint16(&o.INTENSET.Reg, volatile.LoadUint16(&o.INTENSET.Reg)&^(0x100)|value<<8)
}
func (o *RTC_MODE2_Type) GetINTENSET_ALARM0() uint16 {
	return (volatile.LoadUint16(&o.INTENSET.Reg) & 0x100) >> 8
}
func (o *RTC_MODE2_Type) SetINTENSET_TAMPER(value uint16) {
	volatile.StoreUint16(&o.INTENSET.Reg, volatile.LoadUint16(&o.INTENSET.Reg)&^(0x4000)|value<<14)
}
func (o *RTC_MODE2_Type) GetINTENSET_TAMPER() uint16 {
	return (volatile.LoadUint16(&o.INTENSET.Reg) & 0x4000) >> 14
}
func (o *RTC_MODE2_Type) SetINTENSET_OVF(value uint16) {
	volatile.StoreUint16(&o.INTENSET.Reg, volatile.LoadUint16(&o.INTENSET.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_MODE2_Type) GetINTENSET_OVF() uint16 {
	return (volatile.LoadUint16(&o.INTENSET.Reg) & 0x8000) >> 15
}

// RTC_MODE2.INTFLAG: MODE2 Interrupt Flag Status and Clear
func (o *RTC_MODE2_Type) SetINTFLAG_PER0(value uint16) {
	volatile.StoreUint16(&o.INTFLAG.Reg, volatile.LoadUint16(&o.INTFLAG.Reg)&^(0x1)|value)
}
func (o *RTC_MODE2_Type) GetINTFLAG_PER0() uint16 {
	return volatile.LoadUint16(&o.INTFLAG.Reg) & 0x1
}
func (o *RTC_MODE2_Type) SetINTFLAG_PER1(value uint16) {
	volatile.StoreUint16(&o.INTFLAG.Reg, volatile.LoadUint16(&o.INTFLAG.Reg)&^(0x2)|value<<1)
}
func (o *RTC_MODE2_Type) GetINTFLAG_PER1() uint16 {
	return (volatile.LoadUint16(&o.INTFLAG.Reg) & 0x2) >> 1
}
func (o *RTC_MODE2_Type) SetINTFLAG_PER2(value uint16) {
	volatile.StoreUint16(&o.INTFLAG.Reg, volatile.LoadUint16(&o.INTFLAG.Reg)&^(0x4)|value<<2)
}
func (o *RTC_MODE2_Type) GetINTFLAG_PER2() uint16 {
	return (volatile.LoadUint16(&o.INTFLAG.Reg) & 0x4) >> 2
}
func (o *RTC_MODE2_Type) SetINTFLAG_PER3(value uint16) {
	volatile.StoreUint16(&o.INTFLAG.Reg, volatile.LoadUint16(&o.INTFLAG.Reg)&^(0x8)|value<<3)
}
func (o *RTC_MODE2_Type) GetINTFLAG_PER3() uint16 {
	return (volatile.LoadUint16(&o.INTFLAG.Reg) & 0x8) >> 3
}
func (o *RTC_MODE2_Type) SetINTFLAG_PER4(value uint16) {
	volatile.StoreUint16(&o.INTFLAG.Reg, volatile.LoadUint16(&o.INTFLAG.Reg)&^(0x10)|value<<4)
}
func (o *RTC_MODE2_Type) GetINTFLAG_PER4() uint16 {
	return (volatile.LoadUint16(&o.INTFLAG.Reg) & 0x10) >> 4
}
func (o *RTC_MODE2_Type) SetINTFLAG_PER5(value uint16) {
	volatile.StoreUint16(&o.INTFLAG.Reg, volatile.LoadUint16(&o.INTFLAG.Reg)&^(0x20)|value<<5)
}
func (o *RTC_MODE2_Type) GetINTFLAG_PER5() uint16 {
	return (volatile.LoadUint16(&o.INTFLAG.Reg) & 0x20) >> 5
}
func (o *RTC_MODE2_Type) SetINTFLAG_PER6(value uint16) {
	volatile.StoreUint16(&o.INTFLAG.Reg, volatile.LoadUint16(&o.INTFLAG.Reg)&^(0x40)|value<<6)
}
func (o *RTC_MODE2_Type) GetINTFLAG_PER6() uint16 {
	return (volatile.LoadUint16(&o.INTFLAG.Reg) & 0x40) >> 6
}
func (o *RTC_MODE2_Type) SetINTFLAG_PER7(value uint16) {
	volatile.StoreUint16(&o.INTFLAG.Reg, volatile.LoadUint16(&o.INTFLAG.Reg)&^(0x80)|value<<7)
}
func (o *RTC_MODE2_Type) GetINTFLAG_PER7() uint16 {
	return (volatile.LoadUint16(&o.INTFLAG.Reg) & 0x80) >> 7
}
func (o *RTC_MODE2_Type) SetINTFLAG_ALARM0(value uint16) {
	volatile.StoreUint16(&o.INTFLAG.Reg, volatile.LoadUint16(&o.INTFLAG.Reg)&^(0x100)|value<<8)
}
func (o *RTC_MODE2_Type) GetINTFLAG_ALARM0() uint16 {
	return (volatile.LoadUint16(&o.INTFLAG.Reg) & 0x100) >> 8
}
func (o *RTC_MODE2_Type) SetINTFLAG_TAMPER(value uint16) {
	volatile.StoreUint16(&o.INTFLAG.Reg, volatile.LoadUint16(&o.INTFLAG.Reg)&^(0x4000)|value<<14)
}
func (o *RTC_MODE2_Type) GetINTFLAG_TAMPER() uint16 {
	return (volatile.LoadUint16(&o.INTFLAG.Reg) & 0x4000) >> 14
}
func (o *RTC_MODE2_Type) SetINTFLAG_OVF(value uint16) {
	volatile.StoreUint16(&o.INTFLAG.Reg, volatile.LoadUint16(&o.INTFLAG.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_MODE2_Type) GetINTFLAG_OVF() uint16 {
	return (volatile.LoadUint16(&o.INTFLAG.Reg) & 0x8000) >> 15
}

// RTC_MODE2.DBGCTRL: Debug Control
func (o *RTC_MODE2_Type) SetDBGCTRL_DBGRUN(value uint8) {
	volatile.StoreUint8(&o.DBGCTRL.Reg, volatile.LoadUint8(&o.DBGCTRL.Reg)&^(0x1)|value)
}
func (o *RTC_MODE2_Type) GetDBGCTRL_DBGRUN() uint8 {
	return volatile.LoadUint8(&o.DBGCTRL.Reg) & 0x1
}

// RTC_MODE2.SYNCBUSY: MODE2 Synchronization Busy Status
func (o *RTC_MODE2_Type) SetSYNCBUSY_SWRST(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x1)|value)
}
func (o *RTC_MODE2_Type) GetSYNCBUSY_SWRST() uint32 {
	return volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x1
}
func (o *RTC_MODE2_Type) SetSYNCBUSY_ENABLE(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x2)|value<<1)
}
func (o *RTC_MODE2_Type) GetSYNCBUSY_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x2) >> 1
}
func (o *RTC_MODE2_Type) SetSYNCBUSY_FREQCORR(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x4)|value<<2)
}
func (o *RTC_MODE2_Type) GetSYNCBUSY_FREQCORR() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x4) >> 2
}
func (o *RTC_MODE2_Type) SetSYNCBUSY_CLOCK(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x8)|value<<3)
}
func (o *RTC_MODE2_Type) GetSYNCBUSY_CLOCK() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x8) >> 3
}
func (o *RTC_MODE2_Type) SetSYNCBUSY_ALARM0(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x20)|value<<5)
}
func (o *RTC_MODE2_Type) GetSYNCBUSY_ALARM0() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x20) >> 5
}
func (o *RTC_MODE2_Type) SetSYNCBUSY_MASK0(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x800)|value<<11)
}
func (o *RTC_MODE2_Type) GetSYNCBUSY_MASK0() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x800) >> 11
}
func (o *RTC_MODE2_Type) SetSYNCBUSY_CLOCKSYNC(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x8000)|value<<15)
}
func (o *RTC_MODE2_Type) GetSYNCBUSY_CLOCKSYNC() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x8000) >> 15
}
func (o *RTC_MODE2_Type) SetSYNCBUSY_GP0(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x10000)|value<<16)
}
func (o *RTC_MODE2_Type) GetSYNCBUSY_GP0() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x10000) >> 16
}
func (o *RTC_MODE2_Type) SetSYNCBUSY_GP1(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x20000)|value<<17)
}
func (o *RTC_MODE2_Type) GetSYNCBUSY_GP1() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x20000) >> 17
}

// RTC_MODE2.FREQCORR: Frequency Correction
func (o *RTC_MODE2_Type) SetFREQCORR_VALUE(value uint8) {
	volatile.StoreUint8(&o.FREQCORR.Reg, volatile.LoadUint8(&o.FREQCORR.Reg)&^(0x7f)|value)
}
func (o *RTC_MODE2_Type) GetFREQCORR_VALUE() uint8 {
	return volatile.LoadUint8(&o.FREQCORR.Reg) & 0x7f
}
func (o *RTC_MODE2_Type) SetFREQCORR_SIGN(value uint8) {
	volatile.StoreUint8(&o.FREQCORR.Reg, volatile.LoadUint8(&o.FREQCORR.Reg)&^(0x80)|value<<7)
}
func (o *RTC_MODE2_Type) GetFREQCORR_SIGN() uint8 {
	return (volatile.LoadUint8(&o.FREQCORR.Reg) & 0x80) >> 7
}

// RTC_MODE2.CLOCK: MODE2 Clock Value
func (o *RTC_MODE2_Type) SetCLOCK_SECOND(value uint32) {
	volatile.StoreUint32(&o.CLOCK.Reg, volatile.LoadUint32(&o.CLOCK.Reg)&^(0x3f)|value)
}
func (o *RTC_MODE2_Type) GetCLOCK_SECOND() uint32 {
	return volatile.LoadUint32(&o.CLOCK.Reg) & 0x3f
}
func (o *RTC_MODE2_Type) SetCLOCK_MINUTE(value uint32) {
	volatile.StoreUint32(&o.CLOCK.Reg, volatile.LoadUint32(&o.CLOCK.Reg)&^(0xfc0)|value<<6)
}
func (o *RTC_MODE2_Type) GetCLOCK_MINUTE() uint32 {
	return (volatile.LoadUint32(&o.CLOCK.Reg) & 0xfc0) >> 6
}
func (o *RTC_MODE2_Type) SetCLOCK_HOUR(value uint32) {
	volatile.StoreUint32(&o.CLOCK.Reg, volatile.LoadUint32(&o.CLOCK.Reg)&^(0x1f000)|value<<12)
}
func (o *RTC_MODE2_Type) GetCLOCK_HOUR() uint32 {
	return (volatile.LoadUint32(&o.CLOCK.Reg) & 0x1f000) >> 12
}
func (o *RTC_MODE2_Type) SetCLOCK_DAY(value uint32) {
	volatile.StoreUint32(&o.CLOCK.Reg, volatile.LoadUint32(&o.CLOCK.Reg)&^(0x3e0000)|value<<17)
}
func (o *RTC_MODE2_Type) GetCLOCK_DAY() uint32 {
	return (volatile.LoadUint32(&o.CLOCK.Reg) & 0x3e0000) >> 17
}
func (o *RTC_MODE2_Type) SetCLOCK_MONTH(value uint32) {
	volatile.StoreUint32(&o.CLOCK.Reg, volatile.LoadUint32(&o.CLOCK.Reg)&^(0x3c00000)|value<<22)
}
func (o *RTC_MODE2_Type) GetCLOCK_MONTH() uint32 {
	return (volatile.LoadUint32(&o.CLOCK.Reg) & 0x3c00000) >> 22
}
func (o *RTC_MODE2_Type) SetCLOCK_YEAR(value uint32) {
	volatile.StoreUint32(&o.CLOCK.Reg, volatile.LoadUint32(&o.CLOCK.Reg)&^(0xfc000000)|value<<26)
}
func (o *RTC_MODE2_Type) GetCLOCK_YEAR() uint32 {
	return (volatile.LoadUint32(&o.CLOCK.Reg) & 0xfc000000) >> 26
}

// RTC_MODE2.ALARM0: MODE2 Alarm n Value
func (o *RTC_MODE2_Type) SetALARM0_SECOND(value uint32) {
	volatile.StoreUint32(&o.ALARM0.Reg, volatile.LoadUint32(&o.ALARM0.Reg)&^(0x3f)|value)
}
func (o *RTC_MODE2_Type) GetALARM0_SECOND() uint32 {
	return volatile.LoadUint32(&o.ALARM0.Reg) & 0x3f
}
func (o *RTC_MODE2_Type) SetALARM0_MINUTE(value uint32) {
	volatile.StoreUint32(&o.ALARM0.Reg, volatile.LoadUint32(&o.ALARM0.Reg)&^(0xfc0)|value<<6)
}
func (o *RTC_MODE2_Type) GetALARM0_MINUTE() uint32 {
	return (volatile.LoadUint32(&o.ALARM0.Reg) & 0xfc0) >> 6
}
func (o *RTC_MODE2_Type) SetALARM0_HOUR(value uint32) {
	volatile.StoreUint32(&o.ALARM0.Reg, volatile.LoadUint32(&o.ALARM0.Reg)&^(0x1f000)|value<<12)
}
func (o *RTC_MODE2_Type) GetALARM0_HOUR() uint32 {
	return (volatile.LoadUint32(&o.ALARM0.Reg) & 0x1f000) >> 12
}
func (o *RTC_MODE2_Type) SetALARM0_DAY(value uint32) {
	volatile.StoreUint32(&o.ALARM0.Reg, volatile.LoadUint32(&o.ALARM0.Reg)&^(0x3e0000)|value<<17)
}
func (o *RTC_MODE2_Type) GetALARM0_DAY() uint32 {
	return (volatile.LoadUint32(&o.ALARM0.Reg) & 0x3e0000) >> 17
}
func (o *RTC_MODE2_Type) SetALARM0_MONTH(value uint32) {
	volatile.StoreUint32(&o.ALARM0.Reg, volatile.LoadUint32(&o.ALARM0.Reg)&^(0x3c00000)|value<<22)
}
func (o *RTC_MODE2_Type) GetALARM0_MONTH() uint32 {
	return (volatile.LoadUint32(&o.ALARM0.Reg) & 0x3c00000) >> 22
}
func (o *RTC_MODE2_Type) SetALARM0_YEAR(value uint32) {
	volatile.StoreUint32(&o.ALARM0.Reg, volatile.LoadUint32(&o.ALARM0.Reg)&^(0xfc000000)|value<<26)
}
func (o *RTC_MODE2_Type) GetALARM0_YEAR() uint32 {
	return (volatile.LoadUint32(&o.ALARM0.Reg) & 0xfc000000) >> 26
}

// RTC_MODE2.MASK0: MODE2 Alarm n Mask
func (o *RTC_MODE2_Type) SetMASK0_SEL(value uint8) {
	volatile.StoreUint8(&o.MASK0.Reg, volatile.LoadUint8(&o.MASK0.Reg)&^(0x7)|value)
}
func (o *RTC_MODE2_Type) GetMASK0_SEL() uint8 {
	return volatile.LoadUint8(&o.MASK0.Reg) & 0x7
}

// RTC_MODE2.GP0: General Purpose
func (o *RTC_MODE2_Type) SetGP0(value uint32) {
	volatile.StoreUint32(&o.GP0.Reg, value)
}
func (o *RTC_MODE2_Type) GetGP0() uint32 {
	return volatile.LoadUint32(&o.GP0.Reg)
}

// RTC_MODE2.GP1: General Purpose
func (o *RTC_MODE2_Type) SetGP1(value uint32) {
	volatile.StoreUint32(&o.GP1.Reg, value)
}
func (o *RTC_MODE2_Type) GetGP1() uint32 {
	return volatile.LoadUint32(&o.GP1.Reg)
}

// RTC_MODE2.TAMPCTRL: Tamper Control
func (o *RTC_MODE2_Type) SetTAMPCTRL_IN0ACT(value uint32) {
	volatile.StoreUint32(&o.TAMPCTRL.Reg, volatile.LoadUint32(&o.TAMPCTRL.Reg)&^(0x3)|value)
}
func (o *RTC_MODE2_Type) GetTAMPCTRL_IN0ACT() uint32 {
	return volatile.LoadUint32(&o.TAMPCTRL.Reg) & 0x3
}
func (o *RTC_MODE2_Type) SetTAMPCTRL_IN1ACT(value uint32) {
	volatile.StoreUint32(&o.TAMPCTRL.Reg, volatile.LoadUint32(&o.TAMPCTRL.Reg)&^(0xc)|value<<2)
}
func (o *RTC_MODE2_Type) GetTAMPCTRL_IN1ACT() uint32 {
	return (volatile.LoadUint32(&o.TAMPCTRL.Reg) & 0xc) >> 2
}
func (o *RTC_MODE2_Type) SetTAMPCTRL_IN2ACT(value uint32) {
	volatile.StoreUint32(&o.TAMPCTRL.Reg, volatile.LoadUint32(&o.TAMPCTRL.Reg)&^(0x30)|value<<4)
}
func (o *RTC_MODE2_Type) GetTAMPCTRL_IN2ACT() uint32 {
	return (volatile.LoadUint32(&o.TAMPCTRL.Reg) & 0x30) >> 4
}
func (o *RTC_MODE2_Type) SetTAMPCTRL_IN3ACT(value uint32) {
	volatile.StoreUint32(&o.TAMPCTRL.Reg, volatile.LoadUint32(&o.TAMPCTRL.Reg)&^(0xc0)|value<<6)
}
func (o *RTC_MODE2_Type) GetTAMPCTRL_IN3ACT() uint32 {
	return (volatile.LoadUint32(&o.TAMPCTRL.Reg) & 0xc0) >> 6
}
func (o *RTC_MODE2_Type) SetTAMPCTRL_IN4ACT(value uint32) {
	volatile.StoreUint32(&o.TAMPCTRL.Reg, volatile.LoadUint32(&o.TAMPCTRL.Reg)&^(0x300)|value<<8)
}
func (o *RTC_MODE2_Type) GetTAMPCTRL_IN4ACT() uint32 {
	return (volatile.LoadUint32(&o.TAMPCTRL.Reg) & 0x300) >> 8
}
func (o *RTC_MODE2_Type) SetTAMPCTRL_TAMLVL0(value uint32) {
	volatile.StoreUint32(&o.TAMPCTRL.Reg, volatile.LoadUint32(&o.TAMPCTRL.Reg)&^(0x10000)|value<<16)
}
func (o *RTC_MODE2_Type) GetTAMPCTRL_TAMLVL0() uint32 {
	return (volatile.LoadUint32(&o.TAMPCTRL.Reg) & 0x10000) >> 16
}
func (o *RTC_MODE2_Type) SetTAMPCTRL_TAMLVL1(value uint32) {
	volatile.StoreUint32(&o.TAMPCTRL.Reg, volatile.LoadUint32(&o.TAMPCTRL.Reg)&^(0x20000)|value<<17)
}
func (o *RTC_MODE2_Type) GetTAMPCTRL_TAMLVL1() uint32 {
	return (volatile.LoadUint32(&o.TAMPCTRL.Reg) & 0x20000) >> 17
}
func (o *RTC_MODE2_Type) SetTAMPCTRL_TAMLVL2(value uint32) {
	volatile.StoreUint32(&o.TAMPCTRL.Reg, volatile.LoadUint32(&o.TAMPCTRL.Reg)&^(0x40000)|value<<18)
}
func (o *RTC_MODE2_Type) GetTAMPCTRL_TAMLVL2() uint32 {
	return (volatile.LoadUint32(&o.TAMPCTRL.Reg) & 0x40000) >> 18
}
func (o *RTC_MODE2_Type) SetTAMPCTRL_TAMLVL3(value uint32) {
	volatile.StoreUint32(&o.TAMPCTRL.Reg, volatile.LoadUint32(&o.TAMPCTRL.Reg)&^(0x80000)|value<<19)
}
func (o *RTC_MODE2_Type) GetTAMPCTRL_TAMLVL3() uint32 {
	return (volatile.LoadUint32(&o.TAMPCTRL.Reg) & 0x80000) >> 19
}
func (o *RTC_MODE2_Type) SetTAMPCTRL_TAMLVL4(value uint32) {
	volatile.StoreUint32(&o.TAMPCTRL.Reg, volatile.LoadUint32(&o.TAMPCTRL.Reg)&^(0x100000)|value<<20)
}
func (o *RTC_MODE2_Type) GetTAMPCTRL_TAMLVL4() uint32 {
	return (volatile.LoadUint32(&o.TAMPCTRL.Reg) & 0x100000) >> 20
}
func (o *RTC_MODE2_Type) SetTAMPCTRL_DEBNC0(value uint32) {
	volatile.StoreUint32(&o.TAMPCTRL.Reg, volatile.LoadUint32(&o.TAMPCTRL.Reg)&^(0x1000000)|value<<24)
}
func (o *RTC_MODE2_Type) GetTAMPCTRL_DEBNC0() uint32 {
	return (volatile.LoadUint32(&o.TAMPCTRL.Reg) & 0x1000000) >> 24
}
func (o *RTC_MODE2_Type) SetTAMPCTRL_DEBNC1(value uint32) {
	volatile.StoreUint32(&o.TAMPCTRL.Reg, volatile.LoadUint32(&o.TAMPCTRL.Reg)&^(0x2000000)|value<<25)
}
func (o *RTC_MODE2_Type) GetTAMPCTRL_DEBNC1() uint32 {
	return (volatile.LoadUint32(&o.TAMPCTRL.Reg) & 0x2000000) >> 25
}
func (o *RTC_MODE2_Type) SetTAMPCTRL_DEBNC2(value uint32) {
	volatile.StoreUint32(&o.TAMPCTRL.Reg, volatile.LoadUint32(&o.TAMPCTRL.Reg)&^(0x4000000)|value<<26)
}
func (o *RTC_MODE2_Type) GetTAMPCTRL_DEBNC2() uint32 {
	return (volatile.LoadUint32(&o.TAMPCTRL.Reg) & 0x4000000) >> 26
}
func (o *RTC_MODE2_Type) SetTAMPCTRL_DEBNC3(value uint32) {
	volatile.StoreUint32(&o.TAMPCTRL.Reg, volatile.LoadUint32(&o.TAMPCTRL.Reg)&^(0x8000000)|value<<27)
}
func (o *RTC_MODE2_Type) GetTAMPCTRL_DEBNC3() uint32 {
	return (volatile.LoadUint32(&o.TAMPCTRL.Reg) & 0x8000000) >> 27
}
func (o *RTC_MODE2_Type) SetTAMPCTRL_DEBNC4(value uint32) {
	volatile.StoreUint32(&o.TAMPCTRL.Reg, volatile.LoadUint32(&o.TAMPCTRL.Reg)&^(0x10000000)|value<<28)
}
func (o *RTC_MODE2_Type) GetTAMPCTRL_DEBNC4() uint32 {
	return (volatile.LoadUint32(&o.TAMPCTRL.Reg) & 0x10000000) >> 28
}

// RTC_MODE2.TIMESTAMP: MODE2 Timestamp
func (o *RTC_MODE2_Type) SetTIMESTAMP_SECOND(value uint32) {
	volatile.StoreUint32(&o.TIMESTAMP.Reg, volatile.LoadUint32(&o.TIMESTAMP.Reg)&^(0x3f)|value)
}
func (o *RTC_MODE2_Type) GetTIMESTAMP_SECOND() uint32 {
	return volatile.LoadUint32(&o.TIMESTAMP.Reg) & 0x3f
}
func (o *RTC_MODE2_Type) SetTIMESTAMP_MINUTE(value uint32) {
	volatile.StoreUint32(&o.TIMESTAMP.Reg, volatile.LoadUint32(&o.TIMESTAMP.Reg)&^(0xfc0)|value<<6)
}
func (o *RTC_MODE2_Type) GetTIMESTAMP_MINUTE() uint32 {
	return (volatile.LoadUint32(&o.TIMESTAMP.Reg) & 0xfc0) >> 6
}
func (o *RTC_MODE2_Type) SetTIMESTAMP_HOUR(value uint32) {
	volatile.StoreUint32(&o.TIMESTAMP.Reg, volatile.LoadUint32(&o.TIMESTAMP.Reg)&^(0x1f000)|value<<12)
}
func (o *RTC_MODE2_Type) GetTIMESTAMP_HOUR() uint32 {
	return (volatile.LoadUint32(&o.TIMESTAMP.Reg) & 0x1f000) >> 12
}
func (o *RTC_MODE2_Type) SetTIMESTAMP_DAY(value uint32) {
	volatile.StoreUint32(&o.TIMESTAMP.Reg, volatile.LoadUint32(&o.TIMESTAMP.Reg)&^(0x3e0000)|value<<17)
}
func (o *RTC_MODE2_Type) GetTIMESTAMP_DAY() uint32 {
	return (volatile.LoadUint32(&o.TIMESTAMP.Reg) & 0x3e0000) >> 17
}
func (o *RTC_MODE2_Type) SetTIMESTAMP_MONTH(value uint32) {
	volatile.StoreUint32(&o.TIMESTAMP.Reg, volatile.LoadUint32(&o.TIMESTAMP.Reg)&^(0x3c00000)|value<<22)
}
func (o *RTC_MODE2_Type) GetTIMESTAMP_MONTH() uint32 {
	return (volatile.LoadUint32(&o.TIMESTAMP.Reg) & 0x3c00000) >> 22
}
func (o *RTC_MODE2_Type) SetTIMESTAMP_YEAR(value uint32) {
	volatile.StoreUint32(&o.TIMESTAMP.Reg, volatile.LoadUint32(&o.TIMESTAMP.Reg)&^(0xfc000000)|value<<26)
}
func (o *RTC_MODE2_Type) GetTIMESTAMP_YEAR() uint32 {
	return (volatile.LoadUint32(&o.TIMESTAMP.Reg) & 0xfc000000) >> 26
}

// RTC_MODE2.TAMPID: Tamper ID
func (o *RTC_MODE2_Type) SetTAMPID_TAMPID0(value uint32) {
	volatile.StoreUint32(&o.TAMPID.Reg, volatile.LoadUint32(&o.TAMPID.Reg)&^(0x1)|value)
}
func (o *RTC_MODE2_Type) GetTAMPID_TAMPID0() uint32 {
	return volatile.LoadUint32(&o.TAMPID.Reg) & 0x1
}
func (o *RTC_MODE2_Type) SetTAMPID_TAMPID1(value uint32) {
	volatile.StoreUint32(&o.TAMPID.Reg, volatile.LoadUint32(&o.TAMPID.Reg)&^(0x2)|value<<1)
}
func (o *RTC_MODE2_Type) GetTAMPID_TAMPID1() uint32 {
	return (volatile.LoadUint32(&o.TAMPID.Reg) & 0x2) >> 1
}
func (o *RTC_MODE2_Type) SetTAMPID_TAMPID2(value uint32) {
	volatile.StoreUint32(&o.TAMPID.Reg, volatile.LoadUint32(&o.TAMPID.Reg)&^(0x4)|value<<2)
}
func (o *RTC_MODE2_Type) GetTAMPID_TAMPID2() uint32 {
	return (volatile.LoadUint32(&o.TAMPID.Reg) & 0x4) >> 2
}
func (o *RTC_MODE2_Type) SetTAMPID_TAMPID3(value uint32) {
	volatile.StoreUint32(&o.TAMPID.Reg, volatile.LoadUint32(&o.TAMPID.Reg)&^(0x8)|value<<3)
}
func (o *RTC_MODE2_Type) GetTAMPID_TAMPID3() uint32 {
	return (volatile.LoadUint32(&o.TAMPID.Reg) & 0x8) >> 3
}
func (o *RTC_MODE2_Type) SetTAMPID_TAMPID4(value uint32) {
	volatile.StoreUint32(&o.TAMPID.Reg, volatile.LoadUint32(&o.TAMPID.Reg)&^(0x10)|value<<4)
}
func (o *RTC_MODE2_Type) GetTAMPID_TAMPID4() uint32 {
	return (volatile.LoadUint32(&o.TAMPID.Reg) & 0x10) >> 4
}
func (o *RTC_MODE2_Type) SetTAMPID_TAMPEVT(value uint32) {
	volatile.StoreUint32(&o.TAMPID.Reg, volatile.LoadUint32(&o.TAMPID.Reg)&^(0x80000000)|value<<31)
}
func (o *RTC_MODE2_Type) GetTAMPID_TAMPEVT() uint32 {
	return (volatile.LoadUint32(&o.TAMPID.Reg) & 0x80000000) >> 31
}

// RTC_MODE2.BKUP0: Backup
func (o *RTC_MODE2_Type) SetBKUP0(value uint32) {
	volatile.StoreUint32(&o.BKUP0.Reg, value)
}
func (o *RTC_MODE2_Type) GetBKUP0() uint32 {
	return volatile.LoadUint32(&o.BKUP0.Reg)
}

// RTC_MODE2.BKUP1: Backup
func (o *RTC_MODE2_Type) SetBKUP1(value uint32) {
	volatile.StoreUint32(&o.BKUP1.Reg, value)
}
func (o *RTC_MODE2_Type) GetBKUP1() uint32 {
	return volatile.LoadUint32(&o.BKUP1.Reg)
}

// RTC_MODE2.BKUP2: Backup
func (o *RTC_MODE2_Type) SetBKUP2(value uint32) {
	volatile.StoreUint32(&o.BKUP2.Reg, value)
}
func (o *RTC_MODE2_Type) GetBKUP2() uint32 {
	return volatile.LoadUint32(&o.BKUP2.Reg)
}

// RTC_MODE2.BKUP3: Backup
func (o *RTC_MODE2_Type) SetBKUP3(value uint32) {
	volatile.StoreUint32(&o.BKUP3.Reg, value)
}
func (o *RTC_MODE2_Type) GetBKUP3() uint32 {
	return volatile.LoadUint32(&o.BKUP3.Reg)
}

// RTC_MODE2.BKUP4: Backup
func (o *RTC_MODE2_Type) SetBKUP4(value uint32) {
	volatile.StoreUint32(&o.BKUP4.Reg, value)
}
func (o *RTC_MODE2_Type) GetBKUP4() uint32 {
	return volatile.LoadUint32(&o.BKUP4.Reg)
}

// RTC_MODE2.BKUP5: Backup
func (o *RTC_MODE2_Type) SetBKUP5(value uint32) {
	volatile.StoreUint32(&o.BKUP5.Reg, value)
}
func (o *RTC_MODE2_Type) GetBKUP5() uint32 {
	return volatile.LoadUint32(&o.BKUP5.Reg)
}

// RTC_MODE2.BKUP6: Backup
func (o *RTC_MODE2_Type) SetBKUP6(value uint32) {
	volatile.StoreUint32(&o.BKUP6.Reg, value)
}
func (o *RTC_MODE2_Type) GetBKUP6() uint32 {
	return volatile.LoadUint32(&o.BKUP6.Reg)
}

// RTC_MODE2.BKUP7: Backup
func (o *RTC_MODE2_Type) SetBKUP7(value uint32) {
	volatile.StoreUint32(&o.BKUP7.Reg, value)
}
func (o *RTC_MODE2_Type) GetBKUP7() uint32 {
	return volatile.LoadUint32(&o.BKUP7.Reg)
}

// Serial Communication Interface 0
type SERCOM_Type struct {
}

// Serial Communication Interface 0 - I2CM
type SERCOM_I2CM_Type struct {
	CTRLA    volatile.Register32 // 0x0
	CTRLB    volatile.Register32 // 0x4
	_        [4]byte
	BAUD     volatile.Register32 // 0xC
	_        [4]byte
	INTENCLR volatile.Register8 // 0x14
	_        byte
	INTENSET volatile.Register8 // 0x16
	_        byte
	INTFLAG  volatile.Register8 // 0x18
	_        byte
	STATUS   volatile.Register16 // 0x1A
	SYNCBUSY volatile.Register32 // 0x1C
	_        [4]byte
	ADDR     volatile.Register32 // 0x24
	DATA     volatile.Register8  // 0x28
	_        [7]byte
	DBGCTRL  volatile.Register8 // 0x30
}

// SERCOM_I2CM.CTRLA: I2CM Control A
func (o *SERCOM_I2CM_Type) SetCTRLA_SWRST(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x1)|value)
}
func (o *SERCOM_I2CM_Type) GetCTRLA_SWRST() uint32 {
	return volatile.LoadUint32(&o.CTRLA.Reg) & 0x1
}
func (o *SERCOM_I2CM_Type) SetCTRLA_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x2)|value<<1)
}
func (o *SERCOM_I2CM_Type) GetCTRLA_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x2) >> 1
}
func (o *SERCOM_I2CM_Type) SetCTRLA_MODE(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x1c)|value<<2)
}
func (o *SERCOM_I2CM_Type) GetCTRLA_MODE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x1c) >> 2
}
func (o *SERCOM_I2CM_Type) SetCTRLA_RUNSTDBY(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x80)|value<<7)
}
func (o *SERCOM_I2CM_Type) GetCTRLA_RUNSTDBY() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x80) >> 7
}
func (o *SERCOM_I2CM_Type) SetCTRLA_PINOUT(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x10000)|value<<16)
}
func (o *SERCOM_I2CM_Type) GetCTRLA_PINOUT() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x10000) >> 16
}
func (o *SERCOM_I2CM_Type) SetCTRLA_SDAHOLD(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x300000)|value<<20)
}
func (o *SERCOM_I2CM_Type) GetCTRLA_SDAHOLD() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x300000) >> 20
}
func (o *SERCOM_I2CM_Type) SetCTRLA_MEXTTOEN(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x400000)|value<<22)
}
func (o *SERCOM_I2CM_Type) GetCTRLA_MEXTTOEN() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x400000) >> 22
}
func (o *SERCOM_I2CM_Type) SetCTRLA_SEXTTOEN(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x800000)|value<<23)
}
func (o *SERCOM_I2CM_Type) GetCTRLA_SEXTTOEN() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x800000) >> 23
}
func (o *SERCOM_I2CM_Type) SetCTRLA_SPEED(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x3000000)|value<<24)
}
func (o *SERCOM_I2CM_Type) GetCTRLA_SPEED() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x3000000) >> 24
}
func (o *SERCOM_I2CM_Type) SetCTRLA_SCLSM(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x8000000)|value<<27)
}
func (o *SERCOM_I2CM_Type) GetCTRLA_SCLSM() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x8000000) >> 27
}
func (o *SERCOM_I2CM_Type) SetCTRLA_INACTOUT(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x30000000)|value<<28)
}
func (o *SERCOM_I2CM_Type) GetCTRLA_INACTOUT() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x30000000) >> 28
}
func (o *SERCOM_I2CM_Type) SetCTRLA_LOWTOUTEN(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x40000000)|value<<30)
}
func (o *SERCOM_I2CM_Type) GetCTRLA_LOWTOUTEN() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x40000000) >> 30
}

// SERCOM_I2CM.CTRLB: I2CM Control B
func (o *SERCOM_I2CM_Type) SetCTRLB_SMEN(value uint32) {
	volatile.StoreUint32(&o.CTRLB.Reg, volatile.LoadUint32(&o.CTRLB.Reg)&^(0x100)|value<<8)
}
func (o *SERCOM_I2CM_Type) GetCTRLB_SMEN() uint32 {
	return (volatile.LoadUint32(&o.CTRLB.Reg) & 0x100) >> 8
}
func (o *SERCOM_I2CM_Type) SetCTRLB_QCEN(value uint32) {
	volatile.StoreUint32(&o.CTRLB.Reg, volatile.LoadUint32(&o.CTRLB.Reg)&^(0x200)|value<<9)
}
func (o *SERCOM_I2CM_Type) GetCTRLB_QCEN() uint32 {
	return (volatile.LoadUint32(&o.CTRLB.Reg) & 0x200) >> 9
}
func (o *SERCOM_I2CM_Type) SetCTRLB_CMD(value uint32) {
	volatile.StoreUint32(&o.CTRLB.Reg, volatile.LoadUint32(&o.CTRLB.Reg)&^(0x30000)|value<<16)
}
func (o *SERCOM_I2CM_Type) GetCTRLB_CMD() uint32 {
	return (volatile.LoadUint32(&o.CTRLB.Reg) & 0x30000) >> 16
}
func (o *SERCOM_I2CM_Type) SetCTRLB_ACKACT(value uint32) {
	volatile.StoreUint32(&o.CTRLB.Reg, volatile.LoadUint32(&o.CTRLB.Reg)&^(0x40000)|value<<18)
}
func (o *SERCOM_I2CM_Type) GetCTRLB_ACKACT() uint32 {
	return (volatile.LoadUint32(&o.CTRLB.Reg) & 0x40000) >> 18
}

// SERCOM_I2CM.BAUD: I2CM Baud Rate
func (o *SERCOM_I2CM_Type) SetBAUD(value uint32) {
	volatile.StoreUint32(&o.BAUD.Reg, volatile.LoadUint32(&o.BAUD.Reg)&^(0xff)|value)
}
func (o *SERCOM_I2CM_Type) GetBAUD() uint32 {
	return volatile.LoadUint32(&o.BAUD.Reg) & 0xff
}
func (o *SERCOM_I2CM_Type) SetBAUD_BAUDLOW(value uint32) {
	volatile.StoreUint32(&o.BAUD.Reg, volatile.LoadUint32(&o.BAUD.Reg)&^(0xff00)|value<<8)
}
func (o *SERCOM_I2CM_Type) GetBAUD_BAUDLOW() uint32 {
	return (volatile.LoadUint32(&o.BAUD.Reg) & 0xff00) >> 8
}
func (o *SERCOM_I2CM_Type) SetBAUD_HSBAUD(value uint32) {
	volatile.StoreUint32(&o.BAUD.Reg, volatile.LoadUint32(&o.BAUD.Reg)&^(0xff0000)|value<<16)
}
func (o *SERCOM_I2CM_Type) GetBAUD_HSBAUD() uint32 {
	return (volatile.LoadUint32(&o.BAUD.Reg) & 0xff0000) >> 16
}
func (o *SERCOM_I2CM_Type) SetBAUD_HSBAUDLOW(value uint32) {
	volatile.StoreUint32(&o.BAUD.Reg, volatile.LoadUint32(&o.BAUD.Reg)&^(0xff000000)|value<<24)
}
func (o *SERCOM_I2CM_Type) GetBAUD_HSBAUDLOW() uint32 {
	return (volatile.LoadUint32(&o.BAUD.Reg) & 0xff000000) >> 24
}

// SERCOM_I2CM.INTENCLR: I2CM Interrupt Enable Clear
func (o *SERCOM_I2CM_Type) SetINTENCLR_MB(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *SERCOM_I2CM_Type) GetINTENCLR_MB() uint8 {
	return volatile.LoadUint8(&o.INTENCLR.Reg) & 0x1
}
func (o *SERCOM_I2CM_Type) SetINTENCLR_SB(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *SERCOM_I2CM_Type) GetINTENCLR_SB() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *SERCOM_I2CM_Type) SetINTENCLR_ERROR(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x80)|value<<7)
}
func (o *SERCOM_I2CM_Type) GetINTENCLR_ERROR() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x80) >> 7
}

// SERCOM_I2CM.INTENSET: I2CM Interrupt Enable Set
func (o *SERCOM_I2CM_Type) SetINTENSET_MB(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *SERCOM_I2CM_Type) GetINTENSET_MB() uint8 {
	return volatile.LoadUint8(&o.INTENSET.Reg) & 0x1
}
func (o *SERCOM_I2CM_Type) SetINTENSET_SB(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *SERCOM_I2CM_Type) GetINTENSET_SB() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *SERCOM_I2CM_Type) SetINTENSET_ERROR(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x80)|value<<7)
}
func (o *SERCOM_I2CM_Type) GetINTENSET_ERROR() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x80) >> 7
}

// SERCOM_I2CM.INTFLAG: I2CM Interrupt Flag Status and Clear
func (o *SERCOM_I2CM_Type) SetINTFLAG_MB(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x1)|value)
}
func (o *SERCOM_I2CM_Type) GetINTFLAG_MB() uint8 {
	return volatile.LoadUint8(&o.INTFLAG.Reg) & 0x1
}
func (o *SERCOM_I2CM_Type) SetINTFLAG_SB(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x2)|value<<1)
}
func (o *SERCOM_I2CM_Type) GetINTFLAG_SB() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x2) >> 1
}
func (o *SERCOM_I2CM_Type) SetINTFLAG_ERROR(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x80)|value<<7)
}
func (o *SERCOM_I2CM_Type) GetINTFLAG_ERROR() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x80) >> 7
}

// SERCOM_I2CM.STATUS: I2CM Status
func (o *SERCOM_I2CM_Type) SetSTATUS_BUSERR(value uint16) {
	volatile.StoreUint16(&o.STATUS.Reg, volatile.LoadUint16(&o.STATUS.Reg)&^(0x1)|value)
}
func (o *SERCOM_I2CM_Type) GetSTATUS_BUSERR() uint16 {
	return volatile.LoadUint16(&o.STATUS.Reg) & 0x1
}
func (o *SERCOM_I2CM_Type) SetSTATUS_ARBLOST(value uint16) {
	volatile.StoreUint16(&o.STATUS.Reg, volatile.LoadUint16(&o.STATUS.Reg)&^(0x2)|value<<1)
}
func (o *SERCOM_I2CM_Type) GetSTATUS_ARBLOST() uint16 {
	return (volatile.LoadUint16(&o.STATUS.Reg) & 0x2) >> 1
}
func (o *SERCOM_I2CM_Type) SetSTATUS_RXNACK(value uint16) {
	volatile.StoreUint16(&o.STATUS.Reg, volatile.LoadUint16(&o.STATUS.Reg)&^(0x4)|value<<2)
}
func (o *SERCOM_I2CM_Type) GetSTATUS_RXNACK() uint16 {
	return (volatile.LoadUint16(&o.STATUS.Reg) & 0x4) >> 2
}
func (o *SERCOM_I2CM_Type) SetSTATUS_BUSSTATE(value uint16) {
	volatile.StoreUint16(&o.STATUS.Reg, volatile.LoadUint16(&o.STATUS.Reg)&^(0x30)|value<<4)
}
func (o *SERCOM_I2CM_Type) GetSTATUS_BUSSTATE() uint16 {
	return (volatile.LoadUint16(&o.STATUS.Reg) & 0x30) >> 4
}
func (o *SERCOM_I2CM_Type) SetSTATUS_LOWTOUT(value uint16) {
	volatile.StoreUint16(&o.STATUS.Reg, volatile.LoadUint16(&o.STATUS.Reg)&^(0x40)|value<<6)
}
func (o *SERCOM_I2CM_Type) GetSTATUS_LOWTOUT() uint16 {
	return (volatile.LoadUint16(&o.STATUS.Reg) & 0x40) >> 6
}
func (o *SERCOM_I2CM_Type) SetSTATUS_CLKHOLD(value uint16) {
	volatile.StoreUint16(&o.STATUS.Reg, volatile.LoadUint16(&o.STATUS.Reg)&^(0x80)|value<<7)
}
func (o *SERCOM_I2CM_Type) GetSTATUS_CLKHOLD() uint16 {
	return (volatile.LoadUint16(&o.STATUS.Reg) & 0x80) >> 7
}
func (o *SERCOM_I2CM_Type) SetSTATUS_MEXTTOUT(value uint16) {
	volatile.StoreUint16(&o.STATUS.Reg, volatile.LoadUint16(&o.STATUS.Reg)&^(0x100)|value<<8)
}
func (o *SERCOM_I2CM_Type) GetSTATUS_MEXTTOUT() uint16 {
	return (volatile.LoadUint16(&o.STATUS.Reg) & 0x100) >> 8
}
func (o *SERCOM_I2CM_Type) SetSTATUS_SEXTTOUT(value uint16) {
	volatile.StoreUint16(&o.STATUS.Reg, volatile.LoadUint16(&o.STATUS.Reg)&^(0x200)|value<<9)
}
func (o *SERCOM_I2CM_Type) GetSTATUS_SEXTTOUT() uint16 {
	return (volatile.LoadUint16(&o.STATUS.Reg) & 0x200) >> 9
}
func (o *SERCOM_I2CM_Type) SetSTATUS_LENERR(value uint16) {
	volatile.StoreUint16(&o.STATUS.Reg, volatile.LoadUint16(&o.STATUS.Reg)&^(0x400)|value<<10)
}
func (o *SERCOM_I2CM_Type) GetSTATUS_LENERR() uint16 {
	return (volatile.LoadUint16(&o.STATUS.Reg) & 0x400) >> 10
}

// SERCOM_I2CM.SYNCBUSY: I2CM Synchronization Busy
func (o *SERCOM_I2CM_Type) SetSYNCBUSY_SWRST(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x1)|value)
}
func (o *SERCOM_I2CM_Type) GetSYNCBUSY_SWRST() uint32 {
	return volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x1
}
func (o *SERCOM_I2CM_Type) SetSYNCBUSY_ENABLE(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x2)|value<<1)
}
func (o *SERCOM_I2CM_Type) GetSYNCBUSY_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x2) >> 1
}
func (o *SERCOM_I2CM_Type) SetSYNCBUSY_SYSOP(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x4)|value<<2)
}
func (o *SERCOM_I2CM_Type) GetSYNCBUSY_SYSOP() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x4) >> 2
}

// SERCOM_I2CM.ADDR: I2CM Address
func (o *SERCOM_I2CM_Type) SetADDR(value uint32) {
	volatile.StoreUint32(&o.ADDR.Reg, volatile.LoadUint32(&o.ADDR.Reg)&^(0x7ff)|value)
}
func (o *SERCOM_I2CM_Type) GetADDR() uint32 {
	return volatile.LoadUint32(&o.ADDR.Reg) & 0x7ff
}
func (o *SERCOM_I2CM_Type) SetADDR_LENEN(value uint32) {
	volatile.StoreUint32(&o.ADDR.Reg, volatile.LoadUint32(&o.ADDR.Reg)&^(0x2000)|value<<13)
}
func (o *SERCOM_I2CM_Type) GetADDR_LENEN() uint32 {
	return (volatile.LoadUint32(&o.ADDR.Reg) & 0x2000) >> 13
}
func (o *SERCOM_I2CM_Type) SetADDR_HS(value uint32) {
	volatile.StoreUint32(&o.ADDR.Reg, volatile.LoadUint32(&o.ADDR.Reg)&^(0x4000)|value<<14)
}
func (o *SERCOM_I2CM_Type) GetADDR_HS() uint32 {
	return (volatile.LoadUint32(&o.ADDR.Reg) & 0x4000) >> 14
}
func (o *SERCOM_I2CM_Type) SetADDR_TENBITEN(value uint32) {
	volatile.StoreUint32(&o.ADDR.Reg, volatile.LoadUint32(&o.ADDR.Reg)&^(0x8000)|value<<15)
}
func (o *SERCOM_I2CM_Type) GetADDR_TENBITEN() uint32 {
	return (volatile.LoadUint32(&o.ADDR.Reg) & 0x8000) >> 15
}
func (o *SERCOM_I2CM_Type) SetADDR_LEN(value uint32) {
	volatile.StoreUint32(&o.ADDR.Reg, volatile.LoadUint32(&o.ADDR.Reg)&^(0xff0000)|value<<16)
}
func (o *SERCOM_I2CM_Type) GetADDR_LEN() uint32 {
	return (volatile.LoadUint32(&o.ADDR.Reg) & 0xff0000) >> 16
}

// SERCOM_I2CM.DATA: I2CM Data
func (o *SERCOM_I2CM_Type) SetDATA(value uint8) {
	volatile.StoreUint8(&o.DATA.Reg, value)
}
func (o *SERCOM_I2CM_Type) GetDATA() uint8 {
	return volatile.LoadUint8(&o.DATA.Reg)
}

// SERCOM_I2CM.DBGCTRL: I2CM Debug Control
func (o *SERCOM_I2CM_Type) SetDBGCTRL_DBGSTOP(value uint8) {
	volatile.StoreUint8(&o.DBGCTRL.Reg, volatile.LoadUint8(&o.DBGCTRL.Reg)&^(0x1)|value)
}
func (o *SERCOM_I2CM_Type) GetDBGCTRL_DBGSTOP() uint8 {
	return volatile.LoadUint8(&o.DBGCTRL.Reg) & 0x1
}

// Serial Communication Interface 0 - I2CS
type SERCOM_I2CS_Type struct {
	CTRLA    volatile.Register32 // 0x0
	CTRLB    volatile.Register32 // 0x4
	_        [12]byte
	INTENCLR volatile.Register8 // 0x14
	_        byte
	INTENSET volatile.Register8 // 0x16
	_        byte
	INTFLAG  volatile.Register8 // 0x18
	_        byte
	STATUS   volatile.Register16 // 0x1A
	SYNCBUSY volatile.Register32 // 0x1C
	_        [4]byte
	ADDR     volatile.Register32 // 0x24
	DATA     volatile.Register8  // 0x28
}

// SERCOM_I2CS.CTRLA: I2CS Control A
func (o *SERCOM_I2CS_Type) SetCTRLA_SWRST(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x1)|value)
}
func (o *SERCOM_I2CS_Type) GetCTRLA_SWRST() uint32 {
	return volatile.LoadUint32(&o.CTRLA.Reg) & 0x1
}
func (o *SERCOM_I2CS_Type) SetCTRLA_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x2)|value<<1)
}
func (o *SERCOM_I2CS_Type) GetCTRLA_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x2) >> 1
}
func (o *SERCOM_I2CS_Type) SetCTRLA_MODE(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x1c)|value<<2)
}
func (o *SERCOM_I2CS_Type) GetCTRLA_MODE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x1c) >> 2
}
func (o *SERCOM_I2CS_Type) SetCTRLA_RUNSTDBY(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x80)|value<<7)
}
func (o *SERCOM_I2CS_Type) GetCTRLA_RUNSTDBY() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x80) >> 7
}
func (o *SERCOM_I2CS_Type) SetCTRLA_PINOUT(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x10000)|value<<16)
}
func (o *SERCOM_I2CS_Type) GetCTRLA_PINOUT() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x10000) >> 16
}
func (o *SERCOM_I2CS_Type) SetCTRLA_SDAHOLD(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x300000)|value<<20)
}
func (o *SERCOM_I2CS_Type) GetCTRLA_SDAHOLD() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x300000) >> 20
}
func (o *SERCOM_I2CS_Type) SetCTRLA_SEXTTOEN(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x800000)|value<<23)
}
func (o *SERCOM_I2CS_Type) GetCTRLA_SEXTTOEN() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x800000) >> 23
}
func (o *SERCOM_I2CS_Type) SetCTRLA_SPEED(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x3000000)|value<<24)
}
func (o *SERCOM_I2CS_Type) GetCTRLA_SPEED() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x3000000) >> 24
}
func (o *SERCOM_I2CS_Type) SetCTRLA_SCLSM(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x8000000)|value<<27)
}
func (o *SERCOM_I2CS_Type) GetCTRLA_SCLSM() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x8000000) >> 27
}
func (o *SERCOM_I2CS_Type) SetCTRLA_LOWTOUTEN(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x40000000)|value<<30)
}
func (o *SERCOM_I2CS_Type) GetCTRLA_LOWTOUTEN() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x40000000) >> 30
}

// SERCOM_I2CS.CTRLB: I2CS Control B
func (o *SERCOM_I2CS_Type) SetCTRLB_SMEN(value uint32) {
	volatile.StoreUint32(&o.CTRLB.Reg, volatile.LoadUint32(&o.CTRLB.Reg)&^(0x100)|value<<8)
}
func (o *SERCOM_I2CS_Type) GetCTRLB_SMEN() uint32 {
	return (volatile.LoadUint32(&o.CTRLB.Reg) & 0x100) >> 8
}
func (o *SERCOM_I2CS_Type) SetCTRLB_GCMD(value uint32) {
	volatile.StoreUint32(&o.CTRLB.Reg, volatile.LoadUint32(&o.CTRLB.Reg)&^(0x200)|value<<9)
}
func (o *SERCOM_I2CS_Type) GetCTRLB_GCMD() uint32 {
	return (volatile.LoadUint32(&o.CTRLB.Reg) & 0x200) >> 9
}
func (o *SERCOM_I2CS_Type) SetCTRLB_AACKEN(value uint32) {
	volatile.StoreUint32(&o.CTRLB.Reg, volatile.LoadUint32(&o.CTRLB.Reg)&^(0x400)|value<<10)
}
func (o *SERCOM_I2CS_Type) GetCTRLB_AACKEN() uint32 {
	return (volatile.LoadUint32(&o.CTRLB.Reg) & 0x400) >> 10
}
func (o *SERCOM_I2CS_Type) SetCTRLB_AMODE(value uint32) {
	volatile.StoreUint32(&o.CTRLB.Reg, volatile.LoadUint32(&o.CTRLB.Reg)&^(0xc000)|value<<14)
}
func (o *SERCOM_I2CS_Type) GetCTRLB_AMODE() uint32 {
	return (volatile.LoadUint32(&o.CTRLB.Reg) & 0xc000) >> 14
}
func (o *SERCOM_I2CS_Type) SetCTRLB_CMD(value uint32) {
	volatile.StoreUint32(&o.CTRLB.Reg, volatile.LoadUint32(&o.CTRLB.Reg)&^(0x30000)|value<<16)
}
func (o *SERCOM_I2CS_Type) GetCTRLB_CMD() uint32 {
	return (volatile.LoadUint32(&o.CTRLB.Reg) & 0x30000) >> 16
}
func (o *SERCOM_I2CS_Type) SetCTRLB_ACKACT(value uint32) {
	volatile.StoreUint32(&o.CTRLB.Reg, volatile.LoadUint32(&o.CTRLB.Reg)&^(0x40000)|value<<18)
}
func (o *SERCOM_I2CS_Type) GetCTRLB_ACKACT() uint32 {
	return (volatile.LoadUint32(&o.CTRLB.Reg) & 0x40000) >> 18
}

// SERCOM_I2CS.INTENCLR: I2CS Interrupt Enable Clear
func (o *SERCOM_I2CS_Type) SetINTENCLR_PREC(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *SERCOM_I2CS_Type) GetINTENCLR_PREC() uint8 {
	return volatile.LoadUint8(&o.INTENCLR.Reg) & 0x1
}
func (o *SERCOM_I2CS_Type) SetINTENCLR_AMATCH(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *SERCOM_I2CS_Type) GetINTENCLR_AMATCH() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *SERCOM_I2CS_Type) SetINTENCLR_DRDY(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x4)|value<<2)
}
func (o *SERCOM_I2CS_Type) GetINTENCLR_DRDY() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x4) >> 2
}
func (o *SERCOM_I2CS_Type) SetINTENCLR_ERROR(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x80)|value<<7)
}
func (o *SERCOM_I2CS_Type) GetINTENCLR_ERROR() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x80) >> 7
}

// SERCOM_I2CS.INTENSET: I2CS Interrupt Enable Set
func (o *SERCOM_I2CS_Type) SetINTENSET_PREC(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *SERCOM_I2CS_Type) GetINTENSET_PREC() uint8 {
	return volatile.LoadUint8(&o.INTENSET.Reg) & 0x1
}
func (o *SERCOM_I2CS_Type) SetINTENSET_AMATCH(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *SERCOM_I2CS_Type) GetINTENSET_AMATCH() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *SERCOM_I2CS_Type) SetINTENSET_DRDY(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x4)|value<<2)
}
func (o *SERCOM_I2CS_Type) GetINTENSET_DRDY() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x4) >> 2
}
func (o *SERCOM_I2CS_Type) SetINTENSET_ERROR(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x80)|value<<7)
}
func (o *SERCOM_I2CS_Type) GetINTENSET_ERROR() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x80) >> 7
}

// SERCOM_I2CS.INTFLAG: I2CS Interrupt Flag Status and Clear
func (o *SERCOM_I2CS_Type) SetINTFLAG_PREC(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x1)|value)
}
func (o *SERCOM_I2CS_Type) GetINTFLAG_PREC() uint8 {
	return volatile.LoadUint8(&o.INTFLAG.Reg) & 0x1
}
func (o *SERCOM_I2CS_Type) SetINTFLAG_AMATCH(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x2)|value<<1)
}
func (o *SERCOM_I2CS_Type) GetINTFLAG_AMATCH() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x2) >> 1
}
func (o *SERCOM_I2CS_Type) SetINTFLAG_DRDY(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x4)|value<<2)
}
func (o *SERCOM_I2CS_Type) GetINTFLAG_DRDY() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x4) >> 2
}
func (o *SERCOM_I2CS_Type) SetINTFLAG_ERROR(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x80)|value<<7)
}
func (o *SERCOM_I2CS_Type) GetINTFLAG_ERROR() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x80) >> 7
}

// SERCOM_I2CS.STATUS: I2CS Status
func (o *SERCOM_I2CS_Type) SetSTATUS_BUSERR(value uint16) {
	volatile.StoreUint16(&o.STATUS.Reg, volatile.LoadUint16(&o.STATUS.Reg)&^(0x1)|value)
}
func (o *SERCOM_I2CS_Type) GetSTATUS_BUSERR() uint16 {
	return volatile.LoadUint16(&o.STATUS.Reg) & 0x1
}
func (o *SERCOM_I2CS_Type) SetSTATUS_COLL(value uint16) {
	volatile.StoreUint16(&o.STATUS.Reg, volatile.LoadUint16(&o.STATUS.Reg)&^(0x2)|value<<1)
}
func (o *SERCOM_I2CS_Type) GetSTATUS_COLL() uint16 {
	return (volatile.LoadUint16(&o.STATUS.Reg) & 0x2) >> 1
}
func (o *SERCOM_I2CS_Type) SetSTATUS_RXNACK(value uint16) {
	volatile.StoreUint16(&o.STATUS.Reg, volatile.LoadUint16(&o.STATUS.Reg)&^(0x4)|value<<2)
}
func (o *SERCOM_I2CS_Type) GetSTATUS_RXNACK() uint16 {
	return (volatile.LoadUint16(&o.STATUS.Reg) & 0x4) >> 2
}
func (o *SERCOM_I2CS_Type) SetSTATUS_DIR(value uint16) {
	volatile.StoreUint16(&o.STATUS.Reg, volatile.LoadUint16(&o.STATUS.Reg)&^(0x8)|value<<3)
}
func (o *SERCOM_I2CS_Type) GetSTATUS_DIR() uint16 {
	return (volatile.LoadUint16(&o.STATUS.Reg) & 0x8) >> 3
}
func (o *SERCOM_I2CS_Type) SetSTATUS_SR(value uint16) {
	volatile.StoreUint16(&o.STATUS.Reg, volatile.LoadUint16(&o.STATUS.Reg)&^(0x10)|value<<4)
}
func (o *SERCOM_I2CS_Type) GetSTATUS_SR() uint16 {
	return (volatile.LoadUint16(&o.STATUS.Reg) & 0x10) >> 4
}
func (o *SERCOM_I2CS_Type) SetSTATUS_LOWTOUT(value uint16) {
	volatile.StoreUint16(&o.STATUS.Reg, volatile.LoadUint16(&o.STATUS.Reg)&^(0x40)|value<<6)
}
func (o *SERCOM_I2CS_Type) GetSTATUS_LOWTOUT() uint16 {
	return (volatile.LoadUint16(&o.STATUS.Reg) & 0x40) >> 6
}
func (o *SERCOM_I2CS_Type) SetSTATUS_CLKHOLD(value uint16) {
	volatile.StoreUint16(&o.STATUS.Reg, volatile.LoadUint16(&o.STATUS.Reg)&^(0x80)|value<<7)
}
func (o *SERCOM_I2CS_Type) GetSTATUS_CLKHOLD() uint16 {
	return (volatile.LoadUint16(&o.STATUS.Reg) & 0x80) >> 7
}
func (o *SERCOM_I2CS_Type) SetSTATUS_SEXTTOUT(value uint16) {
	volatile.StoreUint16(&o.STATUS.Reg, volatile.LoadUint16(&o.STATUS.Reg)&^(0x200)|value<<9)
}
func (o *SERCOM_I2CS_Type) GetSTATUS_SEXTTOUT() uint16 {
	return (volatile.LoadUint16(&o.STATUS.Reg) & 0x200) >> 9
}
func (o *SERCOM_I2CS_Type) SetSTATUS_HS(value uint16) {
	volatile.StoreUint16(&o.STATUS.Reg, volatile.LoadUint16(&o.STATUS.Reg)&^(0x400)|value<<10)
}
func (o *SERCOM_I2CS_Type) GetSTATUS_HS() uint16 {
	return (volatile.LoadUint16(&o.STATUS.Reg) & 0x400) >> 10
}

// SERCOM_I2CS.SYNCBUSY: I2CS Synchronization Busy
func (o *SERCOM_I2CS_Type) SetSYNCBUSY_SWRST(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x1)|value)
}
func (o *SERCOM_I2CS_Type) GetSYNCBUSY_SWRST() uint32 {
	return volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x1
}
func (o *SERCOM_I2CS_Type) SetSYNCBUSY_ENABLE(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x2)|value<<1)
}
func (o *SERCOM_I2CS_Type) GetSYNCBUSY_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x2) >> 1
}

// SERCOM_I2CS.ADDR: I2CS Address
func (o *SERCOM_I2CS_Type) SetADDR_GENCEN(value uint32) {
	volatile.StoreUint32(&o.ADDR.Reg, volatile.LoadUint32(&o.ADDR.Reg)&^(0x1)|value)
}
func (o *SERCOM_I2CS_Type) GetADDR_GENCEN() uint32 {
	return volatile.LoadUint32(&o.ADDR.Reg) & 0x1
}
func (o *SERCOM_I2CS_Type) SetADDR(value uint32) {
	volatile.StoreUint32(&o.ADDR.Reg, volatile.LoadUint32(&o.ADDR.Reg)&^(0x7fe)|value<<1)
}
func (o *SERCOM_I2CS_Type) GetADDR() uint32 {
	return (volatile.LoadUint32(&o.ADDR.Reg) & 0x7fe) >> 1
}
func (o *SERCOM_I2CS_Type) SetADDR_TENBITEN(value uint32) {
	volatile.StoreUint32(&o.ADDR.Reg, volatile.LoadUint32(&o.ADDR.Reg)&^(0x8000)|value<<15)
}
func (o *SERCOM_I2CS_Type) GetADDR_TENBITEN() uint32 {
	return (volatile.LoadUint32(&o.ADDR.Reg) & 0x8000) >> 15
}
func (o *SERCOM_I2CS_Type) SetADDR_ADDRMASK(value uint32) {
	volatile.StoreUint32(&o.ADDR.Reg, volatile.LoadUint32(&o.ADDR.Reg)&^(0x7fe0000)|value<<17)
}
func (o *SERCOM_I2CS_Type) GetADDR_ADDRMASK() uint32 {
	return (volatile.LoadUint32(&o.ADDR.Reg) & 0x7fe0000) >> 17
}

// SERCOM_I2CS.DATA: I2CS Data
func (o *SERCOM_I2CS_Type) SetDATA(value uint8) {
	volatile.StoreUint8(&o.DATA.Reg, value)
}
func (o *SERCOM_I2CS_Type) GetDATA() uint8 {
	return volatile.LoadUint8(&o.DATA.Reg)
}

// Serial Communication Interface 0 - SPI
type SERCOM_SPI_Type struct {
	CTRLA    volatile.Register32 // 0x0
	CTRLB    volatile.Register32 // 0x4
	_        [4]byte
	BAUD     volatile.Register8 // 0xC
	_        [7]byte
	INTENCLR volatile.Register8 // 0x14
	_        byte
	INTENSET volatile.Register8 // 0x16
	_        byte
	INTFLAG  volatile.Register8 // 0x18
	_        byte
	STATUS   volatile.Register16 // 0x1A
	SYNCBUSY volatile.Register32 // 0x1C
	_        [4]byte
	ADDR     volatile.Register32 // 0x24
	DATA     volatile.Register32 // 0x28
	_        [4]byte
	DBGCTRL  volatile.Register8 // 0x30
}

// SERCOM_SPI.CTRLA: SPI Control A
func (o *SERCOM_SPI_Type) SetCTRLA_SWRST(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x1)|value)
}
func (o *SERCOM_SPI_Type) GetCTRLA_SWRST() uint32 {
	return volatile.LoadUint32(&o.CTRLA.Reg) & 0x1
}
func (o *SERCOM_SPI_Type) SetCTRLA_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x2)|value<<1)
}
func (o *SERCOM_SPI_Type) GetCTRLA_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x2) >> 1
}
func (o *SERCOM_SPI_Type) SetCTRLA_MODE(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x1c)|value<<2)
}
func (o *SERCOM_SPI_Type) GetCTRLA_MODE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x1c) >> 2
}
func (o *SERCOM_SPI_Type) SetCTRLA_RUNSTDBY(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x80)|value<<7)
}
func (o *SERCOM_SPI_Type) GetCTRLA_RUNSTDBY() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x80) >> 7
}
func (o *SERCOM_SPI_Type) SetCTRLA_IBON(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x100)|value<<8)
}
func (o *SERCOM_SPI_Type) GetCTRLA_IBON() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x100) >> 8
}
func (o *SERCOM_SPI_Type) SetCTRLA_DOPO(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x30000)|value<<16)
}
func (o *SERCOM_SPI_Type) GetCTRLA_DOPO() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x30000) >> 16
}
func (o *SERCOM_SPI_Type) SetCTRLA_DIPO(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x300000)|value<<20)
}
func (o *SERCOM_SPI_Type) GetCTRLA_DIPO() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x300000) >> 20
}
func (o *SERCOM_SPI_Type) SetCTRLA_FORM(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0xf000000)|value<<24)
}
func (o *SERCOM_SPI_Type) GetCTRLA_FORM() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0xf000000) >> 24
}
func (o *SERCOM_SPI_Type) SetCTRLA_CPHA(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x10000000)|value<<28)
}
func (o *SERCOM_SPI_Type) GetCTRLA_CPHA() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x10000000) >> 28
}
func (o *SERCOM_SPI_Type) SetCTRLA_CPOL(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x20000000)|value<<29)
}
func (o *SERCOM_SPI_Type) GetCTRLA_CPOL() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x20000000) >> 29
}
func (o *SERCOM_SPI_Type) SetCTRLA_DORD(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x40000000)|value<<30)
}
func (o *SERCOM_SPI_Type) GetCTRLA_DORD() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x40000000) >> 30
}

// SERCOM_SPI.CTRLB: SPI Control B
func (o *SERCOM_SPI_Type) SetCTRLB_CHSIZE(value uint32) {
	volatile.StoreUint32(&o.CTRLB.Reg, volatile.LoadUint32(&o.CTRLB.Reg)&^(0x7)|value)
}
func (o *SERCOM_SPI_Type) GetCTRLB_CHSIZE() uint32 {
	return volatile.LoadUint32(&o.CTRLB.Reg) & 0x7
}
func (o *SERCOM_SPI_Type) SetCTRLB_PLOADEN(value uint32) {
	volatile.StoreUint32(&o.CTRLB.Reg, volatile.LoadUint32(&o.CTRLB.Reg)&^(0x40)|value<<6)
}
func (o *SERCOM_SPI_Type) GetCTRLB_PLOADEN() uint32 {
	return (volatile.LoadUint32(&o.CTRLB.Reg) & 0x40) >> 6
}
func (o *SERCOM_SPI_Type) SetCTRLB_SSDE(value uint32) {
	volatile.StoreUint32(&o.CTRLB.Reg, volatile.LoadUint32(&o.CTRLB.Reg)&^(0x200)|value<<9)
}
func (o *SERCOM_SPI_Type) GetCTRLB_SSDE() uint32 {
	return (volatile.LoadUint32(&o.CTRLB.Reg) & 0x200) >> 9
}
func (o *SERCOM_SPI_Type) SetCTRLB_MSSEN(value uint32) {
	volatile.StoreUint32(&o.CTRLB.Reg, volatile.LoadUint32(&o.CTRLB.Reg)&^(0x2000)|value<<13)
}
func (o *SERCOM_SPI_Type) GetCTRLB_MSSEN() uint32 {
	return (volatile.LoadUint32(&o.CTRLB.Reg) & 0x2000) >> 13
}
func (o *SERCOM_SPI_Type) SetCTRLB_AMODE(value uint32) {
	volatile.StoreUint32(&o.CTRLB.Reg, volatile.LoadUint32(&o.CTRLB.Reg)&^(0xc000)|value<<14)
}
func (o *SERCOM_SPI_Type) GetCTRLB_AMODE() uint32 {
	return (volatile.LoadUint32(&o.CTRLB.Reg) & 0xc000) >> 14
}
func (o *SERCOM_SPI_Type) SetCTRLB_RXEN(value uint32) {
	volatile.StoreUint32(&o.CTRLB.Reg, volatile.LoadUint32(&o.CTRLB.Reg)&^(0x20000)|value<<17)
}
func (o *SERCOM_SPI_Type) GetCTRLB_RXEN() uint32 {
	return (volatile.LoadUint32(&o.CTRLB.Reg) & 0x20000) >> 17
}

// SERCOM_SPI.BAUD: SPI Baud Rate
func (o *SERCOM_SPI_Type) SetBAUD(value uint8) {
	volatile.StoreUint8(&o.BAUD.Reg, value)
}
func (o *SERCOM_SPI_Type) GetBAUD() uint8 {
	return volatile.LoadUint8(&o.BAUD.Reg)
}

// SERCOM_SPI.INTENCLR: SPI Interrupt Enable Clear
func (o *SERCOM_SPI_Type) SetINTENCLR_DRE(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *SERCOM_SPI_Type) GetINTENCLR_DRE() uint8 {
	return volatile.LoadUint8(&o.INTENCLR.Reg) & 0x1
}
func (o *SERCOM_SPI_Type) SetINTENCLR_TXC(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *SERCOM_SPI_Type) GetINTENCLR_TXC() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *SERCOM_SPI_Type) SetINTENCLR_RXC(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x4)|value<<2)
}
func (o *SERCOM_SPI_Type) GetINTENCLR_RXC() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x4) >> 2
}
func (o *SERCOM_SPI_Type) SetINTENCLR_SSL(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x8)|value<<3)
}
func (o *SERCOM_SPI_Type) GetINTENCLR_SSL() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x8) >> 3
}
func (o *SERCOM_SPI_Type) SetINTENCLR_ERROR(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x80)|value<<7)
}
func (o *SERCOM_SPI_Type) GetINTENCLR_ERROR() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x80) >> 7
}

// SERCOM_SPI.INTENSET: SPI Interrupt Enable Set
func (o *SERCOM_SPI_Type) SetINTENSET_DRE(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *SERCOM_SPI_Type) GetINTENSET_DRE() uint8 {
	return volatile.LoadUint8(&o.INTENSET.Reg) & 0x1
}
func (o *SERCOM_SPI_Type) SetINTENSET_TXC(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *SERCOM_SPI_Type) GetINTENSET_TXC() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *SERCOM_SPI_Type) SetINTENSET_RXC(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x4)|value<<2)
}
func (o *SERCOM_SPI_Type) GetINTENSET_RXC() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x4) >> 2
}
func (o *SERCOM_SPI_Type) SetINTENSET_SSL(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x8)|value<<3)
}
func (o *SERCOM_SPI_Type) GetINTENSET_SSL() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x8) >> 3
}
func (o *SERCOM_SPI_Type) SetINTENSET_ERROR(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x80)|value<<7)
}
func (o *SERCOM_SPI_Type) GetINTENSET_ERROR() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x80) >> 7
}

// SERCOM_SPI.INTFLAG: SPI Interrupt Flag Status and Clear
func (o *SERCOM_SPI_Type) SetINTFLAG_DRE(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x1)|value)
}
func (o *SERCOM_SPI_Type) GetINTFLAG_DRE() uint8 {
	return volatile.LoadUint8(&o.INTFLAG.Reg) & 0x1
}
func (o *SERCOM_SPI_Type) SetINTFLAG_TXC(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x2)|value<<1)
}
func (o *SERCOM_SPI_Type) GetINTFLAG_TXC() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x2) >> 1
}
func (o *SERCOM_SPI_Type) SetINTFLAG_RXC(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x4)|value<<2)
}
func (o *SERCOM_SPI_Type) GetINTFLAG_RXC() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x4) >> 2
}
func (o *SERCOM_SPI_Type) SetINTFLAG_SSL(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x8)|value<<3)
}
func (o *SERCOM_SPI_Type) GetINTFLAG_SSL() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x8) >> 3
}
func (o *SERCOM_SPI_Type) SetINTFLAG_ERROR(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x80)|value<<7)
}
func (o *SERCOM_SPI_Type) GetINTFLAG_ERROR() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x80) >> 7
}

// SERCOM_SPI.STATUS: SPI Status
func (o *SERCOM_SPI_Type) SetSTATUS_BUFOVF(value uint16) {
	volatile.StoreUint16(&o.STATUS.Reg, volatile.LoadUint16(&o.STATUS.Reg)&^(0x4)|value<<2)
}
func (o *SERCOM_SPI_Type) GetSTATUS_BUFOVF() uint16 {
	return (volatile.LoadUint16(&o.STATUS.Reg) & 0x4) >> 2
}

// SERCOM_SPI.SYNCBUSY: SPI Synchronization Busy
func (o *SERCOM_SPI_Type) SetSYNCBUSY_SWRST(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x1)|value)
}
func (o *SERCOM_SPI_Type) GetSYNCBUSY_SWRST() uint32 {
	return volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x1
}
func (o *SERCOM_SPI_Type) SetSYNCBUSY_ENABLE(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x2)|value<<1)
}
func (o *SERCOM_SPI_Type) GetSYNCBUSY_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x2) >> 1
}
func (o *SERCOM_SPI_Type) SetSYNCBUSY_CTRLB(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x4)|value<<2)
}
func (o *SERCOM_SPI_Type) GetSYNCBUSY_CTRLB() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x4) >> 2
}

// SERCOM_SPI.ADDR: SPI Address
func (o *SERCOM_SPI_Type) SetADDR(value uint32) {
	volatile.StoreUint32(&o.ADDR.Reg, volatile.LoadUint32(&o.ADDR.Reg)&^(0xff)|value)
}
func (o *SERCOM_SPI_Type) GetADDR() uint32 {
	return volatile.LoadUint32(&o.ADDR.Reg) & 0xff
}
func (o *SERCOM_SPI_Type) SetADDR_ADDRMASK(value uint32) {
	volatile.StoreUint32(&o.ADDR.Reg, volatile.LoadUint32(&o.ADDR.Reg)&^(0xff0000)|value<<16)
}
func (o *SERCOM_SPI_Type) GetADDR_ADDRMASK() uint32 {
	return (volatile.LoadUint32(&o.ADDR.Reg) & 0xff0000) >> 16
}

// SERCOM_SPI.DATA: SPI Data
func (o *SERCOM_SPI_Type) SetDATA(value uint32) {
	volatile.StoreUint32(&o.DATA.Reg, volatile.LoadUint32(&o.DATA.Reg)&^(0x1ff)|value)
}
func (o *SERCOM_SPI_Type) GetDATA() uint32 {
	return volatile.LoadUint32(&o.DATA.Reg) & 0x1ff
}

// SERCOM_SPI.DBGCTRL: SPI Debug Control
func (o *SERCOM_SPI_Type) SetDBGCTRL_DBGSTOP(value uint8) {
	volatile.StoreUint8(&o.DBGCTRL.Reg, volatile.LoadUint8(&o.DBGCTRL.Reg)&^(0x1)|value)
}
func (o *SERCOM_SPI_Type) GetDBGCTRL_DBGSTOP() uint8 {
	return volatile.LoadUint8(&o.DBGCTRL.Reg) & 0x1
}

// Serial Communication Interface 0 - USART
type SERCOM_USART_Type struct {
	CTRLA    volatile.Register32 // 0x0
	CTRLB    volatile.Register32 // 0x4
	CTRLC    volatile.Register32 // 0x8
	BAUD     volatile.Register16 // 0xC
	RXPL     volatile.Register8  // 0xE
	_        [5]byte
	INTENCLR volatile.Register8 // 0x14
	_        byte
	INTENSET volatile.Register8 // 0x16
	_        byte
	INTFLAG  volatile.Register8 // 0x18
	_        byte
	STATUS   volatile.Register16 // 0x1A
	SYNCBUSY volatile.Register32 // 0x1C
	RXERRCNT volatile.Register8  // 0x20
	_        [7]byte
	DATA     volatile.Register16 // 0x28
	_        [6]byte
	DBGCTRL  volatile.Register8 // 0x30
}

// SERCOM_USART.CTRLA: USART Control A
func (o *SERCOM_USART_Type) SetCTRLA_SWRST(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x1)|value)
}
func (o *SERCOM_USART_Type) GetCTRLA_SWRST() uint32 {
	return volatile.LoadUint32(&o.CTRLA.Reg) & 0x1
}
func (o *SERCOM_USART_Type) SetCTRLA_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x2)|value<<1)
}
func (o *SERCOM_USART_Type) GetCTRLA_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x2) >> 1
}
func (o *SERCOM_USART_Type) SetCTRLA_MODE(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x1c)|value<<2)
}
func (o *SERCOM_USART_Type) GetCTRLA_MODE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x1c) >> 2
}
func (o *SERCOM_USART_Type) SetCTRLA_RUNSTDBY(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x80)|value<<7)
}
func (o *SERCOM_USART_Type) GetCTRLA_RUNSTDBY() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x80) >> 7
}
func (o *SERCOM_USART_Type) SetCTRLA_IBON(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x100)|value<<8)
}
func (o *SERCOM_USART_Type) GetCTRLA_IBON() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x100) >> 8
}
func (o *SERCOM_USART_Type) SetCTRLA_TXINV(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x200)|value<<9)
}
func (o *SERCOM_USART_Type) GetCTRLA_TXINV() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x200) >> 9
}
func (o *SERCOM_USART_Type) SetCTRLA_RXINV(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x400)|value<<10)
}
func (o *SERCOM_USART_Type) GetCTRLA_RXINV() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x400) >> 10
}
func (o *SERCOM_USART_Type) SetCTRLA_SAMPR(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0xe000)|value<<13)
}
func (o *SERCOM_USART_Type) GetCTRLA_SAMPR() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0xe000) >> 13
}
func (o *SERCOM_USART_Type) SetCTRLA_TXPO(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x30000)|value<<16)
}
func (o *SERCOM_USART_Type) GetCTRLA_TXPO() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x30000) >> 16
}
func (o *SERCOM_USART_Type) SetCTRLA_RXPO(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x300000)|value<<20)
}
func (o *SERCOM_USART_Type) GetCTRLA_RXPO() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x300000) >> 20
}
func (o *SERCOM_USART_Type) SetCTRLA_SAMPA(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0xc00000)|value<<22)
}
func (o *SERCOM_USART_Type) GetCTRLA_SAMPA() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0xc00000) >> 22
}
func (o *SERCOM_USART_Type) SetCTRLA_FORM(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0xf000000)|value<<24)
}
func (o *SERCOM_USART_Type) GetCTRLA_FORM() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0xf000000) >> 24
}
func (o *SERCOM_USART_Type) SetCTRLA_CMODE(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x10000000)|value<<28)
}
func (o *SERCOM_USART_Type) GetCTRLA_CMODE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x10000000) >> 28
}
func (o *SERCOM_USART_Type) SetCTRLA_CPOL(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x20000000)|value<<29)
}
func (o *SERCOM_USART_Type) GetCTRLA_CPOL() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x20000000) >> 29
}
func (o *SERCOM_USART_Type) SetCTRLA_DORD(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x40000000)|value<<30)
}
func (o *SERCOM_USART_Type) GetCTRLA_DORD() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x40000000) >> 30
}

// SERCOM_USART.CTRLB: USART Control B
func (o *SERCOM_USART_Type) SetCTRLB_CHSIZE(value uint32) {
	volatile.StoreUint32(&o.CTRLB.Reg, volatile.LoadUint32(&o.CTRLB.Reg)&^(0x7)|value)
}
func (o *SERCOM_USART_Type) GetCTRLB_CHSIZE() uint32 {
	return volatile.LoadUint32(&o.CTRLB.Reg) & 0x7
}
func (o *SERCOM_USART_Type) SetCTRLB_SBMODE(value uint32) {
	volatile.StoreUint32(&o.CTRLB.Reg, volatile.LoadUint32(&o.CTRLB.Reg)&^(0x40)|value<<6)
}
func (o *SERCOM_USART_Type) GetCTRLB_SBMODE() uint32 {
	return (volatile.LoadUint32(&o.CTRLB.Reg) & 0x40) >> 6
}
func (o *SERCOM_USART_Type) SetCTRLB_COLDEN(value uint32) {
	volatile.StoreUint32(&o.CTRLB.Reg, volatile.LoadUint32(&o.CTRLB.Reg)&^(0x100)|value<<8)
}
func (o *SERCOM_USART_Type) GetCTRLB_COLDEN() uint32 {
	return (volatile.LoadUint32(&o.CTRLB.Reg) & 0x100) >> 8
}
func (o *SERCOM_USART_Type) SetCTRLB_SFDE(value uint32) {
	volatile.StoreUint32(&o.CTRLB.Reg, volatile.LoadUint32(&o.CTRLB.Reg)&^(0x200)|value<<9)
}
func (o *SERCOM_USART_Type) GetCTRLB_SFDE() uint32 {
	return (volatile.LoadUint32(&o.CTRLB.Reg) & 0x200) >> 9
}
func (o *SERCOM_USART_Type) SetCTRLB_ENC(value uint32) {
	volatile.StoreUint32(&o.CTRLB.Reg, volatile.LoadUint32(&o.CTRLB.Reg)&^(0x400)|value<<10)
}
func (o *SERCOM_USART_Type) GetCTRLB_ENC() uint32 {
	return (volatile.LoadUint32(&o.CTRLB.Reg) & 0x400) >> 10
}
func (o *SERCOM_USART_Type) SetCTRLB_PMODE(value uint32) {
	volatile.StoreUint32(&o.CTRLB.Reg, volatile.LoadUint32(&o.CTRLB.Reg)&^(0x2000)|value<<13)
}
func (o *SERCOM_USART_Type) GetCTRLB_PMODE() uint32 {
	return (volatile.LoadUint32(&o.CTRLB.Reg) & 0x2000) >> 13
}
func (o *SERCOM_USART_Type) SetCTRLB_TXEN(value uint32) {
	volatile.StoreUint32(&o.CTRLB.Reg, volatile.LoadUint32(&o.CTRLB.Reg)&^(0x10000)|value<<16)
}
func (o *SERCOM_USART_Type) GetCTRLB_TXEN() uint32 {
	return (volatile.LoadUint32(&o.CTRLB.Reg) & 0x10000) >> 16
}
func (o *SERCOM_USART_Type) SetCTRLB_RXEN(value uint32) {
	volatile.StoreUint32(&o.CTRLB.Reg, volatile.LoadUint32(&o.CTRLB.Reg)&^(0x20000)|value<<17)
}
func (o *SERCOM_USART_Type) GetCTRLB_RXEN() uint32 {
	return (volatile.LoadUint32(&o.CTRLB.Reg) & 0x20000) >> 17
}

// SERCOM_USART.CTRLC: USART Control C
func (o *SERCOM_USART_Type) SetCTRLC_GTIME(value uint32) {
	volatile.StoreUint32(&o.CTRLC.Reg, volatile.LoadUint32(&o.CTRLC.Reg)&^(0x7)|value)
}
func (o *SERCOM_USART_Type) GetCTRLC_GTIME() uint32 {
	return volatile.LoadUint32(&o.CTRLC.Reg) & 0x7
}
func (o *SERCOM_USART_Type) SetCTRLC_INACK(value uint32) {
	volatile.StoreUint32(&o.CTRLC.Reg, volatile.LoadUint32(&o.CTRLC.Reg)&^(0x10000)|value<<16)
}
func (o *SERCOM_USART_Type) GetCTRLC_INACK() uint32 {
	return (volatile.LoadUint32(&o.CTRLC.Reg) & 0x10000) >> 16
}
func (o *SERCOM_USART_Type) SetCTRLC_DSNACK(value uint32) {
	volatile.StoreUint32(&o.CTRLC.Reg, volatile.LoadUint32(&o.CTRLC.Reg)&^(0x20000)|value<<17)
}
func (o *SERCOM_USART_Type) GetCTRLC_DSNACK() uint32 {
	return (volatile.LoadUint32(&o.CTRLC.Reg) & 0x20000) >> 17
}
func (o *SERCOM_USART_Type) SetCTRLC_MAXITER(value uint32) {
	volatile.StoreUint32(&o.CTRLC.Reg, volatile.LoadUint32(&o.CTRLC.Reg)&^(0x700000)|value<<20)
}
func (o *SERCOM_USART_Type) GetCTRLC_MAXITER() uint32 {
	return (volatile.LoadUint32(&o.CTRLC.Reg) & 0x700000) >> 20
}

// SERCOM_USART.BAUD: USART Baud Rate
func (o *SERCOM_USART_Type) SetBAUD(value uint16) {
	volatile.StoreUint16(&o.BAUD.Reg, value)
}
func (o *SERCOM_USART_Type) GetBAUD() uint16 {
	return volatile.LoadUint16(&o.BAUD.Reg)
}

// SERCOM_USART.RXPL: USART Receive Pulse Length
func (o *SERCOM_USART_Type) SetRXPL(value uint8) {
	volatile.StoreUint8(&o.RXPL.Reg, value)
}
func (o *SERCOM_USART_Type) GetRXPL() uint8 {
	return volatile.LoadUint8(&o.RXPL.Reg)
}

// SERCOM_USART.INTENCLR: USART Interrupt Enable Clear
func (o *SERCOM_USART_Type) SetINTENCLR_DRE(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *SERCOM_USART_Type) GetINTENCLR_DRE() uint8 {
	return volatile.LoadUint8(&o.INTENCLR.Reg) & 0x1
}
func (o *SERCOM_USART_Type) SetINTENCLR_TXC(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *SERCOM_USART_Type) GetINTENCLR_TXC() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *SERCOM_USART_Type) SetINTENCLR_RXC(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x4)|value<<2)
}
func (o *SERCOM_USART_Type) GetINTENCLR_RXC() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x4) >> 2
}
func (o *SERCOM_USART_Type) SetINTENCLR_RXS(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x8)|value<<3)
}
func (o *SERCOM_USART_Type) GetINTENCLR_RXS() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x8) >> 3
}
func (o *SERCOM_USART_Type) SetINTENCLR_CTSIC(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x10)|value<<4)
}
func (o *SERCOM_USART_Type) GetINTENCLR_CTSIC() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x10) >> 4
}
func (o *SERCOM_USART_Type) SetINTENCLR_RXBRK(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x20)|value<<5)
}
func (o *SERCOM_USART_Type) GetINTENCLR_RXBRK() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x20) >> 5
}
func (o *SERCOM_USART_Type) SetINTENCLR_ERROR(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x80)|value<<7)
}
func (o *SERCOM_USART_Type) GetINTENCLR_ERROR() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x80) >> 7
}

// SERCOM_USART.INTENSET: USART Interrupt Enable Set
func (o *SERCOM_USART_Type) SetINTENSET_DRE(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *SERCOM_USART_Type) GetINTENSET_DRE() uint8 {
	return volatile.LoadUint8(&o.INTENSET.Reg) & 0x1
}
func (o *SERCOM_USART_Type) SetINTENSET_TXC(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *SERCOM_USART_Type) GetINTENSET_TXC() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *SERCOM_USART_Type) SetINTENSET_RXC(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x4)|value<<2)
}
func (o *SERCOM_USART_Type) GetINTENSET_RXC() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x4) >> 2
}
func (o *SERCOM_USART_Type) SetINTENSET_RXS(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x8)|value<<3)
}
func (o *SERCOM_USART_Type) GetINTENSET_RXS() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x8) >> 3
}
func (o *SERCOM_USART_Type) SetINTENSET_CTSIC(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x10)|value<<4)
}
func (o *SERCOM_USART_Type) GetINTENSET_CTSIC() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x10) >> 4
}
func (o *SERCOM_USART_Type) SetINTENSET_RXBRK(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x20)|value<<5)
}
func (o *SERCOM_USART_Type) GetINTENSET_RXBRK() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x20) >> 5
}
func (o *SERCOM_USART_Type) SetINTENSET_ERROR(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x80)|value<<7)
}
func (o *SERCOM_USART_Type) GetINTENSET_ERROR() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x80) >> 7
}

// SERCOM_USART.INTFLAG: USART Interrupt Flag Status and Clear
func (o *SERCOM_USART_Type) SetINTFLAG_DRE(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x1)|value)
}
func (o *SERCOM_USART_Type) GetINTFLAG_DRE() uint8 {
	return volatile.LoadUint8(&o.INTFLAG.Reg) & 0x1
}
func (o *SERCOM_USART_Type) SetINTFLAG_TXC(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x2)|value<<1)
}
func (o *SERCOM_USART_Type) GetINTFLAG_TXC() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x2) >> 1
}
func (o *SERCOM_USART_Type) SetINTFLAG_RXC(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x4)|value<<2)
}
func (o *SERCOM_USART_Type) GetINTFLAG_RXC() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x4) >> 2
}
func (o *SERCOM_USART_Type) SetINTFLAG_RXS(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x8)|value<<3)
}
func (o *SERCOM_USART_Type) GetINTFLAG_RXS() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x8) >> 3
}
func (o *SERCOM_USART_Type) SetINTFLAG_CTSIC(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x10)|value<<4)
}
func (o *SERCOM_USART_Type) GetINTFLAG_CTSIC() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x10) >> 4
}
func (o *SERCOM_USART_Type) SetINTFLAG_RXBRK(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x20)|value<<5)
}
func (o *SERCOM_USART_Type) GetINTFLAG_RXBRK() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x20) >> 5
}
func (o *SERCOM_USART_Type) SetINTFLAG_ERROR(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x80)|value<<7)
}
func (o *SERCOM_USART_Type) GetINTFLAG_ERROR() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x80) >> 7
}

// SERCOM_USART.STATUS: USART Status
func (o *SERCOM_USART_Type) SetSTATUS_PERR(value uint16) {
	volatile.StoreUint16(&o.STATUS.Reg, volatile.LoadUint16(&o.STATUS.Reg)&^(0x1)|value)
}
func (o *SERCOM_USART_Type) GetSTATUS_PERR() uint16 {
	return volatile.LoadUint16(&o.STATUS.Reg) & 0x1
}
func (o *SERCOM_USART_Type) SetSTATUS_FERR(value uint16) {
	volatile.StoreUint16(&o.STATUS.Reg, volatile.LoadUint16(&o.STATUS.Reg)&^(0x2)|value<<1)
}
func (o *SERCOM_USART_Type) GetSTATUS_FERR() uint16 {
	return (volatile.LoadUint16(&o.STATUS.Reg) & 0x2) >> 1
}
func (o *SERCOM_USART_Type) SetSTATUS_BUFOVF(value uint16) {
	volatile.StoreUint16(&o.STATUS.Reg, volatile.LoadUint16(&o.STATUS.Reg)&^(0x4)|value<<2)
}
func (o *SERCOM_USART_Type) GetSTATUS_BUFOVF() uint16 {
	return (volatile.LoadUint16(&o.STATUS.Reg) & 0x4) >> 2
}
func (o *SERCOM_USART_Type) SetSTATUS_CTS(value uint16) {
	volatile.StoreUint16(&o.STATUS.Reg, volatile.LoadUint16(&o.STATUS.Reg)&^(0x8)|value<<3)
}
func (o *SERCOM_USART_Type) GetSTATUS_CTS() uint16 {
	return (volatile.LoadUint16(&o.STATUS.Reg) & 0x8) >> 3
}
func (o *SERCOM_USART_Type) SetSTATUS_ISF(value uint16) {
	volatile.StoreUint16(&o.STATUS.Reg, volatile.LoadUint16(&o.STATUS.Reg)&^(0x10)|value<<4)
}
func (o *SERCOM_USART_Type) GetSTATUS_ISF() uint16 {
	return (volatile.LoadUint16(&o.STATUS.Reg) & 0x10) >> 4
}
func (o *SERCOM_USART_Type) SetSTATUS_COLL(value uint16) {
	volatile.StoreUint16(&o.STATUS.Reg, volatile.LoadUint16(&o.STATUS.Reg)&^(0x20)|value<<5)
}
func (o *SERCOM_USART_Type) GetSTATUS_COLL() uint16 {
	return (volatile.LoadUint16(&o.STATUS.Reg) & 0x20) >> 5
}
func (o *SERCOM_USART_Type) SetSTATUS_TXE(value uint16) {
	volatile.StoreUint16(&o.STATUS.Reg, volatile.LoadUint16(&o.STATUS.Reg)&^(0x40)|value<<6)
}
func (o *SERCOM_USART_Type) GetSTATUS_TXE() uint16 {
	return (volatile.LoadUint16(&o.STATUS.Reg) & 0x40) >> 6
}
func (o *SERCOM_USART_Type) SetSTATUS_ITER(value uint16) {
	volatile.StoreUint16(&o.STATUS.Reg, volatile.LoadUint16(&o.STATUS.Reg)&^(0x80)|value<<7)
}
func (o *SERCOM_USART_Type) GetSTATUS_ITER() uint16 {
	return (volatile.LoadUint16(&o.STATUS.Reg) & 0x80) >> 7
}

// SERCOM_USART.SYNCBUSY: USART Synchronization Busy
func (o *SERCOM_USART_Type) SetSYNCBUSY_SWRST(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x1)|value)
}
func (o *SERCOM_USART_Type) GetSYNCBUSY_SWRST() uint32 {
	return volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x1
}
func (o *SERCOM_USART_Type) SetSYNCBUSY_ENABLE(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x2)|value<<1)
}
func (o *SERCOM_USART_Type) GetSYNCBUSY_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x2) >> 1
}
func (o *SERCOM_USART_Type) SetSYNCBUSY_CTRLB(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x4)|value<<2)
}
func (o *SERCOM_USART_Type) GetSYNCBUSY_CTRLB() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x4) >> 2
}

// SERCOM_USART.DATA: USART Data
func (o *SERCOM_USART_Type) SetDATA(value uint16) {
	volatile.StoreUint16(&o.DATA.Reg, volatile.LoadUint16(&o.DATA.Reg)&^(0x1ff)|value)
}
func (o *SERCOM_USART_Type) GetDATA() uint16 {
	return volatile.LoadUint16(&o.DATA.Reg) & 0x1ff
}

// SERCOM_USART.DBGCTRL: USART Debug Control
func (o *SERCOM_USART_Type) SetDBGCTRL_DBGSTOP(value uint8) {
	volatile.StoreUint8(&o.DBGCTRL.Reg, volatile.LoadUint8(&o.DBGCTRL.Reg)&^(0x1)|value)
}
func (o *SERCOM_USART_Type) GetDBGCTRL_DBGSTOP() uint8 {
	return volatile.LoadUint8(&o.DBGCTRL.Reg) & 0x1
}

// Segment Liquid Crystal Display Controller
type SLCD_Type struct {
	CTRLA    volatile.Register32 // 0x0
	CTRLB    volatile.Register16 // 0x4
	CTRLC    volatile.Register16 // 0x6
	CTRLD    volatile.Register8  // 0x8
	_        [3]byte
	EVCTRL   volatile.Register8 // 0xC
	INTENCLR volatile.Register8 // 0xD
	INTENSET volatile.Register8 // 0xE
	INTFLAG  volatile.Register8 // 0xF
	STATUS   volatile.Register8 // 0x10
	_        [3]byte
	SYNCBUSY volatile.Register32 // 0x14
	FC0      volatile.Register8  // 0x18
	FC1      volatile.Register8  // 0x19
	FC2      volatile.Register8  // 0x1A
	_        byte
	LPENL    volatile.Register32 // 0x1C
	LPENH    volatile.Register32 // 0x20
	SDATAL0  volatile.Register32 // 0x24
	SDATAH0  volatile.Register32 // 0x28
	SDATAL1  volatile.Register32 // 0x2C
	SDATAH1  volatile.Register32 // 0x30
	SDATAL2  volatile.Register32 // 0x34
	SDATAH2  volatile.Register32 // 0x38
	SDATAL3  volatile.Register32 // 0x3C
	SDATAH3  volatile.Register32 // 0x40
	SDATAL4  volatile.Register32 // 0x44
	SDATAH4  volatile.Register32 // 0x48
	SDATAL5  volatile.Register32 // 0x4C
	SDATAH5  volatile.Register32 // 0x50
	SDATAL6  volatile.Register32 // 0x54
	SDATAH6  volatile.Register32 // 0x58
	SDATAL7  volatile.Register32 // 0x5C
	SDATAH7  volatile.Register32 // 0x60
	ISDATA   volatile.Register32 // 0x64
	BCFG     volatile.Register32 // 0x68
	CSRCFG   volatile.Register32 // 0x6C
	CMCFG    volatile.Register8  // 0x70
	_        [3]byte
	ACMCFG   volatile.Register32 // 0x74
	ABMCFG   volatile.Register8  // 0x78
	_        [3]byte
	CMDATA   volatile.Register32 // 0x7C
	CMDMASK  volatile.Register32 // 0x80
	CMINDEX  volatile.Register16 // 0x84
}

// SLCD.CTRLA: Control A
func (o *SLCD_Type) SetCTRLA_SWRST(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x1)|value)
}
func (o *SLCD_Type) GetCTRLA_SWRST() uint32 {
	return volatile.LoadUint32(&o.CTRLA.Reg) & 0x1
}
func (o *SLCD_Type) SetCTRLA_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x2)|value<<1)
}
func (o *SLCD_Type) GetCTRLA_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x2) >> 1
}
func (o *SLCD_Type) SetCTRLA_DUTY(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x1c)|value<<2)
}
func (o *SLCD_Type) GetCTRLA_DUTY() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x1c) >> 2
}
func (o *SLCD_Type) SetCTRLA_WMOD(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x20)|value<<5)
}
func (o *SLCD_Type) GetCTRLA_WMOD() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x20) >> 5
}
func (o *SLCD_Type) SetCTRLA_RUNSTDBY(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x40)|value<<6)
}
func (o *SLCD_Type) GetCTRLA_RUNSTDBY() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x40) >> 6
}
func (o *SLCD_Type) SetCTRLA_PRESC(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x300)|value<<8)
}
func (o *SLCD_Type) GetCTRLA_PRESC() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x300) >> 8
}
func (o *SLCD_Type) SetCTRLA_CKDIV(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x7000)|value<<12)
}
func (o *SLCD_Type) GetCTRLA_CKDIV() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x7000) >> 12
}
func (o *SLCD_Type) SetCTRLA_BIAS(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x30000)|value<<16)
}
func (o *SLCD_Type) GetCTRLA_BIAS() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x30000) >> 16
}
func (o *SLCD_Type) SetCTRLA_XVLCD(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x80000)|value<<19)
}
func (o *SLCD_Type) GetCTRLA_XVLCD() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x80000) >> 19
}
func (o *SLCD_Type) SetCTRLA_PRF(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x300000)|value<<20)
}
func (o *SLCD_Type) GetCTRLA_PRF() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x300000) >> 20
}
func (o *SLCD_Type) SetCTRLA_DMFCS(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0xc00000)|value<<22)
}
func (o *SLCD_Type) GetCTRLA_DMFCS() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0xc00000) >> 22
}
func (o *SLCD_Type) SetCTRLA_RRF(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x7000000)|value<<24)
}
func (o *SLCD_Type) GetCTRLA_RRF() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x7000000) >> 24
}

// SLCD.CTRLB: Control B
func (o *SLCD_Type) SetCTRLB_BBD(value uint16) {
	volatile.StoreUint16(&o.CTRLB.Reg, volatile.LoadUint16(&o.CTRLB.Reg)&^(0xf)|value)
}
func (o *SLCD_Type) GetCTRLB_BBD() uint16 {
	return volatile.LoadUint16(&o.CTRLB.Reg) & 0xf
}
func (o *SLCD_Type) SetCTRLB_BBEN(value uint16) {
	volatile.StoreUint16(&o.CTRLB.Reg, volatile.LoadUint16(&o.CTRLB.Reg)&^(0x80)|value<<7)
}
func (o *SLCD_Type) GetCTRLB_BBEN() uint16 {
	return (volatile.LoadUint16(&o.CTRLB.Reg) & 0x80) >> 7
}
func (o *SLCD_Type) SetCTRLB_LRD(value uint16) {
	volatile.StoreUint16(&o.CTRLB.Reg, volatile.LoadUint16(&o.CTRLB.Reg)&^(0xf00)|value<<8)
}
func (o *SLCD_Type) GetCTRLB_LRD() uint16 {
	return (volatile.LoadUint16(&o.CTRLB.Reg) & 0xf00) >> 8
}
func (o *SLCD_Type) SetCTRLB_LREN(value uint16) {
	volatile.StoreUint16(&o.CTRLB.Reg, volatile.LoadUint16(&o.CTRLB.Reg)&^(0x8000)|value<<15)
}
func (o *SLCD_Type) GetCTRLB_LREN() uint16 {
	return (volatile.LoadUint16(&o.CTRLB.Reg) & 0x8000) >> 15
}

// SLCD.CTRLC: Control C
func (o *SLCD_Type) SetCTRLC_CLEAR(value uint16) {
	volatile.StoreUint16(&o.CTRLC.Reg, volatile.LoadUint16(&o.CTRLC.Reg)&^(0x1)|value)
}
func (o *SLCD_Type) GetCTRLC_CLEAR() uint16 {
	return volatile.LoadUint16(&o.CTRLC.Reg) & 0x1
}
func (o *SLCD_Type) SetCTRLC_LOCK(value uint16) {
	volatile.StoreUint16(&o.CTRLC.Reg, volatile.LoadUint16(&o.CTRLC.Reg)&^(0x2)|value<<1)
}
func (o *SLCD_Type) GetCTRLC_LOCK() uint16 {
	return (volatile.LoadUint16(&o.CTRLC.Reg) & 0x2) >> 1
}
func (o *SLCD_Type) SetCTRLC_ABMEN(value uint16) {
	volatile.StoreUint16(&o.CTRLC.Reg, volatile.LoadUint16(&o.CTRLC.Reg)&^(0x4)|value<<2)
}
func (o *SLCD_Type) GetCTRLC_ABMEN() uint16 {
	return (volatile.LoadUint16(&o.CTRLC.Reg) & 0x4) >> 2
}
func (o *SLCD_Type) SetCTRLC_ACMEN(value uint16) {
	volatile.StoreUint16(&o.CTRLC.Reg, volatile.LoadUint16(&o.CTRLC.Reg)&^(0x8)|value<<3)
}
func (o *SLCD_Type) GetCTRLC_ACMEN() uint16 {
	return (volatile.LoadUint16(&o.CTRLC.Reg) & 0x8) >> 3
}
func (o *SLCD_Type) SetCTRLC_CTST(value uint16) {
	volatile.StoreUint16(&o.CTRLC.Reg, volatile.LoadUint16(&o.CTRLC.Reg)&^(0xf0)|value<<4)
}
func (o *SLCD_Type) GetCTRLC_CTST() uint16 {
	return (volatile.LoadUint16(&o.CTRLC.Reg) & 0xf0) >> 4
}
func (o *SLCD_Type) SetCTRLC_LPPM(value uint16) {
	volatile.StoreUint16(&o.CTRLC.Reg, volatile.LoadUint16(&o.CTRLC.Reg)&^(0x300)|value<<8)
}
func (o *SLCD_Type) GetCTRLC_LPPM() uint16 {
	return (volatile.LoadUint16(&o.CTRLC.Reg) & 0x300) >> 8
}

// SLCD.CTRLD: Control D
func (o *SLCD_Type) SetCTRLD_BLANK(value uint8) {
	volatile.StoreUint8(&o.CTRLD.Reg, volatile.LoadUint8(&o.CTRLD.Reg)&^(0x1)|value)
}
func (o *SLCD_Type) GetCTRLD_BLANK() uint8 {
	return volatile.LoadUint8(&o.CTRLD.Reg) & 0x1
}
func (o *SLCD_Type) SetCTRLD_BLINK(value uint8) {
	volatile.StoreUint8(&o.CTRLD.Reg, volatile.LoadUint8(&o.CTRLD.Reg)&^(0x2)|value<<1)
}
func (o *SLCD_Type) GetCTRLD_BLINK() uint8 {
	return (volatile.LoadUint8(&o.CTRLD.Reg) & 0x2) >> 1
}
func (o *SLCD_Type) SetCTRLD_CSREN(value uint8) {
	volatile.StoreUint8(&o.CTRLD.Reg, volatile.LoadUint8(&o.CTRLD.Reg)&^(0x4)|value<<2)
}
func (o *SLCD_Type) GetCTRLD_CSREN() uint8 {
	return (volatile.LoadUint8(&o.CTRLD.Reg) & 0x4) >> 2
}
func (o *SLCD_Type) SetCTRLD_FC0EN(value uint8) {
	volatile.StoreUint8(&o.CTRLD.Reg, volatile.LoadUint8(&o.CTRLD.Reg)&^(0x10)|value<<4)
}
func (o *SLCD_Type) GetCTRLD_FC0EN() uint8 {
	return (volatile.LoadUint8(&o.CTRLD.Reg) & 0x10) >> 4
}
func (o *SLCD_Type) SetCTRLD_FC1EN(value uint8) {
	volatile.StoreUint8(&o.CTRLD.Reg, volatile.LoadUint8(&o.CTRLD.Reg)&^(0x20)|value<<5)
}
func (o *SLCD_Type) GetCTRLD_FC1EN() uint8 {
	return (volatile.LoadUint8(&o.CTRLD.Reg) & 0x20) >> 5
}
func (o *SLCD_Type) SetCTRLD_FC2EN(value uint8) {
	volatile.StoreUint8(&o.CTRLD.Reg, volatile.LoadUint8(&o.CTRLD.Reg)&^(0x40)|value<<6)
}
func (o *SLCD_Type) GetCTRLD_FC2EN() uint8 {
	return (volatile.LoadUint8(&o.CTRLD.Reg) & 0x40) >> 6
}
func (o *SLCD_Type) SetCTRLD_DISPEN(value uint8) {
	volatile.StoreUint8(&o.CTRLD.Reg, volatile.LoadUint8(&o.CTRLD.Reg)&^(0x80)|value<<7)
}
func (o *SLCD_Type) GetCTRLD_DISPEN() uint8 {
	return (volatile.LoadUint8(&o.CTRLD.Reg) & 0x80) >> 7
}

// SLCD.EVCTRL: Event Control
func (o *SLCD_Type) SetEVCTRL_FC0OEO(value uint8) {
	volatile.StoreUint8(&o.EVCTRL.Reg, volatile.LoadUint8(&o.EVCTRL.Reg)&^(0x1)|value)
}
func (o *SLCD_Type) GetEVCTRL_FC0OEO() uint8 {
	return volatile.LoadUint8(&o.EVCTRL.Reg) & 0x1
}
func (o *SLCD_Type) SetEVCTRL_FC1OEO(value uint8) {
	volatile.StoreUint8(&o.EVCTRL.Reg, volatile.LoadUint8(&o.EVCTRL.Reg)&^(0x2)|value<<1)
}
func (o *SLCD_Type) GetEVCTRL_FC1OEO() uint8 {
	return (volatile.LoadUint8(&o.EVCTRL.Reg) & 0x2) >> 1
}
func (o *SLCD_Type) SetEVCTRL_FC2OEO(value uint8) {
	volatile.StoreUint8(&o.EVCTRL.Reg, volatile.LoadUint8(&o.EVCTRL.Reg)&^(0x4)|value<<2)
}
func (o *SLCD_Type) GetEVCTRL_FC2OEO() uint8 {
	return (volatile.LoadUint8(&o.EVCTRL.Reg) & 0x4) >> 2
}

// SLCD.INTENCLR: Interrupt Enable Clear
func (o *SLCD_Type) SetINTENCLR_FC0O(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *SLCD_Type) GetINTENCLR_FC0O() uint8 {
	return volatile.LoadUint8(&o.INTENCLR.Reg) & 0x1
}
func (o *SLCD_Type) SetINTENCLR_FC1O(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *SLCD_Type) GetINTENCLR_FC1O() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *SLCD_Type) SetINTENCLR_FC2O(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x4)|value<<2)
}
func (o *SLCD_Type) GetINTENCLR_FC2O() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x4) >> 2
}
func (o *SLCD_Type) SetINTENCLR_VLCDRT(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x8)|value<<3)
}
func (o *SLCD_Type) GetINTENCLR_VLCDRT() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x8) >> 3
}
func (o *SLCD_Type) SetINTENCLR_VLCDST(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x10)|value<<4)
}
func (o *SLCD_Type) GetINTENCLR_VLCDST() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x10) >> 4
}
func (o *SLCD_Type) SetINTENCLR_PRST(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x20)|value<<5)
}
func (o *SLCD_Type) GetINTENCLR_PRST() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x20) >> 5
}

// SLCD.INTENSET: Interrupt Enable Set
func (o *SLCD_Type) SetINTENSET_FC0O(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *SLCD_Type) GetINTENSET_FC0O() uint8 {
	return volatile.LoadUint8(&o.INTENSET.Reg) & 0x1
}
func (o *SLCD_Type) SetINTENSET_FC1O(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *SLCD_Type) GetINTENSET_FC1O() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *SLCD_Type) SetINTENSET_FC2O(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x4)|value<<2)
}
func (o *SLCD_Type) GetINTENSET_FC2O() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x4) >> 2
}
func (o *SLCD_Type) SetINTENSET_VLCDRT(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x8)|value<<3)
}
func (o *SLCD_Type) GetINTENSET_VLCDRT() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x8) >> 3
}
func (o *SLCD_Type) SetINTENSET_VLCDST(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x10)|value<<4)
}
func (o *SLCD_Type) GetINTENSET_VLCDST() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x10) >> 4
}
func (o *SLCD_Type) SetINTENSET_PRST(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x20)|value<<5)
}
func (o *SLCD_Type) GetINTENSET_PRST() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x20) >> 5
}

// SLCD.INTFLAG: Interrupt Flag Status and Clear
func (o *SLCD_Type) SetINTFLAG_FC0O(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x1)|value)
}
func (o *SLCD_Type) GetINTFLAG_FC0O() uint8 {
	return volatile.LoadUint8(&o.INTFLAG.Reg) & 0x1
}
func (o *SLCD_Type) SetINTFLAG_FC1O(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x2)|value<<1)
}
func (o *SLCD_Type) GetINTFLAG_FC1O() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x2) >> 1
}
func (o *SLCD_Type) SetINTFLAG_FC2O(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x4)|value<<2)
}
func (o *SLCD_Type) GetINTFLAG_FC2O() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x4) >> 2
}
func (o *SLCD_Type) SetINTFLAG_VLCDRT(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x8)|value<<3)
}
func (o *SLCD_Type) GetINTFLAG_VLCDRT() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x8) >> 3
}
func (o *SLCD_Type) SetINTFLAG_VLCDST(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x10)|value<<4)
}
func (o *SLCD_Type) GetINTFLAG_VLCDST() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x10) >> 4
}
func (o *SLCD_Type) SetINTFLAG_PRST(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x20)|value<<5)
}
func (o *SLCD_Type) GetINTFLAG_PRST() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x20) >> 5
}

// SLCD.STATUS: Status
func (o *SLCD_Type) SetSTATUS_VLCDR(value uint8) {
	volatile.StoreUint8(&o.STATUS.Reg, volatile.LoadUint8(&o.STATUS.Reg)&^(0x1)|value)
}
func (o *SLCD_Type) GetSTATUS_VLCDR() uint8 {
	return volatile.LoadUint8(&o.STATUS.Reg) & 0x1
}
func (o *SLCD_Type) SetSTATUS_PRUN(value uint8) {
	volatile.StoreUint8(&o.STATUS.Reg, volatile.LoadUint8(&o.STATUS.Reg)&^(0x2)|value<<1)
}
func (o *SLCD_Type) GetSTATUS_PRUN() uint8 {
	return (volatile.LoadUint8(&o.STATUS.Reg) & 0x2) >> 1
}
func (o *SLCD_Type) SetSTATUS_VLCDS(value uint8) {
	volatile.StoreUint8(&o.STATUS.Reg, volatile.LoadUint8(&o.STATUS.Reg)&^(0x4)|value<<2)
}
func (o *SLCD_Type) GetSTATUS_VLCDS() uint8 {
	return (volatile.LoadUint8(&o.STATUS.Reg) & 0x4) >> 2
}
func (o *SLCD_Type) SetSTATUS_CMWRBUSY(value uint8) {
	volatile.StoreUint8(&o.STATUS.Reg, volatile.LoadUint8(&o.STATUS.Reg)&^(0x8)|value<<3)
}
func (o *SLCD_Type) GetSTATUS_CMWRBUSY() uint8 {
	return (volatile.LoadUint8(&o.STATUS.Reg) & 0x8) >> 3
}
func (o *SLCD_Type) SetSTATUS_ACMBUSY(value uint8) {
	volatile.StoreUint8(&o.STATUS.Reg, volatile.LoadUint8(&o.STATUS.Reg)&^(0x10)|value<<4)
}
func (o *SLCD_Type) GetSTATUS_ACMBUSY() uint8 {
	return (volatile.LoadUint8(&o.STATUS.Reg) & 0x10) >> 4
}
func (o *SLCD_Type) SetSTATUS_ABMBUSY(value uint8) {
	volatile.StoreUint8(&o.STATUS.Reg, volatile.LoadUint8(&o.STATUS.Reg)&^(0x20)|value<<5)
}
func (o *SLCD_Type) GetSTATUS_ABMBUSY() uint8 {
	return (volatile.LoadUint8(&o.STATUS.Reg) & 0x20) >> 5
}

// SLCD.SYNCBUSY: Synchronization Busy
func (o *SLCD_Type) SetSYNCBUSY_SWRST(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x1)|value)
}
func (o *SLCD_Type) GetSYNCBUSY_SWRST() uint32 {
	return volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x1
}
func (o *SLCD_Type) SetSYNCBUSY_ENABLE(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x2)|value<<1)
}
func (o *SLCD_Type) GetSYNCBUSY_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x2) >> 1
}
func (o *SLCD_Type) SetSYNCBUSY_CTRLD(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x4)|value<<2)
}
func (o *SLCD_Type) GetSYNCBUSY_CTRLD() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x4) >> 2
}

// SLCD.FC0: Frame Counter 0 Configuration
func (o *SLCD_Type) SetFC0_OVF(value uint8) {
	volatile.StoreUint8(&o.FC0.Reg, volatile.LoadUint8(&o.FC0.Reg)&^(0x1f)|value)
}
func (o *SLCD_Type) GetFC0_OVF() uint8 {
	return volatile.LoadUint8(&o.FC0.Reg) & 0x1f
}
func (o *SLCD_Type) SetFC0_PB(value uint8) {
	volatile.StoreUint8(&o.FC0.Reg, volatile.LoadUint8(&o.FC0.Reg)&^(0x80)|value<<7)
}
func (o *SLCD_Type) GetFC0_PB() uint8 {
	return (volatile.LoadUint8(&o.FC0.Reg) & 0x80) >> 7
}

// SLCD.FC1: Frame Counter 1 Configuration
func (o *SLCD_Type) SetFC1_OVF(value uint8) {
	volatile.StoreUint8(&o.FC1.Reg, volatile.LoadUint8(&o.FC1.Reg)&^(0x1f)|value)
}
func (o *SLCD_Type) GetFC1_OVF() uint8 {
	return volatile.LoadUint8(&o.FC1.Reg) & 0x1f
}
func (o *SLCD_Type) SetFC1_PB(value uint8) {
	volatile.StoreUint8(&o.FC1.Reg, volatile.LoadUint8(&o.FC1.Reg)&^(0x80)|value<<7)
}
func (o *SLCD_Type) GetFC1_PB() uint8 {
	return (volatile.LoadUint8(&o.FC1.Reg) & 0x80) >> 7
}

// SLCD.FC2: Frame Counter 2 Configuration
func (o *SLCD_Type) SetFC2_OVF(value uint8) {
	volatile.StoreUint8(&o.FC2.Reg, volatile.LoadUint8(&o.FC2.Reg)&^(0x1f)|value)
}
func (o *SLCD_Type) GetFC2_OVF() uint8 {
	return volatile.LoadUint8(&o.FC2.Reg) & 0x1f
}
func (o *SLCD_Type) SetFC2_PB(value uint8) {
	volatile.StoreUint8(&o.FC2.Reg, volatile.LoadUint8(&o.FC2.Reg)&^(0x80)|value<<7)
}
func (o *SLCD_Type) GetFC2_PB() uint8 {
	return (volatile.LoadUint8(&o.FC2.Reg) & 0x80) >> 7
}

// SLCD.LPENL: LCD Pin Enable Low
func (o *SLCD_Type) SetLPENL(value uint32) {
	volatile.StoreUint32(&o.LPENL.Reg, value)
}
func (o *SLCD_Type) GetLPENL() uint32 {
	return volatile.LoadUint32(&o.LPENL.Reg)
}

// SLCD.LPENH: LCD Pin Enable High
func (o *SLCD_Type) SetLPENH_LPEN(value uint32) {
	volatile.StoreUint32(&o.LPENH.Reg, volatile.LoadUint32(&o.LPENH.Reg)&^(0xfffff)|value)
}
func (o *SLCD_Type) GetLPENH_LPEN() uint32 {
	return volatile.LoadUint32(&o.LPENH.Reg) & 0xfffff
}

// SLCD.SDATAL0: Segments Data Low for COM0 Line
func (o *SLCD_Type) SetSDATAL0(value uint32) {
	volatile.StoreUint32(&o.SDATAL0.Reg, value)
}
func (o *SLCD_Type) GetSDATAL0() uint32 {
	return volatile.LoadUint32(&o.SDATAL0.Reg)
}

// SLCD.SDATAH0: Segments Data High for COM0 Line
func (o *SLCD_Type) SetSDATAH0_SDATA(value uint32) {
	volatile.StoreUint32(&o.SDATAH0.Reg, volatile.LoadUint32(&o.SDATAH0.Reg)&^(0xfff)|value)
}
func (o *SLCD_Type) GetSDATAH0_SDATA() uint32 {
	return volatile.LoadUint32(&o.SDATAH0.Reg) & 0xfff
}

// SLCD.SDATAL1: Segments Data Low for COM1 Line
func (o *SLCD_Type) SetSDATAL1(value uint32) {
	volatile.StoreUint32(&o.SDATAL1.Reg, value)
}
func (o *SLCD_Type) GetSDATAL1() uint32 {
	return volatile.LoadUint32(&o.SDATAL1.Reg)
}

// SLCD.SDATAH1: Segments Data High for COM1 Line
func (o *SLCD_Type) SetSDATAH1_SDATA(value uint32) {
	volatile.StoreUint32(&o.SDATAH1.Reg, volatile.LoadUint32(&o.SDATAH1.Reg)&^(0xfff)|value)
}
func (o *SLCD_Type) GetSDATAH1_SDATA() uint32 {
	return volatile.LoadUint32(&o.SDATAH1.Reg) & 0xfff
}

// SLCD.SDATAL2: Segments Data Low for COM2 Line
func (o *SLCD_Type) SetSDATAL2(value uint32) {
	volatile.StoreUint32(&o.SDATAL2.Reg, value)
}
func (o *SLCD_Type) GetSDATAL2() uint32 {
	return volatile.LoadUint32(&o.SDATAL2.Reg)
}

// SLCD.SDATAH2: Segments Data High for COM2 Line
func (o *SLCD_Type) SetSDATAH2_SDATA(value uint32) {
	volatile.StoreUint32(&o.SDATAH2.Reg, volatile.LoadUint32(&o.SDATAH2.Reg)&^(0xfff)|value)
}
func (o *SLCD_Type) GetSDATAH2_SDATA() uint32 {
	return volatile.LoadUint32(&o.SDATAH2.Reg) & 0xfff
}

// SLCD.SDATAL3: Segments Data Low for COM3 Line
func (o *SLCD_Type) SetSDATAL3(value uint32) {
	volatile.StoreUint32(&o.SDATAL3.Reg, value)
}
func (o *SLCD_Type) GetSDATAL3() uint32 {
	return volatile.LoadUint32(&o.SDATAL3.Reg)
}

// SLCD.SDATAH3: Segments Data High for COM3 Line
func (o *SLCD_Type) SetSDATAH3_SDATA(value uint32) {
	volatile.StoreUint32(&o.SDATAH3.Reg, volatile.LoadUint32(&o.SDATAH3.Reg)&^(0xfff)|value)
}
func (o *SLCD_Type) GetSDATAH3_SDATA() uint32 {
	return volatile.LoadUint32(&o.SDATAH3.Reg) & 0xfff
}

// SLCD.SDATAL4: Segments Data Low for COM4 Line
func (o *SLCD_Type) SetSDATAL4(value uint32) {
	volatile.StoreUint32(&o.SDATAL4.Reg, value)
}
func (o *SLCD_Type) GetSDATAL4() uint32 {
	return volatile.LoadUint32(&o.SDATAL4.Reg)
}

// SLCD.SDATAH4: Segments Data High for COM4 Line
func (o *SLCD_Type) SetSDATAH4_SDATA(value uint32) {
	volatile.StoreUint32(&o.SDATAH4.Reg, volatile.LoadUint32(&o.SDATAH4.Reg)&^(0x3ff)|value)
}
func (o *SLCD_Type) GetSDATAH4_SDATA() uint32 {
	return volatile.LoadUint32(&o.SDATAH4.Reg) & 0x3ff
}

// SLCD.SDATAL5: Segments Data Low for COM5 Line
func (o *SLCD_Type) SetSDATAL5(value uint32) {
	volatile.StoreUint32(&o.SDATAL5.Reg, value)
}
func (o *SLCD_Type) GetSDATAL5() uint32 {
	return volatile.LoadUint32(&o.SDATAL5.Reg)
}

// SLCD.SDATAH5: Segments Data High for COM5 Line
func (o *SLCD_Type) SetSDATAH5_SDATA(value uint32) {
	volatile.StoreUint32(&o.SDATAH5.Reg, volatile.LoadUint32(&o.SDATAH5.Reg)&^(0x3ff)|value)
}
func (o *SLCD_Type) GetSDATAH5_SDATA() uint32 {
	return volatile.LoadUint32(&o.SDATAH5.Reg) & 0x3ff
}

// SLCD.SDATAL6: Segments Data Low for COM6 Line
func (o *SLCD_Type) SetSDATAL6(value uint32) {
	volatile.StoreUint32(&o.SDATAL6.Reg, value)
}
func (o *SLCD_Type) GetSDATAL6() uint32 {
	return volatile.LoadUint32(&o.SDATAL6.Reg)
}

// SLCD.SDATAH6: Segments Data High for COM6 Line
func (o *SLCD_Type) SetSDATAH6_SDATA(value uint32) {
	volatile.StoreUint32(&o.SDATAH6.Reg, volatile.LoadUint32(&o.SDATAH6.Reg)&^(0xff)|value)
}
func (o *SLCD_Type) GetSDATAH6_SDATA() uint32 {
	return volatile.LoadUint32(&o.SDATAH6.Reg) & 0xff
}

// SLCD.SDATAL7: Segments Data Low for COM7 Line
func (o *SLCD_Type) SetSDATAL7(value uint32) {
	volatile.StoreUint32(&o.SDATAL7.Reg, value)
}
func (o *SLCD_Type) GetSDATAL7() uint32 {
	return volatile.LoadUint32(&o.SDATAL7.Reg)
}

// SLCD.SDATAH7: Segments Data High for COM7 Line
func (o *SLCD_Type) SetSDATAH7_SDATA(value uint32) {
	volatile.StoreUint32(&o.SDATAH7.Reg, volatile.LoadUint32(&o.SDATAH7.Reg)&^(0xff)|value)
}
func (o *SLCD_Type) GetSDATAH7_SDATA() uint32 {
	return volatile.LoadUint32(&o.SDATAH7.Reg) & 0xff
}

// SLCD.ISDATA: Indirect Segments Data Access
func (o *SLCD_Type) SetISDATA_SDATA(value uint32) {
	volatile.StoreUint32(&o.ISDATA.Reg, volatile.LoadUint32(&o.ISDATA.Reg)&^(0xff)|value)
}
func (o *SLCD_Type) GetISDATA_SDATA() uint32 {
	return volatile.LoadUint32(&o.ISDATA.Reg) & 0xff
}
func (o *SLCD_Type) SetISDATA_SDMASK(value uint32) {
	volatile.StoreUint32(&o.ISDATA.Reg, volatile.LoadUint32(&o.ISDATA.Reg)&^(0xff00)|value<<8)
}
func (o *SLCD_Type) GetISDATA_SDMASK() uint32 {
	return (volatile.LoadUint32(&o.ISDATA.Reg) & 0xff00) >> 8
}
func (o *SLCD_Type) SetISDATA_OFF(value uint32) {
	volatile.StoreUint32(&o.ISDATA.Reg, volatile.LoadUint32(&o.ISDATA.Reg)&^(0x3f0000)|value<<16)
}
func (o *SLCD_Type) GetISDATA_OFF() uint32 {
	return (volatile.LoadUint32(&o.ISDATA.Reg) & 0x3f0000) >> 16
}

// SLCD.BCFG: Blink Configuration
func (o *SLCD_Type) SetBCFG_MODE(value uint32) {
	volatile.StoreUint32(&o.BCFG.Reg, volatile.LoadUint32(&o.BCFG.Reg)&^(0x1)|value)
}
func (o *SLCD_Type) GetBCFG_MODE() uint32 {
	return volatile.LoadUint32(&o.BCFG.Reg) & 0x1
}
func (o *SLCD_Type) SetBCFG_FCS(value uint32) {
	volatile.StoreUint32(&o.BCFG.Reg, volatile.LoadUint32(&o.BCFG.Reg)&^(0x6)|value<<1)
}
func (o *SLCD_Type) GetBCFG_FCS() uint32 {
	return (volatile.LoadUint32(&o.BCFG.Reg) & 0x6) >> 1
}
func (o *SLCD_Type) SetBCFG_BSS0(value uint32) {
	volatile.StoreUint32(&o.BCFG.Reg, volatile.LoadUint32(&o.BCFG.Reg)&^(0xff00)|value<<8)
}
func (o *SLCD_Type) GetBCFG_BSS0() uint32 {
	return (volatile.LoadUint32(&o.BCFG.Reg) & 0xff00) >> 8
}
func (o *SLCD_Type) SetBCFG_BSS1(value uint32) {
	volatile.StoreUint32(&o.BCFG.Reg, volatile.LoadUint32(&o.BCFG.Reg)&^(0xff0000)|value<<16)
}
func (o *SLCD_Type) GetBCFG_BSS1() uint32 {
	return (volatile.LoadUint32(&o.BCFG.Reg) & 0xff0000) >> 16
}

// SLCD.CSRCFG: Circular Shift Register Configuration
func (o *SLCD_Type) SetCSRCFG_DIR(value uint32) {
	volatile.StoreUint32(&o.CSRCFG.Reg, volatile.LoadUint32(&o.CSRCFG.Reg)&^(0x1)|value)
}
func (o *SLCD_Type) GetCSRCFG_DIR() uint32 {
	return volatile.LoadUint32(&o.CSRCFG.Reg) & 0x1
}
func (o *SLCD_Type) SetCSRCFG_FCS(value uint32) {
	volatile.StoreUint32(&o.CSRCFG.Reg, volatile.LoadUint32(&o.CSRCFG.Reg)&^(0x6)|value<<1)
}
func (o *SLCD_Type) GetCSRCFG_FCS() uint32 {
	return (volatile.LoadUint32(&o.CSRCFG.Reg) & 0x6) >> 1
}
func (o *SLCD_Type) SetCSRCFG_SIZE(value uint32) {
	volatile.StoreUint32(&o.CSRCFG.Reg, volatile.LoadUint32(&o.CSRCFG.Reg)&^(0xf0)|value<<4)
}
func (o *SLCD_Type) GetCSRCFG_SIZE() uint32 {
	return (volatile.LoadUint32(&o.CSRCFG.Reg) & 0xf0) >> 4
}
func (o *SLCD_Type) SetCSRCFG_DATA(value uint32) {
	volatile.StoreUint32(&o.CSRCFG.Reg, volatile.LoadUint32(&o.CSRCFG.Reg)&^(0xffff00)|value<<8)
}
func (o *SLCD_Type) GetCSRCFG_DATA() uint32 {
	return (volatile.LoadUint32(&o.CSRCFG.Reg) & 0xffff00) >> 8
}

// SLCD.CMCFG: Character Mapping Configuration
func (o *SLCD_Type) SetCMCFG_NSEG(value uint8) {
	volatile.StoreUint8(&o.CMCFG.Reg, volatile.LoadUint8(&o.CMCFG.Reg)&^(0x7)|value)
}
func (o *SLCD_Type) GetCMCFG_NSEG() uint8 {
	return volatile.LoadUint8(&o.CMCFG.Reg) & 0x7
}
func (o *SLCD_Type) SetCMCFG_DEC(value uint8) {
	volatile.StoreUint8(&o.CMCFG.Reg, volatile.LoadUint8(&o.CMCFG.Reg)&^(0x8)|value<<3)
}
func (o *SLCD_Type) GetCMCFG_DEC() uint8 {
	return (volatile.LoadUint8(&o.CMCFG.Reg) & 0x8) >> 3
}

// SLCD.ACMCFG: Automated Character Mapping Configuration
func (o *SLCD_Type) SetACMCFG_NCOM(value uint32) {
	volatile.StoreUint32(&o.ACMCFG.Reg, volatile.LoadUint32(&o.ACMCFG.Reg)&^(0x7)|value)
}
func (o *SLCD_Type) GetACMCFG_NCOM() uint32 {
	return volatile.LoadUint32(&o.ACMCFG.Reg) & 0x7
}
func (o *SLCD_Type) SetACMCFG_NDIG(value uint32) {
	volatile.StoreUint32(&o.ACMCFG.Reg, volatile.LoadUint32(&o.ACMCFG.Reg)&^(0xf0)|value<<4)
}
func (o *SLCD_Type) GetACMCFG_NDIG() uint32 {
	return (volatile.LoadUint32(&o.ACMCFG.Reg) & 0xf0) >> 4
}
func (o *SLCD_Type) SetACMCFG_STEPS(value uint32) {
	volatile.StoreUint32(&o.ACMCFG.Reg, volatile.LoadUint32(&o.ACMCFG.Reg)&^(0xff00)|value<<8)
}
func (o *SLCD_Type) GetACMCFG_STEPS() uint32 {
	return (volatile.LoadUint32(&o.ACMCFG.Reg) & 0xff00) >> 8
}
func (o *SLCD_Type) SetACMCFG_NDROW(value uint32) {
	volatile.StoreUint32(&o.ACMCFG.Reg, volatile.LoadUint32(&o.ACMCFG.Reg)&^(0x3f0000)|value<<16)
}
func (o *SLCD_Type) GetACMCFG_NDROW() uint32 {
	return (volatile.LoadUint32(&o.ACMCFG.Reg) & 0x3f0000) >> 16
}
func (o *SLCD_Type) SetACMCFG_MODE(value uint32) {
	volatile.StoreUint32(&o.ACMCFG.Reg, volatile.LoadUint32(&o.ACMCFG.Reg)&^(0x800000)|value<<23)
}
func (o *SLCD_Type) GetACMCFG_MODE() uint32 {
	return (volatile.LoadUint32(&o.ACMCFG.Reg) & 0x800000) >> 23
}
func (o *SLCD_Type) SetACMCFG_STSEG(value uint32) {
	volatile.StoreUint32(&o.ACMCFG.Reg, volatile.LoadUint32(&o.ACMCFG.Reg)&^(0x3f000000)|value<<24)
}
func (o *SLCD_Type) GetACMCFG_STSEG() uint32 {
	return (volatile.LoadUint32(&o.ACMCFG.Reg) & 0x3f000000) >> 24
}
func (o *SLCD_Type) SetACMCFG_FCS(value uint32) {
	volatile.StoreUint32(&o.ACMCFG.Reg, volatile.LoadUint32(&o.ACMCFG.Reg)&^(0xc0000000)|value<<30)
}
func (o *SLCD_Type) GetACMCFG_FCS() uint32 {
	return (volatile.LoadUint32(&o.ACMCFG.Reg) & 0xc0000000) >> 30
}

// SLCD.ABMCFG: Automated Bit Mapping Configuration
func (o *SLCD_Type) SetABMCFG_FCS(value uint8) {
	volatile.StoreUint8(&o.ABMCFG.Reg, volatile.LoadUint8(&o.ABMCFG.Reg)&^(0x3)|value)
}
func (o *SLCD_Type) GetABMCFG_FCS() uint8 {
	return volatile.LoadUint8(&o.ABMCFG.Reg) & 0x3
}
func (o *SLCD_Type) SetABMCFG_SIZE(value uint8) {
	volatile.StoreUint8(&o.ABMCFG.Reg, volatile.LoadUint8(&o.ABMCFG.Reg)&^(0xfc)|value<<2)
}
func (o *SLCD_Type) GetABMCFG_SIZE() uint8 {
	return (volatile.LoadUint8(&o.ABMCFG.Reg) & 0xfc) >> 2
}

// SLCD.CMDATA: Character Mapping Segments Data
func (o *SLCD_Type) SetCMDATA_SDATA(value uint32) {
	volatile.StoreUint32(&o.CMDATA.Reg, volatile.LoadUint32(&o.CMDATA.Reg)&^(0xffffff)|value)
}
func (o *SLCD_Type) GetCMDATA_SDATA() uint32 {
	return volatile.LoadUint32(&o.CMDATA.Reg) & 0xffffff
}

// SLCD.CMDMASK: Character Mapping Segments Data Mask
func (o *SLCD_Type) SetCMDMASK_SDMASK(value uint32) {
	volatile.StoreUint32(&o.CMDMASK.Reg, volatile.LoadUint32(&o.CMDMASK.Reg)&^(0xffffff)|value)
}
func (o *SLCD_Type) GetCMDMASK_SDMASK() uint32 {
	return volatile.LoadUint32(&o.CMDMASK.Reg) & 0xffffff
}

// SLCD.CMINDEX: Character Mapping SEG/COM Index
func (o *SLCD_Type) SetCMINDEX_SINDEX(value uint16) {
	volatile.StoreUint16(&o.CMINDEX.Reg, volatile.LoadUint16(&o.CMINDEX.Reg)&^(0x3f)|value)
}
func (o *SLCD_Type) GetCMINDEX_SINDEX() uint16 {
	return volatile.LoadUint16(&o.CMINDEX.Reg) & 0x3f
}
func (o *SLCD_Type) SetCMINDEX_CINDEX(value uint16) {
	volatile.StoreUint16(&o.CMINDEX.Reg, volatile.LoadUint16(&o.CMINDEX.Reg)&^(0x700)|value<<8)
}
func (o *SLCD_Type) GetCMINDEX_CINDEX() uint16 {
	return (volatile.LoadUint16(&o.CMINDEX.Reg) & 0x700) >> 8
}

// Supply Controller
type SUPC_Type struct {
	INTENCLR volatile.Register32 // 0x0
	INTENSET volatile.Register32 // 0x4
	INTFLAG  volatile.Register32 // 0x8
	STATUS   volatile.Register32 // 0xC
	BOD33    volatile.Register32 // 0x10
	BOD12    volatile.Register32 // 0x14
	VREG     volatile.Register32 // 0x18
	VREF     volatile.Register32 // 0x1C
	BBPS     volatile.Register32 // 0x20
	BKOUT    volatile.Register32 // 0x24
	BKIN     volatile.Register32 // 0x28
}

// SUPC.INTENCLR: Interrupt Enable Clear
func (o *SUPC_Type) SetINTENCLR_BOD33RDY(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *SUPC_Type) GetINTENCLR_BOD33RDY() uint32 {
	return volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1
}
func (o *SUPC_Type) SetINTENCLR_BOD33DET(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *SUPC_Type) GetINTENCLR_BOD33DET() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *SUPC_Type) SetINTENCLR_B33SRDY(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x4)|value<<2)
}
func (o *SUPC_Type) GetINTENCLR_B33SRDY() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x4) >> 2
}
func (o *SUPC_Type) SetINTENCLR_BOD12RDY(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x8)|value<<3)
}
func (o *SUPC_Type) GetINTENCLR_BOD12RDY() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x8) >> 3
}
func (o *SUPC_Type) SetINTENCLR_BOD12DET(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x10)|value<<4)
}
func (o *SUPC_Type) GetINTENCLR_BOD12DET() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x10) >> 4
}
func (o *SUPC_Type) SetINTENCLR_B12SRDY(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x20)|value<<5)
}
func (o *SUPC_Type) GetINTENCLR_B12SRDY() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x20) >> 5
}
func (o *SUPC_Type) SetINTENCLR_VREGRDY(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x100)|value<<8)
}
func (o *SUPC_Type) GetINTENCLR_VREGRDY() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x100) >> 8
}
func (o *SUPC_Type) SetINTENCLR_APWSRDY(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x200)|value<<9)
}
func (o *SUPC_Type) GetINTENCLR_APWSRDY() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x200) >> 9
}
func (o *SUPC_Type) SetINTENCLR_VCORERDY(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x400)|value<<10)
}
func (o *SUPC_Type) GetINTENCLR_VCORERDY() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x400) >> 10
}

// SUPC.INTENSET: Interrupt Enable Set
func (o *SUPC_Type) SetINTENSET_BOD33RDY(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *SUPC_Type) GetINTENSET_BOD33RDY() uint32 {
	return volatile.LoadUint32(&o.INTENSET.Reg) & 0x1
}
func (o *SUPC_Type) SetINTENSET_BOD33DET(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *SUPC_Type) GetINTENSET_BOD33DET() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *SUPC_Type) SetINTENSET_B33SRDY(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x4)|value<<2)
}
func (o *SUPC_Type) GetINTENSET_B33SRDY() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x4) >> 2
}
func (o *SUPC_Type) SetINTENSET_BOD12RDY(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x8)|value<<3)
}
func (o *SUPC_Type) GetINTENSET_BOD12RDY() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x8) >> 3
}
func (o *SUPC_Type) SetINTENSET_BOD12DET(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x10)|value<<4)
}
func (o *SUPC_Type) GetINTENSET_BOD12DET() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x10) >> 4
}
func (o *SUPC_Type) SetINTENSET_B12SRDY(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x20)|value<<5)
}
func (o *SUPC_Type) GetINTENSET_B12SRDY() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x20) >> 5
}
func (o *SUPC_Type) SetINTENSET_VREGRDY(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x100)|value<<8)
}
func (o *SUPC_Type) GetINTENSET_VREGRDY() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x100) >> 8
}
func (o *SUPC_Type) SetINTENSET_APWSRDY(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x200)|value<<9)
}
func (o *SUPC_Type) GetINTENSET_APWSRDY() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x200) >> 9
}
func (o *SUPC_Type) SetINTENSET_VCORERDY(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x400)|value<<10)
}
func (o *SUPC_Type) GetINTENSET_VCORERDY() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x400) >> 10
}

// SUPC.INTFLAG: Interrupt Flag Status and Clear
func (o *SUPC_Type) SetINTFLAG_BOD33RDY(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x1)|value)
}
func (o *SUPC_Type) GetINTFLAG_BOD33RDY() uint32 {
	return volatile.LoadUint32(&o.INTFLAG.Reg) & 0x1
}
func (o *SUPC_Type) SetINTFLAG_BOD33DET(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x2)|value<<1)
}
func (o *SUPC_Type) GetINTFLAG_BOD33DET() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x2) >> 1
}
func (o *SUPC_Type) SetINTFLAG_B33SRDY(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x4)|value<<2)
}
func (o *SUPC_Type) GetINTFLAG_B33SRDY() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x4) >> 2
}
func (o *SUPC_Type) SetINTFLAG_BOD12RDY(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x8)|value<<3)
}
func (o *SUPC_Type) GetINTFLAG_BOD12RDY() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x8) >> 3
}
func (o *SUPC_Type) SetINTFLAG_BOD12DET(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x10)|value<<4)
}
func (o *SUPC_Type) GetINTFLAG_BOD12DET() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x10) >> 4
}
func (o *SUPC_Type) SetINTFLAG_B12SRDY(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x20)|value<<5)
}
func (o *SUPC_Type) GetINTFLAG_B12SRDY() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x20) >> 5
}
func (o *SUPC_Type) SetINTFLAG_VREGRDY(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x100)|value<<8)
}
func (o *SUPC_Type) GetINTFLAG_VREGRDY() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x100) >> 8
}
func (o *SUPC_Type) SetINTFLAG_APWSRDY(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x200)|value<<9)
}
func (o *SUPC_Type) GetINTFLAG_APWSRDY() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x200) >> 9
}
func (o *SUPC_Type) SetINTFLAG_VCORERDY(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x400)|value<<10)
}
func (o *SUPC_Type) GetINTFLAG_VCORERDY() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x400) >> 10
}

// SUPC.STATUS: Power and Clocks Status
func (o *SUPC_Type) SetSTATUS_BOD33RDY(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x1)|value)
}
func (o *SUPC_Type) GetSTATUS_BOD33RDY() uint32 {
	return volatile.LoadUint32(&o.STATUS.Reg) & 0x1
}
func (o *SUPC_Type) SetSTATUS_BOD33DET(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x2)|value<<1)
}
func (o *SUPC_Type) GetSTATUS_BOD33DET() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x2) >> 1
}
func (o *SUPC_Type) SetSTATUS_B33SRDY(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x4)|value<<2)
}
func (o *SUPC_Type) GetSTATUS_B33SRDY() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x4) >> 2
}
func (o *SUPC_Type) SetSTATUS_BOD12RDY(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x8)|value<<3)
}
func (o *SUPC_Type) GetSTATUS_BOD12RDY() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x8) >> 3
}
func (o *SUPC_Type) SetSTATUS_BOD12DET(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x10)|value<<4)
}
func (o *SUPC_Type) GetSTATUS_BOD12DET() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x10) >> 4
}
func (o *SUPC_Type) SetSTATUS_B12SRDY(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x20)|value<<5)
}
func (o *SUPC_Type) GetSTATUS_B12SRDY() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x20) >> 5
}
func (o *SUPC_Type) SetSTATUS_VREGRDY(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x100)|value<<8)
}
func (o *SUPC_Type) GetSTATUS_VREGRDY() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x100) >> 8
}
func (o *SUPC_Type) SetSTATUS_APWSRDY(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x200)|value<<9)
}
func (o *SUPC_Type) GetSTATUS_APWSRDY() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x200) >> 9
}
func (o *SUPC_Type) SetSTATUS_VCORERDY(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x400)|value<<10)
}
func (o *SUPC_Type) GetSTATUS_VCORERDY() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x400) >> 10
}
func (o *SUPC_Type) SetSTATUS_BBPS(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x800)|value<<11)
}
func (o *SUPC_Type) GetSTATUS_BBPS() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x800) >> 11
}

// SUPC.BOD33: BOD33 Control
func (o *SUPC_Type) SetBOD33_ENABLE(value uint32) {
	volatile.StoreUint32(&o.BOD33.Reg, volatile.LoadUint32(&o.BOD33.Reg)&^(0x2)|value<<1)
}
func (o *SUPC_Type) GetBOD33_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.BOD33.Reg) & 0x2) >> 1
}
func (o *SUPC_Type) SetBOD33_HYST(value uint32) {
	volatile.StoreUint32(&o.BOD33.Reg, volatile.LoadUint32(&o.BOD33.Reg)&^(0x4)|value<<2)
}
func (o *SUPC_Type) GetBOD33_HYST() uint32 {
	return (volatile.LoadUint32(&o.BOD33.Reg) & 0x4) >> 2
}
func (o *SUPC_Type) SetBOD33_ACTION(value uint32) {
	volatile.StoreUint32(&o.BOD33.Reg, volatile.LoadUint32(&o.BOD33.Reg)&^(0x18)|value<<3)
}
func (o *SUPC_Type) GetBOD33_ACTION() uint32 {
	return (volatile.LoadUint32(&o.BOD33.Reg) & 0x18) >> 3
}
func (o *SUPC_Type) SetBOD33_STDBYCFG(value uint32) {
	volatile.StoreUint32(&o.BOD33.Reg, volatile.LoadUint32(&o.BOD33.Reg)&^(0x20)|value<<5)
}
func (o *SUPC_Type) GetBOD33_STDBYCFG() uint32 {
	return (volatile.LoadUint32(&o.BOD33.Reg) & 0x20) >> 5
}
func (o *SUPC_Type) SetBOD33_RUNSTDBY(value uint32) {
	volatile.StoreUint32(&o.BOD33.Reg, volatile.LoadUint32(&o.BOD33.Reg)&^(0x40)|value<<6)
}
func (o *SUPC_Type) GetBOD33_RUNSTDBY() uint32 {
	return (volatile.LoadUint32(&o.BOD33.Reg) & 0x40) >> 6
}
func (o *SUPC_Type) SetBOD33_RUNBKUP(value uint32) {
	volatile.StoreUint32(&o.BOD33.Reg, volatile.LoadUint32(&o.BOD33.Reg)&^(0x80)|value<<7)
}
func (o *SUPC_Type) GetBOD33_RUNBKUP() uint32 {
	return (volatile.LoadUint32(&o.BOD33.Reg) & 0x80) >> 7
}
func (o *SUPC_Type) SetBOD33_ACTCFG(value uint32) {
	volatile.StoreUint32(&o.BOD33.Reg, volatile.LoadUint32(&o.BOD33.Reg)&^(0x100)|value<<8)
}
func (o *SUPC_Type) GetBOD33_ACTCFG() uint32 {
	return (volatile.LoadUint32(&o.BOD33.Reg) & 0x100) >> 8
}
func (o *SUPC_Type) SetBOD33_VMON(value uint32) {
	volatile.StoreUint32(&o.BOD33.Reg, volatile.LoadUint32(&o.BOD33.Reg)&^(0x400)|value<<10)
}
func (o *SUPC_Type) GetBOD33_VMON() uint32 {
	return (volatile.LoadUint32(&o.BOD33.Reg) & 0x400) >> 10
}
func (o *SUPC_Type) SetBOD33_PSEL(value uint32) {
	volatile.StoreUint32(&o.BOD33.Reg, volatile.LoadUint32(&o.BOD33.Reg)&^(0xf000)|value<<12)
}
func (o *SUPC_Type) GetBOD33_PSEL() uint32 {
	return (volatile.LoadUint32(&o.BOD33.Reg) & 0xf000) >> 12
}
func (o *SUPC_Type) SetBOD33_LEVEL(value uint32) {
	volatile.StoreUint32(&o.BOD33.Reg, volatile.LoadUint32(&o.BOD33.Reg)&^(0x3f0000)|value<<16)
}
func (o *SUPC_Type) GetBOD33_LEVEL() uint32 {
	return (volatile.LoadUint32(&o.BOD33.Reg) & 0x3f0000) >> 16
}
func (o *SUPC_Type) SetBOD33_BKUPLEVEL(value uint32) {
	volatile.StoreUint32(&o.BOD33.Reg, volatile.LoadUint32(&o.BOD33.Reg)&^(0x3f000000)|value<<24)
}
func (o *SUPC_Type) GetBOD33_BKUPLEVEL() uint32 {
	return (volatile.LoadUint32(&o.BOD33.Reg) & 0x3f000000) >> 24
}

// SUPC.BOD12: BOD12 Control
func (o *SUPC_Type) SetBOD12_ENABLE(value uint32) {
	volatile.StoreUint32(&o.BOD12.Reg, volatile.LoadUint32(&o.BOD12.Reg)&^(0x2)|value<<1)
}
func (o *SUPC_Type) GetBOD12_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.BOD12.Reg) & 0x2) >> 1
}
func (o *SUPC_Type) SetBOD12_HYST(value uint32) {
	volatile.StoreUint32(&o.BOD12.Reg, volatile.LoadUint32(&o.BOD12.Reg)&^(0x4)|value<<2)
}
func (o *SUPC_Type) GetBOD12_HYST() uint32 {
	return (volatile.LoadUint32(&o.BOD12.Reg) & 0x4) >> 2
}
func (o *SUPC_Type) SetBOD12_ACTION(value uint32) {
	volatile.StoreUint32(&o.BOD12.Reg, volatile.LoadUint32(&o.BOD12.Reg)&^(0x18)|value<<3)
}
func (o *SUPC_Type) GetBOD12_ACTION() uint32 {
	return (volatile.LoadUint32(&o.BOD12.Reg) & 0x18) >> 3
}
func (o *SUPC_Type) SetBOD12_STDBYCFG(value uint32) {
	volatile.StoreUint32(&o.BOD12.Reg, volatile.LoadUint32(&o.BOD12.Reg)&^(0x20)|value<<5)
}
func (o *SUPC_Type) GetBOD12_STDBYCFG() uint32 {
	return (volatile.LoadUint32(&o.BOD12.Reg) & 0x20) >> 5
}
func (o *SUPC_Type) SetBOD12_RUNSTDBY(value uint32) {
	volatile.StoreUint32(&o.BOD12.Reg, volatile.LoadUint32(&o.BOD12.Reg)&^(0x40)|value<<6)
}
func (o *SUPC_Type) GetBOD12_RUNSTDBY() uint32 {
	return (volatile.LoadUint32(&o.BOD12.Reg) & 0x40) >> 6
}
func (o *SUPC_Type) SetBOD12_ACTCFG(value uint32) {
	volatile.StoreUint32(&o.BOD12.Reg, volatile.LoadUint32(&o.BOD12.Reg)&^(0x100)|value<<8)
}
func (o *SUPC_Type) GetBOD12_ACTCFG() uint32 {
	return (volatile.LoadUint32(&o.BOD12.Reg) & 0x100) >> 8
}
func (o *SUPC_Type) SetBOD12_PSEL(value uint32) {
	volatile.StoreUint32(&o.BOD12.Reg, volatile.LoadUint32(&o.BOD12.Reg)&^(0xf000)|value<<12)
}
func (o *SUPC_Type) GetBOD12_PSEL() uint32 {
	return (volatile.LoadUint32(&o.BOD12.Reg) & 0xf000) >> 12
}
func (o *SUPC_Type) SetBOD12_LEVEL(value uint32) {
	volatile.StoreUint32(&o.BOD12.Reg, volatile.LoadUint32(&o.BOD12.Reg)&^(0x3f0000)|value<<16)
}
func (o *SUPC_Type) GetBOD12_LEVEL() uint32 {
	return (volatile.LoadUint32(&o.BOD12.Reg) & 0x3f0000) >> 16
}

// SUPC.VREG: VREG Control
func (o *SUPC_Type) SetVREG_ENABLE(value uint32) {
	volatile.StoreUint32(&o.VREG.Reg, volatile.LoadUint32(&o.VREG.Reg)&^(0x2)|value<<1)
}
func (o *SUPC_Type) GetVREG_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.VREG.Reg) & 0x2) >> 1
}
func (o *SUPC_Type) SetVREG_SEL(value uint32) {
	volatile.StoreUint32(&o.VREG.Reg, volatile.LoadUint32(&o.VREG.Reg)&^(0xc)|value<<2)
}
func (o *SUPC_Type) GetVREG_SEL() uint32 {
	return (volatile.LoadUint32(&o.VREG.Reg) & 0xc) >> 2
}
func (o *SUPC_Type) SetVREG_STDBYPL0(value uint32) {
	volatile.StoreUint32(&o.VREG.Reg, volatile.LoadUint32(&o.VREG.Reg)&^(0x20)|value<<5)
}
func (o *SUPC_Type) GetVREG_STDBYPL0() uint32 {
	return (volatile.LoadUint32(&o.VREG.Reg) & 0x20) >> 5
}
func (o *SUPC_Type) SetVREG_RUNSTDBY(value uint32) {
	volatile.StoreUint32(&o.VREG.Reg, volatile.LoadUint32(&o.VREG.Reg)&^(0x40)|value<<6)
}
func (o *SUPC_Type) GetVREG_RUNSTDBY() uint32 {
	return (volatile.LoadUint32(&o.VREG.Reg) & 0x40) >> 6
}
func (o *SUPC_Type) SetVREG_LPEFF(value uint32) {
	volatile.StoreUint32(&o.VREG.Reg, volatile.LoadUint32(&o.VREG.Reg)&^(0x100)|value<<8)
}
func (o *SUPC_Type) GetVREG_LPEFF() uint32 {
	return (volatile.LoadUint32(&o.VREG.Reg) & 0x100) >> 8
}
func (o *SUPC_Type) SetVREG_VSVSTEP(value uint32) {
	volatile.StoreUint32(&o.VREG.Reg, volatile.LoadUint32(&o.VREG.Reg)&^(0xf0000)|value<<16)
}
func (o *SUPC_Type) GetVREG_VSVSTEP() uint32 {
	return (volatile.LoadUint32(&o.VREG.Reg) & 0xf0000) >> 16
}
func (o *SUPC_Type) SetVREG_VSPER(value uint32) {
	volatile.StoreUint32(&o.VREG.Reg, volatile.LoadUint32(&o.VREG.Reg)&^(0xff000000)|value<<24)
}
func (o *SUPC_Type) GetVREG_VSPER() uint32 {
	return (volatile.LoadUint32(&o.VREG.Reg) & 0xff000000) >> 24
}

// SUPC.VREF: VREF Control
func (o *SUPC_Type) SetVREF_TSEN(value uint32) {
	volatile.StoreUint32(&o.VREF.Reg, volatile.LoadUint32(&o.VREF.Reg)&^(0x2)|value<<1)
}
func (o *SUPC_Type) GetVREF_TSEN() uint32 {
	return (volatile.LoadUint32(&o.VREF.Reg) & 0x2) >> 1
}
func (o *SUPC_Type) SetVREF_VREFOE(value uint32) {
	volatile.StoreUint32(&o.VREF.Reg, volatile.LoadUint32(&o.VREF.Reg)&^(0x4)|value<<2)
}
func (o *SUPC_Type) GetVREF_VREFOE() uint32 {
	return (volatile.LoadUint32(&o.VREF.Reg) & 0x4) >> 2
}
func (o *SUPC_Type) SetVREF_TSSEL(value uint32) {
	volatile.StoreUint32(&o.VREF.Reg, volatile.LoadUint32(&o.VREF.Reg)&^(0x8)|value<<3)
}
func (o *SUPC_Type) GetVREF_TSSEL() uint32 {
	return (volatile.LoadUint32(&o.VREF.Reg) & 0x8) >> 3
}
func (o *SUPC_Type) SetVREF_RUNSTDBY(value uint32) {
	volatile.StoreUint32(&o.VREF.Reg, volatile.LoadUint32(&o.VREF.Reg)&^(0x40)|value<<6)
}
func (o *SUPC_Type) GetVREF_RUNSTDBY() uint32 {
	return (volatile.LoadUint32(&o.VREF.Reg) & 0x40) >> 6
}
func (o *SUPC_Type) SetVREF_ONDEMAND(value uint32) {
	volatile.StoreUint32(&o.VREF.Reg, volatile.LoadUint32(&o.VREF.Reg)&^(0x80)|value<<7)
}
func (o *SUPC_Type) GetVREF_ONDEMAND() uint32 {
	return (volatile.LoadUint32(&o.VREF.Reg) & 0x80) >> 7
}
func (o *SUPC_Type) SetVREF_SEL(value uint32) {
	volatile.StoreUint32(&o.VREF.Reg, volatile.LoadUint32(&o.VREF.Reg)&^(0xf0000)|value<<16)
}
func (o *SUPC_Type) GetVREF_SEL() uint32 {
	return (volatile.LoadUint32(&o.VREF.Reg) & 0xf0000) >> 16
}

// SUPC.BBPS: Battery Backup Power Switch
func (o *SUPC_Type) SetBBPS_CONF(value uint32) {
	volatile.StoreUint32(&o.BBPS.Reg, volatile.LoadUint32(&o.BBPS.Reg)&^(0x3)|value)
}
func (o *SUPC_Type) GetBBPS_CONF() uint32 {
	return volatile.LoadUint32(&o.BBPS.Reg) & 0x3
}
func (o *SUPC_Type) SetBBPS_WAKEEN(value uint32) {
	volatile.StoreUint32(&o.BBPS.Reg, volatile.LoadUint32(&o.BBPS.Reg)&^(0x4)|value<<2)
}
func (o *SUPC_Type) GetBBPS_WAKEEN() uint32 {
	return (volatile.LoadUint32(&o.BBPS.Reg) & 0x4) >> 2
}
func (o *SUPC_Type) SetBBPS_PSOKEN(value uint32) {
	volatile.StoreUint32(&o.BBPS.Reg, volatile.LoadUint32(&o.BBPS.Reg)&^(0x8)|value<<3)
}
func (o *SUPC_Type) GetBBPS_PSOKEN() uint32 {
	return (volatile.LoadUint32(&o.BBPS.Reg) & 0x8) >> 3
}

// SUPC.BKOUT: Backup Output Control
func (o *SUPC_Type) SetBKOUT_EN(value uint32) {
	volatile.StoreUint32(&o.BKOUT.Reg, volatile.LoadUint32(&o.BKOUT.Reg)&^(0x3)|value)
}
func (o *SUPC_Type) GetBKOUT_EN() uint32 {
	return volatile.LoadUint32(&o.BKOUT.Reg) & 0x3
}
func (o *SUPC_Type) SetBKOUT_CLR(value uint32) {
	volatile.StoreUint32(&o.BKOUT.Reg, volatile.LoadUint32(&o.BKOUT.Reg)&^(0x300)|value<<8)
}
func (o *SUPC_Type) GetBKOUT_CLR() uint32 {
	return (volatile.LoadUint32(&o.BKOUT.Reg) & 0x300) >> 8
}
func (o *SUPC_Type) SetBKOUT_SET(value uint32) {
	volatile.StoreUint32(&o.BKOUT.Reg, volatile.LoadUint32(&o.BKOUT.Reg)&^(0x30000)|value<<16)
}
func (o *SUPC_Type) GetBKOUT_SET() uint32 {
	return (volatile.LoadUint32(&o.BKOUT.Reg) & 0x30000) >> 16
}
func (o *SUPC_Type) SetBKOUT_RTCTGL(value uint32) {
	volatile.StoreUint32(&o.BKOUT.Reg, volatile.LoadUint32(&o.BKOUT.Reg)&^(0x3000000)|value<<24)
}
func (o *SUPC_Type) GetBKOUT_RTCTGL() uint32 {
	return (volatile.LoadUint32(&o.BKOUT.Reg) & 0x3000000) >> 24
}

// SUPC.BKIN: Backup Input Control
func (o *SUPC_Type) SetBKIN(value uint32) {
	volatile.StoreUint32(&o.BKIN.Reg, volatile.LoadUint32(&o.BKIN.Reg)&^(0xff)|value)
}
func (o *SUPC_Type) GetBKIN() uint32 {
	return volatile.LoadUint32(&o.BKIN.Reg) & 0xff
}

// Basic Timer Counter 0
type TC_Type struct {
}

// Basic Timer Counter 0 - COUNT8
type TC_COUNT8_Type struct {
	CTRLA    volatile.Register32 // 0x0
	CTRLBCLR volatile.Register8  // 0x4
	CTRLBSET volatile.Register8  // 0x5
	EVCTRL   volatile.Register16 // 0x6
	INTENCLR volatile.Register8  // 0x8
	INTENSET volatile.Register8  // 0x9
	INTFLAG  volatile.Register8  // 0xA
	STATUS   volatile.Register8  // 0xB
	WAVE     volatile.Register8  // 0xC
	DRVCTRL  volatile.Register8  // 0xD
	_        byte
	DBGCTRL  volatile.Register8  // 0xF
	SYNCBUSY volatile.Register32 // 0x10
	COUNT    volatile.Register8  // 0x14
	_        [6]byte
	PER      volatile.Register8 // 0x1B
	CC0      volatile.Register8 // 0x1C
	CC1      volatile.Register8 // 0x1D
	_        [17]byte
	PERBUF   volatile.Register8 // 0x2F
	CCBUF0   volatile.Register8 // 0x30
	CCBUF1   volatile.Register8 // 0x31
}

// TC_COUNT8.CTRLA: Control A
func (o *TC_COUNT8_Type) SetCTRLA_SWRST(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x1)|value)
}
func (o *TC_COUNT8_Type) GetCTRLA_SWRST() uint32 {
	return volatile.LoadUint32(&o.CTRLA.Reg) & 0x1
}
func (o *TC_COUNT8_Type) SetCTRLA_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x2)|value<<1)
}
func (o *TC_COUNT8_Type) GetCTRLA_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x2) >> 1
}
func (o *TC_COUNT8_Type) SetCTRLA_MODE(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0xc)|value<<2)
}
func (o *TC_COUNT8_Type) GetCTRLA_MODE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0xc) >> 2
}
func (o *TC_COUNT8_Type) SetCTRLA_PRESCSYNC(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x30)|value<<4)
}
func (o *TC_COUNT8_Type) GetCTRLA_PRESCSYNC() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x30) >> 4
}
func (o *TC_COUNT8_Type) SetCTRLA_RUNSTDBY(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x40)|value<<6)
}
func (o *TC_COUNT8_Type) GetCTRLA_RUNSTDBY() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x40) >> 6
}
func (o *TC_COUNT8_Type) SetCTRLA_ONDEMAND(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x80)|value<<7)
}
func (o *TC_COUNT8_Type) GetCTRLA_ONDEMAND() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x80) >> 7
}
func (o *TC_COUNT8_Type) SetCTRLA_PRESCALER(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x700)|value<<8)
}
func (o *TC_COUNT8_Type) GetCTRLA_PRESCALER() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x700) >> 8
}
func (o *TC_COUNT8_Type) SetCTRLA_ALOCK(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x800)|value<<11)
}
func (o *TC_COUNT8_Type) GetCTRLA_ALOCK() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x800) >> 11
}
func (o *TC_COUNT8_Type) SetCTRLA_CAPTEN0(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x10000)|value<<16)
}
func (o *TC_COUNT8_Type) GetCTRLA_CAPTEN0() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x10000) >> 16
}
func (o *TC_COUNT8_Type) SetCTRLA_CAPTEN1(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x20000)|value<<17)
}
func (o *TC_COUNT8_Type) GetCTRLA_CAPTEN1() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x20000) >> 17
}
func (o *TC_COUNT8_Type) SetCTRLA_COPEN0(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x100000)|value<<20)
}
func (o *TC_COUNT8_Type) GetCTRLA_COPEN0() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x100000) >> 20
}
func (o *TC_COUNT8_Type) SetCTRLA_COPEN1(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x200000)|value<<21)
}
func (o *TC_COUNT8_Type) GetCTRLA_COPEN1() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x200000) >> 21
}

// TC_COUNT8.CTRLBCLR: Control B Clear
func (o *TC_COUNT8_Type) SetCTRLBCLR_DIR(value uint8) {
	volatile.StoreUint8(&o.CTRLBCLR.Reg, volatile.LoadUint8(&o.CTRLBCLR.Reg)&^(0x1)|value)
}
func (o *TC_COUNT8_Type) GetCTRLBCLR_DIR() uint8 {
	return volatile.LoadUint8(&o.CTRLBCLR.Reg) & 0x1
}
func (o *TC_COUNT8_Type) SetCTRLBCLR_LUPD(value uint8) {
	volatile.StoreUint8(&o.CTRLBCLR.Reg, volatile.LoadUint8(&o.CTRLBCLR.Reg)&^(0x2)|value<<1)
}
func (o *TC_COUNT8_Type) GetCTRLBCLR_LUPD() uint8 {
	return (volatile.LoadUint8(&o.CTRLBCLR.Reg) & 0x2) >> 1
}
func (o *TC_COUNT8_Type) SetCTRLBCLR_ONESHOT(value uint8) {
	volatile.StoreUint8(&o.CTRLBCLR.Reg, volatile.LoadUint8(&o.CTRLBCLR.Reg)&^(0x4)|value<<2)
}
func (o *TC_COUNT8_Type) GetCTRLBCLR_ONESHOT() uint8 {
	return (volatile.LoadUint8(&o.CTRLBCLR.Reg) & 0x4) >> 2
}
func (o *TC_COUNT8_Type) SetCTRLBCLR_CMD(value uint8) {
	volatile.StoreUint8(&o.CTRLBCLR.Reg, volatile.LoadUint8(&o.CTRLBCLR.Reg)&^(0xe0)|value<<5)
}
func (o *TC_COUNT8_Type) GetCTRLBCLR_CMD() uint8 {
	return (volatile.LoadUint8(&o.CTRLBCLR.Reg) & 0xe0) >> 5
}

// TC_COUNT8.CTRLBSET: Control B Set
func (o *TC_COUNT8_Type) SetCTRLBSET_DIR(value uint8) {
	volatile.StoreUint8(&o.CTRLBSET.Reg, volatile.LoadUint8(&o.CTRLBSET.Reg)&^(0x1)|value)
}
func (o *TC_COUNT8_Type) GetCTRLBSET_DIR() uint8 {
	return volatile.LoadUint8(&o.CTRLBSET.Reg) & 0x1
}
func (o *TC_COUNT8_Type) SetCTRLBSET_LUPD(value uint8) {
	volatile.StoreUint8(&o.CTRLBSET.Reg, volatile.LoadUint8(&o.CTRLBSET.Reg)&^(0x2)|value<<1)
}
func (o *TC_COUNT8_Type) GetCTRLBSET_LUPD() uint8 {
	return (volatile.LoadUint8(&o.CTRLBSET.Reg) & 0x2) >> 1
}
func (o *TC_COUNT8_Type) SetCTRLBSET_ONESHOT(value uint8) {
	volatile.StoreUint8(&o.CTRLBSET.Reg, volatile.LoadUint8(&o.CTRLBSET.Reg)&^(0x4)|value<<2)
}
func (o *TC_COUNT8_Type) GetCTRLBSET_ONESHOT() uint8 {
	return (volatile.LoadUint8(&o.CTRLBSET.Reg) & 0x4) >> 2
}
func (o *TC_COUNT8_Type) SetCTRLBSET_CMD(value uint8) {
	volatile.StoreUint8(&o.CTRLBSET.Reg, volatile.LoadUint8(&o.CTRLBSET.Reg)&^(0xe0)|value<<5)
}
func (o *TC_COUNT8_Type) GetCTRLBSET_CMD() uint8 {
	return (volatile.LoadUint8(&o.CTRLBSET.Reg) & 0xe0) >> 5
}

// TC_COUNT8.EVCTRL: Event Control
func (o *TC_COUNT8_Type) SetEVCTRL_EVACT(value uint16) {
	volatile.StoreUint16(&o.EVCTRL.Reg, volatile.LoadUint16(&o.EVCTRL.Reg)&^(0x7)|value)
}
func (o *TC_COUNT8_Type) GetEVCTRL_EVACT() uint16 {
	return volatile.LoadUint16(&o.EVCTRL.Reg) & 0x7
}
func (o *TC_COUNT8_Type) SetEVCTRL_TCINV(value uint16) {
	volatile.StoreUint16(&o.EVCTRL.Reg, volatile.LoadUint16(&o.EVCTRL.Reg)&^(0x10)|value<<4)
}
func (o *TC_COUNT8_Type) GetEVCTRL_TCINV() uint16 {
	return (volatile.LoadUint16(&o.EVCTRL.Reg) & 0x10) >> 4
}
func (o *TC_COUNT8_Type) SetEVCTRL_TCEI(value uint16) {
	volatile.StoreUint16(&o.EVCTRL.Reg, volatile.LoadUint16(&o.EVCTRL.Reg)&^(0x20)|value<<5)
}
func (o *TC_COUNT8_Type) GetEVCTRL_TCEI() uint16 {
	return (volatile.LoadUint16(&o.EVCTRL.Reg) & 0x20) >> 5
}
func (o *TC_COUNT8_Type) SetEVCTRL_OVFEO(value uint16) {
	volatile.StoreUint16(&o.EVCTRL.Reg, volatile.LoadUint16(&o.EVCTRL.Reg)&^(0x100)|value<<8)
}
func (o *TC_COUNT8_Type) GetEVCTRL_OVFEO() uint16 {
	return (volatile.LoadUint16(&o.EVCTRL.Reg) & 0x100) >> 8
}
func (o *TC_COUNT8_Type) SetEVCTRL_MCEO0(value uint16) {
	volatile.StoreUint16(&o.EVCTRL.Reg, volatile.LoadUint16(&o.EVCTRL.Reg)&^(0x1000)|value<<12)
}
func (o *TC_COUNT8_Type) GetEVCTRL_MCEO0() uint16 {
	return (volatile.LoadUint16(&o.EVCTRL.Reg) & 0x1000) >> 12
}
func (o *TC_COUNT8_Type) SetEVCTRL_MCEO1(value uint16) {
	volatile.StoreUint16(&o.EVCTRL.Reg, volatile.LoadUint16(&o.EVCTRL.Reg)&^(0x2000)|value<<13)
}
func (o *TC_COUNT8_Type) GetEVCTRL_MCEO1() uint16 {
	return (volatile.LoadUint16(&o.EVCTRL.Reg) & 0x2000) >> 13
}

// TC_COUNT8.INTENCLR: Interrupt Enable Clear
func (o *TC_COUNT8_Type) SetINTENCLR_OVF(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *TC_COUNT8_Type) GetINTENCLR_OVF() uint8 {
	return volatile.LoadUint8(&o.INTENCLR.Reg) & 0x1
}
func (o *TC_COUNT8_Type) SetINTENCLR_ERR(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *TC_COUNT8_Type) GetINTENCLR_ERR() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *TC_COUNT8_Type) SetINTENCLR_MC0(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x10)|value<<4)
}
func (o *TC_COUNT8_Type) GetINTENCLR_MC0() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x10) >> 4
}
func (o *TC_COUNT8_Type) SetINTENCLR_MC1(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x20)|value<<5)
}
func (o *TC_COUNT8_Type) GetINTENCLR_MC1() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x20) >> 5
}

// TC_COUNT8.INTENSET: Interrupt Enable Set
func (o *TC_COUNT8_Type) SetINTENSET_OVF(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *TC_COUNT8_Type) GetINTENSET_OVF() uint8 {
	return volatile.LoadUint8(&o.INTENSET.Reg) & 0x1
}
func (o *TC_COUNT8_Type) SetINTENSET_ERR(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *TC_COUNT8_Type) GetINTENSET_ERR() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *TC_COUNT8_Type) SetINTENSET_MC0(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x10)|value<<4)
}
func (o *TC_COUNT8_Type) GetINTENSET_MC0() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x10) >> 4
}
func (o *TC_COUNT8_Type) SetINTENSET_MC1(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x20)|value<<5)
}
func (o *TC_COUNT8_Type) GetINTENSET_MC1() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x20) >> 5
}

// TC_COUNT8.INTFLAG: Interrupt Flag Status and Clear
func (o *TC_COUNT8_Type) SetINTFLAG_OVF(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x1)|value)
}
func (o *TC_COUNT8_Type) GetINTFLAG_OVF() uint8 {
	return volatile.LoadUint8(&o.INTFLAG.Reg) & 0x1
}
func (o *TC_COUNT8_Type) SetINTFLAG_ERR(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x2)|value<<1)
}
func (o *TC_COUNT8_Type) GetINTFLAG_ERR() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x2) >> 1
}
func (o *TC_COUNT8_Type) SetINTFLAG_MC0(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x10)|value<<4)
}
func (o *TC_COUNT8_Type) GetINTFLAG_MC0() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x10) >> 4
}
func (o *TC_COUNT8_Type) SetINTFLAG_MC1(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x20)|value<<5)
}
func (o *TC_COUNT8_Type) GetINTFLAG_MC1() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x20) >> 5
}

// TC_COUNT8.STATUS: Status
func (o *TC_COUNT8_Type) SetSTATUS_STOP(value uint8) {
	volatile.StoreUint8(&o.STATUS.Reg, volatile.LoadUint8(&o.STATUS.Reg)&^(0x1)|value)
}
func (o *TC_COUNT8_Type) GetSTATUS_STOP() uint8 {
	return volatile.LoadUint8(&o.STATUS.Reg) & 0x1
}
func (o *TC_COUNT8_Type) SetSTATUS_SLAVE(value uint8) {
	volatile.StoreUint8(&o.STATUS.Reg, volatile.LoadUint8(&o.STATUS.Reg)&^(0x2)|value<<1)
}
func (o *TC_COUNT8_Type) GetSTATUS_SLAVE() uint8 {
	return (volatile.LoadUint8(&o.STATUS.Reg) & 0x2) >> 1
}
func (o *TC_COUNT8_Type) SetSTATUS_PERBUFV(value uint8) {
	volatile.StoreUint8(&o.STATUS.Reg, volatile.LoadUint8(&o.STATUS.Reg)&^(0x8)|value<<3)
}
func (o *TC_COUNT8_Type) GetSTATUS_PERBUFV() uint8 {
	return (volatile.LoadUint8(&o.STATUS.Reg) & 0x8) >> 3
}
func (o *TC_COUNT8_Type) SetSTATUS_CCBUFV0(value uint8) {
	volatile.StoreUint8(&o.STATUS.Reg, volatile.LoadUint8(&o.STATUS.Reg)&^(0x10)|value<<4)
}
func (o *TC_COUNT8_Type) GetSTATUS_CCBUFV0() uint8 {
	return (volatile.LoadUint8(&o.STATUS.Reg) & 0x10) >> 4
}
func (o *TC_COUNT8_Type) SetSTATUS_CCBUFV1(value uint8) {
	volatile.StoreUint8(&o.STATUS.Reg, volatile.LoadUint8(&o.STATUS.Reg)&^(0x20)|value<<5)
}
func (o *TC_COUNT8_Type) GetSTATUS_CCBUFV1() uint8 {
	return (volatile.LoadUint8(&o.STATUS.Reg) & 0x20) >> 5
}

// TC_COUNT8.WAVE: Waveform Generation Control
func (o *TC_COUNT8_Type) SetWAVE_WAVEGEN(value uint8) {
	volatile.StoreUint8(&o.WAVE.Reg, volatile.LoadUint8(&o.WAVE.Reg)&^(0x3)|value)
}
func (o *TC_COUNT8_Type) GetWAVE_WAVEGEN() uint8 {
	return volatile.LoadUint8(&o.WAVE.Reg) & 0x3
}

// TC_COUNT8.DRVCTRL: Control C
func (o *TC_COUNT8_Type) SetDRVCTRL_INVEN0(value uint8) {
	volatile.StoreUint8(&o.DRVCTRL.Reg, volatile.LoadUint8(&o.DRVCTRL.Reg)&^(0x1)|value)
}
func (o *TC_COUNT8_Type) GetDRVCTRL_INVEN0() uint8 {
	return volatile.LoadUint8(&o.DRVCTRL.Reg) & 0x1
}
func (o *TC_COUNT8_Type) SetDRVCTRL_INVEN1(value uint8) {
	volatile.StoreUint8(&o.DRVCTRL.Reg, volatile.LoadUint8(&o.DRVCTRL.Reg)&^(0x2)|value<<1)
}
func (o *TC_COUNT8_Type) GetDRVCTRL_INVEN1() uint8 {
	return (volatile.LoadUint8(&o.DRVCTRL.Reg) & 0x2) >> 1
}

// TC_COUNT8.DBGCTRL: Debug Control
func (o *TC_COUNT8_Type) SetDBGCTRL_DBGRUN(value uint8) {
	volatile.StoreUint8(&o.DBGCTRL.Reg, volatile.LoadUint8(&o.DBGCTRL.Reg)&^(0x1)|value)
}
func (o *TC_COUNT8_Type) GetDBGCTRL_DBGRUN() uint8 {
	return volatile.LoadUint8(&o.DBGCTRL.Reg) & 0x1
}

// TC_COUNT8.SYNCBUSY: Synchronization Status
func (o *TC_COUNT8_Type) SetSYNCBUSY_SWRST(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x1)|value)
}
func (o *TC_COUNT8_Type) GetSYNCBUSY_SWRST() uint32 {
	return volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x1
}
func (o *TC_COUNT8_Type) SetSYNCBUSY_ENABLE(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x2)|value<<1)
}
func (o *TC_COUNT8_Type) GetSYNCBUSY_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x2) >> 1
}
func (o *TC_COUNT8_Type) SetSYNCBUSY_CTRLB(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x4)|value<<2)
}
func (o *TC_COUNT8_Type) GetSYNCBUSY_CTRLB() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x4) >> 2
}
func (o *TC_COUNT8_Type) SetSYNCBUSY_STATUS(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x8)|value<<3)
}
func (o *TC_COUNT8_Type) GetSYNCBUSY_STATUS() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x8) >> 3
}
func (o *TC_COUNT8_Type) SetSYNCBUSY_COUNT(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x10)|value<<4)
}
func (o *TC_COUNT8_Type) GetSYNCBUSY_COUNT() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x10) >> 4
}
func (o *TC_COUNT8_Type) SetSYNCBUSY_PER(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x20)|value<<5)
}
func (o *TC_COUNT8_Type) GetSYNCBUSY_PER() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x20) >> 5
}
func (o *TC_COUNT8_Type) SetSYNCBUSY_CC0(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x40)|value<<6)
}
func (o *TC_COUNT8_Type) GetSYNCBUSY_CC0() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x40) >> 6
}
func (o *TC_COUNT8_Type) SetSYNCBUSY_CC1(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x80)|value<<7)
}
func (o *TC_COUNT8_Type) GetSYNCBUSY_CC1() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x80) >> 7
}

// TC_COUNT8.COUNT: COUNT8 Count
func (o *TC_COUNT8_Type) SetCOUNT(value uint8) {
	volatile.StoreUint8(&o.COUNT.Reg, value)
}
func (o *TC_COUNT8_Type) GetCOUNT() uint8 {
	return volatile.LoadUint8(&o.COUNT.Reg)
}

// TC_COUNT8.PER: COUNT8 Period
func (o *TC_COUNT8_Type) SetPER(value uint8) {
	volatile.StoreUint8(&o.PER.Reg, value)
}
func (o *TC_COUNT8_Type) GetPER() uint8 {
	return volatile.LoadUint8(&o.PER.Reg)
}

// TC_COUNT8.CC0: COUNT8 Compare and Capture
func (o *TC_COUNT8_Type) SetCC0(value uint8) {
	volatile.StoreUint8(&o.CC0.Reg, value)
}
func (o *TC_COUNT8_Type) GetCC0() uint8 {
	return volatile.LoadUint8(&o.CC0.Reg)
}

// TC_COUNT8.CC1: COUNT8 Compare and Capture
func (o *TC_COUNT8_Type) SetCC1(value uint8) {
	volatile.StoreUint8(&o.CC1.Reg, value)
}
func (o *TC_COUNT8_Type) GetCC1() uint8 {
	return volatile.LoadUint8(&o.CC1.Reg)
}

// TC_COUNT8.PERBUF: COUNT8 Period Buffer
func (o *TC_COUNT8_Type) SetPERBUF(value uint8) {
	volatile.StoreUint8(&o.PERBUF.Reg, value)
}
func (o *TC_COUNT8_Type) GetPERBUF() uint8 {
	return volatile.LoadUint8(&o.PERBUF.Reg)
}

// TC_COUNT8.CCBUF0: COUNT8 Compare and Capture Buffer
func (o *TC_COUNT8_Type) SetCCBUF0(value uint8) {
	volatile.StoreUint8(&o.CCBUF0.Reg, value)
}
func (o *TC_COUNT8_Type) GetCCBUF0() uint8 {
	return volatile.LoadUint8(&o.CCBUF0.Reg)
}

// TC_COUNT8.CCBUF1: COUNT8 Compare and Capture Buffer
func (o *TC_COUNT8_Type) SetCCBUF1(value uint8) {
	volatile.StoreUint8(&o.CCBUF1.Reg, value)
}
func (o *TC_COUNT8_Type) GetCCBUF1() uint8 {
	return volatile.LoadUint8(&o.CCBUF1.Reg)
}

// Basic Timer Counter 0 - COUNT16
type TC_COUNT16_Type struct {
	CTRLA    volatile.Register32 // 0x0
	CTRLBCLR volatile.Register8  // 0x4
	CTRLBSET volatile.Register8  // 0x5
	EVCTRL   volatile.Register16 // 0x6
	INTENCLR volatile.Register8  // 0x8
	INTENSET volatile.Register8  // 0x9
	INTFLAG  volatile.Register8  // 0xA
	STATUS   volatile.Register8  // 0xB
	WAVE     volatile.Register8  // 0xC
	DRVCTRL  volatile.Register8  // 0xD
	_        byte
	DBGCTRL  volatile.Register8  // 0xF
	SYNCBUSY volatile.Register32 // 0x10
	COUNT    volatile.Register16 // 0x14
	_        [6]byte
	CC0      volatile.Register16 // 0x1C
	CC1      volatile.Register16 // 0x1E
	_        [16]byte
	CCBUF0   volatile.Register16 // 0x30
	CCBUF1   volatile.Register16 // 0x32
}

// TC_COUNT16.CTRLA: Control A
func (o *TC_COUNT16_Type) SetCTRLA_SWRST(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x1)|value)
}
func (o *TC_COUNT16_Type) GetCTRLA_SWRST() uint32 {
	return volatile.LoadUint32(&o.CTRLA.Reg) & 0x1
}
func (o *TC_COUNT16_Type) SetCTRLA_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x2)|value<<1)
}
func (o *TC_COUNT16_Type) GetCTRLA_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x2) >> 1
}
func (o *TC_COUNT16_Type) SetCTRLA_MODE(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0xc)|value<<2)
}
func (o *TC_COUNT16_Type) GetCTRLA_MODE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0xc) >> 2
}
func (o *TC_COUNT16_Type) SetCTRLA_PRESCSYNC(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x30)|value<<4)
}
func (o *TC_COUNT16_Type) GetCTRLA_PRESCSYNC() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x30) >> 4
}
func (o *TC_COUNT16_Type) SetCTRLA_RUNSTDBY(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x40)|value<<6)
}
func (o *TC_COUNT16_Type) GetCTRLA_RUNSTDBY() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x40) >> 6
}
func (o *TC_COUNT16_Type) SetCTRLA_ONDEMAND(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x80)|value<<7)
}
func (o *TC_COUNT16_Type) GetCTRLA_ONDEMAND() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x80) >> 7
}
func (o *TC_COUNT16_Type) SetCTRLA_PRESCALER(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x700)|value<<8)
}
func (o *TC_COUNT16_Type) GetCTRLA_PRESCALER() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x700) >> 8
}
func (o *TC_COUNT16_Type) SetCTRLA_ALOCK(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x800)|value<<11)
}
func (o *TC_COUNT16_Type) GetCTRLA_ALOCK() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x800) >> 11
}
func (o *TC_COUNT16_Type) SetCTRLA_CAPTEN0(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x10000)|value<<16)
}
func (o *TC_COUNT16_Type) GetCTRLA_CAPTEN0() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x10000) >> 16
}
func (o *TC_COUNT16_Type) SetCTRLA_CAPTEN1(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x20000)|value<<17)
}
func (o *TC_COUNT16_Type) GetCTRLA_CAPTEN1() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x20000) >> 17
}
func (o *TC_COUNT16_Type) SetCTRLA_COPEN0(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x100000)|value<<20)
}
func (o *TC_COUNT16_Type) GetCTRLA_COPEN0() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x100000) >> 20
}
func (o *TC_COUNT16_Type) SetCTRLA_COPEN1(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x200000)|value<<21)
}
func (o *TC_COUNT16_Type) GetCTRLA_COPEN1() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x200000) >> 21
}

// TC_COUNT16.CTRLBCLR: Control B Clear
func (o *TC_COUNT16_Type) SetCTRLBCLR_DIR(value uint8) {
	volatile.StoreUint8(&o.CTRLBCLR.Reg, volatile.LoadUint8(&o.CTRLBCLR.Reg)&^(0x1)|value)
}
func (o *TC_COUNT16_Type) GetCTRLBCLR_DIR() uint8 {
	return volatile.LoadUint8(&o.CTRLBCLR.Reg) & 0x1
}
func (o *TC_COUNT16_Type) SetCTRLBCLR_LUPD(value uint8) {
	volatile.StoreUint8(&o.CTRLBCLR.Reg, volatile.LoadUint8(&o.CTRLBCLR.Reg)&^(0x2)|value<<1)
}
func (o *TC_COUNT16_Type) GetCTRLBCLR_LUPD() uint8 {
	return (volatile.LoadUint8(&o.CTRLBCLR.Reg) & 0x2) >> 1
}
func (o *TC_COUNT16_Type) SetCTRLBCLR_ONESHOT(value uint8) {
	volatile.StoreUint8(&o.CTRLBCLR.Reg, volatile.LoadUint8(&o.CTRLBCLR.Reg)&^(0x4)|value<<2)
}
func (o *TC_COUNT16_Type) GetCTRLBCLR_ONESHOT() uint8 {
	return (volatile.LoadUint8(&o.CTRLBCLR.Reg) & 0x4) >> 2
}
func (o *TC_COUNT16_Type) SetCTRLBCLR_CMD(value uint8) {
	volatile.StoreUint8(&o.CTRLBCLR.Reg, volatile.LoadUint8(&o.CTRLBCLR.Reg)&^(0xe0)|value<<5)
}
func (o *TC_COUNT16_Type) GetCTRLBCLR_CMD() uint8 {
	return (volatile.LoadUint8(&o.CTRLBCLR.Reg) & 0xe0) >> 5
}

// TC_COUNT16.CTRLBSET: Control B Set
func (o *TC_COUNT16_Type) SetCTRLBSET_DIR(value uint8) {
	volatile.StoreUint8(&o.CTRLBSET.Reg, volatile.LoadUint8(&o.CTRLBSET.Reg)&^(0x1)|value)
}
func (o *TC_COUNT16_Type) GetCTRLBSET_DIR() uint8 {
	return volatile.LoadUint8(&o.CTRLBSET.Reg) & 0x1
}
func (o *TC_COUNT16_Type) SetCTRLBSET_LUPD(value uint8) {
	volatile.StoreUint8(&o.CTRLBSET.Reg, volatile.LoadUint8(&o.CTRLBSET.Reg)&^(0x2)|value<<1)
}
func (o *TC_COUNT16_Type) GetCTRLBSET_LUPD() uint8 {
	return (volatile.LoadUint8(&o.CTRLBSET.Reg) & 0x2) >> 1
}
func (o *TC_COUNT16_Type) SetCTRLBSET_ONESHOT(value uint8) {
	volatile.StoreUint8(&o.CTRLBSET.Reg, volatile.LoadUint8(&o.CTRLBSET.Reg)&^(0x4)|value<<2)
}
func (o *TC_COUNT16_Type) GetCTRLBSET_ONESHOT() uint8 {
	return (volatile.LoadUint8(&o.CTRLBSET.Reg) & 0x4) >> 2
}
func (o *TC_COUNT16_Type) SetCTRLBSET_CMD(value uint8) {
	volatile.StoreUint8(&o.CTRLBSET.Reg, volatile.LoadUint8(&o.CTRLBSET.Reg)&^(0xe0)|value<<5)
}
func (o *TC_COUNT16_Type) GetCTRLBSET_CMD() uint8 {
	return (volatile.LoadUint8(&o.CTRLBSET.Reg) & 0xe0) >> 5
}

// TC_COUNT16.EVCTRL: Event Control
func (o *TC_COUNT16_Type) SetEVCTRL_EVACT(value uint16) {
	volatile.StoreUint16(&o.EVCTRL.Reg, volatile.LoadUint16(&o.EVCTRL.Reg)&^(0x7)|value)
}
func (o *TC_COUNT16_Type) GetEVCTRL_EVACT() uint16 {
	return volatile.LoadUint16(&o.EVCTRL.Reg) & 0x7
}
func (o *TC_COUNT16_Type) SetEVCTRL_TCINV(value uint16) {
	volatile.StoreUint16(&o.EVCTRL.Reg, volatile.LoadUint16(&o.EVCTRL.Reg)&^(0x10)|value<<4)
}
func (o *TC_COUNT16_Type) GetEVCTRL_TCINV() uint16 {
	return (volatile.LoadUint16(&o.EVCTRL.Reg) & 0x10) >> 4
}
func (o *TC_COUNT16_Type) SetEVCTRL_TCEI(value uint16) {
	volatile.StoreUint16(&o.EVCTRL.Reg, volatile.LoadUint16(&o.EVCTRL.Reg)&^(0x20)|value<<5)
}
func (o *TC_COUNT16_Type) GetEVCTRL_TCEI() uint16 {
	return (volatile.LoadUint16(&o.EVCTRL.Reg) & 0x20) >> 5
}
func (o *TC_COUNT16_Type) SetEVCTRL_OVFEO(value uint16) {
	volatile.StoreUint16(&o.EVCTRL.Reg, volatile.LoadUint16(&o.EVCTRL.Reg)&^(0x100)|value<<8)
}
func (o *TC_COUNT16_Type) GetEVCTRL_OVFEO() uint16 {
	return (volatile.LoadUint16(&o.EVCTRL.Reg) & 0x100) >> 8
}
func (o *TC_COUNT16_Type) SetEVCTRL_MCEO0(value uint16) {
	volatile.StoreUint16(&o.EVCTRL.Reg, volatile.LoadUint16(&o.EVCTRL.Reg)&^(0x1000)|value<<12)
}
func (o *TC_COUNT16_Type) GetEVCTRL_MCEO0() uint16 {
	return (volatile.LoadUint16(&o.EVCTRL.Reg) & 0x1000) >> 12
}
func (o *TC_COUNT16_Type) SetEVCTRL_MCEO1(value uint16) {
	volatile.StoreUint16(&o.EVCTRL.Reg, volatile.LoadUint16(&o.EVCTRL.Reg)&^(0x2000)|value<<13)
}
func (o *TC_COUNT16_Type) GetEVCTRL_MCEO1() uint16 {
	return (volatile.LoadUint16(&o.EVCTRL.Reg) & 0x2000) >> 13
}

// TC_COUNT16.INTENCLR: Interrupt Enable Clear
func (o *TC_COUNT16_Type) SetINTENCLR_OVF(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *TC_COUNT16_Type) GetINTENCLR_OVF() uint8 {
	return volatile.LoadUint8(&o.INTENCLR.Reg) & 0x1
}
func (o *TC_COUNT16_Type) SetINTENCLR_ERR(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *TC_COUNT16_Type) GetINTENCLR_ERR() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *TC_COUNT16_Type) SetINTENCLR_MC0(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x10)|value<<4)
}
func (o *TC_COUNT16_Type) GetINTENCLR_MC0() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x10) >> 4
}
func (o *TC_COUNT16_Type) SetINTENCLR_MC1(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x20)|value<<5)
}
func (o *TC_COUNT16_Type) GetINTENCLR_MC1() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x20) >> 5
}

// TC_COUNT16.INTENSET: Interrupt Enable Set
func (o *TC_COUNT16_Type) SetINTENSET_OVF(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *TC_COUNT16_Type) GetINTENSET_OVF() uint8 {
	return volatile.LoadUint8(&o.INTENSET.Reg) & 0x1
}
func (o *TC_COUNT16_Type) SetINTENSET_ERR(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *TC_COUNT16_Type) GetINTENSET_ERR() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *TC_COUNT16_Type) SetINTENSET_MC0(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x10)|value<<4)
}
func (o *TC_COUNT16_Type) GetINTENSET_MC0() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x10) >> 4
}
func (o *TC_COUNT16_Type) SetINTENSET_MC1(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x20)|value<<5)
}
func (o *TC_COUNT16_Type) GetINTENSET_MC1() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x20) >> 5
}

// TC_COUNT16.INTFLAG: Interrupt Flag Status and Clear
func (o *TC_COUNT16_Type) SetINTFLAG_OVF(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x1)|value)
}
func (o *TC_COUNT16_Type) GetINTFLAG_OVF() uint8 {
	return volatile.LoadUint8(&o.INTFLAG.Reg) & 0x1
}
func (o *TC_COUNT16_Type) SetINTFLAG_ERR(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x2)|value<<1)
}
func (o *TC_COUNT16_Type) GetINTFLAG_ERR() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x2) >> 1
}
func (o *TC_COUNT16_Type) SetINTFLAG_MC0(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x10)|value<<4)
}
func (o *TC_COUNT16_Type) GetINTFLAG_MC0() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x10) >> 4
}
func (o *TC_COUNT16_Type) SetINTFLAG_MC1(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x20)|value<<5)
}
func (o *TC_COUNT16_Type) GetINTFLAG_MC1() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x20) >> 5
}

// TC_COUNT16.STATUS: Status
func (o *TC_COUNT16_Type) SetSTATUS_STOP(value uint8) {
	volatile.StoreUint8(&o.STATUS.Reg, volatile.LoadUint8(&o.STATUS.Reg)&^(0x1)|value)
}
func (o *TC_COUNT16_Type) GetSTATUS_STOP() uint8 {
	return volatile.LoadUint8(&o.STATUS.Reg) & 0x1
}
func (o *TC_COUNT16_Type) SetSTATUS_SLAVE(value uint8) {
	volatile.StoreUint8(&o.STATUS.Reg, volatile.LoadUint8(&o.STATUS.Reg)&^(0x2)|value<<1)
}
func (o *TC_COUNT16_Type) GetSTATUS_SLAVE() uint8 {
	return (volatile.LoadUint8(&o.STATUS.Reg) & 0x2) >> 1
}
func (o *TC_COUNT16_Type) SetSTATUS_PERBUFV(value uint8) {
	volatile.StoreUint8(&o.STATUS.Reg, volatile.LoadUint8(&o.STATUS.Reg)&^(0x8)|value<<3)
}
func (o *TC_COUNT16_Type) GetSTATUS_PERBUFV() uint8 {
	return (volatile.LoadUint8(&o.STATUS.Reg) & 0x8) >> 3
}
func (o *TC_COUNT16_Type) SetSTATUS_CCBUFV0(value uint8) {
	volatile.StoreUint8(&o.STATUS.Reg, volatile.LoadUint8(&o.STATUS.Reg)&^(0x10)|value<<4)
}
func (o *TC_COUNT16_Type) GetSTATUS_CCBUFV0() uint8 {
	return (volatile.LoadUint8(&o.STATUS.Reg) & 0x10) >> 4
}
func (o *TC_COUNT16_Type) SetSTATUS_CCBUFV1(value uint8) {
	volatile.StoreUint8(&o.STATUS.Reg, volatile.LoadUint8(&o.STATUS.Reg)&^(0x20)|value<<5)
}
func (o *TC_COUNT16_Type) GetSTATUS_CCBUFV1() uint8 {
	return (volatile.LoadUint8(&o.STATUS.Reg) & 0x20) >> 5
}

// TC_COUNT16.WAVE: Waveform Generation Control
func (o *TC_COUNT16_Type) SetWAVE_WAVEGEN(value uint8) {
	volatile.StoreUint8(&o.WAVE.Reg, volatile.LoadUint8(&o.WAVE.Reg)&^(0x3)|value)
}
func (o *TC_COUNT16_Type) GetWAVE_WAVEGEN() uint8 {
	return volatile.LoadUint8(&o.WAVE.Reg) & 0x3
}

// TC_COUNT16.DRVCTRL: Control C
func (o *TC_COUNT16_Type) SetDRVCTRL_INVEN0(value uint8) {
	volatile.StoreUint8(&o.DRVCTRL.Reg, volatile.LoadUint8(&o.DRVCTRL.Reg)&^(0x1)|value)
}
func (o *TC_COUNT16_Type) GetDRVCTRL_INVEN0() uint8 {
	return volatile.LoadUint8(&o.DRVCTRL.Reg) & 0x1
}
func (o *TC_COUNT16_Type) SetDRVCTRL_INVEN1(value uint8) {
	volatile.StoreUint8(&o.DRVCTRL.Reg, volatile.LoadUint8(&o.DRVCTRL.Reg)&^(0x2)|value<<1)
}
func (o *TC_COUNT16_Type) GetDRVCTRL_INVEN1() uint8 {
	return (volatile.LoadUint8(&o.DRVCTRL.Reg) & 0x2) >> 1
}

// TC_COUNT16.DBGCTRL: Debug Control
func (o *TC_COUNT16_Type) SetDBGCTRL_DBGRUN(value uint8) {
	volatile.StoreUint8(&o.DBGCTRL.Reg, volatile.LoadUint8(&o.DBGCTRL.Reg)&^(0x1)|value)
}
func (o *TC_COUNT16_Type) GetDBGCTRL_DBGRUN() uint8 {
	return volatile.LoadUint8(&o.DBGCTRL.Reg) & 0x1
}

// TC_COUNT16.SYNCBUSY: Synchronization Status
func (o *TC_COUNT16_Type) SetSYNCBUSY_SWRST(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x1)|value)
}
func (o *TC_COUNT16_Type) GetSYNCBUSY_SWRST() uint32 {
	return volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x1
}
func (o *TC_COUNT16_Type) SetSYNCBUSY_ENABLE(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x2)|value<<1)
}
func (o *TC_COUNT16_Type) GetSYNCBUSY_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x2) >> 1
}
func (o *TC_COUNT16_Type) SetSYNCBUSY_CTRLB(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x4)|value<<2)
}
func (o *TC_COUNT16_Type) GetSYNCBUSY_CTRLB() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x4) >> 2
}
func (o *TC_COUNT16_Type) SetSYNCBUSY_STATUS(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x8)|value<<3)
}
func (o *TC_COUNT16_Type) GetSYNCBUSY_STATUS() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x8) >> 3
}
func (o *TC_COUNT16_Type) SetSYNCBUSY_COUNT(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x10)|value<<4)
}
func (o *TC_COUNT16_Type) GetSYNCBUSY_COUNT() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x10) >> 4
}
func (o *TC_COUNT16_Type) SetSYNCBUSY_PER(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x20)|value<<5)
}
func (o *TC_COUNT16_Type) GetSYNCBUSY_PER() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x20) >> 5
}
func (o *TC_COUNT16_Type) SetSYNCBUSY_CC0(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x40)|value<<6)
}
func (o *TC_COUNT16_Type) GetSYNCBUSY_CC0() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x40) >> 6
}
func (o *TC_COUNT16_Type) SetSYNCBUSY_CC1(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x80)|value<<7)
}
func (o *TC_COUNT16_Type) GetSYNCBUSY_CC1() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x80) >> 7
}

// TC_COUNT16.COUNT: COUNT16 Count
func (o *TC_COUNT16_Type) SetCOUNT(value uint16) {
	volatile.StoreUint16(&o.COUNT.Reg, value)
}
func (o *TC_COUNT16_Type) GetCOUNT() uint16 {
	return volatile.LoadUint16(&o.COUNT.Reg)
}

// TC_COUNT16.CC0: COUNT16 Compare and Capture
func (o *TC_COUNT16_Type) SetCC0(value uint16) {
	volatile.StoreUint16(&o.CC0.Reg, value)
}
func (o *TC_COUNT16_Type) GetCC0() uint16 {
	return volatile.LoadUint16(&o.CC0.Reg)
}

// TC_COUNT16.CC1: COUNT16 Compare and Capture
func (o *TC_COUNT16_Type) SetCC1(value uint16) {
	volatile.StoreUint16(&o.CC1.Reg, value)
}
func (o *TC_COUNT16_Type) GetCC1() uint16 {
	return volatile.LoadUint16(&o.CC1.Reg)
}

// TC_COUNT16.CCBUF0: COUNT16 Compare and Capture Buffer
func (o *TC_COUNT16_Type) SetCCBUF0(value uint16) {
	volatile.StoreUint16(&o.CCBUF0.Reg, value)
}
func (o *TC_COUNT16_Type) GetCCBUF0() uint16 {
	return volatile.LoadUint16(&o.CCBUF0.Reg)
}

// TC_COUNT16.CCBUF1: COUNT16 Compare and Capture Buffer
func (o *TC_COUNT16_Type) SetCCBUF1(value uint16) {
	volatile.StoreUint16(&o.CCBUF1.Reg, value)
}
func (o *TC_COUNT16_Type) GetCCBUF1() uint16 {
	return volatile.LoadUint16(&o.CCBUF1.Reg)
}

// Basic Timer Counter 0 - COUNT32
type TC_COUNT32_Type struct {
	CTRLA    volatile.Register32 // 0x0
	CTRLBCLR volatile.Register8  // 0x4
	CTRLBSET volatile.Register8  // 0x5
	EVCTRL   volatile.Register16 // 0x6
	INTENCLR volatile.Register8  // 0x8
	INTENSET volatile.Register8  // 0x9
	INTFLAG  volatile.Register8  // 0xA
	STATUS   volatile.Register8  // 0xB
	WAVE     volatile.Register8  // 0xC
	DRVCTRL  volatile.Register8  // 0xD
	_        byte
	DBGCTRL  volatile.Register8  // 0xF
	SYNCBUSY volatile.Register32 // 0x10
	COUNT    volatile.Register32 // 0x14
	_        [4]byte
	CC0      volatile.Register32 // 0x1C
	CC1      volatile.Register32 // 0x20
	_        [12]byte
	CCBUF0   volatile.Register32 // 0x30
	CCBUF1   volatile.Register32 // 0x34
}

// TC_COUNT32.CTRLA: Control A
func (o *TC_COUNT32_Type) SetCTRLA_SWRST(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x1)|value)
}
func (o *TC_COUNT32_Type) GetCTRLA_SWRST() uint32 {
	return volatile.LoadUint32(&o.CTRLA.Reg) & 0x1
}
func (o *TC_COUNT32_Type) SetCTRLA_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x2)|value<<1)
}
func (o *TC_COUNT32_Type) GetCTRLA_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x2) >> 1
}
func (o *TC_COUNT32_Type) SetCTRLA_MODE(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0xc)|value<<2)
}
func (o *TC_COUNT32_Type) GetCTRLA_MODE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0xc) >> 2
}
func (o *TC_COUNT32_Type) SetCTRLA_PRESCSYNC(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x30)|value<<4)
}
func (o *TC_COUNT32_Type) GetCTRLA_PRESCSYNC() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x30) >> 4
}
func (o *TC_COUNT32_Type) SetCTRLA_RUNSTDBY(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x40)|value<<6)
}
func (o *TC_COUNT32_Type) GetCTRLA_RUNSTDBY() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x40) >> 6
}
func (o *TC_COUNT32_Type) SetCTRLA_ONDEMAND(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x80)|value<<7)
}
func (o *TC_COUNT32_Type) GetCTRLA_ONDEMAND() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x80) >> 7
}
func (o *TC_COUNT32_Type) SetCTRLA_PRESCALER(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x700)|value<<8)
}
func (o *TC_COUNT32_Type) GetCTRLA_PRESCALER() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x700) >> 8
}
func (o *TC_COUNT32_Type) SetCTRLA_ALOCK(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x800)|value<<11)
}
func (o *TC_COUNT32_Type) GetCTRLA_ALOCK() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x800) >> 11
}
func (o *TC_COUNT32_Type) SetCTRLA_CAPTEN0(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x10000)|value<<16)
}
func (o *TC_COUNT32_Type) GetCTRLA_CAPTEN0() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x10000) >> 16
}
func (o *TC_COUNT32_Type) SetCTRLA_CAPTEN1(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x20000)|value<<17)
}
func (o *TC_COUNT32_Type) GetCTRLA_CAPTEN1() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x20000) >> 17
}
func (o *TC_COUNT32_Type) SetCTRLA_COPEN0(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x100000)|value<<20)
}
func (o *TC_COUNT32_Type) GetCTRLA_COPEN0() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x100000) >> 20
}
func (o *TC_COUNT32_Type) SetCTRLA_COPEN1(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x200000)|value<<21)
}
func (o *TC_COUNT32_Type) GetCTRLA_COPEN1() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x200000) >> 21
}

// TC_COUNT32.CTRLBCLR: Control B Clear
func (o *TC_COUNT32_Type) SetCTRLBCLR_DIR(value uint8) {
	volatile.StoreUint8(&o.CTRLBCLR.Reg, volatile.LoadUint8(&o.CTRLBCLR.Reg)&^(0x1)|value)
}
func (o *TC_COUNT32_Type) GetCTRLBCLR_DIR() uint8 {
	return volatile.LoadUint8(&o.CTRLBCLR.Reg) & 0x1
}
func (o *TC_COUNT32_Type) SetCTRLBCLR_LUPD(value uint8) {
	volatile.StoreUint8(&o.CTRLBCLR.Reg, volatile.LoadUint8(&o.CTRLBCLR.Reg)&^(0x2)|value<<1)
}
func (o *TC_COUNT32_Type) GetCTRLBCLR_LUPD() uint8 {
	return (volatile.LoadUint8(&o.CTRLBCLR.Reg) & 0x2) >> 1
}
func (o *TC_COUNT32_Type) SetCTRLBCLR_ONESHOT(value uint8) {
	volatile.StoreUint8(&o.CTRLBCLR.Reg, volatile.LoadUint8(&o.CTRLBCLR.Reg)&^(0x4)|value<<2)
}
func (o *TC_COUNT32_Type) GetCTRLBCLR_ONESHOT() uint8 {
	return (volatile.LoadUint8(&o.CTRLBCLR.Reg) & 0x4) >> 2
}
func (o *TC_COUNT32_Type) SetCTRLBCLR_CMD(value uint8) {
	volatile.StoreUint8(&o.CTRLBCLR.Reg, volatile.LoadUint8(&o.CTRLBCLR.Reg)&^(0xe0)|value<<5)
}
func (o *TC_COUNT32_Type) GetCTRLBCLR_CMD() uint8 {
	return (volatile.LoadUint8(&o.CTRLBCLR.Reg) & 0xe0) >> 5
}

// TC_COUNT32.CTRLBSET: Control B Set
func (o *TC_COUNT32_Type) SetCTRLBSET_DIR(value uint8) {
	volatile.StoreUint8(&o.CTRLBSET.Reg, volatile.LoadUint8(&o.CTRLBSET.Reg)&^(0x1)|value)
}
func (o *TC_COUNT32_Type) GetCTRLBSET_DIR() uint8 {
	return volatile.LoadUint8(&o.CTRLBSET.Reg) & 0x1
}
func (o *TC_COUNT32_Type) SetCTRLBSET_LUPD(value uint8) {
	volatile.StoreUint8(&o.CTRLBSET.Reg, volatile.LoadUint8(&o.CTRLBSET.Reg)&^(0x2)|value<<1)
}
func (o *TC_COUNT32_Type) GetCTRLBSET_LUPD() uint8 {
	return (volatile.LoadUint8(&o.CTRLBSET.Reg) & 0x2) >> 1
}
func (o *TC_COUNT32_Type) SetCTRLBSET_ONESHOT(value uint8) {
	volatile.StoreUint8(&o.CTRLBSET.Reg, volatile.LoadUint8(&o.CTRLBSET.Reg)&^(0x4)|value<<2)
}
func (o *TC_COUNT32_Type) GetCTRLBSET_ONESHOT() uint8 {
	return (volatile.LoadUint8(&o.CTRLBSET.Reg) & 0x4) >> 2
}
func (o *TC_COUNT32_Type) SetCTRLBSET_CMD(value uint8) {
	volatile.StoreUint8(&o.CTRLBSET.Reg, volatile.LoadUint8(&o.CTRLBSET.Reg)&^(0xe0)|value<<5)
}
func (o *TC_COUNT32_Type) GetCTRLBSET_CMD() uint8 {
	return (volatile.LoadUint8(&o.CTRLBSET.Reg) & 0xe0) >> 5
}

// TC_COUNT32.EVCTRL: Event Control
func (o *TC_COUNT32_Type) SetEVCTRL_EVACT(value uint16) {
	volatile.StoreUint16(&o.EVCTRL.Reg, volatile.LoadUint16(&o.EVCTRL.Reg)&^(0x7)|value)
}
func (o *TC_COUNT32_Type) GetEVCTRL_EVACT() uint16 {
	return volatile.LoadUint16(&o.EVCTRL.Reg) & 0x7
}
func (o *TC_COUNT32_Type) SetEVCTRL_TCINV(value uint16) {
	volatile.StoreUint16(&o.EVCTRL.Reg, volatile.LoadUint16(&o.EVCTRL.Reg)&^(0x10)|value<<4)
}
func (o *TC_COUNT32_Type) GetEVCTRL_TCINV() uint16 {
	return (volatile.LoadUint16(&o.EVCTRL.Reg) & 0x10) >> 4
}
func (o *TC_COUNT32_Type) SetEVCTRL_TCEI(value uint16) {
	volatile.StoreUint16(&o.EVCTRL.Reg, volatile.LoadUint16(&o.EVCTRL.Reg)&^(0x20)|value<<5)
}
func (o *TC_COUNT32_Type) GetEVCTRL_TCEI() uint16 {
	return (volatile.LoadUint16(&o.EVCTRL.Reg) & 0x20) >> 5
}
func (o *TC_COUNT32_Type) SetEVCTRL_OVFEO(value uint16) {
	volatile.StoreUint16(&o.EVCTRL.Reg, volatile.LoadUint16(&o.EVCTRL.Reg)&^(0x100)|value<<8)
}
func (o *TC_COUNT32_Type) GetEVCTRL_OVFEO() uint16 {
	return (volatile.LoadUint16(&o.EVCTRL.Reg) & 0x100) >> 8
}
func (o *TC_COUNT32_Type) SetEVCTRL_MCEO0(value uint16) {
	volatile.StoreUint16(&o.EVCTRL.Reg, volatile.LoadUint16(&o.EVCTRL.Reg)&^(0x1000)|value<<12)
}
func (o *TC_COUNT32_Type) GetEVCTRL_MCEO0() uint16 {
	return (volatile.LoadUint16(&o.EVCTRL.Reg) & 0x1000) >> 12
}
func (o *TC_COUNT32_Type) SetEVCTRL_MCEO1(value uint16) {
	volatile.StoreUint16(&o.EVCTRL.Reg, volatile.LoadUint16(&o.EVCTRL.Reg)&^(0x2000)|value<<13)
}
func (o *TC_COUNT32_Type) GetEVCTRL_MCEO1() uint16 {
	return (volatile.LoadUint16(&o.EVCTRL.Reg) & 0x2000) >> 13
}

// TC_COUNT32.INTENCLR: Interrupt Enable Clear
func (o *TC_COUNT32_Type) SetINTENCLR_OVF(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *TC_COUNT32_Type) GetINTENCLR_OVF() uint8 {
	return volatile.LoadUint8(&o.INTENCLR.Reg) & 0x1
}
func (o *TC_COUNT32_Type) SetINTENCLR_ERR(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *TC_COUNT32_Type) GetINTENCLR_ERR() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *TC_COUNT32_Type) SetINTENCLR_MC0(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x10)|value<<4)
}
func (o *TC_COUNT32_Type) GetINTENCLR_MC0() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x10) >> 4
}
func (o *TC_COUNT32_Type) SetINTENCLR_MC1(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x20)|value<<5)
}
func (o *TC_COUNT32_Type) GetINTENCLR_MC1() uint8 {
	return (volatile.LoadUint8(&o.INTENCLR.Reg) & 0x20) >> 5
}

// TC_COUNT32.INTENSET: Interrupt Enable Set
func (o *TC_COUNT32_Type) SetINTENSET_OVF(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *TC_COUNT32_Type) GetINTENSET_OVF() uint8 {
	return volatile.LoadUint8(&o.INTENSET.Reg) & 0x1
}
func (o *TC_COUNT32_Type) SetINTENSET_ERR(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *TC_COUNT32_Type) GetINTENSET_ERR() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *TC_COUNT32_Type) SetINTENSET_MC0(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x10)|value<<4)
}
func (o *TC_COUNT32_Type) GetINTENSET_MC0() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x10) >> 4
}
func (o *TC_COUNT32_Type) SetINTENSET_MC1(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x20)|value<<5)
}
func (o *TC_COUNT32_Type) GetINTENSET_MC1() uint8 {
	return (volatile.LoadUint8(&o.INTENSET.Reg) & 0x20) >> 5
}

// TC_COUNT32.INTFLAG: Interrupt Flag Status and Clear
func (o *TC_COUNT32_Type) SetINTFLAG_OVF(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x1)|value)
}
func (o *TC_COUNT32_Type) GetINTFLAG_OVF() uint8 {
	return volatile.LoadUint8(&o.INTFLAG.Reg) & 0x1
}
func (o *TC_COUNT32_Type) SetINTFLAG_ERR(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x2)|value<<1)
}
func (o *TC_COUNT32_Type) GetINTFLAG_ERR() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x2) >> 1
}
func (o *TC_COUNT32_Type) SetINTFLAG_MC0(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x10)|value<<4)
}
func (o *TC_COUNT32_Type) GetINTFLAG_MC0() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x10) >> 4
}
func (o *TC_COUNT32_Type) SetINTFLAG_MC1(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x20)|value<<5)
}
func (o *TC_COUNT32_Type) GetINTFLAG_MC1() uint8 {
	return (volatile.LoadUint8(&o.INTFLAG.Reg) & 0x20) >> 5
}

// TC_COUNT32.STATUS: Status
func (o *TC_COUNT32_Type) SetSTATUS_STOP(value uint8) {
	volatile.StoreUint8(&o.STATUS.Reg, volatile.LoadUint8(&o.STATUS.Reg)&^(0x1)|value)
}
func (o *TC_COUNT32_Type) GetSTATUS_STOP() uint8 {
	return volatile.LoadUint8(&o.STATUS.Reg) & 0x1
}
func (o *TC_COUNT32_Type) SetSTATUS_SLAVE(value uint8) {
	volatile.StoreUint8(&o.STATUS.Reg, volatile.LoadUint8(&o.STATUS.Reg)&^(0x2)|value<<1)
}
func (o *TC_COUNT32_Type) GetSTATUS_SLAVE() uint8 {
	return (volatile.LoadUint8(&o.STATUS.Reg) & 0x2) >> 1
}
func (o *TC_COUNT32_Type) SetSTATUS_PERBUFV(value uint8) {
	volatile.StoreUint8(&o.STATUS.Reg, volatile.LoadUint8(&o.STATUS.Reg)&^(0x8)|value<<3)
}
func (o *TC_COUNT32_Type) GetSTATUS_PERBUFV() uint8 {
	return (volatile.LoadUint8(&o.STATUS.Reg) & 0x8) >> 3
}
func (o *TC_COUNT32_Type) SetSTATUS_CCBUFV0(value uint8) {
	volatile.StoreUint8(&o.STATUS.Reg, volatile.LoadUint8(&o.STATUS.Reg)&^(0x10)|value<<4)
}
func (o *TC_COUNT32_Type) GetSTATUS_CCBUFV0() uint8 {
	return (volatile.LoadUint8(&o.STATUS.Reg) & 0x10) >> 4
}
func (o *TC_COUNT32_Type) SetSTATUS_CCBUFV1(value uint8) {
	volatile.StoreUint8(&o.STATUS.Reg, volatile.LoadUint8(&o.STATUS.Reg)&^(0x20)|value<<5)
}
func (o *TC_COUNT32_Type) GetSTATUS_CCBUFV1() uint8 {
	return (volatile.LoadUint8(&o.STATUS.Reg) & 0x20) >> 5
}

// TC_COUNT32.WAVE: Waveform Generation Control
func (o *TC_COUNT32_Type) SetWAVE_WAVEGEN(value uint8) {
	volatile.StoreUint8(&o.WAVE.Reg, volatile.LoadUint8(&o.WAVE.Reg)&^(0x3)|value)
}
func (o *TC_COUNT32_Type) GetWAVE_WAVEGEN() uint8 {
	return volatile.LoadUint8(&o.WAVE.Reg) & 0x3
}

// TC_COUNT32.DRVCTRL: Control C
func (o *TC_COUNT32_Type) SetDRVCTRL_INVEN0(value uint8) {
	volatile.StoreUint8(&o.DRVCTRL.Reg, volatile.LoadUint8(&o.DRVCTRL.Reg)&^(0x1)|value)
}
func (o *TC_COUNT32_Type) GetDRVCTRL_INVEN0() uint8 {
	return volatile.LoadUint8(&o.DRVCTRL.Reg) & 0x1
}
func (o *TC_COUNT32_Type) SetDRVCTRL_INVEN1(value uint8) {
	volatile.StoreUint8(&o.DRVCTRL.Reg, volatile.LoadUint8(&o.DRVCTRL.Reg)&^(0x2)|value<<1)
}
func (o *TC_COUNT32_Type) GetDRVCTRL_INVEN1() uint8 {
	return (volatile.LoadUint8(&o.DRVCTRL.Reg) & 0x2) >> 1
}

// TC_COUNT32.DBGCTRL: Debug Control
func (o *TC_COUNT32_Type) SetDBGCTRL_DBGRUN(value uint8) {
	volatile.StoreUint8(&o.DBGCTRL.Reg, volatile.LoadUint8(&o.DBGCTRL.Reg)&^(0x1)|value)
}
func (o *TC_COUNT32_Type) GetDBGCTRL_DBGRUN() uint8 {
	return volatile.LoadUint8(&o.DBGCTRL.Reg) & 0x1
}

// TC_COUNT32.SYNCBUSY: Synchronization Status
func (o *TC_COUNT32_Type) SetSYNCBUSY_SWRST(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x1)|value)
}
func (o *TC_COUNT32_Type) GetSYNCBUSY_SWRST() uint32 {
	return volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x1
}
func (o *TC_COUNT32_Type) SetSYNCBUSY_ENABLE(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x2)|value<<1)
}
func (o *TC_COUNT32_Type) GetSYNCBUSY_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x2) >> 1
}
func (o *TC_COUNT32_Type) SetSYNCBUSY_CTRLB(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x4)|value<<2)
}
func (o *TC_COUNT32_Type) GetSYNCBUSY_CTRLB() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x4) >> 2
}
func (o *TC_COUNT32_Type) SetSYNCBUSY_STATUS(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x8)|value<<3)
}
func (o *TC_COUNT32_Type) GetSYNCBUSY_STATUS() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x8) >> 3
}
func (o *TC_COUNT32_Type) SetSYNCBUSY_COUNT(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x10)|value<<4)
}
func (o *TC_COUNT32_Type) GetSYNCBUSY_COUNT() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x10) >> 4
}
func (o *TC_COUNT32_Type) SetSYNCBUSY_PER(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x20)|value<<5)
}
func (o *TC_COUNT32_Type) GetSYNCBUSY_PER() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x20) >> 5
}
func (o *TC_COUNT32_Type) SetSYNCBUSY_CC0(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x40)|value<<6)
}
func (o *TC_COUNT32_Type) GetSYNCBUSY_CC0() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x40) >> 6
}
func (o *TC_COUNT32_Type) SetSYNCBUSY_CC1(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x80)|value<<7)
}
func (o *TC_COUNT32_Type) GetSYNCBUSY_CC1() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x80) >> 7
}

// TC_COUNT32.COUNT: COUNT32 Count
func (o *TC_COUNT32_Type) SetCOUNT(value uint32) {
	volatile.StoreUint32(&o.COUNT.Reg, value)
}
func (o *TC_COUNT32_Type) GetCOUNT() uint32 {
	return volatile.LoadUint32(&o.COUNT.Reg)
}

// TC_COUNT32.CC0: COUNT32 Compare and Capture
func (o *TC_COUNT32_Type) SetCC0(value uint32) {
	volatile.StoreUint32(&o.CC0.Reg, value)
}
func (o *TC_COUNT32_Type) GetCC0() uint32 {
	return volatile.LoadUint32(&o.CC0.Reg)
}

// TC_COUNT32.CC1: COUNT32 Compare and Capture
func (o *TC_COUNT32_Type) SetCC1(value uint32) {
	volatile.StoreUint32(&o.CC1.Reg, value)
}
func (o *TC_COUNT32_Type) GetCC1() uint32 {
	return volatile.LoadUint32(&o.CC1.Reg)
}

// TC_COUNT32.CCBUF0: COUNT32 Compare and Capture Buffer
func (o *TC_COUNT32_Type) SetCCBUF0(value uint32) {
	volatile.StoreUint32(&o.CCBUF0.Reg, value)
}
func (o *TC_COUNT32_Type) GetCCBUF0() uint32 {
	return volatile.LoadUint32(&o.CCBUF0.Reg)
}

// TC_COUNT32.CCBUF1: COUNT32 Compare and Capture Buffer
func (o *TC_COUNT32_Type) SetCCBUF1(value uint32) {
	volatile.StoreUint32(&o.CCBUF1.Reg, value)
}
func (o *TC_COUNT32_Type) GetCCBUF1() uint32 {
	return volatile.LoadUint32(&o.CCBUF1.Reg)
}

// Timer Counter Control
type TCC_Type struct {
	CTRLA    volatile.Register32 // 0x0
	CTRLBCLR volatile.Register8  // 0x4
	CTRLBSET volatile.Register8  // 0x5
	_        [2]byte
	SYNCBUSY volatile.Register32 // 0x8
	FCTRLA   volatile.Register32 // 0xC
	FCTRLB   volatile.Register32 // 0x10
	WEXCTRL  volatile.Register32 // 0x14
	DRVCTRL  volatile.Register32 // 0x18
	_        [2]byte
	DBGCTRL  volatile.Register8 // 0x1E
	_        byte
	EVCTRL   volatile.Register32 // 0x20
	INTENCLR volatile.Register32 // 0x24
	INTENSET volatile.Register32 // 0x28
	INTFLAG  volatile.Register32 // 0x2C
	STATUS   volatile.Register32 // 0x30
	COUNT    volatile.Register32 // 0x34
	PATT     volatile.Register16 // 0x38
	_        [2]byte
	WAVE     volatile.Register32 // 0x3C
	PER      volatile.Register32 // 0x40
	CC0      volatile.Register32 // 0x44
	CC1      volatile.Register32 // 0x48
	CC2      volatile.Register32 // 0x4C
	CC3      volatile.Register32 // 0x50
	_        [16]byte
	PATTBUF  volatile.Register16 // 0x64
	_        [6]byte
	PERBUF   volatile.Register32 // 0x6C
	CCBUF0   volatile.Register32 // 0x70
	CCBUF1   volatile.Register32 // 0x74
	CCBUF2   volatile.Register32 // 0x78
	CCBUF3   volatile.Register32 // 0x7C
}

// TCC.CTRLA: Control A
func (o *TCC_Type) SetCTRLA_SWRST(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x1)|value)
}
func (o *TCC_Type) GetCTRLA_SWRST() uint32 {
	return volatile.LoadUint32(&o.CTRLA.Reg) & 0x1
}
func (o *TCC_Type) SetCTRLA_ENABLE(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x2)|value<<1)
}
func (o *TCC_Type) GetCTRLA_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x2) >> 1
}
func (o *TCC_Type) SetCTRLA_RESOLUTION(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x60)|value<<5)
}
func (o *TCC_Type) GetCTRLA_RESOLUTION() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x60) >> 5
}
func (o *TCC_Type) SetCTRLA_PRESCALER(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x700)|value<<8)
}
func (o *TCC_Type) GetCTRLA_PRESCALER() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x700) >> 8
}
func (o *TCC_Type) SetCTRLA_RUNSTDBY(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x800)|value<<11)
}
func (o *TCC_Type) GetCTRLA_RUNSTDBY() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x800) >> 11
}
func (o *TCC_Type) SetCTRLA_PRESCSYNC(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x3000)|value<<12)
}
func (o *TCC_Type) GetCTRLA_PRESCSYNC() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x3000) >> 12
}
func (o *TCC_Type) SetCTRLA_ALOCK(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x4000)|value<<14)
}
func (o *TCC_Type) GetCTRLA_ALOCK() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x4000) >> 14
}
func (o *TCC_Type) SetCTRLA_MSYNC(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x8000)|value<<15)
}
func (o *TCC_Type) GetCTRLA_MSYNC() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x8000) >> 15
}
func (o *TCC_Type) SetCTRLA_DMAOS(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x800000)|value<<23)
}
func (o *TCC_Type) GetCTRLA_DMAOS() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x800000) >> 23
}
func (o *TCC_Type) SetCTRLA_CPTEN0(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x1000000)|value<<24)
}
func (o *TCC_Type) GetCTRLA_CPTEN0() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x1000000) >> 24
}
func (o *TCC_Type) SetCTRLA_CPTEN1(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x2000000)|value<<25)
}
func (o *TCC_Type) GetCTRLA_CPTEN1() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x2000000) >> 25
}
func (o *TCC_Type) SetCTRLA_CPTEN2(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x4000000)|value<<26)
}
func (o *TCC_Type) GetCTRLA_CPTEN2() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x4000000) >> 26
}
func (o *TCC_Type) SetCTRLA_CPTEN3(value uint32) {
	volatile.StoreUint32(&o.CTRLA.Reg, volatile.LoadUint32(&o.CTRLA.Reg)&^(0x8000000)|value<<27)
}
func (o *TCC_Type) GetCTRLA_CPTEN3() uint32 {
	return (volatile.LoadUint32(&o.CTRLA.Reg) & 0x8000000) >> 27
}

// TCC.CTRLBCLR: Control B Clear
func (o *TCC_Type) SetCTRLBCLR_DIR(value uint8) {
	volatile.StoreUint8(&o.CTRLBCLR.Reg, volatile.LoadUint8(&o.CTRLBCLR.Reg)&^(0x1)|value)
}
func (o *TCC_Type) GetCTRLBCLR_DIR() uint8 {
	return volatile.LoadUint8(&o.CTRLBCLR.Reg) & 0x1
}
func (o *TCC_Type) SetCTRLBCLR_LUPD(value uint8) {
	volatile.StoreUint8(&o.CTRLBCLR.Reg, volatile.LoadUint8(&o.CTRLBCLR.Reg)&^(0x2)|value<<1)
}
func (o *TCC_Type) GetCTRLBCLR_LUPD() uint8 {
	return (volatile.LoadUint8(&o.CTRLBCLR.Reg) & 0x2) >> 1
}
func (o *TCC_Type) SetCTRLBCLR_ONESHOT(value uint8) {
	volatile.StoreUint8(&o.CTRLBCLR.Reg, volatile.LoadUint8(&o.CTRLBCLR.Reg)&^(0x4)|value<<2)
}
func (o *TCC_Type) GetCTRLBCLR_ONESHOT() uint8 {
	return (volatile.LoadUint8(&o.CTRLBCLR.Reg) & 0x4) >> 2
}
func (o *TCC_Type) SetCTRLBCLR_IDXCMD(value uint8) {
	volatile.StoreUint8(&o.CTRLBCLR.Reg, volatile.LoadUint8(&o.CTRLBCLR.Reg)&^(0x18)|value<<3)
}
func (o *TCC_Type) GetCTRLBCLR_IDXCMD() uint8 {
	return (volatile.LoadUint8(&o.CTRLBCLR.Reg) & 0x18) >> 3
}
func (o *TCC_Type) SetCTRLBCLR_CMD(value uint8) {
	volatile.StoreUint8(&o.CTRLBCLR.Reg, volatile.LoadUint8(&o.CTRLBCLR.Reg)&^(0xe0)|value<<5)
}
func (o *TCC_Type) GetCTRLBCLR_CMD() uint8 {
	return (volatile.LoadUint8(&o.CTRLBCLR.Reg) & 0xe0) >> 5
}

// TCC.CTRLBSET: Control B Set
func (o *TCC_Type) SetCTRLBSET_DIR(value uint8) {
	volatile.StoreUint8(&o.CTRLBSET.Reg, volatile.LoadUint8(&o.CTRLBSET.Reg)&^(0x1)|value)
}
func (o *TCC_Type) GetCTRLBSET_DIR() uint8 {
	return volatile.LoadUint8(&o.CTRLBSET.Reg) & 0x1
}
func (o *TCC_Type) SetCTRLBSET_LUPD(value uint8) {
	volatile.StoreUint8(&o.CTRLBSET.Reg, volatile.LoadUint8(&o.CTRLBSET.Reg)&^(0x2)|value<<1)
}
func (o *TCC_Type) GetCTRLBSET_LUPD() uint8 {
	return (volatile.LoadUint8(&o.CTRLBSET.Reg) & 0x2) >> 1
}
func (o *TCC_Type) SetCTRLBSET_ONESHOT(value uint8) {
	volatile.StoreUint8(&o.CTRLBSET.Reg, volatile.LoadUint8(&o.CTRLBSET.Reg)&^(0x4)|value<<2)
}
func (o *TCC_Type) GetCTRLBSET_ONESHOT() uint8 {
	return (volatile.LoadUint8(&o.CTRLBSET.Reg) & 0x4) >> 2
}
func (o *TCC_Type) SetCTRLBSET_IDXCMD(value uint8) {
	volatile.StoreUint8(&o.CTRLBSET.Reg, volatile.LoadUint8(&o.CTRLBSET.Reg)&^(0x18)|value<<3)
}
func (o *TCC_Type) GetCTRLBSET_IDXCMD() uint8 {
	return (volatile.LoadUint8(&o.CTRLBSET.Reg) & 0x18) >> 3
}
func (o *TCC_Type) SetCTRLBSET_CMD(value uint8) {
	volatile.StoreUint8(&o.CTRLBSET.Reg, volatile.LoadUint8(&o.CTRLBSET.Reg)&^(0xe0)|value<<5)
}
func (o *TCC_Type) GetCTRLBSET_CMD() uint8 {
	return (volatile.LoadUint8(&o.CTRLBSET.Reg) & 0xe0) >> 5
}

// TCC.SYNCBUSY: Synchronization Busy
func (o *TCC_Type) SetSYNCBUSY_SWRST(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x1)|value)
}
func (o *TCC_Type) GetSYNCBUSY_SWRST() uint32 {
	return volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x1
}
func (o *TCC_Type) SetSYNCBUSY_ENABLE(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x2)|value<<1)
}
func (o *TCC_Type) GetSYNCBUSY_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x2) >> 1
}
func (o *TCC_Type) SetSYNCBUSY_CTRLB(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x4)|value<<2)
}
func (o *TCC_Type) GetSYNCBUSY_CTRLB() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x4) >> 2
}
func (o *TCC_Type) SetSYNCBUSY_STATUS(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x8)|value<<3)
}
func (o *TCC_Type) GetSYNCBUSY_STATUS() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x8) >> 3
}
func (o *TCC_Type) SetSYNCBUSY_COUNT(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x10)|value<<4)
}
func (o *TCC_Type) GetSYNCBUSY_COUNT() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x10) >> 4
}
func (o *TCC_Type) SetSYNCBUSY_PATT(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x20)|value<<5)
}
func (o *TCC_Type) GetSYNCBUSY_PATT() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x20) >> 5
}
func (o *TCC_Type) SetSYNCBUSY_WAVE(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x40)|value<<6)
}
func (o *TCC_Type) GetSYNCBUSY_WAVE() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x40) >> 6
}
func (o *TCC_Type) SetSYNCBUSY_PER(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x80)|value<<7)
}
func (o *TCC_Type) GetSYNCBUSY_PER() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x80) >> 7
}
func (o *TCC_Type) SetSYNCBUSY_CC0(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x100)|value<<8)
}
func (o *TCC_Type) GetSYNCBUSY_CC0() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x100) >> 8
}
func (o *TCC_Type) SetSYNCBUSY_CC1(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x200)|value<<9)
}
func (o *TCC_Type) GetSYNCBUSY_CC1() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x200) >> 9
}
func (o *TCC_Type) SetSYNCBUSY_CC2(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x400)|value<<10)
}
func (o *TCC_Type) GetSYNCBUSY_CC2() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x400) >> 10
}
func (o *TCC_Type) SetSYNCBUSY_CC3(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x800)|value<<11)
}
func (o *TCC_Type) GetSYNCBUSY_CC3() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x800) >> 11
}

// TCC.FCTRLA: Recoverable Fault A Configuration
func (o *TCC_Type) SetFCTRLA_SRC(value uint32) {
	volatile.StoreUint32(&o.FCTRLA.Reg, volatile.LoadUint32(&o.FCTRLA.Reg)&^(0x3)|value)
}
func (o *TCC_Type) GetFCTRLA_SRC() uint32 {
	return volatile.LoadUint32(&o.FCTRLA.Reg) & 0x3
}
func (o *TCC_Type) SetFCTRLA_KEEP(value uint32) {
	volatile.StoreUint32(&o.FCTRLA.Reg, volatile.LoadUint32(&o.FCTRLA.Reg)&^(0x8)|value<<3)
}
func (o *TCC_Type) GetFCTRLA_KEEP() uint32 {
	return (volatile.LoadUint32(&o.FCTRLA.Reg) & 0x8) >> 3
}
func (o *TCC_Type) SetFCTRLA_QUAL(value uint32) {
	volatile.StoreUint32(&o.FCTRLA.Reg, volatile.LoadUint32(&o.FCTRLA.Reg)&^(0x10)|value<<4)
}
func (o *TCC_Type) GetFCTRLA_QUAL() uint32 {
	return (volatile.LoadUint32(&o.FCTRLA.Reg) & 0x10) >> 4
}
func (o *TCC_Type) SetFCTRLA_BLANK(value uint32) {
	volatile.StoreUint32(&o.FCTRLA.Reg, volatile.LoadUint32(&o.FCTRLA.Reg)&^(0x60)|value<<5)
}
func (o *TCC_Type) GetFCTRLA_BLANK() uint32 {
	return (volatile.LoadUint32(&o.FCTRLA.Reg) & 0x60) >> 5
}
func (o *TCC_Type) SetFCTRLA_RESTART(value uint32) {
	volatile.StoreUint32(&o.FCTRLA.Reg, volatile.LoadUint32(&o.FCTRLA.Reg)&^(0x80)|value<<7)
}
func (o *TCC_Type) GetFCTRLA_RESTART() uint32 {
	return (volatile.LoadUint32(&o.FCTRLA.Reg) & 0x80) >> 7
}
func (o *TCC_Type) SetFCTRLA_HALT(value uint32) {
	volatile.StoreUint32(&o.FCTRLA.Reg, volatile.LoadUint32(&o.FCTRLA.Reg)&^(0x300)|value<<8)
}
func (o *TCC_Type) GetFCTRLA_HALT() uint32 {
	return (volatile.LoadUint32(&o.FCTRLA.Reg) & 0x300) >> 8
}
func (o *TCC_Type) SetFCTRLA_CHSEL(value uint32) {
	volatile.StoreUint32(&o.FCTRLA.Reg, volatile.LoadUint32(&o.FCTRLA.Reg)&^(0xc00)|value<<10)
}
func (o *TCC_Type) GetFCTRLA_CHSEL() uint32 {
	return (volatile.LoadUint32(&o.FCTRLA.Reg) & 0xc00) >> 10
}
func (o *TCC_Type) SetFCTRLA_CAPTURE(value uint32) {
	volatile.StoreUint32(&o.FCTRLA.Reg, volatile.LoadUint32(&o.FCTRLA.Reg)&^(0x7000)|value<<12)
}
func (o *TCC_Type) GetFCTRLA_CAPTURE() uint32 {
	return (volatile.LoadUint32(&o.FCTRLA.Reg) & 0x7000) >> 12
}
func (o *TCC_Type) SetFCTRLA_BLANKPRESC(value uint32) {
	volatile.StoreUint32(&o.FCTRLA.Reg, volatile.LoadUint32(&o.FCTRLA.Reg)&^(0x8000)|value<<15)
}
func (o *TCC_Type) GetFCTRLA_BLANKPRESC() uint32 {
	return (volatile.LoadUint32(&o.FCTRLA.Reg) & 0x8000) >> 15
}
func (o *TCC_Type) SetFCTRLA_BLANKVAL(value uint32) {
	volatile.StoreUint32(&o.FCTRLA.Reg, volatile.LoadUint32(&o.FCTRLA.Reg)&^(0xff0000)|value<<16)
}
func (o *TCC_Type) GetFCTRLA_BLANKVAL() uint32 {
	return (volatile.LoadUint32(&o.FCTRLA.Reg) & 0xff0000) >> 16
}
func (o *TCC_Type) SetFCTRLA_FILTERVAL(value uint32) {
	volatile.StoreUint32(&o.FCTRLA.Reg, volatile.LoadUint32(&o.FCTRLA.Reg)&^(0xf000000)|value<<24)
}
func (o *TCC_Type) GetFCTRLA_FILTERVAL() uint32 {
	return (volatile.LoadUint32(&o.FCTRLA.Reg) & 0xf000000) >> 24
}

// TCC.FCTRLB: Recoverable Fault B Configuration
func (o *TCC_Type) SetFCTRLB_SRC(value uint32) {
	volatile.StoreUint32(&o.FCTRLB.Reg, volatile.LoadUint32(&o.FCTRLB.Reg)&^(0x3)|value)
}
func (o *TCC_Type) GetFCTRLB_SRC() uint32 {
	return volatile.LoadUint32(&o.FCTRLB.Reg) & 0x3
}
func (o *TCC_Type) SetFCTRLB_KEEP(value uint32) {
	volatile.StoreUint32(&o.FCTRLB.Reg, volatile.LoadUint32(&o.FCTRLB.Reg)&^(0x8)|value<<3)
}
func (o *TCC_Type) GetFCTRLB_KEEP() uint32 {
	return (volatile.LoadUint32(&o.FCTRLB.Reg) & 0x8) >> 3
}
func (o *TCC_Type) SetFCTRLB_QUAL(value uint32) {
	volatile.StoreUint32(&o.FCTRLB.Reg, volatile.LoadUint32(&o.FCTRLB.Reg)&^(0x10)|value<<4)
}
func (o *TCC_Type) GetFCTRLB_QUAL() uint32 {
	return (volatile.LoadUint32(&o.FCTRLB.Reg) & 0x10) >> 4
}
func (o *TCC_Type) SetFCTRLB_BLANK(value uint32) {
	volatile.StoreUint32(&o.FCTRLB.Reg, volatile.LoadUint32(&o.FCTRLB.Reg)&^(0x60)|value<<5)
}
func (o *TCC_Type) GetFCTRLB_BLANK() uint32 {
	return (volatile.LoadUint32(&o.FCTRLB.Reg) & 0x60) >> 5
}
func (o *TCC_Type) SetFCTRLB_RESTART(value uint32) {
	volatile.StoreUint32(&o.FCTRLB.Reg, volatile.LoadUint32(&o.FCTRLB.Reg)&^(0x80)|value<<7)
}
func (o *TCC_Type) GetFCTRLB_RESTART() uint32 {
	return (volatile.LoadUint32(&o.FCTRLB.Reg) & 0x80) >> 7
}
func (o *TCC_Type) SetFCTRLB_HALT(value uint32) {
	volatile.StoreUint32(&o.FCTRLB.Reg, volatile.LoadUint32(&o.FCTRLB.Reg)&^(0x300)|value<<8)
}
func (o *TCC_Type) GetFCTRLB_HALT() uint32 {
	return (volatile.LoadUint32(&o.FCTRLB.Reg) & 0x300) >> 8
}
func (o *TCC_Type) SetFCTRLB_CHSEL(value uint32) {
	volatile.StoreUint32(&o.FCTRLB.Reg, volatile.LoadUint32(&o.FCTRLB.Reg)&^(0xc00)|value<<10)
}
func (o *TCC_Type) GetFCTRLB_CHSEL() uint32 {
	return (volatile.LoadUint32(&o.FCTRLB.Reg) & 0xc00) >> 10
}
func (o *TCC_Type) SetFCTRLB_CAPTURE(value uint32) {
	volatile.StoreUint32(&o.FCTRLB.Reg, volatile.LoadUint32(&o.FCTRLB.Reg)&^(0x7000)|value<<12)
}
func (o *TCC_Type) GetFCTRLB_CAPTURE() uint32 {
	return (volatile.LoadUint32(&o.FCTRLB.Reg) & 0x7000) >> 12
}
func (o *TCC_Type) SetFCTRLB_BLANKPRESC(value uint32) {
	volatile.StoreUint32(&o.FCTRLB.Reg, volatile.LoadUint32(&o.FCTRLB.Reg)&^(0x8000)|value<<15)
}
func (o *TCC_Type) GetFCTRLB_BLANKPRESC() uint32 {
	return (volatile.LoadUint32(&o.FCTRLB.Reg) & 0x8000) >> 15
}
func (o *TCC_Type) SetFCTRLB_BLANKVAL(value uint32) {
	volatile.StoreUint32(&o.FCTRLB.Reg, volatile.LoadUint32(&o.FCTRLB.Reg)&^(0xff0000)|value<<16)
}
func (o *TCC_Type) GetFCTRLB_BLANKVAL() uint32 {
	return (volatile.LoadUint32(&o.FCTRLB.Reg) & 0xff0000) >> 16
}
func (o *TCC_Type) SetFCTRLB_FILTERVAL(value uint32) {
	volatile.StoreUint32(&o.FCTRLB.Reg, volatile.LoadUint32(&o.FCTRLB.Reg)&^(0xf000000)|value<<24)
}
func (o *TCC_Type) GetFCTRLB_FILTERVAL() uint32 {
	return (volatile.LoadUint32(&o.FCTRLB.Reg) & 0xf000000) >> 24
}

// TCC.WEXCTRL: Waveform Extension Configuration
func (o *TCC_Type) SetWEXCTRL_OTMX(value uint32) {
	volatile.StoreUint32(&o.WEXCTRL.Reg, volatile.LoadUint32(&o.WEXCTRL.Reg)&^(0x3)|value)
}
func (o *TCC_Type) GetWEXCTRL_OTMX() uint32 {
	return volatile.LoadUint32(&o.WEXCTRL.Reg) & 0x3
}
func (o *TCC_Type) SetWEXCTRL_DTIEN0(value uint32) {
	volatile.StoreUint32(&o.WEXCTRL.Reg, volatile.LoadUint32(&o.WEXCTRL.Reg)&^(0x100)|value<<8)
}
func (o *TCC_Type) GetWEXCTRL_DTIEN0() uint32 {
	return (volatile.LoadUint32(&o.WEXCTRL.Reg) & 0x100) >> 8
}
func (o *TCC_Type) SetWEXCTRL_DTIEN1(value uint32) {
	volatile.StoreUint32(&o.WEXCTRL.Reg, volatile.LoadUint32(&o.WEXCTRL.Reg)&^(0x200)|value<<9)
}
func (o *TCC_Type) GetWEXCTRL_DTIEN1() uint32 {
	return (volatile.LoadUint32(&o.WEXCTRL.Reg) & 0x200) >> 9
}
func (o *TCC_Type) SetWEXCTRL_DTIEN2(value uint32) {
	volatile.StoreUint32(&o.WEXCTRL.Reg, volatile.LoadUint32(&o.WEXCTRL.Reg)&^(0x400)|value<<10)
}
func (o *TCC_Type) GetWEXCTRL_DTIEN2() uint32 {
	return (volatile.LoadUint32(&o.WEXCTRL.Reg) & 0x400) >> 10
}
func (o *TCC_Type) SetWEXCTRL_DTIEN3(value uint32) {
	volatile.StoreUint32(&o.WEXCTRL.Reg, volatile.LoadUint32(&o.WEXCTRL.Reg)&^(0x800)|value<<11)
}
func (o *TCC_Type) GetWEXCTRL_DTIEN3() uint32 {
	return (volatile.LoadUint32(&o.WEXCTRL.Reg) & 0x800) >> 11
}
func (o *TCC_Type) SetWEXCTRL_DTLS(value uint32) {
	volatile.StoreUint32(&o.WEXCTRL.Reg, volatile.LoadUint32(&o.WEXCTRL.Reg)&^(0xff0000)|value<<16)
}
func (o *TCC_Type) GetWEXCTRL_DTLS() uint32 {
	return (volatile.LoadUint32(&o.WEXCTRL.Reg) & 0xff0000) >> 16
}
func (o *TCC_Type) SetWEXCTRL_DTHS(value uint32) {
	volatile.StoreUint32(&o.WEXCTRL.Reg, volatile.LoadUint32(&o.WEXCTRL.Reg)&^(0xff000000)|value<<24)
}
func (o *TCC_Type) GetWEXCTRL_DTHS() uint32 {
	return (volatile.LoadUint32(&o.WEXCTRL.Reg) & 0xff000000) >> 24
}

// TCC.DRVCTRL: Driver Control
func (o *TCC_Type) SetDRVCTRL_NRE0(value uint32) {
	volatile.StoreUint32(&o.DRVCTRL.Reg, volatile.LoadUint32(&o.DRVCTRL.Reg)&^(0x1)|value)
}
func (o *TCC_Type) GetDRVCTRL_NRE0() uint32 {
	return volatile.LoadUint32(&o.DRVCTRL.Reg) & 0x1
}
func (o *TCC_Type) SetDRVCTRL_NRE1(value uint32) {
	volatile.StoreUint32(&o.DRVCTRL.Reg, volatile.LoadUint32(&o.DRVCTRL.Reg)&^(0x2)|value<<1)
}
func (o *TCC_Type) GetDRVCTRL_NRE1() uint32 {
	return (volatile.LoadUint32(&o.DRVCTRL.Reg) & 0x2) >> 1
}
func (o *TCC_Type) SetDRVCTRL_NRE2(value uint32) {
	volatile.StoreUint32(&o.DRVCTRL.Reg, volatile.LoadUint32(&o.DRVCTRL.Reg)&^(0x4)|value<<2)
}
func (o *TCC_Type) GetDRVCTRL_NRE2() uint32 {
	return (volatile.LoadUint32(&o.DRVCTRL.Reg) & 0x4) >> 2
}
func (o *TCC_Type) SetDRVCTRL_NRE3(value uint32) {
	volatile.StoreUint32(&o.DRVCTRL.Reg, volatile.LoadUint32(&o.DRVCTRL.Reg)&^(0x8)|value<<3)
}
func (o *TCC_Type) GetDRVCTRL_NRE3() uint32 {
	return (volatile.LoadUint32(&o.DRVCTRL.Reg) & 0x8) >> 3
}
func (o *TCC_Type) SetDRVCTRL_NRE4(value uint32) {
	volatile.StoreUint32(&o.DRVCTRL.Reg, volatile.LoadUint32(&o.DRVCTRL.Reg)&^(0x10)|value<<4)
}
func (o *TCC_Type) GetDRVCTRL_NRE4() uint32 {
	return (volatile.LoadUint32(&o.DRVCTRL.Reg) & 0x10) >> 4
}
func (o *TCC_Type) SetDRVCTRL_NRE5(value uint32) {
	volatile.StoreUint32(&o.DRVCTRL.Reg, volatile.LoadUint32(&o.DRVCTRL.Reg)&^(0x20)|value<<5)
}
func (o *TCC_Type) GetDRVCTRL_NRE5() uint32 {
	return (volatile.LoadUint32(&o.DRVCTRL.Reg) & 0x20) >> 5
}
func (o *TCC_Type) SetDRVCTRL_NRE6(value uint32) {
	volatile.StoreUint32(&o.DRVCTRL.Reg, volatile.LoadUint32(&o.DRVCTRL.Reg)&^(0x40)|value<<6)
}
func (o *TCC_Type) GetDRVCTRL_NRE6() uint32 {
	return (volatile.LoadUint32(&o.DRVCTRL.Reg) & 0x40) >> 6
}
func (o *TCC_Type) SetDRVCTRL_NRE7(value uint32) {
	volatile.StoreUint32(&o.DRVCTRL.Reg, volatile.LoadUint32(&o.DRVCTRL.Reg)&^(0x80)|value<<7)
}
func (o *TCC_Type) GetDRVCTRL_NRE7() uint32 {
	return (volatile.LoadUint32(&o.DRVCTRL.Reg) & 0x80) >> 7
}
func (o *TCC_Type) SetDRVCTRL_NRV0(value uint32) {
	volatile.StoreUint32(&o.DRVCTRL.Reg, volatile.LoadUint32(&o.DRVCTRL.Reg)&^(0x100)|value<<8)
}
func (o *TCC_Type) GetDRVCTRL_NRV0() uint32 {
	return (volatile.LoadUint32(&o.DRVCTRL.Reg) & 0x100) >> 8
}
func (o *TCC_Type) SetDRVCTRL_NRV1(value uint32) {
	volatile.StoreUint32(&o.DRVCTRL.Reg, volatile.LoadUint32(&o.DRVCTRL.Reg)&^(0x200)|value<<9)
}
func (o *TCC_Type) GetDRVCTRL_NRV1() uint32 {
	return (volatile.LoadUint32(&o.DRVCTRL.Reg) & 0x200) >> 9
}
func (o *TCC_Type) SetDRVCTRL_NRV2(value uint32) {
	volatile.StoreUint32(&o.DRVCTRL.Reg, volatile.LoadUint32(&o.DRVCTRL.Reg)&^(0x400)|value<<10)
}
func (o *TCC_Type) GetDRVCTRL_NRV2() uint32 {
	return (volatile.LoadUint32(&o.DRVCTRL.Reg) & 0x400) >> 10
}
func (o *TCC_Type) SetDRVCTRL_NRV3(value uint32) {
	volatile.StoreUint32(&o.DRVCTRL.Reg, volatile.LoadUint32(&o.DRVCTRL.Reg)&^(0x800)|value<<11)
}
func (o *TCC_Type) GetDRVCTRL_NRV3() uint32 {
	return (volatile.LoadUint32(&o.DRVCTRL.Reg) & 0x800) >> 11
}
func (o *TCC_Type) SetDRVCTRL_NRV4(value uint32) {
	volatile.StoreUint32(&o.DRVCTRL.Reg, volatile.LoadUint32(&o.DRVCTRL.Reg)&^(0x1000)|value<<12)
}
func (o *TCC_Type) GetDRVCTRL_NRV4() uint32 {
	return (volatile.LoadUint32(&o.DRVCTRL.Reg) & 0x1000) >> 12
}
func (o *TCC_Type) SetDRVCTRL_NRV5(value uint32) {
	volatile.StoreUint32(&o.DRVCTRL.Reg, volatile.LoadUint32(&o.DRVCTRL.Reg)&^(0x2000)|value<<13)
}
func (o *TCC_Type) GetDRVCTRL_NRV5() uint32 {
	return (volatile.LoadUint32(&o.DRVCTRL.Reg) & 0x2000) >> 13
}
func (o *TCC_Type) SetDRVCTRL_NRV6(value uint32) {
	volatile.StoreUint32(&o.DRVCTRL.Reg, volatile.LoadUint32(&o.DRVCTRL.Reg)&^(0x4000)|value<<14)
}
func (o *TCC_Type) GetDRVCTRL_NRV6() uint32 {
	return (volatile.LoadUint32(&o.DRVCTRL.Reg) & 0x4000) >> 14
}
func (o *TCC_Type) SetDRVCTRL_NRV7(value uint32) {
	volatile.StoreUint32(&o.DRVCTRL.Reg, volatile.LoadUint32(&o.DRVCTRL.Reg)&^(0x8000)|value<<15)
}
func (o *TCC_Type) GetDRVCTRL_NRV7() uint32 {
	return (volatile.LoadUint32(&o.DRVCTRL.Reg) & 0x8000) >> 15
}
func (o *TCC_Type) SetDRVCTRL_INVEN0(value uint32) {
	volatile.StoreUint32(&o.DRVCTRL.Reg, volatile.LoadUint32(&o.DRVCTRL.Reg)&^(0x10000)|value<<16)
}
func (o *TCC_Type) GetDRVCTRL_INVEN0() uint32 {
	return (volatile.LoadUint32(&o.DRVCTRL.Reg) & 0x10000) >> 16
}
func (o *TCC_Type) SetDRVCTRL_INVEN1(value uint32) {
	volatile.StoreUint32(&o.DRVCTRL.Reg, volatile.LoadUint32(&o.DRVCTRL.Reg)&^(0x20000)|value<<17)
}
func (o *TCC_Type) GetDRVCTRL_INVEN1() uint32 {
	return (volatile.LoadUint32(&o.DRVCTRL.Reg) & 0x20000) >> 17
}
func (o *TCC_Type) SetDRVCTRL_INVEN2(value uint32) {
	volatile.StoreUint32(&o.DRVCTRL.Reg, volatile.LoadUint32(&o.DRVCTRL.Reg)&^(0x40000)|value<<18)
}
func (o *TCC_Type) GetDRVCTRL_INVEN2() uint32 {
	return (volatile.LoadUint32(&o.DRVCTRL.Reg) & 0x40000) >> 18
}
func (o *TCC_Type) SetDRVCTRL_INVEN3(value uint32) {
	volatile.StoreUint32(&o.DRVCTRL.Reg, volatile.LoadUint32(&o.DRVCTRL.Reg)&^(0x80000)|value<<19)
}
func (o *TCC_Type) GetDRVCTRL_INVEN3() uint32 {
	return (volatile.LoadUint32(&o.DRVCTRL.Reg) & 0x80000) >> 19
}
func (o *TCC_Type) SetDRVCTRL_INVEN4(value uint32) {
	volatile.StoreUint32(&o.DRVCTRL.Reg, volatile.LoadUint32(&o.DRVCTRL.Reg)&^(0x100000)|value<<20)
}
func (o *TCC_Type) GetDRVCTRL_INVEN4() uint32 {
	return (volatile.LoadUint32(&o.DRVCTRL.Reg) & 0x100000) >> 20
}
func (o *TCC_Type) SetDRVCTRL_INVEN5(value uint32) {
	volatile.StoreUint32(&o.DRVCTRL.Reg, volatile.LoadUint32(&o.DRVCTRL.Reg)&^(0x200000)|value<<21)
}
func (o *TCC_Type) GetDRVCTRL_INVEN5() uint32 {
	return (volatile.LoadUint32(&o.DRVCTRL.Reg) & 0x200000) >> 21
}
func (o *TCC_Type) SetDRVCTRL_INVEN6(value uint32) {
	volatile.StoreUint32(&o.DRVCTRL.Reg, volatile.LoadUint32(&o.DRVCTRL.Reg)&^(0x400000)|value<<22)
}
func (o *TCC_Type) GetDRVCTRL_INVEN6() uint32 {
	return (volatile.LoadUint32(&o.DRVCTRL.Reg) & 0x400000) >> 22
}
func (o *TCC_Type) SetDRVCTRL_INVEN7(value uint32) {
	volatile.StoreUint32(&o.DRVCTRL.Reg, volatile.LoadUint32(&o.DRVCTRL.Reg)&^(0x800000)|value<<23)
}
func (o *TCC_Type) GetDRVCTRL_INVEN7() uint32 {
	return (volatile.LoadUint32(&o.DRVCTRL.Reg) & 0x800000) >> 23
}
func (o *TCC_Type) SetDRVCTRL_FILTERVAL0(value uint32) {
	volatile.StoreUint32(&o.DRVCTRL.Reg, volatile.LoadUint32(&o.DRVCTRL.Reg)&^(0xf000000)|value<<24)
}
func (o *TCC_Type) GetDRVCTRL_FILTERVAL0() uint32 {
	return (volatile.LoadUint32(&o.DRVCTRL.Reg) & 0xf000000) >> 24
}
func (o *TCC_Type) SetDRVCTRL_FILTERVAL1(value uint32) {
	volatile.StoreUint32(&o.DRVCTRL.Reg, volatile.LoadUint32(&o.DRVCTRL.Reg)&^(0xf0000000)|value<<28)
}
func (o *TCC_Type) GetDRVCTRL_FILTERVAL1() uint32 {
	return (volatile.LoadUint32(&o.DRVCTRL.Reg) & 0xf0000000) >> 28
}

// TCC.DBGCTRL: Debug Control
func (o *TCC_Type) SetDBGCTRL_DBGRUN(value uint8) {
	volatile.StoreUint8(&o.DBGCTRL.Reg, volatile.LoadUint8(&o.DBGCTRL.Reg)&^(0x1)|value)
}
func (o *TCC_Type) GetDBGCTRL_DBGRUN() uint8 {
	return volatile.LoadUint8(&o.DBGCTRL.Reg) & 0x1
}
func (o *TCC_Type) SetDBGCTRL_FDDBD(value uint8) {
	volatile.StoreUint8(&o.DBGCTRL.Reg, volatile.LoadUint8(&o.DBGCTRL.Reg)&^(0x4)|value<<2)
}
func (o *TCC_Type) GetDBGCTRL_FDDBD() uint8 {
	return (volatile.LoadUint8(&o.DBGCTRL.Reg) & 0x4) >> 2
}

// TCC.EVCTRL: Event Control
func (o *TCC_Type) SetEVCTRL_EVACT0(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x7)|value)
}
func (o *TCC_Type) GetEVCTRL_EVACT0() uint32 {
	return volatile.LoadUint32(&o.EVCTRL.Reg) & 0x7
}
func (o *TCC_Type) SetEVCTRL_EVACT1(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x38)|value<<3)
}
func (o *TCC_Type) GetEVCTRL_EVACT1() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x38) >> 3
}
func (o *TCC_Type) SetEVCTRL_CNTSEL(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0xc0)|value<<6)
}
func (o *TCC_Type) GetEVCTRL_CNTSEL() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0xc0) >> 6
}
func (o *TCC_Type) SetEVCTRL_OVFEO(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x100)|value<<8)
}
func (o *TCC_Type) GetEVCTRL_OVFEO() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x100) >> 8
}
func (o *TCC_Type) SetEVCTRL_TRGEO(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x200)|value<<9)
}
func (o *TCC_Type) GetEVCTRL_TRGEO() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x200) >> 9
}
func (o *TCC_Type) SetEVCTRL_CNTEO(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x400)|value<<10)
}
func (o *TCC_Type) GetEVCTRL_CNTEO() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x400) >> 10
}
func (o *TCC_Type) SetEVCTRL_TCINV0(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x1000)|value<<12)
}
func (o *TCC_Type) GetEVCTRL_TCINV0() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x1000) >> 12
}
func (o *TCC_Type) SetEVCTRL_TCINV1(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x2000)|value<<13)
}
func (o *TCC_Type) GetEVCTRL_TCINV1() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x2000) >> 13
}
func (o *TCC_Type) SetEVCTRL_TCEI0(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x4000)|value<<14)
}
func (o *TCC_Type) GetEVCTRL_TCEI0() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x4000) >> 14
}
func (o *TCC_Type) SetEVCTRL_TCEI1(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x8000)|value<<15)
}
func (o *TCC_Type) GetEVCTRL_TCEI1() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x8000) >> 15
}
func (o *TCC_Type) SetEVCTRL_MCEI0(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x10000)|value<<16)
}
func (o *TCC_Type) GetEVCTRL_MCEI0() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x10000) >> 16
}
func (o *TCC_Type) SetEVCTRL_MCEI1(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x20000)|value<<17)
}
func (o *TCC_Type) GetEVCTRL_MCEI1() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x20000) >> 17
}
func (o *TCC_Type) SetEVCTRL_MCEI2(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x40000)|value<<18)
}
func (o *TCC_Type) GetEVCTRL_MCEI2() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x40000) >> 18
}
func (o *TCC_Type) SetEVCTRL_MCEI3(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x80000)|value<<19)
}
func (o *TCC_Type) GetEVCTRL_MCEI3() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x80000) >> 19
}
func (o *TCC_Type) SetEVCTRL_MCEO0(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x1000000)|value<<24)
}
func (o *TCC_Type) GetEVCTRL_MCEO0() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x1000000) >> 24
}
func (o *TCC_Type) SetEVCTRL_MCEO1(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x2000000)|value<<25)
}
func (o *TCC_Type) GetEVCTRL_MCEO1() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x2000000) >> 25
}
func (o *TCC_Type) SetEVCTRL_MCEO2(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x4000000)|value<<26)
}
func (o *TCC_Type) GetEVCTRL_MCEO2() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x4000000) >> 26
}
func (o *TCC_Type) SetEVCTRL_MCEO3(value uint32) {
	volatile.StoreUint32(&o.EVCTRL.Reg, volatile.LoadUint32(&o.EVCTRL.Reg)&^(0x8000000)|value<<27)
}
func (o *TCC_Type) GetEVCTRL_MCEO3() uint32 {
	return (volatile.LoadUint32(&o.EVCTRL.Reg) & 0x8000000) >> 27
}

// TCC.INTENCLR: Interrupt Enable Clear
func (o *TCC_Type) SetINTENCLR_OVF(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *TCC_Type) GetINTENCLR_OVF() uint32 {
	return volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1
}
func (o *TCC_Type) SetINTENCLR_TRG(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *TCC_Type) GetINTENCLR_TRG() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *TCC_Type) SetINTENCLR_CNT(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x4)|value<<2)
}
func (o *TCC_Type) GetINTENCLR_CNT() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x4) >> 2
}
func (o *TCC_Type) SetINTENCLR_ERR(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x8)|value<<3)
}
func (o *TCC_Type) GetINTENCLR_ERR() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x8) >> 3
}
func (o *TCC_Type) SetINTENCLR_UFS(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x400)|value<<10)
}
func (o *TCC_Type) GetINTENCLR_UFS() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x400) >> 10
}
func (o *TCC_Type) SetINTENCLR_DFS(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x800)|value<<11)
}
func (o *TCC_Type) GetINTENCLR_DFS() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x800) >> 11
}
func (o *TCC_Type) SetINTENCLR_FAULTA(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x1000)|value<<12)
}
func (o *TCC_Type) GetINTENCLR_FAULTA() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x1000) >> 12
}
func (o *TCC_Type) SetINTENCLR_FAULTB(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x2000)|value<<13)
}
func (o *TCC_Type) GetINTENCLR_FAULTB() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x2000) >> 13
}
func (o *TCC_Type) SetINTENCLR_FAULT0(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x4000)|value<<14)
}
func (o *TCC_Type) GetINTENCLR_FAULT0() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x4000) >> 14
}
func (o *TCC_Type) SetINTENCLR_FAULT1(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x8000)|value<<15)
}
func (o *TCC_Type) GetINTENCLR_FAULT1() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x8000) >> 15
}
func (o *TCC_Type) SetINTENCLR_MC0(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x10000)|value<<16)
}
func (o *TCC_Type) GetINTENCLR_MC0() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x10000) >> 16
}
func (o *TCC_Type) SetINTENCLR_MC1(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x20000)|value<<17)
}
func (o *TCC_Type) GetINTENCLR_MC1() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x20000) >> 17
}
func (o *TCC_Type) SetINTENCLR_MC2(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x40000)|value<<18)
}
func (o *TCC_Type) GetINTENCLR_MC2() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x40000) >> 18
}
func (o *TCC_Type) SetINTENCLR_MC3(value uint32) {
	volatile.StoreUint32(&o.INTENCLR.Reg, volatile.LoadUint32(&o.INTENCLR.Reg)&^(0x80000)|value<<19)
}
func (o *TCC_Type) GetINTENCLR_MC3() uint32 {
	return (volatile.LoadUint32(&o.INTENCLR.Reg) & 0x80000) >> 19
}

// TCC.INTENSET: Interrupt Enable Set
func (o *TCC_Type) SetINTENSET_OVF(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *TCC_Type) GetINTENSET_OVF() uint32 {
	return volatile.LoadUint32(&o.INTENSET.Reg) & 0x1
}
func (o *TCC_Type) SetINTENSET_TRG(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *TCC_Type) GetINTENSET_TRG() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *TCC_Type) SetINTENSET_CNT(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x4)|value<<2)
}
func (o *TCC_Type) GetINTENSET_CNT() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x4) >> 2
}
func (o *TCC_Type) SetINTENSET_ERR(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x8)|value<<3)
}
func (o *TCC_Type) GetINTENSET_ERR() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x8) >> 3
}
func (o *TCC_Type) SetINTENSET_UFS(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x400)|value<<10)
}
func (o *TCC_Type) GetINTENSET_UFS() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x400) >> 10
}
func (o *TCC_Type) SetINTENSET_DFS(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x800)|value<<11)
}
func (o *TCC_Type) GetINTENSET_DFS() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x800) >> 11
}
func (o *TCC_Type) SetINTENSET_FAULTA(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x1000)|value<<12)
}
func (o *TCC_Type) GetINTENSET_FAULTA() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x1000) >> 12
}
func (o *TCC_Type) SetINTENSET_FAULTB(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x2000)|value<<13)
}
func (o *TCC_Type) GetINTENSET_FAULTB() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x2000) >> 13
}
func (o *TCC_Type) SetINTENSET_FAULT0(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x4000)|value<<14)
}
func (o *TCC_Type) GetINTENSET_FAULT0() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x4000) >> 14
}
func (o *TCC_Type) SetINTENSET_FAULT1(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x8000)|value<<15)
}
func (o *TCC_Type) GetINTENSET_FAULT1() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x8000) >> 15
}
func (o *TCC_Type) SetINTENSET_MC0(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x10000)|value<<16)
}
func (o *TCC_Type) GetINTENSET_MC0() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x10000) >> 16
}
func (o *TCC_Type) SetINTENSET_MC1(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x20000)|value<<17)
}
func (o *TCC_Type) GetINTENSET_MC1() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x20000) >> 17
}
func (o *TCC_Type) SetINTENSET_MC2(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x40000)|value<<18)
}
func (o *TCC_Type) GetINTENSET_MC2() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x40000) >> 18
}
func (o *TCC_Type) SetINTENSET_MC3(value uint32) {
	volatile.StoreUint32(&o.INTENSET.Reg, volatile.LoadUint32(&o.INTENSET.Reg)&^(0x80000)|value<<19)
}
func (o *TCC_Type) GetINTENSET_MC3() uint32 {
	return (volatile.LoadUint32(&o.INTENSET.Reg) & 0x80000) >> 19
}

// TCC.INTFLAG: Interrupt Flag Status and Clear
func (o *TCC_Type) SetINTFLAG_OVF(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x1)|value)
}
func (o *TCC_Type) GetINTFLAG_OVF() uint32 {
	return volatile.LoadUint32(&o.INTFLAG.Reg) & 0x1
}
func (o *TCC_Type) SetINTFLAG_TRG(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x2)|value<<1)
}
func (o *TCC_Type) GetINTFLAG_TRG() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x2) >> 1
}
func (o *TCC_Type) SetINTFLAG_CNT(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x4)|value<<2)
}
func (o *TCC_Type) GetINTFLAG_CNT() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x4) >> 2
}
func (o *TCC_Type) SetINTFLAG_ERR(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x8)|value<<3)
}
func (o *TCC_Type) GetINTFLAG_ERR() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x8) >> 3
}
func (o *TCC_Type) SetINTFLAG_UFS(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x400)|value<<10)
}
func (o *TCC_Type) GetINTFLAG_UFS() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x400) >> 10
}
func (o *TCC_Type) SetINTFLAG_DFS(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x800)|value<<11)
}
func (o *TCC_Type) GetINTFLAG_DFS() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x800) >> 11
}
func (o *TCC_Type) SetINTFLAG_FAULTA(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x1000)|value<<12)
}
func (o *TCC_Type) GetINTFLAG_FAULTA() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x1000) >> 12
}
func (o *TCC_Type) SetINTFLAG_FAULTB(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x2000)|value<<13)
}
func (o *TCC_Type) GetINTFLAG_FAULTB() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x2000) >> 13
}
func (o *TCC_Type) SetINTFLAG_FAULT0(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x4000)|value<<14)
}
func (o *TCC_Type) GetINTFLAG_FAULT0() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x4000) >> 14
}
func (o *TCC_Type) SetINTFLAG_FAULT1(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x8000)|value<<15)
}
func (o *TCC_Type) GetINTFLAG_FAULT1() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x8000) >> 15
}
func (o *TCC_Type) SetINTFLAG_MC0(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x10000)|value<<16)
}
func (o *TCC_Type) GetINTFLAG_MC0() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x10000) >> 16
}
func (o *TCC_Type) SetINTFLAG_MC1(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x20000)|value<<17)
}
func (o *TCC_Type) GetINTFLAG_MC1() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x20000) >> 17
}
func (o *TCC_Type) SetINTFLAG_MC2(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x40000)|value<<18)
}
func (o *TCC_Type) GetINTFLAG_MC2() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x40000) >> 18
}
func (o *TCC_Type) SetINTFLAG_MC3(value uint32) {
	volatile.StoreUint32(&o.INTFLAG.Reg, volatile.LoadUint32(&o.INTFLAG.Reg)&^(0x80000)|value<<19)
}
func (o *TCC_Type) GetINTFLAG_MC3() uint32 {
	return (volatile.LoadUint32(&o.INTFLAG.Reg) & 0x80000) >> 19
}

// TCC.STATUS: Status
func (o *TCC_Type) SetSTATUS_STOP(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x1)|value)
}
func (o *TCC_Type) GetSTATUS_STOP() uint32 {
	return volatile.LoadUint32(&o.STATUS.Reg) & 0x1
}
func (o *TCC_Type) SetSTATUS_IDX(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x2)|value<<1)
}
func (o *TCC_Type) GetSTATUS_IDX() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x2) >> 1
}
func (o *TCC_Type) SetSTATUS_UFS(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x4)|value<<2)
}
func (o *TCC_Type) GetSTATUS_UFS() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x4) >> 2
}
func (o *TCC_Type) SetSTATUS_DFS(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x8)|value<<3)
}
func (o *TCC_Type) GetSTATUS_DFS() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x8) >> 3
}
func (o *TCC_Type) SetSTATUS_SLAVE(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x10)|value<<4)
}
func (o *TCC_Type) GetSTATUS_SLAVE() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x10) >> 4
}
func (o *TCC_Type) SetSTATUS_PATTBUFV(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x20)|value<<5)
}
func (o *TCC_Type) GetSTATUS_PATTBUFV() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x20) >> 5
}
func (o *TCC_Type) SetSTATUS_PERBUFV(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x80)|value<<7)
}
func (o *TCC_Type) GetSTATUS_PERBUFV() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x80) >> 7
}
func (o *TCC_Type) SetSTATUS_FAULTAIN(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x100)|value<<8)
}
func (o *TCC_Type) GetSTATUS_FAULTAIN() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x100) >> 8
}
func (o *TCC_Type) SetSTATUS_FAULTBIN(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x200)|value<<9)
}
func (o *TCC_Type) GetSTATUS_FAULTBIN() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x200) >> 9
}
func (o *TCC_Type) SetSTATUS_FAULT0IN(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x400)|value<<10)
}
func (o *TCC_Type) GetSTATUS_FAULT0IN() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x400) >> 10
}
func (o *TCC_Type) SetSTATUS_FAULT1IN(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x800)|value<<11)
}
func (o *TCC_Type) GetSTATUS_FAULT1IN() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x800) >> 11
}
func (o *TCC_Type) SetSTATUS_FAULTA(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x1000)|value<<12)
}
func (o *TCC_Type) GetSTATUS_FAULTA() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x1000) >> 12
}
func (o *TCC_Type) SetSTATUS_FAULTB(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x2000)|value<<13)
}
func (o *TCC_Type) GetSTATUS_FAULTB() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x2000) >> 13
}
func (o *TCC_Type) SetSTATUS_FAULT0(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x4000)|value<<14)
}
func (o *TCC_Type) GetSTATUS_FAULT0() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x4000) >> 14
}
func (o *TCC_Type) SetSTATUS_FAULT1(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x8000)|value<<15)
}
func (o *TCC_Type) GetSTATUS_FAULT1() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x8000) >> 15
}
func (o *TCC_Type) SetSTATUS_CCBUFV0(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x10000)|value<<16)
}
func (o *TCC_Type) GetSTATUS_CCBUFV0() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x10000) >> 16
}
func (o *TCC_Type) SetSTATUS_CCBUFV1(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x20000)|value<<17)
}
func (o *TCC_Type) GetSTATUS_CCBUFV1() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x20000) >> 17
}
func (o *TCC_Type) SetSTATUS_CCBUFV2(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x40000)|value<<18)
}
func (o *TCC_Type) GetSTATUS_CCBUFV2() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x40000) >> 18
}
func (o *TCC_Type) SetSTATUS_CCBUFV3(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x80000)|value<<19)
}
func (o *TCC_Type) GetSTATUS_CCBUFV3() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x80000) >> 19
}
func (o *TCC_Type) SetSTATUS_CMP0(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x1000000)|value<<24)
}
func (o *TCC_Type) GetSTATUS_CMP0() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x1000000) >> 24
}
func (o *TCC_Type) SetSTATUS_CMP1(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x2000000)|value<<25)
}
func (o *TCC_Type) GetSTATUS_CMP1() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x2000000) >> 25
}
func (o *TCC_Type) SetSTATUS_CMP2(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x4000000)|value<<26)
}
func (o *TCC_Type) GetSTATUS_CMP2() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x4000000) >> 26
}
func (o *TCC_Type) SetSTATUS_CMP3(value uint32) {
	volatile.StoreUint32(&o.STATUS.Reg, volatile.LoadUint32(&o.STATUS.Reg)&^(0x8000000)|value<<27)
}
func (o *TCC_Type) GetSTATUS_CMP3() uint32 {
	return (volatile.LoadUint32(&o.STATUS.Reg) & 0x8000000) >> 27
}

// TCC.COUNT: Count
func (o *TCC_Type) SetCOUNT(value uint32) {
	volatile.StoreUint32(&o.COUNT.Reg, volatile.LoadUint32(&o.COUNT.Reg)&^(0xffffff)|value)
}
func (o *TCC_Type) GetCOUNT() uint32 {
	return volatile.LoadUint32(&o.COUNT.Reg) & 0xffffff
}

// TCC.PATT: Pattern
func (o *TCC_Type) SetPATT_PGE0(value uint16) {
	volatile.StoreUint16(&o.PATT.Reg, volatile.LoadUint16(&o.PATT.Reg)&^(0x1)|value)
}
func (o *TCC_Type) GetPATT_PGE0() uint16 {
	return volatile.LoadUint16(&o.PATT.Reg) & 0x1
}
func (o *TCC_Type) SetPATT_PGE1(value uint16) {
	volatile.StoreUint16(&o.PATT.Reg, volatile.LoadUint16(&o.PATT.Reg)&^(0x2)|value<<1)
}
func (o *TCC_Type) GetPATT_PGE1() uint16 {
	return (volatile.LoadUint16(&o.PATT.Reg) & 0x2) >> 1
}
func (o *TCC_Type) SetPATT_PGE2(value uint16) {
	volatile.StoreUint16(&o.PATT.Reg, volatile.LoadUint16(&o.PATT.Reg)&^(0x4)|value<<2)
}
func (o *TCC_Type) GetPATT_PGE2() uint16 {
	return (volatile.LoadUint16(&o.PATT.Reg) & 0x4) >> 2
}
func (o *TCC_Type) SetPATT_PGE3(value uint16) {
	volatile.StoreUint16(&o.PATT.Reg, volatile.LoadUint16(&o.PATT.Reg)&^(0x8)|value<<3)
}
func (o *TCC_Type) GetPATT_PGE3() uint16 {
	return (volatile.LoadUint16(&o.PATT.Reg) & 0x8) >> 3
}
func (o *TCC_Type) SetPATT_PGE4(value uint16) {
	volatile.StoreUint16(&o.PATT.Reg, volatile.LoadUint16(&o.PATT.Reg)&^(0x10)|value<<4)
}
func (o *TCC_Type) GetPATT_PGE4() uint16 {
	return (volatile.LoadUint16(&o.PATT.Reg) & 0x10) >> 4
}
func (o *TCC_Type) SetPATT_PGE5(value uint16) {
	volatile.StoreUint16(&o.PATT.Reg, volatile.LoadUint16(&o.PATT.Reg)&^(0x20)|value<<5)
}
func (o *TCC_Type) GetPATT_PGE5() uint16 {
	return (volatile.LoadUint16(&o.PATT.Reg) & 0x20) >> 5
}
func (o *TCC_Type) SetPATT_PGE6(value uint16) {
	volatile.StoreUint16(&o.PATT.Reg, volatile.LoadUint16(&o.PATT.Reg)&^(0x40)|value<<6)
}
func (o *TCC_Type) GetPATT_PGE6() uint16 {
	return (volatile.LoadUint16(&o.PATT.Reg) & 0x40) >> 6
}
func (o *TCC_Type) SetPATT_PGE7(value uint16) {
	volatile.StoreUint16(&o.PATT.Reg, volatile.LoadUint16(&o.PATT.Reg)&^(0x80)|value<<7)
}
func (o *TCC_Type) GetPATT_PGE7() uint16 {
	return (volatile.LoadUint16(&o.PATT.Reg) & 0x80) >> 7
}
func (o *TCC_Type) SetPATT_PGV0(value uint16) {
	volatile.StoreUint16(&o.PATT.Reg, volatile.LoadUint16(&o.PATT.Reg)&^(0x100)|value<<8)
}
func (o *TCC_Type) GetPATT_PGV0() uint16 {
	return (volatile.LoadUint16(&o.PATT.Reg) & 0x100) >> 8
}
func (o *TCC_Type) SetPATT_PGV1(value uint16) {
	volatile.StoreUint16(&o.PATT.Reg, volatile.LoadUint16(&o.PATT.Reg)&^(0x200)|value<<9)
}
func (o *TCC_Type) GetPATT_PGV1() uint16 {
	return (volatile.LoadUint16(&o.PATT.Reg) & 0x200) >> 9
}
func (o *TCC_Type) SetPATT_PGV2(value uint16) {
	volatile.StoreUint16(&o.PATT.Reg, volatile.LoadUint16(&o.PATT.Reg)&^(0x400)|value<<10)
}
func (o *TCC_Type) GetPATT_PGV2() uint16 {
	return (volatile.LoadUint16(&o.PATT.Reg) & 0x400) >> 10
}
func (o *TCC_Type) SetPATT_PGV3(value uint16) {
	volatile.StoreUint16(&o.PATT.Reg, volatile.LoadUint16(&o.PATT.Reg)&^(0x800)|value<<11)
}
func (o *TCC_Type) GetPATT_PGV3() uint16 {
	return (volatile.LoadUint16(&o.PATT.Reg) & 0x800) >> 11
}
func (o *TCC_Type) SetPATT_PGV4(value uint16) {
	volatile.StoreUint16(&o.PATT.Reg, volatile.LoadUint16(&o.PATT.Reg)&^(0x1000)|value<<12)
}
func (o *TCC_Type) GetPATT_PGV4() uint16 {
	return (volatile.LoadUint16(&o.PATT.Reg) & 0x1000) >> 12
}
func (o *TCC_Type) SetPATT_PGV5(value uint16) {
	volatile.StoreUint16(&o.PATT.Reg, volatile.LoadUint16(&o.PATT.Reg)&^(0x2000)|value<<13)
}
func (o *TCC_Type) GetPATT_PGV5() uint16 {
	return (volatile.LoadUint16(&o.PATT.Reg) & 0x2000) >> 13
}
func (o *TCC_Type) SetPATT_PGV6(value uint16) {
	volatile.StoreUint16(&o.PATT.Reg, volatile.LoadUint16(&o.PATT.Reg)&^(0x4000)|value<<14)
}
func (o *TCC_Type) GetPATT_PGV6() uint16 {
	return (volatile.LoadUint16(&o.PATT.Reg) & 0x4000) >> 14
}
func (o *TCC_Type) SetPATT_PGV7(value uint16) {
	volatile.StoreUint16(&o.PATT.Reg, volatile.LoadUint16(&o.PATT.Reg)&^(0x8000)|value<<15)
}
func (o *TCC_Type) GetPATT_PGV7() uint16 {
	return (volatile.LoadUint16(&o.PATT.Reg) & 0x8000) >> 15
}

// TCC.WAVE: Waveform Control
func (o *TCC_Type) SetWAVE_WAVEGEN(value uint32) {
	volatile.StoreUint32(&o.WAVE.Reg, volatile.LoadUint32(&o.WAVE.Reg)&^(0x7)|value)
}
func (o *TCC_Type) GetWAVE_WAVEGEN() uint32 {
	return volatile.LoadUint32(&o.WAVE.Reg) & 0x7
}
func (o *TCC_Type) SetWAVE_RAMP(value uint32) {
	volatile.StoreUint32(&o.WAVE.Reg, volatile.LoadUint32(&o.WAVE.Reg)&^(0x30)|value<<4)
}
func (o *TCC_Type) GetWAVE_RAMP() uint32 {
	return (volatile.LoadUint32(&o.WAVE.Reg) & 0x30) >> 4
}
func (o *TCC_Type) SetWAVE_CIPEREN(value uint32) {
	volatile.StoreUint32(&o.WAVE.Reg, volatile.LoadUint32(&o.WAVE.Reg)&^(0x80)|value<<7)
}
func (o *TCC_Type) GetWAVE_CIPEREN() uint32 {
	return (volatile.LoadUint32(&o.WAVE.Reg) & 0x80) >> 7
}
func (o *TCC_Type) SetWAVE_CICCEN0(value uint32) {
	volatile.StoreUint32(&o.WAVE.Reg, volatile.LoadUint32(&o.WAVE.Reg)&^(0x100)|value<<8)
}
func (o *TCC_Type) GetWAVE_CICCEN0() uint32 {
	return (volatile.LoadUint32(&o.WAVE.Reg) & 0x100) >> 8
}
func (o *TCC_Type) SetWAVE_CICCEN1(value uint32) {
	volatile.StoreUint32(&o.WAVE.Reg, volatile.LoadUint32(&o.WAVE.Reg)&^(0x200)|value<<9)
}
func (o *TCC_Type) GetWAVE_CICCEN1() uint32 {
	return (volatile.LoadUint32(&o.WAVE.Reg) & 0x200) >> 9
}
func (o *TCC_Type) SetWAVE_CICCEN2(value uint32) {
	volatile.StoreUint32(&o.WAVE.Reg, volatile.LoadUint32(&o.WAVE.Reg)&^(0x400)|value<<10)
}
func (o *TCC_Type) GetWAVE_CICCEN2() uint32 {
	return (volatile.LoadUint32(&o.WAVE.Reg) & 0x400) >> 10
}
func (o *TCC_Type) SetWAVE_CICCEN3(value uint32) {
	volatile.StoreUint32(&o.WAVE.Reg, volatile.LoadUint32(&o.WAVE.Reg)&^(0x800)|value<<11)
}
func (o *TCC_Type) GetWAVE_CICCEN3() uint32 {
	return (volatile.LoadUint32(&o.WAVE.Reg) & 0x800) >> 11
}
func (o *TCC_Type) SetWAVE_POL0(value uint32) {
	volatile.StoreUint32(&o.WAVE.Reg, volatile.LoadUint32(&o.WAVE.Reg)&^(0x10000)|value<<16)
}
func (o *TCC_Type) GetWAVE_POL0() uint32 {
	return (volatile.LoadUint32(&o.WAVE.Reg) & 0x10000) >> 16
}
func (o *TCC_Type) SetWAVE_POL1(value uint32) {
	volatile.StoreUint32(&o.WAVE.Reg, volatile.LoadUint32(&o.WAVE.Reg)&^(0x20000)|value<<17)
}
func (o *TCC_Type) GetWAVE_POL1() uint32 {
	return (volatile.LoadUint32(&o.WAVE.Reg) & 0x20000) >> 17
}
func (o *TCC_Type) SetWAVE_POL2(value uint32) {
	volatile.StoreUint32(&o.WAVE.Reg, volatile.LoadUint32(&o.WAVE.Reg)&^(0x40000)|value<<18)
}
func (o *TCC_Type) GetWAVE_POL2() uint32 {
	return (volatile.LoadUint32(&o.WAVE.Reg) & 0x40000) >> 18
}
func (o *TCC_Type) SetWAVE_POL3(value uint32) {
	volatile.StoreUint32(&o.WAVE.Reg, volatile.LoadUint32(&o.WAVE.Reg)&^(0x80000)|value<<19)
}
func (o *TCC_Type) GetWAVE_POL3() uint32 {
	return (volatile.LoadUint32(&o.WAVE.Reg) & 0x80000) >> 19
}
func (o *TCC_Type) SetWAVE_SWAP0(value uint32) {
	volatile.StoreUint32(&o.WAVE.Reg, volatile.LoadUint32(&o.WAVE.Reg)&^(0x1000000)|value<<24)
}
func (o *TCC_Type) GetWAVE_SWAP0() uint32 {
	return (volatile.LoadUint32(&o.WAVE.Reg) & 0x1000000) >> 24
}
func (o *TCC_Type) SetWAVE_SWAP1(value uint32) {
	volatile.StoreUint32(&o.WAVE.Reg, volatile.LoadUint32(&o.WAVE.Reg)&^(0x2000000)|value<<25)
}
func (o *TCC_Type) GetWAVE_SWAP1() uint32 {
	return (volatile.LoadUint32(&o.WAVE.Reg) & 0x2000000) >> 25
}
func (o *TCC_Type) SetWAVE_SWAP2(value uint32) {
	volatile.StoreUint32(&o.WAVE.Reg, volatile.LoadUint32(&o.WAVE.Reg)&^(0x4000000)|value<<26)
}
func (o *TCC_Type) GetWAVE_SWAP2() uint32 {
	return (volatile.LoadUint32(&o.WAVE.Reg) & 0x4000000) >> 26
}
func (o *TCC_Type) SetWAVE_SWAP3(value uint32) {
	volatile.StoreUint32(&o.WAVE.Reg, volatile.LoadUint32(&o.WAVE.Reg)&^(0x8000000)|value<<27)
}
func (o *TCC_Type) GetWAVE_SWAP3() uint32 {
	return (volatile.LoadUint32(&o.WAVE.Reg) & 0x8000000) >> 27
}

// TCC.PER: Period
func (o *TCC_Type) SetPER(value uint32) {
	volatile.StoreUint32(&o.PER.Reg, volatile.LoadUint32(&o.PER.Reg)&^(0xffffff)|value)
}
func (o *TCC_Type) GetPER() uint32 {
	return volatile.LoadUint32(&o.PER.Reg) & 0xffffff
}

// TCC.CC0: Compare and Capture
func (o *TCC_Type) SetCC0_CC(value uint32) {
	volatile.StoreUint32(&o.CC0.Reg, volatile.LoadUint32(&o.CC0.Reg)&^(0xffffff)|value)
}
func (o *TCC_Type) GetCC0_CC() uint32 {
	return volatile.LoadUint32(&o.CC0.Reg) & 0xffffff
}

// TCC.CC1: Compare and Capture
func (o *TCC_Type) SetCC1_CC(value uint32) {
	volatile.StoreUint32(&o.CC1.Reg, volatile.LoadUint32(&o.CC1.Reg)&^(0xffffff)|value)
}
func (o *TCC_Type) GetCC1_CC() uint32 {
	return volatile.LoadUint32(&o.CC1.Reg) & 0xffffff
}

// TCC.CC2: Compare and Capture
func (o *TCC_Type) SetCC2_CC(value uint32) {
	volatile.StoreUint32(&o.CC2.Reg, volatile.LoadUint32(&o.CC2.Reg)&^(0xffffff)|value)
}
func (o *TCC_Type) GetCC2_CC() uint32 {
	return volatile.LoadUint32(&o.CC2.Reg) & 0xffffff
}

// TCC.CC3: Compare and Capture
func (o *TCC_Type) SetCC3_CC(value uint32) {
	volatile.StoreUint32(&o.CC3.Reg, volatile.LoadUint32(&o.CC3.Reg)&^(0xffffff)|value)
}
func (o *TCC_Type) GetCC3_CC() uint32 {
	return volatile.LoadUint32(&o.CC3.Reg) & 0xffffff
}

// TCC.PATTBUF: Pattern Buffer
func (o *TCC_Type) SetPATTBUF_PGEB0(value uint16) {
	volatile.StoreUint16(&o.PATTBUF.Reg, volatile.LoadUint16(&o.PATTBUF.Reg)&^(0x1)|value)
}
func (o *TCC_Type) GetPATTBUF_PGEB0() uint16 {
	return volatile.LoadUint16(&o.PATTBUF.Reg) & 0x1
}
func (o *TCC_Type) SetPATTBUF_PGEB1(value uint16) {
	volatile.StoreUint16(&o.PATTBUF.Reg, volatile.LoadUint16(&o.PATTBUF.Reg)&^(0x2)|value<<1)
}
func (o *TCC_Type) GetPATTBUF_PGEB1() uint16 {
	return (volatile.LoadUint16(&o.PATTBUF.Reg) & 0x2) >> 1
}
func (o *TCC_Type) SetPATTBUF_PGEB2(value uint16) {
	volatile.StoreUint16(&o.PATTBUF.Reg, volatile.LoadUint16(&o.PATTBUF.Reg)&^(0x4)|value<<2)
}
func (o *TCC_Type) GetPATTBUF_PGEB2() uint16 {
	return (volatile.LoadUint16(&o.PATTBUF.Reg) & 0x4) >> 2
}
func (o *TCC_Type) SetPATTBUF_PGEB3(value uint16) {
	volatile.StoreUint16(&o.PATTBUF.Reg, volatile.LoadUint16(&o.PATTBUF.Reg)&^(0x8)|value<<3)
}
func (o *TCC_Type) GetPATTBUF_PGEB3() uint16 {
	return (volatile.LoadUint16(&o.PATTBUF.Reg) & 0x8) >> 3
}
func (o *TCC_Type) SetPATTBUF_PGEB4(value uint16) {
	volatile.StoreUint16(&o.PATTBUF.Reg, volatile.LoadUint16(&o.PATTBUF.Reg)&^(0x10)|value<<4)
}
func (o *TCC_Type) GetPATTBUF_PGEB4() uint16 {
	return (volatile.LoadUint16(&o.PATTBUF.Reg) & 0x10) >> 4
}
func (o *TCC_Type) SetPATTBUF_PGEB5(value uint16) {
	volatile.StoreUint16(&o.PATTBUF.Reg, volatile.LoadUint16(&o.PATTBUF.Reg)&^(0x20)|value<<5)
}
func (o *TCC_Type) GetPATTBUF_PGEB5() uint16 {
	return (volatile.LoadUint16(&o.PATTBUF.Reg) & 0x20) >> 5
}
func (o *TCC_Type) SetPATTBUF_PGEB6(value uint16) {
	volatile.StoreUint16(&o.PATTBUF.Reg, volatile.LoadUint16(&o.PATTBUF.Reg)&^(0x40)|value<<6)
}
func (o *TCC_Type) GetPATTBUF_PGEB6() uint16 {
	return (volatile.LoadUint16(&o.PATTBUF.Reg) & 0x40) >> 6
}
func (o *TCC_Type) SetPATTBUF_PGEB7(value uint16) {
	volatile.StoreUint16(&o.PATTBUF.Reg, volatile.LoadUint16(&o.PATTBUF.Reg)&^(0x80)|value<<7)
}
func (o *TCC_Type) GetPATTBUF_PGEB7() uint16 {
	return (volatile.LoadUint16(&o.PATTBUF.Reg) & 0x80) >> 7
}
func (o *TCC_Type) SetPATTBUF_PGVB0(value uint16) {
	volatile.StoreUint16(&o.PATTBUF.Reg, volatile.LoadUint16(&o.PATTBUF.Reg)&^(0x100)|value<<8)
}
func (o *TCC_Type) GetPATTBUF_PGVB0() uint16 {
	return (volatile.LoadUint16(&o.PATTBUF.Reg) & 0x100) >> 8
}
func (o *TCC_Type) SetPATTBUF_PGVB1(value uint16) {
	volatile.StoreUint16(&o.PATTBUF.Reg, volatile.LoadUint16(&o.PATTBUF.Reg)&^(0x200)|value<<9)
}
func (o *TCC_Type) GetPATTBUF_PGVB1() uint16 {
	return (volatile.LoadUint16(&o.PATTBUF.Reg) & 0x200) >> 9
}
func (o *TCC_Type) SetPATTBUF_PGVB2(value uint16) {
	volatile.StoreUint16(&o.PATTBUF.Reg, volatile.LoadUint16(&o.PATTBUF.Reg)&^(0x400)|value<<10)
}
func (o *TCC_Type) GetPATTBUF_PGVB2() uint16 {
	return (volatile.LoadUint16(&o.PATTBUF.Reg) & 0x400) >> 10
}
func (o *TCC_Type) SetPATTBUF_PGVB3(value uint16) {
	volatile.StoreUint16(&o.PATTBUF.Reg, volatile.LoadUint16(&o.PATTBUF.Reg)&^(0x800)|value<<11)
}
func (o *TCC_Type) GetPATTBUF_PGVB3() uint16 {
	return (volatile.LoadUint16(&o.PATTBUF.Reg) & 0x800) >> 11
}
func (o *TCC_Type) SetPATTBUF_PGVB4(value uint16) {
	volatile.StoreUint16(&o.PATTBUF.Reg, volatile.LoadUint16(&o.PATTBUF.Reg)&^(0x1000)|value<<12)
}
func (o *TCC_Type) GetPATTBUF_PGVB4() uint16 {
	return (volatile.LoadUint16(&o.PATTBUF.Reg) & 0x1000) >> 12
}
func (o *TCC_Type) SetPATTBUF_PGVB5(value uint16) {
	volatile.StoreUint16(&o.PATTBUF.Reg, volatile.LoadUint16(&o.PATTBUF.Reg)&^(0x2000)|value<<13)
}
func (o *TCC_Type) GetPATTBUF_PGVB5() uint16 {
	return (volatile.LoadUint16(&o.PATTBUF.Reg) & 0x2000) >> 13
}
func (o *TCC_Type) SetPATTBUF_PGVB6(value uint16) {
	volatile.StoreUint16(&o.PATTBUF.Reg, volatile.LoadUint16(&o.PATTBUF.Reg)&^(0x4000)|value<<14)
}
func (o *TCC_Type) GetPATTBUF_PGVB6() uint16 {
	return (volatile.LoadUint16(&o.PATTBUF.Reg) & 0x4000) >> 14
}
func (o *TCC_Type) SetPATTBUF_PGVB7(value uint16) {
	volatile.StoreUint16(&o.PATTBUF.Reg, volatile.LoadUint16(&o.PATTBUF.Reg)&^(0x8000)|value<<15)
}
func (o *TCC_Type) GetPATTBUF_PGVB7() uint16 {
	return (volatile.LoadUint16(&o.PATTBUF.Reg) & 0x8000) >> 15
}

// TCC.PERBUF: Period Buffer
func (o *TCC_Type) SetPERBUF(value uint32) {
	volatile.StoreUint32(&o.PERBUF.Reg, volatile.LoadUint32(&o.PERBUF.Reg)&^(0xffffff)|value)
}
func (o *TCC_Type) GetPERBUF() uint32 {
	return volatile.LoadUint32(&o.PERBUF.Reg) & 0xffffff
}

// TCC.CCBUF0: Compare and Capture Buffer
func (o *TCC_Type) SetCCBUF0_CCBUF(value uint32) {
	volatile.StoreUint32(&o.CCBUF0.Reg, volatile.LoadUint32(&o.CCBUF0.Reg)&^(0xffffff)|value)
}
func (o *TCC_Type) GetCCBUF0_CCBUF() uint32 {
	return volatile.LoadUint32(&o.CCBUF0.Reg) & 0xffffff
}

// TCC.CCBUF1: Compare and Capture Buffer
func (o *TCC_Type) SetCCBUF1_CCBUF(value uint32) {
	volatile.StoreUint32(&o.CCBUF1.Reg, volatile.LoadUint32(&o.CCBUF1.Reg)&^(0xffffff)|value)
}
func (o *TCC_Type) GetCCBUF1_CCBUF() uint32 {
	return volatile.LoadUint32(&o.CCBUF1.Reg) & 0xffffff
}

// TCC.CCBUF2: Compare and Capture Buffer
func (o *TCC_Type) SetCCBUF2_CCBUF(value uint32) {
	volatile.StoreUint32(&o.CCBUF2.Reg, volatile.LoadUint32(&o.CCBUF2.Reg)&^(0xffffff)|value)
}
func (o *TCC_Type) GetCCBUF2_CCBUF() uint32 {
	return volatile.LoadUint32(&o.CCBUF2.Reg) & 0xffffff
}

// TCC.CCBUF3: Compare and Capture Buffer
func (o *TCC_Type) SetCCBUF3_CCBUF(value uint32) {
	volatile.StoreUint32(&o.CCBUF3.Reg, volatile.LoadUint32(&o.CCBUF3.Reg)&^(0xffffff)|value)
}
func (o *TCC_Type) GetCCBUF3_CCBUF() uint32 {
	return volatile.LoadUint32(&o.CCBUF3.Reg) & 0xffffff
}

// True Random Generator
type TRNG_Type struct {
	CTRLA    volatile.Register8 // 0x0
	_        [3]byte
	EVCTRL   volatile.Register8 // 0x4
	_        [3]byte
	INTENCLR volatile.Register8 // 0x8
	INTENSET volatile.Register8 // 0x9
	INTFLAG  volatile.Register8 // 0xA
	_        [21]byte
	DATA     volatile.Register32 // 0x20
}

// TRNG.CTRLA: Control A
func (o *TRNG_Type) SetCTRLA_ENABLE(value uint8) {
	volatile.StoreUint8(&o.CTRLA.Reg, volatile.LoadUint8(&o.CTRLA.Reg)&^(0x2)|value<<1)
}
func (o *TRNG_Type) GetCTRLA_ENABLE() uint8 {
	return (volatile.LoadUint8(&o.CTRLA.Reg) & 0x2) >> 1
}
func (o *TRNG_Type) SetCTRLA_RUNSTDBY(value uint8) {
	volatile.StoreUint8(&o.CTRLA.Reg, volatile.LoadUint8(&o.CTRLA.Reg)&^(0x40)|value<<6)
}
func (o *TRNG_Type) GetCTRLA_RUNSTDBY() uint8 {
	return (volatile.LoadUint8(&o.CTRLA.Reg) & 0x40) >> 6
}

// TRNG.EVCTRL: Event Control
func (o *TRNG_Type) SetEVCTRL_DATARDYEO(value uint8) {
	volatile.StoreUint8(&o.EVCTRL.Reg, volatile.LoadUint8(&o.EVCTRL.Reg)&^(0x1)|value)
}
func (o *TRNG_Type) GetEVCTRL_DATARDYEO() uint8 {
	return volatile.LoadUint8(&o.EVCTRL.Reg) & 0x1
}

// TRNG.INTENCLR: Interrupt Enable Clear
func (o *TRNG_Type) SetINTENCLR_DATARDY(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *TRNG_Type) GetINTENCLR_DATARDY() uint8 {
	return volatile.LoadUint8(&o.INTENCLR.Reg) & 0x1
}

// TRNG.INTENSET: Interrupt Enable Set
func (o *TRNG_Type) SetINTENSET_DATARDY(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *TRNG_Type) GetINTENSET_DATARDY() uint8 {
	return volatile.LoadUint8(&o.INTENSET.Reg) & 0x1
}

// TRNG.INTFLAG: Interrupt Flag Status and Clear
func (o *TRNG_Type) SetINTFLAG_DATARDY(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x1)|value)
}
func (o *TRNG_Type) GetINTFLAG_DATARDY() uint8 {
	return volatile.LoadUint8(&o.INTFLAG.Reg) & 0x1
}

// TRNG.DATA: Output Data
func (o *TRNG_Type) SetDATA(value uint32) {
	volatile.StoreUint32(&o.DATA.Reg, value)
}
func (o *TRNG_Type) GetDATA() uint32 {
	return volatile.LoadUint32(&o.DATA.Reg)
}

// Universal Serial Bus
type USB_Type struct {
}

// Universal Serial Bus - DEVICE
type USB_DEVICE_Type struct {
	CTRLA        volatile.Register8 // 0x0
	_            byte
	SYNCBUSY     volatile.Register8 // 0x2
	QOSCTRL      volatile.Register8 // 0x3
	_            [4]byte
	CTRLB        volatile.Register16 // 0x8
	DADD         volatile.Register8  // 0xA
	_            byte
	STATUS       volatile.Register8 // 0xC
	FSMSTATUS    volatile.Register8 // 0xD
	_            [2]byte
	FNUM         volatile.Register16 // 0x10
	_            [2]byte
	INTENCLR     volatile.Register16 // 0x14
	_            [2]byte
	INTENSET     volatile.Register16 // 0x18
	_            [2]byte
	INTFLAG      volatile.Register16 // 0x1C
	_            [2]byte
	EPINTSMRY    volatile.Register16 // 0x20
	_            [2]byte
	DESCADD      volatile.Register32 // 0x24
	PADCAL       volatile.Register16 // 0x28
	_            [214]byte
	EPCFG0       volatile.Register8 // 0x100
	_            [3]byte
	EPSTATUSCLR0 volatile.Register8 // 0x104
	EPSTATUSSET0 volatile.Register8 // 0x105
	EPSTATUS0    volatile.Register8 // 0x106
	EPINTFLAG0   volatile.Register8 // 0x107
	EPINTENCLR0  volatile.Register8 // 0x108
	EPINTENSET0  volatile.Register8 // 0x109
	_            [22]byte
	EPCFG1       volatile.Register8 // 0x120
	_            [3]byte
	EPSTATUSCLR1 volatile.Register8 // 0x124
	EPSTATUSSET1 volatile.Register8 // 0x125
	EPSTATUS1    volatile.Register8 // 0x126
	EPINTFLAG1   volatile.Register8 // 0x127
	EPINTENCLR1  volatile.Register8 // 0x128
	EPINTENSET1  volatile.Register8 // 0x129
	_            [22]byte
	EPCFG2       volatile.Register8 // 0x140
	_            [3]byte
	EPSTATUSCLR2 volatile.Register8 // 0x144
	EPSTATUSSET2 volatile.Register8 // 0x145
	EPSTATUS2    volatile.Register8 // 0x146
	EPINTFLAG2   volatile.Register8 // 0x147
	EPINTENCLR2  volatile.Register8 // 0x148
	EPINTENSET2  volatile.Register8 // 0x149
	_            [22]byte
	EPCFG3       volatile.Register8 // 0x160
	_            [3]byte
	EPSTATUSCLR3 volatile.Register8 // 0x164
	EPSTATUSSET3 volatile.Register8 // 0x165
	EPSTATUS3    volatile.Register8 // 0x166
	EPINTFLAG3   volatile.Register8 // 0x167
	EPINTENCLR3  volatile.Register8 // 0x168
	EPINTENSET3  volatile.Register8 // 0x169
	_            [22]byte
	EPCFG4       volatile.Register8 // 0x180
	_            [3]byte
	EPSTATUSCLR4 volatile.Register8 // 0x184
	EPSTATUSSET4 volatile.Register8 // 0x185
	EPSTATUS4    volatile.Register8 // 0x186
	EPINTFLAG4   volatile.Register8 // 0x187
	EPINTENCLR4  volatile.Register8 // 0x188
	EPINTENSET4  volatile.Register8 // 0x189
	_            [22]byte
	EPCFG5       volatile.Register8 // 0x1A0
	_            [3]byte
	EPSTATUSCLR5 volatile.Register8 // 0x1A4
	EPSTATUSSET5 volatile.Register8 // 0x1A5
	EPSTATUS5    volatile.Register8 // 0x1A6
	EPINTFLAG5   volatile.Register8 // 0x1A7
	EPINTENCLR5  volatile.Register8 // 0x1A8
	EPINTENSET5  volatile.Register8 // 0x1A9
	_            [22]byte
	EPCFG6       volatile.Register8 // 0x1C0
	_            [3]byte
	EPSTATUSCLR6 volatile.Register8 // 0x1C4
	EPSTATUSSET6 volatile.Register8 // 0x1C5
	EPSTATUS6    volatile.Register8 // 0x1C6
	EPINTFLAG6   volatile.Register8 // 0x1C7
	EPINTENCLR6  volatile.Register8 // 0x1C8
	EPINTENSET6  volatile.Register8 // 0x1C9
	_            [22]byte
	EPCFG7       volatile.Register8 // 0x1E0
	_            [3]byte
	EPSTATUSCLR7 volatile.Register8 // 0x1E4
	EPSTATUSSET7 volatile.Register8 // 0x1E5
	EPSTATUS7    volatile.Register8 // 0x1E6
	EPINTFLAG7   volatile.Register8 // 0x1E7
	EPINTENCLR7  volatile.Register8 // 0x1E8
	EPINTENSET7  volatile.Register8 // 0x1E9
}

// USB_DEVICE.CTRLA: Control A
func (o *USB_DEVICE_Type) SetCTRLA_SWRST(value uint8) {
	volatile.StoreUint8(&o.CTRLA.Reg, volatile.LoadUint8(&o.CTRLA.Reg)&^(0x1)|value)
}
func (o *USB_DEVICE_Type) GetCTRLA_SWRST() uint8 {
	return volatile.LoadUint8(&o.CTRLA.Reg) & 0x1
}
func (o *USB_DEVICE_Type) SetCTRLA_ENABLE(value uint8) {
	volatile.StoreUint8(&o.CTRLA.Reg, volatile.LoadUint8(&o.CTRLA.Reg)&^(0x2)|value<<1)
}
func (o *USB_DEVICE_Type) GetCTRLA_ENABLE() uint8 {
	return (volatile.LoadUint8(&o.CTRLA.Reg) & 0x2) >> 1
}
func (o *USB_DEVICE_Type) SetCTRLA_RUNSTDBY(value uint8) {
	volatile.StoreUint8(&o.CTRLA.Reg, volatile.LoadUint8(&o.CTRLA.Reg)&^(0x4)|value<<2)
}
func (o *USB_DEVICE_Type) GetCTRLA_RUNSTDBY() uint8 {
	return (volatile.LoadUint8(&o.CTRLA.Reg) & 0x4) >> 2
}
func (o *USB_DEVICE_Type) SetCTRLA_MODE(value uint8) {
	volatile.StoreUint8(&o.CTRLA.Reg, volatile.LoadUint8(&o.CTRLA.Reg)&^(0x80)|value<<7)
}
func (o *USB_DEVICE_Type) GetCTRLA_MODE() uint8 {
	return (volatile.LoadUint8(&o.CTRLA.Reg) & 0x80) >> 7
}

// USB_DEVICE.SYNCBUSY: Synchronization Busy
func (o *USB_DEVICE_Type) SetSYNCBUSY_SWRST(value uint8) {
	volatile.StoreUint8(&o.SYNCBUSY.Reg, volatile.LoadUint8(&o.SYNCBUSY.Reg)&^(0x1)|value)
}
func (o *USB_DEVICE_Type) GetSYNCBUSY_SWRST() uint8 {
	return volatile.LoadUint8(&o.SYNCBUSY.Reg) & 0x1
}
func (o *USB_DEVICE_Type) SetSYNCBUSY_ENABLE(value uint8) {
	volatile.StoreUint8(&o.SYNCBUSY.Reg, volatile.LoadUint8(&o.SYNCBUSY.Reg)&^(0x2)|value<<1)
}
func (o *USB_DEVICE_Type) GetSYNCBUSY_ENABLE() uint8 {
	return (volatile.LoadUint8(&o.SYNCBUSY.Reg) & 0x2) >> 1
}

// USB_DEVICE.QOSCTRL: USB Quality Of Service
func (o *USB_DEVICE_Type) SetQOSCTRL_CQOS(value uint8) {
	volatile.StoreUint8(&o.QOSCTRL.Reg, volatile.LoadUint8(&o.QOSCTRL.Reg)&^(0x3)|value)
}
func (o *USB_DEVICE_Type) GetQOSCTRL_CQOS() uint8 {
	return volatile.LoadUint8(&o.QOSCTRL.Reg) & 0x3
}
func (o *USB_DEVICE_Type) SetQOSCTRL_DQOS(value uint8) {
	volatile.StoreUint8(&o.QOSCTRL.Reg, volatile.LoadUint8(&o.QOSCTRL.Reg)&^(0xc)|value<<2)
}
func (o *USB_DEVICE_Type) GetQOSCTRL_DQOS() uint8 {
	return (volatile.LoadUint8(&o.QOSCTRL.Reg) & 0xc) >> 2
}

// USB_DEVICE.CTRLB: DEVICE Control B
func (o *USB_DEVICE_Type) SetCTRLB_DETACH(value uint16) {
	volatile.StoreUint16(&o.CTRLB.Reg, volatile.LoadUint16(&o.CTRLB.Reg)&^(0x1)|value)
}
func (o *USB_DEVICE_Type) GetCTRLB_DETACH() uint16 {
	return volatile.LoadUint16(&o.CTRLB.Reg) & 0x1
}
func (o *USB_DEVICE_Type) SetCTRLB_UPRSM(value uint16) {
	volatile.StoreUint16(&o.CTRLB.Reg, volatile.LoadUint16(&o.CTRLB.Reg)&^(0x2)|value<<1)
}
func (o *USB_DEVICE_Type) GetCTRLB_UPRSM() uint16 {
	return (volatile.LoadUint16(&o.CTRLB.Reg) & 0x2) >> 1
}
func (o *USB_DEVICE_Type) SetCTRLB_SPDCONF(value uint16) {
	volatile.StoreUint16(&o.CTRLB.Reg, volatile.LoadUint16(&o.CTRLB.Reg)&^(0xc)|value<<2)
}
func (o *USB_DEVICE_Type) GetCTRLB_SPDCONF() uint16 {
	return (volatile.LoadUint16(&o.CTRLB.Reg) & 0xc) >> 2
}
func (o *USB_DEVICE_Type) SetCTRLB_NREPLY(value uint16) {
	volatile.StoreUint16(&o.CTRLB.Reg, volatile.LoadUint16(&o.CTRLB.Reg)&^(0x10)|value<<4)
}
func (o *USB_DEVICE_Type) GetCTRLB_NREPLY() uint16 {
	return (volatile.LoadUint16(&o.CTRLB.Reg) & 0x10) >> 4
}
func (o *USB_DEVICE_Type) SetCTRLB_TSTJ(value uint16) {
	volatile.StoreUint16(&o.CTRLB.Reg, volatile.LoadUint16(&o.CTRLB.Reg)&^(0x20)|value<<5)
}
func (o *USB_DEVICE_Type) GetCTRLB_TSTJ() uint16 {
	return (volatile.LoadUint16(&o.CTRLB.Reg) & 0x20) >> 5
}
func (o *USB_DEVICE_Type) SetCTRLB_TSTK(value uint16) {
	volatile.StoreUint16(&o.CTRLB.Reg, volatile.LoadUint16(&o.CTRLB.Reg)&^(0x40)|value<<6)
}
func (o *USB_DEVICE_Type) GetCTRLB_TSTK() uint16 {
	return (volatile.LoadUint16(&o.CTRLB.Reg) & 0x40) >> 6
}
func (o *USB_DEVICE_Type) SetCTRLB_TSTPCKT(value uint16) {
	volatile.StoreUint16(&o.CTRLB.Reg, volatile.LoadUint16(&o.CTRLB.Reg)&^(0x80)|value<<7)
}
func (o *USB_DEVICE_Type) GetCTRLB_TSTPCKT() uint16 {
	return (volatile.LoadUint16(&o.CTRLB.Reg) & 0x80) >> 7
}
func (o *USB_DEVICE_Type) SetCTRLB_OPMODE2(value uint16) {
	volatile.StoreUint16(&o.CTRLB.Reg, volatile.LoadUint16(&o.CTRLB.Reg)&^(0x100)|value<<8)
}
func (o *USB_DEVICE_Type) GetCTRLB_OPMODE2() uint16 {
	return (volatile.LoadUint16(&o.CTRLB.Reg) & 0x100) >> 8
}
func (o *USB_DEVICE_Type) SetCTRLB_GNAK(value uint16) {
	volatile.StoreUint16(&o.CTRLB.Reg, volatile.LoadUint16(&o.CTRLB.Reg)&^(0x200)|value<<9)
}
func (o *USB_DEVICE_Type) GetCTRLB_GNAK() uint16 {
	return (volatile.LoadUint16(&o.CTRLB.Reg) & 0x200) >> 9
}
func (o *USB_DEVICE_Type) SetCTRLB_LPMHDSK(value uint16) {
	volatile.StoreUint16(&o.CTRLB.Reg, volatile.LoadUint16(&o.CTRLB.Reg)&^(0xc00)|value<<10)
}
func (o *USB_DEVICE_Type) GetCTRLB_LPMHDSK() uint16 {
	return (volatile.LoadUint16(&o.CTRLB.Reg) & 0xc00) >> 10
}

// USB_DEVICE.DADD: DEVICE Device Address
func (o *USB_DEVICE_Type) SetDADD(value uint8) {
	volatile.StoreUint8(&o.DADD.Reg, volatile.LoadUint8(&o.DADD.Reg)&^(0x7f)|value)
}
func (o *USB_DEVICE_Type) GetDADD() uint8 {
	return volatile.LoadUint8(&o.DADD.Reg) & 0x7f
}
func (o *USB_DEVICE_Type) SetDADD_ADDEN(value uint8) {
	volatile.StoreUint8(&o.DADD.Reg, volatile.LoadUint8(&o.DADD.Reg)&^(0x80)|value<<7)
}
func (o *USB_DEVICE_Type) GetDADD_ADDEN() uint8 {
	return (volatile.LoadUint8(&o.DADD.Reg) & 0x80) >> 7
}

// USB_DEVICE.STATUS: DEVICE Status
func (o *USB_DEVICE_Type) SetSTATUS_SPEED(value uint8) {
	volatile.StoreUint8(&o.STATUS.Reg, volatile.LoadUint8(&o.STATUS.Reg)&^(0xc)|value<<2)
}
func (o *USB_DEVICE_Type) GetSTATUS_SPEED() uint8 {
	return (volatile.LoadUint8(&o.STATUS.Reg) & 0xc) >> 2
}
func (o *USB_DEVICE_Type) SetSTATUS_LINESTATE(value uint8) {
	volatile.StoreUint8(&o.STATUS.Reg, volatile.LoadUint8(&o.STATUS.Reg)&^(0xc0)|value<<6)
}
func (o *USB_DEVICE_Type) GetSTATUS_LINESTATE() uint8 {
	return (volatile.LoadUint8(&o.STATUS.Reg) & 0xc0) >> 6
}

// USB_DEVICE.FSMSTATUS: Finite State Machine Status
func (o *USB_DEVICE_Type) SetFSMSTATUS_FSMSTATE(value uint8) {
	volatile.StoreUint8(&o.FSMSTATUS.Reg, volatile.LoadUint8(&o.FSMSTATUS.Reg)&^(0x7f)|value)
}
func (o *USB_DEVICE_Type) GetFSMSTATUS_FSMSTATE() uint8 {
	return volatile.LoadUint8(&o.FSMSTATUS.Reg) & 0x7f
}

// USB_DEVICE.FNUM: DEVICE Device Frame Number
func (o *USB_DEVICE_Type) SetFNUM_MFNUM(value uint16) {
	volatile.StoreUint16(&o.FNUM.Reg, volatile.LoadUint16(&o.FNUM.Reg)&^(0x7)|value)
}
func (o *USB_DEVICE_Type) GetFNUM_MFNUM() uint16 {
	return volatile.LoadUint16(&o.FNUM.Reg) & 0x7
}
func (o *USB_DEVICE_Type) SetFNUM(value uint16) {
	volatile.StoreUint16(&o.FNUM.Reg, volatile.LoadUint16(&o.FNUM.Reg)&^(0x3ff8)|value<<3)
}
func (o *USB_DEVICE_Type) GetFNUM() uint16 {
	return (volatile.LoadUint16(&o.FNUM.Reg) & 0x3ff8) >> 3
}
func (o *USB_DEVICE_Type) SetFNUM_FNCERR(value uint16) {
	volatile.StoreUint16(&o.FNUM.Reg, volatile.LoadUint16(&o.FNUM.Reg)&^(0x8000)|value<<15)
}
func (o *USB_DEVICE_Type) GetFNUM_FNCERR() uint16 {
	return (volatile.LoadUint16(&o.FNUM.Reg) & 0x8000) >> 15
}

// USB_DEVICE.INTENCLR: DEVICE Device Interrupt Enable Clear
func (o *USB_DEVICE_Type) SetINTENCLR_SUSPEND(value uint16) {
	volatile.StoreUint16(&o.INTENCLR.Reg, volatile.LoadUint16(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *USB_DEVICE_Type) GetINTENCLR_SUSPEND() uint16 {
	return volatile.LoadUint16(&o.INTENCLR.Reg) & 0x1
}
func (o *USB_DEVICE_Type) SetINTENCLR_MSOF(value uint16) {
	volatile.StoreUint16(&o.INTENCLR.Reg, volatile.LoadUint16(&o.INTENCLR.Reg)&^(0x2)|value<<1)
}
func (o *USB_DEVICE_Type) GetINTENCLR_MSOF() uint16 {
	return (volatile.LoadUint16(&o.INTENCLR.Reg) & 0x2) >> 1
}
func (o *USB_DEVICE_Type) SetINTENCLR_SOF(value uint16) {
	volatile.StoreUint16(&o.INTENCLR.Reg, volatile.LoadUint16(&o.INTENCLR.Reg)&^(0x4)|value<<2)
}
func (o *USB_DEVICE_Type) GetINTENCLR_SOF() uint16 {
	return (volatile.LoadUint16(&o.INTENCLR.Reg) & 0x4) >> 2
}
func (o *USB_DEVICE_Type) SetINTENCLR_EORST(value uint16) {
	volatile.StoreUint16(&o.INTENCLR.Reg, volatile.LoadUint16(&o.INTENCLR.Reg)&^(0x8)|value<<3)
}
func (o *USB_DEVICE_Type) GetINTENCLR_EORST() uint16 {
	return (volatile.LoadUint16(&o.INTENCLR.Reg) & 0x8) >> 3
}
func (o *USB_DEVICE_Type) SetINTENCLR_WAKEUP(value uint16) {
	volatile.StoreUint16(&o.INTENCLR.Reg, volatile.LoadUint16(&o.INTENCLR.Reg)&^(0x10)|value<<4)
}
func (o *USB_DEVICE_Type) GetINTENCLR_WAKEUP() uint16 {
	return (volatile.LoadUint16(&o.INTENCLR.Reg) & 0x10) >> 4
}
func (o *USB_DEVICE_Type) SetINTENCLR_EORSM(value uint16) {
	volatile.StoreUint16(&o.INTENCLR.Reg, volatile.LoadUint16(&o.INTENCLR.Reg)&^(0x20)|value<<5)
}
func (o *USB_DEVICE_Type) GetINTENCLR_EORSM() uint16 {
	return (volatile.LoadUint16(&o.INTENCLR.Reg) & 0x20) >> 5
}
func (o *USB_DEVICE_Type) SetINTENCLR_UPRSM(value uint16) {
	volatile.StoreUint16(&o.INTENCLR.Reg, volatile.LoadUint16(&o.INTENCLR.Reg)&^(0x40)|value<<6)
}
func (o *USB_DEVICE_Type) GetINTENCLR_UPRSM() uint16 {
	return (volatile.LoadUint16(&o.INTENCLR.Reg) & 0x40) >> 6
}
func (o *USB_DEVICE_Type) SetINTENCLR_RAMACER(value uint16) {
	volatile.StoreUint16(&o.INTENCLR.Reg, volatile.LoadUint16(&o.INTENCLR.Reg)&^(0x80)|value<<7)
}
func (o *USB_DEVICE_Type) GetINTENCLR_RAMACER() uint16 {
	return (volatile.LoadUint16(&o.INTENCLR.Reg) & 0x80) >> 7
}
func (o *USB_DEVICE_Type) SetINTENCLR_LPMNYET(value uint16) {
	volatile.StoreUint16(&o.INTENCLR.Reg, volatile.LoadUint16(&o.INTENCLR.Reg)&^(0x100)|value<<8)
}
func (o *USB_DEVICE_Type) GetINTENCLR_LPMNYET() uint16 {
	return (volatile.LoadUint16(&o.INTENCLR.Reg) & 0x100) >> 8
}
func (o *USB_DEVICE_Type) SetINTENCLR_LPMSUSP(value uint16) {
	volatile.StoreUint16(&o.INTENCLR.Reg, volatile.LoadUint16(&o.INTENCLR.Reg)&^(0x200)|value<<9)
}
func (o *USB_DEVICE_Type) GetINTENCLR_LPMSUSP() uint16 {
	return (volatile.LoadUint16(&o.INTENCLR.Reg) & 0x200) >> 9
}

// USB_DEVICE.INTENSET: DEVICE Device Interrupt Enable Set
func (o *USB_DEVICE_Type) SetINTENSET_SUSPEND(value uint16) {
	volatile.StoreUint16(&o.INTENSET.Reg, volatile.LoadUint16(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *USB_DEVICE_Type) GetINTENSET_SUSPEND() uint16 {
	return volatile.LoadUint16(&o.INTENSET.Reg) & 0x1
}
func (o *USB_DEVICE_Type) SetINTENSET_MSOF(value uint16) {
	volatile.StoreUint16(&o.INTENSET.Reg, volatile.LoadUint16(&o.INTENSET.Reg)&^(0x2)|value<<1)
}
func (o *USB_DEVICE_Type) GetINTENSET_MSOF() uint16 {
	return (volatile.LoadUint16(&o.INTENSET.Reg) & 0x2) >> 1
}
func (o *USB_DEVICE_Type) SetINTENSET_SOF(value uint16) {
	volatile.StoreUint16(&o.INTENSET.Reg, volatile.LoadUint16(&o.INTENSET.Reg)&^(0x4)|value<<2)
}
func (o *USB_DEVICE_Type) GetINTENSET_SOF() uint16 {
	return (volatile.LoadUint16(&o.INTENSET.Reg) & 0x4) >> 2
}
func (o *USB_DEVICE_Type) SetINTENSET_EORST(value uint16) {
	volatile.StoreUint16(&o.INTENSET.Reg, volatile.LoadUint16(&o.INTENSET.Reg)&^(0x8)|value<<3)
}
func (o *USB_DEVICE_Type) GetINTENSET_EORST() uint16 {
	return (volatile.LoadUint16(&o.INTENSET.Reg) & 0x8) >> 3
}
func (o *USB_DEVICE_Type) SetINTENSET_WAKEUP(value uint16) {
	volatile.StoreUint16(&o.INTENSET.Reg, volatile.LoadUint16(&o.INTENSET.Reg)&^(0x10)|value<<4)
}
func (o *USB_DEVICE_Type) GetINTENSET_WAKEUP() uint16 {
	return (volatile.LoadUint16(&o.INTENSET.Reg) & 0x10) >> 4
}
func (o *USB_DEVICE_Type) SetINTENSET_EORSM(value uint16) {
	volatile.StoreUint16(&o.INTENSET.Reg, volatile.LoadUint16(&o.INTENSET.Reg)&^(0x20)|value<<5)
}
func (o *USB_DEVICE_Type) GetINTENSET_EORSM() uint16 {
	return (volatile.LoadUint16(&o.INTENSET.Reg) & 0x20) >> 5
}
func (o *USB_DEVICE_Type) SetINTENSET_UPRSM(value uint16) {
	volatile.StoreUint16(&o.INTENSET.Reg, volatile.LoadUint16(&o.INTENSET.Reg)&^(0x40)|value<<6)
}
func (o *USB_DEVICE_Type) GetINTENSET_UPRSM() uint16 {
	return (volatile.LoadUint16(&o.INTENSET.Reg) & 0x40) >> 6
}
func (o *USB_DEVICE_Type) SetINTENSET_RAMACER(value uint16) {
	volatile.StoreUint16(&o.INTENSET.Reg, volatile.LoadUint16(&o.INTENSET.Reg)&^(0x80)|value<<7)
}
func (o *USB_DEVICE_Type) GetINTENSET_RAMACER() uint16 {
	return (volatile.LoadUint16(&o.INTENSET.Reg) & 0x80) >> 7
}
func (o *USB_DEVICE_Type) SetINTENSET_LPMNYET(value uint16) {
	volatile.StoreUint16(&o.INTENSET.Reg, volatile.LoadUint16(&o.INTENSET.Reg)&^(0x100)|value<<8)
}
func (o *USB_DEVICE_Type) GetINTENSET_LPMNYET() uint16 {
	return (volatile.LoadUint16(&o.INTENSET.Reg) & 0x100) >> 8
}
func (o *USB_DEVICE_Type) SetINTENSET_LPMSUSP(value uint16) {
	volatile.StoreUint16(&o.INTENSET.Reg, volatile.LoadUint16(&o.INTENSET.Reg)&^(0x200)|value<<9)
}
func (o *USB_DEVICE_Type) GetINTENSET_LPMSUSP() uint16 {
	return (volatile.LoadUint16(&o.INTENSET.Reg) & 0x200) >> 9
}

// USB_DEVICE.INTFLAG: DEVICE Device Interrupt Flag
func (o *USB_DEVICE_Type) SetINTFLAG_SUSPEND(value uint16) {
	volatile.StoreUint16(&o.INTFLAG.Reg, volatile.LoadUint16(&o.INTFLAG.Reg)&^(0x1)|value)
}
func (o *USB_DEVICE_Type) GetINTFLAG_SUSPEND() uint16 {
	return volatile.LoadUint16(&o.INTFLAG.Reg) & 0x1
}
func (o *USB_DEVICE_Type) SetINTFLAG_MSOF(value uint16) {
	volatile.StoreUint16(&o.INTFLAG.Reg, volatile.LoadUint16(&o.INTFLAG.Reg)&^(0x2)|value<<1)
}
func (o *USB_DEVICE_Type) GetINTFLAG_MSOF() uint16 {
	return (volatile.LoadUint16(&o.INTFLAG.Reg) & 0x2) >> 1
}
func (o *USB_DEVICE_Type) SetINTFLAG_SOF(value uint16) {
	volatile.StoreUint16(&o.INTFLAG.Reg, volatile.LoadUint16(&o.INTFLAG.Reg)&^(0x4)|value<<2)
}
func (o *USB_DEVICE_Type) GetINTFLAG_SOF() uint16 {
	return (volatile.LoadUint16(&o.INTFLAG.Reg) & 0x4) >> 2
}
func (o *USB_DEVICE_Type) SetINTFLAG_EORST(value uint16) {
	volatile.StoreUint16(&o.INTFLAG.Reg, volatile.LoadUint16(&o.INTFLAG.Reg)&^(0x8)|value<<3)
}
func (o *USB_DEVICE_Type) GetINTFLAG_EORST() uint16 {
	return (volatile.LoadUint16(&o.INTFLAG.Reg) & 0x8) >> 3
}
func (o *USB_DEVICE_Type) SetINTFLAG_WAKEUP(value uint16) {
	volatile.StoreUint16(&o.INTFLAG.Reg, volatile.LoadUint16(&o.INTFLAG.Reg)&^(0x10)|value<<4)
}
func (o *USB_DEVICE_Type) GetINTFLAG_WAKEUP() uint16 {
	return (volatile.LoadUint16(&o.INTFLAG.Reg) & 0x10) >> 4
}
func (o *USB_DEVICE_Type) SetINTFLAG_EORSM(value uint16) {
	volatile.StoreUint16(&o.INTFLAG.Reg, volatile.LoadUint16(&o.INTFLAG.Reg)&^(0x20)|value<<5)
}
func (o *USB_DEVICE_Type) GetINTFLAG_EORSM() uint16 {
	return (volatile.LoadUint16(&o.INTFLAG.Reg) & 0x20) >> 5
}
func (o *USB_DEVICE_Type) SetINTFLAG_UPRSM(value uint16) {
	volatile.StoreUint16(&o.INTFLAG.Reg, volatile.LoadUint16(&o.INTFLAG.Reg)&^(0x40)|value<<6)
}
func (o *USB_DEVICE_Type) GetINTFLAG_UPRSM() uint16 {
	return (volatile.LoadUint16(&o.INTFLAG.Reg) & 0x40) >> 6
}
func (o *USB_DEVICE_Type) SetINTFLAG_RAMACER(value uint16) {
	volatile.StoreUint16(&o.INTFLAG.Reg, volatile.LoadUint16(&o.INTFLAG.Reg)&^(0x80)|value<<7)
}
func (o *USB_DEVICE_Type) GetINTFLAG_RAMACER() uint16 {
	return (volatile.LoadUint16(&o.INTFLAG.Reg) & 0x80) >> 7
}
func (o *USB_DEVICE_Type) SetINTFLAG_LPMNYET(value uint16) {
	volatile.StoreUint16(&o.INTFLAG.Reg, volatile.LoadUint16(&o.INTFLAG.Reg)&^(0x100)|value<<8)
}
func (o *USB_DEVICE_Type) GetINTFLAG_LPMNYET() uint16 {
	return (volatile.LoadUint16(&o.INTFLAG.Reg) & 0x100) >> 8
}
func (o *USB_DEVICE_Type) SetINTFLAG_LPMSUSP(value uint16) {
	volatile.StoreUint16(&o.INTFLAG.Reg, volatile.LoadUint16(&o.INTFLAG.Reg)&^(0x200)|value<<9)
}
func (o *USB_DEVICE_Type) GetINTFLAG_LPMSUSP() uint16 {
	return (volatile.LoadUint16(&o.INTFLAG.Reg) & 0x200) >> 9
}

// USB_DEVICE.EPINTSMRY: DEVICE End Point Interrupt Summary
func (o *USB_DEVICE_Type) SetEPINTSMRY_EPINT0(value uint16) {
	volatile.StoreUint16(&o.EPINTSMRY.Reg, volatile.LoadUint16(&o.EPINTSMRY.Reg)&^(0x1)|value)
}
func (o *USB_DEVICE_Type) GetEPINTSMRY_EPINT0() uint16 {
	return volatile.LoadUint16(&o.EPINTSMRY.Reg) & 0x1
}
func (o *USB_DEVICE_Type) SetEPINTSMRY_EPINT1(value uint16) {
	volatile.StoreUint16(&o.EPINTSMRY.Reg, volatile.LoadUint16(&o.EPINTSMRY.Reg)&^(0x2)|value<<1)
}
func (o *USB_DEVICE_Type) GetEPINTSMRY_EPINT1() uint16 {
	return (volatile.LoadUint16(&o.EPINTSMRY.Reg) & 0x2) >> 1
}
func (o *USB_DEVICE_Type) SetEPINTSMRY_EPINT2(value uint16) {
	volatile.StoreUint16(&o.EPINTSMRY.Reg, volatile.LoadUint16(&o.EPINTSMRY.Reg)&^(0x4)|value<<2)
}
func (o *USB_DEVICE_Type) GetEPINTSMRY_EPINT2() uint16 {
	return (volatile.LoadUint16(&o.EPINTSMRY.Reg) & 0x4) >> 2
}
func (o *USB_DEVICE_Type) SetEPINTSMRY_EPINT3(value uint16) {
	volatile.StoreUint16(&o.EPINTSMRY.Reg, volatile.LoadUint16(&o.EPINTSMRY.Reg)&^(0x8)|value<<3)
}
func (o *USB_DEVICE_Type) GetEPINTSMRY_EPINT3() uint16 {
	return (volatile.LoadUint16(&o.EPINTSMRY.Reg) & 0x8) >> 3
}
func (o *USB_DEVICE_Type) SetEPINTSMRY_EPINT4(value uint16) {
	volatile.StoreUint16(&o.EPINTSMRY.Reg, volatile.LoadUint16(&o.EPINTSMRY.Reg)&^(0x10)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPINTSMRY_EPINT4() uint16 {
	return (volatile.LoadUint16(&o.EPINTSMRY.Reg) & 0x10) >> 4
}
func (o *USB_DEVICE_Type) SetEPINTSMRY_EPINT5(value uint16) {
	volatile.StoreUint16(&o.EPINTSMRY.Reg, volatile.LoadUint16(&o.EPINTSMRY.Reg)&^(0x20)|value<<5)
}
func (o *USB_DEVICE_Type) GetEPINTSMRY_EPINT5() uint16 {
	return (volatile.LoadUint16(&o.EPINTSMRY.Reg) & 0x20) >> 5
}
func (o *USB_DEVICE_Type) SetEPINTSMRY_EPINT6(value uint16) {
	volatile.StoreUint16(&o.EPINTSMRY.Reg, volatile.LoadUint16(&o.EPINTSMRY.Reg)&^(0x40)|value<<6)
}
func (o *USB_DEVICE_Type) GetEPINTSMRY_EPINT6() uint16 {
	return (volatile.LoadUint16(&o.EPINTSMRY.Reg) & 0x40) >> 6
}
func (o *USB_DEVICE_Type) SetEPINTSMRY_EPINT7(value uint16) {
	volatile.StoreUint16(&o.EPINTSMRY.Reg, volatile.LoadUint16(&o.EPINTSMRY.Reg)&^(0x80)|value<<7)
}
func (o *USB_DEVICE_Type) GetEPINTSMRY_EPINT7() uint16 {
	return (volatile.LoadUint16(&o.EPINTSMRY.Reg) & 0x80) >> 7
}

// USB_DEVICE.DESCADD: Descriptor Address
func (o *USB_DEVICE_Type) SetDESCADD(value uint32) {
	volatile.StoreUint32(&o.DESCADD.Reg, value)
}
func (o *USB_DEVICE_Type) GetDESCADD() uint32 {
	return volatile.LoadUint32(&o.DESCADD.Reg)
}

// USB_DEVICE.PADCAL: USB PAD Calibration
func (o *USB_DEVICE_Type) SetPADCAL_TRANSP(value uint16) {
	volatile.StoreUint16(&o.PADCAL.Reg, volatile.LoadUint16(&o.PADCAL.Reg)&^(0x1f)|value)
}
func (o *USB_DEVICE_Type) GetPADCAL_TRANSP() uint16 {
	return volatile.LoadUint16(&o.PADCAL.Reg) & 0x1f
}
func (o *USB_DEVICE_Type) SetPADCAL_TRANSN(value uint16) {
	volatile.StoreUint16(&o.PADCAL.Reg, volatile.LoadUint16(&o.PADCAL.Reg)&^(0x7c0)|value<<6)
}
func (o *USB_DEVICE_Type) GetPADCAL_TRANSN() uint16 {
	return (volatile.LoadUint16(&o.PADCAL.Reg) & 0x7c0) >> 6
}
func (o *USB_DEVICE_Type) SetPADCAL_TRIM(value uint16) {
	volatile.StoreUint16(&o.PADCAL.Reg, volatile.LoadUint16(&o.PADCAL.Reg)&^(0x7000)|value<<12)
}
func (o *USB_DEVICE_Type) GetPADCAL_TRIM() uint16 {
	return (volatile.LoadUint16(&o.PADCAL.Reg) & 0x7000) >> 12
}

// USB_DEVICE.EPCFG0: DEVICE End Point Configuration
func (o *USB_DEVICE_Type) SetEPCFG0_EPTYPE0(value uint8) {
	volatile.StoreUint8(&o.EPCFG0.Reg, volatile.LoadUint8(&o.EPCFG0.Reg)&^(0x7)|value)
}
func (o *USB_DEVICE_Type) GetEPCFG0_EPTYPE0() uint8 {
	return volatile.LoadUint8(&o.EPCFG0.Reg) & 0x7
}
func (o *USB_DEVICE_Type) SetEPCFG0_EPTYPE1(value uint8) {
	volatile.StoreUint8(&o.EPCFG0.Reg, volatile.LoadUint8(&o.EPCFG0.Reg)&^(0x70)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPCFG0_EPTYPE1() uint8 {
	return (volatile.LoadUint8(&o.EPCFG0.Reg) & 0x70) >> 4
}
func (o *USB_DEVICE_Type) SetEPCFG0_NYETDIS(value uint8) {
	volatile.StoreUint8(&o.EPCFG0.Reg, volatile.LoadUint8(&o.EPCFG0.Reg)&^(0x80)|value<<7)
}
func (o *USB_DEVICE_Type) GetEPCFG0_NYETDIS() uint8 {
	return (volatile.LoadUint8(&o.EPCFG0.Reg) & 0x80) >> 7
}

// USB_DEVICE.EPSTATUSCLR0: DEVICE End Point Pipe Status Clear
func (o *USB_DEVICE_Type) SetEPSTATUSCLR0_DTGLOUT(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR0.Reg, volatile.LoadUint8(&o.EPSTATUSCLR0.Reg)&^(0x1)|value)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR0_DTGLOUT() uint8 {
	return volatile.LoadUint8(&o.EPSTATUSCLR0.Reg) & 0x1
}
func (o *USB_DEVICE_Type) SetEPSTATUSCLR0_DTGLIN(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR0.Reg, volatile.LoadUint8(&o.EPSTATUSCLR0.Reg)&^(0x2)|value<<1)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR0_DTGLIN() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSCLR0.Reg) & 0x2) >> 1
}
func (o *USB_DEVICE_Type) SetEPSTATUSCLR0_CURBK(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR0.Reg, volatile.LoadUint8(&o.EPSTATUSCLR0.Reg)&^(0x4)|value<<2)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR0_CURBK() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSCLR0.Reg) & 0x4) >> 2
}
func (o *USB_DEVICE_Type) SetEPSTATUSCLR0_STALLRQ0(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR0.Reg, volatile.LoadUint8(&o.EPSTATUSCLR0.Reg)&^(0x10)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR0_STALLRQ0() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSCLR0.Reg) & 0x10) >> 4
}
func (o *USB_DEVICE_Type) SetEPSTATUSCLR0_STALLRQ1(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR0.Reg, volatile.LoadUint8(&o.EPSTATUSCLR0.Reg)&^(0x20)|value<<5)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR0_STALLRQ1() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSCLR0.Reg) & 0x20) >> 5
}
func (o *USB_DEVICE_Type) SetEPSTATUSCLR0_BK0RDY(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR0.Reg, volatile.LoadUint8(&o.EPSTATUSCLR0.Reg)&^(0x40)|value<<6)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR0_BK0RDY() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSCLR0.Reg) & 0x40) >> 6
}
func (o *USB_DEVICE_Type) SetEPSTATUSCLR0_BK1RDY(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR0.Reg, volatile.LoadUint8(&o.EPSTATUSCLR0.Reg)&^(0x80)|value<<7)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR0_BK1RDY() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSCLR0.Reg) & 0x80) >> 7
}

// USB_DEVICE.EPSTATUSSET0: DEVICE End Point Pipe Status Set
func (o *USB_DEVICE_Type) SetEPSTATUSSET0_DTGLOUT(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET0.Reg, volatile.LoadUint8(&o.EPSTATUSSET0.Reg)&^(0x1)|value)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET0_DTGLOUT() uint8 {
	return volatile.LoadUint8(&o.EPSTATUSSET0.Reg) & 0x1
}
func (o *USB_DEVICE_Type) SetEPSTATUSSET0_DTGLIN(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET0.Reg, volatile.LoadUint8(&o.EPSTATUSSET0.Reg)&^(0x2)|value<<1)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET0_DTGLIN() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSSET0.Reg) & 0x2) >> 1
}
func (o *USB_DEVICE_Type) SetEPSTATUSSET0_CURBK(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET0.Reg, volatile.LoadUint8(&o.EPSTATUSSET0.Reg)&^(0x4)|value<<2)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET0_CURBK() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSSET0.Reg) & 0x4) >> 2
}
func (o *USB_DEVICE_Type) SetEPSTATUSSET0_STALLRQ0(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET0.Reg, volatile.LoadUint8(&o.EPSTATUSSET0.Reg)&^(0x10)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET0_STALLRQ0() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSSET0.Reg) & 0x10) >> 4
}
func (o *USB_DEVICE_Type) SetEPSTATUSSET0_STALLRQ1(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET0.Reg, volatile.LoadUint8(&o.EPSTATUSSET0.Reg)&^(0x20)|value<<5)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET0_STALLRQ1() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSSET0.Reg) & 0x20) >> 5
}
func (o *USB_DEVICE_Type) SetEPSTATUSSET0_BK0RDY(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET0.Reg, volatile.LoadUint8(&o.EPSTATUSSET0.Reg)&^(0x40)|value<<6)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET0_BK0RDY() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSSET0.Reg) & 0x40) >> 6
}
func (o *USB_DEVICE_Type) SetEPSTATUSSET0_BK1RDY(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET0.Reg, volatile.LoadUint8(&o.EPSTATUSSET0.Reg)&^(0x80)|value<<7)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET0_BK1RDY() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSSET0.Reg) & 0x80) >> 7
}

// USB_DEVICE.EPSTATUS0: DEVICE End Point Pipe Status
func (o *USB_DEVICE_Type) SetEPSTATUS0_DTGLOUT(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS0.Reg, volatile.LoadUint8(&o.EPSTATUS0.Reg)&^(0x1)|value)
}
func (o *USB_DEVICE_Type) GetEPSTATUS0_DTGLOUT() uint8 {
	return volatile.LoadUint8(&o.EPSTATUS0.Reg) & 0x1
}
func (o *USB_DEVICE_Type) SetEPSTATUS0_DTGLIN(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS0.Reg, volatile.LoadUint8(&o.EPSTATUS0.Reg)&^(0x2)|value<<1)
}
func (o *USB_DEVICE_Type) GetEPSTATUS0_DTGLIN() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUS0.Reg) & 0x2) >> 1
}
func (o *USB_DEVICE_Type) SetEPSTATUS0_CURBK(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS0.Reg, volatile.LoadUint8(&o.EPSTATUS0.Reg)&^(0x4)|value<<2)
}
func (o *USB_DEVICE_Type) GetEPSTATUS0_CURBK() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUS0.Reg) & 0x4) >> 2
}
func (o *USB_DEVICE_Type) SetEPSTATUS0_STALLRQ0(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS0.Reg, volatile.LoadUint8(&o.EPSTATUS0.Reg)&^(0x10)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPSTATUS0_STALLRQ0() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUS0.Reg) & 0x10) >> 4
}
func (o *USB_DEVICE_Type) SetEPSTATUS0_STALLRQ1(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS0.Reg, volatile.LoadUint8(&o.EPSTATUS0.Reg)&^(0x20)|value<<5)
}
func (o *USB_DEVICE_Type) GetEPSTATUS0_STALLRQ1() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUS0.Reg) & 0x20) >> 5
}
func (o *USB_DEVICE_Type) SetEPSTATUS0_BK0RDY(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS0.Reg, volatile.LoadUint8(&o.EPSTATUS0.Reg)&^(0x40)|value<<6)
}
func (o *USB_DEVICE_Type) GetEPSTATUS0_BK0RDY() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUS0.Reg) & 0x40) >> 6
}
func (o *USB_DEVICE_Type) SetEPSTATUS0_BK1RDY(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS0.Reg, volatile.LoadUint8(&o.EPSTATUS0.Reg)&^(0x80)|value<<7)
}
func (o *USB_DEVICE_Type) GetEPSTATUS0_BK1RDY() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUS0.Reg) & 0x80) >> 7
}

// USB_DEVICE.EPINTFLAG0: DEVICE End Point Interrupt Flag
func (o *USB_DEVICE_Type) SetEPINTFLAG0_TRCPT0(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG0.Reg, volatile.LoadUint8(&o.EPINTFLAG0.Reg)&^(0x1)|value)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG0_TRCPT0() uint8 {
	return volatile.LoadUint8(&o.EPINTFLAG0.Reg) & 0x1
}
func (o *USB_DEVICE_Type) SetEPINTFLAG0_TRCPT1(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG0.Reg, volatile.LoadUint8(&o.EPINTFLAG0.Reg)&^(0x2)|value<<1)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG0_TRCPT1() uint8 {
	return (volatile.LoadUint8(&o.EPINTFLAG0.Reg) & 0x2) >> 1
}
func (o *USB_DEVICE_Type) SetEPINTFLAG0_TRFAIL0(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG0.Reg, volatile.LoadUint8(&o.EPINTFLAG0.Reg)&^(0x4)|value<<2)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG0_TRFAIL0() uint8 {
	return (volatile.LoadUint8(&o.EPINTFLAG0.Reg) & 0x4) >> 2
}
func (o *USB_DEVICE_Type) SetEPINTFLAG0_TRFAIL1(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG0.Reg, volatile.LoadUint8(&o.EPINTFLAG0.Reg)&^(0x8)|value<<3)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG0_TRFAIL1() uint8 {
	return (volatile.LoadUint8(&o.EPINTFLAG0.Reg) & 0x8) >> 3
}
func (o *USB_DEVICE_Type) SetEPINTFLAG0_RXSTP(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG0.Reg, volatile.LoadUint8(&o.EPINTFLAG0.Reg)&^(0x10)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG0_RXSTP() uint8 {
	return (volatile.LoadUint8(&o.EPINTFLAG0.Reg) & 0x10) >> 4
}
func (o *USB_DEVICE_Type) SetEPINTFLAG0_STALL0(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG0.Reg, volatile.LoadUint8(&o.EPINTFLAG0.Reg)&^(0x20)|value<<5)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG0_STALL0() uint8 {
	return (volatile.LoadUint8(&o.EPINTFLAG0.Reg) & 0x20) >> 5
}
func (o *USB_DEVICE_Type) SetEPINTFLAG0_STALL1(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG0.Reg, volatile.LoadUint8(&o.EPINTFLAG0.Reg)&^(0x40)|value<<6)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG0_STALL1() uint8 {
	return (volatile.LoadUint8(&o.EPINTFLAG0.Reg) & 0x40) >> 6
}

// USB_DEVICE.EPINTENCLR0: DEVICE End Point Interrupt Clear Flag
func (o *USB_DEVICE_Type) SetEPINTENCLR0_TRCPT0(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR0.Reg, volatile.LoadUint8(&o.EPINTENCLR0.Reg)&^(0x1)|value)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR0_TRCPT0() uint8 {
	return volatile.LoadUint8(&o.EPINTENCLR0.Reg) & 0x1
}
func (o *USB_DEVICE_Type) SetEPINTENCLR0_TRCPT1(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR0.Reg, volatile.LoadUint8(&o.EPINTENCLR0.Reg)&^(0x2)|value<<1)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR0_TRCPT1() uint8 {
	return (volatile.LoadUint8(&o.EPINTENCLR0.Reg) & 0x2) >> 1
}
func (o *USB_DEVICE_Type) SetEPINTENCLR0_TRFAIL0(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR0.Reg, volatile.LoadUint8(&o.EPINTENCLR0.Reg)&^(0x4)|value<<2)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR0_TRFAIL0() uint8 {
	return (volatile.LoadUint8(&o.EPINTENCLR0.Reg) & 0x4) >> 2
}
func (o *USB_DEVICE_Type) SetEPINTENCLR0_TRFAIL1(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR0.Reg, volatile.LoadUint8(&o.EPINTENCLR0.Reg)&^(0x8)|value<<3)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR0_TRFAIL1() uint8 {
	return (volatile.LoadUint8(&o.EPINTENCLR0.Reg) & 0x8) >> 3
}
func (o *USB_DEVICE_Type) SetEPINTENCLR0_RXSTP(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR0.Reg, volatile.LoadUint8(&o.EPINTENCLR0.Reg)&^(0x10)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR0_RXSTP() uint8 {
	return (volatile.LoadUint8(&o.EPINTENCLR0.Reg) & 0x10) >> 4
}
func (o *USB_DEVICE_Type) SetEPINTENCLR0_STALL0(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR0.Reg, volatile.LoadUint8(&o.EPINTENCLR0.Reg)&^(0x20)|value<<5)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR0_STALL0() uint8 {
	return (volatile.LoadUint8(&o.EPINTENCLR0.Reg) & 0x20) >> 5
}
func (o *USB_DEVICE_Type) SetEPINTENCLR0_STALL1(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR0.Reg, volatile.LoadUint8(&o.EPINTENCLR0.Reg)&^(0x40)|value<<6)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR0_STALL1() uint8 {
	return (volatile.LoadUint8(&o.EPINTENCLR0.Reg) & 0x40) >> 6
}

// USB_DEVICE.EPINTENSET0: DEVICE End Point Interrupt Set Flag
func (o *USB_DEVICE_Type) SetEPINTENSET0_TRCPT0(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET0.Reg, volatile.LoadUint8(&o.EPINTENSET0.Reg)&^(0x1)|value)
}
func (o *USB_DEVICE_Type) GetEPINTENSET0_TRCPT0() uint8 {
	return volatile.LoadUint8(&o.EPINTENSET0.Reg) & 0x1
}
func (o *USB_DEVICE_Type) SetEPINTENSET0_TRCPT1(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET0.Reg, volatile.LoadUint8(&o.EPINTENSET0.Reg)&^(0x2)|value<<1)
}
func (o *USB_DEVICE_Type) GetEPINTENSET0_TRCPT1() uint8 {
	return (volatile.LoadUint8(&o.EPINTENSET0.Reg) & 0x2) >> 1
}
func (o *USB_DEVICE_Type) SetEPINTENSET0_TRFAIL0(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET0.Reg, volatile.LoadUint8(&o.EPINTENSET0.Reg)&^(0x4)|value<<2)
}
func (o *USB_DEVICE_Type) GetEPINTENSET0_TRFAIL0() uint8 {
	return (volatile.LoadUint8(&o.EPINTENSET0.Reg) & 0x4) >> 2
}
func (o *USB_DEVICE_Type) SetEPINTENSET0_TRFAIL1(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET0.Reg, volatile.LoadUint8(&o.EPINTENSET0.Reg)&^(0x8)|value<<3)
}
func (o *USB_DEVICE_Type) GetEPINTENSET0_TRFAIL1() uint8 {
	return (volatile.LoadUint8(&o.EPINTENSET0.Reg) & 0x8) >> 3
}
func (o *USB_DEVICE_Type) SetEPINTENSET0_RXSTP(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET0.Reg, volatile.LoadUint8(&o.EPINTENSET0.Reg)&^(0x10)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPINTENSET0_RXSTP() uint8 {
	return (volatile.LoadUint8(&o.EPINTENSET0.Reg) & 0x10) >> 4
}
func (o *USB_DEVICE_Type) SetEPINTENSET0_STALL0(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET0.Reg, volatile.LoadUint8(&o.EPINTENSET0.Reg)&^(0x20)|value<<5)
}
func (o *USB_DEVICE_Type) GetEPINTENSET0_STALL0() uint8 {
	return (volatile.LoadUint8(&o.EPINTENSET0.Reg) & 0x20) >> 5
}
func (o *USB_DEVICE_Type) SetEPINTENSET0_STALL1(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET0.Reg, volatile.LoadUint8(&o.EPINTENSET0.Reg)&^(0x40)|value<<6)
}
func (o *USB_DEVICE_Type) GetEPINTENSET0_STALL1() uint8 {
	return (volatile.LoadUint8(&o.EPINTENSET0.Reg) & 0x40) >> 6
}

// USB_DEVICE.EPCFG1: DEVICE End Point Configuration
func (o *USB_DEVICE_Type) SetEPCFG1_EPTYPE0(value uint8) {
	volatile.StoreUint8(&o.EPCFG1.Reg, volatile.LoadUint8(&o.EPCFG1.Reg)&^(0x7)|value)
}
func (o *USB_DEVICE_Type) GetEPCFG1_EPTYPE0() uint8 {
	return volatile.LoadUint8(&o.EPCFG1.Reg) & 0x7
}
func (o *USB_DEVICE_Type) SetEPCFG1_EPTYPE1(value uint8) {
	volatile.StoreUint8(&o.EPCFG1.Reg, volatile.LoadUint8(&o.EPCFG1.Reg)&^(0x70)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPCFG1_EPTYPE1() uint8 {
	return (volatile.LoadUint8(&o.EPCFG1.Reg) & 0x70) >> 4
}
func (o *USB_DEVICE_Type) SetEPCFG1_NYETDIS(value uint8) {
	volatile.StoreUint8(&o.EPCFG1.Reg, volatile.LoadUint8(&o.EPCFG1.Reg)&^(0x80)|value<<7)
}
func (o *USB_DEVICE_Type) GetEPCFG1_NYETDIS() uint8 {
	return (volatile.LoadUint8(&o.EPCFG1.Reg) & 0x80) >> 7
}

// USB_DEVICE.EPSTATUSCLR1: DEVICE End Point Pipe Status Clear
func (o *USB_DEVICE_Type) SetEPSTATUSCLR1_DTGLOUT(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR1.Reg, volatile.LoadUint8(&o.EPSTATUSCLR1.Reg)&^(0x1)|value)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR1_DTGLOUT() uint8 {
	return volatile.LoadUint8(&o.EPSTATUSCLR1.Reg) & 0x1
}
func (o *USB_DEVICE_Type) SetEPSTATUSCLR1_DTGLIN(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR1.Reg, volatile.LoadUint8(&o.EPSTATUSCLR1.Reg)&^(0x2)|value<<1)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR1_DTGLIN() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSCLR1.Reg) & 0x2) >> 1
}
func (o *USB_DEVICE_Type) SetEPSTATUSCLR1_CURBK(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR1.Reg, volatile.LoadUint8(&o.EPSTATUSCLR1.Reg)&^(0x4)|value<<2)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR1_CURBK() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSCLR1.Reg) & 0x4) >> 2
}
func (o *USB_DEVICE_Type) SetEPSTATUSCLR1_STALLRQ0(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR1.Reg, volatile.LoadUint8(&o.EPSTATUSCLR1.Reg)&^(0x10)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR1_STALLRQ0() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSCLR1.Reg) & 0x10) >> 4
}
func (o *USB_DEVICE_Type) SetEPSTATUSCLR1_STALLRQ1(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR1.Reg, volatile.LoadUint8(&o.EPSTATUSCLR1.Reg)&^(0x20)|value<<5)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR1_STALLRQ1() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSCLR1.Reg) & 0x20) >> 5
}
func (o *USB_DEVICE_Type) SetEPSTATUSCLR1_BK0RDY(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR1.Reg, volatile.LoadUint8(&o.EPSTATUSCLR1.Reg)&^(0x40)|value<<6)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR1_BK0RDY() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSCLR1.Reg) & 0x40) >> 6
}
func (o *USB_DEVICE_Type) SetEPSTATUSCLR1_BK1RDY(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR1.Reg, volatile.LoadUint8(&o.EPSTATUSCLR1.Reg)&^(0x80)|value<<7)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR1_BK1RDY() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSCLR1.Reg) & 0x80) >> 7
}

// USB_DEVICE.EPSTATUSSET1: DEVICE End Point Pipe Status Set
func (o *USB_DEVICE_Type) SetEPSTATUSSET1_DTGLOUT(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET1.Reg, volatile.LoadUint8(&o.EPSTATUSSET1.Reg)&^(0x1)|value)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET1_DTGLOUT() uint8 {
	return volatile.LoadUint8(&o.EPSTATUSSET1.Reg) & 0x1
}
func (o *USB_DEVICE_Type) SetEPSTATUSSET1_DTGLIN(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET1.Reg, volatile.LoadUint8(&o.EPSTATUSSET1.Reg)&^(0x2)|value<<1)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET1_DTGLIN() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSSET1.Reg) & 0x2) >> 1
}
func (o *USB_DEVICE_Type) SetEPSTATUSSET1_CURBK(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET1.Reg, volatile.LoadUint8(&o.EPSTATUSSET1.Reg)&^(0x4)|value<<2)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET1_CURBK() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSSET1.Reg) & 0x4) >> 2
}
func (o *USB_DEVICE_Type) SetEPSTATUSSET1_STALLRQ0(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET1.Reg, volatile.LoadUint8(&o.EPSTATUSSET1.Reg)&^(0x10)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET1_STALLRQ0() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSSET1.Reg) & 0x10) >> 4
}
func (o *USB_DEVICE_Type) SetEPSTATUSSET1_STALLRQ1(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET1.Reg, volatile.LoadUint8(&o.EPSTATUSSET1.Reg)&^(0x20)|value<<5)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET1_STALLRQ1() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSSET1.Reg) & 0x20) >> 5
}
func (o *USB_DEVICE_Type) SetEPSTATUSSET1_BK0RDY(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET1.Reg, volatile.LoadUint8(&o.EPSTATUSSET1.Reg)&^(0x40)|value<<6)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET1_BK0RDY() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSSET1.Reg) & 0x40) >> 6
}
func (o *USB_DEVICE_Type) SetEPSTATUSSET1_BK1RDY(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET1.Reg, volatile.LoadUint8(&o.EPSTATUSSET1.Reg)&^(0x80)|value<<7)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET1_BK1RDY() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSSET1.Reg) & 0x80) >> 7
}

// USB_DEVICE.EPSTATUS1: DEVICE End Point Pipe Status
func (o *USB_DEVICE_Type) SetEPSTATUS1_DTGLOUT(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS1.Reg, volatile.LoadUint8(&o.EPSTATUS1.Reg)&^(0x1)|value)
}
func (o *USB_DEVICE_Type) GetEPSTATUS1_DTGLOUT() uint8 {
	return volatile.LoadUint8(&o.EPSTATUS1.Reg) & 0x1
}
func (o *USB_DEVICE_Type) SetEPSTATUS1_DTGLIN(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS1.Reg, volatile.LoadUint8(&o.EPSTATUS1.Reg)&^(0x2)|value<<1)
}
func (o *USB_DEVICE_Type) GetEPSTATUS1_DTGLIN() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUS1.Reg) & 0x2) >> 1
}
func (o *USB_DEVICE_Type) SetEPSTATUS1_CURBK(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS1.Reg, volatile.LoadUint8(&o.EPSTATUS1.Reg)&^(0x4)|value<<2)
}
func (o *USB_DEVICE_Type) GetEPSTATUS1_CURBK() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUS1.Reg) & 0x4) >> 2
}
func (o *USB_DEVICE_Type) SetEPSTATUS1_STALLRQ0(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS1.Reg, volatile.LoadUint8(&o.EPSTATUS1.Reg)&^(0x10)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPSTATUS1_STALLRQ0() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUS1.Reg) & 0x10) >> 4
}
func (o *USB_DEVICE_Type) SetEPSTATUS1_STALLRQ1(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS1.Reg, volatile.LoadUint8(&o.EPSTATUS1.Reg)&^(0x20)|value<<5)
}
func (o *USB_DEVICE_Type) GetEPSTATUS1_STALLRQ1() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUS1.Reg) & 0x20) >> 5
}
func (o *USB_DEVICE_Type) SetEPSTATUS1_BK0RDY(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS1.Reg, volatile.LoadUint8(&o.EPSTATUS1.Reg)&^(0x40)|value<<6)
}
func (o *USB_DEVICE_Type) GetEPSTATUS1_BK0RDY() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUS1.Reg) & 0x40) >> 6
}
func (o *USB_DEVICE_Type) SetEPSTATUS1_BK1RDY(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS1.Reg, volatile.LoadUint8(&o.EPSTATUS1.Reg)&^(0x80)|value<<7)
}
func (o *USB_DEVICE_Type) GetEPSTATUS1_BK1RDY() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUS1.Reg) & 0x80) >> 7
}

// USB_DEVICE.EPINTFLAG1: DEVICE End Point Interrupt Flag
func (o *USB_DEVICE_Type) SetEPINTFLAG1_TRCPT0(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG1.Reg, volatile.LoadUint8(&o.EPINTFLAG1.Reg)&^(0x1)|value)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG1_TRCPT0() uint8 {
	return volatile.LoadUint8(&o.EPINTFLAG1.Reg) & 0x1
}
func (o *USB_DEVICE_Type) SetEPINTFLAG1_TRCPT1(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG1.Reg, volatile.LoadUint8(&o.EPINTFLAG1.Reg)&^(0x2)|value<<1)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG1_TRCPT1() uint8 {
	return (volatile.LoadUint8(&o.EPINTFLAG1.Reg) & 0x2) >> 1
}
func (o *USB_DEVICE_Type) SetEPINTFLAG1_TRFAIL0(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG1.Reg, volatile.LoadUint8(&o.EPINTFLAG1.Reg)&^(0x4)|value<<2)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG1_TRFAIL0() uint8 {
	return (volatile.LoadUint8(&o.EPINTFLAG1.Reg) & 0x4) >> 2
}
func (o *USB_DEVICE_Type) SetEPINTFLAG1_TRFAIL1(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG1.Reg, volatile.LoadUint8(&o.EPINTFLAG1.Reg)&^(0x8)|value<<3)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG1_TRFAIL1() uint8 {
	return (volatile.LoadUint8(&o.EPINTFLAG1.Reg) & 0x8) >> 3
}
func (o *USB_DEVICE_Type) SetEPINTFLAG1_RXSTP(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG1.Reg, volatile.LoadUint8(&o.EPINTFLAG1.Reg)&^(0x10)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG1_RXSTP() uint8 {
	return (volatile.LoadUint8(&o.EPINTFLAG1.Reg) & 0x10) >> 4
}
func (o *USB_DEVICE_Type) SetEPINTFLAG1_STALL0(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG1.Reg, volatile.LoadUint8(&o.EPINTFLAG1.Reg)&^(0x20)|value<<5)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG1_STALL0() uint8 {
	return (volatile.LoadUint8(&o.EPINTFLAG1.Reg) & 0x20) >> 5
}
func (o *USB_DEVICE_Type) SetEPINTFLAG1_STALL1(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG1.Reg, volatile.LoadUint8(&o.EPINTFLAG1.Reg)&^(0x40)|value<<6)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG1_STALL1() uint8 {
	return (volatile.LoadUint8(&o.EPINTFLAG1.Reg) & 0x40) >> 6
}

// USB_DEVICE.EPINTENCLR1: DEVICE End Point Interrupt Clear Flag
func (o *USB_DEVICE_Type) SetEPINTENCLR1_TRCPT0(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR1.Reg, volatile.LoadUint8(&o.EPINTENCLR1.Reg)&^(0x1)|value)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR1_TRCPT0() uint8 {
	return volatile.LoadUint8(&o.EPINTENCLR1.Reg) & 0x1
}
func (o *USB_DEVICE_Type) SetEPINTENCLR1_TRCPT1(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR1.Reg, volatile.LoadUint8(&o.EPINTENCLR1.Reg)&^(0x2)|value<<1)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR1_TRCPT1() uint8 {
	return (volatile.LoadUint8(&o.EPINTENCLR1.Reg) & 0x2) >> 1
}
func (o *USB_DEVICE_Type) SetEPINTENCLR1_TRFAIL0(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR1.Reg, volatile.LoadUint8(&o.EPINTENCLR1.Reg)&^(0x4)|value<<2)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR1_TRFAIL0() uint8 {
	return (volatile.LoadUint8(&o.EPINTENCLR1.Reg) & 0x4) >> 2
}
func (o *USB_DEVICE_Type) SetEPINTENCLR1_TRFAIL1(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR1.Reg, volatile.LoadUint8(&o.EPINTENCLR1.Reg)&^(0x8)|value<<3)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR1_TRFAIL1() uint8 {
	return (volatile.LoadUint8(&o.EPINTENCLR1.Reg) & 0x8) >> 3
}
func (o *USB_DEVICE_Type) SetEPINTENCLR1_RXSTP(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR1.Reg, volatile.LoadUint8(&o.EPINTENCLR1.Reg)&^(0x10)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR1_RXSTP() uint8 {
	return (volatile.LoadUint8(&o.EPINTENCLR1.Reg) & 0x10) >> 4
}
func (o *USB_DEVICE_Type) SetEPINTENCLR1_STALL0(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR1.Reg, volatile.LoadUint8(&o.EPINTENCLR1.Reg)&^(0x20)|value<<5)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR1_STALL0() uint8 {
	return (volatile.LoadUint8(&o.EPINTENCLR1.Reg) & 0x20) >> 5
}
func (o *USB_DEVICE_Type) SetEPINTENCLR1_STALL1(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR1.Reg, volatile.LoadUint8(&o.EPINTENCLR1.Reg)&^(0x40)|value<<6)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR1_STALL1() uint8 {
	return (volatile.LoadUint8(&o.EPINTENCLR1.Reg) & 0x40) >> 6
}

// USB_DEVICE.EPINTENSET1: DEVICE End Point Interrupt Set Flag
func (o *USB_DEVICE_Type) SetEPINTENSET1_TRCPT0(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET1.Reg, volatile.LoadUint8(&o.EPINTENSET1.Reg)&^(0x1)|value)
}
func (o *USB_DEVICE_Type) GetEPINTENSET1_TRCPT0() uint8 {
	return volatile.LoadUint8(&o.EPINTENSET1.Reg) & 0x1
}
func (o *USB_DEVICE_Type) SetEPINTENSET1_TRCPT1(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET1.Reg, volatile.LoadUint8(&o.EPINTENSET1.Reg)&^(0x2)|value<<1)
}
func (o *USB_DEVICE_Type) GetEPINTENSET1_TRCPT1() uint8 {
	return (volatile.LoadUint8(&o.EPINTENSET1.Reg) & 0x2) >> 1
}
func (o *USB_DEVICE_Type) SetEPINTENSET1_TRFAIL0(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET1.Reg, volatile.LoadUint8(&o.EPINTENSET1.Reg)&^(0x4)|value<<2)
}
func (o *USB_DEVICE_Type) GetEPINTENSET1_TRFAIL0() uint8 {
	return (volatile.LoadUint8(&o.EPINTENSET1.Reg) & 0x4) >> 2
}
func (o *USB_DEVICE_Type) SetEPINTENSET1_TRFAIL1(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET1.Reg, volatile.LoadUint8(&o.EPINTENSET1.Reg)&^(0x8)|value<<3)
}
func (o *USB_DEVICE_Type) GetEPINTENSET1_TRFAIL1() uint8 {
	return (volatile.LoadUint8(&o.EPINTENSET1.Reg) & 0x8) >> 3
}
func (o *USB_DEVICE_Type) SetEPINTENSET1_RXSTP(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET1.Reg, volatile.LoadUint8(&o.EPINTENSET1.Reg)&^(0x10)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPINTENSET1_RXSTP() uint8 {
	return (volatile.LoadUint8(&o.EPINTENSET1.Reg) & 0x10) >> 4
}
func (o *USB_DEVICE_Type) SetEPINTENSET1_STALL0(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET1.Reg, volatile.LoadUint8(&o.EPINTENSET1.Reg)&^(0x20)|value<<5)
}
func (o *USB_DEVICE_Type) GetEPINTENSET1_STALL0() uint8 {
	return (volatile.LoadUint8(&o.EPINTENSET1.Reg) & 0x20) >> 5
}
func (o *USB_DEVICE_Type) SetEPINTENSET1_STALL1(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET1.Reg, volatile.LoadUint8(&o.EPINTENSET1.Reg)&^(0x40)|value<<6)
}
func (o *USB_DEVICE_Type) GetEPINTENSET1_STALL1() uint8 {
	return (volatile.LoadUint8(&o.EPINTENSET1.Reg) & 0x40) >> 6
}

// USB_DEVICE.EPCFG2: DEVICE End Point Configuration
func (o *USB_DEVICE_Type) SetEPCFG2_EPTYPE0(value uint8) {
	volatile.StoreUint8(&o.EPCFG2.Reg, volatile.LoadUint8(&o.EPCFG2.Reg)&^(0x7)|value)
}
func (o *USB_DEVICE_Type) GetEPCFG2_EPTYPE0() uint8 {
	return volatile.LoadUint8(&o.EPCFG2.Reg) & 0x7
}
func (o *USB_DEVICE_Type) SetEPCFG2_EPTYPE1(value uint8) {
	volatile.StoreUint8(&o.EPCFG2.Reg, volatile.LoadUint8(&o.EPCFG2.Reg)&^(0x70)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPCFG2_EPTYPE1() uint8 {
	return (volatile.LoadUint8(&o.EPCFG2.Reg) & 0x70) >> 4
}
func (o *USB_DEVICE_Type) SetEPCFG2_NYETDIS(value uint8) {
	volatile.StoreUint8(&o.EPCFG2.Reg, volatile.LoadUint8(&o.EPCFG2.Reg)&^(0x80)|value<<7)
}
func (o *USB_DEVICE_Type) GetEPCFG2_NYETDIS() uint8 {
	return (volatile.LoadUint8(&o.EPCFG2.Reg) & 0x80) >> 7
}

// USB_DEVICE.EPSTATUSCLR2: DEVICE End Point Pipe Status Clear
func (o *USB_DEVICE_Type) SetEPSTATUSCLR2_DTGLOUT(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR2.Reg, volatile.LoadUint8(&o.EPSTATUSCLR2.Reg)&^(0x1)|value)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR2_DTGLOUT() uint8 {
	return volatile.LoadUint8(&o.EPSTATUSCLR2.Reg) & 0x1
}
func (o *USB_DEVICE_Type) SetEPSTATUSCLR2_DTGLIN(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR2.Reg, volatile.LoadUint8(&o.EPSTATUSCLR2.Reg)&^(0x2)|value<<1)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR2_DTGLIN() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSCLR2.Reg) & 0x2) >> 1
}
func (o *USB_DEVICE_Type) SetEPSTATUSCLR2_CURBK(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR2.Reg, volatile.LoadUint8(&o.EPSTATUSCLR2.Reg)&^(0x4)|value<<2)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR2_CURBK() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSCLR2.Reg) & 0x4) >> 2
}
func (o *USB_DEVICE_Type) SetEPSTATUSCLR2_STALLRQ0(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR2.Reg, volatile.LoadUint8(&o.EPSTATUSCLR2.Reg)&^(0x10)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR2_STALLRQ0() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSCLR2.Reg) & 0x10) >> 4
}
func (o *USB_DEVICE_Type) SetEPSTATUSCLR2_STALLRQ1(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR2.Reg, volatile.LoadUint8(&o.EPSTATUSCLR2.Reg)&^(0x20)|value<<5)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR2_STALLRQ1() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSCLR2.Reg) & 0x20) >> 5
}
func (o *USB_DEVICE_Type) SetEPSTATUSCLR2_BK0RDY(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR2.Reg, volatile.LoadUint8(&o.EPSTATUSCLR2.Reg)&^(0x40)|value<<6)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR2_BK0RDY() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSCLR2.Reg) & 0x40) >> 6
}
func (o *USB_DEVICE_Type) SetEPSTATUSCLR2_BK1RDY(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR2.Reg, volatile.LoadUint8(&o.EPSTATUSCLR2.Reg)&^(0x80)|value<<7)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR2_BK1RDY() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSCLR2.Reg) & 0x80) >> 7
}

// USB_DEVICE.EPSTATUSSET2: DEVICE End Point Pipe Status Set
func (o *USB_DEVICE_Type) SetEPSTATUSSET2_DTGLOUT(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET2.Reg, volatile.LoadUint8(&o.EPSTATUSSET2.Reg)&^(0x1)|value)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET2_DTGLOUT() uint8 {
	return volatile.LoadUint8(&o.EPSTATUSSET2.Reg) & 0x1
}
func (o *USB_DEVICE_Type) SetEPSTATUSSET2_DTGLIN(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET2.Reg, volatile.LoadUint8(&o.EPSTATUSSET2.Reg)&^(0x2)|value<<1)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET2_DTGLIN() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSSET2.Reg) & 0x2) >> 1
}
func (o *USB_DEVICE_Type) SetEPSTATUSSET2_CURBK(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET2.Reg, volatile.LoadUint8(&o.EPSTATUSSET2.Reg)&^(0x4)|value<<2)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET2_CURBK() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSSET2.Reg) & 0x4) >> 2
}
func (o *USB_DEVICE_Type) SetEPSTATUSSET2_STALLRQ0(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET2.Reg, volatile.LoadUint8(&o.EPSTATUSSET2.Reg)&^(0x10)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET2_STALLRQ0() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSSET2.Reg) & 0x10) >> 4
}
func (o *USB_DEVICE_Type) SetEPSTATUSSET2_STALLRQ1(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET2.Reg, volatile.LoadUint8(&o.EPSTATUSSET2.Reg)&^(0x20)|value<<5)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET2_STALLRQ1() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSSET2.Reg) & 0x20) >> 5
}
func (o *USB_DEVICE_Type) SetEPSTATUSSET2_BK0RDY(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET2.Reg, volatile.LoadUint8(&o.EPSTATUSSET2.Reg)&^(0x40)|value<<6)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET2_BK0RDY() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSSET2.Reg) & 0x40) >> 6
}
func (o *USB_DEVICE_Type) SetEPSTATUSSET2_BK1RDY(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET2.Reg, volatile.LoadUint8(&o.EPSTATUSSET2.Reg)&^(0x80)|value<<7)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET2_BK1RDY() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSSET2.Reg) & 0x80) >> 7
}

// USB_DEVICE.EPSTATUS2: DEVICE End Point Pipe Status
func (o *USB_DEVICE_Type) SetEPSTATUS2_DTGLOUT(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS2.Reg, volatile.LoadUint8(&o.EPSTATUS2.Reg)&^(0x1)|value)
}
func (o *USB_DEVICE_Type) GetEPSTATUS2_DTGLOUT() uint8 {
	return volatile.LoadUint8(&o.EPSTATUS2.Reg) & 0x1
}
func (o *USB_DEVICE_Type) SetEPSTATUS2_DTGLIN(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS2.Reg, volatile.LoadUint8(&o.EPSTATUS2.Reg)&^(0x2)|value<<1)
}
func (o *USB_DEVICE_Type) GetEPSTATUS2_DTGLIN() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUS2.Reg) & 0x2) >> 1
}
func (o *USB_DEVICE_Type) SetEPSTATUS2_CURBK(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS2.Reg, volatile.LoadUint8(&o.EPSTATUS2.Reg)&^(0x4)|value<<2)
}
func (o *USB_DEVICE_Type) GetEPSTATUS2_CURBK() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUS2.Reg) & 0x4) >> 2
}
func (o *USB_DEVICE_Type) SetEPSTATUS2_STALLRQ0(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS2.Reg, volatile.LoadUint8(&o.EPSTATUS2.Reg)&^(0x10)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPSTATUS2_STALLRQ0() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUS2.Reg) & 0x10) >> 4
}
func (o *USB_DEVICE_Type) SetEPSTATUS2_STALLRQ1(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS2.Reg, volatile.LoadUint8(&o.EPSTATUS2.Reg)&^(0x20)|value<<5)
}
func (o *USB_DEVICE_Type) GetEPSTATUS2_STALLRQ1() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUS2.Reg) & 0x20) >> 5
}
func (o *USB_DEVICE_Type) SetEPSTATUS2_BK0RDY(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS2.Reg, volatile.LoadUint8(&o.EPSTATUS2.Reg)&^(0x40)|value<<6)
}
func (o *USB_DEVICE_Type) GetEPSTATUS2_BK0RDY() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUS2.Reg) & 0x40) >> 6
}
func (o *USB_DEVICE_Type) SetEPSTATUS2_BK1RDY(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS2.Reg, volatile.LoadUint8(&o.EPSTATUS2.Reg)&^(0x80)|value<<7)
}
func (o *USB_DEVICE_Type) GetEPSTATUS2_BK1RDY() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUS2.Reg) & 0x80) >> 7
}

// USB_DEVICE.EPINTFLAG2: DEVICE End Point Interrupt Flag
func (o *USB_DEVICE_Type) SetEPINTFLAG2_TRCPT0(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG2.Reg, volatile.LoadUint8(&o.EPINTFLAG2.Reg)&^(0x1)|value)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG2_TRCPT0() uint8 {
	return volatile.LoadUint8(&o.EPINTFLAG2.Reg) & 0x1
}
func (o *USB_DEVICE_Type) SetEPINTFLAG2_TRCPT1(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG2.Reg, volatile.LoadUint8(&o.EPINTFLAG2.Reg)&^(0x2)|value<<1)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG2_TRCPT1() uint8 {
	return (volatile.LoadUint8(&o.EPINTFLAG2.Reg) & 0x2) >> 1
}
func (o *USB_DEVICE_Type) SetEPINTFLAG2_TRFAIL0(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG2.Reg, volatile.LoadUint8(&o.EPINTFLAG2.Reg)&^(0x4)|value<<2)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG2_TRFAIL0() uint8 {
	return (volatile.LoadUint8(&o.EPINTFLAG2.Reg) & 0x4) >> 2
}
func (o *USB_DEVICE_Type) SetEPINTFLAG2_TRFAIL1(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG2.Reg, volatile.LoadUint8(&o.EPINTFLAG2.Reg)&^(0x8)|value<<3)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG2_TRFAIL1() uint8 {
	return (volatile.LoadUint8(&o.EPINTFLAG2.Reg) & 0x8) >> 3
}
func (o *USB_DEVICE_Type) SetEPINTFLAG2_RXSTP(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG2.Reg, volatile.LoadUint8(&o.EPINTFLAG2.Reg)&^(0x10)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG2_RXSTP() uint8 {
	return (volatile.LoadUint8(&o.EPINTFLAG2.Reg) & 0x10) >> 4
}
func (o *USB_DEVICE_Type) SetEPINTFLAG2_STALL0(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG2.Reg, volatile.LoadUint8(&o.EPINTFLAG2.Reg)&^(0x20)|value<<5)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG2_STALL0() uint8 {
	return (volatile.LoadUint8(&o.EPINTFLAG2.Reg) & 0x20) >> 5
}
func (o *USB_DEVICE_Type) SetEPINTFLAG2_STALL1(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG2.Reg, volatile.LoadUint8(&o.EPINTFLAG2.Reg)&^(0x40)|value<<6)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG2_STALL1() uint8 {
	return (volatile.LoadUint8(&o.EPINTFLAG2.Reg) & 0x40) >> 6
}

// USB_DEVICE.EPINTENCLR2: DEVICE End Point Interrupt Clear Flag
func (o *USB_DEVICE_Type) SetEPINTENCLR2_TRCPT0(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR2.Reg, volatile.LoadUint8(&o.EPINTENCLR2.Reg)&^(0x1)|value)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR2_TRCPT0() uint8 {
	return volatile.LoadUint8(&o.EPINTENCLR2.Reg) & 0x1
}
func (o *USB_DEVICE_Type) SetEPINTENCLR2_TRCPT1(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR2.Reg, volatile.LoadUint8(&o.EPINTENCLR2.Reg)&^(0x2)|value<<1)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR2_TRCPT1() uint8 {
	return (volatile.LoadUint8(&o.EPINTENCLR2.Reg) & 0x2) >> 1
}
func (o *USB_DEVICE_Type) SetEPINTENCLR2_TRFAIL0(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR2.Reg, volatile.LoadUint8(&o.EPINTENCLR2.Reg)&^(0x4)|value<<2)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR2_TRFAIL0() uint8 {
	return (volatile.LoadUint8(&o.EPINTENCLR2.Reg) & 0x4) >> 2
}
func (o *USB_DEVICE_Type) SetEPINTENCLR2_TRFAIL1(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR2.Reg, volatile.LoadUint8(&o.EPINTENCLR2.Reg)&^(0x8)|value<<3)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR2_TRFAIL1() uint8 {
	return (volatile.LoadUint8(&o.EPINTENCLR2.Reg) & 0x8) >> 3
}
func (o *USB_DEVICE_Type) SetEPINTENCLR2_RXSTP(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR2.Reg, volatile.LoadUint8(&o.EPINTENCLR2.Reg)&^(0x10)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR2_RXSTP() uint8 {
	return (volatile.LoadUint8(&o.EPINTENCLR2.Reg) & 0x10) >> 4
}
func (o *USB_DEVICE_Type) SetEPINTENCLR2_STALL0(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR2.Reg, volatile.LoadUint8(&o.EPINTENCLR2.Reg)&^(0x20)|value<<5)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR2_STALL0() uint8 {
	return (volatile.LoadUint8(&o.EPINTENCLR2.Reg) & 0x20) >> 5
}
func (o *USB_DEVICE_Type) SetEPINTENCLR2_STALL1(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR2.Reg, volatile.LoadUint8(&o.EPINTENCLR2.Reg)&^(0x40)|value<<6)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR2_STALL1() uint8 {
	return (volatile.LoadUint8(&o.EPINTENCLR2.Reg) & 0x40) >> 6
}

// USB_DEVICE.EPINTENSET2: DEVICE End Point Interrupt Set Flag
func (o *USB_DEVICE_Type) SetEPINTENSET2_TRCPT0(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET2.Reg, volatile.LoadUint8(&o.EPINTENSET2.Reg)&^(0x1)|value)
}
func (o *USB_DEVICE_Type) GetEPINTENSET2_TRCPT0() uint8 {
	return volatile.LoadUint8(&o.EPINTENSET2.Reg) & 0x1
}
func (o *USB_DEVICE_Type) SetEPINTENSET2_TRCPT1(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET2.Reg, volatile.LoadUint8(&o.EPINTENSET2.Reg)&^(0x2)|value<<1)
}
func (o *USB_DEVICE_Type) GetEPINTENSET2_TRCPT1() uint8 {
	return (volatile.LoadUint8(&o.EPINTENSET2.Reg) & 0x2) >> 1
}
func (o *USB_DEVICE_Type) SetEPINTENSET2_TRFAIL0(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET2.Reg, volatile.LoadUint8(&o.EPINTENSET2.Reg)&^(0x4)|value<<2)
}
func (o *USB_DEVICE_Type) GetEPINTENSET2_TRFAIL0() uint8 {
	return (volatile.LoadUint8(&o.EPINTENSET2.Reg) & 0x4) >> 2
}
func (o *USB_DEVICE_Type) SetEPINTENSET2_TRFAIL1(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET2.Reg, volatile.LoadUint8(&o.EPINTENSET2.Reg)&^(0x8)|value<<3)
}
func (o *USB_DEVICE_Type) GetEPINTENSET2_TRFAIL1() uint8 {
	return (volatile.LoadUint8(&o.EPINTENSET2.Reg) & 0x8) >> 3
}
func (o *USB_DEVICE_Type) SetEPINTENSET2_RXSTP(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET2.Reg, volatile.LoadUint8(&o.EPINTENSET2.Reg)&^(0x10)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPINTENSET2_RXSTP() uint8 {
	return (volatile.LoadUint8(&o.EPINTENSET2.Reg) & 0x10) >> 4
}
func (o *USB_DEVICE_Type) SetEPINTENSET2_STALL0(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET2.Reg, volatile.LoadUint8(&o.EPINTENSET2.Reg)&^(0x20)|value<<5)
}
func (o *USB_DEVICE_Type) GetEPINTENSET2_STALL0() uint8 {
	return (volatile.LoadUint8(&o.EPINTENSET2.Reg) & 0x20) >> 5
}
func (o *USB_DEVICE_Type) SetEPINTENSET2_STALL1(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET2.Reg, volatile.LoadUint8(&o.EPINTENSET2.Reg)&^(0x40)|value<<6)
}
func (o *USB_DEVICE_Type) GetEPINTENSET2_STALL1() uint8 {
	return (volatile.LoadUint8(&o.EPINTENSET2.Reg) & 0x40) >> 6
}

// USB_DEVICE.EPCFG3: DEVICE End Point Configuration
func (o *USB_DEVICE_Type) SetEPCFG3_EPTYPE0(value uint8) {
	volatile.StoreUint8(&o.EPCFG3.Reg, volatile.LoadUint8(&o.EPCFG3.Reg)&^(0x7)|value)
}
func (o *USB_DEVICE_Type) GetEPCFG3_EPTYPE0() uint8 {
	return volatile.LoadUint8(&o.EPCFG3.Reg) & 0x7
}
func (o *USB_DEVICE_Type) SetEPCFG3_EPTYPE1(value uint8) {
	volatile.StoreUint8(&o.EPCFG3.Reg, volatile.LoadUint8(&o.EPCFG3.Reg)&^(0x70)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPCFG3_EPTYPE1() uint8 {
	return (volatile.LoadUint8(&o.EPCFG3.Reg) & 0x70) >> 4
}
func (o *USB_DEVICE_Type) SetEPCFG3_NYETDIS(value uint8) {
	volatile.StoreUint8(&o.EPCFG3.Reg, volatile.LoadUint8(&o.EPCFG3.Reg)&^(0x80)|value<<7)
}
func (o *USB_DEVICE_Type) GetEPCFG3_NYETDIS() uint8 {
	return (volatile.LoadUint8(&o.EPCFG3.Reg) & 0x80) >> 7
}

// USB_DEVICE.EPSTATUSCLR3: DEVICE End Point Pipe Status Clear
func (o *USB_DEVICE_Type) SetEPSTATUSCLR3_DTGLOUT(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR3.Reg, volatile.LoadUint8(&o.EPSTATUSCLR3.Reg)&^(0x1)|value)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR3_DTGLOUT() uint8 {
	return volatile.LoadUint8(&o.EPSTATUSCLR3.Reg) & 0x1
}
func (o *USB_DEVICE_Type) SetEPSTATUSCLR3_DTGLIN(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR3.Reg, volatile.LoadUint8(&o.EPSTATUSCLR3.Reg)&^(0x2)|value<<1)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR3_DTGLIN() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSCLR3.Reg) & 0x2) >> 1
}
func (o *USB_DEVICE_Type) SetEPSTATUSCLR3_CURBK(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR3.Reg, volatile.LoadUint8(&o.EPSTATUSCLR3.Reg)&^(0x4)|value<<2)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR3_CURBK() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSCLR3.Reg) & 0x4) >> 2
}
func (o *USB_DEVICE_Type) SetEPSTATUSCLR3_STALLRQ0(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR3.Reg, volatile.LoadUint8(&o.EPSTATUSCLR3.Reg)&^(0x10)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR3_STALLRQ0() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSCLR3.Reg) & 0x10) >> 4
}
func (o *USB_DEVICE_Type) SetEPSTATUSCLR3_STALLRQ1(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR3.Reg, volatile.LoadUint8(&o.EPSTATUSCLR3.Reg)&^(0x20)|value<<5)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR3_STALLRQ1() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSCLR3.Reg) & 0x20) >> 5
}
func (o *USB_DEVICE_Type) SetEPSTATUSCLR3_BK0RDY(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR3.Reg, volatile.LoadUint8(&o.EPSTATUSCLR3.Reg)&^(0x40)|value<<6)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR3_BK0RDY() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSCLR3.Reg) & 0x40) >> 6
}
func (o *USB_DEVICE_Type) SetEPSTATUSCLR3_BK1RDY(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR3.Reg, volatile.LoadUint8(&o.EPSTATUSCLR3.Reg)&^(0x80)|value<<7)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR3_BK1RDY() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSCLR3.Reg) & 0x80) >> 7
}

// USB_DEVICE.EPSTATUSSET3: DEVICE End Point Pipe Status Set
func (o *USB_DEVICE_Type) SetEPSTATUSSET3_DTGLOUT(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET3.Reg, volatile.LoadUint8(&o.EPSTATUSSET3.Reg)&^(0x1)|value)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET3_DTGLOUT() uint8 {
	return volatile.LoadUint8(&o.EPSTATUSSET3.Reg) & 0x1
}
func (o *USB_DEVICE_Type) SetEPSTATUSSET3_DTGLIN(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET3.Reg, volatile.LoadUint8(&o.EPSTATUSSET3.Reg)&^(0x2)|value<<1)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET3_DTGLIN() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSSET3.Reg) & 0x2) >> 1
}
func (o *USB_DEVICE_Type) SetEPSTATUSSET3_CURBK(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET3.Reg, volatile.LoadUint8(&o.EPSTATUSSET3.Reg)&^(0x4)|value<<2)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET3_CURBK() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSSET3.Reg) & 0x4) >> 2
}
func (o *USB_DEVICE_Type) SetEPSTATUSSET3_STALLRQ0(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET3.Reg, volatile.LoadUint8(&o.EPSTATUSSET3.Reg)&^(0x10)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET3_STALLRQ0() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSSET3.Reg) & 0x10) >> 4
}
func (o *USB_DEVICE_Type) SetEPSTATUSSET3_STALLRQ1(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET3.Reg, volatile.LoadUint8(&o.EPSTATUSSET3.Reg)&^(0x20)|value<<5)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET3_STALLRQ1() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSSET3.Reg) & 0x20) >> 5
}
func (o *USB_DEVICE_Type) SetEPSTATUSSET3_BK0RDY(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET3.Reg, volatile.LoadUint8(&o.EPSTATUSSET3.Reg)&^(0x40)|value<<6)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET3_BK0RDY() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSSET3.Reg) & 0x40) >> 6
}
func (o *USB_DEVICE_Type) SetEPSTATUSSET3_BK1RDY(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET3.Reg, volatile.LoadUint8(&o.EPSTATUSSET3.Reg)&^(0x80)|value<<7)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET3_BK1RDY() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSSET3.Reg) & 0x80) >> 7
}

// USB_DEVICE.EPSTATUS3: DEVICE End Point Pipe Status
func (o *USB_DEVICE_Type) SetEPSTATUS3_DTGLOUT(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS3.Reg, volatile.LoadUint8(&o.EPSTATUS3.Reg)&^(0x1)|value)
}
func (o *USB_DEVICE_Type) GetEPSTATUS3_DTGLOUT() uint8 {
	return volatile.LoadUint8(&o.EPSTATUS3.Reg) & 0x1
}
func (o *USB_DEVICE_Type) SetEPSTATUS3_DTGLIN(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS3.Reg, volatile.LoadUint8(&o.EPSTATUS3.Reg)&^(0x2)|value<<1)
}
func (o *USB_DEVICE_Type) GetEPSTATUS3_DTGLIN() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUS3.Reg) & 0x2) >> 1
}
func (o *USB_DEVICE_Type) SetEPSTATUS3_CURBK(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS3.Reg, volatile.LoadUint8(&o.EPSTATUS3.Reg)&^(0x4)|value<<2)
}
func (o *USB_DEVICE_Type) GetEPSTATUS3_CURBK() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUS3.Reg) & 0x4) >> 2
}
func (o *USB_DEVICE_Type) SetEPSTATUS3_STALLRQ0(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS3.Reg, volatile.LoadUint8(&o.EPSTATUS3.Reg)&^(0x10)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPSTATUS3_STALLRQ0() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUS3.Reg) & 0x10) >> 4
}
func (o *USB_DEVICE_Type) SetEPSTATUS3_STALLRQ1(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS3.Reg, volatile.LoadUint8(&o.EPSTATUS3.Reg)&^(0x20)|value<<5)
}
func (o *USB_DEVICE_Type) GetEPSTATUS3_STALLRQ1() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUS3.Reg) & 0x20) >> 5
}
func (o *USB_DEVICE_Type) SetEPSTATUS3_BK0RDY(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS3.Reg, volatile.LoadUint8(&o.EPSTATUS3.Reg)&^(0x40)|value<<6)
}
func (o *USB_DEVICE_Type) GetEPSTATUS3_BK0RDY() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUS3.Reg) & 0x40) >> 6
}
func (o *USB_DEVICE_Type) SetEPSTATUS3_BK1RDY(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS3.Reg, volatile.LoadUint8(&o.EPSTATUS3.Reg)&^(0x80)|value<<7)
}
func (o *USB_DEVICE_Type) GetEPSTATUS3_BK1RDY() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUS3.Reg) & 0x80) >> 7
}

// USB_DEVICE.EPINTFLAG3: DEVICE End Point Interrupt Flag
func (o *USB_DEVICE_Type) SetEPINTFLAG3_TRCPT0(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG3.Reg, volatile.LoadUint8(&o.EPINTFLAG3.Reg)&^(0x1)|value)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG3_TRCPT0() uint8 {
	return volatile.LoadUint8(&o.EPINTFLAG3.Reg) & 0x1
}
func (o *USB_DEVICE_Type) SetEPINTFLAG3_TRCPT1(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG3.Reg, volatile.LoadUint8(&o.EPINTFLAG3.Reg)&^(0x2)|value<<1)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG3_TRCPT1() uint8 {
	return (volatile.LoadUint8(&o.EPINTFLAG3.Reg) & 0x2) >> 1
}
func (o *USB_DEVICE_Type) SetEPINTFLAG3_TRFAIL0(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG3.Reg, volatile.LoadUint8(&o.EPINTFLAG3.Reg)&^(0x4)|value<<2)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG3_TRFAIL0() uint8 {
	return (volatile.LoadUint8(&o.EPINTFLAG3.Reg) & 0x4) >> 2
}
func (o *USB_DEVICE_Type) SetEPINTFLAG3_TRFAIL1(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG3.Reg, volatile.LoadUint8(&o.EPINTFLAG3.Reg)&^(0x8)|value<<3)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG3_TRFAIL1() uint8 {
	return (volatile.LoadUint8(&o.EPINTFLAG3.Reg) & 0x8) >> 3
}
func (o *USB_DEVICE_Type) SetEPINTFLAG3_RXSTP(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG3.Reg, volatile.LoadUint8(&o.EPINTFLAG3.Reg)&^(0x10)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG3_RXSTP() uint8 {
	return (volatile.LoadUint8(&o.EPINTFLAG3.Reg) & 0x10) >> 4
}
func (o *USB_DEVICE_Type) SetEPINTFLAG3_STALL0(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG3.Reg, volatile.LoadUint8(&o.EPINTFLAG3.Reg)&^(0x20)|value<<5)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG3_STALL0() uint8 {
	return (volatile.LoadUint8(&o.EPINTFLAG3.Reg) & 0x20) >> 5
}
func (o *USB_DEVICE_Type) SetEPINTFLAG3_STALL1(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG3.Reg, volatile.LoadUint8(&o.EPINTFLAG3.Reg)&^(0x40)|value<<6)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG3_STALL1() uint8 {
	return (volatile.LoadUint8(&o.EPINTFLAG3.Reg) & 0x40) >> 6
}

// USB_DEVICE.EPINTENCLR3: DEVICE End Point Interrupt Clear Flag
func (o *USB_DEVICE_Type) SetEPINTENCLR3_TRCPT0(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR3.Reg, volatile.LoadUint8(&o.EPINTENCLR3.Reg)&^(0x1)|value)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR3_TRCPT0() uint8 {
	return volatile.LoadUint8(&o.EPINTENCLR3.Reg) & 0x1
}
func (o *USB_DEVICE_Type) SetEPINTENCLR3_TRCPT1(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR3.Reg, volatile.LoadUint8(&o.EPINTENCLR3.Reg)&^(0x2)|value<<1)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR3_TRCPT1() uint8 {
	return (volatile.LoadUint8(&o.EPINTENCLR3.Reg) & 0x2) >> 1
}
func (o *USB_DEVICE_Type) SetEPINTENCLR3_TRFAIL0(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR3.Reg, volatile.LoadUint8(&o.EPINTENCLR3.Reg)&^(0x4)|value<<2)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR3_TRFAIL0() uint8 {
	return (volatile.LoadUint8(&o.EPINTENCLR3.Reg) & 0x4) >> 2
}
func (o *USB_DEVICE_Type) SetEPINTENCLR3_TRFAIL1(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR3.Reg, volatile.LoadUint8(&o.EPINTENCLR3.Reg)&^(0x8)|value<<3)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR3_TRFAIL1() uint8 {
	return (volatile.LoadUint8(&o.EPINTENCLR3.Reg) & 0x8) >> 3
}
func (o *USB_DEVICE_Type) SetEPINTENCLR3_RXSTP(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR3.Reg, volatile.LoadUint8(&o.EPINTENCLR3.Reg)&^(0x10)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR3_RXSTP() uint8 {
	return (volatile.LoadUint8(&o.EPINTENCLR3.Reg) & 0x10) >> 4
}
func (o *USB_DEVICE_Type) SetEPINTENCLR3_STALL0(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR3.Reg, volatile.LoadUint8(&o.EPINTENCLR3.Reg)&^(0x20)|value<<5)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR3_STALL0() uint8 {
	return (volatile.LoadUint8(&o.EPINTENCLR3.Reg) & 0x20) >> 5
}
func (o *USB_DEVICE_Type) SetEPINTENCLR3_STALL1(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR3.Reg, volatile.LoadUint8(&o.EPINTENCLR3.Reg)&^(0x40)|value<<6)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR3_STALL1() uint8 {
	return (volatile.LoadUint8(&o.EPINTENCLR3.Reg) & 0x40) >> 6
}

// USB_DEVICE.EPINTENSET3: DEVICE End Point Interrupt Set Flag
func (o *USB_DEVICE_Type) SetEPINTENSET3_TRCPT0(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET3.Reg, volatile.LoadUint8(&o.EPINTENSET3.Reg)&^(0x1)|value)
}
func (o *USB_DEVICE_Type) GetEPINTENSET3_TRCPT0() uint8 {
	return volatile.LoadUint8(&o.EPINTENSET3.Reg) & 0x1
}
func (o *USB_DEVICE_Type) SetEPINTENSET3_TRCPT1(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET3.Reg, volatile.LoadUint8(&o.EPINTENSET3.Reg)&^(0x2)|value<<1)
}
func (o *USB_DEVICE_Type) GetEPINTENSET3_TRCPT1() uint8 {
	return (volatile.LoadUint8(&o.EPINTENSET3.Reg) & 0x2) >> 1
}
func (o *USB_DEVICE_Type) SetEPINTENSET3_TRFAIL0(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET3.Reg, volatile.LoadUint8(&o.EPINTENSET3.Reg)&^(0x4)|value<<2)
}
func (o *USB_DEVICE_Type) GetEPINTENSET3_TRFAIL0() uint8 {
	return (volatile.LoadUint8(&o.EPINTENSET3.Reg) & 0x4) >> 2
}
func (o *USB_DEVICE_Type) SetEPINTENSET3_TRFAIL1(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET3.Reg, volatile.LoadUint8(&o.EPINTENSET3.Reg)&^(0x8)|value<<3)
}
func (o *USB_DEVICE_Type) GetEPINTENSET3_TRFAIL1() uint8 {
	return (volatile.LoadUint8(&o.EPINTENSET3.Reg) & 0x8) >> 3
}
func (o *USB_DEVICE_Type) SetEPINTENSET3_RXSTP(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET3.Reg, volatile.LoadUint8(&o.EPINTENSET3.Reg)&^(0x10)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPINTENSET3_RXSTP() uint8 {
	return (volatile.LoadUint8(&o.EPINTENSET3.Reg) & 0x10) >> 4
}
func (o *USB_DEVICE_Type) SetEPINTENSET3_STALL0(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET3.Reg, volatile.LoadUint8(&o.EPINTENSET3.Reg)&^(0x20)|value<<5)
}
func (o *USB_DEVICE_Type) GetEPINTENSET3_STALL0() uint8 {
	return (volatile.LoadUint8(&o.EPINTENSET3.Reg) & 0x20) >> 5
}
func (o *USB_DEVICE_Type) SetEPINTENSET3_STALL1(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET3.Reg, volatile.LoadUint8(&o.EPINTENSET3.Reg)&^(0x40)|value<<6)
}
func (o *USB_DEVICE_Type) GetEPINTENSET3_STALL1() uint8 {
	return (volatile.LoadUint8(&o.EPINTENSET3.Reg) & 0x40) >> 6
}

// USB_DEVICE.EPCFG4: DEVICE End Point Configuration
func (o *USB_DEVICE_Type) SetEPCFG4_EPTYPE0(value uint8) {
	volatile.StoreUint8(&o.EPCFG4.Reg, volatile.LoadUint8(&o.EPCFG4.Reg)&^(0x7)|value)
}
func (o *USB_DEVICE_Type) GetEPCFG4_EPTYPE0() uint8 {
	return volatile.LoadUint8(&o.EPCFG4.Reg) & 0x7
}
func (o *USB_DEVICE_Type) SetEPCFG4_EPTYPE1(value uint8) {
	volatile.StoreUint8(&o.EPCFG4.Reg, volatile.LoadUint8(&o.EPCFG4.Reg)&^(0x70)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPCFG4_EPTYPE1() uint8 {
	return (volatile.LoadUint8(&o.EPCFG4.Reg) & 0x70) >> 4
}
func (o *USB_DEVICE_Type) SetEPCFG4_NYETDIS(value uint8) {
	volatile.StoreUint8(&o.EPCFG4.Reg, volatile.LoadUint8(&o.EPCFG4.Reg)&^(0x80)|value<<7)
}
func (o *USB_DEVICE_Type) GetEPCFG4_NYETDIS() uint8 {
	return (volatile.LoadUint8(&o.EPCFG4.Reg) & 0x80) >> 7
}

// USB_DEVICE.EPSTATUSCLR4: DEVICE End Point Pipe Status Clear
func (o *USB_DEVICE_Type) SetEPSTATUSCLR4_DTGLOUT(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR4.Reg, volatile.LoadUint8(&o.EPSTATUSCLR4.Reg)&^(0x1)|value)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR4_DTGLOUT() uint8 {
	return volatile.LoadUint8(&o.EPSTATUSCLR4.Reg) & 0x1
}
func (o *USB_DEVICE_Type) SetEPSTATUSCLR4_DTGLIN(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR4.Reg, volatile.LoadUint8(&o.EPSTATUSCLR4.Reg)&^(0x2)|value<<1)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR4_DTGLIN() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSCLR4.Reg) & 0x2) >> 1
}
func (o *USB_DEVICE_Type) SetEPSTATUSCLR4_CURBK(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR4.Reg, volatile.LoadUint8(&o.EPSTATUSCLR4.Reg)&^(0x4)|value<<2)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR4_CURBK() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSCLR4.Reg) & 0x4) >> 2
}
func (o *USB_DEVICE_Type) SetEPSTATUSCLR4_STALLRQ0(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR4.Reg, volatile.LoadUint8(&o.EPSTATUSCLR4.Reg)&^(0x10)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR4_STALLRQ0() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSCLR4.Reg) & 0x10) >> 4
}
func (o *USB_DEVICE_Type) SetEPSTATUSCLR4_STALLRQ1(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR4.Reg, volatile.LoadUint8(&o.EPSTATUSCLR4.Reg)&^(0x20)|value<<5)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR4_STALLRQ1() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSCLR4.Reg) & 0x20) >> 5
}
func (o *USB_DEVICE_Type) SetEPSTATUSCLR4_BK0RDY(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR4.Reg, volatile.LoadUint8(&o.EPSTATUSCLR4.Reg)&^(0x40)|value<<6)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR4_BK0RDY() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSCLR4.Reg) & 0x40) >> 6
}
func (o *USB_DEVICE_Type) SetEPSTATUSCLR4_BK1RDY(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR4.Reg, volatile.LoadUint8(&o.EPSTATUSCLR4.Reg)&^(0x80)|value<<7)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR4_BK1RDY() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSCLR4.Reg) & 0x80) >> 7
}

// USB_DEVICE.EPSTATUSSET4: DEVICE End Point Pipe Status Set
func (o *USB_DEVICE_Type) SetEPSTATUSSET4_DTGLOUT(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET4.Reg, volatile.LoadUint8(&o.EPSTATUSSET4.Reg)&^(0x1)|value)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET4_DTGLOUT() uint8 {
	return volatile.LoadUint8(&o.EPSTATUSSET4.Reg) & 0x1
}
func (o *USB_DEVICE_Type) SetEPSTATUSSET4_DTGLIN(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET4.Reg, volatile.LoadUint8(&o.EPSTATUSSET4.Reg)&^(0x2)|value<<1)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET4_DTGLIN() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSSET4.Reg) & 0x2) >> 1
}
func (o *USB_DEVICE_Type) SetEPSTATUSSET4_CURBK(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET4.Reg, volatile.LoadUint8(&o.EPSTATUSSET4.Reg)&^(0x4)|value<<2)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET4_CURBK() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSSET4.Reg) & 0x4) >> 2
}
func (o *USB_DEVICE_Type) SetEPSTATUSSET4_STALLRQ0(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET4.Reg, volatile.LoadUint8(&o.EPSTATUSSET4.Reg)&^(0x10)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET4_STALLRQ0() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSSET4.Reg) & 0x10) >> 4
}
func (o *USB_DEVICE_Type) SetEPSTATUSSET4_STALLRQ1(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET4.Reg, volatile.LoadUint8(&o.EPSTATUSSET4.Reg)&^(0x20)|value<<5)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET4_STALLRQ1() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSSET4.Reg) & 0x20) >> 5
}
func (o *USB_DEVICE_Type) SetEPSTATUSSET4_BK0RDY(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET4.Reg, volatile.LoadUint8(&o.EPSTATUSSET4.Reg)&^(0x40)|value<<6)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET4_BK0RDY() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSSET4.Reg) & 0x40) >> 6
}
func (o *USB_DEVICE_Type) SetEPSTATUSSET4_BK1RDY(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET4.Reg, volatile.LoadUint8(&o.EPSTATUSSET4.Reg)&^(0x80)|value<<7)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET4_BK1RDY() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSSET4.Reg) & 0x80) >> 7
}

// USB_DEVICE.EPSTATUS4: DEVICE End Point Pipe Status
func (o *USB_DEVICE_Type) SetEPSTATUS4_DTGLOUT(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS4.Reg, volatile.LoadUint8(&o.EPSTATUS4.Reg)&^(0x1)|value)
}
func (o *USB_DEVICE_Type) GetEPSTATUS4_DTGLOUT() uint8 {
	return volatile.LoadUint8(&o.EPSTATUS4.Reg) & 0x1
}
func (o *USB_DEVICE_Type) SetEPSTATUS4_DTGLIN(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS4.Reg, volatile.LoadUint8(&o.EPSTATUS4.Reg)&^(0x2)|value<<1)
}
func (o *USB_DEVICE_Type) GetEPSTATUS4_DTGLIN() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUS4.Reg) & 0x2) >> 1
}
func (o *USB_DEVICE_Type) SetEPSTATUS4_CURBK(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS4.Reg, volatile.LoadUint8(&o.EPSTATUS4.Reg)&^(0x4)|value<<2)
}
func (o *USB_DEVICE_Type) GetEPSTATUS4_CURBK() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUS4.Reg) & 0x4) >> 2
}
func (o *USB_DEVICE_Type) SetEPSTATUS4_STALLRQ0(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS4.Reg, volatile.LoadUint8(&o.EPSTATUS4.Reg)&^(0x10)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPSTATUS4_STALLRQ0() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUS4.Reg) & 0x10) >> 4
}
func (o *USB_DEVICE_Type) SetEPSTATUS4_STALLRQ1(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS4.Reg, volatile.LoadUint8(&o.EPSTATUS4.Reg)&^(0x20)|value<<5)
}
func (o *USB_DEVICE_Type) GetEPSTATUS4_STALLRQ1() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUS4.Reg) & 0x20) >> 5
}
func (o *USB_DEVICE_Type) SetEPSTATUS4_BK0RDY(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS4.Reg, volatile.LoadUint8(&o.EPSTATUS4.Reg)&^(0x40)|value<<6)
}
func (o *USB_DEVICE_Type) GetEPSTATUS4_BK0RDY() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUS4.Reg) & 0x40) >> 6
}
func (o *USB_DEVICE_Type) SetEPSTATUS4_BK1RDY(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS4.Reg, volatile.LoadUint8(&o.EPSTATUS4.Reg)&^(0x80)|value<<7)
}
func (o *USB_DEVICE_Type) GetEPSTATUS4_BK1RDY() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUS4.Reg) & 0x80) >> 7
}

// USB_DEVICE.EPINTFLAG4: DEVICE End Point Interrupt Flag
func (o *USB_DEVICE_Type) SetEPINTFLAG4_TRCPT0(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG4.Reg, volatile.LoadUint8(&o.EPINTFLAG4.Reg)&^(0x1)|value)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG4_TRCPT0() uint8 {
	return volatile.LoadUint8(&o.EPINTFLAG4.Reg) & 0x1
}
func (o *USB_DEVICE_Type) SetEPINTFLAG4_TRCPT1(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG4.Reg, volatile.LoadUint8(&o.EPINTFLAG4.Reg)&^(0x2)|value<<1)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG4_TRCPT1() uint8 {
	return (volatile.LoadUint8(&o.EPINTFLAG4.Reg) & 0x2) >> 1
}
func (o *USB_DEVICE_Type) SetEPINTFLAG4_TRFAIL0(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG4.Reg, volatile.LoadUint8(&o.EPINTFLAG4.Reg)&^(0x4)|value<<2)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG4_TRFAIL0() uint8 {
	return (volatile.LoadUint8(&o.EPINTFLAG4.Reg) & 0x4) >> 2
}
func (o *USB_DEVICE_Type) SetEPINTFLAG4_TRFAIL1(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG4.Reg, volatile.LoadUint8(&o.EPINTFLAG4.Reg)&^(0x8)|value<<3)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG4_TRFAIL1() uint8 {
	return (volatile.LoadUint8(&o.EPINTFLAG4.Reg) & 0x8) >> 3
}
func (o *USB_DEVICE_Type) SetEPINTFLAG4_RXSTP(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG4.Reg, volatile.LoadUint8(&o.EPINTFLAG4.Reg)&^(0x10)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG4_RXSTP() uint8 {
	return (volatile.LoadUint8(&o.EPINTFLAG4.Reg) & 0x10) >> 4
}
func (o *USB_DEVICE_Type) SetEPINTFLAG4_STALL0(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG4.Reg, volatile.LoadUint8(&o.EPINTFLAG4.Reg)&^(0x20)|value<<5)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG4_STALL0() uint8 {
	return (volatile.LoadUint8(&o.EPINTFLAG4.Reg) & 0x20) >> 5
}
func (o *USB_DEVICE_Type) SetEPINTFLAG4_STALL1(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG4.Reg, volatile.LoadUint8(&o.EPINTFLAG4.Reg)&^(0x40)|value<<6)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG4_STALL1() uint8 {
	return (volatile.LoadUint8(&o.EPINTFLAG4.Reg) & 0x40) >> 6
}

// USB_DEVICE.EPINTENCLR4: DEVICE End Point Interrupt Clear Flag
func (o *USB_DEVICE_Type) SetEPINTENCLR4_TRCPT0(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR4.Reg, volatile.LoadUint8(&o.EPINTENCLR4.Reg)&^(0x1)|value)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR4_TRCPT0() uint8 {
	return volatile.LoadUint8(&o.EPINTENCLR4.Reg) & 0x1
}
func (o *USB_DEVICE_Type) SetEPINTENCLR4_TRCPT1(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR4.Reg, volatile.LoadUint8(&o.EPINTENCLR4.Reg)&^(0x2)|value<<1)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR4_TRCPT1() uint8 {
	return (volatile.LoadUint8(&o.EPINTENCLR4.Reg) & 0x2) >> 1
}
func (o *USB_DEVICE_Type) SetEPINTENCLR4_TRFAIL0(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR4.Reg, volatile.LoadUint8(&o.EPINTENCLR4.Reg)&^(0x4)|value<<2)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR4_TRFAIL0() uint8 {
	return (volatile.LoadUint8(&o.EPINTENCLR4.Reg) & 0x4) >> 2
}
func (o *USB_DEVICE_Type) SetEPINTENCLR4_TRFAIL1(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR4.Reg, volatile.LoadUint8(&o.EPINTENCLR4.Reg)&^(0x8)|value<<3)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR4_TRFAIL1() uint8 {
	return (volatile.LoadUint8(&o.EPINTENCLR4.Reg) & 0x8) >> 3
}
func (o *USB_DEVICE_Type) SetEPINTENCLR4_RXSTP(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR4.Reg, volatile.LoadUint8(&o.EPINTENCLR4.Reg)&^(0x10)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR4_RXSTP() uint8 {
	return (volatile.LoadUint8(&o.EPINTENCLR4.Reg) & 0x10) >> 4
}
func (o *USB_DEVICE_Type) SetEPINTENCLR4_STALL0(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR4.Reg, volatile.LoadUint8(&o.EPINTENCLR4.Reg)&^(0x20)|value<<5)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR4_STALL0() uint8 {
	return (volatile.LoadUint8(&o.EPINTENCLR4.Reg) & 0x20) >> 5
}
func (o *USB_DEVICE_Type) SetEPINTENCLR4_STALL1(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR4.Reg, volatile.LoadUint8(&o.EPINTENCLR4.Reg)&^(0x40)|value<<6)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR4_STALL1() uint8 {
	return (volatile.LoadUint8(&o.EPINTENCLR4.Reg) & 0x40) >> 6
}

// USB_DEVICE.EPINTENSET4: DEVICE End Point Interrupt Set Flag
func (o *USB_DEVICE_Type) SetEPINTENSET4_TRCPT0(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET4.Reg, volatile.LoadUint8(&o.EPINTENSET4.Reg)&^(0x1)|value)
}
func (o *USB_DEVICE_Type) GetEPINTENSET4_TRCPT0() uint8 {
	return volatile.LoadUint8(&o.EPINTENSET4.Reg) & 0x1
}
func (o *USB_DEVICE_Type) SetEPINTENSET4_TRCPT1(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET4.Reg, volatile.LoadUint8(&o.EPINTENSET4.Reg)&^(0x2)|value<<1)
}
func (o *USB_DEVICE_Type) GetEPINTENSET4_TRCPT1() uint8 {
	return (volatile.LoadUint8(&o.EPINTENSET4.Reg) & 0x2) >> 1
}
func (o *USB_DEVICE_Type) SetEPINTENSET4_TRFAIL0(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET4.Reg, volatile.LoadUint8(&o.EPINTENSET4.Reg)&^(0x4)|value<<2)
}
func (o *USB_DEVICE_Type) GetEPINTENSET4_TRFAIL0() uint8 {
	return (volatile.LoadUint8(&o.EPINTENSET4.Reg) & 0x4) >> 2
}
func (o *USB_DEVICE_Type) SetEPINTENSET4_TRFAIL1(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET4.Reg, volatile.LoadUint8(&o.EPINTENSET4.Reg)&^(0x8)|value<<3)
}
func (o *USB_DEVICE_Type) GetEPINTENSET4_TRFAIL1() uint8 {
	return (volatile.LoadUint8(&o.EPINTENSET4.Reg) & 0x8) >> 3
}
func (o *USB_DEVICE_Type) SetEPINTENSET4_RXSTP(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET4.Reg, volatile.LoadUint8(&o.EPINTENSET4.Reg)&^(0x10)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPINTENSET4_RXSTP() uint8 {
	return (volatile.LoadUint8(&o.EPINTENSET4.Reg) & 0x10) >> 4
}
func (o *USB_DEVICE_Type) SetEPINTENSET4_STALL0(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET4.Reg, volatile.LoadUint8(&o.EPINTENSET4.Reg)&^(0x20)|value<<5)
}
func (o *USB_DEVICE_Type) GetEPINTENSET4_STALL0() uint8 {
	return (volatile.LoadUint8(&o.EPINTENSET4.Reg) & 0x20) >> 5
}
func (o *USB_DEVICE_Type) SetEPINTENSET4_STALL1(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET4.Reg, volatile.LoadUint8(&o.EPINTENSET4.Reg)&^(0x40)|value<<6)
}
func (o *USB_DEVICE_Type) GetEPINTENSET4_STALL1() uint8 {
	return (volatile.LoadUint8(&o.EPINTENSET4.Reg) & 0x40) >> 6
}

// USB_DEVICE.EPCFG5: DEVICE End Point Configuration
func (o *USB_DEVICE_Type) SetEPCFG5_EPTYPE0(value uint8) {
	volatile.StoreUint8(&o.EPCFG5.Reg, volatile.LoadUint8(&o.EPCFG5.Reg)&^(0x7)|value)
}
func (o *USB_DEVICE_Type) GetEPCFG5_EPTYPE0() uint8 {
	return volatile.LoadUint8(&o.EPCFG5.Reg) & 0x7
}
func (o *USB_DEVICE_Type) SetEPCFG5_EPTYPE1(value uint8) {
	volatile.StoreUint8(&o.EPCFG5.Reg, volatile.LoadUint8(&o.EPCFG5.Reg)&^(0x70)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPCFG5_EPTYPE1() uint8 {
	return (volatile.LoadUint8(&o.EPCFG5.Reg) & 0x70) >> 4
}
func (o *USB_DEVICE_Type) SetEPCFG5_NYETDIS(value uint8) {
	volatile.StoreUint8(&o.EPCFG5.Reg, volatile.LoadUint8(&o.EPCFG5.Reg)&^(0x80)|value<<7)
}
func (o *USB_DEVICE_Type) GetEPCFG5_NYETDIS() uint8 {
	return (volatile.LoadUint8(&o.EPCFG5.Reg) & 0x80) >> 7
}

// USB_DEVICE.EPSTATUSCLR5: DEVICE End Point Pipe Status Clear
func (o *USB_DEVICE_Type) SetEPSTATUSCLR5_DTGLOUT(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR5.Reg, volatile.LoadUint8(&o.EPSTATUSCLR5.Reg)&^(0x1)|value)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR5_DTGLOUT() uint8 {
	return volatile.LoadUint8(&o.EPSTATUSCLR5.Reg) & 0x1
}
func (o *USB_DEVICE_Type) SetEPSTATUSCLR5_DTGLIN(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR5.Reg, volatile.LoadUint8(&o.EPSTATUSCLR5.Reg)&^(0x2)|value<<1)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR5_DTGLIN() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSCLR5.Reg) & 0x2) >> 1
}
func (o *USB_DEVICE_Type) SetEPSTATUSCLR5_CURBK(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR5.Reg, volatile.LoadUint8(&o.EPSTATUSCLR5.Reg)&^(0x4)|value<<2)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR5_CURBK() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSCLR5.Reg) & 0x4) >> 2
}
func (o *USB_DEVICE_Type) SetEPSTATUSCLR5_STALLRQ0(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR5.Reg, volatile.LoadUint8(&o.EPSTATUSCLR5.Reg)&^(0x10)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR5_STALLRQ0() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSCLR5.Reg) & 0x10) >> 4
}
func (o *USB_DEVICE_Type) SetEPSTATUSCLR5_STALLRQ1(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR5.Reg, volatile.LoadUint8(&o.EPSTATUSCLR5.Reg)&^(0x20)|value<<5)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR5_STALLRQ1() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSCLR5.Reg) & 0x20) >> 5
}
func (o *USB_DEVICE_Type) SetEPSTATUSCLR5_BK0RDY(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR5.Reg, volatile.LoadUint8(&o.EPSTATUSCLR5.Reg)&^(0x40)|value<<6)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR5_BK0RDY() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSCLR5.Reg) & 0x40) >> 6
}
func (o *USB_DEVICE_Type) SetEPSTATUSCLR5_BK1RDY(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR5.Reg, volatile.LoadUint8(&o.EPSTATUSCLR5.Reg)&^(0x80)|value<<7)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR5_BK1RDY() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSCLR5.Reg) & 0x80) >> 7
}

// USB_DEVICE.EPSTATUSSET5: DEVICE End Point Pipe Status Set
func (o *USB_DEVICE_Type) SetEPSTATUSSET5_DTGLOUT(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET5.Reg, volatile.LoadUint8(&o.EPSTATUSSET5.Reg)&^(0x1)|value)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET5_DTGLOUT() uint8 {
	return volatile.LoadUint8(&o.EPSTATUSSET5.Reg) & 0x1
}
func (o *USB_DEVICE_Type) SetEPSTATUSSET5_DTGLIN(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET5.Reg, volatile.LoadUint8(&o.EPSTATUSSET5.Reg)&^(0x2)|value<<1)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET5_DTGLIN() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSSET5.Reg) & 0x2) >> 1
}
func (o *USB_DEVICE_Type) SetEPSTATUSSET5_CURBK(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET5.Reg, volatile.LoadUint8(&o.EPSTATUSSET5.Reg)&^(0x4)|value<<2)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET5_CURBK() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSSET5.Reg) & 0x4) >> 2
}
func (o *USB_DEVICE_Type) SetEPSTATUSSET5_STALLRQ0(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET5.Reg, volatile.LoadUint8(&o.EPSTATUSSET5.Reg)&^(0x10)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET5_STALLRQ0() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSSET5.Reg) & 0x10) >> 4
}
func (o *USB_DEVICE_Type) SetEPSTATUSSET5_STALLRQ1(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET5.Reg, volatile.LoadUint8(&o.EPSTATUSSET5.Reg)&^(0x20)|value<<5)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET5_STALLRQ1() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSSET5.Reg) & 0x20) >> 5
}
func (o *USB_DEVICE_Type) SetEPSTATUSSET5_BK0RDY(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET5.Reg, volatile.LoadUint8(&o.EPSTATUSSET5.Reg)&^(0x40)|value<<6)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET5_BK0RDY() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSSET5.Reg) & 0x40) >> 6
}
func (o *USB_DEVICE_Type) SetEPSTATUSSET5_BK1RDY(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET5.Reg, volatile.LoadUint8(&o.EPSTATUSSET5.Reg)&^(0x80)|value<<7)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET5_BK1RDY() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSSET5.Reg) & 0x80) >> 7
}

// USB_DEVICE.EPSTATUS5: DEVICE End Point Pipe Status
func (o *USB_DEVICE_Type) SetEPSTATUS5_DTGLOUT(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS5.Reg, volatile.LoadUint8(&o.EPSTATUS5.Reg)&^(0x1)|value)
}
func (o *USB_DEVICE_Type) GetEPSTATUS5_DTGLOUT() uint8 {
	return volatile.LoadUint8(&o.EPSTATUS5.Reg) & 0x1
}
func (o *USB_DEVICE_Type) SetEPSTATUS5_DTGLIN(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS5.Reg, volatile.LoadUint8(&o.EPSTATUS5.Reg)&^(0x2)|value<<1)
}
func (o *USB_DEVICE_Type) GetEPSTATUS5_DTGLIN() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUS5.Reg) & 0x2) >> 1
}
func (o *USB_DEVICE_Type) SetEPSTATUS5_CURBK(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS5.Reg, volatile.LoadUint8(&o.EPSTATUS5.Reg)&^(0x4)|value<<2)
}
func (o *USB_DEVICE_Type) GetEPSTATUS5_CURBK() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUS5.Reg) & 0x4) >> 2
}
func (o *USB_DEVICE_Type) SetEPSTATUS5_STALLRQ0(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS5.Reg, volatile.LoadUint8(&o.EPSTATUS5.Reg)&^(0x10)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPSTATUS5_STALLRQ0() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUS5.Reg) & 0x10) >> 4
}
func (o *USB_DEVICE_Type) SetEPSTATUS5_STALLRQ1(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS5.Reg, volatile.LoadUint8(&o.EPSTATUS5.Reg)&^(0x20)|value<<5)
}
func (o *USB_DEVICE_Type) GetEPSTATUS5_STALLRQ1() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUS5.Reg) & 0x20) >> 5
}
func (o *USB_DEVICE_Type) SetEPSTATUS5_BK0RDY(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS5.Reg, volatile.LoadUint8(&o.EPSTATUS5.Reg)&^(0x40)|value<<6)
}
func (o *USB_DEVICE_Type) GetEPSTATUS5_BK0RDY() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUS5.Reg) & 0x40) >> 6
}
func (o *USB_DEVICE_Type) SetEPSTATUS5_BK1RDY(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS5.Reg, volatile.LoadUint8(&o.EPSTATUS5.Reg)&^(0x80)|value<<7)
}
func (o *USB_DEVICE_Type) GetEPSTATUS5_BK1RDY() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUS5.Reg) & 0x80) >> 7
}

// USB_DEVICE.EPINTFLAG5: DEVICE End Point Interrupt Flag
func (o *USB_DEVICE_Type) SetEPINTFLAG5_TRCPT0(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG5.Reg, volatile.LoadUint8(&o.EPINTFLAG5.Reg)&^(0x1)|value)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG5_TRCPT0() uint8 {
	return volatile.LoadUint8(&o.EPINTFLAG5.Reg) & 0x1
}
func (o *USB_DEVICE_Type) SetEPINTFLAG5_TRCPT1(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG5.Reg, volatile.LoadUint8(&o.EPINTFLAG5.Reg)&^(0x2)|value<<1)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG5_TRCPT1() uint8 {
	return (volatile.LoadUint8(&o.EPINTFLAG5.Reg) & 0x2) >> 1
}
func (o *USB_DEVICE_Type) SetEPINTFLAG5_TRFAIL0(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG5.Reg, volatile.LoadUint8(&o.EPINTFLAG5.Reg)&^(0x4)|value<<2)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG5_TRFAIL0() uint8 {
	return (volatile.LoadUint8(&o.EPINTFLAG5.Reg) & 0x4) >> 2
}
func (o *USB_DEVICE_Type) SetEPINTFLAG5_TRFAIL1(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG5.Reg, volatile.LoadUint8(&o.EPINTFLAG5.Reg)&^(0x8)|value<<3)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG5_TRFAIL1() uint8 {
	return (volatile.LoadUint8(&o.EPINTFLAG5.Reg) & 0x8) >> 3
}
func (o *USB_DEVICE_Type) SetEPINTFLAG5_RXSTP(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG5.Reg, volatile.LoadUint8(&o.EPINTFLAG5.Reg)&^(0x10)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG5_RXSTP() uint8 {
	return (volatile.LoadUint8(&o.EPINTFLAG5.Reg) & 0x10) >> 4
}
func (o *USB_DEVICE_Type) SetEPINTFLAG5_STALL0(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG5.Reg, volatile.LoadUint8(&o.EPINTFLAG5.Reg)&^(0x20)|value<<5)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG5_STALL0() uint8 {
	return (volatile.LoadUint8(&o.EPINTFLAG5.Reg) & 0x20) >> 5
}
func (o *USB_DEVICE_Type) SetEPINTFLAG5_STALL1(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG5.Reg, volatile.LoadUint8(&o.EPINTFLAG5.Reg)&^(0x40)|value<<6)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG5_STALL1() uint8 {
	return (volatile.LoadUint8(&o.EPINTFLAG5.Reg) & 0x40) >> 6
}

// USB_DEVICE.EPINTENCLR5: DEVICE End Point Interrupt Clear Flag
func (o *USB_DEVICE_Type) SetEPINTENCLR5_TRCPT0(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR5.Reg, volatile.LoadUint8(&o.EPINTENCLR5.Reg)&^(0x1)|value)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR5_TRCPT0() uint8 {
	return volatile.LoadUint8(&o.EPINTENCLR5.Reg) & 0x1
}
func (o *USB_DEVICE_Type) SetEPINTENCLR5_TRCPT1(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR5.Reg, volatile.LoadUint8(&o.EPINTENCLR5.Reg)&^(0x2)|value<<1)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR5_TRCPT1() uint8 {
	return (volatile.LoadUint8(&o.EPINTENCLR5.Reg) & 0x2) >> 1
}
func (o *USB_DEVICE_Type) SetEPINTENCLR5_TRFAIL0(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR5.Reg, volatile.LoadUint8(&o.EPINTENCLR5.Reg)&^(0x4)|value<<2)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR5_TRFAIL0() uint8 {
	return (volatile.LoadUint8(&o.EPINTENCLR5.Reg) & 0x4) >> 2
}
func (o *USB_DEVICE_Type) SetEPINTENCLR5_TRFAIL1(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR5.Reg, volatile.LoadUint8(&o.EPINTENCLR5.Reg)&^(0x8)|value<<3)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR5_TRFAIL1() uint8 {
	return (volatile.LoadUint8(&o.EPINTENCLR5.Reg) & 0x8) >> 3
}
func (o *USB_DEVICE_Type) SetEPINTENCLR5_RXSTP(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR5.Reg, volatile.LoadUint8(&o.EPINTENCLR5.Reg)&^(0x10)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR5_RXSTP() uint8 {
	return (volatile.LoadUint8(&o.EPINTENCLR5.Reg) & 0x10) >> 4
}
func (o *USB_DEVICE_Type) SetEPINTENCLR5_STALL0(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR5.Reg, volatile.LoadUint8(&o.EPINTENCLR5.Reg)&^(0x20)|value<<5)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR5_STALL0() uint8 {
	return (volatile.LoadUint8(&o.EPINTENCLR5.Reg) & 0x20) >> 5
}
func (o *USB_DEVICE_Type) SetEPINTENCLR5_STALL1(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR5.Reg, volatile.LoadUint8(&o.EPINTENCLR5.Reg)&^(0x40)|value<<6)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR5_STALL1() uint8 {
	return (volatile.LoadUint8(&o.EPINTENCLR5.Reg) & 0x40) >> 6
}

// USB_DEVICE.EPINTENSET5: DEVICE End Point Interrupt Set Flag
func (o *USB_DEVICE_Type) SetEPINTENSET5_TRCPT0(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET5.Reg, volatile.LoadUint8(&o.EPINTENSET5.Reg)&^(0x1)|value)
}
func (o *USB_DEVICE_Type) GetEPINTENSET5_TRCPT0() uint8 {
	return volatile.LoadUint8(&o.EPINTENSET5.Reg) & 0x1
}
func (o *USB_DEVICE_Type) SetEPINTENSET5_TRCPT1(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET5.Reg, volatile.LoadUint8(&o.EPINTENSET5.Reg)&^(0x2)|value<<1)
}
func (o *USB_DEVICE_Type) GetEPINTENSET5_TRCPT1() uint8 {
	return (volatile.LoadUint8(&o.EPINTENSET5.Reg) & 0x2) >> 1
}
func (o *USB_DEVICE_Type) SetEPINTENSET5_TRFAIL0(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET5.Reg, volatile.LoadUint8(&o.EPINTENSET5.Reg)&^(0x4)|value<<2)
}
func (o *USB_DEVICE_Type) GetEPINTENSET5_TRFAIL0() uint8 {
	return (volatile.LoadUint8(&o.EPINTENSET5.Reg) & 0x4) >> 2
}
func (o *USB_DEVICE_Type) SetEPINTENSET5_TRFAIL1(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET5.Reg, volatile.LoadUint8(&o.EPINTENSET5.Reg)&^(0x8)|value<<3)
}
func (o *USB_DEVICE_Type) GetEPINTENSET5_TRFAIL1() uint8 {
	return (volatile.LoadUint8(&o.EPINTENSET5.Reg) & 0x8) >> 3
}
func (o *USB_DEVICE_Type) SetEPINTENSET5_RXSTP(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET5.Reg, volatile.LoadUint8(&o.EPINTENSET5.Reg)&^(0x10)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPINTENSET5_RXSTP() uint8 {
	return (volatile.LoadUint8(&o.EPINTENSET5.Reg) & 0x10) >> 4
}
func (o *USB_DEVICE_Type) SetEPINTENSET5_STALL0(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET5.Reg, volatile.LoadUint8(&o.EPINTENSET5.Reg)&^(0x20)|value<<5)
}
func (o *USB_DEVICE_Type) GetEPINTENSET5_STALL0() uint8 {
	return (volatile.LoadUint8(&o.EPINTENSET5.Reg) & 0x20) >> 5
}
func (o *USB_DEVICE_Type) SetEPINTENSET5_STALL1(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET5.Reg, volatile.LoadUint8(&o.EPINTENSET5.Reg)&^(0x40)|value<<6)
}
func (o *USB_DEVICE_Type) GetEPINTENSET5_STALL1() uint8 {
	return (volatile.LoadUint8(&o.EPINTENSET5.Reg) & 0x40) >> 6
}

// USB_DEVICE.EPCFG6: DEVICE End Point Configuration
func (o *USB_DEVICE_Type) SetEPCFG6_EPTYPE0(value uint8) {
	volatile.StoreUint8(&o.EPCFG6.Reg, volatile.LoadUint8(&o.EPCFG6.Reg)&^(0x7)|value)
}
func (o *USB_DEVICE_Type) GetEPCFG6_EPTYPE0() uint8 {
	return volatile.LoadUint8(&o.EPCFG6.Reg) & 0x7
}
func (o *USB_DEVICE_Type) SetEPCFG6_EPTYPE1(value uint8) {
	volatile.StoreUint8(&o.EPCFG6.Reg, volatile.LoadUint8(&o.EPCFG6.Reg)&^(0x70)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPCFG6_EPTYPE1() uint8 {
	return (volatile.LoadUint8(&o.EPCFG6.Reg) & 0x70) >> 4
}
func (o *USB_DEVICE_Type) SetEPCFG6_NYETDIS(value uint8) {
	volatile.StoreUint8(&o.EPCFG6.Reg, volatile.LoadUint8(&o.EPCFG6.Reg)&^(0x80)|value<<7)
}
func (o *USB_DEVICE_Type) GetEPCFG6_NYETDIS() uint8 {
	return (volatile.LoadUint8(&o.EPCFG6.Reg) & 0x80) >> 7
}

// USB_DEVICE.EPSTATUSCLR6: DEVICE End Point Pipe Status Clear
func (o *USB_DEVICE_Type) SetEPSTATUSCLR6_DTGLOUT(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR6.Reg, volatile.LoadUint8(&o.EPSTATUSCLR6.Reg)&^(0x1)|value)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR6_DTGLOUT() uint8 {
	return volatile.LoadUint8(&o.EPSTATUSCLR6.Reg) & 0x1
}
func (o *USB_DEVICE_Type) SetEPSTATUSCLR6_DTGLIN(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR6.Reg, volatile.LoadUint8(&o.EPSTATUSCLR6.Reg)&^(0x2)|value<<1)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR6_DTGLIN() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSCLR6.Reg) & 0x2) >> 1
}
func (o *USB_DEVICE_Type) SetEPSTATUSCLR6_CURBK(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR6.Reg, volatile.LoadUint8(&o.EPSTATUSCLR6.Reg)&^(0x4)|value<<2)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR6_CURBK() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSCLR6.Reg) & 0x4) >> 2
}
func (o *USB_DEVICE_Type) SetEPSTATUSCLR6_STALLRQ0(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR6.Reg, volatile.LoadUint8(&o.EPSTATUSCLR6.Reg)&^(0x10)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR6_STALLRQ0() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSCLR6.Reg) & 0x10) >> 4
}
func (o *USB_DEVICE_Type) SetEPSTATUSCLR6_STALLRQ1(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR6.Reg, volatile.LoadUint8(&o.EPSTATUSCLR6.Reg)&^(0x20)|value<<5)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR6_STALLRQ1() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSCLR6.Reg) & 0x20) >> 5
}
func (o *USB_DEVICE_Type) SetEPSTATUSCLR6_BK0RDY(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR6.Reg, volatile.LoadUint8(&o.EPSTATUSCLR6.Reg)&^(0x40)|value<<6)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR6_BK0RDY() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSCLR6.Reg) & 0x40) >> 6
}
func (o *USB_DEVICE_Type) SetEPSTATUSCLR6_BK1RDY(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR6.Reg, volatile.LoadUint8(&o.EPSTATUSCLR6.Reg)&^(0x80)|value<<7)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR6_BK1RDY() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSCLR6.Reg) & 0x80) >> 7
}

// USB_DEVICE.EPSTATUSSET6: DEVICE End Point Pipe Status Set
func (o *USB_DEVICE_Type) SetEPSTATUSSET6_DTGLOUT(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET6.Reg, volatile.LoadUint8(&o.EPSTATUSSET6.Reg)&^(0x1)|value)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET6_DTGLOUT() uint8 {
	return volatile.LoadUint8(&o.EPSTATUSSET6.Reg) & 0x1
}
func (o *USB_DEVICE_Type) SetEPSTATUSSET6_DTGLIN(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET6.Reg, volatile.LoadUint8(&o.EPSTATUSSET6.Reg)&^(0x2)|value<<1)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET6_DTGLIN() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSSET6.Reg) & 0x2) >> 1
}
func (o *USB_DEVICE_Type) SetEPSTATUSSET6_CURBK(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET6.Reg, volatile.LoadUint8(&o.EPSTATUSSET6.Reg)&^(0x4)|value<<2)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET6_CURBK() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSSET6.Reg) & 0x4) >> 2
}
func (o *USB_DEVICE_Type) SetEPSTATUSSET6_STALLRQ0(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET6.Reg, volatile.LoadUint8(&o.EPSTATUSSET6.Reg)&^(0x10)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET6_STALLRQ0() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSSET6.Reg) & 0x10) >> 4
}
func (o *USB_DEVICE_Type) SetEPSTATUSSET6_STALLRQ1(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET6.Reg, volatile.LoadUint8(&o.EPSTATUSSET6.Reg)&^(0x20)|value<<5)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET6_STALLRQ1() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSSET6.Reg) & 0x20) >> 5
}
func (o *USB_DEVICE_Type) SetEPSTATUSSET6_BK0RDY(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET6.Reg, volatile.LoadUint8(&o.EPSTATUSSET6.Reg)&^(0x40)|value<<6)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET6_BK0RDY() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSSET6.Reg) & 0x40) >> 6
}
func (o *USB_DEVICE_Type) SetEPSTATUSSET6_BK1RDY(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET6.Reg, volatile.LoadUint8(&o.EPSTATUSSET6.Reg)&^(0x80)|value<<7)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET6_BK1RDY() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSSET6.Reg) & 0x80) >> 7
}

// USB_DEVICE.EPSTATUS6: DEVICE End Point Pipe Status
func (o *USB_DEVICE_Type) SetEPSTATUS6_DTGLOUT(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS6.Reg, volatile.LoadUint8(&o.EPSTATUS6.Reg)&^(0x1)|value)
}
func (o *USB_DEVICE_Type) GetEPSTATUS6_DTGLOUT() uint8 {
	return volatile.LoadUint8(&o.EPSTATUS6.Reg) & 0x1
}
func (o *USB_DEVICE_Type) SetEPSTATUS6_DTGLIN(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS6.Reg, volatile.LoadUint8(&o.EPSTATUS6.Reg)&^(0x2)|value<<1)
}
func (o *USB_DEVICE_Type) GetEPSTATUS6_DTGLIN() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUS6.Reg) & 0x2) >> 1
}
func (o *USB_DEVICE_Type) SetEPSTATUS6_CURBK(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS6.Reg, volatile.LoadUint8(&o.EPSTATUS6.Reg)&^(0x4)|value<<2)
}
func (o *USB_DEVICE_Type) GetEPSTATUS6_CURBK() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUS6.Reg) & 0x4) >> 2
}
func (o *USB_DEVICE_Type) SetEPSTATUS6_STALLRQ0(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS6.Reg, volatile.LoadUint8(&o.EPSTATUS6.Reg)&^(0x10)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPSTATUS6_STALLRQ0() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUS6.Reg) & 0x10) >> 4
}
func (o *USB_DEVICE_Type) SetEPSTATUS6_STALLRQ1(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS6.Reg, volatile.LoadUint8(&o.EPSTATUS6.Reg)&^(0x20)|value<<5)
}
func (o *USB_DEVICE_Type) GetEPSTATUS6_STALLRQ1() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUS6.Reg) & 0x20) >> 5
}
func (o *USB_DEVICE_Type) SetEPSTATUS6_BK0RDY(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS6.Reg, volatile.LoadUint8(&o.EPSTATUS6.Reg)&^(0x40)|value<<6)
}
func (o *USB_DEVICE_Type) GetEPSTATUS6_BK0RDY() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUS6.Reg) & 0x40) >> 6
}
func (o *USB_DEVICE_Type) SetEPSTATUS6_BK1RDY(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS6.Reg, volatile.LoadUint8(&o.EPSTATUS6.Reg)&^(0x80)|value<<7)
}
func (o *USB_DEVICE_Type) GetEPSTATUS6_BK1RDY() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUS6.Reg) & 0x80) >> 7
}

// USB_DEVICE.EPINTFLAG6: DEVICE End Point Interrupt Flag
func (o *USB_DEVICE_Type) SetEPINTFLAG6_TRCPT0(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG6.Reg, volatile.LoadUint8(&o.EPINTFLAG6.Reg)&^(0x1)|value)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG6_TRCPT0() uint8 {
	return volatile.LoadUint8(&o.EPINTFLAG6.Reg) & 0x1
}
func (o *USB_DEVICE_Type) SetEPINTFLAG6_TRCPT1(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG6.Reg, volatile.LoadUint8(&o.EPINTFLAG6.Reg)&^(0x2)|value<<1)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG6_TRCPT1() uint8 {
	return (volatile.LoadUint8(&o.EPINTFLAG6.Reg) & 0x2) >> 1
}
func (o *USB_DEVICE_Type) SetEPINTFLAG6_TRFAIL0(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG6.Reg, volatile.LoadUint8(&o.EPINTFLAG6.Reg)&^(0x4)|value<<2)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG6_TRFAIL0() uint8 {
	return (volatile.LoadUint8(&o.EPINTFLAG6.Reg) & 0x4) >> 2
}
func (o *USB_DEVICE_Type) SetEPINTFLAG6_TRFAIL1(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG6.Reg, volatile.LoadUint8(&o.EPINTFLAG6.Reg)&^(0x8)|value<<3)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG6_TRFAIL1() uint8 {
	return (volatile.LoadUint8(&o.EPINTFLAG6.Reg) & 0x8) >> 3
}
func (o *USB_DEVICE_Type) SetEPINTFLAG6_RXSTP(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG6.Reg, volatile.LoadUint8(&o.EPINTFLAG6.Reg)&^(0x10)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG6_RXSTP() uint8 {
	return (volatile.LoadUint8(&o.EPINTFLAG6.Reg) & 0x10) >> 4
}
func (o *USB_DEVICE_Type) SetEPINTFLAG6_STALL0(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG6.Reg, volatile.LoadUint8(&o.EPINTFLAG6.Reg)&^(0x20)|value<<5)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG6_STALL0() uint8 {
	return (volatile.LoadUint8(&o.EPINTFLAG6.Reg) & 0x20) >> 5
}
func (o *USB_DEVICE_Type) SetEPINTFLAG6_STALL1(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG6.Reg, volatile.LoadUint8(&o.EPINTFLAG6.Reg)&^(0x40)|value<<6)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG6_STALL1() uint8 {
	return (volatile.LoadUint8(&o.EPINTFLAG6.Reg) & 0x40) >> 6
}

// USB_DEVICE.EPINTENCLR6: DEVICE End Point Interrupt Clear Flag
func (o *USB_DEVICE_Type) SetEPINTENCLR6_TRCPT0(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR6.Reg, volatile.LoadUint8(&o.EPINTENCLR6.Reg)&^(0x1)|value)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR6_TRCPT0() uint8 {
	return volatile.LoadUint8(&o.EPINTENCLR6.Reg) & 0x1
}
func (o *USB_DEVICE_Type) SetEPINTENCLR6_TRCPT1(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR6.Reg, volatile.LoadUint8(&o.EPINTENCLR6.Reg)&^(0x2)|value<<1)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR6_TRCPT1() uint8 {
	return (volatile.LoadUint8(&o.EPINTENCLR6.Reg) & 0x2) >> 1
}
func (o *USB_DEVICE_Type) SetEPINTENCLR6_TRFAIL0(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR6.Reg, volatile.LoadUint8(&o.EPINTENCLR6.Reg)&^(0x4)|value<<2)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR6_TRFAIL0() uint8 {
	return (volatile.LoadUint8(&o.EPINTENCLR6.Reg) & 0x4) >> 2
}
func (o *USB_DEVICE_Type) SetEPINTENCLR6_TRFAIL1(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR6.Reg, volatile.LoadUint8(&o.EPINTENCLR6.Reg)&^(0x8)|value<<3)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR6_TRFAIL1() uint8 {
	return (volatile.LoadUint8(&o.EPINTENCLR6.Reg) & 0x8) >> 3
}
func (o *USB_DEVICE_Type) SetEPINTENCLR6_RXSTP(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR6.Reg, volatile.LoadUint8(&o.EPINTENCLR6.Reg)&^(0x10)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR6_RXSTP() uint8 {
	return (volatile.LoadUint8(&o.EPINTENCLR6.Reg) & 0x10) >> 4
}
func (o *USB_DEVICE_Type) SetEPINTENCLR6_STALL0(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR6.Reg, volatile.LoadUint8(&o.EPINTENCLR6.Reg)&^(0x20)|value<<5)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR6_STALL0() uint8 {
	return (volatile.LoadUint8(&o.EPINTENCLR6.Reg) & 0x20) >> 5
}
func (o *USB_DEVICE_Type) SetEPINTENCLR6_STALL1(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR6.Reg, volatile.LoadUint8(&o.EPINTENCLR6.Reg)&^(0x40)|value<<6)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR6_STALL1() uint8 {
	return (volatile.LoadUint8(&o.EPINTENCLR6.Reg) & 0x40) >> 6
}

// USB_DEVICE.EPINTENSET6: DEVICE End Point Interrupt Set Flag
func (o *USB_DEVICE_Type) SetEPINTENSET6_TRCPT0(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET6.Reg, volatile.LoadUint8(&o.EPINTENSET6.Reg)&^(0x1)|value)
}
func (o *USB_DEVICE_Type) GetEPINTENSET6_TRCPT0() uint8 {
	return volatile.LoadUint8(&o.EPINTENSET6.Reg) & 0x1
}
func (o *USB_DEVICE_Type) SetEPINTENSET6_TRCPT1(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET6.Reg, volatile.LoadUint8(&o.EPINTENSET6.Reg)&^(0x2)|value<<1)
}
func (o *USB_DEVICE_Type) GetEPINTENSET6_TRCPT1() uint8 {
	return (volatile.LoadUint8(&o.EPINTENSET6.Reg) & 0x2) >> 1
}
func (o *USB_DEVICE_Type) SetEPINTENSET6_TRFAIL0(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET6.Reg, volatile.LoadUint8(&o.EPINTENSET6.Reg)&^(0x4)|value<<2)
}
func (o *USB_DEVICE_Type) GetEPINTENSET6_TRFAIL0() uint8 {
	return (volatile.LoadUint8(&o.EPINTENSET6.Reg) & 0x4) >> 2
}
func (o *USB_DEVICE_Type) SetEPINTENSET6_TRFAIL1(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET6.Reg, volatile.LoadUint8(&o.EPINTENSET6.Reg)&^(0x8)|value<<3)
}
func (o *USB_DEVICE_Type) GetEPINTENSET6_TRFAIL1() uint8 {
	return (volatile.LoadUint8(&o.EPINTENSET6.Reg) & 0x8) >> 3
}
func (o *USB_DEVICE_Type) SetEPINTENSET6_RXSTP(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET6.Reg, volatile.LoadUint8(&o.EPINTENSET6.Reg)&^(0x10)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPINTENSET6_RXSTP() uint8 {
	return (volatile.LoadUint8(&o.EPINTENSET6.Reg) & 0x10) >> 4
}
func (o *USB_DEVICE_Type) SetEPINTENSET6_STALL0(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET6.Reg, volatile.LoadUint8(&o.EPINTENSET6.Reg)&^(0x20)|value<<5)
}
func (o *USB_DEVICE_Type) GetEPINTENSET6_STALL0() uint8 {
	return (volatile.LoadUint8(&o.EPINTENSET6.Reg) & 0x20) >> 5
}
func (o *USB_DEVICE_Type) SetEPINTENSET6_STALL1(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET6.Reg, volatile.LoadUint8(&o.EPINTENSET6.Reg)&^(0x40)|value<<6)
}
func (o *USB_DEVICE_Type) GetEPINTENSET6_STALL1() uint8 {
	return (volatile.LoadUint8(&o.EPINTENSET6.Reg) & 0x40) >> 6
}

// USB_DEVICE.EPCFG7: DEVICE End Point Configuration
func (o *USB_DEVICE_Type) SetEPCFG7_EPTYPE0(value uint8) {
	volatile.StoreUint8(&o.EPCFG7.Reg, volatile.LoadUint8(&o.EPCFG7.Reg)&^(0x7)|value)
}
func (o *USB_DEVICE_Type) GetEPCFG7_EPTYPE0() uint8 {
	return volatile.LoadUint8(&o.EPCFG7.Reg) & 0x7
}
func (o *USB_DEVICE_Type) SetEPCFG7_EPTYPE1(value uint8) {
	volatile.StoreUint8(&o.EPCFG7.Reg, volatile.LoadUint8(&o.EPCFG7.Reg)&^(0x70)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPCFG7_EPTYPE1() uint8 {
	return (volatile.LoadUint8(&o.EPCFG7.Reg) & 0x70) >> 4
}
func (o *USB_DEVICE_Type) SetEPCFG7_NYETDIS(value uint8) {
	volatile.StoreUint8(&o.EPCFG7.Reg, volatile.LoadUint8(&o.EPCFG7.Reg)&^(0x80)|value<<7)
}
func (o *USB_DEVICE_Type) GetEPCFG7_NYETDIS() uint8 {
	return (volatile.LoadUint8(&o.EPCFG7.Reg) & 0x80) >> 7
}

// USB_DEVICE.EPSTATUSCLR7: DEVICE End Point Pipe Status Clear
func (o *USB_DEVICE_Type) SetEPSTATUSCLR7_DTGLOUT(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR7.Reg, volatile.LoadUint8(&o.EPSTATUSCLR7.Reg)&^(0x1)|value)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR7_DTGLOUT() uint8 {
	return volatile.LoadUint8(&o.EPSTATUSCLR7.Reg) & 0x1
}
func (o *USB_DEVICE_Type) SetEPSTATUSCLR7_DTGLIN(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR7.Reg, volatile.LoadUint8(&o.EPSTATUSCLR7.Reg)&^(0x2)|value<<1)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR7_DTGLIN() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSCLR7.Reg) & 0x2) >> 1
}
func (o *USB_DEVICE_Type) SetEPSTATUSCLR7_CURBK(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR7.Reg, volatile.LoadUint8(&o.EPSTATUSCLR7.Reg)&^(0x4)|value<<2)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR7_CURBK() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSCLR7.Reg) & 0x4) >> 2
}
func (o *USB_DEVICE_Type) SetEPSTATUSCLR7_STALLRQ0(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR7.Reg, volatile.LoadUint8(&o.EPSTATUSCLR7.Reg)&^(0x10)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR7_STALLRQ0() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSCLR7.Reg) & 0x10) >> 4
}
func (o *USB_DEVICE_Type) SetEPSTATUSCLR7_STALLRQ1(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR7.Reg, volatile.LoadUint8(&o.EPSTATUSCLR7.Reg)&^(0x20)|value<<5)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR7_STALLRQ1() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSCLR7.Reg) & 0x20) >> 5
}
func (o *USB_DEVICE_Type) SetEPSTATUSCLR7_BK0RDY(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR7.Reg, volatile.LoadUint8(&o.EPSTATUSCLR7.Reg)&^(0x40)|value<<6)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR7_BK0RDY() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSCLR7.Reg) & 0x40) >> 6
}
func (o *USB_DEVICE_Type) SetEPSTATUSCLR7_BK1RDY(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSCLR7.Reg, volatile.LoadUint8(&o.EPSTATUSCLR7.Reg)&^(0x80)|value<<7)
}
func (o *USB_DEVICE_Type) GetEPSTATUSCLR7_BK1RDY() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSCLR7.Reg) & 0x80) >> 7
}

// USB_DEVICE.EPSTATUSSET7: DEVICE End Point Pipe Status Set
func (o *USB_DEVICE_Type) SetEPSTATUSSET7_DTGLOUT(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET7.Reg, volatile.LoadUint8(&o.EPSTATUSSET7.Reg)&^(0x1)|value)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET7_DTGLOUT() uint8 {
	return volatile.LoadUint8(&o.EPSTATUSSET7.Reg) & 0x1
}
func (o *USB_DEVICE_Type) SetEPSTATUSSET7_DTGLIN(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET7.Reg, volatile.LoadUint8(&o.EPSTATUSSET7.Reg)&^(0x2)|value<<1)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET7_DTGLIN() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSSET7.Reg) & 0x2) >> 1
}
func (o *USB_DEVICE_Type) SetEPSTATUSSET7_CURBK(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET7.Reg, volatile.LoadUint8(&o.EPSTATUSSET7.Reg)&^(0x4)|value<<2)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET7_CURBK() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSSET7.Reg) & 0x4) >> 2
}
func (o *USB_DEVICE_Type) SetEPSTATUSSET7_STALLRQ0(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET7.Reg, volatile.LoadUint8(&o.EPSTATUSSET7.Reg)&^(0x10)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET7_STALLRQ0() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSSET7.Reg) & 0x10) >> 4
}
func (o *USB_DEVICE_Type) SetEPSTATUSSET7_STALLRQ1(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET7.Reg, volatile.LoadUint8(&o.EPSTATUSSET7.Reg)&^(0x20)|value<<5)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET7_STALLRQ1() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSSET7.Reg) & 0x20) >> 5
}
func (o *USB_DEVICE_Type) SetEPSTATUSSET7_BK0RDY(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET7.Reg, volatile.LoadUint8(&o.EPSTATUSSET7.Reg)&^(0x40)|value<<6)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET7_BK0RDY() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSSET7.Reg) & 0x40) >> 6
}
func (o *USB_DEVICE_Type) SetEPSTATUSSET7_BK1RDY(value uint8) {
	volatile.StoreUint8(&o.EPSTATUSSET7.Reg, volatile.LoadUint8(&o.EPSTATUSSET7.Reg)&^(0x80)|value<<7)
}
func (o *USB_DEVICE_Type) GetEPSTATUSSET7_BK1RDY() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUSSET7.Reg) & 0x80) >> 7
}

// USB_DEVICE.EPSTATUS7: DEVICE End Point Pipe Status
func (o *USB_DEVICE_Type) SetEPSTATUS7_DTGLOUT(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS7.Reg, volatile.LoadUint8(&o.EPSTATUS7.Reg)&^(0x1)|value)
}
func (o *USB_DEVICE_Type) GetEPSTATUS7_DTGLOUT() uint8 {
	return volatile.LoadUint8(&o.EPSTATUS7.Reg) & 0x1
}
func (o *USB_DEVICE_Type) SetEPSTATUS7_DTGLIN(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS7.Reg, volatile.LoadUint8(&o.EPSTATUS7.Reg)&^(0x2)|value<<1)
}
func (o *USB_DEVICE_Type) GetEPSTATUS7_DTGLIN() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUS7.Reg) & 0x2) >> 1
}
func (o *USB_DEVICE_Type) SetEPSTATUS7_CURBK(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS7.Reg, volatile.LoadUint8(&o.EPSTATUS7.Reg)&^(0x4)|value<<2)
}
func (o *USB_DEVICE_Type) GetEPSTATUS7_CURBK() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUS7.Reg) & 0x4) >> 2
}
func (o *USB_DEVICE_Type) SetEPSTATUS7_STALLRQ0(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS7.Reg, volatile.LoadUint8(&o.EPSTATUS7.Reg)&^(0x10)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPSTATUS7_STALLRQ0() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUS7.Reg) & 0x10) >> 4
}
func (o *USB_DEVICE_Type) SetEPSTATUS7_STALLRQ1(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS7.Reg, volatile.LoadUint8(&o.EPSTATUS7.Reg)&^(0x20)|value<<5)
}
func (o *USB_DEVICE_Type) GetEPSTATUS7_STALLRQ1() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUS7.Reg) & 0x20) >> 5
}
func (o *USB_DEVICE_Type) SetEPSTATUS7_BK0RDY(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS7.Reg, volatile.LoadUint8(&o.EPSTATUS7.Reg)&^(0x40)|value<<6)
}
func (o *USB_DEVICE_Type) GetEPSTATUS7_BK0RDY() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUS7.Reg) & 0x40) >> 6
}
func (o *USB_DEVICE_Type) SetEPSTATUS7_BK1RDY(value uint8) {
	volatile.StoreUint8(&o.EPSTATUS7.Reg, volatile.LoadUint8(&o.EPSTATUS7.Reg)&^(0x80)|value<<7)
}
func (o *USB_DEVICE_Type) GetEPSTATUS7_BK1RDY() uint8 {
	return (volatile.LoadUint8(&o.EPSTATUS7.Reg) & 0x80) >> 7
}

// USB_DEVICE.EPINTFLAG7: DEVICE End Point Interrupt Flag
func (o *USB_DEVICE_Type) SetEPINTFLAG7_TRCPT0(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG7.Reg, volatile.LoadUint8(&o.EPINTFLAG7.Reg)&^(0x1)|value)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG7_TRCPT0() uint8 {
	return volatile.LoadUint8(&o.EPINTFLAG7.Reg) & 0x1
}
func (o *USB_DEVICE_Type) SetEPINTFLAG7_TRCPT1(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG7.Reg, volatile.LoadUint8(&o.EPINTFLAG7.Reg)&^(0x2)|value<<1)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG7_TRCPT1() uint8 {
	return (volatile.LoadUint8(&o.EPINTFLAG7.Reg) & 0x2) >> 1
}
func (o *USB_DEVICE_Type) SetEPINTFLAG7_TRFAIL0(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG7.Reg, volatile.LoadUint8(&o.EPINTFLAG7.Reg)&^(0x4)|value<<2)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG7_TRFAIL0() uint8 {
	return (volatile.LoadUint8(&o.EPINTFLAG7.Reg) & 0x4) >> 2
}
func (o *USB_DEVICE_Type) SetEPINTFLAG7_TRFAIL1(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG7.Reg, volatile.LoadUint8(&o.EPINTFLAG7.Reg)&^(0x8)|value<<3)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG7_TRFAIL1() uint8 {
	return (volatile.LoadUint8(&o.EPINTFLAG7.Reg) & 0x8) >> 3
}
func (o *USB_DEVICE_Type) SetEPINTFLAG7_RXSTP(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG7.Reg, volatile.LoadUint8(&o.EPINTFLAG7.Reg)&^(0x10)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG7_RXSTP() uint8 {
	return (volatile.LoadUint8(&o.EPINTFLAG7.Reg) & 0x10) >> 4
}
func (o *USB_DEVICE_Type) SetEPINTFLAG7_STALL0(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG7.Reg, volatile.LoadUint8(&o.EPINTFLAG7.Reg)&^(0x20)|value<<5)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG7_STALL0() uint8 {
	return (volatile.LoadUint8(&o.EPINTFLAG7.Reg) & 0x20) >> 5
}
func (o *USB_DEVICE_Type) SetEPINTFLAG7_STALL1(value uint8) {
	volatile.StoreUint8(&o.EPINTFLAG7.Reg, volatile.LoadUint8(&o.EPINTFLAG7.Reg)&^(0x40)|value<<6)
}
func (o *USB_DEVICE_Type) GetEPINTFLAG7_STALL1() uint8 {
	return (volatile.LoadUint8(&o.EPINTFLAG7.Reg) & 0x40) >> 6
}

// USB_DEVICE.EPINTENCLR7: DEVICE End Point Interrupt Clear Flag
func (o *USB_DEVICE_Type) SetEPINTENCLR7_TRCPT0(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR7.Reg, volatile.LoadUint8(&o.EPINTENCLR7.Reg)&^(0x1)|value)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR7_TRCPT0() uint8 {
	return volatile.LoadUint8(&o.EPINTENCLR7.Reg) & 0x1
}
func (o *USB_DEVICE_Type) SetEPINTENCLR7_TRCPT1(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR7.Reg, volatile.LoadUint8(&o.EPINTENCLR7.Reg)&^(0x2)|value<<1)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR7_TRCPT1() uint8 {
	return (volatile.LoadUint8(&o.EPINTENCLR7.Reg) & 0x2) >> 1
}
func (o *USB_DEVICE_Type) SetEPINTENCLR7_TRFAIL0(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR7.Reg, volatile.LoadUint8(&o.EPINTENCLR7.Reg)&^(0x4)|value<<2)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR7_TRFAIL0() uint8 {
	return (volatile.LoadUint8(&o.EPINTENCLR7.Reg) & 0x4) >> 2
}
func (o *USB_DEVICE_Type) SetEPINTENCLR7_TRFAIL1(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR7.Reg, volatile.LoadUint8(&o.EPINTENCLR7.Reg)&^(0x8)|value<<3)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR7_TRFAIL1() uint8 {
	return (volatile.LoadUint8(&o.EPINTENCLR7.Reg) & 0x8) >> 3
}
func (o *USB_DEVICE_Type) SetEPINTENCLR7_RXSTP(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR7.Reg, volatile.LoadUint8(&o.EPINTENCLR7.Reg)&^(0x10)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR7_RXSTP() uint8 {
	return (volatile.LoadUint8(&o.EPINTENCLR7.Reg) & 0x10) >> 4
}
func (o *USB_DEVICE_Type) SetEPINTENCLR7_STALL0(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR7.Reg, volatile.LoadUint8(&o.EPINTENCLR7.Reg)&^(0x20)|value<<5)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR7_STALL0() uint8 {
	return (volatile.LoadUint8(&o.EPINTENCLR7.Reg) & 0x20) >> 5
}
func (o *USB_DEVICE_Type) SetEPINTENCLR7_STALL1(value uint8) {
	volatile.StoreUint8(&o.EPINTENCLR7.Reg, volatile.LoadUint8(&o.EPINTENCLR7.Reg)&^(0x40)|value<<6)
}
func (o *USB_DEVICE_Type) GetEPINTENCLR7_STALL1() uint8 {
	return (volatile.LoadUint8(&o.EPINTENCLR7.Reg) & 0x40) >> 6
}

// USB_DEVICE.EPINTENSET7: DEVICE End Point Interrupt Set Flag
func (o *USB_DEVICE_Type) SetEPINTENSET7_TRCPT0(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET7.Reg, volatile.LoadUint8(&o.EPINTENSET7.Reg)&^(0x1)|value)
}
func (o *USB_DEVICE_Type) GetEPINTENSET7_TRCPT0() uint8 {
	return volatile.LoadUint8(&o.EPINTENSET7.Reg) & 0x1
}
func (o *USB_DEVICE_Type) SetEPINTENSET7_TRCPT1(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET7.Reg, volatile.LoadUint8(&o.EPINTENSET7.Reg)&^(0x2)|value<<1)
}
func (o *USB_DEVICE_Type) GetEPINTENSET7_TRCPT1() uint8 {
	return (volatile.LoadUint8(&o.EPINTENSET7.Reg) & 0x2) >> 1
}
func (o *USB_DEVICE_Type) SetEPINTENSET7_TRFAIL0(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET7.Reg, volatile.LoadUint8(&o.EPINTENSET7.Reg)&^(0x4)|value<<2)
}
func (o *USB_DEVICE_Type) GetEPINTENSET7_TRFAIL0() uint8 {
	return (volatile.LoadUint8(&o.EPINTENSET7.Reg) & 0x4) >> 2
}
func (o *USB_DEVICE_Type) SetEPINTENSET7_TRFAIL1(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET7.Reg, volatile.LoadUint8(&o.EPINTENSET7.Reg)&^(0x8)|value<<3)
}
func (o *USB_DEVICE_Type) GetEPINTENSET7_TRFAIL1() uint8 {
	return (volatile.LoadUint8(&o.EPINTENSET7.Reg) & 0x8) >> 3
}
func (o *USB_DEVICE_Type) SetEPINTENSET7_RXSTP(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET7.Reg, volatile.LoadUint8(&o.EPINTENSET7.Reg)&^(0x10)|value<<4)
}
func (o *USB_DEVICE_Type) GetEPINTENSET7_RXSTP() uint8 {
	return (volatile.LoadUint8(&o.EPINTENSET7.Reg) & 0x10) >> 4
}
func (o *USB_DEVICE_Type) SetEPINTENSET7_STALL0(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET7.Reg, volatile.LoadUint8(&o.EPINTENSET7.Reg)&^(0x20)|value<<5)
}
func (o *USB_DEVICE_Type) GetEPINTENSET7_STALL0() uint8 {
	return (volatile.LoadUint8(&o.EPINTENSET7.Reg) & 0x20) >> 5
}
func (o *USB_DEVICE_Type) SetEPINTENSET7_STALL1(value uint8) {
	volatile.StoreUint8(&o.EPINTENSET7.Reg, volatile.LoadUint8(&o.EPINTENSET7.Reg)&^(0x40)|value<<6)
}
func (o *USB_DEVICE_Type) GetEPINTENSET7_STALL1() uint8 {
	return (volatile.LoadUint8(&o.EPINTENSET7.Reg) & 0x40) >> 6
}

// Watchdog Timer
type WDT_Type struct {
	CTRLA    volatile.Register8 // 0x0
	CONFIG   volatile.Register8 // 0x1
	EWCTRL   volatile.Register8 // 0x2
	_        byte
	INTENCLR volatile.Register8 // 0x4
	INTENSET volatile.Register8 // 0x5
	INTFLAG  volatile.Register8 // 0x6
	_        byte
	SYNCBUSY volatile.Register32 // 0x8
	CLEAR    volatile.Register8  // 0xC
}

// WDT.CTRLA: Control
func (o *WDT_Type) SetCTRLA_ENABLE(value uint8) {
	volatile.StoreUint8(&o.CTRLA.Reg, volatile.LoadUint8(&o.CTRLA.Reg)&^(0x2)|value<<1)
}
func (o *WDT_Type) GetCTRLA_ENABLE() uint8 {
	return (volatile.LoadUint8(&o.CTRLA.Reg) & 0x2) >> 1
}
func (o *WDT_Type) SetCTRLA_WEN(value uint8) {
	volatile.StoreUint8(&o.CTRLA.Reg, volatile.LoadUint8(&o.CTRLA.Reg)&^(0x4)|value<<2)
}
func (o *WDT_Type) GetCTRLA_WEN() uint8 {
	return (volatile.LoadUint8(&o.CTRLA.Reg) & 0x4) >> 2
}
func (o *WDT_Type) SetCTRLA_ALWAYSON(value uint8) {
	volatile.StoreUint8(&o.CTRLA.Reg, volatile.LoadUint8(&o.CTRLA.Reg)&^(0x80)|value<<7)
}
func (o *WDT_Type) GetCTRLA_ALWAYSON() uint8 {
	return (volatile.LoadUint8(&o.CTRLA.Reg) & 0x80) >> 7
}

// WDT.CONFIG: Configuration
func (o *WDT_Type) SetCONFIG_PER(value uint8) {
	volatile.StoreUint8(&o.CONFIG.Reg, volatile.LoadUint8(&o.CONFIG.Reg)&^(0xf)|value)
}
func (o *WDT_Type) GetCONFIG_PER() uint8 {
	return volatile.LoadUint8(&o.CONFIG.Reg) & 0xf
}
func (o *WDT_Type) SetCONFIG_WINDOW(value uint8) {
	volatile.StoreUint8(&o.CONFIG.Reg, volatile.LoadUint8(&o.CONFIG.Reg)&^(0xf0)|value<<4)
}
func (o *WDT_Type) GetCONFIG_WINDOW() uint8 {
	return (volatile.LoadUint8(&o.CONFIG.Reg) & 0xf0) >> 4
}

// WDT.EWCTRL: Early Warning Interrupt Control
func (o *WDT_Type) SetEWCTRL_EWOFFSET(value uint8) {
	volatile.StoreUint8(&o.EWCTRL.Reg, volatile.LoadUint8(&o.EWCTRL.Reg)&^(0xf)|value)
}
func (o *WDT_Type) GetEWCTRL_EWOFFSET() uint8 {
	return volatile.LoadUint8(&o.EWCTRL.Reg) & 0xf
}

// WDT.INTENCLR: Interrupt Enable Clear
func (o *WDT_Type) SetINTENCLR_EW(value uint8) {
	volatile.StoreUint8(&o.INTENCLR.Reg, volatile.LoadUint8(&o.INTENCLR.Reg)&^(0x1)|value)
}
func (o *WDT_Type) GetINTENCLR_EW() uint8 {
	return volatile.LoadUint8(&o.INTENCLR.Reg) & 0x1
}

// WDT.INTENSET: Interrupt Enable Set
func (o *WDT_Type) SetINTENSET_EW(value uint8) {
	volatile.StoreUint8(&o.INTENSET.Reg, volatile.LoadUint8(&o.INTENSET.Reg)&^(0x1)|value)
}
func (o *WDT_Type) GetINTENSET_EW() uint8 {
	return volatile.LoadUint8(&o.INTENSET.Reg) & 0x1
}

// WDT.INTFLAG: Interrupt Flag Status and Clear
func (o *WDT_Type) SetINTFLAG_EW(value uint8) {
	volatile.StoreUint8(&o.INTFLAG.Reg, volatile.LoadUint8(&o.INTFLAG.Reg)&^(0x1)|value)
}
func (o *WDT_Type) GetINTFLAG_EW() uint8 {
	return volatile.LoadUint8(&o.INTFLAG.Reg) & 0x1
}

// WDT.SYNCBUSY: Synchronization Busy
func (o *WDT_Type) SetSYNCBUSY_ENABLE(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x2)|value<<1)
}
func (o *WDT_Type) GetSYNCBUSY_ENABLE() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x2) >> 1
}
func (o *WDT_Type) SetSYNCBUSY_WEN(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x4)|value<<2)
}
func (o *WDT_Type) GetSYNCBUSY_WEN() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x4) >> 2
}
func (o *WDT_Type) SetSYNCBUSY_ALWAYSON(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x8)|value<<3)
}
func (o *WDT_Type) GetSYNCBUSY_ALWAYSON() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x8) >> 3
}
func (o *WDT_Type) SetSYNCBUSY_CLEAR(value uint32) {
	volatile.StoreUint32(&o.SYNCBUSY.Reg, volatile.LoadUint32(&o.SYNCBUSY.Reg)&^(0x10)|value<<4)
}
func (o *WDT_Type) GetSYNCBUSY_CLEAR() uint32 {
	return (volatile.LoadUint32(&o.SYNCBUSY.Reg) & 0x10) >> 4
}

// WDT.CLEAR: Clear
func (o *WDT_Type) SetCLEAR(value uint8) {
	volatile.StoreUint8(&o.CLEAR.Reg, value)
}
func (o *WDT_Type) GetCLEAR() uint8 {
	return volatile.LoadUint8(&o.CLEAR.Reg)
}

// Constants for AC: Analog Comparators
const (
	// CTRLA: Control A
	// Position of SWRST field.
	AC_CTRLA_SWRST_Pos = 0x0
	// Bit mask of SWRST field.
	AC_CTRLA_SWRST_Msk = 0x1
	// Bit SWRST.
	AC_CTRLA_SWRST = 0x1
	// Position of ENABLE field.
	AC_CTRLA_ENABLE_Pos = 0x1
	// Bit mask of ENABLE field.
	AC_CTRLA_ENABLE_Msk = 0x2
	// Bit ENABLE.
	AC_CTRLA_ENABLE = 0x2

	// CTRLB: Control B
	// Position of START0 field.
	AC_CTRLB_START0_Pos = 0x0
	// Bit mask of START0 field.
	AC_CTRLB_START0_Msk = 0x1
	// Bit START0.
	AC_CTRLB_START0 = 0x1
	// Position of START1 field.
	AC_CTRLB_START1_Pos = 0x1
	// Bit mask of START1 field.
	AC_CTRLB_START1_Msk = 0x2
	// Bit START1.
	AC_CTRLB_START1 = 0x2

	// EVCTRL: Event Control
	// Position of COMPEO0 field.
	AC_EVCTRL_COMPEO0_Pos = 0x0
	// Bit mask of COMPEO0 field.
	AC_EVCTRL_COMPEO0_Msk = 0x1
	// Bit COMPEO0.
	AC_EVCTRL_COMPEO0 = 0x1
	// Position of COMPEO1 field.
	AC_EVCTRL_COMPEO1_Pos = 0x1
	// Bit mask of COMPEO1 field.
	AC_EVCTRL_COMPEO1_Msk = 0x2
	// Bit COMPEO1.
	AC_EVCTRL_COMPEO1 = 0x2
	// Position of WINEO0 field.
	AC_EVCTRL_WINEO0_Pos = 0x4
	// Bit mask of WINEO0 field.
	AC_EVCTRL_WINEO0_Msk = 0x10
	// Bit WINEO0.
	AC_EVCTRL_WINEO0 = 0x10
	// Position of COMPEI0 field.
	AC_EVCTRL_COMPEI0_Pos = 0x8
	// Bit mask of COMPEI0 field.
	AC_EVCTRL_COMPEI0_Msk = 0x100
	// Bit COMPEI0.
	AC_EVCTRL_COMPEI0 = 0x100
	// Position of COMPEI1 field.
	AC_EVCTRL_COMPEI1_Pos = 0x9
	// Bit mask of COMPEI1 field.
	AC_EVCTRL_COMPEI1_Msk = 0x200
	// Bit COMPEI1.
	AC_EVCTRL_COMPEI1 = 0x200
	// Position of INVEI0 field.
	AC_EVCTRL_INVEI0_Pos = 0xc
	// Bit mask of INVEI0 field.
	AC_EVCTRL_INVEI0_Msk = 0x1000
	// Bit INVEI0.
	AC_EVCTRL_INVEI0 = 0x1000
	// Position of INVEI1 field.
	AC_EVCTRL_INVEI1_Pos = 0xd
	// Bit mask of INVEI1 field.
	AC_EVCTRL_INVEI1_Msk = 0x2000
	// Bit INVEI1.
	AC_EVCTRL_INVEI1 = 0x2000

	// INTENCLR: Interrupt Enable Clear
	// Position of COMP0 field.
	AC_INTENCLR_COMP0_Pos = 0x0
	// Bit mask of COMP0 field.
	AC_INTENCLR_COMP0_Msk = 0x1
	// Bit COMP0.
	AC_INTENCLR_COMP0 = 0x1
	// Position of COMP1 field.
	AC_INTENCLR_COMP1_Pos = 0x1
	// Bit mask of COMP1 field.
	AC_INTENCLR_COMP1_Msk = 0x2
	// Bit COMP1.
	AC_INTENCLR_COMP1 = 0x2
	// Position of WIN0 field.
	AC_INTENCLR_WIN0_Pos = 0x4
	// Bit mask of WIN0 field.
	AC_INTENCLR_WIN0_Msk = 0x10
	// Bit WIN0.
	AC_INTENCLR_WIN0 = 0x10

	// INTENSET: Interrupt Enable Set
	// Position of COMP0 field.
	AC_INTENSET_COMP0_Pos = 0x0
	// Bit mask of COMP0 field.
	AC_INTENSET_COMP0_Msk = 0x1
	// Bit COMP0.
	AC_INTENSET_COMP0 = 0x1
	// Position of COMP1 field.
	AC_INTENSET_COMP1_Pos = 0x1
	// Bit mask of COMP1 field.
	AC_INTENSET_COMP1_Msk = 0x2
	// Bit COMP1.
	AC_INTENSET_COMP1 = 0x2
	// Position of WIN0 field.
	AC_INTENSET_WIN0_Pos = 0x4
	// Bit mask of WIN0 field.
	AC_INTENSET_WIN0_Msk = 0x10
	// Bit WIN0.
	AC_INTENSET_WIN0 = 0x10

	// INTFLAG: Interrupt Flag Status and Clear
	// Position of COMP0 field.
	AC_INTFLAG_COMP0_Pos = 0x0
	// Bit mask of COMP0 field.
	AC_INTFLAG_COMP0_Msk = 0x1
	// Bit COMP0.
	AC_INTFLAG_COMP0 = 0x1
	// Position of COMP1 field.
	AC_INTFLAG_COMP1_Pos = 0x1
	// Bit mask of COMP1 field.
	AC_INTFLAG_COMP1_Msk = 0x2
	// Bit COMP1.
	AC_INTFLAG_COMP1 = 0x2
	// Position of WIN0 field.
	AC_INTFLAG_WIN0_Pos = 0x4
	// Bit mask of WIN0 field.
	AC_INTFLAG_WIN0_Msk = 0x10
	// Bit WIN0.
	AC_INTFLAG_WIN0 = 0x10

	// STATUSA: Status A
	// Position of STATE0 field.
	AC_STATUSA_STATE0_Pos = 0x0
	// Bit mask of STATE0 field.
	AC_STATUSA_STATE0_Msk = 0x1
	// Bit STATE0.
	AC_STATUSA_STATE0 = 0x1
	// Position of STATE1 field.
	AC_STATUSA_STATE1_Pos = 0x1
	// Bit mask of STATE1 field.
	AC_STATUSA_STATE1_Msk = 0x2
	// Bit STATE1.
	AC_STATUSA_STATE1 = 0x2
	// Position of WSTATE0 field.
	AC_STATUSA_WSTATE0_Pos = 0x4
	// Bit mask of WSTATE0 field.
	AC_STATUSA_WSTATE0_Msk = 0x30
	// Signal is above window
	AC_STATUSA_WSTATE0_ABOVE = 0x0
	// Signal is inside window
	AC_STATUSA_WSTATE0_INSIDE = 0x1
	// Signal is below window
	AC_STATUSA_WSTATE0_BELOW = 0x2

	// STATUSB: Status B
	// Position of READY0 field.
	AC_STATUSB_READY0_Pos = 0x0
	// Bit mask of READY0 field.
	AC_STATUSB_READY0_Msk = 0x1
	// Bit READY0.
	AC_STATUSB_READY0 = 0x1
	// Position of READY1 field.
	AC_STATUSB_READY1_Pos = 0x1
	// Bit mask of READY1 field.
	AC_STATUSB_READY1_Msk = 0x2
	// Bit READY1.
	AC_STATUSB_READY1 = 0x2

	// DBGCTRL: Debug Control
	// Position of DBGRUN field.
	AC_DBGCTRL_DBGRUN_Pos = 0x0
	// Bit mask of DBGRUN field.
	AC_DBGCTRL_DBGRUN_Msk = 0x1
	// Bit DBGRUN.
	AC_DBGCTRL_DBGRUN = 0x1

	// WINCTRL: Window Control
	// Position of WEN0 field.
	AC_WINCTRL_WEN0_Pos = 0x0
	// Bit mask of WEN0 field.
	AC_WINCTRL_WEN0_Msk = 0x1
	// Bit WEN0.
	AC_WINCTRL_WEN0 = 0x1
	// Position of WINTSEL0 field.
	AC_WINCTRL_WINTSEL0_Pos = 0x1
	// Bit mask of WINTSEL0 field.
	AC_WINCTRL_WINTSEL0_Msk = 0x6
	// Interrupt on signal above window
	AC_WINCTRL_WINTSEL0_ABOVE = 0x0
	// Interrupt on signal inside window
	AC_WINCTRL_WINTSEL0_INSIDE = 0x1
	// Interrupt on signal below window
	AC_WINCTRL_WINTSEL0_BELOW = 0x2
	// Interrupt on signal outside window
	AC_WINCTRL_WINTSEL0_OUTSIDE = 0x3

	// SCALER0: Scaler n
	// Position of VALUE field.
	AC_SCALER_VALUE_Pos = 0x0
	// Bit mask of VALUE field.
	AC_SCALER_VALUE_Msk = 0x3f

	// COMPCTRL0: Comparator Control n
	// Position of ENABLE field.
	AC_COMPCTRL_ENABLE_Pos = 0x1
	// Bit mask of ENABLE field.
	AC_COMPCTRL_ENABLE_Msk = 0x2
	// Bit ENABLE.
	AC_COMPCTRL_ENABLE = 0x2
	// Position of SINGLE field.
	AC_COMPCTRL_SINGLE_Pos = 0x2
	// Bit mask of SINGLE field.
	AC_COMPCTRL_SINGLE_Msk = 0x4
	// Bit SINGLE.
	AC_COMPCTRL_SINGLE = 0x4
	// Position of INTSEL field.
	AC_COMPCTRL_INTSEL_Pos = 0x3
	// Bit mask of INTSEL field.
	AC_COMPCTRL_INTSEL_Msk = 0x18
	// Interrupt on comparator output toggle
	AC_COMPCTRL_INTSEL_TOGGLE = 0x0
	// Interrupt on comparator output rising
	AC_COMPCTRL_INTSEL_RISING = 0x1
	// Interrupt on comparator output falling
	AC_COMPCTRL_INTSEL_FALLING = 0x2
	// Interrupt on end of comparison (single-shot mode only)
	AC_COMPCTRL_INTSEL_EOC = 0x3
	// Position of RUNSTDBY field.
	AC_COMPCTRL_RUNSTDBY_Pos = 0x6
	// Bit mask of RUNSTDBY field.
	AC_COMPCTRL_RUNSTDBY_Msk = 0x40
	// Bit RUNSTDBY.
	AC_COMPCTRL_RUNSTDBY = 0x40
	// Position of MUXNEG field.
	AC_COMPCTRL_MUXNEG_Pos = 0x8
	// Bit mask of MUXNEG field.
	AC_COMPCTRL_MUXNEG_Msk = 0x700
	// I/O pin 0
	AC_COMPCTRL_MUXNEG_PIN0 = 0x0
	// I/O pin 1
	AC_COMPCTRL_MUXNEG_PIN1 = 0x1
	// I/O pin 2
	AC_COMPCTRL_MUXNEG_PIN2 = 0x2
	// I/O pin 3
	AC_COMPCTRL_MUXNEG_PIN3 = 0x3
	// Ground
	AC_COMPCTRL_MUXNEG_GND = 0x4
	// VDD scaler
	AC_COMPCTRL_MUXNEG_VSCALE = 0x5
	// Internal bandgap voltage
	AC_COMPCTRL_MUXNEG_BANDGAP = 0x6
	// DAC output
	AC_COMPCTRL_MUXNEG_DAC = 0x7
	// Position of MUXPOS field.
	AC_COMPCTRL_MUXPOS_Pos = 0xc
	// Bit mask of MUXPOS field.
	AC_COMPCTRL_MUXPOS_Msk = 0x7000
	// I/O pin 0
	AC_COMPCTRL_MUXPOS_PIN0 = 0x0
	// I/O pin 1
	AC_COMPCTRL_MUXPOS_PIN1 = 0x1
	// I/O pin 2
	AC_COMPCTRL_MUXPOS_PIN2 = 0x2
	// I/O pin 3
	AC_COMPCTRL_MUXPOS_PIN3 = 0x3
	// VDD Scaler
	AC_COMPCTRL_MUXPOS_VSCALE = 0x4
	// Position of SWAP field.
	AC_COMPCTRL_SWAP_Pos = 0xf
	// Bit mask of SWAP field.
	AC_COMPCTRL_SWAP_Msk = 0x8000
	// Bit SWAP.
	AC_COMPCTRL_SWAP = 0x8000
	// Position of SPEED field.
	AC_COMPCTRL_SPEED_Pos = 0x10
	// Bit mask of SPEED field.
	AC_COMPCTRL_SPEED_Msk = 0x30000
	// Low speed
	AC_COMPCTRL_SPEED_LOW = 0x0
	// Medium low speed
	AC_COMPCTRL_SPEED_MEDLOW = 0x1
	// Medium high speed
	AC_COMPCTRL_SPEED_MEDHIGH = 0x2
	// High speed
	AC_COMPCTRL_SPEED_HIGH = 0x3
	// Position of HYSTEN field.
	AC_COMPCTRL_HYSTEN_Pos = 0x13
	// Bit mask of HYSTEN field.
	AC_COMPCTRL_HYSTEN_Msk = 0x80000
	// Bit HYSTEN.
	AC_COMPCTRL_HYSTEN = 0x80000
	// Position of HYST field.
	AC_COMPCTRL_HYST_Pos = 0x14
	// Bit mask of HYST field.
	AC_COMPCTRL_HYST_Msk = 0x300000
	// 50mV
	AC_COMPCTRL_HYST_HYST50 = 0x0
	// 70mV
	AC_COMPCTRL_HYST_HYST70 = 0x1
	// 90mV
	AC_COMPCTRL_HYST_HYST90 = 0x2
	// 110mV
	AC_COMPCTRL_HYST_HYST110 = 0x3
	// Position of FLEN field.
	AC_COMPCTRL_FLEN_Pos = 0x18
	// Bit mask of FLEN field.
	AC_COMPCTRL_FLEN_Msk = 0x7000000
	// No filtering
	AC_COMPCTRL_FLEN_OFF = 0x0
	// 3-bit majority function (2 of 3)
	AC_COMPCTRL_FLEN_MAJ3 = 0x1
	// 5-bit majority function (3 of 5)
	AC_COMPCTRL_FLEN_MAJ5 = 0x2
	// Position of OUT field.
	AC_COMPCTRL_OUT_Pos = 0x1c
	// Bit mask of OUT field.
	AC_COMPCTRL_OUT_Msk = 0x30000000
	// The output of COMPn is not routed to the COMPn I/O port
	AC_COMPCTRL_OUT_OFF = 0x0
	// The asynchronous output of COMPn is routed to the COMPn I/O port
	AC_COMPCTRL_OUT_ASYNC = 0x1
	// The synchronous output (including filtering) of COMPn is routed to the COMPn I/O port
	AC_COMPCTRL_OUT_SYNC = 0x2

	// SYNCBUSY: Synchronization Busy
	// Position of SWRST field.
	AC_SYNCBUSY_SWRST_Pos = 0x0
	// Bit mask of SWRST field.
	AC_SYNCBUSY_SWRST_Msk = 0x1
	// Bit SWRST.
	AC_SYNCBUSY_SWRST = 0x1
	// Position of ENABLE field.
	AC_SYNCBUSY_ENABLE_Pos = 0x1
	// Bit mask of ENABLE field.
	AC_SYNCBUSY_ENABLE_Msk = 0x2
	// Bit ENABLE.
	AC_SYNCBUSY_ENABLE = 0x2
	// Position of WINCTRL field.
	AC_SYNCBUSY_WINCTRL_Pos = 0x2
	// Bit mask of WINCTRL field.
	AC_SYNCBUSY_WINCTRL_Msk = 0x4
	// Bit WINCTRL.
	AC_SYNCBUSY_WINCTRL = 0x4
	// Position of COMPCTRL0 field.
	AC_SYNCBUSY_COMPCTRL0_Pos = 0x3
	// Bit mask of COMPCTRL0 field.
	AC_SYNCBUSY_COMPCTRL0_Msk = 0x8
	// Bit COMPCTRL0.
	AC_SYNCBUSY_COMPCTRL0 = 0x8
	// Position of COMPCTRL1 field.
	AC_SYNCBUSY_COMPCTRL1_Pos = 0x4
	// Bit mask of COMPCTRL1 field.
	AC_SYNCBUSY_COMPCTRL1_Msk = 0x10
	// Bit COMPCTRL1.
	AC_SYNCBUSY_COMPCTRL1 = 0x10
)

// Constants for ADC: Analog Digital Converter
const (
	// CTRLA: Control A
	// Position of SWRST field.
	ADC_CTRLA_SWRST_Pos = 0x0
	// Bit mask of SWRST field.
	ADC_CTRLA_SWRST_Msk = 0x1
	// Bit SWRST.
	ADC_CTRLA_SWRST = 0x1
	// Position of ENABLE field.
	ADC_CTRLA_ENABLE_Pos = 0x1
	// Bit mask of ENABLE field.
	ADC_CTRLA_ENABLE_Msk = 0x2
	// Bit ENABLE.
	ADC_CTRLA_ENABLE = 0x2
	// Position of RUNSTDBY field.
	ADC_CTRLA_RUNSTDBY_Pos = 0x6
	// Bit mask of RUNSTDBY field.
	ADC_CTRLA_RUNSTDBY_Msk = 0x40
	// Bit RUNSTDBY.
	ADC_CTRLA_RUNSTDBY = 0x40
	// Position of ONDEMAND field.
	ADC_CTRLA_ONDEMAND_Pos = 0x7
	// Bit mask of ONDEMAND field.
	ADC_CTRLA_ONDEMAND_Msk = 0x80
	// Bit ONDEMAND.
	ADC_CTRLA_ONDEMAND = 0x80

	// CTRLB: Control B
	// Position of PRESCALER field.
	ADC_CTRLB_PRESCALER_Pos = 0x0
	// Bit mask of PRESCALER field.
	ADC_CTRLB_PRESCALER_Msk = 0x7
	// Peripheral clock divided by 2
	ADC_CTRLB_PRESCALER_DIV2 = 0x0
	// Peripheral clock divided by 4
	ADC_CTRLB_PRESCALER_DIV4 = 0x1
	// Peripheral clock divided by 8
	ADC_CTRLB_PRESCALER_DIV8 = 0x2
	// Peripheral clock divided by 16
	ADC_CTRLB_PRESCALER_DIV16 = 0x3
	// Peripheral clock divided by 32
	ADC_CTRLB_PRESCALER_DIV32 = 0x4
	// Peripheral clock divided by 64
	ADC_CTRLB_PRESCALER_DIV64 = 0x5
	// Peripheral clock divided by 128
	ADC_CTRLB_PRESCALER_DIV128 = 0x6
	// Peripheral clock divided by 256
	ADC_CTRLB_PRESCALER_DIV256 = 0x7

	// REFCTRL: Reference Control
	// Position of REFSEL field.
	ADC_REFCTRL_REFSEL_Pos = 0x0
	// Bit mask of REFSEL field.
	ADC_REFCTRL_REFSEL_Msk = 0xf
	// Internal Bandgap Reference
	ADC_REFCTRL_REFSEL_INTREF = 0x0
	// 1/1.6 VDDANA
	ADC_REFCTRL_REFSEL_INTVCC0 = 0x1
	// 1/2 VDDANA
	ADC_REFCTRL_REFSEL_INTVCC1 = 0x2
	// External Reference
	ADC_REFCTRL_REFSEL_AREFA = 0x3
	// External Reference
	ADC_REFCTRL_REFSEL_AREFB = 0x4
	// VCCANA
	ADC_REFCTRL_REFSEL_INTVCC2 = 0x5
	// Position of REFCOMP field.
	ADC_REFCTRL_REFCOMP_Pos = 0x7
	// Bit mask of REFCOMP field.
	ADC_REFCTRL_REFCOMP_Msk = 0x80
	// Bit REFCOMP.
	ADC_REFCTRL_REFCOMP = 0x80

	// EVCTRL: Event Control
	// Position of FLUSHEI field.
	ADC_EVCTRL_FLUSHEI_Pos = 0x0
	// Bit mask of FLUSHEI field.
	ADC_EVCTRL_FLUSHEI_Msk = 0x1
	// Bit FLUSHEI.
	ADC_EVCTRL_FLUSHEI = 0x1
	// Position of STARTEI field.
	ADC_EVCTRL_STARTEI_Pos = 0x1
	// Bit mask of STARTEI field.
	ADC_EVCTRL_STARTEI_Msk = 0x2
	// Bit STARTEI.
	ADC_EVCTRL_STARTEI = 0x2
	// Position of FLUSHINV field.
	ADC_EVCTRL_FLUSHINV_Pos = 0x2
	// Bit mask of FLUSHINV field.
	ADC_EVCTRL_FLUSHINV_Msk = 0x4
	// Bit FLUSHINV.
	ADC_EVCTRL_FLUSHINV = 0x4
	// Position of STARTINV field.
	ADC_EVCTRL_STARTINV_Pos = 0x3
	// Bit mask of STARTINV field.
	ADC_EVCTRL_STARTINV_Msk = 0x8
	// Bit STARTINV.
	ADC_EVCTRL_STARTINV = 0x8
	// Position of RESRDYEO field.
	ADC_EVCTRL_RESRDYEO_Pos = 0x4
	// Bit mask of RESRDYEO field.
	ADC_EVCTRL_RESRDYEO_Msk = 0x10
	// Bit RESRDYEO.
	ADC_EVCTRL_RESRDYEO = 0x10
	// Position of WINMONEO field.
	ADC_EVCTRL_WINMONEO_Pos = 0x5
	// Bit mask of WINMONEO field.
	ADC_EVCTRL_WINMONEO_Msk = 0x20
	// Bit WINMONEO.
	ADC_EVCTRL_WINMONEO = 0x20

	// INTENCLR: Interrupt Enable Clear
	// Position of RESRDY field.
	ADC_INTENCLR_RESRDY_Pos = 0x0
	// Bit mask of RESRDY field.
	ADC_INTENCLR_RESRDY_Msk = 0x1
	// Bit RESRDY.
	ADC_INTENCLR_RESRDY = 0x1
	// Position of OVERRUN field.
	ADC_INTENCLR_OVERRUN_Pos = 0x1
	// Bit mask of OVERRUN field.
	ADC_INTENCLR_OVERRUN_Msk = 0x2
	// Bit OVERRUN.
	ADC_INTENCLR_OVERRUN = 0x2
	// Position of WINMON field.
	ADC_INTENCLR_WINMON_Pos = 0x2
	// Bit mask of WINMON field.
	ADC_INTENCLR_WINMON_Msk = 0x4
	// Bit WINMON.
	ADC_INTENCLR_WINMON = 0x4

	// INTENSET: Interrupt Enable Set
	// Position of RESRDY field.
	ADC_INTENSET_RESRDY_Pos = 0x0
	// Bit mask of RESRDY field.
	ADC_INTENSET_RESRDY_Msk = 0x1
	// Bit RESRDY.
	ADC_INTENSET_RESRDY = 0x1
	// Position of OVERRUN field.
	ADC_INTENSET_OVERRUN_Pos = 0x1
	// Bit mask of OVERRUN field.
	ADC_INTENSET_OVERRUN_Msk = 0x2
	// Bit OVERRUN.
	ADC_INTENSET_OVERRUN = 0x2
	// Position of WINMON field.
	ADC_INTENSET_WINMON_Pos = 0x2
	// Bit mask of WINMON field.
	ADC_INTENSET_WINMON_Msk = 0x4
	// Bit WINMON.
	ADC_INTENSET_WINMON = 0x4

	// INTFLAG: Interrupt Flag Status and Clear
	// Position of RESRDY field.
	ADC_INTFLAG_RESRDY_Pos = 0x0
	// Bit mask of RESRDY field.
	ADC_INTFLAG_RESRDY_Msk = 0x1
	// Bit RESRDY.
	ADC_INTFLAG_RESRDY = 0x1
	// Position of OVERRUN field.
	ADC_INTFLAG_OVERRUN_Pos = 0x1
	// Bit mask of OVERRUN field.
	ADC_INTFLAG_OVERRUN_Msk = 0x2
	// Bit OVERRUN.
	ADC_INTFLAG_OVERRUN = 0x2
	// Position of WINMON field.
	ADC_INTFLAG_WINMON_Pos = 0x2
	// Bit mask of WINMON field.
	ADC_INTFLAG_WINMON_Msk = 0x4
	// Bit WINMON.
	ADC_INTFLAG_WINMON = 0x4

	// SEQSTATUS: Sequence Status
	// Position of SEQSTATE field.
	ADC_SEQSTATUS_SEQSTATE_Pos = 0x0
	// Bit mask of SEQSTATE field.
	ADC_SEQSTATUS_SEQSTATE_Msk = 0x1f
	// Position of SEQBUSY field.
	ADC_SEQSTATUS_SEQBUSY_Pos = 0x7
	// Bit mask of SEQBUSY field.
	ADC_SEQSTATUS_SEQBUSY_Msk = 0x80
	// Bit SEQBUSY.
	ADC_SEQSTATUS_SEQBUSY = 0x80

	// INPUTCTRL: Input Control
	// Position of MUXPOS field.
	ADC_INPUTCTRL_MUXPOS_Pos = 0x0
	// Bit mask of MUXPOS field.
	ADC_INPUTCTRL_MUXPOS_Msk = 0x1f
	// ADC AIN0 Pin
	ADC_INPUTCTRL_MUXPOS_AIN0 = 0x0
	// ADC AIN1 Pin
	ADC_INPUTCTRL_MUXPOS_AIN1 = 0x1
	// ADC AIN2 Pin
	ADC_INPUTCTRL_MUXPOS_AIN2 = 0x2
	// ADC AIN3 Pin
	ADC_INPUTCTRL_MUXPOS_AIN3 = 0x3
	// ADC AIN4 Pin
	ADC_INPUTCTRL_MUXPOS_AIN4 = 0x4
	// ADC AIN5 Pin
	ADC_INPUTCTRL_MUXPOS_AIN5 = 0x5
	// ADC AIN6 Pin
	ADC_INPUTCTRL_MUXPOS_AIN6 = 0x6
	// ADC AIN7 Pin
	ADC_INPUTCTRL_MUXPOS_AIN7 = 0x7
	// ADC AIN8 Pin
	ADC_INPUTCTRL_MUXPOS_AIN8 = 0x8
	// ADC AIN9 Pin
	ADC_INPUTCTRL_MUXPOS_AIN9 = 0x9
	// ADC AIN10 Pin
	ADC_INPUTCTRL_MUXPOS_AIN10 = 0xa
	// ADC AIN11 Pin
	ADC_INPUTCTRL_MUXPOS_AIN11 = 0xb
	// ADC AIN12 Pin
	ADC_INPUTCTRL_MUXPOS_AIN12 = 0xc
	// ADC AIN13 Pin
	ADC_INPUTCTRL_MUXPOS_AIN13 = 0xd
	// ADC AIN14 Pin
	ADC_INPUTCTRL_MUXPOS_AIN14 = 0xe
	// ADC AIN15 Pin
	ADC_INPUTCTRL_MUXPOS_AIN15 = 0xf
	// ADC AIN16 Pin
	ADC_INPUTCTRL_MUXPOS_AIN16 = 0x10
	// ADC AIN17 Pin
	ADC_INPUTCTRL_MUXPOS_AIN17 = 0x11
	// ADC AIN18 Pin
	ADC_INPUTCTRL_MUXPOS_AIN18 = 0x12
	// ADC AIN19 Pin
	ADC_INPUTCTRL_MUXPOS_AIN19 = 0x13
	// Temperature Sensor
	ADC_INPUTCTRL_MUXPOS_TEMP = 0x18
	// Bandgap Voltage
	ADC_INPUTCTRL_MUXPOS_BANDGAP = 0x19
	// 1/4 Scaled Core Supply
	ADC_INPUTCTRL_MUXPOS_SCALEDCOREVCC = 0x1a
	// 1/4 Scaled I/O Supply
	ADC_INPUTCTRL_MUXPOS_SCALEDIOVCC = 0x1b
	// 1/4 Scaled VBAT Supply
	ADC_INPUTCTRL_MUXPOS_SCALEDVBAT = 0x1d
	// CTAT output
	ADC_INPUTCTRL_MUXPOS_CTAT = 0x1e
	// Position of MUXNEG field.
	ADC_INPUTCTRL_MUXNEG_Pos = 0x8
	// Bit mask of MUXNEG field.
	ADC_INPUTCTRL_MUXNEG_Msk = 0x1f00
	// ADC AIN0 Pin
	ADC_INPUTCTRL_MUXNEG_AIN0 = 0x0
	// ADC AIN1 Pin
	ADC_INPUTCTRL_MUXNEG_AIN1 = 0x1
	// ADC AIN2 Pin
	ADC_INPUTCTRL_MUXNEG_AIN2 = 0x2
	// ADC AIN3 Pin
	ADC_INPUTCTRL_MUXNEG_AIN3 = 0x3
	// ADC AIN4 Pin
	ADC_INPUTCTRL_MUXNEG_AIN4 = 0x4
	// ADC AIN5 Pin
	ADC_INPUTCTRL_MUXNEG_AIN5 = 0x5
	// ADC AIN6 Pin
	ADC_INPUTCTRL_MUXNEG_AIN6 = 0x6
	// ADC AIN7 Pin
	ADC_INPUTCTRL_MUXNEG_AIN7 = 0x7

	// CTRLC: Control C
	// Position of DIFFMODE field.
	ADC_CTRLC_DIFFMODE_Pos = 0x0
	// Bit mask of DIFFMODE field.
	ADC_CTRLC_DIFFMODE_Msk = 0x1
	// Bit DIFFMODE.
	ADC_CTRLC_DIFFMODE = 0x1
	// Position of LEFTADJ field.
	ADC_CTRLC_LEFTADJ_Pos = 0x1
	// Bit mask of LEFTADJ field.
	ADC_CTRLC_LEFTADJ_Msk = 0x2
	// Bit LEFTADJ.
	ADC_CTRLC_LEFTADJ = 0x2
	// Position of FREERUN field.
	ADC_CTRLC_FREERUN_Pos = 0x2
	// Bit mask of FREERUN field.
	ADC_CTRLC_FREERUN_Msk = 0x4
	// Bit FREERUN.
	ADC_CTRLC_FREERUN = 0x4
	// Position of CORREN field.
	ADC_CTRLC_CORREN_Pos = 0x3
	// Bit mask of CORREN field.
	ADC_CTRLC_CORREN_Msk = 0x8
	// Bit CORREN.
	ADC_CTRLC_CORREN = 0x8
	// Position of RESSEL field.
	ADC_CTRLC_RESSEL_Pos = 0x4
	// Bit mask of RESSEL field.
	ADC_CTRLC_RESSEL_Msk = 0x30
	// 12-bit result
	ADC_CTRLC_RESSEL_12BIT = 0x0
	// For averaging mode output
	ADC_CTRLC_RESSEL_16BIT = 0x1
	// 10-bit result
	ADC_CTRLC_RESSEL_10BIT = 0x2
	// 8-bit result
	ADC_CTRLC_RESSEL_8BIT = 0x3
	// Position of R2R field.
	ADC_CTRLC_R2R_Pos = 0x7
	// Bit mask of R2R field.
	ADC_CTRLC_R2R_Msk = 0x80
	// Bit R2R.
	ADC_CTRLC_R2R = 0x80
	// Position of WINMODE field.
	ADC_CTRLC_WINMODE_Pos = 0x8
	// Bit mask of WINMODE field.
	ADC_CTRLC_WINMODE_Msk = 0x700
	// No window mode (default)
	ADC_CTRLC_WINMODE_DISABLE = 0x0
	// RESULT > WINLT
	ADC_CTRLC_WINMODE_MODE1 = 0x1
	// RESULT < WINUT
	ADC_CTRLC_WINMODE_MODE2 = 0x2
	// WINLT < RESULT < WINUT
	ADC_CTRLC_WINMODE_MODE3 = 0x3
	// !(WINLT < RESULT < WINUT)
	ADC_CTRLC_WINMODE_MODE4 = 0x4
	// Position of DUALSEL field.
	ADC_CTRLC_DUALSEL_Pos = 0xc
	// Bit mask of DUALSEL field.
	ADC_CTRLC_DUALSEL_Msk = 0x3000
	// Start event or software trigger will start a conversion on both ADCs
	ADC_CTRLC_DUALSEL_BOTH = 0x0
	// START event or software trigger will alternatingly start a conversion on ADC0 and ADC1
	ADC_CTRLC_DUALSEL_INTERLEAVE = 0x1

	// AVGCTRL: Average Control
	// Position of SAMPLENUM field.
	ADC_AVGCTRL_SAMPLENUM_Pos = 0x0
	// Bit mask of SAMPLENUM field.
	ADC_AVGCTRL_SAMPLENUM_Msk = 0xf
	// 1 sample
	ADC_AVGCTRL_SAMPLENUM_1 = 0x0
	// 2 samples
	ADC_AVGCTRL_SAMPLENUM_2 = 0x1
	// 4 samples
	ADC_AVGCTRL_SAMPLENUM_4 = 0x2
	// 8 samples
	ADC_AVGCTRL_SAMPLENUM_8 = 0x3
	// 16 samples
	ADC_AVGCTRL_SAMPLENUM_16 = 0x4
	// 32 samples
	ADC_AVGCTRL_SAMPLENUM_32 = 0x5
	// 64 samples
	ADC_AVGCTRL_SAMPLENUM_64 = 0x6
	// 128 samples
	ADC_AVGCTRL_SAMPLENUM_128 = 0x7
	// 256 samples
	ADC_AVGCTRL_SAMPLENUM_256 = 0x8
	// 512 samples
	ADC_AVGCTRL_SAMPLENUM_512 = 0x9
	// 1024 samples
	ADC_AVGCTRL_SAMPLENUM_1024 = 0xa
	// Position of ADJRES field.
	ADC_AVGCTRL_ADJRES_Pos = 0x4
	// Bit mask of ADJRES field.
	ADC_AVGCTRL_ADJRES_Msk = 0x70

	// SAMPCTRL: Sample Time Control
	// Position of SAMPLEN field.
	ADC_SAMPCTRL_SAMPLEN_Pos = 0x0
	// Bit mask of SAMPLEN field.
	ADC_SAMPCTRL_SAMPLEN_Msk = 0x3f
	// Position of OFFCOMP field.
	ADC_SAMPCTRL_OFFCOMP_Pos = 0x7
	// Bit mask of OFFCOMP field.
	ADC_SAMPCTRL_OFFCOMP_Msk = 0x80
	// Bit OFFCOMP.
	ADC_SAMPCTRL_OFFCOMP = 0x80

	// WINLT: Window Monitor Lower Threshold
	// Position of WINLT field.
	ADC_WINLT_WINLT_Pos = 0x0
	// Bit mask of WINLT field.
	ADC_WINLT_WINLT_Msk = 0xffff

	// WINUT: Window Monitor Upper Threshold
	// Position of WINUT field.
	ADC_WINUT_WINUT_Pos = 0x0
	// Bit mask of WINUT field.
	ADC_WINUT_WINUT_Msk = 0xffff

	// GAINCORR: Gain Correction
	// Position of GAINCORR field.
	ADC_GAINCORR_GAINCORR_Pos = 0x0
	// Bit mask of GAINCORR field.
	ADC_GAINCORR_GAINCORR_Msk = 0xfff

	// OFFSETCORR: Offset Correction
	// Position of OFFSETCORR field.
	ADC_OFFSETCORR_OFFSETCORR_Pos = 0x0
	// Bit mask of OFFSETCORR field.
	ADC_OFFSETCORR_OFFSETCORR_Msk = 0xfff

	// SWTRIG: Software Trigger
	// Position of FLUSH field.
	ADC_SWTRIG_FLUSH_Pos = 0x0
	// Bit mask of FLUSH field.
	ADC_SWTRIG_FLUSH_Msk = 0x1
	// Bit FLUSH.
	ADC_SWTRIG_FLUSH = 0x1
	// Position of START field.
	ADC_SWTRIG_START_Pos = 0x1
	// Bit mask of START field.
	ADC_SWTRIG_START_Msk = 0x2
	// Bit START.
	ADC_SWTRIG_START = 0x2

	// DBGCTRL: Debug Control
	// Position of DBGRUN field.
	ADC_DBGCTRL_DBGRUN_Pos = 0x0
	// Bit mask of DBGRUN field.
	ADC_DBGCTRL_DBGRUN_Msk = 0x1
	// Bit DBGRUN.
	ADC_DBGCTRL_DBGRUN = 0x1

	// SYNCBUSY: Synchronization Busy
	// Position of SWRST field.
	ADC_SYNCBUSY_SWRST_Pos = 0x0
	// Bit mask of SWRST field.
	ADC_SYNCBUSY_SWRST_Msk = 0x1
	// Bit SWRST.
	ADC_SYNCBUSY_SWRST = 0x1
	// Position of ENABLE field.
	ADC_SYNCBUSY_ENABLE_Pos = 0x1
	// Bit mask of ENABLE field.
	ADC_SYNCBUSY_ENABLE_Msk = 0x2
	// Bit ENABLE.
	ADC_SYNCBUSY_ENABLE = 0x2
	// Position of INPUTCTRL field.
	ADC_SYNCBUSY_INPUTCTRL_Pos = 0x2
	// Bit mask of INPUTCTRL field.
	ADC_SYNCBUSY_INPUTCTRL_Msk = 0x4
	// Bit INPUTCTRL.
	ADC_SYNCBUSY_INPUTCTRL = 0x4
	// Position of CTRLC field.
	ADC_SYNCBUSY_CTRLC_Pos = 0x3
	// Bit mask of CTRLC field.
	ADC_SYNCBUSY_CTRLC_Msk = 0x8
	// Bit CTRLC.
	ADC_SYNCBUSY_CTRLC = 0x8
	// Position of AVGCTRL field.
	ADC_SYNCBUSY_AVGCTRL_Pos = 0x4
	// Bit mask of AVGCTRL field.
	ADC_SYNCBUSY_AVGCTRL_Msk = 0x10
	// Bit AVGCTRL.
	ADC_SYNCBUSY_AVGCTRL = 0x10
	// Position of SAMPCTRL field.
	ADC_SYNCBUSY_SAMPCTRL_Pos = 0x5
	// Bit mask of SAMPCTRL field.
	ADC_SYNCBUSY_SAMPCTRL_Msk = 0x20
	// Bit SAMPCTRL.
	ADC_SYNCBUSY_SAMPCTRL = 0x20
	// Position of WINLT field.
	ADC_SYNCBUSY_WINLT_Pos = 0x6
	// Bit mask of WINLT field.
	ADC_SYNCBUSY_WINLT_Msk = 0x40
	// Bit WINLT.
	ADC_SYNCBUSY_WINLT = 0x40
	// Position of WINUT field.
	ADC_SYNCBUSY_WINUT_Pos = 0x7
	// Bit mask of WINUT field.
	ADC_SYNCBUSY_WINUT_Msk = 0x80
	// Bit WINUT.
	ADC_SYNCBUSY_WINUT = 0x80
	// Position of GAINCORR field.
	ADC_SYNCBUSY_GAINCORR_Pos = 0x8
	// Bit mask of GAINCORR field.
	ADC_SYNCBUSY_GAINCORR_Msk = 0x100
	// Bit GAINCORR.
	ADC_SYNCBUSY_GAINCORR = 0x100
	// Position of OFFSETCORR field.
	ADC_SYNCBUSY_OFFSETCORR_Pos = 0x9
	// Bit mask of OFFSETCORR field.
	ADC_SYNCBUSY_OFFSETCORR_Msk = 0x200
	// Bit OFFSETCORR.
	ADC_SYNCBUSY_OFFSETCORR = 0x200
	// Position of SWTRIG field.
	ADC_SYNCBUSY_SWTRIG_Pos = 0xa
	// Bit mask of SWTRIG field.
	ADC_SYNCBUSY_SWTRIG_Msk = 0x400
	// Bit SWTRIG.
	ADC_SYNCBUSY_SWTRIG = 0x400

	// RESULT: Result
	// Position of RESULT field.
	ADC_RESULT_RESULT_Pos = 0x0
	// Bit mask of RESULT field.
	ADC_RESULT_RESULT_Msk = 0xffff

	// SEQCTRL: Sequence Control
	// Position of SEQEN field.
	ADC_SEQCTRL_SEQEN_Pos = 0x0
	// Bit mask of SEQEN field.
	ADC_SEQCTRL_SEQEN_Msk = 0xffffffff

	// CALIB: Calibration
	// Position of BIASCOMP field.
	ADC_CALIB_BIASCOMP_Pos = 0x0
	// Bit mask of BIASCOMP field.
	ADC_CALIB_BIASCOMP_Msk = 0x7
	// Position of BIASREFBUF field.
	ADC_CALIB_BIASREFBUF_Pos = 0x8
	// Bit mask of BIASREFBUF field.
	ADC_CALIB_BIASREFBUF_Msk = 0x700
)

// Constants for AES: Advanced Encryption Standard
const (
	// CTRLA: Control A
	// Position of SWRST field.
	AES_CTRLA_SWRST_Pos = 0x0
	// Bit mask of SWRST field.
	AES_CTRLA_SWRST_Msk = 0x1
	// Bit SWRST.
	AES_CTRLA_SWRST = 0x1
	// Position of ENABLE field.
	AES_CTRLA_ENABLE_Pos = 0x1
	// Bit mask of ENABLE field.
	AES_CTRLA_ENABLE_Msk = 0x2
	// Bit ENABLE.
	AES_CTRLA_ENABLE = 0x2
	// Position of AESMODE field.
	AES_CTRLA_AESMODE_Pos = 0x2
	// Bit mask of AESMODE field.
	AES_CTRLA_AESMODE_Msk = 0x1c
	// Position of CFBS field.
	AES_CTRLA_CFBS_Pos = 0x5
	// Bit mask of CFBS field.
	AES_CTRLA_CFBS_Msk = 0xe0
	// Position of KEYSIZE field.
	AES_CTRLA_KEYSIZE_Pos = 0x8
	// Bit mask of KEYSIZE field.
	AES_CTRLA_KEYSIZE_Msk = 0x300
	// Position of CIPHER field.
	AES_CTRLA_CIPHER_Pos = 0xa
	// Bit mask of CIPHER field.
	AES_CTRLA_CIPHER_Msk = 0x400
	// Bit CIPHER.
	AES_CTRLA_CIPHER = 0x400
	// Position of STARTMODE field.
	AES_CTRLA_STARTMODE_Pos = 0xb
	// Bit mask of STARTMODE field.
	AES_CTRLA_STARTMODE_Msk = 0x800
	// Bit STARTMODE.
	AES_CTRLA_STARTMODE = 0x800
	// Position of LOD field.
	AES_CTRLA_LOD_Pos = 0xc
	// Bit mask of LOD field.
	AES_CTRLA_LOD_Msk = 0x1000
	// Bit LOD.
	AES_CTRLA_LOD = 0x1000
	// Position of KEYGEN field.
	AES_CTRLA_KEYGEN_Pos = 0xd
	// Bit mask of KEYGEN field.
	AES_CTRLA_KEYGEN_Msk = 0x2000
	// Bit KEYGEN.
	AES_CTRLA_KEYGEN = 0x2000
	// Position of XORKEY field.
	AES_CTRLA_XORKEY_Pos = 0xe
	// Bit mask of XORKEY field.
	AES_CTRLA_XORKEY_Msk = 0x4000
	// Bit XORKEY.
	AES_CTRLA_XORKEY = 0x4000
	// Position of CTYPE field.
	AES_CTRLA_CTYPE_Pos = 0x10
	// Bit mask of CTYPE field.
	AES_CTRLA_CTYPE_Msk = 0xf0000

	// CTRLB: Control B
	// Position of START field.
	AES_CTRLB_START_Pos = 0x0
	// Bit mask of START field.
	AES_CTRLB_START_Msk = 0x1
	// Bit START.
	AES_CTRLB_START = 0x1
	// Position of NEWMSG field.
	AES_CTRLB_NEWMSG_Pos = 0x1
	// Bit mask of NEWMSG field.
	AES_CTRLB_NEWMSG_Msk = 0x2
	// Bit NEWMSG.
	AES_CTRLB_NEWMSG = 0x2
	// Position of EOM field.
	AES_CTRLB_EOM_Pos = 0x2
	// Bit mask of EOM field.
	AES_CTRLB_EOM_Msk = 0x4
	// Bit EOM.
	AES_CTRLB_EOM = 0x4
	// Position of GFMUL field.
	AES_CTRLB_GFMUL_Pos = 0x3
	// Bit mask of GFMUL field.
	AES_CTRLB_GFMUL_Msk = 0x8
	// Bit GFMUL.
	AES_CTRLB_GFMUL = 0x8

	// INTENCLR: Interrupt Enable Clear
	// Position of ENCCMP field.
	AES_INTENCLR_ENCCMP_Pos = 0x0
	// Bit mask of ENCCMP field.
	AES_INTENCLR_ENCCMP_Msk = 0x1
	// Bit ENCCMP.
	AES_INTENCLR_ENCCMP = 0x1
	// Position of GFMCMP field.
	AES_INTENCLR_GFMCMP_Pos = 0x1
	// Bit mask of GFMCMP field.
	AES_INTENCLR_GFMCMP_Msk = 0x2
	// Bit GFMCMP.
	AES_INTENCLR_GFMCMP = 0x2

	// INTENSET: Interrupt Enable Set
	// Position of ENCCMP field.
	AES_INTENSET_ENCCMP_Pos = 0x0
	// Bit mask of ENCCMP field.
	AES_INTENSET_ENCCMP_Msk = 0x1
	// Bit ENCCMP.
	AES_INTENSET_ENCCMP = 0x1
	// Position of GFMCMP field.
	AES_INTENSET_GFMCMP_Pos = 0x1
	// Bit mask of GFMCMP field.
	AES_INTENSET_GFMCMP_Msk = 0x2
	// Bit GFMCMP.
	AES_INTENSET_GFMCMP = 0x2

	// INTFLAG: Interrupt Flag Status
	// Position of ENCCMP field.
	AES_INTFLAG_ENCCMP_Pos = 0x0
	// Bit mask of ENCCMP field.
	AES_INTFLAG_ENCCMP_Msk = 0x1
	// Bit ENCCMP.
	AES_INTFLAG_ENCCMP = 0x1
	// Position of GFMCMP field.
	AES_INTFLAG_GFMCMP_Pos = 0x1
	// Bit mask of GFMCMP field.
	AES_INTFLAG_GFMCMP_Msk = 0x2
	// Bit GFMCMP.
	AES_INTFLAG_GFMCMP = 0x2

	// DATABUFPTR: Data buffer pointer
	// Position of INDATAPTR field.
	AES_DATABUFPTR_INDATAPTR_Pos = 0x0
	// Bit mask of INDATAPTR field.
	AES_DATABUFPTR_INDATAPTR_Msk = 0x3

	// DBGCTRL: Debug control
	// Position of DBGRUN field.
	AES_DBGCTRL_DBGRUN_Pos = 0x0
	// Bit mask of DBGRUN field.
	AES_DBGCTRL_DBGRUN_Msk = 0x1
	// Bit DBGRUN.
	AES_DBGCTRL_DBGRUN = 0x1
)

// Constants for CCL: Configurable Custom Logic
const (
	// CTRL: Control
	// Position of SWRST field.
	CCL_CTRL_SWRST_Pos = 0x0
	// Bit mask of SWRST field.
	CCL_CTRL_SWRST_Msk = 0x1
	// Bit SWRST.
	CCL_CTRL_SWRST = 0x1
	// Position of ENABLE field.
	CCL_CTRL_ENABLE_Pos = 0x1
	// Bit mask of ENABLE field.
	CCL_CTRL_ENABLE_Msk = 0x2
	// Bit ENABLE.
	CCL_CTRL_ENABLE = 0x2
	// Position of RUNSTDBY field.
	CCL_CTRL_RUNSTDBY_Pos = 0x6
	// Bit mask of RUNSTDBY field.
	CCL_CTRL_RUNSTDBY_Msk = 0x40
	// Bit RUNSTDBY.
	CCL_CTRL_RUNSTDBY = 0x40

	// SEQCTRL0: SEQ Control x
	// Position of SEQSEL field.
	CCL_SEQCTRL_SEQSEL_Pos = 0x0
	// Bit mask of SEQSEL field.
	CCL_SEQCTRL_SEQSEL_Msk = 0xf
	// Sequential logic is disabled
	CCL_SEQCTRL_SEQSEL_DISABLE = 0x0
	// D flip flop
	CCL_SEQCTRL_SEQSEL_DFF = 0x1
	// JK flip flop
	CCL_SEQCTRL_SEQSEL_JK = 0x2
	// D latch
	CCL_SEQCTRL_SEQSEL_LATCH = 0x3
	// RS latch
	CCL_SEQCTRL_SEQSEL_RS = 0x4

	// LUTCTRL0: LUT Control x
	// Position of ENABLE field.
	CCL_LUTCTRL_ENABLE_Pos = 0x1
	// Bit mask of ENABLE field.
	CCL_LUTCTRL_ENABLE_Msk = 0x2
	// Bit ENABLE.
	CCL_LUTCTRL_ENABLE = 0x2
	// Position of FILTSEL field.
	CCL_LUTCTRL_FILTSEL_Pos = 0x4
	// Bit mask of FILTSEL field.
	CCL_LUTCTRL_FILTSEL_Msk = 0x30
	// Filter disabled
	CCL_LUTCTRL_FILTSEL_DISABLE = 0x0
	// Synchronizer enabled
	CCL_LUTCTRL_FILTSEL_SYNCH = 0x1
	// Filter enabled
	CCL_LUTCTRL_FILTSEL_FILTER = 0x2
	// Position of EDGESEL field.
	CCL_LUTCTRL_EDGESEL_Pos = 0x7
	// Bit mask of EDGESEL field.
	CCL_LUTCTRL_EDGESEL_Msk = 0x80
	// Bit EDGESEL.
	CCL_LUTCTRL_EDGESEL = 0x80
	// Position of INSEL0 field.
	CCL_LUTCTRL_INSEL0_Pos = 0x8
	// Bit mask of INSEL0 field.
	CCL_LUTCTRL_INSEL0_Msk = 0xf00
	// Masked input
	CCL_LUTCTRL_INSEL0_MASK = 0x0
	// Feedback input source
	CCL_LUTCTRL_INSEL0_FEEDBACK = 0x1
	// Linked LUT input source
	CCL_LUTCTRL_INSEL0_LINK = 0x2
	// Event in put source
	CCL_LUTCTRL_INSEL0_EVENT = 0x3
	// I/O pin input source
	CCL_LUTCTRL_INSEL0_IO = 0x4
	// AC input source
	CCL_LUTCTRL_INSEL0_AC = 0x5
	// TC input source
	CCL_LUTCTRL_INSEL0_TC = 0x6
	// Alternate TC input source
	CCL_LUTCTRL_INSEL0_ALTTC = 0x7
	// TCC input source
	CCL_LUTCTRL_INSEL0_TCC = 0x8
	// SERCOM inout source
	CCL_LUTCTRL_INSEL0_SERCOM = 0x9
	// Position of INSEL1 field.
	CCL_LUTCTRL_INSEL1_Pos = 0xc
	// Bit mask of INSEL1 field.
	CCL_LUTCTRL_INSEL1_Msk = 0xf000
	// Position of INSEL2 field.
	CCL_LUTCTRL_INSEL2_Pos = 0x10
	// Bit mask of INSEL2 field.
	CCL_LUTCTRL_INSEL2_Msk = 0xf0000
	// Position of INVEI field.
	CCL_LUTCTRL_INVEI_Pos = 0x14
	// Bit mask of INVEI field.
	CCL_LUTCTRL_INVEI_Msk = 0x100000
	// Bit INVEI.
	CCL_LUTCTRL_INVEI = 0x100000
	// Position of LUTEI field.
	CCL_LUTCTRL_LUTEI_Pos = 0x15
	// Bit mask of LUTEI field.
	CCL_LUTCTRL_LUTEI_Msk = 0x200000
	// Bit LUTEI.
	CCL_LUTCTRL_LUTEI = 0x200000
	// Position of LUTEO field.
	CCL_LUTCTRL_LUTEO_Pos = 0x16
	// Bit mask of LUTEO field.
	CCL_LUTCTRL_LUTEO_Msk = 0x400000
	// Bit LUTEO.
	CCL_LUTCTRL_LUTEO = 0x400000
	// Position of TRUTH field.
	CCL_LUTCTRL_TRUTH_Pos = 0x18
	// Bit mask of TRUTH field.
	CCL_LUTCTRL_TRUTH_Msk = 0xff000000
)

// Constants for DMAC: Direct Memory Access Controller
const (
	// CTRL: Control
	// Position of SWRST field.
	DMAC_CTRL_SWRST_Pos = 0x0
	// Bit mask of SWRST field.
	DMAC_CTRL_SWRST_Msk = 0x1
	// Bit SWRST.
	DMAC_CTRL_SWRST = 0x1
	// Position of DMAENABLE field.
	DMAC_CTRL_DMAENABLE_Pos = 0x1
	// Bit mask of DMAENABLE field.
	DMAC_CTRL_DMAENABLE_Msk = 0x2
	// Bit DMAENABLE.
	DMAC_CTRL_DMAENABLE = 0x2
	// Position of CRCENABLE field.
	DMAC_CTRL_CRCENABLE_Pos = 0x2
	// Bit mask of CRCENABLE field.
	DMAC_CTRL_CRCENABLE_Msk = 0x4
	// Bit CRCENABLE.
	DMAC_CTRL_CRCENABLE = 0x4
	// Position of LVLEN0 field.
	DMAC_CTRL_LVLEN0_Pos = 0x8
	// Bit mask of LVLEN0 field.
	DMAC_CTRL_LVLEN0_Msk = 0x100
	// Bit LVLEN0.
	DMAC_CTRL_LVLEN0 = 0x100
	// Position of LVLEN1 field.
	DMAC_CTRL_LVLEN1_Pos = 0x9
	// Bit mask of LVLEN1 field.
	DMAC_CTRL_LVLEN1_Msk = 0x200
	// Bit LVLEN1.
	DMAC_CTRL_LVLEN1 = 0x200
	// Position of LVLEN2 field.
	DMAC_CTRL_LVLEN2_Pos = 0xa
	// Bit mask of LVLEN2 field.
	DMAC_CTRL_LVLEN2_Msk = 0x400
	// Bit LVLEN2.
	DMAC_CTRL_LVLEN2 = 0x400
	// Position of LVLEN3 field.
	DMAC_CTRL_LVLEN3_Pos = 0xb
	// Bit mask of LVLEN3 field.
	DMAC_CTRL_LVLEN3_Msk = 0x800
	// Bit LVLEN3.
	DMAC_CTRL_LVLEN3 = 0x800

	// CRCCTRL: CRC Control
	// Position of CRCBEATSIZE field.
	DMAC_CRCCTRL_CRCBEATSIZE_Pos = 0x0
	// Bit mask of CRCBEATSIZE field.
	DMAC_CRCCTRL_CRCBEATSIZE_Msk = 0x3
	// 8-bit bus transfer
	DMAC_CRCCTRL_CRCBEATSIZE_BYTE = 0x0
	// 16-bit bus transfer
	DMAC_CRCCTRL_CRCBEATSIZE_HWORD = 0x1
	// 32-bit bus transfer
	DMAC_CRCCTRL_CRCBEATSIZE_WORD = 0x2
	// Position of CRCPOLY field.
	DMAC_CRCCTRL_CRCPOLY_Pos = 0x2
	// Bit mask of CRCPOLY field.
	DMAC_CRCCTRL_CRCPOLY_Msk = 0xc
	// CRC-16 (CRC-CCITT)
	DMAC_CRCCTRL_CRCPOLY_CRC16 = 0x0
	// CRC32 (IEEE 802.3)
	DMAC_CRCCTRL_CRCPOLY_CRC32 = 0x1
	// Position of CRCSRC field.
	DMAC_CRCCTRL_CRCSRC_Pos = 0x8
	// Bit mask of CRCSRC field.
	DMAC_CRCCTRL_CRCSRC_Msk = 0x3f00
	// No action
	DMAC_CRCCTRL_CRCSRC_NOACT = 0x0
	// I/O interface
	DMAC_CRCCTRL_CRCSRC_IO = 0x1

	// CRCDATAIN: CRC Data Input
	// Position of CRCDATAIN field.
	DMAC_CRCDATAIN_CRCDATAIN_Pos = 0x0
	// Bit mask of CRCDATAIN field.
	DMAC_CRCDATAIN_CRCDATAIN_Msk = 0xffffffff

	// CRCCHKSUM: CRC Checksum
	// Position of CRCCHKSUM field.
	DMAC_CRCCHKSUM_CRCCHKSUM_Pos = 0x0
	// Bit mask of CRCCHKSUM field.
	DMAC_CRCCHKSUM_CRCCHKSUM_Msk = 0xffffffff

	// CRCSTATUS: CRC Status
	// Position of CRCBUSY field.
	DMAC_CRCSTATUS_CRCBUSY_Pos = 0x0
	// Bit mask of CRCBUSY field.
	DMAC_CRCSTATUS_CRCBUSY_Msk = 0x1
	// Bit CRCBUSY.
	DMAC_CRCSTATUS_CRCBUSY = 0x1
	// Position of CRCZERO field.
	DMAC_CRCSTATUS_CRCZERO_Pos = 0x1
	// Bit mask of CRCZERO field.
	DMAC_CRCSTATUS_CRCZERO_Msk = 0x2
	// Bit CRCZERO.
	DMAC_CRCSTATUS_CRCZERO = 0x2

	// DBGCTRL: Debug Control
	// Position of DBGRUN field.
	DMAC_DBGCTRL_DBGRUN_Pos = 0x0
	// Bit mask of DBGRUN field.
	DMAC_DBGCTRL_DBGRUN_Msk = 0x1
	// Bit DBGRUN.
	DMAC_DBGCTRL_DBGRUN = 0x1

	// QOSCTRL: QOS Control
	// Position of WRBQOS field.
	DMAC_QOSCTRL_WRBQOS_Pos = 0x0
	// Bit mask of WRBQOS field.
	DMAC_QOSCTRL_WRBQOS_Msk = 0x3
	// Background (no sensitive operation)
	DMAC_QOSCTRL_WRBQOS_DISABLE = 0x0
	// Sensitive Bandwidth
	DMAC_QOSCTRL_WRBQOS_LOW = 0x1
	// Sensitive Latency
	DMAC_QOSCTRL_WRBQOS_MEDIUM = 0x2
	// Critical Latency
	DMAC_QOSCTRL_WRBQOS_HIGH = 0x3
	// Position of FQOS field.
	DMAC_QOSCTRL_FQOS_Pos = 0x2
	// Bit mask of FQOS field.
	DMAC_QOSCTRL_FQOS_Msk = 0xc
	// Background (no sensitive operation)
	DMAC_QOSCTRL_FQOS_DISABLE = 0x0
	// Sensitive Bandwidth
	DMAC_QOSCTRL_FQOS_LOW = 0x1
	// Sensitive Latency
	DMAC_QOSCTRL_FQOS_MEDIUM = 0x2
	// Critical Latency
	DMAC_QOSCTRL_FQOS_HIGH = 0x3
	// Position of DQOS field.
	DMAC_QOSCTRL_DQOS_Pos = 0x4
	// Bit mask of DQOS field.
	DMAC_QOSCTRL_DQOS_Msk = 0x30
	// Background (no sensitive operation)
	DMAC_QOSCTRL_DQOS_DISABLE = 0x0
	// Sensitive Bandwidth
	DMAC_QOSCTRL_DQOS_LOW = 0x1
	// Sensitive Latency
	DMAC_QOSCTRL_DQOS_MEDIUM = 0x2
	// Critical Latency
	DMAC_QOSCTRL_DQOS_HIGH = 0x3

	// SWTRIGCTRL: Software Trigger Control
	// Position of SWTRIG0 field.
	DMAC_SWTRIGCTRL_SWTRIG0_Pos = 0x0
	// Bit mask of SWTRIG0 field.
	DMAC_SWTRIGCTRL_SWTRIG0_Msk = 0x1
	// Bit SWTRIG0.
	DMAC_SWTRIGCTRL_SWTRIG0 = 0x1
	// Position of SWTRIG1 field.
	DMAC_SWTRIGCTRL_SWTRIG1_Pos = 0x1
	// Bit mask of SWTRIG1 field.
	DMAC_SWTRIGCTRL_SWTRIG1_Msk = 0x2
	// Bit SWTRIG1.
	DMAC_SWTRIGCTRL_SWTRIG1 = 0x2
	// Position of SWTRIG2 field.
	DMAC_SWTRIGCTRL_SWTRIG2_Pos = 0x2
	// Bit mask of SWTRIG2 field.
	DMAC_SWTRIGCTRL_SWTRIG2_Msk = 0x4
	// Bit SWTRIG2.
	DMAC_SWTRIGCTRL_SWTRIG2 = 0x4
	// Position of SWTRIG3 field.
	DMAC_SWTRIGCTRL_SWTRIG3_Pos = 0x3
	// Bit mask of SWTRIG3 field.
	DMAC_SWTRIGCTRL_SWTRIG3_Msk = 0x8
	// Bit SWTRIG3.
	DMAC_SWTRIGCTRL_SWTRIG3 = 0x8
	// Position of SWTRIG4 field.
	DMAC_SWTRIGCTRL_SWTRIG4_Pos = 0x4
	// Bit mask of SWTRIG4 field.
	DMAC_SWTRIGCTRL_SWTRIG4_Msk = 0x10
	// Bit SWTRIG4.
	DMAC_SWTRIGCTRL_SWTRIG4 = 0x10
	// Position of SWTRIG5 field.
	DMAC_SWTRIGCTRL_SWTRIG5_Pos = 0x5
	// Bit mask of SWTRIG5 field.
	DMAC_SWTRIGCTRL_SWTRIG5_Msk = 0x20
	// Bit SWTRIG5.
	DMAC_SWTRIGCTRL_SWTRIG5 = 0x20
	// Position of SWTRIG6 field.
	DMAC_SWTRIGCTRL_SWTRIG6_Pos = 0x6
	// Bit mask of SWTRIG6 field.
	DMAC_SWTRIGCTRL_SWTRIG6_Msk = 0x40
	// Bit SWTRIG6.
	DMAC_SWTRIGCTRL_SWTRIG6 = 0x40
	// Position of SWTRIG7 field.
	DMAC_SWTRIGCTRL_SWTRIG7_Pos = 0x7
	// Bit mask of SWTRIG7 field.
	DMAC_SWTRIGCTRL_SWTRIG7_Msk = 0x80
	// Bit SWTRIG7.
	DMAC_SWTRIGCTRL_SWTRIG7 = 0x80
	// Position of SWTRIG8 field.
	DMAC_SWTRIGCTRL_SWTRIG8_Pos = 0x8
	// Bit mask of SWTRIG8 field.
	DMAC_SWTRIGCTRL_SWTRIG8_Msk = 0x100
	// Bit SWTRIG8.
	DMAC_SWTRIGCTRL_SWTRIG8 = 0x100
	// Position of SWTRIG9 field.
	DMAC_SWTRIGCTRL_SWTRIG9_Pos = 0x9
	// Bit mask of SWTRIG9 field.
	DMAC_SWTRIGCTRL_SWTRIG9_Msk = 0x200
	// Bit SWTRIG9.
	DMAC_SWTRIGCTRL_SWTRIG9 = 0x200
	// Position of SWTRIG10 field.
	DMAC_SWTRIGCTRL_SWTRIG10_Pos = 0xa
	// Bit mask of SWTRIG10 field.
	DMAC_SWTRIGCTRL_SWTRIG10_Msk = 0x400
	// Bit SWTRIG10.
	DMAC_SWTRIGCTRL_SWTRIG10 = 0x400
	// Position of SWTRIG11 field.
	DMAC_SWTRIGCTRL_SWTRIG11_Pos = 0xb
	// Bit mask of SWTRIG11 field.
	DMAC_SWTRIGCTRL_SWTRIG11_Msk = 0x800
	// Bit SWTRIG11.
	DMAC_SWTRIGCTRL_SWTRIG11 = 0x800
	// Position of SWTRIG12 field.
	DMAC_SWTRIGCTRL_SWTRIG12_Pos = 0xc
	// Bit mask of SWTRIG12 field.
	DMAC_SWTRIGCTRL_SWTRIG12_Msk = 0x1000
	// Bit SWTRIG12.
	DMAC_SWTRIGCTRL_SWTRIG12 = 0x1000
	// Position of SWTRIG13 field.
	DMAC_SWTRIGCTRL_SWTRIG13_Pos = 0xd
	// Bit mask of SWTRIG13 field.
	DMAC_SWTRIGCTRL_SWTRIG13_Msk = 0x2000
	// Bit SWTRIG13.
	DMAC_SWTRIGCTRL_SWTRIG13 = 0x2000
	// Position of SWTRIG14 field.
	DMAC_SWTRIGCTRL_SWTRIG14_Pos = 0xe
	// Bit mask of SWTRIG14 field.
	DMAC_SWTRIGCTRL_SWTRIG14_Msk = 0x4000
	// Bit SWTRIG14.
	DMAC_SWTRIGCTRL_SWTRIG14 = 0x4000
	// Position of SWTRIG15 field.
	DMAC_SWTRIGCTRL_SWTRIG15_Pos = 0xf
	// Bit mask of SWTRIG15 field.
	DMAC_SWTRIGCTRL_SWTRIG15_Msk = 0x8000
	// Bit SWTRIG15.
	DMAC_SWTRIGCTRL_SWTRIG15 = 0x8000

	// PRICTRL0: Priority Control 0
	// Position of LVLPRI0 field.
	DMAC_PRICTRL0_LVLPRI0_Pos = 0x0
	// Bit mask of LVLPRI0 field.
	DMAC_PRICTRL0_LVLPRI0_Msk = 0xf
	// Position of RRLVLEN0 field.
	DMAC_PRICTRL0_RRLVLEN0_Pos = 0x7
	// Bit mask of RRLVLEN0 field.
	DMAC_PRICTRL0_RRLVLEN0_Msk = 0x80
	// Bit RRLVLEN0.
	DMAC_PRICTRL0_RRLVLEN0 = 0x80
	// Position of LVLPRI1 field.
	DMAC_PRICTRL0_LVLPRI1_Pos = 0x8
	// Bit mask of LVLPRI1 field.
	DMAC_PRICTRL0_LVLPRI1_Msk = 0xf00
	// Position of RRLVLEN1 field.
	DMAC_PRICTRL0_RRLVLEN1_Pos = 0xf
	// Bit mask of RRLVLEN1 field.
	DMAC_PRICTRL0_RRLVLEN1_Msk = 0x8000
	// Bit RRLVLEN1.
	DMAC_PRICTRL0_RRLVLEN1 = 0x8000
	// Position of LVLPRI2 field.
	DMAC_PRICTRL0_LVLPRI2_Pos = 0x10
	// Bit mask of LVLPRI2 field.
	DMAC_PRICTRL0_LVLPRI2_Msk = 0xf0000
	// Position of RRLVLEN2 field.
	DMAC_PRICTRL0_RRLVLEN2_Pos = 0x17
	// Bit mask of RRLVLEN2 field.
	DMAC_PRICTRL0_RRLVLEN2_Msk = 0x800000
	// Bit RRLVLEN2.
	DMAC_PRICTRL0_RRLVLEN2 = 0x800000
	// Position of LVLPRI3 field.
	DMAC_PRICTRL0_LVLPRI3_Pos = 0x18
	// Bit mask of LVLPRI3 field.
	DMAC_PRICTRL0_LVLPRI3_Msk = 0xf000000
	// Position of RRLVLEN3 field.
	DMAC_PRICTRL0_RRLVLEN3_Pos = 0x1f
	// Bit mask of RRLVLEN3 field.
	DMAC_PRICTRL0_RRLVLEN3_Msk = 0x80000000
	// Bit RRLVLEN3.
	DMAC_PRICTRL0_RRLVLEN3 = 0x80000000

	// INTPEND: Interrupt Pending
	// Position of ID field.
	DMAC_INTPEND_ID_Pos = 0x0
	// Bit mask of ID field.
	DMAC_INTPEND_ID_Msk = 0xf
	// Position of TERR field.
	DMAC_INTPEND_TERR_Pos = 0x8
	// Bit mask of TERR field.
	DMAC_INTPEND_TERR_Msk = 0x100
	// Bit TERR.
	DMAC_INTPEND_TERR = 0x100
	// Position of TCMPL field.
	DMAC_INTPEND_TCMPL_Pos = 0x9
	// Bit mask of TCMPL field.
	DMAC_INTPEND_TCMPL_Msk = 0x200
	// Bit TCMPL.
	DMAC_INTPEND_TCMPL = 0x200
	// Position of SUSP field.
	DMAC_INTPEND_SUSP_Pos = 0xa
	// Bit mask of SUSP field.
	DMAC_INTPEND_SUSP_Msk = 0x400
	// Bit SUSP.
	DMAC_INTPEND_SUSP = 0x400
	// Position of FERR field.
	DMAC_INTPEND_FERR_Pos = 0xd
	// Bit mask of FERR field.
	DMAC_INTPEND_FERR_Msk = 0x2000
	// Bit FERR.
	DMAC_INTPEND_FERR = 0x2000
	// Position of BUSY field.
	DMAC_INTPEND_BUSY_Pos = 0xe
	// Bit mask of BUSY field.
	DMAC_INTPEND_BUSY_Msk = 0x4000
	// Bit BUSY.
	DMAC_INTPEND_BUSY = 0x4000
	// Position of PEND field.
	DMAC_INTPEND_PEND_Pos = 0xf
	// Bit mask of PEND field.
	DMAC_INTPEND_PEND_Msk = 0x8000
	// Bit PEND.
	DMAC_INTPEND_PEND = 0x8000

	// INTSTATUS: Interrupt Status
	// Position of CHINT0 field.
	DMAC_INTSTATUS_CHINT0_Pos = 0x0
	// Bit mask of CHINT0 field.
	DMAC_INTSTATUS_CHINT0_Msk = 0x1
	// Bit CHINT0.
	DMAC_INTSTATUS_CHINT0 = 0x1
	// Position of CHINT1 field.
	DMAC_INTSTATUS_CHINT1_Pos = 0x1
	// Bit mask of CHINT1 field.
	DMAC_INTSTATUS_CHINT1_Msk = 0x2
	// Bit CHINT1.
	DMAC_INTSTATUS_CHINT1 = 0x2
	// Position of CHINT2 field.
	DMAC_INTSTATUS_CHINT2_Pos = 0x2
	// Bit mask of CHINT2 field.
	DMAC_INTSTATUS_CHINT2_Msk = 0x4
	// Bit CHINT2.
	DMAC_INTSTATUS_CHINT2 = 0x4
	// Position of CHINT3 field.
	DMAC_INTSTATUS_CHINT3_Pos = 0x3
	// Bit mask of CHINT3 field.
	DMAC_INTSTATUS_CHINT3_Msk = 0x8
	// Bit CHINT3.
	DMAC_INTSTATUS_CHINT3 = 0x8
	// Position of CHINT4 field.
	DMAC_INTSTATUS_CHINT4_Pos = 0x4
	// Bit mask of CHINT4 field.
	DMAC_INTSTATUS_CHINT4_Msk = 0x10
	// Bit CHINT4.
	DMAC_INTSTATUS_CHINT4 = 0x10
	// Position of CHINT5 field.
	DMAC_INTSTATUS_CHINT5_Pos = 0x5
	// Bit mask of CHINT5 field.
	DMAC_INTSTATUS_CHINT5_Msk = 0x20
	// Bit CHINT5.
	DMAC_INTSTATUS_CHINT5 = 0x20
	// Position of CHINT6 field.
	DMAC_INTSTATUS_CHINT6_Pos = 0x6
	// Bit mask of CHINT6 field.
	DMAC_INTSTATUS_CHINT6_Msk = 0x40
	// Bit CHINT6.
	DMAC_INTSTATUS_CHINT6 = 0x40
	// Position of CHINT7 field.
	DMAC_INTSTATUS_CHINT7_Pos = 0x7
	// Bit mask of CHINT7 field.
	DMAC_INTSTATUS_CHINT7_Msk = 0x80
	// Bit CHINT7.
	DMAC_INTSTATUS_CHINT7 = 0x80
	// Position of CHINT8 field.
	DMAC_INTSTATUS_CHINT8_Pos = 0x8
	// Bit mask of CHINT8 field.
	DMAC_INTSTATUS_CHINT8_Msk = 0x100
	// Bit CHINT8.
	DMAC_INTSTATUS_CHINT8 = 0x100
	// Position of CHINT9 field.
	DMAC_INTSTATUS_CHINT9_Pos = 0x9
	// Bit mask of CHINT9 field.
	DMAC_INTSTATUS_CHINT9_Msk = 0x200
	// Bit CHINT9.
	DMAC_INTSTATUS_CHINT9 = 0x200
	// Position of CHINT10 field.
	DMAC_INTSTATUS_CHINT10_Pos = 0xa
	// Bit mask of CHINT10 field.
	DMAC_INTSTATUS_CHINT10_Msk = 0x400
	// Bit CHINT10.
	DMAC_INTSTATUS_CHINT10 = 0x400
	// Position of CHINT11 field.
	DMAC_INTSTATUS_CHINT11_Pos = 0xb
	// Bit mask of CHINT11 field.
	DMAC_INTSTATUS_CHINT11_Msk = 0x800
	// Bit CHINT11.
	DMAC_INTSTATUS_CHINT11 = 0x800
	// Position of CHINT12 field.
	DMAC_INTSTATUS_CHINT12_Pos = 0xc
	// Bit mask of CHINT12 field.
	DMAC_INTSTATUS_CHINT12_Msk = 0x1000
	// Bit CHINT12.
	DMAC_INTSTATUS_CHINT12 = 0x1000
	// Position of CHINT13 field.
	DMAC_INTSTATUS_CHINT13_Pos = 0xd
	// Bit mask of CHINT13 field.
	DMAC_INTSTATUS_CHINT13_Msk = 0x2000
	// Bit CHINT13.
	DMAC_INTSTATUS_CHINT13 = 0x2000
	// Position of CHINT14 field.
	DMAC_INTSTATUS_CHINT14_Pos = 0xe
	// Bit mask of CHINT14 field.
	DMAC_INTSTATUS_CHINT14_Msk = 0x4000
	// Bit CHINT14.
	DMAC_INTSTATUS_CHINT14 = 0x4000
	// Position of CHINT15 field.
	DMAC_INTSTATUS_CHINT15_Pos = 0xf
	// Bit mask of CHINT15 field.
	DMAC_INTSTATUS_CHINT15_Msk = 0x8000
	// Bit CHINT15.
	DMAC_INTSTATUS_CHINT15 = 0x8000

	// BUSYCH: Busy Channels
	// Position of BUSYCH0 field.
	DMAC_BUSYCH_BUSYCH0_Pos = 0x0
	// Bit mask of BUSYCH0 field.
	DMAC_BUSYCH_BUSYCH0_Msk = 0x1
	// Bit BUSYCH0.
	DMAC_BUSYCH_BUSYCH0 = 0x1
	// Position of BUSYCH1 field.
	DMAC_BUSYCH_BUSYCH1_Pos = 0x1
	// Bit mask of BUSYCH1 field.
	DMAC_BUSYCH_BUSYCH1_Msk = 0x2
	// Bit BUSYCH1.
	DMAC_BUSYCH_BUSYCH1 = 0x2
	// Position of BUSYCH2 field.
	DMAC_BUSYCH_BUSYCH2_Pos = 0x2
	// Bit mask of BUSYCH2 field.
	DMAC_BUSYCH_BUSYCH2_Msk = 0x4
	// Bit BUSYCH2.
	DMAC_BUSYCH_BUSYCH2 = 0x4
	// Position of BUSYCH3 field.
	DMAC_BUSYCH_BUSYCH3_Pos = 0x3
	// Bit mask of BUSYCH3 field.
	DMAC_BUSYCH_BUSYCH3_Msk = 0x8
	// Bit BUSYCH3.
	DMAC_BUSYCH_BUSYCH3 = 0x8
	// Position of BUSYCH4 field.
	DMAC_BUSYCH_BUSYCH4_Pos = 0x4
	// Bit mask of BUSYCH4 field.
	DMAC_BUSYCH_BUSYCH4_Msk = 0x10
	// Bit BUSYCH4.
	DMAC_BUSYCH_BUSYCH4 = 0x10
	// Position of BUSYCH5 field.
	DMAC_BUSYCH_BUSYCH5_Pos = 0x5
	// Bit mask of BUSYCH5 field.
	DMAC_BUSYCH_BUSYCH5_Msk = 0x20
	// Bit BUSYCH5.
	DMAC_BUSYCH_BUSYCH5 = 0x20
	// Position of BUSYCH6 field.
	DMAC_BUSYCH_BUSYCH6_Pos = 0x6
	// Bit mask of BUSYCH6 field.
	DMAC_BUSYCH_BUSYCH6_Msk = 0x40
	// Bit BUSYCH6.
	DMAC_BUSYCH_BUSYCH6 = 0x40
	// Position of BUSYCH7 field.
	DMAC_BUSYCH_BUSYCH7_Pos = 0x7
	// Bit mask of BUSYCH7 field.
	DMAC_BUSYCH_BUSYCH7_Msk = 0x80
	// Bit BUSYCH7.
	DMAC_BUSYCH_BUSYCH7 = 0x80
	// Position of BUSYCH8 field.
	DMAC_BUSYCH_BUSYCH8_Pos = 0x8
	// Bit mask of BUSYCH8 field.
	DMAC_BUSYCH_BUSYCH8_Msk = 0x100
	// Bit BUSYCH8.
	DMAC_BUSYCH_BUSYCH8 = 0x100
	// Position of BUSYCH9 field.
	DMAC_BUSYCH_BUSYCH9_Pos = 0x9
	// Bit mask of BUSYCH9 field.
	DMAC_BUSYCH_BUSYCH9_Msk = 0x200
	// Bit BUSYCH9.
	DMAC_BUSYCH_BUSYCH9 = 0x200
	// Position of BUSYCH10 field.
	DMAC_BUSYCH_BUSYCH10_Pos = 0xa
	// Bit mask of BUSYCH10 field.
	DMAC_BUSYCH_BUSYCH10_Msk = 0x400
	// Bit BUSYCH10.
	DMAC_BUSYCH_BUSYCH10 = 0x400
	// Position of BUSYCH11 field.
	DMAC_BUSYCH_BUSYCH11_Pos = 0xb
	// Bit mask of BUSYCH11 field.
	DMAC_BUSYCH_BUSYCH11_Msk = 0x800
	// Bit BUSYCH11.
	DMAC_BUSYCH_BUSYCH11 = 0x800
	// Position of BUSYCH12 field.
	DMAC_BUSYCH_BUSYCH12_Pos = 0xc
	// Bit mask of BUSYCH12 field.
	DMAC_BUSYCH_BUSYCH12_Msk = 0x1000
	// Bit BUSYCH12.
	DMAC_BUSYCH_BUSYCH12 = 0x1000
	// Position of BUSYCH13 field.
	DMAC_BUSYCH_BUSYCH13_Pos = 0xd
	// Bit mask of BUSYCH13 field.
	DMAC_BUSYCH_BUSYCH13_Msk = 0x2000
	// Bit BUSYCH13.
	DMAC_BUSYCH_BUSYCH13 = 0x2000
	// Position of BUSYCH14 field.
	DMAC_BUSYCH_BUSYCH14_Pos = 0xe
	// Bit mask of BUSYCH14 field.
	DMAC_BUSYCH_BUSYCH14_Msk = 0x4000
	// Bit BUSYCH14.
	DMAC_BUSYCH_BUSYCH14 = 0x4000
	// Position of BUSYCH15 field.
	DMAC_BUSYCH_BUSYCH15_Pos = 0xf
	// Bit mask of BUSYCH15 field.
	DMAC_BUSYCH_BUSYCH15_Msk = 0x8000
	// Bit BUSYCH15.
	DMAC_BUSYCH_BUSYCH15 = 0x8000

	// PENDCH: Pending Channels
	// Position of PENDCH0 field.
	DMAC_PENDCH_PENDCH0_Pos = 0x0
	// Bit mask of PENDCH0 field.
	DMAC_PENDCH_PENDCH0_Msk = 0x1
	// Bit PENDCH0.
	DMAC_PENDCH_PENDCH0 = 0x1
	// Position of PENDCH1 field.
	DMAC_PENDCH_PENDCH1_Pos = 0x1
	// Bit mask of PENDCH1 field.
	DMAC_PENDCH_PENDCH1_Msk = 0x2
	// Bit PENDCH1.
	DMAC_PENDCH_PENDCH1 = 0x2
	// Position of PENDCH2 field.
	DMAC_PENDCH_PENDCH2_Pos = 0x2
	// Bit mask of PENDCH2 field.
	DMAC_PENDCH_PENDCH2_Msk = 0x4
	// Bit PENDCH2.
	DMAC_PENDCH_PENDCH2 = 0x4
	// Position of PENDCH3 field.
	DMAC_PENDCH_PENDCH3_Pos = 0x3
	// Bit mask of PENDCH3 field.
	DMAC_PENDCH_PENDCH3_Msk = 0x8
	// Bit PENDCH3.
	DMAC_PENDCH_PENDCH3 = 0x8
	// Position of PENDCH4 field.
	DMAC_PENDCH_PENDCH4_Pos = 0x4
	// Bit mask of PENDCH4 field.
	DMAC_PENDCH_PENDCH4_Msk = 0x10
	// Bit PENDCH4.
	DMAC_PENDCH_PENDCH4 = 0x10
	// Position of PENDCH5 field.
	DMAC_PENDCH_PENDCH5_Pos = 0x5
	// Bit mask of PENDCH5 field.
	DMAC_PENDCH_PENDCH5_Msk = 0x20
	// Bit PENDCH5.
	DMAC_PENDCH_PENDCH5 = 0x20
	// Position of PENDCH6 field.
	DMAC_PENDCH_PENDCH6_Pos = 0x6
	// Bit mask of PENDCH6 field.
	DMAC_PENDCH_PENDCH6_Msk = 0x40
	// Bit PENDCH6.
	DMAC_PENDCH_PENDCH6 = 0x40
	// Position of PENDCH7 field.
	DMAC_PENDCH_PENDCH7_Pos = 0x7
	// Bit mask of PENDCH7 field.
	DMAC_PENDCH_PENDCH7_Msk = 0x80
	// Bit PENDCH7.
	DMAC_PENDCH_PENDCH7 = 0x80
	// Position of PENDCH8 field.
	DMAC_PENDCH_PENDCH8_Pos = 0x8
	// Bit mask of PENDCH8 field.
	DMAC_PENDCH_PENDCH8_Msk = 0x100
	// Bit PENDCH8.
	DMAC_PENDCH_PENDCH8 = 0x100
	// Position of PENDCH9 field.
	DMAC_PENDCH_PENDCH9_Pos = 0x9
	// Bit mask of PENDCH9 field.
	DMAC_PENDCH_PENDCH9_Msk = 0x200
	// Bit PENDCH9.
	DMAC_PENDCH_PENDCH9 = 0x200
	// Position of PENDCH10 field.
	DMAC_PENDCH_PENDCH10_Pos = 0xa
	// Bit mask of PENDCH10 field.
	DMAC_PENDCH_PENDCH10_Msk = 0x400
	// Bit PENDCH10.
	DMAC_PENDCH_PENDCH10 = 0x400
	// Position of PENDCH11 field.
	DMAC_PENDCH_PENDCH11_Pos = 0xb
	// Bit mask of PENDCH11 field.
	DMAC_PENDCH_PENDCH11_Msk = 0x800
	// Bit PENDCH11.
	DMAC_PENDCH_PENDCH11 = 0x800
	// Position of PENDCH12 field.
	DMAC_PENDCH_PENDCH12_Pos = 0xc
	// Bit mask of PENDCH12 field.
	DMAC_PENDCH_PENDCH12_Msk = 0x1000
	// Bit PENDCH12.
	DMAC_PENDCH_PENDCH12 = 0x1000
	// Position of PENDCH13 field.
	DMAC_PENDCH_PENDCH13_Pos = 0xd
	// Bit mask of PENDCH13 field.
	DMAC_PENDCH_PENDCH13_Msk = 0x2000
	// Bit PENDCH13.
	DMAC_PENDCH_PENDCH13 = 0x2000
	// Position of PENDCH14 field.
	DMAC_PENDCH_PENDCH14_Pos = 0xe
	// Bit mask of PENDCH14 field.
	DMAC_PENDCH_PENDCH14_Msk = 0x4000
	// Bit PENDCH14.
	DMAC_PENDCH_PENDCH14 = 0x4000
	// Position of PENDCH15 field.
	DMAC_PENDCH_PENDCH15_Pos = 0xf
	// Bit mask of PENDCH15 field.
	DMAC_PENDCH_PENDCH15_Msk = 0x8000
	// Bit PENDCH15.
	DMAC_PENDCH_PENDCH15 = 0x8000

	// ACTIVE: Active Channel and Levels
	// Position of LVLEX0 field.
	DMAC_ACTIVE_LVLEX0_Pos = 0x0
	// Bit mask of LVLEX0 field.
	DMAC_ACTIVE_LVLEX0_Msk = 0x1
	// Bit LVLEX0.
	DMAC_ACTIVE_LVLEX0 = 0x1
	// Position of LVLEX1 field.
	DMAC_ACTIVE_LVLEX1_Pos = 0x1
	// Bit mask of LVLEX1 field.
	DMAC_ACTIVE_LVLEX1_Msk = 0x2
	// Bit LVLEX1.
	DMAC_ACTIVE_LVLEX1 = 0x2
	// Position of LVLEX2 field.
	DMAC_ACTIVE_LVLEX2_Pos = 0x2
	// Bit mask of LVLEX2 field.
	DMAC_ACTIVE_LVLEX2_Msk = 0x4
	// Bit LVLEX2.
	DMAC_ACTIVE_LVLEX2 = 0x4
	// Position of LVLEX3 field.
	DMAC_ACTIVE_LVLEX3_Pos = 0x3
	// Bit mask of LVLEX3 field.
	DMAC_ACTIVE_LVLEX3_Msk = 0x8
	// Bit LVLEX3.
	DMAC_ACTIVE_LVLEX3 = 0x8
	// Position of ID field.
	DMAC_ACTIVE_ID_Pos = 0x8
	// Bit mask of ID field.
	DMAC_ACTIVE_ID_Msk = 0x1f00
	// Position of ABUSY field.
	DMAC_ACTIVE_ABUSY_Pos = 0xf
	// Bit mask of ABUSY field.
	DMAC_ACTIVE_ABUSY_Msk = 0x8000
	// Bit ABUSY.
	DMAC_ACTIVE_ABUSY = 0x8000
	// Position of BTCNT field.
	DMAC_ACTIVE_BTCNT_Pos = 0x10
	// Bit mask of BTCNT field.
	DMAC_ACTIVE_BTCNT_Msk = 0xffff0000

	// BASEADDR: Descriptor Memory Section Base Address
	// Position of BASEADDR field.
	DMAC_BASEADDR_BASEADDR_Pos = 0x0
	// Bit mask of BASEADDR field.
	DMAC_BASEADDR_BASEADDR_Msk = 0xffffffff

	// WRBADDR: Write-Back Memory Section Base Address
	// Position of WRBADDR field.
	DMAC_WRBADDR_WRBADDR_Pos = 0x0
	// Bit mask of WRBADDR field.
	DMAC_WRBADDR_WRBADDR_Msk = 0xffffffff

	// CHID: Channel ID
	// Position of ID field.
	DMAC_CHID_ID_Pos = 0x0
	// Bit mask of ID field.
	DMAC_CHID_ID_Msk = 0xf

	// CHCTRLA: Channel Control A
	// Position of SWRST field.
	DMAC_CHCTRLA_SWRST_Pos = 0x0
	// Bit mask of SWRST field.
	DMAC_CHCTRLA_SWRST_Msk = 0x1
	// Bit SWRST.
	DMAC_CHCTRLA_SWRST = 0x1
	// Position of ENABLE field.
	DMAC_CHCTRLA_ENABLE_Pos = 0x1
	// Bit mask of ENABLE field.
	DMAC_CHCTRLA_ENABLE_Msk = 0x2
	// Bit ENABLE.
	DMAC_CHCTRLA_ENABLE = 0x2
	// Position of RUNSTDBY field.
	DMAC_CHCTRLA_RUNSTDBY_Pos = 0x6
	// Bit mask of RUNSTDBY field.
	DMAC_CHCTRLA_RUNSTDBY_Msk = 0x40
	// Bit RUNSTDBY.
	DMAC_CHCTRLA_RUNSTDBY = 0x40

	// CHCTRLB: Channel Control B
	// Position of EVACT field.
	DMAC_CHCTRLB_EVACT_Pos = 0x0
	// Bit mask of EVACT field.
	DMAC_CHCTRLB_EVACT_Msk = 0x7
	// No action
	DMAC_CHCTRLB_EVACT_NOACT = 0x0
	// Transfer and periodic transfer trigger
	DMAC_CHCTRLB_EVACT_TRIG = 0x1
	// Conditional transfer trigger
	DMAC_CHCTRLB_EVACT_CTRIG = 0x2
	// Conditional block transfer
	DMAC_CHCTRLB_EVACT_CBLOCK = 0x3
	// Channel suspend operation
	DMAC_CHCTRLB_EVACT_SUSPEND = 0x4
	// Channel resume operation
	DMAC_CHCTRLB_EVACT_RESUME = 0x5
	// Skip next block suspend action
	DMAC_CHCTRLB_EVACT_SSKIP = 0x6
	// Position of EVIE field.
	DMAC_CHCTRLB_EVIE_Pos = 0x3
	// Bit mask of EVIE field.
	DMAC_CHCTRLB_EVIE_Msk = 0x8
	// Bit EVIE.
	DMAC_CHCTRLB_EVIE = 0x8
	// Position of EVOE field.
	DMAC_CHCTRLB_EVOE_Pos = 0x4
	// Bit mask of EVOE field.
	DMAC_CHCTRLB_EVOE_Msk = 0x10
	// Bit EVOE.
	DMAC_CHCTRLB_EVOE = 0x10
	// Position of LVL field.
	DMAC_CHCTRLB_LVL_Pos = 0x5
	// Bit mask of LVL field.
	DMAC_CHCTRLB_LVL_Msk = 0x60
	// Position of TRIGSRC field.
	DMAC_CHCTRLB_TRIGSRC_Pos = 0x8
	// Bit mask of TRIGSRC field.
	DMAC_CHCTRLB_TRIGSRC_Msk = 0x3f00
	// Only software/event triggers
	DMAC_CHCTRLB_TRIGSRC_DISABLE = 0x0
	// Position of TRIGACT field.
	DMAC_CHCTRLB_TRIGACT_Pos = 0x16
	// Bit mask of TRIGACT field.
	DMAC_CHCTRLB_TRIGACT_Msk = 0xc00000
	// One trigger required for each block transfer
	DMAC_CHCTRLB_TRIGACT_BLOCK = 0x0
	// One trigger required for each beat transfer
	DMAC_CHCTRLB_TRIGACT_BEAT = 0x2
	// One trigger required for each transaction
	DMAC_CHCTRLB_TRIGACT_TRANSACTION = 0x3
	// Position of CMD field.
	DMAC_CHCTRLB_CMD_Pos = 0x18
	// Bit mask of CMD field.
	DMAC_CHCTRLB_CMD_Msk = 0x3000000
	// No action
	DMAC_CHCTRLB_CMD_NOACT = 0x0
	// Channel suspend operation
	DMAC_CHCTRLB_CMD_SUSPEND = 0x1
	// Channel resume operation
	DMAC_CHCTRLB_CMD_RESUME = 0x2

	// CHINTENCLR: Channel Interrupt Enable Clear
	// Position of TERR field.
	DMAC_CHINTENCLR_TERR_Pos = 0x0
	// Bit mask of TERR field.
	DMAC_CHINTENCLR_TERR_Msk = 0x1
	// Bit TERR.
	DMAC_CHINTENCLR_TERR = 0x1
	// Position of TCMPL field.
	DMAC_CHINTENCLR_TCMPL_Pos = 0x1
	// Bit mask of TCMPL field.
	DMAC_CHINTENCLR_TCMPL_Msk = 0x2
	// Bit TCMPL.
	DMAC_CHINTENCLR_TCMPL = 0x2
	// Position of SUSP field.
	DMAC_CHINTENCLR_SUSP_Pos = 0x2
	// Bit mask of SUSP field.
	DMAC_CHINTENCLR_SUSP_Msk = 0x4
	// Bit SUSP.
	DMAC_CHINTENCLR_SUSP = 0x4

	// CHINTENSET: Channel Interrupt Enable Set
	// Position of TERR field.
	DMAC_CHINTENSET_TERR_Pos = 0x0
	// Bit mask of TERR field.
	DMAC_CHINTENSET_TERR_Msk = 0x1
	// Bit TERR.
	DMAC_CHINTENSET_TERR = 0x1
	// Position of TCMPL field.
	DMAC_CHINTENSET_TCMPL_Pos = 0x1
	// Bit mask of TCMPL field.
	DMAC_CHINTENSET_TCMPL_Msk = 0x2
	// Bit TCMPL.
	DMAC_CHINTENSET_TCMPL = 0x2
	// Position of SUSP field.
	DMAC_CHINTENSET_SUSP_Pos = 0x2
	// Bit mask of SUSP field.
	DMAC_CHINTENSET_SUSP_Msk = 0x4
	// Bit SUSP.
	DMAC_CHINTENSET_SUSP = 0x4

	// CHINTFLAG: Channel Interrupt Flag Status and Clear
	// Position of TERR field.
	DMAC_CHINTFLAG_TERR_Pos = 0x0
	// Bit mask of TERR field.
	DMAC_CHINTFLAG_TERR_Msk = 0x1
	// Bit TERR.
	DMAC_CHINTFLAG_TERR = 0x1
	// Position of TCMPL field.
	DMAC_CHINTFLAG_TCMPL_Pos = 0x1
	// Bit mask of TCMPL field.
	DMAC_CHINTFLAG_TCMPL_Msk = 0x2
	// Bit TCMPL.
	DMAC_CHINTFLAG_TCMPL = 0x2
	// Position of SUSP field.
	DMAC_CHINTFLAG_SUSP_Pos = 0x2
	// Bit mask of SUSP field.
	DMAC_CHINTFLAG_SUSP_Msk = 0x4
	// Bit SUSP.
	DMAC_CHINTFLAG_SUSP = 0x4

	// CHSTATUS: Channel Status
	// Position of PEND field.
	DMAC_CHSTATUS_PEND_Pos = 0x0
	// Bit mask of PEND field.
	DMAC_CHSTATUS_PEND_Msk = 0x1
	// Bit PEND.
	DMAC_CHSTATUS_PEND = 0x1
	// Position of BUSY field.
	DMAC_CHSTATUS_BUSY_Pos = 0x1
	// Bit mask of BUSY field.
	DMAC_CHSTATUS_BUSY_Msk = 0x2
	// Bit BUSY.
	DMAC_CHSTATUS_BUSY = 0x2
	// Position of FERR field.
	DMAC_CHSTATUS_FERR_Pos = 0x2
	// Bit mask of FERR field.
	DMAC_CHSTATUS_FERR_Msk = 0x4
	// Bit FERR.
	DMAC_CHSTATUS_FERR = 0x4
)

// Constants for DSU: Device Service Unit
const (
	// CTRL: Control
	// Position of SWRST field.
	DSU_CTRL_SWRST_Pos = 0x0
	// Bit mask of SWRST field.
	DSU_CTRL_SWRST_Msk = 0x1
	// Bit SWRST.
	DSU_CTRL_SWRST = 0x1
	// Position of CRC field.
	DSU_CTRL_CRC_Pos = 0x2
	// Bit mask of CRC field.
	DSU_CTRL_CRC_Msk = 0x4
	// Bit CRC.
	DSU_CTRL_CRC = 0x4
	// Position of MBIST field.
	DSU_CTRL_MBIST_Pos = 0x3
	// Bit mask of MBIST field.
	DSU_CTRL_MBIST_Msk = 0x8
	// Bit MBIST.
	DSU_CTRL_MBIST = 0x8
	// Position of CE field.
	DSU_CTRL_CE_Pos = 0x4
	// Bit mask of CE field.
	DSU_CTRL_CE_Msk = 0x10
	// Bit CE.
	DSU_CTRL_CE = 0x10
	// Position of ARR field.
	DSU_CTRL_ARR_Pos = 0x6
	// Bit mask of ARR field.
	DSU_CTRL_ARR_Msk = 0x40
	// Bit ARR.
	DSU_CTRL_ARR = 0x40
	// Position of SMSA field.
	DSU_CTRL_SMSA_Pos = 0x7
	// Bit mask of SMSA field.
	DSU_CTRL_SMSA_Msk = 0x80
	// Bit SMSA.
	DSU_CTRL_SMSA = 0x80

	// STATUSA: Status A
	// Position of DONE field.
	DSU_STATUSA_DONE_Pos = 0x0
	// Bit mask of DONE field.
	DSU_STATUSA_DONE_Msk = 0x1
	// Bit DONE.
	DSU_STATUSA_DONE = 0x1
	// Position of CRSTEXT field.
	DSU_STATUSA_CRSTEXT_Pos = 0x1
	// Bit mask of CRSTEXT field.
	DSU_STATUSA_CRSTEXT_Msk = 0x2
	// Bit CRSTEXT.
	DSU_STATUSA_CRSTEXT = 0x2
	// Position of BERR field.
	DSU_STATUSA_BERR_Pos = 0x2
	// Bit mask of BERR field.
	DSU_STATUSA_BERR_Msk = 0x4
	// Bit BERR.
	DSU_STATUSA_BERR = 0x4
	// Position of FAIL field.
	DSU_STATUSA_FAIL_Pos = 0x3
	// Bit mask of FAIL field.
	DSU_STATUSA_FAIL_Msk = 0x8
	// Bit FAIL.
	DSU_STATUSA_FAIL = 0x8
	// Position of PERR field.
	DSU_STATUSA_PERR_Pos = 0x4
	// Bit mask of PERR field.
	DSU_STATUSA_PERR_Msk = 0x10
	// Bit PERR.
	DSU_STATUSA_PERR = 0x10

	// STATUSB: Status B
	// Position of PROT field.
	DSU_STATUSB_PROT_Pos = 0x0
	// Bit mask of PROT field.
	DSU_STATUSB_PROT_Msk = 0x1
	// Bit PROT.
	DSU_STATUSB_PROT = 0x1
	// Position of DBGPRES field.
	DSU_STATUSB_DBGPRES_Pos = 0x1
	// Bit mask of DBGPRES field.
	DSU_STATUSB_DBGPRES_Msk = 0x2
	// Bit DBGPRES.
	DSU_STATUSB_DBGPRES = 0x2
	// Position of DCCD0 field.
	DSU_STATUSB_DCCD0_Pos = 0x2
	// Bit mask of DCCD0 field.
	DSU_STATUSB_DCCD0_Msk = 0x4
	// Bit DCCD0.
	DSU_STATUSB_DCCD0 = 0x4
	// Position of DCCD1 field.
	DSU_STATUSB_DCCD1_Pos = 0x3
	// Bit mask of DCCD1 field.
	DSU_STATUSB_DCCD1_Msk = 0x8
	// Bit DCCD1.
	DSU_STATUSB_DCCD1 = 0x8
	// Position of HPE field.
	DSU_STATUSB_HPE_Pos = 0x4
	// Bit mask of HPE field.
	DSU_STATUSB_HPE_Msk = 0x10
	// Bit HPE.
	DSU_STATUSB_HPE = 0x10

	// ADDR: Address
	// Position of AMOD field.
	DSU_ADDR_AMOD_Pos = 0x0
	// Bit mask of AMOD field.
	DSU_ADDR_AMOD_Msk = 0x3
	// Position of ADDR field.
	DSU_ADDR_ADDR_Pos = 0x2
	// Bit mask of ADDR field.
	DSU_ADDR_ADDR_Msk = 0xfffffffc

	// LENGTH: Length
	// Position of LENGTH field.
	DSU_LENGTH_LENGTH_Pos = 0x2
	// Bit mask of LENGTH field.
	DSU_LENGTH_LENGTH_Msk = 0xfffffffc

	// DATA: Data
	// Position of DATA field.
	DSU_DATA_DATA_Pos = 0x0
	// Bit mask of DATA field.
	DSU_DATA_DATA_Msk = 0xffffffff

	// DCC0: Debug Communication Channel n
	// Position of DATA field.
	DSU_DCC_DATA_Pos = 0x0
	// Bit mask of DATA field.
	DSU_DCC_DATA_Msk = 0xffffffff

	// DID: Device Identification
	// Position of DEVSEL field.
	DSU_DID_DEVSEL_Pos = 0x0
	// Bit mask of DEVSEL field.
	DSU_DID_DEVSEL_Msk = 0xff
	// Position of REVISION field.
	DSU_DID_REVISION_Pos = 0x8
	// Bit mask of REVISION field.
	DSU_DID_REVISION_Msk = 0xf00
	// Position of DIE field.
	DSU_DID_DIE_Pos = 0xc
	// Bit mask of DIE field.
	DSU_DID_DIE_Msk = 0xf000
	// Position of SERIES field.
	DSU_DID_SERIES_Pos = 0x10
	// Bit mask of SERIES field.
	DSU_DID_SERIES_Msk = 0x3f0000
	// Cortex-M0+ processor, basic feature set
	DSU_DID_SERIES_0 = 0x0
	// Cortex-M0+ processor, USB
	DSU_DID_SERIES_1 = 0x1
	// Position of FAMILY field.
	DSU_DID_FAMILY_Pos = 0x17
	// Bit mask of FAMILY field.
	DSU_DID_FAMILY_Msk = 0xf800000
	// General purpose microcontroller
	DSU_DID_FAMILY_0 = 0x0
	// PicoPower
	DSU_DID_FAMILY_1 = 0x1
	// Position of PROCESSOR field.
	DSU_DID_PROCESSOR_Pos = 0x1c
	// Bit mask of PROCESSOR field.
	DSU_DID_PROCESSOR_Msk = 0xf0000000
	// Cortex-M0
	DSU_DID_PROCESSOR_0 = 0x0
	// Cortex-M0+
	DSU_DID_PROCESSOR_1 = 0x1
	// Cortex-M3
	DSU_DID_PROCESSOR_2 = 0x2
	// Cortex-M4
	DSU_DID_PROCESSOR_3 = 0x3

	// DCFG0: Device Configuration
	// Position of DCFG field.
	DSU_DCFG_DCFG_Pos = 0x0
	// Bit mask of DCFG field.
	DSU_DCFG_DCFG_Msk = 0xffffffff

	// ENTRY0: CoreSight ROM Table Entry 0
	// Position of EPRES field.
	DSU_ENTRY0_EPRES_Pos = 0x0
	// Bit mask of EPRES field.
	DSU_ENTRY0_EPRES_Msk = 0x1
	// Bit EPRES.
	DSU_ENTRY0_EPRES = 0x1
	// Position of FMT field.
	DSU_ENTRY0_FMT_Pos = 0x1
	// Bit mask of FMT field.
	DSU_ENTRY0_FMT_Msk = 0x2
	// Bit FMT.
	DSU_ENTRY0_FMT = 0x2
	// Position of ADDOFF field.
	DSU_ENTRY0_ADDOFF_Pos = 0xc
	// Bit mask of ADDOFF field.
	DSU_ENTRY0_ADDOFF_Msk = 0xfffff000

	// END: CoreSight ROM Table End
	// Position of END field.
	DSU_END_END_Pos = 0x0
	// Bit mask of END field.
	DSU_END_END_Msk = 0xffffffff

	// MEMTYPE: CoreSight ROM Table Memory Type
	// Position of SMEMP field.
	DSU_MEMTYPE_SMEMP_Pos = 0x0
	// Bit mask of SMEMP field.
	DSU_MEMTYPE_SMEMP_Msk = 0x1
	// Bit SMEMP.
	DSU_MEMTYPE_SMEMP = 0x1

	// PID4: Peripheral Identification 4
	// Position of JEPCC field.
	DSU_PID4_JEPCC_Pos = 0x0
	// Bit mask of JEPCC field.
	DSU_PID4_JEPCC_Msk = 0xf
	// Position of FKBC field.
	DSU_PID4_FKBC_Pos = 0x4
	// Bit mask of FKBC field.
	DSU_PID4_FKBC_Msk = 0xf0

	// PID0: Peripheral Identification 0
	// Position of PARTNBL field.
	DSU_PID0_PARTNBL_Pos = 0x0
	// Bit mask of PARTNBL field.
	DSU_PID0_PARTNBL_Msk = 0xff

	// PID1: Peripheral Identification 1
	// Position of PARTNBH field.
	DSU_PID1_PARTNBH_Pos = 0x0
	// Bit mask of PARTNBH field.
	DSU_PID1_PARTNBH_Msk = 0xf
	// Position of JEPIDCL field.
	DSU_PID1_JEPIDCL_Pos = 0x4
	// Bit mask of JEPIDCL field.
	DSU_PID1_JEPIDCL_Msk = 0xf0

	// PID2: Peripheral Identification 2
	// Position of JEPIDCH field.
	DSU_PID2_JEPIDCH_Pos = 0x0
	// Bit mask of JEPIDCH field.
	DSU_PID2_JEPIDCH_Msk = 0x7
	// Position of JEPU field.
	DSU_PID2_JEPU_Pos = 0x3
	// Bit mask of JEPU field.
	DSU_PID2_JEPU_Msk = 0x8
	// Bit JEPU.
	DSU_PID2_JEPU = 0x8
	// Position of REVISION field.
	DSU_PID2_REVISION_Pos = 0x4
	// Bit mask of REVISION field.
	DSU_PID2_REVISION_Msk = 0xf0

	// PID3: Peripheral Identification 3
	// Position of CUSMOD field.
	DSU_PID3_CUSMOD_Pos = 0x0
	// Bit mask of CUSMOD field.
	DSU_PID3_CUSMOD_Msk = 0xf
	// Position of REVAND field.
	DSU_PID3_REVAND_Pos = 0x4
	// Bit mask of REVAND field.
	DSU_PID3_REVAND_Msk = 0xf0

	// CID0: Component Identification 0
	// Position of PREAMBLEB0 field.
	DSU_CID0_PREAMBLEB0_Pos = 0x0
	// Bit mask of PREAMBLEB0 field.
	DSU_CID0_PREAMBLEB0_Msk = 0xff

	// CID1: Component Identification 1
	// Position of PREAMBLE field.
	DSU_CID1_PREAMBLE_Pos = 0x0
	// Bit mask of PREAMBLE field.
	DSU_CID1_PREAMBLE_Msk = 0xf
	// Position of CCLASS field.
	DSU_CID1_CCLASS_Pos = 0x4
	// Bit mask of CCLASS field.
	DSU_CID1_CCLASS_Msk = 0xf0

	// CID2: Component Identification 2
	// Position of PREAMBLEB2 field.
	DSU_CID2_PREAMBLEB2_Pos = 0x0
	// Bit mask of PREAMBLEB2 field.
	DSU_CID2_PREAMBLEB2_Msk = 0xff

	// CID3: Component Identification 3
	// Position of PREAMBLEB3 field.
	DSU_CID3_PREAMBLEB3_Pos = 0x0
	// Bit mask of PREAMBLEB3 field.
	DSU_CID3_PREAMBLEB3_Msk = 0xff
)

// Constants for EIC: External Interrupt Controller
const (
	// CTRLA: Control
	// Position of SWRST field.
	EIC_CTRLA_SWRST_Pos = 0x0
	// Bit mask of SWRST field.
	EIC_CTRLA_SWRST_Msk = 0x1
	// Bit SWRST.
	EIC_CTRLA_SWRST = 0x1
	// Position of ENABLE field.
	EIC_CTRLA_ENABLE_Pos = 0x1
	// Bit mask of ENABLE field.
	EIC_CTRLA_ENABLE_Msk = 0x2
	// Bit ENABLE.
	EIC_CTRLA_ENABLE = 0x2
	// Position of CKSEL field.
	EIC_CTRLA_CKSEL_Pos = 0x4
	// Bit mask of CKSEL field.
	EIC_CTRLA_CKSEL_Msk = 0x10
	// Bit CKSEL.
	EIC_CTRLA_CKSEL = 0x10

	// NMICTRL: NMI Control
	// Position of NMISENSE field.
	EIC_NMICTRL_NMISENSE_Pos = 0x0
	// Bit mask of NMISENSE field.
	EIC_NMICTRL_NMISENSE_Msk = 0x7
	// No detection
	EIC_NMICTRL_NMISENSE_NONE = 0x0
	// Rising edge detection
	EIC_NMICTRL_NMISENSE_RISE = 0x1
	// Falling edge detection
	EIC_NMICTRL_NMISENSE_FALL = 0x2
	// Both edges detection
	EIC_NMICTRL_NMISENSE_BOTH = 0x3
	// High level detection
	EIC_NMICTRL_NMISENSE_HIGH = 0x4
	// Low level detection
	EIC_NMICTRL_NMISENSE_LOW = 0x5
	// Position of NMIFILTEN field.
	EIC_NMICTRL_NMIFILTEN_Pos = 0x3
	// Bit mask of NMIFILTEN field.
	EIC_NMICTRL_NMIFILTEN_Msk = 0x8
	// Bit NMIFILTEN.
	EIC_NMICTRL_NMIFILTEN = 0x8
	// Position of NMIASYNCH field.
	EIC_NMICTRL_NMIASYNCH_Pos = 0x4
	// Bit mask of NMIASYNCH field.
	EIC_NMICTRL_NMIASYNCH_Msk = 0x10
	// Bit NMIASYNCH.
	EIC_NMICTRL_NMIASYNCH = 0x10

	// NMIFLAG: NMI Interrupt Flag
	// Position of NMI field.
	EIC_NMIFLAG_NMI_Pos = 0x0
	// Bit mask of NMI field.
	EIC_NMIFLAG_NMI_Msk = 0x1
	// Bit NMI.
	EIC_NMIFLAG_NMI = 0x1

	// SYNCBUSY: Syncbusy register
	// Position of SWRST field.
	EIC_SYNCBUSY_SWRST_Pos = 0x0
	// Bit mask of SWRST field.
	EIC_SYNCBUSY_SWRST_Msk = 0x1
	// Bit SWRST.
	EIC_SYNCBUSY_SWRST = 0x1
	// Position of ENABLE field.
	EIC_SYNCBUSY_ENABLE_Pos = 0x1
	// Bit mask of ENABLE field.
	EIC_SYNCBUSY_ENABLE_Msk = 0x2
	// Bit ENABLE.
	EIC_SYNCBUSY_ENABLE = 0x2

	// EVCTRL: Event Control
	// Position of EXTINTEO field.
	EIC_EVCTRL_EXTINTEO_Pos = 0x0
	// Bit mask of EXTINTEO field.
	EIC_EVCTRL_EXTINTEO_Msk = 0xffff

	// INTENCLR: Interrupt Enable Clear
	// Position of EXTINT field.
	EIC_INTENCLR_EXTINT_Pos = 0x0
	// Bit mask of EXTINT field.
	EIC_INTENCLR_EXTINT_Msk = 0xffff

	// INTENSET: Interrupt Enable Set
	// Position of EXTINT field.
	EIC_INTENSET_EXTINT_Pos = 0x0
	// Bit mask of EXTINT field.
	EIC_INTENSET_EXTINT_Msk = 0xffff

	// INTFLAG: Interrupt Flag Status and Clear
	// Position of EXTINT field.
	EIC_INTFLAG_EXTINT_Pos = 0x0
	// Bit mask of EXTINT field.
	EIC_INTFLAG_EXTINT_Msk = 0xffff

	// ASYNCH: EIC Asynchronous edge Detection Enable
	// Position of ASYNCH field.
	EIC_ASYNCH_ASYNCH_Pos = 0x0
	// Bit mask of ASYNCH field.
	EIC_ASYNCH_ASYNCH_Msk = 0xffff

	// CONFIG0: Configuration n
	// Position of SENSE0 field.
	EIC_CONFIG_SENSE0_Pos = 0x0
	// Bit mask of SENSE0 field.
	EIC_CONFIG_SENSE0_Msk = 0x7
	// No detection
	EIC_CONFIG_SENSE0_NONE = 0x0
	// Rising edge detection
	EIC_CONFIG_SENSE0_RISE = 0x1
	// Falling edge detection
	EIC_CONFIG_SENSE0_FALL = 0x2
	// Both edges detection
	EIC_CONFIG_SENSE0_BOTH = 0x3
	// High level detection
	EIC_CONFIG_SENSE0_HIGH = 0x4
	// Low level detection
	EIC_CONFIG_SENSE0_LOW = 0x5
	// Position of FILTEN0 field.
	EIC_CONFIG_FILTEN0_Pos = 0x3
	// Bit mask of FILTEN0 field.
	EIC_CONFIG_FILTEN0_Msk = 0x8
	// Bit FILTEN0.
	EIC_CONFIG_FILTEN0 = 0x8
	// Position of SENSE1 field.
	EIC_CONFIG_SENSE1_Pos = 0x4
	// Bit mask of SENSE1 field.
	EIC_CONFIG_SENSE1_Msk = 0x70
	// No detection
	EIC_CONFIG_SENSE1_NONE = 0x0
	// Rising edge detection
	EIC_CONFIG_SENSE1_RISE = 0x1
	// Falling edge detection
	EIC_CONFIG_SENSE1_FALL = 0x2
	// Both edges detection
	EIC_CONFIG_SENSE1_BOTH = 0x3
	// High level detection
	EIC_CONFIG_SENSE1_HIGH = 0x4
	// Low level detection
	EIC_CONFIG_SENSE1_LOW = 0x5
	// Position of FILTEN1 field.
	EIC_CONFIG_FILTEN1_Pos = 0x7
	// Bit mask of FILTEN1 field.
	EIC_CONFIG_FILTEN1_Msk = 0x80
	// Bit FILTEN1.
	EIC_CONFIG_FILTEN1 = 0x80
	// Position of SENSE2 field.
	EIC_CONFIG_SENSE2_Pos = 0x8
	// Bit mask of SENSE2 field.
	EIC_CONFIG_SENSE2_Msk = 0x700
	// No detection
	EIC_CONFIG_SENSE2_NONE = 0x0
	// Rising edge detection
	EIC_CONFIG_SENSE2_RISE = 0x1
	// Falling edge detection
	EIC_CONFIG_SENSE2_FALL = 0x2
	// Both edges detection
	EIC_CONFIG_SENSE2_BOTH = 0x3
	// High level detection
	EIC_CONFIG_SENSE2_HIGH = 0x4
	// Low level detection
	EIC_CONFIG_SENSE2_LOW = 0x5
	// Position of FILTEN2 field.
	EIC_CONFIG_FILTEN2_Pos = 0xb
	// Bit mask of FILTEN2 field.
	EIC_CONFIG_FILTEN2_Msk = 0x800
	// Bit FILTEN2.
	EIC_CONFIG_FILTEN2 = 0x800
	// Position of SENSE3 field.
	EIC_CONFIG_SENSE3_Pos = 0xc
	// Bit mask of SENSE3 field.
	EIC_CONFIG_SENSE3_Msk = 0x7000
	// No detection
	EIC_CONFIG_SENSE3_NONE = 0x0
	// Rising edge detection
	EIC_CONFIG_SENSE3_RISE = 0x1
	// Falling edge detection
	EIC_CONFIG_SENSE3_FALL = 0x2
	// Both edges detection
	EIC_CONFIG_SENSE3_BOTH = 0x3
	// High level detection
	EIC_CONFIG_SENSE3_HIGH = 0x4
	// Low level detection
	EIC_CONFIG_SENSE3_LOW = 0x5
	// Position of FILTEN3 field.
	EIC_CONFIG_FILTEN3_Pos = 0xf
	// Bit mask of FILTEN3 field.
	EIC_CONFIG_FILTEN3_Msk = 0x8000
	// Bit FILTEN3.
	EIC_CONFIG_FILTEN3 = 0x8000
	// Position of SENSE4 field.
	EIC_CONFIG_SENSE4_Pos = 0x10
	// Bit mask of SENSE4 field.
	EIC_CONFIG_SENSE4_Msk = 0x70000
	// No detection
	EIC_CONFIG_SENSE4_NONE = 0x0
	// Rising edge detection
	EIC_CONFIG_SENSE4_RISE = 0x1
	// Falling edge detection
	EIC_CONFIG_SENSE4_FALL = 0x2
	// Both edges detection
	EIC_CONFIG_SENSE4_BOTH = 0x3
	// High level detection
	EIC_CONFIG_SENSE4_HIGH = 0x4
	// Low level detection
	EIC_CONFIG_SENSE4_LOW = 0x5
	// Position of FILTEN4 field.
	EIC_CONFIG_FILTEN4_Pos = 0x13
	// Bit mask of FILTEN4 field.
	EIC_CONFIG_FILTEN4_Msk = 0x80000
	// Bit FILTEN4.
	EIC_CONFIG_FILTEN4 = 0x80000
	// Position of SENSE5 field.
	EIC_CONFIG_SENSE5_Pos = 0x14
	// Bit mask of SENSE5 field.
	EIC_CONFIG_SENSE5_Msk = 0x700000
	// No detection
	EIC_CONFIG_SENSE5_NONE = 0x0
	// Rising edge detection
	EIC_CONFIG_SENSE5_RISE = 0x1
	// Falling edge detection
	EIC_CONFIG_SENSE5_FALL = 0x2
	// Both edges detection
	EIC_CONFIG_SENSE5_BOTH = 0x3
	// High level detection
	EIC_CONFIG_SENSE5_HIGH = 0x4
	// Low level detection
	EIC_CONFIG_SENSE5_LOW = 0x5
	// Position of FILTEN5 field.
	EIC_CONFIG_FILTEN5_Pos = 0x17
	// Bit mask of FILTEN5 field.
	EIC_CONFIG_FILTEN5_Msk = 0x800000
	// Bit FILTEN5.
	EIC_CONFIG_FILTEN5 = 0x800000
	// Position of SENSE6 field.
	EIC_CONFIG_SENSE6_Pos = 0x18
	// Bit mask of SENSE6 field.
	EIC_CONFIG_SENSE6_Msk = 0x7000000
	// No detection
	EIC_CONFIG_SENSE6_NONE = 0x0
	// Rising edge detection
	EIC_CONFIG_SENSE6_RISE = 0x1
	// Falling edge detection
	EIC_CONFIG_SENSE6_FALL = 0x2
	// Both edges detection
	EIC_CONFIG_SENSE6_BOTH = 0x3
	// High level detection
	EIC_CONFIG_SENSE6_HIGH = 0x4
	// Low level detection
	EIC_CONFIG_SENSE6_LOW = 0x5
	// Position of FILTEN6 field.
	EIC_CONFIG_FILTEN6_Pos = 0x1b
	// Bit mask of FILTEN6 field.
	EIC_CONFIG_FILTEN6_Msk = 0x8000000
	// Bit FILTEN6.
	EIC_CONFIG_FILTEN6 = 0x8000000
	// Position of SENSE7 field.
	EIC_CONFIG_SENSE7_Pos = 0x1c
	// Bit mask of SENSE7 field.
	EIC_CONFIG_SENSE7_Msk = 0x70000000
	// No detection
	EIC_CONFIG_SENSE7_NONE = 0x0
	// Rising edge detection
	EIC_CONFIG_SENSE7_RISE = 0x1
	// Falling edge detection
	EIC_CONFIG_SENSE7_FALL = 0x2
	// Both edges detection
	EIC_CONFIG_SENSE7_BOTH = 0x3
	// High level detection
	EIC_CONFIG_SENSE7_HIGH = 0x4
	// Low level detection
	EIC_CONFIG_SENSE7_LOW = 0x5
	// Position of FILTEN7 field.
	EIC_CONFIG_FILTEN7_Pos = 0x1f
	// Bit mask of FILTEN7 field.
	EIC_CONFIG_FILTEN7_Msk = 0x80000000
	// Bit FILTEN7.
	EIC_CONFIG_FILTEN7 = 0x80000000
)

// Constants for EVSYS: Event System Interface
const (
	// CTRLA: Control
	// Position of SWRST field.
	EVSYS_CTRLA_SWRST_Pos = 0x0
	// Bit mask of SWRST field.
	EVSYS_CTRLA_SWRST_Msk = 0x1
	// Bit SWRST.
	EVSYS_CTRLA_SWRST = 0x1

	// CHSTATUS: Channel Status
	// Position of USRRDY0 field.
	EVSYS_CHSTATUS_USRRDY0_Pos = 0x0
	// Bit mask of USRRDY0 field.
	EVSYS_CHSTATUS_USRRDY0_Msk = 0x1
	// Bit USRRDY0.
	EVSYS_CHSTATUS_USRRDY0 = 0x1
	// Position of USRRDY1 field.
	EVSYS_CHSTATUS_USRRDY1_Pos = 0x1
	// Bit mask of USRRDY1 field.
	EVSYS_CHSTATUS_USRRDY1_Msk = 0x2
	// Bit USRRDY1.
	EVSYS_CHSTATUS_USRRDY1 = 0x2
	// Position of USRRDY2 field.
	EVSYS_CHSTATUS_USRRDY2_Pos = 0x2
	// Bit mask of USRRDY2 field.
	EVSYS_CHSTATUS_USRRDY2_Msk = 0x4
	// Bit USRRDY2.
	EVSYS_CHSTATUS_USRRDY2 = 0x4
	// Position of USRRDY3 field.
	EVSYS_CHSTATUS_USRRDY3_Pos = 0x3
	// Bit mask of USRRDY3 field.
	EVSYS_CHSTATUS_USRRDY3_Msk = 0x8
	// Bit USRRDY3.
	EVSYS_CHSTATUS_USRRDY3 = 0x8
	// Position of USRRDY4 field.
	EVSYS_CHSTATUS_USRRDY4_Pos = 0x4
	// Bit mask of USRRDY4 field.
	EVSYS_CHSTATUS_USRRDY4_Msk = 0x10
	// Bit USRRDY4.
	EVSYS_CHSTATUS_USRRDY4 = 0x10
	// Position of USRRDY5 field.
	EVSYS_CHSTATUS_USRRDY5_Pos = 0x5
	// Bit mask of USRRDY5 field.
	EVSYS_CHSTATUS_USRRDY5_Msk = 0x20
	// Bit USRRDY5.
	EVSYS_CHSTATUS_USRRDY5 = 0x20
	// Position of USRRDY6 field.
	EVSYS_CHSTATUS_USRRDY6_Pos = 0x6
	// Bit mask of USRRDY6 field.
	EVSYS_CHSTATUS_USRRDY6_Msk = 0x40
	// Bit USRRDY6.
	EVSYS_CHSTATUS_USRRDY6 = 0x40
	// Position of USRRDY7 field.
	EVSYS_CHSTATUS_USRRDY7_Pos = 0x7
	// Bit mask of USRRDY7 field.
	EVSYS_CHSTATUS_USRRDY7_Msk = 0x80
	// Bit USRRDY7.
	EVSYS_CHSTATUS_USRRDY7 = 0x80
	// Position of CHBUSY0 field.
	EVSYS_CHSTATUS_CHBUSY0_Pos = 0x10
	// Bit mask of CHBUSY0 field.
	EVSYS_CHSTATUS_CHBUSY0_Msk = 0x10000
	// Bit CHBUSY0.
	EVSYS_CHSTATUS_CHBUSY0 = 0x10000
	// Position of CHBUSY1 field.
	EVSYS_CHSTATUS_CHBUSY1_Pos = 0x11
	// Bit mask of CHBUSY1 field.
	EVSYS_CHSTATUS_CHBUSY1_Msk = 0x20000
	// Bit CHBUSY1.
	EVSYS_CHSTATUS_CHBUSY1 = 0x20000
	// Position of CHBUSY2 field.
	EVSYS_CHSTATUS_CHBUSY2_Pos = 0x12
	// Bit mask of CHBUSY2 field.
	EVSYS_CHSTATUS_CHBUSY2_Msk = 0x40000
	// Bit CHBUSY2.
	EVSYS_CHSTATUS_CHBUSY2 = 0x40000
	// Position of CHBUSY3 field.
	EVSYS_CHSTATUS_CHBUSY3_Pos = 0x13
	// Bit mask of CHBUSY3 field.
	EVSYS_CHSTATUS_CHBUSY3_Msk = 0x80000
	// Bit CHBUSY3.
	EVSYS_CHSTATUS_CHBUSY3 = 0x80000
	// Position of CHBUSY4 field.
	EVSYS_CHSTATUS_CHBUSY4_Pos = 0x14
	// Bit mask of CHBUSY4 field.
	EVSYS_CHSTATUS_CHBUSY4_Msk = 0x100000
	// Bit CHBUSY4.
	EVSYS_CHSTATUS_CHBUSY4 = 0x100000
	// Position of CHBUSY5 field.
	EVSYS_CHSTATUS_CHBUSY5_Pos = 0x15
	// Bit mask of CHBUSY5 field.
	EVSYS_CHSTATUS_CHBUSY5_Msk = 0x200000
	// Bit CHBUSY5.
	EVSYS_CHSTATUS_CHBUSY5 = 0x200000
	// Position of CHBUSY6 field.
	EVSYS_CHSTATUS_CHBUSY6_Pos = 0x16
	// Bit mask of CHBUSY6 field.
	EVSYS_CHSTATUS_CHBUSY6_Msk = 0x400000
	// Bit CHBUSY6.
	EVSYS_CHSTATUS_CHBUSY6 = 0x400000
	// Position of CHBUSY7 field.
	EVSYS_CHSTATUS_CHBUSY7_Pos = 0x17
	// Bit mask of CHBUSY7 field.
	EVSYS_CHSTATUS_CHBUSY7_Msk = 0x800000
	// Bit CHBUSY7.
	EVSYS_CHSTATUS_CHBUSY7 = 0x800000

	// INTENCLR: Interrupt Enable Clear
	// Position of OVR0 field.
	EVSYS_INTENCLR_OVR0_Pos = 0x0
	// Bit mask of OVR0 field.
	EVSYS_INTENCLR_OVR0_Msk = 0x1
	// Bit OVR0.
	EVSYS_INTENCLR_OVR0 = 0x1
	// Position of OVR1 field.
	EVSYS_INTENCLR_OVR1_Pos = 0x1
	// Bit mask of OVR1 field.
	EVSYS_INTENCLR_OVR1_Msk = 0x2
	// Bit OVR1.
	EVSYS_INTENCLR_OVR1 = 0x2
	// Position of OVR2 field.
	EVSYS_INTENCLR_OVR2_Pos = 0x2
	// Bit mask of OVR2 field.
	EVSYS_INTENCLR_OVR2_Msk = 0x4
	// Bit OVR2.
	EVSYS_INTENCLR_OVR2 = 0x4
	// Position of OVR3 field.
	EVSYS_INTENCLR_OVR3_Pos = 0x3
	// Bit mask of OVR3 field.
	EVSYS_INTENCLR_OVR3_Msk = 0x8
	// Bit OVR3.
	EVSYS_INTENCLR_OVR3 = 0x8
	// Position of OVR4 field.
	EVSYS_INTENCLR_OVR4_Pos = 0x4
	// Bit mask of OVR4 field.
	EVSYS_INTENCLR_OVR4_Msk = 0x10
	// Bit OVR4.
	EVSYS_INTENCLR_OVR4 = 0x10
	// Position of OVR5 field.
	EVSYS_INTENCLR_OVR5_Pos = 0x5
	// Bit mask of OVR5 field.
	EVSYS_INTENCLR_OVR5_Msk = 0x20
	// Bit OVR5.
	EVSYS_INTENCLR_OVR5 = 0x20
	// Position of OVR6 field.
	EVSYS_INTENCLR_OVR6_Pos = 0x6
	// Bit mask of OVR6 field.
	EVSYS_INTENCLR_OVR6_Msk = 0x40
	// Bit OVR6.
	EVSYS_INTENCLR_OVR6 = 0x40
	// Position of OVR7 field.
	EVSYS_INTENCLR_OVR7_Pos = 0x7
	// Bit mask of OVR7 field.
	EVSYS_INTENCLR_OVR7_Msk = 0x80
	// Bit OVR7.
	EVSYS_INTENCLR_OVR7 = 0x80
	// Position of EVD0 field.
	EVSYS_INTENCLR_EVD0_Pos = 0x10
	// Bit mask of EVD0 field.
	EVSYS_INTENCLR_EVD0_Msk = 0x10000
	// Bit EVD0.
	EVSYS_INTENCLR_EVD0 = 0x10000
	// Position of EVD1 field.
	EVSYS_INTENCLR_EVD1_Pos = 0x11
	// Bit mask of EVD1 field.
	EVSYS_INTENCLR_EVD1_Msk = 0x20000
	// Bit EVD1.
	EVSYS_INTENCLR_EVD1 = 0x20000
	// Position of EVD2 field.
	EVSYS_INTENCLR_EVD2_Pos = 0x12
	// Bit mask of EVD2 field.
	EVSYS_INTENCLR_EVD2_Msk = 0x40000
	// Bit EVD2.
	EVSYS_INTENCLR_EVD2 = 0x40000
	// Position of EVD3 field.
	EVSYS_INTENCLR_EVD3_Pos = 0x13
	// Bit mask of EVD3 field.
	EVSYS_INTENCLR_EVD3_Msk = 0x80000
	// Bit EVD3.
	EVSYS_INTENCLR_EVD3 = 0x80000
	// Position of EVD4 field.
	EVSYS_INTENCLR_EVD4_Pos = 0x14
	// Bit mask of EVD4 field.
	EVSYS_INTENCLR_EVD4_Msk = 0x100000
	// Bit EVD4.
	EVSYS_INTENCLR_EVD4 = 0x100000
	// Position of EVD5 field.
	EVSYS_INTENCLR_EVD5_Pos = 0x15
	// Bit mask of EVD5 field.
	EVSYS_INTENCLR_EVD5_Msk = 0x200000
	// Bit EVD5.
	EVSYS_INTENCLR_EVD5 = 0x200000
	// Position of EVD6 field.
	EVSYS_INTENCLR_EVD6_Pos = 0x16
	// Bit mask of EVD6 field.
	EVSYS_INTENCLR_EVD6_Msk = 0x400000
	// Bit EVD6.
	EVSYS_INTENCLR_EVD6 = 0x400000
	// Position of EVD7 field.
	EVSYS_INTENCLR_EVD7_Pos = 0x17
	// Bit mask of EVD7 field.
	EVSYS_INTENCLR_EVD7_Msk = 0x800000
	// Bit EVD7.
	EVSYS_INTENCLR_EVD7 = 0x800000

	// INTENSET: Interrupt Enable Set
	// Position of OVR0 field.
	EVSYS_INTENSET_OVR0_Pos = 0x0
	// Bit mask of OVR0 field.
	EVSYS_INTENSET_OVR0_Msk = 0x1
	// Bit OVR0.
	EVSYS_INTENSET_OVR0 = 0x1
	// Position of OVR1 field.
	EVSYS_INTENSET_OVR1_Pos = 0x1
	// Bit mask of OVR1 field.
	EVSYS_INTENSET_OVR1_Msk = 0x2
	// Bit OVR1.
	EVSYS_INTENSET_OVR1 = 0x2
	// Position of OVR2 field.
	EVSYS_INTENSET_OVR2_Pos = 0x2
	// Bit mask of OVR2 field.
	EVSYS_INTENSET_OVR2_Msk = 0x4
	// Bit OVR2.
	EVSYS_INTENSET_OVR2 = 0x4
	// Position of OVR3 field.
	EVSYS_INTENSET_OVR3_Pos = 0x3
	// Bit mask of OVR3 field.
	EVSYS_INTENSET_OVR3_Msk = 0x8
	// Bit OVR3.
	EVSYS_INTENSET_OVR3 = 0x8
	// Position of OVR4 field.
	EVSYS_INTENSET_OVR4_Pos = 0x4
	// Bit mask of OVR4 field.
	EVSYS_INTENSET_OVR4_Msk = 0x10
	// Bit OVR4.
	EVSYS_INTENSET_OVR4 = 0x10
	// Position of OVR5 field.
	EVSYS_INTENSET_OVR5_Pos = 0x5
	// Bit mask of OVR5 field.
	EVSYS_INTENSET_OVR5_Msk = 0x20
	// Bit OVR5.
	EVSYS_INTENSET_OVR5 = 0x20
	// Position of OVR6 field.
	EVSYS_INTENSET_OVR6_Pos = 0x6
	// Bit mask of OVR6 field.
	EVSYS_INTENSET_OVR6_Msk = 0x40
	// Bit OVR6.
	EVSYS_INTENSET_OVR6 = 0x40
	// Position of OVR7 field.
	EVSYS_INTENSET_OVR7_Pos = 0x7
	// Bit mask of OVR7 field.
	EVSYS_INTENSET_OVR7_Msk = 0x80
	// Bit OVR7.
	EVSYS_INTENSET_OVR7 = 0x80
	// Position of EVD0 field.
	EVSYS_INTENSET_EVD0_Pos = 0x10
	// Bit mask of EVD0 field.
	EVSYS_INTENSET_EVD0_Msk = 0x10000
	// Bit EVD0.
	EVSYS_INTENSET_EVD0 = 0x10000
	// Position of EVD1 field.
	EVSYS_INTENSET_EVD1_Pos = 0x11
	// Bit mask of EVD1 field.
	EVSYS_INTENSET_EVD1_Msk = 0x20000
	// Bit EVD1.
	EVSYS_INTENSET_EVD1 = 0x20000
	// Position of EVD2 field.
	EVSYS_INTENSET_EVD2_Pos = 0x12
	// Bit mask of EVD2 field.
	EVSYS_INTENSET_EVD2_Msk = 0x40000
	// Bit EVD2.
	EVSYS_INTENSET_EVD2 = 0x40000
	// Position of EVD3 field.
	EVSYS_INTENSET_EVD3_Pos = 0x13
	// Bit mask of EVD3 field.
	EVSYS_INTENSET_EVD3_Msk = 0x80000
	// Bit EVD3.
	EVSYS_INTENSET_EVD3 = 0x80000
	// Position of EVD4 field.
	EVSYS_INTENSET_EVD4_Pos = 0x14
	// Bit mask of EVD4 field.
	EVSYS_INTENSET_EVD4_Msk = 0x100000
	// Bit EVD4.
	EVSYS_INTENSET_EVD4 = 0x100000
	// Position of EVD5 field.
	EVSYS_INTENSET_EVD5_Pos = 0x15
	// Bit mask of EVD5 field.
	EVSYS_INTENSET_EVD5_Msk = 0x200000
	// Bit EVD5.
	EVSYS_INTENSET_EVD5 = 0x200000
	// Position of EVD6 field.
	EVSYS_INTENSET_EVD6_Pos = 0x16
	// Bit mask of EVD6 field.
	EVSYS_INTENSET_EVD6_Msk = 0x400000
	// Bit EVD6.
	EVSYS_INTENSET_EVD6 = 0x400000
	// Position of EVD7 field.
	EVSYS_INTENSET_EVD7_Pos = 0x17
	// Bit mask of EVD7 field.
	EVSYS_INTENSET_EVD7_Msk = 0x800000
	// Bit EVD7.
	EVSYS_INTENSET_EVD7 = 0x800000

	// INTFLAG: Interrupt Flag Status and Clear
	// Position of OVR0 field.
	EVSYS_INTFLAG_OVR0_Pos = 0x0
	// Bit mask of OVR0 field.
	EVSYS_INTFLAG_OVR0_Msk = 0x1
	// Bit OVR0.
	EVSYS_INTFLAG_OVR0 = 0x1
	// Position of OVR1 field.
	EVSYS_INTFLAG_OVR1_Pos = 0x1
	// Bit mask of OVR1 field.
	EVSYS_INTFLAG_OVR1_Msk = 0x2
	// Bit OVR1.
	EVSYS_INTFLAG_OVR1 = 0x2
	// Position of OVR2 field.
	EVSYS_INTFLAG_OVR2_Pos = 0x2
	// Bit mask of OVR2 field.
	EVSYS_INTFLAG_OVR2_Msk = 0x4
	// Bit OVR2.
	EVSYS_INTFLAG_OVR2 = 0x4
	// Position of OVR3 field.
	EVSYS_INTFLAG_OVR3_Pos = 0x3
	// Bit mask of OVR3 field.
	EVSYS_INTFLAG_OVR3_Msk = 0x8
	// Bit OVR3.
	EVSYS_INTFLAG_OVR3 = 0x8
	// Position of OVR4 field.
	EVSYS_INTFLAG_OVR4_Pos = 0x4
	// Bit mask of OVR4 field.
	EVSYS_INTFLAG_OVR4_Msk = 0x10
	// Bit OVR4.
	EVSYS_INTFLAG_OVR4 = 0x10
	// Position of OVR5 field.
	EVSYS_INTFLAG_OVR5_Pos = 0x5
	// Bit mask of OVR5 field.
	EVSYS_INTFLAG_OVR5_Msk = 0x20
	// Bit OVR5.
	EVSYS_INTFLAG_OVR5 = 0x20
	// Position of OVR6 field.
	EVSYS_INTFLAG_OVR6_Pos = 0x6
	// Bit mask of OVR6 field.
	EVSYS_INTFLAG_OVR6_Msk = 0x40
	// Bit OVR6.
	EVSYS_INTFLAG_OVR6 = 0x40
	// Position of OVR7 field.
	EVSYS_INTFLAG_OVR7_Pos = 0x7
	// Bit mask of OVR7 field.
	EVSYS_INTFLAG_OVR7_Msk = 0x80
	// Bit OVR7.
	EVSYS_INTFLAG_OVR7 = 0x80
	// Position of EVD0 field.
	EVSYS_INTFLAG_EVD0_Pos = 0x10
	// Bit mask of EVD0 field.
	EVSYS_INTFLAG_EVD0_Msk = 0x10000
	// Bit EVD0.
	EVSYS_INTFLAG_EVD0 = 0x10000
	// Position of EVD1 field.
	EVSYS_INTFLAG_EVD1_Pos = 0x11
	// Bit mask of EVD1 field.
	EVSYS_INTFLAG_EVD1_Msk = 0x20000
	// Bit EVD1.
	EVSYS_INTFLAG_EVD1 = 0x20000
	// Position of EVD2 field.
	EVSYS_INTFLAG_EVD2_Pos = 0x12
	// Bit mask of EVD2 field.
	EVSYS_INTFLAG_EVD2_Msk = 0x40000
	// Bit EVD2.
	EVSYS_INTFLAG_EVD2 = 0x40000
	// Position of EVD3 field.
	EVSYS_INTFLAG_EVD3_Pos = 0x13
	// Bit mask of EVD3 field.
	EVSYS_INTFLAG_EVD3_Msk = 0x80000
	// Bit EVD3.
	EVSYS_INTFLAG_EVD3 = 0x80000
	// Position of EVD4 field.
	EVSYS_INTFLAG_EVD4_Pos = 0x14
	// Bit mask of EVD4 field.
	EVSYS_INTFLAG_EVD4_Msk = 0x100000
	// Bit EVD4.
	EVSYS_INTFLAG_EVD4 = 0x100000
	// Position of EVD5 field.
	EVSYS_INTFLAG_EVD5_Pos = 0x15
	// Bit mask of EVD5 field.
	EVSYS_INTFLAG_EVD5_Msk = 0x200000
	// Bit EVD5.
	EVSYS_INTFLAG_EVD5 = 0x200000
	// Position of EVD6 field.
	EVSYS_INTFLAG_EVD6_Pos = 0x16
	// Bit mask of EVD6 field.
	EVSYS_INTFLAG_EVD6_Msk = 0x400000
	// Bit EVD6.
	EVSYS_INTFLAG_EVD6 = 0x400000
	// Position of EVD7 field.
	EVSYS_INTFLAG_EVD7_Pos = 0x17
	// Bit mask of EVD7 field.
	EVSYS_INTFLAG_EVD7_Msk = 0x800000
	// Bit EVD7.
	EVSYS_INTFLAG_EVD7 = 0x800000

	// SWEVT: Software Event
	// Position of CHANNEL0 field.
	EVSYS_SWEVT_CHANNEL0_Pos = 0x0
	// Bit mask of CHANNEL0 field.
	EVSYS_SWEVT_CHANNEL0_Msk = 0x1
	// Bit CHANNEL0.
	EVSYS_SWEVT_CHANNEL0 = 0x1
	// Position of CHANNEL1 field.
	EVSYS_SWEVT_CHANNEL1_Pos = 0x1
	// Bit mask of CHANNEL1 field.
	EVSYS_SWEVT_CHANNEL1_Msk = 0x2
	// Bit CHANNEL1.
	EVSYS_SWEVT_CHANNEL1 = 0x2
	// Position of CHANNEL2 field.
	EVSYS_SWEVT_CHANNEL2_Pos = 0x2
	// Bit mask of CHANNEL2 field.
	EVSYS_SWEVT_CHANNEL2_Msk = 0x4
	// Bit CHANNEL2.
	EVSYS_SWEVT_CHANNEL2 = 0x4
	// Position of CHANNEL3 field.
	EVSYS_SWEVT_CHANNEL3_Pos = 0x3
	// Bit mask of CHANNEL3 field.
	EVSYS_SWEVT_CHANNEL3_Msk = 0x8
	// Bit CHANNEL3.
	EVSYS_SWEVT_CHANNEL3 = 0x8
	// Position of CHANNEL4 field.
	EVSYS_SWEVT_CHANNEL4_Pos = 0x4
	// Bit mask of CHANNEL4 field.
	EVSYS_SWEVT_CHANNEL4_Msk = 0x10
	// Bit CHANNEL4.
	EVSYS_SWEVT_CHANNEL4 = 0x10
	// Position of CHANNEL5 field.
	EVSYS_SWEVT_CHANNEL5_Pos = 0x5
	// Bit mask of CHANNEL5 field.
	EVSYS_SWEVT_CHANNEL5_Msk = 0x20
	// Bit CHANNEL5.
	EVSYS_SWEVT_CHANNEL5 = 0x20
	// Position of CHANNEL6 field.
	EVSYS_SWEVT_CHANNEL6_Pos = 0x6
	// Bit mask of CHANNEL6 field.
	EVSYS_SWEVT_CHANNEL6_Msk = 0x40
	// Bit CHANNEL6.
	EVSYS_SWEVT_CHANNEL6 = 0x40
	// Position of CHANNEL7 field.
	EVSYS_SWEVT_CHANNEL7_Pos = 0x7
	// Bit mask of CHANNEL7 field.
	EVSYS_SWEVT_CHANNEL7_Msk = 0x80
	// Bit CHANNEL7.
	EVSYS_SWEVT_CHANNEL7 = 0x80

	// CHANNEL0: Channel n
	// Position of EVGEN field.
	EVSYS_CHANNEL_EVGEN_Pos = 0x0
	// Bit mask of EVGEN field.
	EVSYS_CHANNEL_EVGEN_Msk = 0x7f
	// Position of PATH field.
	EVSYS_CHANNEL_PATH_Pos = 0x8
	// Bit mask of PATH field.
	EVSYS_CHANNEL_PATH_Msk = 0x300
	// Synchronous path
	EVSYS_CHANNEL_PATH_SYNCHRONOUS = 0x0
	// Resynchronized path
	EVSYS_CHANNEL_PATH_RESYNCHRONIZED = 0x1
	// Asynchronous path
	EVSYS_CHANNEL_PATH_ASYNCHRONOUS = 0x2
	// Position of EDGSEL field.
	EVSYS_CHANNEL_EDGSEL_Pos = 0xa
	// Bit mask of EDGSEL field.
	EVSYS_CHANNEL_EDGSEL_Msk = 0xc00
	// No event output when using the resynchronized or synchronous path
	EVSYS_CHANNEL_EDGSEL_NO_EVT_OUTPUT = 0x0
	// Event detection only on the rising edge of the signal from the event generator when using the resynchronized or synchronous path
	EVSYS_CHANNEL_EDGSEL_RISING_EDGE = 0x1
	// Event detection only on the falling edge of the signal from the event generator when using the resynchronized or synchronous path
	EVSYS_CHANNEL_EDGSEL_FALLING_EDGE = 0x2
	// Event detection on rising and falling edges of the signal from the event generator when using the resynchronized or synchronous path
	EVSYS_CHANNEL_EDGSEL_BOTH_EDGES = 0x3
	// Position of RUNSTDBY field.
	EVSYS_CHANNEL_RUNSTDBY_Pos = 0xe
	// Bit mask of RUNSTDBY field.
	EVSYS_CHANNEL_RUNSTDBY_Msk = 0x4000
	// Bit RUNSTDBY.
	EVSYS_CHANNEL_RUNSTDBY = 0x4000
	// Position of ONDEMAND field.
	EVSYS_CHANNEL_ONDEMAND_Pos = 0xf
	// Bit mask of ONDEMAND field.
	EVSYS_CHANNEL_ONDEMAND_Msk = 0x8000
	// Bit ONDEMAND.
	EVSYS_CHANNEL_ONDEMAND = 0x8000

	// USER0: User Multiplexer n
	// Position of CHANNEL field.
	EVSYS_USER_CHANNEL_Pos = 0x0
	// Bit mask of CHANNEL field.
	EVSYS_USER_CHANNEL_Msk = 0xf
)

// Constants for FREQM: Frequency Meter
const (
	// CTRLA: Control A Register
	// Position of SWRST field.
	FREQM_CTRLA_SWRST_Pos = 0x0
	// Bit mask of SWRST field.
	FREQM_CTRLA_SWRST_Msk = 0x1
	// Bit SWRST.
	FREQM_CTRLA_SWRST = 0x1
	// Position of ENABLE field.
	FREQM_CTRLA_ENABLE_Pos = 0x1
	// Bit mask of ENABLE field.
	FREQM_CTRLA_ENABLE_Msk = 0x2
	// Bit ENABLE.
	FREQM_CTRLA_ENABLE = 0x2

	// CTRLB: Control B Register
	// Position of START field.
	FREQM_CTRLB_START_Pos = 0x0
	// Bit mask of START field.
	FREQM_CTRLB_START_Msk = 0x1
	// Bit START.
	FREQM_CTRLB_START = 0x1

	// CFGA: Config A register
	// Position of REFNUM field.
	FREQM_CFGA_REFNUM_Pos = 0x0
	// Bit mask of REFNUM field.
	FREQM_CFGA_REFNUM_Msk = 0xff

	// INTENCLR: Interrupt Enable Clear Register
	// Position of DONE field.
	FREQM_INTENCLR_DONE_Pos = 0x0
	// Bit mask of DONE field.
	FREQM_INTENCLR_DONE_Msk = 0x1
	// Bit DONE.
	FREQM_INTENCLR_DONE = 0x1

	// INTENSET: Interrupt Enable Set Register
	// Position of DONE field.
	FREQM_INTENSET_DONE_Pos = 0x0
	// Bit mask of DONE field.
	FREQM_INTENSET_DONE_Msk = 0x1
	// Bit DONE.
	FREQM_INTENSET_DONE = 0x1

	// INTFLAG: Interrupt Flag Register
	// Position of DONE field.
	FREQM_INTFLAG_DONE_Pos = 0x0
	// Bit mask of DONE field.
	FREQM_INTFLAG_DONE_Msk = 0x1
	// Bit DONE.
	FREQM_INTFLAG_DONE = 0x1

	// STATUS: Status Register
	// Position of BUSY field.
	FREQM_STATUS_BUSY_Pos = 0x0
	// Bit mask of BUSY field.
	FREQM_STATUS_BUSY_Msk = 0x1
	// Bit BUSY.
	FREQM_STATUS_BUSY = 0x1
	// Position of OVF field.
	FREQM_STATUS_OVF_Pos = 0x1
	// Bit mask of OVF field.
	FREQM_STATUS_OVF_Msk = 0x2
	// Bit OVF.
	FREQM_STATUS_OVF = 0x2

	// SYNCBUSY: Synchronization Busy Register
	// Position of SWRST field.
	FREQM_SYNCBUSY_SWRST_Pos = 0x0
	// Bit mask of SWRST field.
	FREQM_SYNCBUSY_SWRST_Msk = 0x1
	// Bit SWRST.
	FREQM_SYNCBUSY_SWRST = 0x1
	// Position of ENABLE field.
	FREQM_SYNCBUSY_ENABLE_Pos = 0x1
	// Bit mask of ENABLE field.
	FREQM_SYNCBUSY_ENABLE_Msk = 0x2
	// Bit ENABLE.
	FREQM_SYNCBUSY_ENABLE = 0x2

	// VALUE: Count Value Register
	// Position of VALUE field.
	FREQM_VALUE_VALUE_Pos = 0x0
	// Bit mask of VALUE field.
	FREQM_VALUE_VALUE_Msk = 0xffffff
)

// Constants for GCLK: Generic Clock Generator
const (
	// CTRLA: Control
	// Position of SWRST field.
	GCLK_CTRLA_SWRST_Pos = 0x0
	// Bit mask of SWRST field.
	GCLK_CTRLA_SWRST_Msk = 0x1
	// Bit SWRST.
	GCLK_CTRLA_SWRST = 0x1

	// SYNCBUSY: Synchronization Busy
	// Position of SWRST field.
	GCLK_SYNCBUSY_SWRST_Pos = 0x0
	// Bit mask of SWRST field.
	GCLK_SYNCBUSY_SWRST_Msk = 0x1
	// Bit SWRST.
	GCLK_SYNCBUSY_SWRST = 0x1
	// Position of GENCTRL0 field.
	GCLK_SYNCBUSY_GENCTRL0_Pos = 0x2
	// Bit mask of GENCTRL0 field.
	GCLK_SYNCBUSY_GENCTRL0_Msk = 0x4
	// Bit GENCTRL0.
	GCLK_SYNCBUSY_GENCTRL0 = 0x4
	// Generic clock generator 0
	GCLK_SYNCBUSY_GENCTRL0_GCLK0 = 0x1
	// Generic clock generator 1
	GCLK_SYNCBUSY_GENCTRL0_GCLK1 = 0x2
	// Generic clock generator 2
	GCLK_SYNCBUSY_GENCTRL0_GCLK2 = 0x4
	// Generic clock generator 3
	GCLK_SYNCBUSY_GENCTRL0_GCLK3 = 0x8
	// Generic clock generator 4
	GCLK_SYNCBUSY_GENCTRL0_GCLK4 = 0x10
	// Position of GENCTRL1 field.
	GCLK_SYNCBUSY_GENCTRL1_Pos = 0x3
	// Bit mask of GENCTRL1 field.
	GCLK_SYNCBUSY_GENCTRL1_Msk = 0x8
	// Bit GENCTRL1.
	GCLK_SYNCBUSY_GENCTRL1 = 0x8
	// Generic clock generator 0
	GCLK_SYNCBUSY_GENCTRL1_GCLK0 = 0x1
	// Generic clock generator 1
	GCLK_SYNCBUSY_GENCTRL1_GCLK1 = 0x2
	// Generic clock generator 2
	GCLK_SYNCBUSY_GENCTRL1_GCLK2 = 0x4
	// Generic clock generator 3
	GCLK_SYNCBUSY_GENCTRL1_GCLK3 = 0x8
	// Generic clock generator 4
	GCLK_SYNCBUSY_GENCTRL1_GCLK4 = 0x10
	// Position of GENCTRL2 field.
	GCLK_SYNCBUSY_GENCTRL2_Pos = 0x4
	// Bit mask of GENCTRL2 field.
	GCLK_SYNCBUSY_GENCTRL2_Msk = 0x10
	// Bit GENCTRL2.
	GCLK_SYNCBUSY_GENCTRL2 = 0x10
	// Generic clock generator 0
	GCLK_SYNCBUSY_GENCTRL2_GCLK0 = 0x1
	// Generic clock generator 1
	GCLK_SYNCBUSY_GENCTRL2_GCLK1 = 0x2
	// Generic clock generator 2
	GCLK_SYNCBUSY_GENCTRL2_GCLK2 = 0x4
	// Generic clock generator 3
	GCLK_SYNCBUSY_GENCTRL2_GCLK3 = 0x8
	// Generic clock generator 4
	GCLK_SYNCBUSY_GENCTRL2_GCLK4 = 0x10
	// Position of GENCTRL3 field.
	GCLK_SYNCBUSY_GENCTRL3_Pos = 0x5
	// Bit mask of GENCTRL3 field.
	GCLK_SYNCBUSY_GENCTRL3_Msk = 0x20
	// Bit GENCTRL3.
	GCLK_SYNCBUSY_GENCTRL3 = 0x20
	// Generic clock generator 0
	GCLK_SYNCBUSY_GENCTRL3_GCLK0 = 0x1
	// Generic clock generator 1
	GCLK_SYNCBUSY_GENCTRL3_GCLK1 = 0x2
	// Generic clock generator 2
	GCLK_SYNCBUSY_GENCTRL3_GCLK2 = 0x4
	// Generic clock generator 3
	GCLK_SYNCBUSY_GENCTRL3_GCLK3 = 0x8
	// Generic clock generator 4
	GCLK_SYNCBUSY_GENCTRL3_GCLK4 = 0x10
	// Position of GENCTRL4 field.
	GCLK_SYNCBUSY_GENCTRL4_Pos = 0x6
	// Bit mask of GENCTRL4 field.
	GCLK_SYNCBUSY_GENCTRL4_Msk = 0x40
	// Bit GENCTRL4.
	GCLK_SYNCBUSY_GENCTRL4 = 0x40
	// Generic clock generator 0
	GCLK_SYNCBUSY_GENCTRL4_GCLK0 = 0x1
	// Generic clock generator 1
	GCLK_SYNCBUSY_GENCTRL4_GCLK1 = 0x2
	// Generic clock generator 2
	GCLK_SYNCBUSY_GENCTRL4_GCLK2 = 0x4
	// Generic clock generator 3
	GCLK_SYNCBUSY_GENCTRL4_GCLK3 = 0x8
	// Generic clock generator 4
	GCLK_SYNCBUSY_GENCTRL4_GCLK4 = 0x10

	// GENCTRL0: Generic Clock Generator Control
	// Position of SRC field.
	GCLK_GENCTRL_SRC_Pos = 0x0
	// Bit mask of SRC field.
	GCLK_GENCTRL_SRC_Msk = 0x7
	// XOSC oscillator output
	GCLK_GENCTRL_SRC_XOSC = 0x0
	// Generator input pad
	GCLK_GENCTRL_SRC_GCLKIN = 0x1
	// Generic clock generator 1 output
	GCLK_GENCTRL_SRC_GCLKGEN1 = 0x2
	// OSCULP32K oscillator output
	GCLK_GENCTRL_SRC_OSCULP32K = 0x3
	// XOSC32K oscillator output
	GCLK_GENCTRL_SRC_XOSC32K = 0x4
	// OSC16M oscillator output
	GCLK_GENCTRL_SRC_OSC16M = 0x5
	// DFLL48M output
	GCLK_GENCTRL_SRC_DFLL48M = 0x6
	// DPLL96M output
	GCLK_GENCTRL_SRC_DPLL96M = 0x7
	// Position of GENEN field.
	GCLK_GENCTRL_GENEN_Pos = 0x8
	// Bit mask of GENEN field.
	GCLK_GENCTRL_GENEN_Msk = 0x100
	// Bit GENEN.
	GCLK_GENCTRL_GENEN = 0x100
	// Position of IDC field.
	GCLK_GENCTRL_IDC_Pos = 0x9
	// Bit mask of IDC field.
	GCLK_GENCTRL_IDC_Msk = 0x200
	// Bit IDC.
	GCLK_GENCTRL_IDC = 0x200
	// Position of OOV field.
	GCLK_GENCTRL_OOV_Pos = 0xa
	// Bit mask of OOV field.
	GCLK_GENCTRL_OOV_Msk = 0x400
	// Bit OOV.
	GCLK_GENCTRL_OOV = 0x400
	// Position of OE field.
	GCLK_GENCTRL_OE_Pos = 0xb
	// Bit mask of OE field.
	GCLK_GENCTRL_OE_Msk = 0x800
	// Bit OE.
	GCLK_GENCTRL_OE = 0x800
	// Position of DIVSEL field.
	GCLK_GENCTRL_DIVSEL_Pos = 0xc
	// Bit mask of DIVSEL field.
	GCLK_GENCTRL_DIVSEL_Msk = 0x1000
	// Bit DIVSEL.
	GCLK_GENCTRL_DIVSEL = 0x1000
	// Position of RUNSTDBY field.
	GCLK_GENCTRL_RUNSTDBY_Pos = 0xd
	// Bit mask of RUNSTDBY field.
	GCLK_GENCTRL_RUNSTDBY_Msk = 0x2000
	// Bit RUNSTDBY.
	GCLK_GENCTRL_RUNSTDBY = 0x2000
	// Position of DIV field.
	GCLK_GENCTRL_DIV_Pos = 0x10
	// Bit mask of DIV field.
	GCLK_GENCTRL_DIV_Msk = 0xffff0000

	// PCHCTRL0: Peripheral Clock Control
	// Position of GEN field.
	GCLK_PCHCTRL_GEN_Pos = 0x0
	// Bit mask of GEN field.
	GCLK_PCHCTRL_GEN_Msk = 0x7
	// Generic clock generator 0
	GCLK_PCHCTRL_GEN_GCLK0 = 0x0
	// Generic clock generator 1
	GCLK_PCHCTRL_GEN_GCLK1 = 0x1
	// Generic clock generator 2
	GCLK_PCHCTRL_GEN_GCLK2 = 0x2
	// Generic clock generator 3
	GCLK_PCHCTRL_GEN_GCLK3 = 0x3
	// Generic clock generator 4
	GCLK_PCHCTRL_GEN_GCLK4 = 0x4
	// Position of CHEN field.
	GCLK_PCHCTRL_CHEN_Pos = 0x6
	// Bit mask of CHEN field.
	GCLK_PCHCTRL_CHEN_Msk = 0x40
	// Bit CHEN.
	GCLK_PCHCTRL_CHEN = 0x40
	// Position of WRTLOCK field.
	GCLK_PCHCTRL_WRTLOCK_Pos = 0x7
	// Bit mask of WRTLOCK field.
	GCLK_PCHCTRL_WRTLOCK_Msk = 0x80
	// Bit WRTLOCK.
	GCLK_PCHCTRL_WRTLOCK = 0x80
)

// Constants for MCLK: Main Clock
const (
	// INTENCLR: Interrupt Enable Clear
	// Position of CKRDY field.
	MCLK_INTENCLR_CKRDY_Pos = 0x0
	// Bit mask of CKRDY field.
	MCLK_INTENCLR_CKRDY_Msk = 0x1
	// Bit CKRDY.
	MCLK_INTENCLR_CKRDY = 0x1

	// INTENSET: Interrupt Enable Set
	// Position of CKRDY field.
	MCLK_INTENSET_CKRDY_Pos = 0x0
	// Bit mask of CKRDY field.
	MCLK_INTENSET_CKRDY_Msk = 0x1
	// Bit CKRDY.
	MCLK_INTENSET_CKRDY = 0x1

	// INTFLAG: Interrupt Flag Status and Clear
	// Position of CKRDY field.
	MCLK_INTFLAG_CKRDY_Pos = 0x0
	// Bit mask of CKRDY field.
	MCLK_INTFLAG_CKRDY_Msk = 0x1
	// Bit CKRDY.
	MCLK_INTFLAG_CKRDY = 0x1

	// CPUDIV: CPU Clock Division
	// Position of CPUDIV field.
	MCLK_CPUDIV_CPUDIV_Pos = 0x0
	// Bit mask of CPUDIV field.
	MCLK_CPUDIV_CPUDIV_Msk = 0xff
	// Divide by 1
	MCLK_CPUDIV_CPUDIV_DIV1 = 0x1
	// Divide by 2
	MCLK_CPUDIV_CPUDIV_DIV2 = 0x2
	// Divide by 4
	MCLK_CPUDIV_CPUDIV_DIV4 = 0x4
	// Divide by 8
	MCLK_CPUDIV_CPUDIV_DIV8 = 0x8
	// Divide by 16
	MCLK_CPUDIV_CPUDIV_DIV16 = 0x10
	// Divide by 32
	MCLK_CPUDIV_CPUDIV_DIV32 = 0x20
	// Divide by 64
	MCLK_CPUDIV_CPUDIV_DIV64 = 0x40
	// Divide by 128
	MCLK_CPUDIV_CPUDIV_DIV128 = 0x80

	// BUPDIV: Backup Clock Division
	// Position of BUPDIV field.
	MCLK_BUPDIV_BUPDIV_Pos = 0x0
	// Bit mask of BUPDIV field.
	MCLK_BUPDIV_BUPDIV_Msk = 0xff
	// Divide by 1
	MCLK_BUPDIV_BUPDIV_DIV1 = 0x1
	// Divide by 2
	MCLK_BUPDIV_BUPDIV_DIV2 = 0x2
	// Divide by 4
	MCLK_BUPDIV_BUPDIV_DIV4 = 0x4
	// Divide by 8
	MCLK_BUPDIV_BUPDIV_DIV8 = 0x8
	// Divide by 16
	MCLK_BUPDIV_BUPDIV_DIV16 = 0x10
	// Divide by 32
	MCLK_BUPDIV_BUPDIV_DIV32 = 0x20
	// Divide by 64
	MCLK_BUPDIV_BUPDIV_DIV64 = 0x40
	// Divide by 128
	MCLK_BUPDIV_BUPDIV_DIV128 = 0x80

	// AHBMASK: AHB Mask
	// Position of HPB0_ field.
	MCLK_AHBMASK_HPB0__Pos = 0x0
	// Bit mask of HPB0_ field.
	MCLK_AHBMASK_HPB0__Msk = 0x1
	// Bit HPB0_.
	MCLK_AHBMASK_HPB0_ = 0x1
	// Position of HPB1_ field.
	MCLK_AHBMASK_HPB1__Pos = 0x1
	// Bit mask of HPB1_ field.
	MCLK_AHBMASK_HPB1__Msk = 0x2
	// Bit HPB1_.
	MCLK_AHBMASK_HPB1_ = 0x2
	// Position of HPB2_ field.
	MCLK_AHBMASK_HPB2__Pos = 0x2
	// Bit mask of HPB2_ field.
	MCLK_AHBMASK_HPB2__Msk = 0x4
	// Bit HPB2_.
	MCLK_AHBMASK_HPB2_ = 0x4
	// Position of DMAC_ field.
	MCLK_AHBMASK_DMAC__Pos = 0x3
	// Bit mask of DMAC_ field.
	MCLK_AHBMASK_DMAC__Msk = 0x8
	// Bit DMAC_.
	MCLK_AHBMASK_DMAC_ = 0x8
	// Position of USB_ field.
	MCLK_AHBMASK_USB__Pos = 0x4
	// Bit mask of USB_ field.
	MCLK_AHBMASK_USB__Msk = 0x10
	// Bit USB_.
	MCLK_AHBMASK_USB_ = 0x10
	// Position of DSU_ field.
	MCLK_AHBMASK_DSU__Pos = 0x5
	// Bit mask of DSU_ field.
	MCLK_AHBMASK_DSU__Msk = 0x20
	// Bit DSU_.
	MCLK_AHBMASK_DSU_ = 0x20
	// Position of PAC_ field.
	MCLK_AHBMASK_PAC__Pos = 0x7
	// Bit mask of PAC_ field.
	MCLK_AHBMASK_PAC__Msk = 0x80
	// Bit PAC_.
	MCLK_AHBMASK_PAC_ = 0x80
	// Position of NVMCTRL_ field.
	MCLK_AHBMASK_NVMCTRL__Pos = 0x8
	// Bit mask of NVMCTRL_ field.
	MCLK_AHBMASK_NVMCTRL__Msk = 0x100
	// Bit NVMCTRL_.
	MCLK_AHBMASK_NVMCTRL_ = 0x100
	// Position of HSRAM_ field.
	MCLK_AHBMASK_HSRAM__Pos = 0x9
	// Bit mask of HSRAM_ field.
	MCLK_AHBMASK_HSRAM__Msk = 0x200
	// Bit HSRAM_.
	MCLK_AHBMASK_HSRAM_ = 0x200
	// Position of NVMCTRL_PICACHU_ field.
	MCLK_AHBMASK_NVMCTRL_PICACHU__Pos = 0xa
	// Bit mask of NVMCTRL_PICACHU_ field.
	MCLK_AHBMASK_NVMCTRL_PICACHU__Msk = 0x400
	// Bit NVMCTRL_PICACHU_.
	MCLK_AHBMASK_NVMCTRL_PICACHU_ = 0x400

	// APBAMASK: APBA Mask
	// Position of PAC_ field.
	MCLK_APBAMASK_PAC__Pos = 0x0
	// Bit mask of PAC_ field.
	MCLK_APBAMASK_PAC__Msk = 0x1
	// Bit PAC_.
	MCLK_APBAMASK_PAC_ = 0x1
	// Position of PM_ field.
	MCLK_APBAMASK_PM__Pos = 0x1
	// Bit mask of PM_ field.
	MCLK_APBAMASK_PM__Msk = 0x2
	// Bit PM_.
	MCLK_APBAMASK_PM_ = 0x2
	// Position of MCLK_ field.
	MCLK_APBAMASK_MCLK__Pos = 0x2
	// Bit mask of MCLK_ field.
	MCLK_APBAMASK_MCLK__Msk = 0x4
	// Bit MCLK_.
	MCLK_APBAMASK_MCLK_ = 0x4
	// Position of RSTC_ field.
	MCLK_APBAMASK_RSTC__Pos = 0x3
	// Bit mask of RSTC_ field.
	MCLK_APBAMASK_RSTC__Msk = 0x8
	// Bit RSTC_.
	MCLK_APBAMASK_RSTC_ = 0x8
	// Position of OSCCTRL_ field.
	MCLK_APBAMASK_OSCCTRL__Pos = 0x4
	// Bit mask of OSCCTRL_ field.
	MCLK_APBAMASK_OSCCTRL__Msk = 0x10
	// Bit OSCCTRL_.
	MCLK_APBAMASK_OSCCTRL_ = 0x10
	// Position of OSC32KCTRL_ field.
	MCLK_APBAMASK_OSC32KCTRL__Pos = 0x5
	// Bit mask of OSC32KCTRL_ field.
	MCLK_APBAMASK_OSC32KCTRL__Msk = 0x20
	// Bit OSC32KCTRL_.
	MCLK_APBAMASK_OSC32KCTRL_ = 0x20
	// Position of SUPC_ field.
	MCLK_APBAMASK_SUPC__Pos = 0x6
	// Bit mask of SUPC_ field.
	MCLK_APBAMASK_SUPC__Msk = 0x40
	// Bit SUPC_.
	MCLK_APBAMASK_SUPC_ = 0x40
	// Position of GCLK_ field.
	MCLK_APBAMASK_GCLK__Pos = 0x7
	// Bit mask of GCLK_ field.
	MCLK_APBAMASK_GCLK__Msk = 0x80
	// Bit GCLK_.
	MCLK_APBAMASK_GCLK_ = 0x80
	// Position of WDT_ field.
	MCLK_APBAMASK_WDT__Pos = 0x8
	// Bit mask of WDT_ field.
	MCLK_APBAMASK_WDT__Msk = 0x100
	// Bit WDT_.
	MCLK_APBAMASK_WDT_ = 0x100
	// Position of RTC_ field.
	MCLK_APBAMASK_RTC__Pos = 0x9
	// Bit mask of RTC_ field.
	MCLK_APBAMASK_RTC__Msk = 0x200
	// Bit RTC_.
	MCLK_APBAMASK_RTC_ = 0x200
	// Position of EIC_ field.
	MCLK_APBAMASK_EIC__Pos = 0xa
	// Bit mask of EIC_ field.
	MCLK_APBAMASK_EIC__Msk = 0x400
	// Bit EIC_.
	MCLK_APBAMASK_EIC_ = 0x400
	// Position of FREQM_ field.
	MCLK_APBAMASK_FREQM__Pos = 0xb
	// Bit mask of FREQM_ field.
	MCLK_APBAMASK_FREQM__Msk = 0x800
	// Bit FREQM_.
	MCLK_APBAMASK_FREQM_ = 0x800

	// APBBMASK: APBB Mask
	// Position of USB_ field.
	MCLK_APBBMASK_USB__Pos = 0x0
	// Bit mask of USB_ field.
	MCLK_APBBMASK_USB__Msk = 0x1
	// Bit USB_.
	MCLK_APBBMASK_USB_ = 0x1
	// Position of DSU_ field.
	MCLK_APBBMASK_DSU__Pos = 0x1
	// Bit mask of DSU_ field.
	MCLK_APBBMASK_DSU__Msk = 0x2
	// Bit DSU_.
	MCLK_APBBMASK_DSU_ = 0x2
	// Position of NVMCTRL_ field.
	MCLK_APBBMASK_NVMCTRL__Pos = 0x2
	// Bit mask of NVMCTRL_ field.
	MCLK_APBBMASK_NVMCTRL__Msk = 0x4
	// Bit NVMCTRL_.
	MCLK_APBBMASK_NVMCTRL_ = 0x4
	// Position of PORT_ field.
	MCLK_APBBMASK_PORT__Pos = 0x3
	// Bit mask of PORT_ field.
	MCLK_APBBMASK_PORT__Msk = 0x8
	// Bit PORT_.
	MCLK_APBBMASK_PORT_ = 0x8

	// APBCMASK: APBC Mask
	// Position of EVSYS_ field.
	MCLK_APBCMASK_EVSYS__Pos = 0x0
	// Bit mask of EVSYS_ field.
	MCLK_APBCMASK_EVSYS__Msk = 0x1
	// Bit EVSYS_.
	MCLK_APBCMASK_EVSYS_ = 0x1
	// Position of SERCOM0_ field.
	MCLK_APBCMASK_SERCOM0__Pos = 0x1
	// Bit mask of SERCOM0_ field.
	MCLK_APBCMASK_SERCOM0__Msk = 0x2
	// Bit SERCOM0_.
	MCLK_APBCMASK_SERCOM0_ = 0x2
	// Position of SERCOM1_ field.
	MCLK_APBCMASK_SERCOM1__Pos = 0x2
	// Bit mask of SERCOM1_ field.
	MCLK_APBCMASK_SERCOM1__Msk = 0x4
	// Bit SERCOM1_.
	MCLK_APBCMASK_SERCOM1_ = 0x4
	// Position of SERCOM2_ field.
	MCLK_APBCMASK_SERCOM2__Pos = 0x3
	// Bit mask of SERCOM2_ field.
	MCLK_APBCMASK_SERCOM2__Msk = 0x8
	// Bit SERCOM2_.
	MCLK_APBCMASK_SERCOM2_ = 0x8
	// Position of SERCOM3_ field.
	MCLK_APBCMASK_SERCOM3__Pos = 0x4
	// Bit mask of SERCOM3_ field.
	MCLK_APBCMASK_SERCOM3__Msk = 0x10
	// Bit SERCOM3_.
	MCLK_APBCMASK_SERCOM3_ = 0x10
	// Position of TCC0_ field.
	MCLK_APBCMASK_TCC0__Pos = 0x7
	// Bit mask of TCC0_ field.
	MCLK_APBCMASK_TCC0__Msk = 0x80
	// Bit TCC0_.
	MCLK_APBCMASK_TCC0_ = 0x80
	// Position of TC0_ field.
	MCLK_APBCMASK_TC0__Pos = 0x8
	// Bit mask of TC0_ field.
	MCLK_APBCMASK_TC0__Msk = 0x100
	// Bit TC0_.
	MCLK_APBCMASK_TC0_ = 0x100
	// Position of TC1_ field.
	MCLK_APBCMASK_TC1__Pos = 0x9
	// Bit mask of TC1_ field.
	MCLK_APBCMASK_TC1__Msk = 0x200
	// Bit TC1_.
	MCLK_APBCMASK_TC1_ = 0x200
	// Position of TC2_ field.
	MCLK_APBCMASK_TC2__Pos = 0xa
	// Bit mask of TC2_ field.
	MCLK_APBCMASK_TC2__Msk = 0x400
	// Bit TC2_.
	MCLK_APBCMASK_TC2_ = 0x400
	// Position of TC3_ field.
	MCLK_APBCMASK_TC3__Pos = 0xb
	// Bit mask of TC3_ field.
	MCLK_APBCMASK_TC3__Msk = 0x800
	// Bit TC3_.
	MCLK_APBCMASK_TC3_ = 0x800
	// Position of ADC_ field.
	MCLK_APBCMASK_ADC__Pos = 0xc
	// Bit mask of ADC_ field.
	MCLK_APBCMASK_ADC__Msk = 0x1000
	// Bit ADC_.
	MCLK_APBCMASK_ADC_ = 0x1000
	// Position of AC_ field.
	MCLK_APBCMASK_AC__Pos = 0xd
	// Bit mask of AC_ field.
	MCLK_APBCMASK_AC__Msk = 0x2000
	// Bit AC_.
	MCLK_APBCMASK_AC_ = 0x2000
	// Position of PTC_ field.
	MCLK_APBCMASK_PTC__Pos = 0xe
	// Bit mask of PTC_ field.
	MCLK_APBCMASK_PTC__Msk = 0x4000
	// Bit PTC_.
	MCLK_APBCMASK_PTC_ = 0x4000
	// Position of SLCD_ field.
	MCLK_APBCMASK_SLCD__Pos = 0xf
	// Bit mask of SLCD_ field.
	MCLK_APBCMASK_SLCD__Msk = 0x8000
	// Bit SLCD_.
	MCLK_APBCMASK_SLCD_ = 0x8000
	// Position of AES_ field.
	MCLK_APBCMASK_AES__Pos = 0x10
	// Bit mask of AES_ field.
	MCLK_APBCMASK_AES__Msk = 0x10000
	// Bit AES_.
	MCLK_APBCMASK_AES_ = 0x10000
	// Position of TRNG_ field.
	MCLK_APBCMASK_TRNG__Pos = 0x11
	// Bit mask of TRNG_ field.
	MCLK_APBCMASK_TRNG__Msk = 0x20000
	// Bit TRNG_.
	MCLK_APBCMASK_TRNG_ = 0x20000
	// Position of CCL_ field.
	MCLK_APBCMASK_CCL__Pos = 0x12
	// Bit mask of CCL_ field.
	MCLK_APBCMASK_CCL__Msk = 0x40000
	// Bit CCL_.
	MCLK_APBCMASK_CCL_ = 0x40000
)

// Constants for MTB: Cortex-M0+ Micro-Trace Buffer
const (
	// POSITION: MTB Position
	// Position of WRAP field.
	MTB_POSITION_WRAP_Pos = 0x2
	// Bit mask of WRAP field.
	MTB_POSITION_WRAP_Msk = 0x4
	// Bit WRAP.
	MTB_POSITION_WRAP = 0x4
	// Position of POINTER field.
	MTB_POSITION_POINTER_Pos = 0x3
	// Bit mask of POINTER field.
	MTB_POSITION_POINTER_Msk = 0xfffffff8

	// MASTER: MTB Master
	// Position of MASK field.
	MTB_MASTER_MASK_Pos = 0x0
	// Bit mask of MASK field.
	MTB_MASTER_MASK_Msk = 0x1f
	// Position of TSTARTEN field.
	MTB_MASTER_TSTARTEN_Pos = 0x5
	// Bit mask of TSTARTEN field.
	MTB_MASTER_TSTARTEN_Msk = 0x20
	// Bit TSTARTEN.
	MTB_MASTER_TSTARTEN = 0x20
	// Position of TSTOPEN field.
	MTB_MASTER_TSTOPEN_Pos = 0x6
	// Bit mask of TSTOPEN field.
	MTB_MASTER_TSTOPEN_Msk = 0x40
	// Bit TSTOPEN.
	MTB_MASTER_TSTOPEN = 0x40
	// Position of SFRWPRIV field.
	MTB_MASTER_SFRWPRIV_Pos = 0x7
	// Bit mask of SFRWPRIV field.
	MTB_MASTER_SFRWPRIV_Msk = 0x80
	// Bit SFRWPRIV.
	MTB_MASTER_SFRWPRIV = 0x80
	// Position of RAMPRIV field.
	MTB_MASTER_RAMPRIV_Pos = 0x8
	// Bit mask of RAMPRIV field.
	MTB_MASTER_RAMPRIV_Msk = 0x100
	// Bit RAMPRIV.
	MTB_MASTER_RAMPRIV = 0x100
	// Position of HALTREQ field.
	MTB_MASTER_HALTREQ_Pos = 0x9
	// Bit mask of HALTREQ field.
	MTB_MASTER_HALTREQ_Msk = 0x200
	// Bit HALTREQ.
	MTB_MASTER_HALTREQ = 0x200
	// Position of EN field.
	MTB_MASTER_EN_Pos = 0x1f
	// Bit mask of EN field.
	MTB_MASTER_EN_Msk = 0x80000000
	// Bit EN.
	MTB_MASTER_EN = 0x80000000

	// FLOW: MTB Flow
	// Position of AUTOSTOP field.
	MTB_FLOW_AUTOSTOP_Pos = 0x0
	// Bit mask of AUTOSTOP field.
	MTB_FLOW_AUTOSTOP_Msk = 0x1
	// Bit AUTOSTOP.
	MTB_FLOW_AUTOSTOP = 0x1
	// Position of AUTOHALT field.
	MTB_FLOW_AUTOHALT_Pos = 0x1
	// Bit mask of AUTOHALT field.
	MTB_FLOW_AUTOHALT_Msk = 0x2
	// Bit AUTOHALT.
	MTB_FLOW_AUTOHALT = 0x2
	// Position of WATERMARK field.
	MTB_FLOW_WATERMARK_Pos = 0x3
	// Bit mask of WATERMARK field.
	MTB_FLOW_WATERMARK_Msk = 0xfffffff8
)

// Constants for NVMCTRL: Non-Volatile Memory Controller
const (
	// CTRLA: Control A
	// Position of CMD field.
	NVMCTRL_CTRLA_CMD_Pos = 0x0
	// Bit mask of CMD field.
	NVMCTRL_CTRLA_CMD_Msk = 0x7f
	// Erase Row - Erases the row addressed by the ADDR register.
	NVMCTRL_CTRLA_CMD_ER = 0x2
	// Write Page - Writes the contents of the page buffer to the page addressed by the ADDR register.
	NVMCTRL_CTRLA_CMD_WP = 0x4
	// Erase Auxiliary Row - Erases the auxiliary row addressed by the ADDR register. This command can be given only when the security bit is not set and only to the user configuration row.
	NVMCTRL_CTRLA_CMD_EAR = 0x5
	// Write Auxiliary Page - Writes the contents of the page buffer to the page addressed by the ADDR register. This command can be given only when the security bit is not set and only to the user configuration row.
	NVMCTRL_CTRLA_CMD_WAP = 0x6
	// Security Flow Command
	NVMCTRL_CTRLA_CMD_SF = 0xa
	// Write lockbits
	NVMCTRL_CTRLA_CMD_WL = 0xf
	// RWW EEPROM area Erase Row - Erases the row addressed by the ADDR register.
	NVMCTRL_CTRLA_CMD_RWWEEER = 0x1a
	// RWW EEPROM Write Page - Writes the contents of the page buffer to the page addressed by the ADDR register.
	NVMCTRL_CTRLA_CMD_RWWEEWP = 0x1c
	// Lock Region - Locks the region containing the address location in the ADDR register.
	NVMCTRL_CTRLA_CMD_LR = 0x40
	// Unlock Region - Unlocks the region containing the address location in the ADDR register.
	NVMCTRL_CTRLA_CMD_UR = 0x41
	// Sets the power reduction mode.
	NVMCTRL_CTRLA_CMD_SPRM = 0x42
	// Clears the power reduction mode.
	NVMCTRL_CTRLA_CMD_CPRM = 0x43
	// Page Buffer Clear - Clears the page buffer.
	NVMCTRL_CTRLA_CMD_PBC = 0x44
	// Set Security Bit - Sets the security bit by writing 0x00 to the first byte in the lockbit row.
	NVMCTRL_CTRLA_CMD_SSB = 0x45
	// Invalidate all cache lines.
	NVMCTRL_CTRLA_CMD_INVALL = 0x46
	// Position of CMDEX field.
	NVMCTRL_CTRLA_CMDEX_Pos = 0x8
	// Bit mask of CMDEX field.
	NVMCTRL_CTRLA_CMDEX_Msk = 0xff00
	// Execution Key
	NVMCTRL_CTRLA_CMDEX_KEY = 0xa5

	// CTRLB: Control B
	// Position of RWS field.
	NVMCTRL_CTRLB_RWS_Pos = 0x1
	// Bit mask of RWS field.
	NVMCTRL_CTRLB_RWS_Msk = 0x1e
	// Single Auto Wait State
	NVMCTRL_CTRLB_RWS_SINGLE = 0x0
	// Half Auto Wait State
	NVMCTRL_CTRLB_RWS_HALF = 0x1
	// Dual Auto Wait State
	NVMCTRL_CTRLB_RWS_DUAL = 0x2
	// Position of MANW field.
	NVMCTRL_CTRLB_MANW_Pos = 0x7
	// Bit mask of MANW field.
	NVMCTRL_CTRLB_MANW_Msk = 0x80
	// Bit MANW.
	NVMCTRL_CTRLB_MANW = 0x80
	// Position of SLEEPPRM field.
	NVMCTRL_CTRLB_SLEEPPRM_Pos = 0x8
	// Bit mask of SLEEPPRM field.
	NVMCTRL_CTRLB_SLEEPPRM_Msk = 0x300
	// NVM block enters low-power mode when entering sleep.NVM block exits low-power mode upon first access.
	NVMCTRL_CTRLB_SLEEPPRM_WAKEONACCESS = 0x0
	// NVM block enters low-power mode when entering sleep.NVM block exits low-power mode when exiting sleep.
	NVMCTRL_CTRLB_SLEEPPRM_WAKEUPINSTANT = 0x1
	// Auto power reduction disabled.
	NVMCTRL_CTRLB_SLEEPPRM_DISABLED = 0x3
	// Position of FWUP field.
	NVMCTRL_CTRLB_FWUP_Pos = 0xb
	// Bit mask of FWUP field.
	NVMCTRL_CTRLB_FWUP_Msk = 0x800
	// Bit FWUP.
	NVMCTRL_CTRLB_FWUP = 0x800
	// Position of READMODE field.
	NVMCTRL_CTRLB_READMODE_Pos = 0x10
	// Bit mask of READMODE field.
	NVMCTRL_CTRLB_READMODE_Msk = 0x30000
	// The NVM Controller (cache system) does not insert wait states on a cache miss. Gives the best system performance.
	NVMCTRL_CTRLB_READMODE_NO_MISS_PENALTY = 0x0
	// Reduces power consumption of the cache system, but inserts a wait state each time there is a cache miss. This mode may not be relevant if CPU performance is required, as the application will be stalled and may lead to increase run time.
	NVMCTRL_CTRLB_READMODE_LOW_POWER = 0x1
	// The cache system ensures that a cache hit or miss takes the same amount of time, determined by the number of programmed flash wait states. This mode can be used for real-time applications that require deterministic execution timings.
	NVMCTRL_CTRLB_READMODE_DETERMINISTIC = 0x2
	// Position of CACHEDIS field.
	NVMCTRL_CTRLB_CACHEDIS_Pos = 0x12
	// Bit mask of CACHEDIS field.
	NVMCTRL_CTRLB_CACHEDIS_Msk = 0x40000
	// Bit CACHEDIS.
	NVMCTRL_CTRLB_CACHEDIS = 0x40000

	// PARAM: NVM Parameter
	// Position of NVMP field.
	NVMCTRL_PARAM_NVMP_Pos = 0x0
	// Bit mask of NVMP field.
	NVMCTRL_PARAM_NVMP_Msk = 0xffff
	// Position of PSZ field.
	NVMCTRL_PARAM_PSZ_Pos = 0x10
	// Bit mask of PSZ field.
	NVMCTRL_PARAM_PSZ_Msk = 0x70000
	// 8 bytes
	NVMCTRL_PARAM_PSZ_8 = 0x0
	// 16 bytes
	NVMCTRL_PARAM_PSZ_16 = 0x1
	// 32 bytes
	NVMCTRL_PARAM_PSZ_32 = 0x2
	// 64 bytes
	NVMCTRL_PARAM_PSZ_64 = 0x3
	// 128 bytes
	NVMCTRL_PARAM_PSZ_128 = 0x4
	// 256 bytes
	NVMCTRL_PARAM_PSZ_256 = 0x5
	// 512 bytes
	NVMCTRL_PARAM_PSZ_512 = 0x6
	// 1024 bytes
	NVMCTRL_PARAM_PSZ_1024 = 0x7
	// Position of RWWEEP field.
	NVMCTRL_PARAM_RWWEEP_Pos = 0x14
	// Bit mask of RWWEEP field.
	NVMCTRL_PARAM_RWWEEP_Msk = 0xfff00000

	// INTENCLR: Interrupt Enable Clear
	// Position of READY field.
	NVMCTRL_INTENCLR_READY_Pos = 0x0
	// Bit mask of READY field.
	NVMCTRL_INTENCLR_READY_Msk = 0x1
	// Bit READY.
	NVMCTRL_INTENCLR_READY = 0x1
	// Position of ERROR field.
	NVMCTRL_INTENCLR_ERROR_Pos = 0x1
	// Bit mask of ERROR field.
	NVMCTRL_INTENCLR_ERROR_Msk = 0x2
	// Bit ERROR.
	NVMCTRL_INTENCLR_ERROR = 0x2

	// INTENSET: Interrupt Enable Set
	// Position of READY field.
	NVMCTRL_INTENSET_READY_Pos = 0x0
	// Bit mask of READY field.
	NVMCTRL_INTENSET_READY_Msk = 0x1
	// Bit READY.
	NVMCTRL_INTENSET_READY = 0x1
	// Position of ERROR field.
	NVMCTRL_INTENSET_ERROR_Pos = 0x1
	// Bit mask of ERROR field.
	NVMCTRL_INTENSET_ERROR_Msk = 0x2
	// Bit ERROR.
	NVMCTRL_INTENSET_ERROR = 0x2

	// INTFLAG: Interrupt Flag Status and Clear
	// Position of READY field.
	NVMCTRL_INTFLAG_READY_Pos = 0x0
	// Bit mask of READY field.
	NVMCTRL_INTFLAG_READY_Msk = 0x1
	// Bit READY.
	NVMCTRL_INTFLAG_READY = 0x1
	// Position of ERROR field.
	NVMCTRL_INTFLAG_ERROR_Pos = 0x1
	// Bit mask of ERROR field.
	NVMCTRL_INTFLAG_ERROR_Msk = 0x2
	// Bit ERROR.
	NVMCTRL_INTFLAG_ERROR = 0x2

	// STATUS: Status
	// Position of PRM field.
	NVMCTRL_STATUS_PRM_Pos = 0x0
	// Bit mask of PRM field.
	NVMCTRL_STATUS_PRM_Msk = 0x1
	// Bit PRM.
	NVMCTRL_STATUS_PRM = 0x1
	// Position of LOAD field.
	NVMCTRL_STATUS_LOAD_Pos = 0x1
	// Bit mask of LOAD field.
	NVMCTRL_STATUS_LOAD_Msk = 0x2
	// Bit LOAD.
	NVMCTRL_STATUS_LOAD = 0x2
	// Position of PROGE field.
	NVMCTRL_STATUS_PROGE_Pos = 0x2
	// Bit mask of PROGE field.
	NVMCTRL_STATUS_PROGE_Msk = 0x4
	// Bit PROGE.
	NVMCTRL_STATUS_PROGE = 0x4
	// Position of LOCKE field.
	NVMCTRL_STATUS_LOCKE_Pos = 0x3
	// Bit mask of LOCKE field.
	NVMCTRL_STATUS_LOCKE_Msk = 0x8
	// Bit LOCKE.
	NVMCTRL_STATUS_LOCKE = 0x8
	// Position of NVME field.
	NVMCTRL_STATUS_NVME_Pos = 0x4
	// Bit mask of NVME field.
	NVMCTRL_STATUS_NVME_Msk = 0x10
	// Bit NVME.
	NVMCTRL_STATUS_NVME = 0x10
	// Position of SB field.
	NVMCTRL_STATUS_SB_Pos = 0x8
	// Bit mask of SB field.
	NVMCTRL_STATUS_SB_Msk = 0x100
	// Bit SB.
	NVMCTRL_STATUS_SB = 0x100

	// ADDR: Address
	// Position of ADDR field.
	NVMCTRL_ADDR_ADDR_Pos = 0x0
	// Bit mask of ADDR field.
	NVMCTRL_ADDR_ADDR_Msk = 0x3fffff

	// LOCK: Lock Section
	// Position of LOCK field.
	NVMCTRL_LOCK_LOCK_Pos = 0x0
	// Bit mask of LOCK field.
	NVMCTRL_LOCK_LOCK_Msk = 0xffff
)

// Constants for OSCCTRL: Oscillators Control
const (
	// INTENCLR: Interrupt Enable Clear
	// Position of XOSCRDY field.
	OSCCTRL_INTENCLR_XOSCRDY_Pos = 0x0
	// Bit mask of XOSCRDY field.
	OSCCTRL_INTENCLR_XOSCRDY_Msk = 0x1
	// Bit XOSCRDY.
	OSCCTRL_INTENCLR_XOSCRDY = 0x1
	// Position of XOSCFAIL field.
	OSCCTRL_INTENCLR_XOSCFAIL_Pos = 0x1
	// Bit mask of XOSCFAIL field.
	OSCCTRL_INTENCLR_XOSCFAIL_Msk = 0x2
	// Bit XOSCFAIL.
	OSCCTRL_INTENCLR_XOSCFAIL = 0x2
	// Position of OSC16MRDY field.
	OSCCTRL_INTENCLR_OSC16MRDY_Pos = 0x4
	// Bit mask of OSC16MRDY field.
	OSCCTRL_INTENCLR_OSC16MRDY_Msk = 0x10
	// Bit OSC16MRDY.
	OSCCTRL_INTENCLR_OSC16MRDY = 0x10
	// Position of DFLLRDY field.
	OSCCTRL_INTENCLR_DFLLRDY_Pos = 0x8
	// Bit mask of DFLLRDY field.
	OSCCTRL_INTENCLR_DFLLRDY_Msk = 0x100
	// Bit DFLLRDY.
	OSCCTRL_INTENCLR_DFLLRDY = 0x100
	// Position of DFLLOOB field.
	OSCCTRL_INTENCLR_DFLLOOB_Pos = 0x9
	// Bit mask of DFLLOOB field.
	OSCCTRL_INTENCLR_DFLLOOB_Msk = 0x200
	// Bit DFLLOOB.
	OSCCTRL_INTENCLR_DFLLOOB = 0x200
	// Position of DFLLLCKF field.
	OSCCTRL_INTENCLR_DFLLLCKF_Pos = 0xa
	// Bit mask of DFLLLCKF field.
	OSCCTRL_INTENCLR_DFLLLCKF_Msk = 0x400
	// Bit DFLLLCKF.
	OSCCTRL_INTENCLR_DFLLLCKF = 0x400
	// Position of DFLLLCKC field.
	OSCCTRL_INTENCLR_DFLLLCKC_Pos = 0xb
	// Bit mask of DFLLLCKC field.
	OSCCTRL_INTENCLR_DFLLLCKC_Msk = 0x800
	// Bit DFLLLCKC.
	OSCCTRL_INTENCLR_DFLLLCKC = 0x800
	// Position of DFLLRCS field.
	OSCCTRL_INTENCLR_DFLLRCS_Pos = 0xc
	// Bit mask of DFLLRCS field.
	OSCCTRL_INTENCLR_DFLLRCS_Msk = 0x1000
	// Bit DFLLRCS.
	OSCCTRL_INTENCLR_DFLLRCS = 0x1000
	// Position of DPLLLCKR field.
	OSCCTRL_INTENCLR_DPLLLCKR_Pos = 0x10
	// Bit mask of DPLLLCKR field.
	OSCCTRL_INTENCLR_DPLLLCKR_Msk = 0x10000
	// Bit DPLLLCKR.
	OSCCTRL_INTENCLR_DPLLLCKR = 0x10000
	// Position of DPLLLCKF field.
	OSCCTRL_INTENCLR_DPLLLCKF_Pos = 0x11
	// Bit mask of DPLLLCKF field.
	OSCCTRL_INTENCLR_DPLLLCKF_Msk = 0x20000
	// Bit DPLLLCKF.
	OSCCTRL_INTENCLR_DPLLLCKF = 0x20000
	// Position of DPLLLTO field.
	OSCCTRL_INTENCLR_DPLLLTO_Pos = 0x12
	// Bit mask of DPLLLTO field.
	OSCCTRL_INTENCLR_DPLLLTO_Msk = 0x40000
	// Bit DPLLLTO.
	OSCCTRL_INTENCLR_DPLLLTO = 0x40000
	// Position of DPLLLDRTO field.
	OSCCTRL_INTENCLR_DPLLLDRTO_Pos = 0x13
	// Bit mask of DPLLLDRTO field.
	OSCCTRL_INTENCLR_DPLLLDRTO_Msk = 0x80000
	// Bit DPLLLDRTO.
	OSCCTRL_INTENCLR_DPLLLDRTO = 0x80000

	// INTENSET: Interrupt Enable Set
	// Position of XOSCRDY field.
	OSCCTRL_INTENSET_XOSCRDY_Pos = 0x0
	// Bit mask of XOSCRDY field.
	OSCCTRL_INTENSET_XOSCRDY_Msk = 0x1
	// Bit XOSCRDY.
	OSCCTRL_INTENSET_XOSCRDY = 0x1
	// Position of XOSCFAIL field.
	OSCCTRL_INTENSET_XOSCFAIL_Pos = 0x1
	// Bit mask of XOSCFAIL field.
	OSCCTRL_INTENSET_XOSCFAIL_Msk = 0x2
	// Bit XOSCFAIL.
	OSCCTRL_INTENSET_XOSCFAIL = 0x2
	// Position of OSC16MRDY field.
	OSCCTRL_INTENSET_OSC16MRDY_Pos = 0x4
	// Bit mask of OSC16MRDY field.
	OSCCTRL_INTENSET_OSC16MRDY_Msk = 0x10
	// Bit OSC16MRDY.
	OSCCTRL_INTENSET_OSC16MRDY = 0x10
	// Position of DFLLRDY field.
	OSCCTRL_INTENSET_DFLLRDY_Pos = 0x8
	// Bit mask of DFLLRDY field.
	OSCCTRL_INTENSET_DFLLRDY_Msk = 0x100
	// Bit DFLLRDY.
	OSCCTRL_INTENSET_DFLLRDY = 0x100
	// Position of DFLLOOB field.
	OSCCTRL_INTENSET_DFLLOOB_Pos = 0x9
	// Bit mask of DFLLOOB field.
	OSCCTRL_INTENSET_DFLLOOB_Msk = 0x200
	// Bit DFLLOOB.
	OSCCTRL_INTENSET_DFLLOOB = 0x200
	// Position of DFLLLCKF field.
	OSCCTRL_INTENSET_DFLLLCKF_Pos = 0xa
	// Bit mask of DFLLLCKF field.
	OSCCTRL_INTENSET_DFLLLCKF_Msk = 0x400
	// Bit DFLLLCKF.
	OSCCTRL_INTENSET_DFLLLCKF = 0x400
	// Position of DFLLLCKC field.
	OSCCTRL_INTENSET_DFLLLCKC_Pos = 0xb
	// Bit mask of DFLLLCKC field.
	OSCCTRL_INTENSET_DFLLLCKC_Msk = 0x800
	// Bit DFLLLCKC.
	OSCCTRL_INTENSET_DFLLLCKC = 0x800
	// Position of DFLLRCS field.
	OSCCTRL_INTENSET_DFLLRCS_Pos = 0xc
	// Bit mask of DFLLRCS field.
	OSCCTRL_INTENSET_DFLLRCS_Msk = 0x1000
	// Bit DFLLRCS.
	OSCCTRL_INTENSET_DFLLRCS = 0x1000
	// Position of DPLLLCKR field.
	OSCCTRL_INTENSET_DPLLLCKR_Pos = 0x10
	// Bit mask of DPLLLCKR field.
	OSCCTRL_INTENSET_DPLLLCKR_Msk = 0x10000
	// Bit DPLLLCKR.
	OSCCTRL_INTENSET_DPLLLCKR = 0x10000
	// Position of DPLLLCKF field.
	OSCCTRL_INTENSET_DPLLLCKF_Pos = 0x11
	// Bit mask of DPLLLCKF field.
	OSCCTRL_INTENSET_DPLLLCKF_Msk = 0x20000
	// Bit DPLLLCKF.
	OSCCTRL_INTENSET_DPLLLCKF = 0x20000
	// Position of DPLLLTO field.
	OSCCTRL_INTENSET_DPLLLTO_Pos = 0x12
	// Bit mask of DPLLLTO field.
	OSCCTRL_INTENSET_DPLLLTO_Msk = 0x40000
	// Bit DPLLLTO.
	OSCCTRL_INTENSET_DPLLLTO = 0x40000
	// Position of DPLLLDRTO field.
	OSCCTRL_INTENSET_DPLLLDRTO_Pos = 0x13
	// Bit mask of DPLLLDRTO field.
	OSCCTRL_INTENSET_DPLLLDRTO_Msk = 0x80000
	// Bit DPLLLDRTO.
	OSCCTRL_INTENSET_DPLLLDRTO = 0x80000

	// INTFLAG: Interrupt Flag Status and Clear
	// Position of XOSCRDY field.
	OSCCTRL_INTFLAG_XOSCRDY_Pos = 0x0
	// Bit mask of XOSCRDY field.
	OSCCTRL_INTFLAG_XOSCRDY_Msk = 0x1
	// Bit XOSCRDY.
	OSCCTRL_INTFLAG_XOSCRDY = 0x1
	// Position of XOSCFAIL field.
	OSCCTRL_INTFLAG_XOSCFAIL_Pos = 0x1
	// Bit mask of XOSCFAIL field.
	OSCCTRL_INTFLAG_XOSCFAIL_Msk = 0x2
	// Bit XOSCFAIL.
	OSCCTRL_INTFLAG_XOSCFAIL = 0x2
	// Position of OSC16MRDY field.
	OSCCTRL_INTFLAG_OSC16MRDY_Pos = 0x4
	// Bit mask of OSC16MRDY field.
	OSCCTRL_INTFLAG_OSC16MRDY_Msk = 0x10
	// Bit OSC16MRDY.
	OSCCTRL_INTFLAG_OSC16MRDY = 0x10
	// Position of DFLLRDY field.
	OSCCTRL_INTFLAG_DFLLRDY_Pos = 0x8
	// Bit mask of DFLLRDY field.
	OSCCTRL_INTFLAG_DFLLRDY_Msk = 0x100
	// Bit DFLLRDY.
	OSCCTRL_INTFLAG_DFLLRDY = 0x100
	// Position of DFLLOOB field.
	OSCCTRL_INTFLAG_DFLLOOB_Pos = 0x9
	// Bit mask of DFLLOOB field.
	OSCCTRL_INTFLAG_DFLLOOB_Msk = 0x200
	// Bit DFLLOOB.
	OSCCTRL_INTFLAG_DFLLOOB = 0x200
	// Position of DFLLLCKF field.
	OSCCTRL_INTFLAG_DFLLLCKF_Pos = 0xa
	// Bit mask of DFLLLCKF field.
	OSCCTRL_INTFLAG_DFLLLCKF_Msk = 0x400
	// Bit DFLLLCKF.
	OSCCTRL_INTFLAG_DFLLLCKF = 0x400
	// Position of DFLLLCKC field.
	OSCCTRL_INTFLAG_DFLLLCKC_Pos = 0xb
	// Bit mask of DFLLLCKC field.
	OSCCTRL_INTFLAG_DFLLLCKC_Msk = 0x800
	// Bit DFLLLCKC.
	OSCCTRL_INTFLAG_DFLLLCKC = 0x800
	// Position of DFLLRCS field.
	OSCCTRL_INTFLAG_DFLLRCS_Pos = 0xc
	// Bit mask of DFLLRCS field.
	OSCCTRL_INTFLAG_DFLLRCS_Msk = 0x1000
	// Bit DFLLRCS.
	OSCCTRL_INTFLAG_DFLLRCS = 0x1000
	// Position of DPLLLCKR field.
	OSCCTRL_INTFLAG_DPLLLCKR_Pos = 0x10
	// Bit mask of DPLLLCKR field.
	OSCCTRL_INTFLAG_DPLLLCKR_Msk = 0x10000
	// Bit DPLLLCKR.
	OSCCTRL_INTFLAG_DPLLLCKR = 0x10000
	// Position of DPLLLCKF field.
	OSCCTRL_INTFLAG_DPLLLCKF_Pos = 0x11
	// Bit mask of DPLLLCKF field.
	OSCCTRL_INTFLAG_DPLLLCKF_Msk = 0x20000
	// Bit DPLLLCKF.
	OSCCTRL_INTFLAG_DPLLLCKF = 0x20000
	// Position of DPLLLTO field.
	OSCCTRL_INTFLAG_DPLLLTO_Pos = 0x12
	// Bit mask of DPLLLTO field.
	OSCCTRL_INTFLAG_DPLLLTO_Msk = 0x40000
	// Bit DPLLLTO.
	OSCCTRL_INTFLAG_DPLLLTO = 0x40000
	// Position of DPLLLDRTO field.
	OSCCTRL_INTFLAG_DPLLLDRTO_Pos = 0x13
	// Bit mask of DPLLLDRTO field.
	OSCCTRL_INTFLAG_DPLLLDRTO_Msk = 0x80000
	// Bit DPLLLDRTO.
	OSCCTRL_INTFLAG_DPLLLDRTO = 0x80000

	// STATUS: Power and Clocks Status
	// Position of XOSCRDY field.
	OSCCTRL_STATUS_XOSCRDY_Pos = 0x0
	// Bit mask of XOSCRDY field.
	OSCCTRL_STATUS_XOSCRDY_Msk = 0x1
	// Bit XOSCRDY.
	OSCCTRL_STATUS_XOSCRDY = 0x1
	// Position of XOSCFAIL field.
	OSCCTRL_STATUS_XOSCFAIL_Pos = 0x1
	// Bit mask of XOSCFAIL field.
	OSCCTRL_STATUS_XOSCFAIL_Msk = 0x2
	// Bit XOSCFAIL.
	OSCCTRL_STATUS_XOSCFAIL = 0x2
	// Position of XOSCCKSW field.
	OSCCTRL_STATUS_XOSCCKSW_Pos = 0x2
	// Bit mask of XOSCCKSW field.
	OSCCTRL_STATUS_XOSCCKSW_Msk = 0x4
	// Bit XOSCCKSW.
	OSCCTRL_STATUS_XOSCCKSW = 0x4
	// Position of OSC16MRDY field.
	OSCCTRL_STATUS_OSC16MRDY_Pos = 0x4
	// Bit mask of OSC16MRDY field.
	OSCCTRL_STATUS_OSC16MRDY_Msk = 0x10
	// Bit OSC16MRDY.
	OSCCTRL_STATUS_OSC16MRDY = 0x10
	// Position of DFLLRDY field.
	OSCCTRL_STATUS_DFLLRDY_Pos = 0x8
	// Bit mask of DFLLRDY field.
	OSCCTRL_STATUS_DFLLRDY_Msk = 0x100
	// Bit DFLLRDY.
	OSCCTRL_STATUS_DFLLRDY = 0x100
	// Position of DFLLOOB field.
	OSCCTRL_STATUS_DFLLOOB_Pos = 0x9
	// Bit mask of DFLLOOB field.
	OSCCTRL_STATUS_DFLLOOB_Msk = 0x200
	// Bit DFLLOOB.
	OSCCTRL_STATUS_DFLLOOB = 0x200
	// Position of DFLLLCKF field.
	OSCCTRL_STATUS_DFLLLCKF_Pos = 0xa
	// Bit mask of DFLLLCKF field.
	OSCCTRL_STATUS_DFLLLCKF_Msk = 0x400
	// Bit DFLLLCKF.
	OSCCTRL_STATUS_DFLLLCKF = 0x400
	// Position of DFLLLCKC field.
	OSCCTRL_STATUS_DFLLLCKC_Pos = 0xb
	// Bit mask of DFLLLCKC field.
	OSCCTRL_STATUS_DFLLLCKC_Msk = 0x800
	// Bit DFLLLCKC.
	OSCCTRL_STATUS_DFLLLCKC = 0x800
	// Position of DFLLRCS field.
	OSCCTRL_STATUS_DFLLRCS_Pos = 0xc
	// Bit mask of DFLLRCS field.
	OSCCTRL_STATUS_DFLLRCS_Msk = 0x1000
	// Bit DFLLRCS.
	OSCCTRL_STATUS_DFLLRCS = 0x1000
	// Position of DPLLLCKR field.
	OSCCTRL_STATUS_DPLLLCKR_Pos = 0x10
	// Bit mask of DPLLLCKR field.
	OSCCTRL_STATUS_DPLLLCKR_Msk = 0x10000
	// Bit DPLLLCKR.
	OSCCTRL_STATUS_DPLLLCKR = 0x10000
	// Position of DPLLLCKF field.
	OSCCTRL_STATUS_DPLLLCKF_Pos = 0x11
	// Bit mask of DPLLLCKF field.
	OSCCTRL_STATUS_DPLLLCKF_Msk = 0x20000
	// Bit DPLLLCKF.
	OSCCTRL_STATUS_DPLLLCKF = 0x20000
	// Position of DPLLTO field.
	OSCCTRL_STATUS_DPLLTO_Pos = 0x12
	// Bit mask of DPLLTO field.
	OSCCTRL_STATUS_DPLLTO_Msk = 0x40000
	// Bit DPLLTO.
	OSCCTRL_STATUS_DPLLTO = 0x40000
	// Position of DPLLLDRTO field.
	OSCCTRL_STATUS_DPLLLDRTO_Pos = 0x13
	// Bit mask of DPLLLDRTO field.
	OSCCTRL_STATUS_DPLLLDRTO_Msk = 0x80000
	// Bit DPLLLDRTO.
	OSCCTRL_STATUS_DPLLLDRTO = 0x80000

	// XOSCCTRL: External Multipurpose Crystal Oscillator (XOSC) Control
	// Position of ENABLE field.
	OSCCTRL_XOSCCTRL_ENABLE_Pos = 0x1
	// Bit mask of ENABLE field.
	OSCCTRL_XOSCCTRL_ENABLE_Msk = 0x2
	// Bit ENABLE.
	OSCCTRL_XOSCCTRL_ENABLE = 0x2
	// Position of XTALEN field.
	OSCCTRL_XOSCCTRL_XTALEN_Pos = 0x2
	// Bit mask of XTALEN field.
	OSCCTRL_XOSCCTRL_XTALEN_Msk = 0x4
	// Bit XTALEN.
	OSCCTRL_XOSCCTRL_XTALEN = 0x4
	// Position of CFDEN field.
	OSCCTRL_XOSCCTRL_CFDEN_Pos = 0x3
	// Bit mask of CFDEN field.
	OSCCTRL_XOSCCTRL_CFDEN_Msk = 0x8
	// Bit CFDEN.
	OSCCTRL_XOSCCTRL_CFDEN = 0x8
	// Position of SWBEN field.
	OSCCTRL_XOSCCTRL_SWBEN_Pos = 0x4
	// Bit mask of SWBEN field.
	OSCCTRL_XOSCCTRL_SWBEN_Msk = 0x10
	// Bit SWBEN.
	OSCCTRL_XOSCCTRL_SWBEN = 0x10
	// Position of RUNSTDBY field.
	OSCCTRL_XOSCCTRL_RUNSTDBY_Pos = 0x6
	// Bit mask of RUNSTDBY field.
	OSCCTRL_XOSCCTRL_RUNSTDBY_Msk = 0x40
	// Bit RUNSTDBY.
	OSCCTRL_XOSCCTRL_RUNSTDBY = 0x40
	// Position of ONDEMAND field.
	OSCCTRL_XOSCCTRL_ONDEMAND_Pos = 0x7
	// Bit mask of ONDEMAND field.
	OSCCTRL_XOSCCTRL_ONDEMAND_Msk = 0x80
	// Bit ONDEMAND.
	OSCCTRL_XOSCCTRL_ONDEMAND = 0x80
	// Position of GAIN field.
	OSCCTRL_XOSCCTRL_GAIN_Pos = 0x8
	// Bit mask of GAIN field.
	OSCCTRL_XOSCCTRL_GAIN_Msk = 0x700
	// Position of AMPGC field.
	OSCCTRL_XOSCCTRL_AMPGC_Pos = 0xb
	// Bit mask of AMPGC field.
	OSCCTRL_XOSCCTRL_AMPGC_Msk = 0x800
	// Bit AMPGC.
	OSCCTRL_XOSCCTRL_AMPGC = 0x800
	// Position of STARTUP field.
	OSCCTRL_XOSCCTRL_STARTUP_Pos = 0xc
	// Bit mask of STARTUP field.
	OSCCTRL_XOSCCTRL_STARTUP_Msk = 0xf000

	// CFDPRESC: Cloc Failure Detector Prescaler
	// Position of CFDPRESC field.
	OSCCTRL_CFDPRESC_CFDPRESC_Pos = 0x0
	// Bit mask of CFDPRESC field.
	OSCCTRL_CFDPRESC_CFDPRESC_Msk = 0x7

	// EVCTRL: Event Control
	// Position of CFDEO field.
	OSCCTRL_EVCTRL_CFDEO_Pos = 0x0
	// Bit mask of CFDEO field.
	OSCCTRL_EVCTRL_CFDEO_Msk = 0x1
	// Bit CFDEO.
	OSCCTRL_EVCTRL_CFDEO = 0x1

	// OSC16MCTRL: 16MHz Internal Oscillator (OSC16M) Control
	// Position of ENABLE field.
	OSCCTRL_OSC16MCTRL_ENABLE_Pos = 0x1
	// Bit mask of ENABLE field.
	OSCCTRL_OSC16MCTRL_ENABLE_Msk = 0x2
	// Bit ENABLE.
	OSCCTRL_OSC16MCTRL_ENABLE = 0x2
	// Position of FSEL field.
	OSCCTRL_OSC16MCTRL_FSEL_Pos = 0x2
	// Bit mask of FSEL field.
	OSCCTRL_OSC16MCTRL_FSEL_Msk = 0xc
	// 4MHz
	OSCCTRL_OSC16MCTRL_FSEL_4 = 0x0
	// 8MHz
	OSCCTRL_OSC16MCTRL_FSEL_8 = 0x1
	// 12MHz
	OSCCTRL_OSC16MCTRL_FSEL_12 = 0x2
	// 16MHz
	OSCCTRL_OSC16MCTRL_FSEL_16 = 0x3
	// Position of RUNSTDBY field.
	OSCCTRL_OSC16MCTRL_RUNSTDBY_Pos = 0x6
	// Bit mask of RUNSTDBY field.
	OSCCTRL_OSC16MCTRL_RUNSTDBY_Msk = 0x40
	// Bit RUNSTDBY.
	OSCCTRL_OSC16MCTRL_RUNSTDBY = 0x40
	// Position of ONDEMAND field.
	OSCCTRL_OSC16MCTRL_ONDEMAND_Pos = 0x7
	// Bit mask of ONDEMAND field.
	OSCCTRL_OSC16MCTRL_ONDEMAND_Msk = 0x80
	// Bit ONDEMAND.
	OSCCTRL_OSC16MCTRL_ONDEMAND = 0x80

	// DFLLCTRL: DFLL48M Control
	// Position of ENABLE field.
	OSCCTRL_DFLLCTRL_ENABLE_Pos = 0x1
	// Bit mask of ENABLE field.
	OSCCTRL_DFLLCTRL_ENABLE_Msk = 0x2
	// Bit ENABLE.
	OSCCTRL_DFLLCTRL_ENABLE = 0x2
	// Position of MODE field.
	OSCCTRL_DFLLCTRL_MODE_Pos = 0x2
	// Bit mask of MODE field.
	OSCCTRL_DFLLCTRL_MODE_Msk = 0x4
	// Bit MODE.
	OSCCTRL_DFLLCTRL_MODE = 0x4
	// Position of STABLE field.
	OSCCTRL_DFLLCTRL_STABLE_Pos = 0x3
	// Bit mask of STABLE field.
	OSCCTRL_DFLLCTRL_STABLE_Msk = 0x8
	// Bit STABLE.
	OSCCTRL_DFLLCTRL_STABLE = 0x8
	// Position of LLAW field.
	OSCCTRL_DFLLCTRL_LLAW_Pos = 0x4
	// Bit mask of LLAW field.
	OSCCTRL_DFLLCTRL_LLAW_Msk = 0x10
	// Bit LLAW.
	OSCCTRL_DFLLCTRL_LLAW = 0x10
	// Position of USBCRM field.
	OSCCTRL_DFLLCTRL_USBCRM_Pos = 0x5
	// Bit mask of USBCRM field.
	OSCCTRL_DFLLCTRL_USBCRM_Msk = 0x20
	// Bit USBCRM.
	OSCCTRL_DFLLCTRL_USBCRM = 0x20
	// Position of RUNSTDBY field.
	OSCCTRL_DFLLCTRL_RUNSTDBY_Pos = 0x6
	// Bit mask of RUNSTDBY field.
	OSCCTRL_DFLLCTRL_RUNSTDBY_Msk = 0x40
	// Bit RUNSTDBY.
	OSCCTRL_DFLLCTRL_RUNSTDBY = 0x40
	// Position of ONDEMAND field.
	OSCCTRL_DFLLCTRL_ONDEMAND_Pos = 0x7
	// Bit mask of ONDEMAND field.
	OSCCTRL_DFLLCTRL_ONDEMAND_Msk = 0x80
	// Bit ONDEMAND.
	OSCCTRL_DFLLCTRL_ONDEMAND = 0x80
	// Position of CCDIS field.
	OSCCTRL_DFLLCTRL_CCDIS_Pos = 0x8
	// Bit mask of CCDIS field.
	OSCCTRL_DFLLCTRL_CCDIS_Msk = 0x100
	// Bit CCDIS.
	OSCCTRL_DFLLCTRL_CCDIS = 0x100
	// Position of QLDIS field.
	OSCCTRL_DFLLCTRL_QLDIS_Pos = 0x9
	// Bit mask of QLDIS field.
	OSCCTRL_DFLLCTRL_QLDIS_Msk = 0x200
	// Bit QLDIS.
	OSCCTRL_DFLLCTRL_QLDIS = 0x200
	// Position of BPLCKC field.
	OSCCTRL_DFLLCTRL_BPLCKC_Pos = 0xa
	// Bit mask of BPLCKC field.
	OSCCTRL_DFLLCTRL_BPLCKC_Msk = 0x400
	// Bit BPLCKC.
	OSCCTRL_DFLLCTRL_BPLCKC = 0x400
	// Position of WAITLOCK field.
	OSCCTRL_DFLLCTRL_WAITLOCK_Pos = 0xb
	// Bit mask of WAITLOCK field.
	OSCCTRL_DFLLCTRL_WAITLOCK_Msk = 0x800
	// Bit WAITLOCK.
	OSCCTRL_DFLLCTRL_WAITLOCK = 0x800

	// DFLLVAL: DFLL48M Value
	// Position of FINE field.
	OSCCTRL_DFLLVAL_FINE_Pos = 0x0
	// Bit mask of FINE field.
	OSCCTRL_DFLLVAL_FINE_Msk = 0x3ff
	// Position of COARSE field.
	OSCCTRL_DFLLVAL_COARSE_Pos = 0xa
	// Bit mask of COARSE field.
	OSCCTRL_DFLLVAL_COARSE_Msk = 0xfc00
	// Position of DIFF field.
	OSCCTRL_DFLLVAL_DIFF_Pos = 0x10
	// Bit mask of DIFF field.
	OSCCTRL_DFLLVAL_DIFF_Msk = 0xffff0000

	// DFLLMUL: DFLL48M Multiplier
	// Position of MUL field.
	OSCCTRL_DFLLMUL_MUL_Pos = 0x0
	// Bit mask of MUL field.
	OSCCTRL_DFLLMUL_MUL_Msk = 0xffff
	// Position of FSTEP field.
	OSCCTRL_DFLLMUL_FSTEP_Pos = 0x10
	// Bit mask of FSTEP field.
	OSCCTRL_DFLLMUL_FSTEP_Msk = 0x3ff0000
	// Position of CSTEP field.
	OSCCTRL_DFLLMUL_CSTEP_Pos = 0x1a
	// Bit mask of CSTEP field.
	OSCCTRL_DFLLMUL_CSTEP_Msk = 0xfc000000

	// DFLLSYNC: DFLL48M Synchronization
	// Position of READREQ field.
	OSCCTRL_DFLLSYNC_READREQ_Pos = 0x7
	// Bit mask of READREQ field.
	OSCCTRL_DFLLSYNC_READREQ_Msk = 0x80
	// Bit READREQ.
	OSCCTRL_DFLLSYNC_READREQ = 0x80

	// DPLLCTRLA: DPLL Control
	// Position of ENABLE field.
	OSCCTRL_DPLLCTRLA_ENABLE_Pos = 0x1
	// Bit mask of ENABLE field.
	OSCCTRL_DPLLCTRLA_ENABLE_Msk = 0x2
	// Bit ENABLE.
	OSCCTRL_DPLLCTRLA_ENABLE = 0x2
	// Position of RUNSTDBY field.
	OSCCTRL_DPLLCTRLA_RUNSTDBY_Pos = 0x6
	// Bit mask of RUNSTDBY field.
	OSCCTRL_DPLLCTRLA_RUNSTDBY_Msk = 0x40
	// Bit RUNSTDBY.
	OSCCTRL_DPLLCTRLA_RUNSTDBY = 0x40
	// Position of ONDEMAND field.
	OSCCTRL_DPLLCTRLA_ONDEMAND_Pos = 0x7
	// Bit mask of ONDEMAND field.
	OSCCTRL_DPLLCTRLA_ONDEMAND_Msk = 0x80
	// Bit ONDEMAND.
	OSCCTRL_DPLLCTRLA_ONDEMAND = 0x80

	// DPLLRATIO: DPLL Ratio Control
	// Position of LDR field.
	OSCCTRL_DPLLRATIO_LDR_Pos = 0x0
	// Bit mask of LDR field.
	OSCCTRL_DPLLRATIO_LDR_Msk = 0xfff
	// Position of LDRFRAC field.
	OSCCTRL_DPLLRATIO_LDRFRAC_Pos = 0x10
	// Bit mask of LDRFRAC field.
	OSCCTRL_DPLLRATIO_LDRFRAC_Msk = 0xf0000

	// DPLLCTRLB: Digital Core Configuration
	// Position of FILTER field.
	OSCCTRL_DPLLCTRLB_FILTER_Pos = 0x0
	// Bit mask of FILTER field.
	OSCCTRL_DPLLCTRLB_FILTER_Msk = 0x3
	// Position of LPEN field.
	OSCCTRL_DPLLCTRLB_LPEN_Pos = 0x2
	// Bit mask of LPEN field.
	OSCCTRL_DPLLCTRLB_LPEN_Msk = 0x4
	// Bit LPEN.
	OSCCTRL_DPLLCTRLB_LPEN = 0x4
	// Position of WUF field.
	OSCCTRL_DPLLCTRLB_WUF_Pos = 0x3
	// Bit mask of WUF field.
	OSCCTRL_DPLLCTRLB_WUF_Msk = 0x8
	// Bit WUF.
	OSCCTRL_DPLLCTRLB_WUF = 0x8
	// Position of REFCLK field.
	OSCCTRL_DPLLCTRLB_REFCLK_Pos = 0x4
	// Bit mask of REFCLK field.
	OSCCTRL_DPLLCTRLB_REFCLK_Msk = 0x30
	// Position of LTIME field.
	OSCCTRL_DPLLCTRLB_LTIME_Pos = 0x8
	// Bit mask of LTIME field.
	OSCCTRL_DPLLCTRLB_LTIME_Msk = 0x700
	// Position of LBYPASS field.
	OSCCTRL_DPLLCTRLB_LBYPASS_Pos = 0xc
	// Bit mask of LBYPASS field.
	OSCCTRL_DPLLCTRLB_LBYPASS_Msk = 0x1000
	// Bit LBYPASS.
	OSCCTRL_DPLLCTRLB_LBYPASS = 0x1000
	// Position of DIV field.
	OSCCTRL_DPLLCTRLB_DIV_Pos = 0x10
	// Bit mask of DIV field.
	OSCCTRL_DPLLCTRLB_DIV_Msk = 0x7ff0000

	// DPLLPRESC: DPLL Prescaler
	// Position of PRESC field.
	OSCCTRL_DPLLPRESC_PRESC_Pos = 0x0
	// Bit mask of PRESC field.
	OSCCTRL_DPLLPRESC_PRESC_Msk = 0x3
	// DPLL output is divided by 1
	OSCCTRL_DPLLPRESC_PRESC_DIV1 = 0x0
	// DPLL output is divided by 2
	OSCCTRL_DPLLPRESC_PRESC_DIV2 = 0x1
	// DPLL output is divided by 4
	OSCCTRL_DPLLPRESC_PRESC_DIV4 = 0x2

	// DPLLSYNCBUSY: DPLL Synchronization Busy
	// Position of ENABLE field.
	OSCCTRL_DPLLSYNCBUSY_ENABLE_Pos = 0x1
	// Bit mask of ENABLE field.
	OSCCTRL_DPLLSYNCBUSY_ENABLE_Msk = 0x2
	// Bit ENABLE.
	OSCCTRL_DPLLSYNCBUSY_ENABLE = 0x2
	// Position of DPLLRATIO field.
	OSCCTRL_DPLLSYNCBUSY_DPLLRATIO_Pos = 0x2
	// Bit mask of DPLLRATIO field.
	OSCCTRL_DPLLSYNCBUSY_DPLLRATIO_Msk = 0x4
	// Bit DPLLRATIO.
	OSCCTRL_DPLLSYNCBUSY_DPLLRATIO = 0x4
	// Position of DPLLPRESC field.
	OSCCTRL_DPLLSYNCBUSY_DPLLPRESC_Pos = 0x3
	// Bit mask of DPLLPRESC field.
	OSCCTRL_DPLLSYNCBUSY_DPLLPRESC_Msk = 0x8
	// Bit DPLLPRESC.
	OSCCTRL_DPLLSYNCBUSY_DPLLPRESC = 0x8

	// DPLLSTATUS: DPLL Status
	// Position of LOCK field.
	OSCCTRL_DPLLSTATUS_LOCK_Pos = 0x0
	// Bit mask of LOCK field.
	OSCCTRL_DPLLSTATUS_LOCK_Msk = 0x1
	// Bit LOCK.
	OSCCTRL_DPLLSTATUS_LOCK = 0x1
	// Position of CLKRDY field.
	OSCCTRL_DPLLSTATUS_CLKRDY_Pos = 0x1
	// Bit mask of CLKRDY field.
	OSCCTRL_DPLLSTATUS_CLKRDY_Msk = 0x2
	// Bit CLKRDY.
	OSCCTRL_DPLLSTATUS_CLKRDY = 0x2
)

// Constants for OSC32KCTRL: 32k Oscillators Control
const (
	// INTENCLR: Interrupt Enable Clear
	// Position of XOSC32KRDY field.
	OSC32KCTRL_INTENCLR_XOSC32KRDY_Pos = 0x0
	// Bit mask of XOSC32KRDY field.
	OSC32KCTRL_INTENCLR_XOSC32KRDY_Msk = 0x1
	// Bit XOSC32KRDY.
	OSC32KCTRL_INTENCLR_XOSC32KRDY = 0x1
	// Position of CLKFAIL field.
	OSC32KCTRL_INTENCLR_CLKFAIL_Pos = 0x2
	// Bit mask of CLKFAIL field.
	OSC32KCTRL_INTENCLR_CLKFAIL_Msk = 0x4
	// Bit CLKFAIL.
	OSC32KCTRL_INTENCLR_CLKFAIL = 0x4

	// INTENSET: Interrupt Enable Set
	// Position of XOSC32KRDY field.
	OSC32KCTRL_INTENSET_XOSC32KRDY_Pos = 0x0
	// Bit mask of XOSC32KRDY field.
	OSC32KCTRL_INTENSET_XOSC32KRDY_Msk = 0x1
	// Bit XOSC32KRDY.
	OSC32KCTRL_INTENSET_XOSC32KRDY = 0x1
	// Position of CLKFAIL field.
	OSC32KCTRL_INTENSET_CLKFAIL_Pos = 0x2
	// Bit mask of CLKFAIL field.
	OSC32KCTRL_INTENSET_CLKFAIL_Msk = 0x4
	// Bit CLKFAIL.
	OSC32KCTRL_INTENSET_CLKFAIL = 0x4

	// INTFLAG: Interrupt Flag Status and Clear
	// Position of XOSC32KRDY field.
	OSC32KCTRL_INTFLAG_XOSC32KRDY_Pos = 0x0
	// Bit mask of XOSC32KRDY field.
	OSC32KCTRL_INTFLAG_XOSC32KRDY_Msk = 0x1
	// Bit XOSC32KRDY.
	OSC32KCTRL_INTFLAG_XOSC32KRDY = 0x1
	// Position of CLKFAIL field.
	OSC32KCTRL_INTFLAG_CLKFAIL_Pos = 0x2
	// Bit mask of CLKFAIL field.
	OSC32KCTRL_INTFLAG_CLKFAIL_Msk = 0x4
	// Bit CLKFAIL.
	OSC32KCTRL_INTFLAG_CLKFAIL = 0x4

	// STATUS: Power and Clocks Status
	// Position of XOSC32KRDY field.
	OSC32KCTRL_STATUS_XOSC32KRDY_Pos = 0x0
	// Bit mask of XOSC32KRDY field.
	OSC32KCTRL_STATUS_XOSC32KRDY_Msk = 0x1
	// Bit XOSC32KRDY.
	OSC32KCTRL_STATUS_XOSC32KRDY = 0x1
	// Position of CLKFAIL field.
	OSC32KCTRL_STATUS_CLKFAIL_Pos = 0x2
	// Bit mask of CLKFAIL field.
	OSC32KCTRL_STATUS_CLKFAIL_Msk = 0x4
	// Bit CLKFAIL.
	OSC32KCTRL_STATUS_CLKFAIL = 0x4
	// Position of CLKSW field.
	OSC32KCTRL_STATUS_CLKSW_Pos = 0x3
	// Bit mask of CLKSW field.
	OSC32KCTRL_STATUS_CLKSW_Msk = 0x8
	// Bit CLKSW.
	OSC32KCTRL_STATUS_CLKSW = 0x8

	// RTCCTRL: RTC Clock Selection
	// Position of RTCSEL field.
	OSC32KCTRL_RTCCTRL_RTCSEL_Pos = 0x0
	// Bit mask of RTCSEL field.
	OSC32KCTRL_RTCCTRL_RTCSEL_Msk = 0x7
	// 1.024kHz from 32kHz internal ULP oscillator
	OSC32KCTRL_RTCCTRL_RTCSEL_ULP1K = 0x0
	// 32.768kHz from 32kHz internal ULP oscillator
	OSC32KCTRL_RTCCTRL_RTCSEL_ULP32K = 0x1
	// 1.024kHz from 32.768kHz external oscillator
	OSC32KCTRL_RTCCTRL_RTCSEL_XOSC1K = 0x4
	// 32.768kHz from 32.768kHz external crystal oscillator
	OSC32KCTRL_RTCCTRL_RTCSEL_XOSC32K = 0x5

	// SLCDCTRL: SLCD Clock Selection
	// Position of SLCDSEL field.
	OSC32KCTRL_SLCDCTRL_SLCDSEL_Pos = 0x0
	// Bit mask of SLCDSEL field.
	OSC32KCTRL_SLCDCTRL_SLCDSEL_Msk = 0x1
	// Bit SLCDSEL.
	OSC32KCTRL_SLCDCTRL_SLCDSEL = 0x1

	// XOSC32K: 32kHz External Crystal Oscillator (XOSC32K) Control
	// Position of ENABLE field.
	OSC32KCTRL_XOSC32K_ENABLE_Pos = 0x1
	// Bit mask of ENABLE field.
	OSC32KCTRL_XOSC32K_ENABLE_Msk = 0x2
	// Bit ENABLE.
	OSC32KCTRL_XOSC32K_ENABLE = 0x2
	// Position of XTALEN field.
	OSC32KCTRL_XOSC32K_XTALEN_Pos = 0x2
	// Bit mask of XTALEN field.
	OSC32KCTRL_XOSC32K_XTALEN_Msk = 0x4
	// Bit XTALEN.
	OSC32KCTRL_XOSC32K_XTALEN = 0x4
	// Position of EN32K field.
	OSC32KCTRL_XOSC32K_EN32K_Pos = 0x3
	// Bit mask of EN32K field.
	OSC32KCTRL_XOSC32K_EN32K_Msk = 0x8
	// Bit EN32K.
	OSC32KCTRL_XOSC32K_EN32K = 0x8
	// Position of EN1K field.
	OSC32KCTRL_XOSC32K_EN1K_Pos = 0x4
	// Bit mask of EN1K field.
	OSC32KCTRL_XOSC32K_EN1K_Msk = 0x10
	// Bit EN1K.
	OSC32KCTRL_XOSC32K_EN1K = 0x10
	// Position of RUNSTDBY field.
	OSC32KCTRL_XOSC32K_RUNSTDBY_Pos = 0x6
	// Bit mask of RUNSTDBY field.
	OSC32KCTRL_XOSC32K_RUNSTDBY_Msk = 0x40
	// Bit RUNSTDBY.
	OSC32KCTRL_XOSC32K_RUNSTDBY = 0x40
	// Position of ONDEMAND field.
	OSC32KCTRL_XOSC32K_ONDEMAND_Pos = 0x7
	// Bit mask of ONDEMAND field.
	OSC32KCTRL_XOSC32K_ONDEMAND_Msk = 0x80
	// Bit ONDEMAND.
	OSC32KCTRL_XOSC32K_ONDEMAND = 0x80
	// Position of STARTUP field.
	OSC32KCTRL_XOSC32K_STARTUP_Pos = 0x8
	// Bit mask of STARTUP field.
	OSC32KCTRL_XOSC32K_STARTUP_Msk = 0x700
	// Position of WRTLOCK field.
	OSC32KCTRL_XOSC32K_WRTLOCK_Pos = 0xc
	// Bit mask of WRTLOCK field.
	OSC32KCTRL_XOSC32K_WRTLOCK_Msk = 0x1000
	// Bit WRTLOCK.
	OSC32KCTRL_XOSC32K_WRTLOCK = 0x1000

	// CFDCTRL: Clock Failure Detector Control
	// Position of CFDEN field.
	OSC32KCTRL_CFDCTRL_CFDEN_Pos = 0x0
	// Bit mask of CFDEN field.
	OSC32KCTRL_CFDCTRL_CFDEN_Msk = 0x1
	// Bit CFDEN.
	OSC32KCTRL_CFDCTRL_CFDEN = 0x1
	// Position of SWBACK field.
	OSC32KCTRL_CFDCTRL_SWBACK_Pos = 0x1
	// Bit mask of SWBACK field.
	OSC32KCTRL_CFDCTRL_SWBACK_Msk = 0x2
	// Bit SWBACK.
	OSC32KCTRL_CFDCTRL_SWBACK = 0x2
	// Position of CFDPRESC field.
	OSC32KCTRL_CFDCTRL_CFDPRESC_Pos = 0x2
	// Bit mask of CFDPRESC field.
	OSC32KCTRL_CFDCTRL_CFDPRESC_Msk = 0x4
	// Bit CFDPRESC.
	OSC32KCTRL_CFDCTRL_CFDPRESC = 0x4

	// EVCTRL: Event Control
	// Position of CFDEO field.
	OSC32KCTRL_EVCTRL_CFDEO_Pos = 0x0
	// Bit mask of CFDEO field.
	OSC32KCTRL_EVCTRL_CFDEO_Msk = 0x1
	// Bit CFDEO.
	OSC32KCTRL_EVCTRL_CFDEO = 0x1

	// OSCULP32K: 32kHz Ultra Low Power Internal Oscillator (OSCULP32K) Control
	// Position of EN32K field.
	OSC32KCTRL_OSCULP32K_EN32K_Pos = 0x1
	// Bit mask of EN32K field.
	OSC32KCTRL_OSCULP32K_EN32K_Msk = 0x2
	// Bit EN32K.
	OSC32KCTRL_OSCULP32K_EN32K = 0x2
	// Position of EN1K field.
	OSC32KCTRL_OSCULP32K_EN1K_Pos = 0x2
	// Bit mask of EN1K field.
	OSC32KCTRL_OSCULP32K_EN1K_Msk = 0x4
	// Bit EN1K.
	OSC32KCTRL_OSCULP32K_EN1K = 0x4
	// Position of CALIB field.
	OSC32KCTRL_OSCULP32K_CALIB_Pos = 0x8
	// Bit mask of CALIB field.
	OSC32KCTRL_OSCULP32K_CALIB_Msk = 0x1f00
	// Position of WRTLOCK field.
	OSC32KCTRL_OSCULP32K_WRTLOCK_Pos = 0xf
	// Bit mask of WRTLOCK field.
	OSC32KCTRL_OSCULP32K_WRTLOCK_Msk = 0x8000
	// Bit WRTLOCK.
	OSC32KCTRL_OSCULP32K_WRTLOCK = 0x8000
)

// Constants for PAC: Peripheral Access Controller
const (
	// WRCTRL: Write control
	// Position of PERID field.
	PAC_WRCTRL_PERID_Pos = 0x0
	// Bit mask of PERID field.
	PAC_WRCTRL_PERID_Msk = 0xffff
	// Position of KEY field.
	PAC_WRCTRL_KEY_Pos = 0x10
	// Bit mask of KEY field.
	PAC_WRCTRL_KEY_Msk = 0xff0000
	// No action
	PAC_WRCTRL_KEY_OFF = 0x0
	// Clear protection
	PAC_WRCTRL_KEY_CLR = 0x1
	// Set protection
	PAC_WRCTRL_KEY_SET = 0x2
	// Set and lock protection
	PAC_WRCTRL_KEY_SETLCK = 0x3

	// EVCTRL: Event control
	// Position of ERREO field.
	PAC_EVCTRL_ERREO_Pos = 0x0
	// Bit mask of ERREO field.
	PAC_EVCTRL_ERREO_Msk = 0x1
	// Bit ERREO.
	PAC_EVCTRL_ERREO = 0x1

	// INTENCLR: Interrupt enable clear
	// Position of ERR field.
	PAC_INTENCLR_ERR_Pos = 0x0
	// Bit mask of ERR field.
	PAC_INTENCLR_ERR_Msk = 0x1
	// Bit ERR.
	PAC_INTENCLR_ERR = 0x1

	// INTENSET: Interrupt enable set
	// Position of ERR field.
	PAC_INTENSET_ERR_Pos = 0x0
	// Bit mask of ERR field.
	PAC_INTENSET_ERR_Msk = 0x1
	// Bit ERR.
	PAC_INTENSET_ERR = 0x1

	// INTFLAGAHB: Bridge interrupt flag status
	// Position of FLASH_ field.
	PAC_INTFLAGAHB_FLASH__Pos = 0x0
	// Bit mask of FLASH_ field.
	PAC_INTFLAGAHB_FLASH__Msk = 0x1
	// Bit FLASH_.
	PAC_INTFLAGAHB_FLASH_ = 0x1
	// Position of HSRAMCM0P_ field.
	PAC_INTFLAGAHB_HSRAMCM0P__Pos = 0x1
	// Bit mask of HSRAMCM0P_ field.
	PAC_INTFLAGAHB_HSRAMCM0P__Msk = 0x2
	// Bit HSRAMCM0P_.
	PAC_INTFLAGAHB_HSRAMCM0P_ = 0x2
	// Position of HSRAMDSU_ field.
	PAC_INTFLAGAHB_HSRAMDSU__Pos = 0x2
	// Bit mask of HSRAMDSU_ field.
	PAC_INTFLAGAHB_HSRAMDSU__Msk = 0x4
	// Bit HSRAMDSU_.
	PAC_INTFLAGAHB_HSRAMDSU_ = 0x4
	// Position of HPB1_ field.
	PAC_INTFLAGAHB_HPB1__Pos = 0x3
	// Bit mask of HPB1_ field.
	PAC_INTFLAGAHB_HPB1__Msk = 0x8
	// Bit HPB1_.
	PAC_INTFLAGAHB_HPB1_ = 0x8
	// Position of HPB0_ field.
	PAC_INTFLAGAHB_HPB0__Pos = 0x4
	// Bit mask of HPB0_ field.
	PAC_INTFLAGAHB_HPB0__Msk = 0x10
	// Bit HPB0_.
	PAC_INTFLAGAHB_HPB0_ = 0x10
	// Position of HPB2_ field.
	PAC_INTFLAGAHB_HPB2__Pos = 0x5
	// Bit mask of HPB2_ field.
	PAC_INTFLAGAHB_HPB2__Msk = 0x20
	// Bit HPB2_.
	PAC_INTFLAGAHB_HPB2_ = 0x20
	// Position of HSRAMDMAC_ field.
	PAC_INTFLAGAHB_HSRAMDMAC__Pos = 0x6
	// Bit mask of HSRAMDMAC_ field.
	PAC_INTFLAGAHB_HSRAMDMAC__Msk = 0x40
	// Bit HSRAMDMAC_.
	PAC_INTFLAGAHB_HSRAMDMAC_ = 0x40

	// INTFLAGA: Peripheral interrupt flag status - Bridge A
	// Position of PAC_ field.
	PAC_INTFLAGA_PAC__Pos = 0x0
	// Bit mask of PAC_ field.
	PAC_INTFLAGA_PAC__Msk = 0x1
	// Bit PAC_.
	PAC_INTFLAGA_PAC_ = 0x1
	// Position of PM_ field.
	PAC_INTFLAGA_PM__Pos = 0x1
	// Bit mask of PM_ field.
	PAC_INTFLAGA_PM__Msk = 0x2
	// Bit PM_.
	PAC_INTFLAGA_PM_ = 0x2
	// Position of MCLK_ field.
	PAC_INTFLAGA_MCLK__Pos = 0x2
	// Bit mask of MCLK_ field.
	PAC_INTFLAGA_MCLK__Msk = 0x4
	// Bit MCLK_.
	PAC_INTFLAGA_MCLK_ = 0x4
	// Position of RSTC_ field.
	PAC_INTFLAGA_RSTC__Pos = 0x3
	// Bit mask of RSTC_ field.
	PAC_INTFLAGA_RSTC__Msk = 0x8
	// Bit RSTC_.
	PAC_INTFLAGA_RSTC_ = 0x8
	// Position of OSCCTRL_ field.
	PAC_INTFLAGA_OSCCTRL__Pos = 0x4
	// Bit mask of OSCCTRL_ field.
	PAC_INTFLAGA_OSCCTRL__Msk = 0x10
	// Bit OSCCTRL_.
	PAC_INTFLAGA_OSCCTRL_ = 0x10
	// Position of OSC32KCTRL_ field.
	PAC_INTFLAGA_OSC32KCTRL__Pos = 0x5
	// Bit mask of OSC32KCTRL_ field.
	PAC_INTFLAGA_OSC32KCTRL__Msk = 0x20
	// Bit OSC32KCTRL_.
	PAC_INTFLAGA_OSC32KCTRL_ = 0x20
	// Position of SUPC_ field.
	PAC_INTFLAGA_SUPC__Pos = 0x6
	// Bit mask of SUPC_ field.
	PAC_INTFLAGA_SUPC__Msk = 0x40
	// Bit SUPC_.
	PAC_INTFLAGA_SUPC_ = 0x40
	// Position of GCLK_ field.
	PAC_INTFLAGA_GCLK__Pos = 0x7
	// Bit mask of GCLK_ field.
	PAC_INTFLAGA_GCLK__Msk = 0x80
	// Bit GCLK_.
	PAC_INTFLAGA_GCLK_ = 0x80
	// Position of WDT_ field.
	PAC_INTFLAGA_WDT__Pos = 0x8
	// Bit mask of WDT_ field.
	PAC_INTFLAGA_WDT__Msk = 0x100
	// Bit WDT_.
	PAC_INTFLAGA_WDT_ = 0x100
	// Position of RTC_ field.
	PAC_INTFLAGA_RTC__Pos = 0x9
	// Bit mask of RTC_ field.
	PAC_INTFLAGA_RTC__Msk = 0x200
	// Bit RTC_.
	PAC_INTFLAGA_RTC_ = 0x200
	// Position of EIC_ field.
	PAC_INTFLAGA_EIC__Pos = 0xa
	// Bit mask of EIC_ field.
	PAC_INTFLAGA_EIC__Msk = 0x400
	// Bit EIC_.
	PAC_INTFLAGA_EIC_ = 0x400
	// Position of FREQM_ field.
	PAC_INTFLAGA_FREQM__Pos = 0xb
	// Bit mask of FREQM_ field.
	PAC_INTFLAGA_FREQM__Msk = 0x800
	// Bit FREQM_.
	PAC_INTFLAGA_FREQM_ = 0x800

	// INTFLAGB: Peripheral interrupt flag status - Bridge B
	// Position of USB_ field.
	PAC_INTFLAGB_USB__Pos = 0x0
	// Bit mask of USB_ field.
	PAC_INTFLAGB_USB__Msk = 0x1
	// Bit USB_.
	PAC_INTFLAGB_USB_ = 0x1
	// Position of DSU_ field.
	PAC_INTFLAGB_DSU__Pos = 0x1
	// Bit mask of DSU_ field.
	PAC_INTFLAGB_DSU__Msk = 0x2
	// Bit DSU_.
	PAC_INTFLAGB_DSU_ = 0x2
	// Position of NVMCTRL_ field.
	PAC_INTFLAGB_NVMCTRL__Pos = 0x2
	// Bit mask of NVMCTRL_ field.
	PAC_INTFLAGB_NVMCTRL__Msk = 0x4
	// Bit NVMCTRL_.
	PAC_INTFLAGB_NVMCTRL_ = 0x4
	// Position of PORT_ field.
	PAC_INTFLAGB_PORT__Pos = 0x3
	// Bit mask of PORT_ field.
	PAC_INTFLAGB_PORT__Msk = 0x8
	// Bit PORT_.
	PAC_INTFLAGB_PORT_ = 0x8
	// Position of DMAC_ field.
	PAC_INTFLAGB_DMAC__Pos = 0x4
	// Bit mask of DMAC_ field.
	PAC_INTFLAGB_DMAC__Msk = 0x10
	// Bit DMAC_.
	PAC_INTFLAGB_DMAC_ = 0x10
	// Position of MTB_ field.
	PAC_INTFLAGB_MTB__Pos = 0x5
	// Bit mask of MTB_ field.
	PAC_INTFLAGB_MTB__Msk = 0x20
	// Bit MTB_.
	PAC_INTFLAGB_MTB_ = 0x20

	// INTFLAGC: Peripheral interrupt flag status - Bridge C
	// Position of EVSYS_ field.
	PAC_INTFLAGC_EVSYS__Pos = 0x0
	// Bit mask of EVSYS_ field.
	PAC_INTFLAGC_EVSYS__Msk = 0x1
	// Bit EVSYS_.
	PAC_INTFLAGC_EVSYS_ = 0x1
	// Position of SERCOM0_ field.
	PAC_INTFLAGC_SERCOM0__Pos = 0x1
	// Bit mask of SERCOM0_ field.
	PAC_INTFLAGC_SERCOM0__Msk = 0x2
	// Bit SERCOM0_.
	PAC_INTFLAGC_SERCOM0_ = 0x2
	// Position of SERCOM1_ field.
	PAC_INTFLAGC_SERCOM1__Pos = 0x2
	// Bit mask of SERCOM1_ field.
	PAC_INTFLAGC_SERCOM1__Msk = 0x4
	// Bit SERCOM1_.
	PAC_INTFLAGC_SERCOM1_ = 0x4
	// Position of SERCOM2_ field.
	PAC_INTFLAGC_SERCOM2__Pos = 0x3
	// Bit mask of SERCOM2_ field.
	PAC_INTFLAGC_SERCOM2__Msk = 0x8
	// Bit SERCOM2_.
	PAC_INTFLAGC_SERCOM2_ = 0x8
	// Position of SERCOM3_ field.
	PAC_INTFLAGC_SERCOM3__Pos = 0x4
	// Bit mask of SERCOM3_ field.
	PAC_INTFLAGC_SERCOM3__Msk = 0x10
	// Bit SERCOM3_.
	PAC_INTFLAGC_SERCOM3_ = 0x10
	// Position of TCC0_ field.
	PAC_INTFLAGC_TCC0__Pos = 0x7
	// Bit mask of TCC0_ field.
	PAC_INTFLAGC_TCC0__Msk = 0x80
	// Bit TCC0_.
	PAC_INTFLAGC_TCC0_ = 0x80
	// Position of TC0_ field.
	PAC_INTFLAGC_TC0__Pos = 0x8
	// Bit mask of TC0_ field.
	PAC_INTFLAGC_TC0__Msk = 0x100
	// Bit TC0_.
	PAC_INTFLAGC_TC0_ = 0x100
	// Position of TC1_ field.
	PAC_INTFLAGC_TC1__Pos = 0x9
	// Bit mask of TC1_ field.
	PAC_INTFLAGC_TC1__Msk = 0x200
	// Bit TC1_.
	PAC_INTFLAGC_TC1_ = 0x200
	// Position of TC2_ field.
	PAC_INTFLAGC_TC2__Pos = 0xa
	// Bit mask of TC2_ field.
	PAC_INTFLAGC_TC2__Msk = 0x400
	// Bit TC2_.
	PAC_INTFLAGC_TC2_ = 0x400
	// Position of TC3_ field.
	PAC_INTFLAGC_TC3__Pos = 0xb
	// Bit mask of TC3_ field.
	PAC_INTFLAGC_TC3__Msk = 0x800
	// Bit TC3_.
	PAC_INTFLAGC_TC3_ = 0x800
	// Position of ADC_ field.
	PAC_INTFLAGC_ADC__Pos = 0xc
	// Bit mask of ADC_ field.
	PAC_INTFLAGC_ADC__Msk = 0x1000
	// Bit ADC_.
	PAC_INTFLAGC_ADC_ = 0x1000
	// Position of AC_ field.
	PAC_INTFLAGC_AC__Pos = 0xd
	// Bit mask of AC_ field.
	PAC_INTFLAGC_AC__Msk = 0x2000
	// Bit AC_.
	PAC_INTFLAGC_AC_ = 0x2000
	// Position of PTC_ field.
	PAC_INTFLAGC_PTC__Pos = 0xe
	// Bit mask of PTC_ field.
	PAC_INTFLAGC_PTC__Msk = 0x4000
	// Bit PTC_.
	PAC_INTFLAGC_PTC_ = 0x4000
	// Position of SLCD_ field.
	PAC_INTFLAGC_SLCD__Pos = 0xf
	// Bit mask of SLCD_ field.
	PAC_INTFLAGC_SLCD__Msk = 0x8000
	// Bit SLCD_.
	PAC_INTFLAGC_SLCD_ = 0x8000
	// Position of AES_ field.
	PAC_INTFLAGC_AES__Pos = 0x10
	// Bit mask of AES_ field.
	PAC_INTFLAGC_AES__Msk = 0x10000
	// Bit AES_.
	PAC_INTFLAGC_AES_ = 0x10000
	// Position of TRNG_ field.
	PAC_INTFLAGC_TRNG__Pos = 0x11
	// Bit mask of TRNG_ field.
	PAC_INTFLAGC_TRNG__Msk = 0x20000
	// Bit TRNG_.
	PAC_INTFLAGC_TRNG_ = 0x20000
	// Position of CCL_ field.
	PAC_INTFLAGC_CCL__Pos = 0x12
	// Bit mask of CCL_ field.
	PAC_INTFLAGC_CCL__Msk = 0x40000
	// Bit CCL_.
	PAC_INTFLAGC_CCL_ = 0x40000

	// STATUSA: Peripheral write protection status - Bridge A
	// Position of PAC_ field.
	PAC_STATUSA_PAC__Pos = 0x0
	// Bit mask of PAC_ field.
	PAC_STATUSA_PAC__Msk = 0x1
	// Bit PAC_.
	PAC_STATUSA_PAC_ = 0x1
	// Position of PM_ field.
	PAC_STATUSA_PM__Pos = 0x1
	// Bit mask of PM_ field.
	PAC_STATUSA_PM__Msk = 0x2
	// Bit PM_.
	PAC_STATUSA_PM_ = 0x2
	// Position of MCLK_ field.
	PAC_STATUSA_MCLK__Pos = 0x2
	// Bit mask of MCLK_ field.
	PAC_STATUSA_MCLK__Msk = 0x4
	// Bit MCLK_.
	PAC_STATUSA_MCLK_ = 0x4
	// Position of RSTC_ field.
	PAC_STATUSA_RSTC__Pos = 0x3
	// Bit mask of RSTC_ field.
	PAC_STATUSA_RSTC__Msk = 0x8
	// Bit RSTC_.
	PAC_STATUSA_RSTC_ = 0x8
	// Position of OSCCTRL_ field.
	PAC_STATUSA_OSCCTRL__Pos = 0x4
	// Bit mask of OSCCTRL_ field.
	PAC_STATUSA_OSCCTRL__Msk = 0x10
	// Bit OSCCTRL_.
	PAC_STATUSA_OSCCTRL_ = 0x10
	// Position of OSC32KCTRL_ field.
	PAC_STATUSA_OSC32KCTRL__Pos = 0x5
	// Bit mask of OSC32KCTRL_ field.
	PAC_STATUSA_OSC32KCTRL__Msk = 0x20
	// Bit OSC32KCTRL_.
	PAC_STATUSA_OSC32KCTRL_ = 0x20
	// Position of SUPC_ field.
	PAC_STATUSA_SUPC__Pos = 0x6
	// Bit mask of SUPC_ field.
	PAC_STATUSA_SUPC__Msk = 0x40
	// Bit SUPC_.
	PAC_STATUSA_SUPC_ = 0x40
	// Position of GCLK_ field.
	PAC_STATUSA_GCLK__Pos = 0x7
	// Bit mask of GCLK_ field.
	PAC_STATUSA_GCLK__Msk = 0x80
	// Bit GCLK_.
	PAC_STATUSA_GCLK_ = 0x80
	// Position of WDT_ field.
	PAC_STATUSA_WDT__Pos = 0x8
	// Bit mask of WDT_ field.
	PAC_STATUSA_WDT__Msk = 0x100
	// Bit WDT_.
	PAC_STATUSA_WDT_ = 0x100
	// Position of RTC_ field.
	PAC_STATUSA_RTC__Pos = 0x9
	// Bit mask of RTC_ field.
	PAC_STATUSA_RTC__Msk = 0x200
	// Bit RTC_.
	PAC_STATUSA_RTC_ = 0x200
	// Position of EIC_ field.
	PAC_STATUSA_EIC__Pos = 0xa
	// Bit mask of EIC_ field.
	PAC_STATUSA_EIC__Msk = 0x400
	// Bit EIC_.
	PAC_STATUSA_EIC_ = 0x400
	// Position of FREQM_ field.
	PAC_STATUSA_FREQM__Pos = 0xb
	// Bit mask of FREQM_ field.
	PAC_STATUSA_FREQM__Msk = 0x800
	// Bit FREQM_.
	PAC_STATUSA_FREQM_ = 0x800

	// STATUSB: Peripheral write protection status - Bridge B
	// Position of USB_ field.
	PAC_STATUSB_USB__Pos = 0x0
	// Bit mask of USB_ field.
	PAC_STATUSB_USB__Msk = 0x1
	// Bit USB_.
	PAC_STATUSB_USB_ = 0x1
	// Position of DSU_ field.
	PAC_STATUSB_DSU__Pos = 0x1
	// Bit mask of DSU_ field.
	PAC_STATUSB_DSU__Msk = 0x2
	// Bit DSU_.
	PAC_STATUSB_DSU_ = 0x2
	// Position of NVMCTRL_ field.
	PAC_STATUSB_NVMCTRL__Pos = 0x2
	// Bit mask of NVMCTRL_ field.
	PAC_STATUSB_NVMCTRL__Msk = 0x4
	// Bit NVMCTRL_.
	PAC_STATUSB_NVMCTRL_ = 0x4
	// Position of PORT_ field.
	PAC_STATUSB_PORT__Pos = 0x3
	// Bit mask of PORT_ field.
	PAC_STATUSB_PORT__Msk = 0x8
	// Bit PORT_.
	PAC_STATUSB_PORT_ = 0x8
	// Position of DMAC_ field.
	PAC_STATUSB_DMAC__Pos = 0x4
	// Bit mask of DMAC_ field.
	PAC_STATUSB_DMAC__Msk = 0x10
	// Bit DMAC_.
	PAC_STATUSB_DMAC_ = 0x10
	// Position of MTB_ field.
	PAC_STATUSB_MTB__Pos = 0x5
	// Bit mask of MTB_ field.
	PAC_STATUSB_MTB__Msk = 0x20
	// Bit MTB_.
	PAC_STATUSB_MTB_ = 0x20

	// STATUSC: Peripheral write protection status - Bridge C
	// Position of EVSYS_ field.
	PAC_STATUSC_EVSYS__Pos = 0x0
	// Bit mask of EVSYS_ field.
	PAC_STATUSC_EVSYS__Msk = 0x1
	// Bit EVSYS_.
	PAC_STATUSC_EVSYS_ = 0x1
	// Position of SERCOM0_ field.
	PAC_STATUSC_SERCOM0__Pos = 0x1
	// Bit mask of SERCOM0_ field.
	PAC_STATUSC_SERCOM0__Msk = 0x2
	// Bit SERCOM0_.
	PAC_STATUSC_SERCOM0_ = 0x2
	// Position of SERCOM1_ field.
	PAC_STATUSC_SERCOM1__Pos = 0x2
	// Bit mask of SERCOM1_ field.
	PAC_STATUSC_SERCOM1__Msk = 0x4
	// Bit SERCOM1_.
	PAC_STATUSC_SERCOM1_ = 0x4
	// Position of SERCOM2_ field.
	PAC_STATUSC_SERCOM2__Pos = 0x3
	// Bit mask of SERCOM2_ field.
	PAC_STATUSC_SERCOM2__Msk = 0x8
	// Bit SERCOM2_.
	PAC_STATUSC_SERCOM2_ = 0x8
	// Position of SERCOM3_ field.
	PAC_STATUSC_SERCOM3__Pos = 0x4
	// Bit mask of SERCOM3_ field.
	PAC_STATUSC_SERCOM3__Msk = 0x10
	// Bit SERCOM3_.
	PAC_STATUSC_SERCOM3_ = 0x10
	// Position of TCC0_ field.
	PAC_STATUSC_TCC0__Pos = 0x7
	// Bit mask of TCC0_ field.
	PAC_STATUSC_TCC0__Msk = 0x80
	// Bit TCC0_.
	PAC_STATUSC_TCC0_ = 0x80
	// Position of TC0_ field.
	PAC_STATUSC_TC0__Pos = 0x8
	// Bit mask of TC0_ field.
	PAC_STATUSC_TC0__Msk = 0x100
	// Bit TC0_.
	PAC_STATUSC_TC0_ = 0x100
	// Position of TC1_ field.
	PAC_STATUSC_TC1__Pos = 0x9
	// Bit mask of TC1_ field.
	PAC_STATUSC_TC1__Msk = 0x200
	// Bit TC1_.
	PAC_STATUSC_TC1_ = 0x200
	// Position of TC2_ field.
	PAC_STATUSC_TC2__Pos = 0xa
	// Bit mask of TC2_ field.
	PAC_STATUSC_TC2__Msk = 0x400
	// Bit TC2_.
	PAC_STATUSC_TC2_ = 0x400
	// Position of TC3_ field.
	PAC_STATUSC_TC3__Pos = 0xb
	// Bit mask of TC3_ field.
	PAC_STATUSC_TC3__Msk = 0x800
	// Bit TC3_.
	PAC_STATUSC_TC3_ = 0x800
	// Position of ADC_ field.
	PAC_STATUSC_ADC__Pos = 0xc
	// Bit mask of ADC_ field.
	PAC_STATUSC_ADC__Msk = 0x1000
	// Bit ADC_.
	PAC_STATUSC_ADC_ = 0x1000
	// Position of AC_ field.
	PAC_STATUSC_AC__Pos = 0xd
	// Bit mask of AC_ field.
	PAC_STATUSC_AC__Msk = 0x2000
	// Bit AC_.
	PAC_STATUSC_AC_ = 0x2000
	// Position of PTC_ field.
	PAC_STATUSC_PTC__Pos = 0xe
	// Bit mask of PTC_ field.
	PAC_STATUSC_PTC__Msk = 0x4000
	// Bit PTC_.
	PAC_STATUSC_PTC_ = 0x4000
	// Position of SLCD_ field.
	PAC_STATUSC_SLCD__Pos = 0xf
	// Bit mask of SLCD_ field.
	PAC_STATUSC_SLCD__Msk = 0x8000
	// Bit SLCD_.
	PAC_STATUSC_SLCD_ = 0x8000
	// Position of AES_ field.
	PAC_STATUSC_AES__Pos = 0x10
	// Bit mask of AES_ field.
	PAC_STATUSC_AES__Msk = 0x10000
	// Bit AES_.
	PAC_STATUSC_AES_ = 0x10000
	// Position of TRNG_ field.
	PAC_STATUSC_TRNG__Pos = 0x11
	// Bit mask of TRNG_ field.
	PAC_STATUSC_TRNG__Msk = 0x20000
	// Bit TRNG_.
	PAC_STATUSC_TRNG_ = 0x20000
	// Position of CCL_ field.
	PAC_STATUSC_CCL__Pos = 0x12
	// Bit mask of CCL_ field.
	PAC_STATUSC_CCL__Msk = 0x40000
	// Bit CCL_.
	PAC_STATUSC_CCL_ = 0x40000
)

// Constants for PM: Power Manager
const (
	// CTRLA: Control A
	// Position of IORET field.
	PM_CTRLA_IORET_Pos = 0x2
	// Bit mask of IORET field.
	PM_CTRLA_IORET_Msk = 0x4
	// Bit IORET.
	PM_CTRLA_IORET = 0x4

	// SLEEPCFG: Sleep Configuration
	// Position of SLEEPMODE field.
	PM_SLEEPCFG_SLEEPMODE_Pos = 0x0
	// Bit mask of SLEEPMODE field.
	PM_SLEEPCFG_SLEEPMODE_Msk = 0x7
	// CPU clock is OFF
	PM_SLEEPCFG_SLEEPMODE_IDLE0 = 0x0
	// AHB clock is OFF
	PM_SLEEPCFG_SLEEPMODE_IDLE1 = 0x1
	// APB clock are OFF
	PM_SLEEPCFG_SLEEPMODE_IDLE2 = 0x2
	// All Clocks are OFF
	PM_SLEEPCFG_SLEEPMODE_STANDBY = 0x4
	// Only Backup domain is powered ON
	PM_SLEEPCFG_SLEEPMODE_BACKUP = 0x5
	// All power domains are powered OFF
	PM_SLEEPCFG_SLEEPMODE_OFF = 0x6

	// PLCFG: Performance Level Configuration
	// Position of PLSEL field.
	PM_PLCFG_PLSEL_Pos = 0x0
	// Bit mask of PLSEL field.
	PM_PLCFG_PLSEL_Msk = 0x3
	// Performance Level 0
	PM_PLCFG_PLSEL_PL0 = 0x0
	// Performance Level 1
	PM_PLCFG_PLSEL_PL1 = 0x1
	// Performance Level 2
	PM_PLCFG_PLSEL_PL2 = 0x2
	// Position of PLDIS field.
	PM_PLCFG_PLDIS_Pos = 0x7
	// Bit mask of PLDIS field.
	PM_PLCFG_PLDIS_Msk = 0x80
	// Bit PLDIS.
	PM_PLCFG_PLDIS = 0x80

	// INTENCLR: Interrupt Enable Clear
	// Position of PLRDY field.
	PM_INTENCLR_PLRDY_Pos = 0x0
	// Bit mask of PLRDY field.
	PM_INTENCLR_PLRDY_Msk = 0x1
	// Bit PLRDY.
	PM_INTENCLR_PLRDY = 0x1

	// INTENSET: Interrupt Enable Set
	// Position of PLRDY field.
	PM_INTENSET_PLRDY_Pos = 0x0
	// Bit mask of PLRDY field.
	PM_INTENSET_PLRDY_Msk = 0x1
	// Bit PLRDY.
	PM_INTENSET_PLRDY = 0x1

	// INTFLAG: Interrupt Flag Status and Clear
	// Position of PLRDY field.
	PM_INTFLAG_PLRDY_Pos = 0x0
	// Bit mask of PLRDY field.
	PM_INTFLAG_PLRDY_Msk = 0x1
	// Bit PLRDY.
	PM_INTFLAG_PLRDY = 0x1

	// STDBYCFG: Standby Configuration
	// Position of VREGSMOD field.
	PM_STDBYCFG_VREGSMOD_Pos = 0x6
	// Bit mask of VREGSMOD field.
	PM_STDBYCFG_VREGSMOD_Msk = 0xc0
	// Automatic mode
	PM_STDBYCFG_VREGSMOD_AUTO = 0x0
	// Performance oriented
	PM_STDBYCFG_VREGSMOD_PERFORMANCE = 0x1
	// Low Power oriented
	PM_STDBYCFG_VREGSMOD_LP = 0x2
	// Position of BBIASHS field.
	PM_STDBYCFG_BBIASHS_Pos = 0xa
	// Bit mask of BBIASHS field.
	PM_STDBYCFG_BBIASHS_Msk = 0xc00
)

// Constants for PORT: Port Module
const (
	// CTRL0: Control
	// Position of SAMPLING field.
	PORT_CTRL_SAMPLING_Pos = 0x0
	// Bit mask of SAMPLING field.
	PORT_CTRL_SAMPLING_Msk = 0xffffffff

	// WRCONFIG0: Write Configuration
	// Position of PINMASK field.
	PORT_WRCONFIG_PINMASK_Pos = 0x0
	// Bit mask of PINMASK field.
	PORT_WRCONFIG_PINMASK_Msk = 0xffff
	// Position of PMUXEN field.
	PORT_WRCONFIG_PMUXEN_Pos = 0x10
	// Bit mask of PMUXEN field.
	PORT_WRCONFIG_PMUXEN_Msk = 0x10000
	// Bit PMUXEN.
	PORT_WRCONFIG_PMUXEN = 0x10000
	// Position of INEN field.
	PORT_WRCONFIG_INEN_Pos = 0x11
	// Bit mask of INEN field.
	PORT_WRCONFIG_INEN_Msk = 0x20000
	// Bit INEN.
	PORT_WRCONFIG_INEN = 0x20000
	// Position of PULLEN field.
	PORT_WRCONFIG_PULLEN_Pos = 0x12
	// Bit mask of PULLEN field.
	PORT_WRCONFIG_PULLEN_Msk = 0x40000
	// Bit PULLEN.
	PORT_WRCONFIG_PULLEN = 0x40000
	// Position of DRVSTR field.
	PORT_WRCONFIG_DRVSTR_Pos = 0x16
	// Bit mask of DRVSTR field.
	PORT_WRCONFIG_DRVSTR_Msk = 0x400000
	// Bit DRVSTR.
	PORT_WRCONFIG_DRVSTR = 0x400000
	// Position of PMUX field.
	PORT_WRCONFIG_PMUX_Pos = 0x18
	// Bit mask of PMUX field.
	PORT_WRCONFIG_PMUX_Msk = 0xf000000
	// Position of WRPMUX field.
	PORT_WRCONFIG_WRPMUX_Pos = 0x1c
	// Bit mask of WRPMUX field.
	PORT_WRCONFIG_WRPMUX_Msk = 0x10000000
	// Bit WRPMUX.
	PORT_WRCONFIG_WRPMUX = 0x10000000
	// Position of WRPINCFG field.
	PORT_WRCONFIG_WRPINCFG_Pos = 0x1e
	// Bit mask of WRPINCFG field.
	PORT_WRCONFIG_WRPINCFG_Msk = 0x40000000
	// Bit WRPINCFG.
	PORT_WRCONFIG_WRPINCFG = 0x40000000
	// Position of HWSEL field.
	PORT_WRCONFIG_HWSEL_Pos = 0x1f
	// Bit mask of HWSEL field.
	PORT_WRCONFIG_HWSEL_Msk = 0x80000000
	// Bit HWSEL.
	PORT_WRCONFIG_HWSEL = 0x80000000

	// EVCTRL0: Event Input Control
	// Position of PID0 field.
	PORT_EVCTRL_PID0_Pos = 0x0
	// Bit mask of PID0 field.
	PORT_EVCTRL_PID0_Msk = 0x1f
	// Position of EVACT0 field.
	PORT_EVCTRL_EVACT0_Pos = 0x5
	// Bit mask of EVACT0 field.
	PORT_EVCTRL_EVACT0_Msk = 0x60
	// Position of PORTEI0 field.
	PORT_EVCTRL_PORTEI0_Pos = 0x7
	// Bit mask of PORTEI0 field.
	PORT_EVCTRL_PORTEI0_Msk = 0x80
	// Bit PORTEI0.
	PORT_EVCTRL_PORTEI0 = 0x80
	// Position of PID1 field.
	PORT_EVCTRL_PID1_Pos = 0x8
	// Bit mask of PID1 field.
	PORT_EVCTRL_PID1_Msk = 0x1f00
	// Position of EVACT1 field.
	PORT_EVCTRL_EVACT1_Pos = 0xd
	// Bit mask of EVACT1 field.
	PORT_EVCTRL_EVACT1_Msk = 0x6000
	// Position of PORTEI1 field.
	PORT_EVCTRL_PORTEI1_Pos = 0xf
	// Bit mask of PORTEI1 field.
	PORT_EVCTRL_PORTEI1_Msk = 0x8000
	// Bit PORTEI1.
	PORT_EVCTRL_PORTEI1 = 0x8000
	// Position of PID2 field.
	PORT_EVCTRL_PID2_Pos = 0x10
	// Bit mask of PID2 field.
	PORT_EVCTRL_PID2_Msk = 0x1f0000
	// Position of EVACT2 field.
	PORT_EVCTRL_EVACT2_Pos = 0x15
	// Bit mask of EVACT2 field.
	PORT_EVCTRL_EVACT2_Msk = 0x600000
	// Position of PORTEI2 field.
	PORT_EVCTRL_PORTEI2_Pos = 0x17
	// Bit mask of PORTEI2 field.
	PORT_EVCTRL_PORTEI2_Msk = 0x800000
	// Bit PORTEI2.
	PORT_EVCTRL_PORTEI2 = 0x800000
	// Position of PID3 field.
	PORT_EVCTRL_PID3_Pos = 0x18
	// Bit mask of PID3 field.
	PORT_EVCTRL_PID3_Msk = 0x1f000000
	// Position of EVACT3 field.
	PORT_EVCTRL_EVACT3_Pos = 0x1d
	// Bit mask of EVACT3 field.
	PORT_EVCTRL_EVACT3_Msk = 0x60000000
	// Position of PORTEI3 field.
	PORT_EVCTRL_PORTEI3_Pos = 0x1f
	// Bit mask of PORTEI3 field.
	PORT_EVCTRL_PORTEI3_Msk = 0x80000000
	// Bit PORTEI3.
	PORT_EVCTRL_PORTEI3 = 0x80000000

	// PMUX0_0: Peripheral Multiplexing n - Group 0
	// Position of PMUXE field.
	PORT_PMUX0_PMUXE_Pos = 0x0
	// Bit mask of PMUXE field.
	PORT_PMUX0_PMUXE_Msk = 0xf
	// Position of PMUXO field.
	PORT_PMUX0_PMUXO_Pos = 0x4
	// Bit mask of PMUXO field.
	PORT_PMUX0_PMUXO_Msk = 0xf0

	// PINCFG0_0: Pin Configuration n - Group 0
	// Position of PMUXEN field.
	PORT_PINCFG0_PMUXEN_Pos = 0x0
	// Bit mask of PMUXEN field.
	PORT_PINCFG0_PMUXEN_Msk = 0x1
	// Bit PMUXEN.
	PORT_PINCFG0_PMUXEN = 0x1
	// Position of INEN field.
	PORT_PINCFG0_INEN_Pos = 0x1
	// Bit mask of INEN field.
	PORT_PINCFG0_INEN_Msk = 0x2
	// Bit INEN.
	PORT_PINCFG0_INEN = 0x2
	// Position of PULLEN field.
	PORT_PINCFG0_PULLEN_Pos = 0x2
	// Bit mask of PULLEN field.
	PORT_PINCFG0_PULLEN_Msk = 0x4
	// Bit PULLEN.
	PORT_PINCFG0_PULLEN = 0x4
	// Position of DRVSTR field.
	PORT_PINCFG0_DRVSTR_Pos = 0x6
	// Bit mask of DRVSTR field.
	PORT_PINCFG0_DRVSTR_Msk = 0x40
	// Bit DRVSTR.
	PORT_PINCFG0_DRVSTR = 0x40
)

// Constants for RSTC: Reset Controller
const (
	// RCAUSE: Reset Cause
	// Position of POR field.
	RSTC_RCAUSE_POR_Pos = 0x0
	// Bit mask of POR field.
	RSTC_RCAUSE_POR_Msk = 0x1
	// Bit POR.
	RSTC_RCAUSE_POR = 0x1
	// Position of BODCORE field.
	RSTC_RCAUSE_BODCORE_Pos = 0x1
	// Bit mask of BODCORE field.
	RSTC_RCAUSE_BODCORE_Msk = 0x2
	// Bit BODCORE.
	RSTC_RCAUSE_BODCORE = 0x2
	// Position of BODVDD field.
	RSTC_RCAUSE_BODVDD_Pos = 0x2
	// Bit mask of BODVDD field.
	RSTC_RCAUSE_BODVDD_Msk = 0x4
	// Bit BODVDD.
	RSTC_RCAUSE_BODVDD = 0x4
	// Position of EXT field.
	RSTC_RCAUSE_EXT_Pos = 0x4
	// Bit mask of EXT field.
	RSTC_RCAUSE_EXT_Msk = 0x10
	// Bit EXT.
	RSTC_RCAUSE_EXT = 0x10
	// Position of WDT field.
	RSTC_RCAUSE_WDT_Pos = 0x5
	// Bit mask of WDT field.
	RSTC_RCAUSE_WDT_Msk = 0x20
	// Bit WDT.
	RSTC_RCAUSE_WDT = 0x20
	// Position of SYST field.
	RSTC_RCAUSE_SYST_Pos = 0x6
	// Bit mask of SYST field.
	RSTC_RCAUSE_SYST_Msk = 0x40
	// Bit SYST.
	RSTC_RCAUSE_SYST = 0x40
	// Position of BACKUP field.
	RSTC_RCAUSE_BACKUP_Pos = 0x7
	// Bit mask of BACKUP field.
	RSTC_RCAUSE_BACKUP_Msk = 0x80
	// Bit BACKUP.
	RSTC_RCAUSE_BACKUP = 0x80

	// BKUPEXIT: Backup Exit Source
	// Position of RTC field.
	RSTC_BKUPEXIT_RTC_Pos = 0x1
	// Bit mask of RTC field.
	RSTC_BKUPEXIT_RTC_Msk = 0x2
	// Bit RTC.
	RSTC_BKUPEXIT_RTC = 0x2
	// Position of BBPS field.
	RSTC_BKUPEXIT_BBPS_Pos = 0x2
	// Bit mask of BBPS field.
	RSTC_BKUPEXIT_BBPS_Msk = 0x4
	// Bit BBPS.
	RSTC_BKUPEXIT_BBPS = 0x4
)

// Constants for RTC: Real-Time Counter
const ()

// Constants for RTC_MODE0: Real-Time Counter - MODE0
const (
	// CTRLA: MODE0 Control A
	// Position of SWRST field.
	RTC_MODE0_CTRLA_SWRST_Pos = 0x0
	// Bit mask of SWRST field.
	RTC_MODE0_CTRLA_SWRST_Msk = 0x1
	// Bit SWRST.
	RTC_MODE0_CTRLA_SWRST = 0x1
	// Position of ENABLE field.
	RTC_MODE0_CTRLA_ENABLE_Pos = 0x1
	// Bit mask of ENABLE field.
	RTC_MODE0_CTRLA_ENABLE_Msk = 0x2
	// Bit ENABLE.
	RTC_MODE0_CTRLA_ENABLE = 0x2
	// Position of MODE field.
	RTC_MODE0_CTRLA_MODE_Pos = 0x2
	// Bit mask of MODE field.
	RTC_MODE0_CTRLA_MODE_Msk = 0xc
	// Mode 0: 32-bit Counter
	RTC_MODE0_CTRLA_MODE_COUNT32 = 0x0
	// Mode 1: 16-bit Counter
	RTC_MODE0_CTRLA_MODE_COUNT16 = 0x1
	// Mode 2: Clock/Calendar
	RTC_MODE0_CTRLA_MODE_CLOCK = 0x2
	// Position of MATCHCLR field.
	RTC_MODE0_CTRLA_MATCHCLR_Pos = 0x7
	// Bit mask of MATCHCLR field.
	RTC_MODE0_CTRLA_MATCHCLR_Msk = 0x80
	// Bit MATCHCLR.
	RTC_MODE0_CTRLA_MATCHCLR = 0x80
	// Position of PRESCALER field.
	RTC_MODE0_CTRLA_PRESCALER_Pos = 0x8
	// Bit mask of PRESCALER field.
	RTC_MODE0_CTRLA_PRESCALER_Msk = 0xf00
	// CLK_RTC_CNT = GCLK_RTC/1
	RTC_MODE0_CTRLA_PRESCALER_OFF = 0x0
	// CLK_RTC_CNT = GCLK_RTC/1
	RTC_MODE0_CTRLA_PRESCALER_DIV1 = 0x1
	// CLK_RTC_CNT = GCLK_RTC/2
	RTC_MODE0_CTRLA_PRESCALER_DIV2 = 0x2
	// CLK_RTC_CNT = GCLK_RTC/4
	RTC_MODE0_CTRLA_PRESCALER_DIV4 = 0x3
	// CLK_RTC_CNT = GCLK_RTC/8
	RTC_MODE0_CTRLA_PRESCALER_DIV8 = 0x4
	// CLK_RTC_CNT = GCLK_RTC/16
	RTC_MODE0_CTRLA_PRESCALER_DIV16 = 0x5
	// CLK_RTC_CNT = GCLK_RTC/32
	RTC_MODE0_CTRLA_PRESCALER_DIV32 = 0x6
	// CLK_RTC_CNT = GCLK_RTC/64
	RTC_MODE0_CTRLA_PRESCALER_DIV64 = 0x7
	// CLK_RTC_CNT = GCLK_RTC/128
	RTC_MODE0_CTRLA_PRESCALER_DIV128 = 0x8
	// CLK_RTC_CNT = GCLK_RTC/256
	RTC_MODE0_CTRLA_PRESCALER_DIV256 = 0x9
	// CLK_RTC_CNT = GCLK_RTC/512
	RTC_MODE0_CTRLA_PRESCALER_DIV512 = 0xa
	// CLK_RTC_CNT = GCLK_RTC/1024
	RTC_MODE0_CTRLA_PRESCALER_DIV1024 = 0xb
	// Position of BKTRST field.
	RTC_MODE0_CTRLA_BKTRST_Pos = 0xd
	// Bit mask of BKTRST field.
	RTC_MODE0_CTRLA_BKTRST_Msk = 0x2000
	// Bit BKTRST.
	RTC_MODE0_CTRLA_BKTRST = 0x2000
	// Position of GPTRST field.
	RTC_MODE0_CTRLA_GPTRST_Pos = 0xe
	// Bit mask of GPTRST field.
	RTC_MODE0_CTRLA_GPTRST_Msk = 0x4000
	// Bit GPTRST.
	RTC_MODE0_CTRLA_GPTRST = 0x4000
	// Position of COUNTSYNC field.
	RTC_MODE0_CTRLA_COUNTSYNC_Pos = 0xf
	// Bit mask of COUNTSYNC field.
	RTC_MODE0_CTRLA_COUNTSYNC_Msk = 0x8000
	// Bit COUNTSYNC.
	RTC_MODE0_CTRLA_COUNTSYNC = 0x8000

	// CTRLB: MODE0 Control B
	// Position of GP0EN field.
	RTC_MODE0_CTRLB_GP0EN_Pos = 0x0
	// Bit mask of GP0EN field.
	RTC_MODE0_CTRLB_GP0EN_Msk = 0x1
	// Bit GP0EN.
	RTC_MODE0_CTRLB_GP0EN = 0x1
	// Position of DEBMAJ field.
	RTC_MODE0_CTRLB_DEBMAJ_Pos = 0x4
	// Bit mask of DEBMAJ field.
	RTC_MODE0_CTRLB_DEBMAJ_Msk = 0x10
	// Bit DEBMAJ.
	RTC_MODE0_CTRLB_DEBMAJ = 0x10
	// Position of DEBASYNC field.
	RTC_MODE0_CTRLB_DEBASYNC_Pos = 0x5
	// Bit mask of DEBASYNC field.
	RTC_MODE0_CTRLB_DEBASYNC_Msk = 0x20
	// Bit DEBASYNC.
	RTC_MODE0_CTRLB_DEBASYNC = 0x20
	// Position of RTCOUT field.
	RTC_MODE0_CTRLB_RTCOUT_Pos = 0x6
	// Bit mask of RTCOUT field.
	RTC_MODE0_CTRLB_RTCOUT_Msk = 0x40
	// Bit RTCOUT.
	RTC_MODE0_CTRLB_RTCOUT = 0x40
	// Position of DMAEN field.
	RTC_MODE0_CTRLB_DMAEN_Pos = 0x7
	// Bit mask of DMAEN field.
	RTC_MODE0_CTRLB_DMAEN_Msk = 0x80
	// Bit DMAEN.
	RTC_MODE0_CTRLB_DMAEN = 0x80
	// Position of DEBF field.
	RTC_MODE0_CTRLB_DEBF_Pos = 0x8
	// Bit mask of DEBF field.
	RTC_MODE0_CTRLB_DEBF_Msk = 0x700
	// CLK_RTC_DEB = CLK_RTC/2
	RTC_MODE0_CTRLB_DEBF_DIV2 = 0x0
	// CLK_RTC_DEB = CLK_RTC/4
	RTC_MODE0_CTRLB_DEBF_DIV4 = 0x1
	// CLK_RTC_DEB = CLK_RTC/8
	RTC_MODE0_CTRLB_DEBF_DIV8 = 0x2
	// CLK_RTC_DEB = CLK_RTC/16
	RTC_MODE0_CTRLB_DEBF_DIV16 = 0x3
	// CLK_RTC_DEB = CLK_RTC/32
	RTC_MODE0_CTRLB_DEBF_DIV32 = 0x4
	// CLK_RTC_DEB = CLK_RTC/64
	RTC_MODE0_CTRLB_DEBF_DIV64 = 0x5
	// CLK_RTC_DEB = CLK_RTC/128
	RTC_MODE0_CTRLB_DEBF_DIV128 = 0x6
	// CLK_RTC_DEB = CLK_RTC/256
	RTC_MODE0_CTRLB_DEBF_DIV256 = 0x7
	// Position of ACTF field.
	RTC_MODE0_CTRLB_ACTF_Pos = 0xc
	// Bit mask of ACTF field.
	RTC_MODE0_CTRLB_ACTF_Msk = 0x7000
	// CLK_RTC_OUT = CLK_RTC/2
	RTC_MODE0_CTRLB_ACTF_DIV2 = 0x0
	// CLK_RTC_OUT = CLK_RTC/4
	RTC_MODE0_CTRLB_ACTF_DIV4 = 0x1
	// CLK_RTC_OUT = CLK_RTC/8
	RTC_MODE0_CTRLB_ACTF_DIV8 = 0x2
	// CLK_RTC_OUT = CLK_RTC/16
	RTC_MODE0_CTRLB_ACTF_DIV16 = 0x3
	// CLK_RTC_OUT = CLK_RTC/32
	RTC_MODE0_CTRLB_ACTF_DIV32 = 0x4
	// CLK_RTC_OUT = CLK_RTC/64
	RTC_MODE0_CTRLB_ACTF_DIV64 = 0x5
	// CLK_RTC_OUT = CLK_RTC/128
	RTC_MODE0_CTRLB_ACTF_DIV128 = 0x6
	// CLK_RTC_OUT = CLK_RTC/256
	RTC_MODE0_CTRLB_ACTF_DIV256 = 0x7

	// EVCTRL: MODE0 Event Control
	// Position of PEREO0 field.
	RTC_MODE0_EVCTRL_PEREO0_Pos = 0x0
	// Bit mask of PEREO0 field.
	RTC_MODE0_EVCTRL_PEREO0_Msk = 0x1
	// Bit PEREO0.
	RTC_MODE0_EVCTRL_PEREO0 = 0x1
	// Position of PEREO1 field.
	RTC_MODE0_EVCTRL_PEREO1_Pos = 0x1
	// Bit mask of PEREO1 field.
	RTC_MODE0_EVCTRL_PEREO1_Msk = 0x2
	// Bit PEREO1.
	RTC_MODE0_EVCTRL_PEREO1 = 0x2
	// Position of PEREO2 field.
	RTC_MODE0_EVCTRL_PEREO2_Pos = 0x2
	// Bit mask of PEREO2 field.
	RTC_MODE0_EVCTRL_PEREO2_Msk = 0x4
	// Bit PEREO2.
	RTC_MODE0_EVCTRL_PEREO2 = 0x4
	// Position of PEREO3 field.
	RTC_MODE0_EVCTRL_PEREO3_Pos = 0x3
	// Bit mask of PEREO3 field.
	RTC_MODE0_EVCTRL_PEREO3_Msk = 0x8
	// Bit PEREO3.
	RTC_MODE0_EVCTRL_PEREO3 = 0x8
	// Position of PEREO4 field.
	RTC_MODE0_EVCTRL_PEREO4_Pos = 0x4
	// Bit mask of PEREO4 field.
	RTC_MODE0_EVCTRL_PEREO4_Msk = 0x10
	// Bit PEREO4.
	RTC_MODE0_EVCTRL_PEREO4 = 0x10
	// Position of PEREO5 field.
	RTC_MODE0_EVCTRL_PEREO5_Pos = 0x5
	// Bit mask of PEREO5 field.
	RTC_MODE0_EVCTRL_PEREO5_Msk = 0x20
	// Bit PEREO5.
	RTC_MODE0_EVCTRL_PEREO5 = 0x20
	// Position of PEREO6 field.
	RTC_MODE0_EVCTRL_PEREO6_Pos = 0x6
	// Bit mask of PEREO6 field.
	RTC_MODE0_EVCTRL_PEREO6_Msk = 0x40
	// Bit PEREO6.
	RTC_MODE0_EVCTRL_PEREO6 = 0x40
	// Position of PEREO7 field.
	RTC_MODE0_EVCTRL_PEREO7_Pos = 0x7
	// Bit mask of PEREO7 field.
	RTC_MODE0_EVCTRL_PEREO7_Msk = 0x80
	// Bit PEREO7.
	RTC_MODE0_EVCTRL_PEREO7 = 0x80
	// Position of CMPEO0 field.
	RTC_MODE0_EVCTRL_CMPEO0_Pos = 0x8
	// Bit mask of CMPEO0 field.
	RTC_MODE0_EVCTRL_CMPEO0_Msk = 0x100
	// Bit CMPEO0.
	RTC_MODE0_EVCTRL_CMPEO0 = 0x100
	// Position of TAMPEREO field.
	RTC_MODE0_EVCTRL_TAMPEREO_Pos = 0xe
	// Bit mask of TAMPEREO field.
	RTC_MODE0_EVCTRL_TAMPEREO_Msk = 0x4000
	// Bit TAMPEREO.
	RTC_MODE0_EVCTRL_TAMPEREO = 0x4000
	// Position of OVFEO field.
	RTC_MODE0_EVCTRL_OVFEO_Pos = 0xf
	// Bit mask of OVFEO field.
	RTC_MODE0_EVCTRL_OVFEO_Msk = 0x8000
	// Bit OVFEO.
	RTC_MODE0_EVCTRL_OVFEO = 0x8000
	// Position of TAMPEVEI field.
	RTC_MODE0_EVCTRL_TAMPEVEI_Pos = 0x10
	// Bit mask of TAMPEVEI field.
	RTC_MODE0_EVCTRL_TAMPEVEI_Msk = 0x10000
	// Bit TAMPEVEI.
	RTC_MODE0_EVCTRL_TAMPEVEI = 0x10000

	// INTENCLR: MODE0 Interrupt Enable Clear
	// Position of PER0 field.
	RTC_MODE0_INTENCLR_PER0_Pos = 0x0
	// Bit mask of PER0 field.
	RTC_MODE0_INTENCLR_PER0_Msk = 0x1
	// Bit PER0.
	RTC_MODE0_INTENCLR_PER0 = 0x1
	// Position of PER1 field.
	RTC_MODE0_INTENCLR_PER1_Pos = 0x1
	// Bit mask of PER1 field.
	RTC_MODE0_INTENCLR_PER1_Msk = 0x2
	// Bit PER1.
	RTC_MODE0_INTENCLR_PER1 = 0x2
	// Position of PER2 field.
	RTC_MODE0_INTENCLR_PER2_Pos = 0x2
	// Bit mask of PER2 field.
	RTC_MODE0_INTENCLR_PER2_Msk = 0x4
	// Bit PER2.
	RTC_MODE0_INTENCLR_PER2 = 0x4
	// Position of PER3 field.
	RTC_MODE0_INTENCLR_PER3_Pos = 0x3
	// Bit mask of PER3 field.
	RTC_MODE0_INTENCLR_PER3_Msk = 0x8
	// Bit PER3.
	RTC_MODE0_INTENCLR_PER3 = 0x8
	// Position of PER4 field.
	RTC_MODE0_INTENCLR_PER4_Pos = 0x4
	// Bit mask of PER4 field.
	RTC_MODE0_INTENCLR_PER4_Msk = 0x10
	// Bit PER4.
	RTC_MODE0_INTENCLR_PER4 = 0x10
	// Position of PER5 field.
	RTC_MODE0_INTENCLR_PER5_Pos = 0x5
	// Bit mask of PER5 field.
	RTC_MODE0_INTENCLR_PER5_Msk = 0x20
	// Bit PER5.
	RTC_MODE0_INTENCLR_PER5 = 0x20
	// Position of PER6 field.
	RTC_MODE0_INTENCLR_PER6_Pos = 0x6
	// Bit mask of PER6 field.
	RTC_MODE0_INTENCLR_PER6_Msk = 0x40
	// Bit PER6.
	RTC_MODE0_INTENCLR_PER6 = 0x40
	// Position of PER7 field.
	RTC_MODE0_INTENCLR_PER7_Pos = 0x7
	// Bit mask of PER7 field.
	RTC_MODE0_INTENCLR_PER7_Msk = 0x80
	// Bit PER7.
	RTC_MODE0_INTENCLR_PER7 = 0x80
	// Position of CMP0 field.
	RTC_MODE0_INTENCLR_CMP0_Pos = 0x8
	// Bit mask of CMP0 field.
	RTC_MODE0_INTENCLR_CMP0_Msk = 0x100
	// Bit CMP0.
	RTC_MODE0_INTENCLR_CMP0 = 0x100
	// Position of TAMPER field.
	RTC_MODE0_INTENCLR_TAMPER_Pos = 0xe
	// Bit mask of TAMPER field.
	RTC_MODE0_INTENCLR_TAMPER_Msk = 0x4000
	// Bit TAMPER.
	RTC_MODE0_INTENCLR_TAMPER = 0x4000
	// Position of OVF field.
	RTC_MODE0_INTENCLR_OVF_Pos = 0xf
	// Bit mask of OVF field.
	RTC_MODE0_INTENCLR_OVF_Msk = 0x8000
	// Bit OVF.
	RTC_MODE0_INTENCLR_OVF = 0x8000

	// INTENSET: MODE0 Interrupt Enable Set
	// Position of PER0 field.
	RTC_MODE0_INTENSET_PER0_Pos = 0x0
	// Bit mask of PER0 field.
	RTC_MODE0_INTENSET_PER0_Msk = 0x1
	// Bit PER0.
	RTC_MODE0_INTENSET_PER0 = 0x1
	// Position of PER1 field.
	RTC_MODE0_INTENSET_PER1_Pos = 0x1
	// Bit mask of PER1 field.
	RTC_MODE0_INTENSET_PER1_Msk = 0x2
	// Bit PER1.
	RTC_MODE0_INTENSET_PER1 = 0x2
	// Position of PER2 field.
	RTC_MODE0_INTENSET_PER2_Pos = 0x2
	// Bit mask of PER2 field.
	RTC_MODE0_INTENSET_PER2_Msk = 0x4
	// Bit PER2.
	RTC_MODE0_INTENSET_PER2 = 0x4
	// Position of PER3 field.
	RTC_MODE0_INTENSET_PER3_Pos = 0x3
	// Bit mask of PER3 field.
	RTC_MODE0_INTENSET_PER3_Msk = 0x8
	// Bit PER3.
	RTC_MODE0_INTENSET_PER3 = 0x8
	// Position of PER4 field.
	RTC_MODE0_INTENSET_PER4_Pos = 0x4
	// Bit mask of PER4 field.
	RTC_MODE0_INTENSET_PER4_Msk = 0x10
	// Bit PER4.
	RTC_MODE0_INTENSET_PER4 = 0x10
	// Position of PER5 field.
	RTC_MODE0_INTENSET_PER5_Pos = 0x5
	// Bit mask of PER5 field.
	RTC_MODE0_INTENSET_PER5_Msk = 0x20
	// Bit PER5.
	RTC_MODE0_INTENSET_PER5 = 0x20
	// Position of PER6 field.
	RTC_MODE0_INTENSET_PER6_Pos = 0x6
	// Bit mask of PER6 field.
	RTC_MODE0_INTENSET_PER6_Msk = 0x40
	// Bit PER6.
	RTC_MODE0_INTENSET_PER6 = 0x40
	// Position of PER7 field.
	RTC_MODE0_INTENSET_PER7_Pos = 0x7
	// Bit mask of PER7 field.
	RTC_MODE0_INTENSET_PER7_Msk = 0x80
	// Bit PER7.
	RTC_MODE0_INTENSET_PER7 = 0x80
	// Position of CMP0 field.
	RTC_MODE0_INTENSET_CMP0_Pos = 0x8
	// Bit mask of CMP0 field.
	RTC_MODE0_INTENSET_CMP0_Msk = 0x100
	// Bit CMP0.
	RTC_MODE0_INTENSET_CMP0 = 0x100
	// Position of TAMPER field.
	RTC_MODE0_INTENSET_TAMPER_Pos = 0xe
	// Bit mask of TAMPER field.
	RTC_MODE0_INTENSET_TAMPER_Msk = 0x4000
	// Bit TAMPER.
	RTC_MODE0_INTENSET_TAMPER = 0x4000
	// Position of OVF field.
	RTC_MODE0_INTENSET_OVF_Pos = 0xf
	// Bit mask of OVF field.
	RTC_MODE0_INTENSET_OVF_Msk = 0x8000
	// Bit OVF.
	RTC_MODE0_INTENSET_OVF = 0x8000

	// INTFLAG: MODE0 Interrupt Flag Status and Clear
	// Position of PER0 field.
	RTC_MODE0_INTFLAG_PER0_Pos = 0x0
	// Bit mask of PER0 field.
	RTC_MODE0_INTFLAG_PER0_Msk = 0x1
	// Bit PER0.
	RTC_MODE0_INTFLAG_PER0 = 0x1
	// Position of PER1 field.
	RTC_MODE0_INTFLAG_PER1_Pos = 0x1
	// Bit mask of PER1 field.
	RTC_MODE0_INTFLAG_PER1_Msk = 0x2
	// Bit PER1.
	RTC_MODE0_INTFLAG_PER1 = 0x2
	// Position of PER2 field.
	RTC_MODE0_INTFLAG_PER2_Pos = 0x2
	// Bit mask of PER2 field.
	RTC_MODE0_INTFLAG_PER2_Msk = 0x4
	// Bit PER2.
	RTC_MODE0_INTFLAG_PER2 = 0x4
	// Position of PER3 field.
	RTC_MODE0_INTFLAG_PER3_Pos = 0x3
	// Bit mask of PER3 field.
	RTC_MODE0_INTFLAG_PER3_Msk = 0x8
	// Bit PER3.
	RTC_MODE0_INTFLAG_PER3 = 0x8
	// Position of PER4 field.
	RTC_MODE0_INTFLAG_PER4_Pos = 0x4
	// Bit mask of PER4 field.
	RTC_MODE0_INTFLAG_PER4_Msk = 0x10
	// Bit PER4.
	RTC_MODE0_INTFLAG_PER4 = 0x10
	// Position of PER5 field.
	RTC_MODE0_INTFLAG_PER5_Pos = 0x5
	// Bit mask of PER5 field.
	RTC_MODE0_INTFLAG_PER5_Msk = 0x20
	// Bit PER5.
	RTC_MODE0_INTFLAG_PER5 = 0x20
	// Position of PER6 field.
	RTC_MODE0_INTFLAG_PER6_Pos = 0x6
	// Bit mask of PER6 field.
	RTC_MODE0_INTFLAG_PER6_Msk = 0x40
	// Bit PER6.
	RTC_MODE0_INTFLAG_PER6 = 0x40
	// Position of PER7 field.
	RTC_MODE0_INTFLAG_PER7_Pos = 0x7
	// Bit mask of PER7 field.
	RTC_MODE0_INTFLAG_PER7_Msk = 0x80
	// Bit PER7.
	RTC_MODE0_INTFLAG_PER7 = 0x80
	// Position of CMP0 field.
	RTC_MODE0_INTFLAG_CMP0_Pos = 0x8
	// Bit mask of CMP0 field.
	RTC_MODE0_INTFLAG_CMP0_Msk = 0x100
	// Bit CMP0.
	RTC_MODE0_INTFLAG_CMP0 = 0x100
	// Position of TAMPER field.
	RTC_MODE0_INTFLAG_TAMPER_Pos = 0xe
	// Bit mask of TAMPER field.
	RTC_MODE0_INTFLAG_TAMPER_Msk = 0x4000
	// Bit TAMPER.
	RTC_MODE0_INTFLAG_TAMPER = 0x4000
	// Position of OVF field.
	RTC_MODE0_INTFLAG_OVF_Pos = 0xf
	// Bit mask of OVF field.
	RTC_MODE0_INTFLAG_OVF_Msk = 0x8000
	// Bit OVF.
	RTC_MODE0_INTFLAG_OVF = 0x8000

	// DBGCTRL: Debug Control
	// Position of DBGRUN field.
	RTC_MODE0_DBGCTRL_DBGRUN_Pos = 0x0
	// Bit mask of DBGRUN field.
	RTC_MODE0_DBGCTRL_DBGRUN_Msk = 0x1
	// Bit DBGRUN.
	RTC_MODE0_DBGCTRL_DBGRUN = 0x1

	// SYNCBUSY: MODE0 Synchronization Busy Status
	// Position of SWRST field.
	RTC_MODE0_SYNCBUSY_SWRST_Pos = 0x0
	// Bit mask of SWRST field.
	RTC_MODE0_SYNCBUSY_SWRST_Msk = 0x1
	// Bit SWRST.
	RTC_MODE0_SYNCBUSY_SWRST = 0x1
	// Position of ENABLE field.
	RTC_MODE0_SYNCBUSY_ENABLE_Pos = 0x1
	// Bit mask of ENABLE field.
	RTC_MODE0_SYNCBUSY_ENABLE_Msk = 0x2
	// Bit ENABLE.
	RTC_MODE0_SYNCBUSY_ENABLE = 0x2
	// Position of FREQCORR field.
	RTC_MODE0_SYNCBUSY_FREQCORR_Pos = 0x2
	// Bit mask of FREQCORR field.
	RTC_MODE0_SYNCBUSY_FREQCORR_Msk = 0x4
	// Bit FREQCORR.
	RTC_MODE0_SYNCBUSY_FREQCORR = 0x4
	// Position of COUNT field.
	RTC_MODE0_SYNCBUSY_COUNT_Pos = 0x3
	// Bit mask of COUNT field.
	RTC_MODE0_SYNCBUSY_COUNT_Msk = 0x8
	// Bit COUNT.
	RTC_MODE0_SYNCBUSY_COUNT = 0x8
	// Position of COMP0 field.
	RTC_MODE0_SYNCBUSY_COMP0_Pos = 0x5
	// Bit mask of COMP0 field.
	RTC_MODE0_SYNCBUSY_COMP0_Msk = 0x20
	// Bit COMP0.
	RTC_MODE0_SYNCBUSY_COMP0 = 0x20
	// Position of COUNTSYNC field.
	RTC_MODE0_SYNCBUSY_COUNTSYNC_Pos = 0xf
	// Bit mask of COUNTSYNC field.
	RTC_MODE0_SYNCBUSY_COUNTSYNC_Msk = 0x8000
	// Bit COUNTSYNC.
	RTC_MODE0_SYNCBUSY_COUNTSYNC = 0x8000
	// Position of GP0 field.
	RTC_MODE0_SYNCBUSY_GP0_Pos = 0x10
	// Bit mask of GP0 field.
	RTC_MODE0_SYNCBUSY_GP0_Msk = 0x10000
	// Bit GP0.
	RTC_MODE0_SYNCBUSY_GP0 = 0x10000
	// Position of GP1 field.
	RTC_MODE0_SYNCBUSY_GP1_Pos = 0x11
	// Bit mask of GP1 field.
	RTC_MODE0_SYNCBUSY_GP1_Msk = 0x20000
	// Bit GP1.
	RTC_MODE0_SYNCBUSY_GP1 = 0x20000

	// FREQCORR: Frequency Correction
	// Position of VALUE field.
	RTC_MODE0_FREQCORR_VALUE_Pos = 0x0
	// Bit mask of VALUE field.
	RTC_MODE0_FREQCORR_VALUE_Msk = 0x7f
	// Position of SIGN field.
	RTC_MODE0_FREQCORR_SIGN_Pos = 0x7
	// Bit mask of SIGN field.
	RTC_MODE0_FREQCORR_SIGN_Msk = 0x80
	// Bit SIGN.
	RTC_MODE0_FREQCORR_SIGN = 0x80

	// COUNT: MODE0 Counter Value
	// Position of COUNT field.
	RTC_MODE0_COUNT_COUNT_Pos = 0x0
	// Bit mask of COUNT field.
	RTC_MODE0_COUNT_COUNT_Msk = 0xffffffff

	// COMP0: MODE0 Compare n Value
	// Position of COMP field.
	RTC_MODE0_COMP_COMP_Pos = 0x0
	// Bit mask of COMP field.
	RTC_MODE0_COMP_COMP_Msk = 0xffffffff

	// GP0: General Purpose
	// Position of GP field.
	RTC_MODE0_GP_GP_Pos = 0x0
	// Bit mask of GP field.
	RTC_MODE0_GP_GP_Msk = 0xffffffff

	// TAMPCTRL: Tamper Control
	// Position of IN0ACT field.
	RTC_MODE0_TAMPCTRL_IN0ACT_Pos = 0x0
	// Bit mask of IN0ACT field.
	RTC_MODE0_TAMPCTRL_IN0ACT_Msk = 0x3
	// Off (Disabled)
	RTC_MODE0_TAMPCTRL_IN0ACT_OFF = 0x0
	// Wake without timestamp
	RTC_MODE0_TAMPCTRL_IN0ACT_WAKE = 0x1
	// Capture timestamp
	RTC_MODE0_TAMPCTRL_IN0ACT_CAPTURE = 0x2
	// Compare IN0 to OUT
	RTC_MODE0_TAMPCTRL_IN0ACT_ACTL = 0x3
	// Position of IN1ACT field.
	RTC_MODE0_TAMPCTRL_IN1ACT_Pos = 0x2
	// Bit mask of IN1ACT field.
	RTC_MODE0_TAMPCTRL_IN1ACT_Msk = 0xc
	// Off (Disabled)
	RTC_MODE0_TAMPCTRL_IN1ACT_OFF = 0x0
	// Wake without timestamp
	RTC_MODE0_TAMPCTRL_IN1ACT_WAKE = 0x1
	// Capture timestamp
	RTC_MODE0_TAMPCTRL_IN1ACT_CAPTURE = 0x2
	// Compare IN1 to OUT
	RTC_MODE0_TAMPCTRL_IN1ACT_ACTL = 0x3
	// Position of IN2ACT field.
	RTC_MODE0_TAMPCTRL_IN2ACT_Pos = 0x4
	// Bit mask of IN2ACT field.
	RTC_MODE0_TAMPCTRL_IN2ACT_Msk = 0x30
	// Off (Disabled)
	RTC_MODE0_TAMPCTRL_IN2ACT_OFF = 0x0
	// Wake without timestamp
	RTC_MODE0_TAMPCTRL_IN2ACT_WAKE = 0x1
	// Capture timestamp
	RTC_MODE0_TAMPCTRL_IN2ACT_CAPTURE = 0x2
	// Compare IN2 to OUT
	RTC_MODE0_TAMPCTRL_IN2ACT_ACTL = 0x3
	// Position of IN3ACT field.
	RTC_MODE0_TAMPCTRL_IN3ACT_Pos = 0x6
	// Bit mask of IN3ACT field.
	RTC_MODE0_TAMPCTRL_IN3ACT_Msk = 0xc0
	// Off (Disabled)
	RTC_MODE0_TAMPCTRL_IN3ACT_OFF = 0x0
	// Wake without timestamp
	RTC_MODE0_TAMPCTRL_IN3ACT_WAKE = 0x1
	// Capture timestamp
	RTC_MODE0_TAMPCTRL_IN3ACT_CAPTURE = 0x2
	// Compare IN3 to OUT
	RTC_MODE0_TAMPCTRL_IN3ACT_ACTL = 0x3
	// Position of IN4ACT field.
	RTC_MODE0_TAMPCTRL_IN4ACT_Pos = 0x8
	// Bit mask of IN4ACT field.
	RTC_MODE0_TAMPCTRL_IN4ACT_Msk = 0x300
	// Off (Disabled)
	RTC_MODE0_TAMPCTRL_IN4ACT_OFF = 0x0
	// Wake without timestamp
	RTC_MODE0_TAMPCTRL_IN4ACT_WAKE = 0x1
	// Capture timestamp
	RTC_MODE0_TAMPCTRL_IN4ACT_CAPTURE = 0x2
	// Compare IN4 to OUT
	RTC_MODE0_TAMPCTRL_IN4ACT_ACTL = 0x3
	// Position of TAMLVL0 field.
	RTC_MODE0_TAMPCTRL_TAMLVL0_Pos = 0x10
	// Bit mask of TAMLVL0 field.
	RTC_MODE0_TAMPCTRL_TAMLVL0_Msk = 0x10000
	// Bit TAMLVL0.
	RTC_MODE0_TAMPCTRL_TAMLVL0 = 0x10000
	// Position of TAMLVL1 field.
	RTC_MODE0_TAMPCTRL_TAMLVL1_Pos = 0x11
	// Bit mask of TAMLVL1 field.
	RTC_MODE0_TAMPCTRL_TAMLVL1_Msk = 0x20000
	// Bit TAMLVL1.
	RTC_MODE0_TAMPCTRL_TAMLVL1 = 0x20000
	// Position of TAMLVL2 field.
	RTC_MODE0_TAMPCTRL_TAMLVL2_Pos = 0x12
	// Bit mask of TAMLVL2 field.
	RTC_MODE0_TAMPCTRL_TAMLVL2_Msk = 0x40000
	// Bit TAMLVL2.
	RTC_MODE0_TAMPCTRL_TAMLVL2 = 0x40000
	// Position of TAMLVL3 field.
	RTC_MODE0_TAMPCTRL_TAMLVL3_Pos = 0x13
	// Bit mask of TAMLVL3 field.
	RTC_MODE0_TAMPCTRL_TAMLVL3_Msk = 0x80000
	// Bit TAMLVL3.
	RTC_MODE0_TAMPCTRL_TAMLVL3 = 0x80000
	// Position of TAMLVL4 field.
	RTC_MODE0_TAMPCTRL_TAMLVL4_Pos = 0x14
	// Bit mask of TAMLVL4 field.
	RTC_MODE0_TAMPCTRL_TAMLVL4_Msk = 0x100000
	// Bit TAMLVL4.
	RTC_MODE0_TAMPCTRL_TAMLVL4 = 0x100000
	// Position of DEBNC0 field.
	RTC_MODE0_TAMPCTRL_DEBNC0_Pos = 0x18
	// Bit mask of DEBNC0 field.
	RTC_MODE0_TAMPCTRL_DEBNC0_Msk = 0x1000000
	// Bit DEBNC0.
	RTC_MODE0_TAMPCTRL_DEBNC0 = 0x1000000
	// Position of DEBNC1 field.
	RTC_MODE0_TAMPCTRL_DEBNC1_Pos = 0x19
	// Bit mask of DEBNC1 field.
	RTC_MODE0_TAMPCTRL_DEBNC1_Msk = 0x2000000
	// Bit DEBNC1.
	RTC_MODE0_TAMPCTRL_DEBNC1 = 0x2000000
	// Position of DEBNC2 field.
	RTC_MODE0_TAMPCTRL_DEBNC2_Pos = 0x1a
	// Bit mask of DEBNC2 field.
	RTC_MODE0_TAMPCTRL_DEBNC2_Msk = 0x4000000
	// Bit DEBNC2.
	RTC_MODE0_TAMPCTRL_DEBNC2 = 0x4000000
	// Position of DEBNC3 field.
	RTC_MODE0_TAMPCTRL_DEBNC3_Pos = 0x1b
	// Bit mask of DEBNC3 field.
	RTC_MODE0_TAMPCTRL_DEBNC3_Msk = 0x8000000
	// Bit DEBNC3.
	RTC_MODE0_TAMPCTRL_DEBNC3 = 0x8000000
	// Position of DEBNC4 field.
	RTC_MODE0_TAMPCTRL_DEBNC4_Pos = 0x1c
	// Bit mask of DEBNC4 field.
	RTC_MODE0_TAMPCTRL_DEBNC4_Msk = 0x10000000
	// Bit DEBNC4.
	RTC_MODE0_TAMPCTRL_DEBNC4 = 0x10000000

	// TIMESTAMP: MODE0 Timestamp
	// Position of COUNT field.
	RTC_MODE0_TIMESTAMP_COUNT_Pos = 0x0
	// Bit mask of COUNT field.
	RTC_MODE0_TIMESTAMP_COUNT_Msk = 0xffffffff

	// TAMPID: Tamper ID
	// Position of TAMPID0 field.
	RTC_MODE0_TAMPID_TAMPID0_Pos = 0x0
	// Bit mask of TAMPID0 field.
	RTC_MODE0_TAMPID_TAMPID0_Msk = 0x1
	// Bit TAMPID0.
	RTC_MODE0_TAMPID_TAMPID0 = 0x1
	// Position of TAMPID1 field.
	RTC_MODE0_TAMPID_TAMPID1_Pos = 0x1
	// Bit mask of TAMPID1 field.
	RTC_MODE0_TAMPID_TAMPID1_Msk = 0x2
	// Bit TAMPID1.
	RTC_MODE0_TAMPID_TAMPID1 = 0x2
	// Position of TAMPID2 field.
	RTC_MODE0_TAMPID_TAMPID2_Pos = 0x2
	// Bit mask of TAMPID2 field.
	RTC_MODE0_TAMPID_TAMPID2_Msk = 0x4
	// Bit TAMPID2.
	RTC_MODE0_TAMPID_TAMPID2 = 0x4
	// Position of TAMPID3 field.
	RTC_MODE0_TAMPID_TAMPID3_Pos = 0x3
	// Bit mask of TAMPID3 field.
	RTC_MODE0_TAMPID_TAMPID3_Msk = 0x8
	// Bit TAMPID3.
	RTC_MODE0_TAMPID_TAMPID3 = 0x8
	// Position of TAMPID4 field.
	RTC_MODE0_TAMPID_TAMPID4_Pos = 0x4
	// Bit mask of TAMPID4 field.
	RTC_MODE0_TAMPID_TAMPID4_Msk = 0x10
	// Bit TAMPID4.
	RTC_MODE0_TAMPID_TAMPID4 = 0x10
	// Position of TAMPEVT field.
	RTC_MODE0_TAMPID_TAMPEVT_Pos = 0x1f
	// Bit mask of TAMPEVT field.
	RTC_MODE0_TAMPID_TAMPEVT_Msk = 0x80000000
	// Bit TAMPEVT.
	RTC_MODE0_TAMPID_TAMPEVT = 0x80000000

	// BKUP0: Backup
	// Position of BKUP field.
	RTC_MODE0_BKUP_BKUP_Pos = 0x0
	// Bit mask of BKUP field.
	RTC_MODE0_BKUP_BKUP_Msk = 0xffffffff
)

// Constants for RTC_MODE1: Real-Time Counter - MODE1
const (
	// CTRLA: MODE1 Control A
	// Position of SWRST field.
	RTC_MODE1_CTRLA_SWRST_Pos = 0x0
	// Bit mask of SWRST field.
	RTC_MODE1_CTRLA_SWRST_Msk = 0x1
	// Bit SWRST.
	RTC_MODE1_CTRLA_SWRST = 0x1
	// Position of ENABLE field.
	RTC_MODE1_CTRLA_ENABLE_Pos = 0x1
	// Bit mask of ENABLE field.
	RTC_MODE1_CTRLA_ENABLE_Msk = 0x2
	// Bit ENABLE.
	RTC_MODE1_CTRLA_ENABLE = 0x2
	// Position of MODE field.
	RTC_MODE1_CTRLA_MODE_Pos = 0x2
	// Bit mask of MODE field.
	RTC_MODE1_CTRLA_MODE_Msk = 0xc
	// Mode 0: 32-bit Counter
	RTC_MODE1_CTRLA_MODE_COUNT32 = 0x0
	// Mode 1: 16-bit Counter
	RTC_MODE1_CTRLA_MODE_COUNT16 = 0x1
	// Mode 2: Clock/Calendar
	RTC_MODE1_CTRLA_MODE_CLOCK = 0x2
	// Position of PRESCALER field.
	RTC_MODE1_CTRLA_PRESCALER_Pos = 0x8
	// Bit mask of PRESCALER field.
	RTC_MODE1_CTRLA_PRESCALER_Msk = 0xf00
	// CLK_RTC_CNT = GCLK_RTC/1
	RTC_MODE1_CTRLA_PRESCALER_OFF = 0x0
	// CLK_RTC_CNT = GCLK_RTC/1
	RTC_MODE1_CTRLA_PRESCALER_DIV1 = 0x1
	// CLK_RTC_CNT = GCLK_RTC/2
	RTC_MODE1_CTRLA_PRESCALER_DIV2 = 0x2
	// CLK_RTC_CNT = GCLK_RTC/4
	RTC_MODE1_CTRLA_PRESCALER_DIV4 = 0x3
	// CLK_RTC_CNT = GCLK_RTC/8
	RTC_MODE1_CTRLA_PRESCALER_DIV8 = 0x4
	// CLK_RTC_CNT = GCLK_RTC/16
	RTC_MODE1_CTRLA_PRESCALER_DIV16 = 0x5
	// CLK_RTC_CNT = GCLK_RTC/32
	RTC_MODE1_CTRLA_PRESCALER_DIV32 = 0x6
	// CLK_RTC_CNT = GCLK_RTC/64
	RTC_MODE1_CTRLA_PRESCALER_DIV64 = 0x7
	// CLK_RTC_CNT = GCLK_RTC/128
	RTC_MODE1_CTRLA_PRESCALER_DIV128 = 0x8
	// CLK_RTC_CNT = GCLK_RTC/256
	RTC_MODE1_CTRLA_PRESCALER_DIV256 = 0x9
	// CLK_RTC_CNT = GCLK_RTC/512
	RTC_MODE1_CTRLA_PRESCALER_DIV512 = 0xa
	// CLK_RTC_CNT = GCLK_RTC/1024
	RTC_MODE1_CTRLA_PRESCALER_DIV1024 = 0xb
	// Position of BKTRST field.
	RTC_MODE1_CTRLA_BKTRST_Pos = 0xd
	// Bit mask of BKTRST field.
	RTC_MODE1_CTRLA_BKTRST_Msk = 0x2000
	// Bit BKTRST.
	RTC_MODE1_CTRLA_BKTRST = 0x2000
	// Position of GPTRST field.
	RTC_MODE1_CTRLA_GPTRST_Pos = 0xe
	// Bit mask of GPTRST field.
	RTC_MODE1_CTRLA_GPTRST_Msk = 0x4000
	// Bit GPTRST.
	RTC_MODE1_CTRLA_GPTRST = 0x4000
	// Position of COUNTSYNC field.
	RTC_MODE1_CTRLA_COUNTSYNC_Pos = 0xf
	// Bit mask of COUNTSYNC field.
	RTC_MODE1_CTRLA_COUNTSYNC_Msk = 0x8000
	// Bit COUNTSYNC.
	RTC_MODE1_CTRLA_COUNTSYNC = 0x8000

	// CTRLB: MODE1 Control B
	// Position of GP0EN field.
	RTC_MODE1_CTRLB_GP0EN_Pos = 0x0
	// Bit mask of GP0EN field.
	RTC_MODE1_CTRLB_GP0EN_Msk = 0x1
	// Bit GP0EN.
	RTC_MODE1_CTRLB_GP0EN = 0x1
	// Position of DEBMAJ field.
	RTC_MODE1_CTRLB_DEBMAJ_Pos = 0x4
	// Bit mask of DEBMAJ field.
	RTC_MODE1_CTRLB_DEBMAJ_Msk = 0x10
	// Bit DEBMAJ.
	RTC_MODE1_CTRLB_DEBMAJ = 0x10
	// Position of DEBASYNC field.
	RTC_MODE1_CTRLB_DEBASYNC_Pos = 0x5
	// Bit mask of DEBASYNC field.
	RTC_MODE1_CTRLB_DEBASYNC_Msk = 0x20
	// Bit DEBASYNC.
	RTC_MODE1_CTRLB_DEBASYNC = 0x20
	// Position of RTCOUT field.
	RTC_MODE1_CTRLB_RTCOUT_Pos = 0x6
	// Bit mask of RTCOUT field.
	RTC_MODE1_CTRLB_RTCOUT_Msk = 0x40
	// Bit RTCOUT.
	RTC_MODE1_CTRLB_RTCOUT = 0x40
	// Position of DMAEN field.
	RTC_MODE1_CTRLB_DMAEN_Pos = 0x7
	// Bit mask of DMAEN field.
	RTC_MODE1_CTRLB_DMAEN_Msk = 0x80
	// Bit DMAEN.
	RTC_MODE1_CTRLB_DMAEN = 0x80
	// Position of DEBF field.
	RTC_MODE1_CTRLB_DEBF_Pos = 0x8
	// Bit mask of DEBF field.
	RTC_MODE1_CTRLB_DEBF_Msk = 0x700
	// CLK_RTC_DEB = CLK_RTC/2
	RTC_MODE1_CTRLB_DEBF_DIV2 = 0x0
	// CLK_RTC_DEB = CLK_RTC/4
	RTC_MODE1_CTRLB_DEBF_DIV4 = 0x1
	// CLK_RTC_DEB = CLK_RTC/8
	RTC_MODE1_CTRLB_DEBF_DIV8 = 0x2
	// CLK_RTC_DEB = CLK_RTC/16
	RTC_MODE1_CTRLB_DEBF_DIV16 = 0x3
	// CLK_RTC_DEB = CLK_RTC/32
	RTC_MODE1_CTRLB_DEBF_DIV32 = 0x4
	// CLK_RTC_DEB = CLK_RTC/64
	RTC_MODE1_CTRLB_DEBF_DIV64 = 0x5
	// CLK_RTC_DEB = CLK_RTC/128
	RTC_MODE1_CTRLB_DEBF_DIV128 = 0x6
	// CLK_RTC_DEB = CLK_RTC/256
	RTC_MODE1_CTRLB_DEBF_DIV256 = 0x7
	// Position of ACTF field.
	RTC_MODE1_CTRLB_ACTF_Pos = 0xc
	// Bit mask of ACTF field.
	RTC_MODE1_CTRLB_ACTF_Msk = 0x7000
	// CLK_RTC_OUT = CLK_RTC/2
	RTC_MODE1_CTRLB_ACTF_DIV2 = 0x0
	// CLK_RTC_OUT = CLK_RTC/4
	RTC_MODE1_CTRLB_ACTF_DIV4 = 0x1
	// CLK_RTC_OUT = CLK_RTC/8
	RTC_MODE1_CTRLB_ACTF_DIV8 = 0x2
	// CLK_RTC_OUT = CLK_RTC/16
	RTC_MODE1_CTRLB_ACTF_DIV16 = 0x3
	// CLK_RTC_OUT = CLK_RTC/32
	RTC_MODE1_CTRLB_ACTF_DIV32 = 0x4
	// CLK_RTC_OUT = CLK_RTC/64
	RTC_MODE1_CTRLB_ACTF_DIV64 = 0x5
	// CLK_RTC_OUT = CLK_RTC/128
	RTC_MODE1_CTRLB_ACTF_DIV128 = 0x6
	// CLK_RTC_OUT = CLK_RTC/256
	RTC_MODE1_CTRLB_ACTF_DIV256 = 0x7

	// EVCTRL: MODE1 Event Control
	// Position of PEREO0 field.
	RTC_MODE1_EVCTRL_PEREO0_Pos = 0x0
	// Bit mask of PEREO0 field.
	RTC_MODE1_EVCTRL_PEREO0_Msk = 0x1
	// Bit PEREO0.
	RTC_MODE1_EVCTRL_PEREO0 = 0x1
	// Position of PEREO1 field.
	RTC_MODE1_EVCTRL_PEREO1_Pos = 0x1
	// Bit mask of PEREO1 field.
	RTC_MODE1_EVCTRL_PEREO1_Msk = 0x2
	// Bit PEREO1.
	RTC_MODE1_EVCTRL_PEREO1 = 0x2
	// Position of PEREO2 field.
	RTC_MODE1_EVCTRL_PEREO2_Pos = 0x2
	// Bit mask of PEREO2 field.
	RTC_MODE1_EVCTRL_PEREO2_Msk = 0x4
	// Bit PEREO2.
	RTC_MODE1_EVCTRL_PEREO2 = 0x4
	// Position of PEREO3 field.
	RTC_MODE1_EVCTRL_PEREO3_Pos = 0x3
	// Bit mask of PEREO3 field.
	RTC_MODE1_EVCTRL_PEREO3_Msk = 0x8
	// Bit PEREO3.
	RTC_MODE1_EVCTRL_PEREO3 = 0x8
	// Position of PEREO4 field.
	RTC_MODE1_EVCTRL_PEREO4_Pos = 0x4
	// Bit mask of PEREO4 field.
	RTC_MODE1_EVCTRL_PEREO4_Msk = 0x10
	// Bit PEREO4.
	RTC_MODE1_EVCTRL_PEREO4 = 0x10
	// Position of PEREO5 field.
	RTC_MODE1_EVCTRL_PEREO5_Pos = 0x5
	// Bit mask of PEREO5 field.
	RTC_MODE1_EVCTRL_PEREO5_Msk = 0x20
	// Bit PEREO5.
	RTC_MODE1_EVCTRL_PEREO5 = 0x20
	// Position of PEREO6 field.
	RTC_MODE1_EVCTRL_PEREO6_Pos = 0x6
	// Bit mask of PEREO6 field.
	RTC_MODE1_EVCTRL_PEREO6_Msk = 0x40
	// Bit PEREO6.
	RTC_MODE1_EVCTRL_PEREO6 = 0x40
	// Position of PEREO7 field.
	RTC_MODE1_EVCTRL_PEREO7_Pos = 0x7
	// Bit mask of PEREO7 field.
	RTC_MODE1_EVCTRL_PEREO7_Msk = 0x80
	// Bit PEREO7.
	RTC_MODE1_EVCTRL_PEREO7 = 0x80
	// Position of CMPEO0 field.
	RTC_MODE1_EVCTRL_CMPEO0_Pos = 0x8
	// Bit mask of CMPEO0 field.
	RTC_MODE1_EVCTRL_CMPEO0_Msk = 0x100
	// Bit CMPEO0.
	RTC_MODE1_EVCTRL_CMPEO0 = 0x100
	// Position of CMPEO1 field.
	RTC_MODE1_EVCTRL_CMPEO1_Pos = 0x9
	// Bit mask of CMPEO1 field.
	RTC_MODE1_EVCTRL_CMPEO1_Msk = 0x200
	// Bit CMPEO1.
	RTC_MODE1_EVCTRL_CMPEO1 = 0x200
	// Position of TAMPEREO field.
	RTC_MODE1_EVCTRL_TAMPEREO_Pos = 0xe
	// Bit mask of TAMPEREO field.
	RTC_MODE1_EVCTRL_TAMPEREO_Msk = 0x4000
	// Bit TAMPEREO.
	RTC_MODE1_EVCTRL_TAMPEREO = 0x4000
	// Position of OVFEO field.
	RTC_MODE1_EVCTRL_OVFEO_Pos = 0xf
	// Bit mask of OVFEO field.
	RTC_MODE1_EVCTRL_OVFEO_Msk = 0x8000
	// Bit OVFEO.
	RTC_MODE1_EVCTRL_OVFEO = 0x8000
	// Position of TAMPEVEI field.
	RTC_MODE1_EVCTRL_TAMPEVEI_Pos = 0x10
	// Bit mask of TAMPEVEI field.
	RTC_MODE1_EVCTRL_TAMPEVEI_Msk = 0x10000
	// Bit TAMPEVEI.
	RTC_MODE1_EVCTRL_TAMPEVEI = 0x10000

	// INTENCLR: MODE1 Interrupt Enable Clear
	// Position of PER0 field.
	RTC_MODE1_INTENCLR_PER0_Pos = 0x0
	// Bit mask of PER0 field.
	RTC_MODE1_INTENCLR_PER0_Msk = 0x1
	// Bit PER0.
	RTC_MODE1_INTENCLR_PER0 = 0x1
	// Position of PER1 field.
	RTC_MODE1_INTENCLR_PER1_Pos = 0x1
	// Bit mask of PER1 field.
	RTC_MODE1_INTENCLR_PER1_Msk = 0x2
	// Bit PER1.
	RTC_MODE1_INTENCLR_PER1 = 0x2
	// Position of PER2 field.
	RTC_MODE1_INTENCLR_PER2_Pos = 0x2
	// Bit mask of PER2 field.
	RTC_MODE1_INTENCLR_PER2_Msk = 0x4
	// Bit PER2.
	RTC_MODE1_INTENCLR_PER2 = 0x4
	// Position of PER3 field.
	RTC_MODE1_INTENCLR_PER3_Pos = 0x3
	// Bit mask of PER3 field.
	RTC_MODE1_INTENCLR_PER3_Msk = 0x8
	// Bit PER3.
	RTC_MODE1_INTENCLR_PER3 = 0x8
	// Position of PER4 field.
	RTC_MODE1_INTENCLR_PER4_Pos = 0x4
	// Bit mask of PER4 field.
	RTC_MODE1_INTENCLR_PER4_Msk = 0x10
	// Bit PER4.
	RTC_MODE1_INTENCLR_PER4 = 0x10
	// Position of PER5 field.
	RTC_MODE1_INTENCLR_PER5_Pos = 0x5
	// Bit mask of PER5 field.
	RTC_MODE1_INTENCLR_PER5_Msk = 0x20
	// Bit PER5.
	RTC_MODE1_INTENCLR_PER5 = 0x20
	// Position of PER6 field.
	RTC_MODE1_INTENCLR_PER6_Pos = 0x6
	// Bit mask of PER6 field.
	RTC_MODE1_INTENCLR_PER6_Msk = 0x40
	// Bit PER6.
	RTC_MODE1_INTENCLR_PER6 = 0x40
	// Position of PER7 field.
	RTC_MODE1_INTENCLR_PER7_Pos = 0x7
	// Bit mask of PER7 field.
	RTC_MODE1_INTENCLR_PER7_Msk = 0x80
	// Bit PER7.
	RTC_MODE1_INTENCLR_PER7 = 0x80
	// Position of CMP0 field.
	RTC_MODE1_INTENCLR_CMP0_Pos = 0x8
	// Bit mask of CMP0 field.
	RTC_MODE1_INTENCLR_CMP0_Msk = 0x100
	// Bit CMP0.
	RTC_MODE1_INTENCLR_CMP0 = 0x100
	// Position of CMP1 field.
	RTC_MODE1_INTENCLR_CMP1_Pos = 0x9
	// Bit mask of CMP1 field.
	RTC_MODE1_INTENCLR_CMP1_Msk = 0x200
	// Bit CMP1.
	RTC_MODE1_INTENCLR_CMP1 = 0x200
	// Position of TAMPER field.
	RTC_MODE1_INTENCLR_TAMPER_Pos = 0xe
	// Bit mask of TAMPER field.
	RTC_MODE1_INTENCLR_TAMPER_Msk = 0x4000
	// Bit TAMPER.
	RTC_MODE1_INTENCLR_TAMPER = 0x4000
	// Position of OVF field.
	RTC_MODE1_INTENCLR_OVF_Pos = 0xf
	// Bit mask of OVF field.
	RTC_MODE1_INTENCLR_OVF_Msk = 0x8000
	// Bit OVF.
	RTC_MODE1_INTENCLR_OVF = 0x8000

	// INTENSET: MODE1 Interrupt Enable Set
	// Position of PER0 field.
	RTC_MODE1_INTENSET_PER0_Pos = 0x0
	// Bit mask of PER0 field.
	RTC_MODE1_INTENSET_PER0_Msk = 0x1
	// Bit PER0.
	RTC_MODE1_INTENSET_PER0 = 0x1
	// Position of PER1 field.
	RTC_MODE1_INTENSET_PER1_Pos = 0x1
	// Bit mask of PER1 field.
	RTC_MODE1_INTENSET_PER1_Msk = 0x2
	// Bit PER1.
	RTC_MODE1_INTENSET_PER1 = 0x2
	// Position of PER2 field.
	RTC_MODE1_INTENSET_PER2_Pos = 0x2
	// Bit mask of PER2 field.
	RTC_MODE1_INTENSET_PER2_Msk = 0x4
	// Bit PER2.
	RTC_MODE1_INTENSET_PER2 = 0x4
	// Position of PER3 field.
	RTC_MODE1_INTENSET_PER3_Pos = 0x3
	// Bit mask of PER3 field.
	RTC_MODE1_INTENSET_PER3_Msk = 0x8
	// Bit PER3.
	RTC_MODE1_INTENSET_PER3 = 0x8
	// Position of PER4 field.
	RTC_MODE1_INTENSET_PER4_Pos = 0x4
	// Bit mask of PER4 field.
	RTC_MODE1_INTENSET_PER4_Msk = 0x10
	// Bit PER4.
	RTC_MODE1_INTENSET_PER4 = 0x10
	// Position of PER5 field.
	RTC_MODE1_INTENSET_PER5_Pos = 0x5
	// Bit mask of PER5 field.
	RTC_MODE1_INTENSET_PER5_Msk = 0x20
	// Bit PER5.
	RTC_MODE1_INTENSET_PER5 = 0x20
	// Position of PER6 field.
	RTC_MODE1_INTENSET_PER6_Pos = 0x6
	// Bit mask of PER6 field.
	RTC_MODE1_INTENSET_PER6_Msk = 0x40
	// Bit PER6.
	RTC_MODE1_INTENSET_PER6 = 0x40
	// Position of PER7 field.
	RTC_MODE1_INTENSET_PER7_Pos = 0x7
	// Bit mask of PER7 field.
	RTC_MODE1_INTENSET_PER7_Msk = 0x80
	// Bit PER7.
	RTC_MODE1_INTENSET_PER7 = 0x80
	// Position of CMP0 field.
	RTC_MODE1_INTENSET_CMP0_Pos = 0x8
	// Bit mask of CMP0 field.
	RTC_MODE1_INTENSET_CMP0_Msk = 0x100
	// Bit CMP0.
	RTC_MODE1_INTENSET_CMP0 = 0x100
	// Position of CMP1 field.
	RTC_MODE1_INTENSET_CMP1_Pos = 0x9
	// Bit mask of CMP1 field.
	RTC_MODE1_INTENSET_CMP1_Msk = 0x200
	// Bit CMP1.
	RTC_MODE1_INTENSET_CMP1 = 0x200
	// Position of TAMPER field.
	RTC_MODE1_INTENSET_TAMPER_Pos = 0xe
	// Bit mask of TAMPER field.
	RTC_MODE1_INTENSET_TAMPER_Msk = 0x4000
	// Bit TAMPER.
	RTC_MODE1_INTENSET_TAMPER = 0x4000
	// Position of OVF field.
	RTC_MODE1_INTENSET_OVF_Pos = 0xf
	// Bit mask of OVF field.
	RTC_MODE1_INTENSET_OVF_Msk = 0x8000
	// Bit OVF.
	RTC_MODE1_INTENSET_OVF = 0x8000

	// INTFLAG: MODE1 Interrupt Flag Status and Clear
	// Position of PER0 field.
	RTC_MODE1_INTFLAG_PER0_Pos = 0x0
	// Bit mask of PER0 field.
	RTC_MODE1_INTFLAG_PER0_Msk = 0x1
	// Bit PER0.
	RTC_MODE1_INTFLAG_PER0 = 0x1
	// Position of PER1 field.
	RTC_MODE1_INTFLAG_PER1_Pos = 0x1
	// Bit mask of PER1 field.
	RTC_MODE1_INTFLAG_PER1_Msk = 0x2
	// Bit PER1.
	RTC_MODE1_INTFLAG_PER1 = 0x2
	// Position of PER2 field.
	RTC_MODE1_INTFLAG_PER2_Pos = 0x2
	// Bit mask of PER2 field.
	RTC_MODE1_INTFLAG_PER2_Msk = 0x4
	// Bit PER2.
	RTC_MODE1_INTFLAG_PER2 = 0x4
	// Position of PER3 field.
	RTC_MODE1_INTFLAG_PER3_Pos = 0x3
	// Bit mask of PER3 field.
	RTC_MODE1_INTFLAG_PER3_Msk = 0x8
	// Bit PER3.
	RTC_MODE1_INTFLAG_PER3 = 0x8
	// Position of PER4 field.
	RTC_MODE1_INTFLAG_PER4_Pos = 0x4
	// Bit mask of PER4 field.
	RTC_MODE1_INTFLAG_PER4_Msk = 0x10
	// Bit PER4.
	RTC_MODE1_INTFLAG_PER4 = 0x10
	// Position of PER5 field.
	RTC_MODE1_INTFLAG_PER5_Pos = 0x5
	// Bit mask of PER5 field.
	RTC_MODE1_INTFLAG_PER5_Msk = 0x20
	// Bit PER5.
	RTC_MODE1_INTFLAG_PER5 = 0x20
	// Position of PER6 field.
	RTC_MODE1_INTFLAG_PER6_Pos = 0x6
	// Bit mask of PER6 field.
	RTC_MODE1_INTFLAG_PER6_Msk = 0x40
	// Bit PER6.
	RTC_MODE1_INTFLAG_PER6 = 0x40
	// Position of PER7 field.
	RTC_MODE1_INTFLAG_PER7_Pos = 0x7
	// Bit mask of PER7 field.
	RTC_MODE1_INTFLAG_PER7_Msk = 0x80
	// Bit PER7.
	RTC_MODE1_INTFLAG_PER7 = 0x80
	// Position of CMP0 field.
	RTC_MODE1_INTFLAG_CMP0_Pos = 0x8
	// Bit mask of CMP0 field.
	RTC_MODE1_INTFLAG_CMP0_Msk = 0x100
	// Bit CMP0.
	RTC_MODE1_INTFLAG_CMP0 = 0x100
	// Position of CMP1 field.
	RTC_MODE1_INTFLAG_CMP1_Pos = 0x9
	// Bit mask of CMP1 field.
	RTC_MODE1_INTFLAG_CMP1_Msk = 0x200
	// Bit CMP1.
	RTC_MODE1_INTFLAG_CMP1 = 0x200
	// Position of TAMPER field.
	RTC_MODE1_INTFLAG_TAMPER_Pos = 0xe
	// Bit mask of TAMPER field.
	RTC_MODE1_INTFLAG_TAMPER_Msk = 0x4000
	// Bit TAMPER.
	RTC_MODE1_INTFLAG_TAMPER = 0x4000
	// Position of OVF field.
	RTC_MODE1_INTFLAG_OVF_Pos = 0xf
	// Bit mask of OVF field.
	RTC_MODE1_INTFLAG_OVF_Msk = 0x8000
	// Bit OVF.
	RTC_MODE1_INTFLAG_OVF = 0x8000

	// DBGCTRL: Debug Control
	// Position of DBGRUN field.
	RTC_MODE1_DBGCTRL_DBGRUN_Pos = 0x0
	// Bit mask of DBGRUN field.
	RTC_MODE1_DBGCTRL_DBGRUN_Msk = 0x1
	// Bit DBGRUN.
	RTC_MODE1_DBGCTRL_DBGRUN = 0x1

	// SYNCBUSY: MODE1 Synchronization Busy Status
	// Position of SWRST field.
	RTC_MODE1_SYNCBUSY_SWRST_Pos = 0x0
	// Bit mask of SWRST field.
	RTC_MODE1_SYNCBUSY_SWRST_Msk = 0x1
	// Bit SWRST.
	RTC_MODE1_SYNCBUSY_SWRST = 0x1
	// Position of ENABLE field.
	RTC_MODE1_SYNCBUSY_ENABLE_Pos = 0x1
	// Bit mask of ENABLE field.
	RTC_MODE1_SYNCBUSY_ENABLE_Msk = 0x2
	// Bit ENABLE.
	RTC_MODE1_SYNCBUSY_ENABLE = 0x2
	// Position of FREQCORR field.
	RTC_MODE1_SYNCBUSY_FREQCORR_Pos = 0x2
	// Bit mask of FREQCORR field.
	RTC_MODE1_SYNCBUSY_FREQCORR_Msk = 0x4
	// Bit FREQCORR.
	RTC_MODE1_SYNCBUSY_FREQCORR = 0x4
	// Position of COUNT field.
	RTC_MODE1_SYNCBUSY_COUNT_Pos = 0x3
	// Bit mask of COUNT field.
	RTC_MODE1_SYNCBUSY_COUNT_Msk = 0x8
	// Bit COUNT.
	RTC_MODE1_SYNCBUSY_COUNT = 0x8
	// Position of PER field.
	RTC_MODE1_SYNCBUSY_PER_Pos = 0x4
	// Bit mask of PER field.
	RTC_MODE1_SYNCBUSY_PER_Msk = 0x10
	// Bit PER.
	RTC_MODE1_SYNCBUSY_PER = 0x10
	// Position of COMP0 field.
	RTC_MODE1_SYNCBUSY_COMP0_Pos = 0x5
	// Bit mask of COMP0 field.
	RTC_MODE1_SYNCBUSY_COMP0_Msk = 0x20
	// Bit COMP0.
	RTC_MODE1_SYNCBUSY_COMP0 = 0x20
	// Position of COMP1 field.
	RTC_MODE1_SYNCBUSY_COMP1_Pos = 0x6
	// Bit mask of COMP1 field.
	RTC_MODE1_SYNCBUSY_COMP1_Msk = 0x40
	// Bit COMP1.
	RTC_MODE1_SYNCBUSY_COMP1 = 0x40
	// Position of COUNTSYNC field.
	RTC_MODE1_SYNCBUSY_COUNTSYNC_Pos = 0xf
	// Bit mask of COUNTSYNC field.
	RTC_MODE1_SYNCBUSY_COUNTSYNC_Msk = 0x8000
	// Bit COUNTSYNC.
	RTC_MODE1_SYNCBUSY_COUNTSYNC = 0x8000
	// Position of GP0 field.
	RTC_MODE1_SYNCBUSY_GP0_Pos = 0x10
	// Bit mask of GP0 field.
	RTC_MODE1_SYNCBUSY_GP0_Msk = 0x10000
	// Bit GP0.
	RTC_MODE1_SYNCBUSY_GP0 = 0x10000
	// Position of GP1 field.
	RTC_MODE1_SYNCBUSY_GP1_Pos = 0x11
	// Bit mask of GP1 field.
	RTC_MODE1_SYNCBUSY_GP1_Msk = 0x20000
	// Bit GP1.
	RTC_MODE1_SYNCBUSY_GP1 = 0x20000

	// FREQCORR: Frequency Correction
	// Position of VALUE field.
	RTC_MODE1_FREQCORR_VALUE_Pos = 0x0
	// Bit mask of VALUE field.
	RTC_MODE1_FREQCORR_VALUE_Msk = 0x7f
	// Position of SIGN field.
	RTC_MODE1_FREQCORR_SIGN_Pos = 0x7
	// Bit mask of SIGN field.
	RTC_MODE1_FREQCORR_SIGN_Msk = 0x80
	// Bit SIGN.
	RTC_MODE1_FREQCORR_SIGN = 0x80

	// COUNT: MODE1 Counter Value
	// Position of COUNT field.
	RTC_MODE1_COUNT_COUNT_Pos = 0x0
	// Bit mask of COUNT field.
	RTC_MODE1_COUNT_COUNT_Msk = 0xffff

	// PER: MODE1 Counter Period
	// Position of PER field.
	RTC_MODE1_PER_PER_Pos = 0x0
	// Bit mask of PER field.
	RTC_MODE1_PER_PER_Msk = 0xffff

	// COMP0: MODE1 Compare n Value
	// Position of COMP field.
	RTC_MODE1_COMP_COMP_Pos = 0x0
	// Bit mask of COMP field.
	RTC_MODE1_COMP_COMP_Msk = 0xffff

	// GP0: General Purpose
	// Position of GP field.
	RTC_MODE1_GP_GP_Pos = 0x0
	// Bit mask of GP field.
	RTC_MODE1_GP_GP_Msk = 0xffffffff

	// TAMPCTRL: Tamper Control
	// Position of IN0ACT field.
	RTC_MODE1_TAMPCTRL_IN0ACT_Pos = 0x0
	// Bit mask of IN0ACT field.
	RTC_MODE1_TAMPCTRL_IN0ACT_Msk = 0x3
	// Off (Disabled)
	RTC_MODE1_TAMPCTRL_IN0ACT_OFF = 0x0
	// Wake without timestamp
	RTC_MODE1_TAMPCTRL_IN0ACT_WAKE = 0x1
	// Capture timestamp
	RTC_MODE1_TAMPCTRL_IN0ACT_CAPTURE = 0x2
	// Compare IN0 to OUT
	RTC_MODE1_TAMPCTRL_IN0ACT_ACTL = 0x3
	// Position of IN1ACT field.
	RTC_MODE1_TAMPCTRL_IN1ACT_Pos = 0x2
	// Bit mask of IN1ACT field.
	RTC_MODE1_TAMPCTRL_IN1ACT_Msk = 0xc
	// Off (Disabled)
	RTC_MODE1_TAMPCTRL_IN1ACT_OFF = 0x0
	// Wake without timestamp
	RTC_MODE1_TAMPCTRL_IN1ACT_WAKE = 0x1
	// Capture timestamp
	RTC_MODE1_TAMPCTRL_IN1ACT_CAPTURE = 0x2
	// Compare IN1 to OUT
	RTC_MODE1_TAMPCTRL_IN1ACT_ACTL = 0x3
	// Position of IN2ACT field.
	RTC_MODE1_TAMPCTRL_IN2ACT_Pos = 0x4
	// Bit mask of IN2ACT field.
	RTC_MODE1_TAMPCTRL_IN2ACT_Msk = 0x30
	// Off (Disabled)
	RTC_MODE1_TAMPCTRL_IN2ACT_OFF = 0x0
	// Wake without timestamp
	RTC_MODE1_TAMPCTRL_IN2ACT_WAKE = 0x1
	// Capture timestamp
	RTC_MODE1_TAMPCTRL_IN2ACT_CAPTURE = 0x2
	// Compare IN2 to OUT
	RTC_MODE1_TAMPCTRL_IN2ACT_ACTL = 0x3
	// Position of IN3ACT field.
	RTC_MODE1_TAMPCTRL_IN3ACT_Pos = 0x6
	// Bit mask of IN3ACT field.
	RTC_MODE1_TAMPCTRL_IN3ACT_Msk = 0xc0
	// Off (Disabled)
	RTC_MODE1_TAMPCTRL_IN3ACT_OFF = 0x0
	// Wake without timestamp
	RTC_MODE1_TAMPCTRL_IN3ACT_WAKE = 0x1
	// Capture timestamp
	RTC_MODE1_TAMPCTRL_IN3ACT_CAPTURE = 0x2
	// Compare IN3 to OUT
	RTC_MODE1_TAMPCTRL_IN3ACT_ACTL = 0x3
	// Position of IN4ACT field.
	RTC_MODE1_TAMPCTRL_IN4ACT_Pos = 0x8
	// Bit mask of IN4ACT field.
	RTC_MODE1_TAMPCTRL_IN4ACT_Msk = 0x300
	// Off (Disabled)
	RTC_MODE1_TAMPCTRL_IN4ACT_OFF = 0x0
	// Wake without timestamp
	RTC_MODE1_TAMPCTRL_IN4ACT_WAKE = 0x1
	// Capture timestamp
	RTC_MODE1_TAMPCTRL_IN4ACT_CAPTURE = 0x2
	// Compare IN4 to OUT
	RTC_MODE1_TAMPCTRL_IN4ACT_ACTL = 0x3
	// Position of TAMLVL0 field.
	RTC_MODE1_TAMPCTRL_TAMLVL0_Pos = 0x10
	// Bit mask of TAMLVL0 field.
	RTC_MODE1_TAMPCTRL_TAMLVL0_Msk = 0x10000
	// Bit TAMLVL0.
	RTC_MODE1_TAMPCTRL_TAMLVL0 = 0x10000
	// Position of TAMLVL1 field.
	RTC_MODE1_TAMPCTRL_TAMLVL1_Pos = 0x11
	// Bit mask of TAMLVL1 field.
	RTC_MODE1_TAMPCTRL_TAMLVL1_Msk = 0x20000
	// Bit TAMLVL1.
	RTC_MODE1_TAMPCTRL_TAMLVL1 = 0x20000
	// Position of TAMLVL2 field.
	RTC_MODE1_TAMPCTRL_TAMLVL2_Pos = 0x12
	// Bit mask of TAMLVL2 field.
	RTC_MODE1_TAMPCTRL_TAMLVL2_Msk = 0x40000
	// Bit TAMLVL2.
	RTC_MODE1_TAMPCTRL_TAMLVL2 = 0x40000
	// Position of TAMLVL3 field.
	RTC_MODE1_TAMPCTRL_TAMLVL3_Pos = 0x13
	// Bit mask of TAMLVL3 field.
	RTC_MODE1_TAMPCTRL_TAMLVL3_Msk = 0x80000
	// Bit TAMLVL3.
	RTC_MODE1_TAMPCTRL_TAMLVL3 = 0x80000
	// Position of TAMLVL4 field.
	RTC_MODE1_TAMPCTRL_TAMLVL4_Pos = 0x14
	// Bit mask of TAMLVL4 field.
	RTC_MODE1_TAMPCTRL_TAMLVL4_Msk = 0x100000
	// Bit TAMLVL4.
	RTC_MODE1_TAMPCTRL_TAMLVL4 = 0x100000
	// Position of DEBNC0 field.
	RTC_MODE1_TAMPCTRL_DEBNC0_Pos = 0x18
	// Bit mask of DEBNC0 field.
	RTC_MODE1_TAMPCTRL_DEBNC0_Msk = 0x1000000
	// Bit DEBNC0.
	RTC_MODE1_TAMPCTRL_DEBNC0 = 0x1000000
	// Position of DEBNC1 field.
	RTC_MODE1_TAMPCTRL_DEBNC1_Pos = 0x19
	// Bit mask of DEBNC1 field.
	RTC_MODE1_TAMPCTRL_DEBNC1_Msk = 0x2000000
	// Bit DEBNC1.
	RTC_MODE1_TAMPCTRL_DEBNC1 = 0x2000000
	// Position of DEBNC2 field.
	RTC_MODE1_TAMPCTRL_DEBNC2_Pos = 0x1a
	// Bit mask of DEBNC2 field.
	RTC_MODE1_TAMPCTRL_DEBNC2_Msk = 0x4000000
	// Bit DEBNC2.
	RTC_MODE1_TAMPCTRL_DEBNC2 = 0x4000000
	// Position of DEBNC3 field.
	RTC_MODE1_TAMPCTRL_DEBNC3_Pos = 0x1b
	// Bit mask of DEBNC3 field.
	RTC_MODE1_TAMPCTRL_DEBNC3_Msk = 0x8000000
	// Bit DEBNC3.
	RTC_MODE1_TAMPCTRL_DEBNC3 = 0x8000000
	// Position of DEBNC4 field.
	RTC_MODE1_TAMPCTRL_DEBNC4_Pos = 0x1c
	// Bit mask of DEBNC4 field.
	RTC_MODE1_TAMPCTRL_DEBNC4_Msk = 0x10000000
	// Bit DEBNC4.
	RTC_MODE1_TAMPCTRL_DEBNC4 = 0x10000000

	// TIMESTAMP: MODE1 Timestamp
	// Position of COUNT field.
	RTC_MODE1_TIMESTAMP_COUNT_Pos = 0x0
	// Bit mask of COUNT field.
	RTC_MODE1_TIMESTAMP_COUNT_Msk = 0xffff

	// TAMPID: Tamper ID
	// Position of TAMPID0 field.
	RTC_MODE1_TAMPID_TAMPID0_Pos = 0x0
	// Bit mask of TAMPID0 field.
	RTC_MODE1_TAMPID_TAMPID0_Msk = 0x1
	// Bit TAMPID0.
	RTC_MODE1_TAMPID_TAMPID0 = 0x1
	// Position of TAMPID1 field.
	RTC_MODE1_TAMPID_TAMPID1_Pos = 0x1
	// Bit mask of TAMPID1 field.
	RTC_MODE1_TAMPID_TAMPID1_Msk = 0x2
	// Bit TAMPID1.
	RTC_MODE1_TAMPID_TAMPID1 = 0x2
	// Position of TAMPID2 field.
	RTC_MODE1_TAMPID_TAMPID2_Pos = 0x2
	// Bit mask of TAMPID2 field.
	RTC_MODE1_TAMPID_TAMPID2_Msk = 0x4
	// Bit TAMPID2.
	RTC_MODE1_TAMPID_TAMPID2 = 0x4
	// Position of TAMPID3 field.
	RTC_MODE1_TAMPID_TAMPID3_Pos = 0x3
	// Bit mask of TAMPID3 field.
	RTC_MODE1_TAMPID_TAMPID3_Msk = 0x8
	// Bit TAMPID3.
	RTC_MODE1_TAMPID_TAMPID3 = 0x8
	// Position of TAMPID4 field.
	RTC_MODE1_TAMPID_TAMPID4_Pos = 0x4
	// Bit mask of TAMPID4 field.
	RTC_MODE1_TAMPID_TAMPID4_Msk = 0x10
	// Bit TAMPID4.
	RTC_MODE1_TAMPID_TAMPID4 = 0x10
	// Position of TAMPEVT field.
	RTC_MODE1_TAMPID_TAMPEVT_Pos = 0x1f
	// Bit mask of TAMPEVT field.
	RTC_MODE1_TAMPID_TAMPEVT_Msk = 0x80000000
	// Bit TAMPEVT.
	RTC_MODE1_TAMPID_TAMPEVT = 0x80000000

	// BKUP0: Backup
	// Position of BKUP field.
	RTC_MODE1_BKUP_BKUP_Pos = 0x0
	// Bit mask of BKUP field.
	RTC_MODE1_BKUP_BKUP_Msk = 0xffffffff
)

// Constants for RTC_MODE2: Real-Time Counter - MODE2
const (
	// CTRLA: MODE2 Control A
	// Position of SWRST field.
	RTC_MODE2_CTRLA_SWRST_Pos = 0x0
	// Bit mask of SWRST field.
	RTC_MODE2_CTRLA_SWRST_Msk = 0x1
	// Bit SWRST.
	RTC_MODE2_CTRLA_SWRST = 0x1
	// Position of ENABLE field.
	RTC_MODE2_CTRLA_ENABLE_Pos = 0x1
	// Bit mask of ENABLE field.
	RTC_MODE2_CTRLA_ENABLE_Msk = 0x2
	// Bit ENABLE.
	RTC_MODE2_CTRLA_ENABLE = 0x2
	// Position of MODE field.
	RTC_MODE2_CTRLA_MODE_Pos = 0x2
	// Bit mask of MODE field.
	RTC_MODE2_CTRLA_MODE_Msk = 0xc
	// Mode 0: 32-bit Counter
	RTC_MODE2_CTRLA_MODE_COUNT32 = 0x0
	// Mode 1: 16-bit Counter
	RTC_MODE2_CTRLA_MODE_COUNT16 = 0x1
	// Mode 2: Clock/Calendar
	RTC_MODE2_CTRLA_MODE_CLOCK = 0x2
	// Position of CLKREP field.
	RTC_MODE2_CTRLA_CLKREP_Pos = 0x6
	// Bit mask of CLKREP field.
	RTC_MODE2_CTRLA_CLKREP_Msk = 0x40
	// Bit CLKREP.
	RTC_MODE2_CTRLA_CLKREP = 0x40
	// Position of MATCHCLR field.
	RTC_MODE2_CTRLA_MATCHCLR_Pos = 0x7
	// Bit mask of MATCHCLR field.
	RTC_MODE2_CTRLA_MATCHCLR_Msk = 0x80
	// Bit MATCHCLR.
	RTC_MODE2_CTRLA_MATCHCLR = 0x80
	// Position of PRESCALER field.
	RTC_MODE2_CTRLA_PRESCALER_Pos = 0x8
	// Bit mask of PRESCALER field.
	RTC_MODE2_CTRLA_PRESCALER_Msk = 0xf00
	// CLK_RTC_CNT = GCLK_RTC/1
	RTC_MODE2_CTRLA_PRESCALER_OFF = 0x0
	// CLK_RTC_CNT = GCLK_RTC/1
	RTC_MODE2_CTRLA_PRESCALER_DIV1 = 0x1
	// CLK_RTC_CNT = GCLK_RTC/2
	RTC_MODE2_CTRLA_PRESCALER_DIV2 = 0x2
	// CLK_RTC_CNT = GCLK_RTC/4
	RTC_MODE2_CTRLA_PRESCALER_DIV4 = 0x3
	// CLK_RTC_CNT = GCLK_RTC/8
	RTC_MODE2_CTRLA_PRESCALER_DIV8 = 0x4
	// CLK_RTC_CNT = GCLK_RTC/16
	RTC_MODE2_CTRLA_PRESCALER_DIV16 = 0x5
	// CLK_RTC_CNT = GCLK_RTC/32
	RTC_MODE2_CTRLA_PRESCALER_DIV32 = 0x6
	// CLK_RTC_CNT = GCLK_RTC/64
	RTC_MODE2_CTRLA_PRESCALER_DIV64 = 0x7
	// CLK_RTC_CNT = GCLK_RTC/128
	RTC_MODE2_CTRLA_PRESCALER_DIV128 = 0x8
	// CLK_RTC_CNT = GCLK_RTC/256
	RTC_MODE2_CTRLA_PRESCALER_DIV256 = 0x9
	// CLK_RTC_CNT = GCLK_RTC/512
	RTC_MODE2_CTRLA_PRESCALER_DIV512 = 0xa
	// CLK_RTC_CNT = GCLK_RTC/1024
	RTC_MODE2_CTRLA_PRESCALER_DIV1024 = 0xb
	// Position of BKTRST field.
	RTC_MODE2_CTRLA_BKTRST_Pos = 0xd
	// Bit mask of BKTRST field.
	RTC_MODE2_CTRLA_BKTRST_Msk = 0x2000
	// Bit BKTRST.
	RTC_MODE2_CTRLA_BKTRST = 0x2000
	// Position of GPTRST field.
	RTC_MODE2_CTRLA_GPTRST_Pos = 0xe
	// Bit mask of GPTRST field.
	RTC_MODE2_CTRLA_GPTRST_Msk = 0x4000
	// Bit GPTRST.
	RTC_MODE2_CTRLA_GPTRST = 0x4000
	// Position of CLOCKSYNC field.
	RTC_MODE2_CTRLA_CLOCKSYNC_Pos = 0xf
	// Bit mask of CLOCKSYNC field.
	RTC_MODE2_CTRLA_CLOCKSYNC_Msk = 0x8000
	// Bit CLOCKSYNC.
	RTC_MODE2_CTRLA_CLOCKSYNC = 0x8000

	// CTRLB: MODE2 Control B
	// Position of GP0EN field.
	RTC_MODE2_CTRLB_GP0EN_Pos = 0x0
	// Bit mask of GP0EN field.
	RTC_MODE2_CTRLB_GP0EN_Msk = 0x1
	// Bit GP0EN.
	RTC_MODE2_CTRLB_GP0EN = 0x1
	// Position of DEBMAJ field.
	RTC_MODE2_CTRLB_DEBMAJ_Pos = 0x4
	// Bit mask of DEBMAJ field.
	RTC_MODE2_CTRLB_DEBMAJ_Msk = 0x10
	// Bit DEBMAJ.
	RTC_MODE2_CTRLB_DEBMAJ = 0x10
	// Position of DEBASYNC field.
	RTC_MODE2_CTRLB_DEBASYNC_Pos = 0x5
	// Bit mask of DEBASYNC field.
	RTC_MODE2_CTRLB_DEBASYNC_Msk = 0x20
	// Bit DEBASYNC.
	RTC_MODE2_CTRLB_DEBASYNC = 0x20
	// Position of RTCOUT field.
	RTC_MODE2_CTRLB_RTCO