/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view;

import java.awt.event.ActionEvent;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.AbstractAction;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.model.Context;

public abstract class DeleteContextAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    public static final String ACTION_NAME = "zap.delete.context";

    public DeleteContextAction() {
        super(ACTION_NAME);
        this.putValue("AcceleratorKey", View.getSingleton().getDefaultDeleteKeyStroke());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        List<Context> contexts = this.getContexts();
        if (contexts.isEmpty()) {
            return;
        }
        String contextList = contexts.stream().map(Context::getName).collect(Collectors.joining("\n"));
        if (View.getSingleton().showConfirmDialog(Constant.messages.getString("context.delete.warning", contextList)) == 0) {
            for (Context context : contexts) {
                Model.getSingleton().getSession().deleteContext(context);
            }
        }
    }

    protected abstract Context getContext();

    protected List<Context> getContexts() {
        Context ctx = this.getContext();
        return ctx == null ? Collections.emptyList() : Arrays.asList(ctx);
    }
}

