/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view.table;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.SortOrder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.action.AbstractActionExt;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.renderer.DefaultTableRenderer;
import org.jdesktop.swingx.renderer.IconValues;
import org.jdesktop.swingx.renderer.MappedValue;
import org.jdesktop.swingx.renderer.StringValue;
import org.jdesktop.swingx.renderer.StringValues;
import org.jdesktop.swingx.table.ColumnFactory;
import org.jdesktop.swingx.table.TableColumnExt;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.db.DatabaseException;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.utils.PagingTableModel;
import org.zaproxy.zap.view.HrefTypeInfo;
import org.zaproxy.zap.view.ZapTable;
import org.zaproxy.zap.view.messagecontainer.http.DefaultSelectableHistoryReferencesContainer;
import org.zaproxy.zap.view.renderer.DateFormatStringValue;
import org.zaproxy.zap.view.renderer.SizeBytesStringValue;
import org.zaproxy.zap.view.renderer.TimeDurationStringValue;
import org.zaproxy.zap.view.table.AlertRiskTableCellItem;
import org.zaproxy.zap.view.table.DefaultHistoryReferencesTableModel;
import org.zaproxy.zap.view.table.HistoryReferencesTableModel;
import org.zaproxy.zap.view.table.decorator.AlertRiskTableCellItemIconHighlighter;
import org.zaproxy.zap.view.table.decorator.HrefTypeInfoIconHighlighter;
import org.zaproxy.zap.view.table.decorator.NoteTableCellItemIconHighlighter;

public class HistoryReferencesTable
extends ZapTable {
    private static final long serialVersionUID = -6988769961088738602L;
    private static final Logger LOGGER = LogManager.getLogger(HistoryReferencesTable.class);
    private static final int MAXIMUM_ROWS_FOR_TABLE_CONFIG = 75;
    private final DisplayMessageOnSelectionValueChange defaultSelectionListener;
    private int maximumRowsForTableConfig = 75;

    public HistoryReferencesTable() {
        this(new DefaultHistoryReferencesTableModel());
    }

    public HistoryReferencesTable(HistoryReferencesTableModel.Column[] columns) {
        this(new DefaultHistoryReferencesTableModel(columns));
    }

    public HistoryReferencesTable(HistoryReferencesTableModel<?> model) {
        this(model, true);
    }

    public HistoryReferencesTable(HistoryReferencesTableModel<?> model, boolean useDefaultSelectionListener) {
        super(model);
        this.setName("GenericHistoryReferenceTable");
        this.installColumnFactory();
        this.setSelectionMode(2);
        this.setSortOrderCycle(new SortOrder[]{SortOrder.ASCENDING, SortOrder.DESCENDING, SortOrder.UNSORTED});
        this.setColumnSelectionAllowed(false);
        this.setCellSelectionEnabled(false);
        this.setRowSelectionAllowed(true);
        if (useDefaultSelectionListener) {
            this.defaultSelectionListener = new DisplayMessageOnSelectionValueChange();
            this.getSelectionModel().addListSelectionListener(this.defaultSelectionListener);
        } else {
            this.defaultSelectionListener = null;
        }
        this.setComponentPopupMenu(new CustomPopupMenu());
    }

    protected void createDefaultRenderers() {
        super.createDefaultRenderers();
        this.setDefaultRenderer(Date.class, (TableCellRenderer)new DefaultTableRenderer((StringValue)new DateFormatStringValue()));
    }

    protected void installColumnFactory() {
        this.setColumnFactory(new HistoryReferencesTableColumnFactory());
        this.createDefaultColumnsFromModel();
        this.initializeColumnWidths();
    }

    protected void displayMessage(HttpMessage msg) {
        View.getSingleton().displayMessage(msg);
    }

    protected DisplayMessageOnSelectionValueChange getDefaultSelectionListener() {
        return this.defaultSelectionListener;
    }

    public HistoryReference getSelectedHistoryReference() {
        int selectedRow = this.getSelectedRow();
        if (selectedRow != -1) {
            return this.getHistoryReferenceAtViewRow(selectedRow);
        }
        return null;
    }

    public List<HistoryReference> getSelectedHistoryReferences() {
        int[] rows = this.getSelectedRows();
        if (rows.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<HistoryReference> hrefList = new ArrayList<HistoryReference>(rows.length);
        for (int row : rows) {
            HistoryReference hRef = this.getHistoryReferenceAtViewRow(row);
            if (hRef == null) continue;
            hrefList.add(hRef);
        }
        return hrefList;
    }

    public List<HistoryReference> getAllHistoryReferences() {
        int rowCount = this.getRowCount();
        if (rowCount == 0) {
            return Collections.emptyList();
        }
        ArrayList<HistoryReference> hrefList = new ArrayList<HistoryReference>(rowCount);
        for (int row = 0; row < rowCount; ++row) {
            HistoryReference hRef = this.getHistoryReferenceAtViewRow(row);
            if (hRef == null) continue;
            hrefList.add(hRef);
        }
        return hrefList;
    }

    protected HistoryReference getHistoryReferenceAtViewRow(int row) {
        Object entry = this.getModel().getEntry(this.convertRowIndexToModel(row));
        if (entry != null) {
            return entry.getHistoryReference();
        }
        return null;
    }

    public void setModel(TableModel dataModel) {
        if (!(dataModel instanceof HistoryReferencesTableModel)) {
            throw new IllegalArgumentException("Parameter dataModel must be a subclass of HistoryReferencesTableModel.");
        }
        if (dataModel instanceof PagingTableModel) {
            this.setMaximumRowsForTableConfiguration(((PagingTableModel)dataModel).getMaxPageSize());
        }
        super.setModel(dataModel);
    }

    public HistoryReferencesTableModel<?> getModel() {
        return (HistoryReferencesTableModel)super.getModel();
    }

    public void setMaximumRowsForTableConfiguration(int maximumRows) {
        this.maximumRowsForTableConfig = maximumRows;
    }

    public int getMaximumRowsForTableConfiguration() {
        return this.maximumRowsForTableConfig;
    }

    public void selectHistoryReference(int historyReferenceId) {
        int modelRowIndex = this.getModel().getEntryRowIndex(historyReferenceId);
        if (modelRowIndex > -1) {
            int viewRowIndex = this.convertRowIndexToView(modelRowIndex);
            this.getSelectionModel().setSelectionInterval(viewRowIndex, viewRowIndex);
            this.scrollRowToVisible(viewRowIndex);
        }
    }

    protected class DisplayMessageOnSelectionValueChange
    implements ListSelectionListener {
        private boolean enabled = true;

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void valueChanged(ListSelectionEvent evt) {
            if (!this.enabled || evt.getValueIsAdjusting()) {
                return;
            }
            HistoryReference hRef = HistoryReferencesTable.this.getSelectedHistoryReference();
            if (hRef == null) {
                return;
            }
            boolean focusOwner = HistoryReferencesTable.this.isFocusOwner();
            try {
                HistoryReferencesTable.this.displayMessage(hRef.getHttpMessage());
            }
            catch (DatabaseException | HttpMalformedHeaderException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
            finally {
                if (focusOwner) {
                    HistoryReferencesTable.this.requestFocusInWindow();
                }
            }
        }
    }

    protected class CustomPopupMenu
    extends JPopupMenu {
        private static final long serialVersionUID = 1L;

        protected CustomPopupMenu() {
        }

        @Override
        public void show(Component invoker, int x, int y) {
            DefaultSelectableHistoryReferencesContainer messageContainer = new DefaultSelectableHistoryReferencesContainer(HistoryReferencesTable.this.getName(), (Component)((Object)HistoryReferencesTable.this), Collections.emptyList(), this.getSelectedHistoryReferences());
            View.getSingleton().getPopupMenu().show(messageContainer, x, y);
        }

        protected List<HistoryReference> getSelectedHistoryReferences() {
            return HistoryReferencesTable.this.getSelectedHistoryReferences();
        }
    }

    protected class HistoryReferencesTableColumnFactory
    extends ColumnFactory {
        private SizeBytesStringValue sizeBytesStringValue;

        protected int getRowCount(JXTable table) {
            int rowCount = super.getRowCount(table);
            int maxRowCount = ((HistoryReferencesTable)table).getMaximumRowsForTableConfiguration();
            if (maxRowCount > 0 && rowCount > maxRowCount) {
                return maxRowCount;
            }
            return rowCount;
        }

        public void configureTableColumn(TableModel model, TableColumnExt columnExt) {
            int noteColumnIndex;
            int rttColumnIndex;
            super.configureTableColumn(model, columnExt);
            HistoryReferencesTableModel hRefModel = (HistoryReferencesTableModel)model;
            columnExt.setPrototypeValue(hRefModel.getPrototypeValue(columnExt.getModelIndex()));
            int highestAlertColumnIndex = hRefModel.getColumnIndex(HistoryReferencesTableModel.Column.HIGHEST_ALERT);
            if (highestAlertColumnIndex != -1 && columnExt.getModelIndex() == highestAlertColumnIndex && model.getColumnClass(highestAlertColumnIndex) == AlertRiskTableCellItem.class) {
                columnExt.setHighlighters(new Highlighter[]{new AlertRiskTableCellItemIconHighlighter(highestAlertColumnIndex)});
            }
            if ((rttColumnIndex = hRefModel.getColumnIndex(HistoryReferencesTableModel.Column.RTT)) != -1 && columnExt.getModelIndex() == rttColumnIndex && TimeDurationStringValue.isTargetClass(model.getColumnClass(rttColumnIndex))) {
                columnExt.setCellRenderer((TableCellRenderer)new DefaultTableRenderer((StringValue)new TimeDurationStringValue()));
            }
            if ((noteColumnIndex = hRefModel.getColumnIndex(HistoryReferencesTableModel.Column.NOTE)) != -1 && columnExt.getModelIndex() == noteColumnIndex && model.getColumnClass(noteColumnIndex) == Boolean.class) {
                columnExt.setCellRenderer((TableCellRenderer)new DefaultTableRenderer((StringValue)new MappedValue(StringValues.EMPTY, IconValues.NONE), 0));
                columnExt.setHighlighters(new Highlighter[]{new NoteTableCellItemIconHighlighter(noteColumnIndex)});
            }
            this.installSizeBytesRenderer(columnExt, hRefModel.getColumnIndex(HistoryReferencesTableModel.Column.SIZE_MESSAGE), model);
            this.installSizeBytesRenderer(columnExt, hRefModel.getColumnIndex(HistoryReferencesTableModel.Column.SIZE_REQUEST_HEADER), model);
            this.installSizeBytesRenderer(columnExt, hRefModel.getColumnIndex(HistoryReferencesTableModel.Column.SIZE_REQUEST_BODY), model);
            this.installSizeBytesRenderer(columnExt, hRefModel.getColumnIndex(HistoryReferencesTableModel.Column.SIZE_RESPONSE_HEADER), model);
            this.installSizeBytesRenderer(columnExt, hRefModel.getColumnIndex(HistoryReferencesTableModel.Column.SIZE_RESPONSE_BODY), model);
            int hrefTypeInfoColumnIndex = hRefModel.getColumnIndex(HistoryReferencesTableModel.Column.HREF_TYPE_INFO);
            if (hrefTypeInfoColumnIndex != -1 && columnExt.getModelIndex() == hrefTypeInfoColumnIndex && model.getColumnClass(hrefTypeInfoColumnIndex) == HrefTypeInfo.class) {
                columnExt.setHighlighters(new Highlighter[]{new HrefTypeInfoIconHighlighter(hrefTypeInfoColumnIndex)});
            }
        }

        protected void installSizeBytesRenderer(TableColumnExt columnExt, int columnIndex, TableModel model) {
            if (columnIndex != -1 && columnExt.getModelIndex() == columnIndex && SizeBytesStringValue.isTargetClass(model.getColumnClass(columnIndex))) {
                columnExt.setCellRenderer((TableCellRenderer)new DefaultTableRenderer((StringValue)this.getSizeBytesStringValue()));
            }
        }

        protected SizeBytesStringValue getSizeBytesStringValue() {
            if (this.sizeBytesStringValue == null) {
                this.sizeBytesStringValue = new SizeBytesStringValue();
                JComponent columnControl = HistoryReferencesTable.this.getColumnControl();
                if (columnControl instanceof ZapTable.ZapColumnControlButton) {
                    ZapTable.ZapColumnControlButton zapColumnControl = (ZapTable.ZapColumnControlButton)((Object)columnControl);
                    zapColumnControl.addAction((Action)((Object)new ChangeByteUnitAction(HistoryReferencesTable.this, this.sizeBytesStringValue)));
                    zapColumnControl.populatePopup();
                }
            }
            return this.sizeBytesStringValue;
        }
    }

    protected static class ChangeByteUnitAction
    extends AbstractActionExt {
        private static final long serialVersionUID = 5518182106427836717L;
        private final JXTable table;
        private final SizeBytesStringValue sizeBytesStringValue;

        public ChangeByteUnitAction(JXTable table, SizeBytesStringValue sizeBytesStringValue) {
            super(Constant.messages.getString("view.table.useJustBytes.label"));
            this.putValue("ShortDescription", Constant.messages.getString("view.table.useJustBytes.tooltip"));
            this.table = table;
            this.sizeBytesStringValue = sizeBytesStringValue;
            this.putValue("SwingSelectedKey", sizeBytesStringValue.isUseJustBytesUnit());
        }

        public ChangeByteUnitAction(String label, Icon icon, JXTable table, SizeBytesStringValue sizeBytesStringValue) {
            super(label, icon);
            this.table = table;
            this.sizeBytesStringValue = sizeBytesStringValue;
        }

        public boolean isStateAction() {
            return true;
        }

        public void actionPerformed(ActionEvent e) {
            this.sizeBytesStringValue.setUseJustBytesUnit(!this.sizeBytesStringValue.isUseJustBytesUnit());
            this.table.repaint();
        }
    }
}

