﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/codeguru-security/CodeGuruSecurity_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace CodeGuruSecurity {
namespace Model {

/**
 * <p>Information about the number of findings generated by a scan.</p><p><h3>See
 * Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/codeguru-security-2018-05-10/ScanNameWithFindingNum">AWS
 * API Reference</a></p>
 */
class ScanNameWithFindingNum {
 public:
  AWS_CODEGURUSECURITY_API ScanNameWithFindingNum() = default;
  AWS_CODEGURUSECURITY_API ScanNameWithFindingNum(Aws::Utils::Json::JsonView jsonValue);
  AWS_CODEGURUSECURITY_API ScanNameWithFindingNum& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_CODEGURUSECURITY_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The name of the scan.</p>
   */
  inline const Aws::String& GetScanName() const { return m_scanName; }
  inline bool ScanNameHasBeenSet() const { return m_scanNameHasBeenSet; }
  template <typename ScanNameT = Aws::String>
  void SetScanName(ScanNameT&& value) {
    m_scanNameHasBeenSet = true;
    m_scanName = std::forward<ScanNameT>(value);
  }
  template <typename ScanNameT = Aws::String>
  ScanNameWithFindingNum& WithScanName(ScanNameT&& value) {
    SetScanName(std::forward<ScanNameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The number of findings generated by a scan.</p>
   */
  inline int GetFindingNumber() const { return m_findingNumber; }
  inline bool FindingNumberHasBeenSet() const { return m_findingNumberHasBeenSet; }
  inline void SetFindingNumber(int value) {
    m_findingNumberHasBeenSet = true;
    m_findingNumber = value;
  }
  inline ScanNameWithFindingNum& WithFindingNumber(int value) {
    SetFindingNumber(value);
    return *this;
  }
  ///@}
 private:
  Aws::String m_scanName;
  bool m_scanNameHasBeenSet = false;

  int m_findingNumber{0};
  bool m_findingNumberHasBeenSet = false;
};

}  // namespace Model
}  // namespace CodeGuruSecurity
}  // namespace Aws
