# --------------------------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
#
# Code generated by aaz-dev-tools
# --------------------------------------------------------------------------------------------

# pylint: skip-file
# flake8: noqa

from azure.cli.core.aaz import *


@register_command(
    "search service check-name-availability",
)
class CheckNameAvailability(AAZCommand):
    """Checks whether or not the given search service name is available for use. Search service names must be globally unique since they are part of the service URI (https://`<name>`.search.windows.net).
    """

    _aaz_info = {
        "version": "2025-05-01",
        "resources": [
            ["mgmt-plane", "/subscriptions/{}/providers/microsoft.search/checknameavailability", "2025-05-01"],
        ]
    }

    def _handler(self, command_args):
        super()._handler(command_args)
        self._execute_operations()
        return self._output()

    _args_schema = None

    @classmethod
    def _build_arguments_schema(cls, *args, **kwargs):
        if cls._args_schema is not None:
            return cls._args_schema
        cls._args_schema = super()._build_arguments_schema(*args, **kwargs)

        # define Arg Group ""

        # define Arg Group "CheckNameAvailabilityInput"

        _args_schema = cls._args_schema
        _args_schema.name = AAZStrArg(
            options=["--name"],
            arg_group="CheckNameAvailabilityInput",
            help="The search service name to validate. Search service names must only contain lowercase letters, digits or dashes, cannot use dash as the first two or last one characters, cannot contain consecutive dashes, and must be between 2 and 60 characters in length.",
            required=True,
        )
        _args_schema.type = AAZStrArg(
            options=["--type"],
            arg_group="CheckNameAvailabilityInput",
            help="The type of the resource whose name is to be validated. This value must always be 'searchServices'.",
            required=True,
            enum={"searchServices": "searchServices"},
        )
        return cls._args_schema

    def _execute_operations(self):
        self.pre_operations()
        self.ServicesCheckNameAvailability(ctx=self.ctx)()
        self.post_operations()

    @register_callback
    def pre_operations(self):
        pass

    @register_callback
    def post_operations(self):
        pass

    def _output(self, *args, **kwargs):
        result = self.deserialize_output(self.ctx.vars.instance, client_flatten=True)
        return result

    class ServicesCheckNameAvailability(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [200]:
                return self.on_200(session)

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/subscriptions/{subscriptionId}/providers/Microsoft.Search/checkNameAvailability",
                **self.url_parameters
            )

        @property
        def method(self):
            return "POST"

        @property
        def error_format(self):
            return "ODataV4Format"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "subscriptionId", self.ctx.subscription_id,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "api-version", "2025-05-01",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Content-Type", "application/json",
                ),
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        @property
        def content(self):
            _content_value, _builder = self.new_content_builder(
                self.ctx.args,
                typ=AAZObjectType,
                typ_kwargs={"flags": {"required": True, "client_flatten": True}}
            )
            _builder.set_prop("name", AAZStrType, ".name", typ_kwargs={"flags": {"required": True}})
            _builder.set_prop("type", AAZStrType, ".type", typ_kwargs={"flags": {"required": True}})

            return self.serialize_content(_content_value)

        def on_200(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200
            )

        _schema_on_200 = None

        @classmethod
        def _build_schema_on_200(cls):
            if cls._schema_on_200 is not None:
                return cls._schema_on_200

            cls._schema_on_200 = AAZObjectType()

            _schema_on_200 = cls._schema_on_200
            _schema_on_200.message = AAZStrType(
                flags={"read_only": True},
            )
            _schema_on_200.name_available = AAZBoolType(
                serialized_name="nameAvailable",
                flags={"read_only": True},
            )
            _schema_on_200.reason = AAZStrType(
                flags={"read_only": True},
            )

            return cls._schema_on_200


class _CheckNameAvailabilityHelper:
    """Helper class for CheckNameAvailability"""


__all__ = ["CheckNameAvailability"]
