# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class AlertSeverity(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The risk level of the threat that was detected. Learn more:
    https://docs.microsoft.com/en-us/azure/security-center/security-center-alerts-overview#how-are-alerts-classified.
    """

    INFORMATIONAL = "Informational"
    """Informational"""
    LOW = "Low"
    """Low"""
    MEDIUM = "Medium"
    """Medium"""
    HIGH = "High"
    """High"""


class AlertStatus(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The life cycle status of the alert."""

    ACTIVE = "Active"
    """An alert which doesn't specify a value is assigned the status 'Active'"""
    RESOLVED = "Resolved"
    """Alert closed after handling"""
    DISMISSED = "Dismissed"
    """Alert dismissed as false positive"""


class BundleType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """Alert Simulator supported bundles."""

    APP_SERVICES = "AppServices"
    DNS = "DNS"
    KEY_VAULTS = "KeyVaults"
    KUBERNETES_SERVICE = "KubernetesService"
    RESOURCE_MANAGER = "ResourceManager"
    SQL_SERVERS = "SqlServers"
    STORAGE_ACCOUNTS = "StorageAccounts"
    VIRTUAL_MACHINES = "VirtualMachines"


class Intent(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The kill chain related intent behind the alert. For list of supported values, and explanations
    of Azure Security Center's supported kill chain intents.
    """

    UNKNOWN = "Unknown"
    """Unknown"""
    PRE_ATTACK = "PreAttack"
    """PreAttack could be either an attempt to access a certain resource regardless of a malicious
    #: intent, or a failed attempt to gain access to a target system to gather information prior to
    #: exploitation. This step is usually detected as an attempt, originating from outside the
    #: network, to scan the target system and find a way in.  Further details on the PreAttack stage
    #: can be read in `MITRE Pre-Att&ck matrix <https://attack.mitre.org/matrices/pre/>`_."""
    INITIAL_ACCESS = "InitialAccess"
    """InitialAccess is the stage where an attacker manages to get foothold on the attacked resource."""
    PERSISTENCE = "Persistence"
    """Persistence is any access, action, or configuration change to a system that gives a threat
    #: actor a persistent presence on that system."""
    PRIVILEGE_ESCALATION = "PrivilegeEscalation"
    """Privilege escalation is the result of actions that allow an adversary to obtain a higher level
    #: of permissions on a system or network."""
    DEFENSE_EVASION = "DefenseEvasion"
    """Defense evasion consists of techniques an adversary may use to evade detection or avoid other
    #: defenses."""
    CREDENTIAL_ACCESS = "CredentialAccess"
    """Credential access represents techniques resulting in access to or control over system, domain,
    #: or service credentials that are used within an enterprise environment."""
    DISCOVERY = "Discovery"
    """Discovery consists of techniques that allow the adversary to gain knowledge about the system
    #: and internal network."""
    LATERAL_MOVEMENT = "LateralMovement"
    """Lateral movement consists of techniques that enable an adversary to access and control remote
    #: systems on a network and could, but does not necessarily, include execution of tools on remote
    #: systems."""
    EXECUTION = "Execution"
    """The execution tactic represents techniques that result in execution of adversary-controlled
    #: code on a local or remote system."""
    COLLECTION = "Collection"
    """Collection consists of techniques used to identify and gather information, such as sensitive
    #: files, from a target network prior to exfiltration."""
    EXFILTRATION = "Exfiltration"
    """Exfiltration refers to techniques and attributes that result or aid in the adversary removing
    #: files and information from a target network."""
    COMMAND_AND_CONTROL = "CommandAndControl"
    """The command and control tactic represents how adversaries communicate with systems under their
    #: control within a target network."""
    IMPACT = "Impact"
    """Impact events primarily try to directly reduce the availability or integrity of a system,
    #: service, or network; including manipulation of data to impact a business or operational
    #: process."""
    PROBING = "Probing"
    """Probing could be either an attempt to access a certain resource regardless of a malicious
    #: intent, or a failed attempt to gain access to a target system to gather information prior to
    #: exploitation."""
    EXPLOITATION = "Exploitation"
    """Exploitation is the stage where an attacker manages to get a foothold on the attacked resource.
    #: This stage is relevant for compute hosts and resources such as user accounts, certificates etc."""


class KindEnum(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The kind of alert simulation."""

    BUNDLES = "Bundles"
    """Simulate alerts according to bundles"""


class ResourceIdentifierType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """There can be multiple identifiers of different type per alert, this field specify the
    identifier type.
    """

    AZURE_RESOURCE = "AzureResource"
    LOG_ANALYTICS = "LogAnalytics"
