/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.text;

import java.util.List;
import org.eclipse.draw2d.text.FlowUtilities;
import org.eclipse.draw2d.text.TextFlow;
import org.eclipse.draw2d.text.TextFragmentBox;
import org.eclipse.draw2d.text.TextLayout;
import org.eclipse.swt.graphics.Font;

public class SimpleTextLayout
extends TextLayout {
    private static final String[] DELIMITERS = new String[]{"\r\n", "\n", "\r"};
    private static int result;
    private static int delimeterLength;

    public SimpleTextLayout(TextFlow flow) {
        super(flow);
    }

    @Override
    protected void layout() {
        TextFlow textFlow = (TextFlow)this.getFlowFigure();
        String text = textFlow.getText();
        List<TextFragmentBox> fragments = textFlow.getFragments();
        Font font = textFlow.getFont();
        int i = 0;
        int offset = 0;
        FlowUtilities flowUtilities = textFlow.getFlowUtilities();
        do {
            SimpleTextLayout.nextLineBreak(text, offset);
            TextFragmentBox fragment = this.getFragment(i, fragments);
            ++i;
            fragment.length = result - offset;
            fragment.offset = offset;
            fragment.setWidth(-1);
            flowUtilities.setupFragment(fragment, font, text.substring(offset, result));
            this.getContext().addToCurrentLine(fragment);
            this.getContext().endLine();
        } while ((offset = result + delimeterLength) < text.length());
        while (i < fragments.size()) {
            fragments.remove(i);
            ++i;
        }
    }

    private static int nextLineBreak(String text, int offset) {
        result = text.length();
        delimeterLength = 0;
        String[] stringArray = DELIMITERS;
        int n = DELIMITERS.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            int current = text.indexOf(element, offset);
            if (current != -1 && current < result) {
                result = current;
                delimeterLength = element.length();
            }
            ++n2;
        }
        return result;
    }
}

