# frozen_string_literal: true

class QueueBackfillOccurrenceIdToVulnerabilityReads < Gitlab::Database::Migration[2.3]
  milestone '18.7'
  restrict_gitlab_migration gitlab_schema: :gitlab_sec

  MIGRATION = "BackfillOccurrenceIdToVulnerabilityReads"

  def up
    queue_batched_background_migration(
      MIGRATION,
      :vulnerability_reads,
      :id
    )
  end

  def down
    delete_batched_background_migration(MIGRATION, :vulnerability_reads, :id, [])
  end
end
