---
stage: Fulfillment
group: Provision
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
description: シートの割り当て、GitLab Duoサブスクリプションアドオン。
title: GitLab Duoのトライアル
---

{{< details >}}

- プラン: Premium、Ultimate
- 提供形態: GitLab.com、GitLab Self-Managed、GitLab Dedicated

{{< /details >}}

GitLab Duoをお試しになるには、期間限定で無料トライアルをご利用いただけます。

トライアル期間中は、選択したアドオンのすべての機能セットにアクセスできます。トライアル期間が終了した後、アクセスを維持するには、アドオンを購入してください。

GitLab Duoアドオンのトライアルは30日間続きます。

## GitLab Duo Proの開始 {#start-gitlab-duo-pro-trial}

GitLab Duo Proを入手して、期間限定で[GitLab Duo Proの機能](../user/gitlab_duo/feature_summary.md)をテストしてください。

GitLab.com、GitLab Self-Managed、またはGitLab DedicatedでPremiumプランをお使いの場合、GitLab Duo Proを入手できます。

### GitLab.com {#on-gitlabcom}

前提要件: 

- アクティブな有料Premiumサブスクリプションをお持ちのトップレベルグループのオーナーロールが必要です。グループメンバーシップによる間接的な所有権では不十分です。

GitLab.comでGitLab Duo Proを開始するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、グループを見つけます。
1. **設定** > **請求**を選択します。
1. **Start a free GitLab Duo Pro trial**（無料のGitLab Duo Proトライアルを開始）を選択します。
1. フィールドに入力します。
1. **次に進む**を選択します。
1. プロンプトが表示されたら、トライアルを適用するグループを選択します。
1. **トライアル版を有効にする**を選択します。
1. アクセスを必要とするユーザーに[シートを割り当て](subscription-add-ons.md#assign-gitlab-duo-seats)ます。

### GitLab Self-Managed {#on-gitlab-self-managed}

前提要件: 

- アクティブな有料Premiumサブスクリプションが必要です。
- GitLab 16.8以降が必要で、インスタンスがGitLabと[サブスクリプションデータを同期](manage_subscription.md#subscription-data-synchronization)できる必要があります。
- 最高のユーザーエクスペリエンスと結果を得るには、GitLab DuoでGitLab 17.2以降が必要です。以前のバージョンでも引き続き動作する可能性はありますが、エクスペリエンスが低下するおそれがあります。

GitLab Self-ManagedまたはGitLab DedicatedでGitLab Duo Proを開始するには:

1. [GitLab Duo Proトライアルページ](https://about.gitlab.com/solutions/gitlab-duo-pro/sales/?toggle=gitlab-duo-pro)に移動します。
1. フィールドに入力します。

   - サブスクリプション名を見つけるには:
     1. Customers Portalの**Subscriptions & purchases**ページで、トライアルを適用するサブスクリプションを見つけます。
     1. ページの上部に、サブスクリプション名がバッジで表示されます。

        ![Subscription name](img/subscription_name_v17_0.png)
   - トライアル登録のために送信するメールアドレスが、[サブスクリプションの連絡先](billing_account.md#change-your-subscription-contact)のメールアドレスと一致していることを確認してください。
1. **送信**を選択します。

トライアルは、24時間以内に自動的にインスタンスに同期されます。トライアルが同期されたら、GitLab Duoにアクセスさせるユーザーに[シートを割り当て](subscription-add-ons.md#assign-gitlab-duo-seats)ます。

### GitLab Dedicated {#on-gitlab-dedicated}

トライアルにご興味のある方は、営業担当者にお問い合わせください。

## GitLab Duo Enterpriseの開始 {#start-gitlab-duo-enterprise-trial}

GitLab Duo Enterpriseを入手して、期間限定で[GitLab Duo Enterpriseの機能](../user/gitlab_duo/feature_summary.md)をテストしてください。

GitLab Duo Enterpriseを入手できるのは、次の場合です:

- GitLab.comでFreeプランをお使いの場合。その場合は、GitLab Duo EnterpriseでUltimateプランをお試しいただけます。
- GitLab.com、GitLab Self-Managed、またはGitLab DedicatedでPremiumまたはUltimateプランをお使いの場合。

GitLab Self-ManagedでFreeプランをお使いの場合、トライアルは利用できません。

### GitLab.com {#on-gitlabcom-1}

前提要件: 

- アクティブな有料Ultimateサブスクリプションをお持ちのトップレベルグループのオーナーロールが必要です。

GitLab.comでGitLab Duo Enterpriseを開始するには:

1. 左側のサイドバーで、**検索または移動先**を選択して、グループを見つけます。
1. **設定** > **請求**を選択します。
1. **Start a free GitLab Duo Enterprise trial**（無料のGitLab Duo Enterpriseトライアルを開始）を選択します。
1. フィールドに入力します。
1. **次に進む**を選択します。
1. プロンプトが表示されたら、トライアルを適用するグループを選択します。
1. **トライアル版を有効にする**を選択します。
1. アクセスを必要とするユーザーに[シートを割り当て](subscription-add-ons.md#assign-gitlab-duo-seats)ます。

### GitLab Self-Managed {#on-gitlab-self-managed-1}

前提要件: 

- アクティブな有料Ultimateサブスクリプションが必要です。
- GitLab 17.3以降が必要で、インスタンスがGitLabと[サブスクリプションデータを同期](manage_subscription.md#subscription-data-synchronization)できる必要があります。

GitLab Self-ManagedまたはGitLab DedicatedでGitLab Duo Enterpriseを開始するには:

1. [GitLab Duo Enterpriseトライアルページ](https://about.gitlab.com/solutions/gitlab-duo-pro/sales/?toggle=gitlab-duo-enterprise)に移動します。
1. フィールドに入力します。

   - サブスクリプション名を見つけるには:
     1. Customers Portalの**Subscriptions & purchases**ページで、トライアルを適用するサブスクリプションを見つけます。
     1. ページの上部に、サブスクリプション名がバッジで表示されます。

        ![Subscription name](img/subscription_name_v17_0.png)
   - トライアル登録のために送信するメールアドレスが、[サブスクリプションの連絡先](billing_account.md#change-your-subscription-contact)のメールアドレスと一致していることを確認してください。
1. **送信**を選択します。

トライアルは、24時間以内に自動的にインスタンスに同期されます。トライアルが同期されたら、GitLab Duoにアクセスさせるユーザーに[シートを割り当て](subscription-add-ons.md#assign-gitlab-duo-seats)ます。

### GitLab Dedicated {#on-gitlab-dedicated-1}

トライアルにご興味のある方は、営業担当者にお問い合わせください。
