#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
printf '%s' 'name:                 text-show
version:              3.10.5
visibility:           public
id:                   text-show-3.10.5-2xqeyNKPfnU4iOC9FlixPu
key:                  text-show-3.10.5-2xqeyNKPfnU4iOC9FlixPu
license:              BSD-3-Clause
copyright:            (C) 2014-2017 Ryan Scott
maintainer:           Ryan Scott <ryan.gl.scott@gmail.com>
author:               Ryan Scott
stability:            Provisional
homepage:             https://github.com/RyanGlScott/text-show
synopsis:             Efficient conversion of values into Text
description:
    @text-show@ offers a replacement for the @Show@ typeclass intended
    for use with @Text@ instead of @String@s. This package was created
    in the spirit of
    @<http://hackage.haskell.org/package/bytestring-show bytestring-show>@.

    For most uses, simply importing "TextShow"
    will suffice:

    @
    module Main where

    import TextShow

    main :: IO ()
    main = printT (Just \"Hello, World!\")
    @

    See also the
    <https://github.com/RyanGlScott/text-show/wiki/Naming-conventions naming conventions>
    page.

    Support for automatically deriving @TextShow@ instances can be found
    in the "TextShow.TH" and "TextShow.Generic" modules.

    @text-show@ only provides instances for data types in the
    following packages:

    * @<http://hackage.haskell.org/package/array array>@

    * @<http://hackage.haskell.org/package/base base>@

    * @<http://hackage.haskell.org/package/bytestring bytestring>@

    * @<http://hackage.haskell.org/package/text text>@

    This policy is in place to keep @text-show@'\''s dependencies
    reasonably light. If you need a @TextShow@ instance for a
    library that is not in this list, it may be covered by the
    @<http://hackage.haskell.org/package/text-show-instances text-show-instances>@
    library.

category:             Text
abi:                  da9a1c70d053d1548fc98349e9216add
exposed:              True
exposed-modules:
    TextShow TextShow.Control.Applicative TextShow.Control.Concurrent
    TextShow.Control.Exception TextShow.Control.Monad.ST
    TextShow.Data.Array TextShow.Data.Array.Byte TextShow.Data.Bool
    TextShow.Data.ByteString TextShow.Data.Char TextShow.Data.Complex
    TextShow.Data.Data TextShow.Data.Dynamic TextShow.Data.Either
    TextShow.Data.Fixed TextShow.Data.Floating
    TextShow.Data.Functor.Compose TextShow.Data.Functor.Identity
    TextShow.Data.Functor.Product TextShow.Data.Functor.Sum
    TextShow.Data.Integral TextShow.Data.List
    TextShow.Data.List.NonEmpty TextShow.Data.Maybe
    TextShow.Data.Monoid TextShow.Data.OldTypeable TextShow.Data.Ord
    TextShow.Data.Proxy TextShow.Data.Ratio TextShow.Data.Semigroup
    TextShow.Data.Text TextShow.Data.Tuple TextShow.Data.Type.Coercion
    TextShow.Data.Type.Equality TextShow.Data.Typeable
    TextShow.Data.Version TextShow.Data.Void TextShow.Debug.Trace
    TextShow.Debug.Trace.Generic TextShow.Debug.Trace.TH
    TextShow.Foreign.C.Types TextShow.Foreign.Ptr TextShow.Functions
    TextShow.GHC.Conc.Windows TextShow.GHC.Event
    TextShow.GHC.Fingerprint TextShow.GHC.Generics
    TextShow.GHC.RTS.Flags TextShow.GHC.Stack TextShow.GHC.StaticPtr
    TextShow.GHC.Stats TextShow.GHC.TypeLits TextShow.Generic
    TextShow.Numeric.Natural TextShow.System.Exit TextShow.System.IO
    TextShow.System.Posix.Types TextShow.TH TextShow.Text.Read

hidden-modules:
    TextShow.Classes TextShow.Data.Typeable.Utils
    TextShow.FromStringTextShow TextShow.Instances TextShow.Options
    TextShow.TH.Internal TextShow.TH.Names TextShow.Utils

import-dirs:          /usr/lib/ghc-9.4.8/site-local/text-show-3.10.5
library-dirs:         /usr/lib/ghc-9.4.8/site-local/text-show-3.10.5
library-dirs-static:  /usr/lib/ghc-9.4.8/site-local/text-show-3.10.5
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/haskell-text-show
hs-libraries:         HStext-show-3.10.5-2xqeyNKPfnU4iOC9FlixPu
includes:             generic.h
depends:
    array-0.5.4.0 base-4.17.2.1
    base-compat-batteries-0.14.1-4nbhCC5zHOy26otbn0yrZb
    bifunctors-5.6.2-CnW8QhOdnhQ7eFthNEafYi bytestring-0.11.5.3
    containers-0.6.7 generic-deriving-1.14.6-74gxRivXpp5IIIsyzm48F0
    ghc-boot-th-9.4.8 ghc-prim-0.9.1 template-haskell-2.19.0.0
    text-2.0.2 th-abstraction-0.5.0.0-BROQwjXmGCt8uLmQUfLqOy
    th-lift-0.8.6-HRVeiGNnDxNElRy2LmdExl transformers-0.5.6.2
    transformers-compat-0.7.2-F1TSDgHxVH372cWL2D3XnQ

haddock-interfaces:   /usr/share/doc/haskell-text-show/html/text-show.haddock
haddock-html:         /usr/share/doc/haskell-text-show/html
' | '/usr/bin/ghc-pkg-9.4.8' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

