/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.sforms;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jetbrains.java.decompiler.modules.decompiler.StatEdge;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.sforms.DirectGraph;
import org.jetbrains.java.decompiler.modules.decompiler.sforms.DirectNode;
import org.jetbrains.java.decompiler.modules.decompiler.stats.BasicBlockStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.CatchAllStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.CatchStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.DoStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.DummyExitStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.IfStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.RootStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.Statement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.SwitchStatement;
import org.jetbrains.java.decompiler.modules.decompiler.stats.SynchronizedStatement;

public class FlattenStatementsHelper {
    private final Map<Integer, String[]> mapDestinationNodes = new HashMap<Integer, String[]>();
    private final List<Edge> listEdges = new ArrayList<Edge>();
    private final Map<String, List<String[]>> mapShortRangeFinallyPathIds = new HashMap<String, List<String[]>>();
    private final Map<String, List<String[]>> mapLongRangeFinallyPathIds = new HashMap<String, List<String[]>>();
    private final Map<String, Integer> mapPosIfBranch = new HashMap<String, Integer>();
    private DirectGraph graph;
    private RootStatement root;

    public DirectGraph buildDirectGraph(RootStatement root) {
        this.root = root;
        this.graph = new DirectGraph();
        this.flattenStatement();
        DummyExitStatement dummyexit = root.getDummyExit();
        DirectNode node = new DirectNode(DirectNode.DirectNodeType.DIRECT, (Statement)dummyexit, Integer.toString(dummyexit.id));
        node.exprents = new ArrayList<Exprent>();
        this.graph.nodes.addWithKey(node, node.id);
        this.mapDestinationNodes.put(dummyexit.id, new String[]{node.id, null});
        this.setEdges();
        this.graph.first = this.graph.nodes.getWithKey(this.mapDestinationNodes.get(root.id)[0]);
        this.graph.sortReversePostOrder();
        return this.graph;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void flattenStatement() {
        LinkedList<StatementStackEntry> lstStackStatements = new LinkedList<StatementStackEntry>();
        class StatementStackEntry {
            public final Statement statement;
            public final LinkedList<StackEntry> stackFinally;
            public final List<Exprent> tailExprents;
            public int statementIndex;
            public int edgeIndex;
            public List<StatEdge> succEdges;

            StatementStackEntry(FlattenStatementsHelper this$0, Statement statement, LinkedList<StackEntry> stackFinally, List<Exprent> tailExprents) {
                this.statement = statement;
                this.stackFinally = stackFinally;
                this.tailExprents = tailExprents;
            }
        }
        lstStackStatements.add(new StatementStackEntry(this, this.root, new LinkedList<StackEntry>(), null));
        block15: while (!lstStackStatements.isEmpty()) {
            StatementStackEntry statEntry = (StatementStackEntry)lstStackStatements.removeFirst();
            Statement stat = statEntry.statement;
            LinkedList<StackEntry> stackFinally = statEntry.stackFinally;
            int statementBreakIndex = statEntry.statementIndex;
            List<Object> lstSuccEdges = new ArrayList();
            DirectNode sourcenode = null;
            if (statEntry.succEdges == null) {
                switch (stat.type) {
                    case BASIC_BLOCK: {
                        DirectNode node = new DirectNode(DirectNode.DirectNodeType.DIRECT, stat, (BasicBlockStatement)stat);
                        if (stat.getExprents() != null) {
                            node.exprents = stat.getExprents();
                        }
                        this.graph.nodes.putWithKey(node, node.id);
                        this.mapDestinationNodes.put(stat.id, new String[]{node.id, null});
                        lstSuccEdges.addAll(stat.getSuccessorEdges(StatEdge.EdgeType.DIRECT_ALL));
                        sourcenode = node;
                        List<Exprent> tailExprentList = statEntry.tailExprents;
                        if (tailExprentList != null) {
                            DirectNode tail = new DirectNode(DirectNode.DirectNodeType.TAIL, stat, stat.id + "_tail");
                            tail.exprents = tailExprentList;
                            this.graph.nodes.putWithKey(tail, tail.id);
                            this.mapDestinationNodes.put(-stat.id, new String[]{tail.id, null});
                            this.listEdges.add(new Edge(node.id, -stat.id, StatEdge.EdgeType.REGULAR));
                            sourcenode = tail;
                        }
                        if (stat.getLastBasicType() != Statement.StatementType.IF) break;
                        this.mapPosIfBranch.put(sourcenode.id, ((StatEdge)lstSuccEdges.get((int)0)).getDestination().id);
                        break;
                    }
                    case CATCH_ALL: 
                    case TRY_CATCH: {
                        CatchStatement catchStat;
                        DirectNode firstnd = new DirectNode(DirectNode.DirectNodeType.TRY, stat, stat.id + "_try");
                        if (stat.type == Statement.StatementType.TRY_CATCH && (catchStat = (CatchStatement)stat).getTryType() == CatchStatement.CatchStatementType.RESOURCES) {
                            firstnd.exprents = catchStat.getResources();
                        }
                        this.mapDestinationNodes.put(stat.id, new String[]{firstnd.id, null});
                        this.graph.nodes.putWithKey(firstnd, firstnd.id);
                        LinkedList<StatementStackEntry> lst = new LinkedList<StatementStackEntry>();
                        for (Object st : stat.getStats()) {
                            this.listEdges.add(new Edge(firstnd.id, ((Statement)st).id, StatEdge.EdgeType.REGULAR));
                            LinkedList<StackEntry> stack = stackFinally;
                            if (stat.type == Statement.StatementType.CATCH_ALL && ((CatchAllStatement)stat).isFinally()) {
                                stack = new LinkedList<StackEntry>(stackFinally);
                                if (st == stat.getFirst()) {
                                    stack.add(new StackEntry((CatchAllStatement)stat, Boolean.FALSE));
                                } else {
                                    stack.add(new StackEntry((CatchAllStatement)stat, Boolean.TRUE, StatEdge.EdgeType.BREAK, this.root.getDummyExit(), (Statement)st, (Statement)st, firstnd, firstnd, true));
                                }
                            }
                            lst.add(new StatementStackEntry(this, (Statement)st, stack, null));
                        }
                        lstStackStatements.addAll(0, lst);
                        break;
                    }
                    case DO: {
                        DirectNode node;
                        if (statementBreakIndex == 0) {
                            statEntry.statementIndex = 1;
                            lstStackStatements.addFirst(statEntry);
                            lstStackStatements.addFirst(new StatementStackEntry(this, stat.getFirst(), stackFinally, null));
                            continue block15;
                        }
                        DirectNode nd = this.graph.nodes.getWithKey(this.mapDestinationNodes.get(stat.getFirst().id)[0]);
                        DoStatement dostat = (DoStatement)stat;
                        DoStatement.LoopType loopType = dostat.getLoopType();
                        if (loopType == DoStatement.LoopType.DO) {
                            this.mapDestinationNodes.put(stat.id, new String[]{nd.id, nd.id});
                            break;
                        }
                        lstSuccEdges.add(stat.getSuccessorEdges(StatEdge.EdgeType.DIRECT_ALL).get(0));
                        switch (loopType) {
                            case WHILE: 
                            case DO_WHILE: {
                                node = new DirectNode(DirectNode.DirectNodeType.CONDITION, stat, stat.id + "_cond");
                                node.exprents = dostat.getConditionExprentList();
                                this.graph.nodes.putWithKey(node, node.id);
                                this.listEdges.add(new Edge(node.id, stat.getFirst().id, StatEdge.EdgeType.REGULAR));
                                if (loopType == DoStatement.LoopType.WHILE) {
                                    this.mapDestinationNodes.put(stat.id, new String[]{node.id, node.id});
                                } else {
                                    Object st;
                                    this.mapDestinationNodes.put(stat.id, new String[]{nd.id, node.id});
                                    boolean found = false;
                                    st = this.listEdges.iterator();
                                    while (st.hasNext()) {
                                        Edge edge = (Edge)st.next();
                                        if (!edge.statid.equals(stat.id) || edge.edgetype != StatEdge.EdgeType.CONTINUE) continue;
                                        found = true;
                                        break;
                                    }
                                    if (!found) {
                                        this.listEdges.add(new Edge(nd.id, stat.id, StatEdge.EdgeType.CONTINUE));
                                    }
                                }
                                sourcenode = node;
                                break;
                            }
                            case FOR: 
                            case FOREACH: {
                                DirectNode nodeinit = new DirectNode(DirectNode.DirectNodeType.INIT, stat, stat.id + "_init");
                                if (dostat.getInitExprent() != null) {
                                    nodeinit.exprents = dostat.getInitExprentList();
                                }
                                this.graph.nodes.putWithKey(nodeinit, nodeinit.id);
                                DirectNode nodecond = new DirectNode(DirectNode.DirectNodeType.CONDITION, stat, stat.id + "_cond");
                                if (loopType != DoStatement.LoopType.FOREACH) {
                                    nodecond.exprents = dostat.getConditionExprentList();
                                }
                                this.graph.nodes.putWithKey(nodecond, nodecond.id);
                                DirectNode nodeinc = new DirectNode(DirectNode.DirectNodeType.INCREMENT, stat, stat.id + "_inc");
                                nodeinc.exprents = dostat.getIncExprentList();
                                this.graph.nodes.putWithKey(nodeinc, nodeinc.id);
                                this.mapDestinationNodes.put(stat.id, new String[]{nodeinit.id, nodeinc.id});
                                this.mapDestinationNodes.put(-stat.id, new String[]{nodecond.id, null});
                                this.listEdges.add(new Edge(nodecond.id, stat.getFirst().id, StatEdge.EdgeType.REGULAR));
                                this.listEdges.add(new Edge(nodeinit.id, -stat.id, StatEdge.EdgeType.REGULAR));
                                this.listEdges.add(new Edge(nodeinc.id, -stat.id, StatEdge.EdgeType.REGULAR));
                                boolean found = false;
                                for (Edge edge : this.listEdges) {
                                    if (!edge.statid.equals(stat.id) || edge.edgetype != StatEdge.EdgeType.CONTINUE) continue;
                                    found = true;
                                    break;
                                }
                                if (!found) {
                                    this.listEdges.add(new Edge(nd.id, stat.id, StatEdge.EdgeType.CONTINUE));
                                }
                                sourcenode = nodecond;
                                break;
                            }
                        }
                        break;
                    }
                    case SYNCHRONIZED: 
                    case SWITCH: 
                    case IF: 
                    case SEQUENCE: 
                    case ROOT: {
                        int statsize = stat.getStats().size();
                        if (stat.type == Statement.StatementType.SYNCHRONIZED) {
                            statsize = 2;
                        }
                        if (statementBreakIndex > statsize) break;
                        List<Exprent> tailexprlst = switch (stat.type) {
                            case Statement.StatementType.SYNCHRONIZED -> ((SynchronizedStatement)stat).getHeadexprentList();
                            case Statement.StatementType.SWITCH -> ((SwitchStatement)stat).getHeadExprentList();
                            case Statement.StatementType.IF -> ((IfStatement)stat).getHeadexprentList();
                            default -> null;
                        };
                        int i = statementBreakIndex;
                        if (i < statsize) {
                            statEntry.statementIndex = i + 1;
                            lstStackStatements.addFirst(statEntry);
                            lstStackStatements.addFirst(new StatementStackEntry(this, (Statement)stat.getStats().get(i), stackFinally, i == 0 && tailexprlst != null && tailexprlst.get(0) != null ? tailexprlst : null));
                            continue block15;
                        }
                        DirectNode node = this.graph.nodes.getWithKey(this.mapDestinationNodes.get(stat.getFirst().id)[0]);
                        this.mapDestinationNodes.put(stat.id, new String[]{node.id, null});
                        if (stat.type != Statement.StatementType.IF || !(stat instanceof IfStatement) || ((IfStatement)stat).iftype != 0) break;
                        lstSuccEdges.add(stat.getSuccessorEdges(StatEdge.EdgeType.DIRECT_ALL).get(0));
                        sourcenode = tailexprlst != null && !tailexprlst.isEmpty() && tailexprlst.get(0) == null ? node : this.graph.nodes.getWithKey(node.id + "_tail");
                        break;
                    }
                }
            }
            if (sourcenode == null) continue;
            if (statEntry.succEdges != null) {
                lstSuccEdges = statEntry.succEdges;
            }
            int edgeindex = statEntry.edgeIndex;
            while (true) {
                boolean created;
                if (edgeindex >= lstSuccEdges.size()) continue block15;
                StatEdge edge = (StatEdge)lstSuccEdges.get(edgeindex);
                LinkedList<StackEntry> stack = new LinkedList<StackEntry>(stackFinally);
                StatEdge.EdgeType edgetype = edge.getType();
                Statement destination = edge.getDestination();
                DirectNode finallyShortRangeSource = sourcenode;
                DirectNode finallyLongRangeSource = sourcenode;
                Statement finallyShortRangeEntry = null;
                Statement finallyLongRangeEntry = null;
                boolean isFinallyMonitorExceptionPath = false;
                boolean isFinallyExit = false;
                do {
                    StackEntry entry = null;
                    if (!stack.isEmpty()) {
                        entry = stack.getLast();
                    }
                    created = true;
                    if (entry == null) {
                        this.saveEdge(sourcenode, destination, edgetype, isFinallyExit ? finallyShortRangeSource : null, finallyLongRangeSource, finallyShortRangeEntry, finallyLongRangeEntry, isFinallyMonitorExceptionPath);
                        continue;
                    }
                    CatchAllStatement catchall = entry.catchstatement;
                    if (entry.state) {
                        if (edgetype == StatEdge.EdgeType.FINALLY_EXIT) {
                            stack.removeLast();
                            destination = entry.destination;
                            edgetype = entry.edgetype;
                            finallyShortRangeSource = entry.finallyShortRangeSource;
                            finallyLongRangeSource = entry.finallyLongRangeSource;
                            finallyShortRangeEntry = entry.finallyShortRangeEntry;
                            finallyLongRangeEntry = entry.finallyLongRangeEntry;
                            isFinallyExit = true;
                            isFinallyMonitorExceptionPath = catchall.getMonitor() != null & entry.isFinallyExceptionPath;
                            created = false;
                            continue;
                        }
                        if (!catchall.containsStatementStrict(destination)) {
                            stack.removeLast();
                            created = false;
                            continue;
                        }
                        this.saveEdge(sourcenode, destination, edgetype, isFinallyExit ? finallyShortRangeSource : null, finallyLongRangeSource, finallyShortRangeEntry, finallyLongRangeEntry, isFinallyMonitorExceptionPath);
                        continue;
                    }
                    if (!catchall.containsStatementStrict(destination)) {
                        this.saveEdge(sourcenode, catchall.getHandler(), StatEdge.EdgeType.REGULAR, isFinallyExit ? finallyShortRangeSource : null, finallyLongRangeSource, finallyShortRangeEntry, finallyLongRangeEntry, isFinallyMonitorExceptionPath);
                        stack.removeLast();
                        stack.add(new StackEntry(catchall, Boolean.TRUE, edgetype, destination, catchall.getHandler(), finallyLongRangeEntry == null ? catchall.getHandler() : finallyLongRangeEntry, sourcenode, finallyLongRangeSource, false));
                        statEntry.edgeIndex = edgeindex + 1;
                        statEntry.succEdges = lstSuccEdges;
                        lstStackStatements.addFirst(statEntry);
                        lstStackStatements.addFirst(new StatementStackEntry(this, catchall.getHandler(), stack, null));
                        continue block15;
                    }
                    this.saveEdge(sourcenode, destination, edgetype, isFinallyExit ? finallyShortRangeSource : null, finallyLongRangeSource, finallyShortRangeEntry, finallyLongRangeEntry, isFinallyMonitorExceptionPath);
                } while (!created);
                ++edgeindex;
            }
            break;
        }
        return;
    }

    private void saveEdge(DirectNode sourcenode, Statement destination, StatEdge.EdgeType edgetype, DirectNode finallyShortRangeSource, DirectNode finallyLongRangeSource, Statement finallyShortRangeEntry, Statement finallyLongRangeEntry, boolean isFinallyMonitorExceptionPath) {
        if (edgetype != StatEdge.EdgeType.FINALLY_EXIT) {
            this.listEdges.add(new Edge(sourcenode.id, destination.id, edgetype));
        }
        if (finallyShortRangeSource != null) {
            boolean isContinueEdge = edgetype == StatEdge.EdgeType.CONTINUE;
            this.mapShortRangeFinallyPathIds.computeIfAbsent(sourcenode.id, k -> new ArrayList()).add(new String[]{finallyShortRangeSource.id, Integer.toString(destination.id), Integer.toString(finallyShortRangeEntry.id), isFinallyMonitorExceptionPath ? "1" : null, isContinueEdge ? "1" : null});
            this.mapLongRangeFinallyPathIds.computeIfAbsent(sourcenode.id, k -> new ArrayList()).add(new String[]{finallyLongRangeSource.id, Integer.toString(destination.id), Integer.toString(finallyLongRangeEntry.id), isContinueEdge ? "1" : null});
        }
    }

    private void setEdges() {
        for (Edge edge : this.listEdges) {
            String sourceid = edge.sourceid;
            Integer statid = edge.statid;
            DirectNode source = this.graph.nodes.getWithKey(sourceid);
            DirectNode dest = this.graph.nodes.getWithKey(this.mapDestinationNodes.get(statid)[edge.edgetype == StatEdge.EdgeType.CONTINUE ? 1 : 0]);
            if (!source.successors.contains(dest)) {
                source.successors.add(dest);
            }
            if (!dest.predecessors.contains(source)) {
                dest.predecessors.add(source);
            }
            if (!this.mapPosIfBranch.containsKey(sourceid) || statid.equals(this.mapPosIfBranch.get(sourceid))) continue;
            this.graph.mapNegIfBranch.put(sourceid, dest.id);
        }
        for (int i = 0; i < 2; ++i) {
            for (Map.Entry<String, List<String[]>> ent : (i == 0 ? this.mapShortRangeFinallyPathIds : this.mapLongRangeFinallyPathIds).entrySet()) {
                ArrayList<FinallyPathWrapper> newLst = new ArrayList<FinallyPathWrapper>();
                List<String[]> lst = ent.getValue();
                for (String[] arr : lst) {
                    boolean isContinueEdge = arr[i == 0 ? 4 : 3] != null;
                    DirectNode dest = this.graph.nodes.getWithKey(this.mapDestinationNodes.get(Integer.parseInt(arr[1]))[isContinueEdge ? 1 : 0]);
                    DirectNode enter = this.graph.nodes.getWithKey(this.mapDestinationNodes.get(Integer.parseInt(arr[2]))[0]);
                    newLst.add(new FinallyPathWrapper(arr[0], dest.id, enter.id));
                    if (i != 0 || arr[3] == null) continue;
                    this.graph.mapFinallyMonitorExceptionPathExits.put(ent.getKey(), dest.id);
                }
                if (newLst.isEmpty()) continue;
                (i == 0 ? this.graph.mapShortRangeFinallyPaths : this.graph.mapLongRangeFinallyPaths).put(ent.getKey(), new ArrayList(new HashSet(newLst)));
            }
        }
    }

    public Map<Integer, String[]> getMapDestinationNodes() {
        return this.mapDestinationNodes;
    }

    private static class Edge {
        public final String sourceid;
        public final Integer statid;
        public final StatEdge.EdgeType edgetype;

        Edge(String sourceid, Integer statid, StatEdge.EdgeType edgetype) {
            this.sourceid = sourceid;
            this.statid = statid;
            this.edgetype = edgetype;
        }
    }

    private static class StackEntry {
        public final CatchAllStatement catchstatement;
        public final boolean state;
        public final StatEdge.EdgeType edgetype;
        public final boolean isFinallyExceptionPath;
        public final Statement destination;
        public final Statement finallyShortRangeEntry;
        public final Statement finallyLongRangeEntry;
        public final DirectNode finallyShortRangeSource;
        public final DirectNode finallyLongRangeSource;

        StackEntry(CatchAllStatement catchstatement, boolean state, StatEdge.EdgeType edgetype, Statement destination, Statement finallyShortRangeEntry, Statement finallyLongRangeEntry, DirectNode finallyShortRangeSource, DirectNode finallyLongRangeSource, boolean isFinallyExceptionPath) {
            this.catchstatement = catchstatement;
            this.state = state;
            this.edgetype = edgetype;
            this.isFinallyExceptionPath = isFinallyExceptionPath;
            this.destination = destination;
            this.finallyShortRangeEntry = finallyShortRangeEntry;
            this.finallyLongRangeEntry = finallyLongRangeEntry;
            this.finallyShortRangeSource = finallyShortRangeSource;
            this.finallyLongRangeSource = finallyLongRangeSource;
        }

        StackEntry(CatchAllStatement catchstatement, boolean state) {
            this(catchstatement, state, StatEdge.EdgeType.NULL, null, null, null, null, null, false);
        }
    }

    public static final class FinallyPathWrapper {
        public final String source;
        public final String destination;
        public final String entry;

        private FinallyPathWrapper(String source, String destination, String entry) {
            this.source = source;
            this.destination = destination;
            this.entry = entry;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FinallyPathWrapper)) {
                return false;
            }
            FinallyPathWrapper fpw = (FinallyPathWrapper)o;
            return (this.source + ":" + this.destination + ":" + this.entry).equals(fpw.source + ":" + fpw.destination + ":" + fpw.entry);
        }

        public int hashCode() {
            return (this.source + ":" + this.destination + ":" + this.entry).hashCode();
        }

        public String toString() {
            return this.source + "->(" + this.entry + ")->" + this.destination;
        }
    }
}

