/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.completion;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementWeigher;
import com.intellij.codeInsight.lookup.WeighingContext;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMember;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.plugins.gradle.service.resolve.UtilKt;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/plugins/gradle/service/completion/GradleLookupWeigher;", "Lcom/intellij/codeInsight/lookup/LookupElementWeigher;", "<init>", "()V", "weigh", "", "element", "Lcom/intellij/codeInsight/lookup/LookupElement;", "context", "Lcom/intellij/codeInsight/lookup/WeighingContext;", "getFallbackCompletionPriority", "", "holder", "Lcom/intellij/openapi/util/UserDataHolder;", "Companion", "intellij.gradle.java"})
@SourceDebugExtension(value={"SMAP\nGradleLookupWeigher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleLookupWeigher.kt\norg/jetbrains/plugins/gradle/service/completion/GradleLookupWeigher\n+ 2 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,54:1\n19#2:55\n19#2:56\n19#2:57\n*S KotlinDebug\n*F\n+ 1 GradleLookupWeigher.kt\norg/jetbrains/plugins/gradle/service/completion/GradleLookupWeigher\n*L\n21#1:55\n22#1:56\n34#1:57\n*E\n"})
public final class GradleLookupWeigher
extends LookupElementWeigher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int DEFAULT_COMPLETION_PRIORITY = 100;
    @NotNull
    private static final Key<Integer> COMPLETION_PRIORITY;

    public GradleLookupWeigher() {
        super("gradleWeigher", true, false);
    }

    @NotNull
    public Comparable<?> weigh(@NotNull LookupElement element, @NotNull WeighingContext context) {
        int n;
        UserDataHolder userDataHolder;
        Object completionElement;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Object object = element.getObject();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getObject(...)");
        Object $this$asSafely$iv = completionElement = object;
        boolean $i$f$asSafely = false;
        Object object2 = $this$asSafely$iv;
        if (!(object2 instanceof UserDataHolder)) {
            object2 = null;
        }
        if ((userDataHolder = (UserDataHolder)object2) == null) {
            Object $this$asSafely$iv2 = completionElement;
            boolean $i$f$asSafely2 = false;
            Object object3 = $this$asSafely$iv2;
            if (!(object3 instanceof GroovyResolveResult)) {
                object3 = null;
            }
            GroovyResolveResult groovyResolveResult = (GroovyResolveResult)object3;
            Object object4 = groovyResolveResult != null ? groovyResolveResult.getElement() : null;
            if (object4 != null) {
                userDataHolder = (UserDataHolder)object4;
            } else {
                return 0;
            }
        }
        UserDataHolder holder = userDataHolder;
        Integer n2 = (Integer)element.getUserData(COMPLETION_PRIORITY);
        if (n2 != null) {
            n = n2;
        } else {
            Integer n3 = (Integer)holder.getUserData(COMPLETION_PRIORITY);
            n = n3 != null ? n3.intValue() : this.getFallbackCompletionPriority(holder);
        }
        int comparable = n;
        PsiElement psiElement = element.getPsiElement();
        double deprecationMultiplier = (psiElement != null ? (List)psiElement.getUserData(UtilKt.DECLARATION_ALTERNATIVES) : null) != null ? 0.9 : 1.0;
        return (int)((double)comparable * deprecationMultiplier);
    }

    private final int getFallbackCompletionPriority(UserDataHolder holder) {
        PsiFile containingFile;
        if (!(holder instanceof PsiMember)) {
            return 0;
        }
        Object object = ((PsiMember)holder).getContainingFile();
        if (object == null) {
            PsiMember psiMember;
            UserDataHolder $this$asSafely$iv = holder;
            boolean $i$f$asSafely = false;
            UserDataHolder userDataHolder = $this$asSafely$iv;
            if (!(userDataHolder instanceof PsiMember)) {
                userDataHolder = null;
            }
            object = (psiMember = (PsiMember)userDataHolder) != null && (psiMember = psiMember.getContainingClass()) != null ? psiMember.getContainingFile() : null;
        }
        if ((containingFile = object) instanceof PsiJavaFile) {
            String string = ((PsiJavaFile)containingFile).getPackageName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPackageName(...)");
            if (StringsKt.startsWith$default((String)string, (String)"org.gradle", (boolean)false, (int)2, null)) {
                return 100;
            }
        }
        return 0;
    }

    @JvmStatic
    public static final void setGradleCompletionPriority(@NotNull UserDataHolder element, int priority) {
        Companion.setGradleCompletionPriority(element, priority);
    }

    static {
        Key key = Key.create((String)"grouping priority for gradle completion results");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        COMPLETION_PRIORITY = key;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u0017\u0010\r\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a2\u0006\u0002\u0010\u000eR\u000e\u0010\n\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/plugins/gradle/service/completion/GradleLookupWeigher$Companion;", "", "<init>", "()V", "setGradleCompletionPriority", "", "element", "Lcom/intellij/openapi/util/UserDataHolder;", "priority", "", "DEFAULT_COMPLETION_PRIORITY", "COMPLETION_PRIORITY", "Lcom/intellij/openapi/util/Key;", "getGradleCompletionPriority", "(Lcom/intellij/openapi/util/UserDataHolder;)Ljava/lang/Integer;", "intellij.gradle.java"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void setGradleCompletionPriority(@NotNull UserDataHolder element, int priority) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            element.putUserData(COMPLETION_PRIORITY, (Object)priority);
        }

        @TestOnly
        @Nullable
        public final Integer getGradleCompletionPriority(@NotNull UserDataHolder element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            return (Integer)element.getUserData(COMPLETION_PRIORITY);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

