/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.generic;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.tasks.Task;
import com.intellij.tasks.generic.GenericRepository;
import com.intellij.tasks.generic.GenericTask;
import com.intellij.tasks.generic.HighlightedSelectorsTable;
import com.intellij.tasks.generic.ResponseHandler;
import com.intellij.tasks.generic.Selector;
import com.intellij.tasks.impl.TaskUtil;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.xmlb.annotations.XCollection;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SelectorBasedResponseHandler
extends ResponseHandler {
    private static final Logger LOG = Logger.getInstance(SelectorBasedResponseHandler.class);
    @NonNls
    protected static final String TASKS = "tasks";
    @NonNls
    protected static final String SUMMARY = "summary";
    @NonNls
    protected static final String DESCRIPTION = "description";
    @NonNls
    protected static final String ISSUE_URL = "issueUrl";
    @NonNls
    protected static final String CLOSED = "closed";
    @NonNls
    protected static final String UPDATED = "updated";
    @NonNls
    protected static final String CREATED = "created";
    @NonNls
    protected static final String SINGLE_TASK_ID = "singleTask-id";
    @NonNls
    protected static final String SINGLE_TASK_SUMMARY = "singleTask-summary";
    @NonNls
    protected static final String SINGLE_TASK_DESCRIPTION = "singleTask-description";
    @NonNls
    protected static final String SINGLE_TASK_ISSUE_URL = "singleTask-issueUrl";
    @NonNls
    protected static final String SINGLE_TASK_CLOSED = "singleTask-closed";
    @NonNls
    protected static final String SINGLE_TASK_UPDATED = "singleTask-updated";
    @NonNls
    protected static final String SINGLE_TASK_CREATED = "singleTask-created";
    @NonNls
    protected static final String ID = "id";
    protected LinkedHashMap<String, Selector> selectors;

    protected SelectorBasedResponseHandler() {
        this.selectors = new LinkedHashMap();
    }

    protected SelectorBasedResponseHandler(@NotNull GenericRepository repository) {
        if (repository == null) {
            SelectorBasedResponseHandler.$$$reportNull$$$0(0);
        }
        super(repository);
        this.selectors = new LinkedHashMap();
        this.setSelectors(List.of(new Selector(TASKS), new Selector(ID), new Selector(SUMMARY), new Selector(DESCRIPTION), new Selector(UPDATED), new Selector(CREATED), new Selector(CLOSED), new Selector(ISSUE_URL), new Selector(SINGLE_TASK_ID), new Selector(SINGLE_TASK_SUMMARY), new Selector(SINGLE_TASK_DESCRIPTION), new Selector(SINGLE_TASK_UPDATED), new Selector(SINGLE_TASK_CREATED), new Selector(SINGLE_TASK_CLOSED), new Selector(SINGLE_TASK_ISSUE_URL)));
    }

    @XCollection(propertyElementName="selectors")
    @NotNull
    public List<Selector> getSelectors() {
        return new ArrayList<Selector>(this.selectors.values());
    }

    public void setSelectors(@NotNull List<Selector> selectors) {
        if (selectors == null) {
            SelectorBasedResponseHandler.$$$reportNull$$$0(1);
        }
        this.selectors.clear();
        for (Selector selector : selectors) {
            this.selectors.put(selector.getName(), selector);
        }
    }

    @NotNull
    protected Selector getSelector(@NotNull String name) {
        if (name == null) {
            SelectorBasedResponseHandler.$$$reportNull$$$0(2);
        }
        Selector selector = this.selectors.get(name);
        if (selector == null) {
            SelectorBasedResponseHandler.$$$reportNull$$$0(3);
        }
        return selector;
    }

    @NotNull
    protected String getSelectorPath(@NotNull String name) {
        if (name == null) {
            SelectorBasedResponseHandler.$$$reportNull$$$0(4);
        }
        String string = this.getSelector(name).getPath();
        if (string == null) {
            SelectorBasedResponseHandler.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    @NotNull
    public JComponent getConfigurationComponent(@NotNull Project project) {
        if (project == null) {
            SelectorBasedResponseHandler.$$$reportNull$$$0(6);
        }
        FileType fileType = this.getResponseType().getSelectorFileType();
        HighlightedSelectorsTable table = new HighlightedSelectorsTable(fileType, project, this.getSelectors());
        return new JBScrollPane((Component)((Object)table));
    }

    @Override
    public SelectorBasedResponseHandler clone() {
        SelectorBasedResponseHandler clone = (SelectorBasedResponseHandler)super.clone();
        clone.selectors = new LinkedHashMap(this.selectors.size());
        for (Selector selector : this.selectors.values()) {
            clone.selectors.put(selector.getName(), selector.clone());
        }
        return clone;
    }

    @Override
    public boolean isConfigured() {
        Selector idSelector = this.getSelector(ID);
        if (StringUtil.isEmpty((String)idSelector.getPath())) {
            return false;
        }
        Selector summarySelector = this.getSelector(SUMMARY);
        return !StringUtil.isEmpty((String)summarySelector.getPath()) || this.repository.getDownloadTasksInSeparateRequests();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SelectorBasedResponseHandler)) {
            return false;
        }
        SelectorBasedResponseHandler handler = (SelectorBasedResponseHandler)o;
        return this.selectors.equals(handler.selectors);
    }

    public int hashCode() {
        return this.selectors.hashCode();
    }

    @Override
    public final Task @NotNull [] parseIssues(@NotNull String response, int max) throws Exception {
        if (response == null) {
            SelectorBasedResponseHandler.$$$reportNull$$$0(7);
        }
        if (StringUtil.isEmpty((String)this.getSelectorPath(TASKS)) || StringUtil.isEmpty((String)this.getSelectorPath(ID)) || StringUtil.isEmpty((String)this.getSelectorPath(SUMMARY)) && !this.repository.getDownloadTasksInSeparateRequests()) {
            throw new Exception("Selectors 'tasks', 'id' and 'summary' are mandatory");
        }
        List<Object> tasks = this.selectTasksList(response, max);
        LOG.debug(String.format("Total %d tasks extracted from response", tasks.size()));
        ArrayList<GenericTask> result = new ArrayList<GenericTask>(tasks.size());
        for (Object context : tasks) {
            GenericTask task;
            String id = this.selectString(this.getSelector(ID), context);
            if (this.repository.getDownloadTasksInSeparateRequests()) {
                task = new GenericTask(id, "", this.repository);
            } else {
                Date created;
                Date updated;
                Boolean closed;
                String issueUrl;
                String summary = this.selectString(this.getSelector(SUMMARY), context);
                assert (id != null && summary != null);
                task = new GenericTask(id, summary, this.repository);
                String description = this.selectString(this.getSelector(DESCRIPTION), context);
                if (description != null) {
                    task.setDescription(description);
                }
                if ((issueUrl = this.selectString(this.getSelector(ISSUE_URL), context)) != null) {
                    task.setIssueUrl(issueUrl);
                }
                if ((closed = this.selectBoolean(this.getSelector(CLOSED), context)) != null) {
                    task.setClosed(closed);
                }
                if ((updated = this.selectDate(this.getSelector(UPDATED), context)) != null) {
                    task.setUpdated(updated);
                }
                if ((created = this.selectDate(this.getSelector(CREATED), context)) != null) {
                    task.setCreated(created);
                }
            }
            result.add(task);
        }
        Task[] taskArray = result.toArray(Task.EMPTY_ARRAY);
        if (taskArray == null) {
            SelectorBasedResponseHandler.$$$reportNull$$$0(8);
        }
        return taskArray;
    }

    @Nullable
    private Date selectDate(@NotNull Selector selector, @NotNull Object context) throws Exception {
        String s;
        if (selector == null) {
            SelectorBasedResponseHandler.$$$reportNull$$$0(9);
        }
        if (context == null) {
            SelectorBasedResponseHandler.$$$reportNull$$$0(10);
        }
        if ((s = this.selectString(selector, context)) == null) {
            return null;
        }
        return TaskUtil.parseDate((String)s);
    }

    @Nullable
    protected Boolean selectBoolean(@NotNull Selector selector, @NotNull Object context) throws Exception {
        String s;
        if (selector == null) {
            SelectorBasedResponseHandler.$$$reportNull$$$0(11);
        }
        if (context == null) {
            SelectorBasedResponseHandler.$$$reportNull$$$0(12);
        }
        if ((s = this.selectString(selector, context)) == null) {
            return null;
        }
        if ((s = StringUtil.toLowerCase((String)s.trim())).equals("true")) {
            return true;
        }
        if (s.equals("false")) {
            return false;
        }
        throw new Exception(String.format("Expression '%s' should match boolean value. Got '%s' instead", selector.getName(), s));
    }

    @NotNull
    protected abstract List<Object> selectTasksList(@NotNull String var1, int var2) throws Exception;

    @Nullable
    @Nls
    protected abstract String selectString(@NotNull Selector var1, @NotNull Object var2) throws Exception;

    @Override
    @NotNull
    public final Task parseIssue(@NotNull String response) throws Exception {
        Date created;
        Date updated;
        Boolean closed;
        String issueUrl;
        if (response == null) {
            SelectorBasedResponseHandler.$$$reportNull$$$0(13);
        }
        if (StringUtil.isEmpty((String)this.getSelectorPath(SINGLE_TASK_ID)) || StringUtil.isEmpty((String)this.getSelectorPath(SINGLE_TASK_SUMMARY))) {
            throw new Exception("Selectors 'singleTask-id' and 'singleTask-summary' are mandatory");
        }
        String id = this.selectString(this.getSelector(SINGLE_TASK_ID), response);
        String summary = this.selectString(this.getSelector(SINGLE_TASK_SUMMARY), response);
        assert (id != null && summary != null);
        GenericTask task = new GenericTask(id, summary, this.repository);
        String description = this.selectString(this.getSelector(SINGLE_TASK_DESCRIPTION), response);
        if (description != null) {
            task.setDescription(description);
        }
        if ((issueUrl = this.selectString(this.getSelector(SINGLE_TASK_ISSUE_URL), response)) != null) {
            task.setIssueUrl(issueUrl);
        }
        if ((closed = this.selectBoolean(this.getSelector(SINGLE_TASK_CLOSED), response)) != null) {
            task.setClosed(closed);
        }
        if ((updated = this.selectDate(this.getSelector(SINGLE_TASK_UPDATED), response)) != null) {
            task.setUpdated(updated);
        }
        if ((created = this.selectDate(this.getSelector(SINGLE_TASK_CREATED), response)) != null) {
            task.setCreated(created);
        }
        GenericTask genericTask = task;
        if (genericTask == null) {
            SelectorBasedResponseHandler.$$$reportNull$$$0(14);
        }
        return genericTask;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 5, 8, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectors";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/tasks/generic/SelectorBasedResponseHandler";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "response";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selector";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/tasks/generic/SelectorBasedResponseHandler";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelector";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectorPath";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "parseIssues";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "parseIssue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setSelectors";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSelector";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 14: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSelectorPath";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getConfigurationComponent";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "parseIssues";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "selectDate";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "selectBoolean";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "parseIssue";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 5, 8, 14 -> new IllegalStateException(string);
        };
    }
}

