/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.util.introspection;

import java.lang.reflect.Method;
import java.util.Objects;
import org.assertj.core.util.Preconditions;

public class MethodSupport {
    private static final String METHOD_HAS_NO_RETURN_VALUE = "Method '%s' in class %s.class has to return a value!";
    private static final String METHOD_NOT_FOUND = "Can't find method '%s' in class %s.class. Make sure public method exists and accepts no arguments!";

    public static Object methodResultFor(Object instance, String methodName) {
        Objects.requireNonNull(instance, "Object instance can not be null!");
        Preconditions.checkNotNullOrEmpty(methodName, "Method name can not be empty!");
        Method method = MethodSupport.findMethod(methodName, instance.getClass());
        return MethodSupport.invokeMethod(instance, method);
    }

    private static Object invokeMethod(Object item, Method method) {
        try {
            return method.invoke(item, new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private static Method findMethod(String methodName, Class<?> itemClass) {
        try {
            Method method = itemClass.getMethod(methodName, new Class[0]);
            MethodSupport.assertHasReturnType(itemClass, method);
            return method;
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw MethodSupport.prepareMethodNotFoundException(methodName, itemClass, e);
        }
    }

    private static IllegalArgumentException prepareMethodNotFoundException(String methodName, Class<?> itemClass, Exception cause) {
        String message = METHOD_NOT_FOUND.formatted(methodName, itemClass.getSimpleName());
        return new IllegalArgumentException(message, cause);
    }

    private static void assertHasReturnType(Class<?> itemClass, Method method) {
        Preconditions.checkArgument(!Void.TYPE.equals(method.getReturnType()), METHOD_HAS_NO_RETURN_VALUE, method.getName(), itemClass.getSimpleName());
    }
}

