/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.util;

import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.SelectionModel;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.EditMaximizedView;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.actionSystem.impl.ActionToolbarImpl;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.ui.InplaceButton;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.InputEvent;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DataGridUIUtil {
    public static Color softHighlightOf(Color c1) {
        if (c1 == null) {
            return null;
        }
        int i = 16;
        return new JBColor(new Color(Math.max(0, c1.getRed() - i), Math.max(0, c1.getGreen() - i), Math.max(0, c1.getBlue() - i)), new Color(Math.min(255, c1.getRed() + i), Math.min(255, c1.getGreen() + i), Math.min(255, c1.getBlue() + i)));
    }

    @NotNull
    public static Color toGrayscale(@NotNull Color color) {
        if (color == null) {
            DataGridUIUtil.$$$reportNull$$$0(0);
        }
        float avg = 0.3f * (float)color.getRed() / 255.0f + 0.59f * (float)color.getBlue() / 255.0f + 0.11f * (float)color.getGreen() / 255.0f;
        return new Color(avg, avg, avg);
    }

    public static void showPopup(@NotNull JBPopup popup, @Nullable Editor editor, @Nullable AnActionEvent event) {
        Object eventSource;
        if (popup == null) {
            DataGridUIUtil.$$$reportNull$$$0(1);
        }
        InputEvent inputEvent = event == null ? null : event.getInputEvent();
        Object object = eventSource = inputEvent == null ? null : inputEvent.getSource();
        if (editor != null && editor.getComponent().isShowing()) {
            popup.showInBestPositionFor(editor);
        } else if (event != null) {
            if (eventSource instanceof InplaceButton || eventSource instanceof ActionButton) {
                popup.setMinimumSize(((JComponent)eventSource).getSize());
                popup.showUnderneathOf((Component)eventSource);
            } else {
                popup.showInBestPositionFor(event.getDataContext());
            }
        }
    }

    public static void updateAllToolbarsUnder(Component component) {
        UIUtil.uiTraverser((Component)component).filter(ActionToolbarImpl.class).forEach(ActionToolbarImpl::updateActionsImmediately);
    }

    public static boolean inCell(@NotNull DataGrid grid, @NotNull AnActionEvent e) {
        Component contextComponent;
        if (grid == null) {
            DataGridUIUtil.$$$reportNull$$$0(2);
        }
        if (e == null) {
            DataGridUIUtil.$$$reportNull$$$0(3);
        }
        return (contextComponent = (Component)e.getData(PlatformCoreDataKeys.CONTEXT_COMPONENT)) == grid.getResultView().getComponent();
    }

    @Nullable
    public static Object getLeadSelectionCellValue(@NotNull DataGrid grid, @NotNull AnActionEvent e, boolean single) {
        if (grid == null) {
            DataGridUIUtil.$$$reportNull$$$0(4);
        }
        if (e == null) {
            DataGridUIUtil.$$$reportNull$$$0(5);
        }
        SelectionModel selectionModel = grid.getSelectionModel();
        if (!single || selectionModel.getSelectedRowCount() == 1 && selectionModel.getSelectedColumnCount() == 1) {
            ModelIndex row = selectionModel.getLeadSelectionRow();
            ModelIndex column = selectionModel.getLeadSelectionColumn();
            return row.asInteger() == -1 || column.asInteger() == -1 ? null : grid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS).getValueAt(row, column);
        }
        return null;
    }

    public static boolean isInsideGrid(@NotNull DataGrid grid, @NotNull Component component) {
        if (grid == null) {
            DataGridUIUtil.$$$reportNull$$$0(6);
        }
        if (component == null) {
            DataGridUIUtil.$$$reportNull$$$0(7);
        }
        return SwingUtilities.isDescendingFrom(component, grid.getPreferredFocusedComponent());
    }

    public static boolean isInsideEditMaximizedView(@Nullable EditMaximizedView view, @NotNull Component component) {
        if (component == null) {
            DataGridUIUtil.$$$reportNull$$$0(8);
        }
        return view != null && SwingUtilities.isDescendingFrom(component, view.getPreferedFocusComponent());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "color";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popup";
                break;
            }
            case 2: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        objectArray2[1] = "com/intellij/database/util/DataGridUIUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "toGrayscale";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "showPopup";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "inCell";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getLeadSelectionCellValue";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isInsideGrid";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "isInsideEditMaximizedView";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

