/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.testng.ITestNGMethod;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.internal.MethodGroupsHelper;
import org.testng.internal.MethodHelper;
import org.testng.internal.Utils;

public class MethodInheritance {
    private static final Comparator<ITestNGMethod> COMPARATOR = (o1, o2) -> {
        Class otherClass;
        int result = -2;
        Class thisClass = o1.getRealClass();
        if (thisClass.isAssignableFrom(otherClass = o2.getRealClass())) {
            result = -1;
        } else if (otherClass.isAssignableFrom(thisClass)) {
            result = 1;
        } else if (o1.equals(o2)) {
            result = 0;
        }
        return result;
    };

    private static List<ITestNGMethod> findMethodListSuperClass(Map<Class<?>, List<ITestNGMethod>> map, Class<? extends ITestNGMethod> methodClass) {
        return ((Stream)map.entrySet().stream().parallel()).filter(each -> ((Class)each.getKey()).isAssignableFrom(methodClass)).map(Map.Entry::getValue).findFirst().orElse(null);
    }

    private static Class<?> findSubClass(Map<Class<?>, List<ITestNGMethod>> map, Class<? extends ITestNGMethod> methodClass) {
        return ((Stream)map.keySet().stream().parallel()).filter(methodClass::isAssignableFrom).findFirst().orElse(null);
    }

    public static void fixMethodInheritance(ITestNGMethod[] methods, boolean before) {
        Map<Class<?>, List<ITestNGMethod>> map = Maps.newHashMap();
        for (ITestNGMethod method : methods) {
            Class methodClass = method.getRealClass();
            List<ITestNGMethod> l2 = MethodInheritance.findMethodListSuperClass(map, methodClass);
            if (null != l2) {
                l2.add(method);
                continue;
            }
            Class<?> subClass = MethodInheritance.findSubClass(map, methodClass);
            if (null != subClass) {
                l2 = map.get(subClass);
                l2.add(method);
                map.remove(subClass);
                map.put(methodClass, l2);
                continue;
            }
            l2 = Lists.newArrayList();
            l2.add(method);
            map.put(methodClass, l2);
        }
        map.values().parallelStream().filter(l -> l.size() > 1).forEach(l -> {
            MethodInheritance.sortMethodsByInheritance(l, before);
            for (int i = 0; i < l.size() - 1; ++i) {
                ITestNGMethod m1 = (ITestNGMethod)l.get(i);
                for (int j = i + 1; j < l.size(); ++j) {
                    boolean hasGroupDependencies;
                    ITestNGMethod m2 = (ITestNGMethod)l.get(j);
                    boolean notEffectivelyEqual = !MethodInheritance.equalsEffectiveClass(m1, m2);
                    boolean upstreamHierarchy = MethodInheritance.hasUpstreamHierarchy(m1, m2);
                    boolean shouldConsider = before ? notEffectivelyEqual && upstreamHierarchy : notEffectivelyEqual;
                    boolean bl = hasGroupDependencies = m2.getGroupsDependedUpon().length == 0 && m1.getGroupsDependedUpon().length == 0;
                    if (!shouldConsider || MethodInheritance.dependencyExists(m1, m2, methods) || !hasGroupDependencies) continue;
                    Utils.log("MethodInheritance", 4, m2 + " DEPENDS ON " + m1);
                    m2.addMethodDependedUpon(MethodHelper.calculateMethodCanonicalName(m1));
                }
            }
        });
    }

    private static boolean hasUpstreamHierarchy(ITestNGMethod m1, ITestNGMethod m2) {
        Class c2;
        Class c1 = m1.getRealClass();
        if (c1.equals(c2 = m2.getRealClass())) {
            return false;
        }
        return c1.isAssignableFrom(c2);
    }

    private static boolean dependencyExists(ITestNGMethod m1, ITestNGMethod m2, ITestNGMethod[] methods) {
        return MethodInheritance.internalDependencyExists(m1, m2, methods) || MethodInheritance.internalDependencyExists(m2, m1, methods);
    }

    private static boolean internalDependencyExists(ITestNGMethod m1, ITestNGMethod m2, ITestNGMethod[] methods) {
        ITestNGMethod[] methodsNamed = MethodHelper.findDependedUponMethods(m1, methods);
        boolean match = ((Stream)Arrays.stream(methodsNamed).parallel()).anyMatch(method -> method.equals(m2));
        if (match) {
            return true;
        }
        return ((Stream)Arrays.stream(m1.getGroupsDependedUpon()).parallel()).anyMatch(group -> {
            ITestNGMethod[] methodsThatBelongToGroup = MethodGroupsHelper.findMethodsThatBelongToGroup(m1, methods, group);
            return ((Stream)Arrays.stream(methodsThatBelongToGroup).parallel()).anyMatch(method -> method.equals(m2));
        });
    }

    private static boolean equalsEffectiveClass(ITestNGMethod m1, ITestNGMethod m2) {
        try {
            Class c1 = m1.getRealClass();
            Class c2 = m2.getRealClass();
            return Objects.equals(c1, c2);
        }
        catch (Exception ex) {
            return false;
        }
    }

    private static void sortMethodsByInheritance(List<ITestNGMethod> methods, boolean baseClassToChild) {
        methods.sort(COMPARATOR);
        if (!baseClassToChild) {
            Collections.reverse(methods);
        }
    }
}

