/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.gradle.scripting.shared.roots;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.gist.storage.GistStorage;
import com.intellij.util.io.DataExternalizer;
import java.io.DataInput;
import java.io.DataOutput;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.gradle.scripting.shared.LastModifiedFiles;
import org.jetbrains.kotlin.gradle.scripting.shared.roots.GradleBuildRootData;
import org.jetbrains.kotlin.gradle.scripting.shared.roots.GradleBuildRootDataSerializerKt;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 \u00132\u00020\u0001:\u0002\u0012\u0013B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\f\u001a\u0004\u0018\u00010\t2\u0006\u0010\r\u001a\u00020\u0006J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u00062\b\u0010\u0010\u001a\u0004\u0018\u00010\tJ\u000e\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u0006R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0007\u001a\u0015\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t0\b\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/gradle/scripting/shared/roots/GradleBuildRootDataSerializer;", "", "<init>", "()V", "currentBuildRoot", "Ljava/lang/ThreadLocal;", "Lcom/intellij/openapi/vfs/VirtualFile;", "buildRootDataGist", "Lcom/intellij/util/gist/storage/GistStorage$Gist;", "Lorg/jetbrains/kotlin/gradle/scripting/shared/roots/GradleBuildRootData;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "read", "buildRoot", "write", "", "data", "remove", "Externalizer", "Companion", "kotlin.gradle.scripting.shared"})
public final class GradleBuildRootDataSerializer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ThreadLocal<VirtualFile> currentBuildRoot = new ThreadLocal();
    @NotNull
    private final GistStorage.Gist<GradleBuildRootData> buildRootDataGist;

    public GradleBuildRootDataSerializer() {
        GistStorage.Gist gist = GistStorage.getInstance().newGist("GradleBuildRootData", 1, (DataExternalizer)new Externalizer());
        Intrinsics.checkNotNullExpressionValue((Object)gist, (String)"newGist(...)");
        this.buildRootDataGist = gist;
    }

    @Nullable
    public final GradleBuildRootData read(@NotNull VirtualFile buildRoot) {
        Intrinsics.checkNotNullParameter((Object)buildRoot, (String)"buildRoot");
        this.currentBuildRoot.set(buildRoot);
        return (GradleBuildRootData)this.buildRootDataGist.getGlobalData(buildRoot, 0).data();
    }

    public final void write(@NotNull VirtualFile buildRoot, @Nullable GradleBuildRootData data) {
        Intrinsics.checkNotNullParameter((Object)buildRoot, (String)"buildRoot");
        this.currentBuildRoot.set(buildRoot);
        this.buildRootDataGist.putGlobalData(buildRoot, (Object)data, 0);
    }

    public final void remove(@NotNull VirtualFile buildRoot) {
        Intrinsics.checkNotNullParameter((Object)buildRoot, (String)"buildRoot");
        this.write(buildRoot, null);
        LastModifiedFiles.Companion.remove(buildRoot);
    }

    @JvmStatic
    @NotNull
    public static final GradleBuildRootDataSerializer getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/gradle/scripting/shared/roots/GradleBuildRootDataSerializer$Companion;", "", "<init>", "()V", "getInstance", "Lorg/jetbrains/kotlin/gradle/scripting/shared/roots/GradleBuildRootDataSerializer;", "kotlin.gradle.scripting.shared"})
    @SourceDebugExtension(value={"SMAP\nGradleBuildRootDataSerializer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleBuildRootDataSerializer.kt\norg/jetbrains/kotlin/gradle/scripting/shared/roots/GradleBuildRootDataSerializer$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,184:1\n42#2,3:185\n*S KotlinDebug\n*F\n+ 1 GradleBuildRootDataSerializer.kt\norg/jetbrains/kotlin/gradle/scripting/shared/roots/GradleBuildRootDataSerializer$Companion\n*L\n55#1:185,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final GradleBuildRootDataSerializer getInstance() {
            boolean $i$f$service = false;
            Class<GradleBuildRootDataSerializer> serviceClass$iv = GradleBuildRootDataSerializer.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (GradleBuildRootDataSerializer)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0016J\u0010\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/gradle/scripting/shared/roots/GradleBuildRootDataSerializer$Externalizer;", "Lcom/intellij/util/io/DataExternalizer;", "Lorg/jetbrains/kotlin/gradle/scripting/shared/roots/GradleBuildRootData;", "<init>", "(Lorg/jetbrains/kotlin/gradle/scripting/shared/roots/GradleBuildRootDataSerializer;)V", "save", "", "out", "Ljava/io/DataOutput;", "value", "read", "in", "Ljava/io/DataInput;", "kotlin.gradle.scripting.shared"})
    public final class Externalizer
    implements DataExternalizer<GradleBuildRootData> {
        public void save(@NotNull DataOutput out, @NotNull GradleBuildRootData value) {
            Intrinsics.checkNotNullParameter((Object)out, (String)"out");
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            GradleBuildRootDataSerializerKt.writeKotlinDslScriptModels(out, value);
        }

        @NotNull
        public GradleBuildRootData read(@NotNull DataInput in) {
            Intrinsics.checkNotNullParameter((Object)in, (String)"in");
            String string = ((VirtualFile)GradleBuildRootDataSerializer.this.currentBuildRoot.get()).getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            return GradleBuildRootDataSerializerKt.readKotlinDslScriptModels(in, string);
        }
    }
}

