/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jdi;

import com.jetbrains.jdi.AsyncUtils;
import com.jetbrains.jdi.ClassTypeImpl;
import com.jetbrains.jdi.CommandSender;
import com.jetbrains.jdi.InterfaceTypeImpl;
import com.jetbrains.jdi.JDWPException;
import com.jetbrains.jdi.MethodImpl;
import com.jetbrains.jdi.ObjectReferenceImpl;
import com.jetbrains.jdi.PacketStream;
import com.jetbrains.jdi.ReferenceTypeImpl;
import com.jetbrains.jdi.ThreadReferenceImpl;
import com.jetbrains.jdi.ValueImpl;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;

abstract class InvokableTypeImpl
extends ReferenceTypeImpl {
    InvokableTypeImpl(VirtualMachine aVm, long aRef) {
        super(aVm, aRef);
    }

    public Value invokeMethod(ThreadReference threadIntf, Method methodIntf, List<? extends Value> origArguments, int options) throws InvalidTypeException, ClassNotLoadedException, IncompatibleThreadStateException, InvocationException {
        InvocationResult ret;
        this.validateMirror(threadIntf);
        this.validateMirror(methodIntf);
        this.validateMirrorsOrNulls(origArguments);
        MethodImpl method = (MethodImpl)methodIntf;
        ThreadReferenceImpl thread = (ThreadReferenceImpl)threadIntf;
        this.validateMethodInvocation(method);
        List<Value> arguments = method.validateAndPrepareArgumentsForInvoke(origArguments, options);
        ValueImpl[] args = arguments.toArray(new ValueImpl[0]);
        try {
            PacketStream stream = this.sendInvokeCommand(thread, method, args, options);
            ret = this.waitForReply(stream);
        }
        catch (JDWPException exc) {
            if (exc.errorCode() == 10) {
                throw new IncompatibleThreadStateException();
            }
            throw exc.toJDIException();
        }
        if ((options & 1) == 0) {
            this.vm.notifySuspend();
        }
        if (ret.getException() != null) {
            throw new InvocationException(ret.getException());
        }
        return ret.getResult();
    }

    public CompletableFuture<Value> invokeMethodAsync(ThreadReference threadIntf, Method methodIntf, List<? extends Value> origArguments, int options) throws InvalidTypeException, ClassNotLoadedException, IncompatibleThreadStateException, InvocationException {
        this.validateMirror(threadIntf);
        this.validateMirror(methodIntf);
        this.validateMirrorsOrNulls(origArguments);
        MethodImpl method = (MethodImpl)methodIntf;
        ThreadReferenceImpl thread = (ThreadReferenceImpl)threadIntf;
        this.validateMethodInvocation(method);
        List<Value> arguments = method.validateAndPrepareArgumentsForInvoke(origArguments, options);
        ValueImpl[] args = arguments.toArray(new ValueImpl[0]);
        PacketStream stream = this.sendInvokeCommand(thread, method, args, options);
        return ((CompletableFuture)this.readReply(stream).exceptionally(throwable -> {
            if ((throwable = AsyncUtils.unwrap(throwable)) instanceof IllegalThreadStateException) {
                throw new CompletionException(new IncompatibleThreadStateException());
            }
            throw (RuntimeException)throwable;
        })).thenApply(ret -> {
            if ((options & 1) == 0) {
                this.vm.notifySuspend();
            }
            if (ret.getException() != null) {
                throw new CompletionException(new InvocationException(ret.getException()));
            }
            return ret.getResult();
        });
    }

    @Override
    public boolean isAssignableTo(ReferenceType type) {
        if (this.equals(type)) {
            return true;
        }
        ClassTypeImpl superclazz = (ClassTypeImpl)this.superclass();
        if (superclazz != null && superclazz.isAssignableTo(type)) {
            return true;
        }
        List<InterfaceType> interfaces = this.interfaces();
        for (InterfaceType anInterface : interfaces) {
            InterfaceTypeImpl interfaze = (InterfaceTypeImpl)anInterface;
            if (!interfaze.isAssignableTo(type)) continue;
            return true;
        }
        return false;
    }

    @Override
    final void addVisibleMethods(Map<String, Method> methodMap, Set<InterfaceType> seenInterfaces) {
        for (InterfaceType interfaceType : this.interfaces()) {
            InterfaceTypeImpl interfaze = (InterfaceTypeImpl)interfaceType;
            if (seenInterfaces.contains(interfaze)) continue;
            interfaze.addVisibleMethods(methodMap, seenInterfaces);
            seenInterfaces.add(interfaze);
        }
        ClassTypeImpl clazz = (ClassTypeImpl)this.superclass();
        if (clazz != null) {
            clazz.addVisibleMethods(methodMap, seenInterfaces);
        }
        this.addToMethodMap(methodMap, this.methods());
    }

    final void addInterfaces(List<InterfaceType> list) {
        List<InterfaceType> immediate = this.interfaces();
        list.addAll(this.interfaces());
        for (InterfaceType interfaceType : immediate) {
            InterfaceTypeImpl interfaze = (InterfaceTypeImpl)interfaceType;
            interfaze.addInterfaces(list);
        }
        ClassTypeImpl superclass = (ClassTypeImpl)this.superclass();
        if (superclass != null) {
            superclass.addInterfaces(list);
        }
    }

    final List<InterfaceType> getAllInterfaces() {
        ArrayList<InterfaceType> all2 = new ArrayList<InterfaceType>();
        this.addInterfaces(all2);
        return all2;
    }

    @Override
    public List<Method> allMethods() {
        ArrayList<Method> list = new ArrayList<Method>(this.methods());
        for (ClassType clazz = this.superclass(); clazz != null; clazz = clazz.superclass()) {
            list.addAll(clazz.methods());
        }
        for (InterfaceType interfaze : this.getAllInterfaces()) {
            list.addAll(interfaze.methods());
        }
        return list;
    }

    final List<ReferenceType> inheritedTypes() {
        ArrayList<ReferenceType> inherited = new ArrayList<ReferenceType>();
        if (this.superclass() != null) {
            inherited.add(0, this.superclass());
        }
        inherited.addAll(this.interfaces());
        return inherited;
    }

    @Override
    final CompletableFuture<List<? extends ReferenceType>> inheritedTypesAsync() {
        return this.superclassAsync().thenCombine(this.interfacesAsync(), (superclass, interfaces) -> {
            ArrayList<ClassType> res2 = new ArrayList<ClassType>();
            if (superclass != null) {
                res2.add((ClassType)superclass);
            }
            res2.addAll((Collection<ClassType>)interfaces);
            return res2;
        });
    }

    private PacketStream sendInvokeCommand(ThreadReferenceImpl thread, MethodImpl method, ValueImpl[] args, int options) {
        CommandSender sender2 = this.getInvokeMethodSender(thread, method, args, options);
        PacketStream stream = (options & 1) != 0 ? thread.sendResumingCommand(sender2) : this.vm.sendResumingCommand(sender2);
        return stream;
    }

    private void validateMethodInvocation(Method method) {
        if (!this.canInvoke(method)) {
            throw new IllegalArgumentException("Invalid method");
        }
        if (!method.isStatic()) {
            throw new IllegalArgumentException("Cannot invoke instance method on a class/interface type");
        }
        if (method.isStaticInitializer()) {
            throw new IllegalArgumentException("Cannot invoke static initializer");
        }
    }

    abstract CommandSender getInvokeMethodSender(ThreadReferenceImpl var1, MethodImpl var2, ValueImpl[] var3, int var4);

    abstract InvocationResult waitForReply(PacketStream var1) throws JDWPException;

    abstract CompletableFuture<InvocationResult> readReply(PacketStream var1);

    abstract ClassType superclass();

    abstract CompletableFuture<ClassType> superclassAsync();

    abstract List<InterfaceType> interfaces();

    abstract CompletableFuture<List<InterfaceType>> interfacesAsync();

    abstract boolean canInvoke(Method var1);

    static interface InvocationResult {
        public ObjectReferenceImpl getException();

        public ValueImpl getResult();
    }
}

