/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.ide.inspection.auto;

import com.intellij.codeInspection.IntentionAndQuickFixAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.grazie.GrazieBundle;
import com.intellij.grazie.GrazieConfig;
import com.intellij.grazie.ide.fus.AcceptanceRateTracker;
import com.intellij.grazie.ide.fus.GrazieFUSCounter;
import com.intellij.grazie.ide.inspection.auto.ChangeTracker;
import com.intellij.grazie.ide.inspection.grammar.quickfix.GrazieReplaceTypoQuickFix;
import com.intellij.grazie.text.TextContent;
import com.intellij.grazie.text.TreeRuleChecker;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.undo.BasicUndoableAction;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.StringOperation;
import java.util.List;
import java.util.Map;
import one.util.streamex.StreamEx;

public final class AutoFix {
    public static void consider(TextContent text, List<TreeRuleChecker.TreeProblem> problems) {
        PsiFile file;
        Document document;
        List candidates;
        if (GrazieConfig.Companion.get().getAutoFix() && !problems.isEmpty() && !(candidates = ContainerUtil.filter(problems, arg_0 -> AutoFix.lambda$consider$0(document = (file = text.getContainingFile()).getViewProvider().getDocument(), arg_0))).isEmpty()) {
            AutoFix.scheduleAutoFix(file, candidates);
        }
    }

    private static void scheduleAutoFix(PsiFile file, List<TreeRuleChecker.TreeProblem> problems) {
        Map<TreeRuleChecker.TreeProblem, List<IntentionAndQuickFixAction>> fixes = AutoFix.collectFixes(problems);
        Document document = file.getViewProvider().getDocument();
        long stamp = document.getModificationStamp();
        ApplicationManager.getApplication().invokeLater(() -> {
            if (file.isValid() && stamp == document.getModificationStamp()) {
                AutoFix.applyFixes(file, fixes);
            }
        });
    }

    private static List<IntentionAndQuickFixAction> selectFixes(List<LocalQuickFix> fixes) {
        return ContainerUtil.filterIsInstance(fixes, IntentionAndQuickFixAction.class);
    }

    private static Map<TreeRuleChecker.TreeProblem, List<IntentionAndQuickFixAction>> collectFixes(List<TreeRuleChecker.TreeProblem> candidates) {
        return StreamEx.of(candidates).mapToEntry(it -> AutoFix.selectFixes(GrazieReplaceTypoQuickFix.getReplacementFixes(it, List.of()))).toMap();
    }

    private static void applyFixes(final PsiFile file, Map<TreeRuleChecker.TreeProblem, List<IntentionAndQuickFixAction>> fixes) {
        final Project project = file.getProject();
        for (Map.Entry<TreeRuleChecker.TreeProblem, List<IntentionAndQuickFixAction>> entry : fixes.entrySet()) {
            TreeRuleChecker.TreeProblem problem = entry.getKey();
            for (final IntentionAndQuickFixAction fix : entry.getValue()) {
                final AcceptanceRateTracker tracker = new AcceptanceRateTracker(entry.getKey());
                WriteCommandAction.runWriteCommandAction((Project)project, (String)AutoFix.commandName(problem), null, () -> {
                    var action2 = new BasicUndoableAction(new VirtualFile[]{file.getViewProvider().getVirtualFile()}){

                        public void undo() {
                            GrazieFUSCounter.INSTANCE.reportAutoFixUndone(tracker);
                        }

                        public void redo() {
                            fix.applyFix(project, file, null);
                            GrazieFUSCounter.INSTANCE.reportAutoFixApplied(tracker);
                        }
                    };
                    action2.redo();
                    UndoManager.getInstance((Project)project).undoableActionPerformed((UndoableAction)action2);
                }, (PsiFile[])new PsiFile[0]);
            }
        }
    }

    private static String commandName(TreeRuleChecker.TreeProblem candidate) {
        String message = candidate.getShortMessage();
        return GrazieBundle.message("auto.apply.fix.command.name", message);
    }

    private static boolean shouldAutoFix(Document document, TreeRuleChecker.TreeProblem problem) {
        if (!problem.match.autoFixCapable() || problem.getSuggestions().size() != 1) {
            return false;
        }
        List<StringOperation> changes = problem.getSuggestions().getFirst().getChanges();
        TextContent text = problem.getText();
        List fileRanges = ContainerUtil.map(changes, c -> text.textRangeToFile(c.getRange()));
        for (Editor editor : EditorFactory.getInstance().getEditors(document, text.getContainingFile().getProject())) {
            for (Caret caret : editor.getCaretModel().getAllCarets()) {
                if (!ContainerUtil.exists((Iterable)fileRanges, r -> r.containsOffset(caret.getOffset()))) continue;
                return false;
            }
        }
        ChangeTracker tracker = ChangeTracker.getInstance();
        return ContainerUtil.exists((Iterable)fileRanges, r -> tracker.mayAutoChange(document, (TextRange)r)) && !ContainerUtil.exists((Iterable)fileRanges, r -> tracker.isExplicitlyUndone(document, (TextRange)r));
    }

    private static /* synthetic */ boolean lambda$consider$0(Document document, TreeRuleChecker.TreeProblem p) {
        return AutoFix.shouldAutoFix(document, p);
    }
}

