/*
 * Decompiled with CFR 0.152.
 */
package org.itk.simple;

import java.util.AbstractList;
import java.util.RandomAccess;
import org.itk.simple.SimpleITKJNI;

public class VectorInt64
extends AbstractList<Long>
implements RandomAccess {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected VectorInt64(long l, boolean bl) {
        this.swigCMemOwn = bl;
        this.swigCPtr = l;
    }

    protected static long getCPtr(VectorInt64 vectorInt64) {
        return vectorInt64 == null ? 0L : vectorInt64.swigCPtr;
    }

    protected static long swigRelease(VectorInt64 vectorInt64) {
        long l = 0L;
        if (vectorInt64 != null) {
            if (!vectorInt64.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            l = vectorInt64.swigCPtr;
            vectorInt64.swigCMemOwn = false;
            vectorInt64.delete();
        }
        return l;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                SimpleITKJNI.delete_VectorInt64(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public VectorInt64(long[] lArray) {
        this();
        this.doReserve(lArray.length);
        for (long l : lArray) {
            this.doAdd(l);
        }
    }

    public VectorInt64(Iterable<Long> iterable) {
        this();
        for (long l : iterable) {
            this.doAdd(l);
        }
    }

    @Override
    public Long get(int n) {
        return this.doGet(n);
    }

    @Override
    public Long set(int n, Long l) {
        return this.doSet(n, l);
    }

    @Override
    public boolean add(Long l) {
        ++this.modCount;
        this.doAdd(l);
        return true;
    }

    @Override
    public void add(int n, Long l) {
        ++this.modCount;
        this.doAdd(n, l);
    }

    @Override
    public Long remove(int n) {
        ++this.modCount;
        return this.doRemove(n);
    }

    @Override
    protected void removeRange(int n, int n2) {
        ++this.modCount;
        this.doRemoveRange(n, n2);
    }

    @Override
    public int size() {
        return this.doSize();
    }

    public int capacity() {
        return this.doCapacity();
    }

    public void reserve(int n) {
        this.doReserve(n);
    }

    public VectorInt64() {
        this(SimpleITKJNI.new_VectorInt64__SWIG_0(), true);
    }

    public VectorInt64(VectorInt64 vectorInt64) {
        this(SimpleITKJNI.new_VectorInt64__SWIG_1(VectorInt64.getCPtr(vectorInt64), vectorInt64), true);
    }

    @Override
    public boolean isEmpty() {
        return SimpleITKJNI.VectorInt64_isEmpty(this.swigCPtr, this);
    }

    @Override
    public void clear() {
        SimpleITKJNI.VectorInt64_clear(this.swigCPtr, this);
    }

    public VectorInt64(int n, long l) {
        this(SimpleITKJNI.new_VectorInt64__SWIG_2(n, l), true);
    }

    private int doCapacity() {
        return SimpleITKJNI.VectorInt64_doCapacity(this.swigCPtr, this);
    }

    private void doReserve(int n) {
        SimpleITKJNI.VectorInt64_doReserve(this.swigCPtr, this, n);
    }

    private int doSize() {
        return SimpleITKJNI.VectorInt64_doSize(this.swigCPtr, this);
    }

    private void doAdd(long l) {
        SimpleITKJNI.VectorInt64_doAdd__SWIG_0(this.swigCPtr, this, l);
    }

    private void doAdd(int n, long l) {
        SimpleITKJNI.VectorInt64_doAdd__SWIG_1(this.swigCPtr, this, n, l);
    }

    private long doRemove(int n) {
        return SimpleITKJNI.VectorInt64_doRemove(this.swigCPtr, this, n);
    }

    private long doGet(int n) {
        return SimpleITKJNI.VectorInt64_doGet(this.swigCPtr, this, n);
    }

    private long doSet(int n, long l) {
        return SimpleITKJNI.VectorInt64_doSet(this.swigCPtr, this, n, l);
    }

    private void doRemoveRange(int n, int n2) {
        SimpleITKJNI.VectorInt64_doRemoveRange(this.swigCPtr, this, n, n2);
    }
}

