/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.assignor;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

class RangeSet
implements Set<Integer> {
    private final int from;
    private final int to;

    public RangeSet(int from, int to) {
        this.from = from;
        this.to = to;
        if (to < from) {
            throw new IllegalArgumentException("Invalid range: to must be greater than or equal to from");
        }
        if ((long)to - (long)from > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Range exceeds the maximum size of Integer.MAX_VALUE");
        }
    }

    @Override
    public int size() {
        return this.to - this.from;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof Integer) {
            int value = (Integer)o;
            return value >= this.from && value < this.to;
        }
        return false;
    }

    @Override
    public Iterator<Integer> iterator() {
        return new Iterator<Integer>(){
            private int current;
            {
                this.current = RangeSet.this.from;
            }

            @Override
            public boolean hasNext() {
                return this.current < RangeSet.this.to;
            }

            @Override
            public Integer next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return this.current++;
            }
        };
    }

    @Override
    public Object[] toArray() {
        Object[] array = new Object[this.size()];
        for (int i = 0; i < this.size(); ++i) {
            array[i] = this.from + i;
        }
        return array;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        int size = this.size();
        if (a.length < size) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        }
        for (int i = 0; i < size; ++i) {
            a[i] = this.from + i;
        }
        if (a.length > size) {
            a[size] = null;
        }
        return a;
    }

    @Override
    public boolean add(Integer integer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends Integer> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return "RangeSet(from=" + this.from + " (inclusive), to=" + this.to + " (exclusive))";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Set)) {
            return false;
        }
        Set otherSet = (Set)o;
        if (o instanceof RangeSet) {
            RangeSet other = (RangeSet)o;
            if (this.size() == 0 && other.size() == 0) {
                return true;
            }
            return this.from == other.from && this.to == other.to;
        }
        if (otherSet.size() != this.size()) {
            return false;
        }
        for (int i = this.from; i < this.to; ++i) {
            if (otherSet.contains(i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        long sum = (long)this.size() * ((long)this.from + (long)this.to - 1L) / 2L;
        return (int)sum;
    }
}

