/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.controller.metrics;

import org.apache.kafka.common.annotation.InterfaceStability;
import org.apache.kafka.metadata.BrokerRegistration;

@InterfaceStability.Stable
public enum BrokerRegistrationState {
    UNREGISTERED(-1),
    FENCED(10),
    CONTROLLED_SHUTDOWN(20),
    ACTIVE(30);

    private final int state;

    private BrokerRegistrationState(int state) {
        this.state = state;
    }

    public int state() {
        return this.state;
    }

    public static BrokerRegistrationState getBrokerRegistrationState(BrokerRegistration brokerRegistration) {
        if (brokerRegistration.fenced()) {
            return FENCED;
        }
        if (brokerRegistration.inControlledShutdown()) {
            return CONTROLLED_SHUTDOWN;
        }
        return ACTIVE;
    }
}

