/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.gizmo2.creator;

import io.quarkus.gizmo2.creator.AnnotationCreator;
import io.smallrye.common.constraint.Assert;
import java.lang.annotation.Annotation;
import java.lang.annotation.RetentionPolicy;
import java.lang.constant.ClassDesc;
import java.util.function.Consumer;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface AnnotatableCreator {
    default public <A extends Annotation> void addAnnotation(A annotation) {
        Assert.checkNotNullParam((String)"annotation", annotation);
        Class<? extends Annotation> annotationType = annotation.annotationType();
        this.addAnnotation(annotationType, AnnotationCreator.from(annotation));
    }

    default public void addAnnotation(Class<? extends Annotation> annotationClass) {
        Assert.checkNotNullParam((String)"annotationClass", annotationClass);
        this.addAnnotation(annotationClass, builder -> {});
    }

    public <A extends Annotation> void addAnnotation(Class<A> var1, Consumer<AnnotationCreator<A>> var2);

    public void addAnnotation(ClassDesc var1, RetentionPolicy var2, Consumer<AnnotationCreator<Annotation>> var3);
}

