/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.utils;

import java.util.concurrent.TimeUnit;
import org.keycloak.models.ClientModel;
import org.keycloak.models.RealmModel;
import org.keycloak.utils.StringUtil;

public class SessionExpirationUtils {
    public static long calculateUserSessionMaxLifespanTimestamp(boolean offline, boolean isRememberMe, long created, RealmModel realm) {
        long timestamp = -1L;
        if (offline) {
            if (realm.isOfflineSessionMaxLifespanEnabled()) {
                timestamp = created + TimeUnit.SECONDS.toMillis(SessionExpirationUtils.getOfflineSessionMaxLifespan(realm));
            }
        } else {
            long userSessionMaxLifespan = TimeUnit.SECONDS.toMillis(SessionExpirationUtils.getSsoSessionMaxLifespan(realm));
            if (isRememberMe) {
                userSessionMaxLifespan = Math.max(userSessionMaxLifespan, TimeUnit.SECONDS.toMillis(realm.getSsoSessionMaxLifespanRememberMe()));
            }
            timestamp = created + userSessionMaxLifespan;
        }
        return timestamp;
    }

    public static long calculateUserSessionIdleTimestamp(boolean offline, boolean isRememberMe, long lastRefreshed, RealmModel realm) {
        long timestamp;
        if (offline) {
            timestamp = lastRefreshed + TimeUnit.SECONDS.toMillis(SessionExpirationUtils.getOfflineSessionIdleTimeout(realm));
        } else {
            long userSessionIdleTimeout = TimeUnit.SECONDS.toMillis(SessionExpirationUtils.getSsoSessionIdleTimeout(realm));
            if (isRememberMe) {
                userSessionIdleTimeout = Math.max(userSessionIdleTimeout, TimeUnit.SECONDS.toMillis(realm.getSsoSessionIdleTimeoutRememberMe()));
            }
            timestamp = lastRefreshed + userSessionIdleTimeout;
        }
        return timestamp;
    }

    public static long calculateClientSessionMaxLifespanTimestamp(boolean offline, boolean isRememberMe, long clientSessionCreated, long userSessionCreated, RealmModel realm, ClientModel client) {
        long timestamp = -1L;
        if (offline) {
            long clientOfflineSessionMaxLifespan = SessionExpirationUtils.getClientAttributeTimeout(client, "client.offline.session.max.lifespan");
            if (realm.isOfflineSessionMaxLifespanEnabled() || clientOfflineSessionMaxLifespan > 0L) {
                clientOfflineSessionMaxLifespan = clientOfflineSessionMaxLifespan > 0L ? TimeUnit.SECONDS.toMillis(clientOfflineSessionMaxLifespan) : (realm.getClientOfflineSessionMaxLifespan() > 0 ? TimeUnit.SECONDS.toMillis(realm.getClientOfflineSessionMaxLifespan()) : TimeUnit.SECONDS.toMillis(SessionExpirationUtils.getOfflineSessionMaxLifespan(realm)));
                timestamp = clientSessionCreated + clientOfflineSessionMaxLifespan;
                long userSessionExpires = SessionExpirationUtils.calculateUserSessionMaxLifespanTimestamp(offline, isRememberMe, userSessionCreated, realm);
                timestamp = userSessionExpires > 0L ? Math.min(timestamp, userSessionExpires) : timestamp;
            }
        } else {
            long clientSessionMaxLifespanPerClient;
            long clientSessionMaxLifespan = TimeUnit.SECONDS.toMillis(SessionExpirationUtils.getSsoSessionMaxLifespan(realm));
            if (isRememberMe) {
                clientSessionMaxLifespan = Math.max(clientSessionMaxLifespan, TimeUnit.SECONDS.toMillis(realm.getSsoSessionMaxLifespanRememberMe()));
            }
            if ((clientSessionMaxLifespanPerClient = SessionExpirationUtils.getClientAttributeTimeout(client, "client.session.max.lifespan")) > 0L) {
                clientSessionMaxLifespan = TimeUnit.SECONDS.toMillis(clientSessionMaxLifespanPerClient);
            } else if (realm.getClientSessionMaxLifespan() > 0) {
                clientSessionMaxLifespan = TimeUnit.SECONDS.toMillis(realm.getClientSessionMaxLifespan());
            }
            timestamp = clientSessionCreated + clientSessionMaxLifespan;
            long userSessionExpires = SessionExpirationUtils.calculateUserSessionMaxLifespanTimestamp(offline, isRememberMe, userSessionCreated, realm);
            timestamp = Math.min(timestamp, userSessionExpires);
        }
        return timestamp;
    }

    public static long calculateClientSessionIdleTimestamp(boolean offline, boolean isRememberMe, long lastRefreshed, RealmModel realm, ClientModel client) {
        long timestamp;
        if (offline) {
            long clientOfflineSessionIdleTimeout = TimeUnit.SECONDS.toMillis(SessionExpirationUtils.getOfflineSessionIdleTimeout(realm));
            long clientOfflineSessionIdleTimeoutPerClient = SessionExpirationUtils.getClientAttributeTimeout(client, "client.offline.session.idle.timeout");
            if (clientOfflineSessionIdleTimeoutPerClient > 0L) {
                clientOfflineSessionIdleTimeout = TimeUnit.SECONDS.toMillis(clientOfflineSessionIdleTimeoutPerClient);
            } else if (realm.getClientOfflineSessionIdleTimeout() > 0) {
                clientOfflineSessionIdleTimeout = TimeUnit.SECONDS.toMillis(realm.getClientOfflineSessionIdleTimeout());
            }
            timestamp = lastRefreshed + clientOfflineSessionIdleTimeout;
        } else {
            long clientSessionIdleTimeoutPerClient;
            long clientSessionIdleTimeout = TimeUnit.SECONDS.toMillis(SessionExpirationUtils.getSsoSessionIdleTimeout(realm));
            if (isRememberMe) {
                clientSessionIdleTimeout = Math.max(clientSessionIdleTimeout, TimeUnit.SECONDS.toMillis(realm.getSsoSessionIdleTimeoutRememberMe()));
            }
            if ((clientSessionIdleTimeoutPerClient = SessionExpirationUtils.getClientAttributeTimeout(client, "client.session.idle.timeout")) > 0L) {
                clientSessionIdleTimeout = TimeUnit.SECONDS.toMillis(clientSessionIdleTimeoutPerClient);
            } else if (realm.getClientSessionIdleTimeout() > 0) {
                clientSessionIdleTimeout = TimeUnit.SECONDS.toMillis(realm.getClientSessionIdleTimeout());
            }
            timestamp = lastRefreshed + clientSessionIdleTimeout;
        }
        return timestamp;
    }

    private static int getSsoSessionMaxLifespan(RealmModel realm) {
        int lifespan = realm.getSsoSessionMaxLifespan();
        if (lifespan <= 0) {
            lifespan = 36000;
        }
        return lifespan;
    }

    private static int getOfflineSessionMaxLifespan(RealmModel realm) {
        int lifespan = realm.getOfflineSessionMaxLifespan();
        if (lifespan <= 0) {
            lifespan = 5184000;
        }
        return lifespan;
    }

    public static int getSsoSessionIdleTimeout(RealmModel realm) {
        int idle = realm.getSsoSessionIdleTimeout();
        if (idle <= 0) {
            idle = 1800;
        }
        return idle;
    }

    public static int getOfflineSessionIdleTimeout(RealmModel realm) {
        int idle = realm.getOfflineSessionIdleTimeout();
        if (idle <= 0) {
            idle = 2592000;
        }
        return idle;
    }

    private static long getClientAttributeTimeout(ClientModel client, String attr) {
        String value;
        if (client != null && StringUtil.isNotBlank((String)(value = client.getAttribute(attr)))) {
            try {
                return Long.parseLong(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1L;
    }
}

