/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.converter.jackson.deserializer.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import com.webauthn4j.data.UserVerificationMethod;
import java.io.IOException;

public class UserVerificationMethodFromLongDeserializer
extends StdDeserializer<UserVerificationMethod> {
    public UserVerificationMethodFromLongDeserializer() {
        super(UserVerificationMethod.class);
    }

    public UserVerificationMethod deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        long value = p.getValueAsLong();
        try {
            return UserVerificationMethod.create(value);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidFormatException(null, "value is out of range", (Object)value, UserVerificationMethod.class);
        }
    }
}

