/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan;

import java.io.Serializable;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.CacheStream;
import org.infinispan.util.function.SerializableConsumer;
import org.jboss.logging.Logger;
import org.keycloak.common.util.StackUtil;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakTransaction;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserLoginFailureModel;
import org.keycloak.models.UserLoginFailureProvider;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.sessions.infinispan.CacheDecorators;
import org.keycloak.models.sessions.infinispan.UserLoginFailureAdapter;
import org.keycloak.models.sessions.infinispan.changes.InfinispanChangelogBasedTransaction;
import org.keycloak.models.sessions.infinispan.changes.SessionEntityWrapper;
import org.keycloak.models.sessions.infinispan.changes.SessionUpdateTask;
import org.keycloak.models.sessions.infinispan.changes.Tasks;
import org.keycloak.models.sessions.infinispan.entities.LoginFailureEntity;
import org.keycloak.models.sessions.infinispan.entities.LoginFailureKey;
import org.keycloak.models.sessions.infinispan.events.RemoveAllUserLoginFailuresEvent;
import org.keycloak.models.sessions.infinispan.events.SessionEventsSenderTransaction;
import org.keycloak.models.sessions.infinispan.stream.LoginFailuresLifespanUpdate;
import org.keycloak.models.sessions.infinispan.stream.Mappers;
import org.keycloak.models.sessions.infinispan.stream.RemoveKeyConsumer;
import org.keycloak.models.sessions.infinispan.stream.SessionWrapperPredicate;
import org.keycloak.models.sessions.infinispan.util.FuturesHelper;

public class InfinispanUserLoginFailureProvider
implements UserLoginFailureProvider {
    private static final Logger log = Logger.getLogger(InfinispanUserLoginFailureProvider.class);
    protected final KeycloakSession session;
    protected final InfinispanChangelogBasedTransaction<LoginFailureKey, LoginFailureEntity> loginFailuresTx;
    protected final SessionEventsSenderTransaction clusterEventsSenderTx;

    public InfinispanUserLoginFailureProvider(KeycloakSession session, InfinispanChangelogBasedTransaction<LoginFailureKey, LoginFailureEntity> loginFailuresTx) {
        this.session = session;
        this.loginFailuresTx = loginFailuresTx;
        this.clusterEventsSenderTx = new SessionEventsSenderTransaction(session);
        session.getTransactionManager().enlistAfterCompletion((KeycloakTransaction)this.clusterEventsSenderTx);
    }

    public UserLoginFailureModel getUserLoginFailure(RealmModel realm, String userId) {
        log.tracef("getUserLoginFailure(%s, %s)%s", (Object)realm, (Object)userId, StackUtil.getShortStackTrace());
        LoginFailureKey key = new LoginFailureKey(realm.getId(), userId);
        LoginFailureEntity entity = this.getLoginFailureEntity(key);
        return this.wrap(key, entity);
    }

    public UserLoginFailureModel addUserLoginFailure(RealmModel realm, String userId) {
        log.tracef("addUserLoginFailure(%s, %s)%s", (Object)realm, (Object)userId, StackUtil.getShortStackTrace());
        LoginFailureKey key = new LoginFailureKey(realm.getId(), userId);
        LoginFailureEntity entity = new LoginFailureEntity(realm.getId(), userId);
        SessionUpdateTask createLoginFailureTask = Tasks.addIfAbsentSync();
        this.loginFailuresTx.addTask(key, createLoginFailureTask, entity, UserSessionModel.SessionPersistenceState.PERSISTENT);
        return this.wrap(key, entity);
    }

    public void removeUserLoginFailure(RealmModel realm, String userId) {
        log.tracef("removeUserLoginFailure(%s, %s)%s", (Object)realm, (Object)userId, StackUtil.getShortStackTrace());
        SessionUpdateTask removeTask = Tasks.removeSync();
        this.loginFailuresTx.addTask(new LoginFailureKey(realm.getId(), userId), removeTask);
    }

    public void removeAllUserLoginFailures(RealmModel realm) {
        log.tracef("removeAllUserLoginFailures(%s)%s", (Object)realm, StackUtil.getShortStackTrace());
        this.clusterEventsSenderTx.addEvent(RemoveAllUserLoginFailuresEvent.createEvent(RemoveAllUserLoginFailuresEvent.class, "REMOVE_ALL_LOGIN_FAILURES_EVENT", this.session, realm.getId()));
    }

    protected void removeAllLocalUserLoginFailuresEvent(String realmId) {
        log.tracef("removeAllLocalUserLoginFailuresEvent(%s)%s", (Object)realmId, StackUtil.getShortStackTrace());
        FuturesHelper futures = new FuturesHelper();
        AdvancedCache<LoginFailureKey, SessionEntityWrapper<LoginFailureEntity>> localCache = CacheDecorators.localCache(this.loginFailuresTx.getCache());
        localCache.entrySet().stream().filter(SessionWrapperPredicate.create(realmId)).map(Mappers.loginFailureId()).forEach((SerializableConsumer & Serializable)loginFailureKey -> {
            CompletableFuture<SessionEntityWrapper<LoginFailureEntity>> future = InfinispanUserLoginFailureProvider.removeKeyFromCache((Cache<LoginFailureKey, SessionEntityWrapper<LoginFailureEntity>>)localCache, loginFailureKey);
            futures.addTask(future);
        });
        futures.waitForAllToFinish();
        log.debugf("Removed %d login failures in realm %s", futures.size(), (Object)realmId);
    }

    UserLoginFailureModel wrap(LoginFailureKey key, LoginFailureEntity entity) {
        return entity != null ? new UserLoginFailureAdapter(this, key, entity) : null;
    }

    private LoginFailureEntity getLoginFailureEntity(LoginFailureKey key) {
        InfinispanChangelogBasedTransaction<LoginFailureKey, LoginFailureEntity> tx = this.getLoginFailuresTx();
        SessionEntityWrapper<LoginFailureEntity> entityWrapper = tx.get(key);
        return entityWrapper == null ? null : entityWrapper.getEntity();
    }

    InfinispanChangelogBasedTransaction<LoginFailureKey, LoginFailureEntity> getLoginFailuresTx() {
        return this.loginFailuresTx;
    }

    public void close() {
    }

    public void updateWithLatestRealmSettings(RealmModel realm) {
        CacheStream stream = this.loginFailuresTx.getCache().entrySet().stream().filter(SessionWrapperPredicate.create(realm.getId()));
        if (realm.isBruteForceProtected()) {
            LoginFailuresLifespanUpdate action = new LoginFailuresLifespanUpdate((long)realm.getMaxDeltaTimeSeconds() * 1000L, realm.getMaxTemporaryLockouts(), realm.isPermanentLockout());
            stream.forEach((BiConsumer)action);
        } else {
            stream.map(Mappers.loginFailureId()).forEach(RemoveKeyConsumer.getInstance());
        }
    }

    private static CompletableFuture<SessionEntityWrapper<LoginFailureEntity>> removeKeyFromCache(Cache<LoginFailureKey, SessionEntityWrapper<LoginFailureEntity>> cache, LoginFailureKey key) {
        return cache.removeAsync((Object)key);
    }
}

