
#ifndef KI18NQML_EXPORT_H
#define KI18NQML_EXPORT_H

#ifdef KI18NQML_STATIC_DEFINE
#  define KI18NQML_EXPORT
#  define KI18NQML_NO_EXPORT
#else
#  ifndef KI18NQML_EXPORT
#    ifdef KF6I18nQml_EXPORTS
        /* We are building this library */
#      define KI18NQML_EXPORT __attribute__((visibility("default")))
#    else
        /* We are using this library */
#      define KI18NQML_EXPORT __attribute__((visibility("default")))
#    endif
#  endif

#  ifndef KI18NQML_NO_EXPORT
#    define KI18NQML_NO_EXPORT __attribute__((visibility("hidden")))
#  endif
#endif

#ifndef KI18NQML_DECL_DEPRECATED
#  define KI18NQML_DECL_DEPRECATED __attribute__ ((__deprecated__))
#endif

#ifndef KI18NQML_DECL_DEPRECATED_EXPORT
#  define KI18NQML_DECL_DEPRECATED_EXPORT KI18NQML_EXPORT KI18NQML_DECL_DEPRECATED
#endif

#ifndef KI18NQML_DECL_DEPRECATED_NO_EXPORT
#  define KI18NQML_DECL_DEPRECATED_NO_EXPORT KI18NQML_NO_EXPORT KI18NQML_DECL_DEPRECATED
#endif

/* NOLINTNEXTLINE(readability-avoid-unconditional-preprocessor-if) */
#if 0 /* DEFINE_NO_DEPRECATED */
#  ifndef KI18NQML_NO_DEPRECATED
#    define KI18NQML_NO_DEPRECATED
#  endif
#endif
#include <ki18n_version.h>

#define KI18NQML_DECL_DEPRECATED_TEXT(text) __attribute__ ((__deprecated__(text)))

/* Take any defaults from group settings */
#if !defined(KI18NQML_NO_DEPRECATED) && !defined(KI18NQML_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  ifdef KF_NO_DEPRECATED
#    define KI18NQML_NO_DEPRECATED
#  elif defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#    define KI18NQML_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#  endif
#endif
#if !defined(KI18NQML_DISABLE_DEPRECATED_BEFORE_AND_AT) && defined(KF_DISABLE_DEPRECATED_BEFORE_AND_AT)
#  define KI18NQML_DISABLE_DEPRECATED_BEFORE_AND_AT KF_DISABLE_DEPRECATED_BEFORE_AND_AT
#endif

#if !defined(KI18NQML_NO_DEPRECATED_WARNINGS) && !defined(KI18NQML_DEPRECATED_WARNINGS_SINCE)
#  ifdef KF_NO_DEPRECATED_WARNINGS
#    define KI18NQML_NO_DEPRECATED_WARNINGS
#  elif defined(KF_DEPRECATED_WARNINGS_SINCE)
#    define KI18NQML_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#  endif
#endif
#if !defined(KI18NQML_DEPRECATED_WARNINGS_SINCE) && defined(KF_DEPRECATED_WARNINGS_SINCE)
#  define KI18NQML_DEPRECATED_WARNINGS_SINCE KF_DEPRECATED_WARNINGS_SINCE
#endif

#if defined(KI18NQML_NO_DEPRECATED)
#  undef KI18NQML_DEPRECATED
#  define KI18NQML_DEPRECATED_EXPORT KI18NQML_EXPORT
#  define KI18NQML_DEPRECATED_NO_EXPORT KI18NQML_NO_EXPORT
#elif defined(KI18NQML_NO_DEPRECATED_WARNINGS)
#  define KI18NQML_DEPRECATED
#  define KI18NQML_DEPRECATED_EXPORT KI18NQML_EXPORT
#  define KI18NQML_DEPRECATED_NO_EXPORT KI18NQML_NO_EXPORT
#else
#  define KI18NQML_DEPRECATED KI18NQML_DECL_DEPRECATED
#  define KI18NQML_DEPRECATED_EXPORT KI18NQML_DECL_DEPRECATED_EXPORT
#  define KI18NQML_DEPRECATED_NO_EXPORT KI18NQML_DECL_DEPRECATED_NO_EXPORT
#endif

/* No deprecated API had been removed from build */
#define KI18NQML_EXCLUDE_DEPRECATED_BEFORE_AND_AT 0

#define KI18NQML_BUILD_DEPRECATED_SINCE(major, minor) 1

#ifdef KI18NQML_NO_DEPRECATED
#  define KI18NQML_DISABLE_DEPRECATED_BEFORE_AND_AT KI18N_VERSION
#endif
#ifdef KI18NQML_NO_DEPRECATED_WARNINGS
#  define KI18NQML_DEPRECATED_WARNINGS_SINCE 0
#endif

#ifndef KI18NQML_DEPRECATED_WARNINGS_SINCE
#  ifdef KI18NQML_DISABLE_DEPRECATED_BEFORE_AND_AT
#    define KI18NQML_DEPRECATED_WARNINGS_SINCE KI18NQML_DISABLE_DEPRECATED_BEFORE_AND_AT
#  else
#    define KI18NQML_DEPRECATED_WARNINGS_SINCE KI18N_VERSION
#  endif
#endif

#ifndef KI18NQML_DISABLE_DEPRECATED_BEFORE_AND_AT
#  define KI18NQML_DISABLE_DEPRECATED_BEFORE_AND_AT 0
#endif

#ifdef KI18NQML_DEPRECATED
#  define KI18NQML_ENABLE_DEPRECATED_SINCE(major, minor) (((major<<16)|(minor<<8)) > KI18NQML_DISABLE_DEPRECATED_BEFORE_AND_AT)
#else
#  define KI18NQML_ENABLE_DEPRECATED_SINCE(major, minor) 0
#endif

#endif /* KI18NQML_EXPORT_H */
