/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.helper.versionspecific;

import com.ejt.internal.util.JavaVersionUtil;
import com.install4j.runtime.installer.helper.content.JavaHttpConnection;
import com.install4j.runtime.installer.helper.versionspecific.HttpClientWrapper;
import com.install4j.runtime.installer.helper.versionspecific.Java9Helper;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.VarHandle;
import java.lang.reflect.Field;
import java.net.Proxy;
import java.net.URL;
import java.net.http.HttpClient;
import java.util.Locale;
import java.util.Map;

public class Java11Helper
extends Java9Helper {
    @Override
    public JavaHttpConnection createHttpConnection(URL url, Proxy proxy, boolean acceptAllCertificates) throws IOException {
        if (!(Boolean.getBoolean("install4j.useHttpClient") && this.isHttpClientAvailable() && this.isHttpClientProtocol(url))) {
            return super.createHttpConnection(url, proxy, acceptAllCertificates);
        }
        return new HttpClientWrapper(url, proxy, acceptAllCertificates);
    }

    private boolean isHttpClientProtocol(URL url) {
        String protocol = url.getProtocol().toLowerCase(Locale.ROOT);
        return protocol.equals("http") || protocol.equals("https");
    }

    private boolean isHttpClientAvailable() {
        try {
            Class.forName(HttpClient.class.getName());
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    @Override
    public void setSecurityManager(SecurityManager securityManager) {
        if (JavaVersionUtil.isJava17Plus()) {
            try {
                this.preventSecurityManagerDeprecationWarning();
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        try {
            System.setSecurityManager(securityManager);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void preventSecurityManagerDeprecationWarning() throws Throwable {
        Class<?> unsafe = Class.forName("sun.misc.Unsafe");
        MethodHandles.Lookup lookup2 = MethodHandles.privateLookupIn(unsafe, MethodHandles.lookup());
        VarHandle handle = lookup2.findStaticVarHandle(unsafe, "theUnsafe", unsafe);
        Object theUnsafe = handle.get();
        Field callersHolder = Class.forName("java.lang.System$CallersHolder", true, null).getDeclaredField("callers");
        MethodHandle staticFieldBase = lookup2.findVirtual(unsafe, "staticFieldBase", MethodType.methodType(Object.class, Field.class));
        staticFieldBase = staticFieldBase.asType(staticFieldBase.type().changeParameterType(0, Object.class));
        Object base = staticFieldBase.invokeExact(theUnsafe, callersHolder);
        MethodHandle staticFieldOffset = lookup2.findVirtual(unsafe, "staticFieldOffset", MethodType.methodType(Long.TYPE, Field.class));
        staticFieldOffset = staticFieldOffset.asType(staticFieldOffset.type().changeParameterType(0, Object.class));
        long offset = staticFieldOffset.invokeExact(theUnsafe, callersHolder);
        MethodHandle getObject = lookup2.findVirtual(unsafe, "getObject", MethodType.methodType(Object.class, Object.class, Long.TYPE));
        getObject = getObject.asType(getObject.type().changeParameterType(0, Object.class));
        Map callers = (Map)getObject.invokeExact(theUnsafe, base, offset);
        callers.put(Java11Helper.class, true);
    }
}

