/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.java.queries;

import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gradle.api.NbGradleProject;
import org.netbeans.modules.gradle.java.api.GradleJavaProject;
import org.netbeans.modules.gradle.java.api.GradleJavaSourceSet;
import org.netbeans.spi.java.queries.SourceForBinaryQueryImplementation2;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public class GradleSourceForBinary
implements SourceForBinaryQueryImplementation2 {
    private static Map<GradleJavaSourceSet.SourceType, String> sourceMimeTypes = new EnumMap<GradleJavaSourceSet.SourceType, String>(GradleJavaSourceSet.SourceType.class);
    private final Project project;
    private final Map<URL, Res> cache = new HashMap<URL, Res>();
    private static final EnumSet<GradleJavaSourceSet.SourceType> ALL_LANGUAGES;

    public GradleSourceForBinary(Project project) {
        this.project = project;
    }

    private SourceForBinaryQueryImplementation2.Result languageSourceForOutput(GradleJavaSourceSet ss, File outputDir) {
        for (GradleJavaSourceSet.SourceType st : ALL_LANGUAGES) {
            File f = ss.getOutputClassDir(st);
            if (!outputDir.equals(f)) continue;
            boolean canPreferSource = st == GradleJavaSourceSet.SourceType.JAVA;
            return new Res(this.project, ss.getName(), EnumSet.of(st), canPreferSource);
        }
        return new Res(this.project, ss.getName(), ALL_LANGUAGES, false);
    }

    public SourceForBinaryQueryImplementation2.Result findSourceRoots2(URL binaryRoot) {
        Res ret = this.cache.get(binaryRoot);
        if (ret == null) {
            try {
                NbGradleProject watcher = NbGradleProject.get((Project)this.project);
                if (watcher.getQuality().atLeast(NbGradleProject.Quality.FALLBACK)) {
                    GradleJavaProject prj = GradleJavaProject.get(this.project);
                    block5 : switch (binaryRoot.getProtocol()) {
                        case "file": {
                            File root = FileUtil.normalizeFile((File)Utilities.toFile((URI)binaryRoot.toURI()));
                            for (GradleJavaSourceSet ss : prj.getSourceSets().values()) {
                                File outputDir;
                                File file = outputDir = ss.getCompilerArgs(GradleJavaSourceSet.SourceType.JAVA).contains("--module-source-path") ? root.getParentFile() : root;
                                if (ss.getOutputClassDirs().contains(outputDir)) {
                                    return this.languageSourceForOutput(ss, outputDir);
                                }
                                if (ret == null && root.equals(ss.getOutputResources())) {
                                    ret = new Res(this.project, ss.getName(), EnumSet.of(GradleJavaSourceSet.SourceType.RESOURCES));
                                }
                                if (ret == null) continue;
                                break block5;
                            }
                            break;
                        }
                        case "jar": {
                            File jar = FileUtil.normalizeFile((File)Utilities.toFile((URI)FileUtil.getArchiveFile((URL)binaryRoot).toURI()));
                            if (jar.equals(prj.getMainJar()) && prj.getSourceSets().containsKey("main")) {
                                ret = new Res(this.project, "main", EnumSet.allOf(GradleJavaSourceSet.SourceType.class));
                                break;
                            }
                            if (!jar.equals(prj.getArchive("tests")) || !prj.getSourceSets().containsKey("test")) break;
                            ret = new Res(this.project, "test", EnumSet.allOf(GradleJavaSourceSet.SourceType.class));
                            break;
                        }
                    }
                }
                if (ret != null) {
                    this.cache.put(binaryRoot, ret);
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return ret;
    }

    public SourceForBinaryQuery.Result findSourceRoots(URL binaryRoot) {
        return this.findSourceRoots2(binaryRoot);
    }

    static {
        sourceMimeTypes.put(GradleJavaSourceSet.SourceType.JAVA, "text/x-java");
        sourceMimeTypes.put(GradleJavaSourceSet.SourceType.GROOVY, "text/x-groovy");
        sourceMimeTypes.put(GradleJavaSourceSet.SourceType.SCALA, "text/x-scala");
        sourceMimeTypes.put(GradleJavaSourceSet.SourceType.KOTLIN, "text/x-kotlin");
        EnumSet<GradleJavaSourceSet.SourceType> s = EnumSet.allOf(GradleJavaSourceSet.SourceType.class);
        s.remove((Object)GradleJavaSourceSet.SourceType.RESOURCES);
        s.remove((Object)GradleJavaSourceSet.SourceType.GENERATED);
        ALL_LANGUAGES = s;
    }

    public static class Res
    implements SourceForBinaryQueryImplementation2.Result {
        private final Project project;
        private final String sourceSet;
        private final Set<GradleJavaSourceSet.SourceType> sourceTypes;
        private final PropertyChangeListener listener;
        private final ChangeSupport support = new ChangeSupport((Object)this);
        private final boolean preferSources;

        public Res(Project project, String sourceSet, Set<GradleJavaSourceSet.SourceType> sourceTypes) {
            this(project, sourceSet, sourceTypes, true);
        }

        public Res(Project project, String sourceSet, Set<GradleJavaSourceSet.SourceType> sourceTypes, boolean preferSources) {
            this.project = project;
            this.sourceSet = sourceSet;
            this.sourceTypes = sourceTypes;
            this.preferSources = preferSources;
            this.listener = evt -> {
                if ("ProjectInfo".equals(evt.getPropertyName())) {
                    this.support.fireChange();
                }
            };
            NbGradleProject.addPropertyChangeListener((Project)project, (PropertyChangeListener)WeakListeners.propertyChange((PropertyChangeListener)this.listener, (Object)NbGradleProject.get((Project)project)));
        }

        public boolean preferSources() {
            return this.preferSources;
        }

        public FileObject[] getRoots() {
            GradleJavaSourceSet ss;
            ArrayList<FileObject> roots = new ArrayList<FileObject>();
            GradleJavaSourceSet gradleJavaSourceSet = ss = GradleJavaProject.get(this.project) != null ? GradleJavaProject.get(this.project).getSourceSets().get(this.sourceSet) : null;
            if (ss != null) {
                for (GradleJavaSourceSet.SourceType type : this.sourceTypes) {
                    Set<File> dirs = ss.getSourceDirs(type);
                    for (File dir : dirs) {
                        FileObject fo = FileUtil.toFileObject((File)dir);
                        if (fo == null) continue;
                        roots.add(fo);
                    }
                }
            }
            return roots.toArray(new FileObject[0]);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addChangeListener(ChangeListener l) {
            ChangeSupport changeSupport = this.support;
            synchronized (changeSupport) {
                this.support.addChangeListener(l);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeChangeListener(ChangeListener l) {
            ChangeSupport changeSupport = this.support;
            synchronized (changeSupport) {
                this.support.removeChangeListener(l);
            }
        }
    }
}

