/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cloud.oracle.vault;

import com.oracle.bmc.keymanagement.KmsVaultClient;
import com.oracle.bmc.keymanagement.model.VaultSummary;
import com.oracle.bmc.keymanagement.requests.ListVaultsRequest;
import java.util.stream.Collectors;
import org.netbeans.modules.cloud.oracle.ChildrenProvider;
import org.netbeans.modules.cloud.oracle.NodeProvider;
import org.netbeans.modules.cloud.oracle.OCINode;
import org.netbeans.modules.cloud.oracle.compartment.CompartmentItem;
import org.netbeans.modules.cloud.oracle.items.OCID;
import org.netbeans.modules.cloud.oracle.vault.Bundle;
import org.netbeans.modules.cloud.oracle.vault.VaultItem;

public class VaultNode
extends OCINode {
    private static final String VAULT_ICON = "org/netbeans/modules/cloud/oracle/resources/vault.svg";

    public VaultNode(VaultItem vault) {
        super(vault);
        this.setName(vault.getName());
        this.setDisplayName(vault.getName());
        this.setIconBaseWithExtension(VAULT_ICON);
        this.setShortDescription(Bundle.OCIVault(vault.getName()));
    }

    public static NodeProvider<VaultItem> createNode() {
        return VaultNode::new;
    }

    public static ChildrenProvider.SessionAware<CompartmentItem, VaultItem> getVaults() {
        return (compartmentId, session) -> {
            KmsVaultClient client = session.newClient(KmsVaultClient.class);
            ListVaultsRequest listVaultsRequest = ListVaultsRequest.builder().compartmentId(compartmentId.getKey().getValue()).limit(Integer.valueOf(88)).build();
            String tenancyId = session.getTenancy().isPresent() ? session.getTenancy().get().getKey().getValue() : null;
            String regionCode = session.getRegion().getRegionCode();
            return client.listVaults(listVaultsRequest).getItems().stream().filter(v -> v.getLifecycleState().equals((Object)VaultSummary.LifecycleState.Active)).map(d -> new VaultItem(OCID.of(d.getId(), "Vault"), d.getCompartmentId(), d.getDisplayName(), d.getManagementEndpoint(), tenancyId, regionCode)).collect(Collectors.toList());
        };
    }
}

